// Code generated by 'go run genfiles.go'; DO NOT EDIT.

//go:build goexperiment.simd

// This file contains functions testing simd methods that compare two operands under a mask.
// Each function in this file is specialized for a
// particular simd type <BaseType><Width>x<Count>.

package simd_test

import (
	"simd/archsimd"
	"testing"
)

// testInt8x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt8x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int8x16, m archsimd.Mask8x16) archsimd.Mask8x16,
	want func(_, _ []int8) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, int8s, n, func(x, y []int8, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		b := archsimd.LoadInt8x16Slice(y)
		k := archsimd.LoadInt8x16Slice(toVect[int8](m)).ToMask()
		g := make([]int8, n)
		f(a, b, k).ToInt8x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt16x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt16x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int16x8, m archsimd.Mask16x8) archsimd.Mask16x8,
	want func(_, _ []int16) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, int16s, n, func(x, y []int16, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		b := archsimd.LoadInt16x8Slice(y)
		k := archsimd.LoadInt16x8Slice(toVect[int16](m)).ToMask()
		g := make([]int16, n)
		f(a, b, k).ToInt16x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt32x4CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt32x4CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int32x4, m archsimd.Mask32x4) archsimd.Mask32x4,
	want func(_, _ []int32) []int64) {
	n := 4
	t.Helper()
	forSlicePairMasked(t, int32s, n, func(x, y []int32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		b := archsimd.LoadInt32x4Slice(y)
		k := archsimd.LoadInt32x4Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x4().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt64x2CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt64x2CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int64x2, m archsimd.Mask64x2) archsimd.Mask64x2,
	want func(_, _ []int64) []int64) {
	n := 2
	t.Helper()
	forSlicePairMasked(t, int64s, n, func(x, y []int64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		b := archsimd.LoadInt64x2Slice(y)
		k := archsimd.LoadInt64x2Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x2().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint8x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint8x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint8x16, m archsimd.Mask8x16) archsimd.Mask8x16,
	want func(_, _ []uint8) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, uint8s, n, func(x, y []uint8, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		b := archsimd.LoadUint8x16Slice(y)
		k := archsimd.LoadInt8x16Slice(toVect[int8](m)).ToMask()
		g := make([]int8, n)
		f(a, b, k).ToInt8x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint16x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint16x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint16x8, m archsimd.Mask16x8) archsimd.Mask16x8,
	want func(_, _ []uint16) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, uint16s, n, func(x, y []uint16, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		b := archsimd.LoadUint16x8Slice(y)
		k := archsimd.LoadInt16x8Slice(toVect[int16](m)).ToMask()
		g := make([]int16, n)
		f(a, b, k).ToInt16x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint32x4CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint32x4CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint32x4, m archsimd.Mask32x4) archsimd.Mask32x4,
	want func(_, _ []uint32) []int64) {
	n := 4
	t.Helper()
	forSlicePairMasked(t, uint32s, n, func(x, y []uint32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		b := archsimd.LoadUint32x4Slice(y)
		k := archsimd.LoadInt32x4Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x4().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint64x2CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint64x2CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint64x2, m archsimd.Mask64x2) archsimd.Mask64x2,
	want func(_, _ []uint64) []int64) {
	n := 2
	t.Helper()
	forSlicePairMasked(t, uint64s, n, func(x, y []uint64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		b := archsimd.LoadUint64x2Slice(y)
		k := archsimd.LoadInt64x2Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x2().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testFloat32x4CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testFloat32x4CompareMasked(t *testing.T,
	f func(_, _ archsimd.Float32x4, m archsimd.Mask32x4) archsimd.Mask32x4,
	want func(_, _ []float32) []int64) {
	n := 4
	t.Helper()
	forSlicePairMasked(t, float32s, n, func(x, y []float32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		b := archsimd.LoadFloat32x4Slice(y)
		k := archsimd.LoadInt32x4Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x4().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testFloat64x2CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testFloat64x2CompareMasked(t *testing.T,
	f func(_, _ archsimd.Float64x2, m archsimd.Mask64x2) archsimd.Mask64x2,
	want func(_, _ []float64) []int64) {
	n := 2
	t.Helper()
	forSlicePairMasked(t, float64s, n, func(x, y []float64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		b := archsimd.LoadFloat64x2Slice(y)
		k := archsimd.LoadInt64x2Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x2().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt8x32CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt8x32CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int8x32, m archsimd.Mask8x32) archsimd.Mask8x32,
	want func(_, _ []int8) []int64) {
	n := 32
	t.Helper()
	forSlicePairMasked(t, int8s, n, func(x, y []int8, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		b := archsimd.LoadInt8x32Slice(y)
		k := archsimd.LoadInt8x32Slice(toVect[int8](m)).ToMask()
		g := make([]int8, n)
		f(a, b, k).ToInt8x32().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt16x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt16x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int16x16, m archsimd.Mask16x16) archsimd.Mask16x16,
	want func(_, _ []int16) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, int16s, n, func(x, y []int16, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		b := archsimd.LoadInt16x16Slice(y)
		k := archsimd.LoadInt16x16Slice(toVect[int16](m)).ToMask()
		g := make([]int16, n)
		f(a, b, k).ToInt16x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt32x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt32x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int32x8, m archsimd.Mask32x8) archsimd.Mask32x8,
	want func(_, _ []int32) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, int32s, n, func(x, y []int32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		b := archsimd.LoadInt32x8Slice(y)
		k := archsimd.LoadInt32x8Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt64x4CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt64x4CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int64x4, m archsimd.Mask64x4) archsimd.Mask64x4,
	want func(_, _ []int64) []int64) {
	n := 4
	t.Helper()
	forSlicePairMasked(t, int64s, n, func(x, y []int64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		b := archsimd.LoadInt64x4Slice(y)
		k := archsimd.LoadInt64x4Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x4().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint8x32CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint8x32CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint8x32, m archsimd.Mask8x32) archsimd.Mask8x32,
	want func(_, _ []uint8) []int64) {
	n := 32
	t.Helper()
	forSlicePairMasked(t, uint8s, n, func(x, y []uint8, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		b := archsimd.LoadUint8x32Slice(y)
		k := archsimd.LoadInt8x32Slice(toVect[int8](m)).ToMask()
		g := make([]int8, n)
		f(a, b, k).ToInt8x32().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint16x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint16x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint16x16, m archsimd.Mask16x16) archsimd.Mask16x16,
	want func(_, _ []uint16) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, uint16s, n, func(x, y []uint16, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		b := archsimd.LoadUint16x16Slice(y)
		k := archsimd.LoadInt16x16Slice(toVect[int16](m)).ToMask()
		g := make([]int16, n)
		f(a, b, k).ToInt16x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint32x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint32x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint32x8, m archsimd.Mask32x8) archsimd.Mask32x8,
	want func(_, _ []uint32) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, uint32s, n, func(x, y []uint32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		b := archsimd.LoadUint32x8Slice(y)
		k := archsimd.LoadInt32x8Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint64x4CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint64x4CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint64x4, m archsimd.Mask64x4) archsimd.Mask64x4,
	want func(_, _ []uint64) []int64) {
	n := 4
	t.Helper()
	forSlicePairMasked(t, uint64s, n, func(x, y []uint64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		b := archsimd.LoadUint64x4Slice(y)
		k := archsimd.LoadInt64x4Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x4().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testFloat32x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testFloat32x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Float32x8, m archsimd.Mask32x8) archsimd.Mask32x8,
	want func(_, _ []float32) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, float32s, n, func(x, y []float32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		b := archsimd.LoadFloat32x8Slice(y)
		k := archsimd.LoadInt32x8Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testFloat64x4CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testFloat64x4CompareMasked(t *testing.T,
	f func(_, _ archsimd.Float64x4, m archsimd.Mask64x4) archsimd.Mask64x4,
	want func(_, _ []float64) []int64) {
	n := 4
	t.Helper()
	forSlicePairMasked(t, float64s, n, func(x, y []float64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		b := archsimd.LoadFloat64x4Slice(y)
		k := archsimd.LoadInt64x4Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x4().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt8x64CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt8x64CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int8x64, m archsimd.Mask8x64) archsimd.Mask8x64,
	want func(_, _ []int8) []int64) {
	n := 64
	t.Helper()
	forSlicePairMasked(t, int8s, n, func(x, y []int8, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		b := archsimd.LoadInt8x64Slice(y)
		k := archsimd.LoadInt8x64Slice(toVect[int8](m)).ToMask()
		g := make([]int8, n)
		f(a, b, k).ToInt8x64().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt16x32CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt16x32CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int16x32, m archsimd.Mask16x32) archsimd.Mask16x32,
	want func(_, _ []int16) []int64) {
	n := 32
	t.Helper()
	forSlicePairMasked(t, int16s, n, func(x, y []int16, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		b := archsimd.LoadInt16x32Slice(y)
		k := archsimd.LoadInt16x32Slice(toVect[int16](m)).ToMask()
		g := make([]int16, n)
		f(a, b, k).ToInt16x32().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt32x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt32x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int32x16, m archsimd.Mask32x16) archsimd.Mask32x16,
	want func(_, _ []int32) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, int32s, n, func(x, y []int32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		b := archsimd.LoadInt32x16Slice(y)
		k := archsimd.LoadInt32x16Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testInt64x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testInt64x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Int64x8, m archsimd.Mask64x8) archsimd.Mask64x8,
	want func(_, _ []int64) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, int64s, n, func(x, y []int64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		b := archsimd.LoadInt64x8Slice(y)
		k := archsimd.LoadInt64x8Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint8x64CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint8x64CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint8x64, m archsimd.Mask8x64) archsimd.Mask8x64,
	want func(_, _ []uint8) []int64) {
	n := 64
	t.Helper()
	forSlicePairMasked(t, uint8s, n, func(x, y []uint8, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		b := archsimd.LoadUint8x64Slice(y)
		k := archsimd.LoadInt8x64Slice(toVect[int8](m)).ToMask()
		g := make([]int8, n)
		f(a, b, k).ToInt8x64().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint16x32CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint16x32CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint16x32, m archsimd.Mask16x32) archsimd.Mask16x32,
	want func(_, _ []uint16) []int64) {
	n := 32
	t.Helper()
	forSlicePairMasked(t, uint16s, n, func(x, y []uint16, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		b := archsimd.LoadUint16x32Slice(y)
		k := archsimd.LoadInt16x32Slice(toVect[int16](m)).ToMask()
		g := make([]int16, n)
		f(a, b, k).ToInt16x32().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint32x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint32x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint32x16, m archsimd.Mask32x16) archsimd.Mask32x16,
	want func(_, _ []uint32) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, uint32s, n, func(x, y []uint32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		b := archsimd.LoadUint32x16Slice(y)
		k := archsimd.LoadInt32x16Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testUint64x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testUint64x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Uint64x8, m archsimd.Mask64x8) archsimd.Mask64x8,
	want func(_, _ []uint64) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, uint64s, n, func(x, y []uint64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		b := archsimd.LoadUint64x8Slice(y)
		k := archsimd.LoadInt64x8Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testFloat32x16CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testFloat32x16CompareMasked(t *testing.T,
	f func(_, _ archsimd.Float32x16, m archsimd.Mask32x16) archsimd.Mask32x16,
	want func(_, _ []float32) []int64) {
	n := 16
	t.Helper()
	forSlicePairMasked(t, float32s, n, func(x, y []float32, m []bool) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		b := archsimd.LoadFloat32x16Slice(y)
		k := archsimd.LoadInt32x16Slice(toVect[int32](m)).ToMask()
		g := make([]int32, n)
		f(a, b, k).ToInt32x16().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}

// testFloat64x8CompareMasked tests the simd masked comparison method f against the expected behavior generated by want
// The mask is applied to the output of want; anything not in the mask, is zeroed.
func testFloat64x8CompareMasked(t *testing.T,
	f func(_, _ archsimd.Float64x8, m archsimd.Mask64x8) archsimd.Mask64x8,
	want func(_, _ []float64) []int64) {
	n := 8
	t.Helper()
	forSlicePairMasked(t, float64s, n, func(x, y []float64, m []bool) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		b := archsimd.LoadFloat64x8Slice(y)
		k := archsimd.LoadInt64x8Slice(toVect[int64](m)).ToMask()
		g := make([]int64, n)
		f(a, b, k).ToInt64x8().StoreSlice(g)
		w := want(x, y)
		for i := range m {
			if !m[i] {
				w[i] = 0
			}
		}
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y); t.Logf("m=%v", m) })
	})
}
