// Code generated by 'go run genfiles.go'; DO NOT EDIT.

//go:build goexperiment.simd

package archsimd

// BroadcastInt8x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt8x16(x int8) Int8x16 {
	var z Int8x16
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastInt16x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt16x8(x int16) Int16x8 {
	var z Int16x8
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastInt32x4 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt32x4(x int32) Int32x4 {
	var z Int32x4
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastInt64x2 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt64x2(x int64) Int64x2 {
	var z Int64x2
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastUint8x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint8x16(x uint8) Uint8x16 {
	var z Uint8x16
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastUint16x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint16x8(x uint16) Uint16x8 {
	var z Uint16x8
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastUint32x4 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint32x4(x uint32) Uint32x4 {
	var z Uint32x4
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastUint64x2 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint64x2(x uint64) Uint64x2 {
	var z Uint64x2
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastFloat32x4 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastFloat32x4(x float32) Float32x4 {
	var z Float32x4
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastFloat64x2 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastFloat64x2(x float64) Float64x2 {
	var z Float64x2
	return z.SetElem(0, x).Broadcast128()
}

// BroadcastInt8x32 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt8x32(x int8) Int8x32 {
	var z Int8x16
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastInt16x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt16x16(x int16) Int16x16 {
	var z Int16x8
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastInt32x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt32x8(x int32) Int32x8 {
	var z Int32x4
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastInt64x4 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastInt64x4(x int64) Int64x4 {
	var z Int64x2
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastUint8x32 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint8x32(x uint8) Uint8x32 {
	var z Uint8x16
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastUint16x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint16x16(x uint16) Uint16x16 {
	var z Uint16x8
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastUint32x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint32x8(x uint32) Uint32x8 {
	var z Uint32x4
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastUint64x4 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastUint64x4(x uint64) Uint64x4 {
	var z Uint64x2
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastFloat32x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastFloat32x8(x float32) Float32x8 {
	var z Float32x4
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastFloat64x4 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX2
func BroadcastFloat64x4(x float64) Float64x4 {
	var z Float64x2
	return z.SetElem(0, x).Broadcast256()
}

// BroadcastInt8x64 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512BW
func BroadcastInt8x64(x int8) Int8x64 {
	var z Int8x16
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastInt16x32 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512BW
func BroadcastInt16x32(x int16) Int16x32 {
	var z Int16x8
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastInt32x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512F
func BroadcastInt32x16(x int32) Int32x16 {
	var z Int32x4
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastInt64x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512F
func BroadcastInt64x8(x int64) Int64x8 {
	var z Int64x2
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastUint8x64 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512BW
func BroadcastUint8x64(x uint8) Uint8x64 {
	var z Uint8x16
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastUint16x32 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512BW
func BroadcastUint16x32(x uint16) Uint16x32 {
	var z Uint16x8
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastUint32x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512F
func BroadcastUint32x16(x uint32) Uint32x16 {
	var z Uint32x4
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastUint64x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512F
func BroadcastUint64x8(x uint64) Uint64x8 {
	var z Uint64x2
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastFloat32x16 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512F
func BroadcastFloat32x16(x float32) Float32x16 {
	var z Float32x4
	return z.SetElem(0, x).Broadcast512()
}

// BroadcastFloat64x8 returns a vector with the input
// x assigned to all elements of the output.
//
// Emulated, CPU Feature AVX512F
func BroadcastFloat64x8(x float64) Float64x8 {
	var z Float64x2
	return z.SetElem(0, x).Broadcast512()
}

// ToMask converts from Int8x16 to Mask8x16, mask element is set to true when the corresponding vector element is non-zero.
func (from Int8x16) ToMask() (to Mask8x16) {
	return from.NotEqual(Int8x16{})
}

// ToMask converts from Int16x8 to Mask16x8, mask element is set to true when the corresponding vector element is non-zero.
func (from Int16x8) ToMask() (to Mask16x8) {
	return from.NotEqual(Int16x8{})
}

// ToMask converts from Int32x4 to Mask32x4, mask element is set to true when the corresponding vector element is non-zero.
func (from Int32x4) ToMask() (to Mask32x4) {
	return from.NotEqual(Int32x4{})
}

// ToMask converts from Int64x2 to Mask64x2, mask element is set to true when the corresponding vector element is non-zero.
func (from Int64x2) ToMask() (to Mask64x2) {
	return from.NotEqual(Int64x2{})
}

// ToMask converts from Int8x32 to Mask8x32, mask element is set to true when the corresponding vector element is non-zero.
func (from Int8x32) ToMask() (to Mask8x32) {
	return from.NotEqual(Int8x32{})
}

// ToMask converts from Int16x16 to Mask16x16, mask element is set to true when the corresponding vector element is non-zero.
func (from Int16x16) ToMask() (to Mask16x16) {
	return from.NotEqual(Int16x16{})
}

// ToMask converts from Int32x8 to Mask32x8, mask element is set to true when the corresponding vector element is non-zero.
func (from Int32x8) ToMask() (to Mask32x8) {
	return from.NotEqual(Int32x8{})
}

// ToMask converts from Int64x4 to Mask64x4, mask element is set to true when the corresponding vector element is non-zero.
func (from Int64x4) ToMask() (to Mask64x4) {
	return from.NotEqual(Int64x4{})
}

// ToMask converts from Int8x64 to Mask8x64, mask element is set to true when the corresponding vector element is non-zero.
func (from Int8x64) ToMask() (to Mask8x64) {
	return from.NotEqual(Int8x64{})
}

// ToMask converts from Int16x32 to Mask16x32, mask element is set to true when the corresponding vector element is non-zero.
func (from Int16x32) ToMask() (to Mask16x32) {
	return from.NotEqual(Int16x32{})
}

// ToMask converts from Int32x16 to Mask32x16, mask element is set to true when the corresponding vector element is non-zero.
func (from Int32x16) ToMask() (to Mask32x16) {
	return from.NotEqual(Int32x16{})
}

// ToMask converts from Int64x8 to Mask64x8, mask element is set to true when the corresponding vector element is non-zero.
func (from Int64x8) ToMask() (to Mask64x8) {
	return from.NotEqual(Int64x8{})
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Int8x16) Not() Int8x16 {
	return x.Xor(x.Equal(x).ToInt8x16())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Int16x8) Not() Int16x8 {
	return x.Xor(x.Equal(x).ToInt16x8())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Int32x4) Not() Int32x4 {
	return x.Xor(x.Equal(x).ToInt32x4())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Int64x2) Not() Int64x2 {
	return x.Xor(x.Equal(x).ToInt64x2())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Int8x32) Not() Int8x32 {
	return x.Xor(x.Equal(x).ToInt8x32())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Int16x16) Not() Int16x16 {
	return x.Xor(x.Equal(x).ToInt16x16())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Int32x8) Not() Int32x8 {
	return x.Xor(x.Equal(x).ToInt32x8())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Int64x4) Not() Int64x4 {
	return x.Xor(x.Equal(x).ToInt64x4())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Int8x64) Not() Int8x64 {
	return x.Xor(x.Equal(x).ToInt8x64())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Int16x32) Not() Int16x32 {
	return x.Xor(x.Equal(x).ToInt16x32())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Int32x16) Not() Int32x16 {
	return x.Xor(x.Equal(x).ToInt32x16())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Int64x8) Not() Int64x8 {
	return x.Xor(x.Equal(x).ToInt64x8())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Uint8x16) Not() Uint8x16 {
	return x.Xor(x.Equal(x).ToInt8x16().AsUint8x16())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Uint16x8) Not() Uint16x8 {
	return x.Xor(x.Equal(x).ToInt16x8().AsUint16x8())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Uint32x4) Not() Uint32x4 {
	return x.Xor(x.Equal(x).ToInt32x4().AsUint32x4())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX
func (x Uint64x2) Not() Uint64x2 {
	return x.Xor(x.Equal(x).ToInt64x2().AsUint64x2())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Uint8x32) Not() Uint8x32 {
	return x.Xor(x.Equal(x).ToInt8x32().AsUint8x32())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Uint16x16) Not() Uint16x16 {
	return x.Xor(x.Equal(x).ToInt16x16().AsUint16x16())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Uint32x8) Not() Uint32x8 {
	return x.Xor(x.Equal(x).ToInt32x8().AsUint32x8())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX2
func (x Uint64x4) Not() Uint64x4 {
	return x.Xor(x.Equal(x).ToInt64x4().AsUint64x4())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Uint8x64) Not() Uint8x64 {
	return x.Xor(x.Equal(x).ToInt8x64().AsUint8x64())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Uint16x32) Not() Uint16x32 {
	return x.Xor(x.Equal(x).ToInt16x32().AsUint16x32())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Uint32x16) Not() Uint32x16 {
	return x.Xor(x.Equal(x).ToInt32x16().AsUint32x16())
}

// Not returns the bitwise complement of x
//
// Emulated, CPU Feature AVX512
func (x Uint64x8) Not() Uint64x8 {
	return x.Xor(x.Equal(x).ToInt64x8().AsUint64x8())
}

// String returns a string representation of SIMD vector x
func (x Int8x16) String() string {
	var s [16]int8
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int16x8) String() string {
	var s [8]int16
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int32x4) String() string {
	var s [4]int32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int64x2) String() string {
	var s [2]int64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint8x16) String() string {
	var s [16]uint8
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint16x8) String() string {
	var s [8]uint16
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint32x4) String() string {
	var s [4]uint32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint64x2) String() string {
	var s [2]uint64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Float32x4) String() string {
	var s [4]float32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Float64x2) String() string {
	var s [2]float64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int8x32) String() string {
	var s [32]int8
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int16x16) String() string {
	var s [16]int16
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int32x8) String() string {
	var s [8]int32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int64x4) String() string {
	var s [4]int64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint8x32) String() string {
	var s [32]uint8
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint16x16) String() string {
	var s [16]uint16
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint32x8) String() string {
	var s [8]uint32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint64x4) String() string {
	var s [4]uint64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Float32x8) String() string {
	var s [8]float32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Float64x4) String() string {
	var s [4]float64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int8x64) String() string {
	var s [64]int8
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int16x32) String() string {
	var s [32]int16
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int32x16) String() string {
	var s [16]int32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Int64x8) String() string {
	var s [8]int64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint8x64) String() string {
	var s [64]uint8
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint16x32) String() string {
	var s [32]uint16
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint32x16) String() string {
	var s [16]uint32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Uint64x8) String() string {
	var s [8]uint64
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Float32x16) String() string {
	var s [16]float32
	x.Store(&s)
	return sliceToString(s[:])
}

// String returns a string representation of SIMD vector x
func (x Float64x8) String() string {
	var s [8]float64
	x.Store(&s)
	return sliceToString(s[:])
}
