/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors;

import com.android.tools.smali.baksmali.Adaptors.MethodItem;
import com.android.tools.smali.baksmali.Adaptors.RegisterFormatter;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.analysis.AnalyzedInstruction;
import com.android.tools.smali.dexlib2.analysis.RegisterType;
import java.io.IOException;
import java.util.BitSet;
import javax.annotation.Nonnull;

public class PostInstructionRegisterInfoMethodItem
extends MethodItem {
    @Nonnull
    private final RegisterFormatter registerFormatter;
    @Nonnull
    private final AnalyzedInstruction analyzedInstruction;

    public PostInstructionRegisterInfoMethodItem(@Nonnull RegisterFormatter registerFormatter, @Nonnull AnalyzedInstruction analyzedInstruction, int codeAddress) {
        super(codeAddress);
        this.registerFormatter = registerFormatter;
        this.analyzedInstruction = analyzedInstruction;
    }

    @Override
    public double getSortOrder() {
        return 100.1;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        int registerInfo = this.registerFormatter.options.registerInfo;
        int registerCount = this.analyzedInstruction.getRegisterCount();
        BitSet registers = new BitSet(registerCount);
        if ((registerInfo & 1) != 0) {
            registers.set(0, registerCount);
        } else if ((registerInfo & 4) != 0) {
            registers.set(0, registerCount);
        } else if ((registerInfo & 0x10) != 0) {
            this.addDestRegs(registers, registerCount);
        }
        return this.writeRegisterInfo(writer, registers);
    }

    private void addDestRegs(BitSet printPostRegister, int registerCount) {
        for (int registerNum = 0; registerNum < registerCount; ++registerNum) {
            if (this.analyzedInstruction.getPreInstructionRegisterType(registerNum).equals(this.analyzedInstruction.getPostInstructionRegisterType(registerNum))) continue;
            printPostRegister.set(registerNum);
        }
    }

    private boolean writeRegisterInfo(BaksmaliWriter writer, BitSet registers) throws IOException {
        int registerNum = registers.nextSetBit(0);
        if (registerNum < 0) {
            return false;
        }
        writer.write(35);
        while (registerNum >= 0) {
            RegisterType registerType = this.analyzedInstruction.getPostInstructionRegisterType(registerNum);
            this.registerFormatter.writeTo(writer, registerNum);
            writer.write(61);
            registerType.writeTo(writer);
            writer.write(59);
            registerNum = registers.nextSetBit(registerNum + 1);
        }
        return true;
    }
}

