/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali;

import com.android.tools.smali.util.ConsoleUtil;
import com.android.tools.smali.util.jcommander.Command;
import com.android.tools.smali.util.jcommander.ExtendedCommands;
import com.android.tools.smali.util.jcommander.ExtendedParameter;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.android.tools.smali.util.jcommander.HelpFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;

@Parameters(commandDescription="Shows usage information")
@ExtendedParameters(commandName="help", commandAliases={"h"})
public class ListHelpCommand
extends Command {
    @Parameter(description="If specified, show the detailed usage information for the given commands")
    @ExtendedParameter(argumentNames={"commands"})
    private List<String> commands;

    public ListHelpCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.commands == null || this.commands.isEmpty()) {
            System.out.println(new HelpFormatter().width(ConsoleUtil.getConsoleWidth()).format(this.commandAncestors));
        } else {
            boolean printedHelp = false;
            JCommander parentJc = (JCommander)Iterables.getLast(this.commandAncestors);
            for (String cmd : this.commands) {
                JCommander command = ExtendedCommands.getSubcommand(parentJc, cmd);
                if (command == null) {
                    System.err.println("No such command: " + cmd);
                    continue;
                }
                printedHelp = true;
                System.out.println(new HelpFormatter().width(ConsoleUtil.getConsoleWidth()).format(((Command)command.getObjects().get(0)).getCommandHierarchy()));
            }
            if (!printedHelp) {
                System.out.println(new HelpFormatter().width(ConsoleUtil.getConsoleWidth()).format(this.commandAncestors));
            }
        }
    }

    @Parameters(hidden=true)
    @ExtendedParameters(commandName="hlep")
    public static class ListHlepCommand
    extends ListHelpCommand {
        public ListHlepCommand(@Nonnull List<JCommander> commandAncestors) {
            super(commandAncestors);
        }
    }
}

