/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedAnnotation;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedField;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.android.tools.smali.dexlib2.dexbacked.util.EncodedArrayItemIterator;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeListIterator;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.util.ChainedIterable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DexBackedClassDef
extends BaseTypeReference
implements ClassDef {
    static final int NO_HIDDEN_API_RESTRICTIONS = 7;
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int classDefOffset;
    @Nullable
    private final HiddenApiRestrictionsReader hiddenApiRestrictionsReader;
    private final int staticFieldsOffset;
    private int instanceFieldsOffset = 0;
    private int directMethodsOffset = 0;
    private int virtualMethodsOffset = 0;
    private final int staticFieldCount;
    private final int instanceFieldCount;
    private final int directMethodCount;
    private final int virtualMethodCount;
    @Nullable
    private AnnotationsDirectory annotationsDirectory;

    public DexBackedClassDef(@Nonnull DexBackedDexFile dexFile, int classDefOffset, int hiddenApiRestrictionsOffset) {
        this.dexFile = dexFile;
        this.classDefOffset = classDefOffset;
        int classDataOffset = dexFile.getBuffer().readSmallUint(classDefOffset + 24);
        if (classDataOffset == 0) {
            this.staticFieldsOffset = -1;
            this.staticFieldCount = 0;
            this.instanceFieldCount = 0;
            this.directMethodCount = 0;
            this.virtualMethodCount = 0;
        } else {
            DexReader<? extends DexBuffer> reader = dexFile.getDataBuffer().readerAt(classDataOffset);
            this.staticFieldCount = reader.readSmallUleb128();
            this.instanceFieldCount = reader.readSmallUleb128();
            this.directMethodCount = reader.readSmallUleb128();
            this.virtualMethodCount = reader.readSmallUleb128();
            this.staticFieldsOffset = reader.getOffset();
        }
        this.hiddenApiRestrictionsReader = hiddenApiRestrictionsOffset != 0 ? new HiddenApiRestrictionsReader(hiddenApiRestrictionsOffset) : null;
    }

    @Override
    @Nonnull
    public String getType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 0));
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.dexFile.getTypeSection().getOptional(this.dexFile.getBuffer().readOptionalUint(this.classDefOffset + 8));
    }

    @Override
    public int getAccessFlags() {
        return this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 4);
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.dexFile.getStringSection().getOptional(this.dexFile.getBuffer().readOptionalUint(this.classDefOffset + 16));
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        final int interfacesOffset = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 12);
        if (interfacesOffset > 0) {
            final int size = this.dexFile.getDataBuffer().readSmallUint(interfacesOffset);
            return new AbstractList<String>(){

                @Override
                @Nonnull
                public String get(int index) {
                    return (String)DexBackedClassDef.this.dexFile.getTypeSection().get(DexBackedClassDef.this.dexFile.getDataBuffer().readUshort(interfacesOffset + 4 + 2 * index));
                }

                @Override
                public int size() {
                    return size;
                }
            };
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return this.getAnnotationsDirectory().getClassAnnotations();
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getStaticFields() {
        return this.getStaticFields(true);
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getStaticFields(final boolean skipDuplicates) {
        if (this.staticFieldCount > 0) {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.staticFieldsOffset);
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int staticInitialValuesOffset = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 28);
            final int fieldsStartOffset = reader.getOffset();
            final VariableSizeListIterator hiddenApiRestrictionIterator = this.hiddenApiRestrictionsReader == null ? null : this.hiddenApiRestrictionsReader.getRestrictionsForStaticFields();
            return new Iterable<DexBackedField>(){

                @Override
                @Nonnull
                public Iterator<DexBackedField> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getFieldAnnotationIterator();
                    final EncodedArrayItemIterator staticInitialValueIterator = EncodedArrayItemIterator.newOrEmpty(DexBackedClassDef.this.dexFile, staticInitialValuesOffset);
                    return new VariableSizeLookaheadIterator<DexBackedField>(DexBackedClassDef.this.dexFile.getDataBuffer(), fieldsStartOffset){
                        private int count;
                        @Nullable
                        private FieldReference previousField;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedField readNextItem(@Nonnull DexReader<? extends DexBuffer> reader) {
                            DexBackedField item;
                            ImmutableFieldReference nextField;
                            FieldReference currentField;
                            do {
                                if (++this.count > DexBackedClassDef.this.staticFieldCount) {
                                    DexBackedClassDef.this.instanceFieldsOffset = reader.getOffset();
                                    return (DexBackedField)this.endOfData();
                                }
                                int hiddenApiRestrictions = 7;
                                if (hiddenApiRestrictionIterator != null) {
                                    hiddenApiRestrictions = (Integer)hiddenApiRestrictionIterator.next();
                                }
                                item = new DexBackedField(DexBackedClassDef.this.dexFile, reader, DexBackedClassDef.this, this.previousIndex, staticInitialValueIterator, annotationIterator, hiddenApiRestrictions);
                                currentField = this.previousField;
                                nextField = ImmutableFieldReference.of(item);
                                this.previousField = nextField;
                                this.previousIndex = item.fieldIndex;
                            } while (skipDuplicates && currentField != null && currentField.equals(nextField));
                            return item;
                        }
                    };
                }
            };
        }
        this.instanceFieldsOffset = this.staticFieldsOffset;
        return Collections.emptySet();
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getInstanceFields() {
        return this.getInstanceFields(true);
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getInstanceFields(final boolean skipDuplicates) {
        if (this.instanceFieldCount > 0) {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.getInstanceFieldsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int fieldsStartOffset = reader.getOffset();
            final Iterator hiddenApiRestrictionIterator = this.hiddenApiRestrictionsReader == null ? null : this.hiddenApiRestrictionsReader.getRestrictionsForInstanceFields();
            return new Iterable<DexBackedField>(){

                @Override
                @Nonnull
                public Iterator<DexBackedField> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getFieldAnnotationIterator();
                    return new VariableSizeLookaheadIterator<DexBackedField>(DexBackedClassDef.this.dexFile.getDataBuffer(), fieldsStartOffset){
                        private int count;
                        @Nullable
                        private FieldReference previousField;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedField readNextItem(@Nonnull DexReader<? extends DexBuffer> reader) {
                            DexBackedField item;
                            ImmutableFieldReference nextField;
                            FieldReference currentField;
                            do {
                                if (++this.count > DexBackedClassDef.this.instanceFieldCount) {
                                    DexBackedClassDef.this.directMethodsOffset = reader.getOffset();
                                    return (DexBackedField)this.endOfData();
                                }
                                int hiddenApiRestrictions = 7;
                                if (hiddenApiRestrictionIterator != null) {
                                    hiddenApiRestrictions = (Integer)hiddenApiRestrictionIterator.next();
                                }
                                item = new DexBackedField(DexBackedClassDef.this.dexFile, reader, DexBackedClassDef.this, this.previousIndex, annotationIterator, hiddenApiRestrictions);
                                currentField = this.previousField;
                                nextField = ImmutableFieldReference.of(item);
                                this.previousField = nextField;
                                this.previousIndex = item.fieldIndex;
                            } while (skipDuplicates && currentField != null && currentField.equals(nextField));
                            return item;
                        }
                    };
                }
            };
        }
        if (this.instanceFieldsOffset > 0) {
            this.directMethodsOffset = this.instanceFieldsOffset;
        }
        return Collections.emptySet();
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getFields() {
        return new ChainedIterable<DexBackedField>(this.getStaticFields(), this.getInstanceFields());
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getDirectMethods() {
        return this.getDirectMethods(true);
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getDirectMethods(final boolean skipDuplicates) {
        if (this.directMethodCount > 0) {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.getDirectMethodsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int methodsStartOffset = reader.getOffset();
            final Iterator hiddenApiRestrictionIterator = this.hiddenApiRestrictionsReader == null ? null : this.hiddenApiRestrictionsReader.getRestrictionsForDirectMethods();
            return new Iterable<DexBackedMethod>(){

                @Override
                @Nonnull
                public Iterator<DexBackedMethod> iterator() {
                    final AnnotationsDirectory.AnnotationIterator methodAnnotationIterator = annotationsDirectory.getMethodAnnotationIterator();
                    final AnnotationsDirectory.AnnotationIterator parameterAnnotationIterator = annotationsDirectory.getParameterAnnotationIterator();
                    return new VariableSizeLookaheadIterator<DexBackedMethod>(DexBackedClassDef.this.dexFile.getDataBuffer(), methodsStartOffset){
                        private int count;
                        @Nullable
                        private MethodReference previousMethod;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedMethod readNextItem(@Nonnull DexReader<? extends DexBuffer> reader) {
                            DexBackedMethod item;
                            ImmutableMethodReference nextMethod;
                            MethodReference currentMethod;
                            do {
                                if (++this.count > DexBackedClassDef.this.directMethodCount) {
                                    DexBackedClassDef.this.virtualMethodsOffset = reader.getOffset();
                                    return (DexBackedMethod)this.endOfData();
                                }
                                int hiddenApiRestrictions = 7;
                                if (hiddenApiRestrictionIterator != null) {
                                    hiddenApiRestrictions = (Integer)hiddenApiRestrictionIterator.next();
                                }
                                item = new DexBackedMethod(DexBackedClassDef.this.dexFile, reader, DexBackedClassDef.this, this.previousIndex, methodAnnotationIterator, parameterAnnotationIterator, hiddenApiRestrictions);
                                currentMethod = this.previousMethod;
                                nextMethod = ImmutableMethodReference.of(item);
                                this.previousMethod = nextMethod;
                                this.previousIndex = item.methodIndex;
                            } while (skipDuplicates && currentMethod != null && currentMethod.equals(nextMethod));
                            return item;
                        }
                    };
                }
            };
        }
        if (this.directMethodsOffset > 0) {
            this.virtualMethodsOffset = this.directMethodsOffset;
        }
        return Collections.emptySet();
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getVirtualMethods(final boolean skipDuplicates) {
        if (this.virtualMethodCount > 0) {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.getVirtualMethodsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int methodsStartOffset = reader.getOffset();
            final Iterator hiddenApiRestrictionIterator = this.hiddenApiRestrictionsReader == null ? null : this.hiddenApiRestrictionsReader.getRestrictionsForVirtualMethods();
            return new Iterable<DexBackedMethod>(){
                final AnnotationsDirectory.AnnotationIterator methodAnnotationIterator;
                final AnnotationsDirectory.AnnotationIterator parameterAnnotationIterator;
                {
                    this.methodAnnotationIterator = annotationsDirectory.getMethodAnnotationIterator();
                    this.parameterAnnotationIterator = annotationsDirectory.getParameterAnnotationIterator();
                }

                @Override
                @Nonnull
                public Iterator<DexBackedMethod> iterator() {
                    return new VariableSizeLookaheadIterator<DexBackedMethod>(DexBackedClassDef.this.dexFile.getDataBuffer(), methodsStartOffset){
                        private int count;
                        @Nullable
                        private MethodReference previousMethod;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedMethod readNextItem(@Nonnull DexReader<? extends DexBuffer> reader) {
                            DexBackedMethod item;
                            ImmutableMethodReference nextMethod;
                            MethodReference currentMethod;
                            do {
                                if (++this.count > DexBackedClassDef.this.virtualMethodCount) {
                                    return (DexBackedMethod)this.endOfData();
                                }
                                int hiddenApiRestrictions = 7;
                                if (hiddenApiRestrictionIterator != null) {
                                    hiddenApiRestrictions = (Integer)hiddenApiRestrictionIterator.next();
                                }
                                item = new DexBackedMethod(DexBackedClassDef.this.dexFile, reader, DexBackedClassDef.this, this.previousIndex, methodAnnotationIterator, parameterAnnotationIterator, hiddenApiRestrictions);
                                currentMethod = this.previousMethod;
                                nextMethod = ImmutableMethodReference.of(item);
                                this.previousMethod = nextMethod;
                                this.previousIndex = item.methodIndex;
                            } while (skipDuplicates && currentMethod != null && currentMethod.equals(nextMethod));
                            return item;
                        }
                    };
                }
            };
        }
        return Collections.emptySet();
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getVirtualMethods() {
        return this.getVirtualMethods(true);
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getMethods() {
        return new ChainedIterable<DexBackedMethod>(this.getDirectMethods(), this.getVirtualMethods());
    }

    private AnnotationsDirectory getAnnotationsDirectory() {
        if (this.annotationsDirectory == null) {
            int annotationsDirectoryOffset = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 20);
            this.annotationsDirectory = AnnotationsDirectory.newOrEmpty(this.dexFile, annotationsDirectoryOffset);
        }
        return this.annotationsDirectory;
    }

    private int getInstanceFieldsOffset() {
        if (this.instanceFieldsOffset > 0) {
            return this.instanceFieldsOffset;
        }
        DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.staticFieldsOffset);
        DexBackedField.skipFields(reader, this.staticFieldCount);
        this.instanceFieldsOffset = reader.getOffset();
        return this.instanceFieldsOffset;
    }

    private int getDirectMethodsOffset() {
        if (this.directMethodsOffset > 0) {
            return this.directMethodsOffset;
        }
        DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.getInstanceFieldsOffset());
        DexBackedField.skipFields(reader, this.instanceFieldCount);
        this.directMethodsOffset = reader.getOffset();
        return this.directMethodsOffset;
    }

    private int getVirtualMethodsOffset() {
        if (this.virtualMethodsOffset > 0) {
            return this.virtualMethodsOffset;
        }
        DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.getDirectMethodsOffset());
        DexBackedMethod.skipMethods(reader, this.directMethodCount);
        this.virtualMethodsOffset = reader.getOffset();
        return this.virtualMethodsOffset;
    }

    public int getSize() {
        int classDataOffset;
        int staticInitialValuesOffset;
        AnnotationsDirectory directory;
        int size = 32;
        size += 4;
        int interfacesLength = this.getInterfaces().size();
        if (interfacesLength > 0) {
            size += 4;
            size += interfacesLength * 2;
        }
        if (!AnnotationsDirectory.EMPTY.equals(directory = this.getAnnotationsDirectory())) {
            size += 16;
            Set<? extends DexBackedAnnotation> classAnnotations = directory.getClassAnnotations();
            if (!classAnnotations.isEmpty()) {
                size += 4;
                size += classAnnotations.size() * 4;
            }
        }
        if ((staticInitialValuesOffset = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 28)) != 0) {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(staticInitialValuesOffset);
            size += reader.peekSmallUleb128Size();
        }
        if ((classDataOffset = this.dexFile.getBuffer().readSmallUint(this.classDefOffset + 24)) > 0) {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(classDataOffset);
            reader.readSmallUleb128();
            reader.readSmallUleb128();
            reader.readSmallUleb128();
            reader.readSmallUleb128();
            size += reader.getOffset() - classDataOffset;
        }
        for (DexBackedField dexBackedField : this.getFields()) {
            size += dexBackedField.getSize();
        }
        for (DexBackedMethod dexBackedMethod : this.getMethods()) {
            size += dexBackedMethod.getSize();
        }
        return size;
    }

    private class HiddenApiRestrictionsReader {
        private final int startOffset;
        private int instanceFieldsStartOffset;
        private int directMethodsStartOffset;
        private int virtualMethodsStartOffset;

        public HiddenApiRestrictionsReader(int startOffset) {
            this.startOffset = startOffset;
        }

        private VariableSizeListIterator<Integer> getRestrictionsForStaticFields() {
            return new VariableSizeListIterator<Integer>(DexBackedClassDef.this.dexFile.getDataBuffer(), this.startOffset, DexBackedClassDef.this.staticFieldCount){

                @Override
                protected Integer readNextItem(@Nonnull DexReader<? extends DexBuffer> reader, int index) {
                    return reader.readSmallUleb128();
                }

                @Override
                public Integer next() {
                    if (this.nextIndex() == DexBackedClassDef.this.staticFieldCount) {
                        HiddenApiRestrictionsReader.this.instanceFieldsStartOffset = this.getReaderOffset();
                    }
                    return (Integer)super.next();
                }
            };
        }

        private int getInstanceFieldsStartOffset() {
            if (this.instanceFieldsStartOffset == 0) {
                DexReader<? extends DexBuffer> reader = DexBackedClassDef.this.dexFile.getDataBuffer().readerAt(this.startOffset);
                for (int i = 0; i < DexBackedClassDef.this.staticFieldCount; ++i) {
                    reader.readSmallUleb128();
                }
                this.instanceFieldsStartOffset = reader.getOffset();
            }
            return this.instanceFieldsStartOffset;
        }

        private Iterator<Integer> getRestrictionsForInstanceFields() {
            return new VariableSizeListIterator<Integer>(DexBackedClassDef.this.dexFile.getDataBuffer(), this.getInstanceFieldsStartOffset(), DexBackedClassDef.this.instanceFieldCount){

                @Override
                protected Integer readNextItem(@Nonnull DexReader<? extends DexBuffer> reader, int index) {
                    return reader.readSmallUleb128();
                }

                @Override
                public Integer next() {
                    if (this.nextIndex() == DexBackedClassDef.this.instanceFieldCount) {
                        HiddenApiRestrictionsReader.this.directMethodsStartOffset = this.getReaderOffset();
                    }
                    return (Integer)super.next();
                }
            };
        }

        private int getDirectMethodsStartOffset() {
            if (this.directMethodsStartOffset == 0) {
                DexReader<? extends DexBuffer> reader = DexBackedClassDef.this.dexFile.getDataBuffer().readerAt(this.getInstanceFieldsStartOffset());
                for (int i = 0; i < DexBackedClassDef.this.instanceFieldCount; ++i) {
                    reader.readSmallUleb128();
                }
                this.directMethodsStartOffset = reader.getOffset();
            }
            return this.directMethodsStartOffset;
        }

        private Iterator<Integer> getRestrictionsForDirectMethods() {
            return new VariableSizeListIterator<Integer>(DexBackedClassDef.this.dexFile.getDataBuffer(), this.getDirectMethodsStartOffset(), DexBackedClassDef.this.directMethodCount){

                @Override
                protected Integer readNextItem(@Nonnull DexReader<? extends DexBuffer> reader, int index) {
                    return reader.readSmallUleb128();
                }

                @Override
                public Integer next() {
                    if (this.nextIndex() == DexBackedClassDef.this.directMethodCount) {
                        HiddenApiRestrictionsReader.this.virtualMethodsStartOffset = this.getReaderOffset();
                    }
                    return (Integer)super.next();
                }
            };
        }

        private int getVirtualMethodsStartOffset() {
            if (this.virtualMethodsStartOffset == 0) {
                DexReader<? extends DexBuffer> reader = DexBackedClassDef.this.dexFile.getDataBuffer().readerAt(this.getDirectMethodsStartOffset());
                for (int i = 0; i < DexBackedClassDef.this.directMethodCount; ++i) {
                    reader.readSmallUleb128();
                }
                this.virtualMethodsStartOffset = reader.getOffset();
            }
            return this.virtualMethodsStartOffset;
        }

        private Iterator<Integer> getRestrictionsForVirtualMethods() {
            return new VariableSizeListIterator<Integer>(DexBackedClassDef.this.dexFile.getDataBuffer(), this.getVirtualMethodsStartOffset(), DexBackedClassDef.this.virtualMethodCount){

                @Override
                protected Integer readNextItem(@Nonnull DexReader<? extends DexBuffer> reader, int index) {
                    return reader.readSmallUleb128();
                }
            };
        }
    }
}

