/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;

public class Lambda<R extends Sort>
extends ArrayExpr<Sort, R> {
    public int getNumBound() {
        return Native.getQuantifierNumBound(this.getContext().nCtx(), this.getNativeObject());
    }

    public Symbol[] getBoundVariableNames() {
        int n = this.getNumBound();
        Symbol[] symbolArray = new Symbol[n];
        for (int i = 0; i < n; ++i) {
            symbolArray[i] = Symbol.create(this.getContext(), Native.getQuantifierBoundName(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return symbolArray;
    }

    public Sort[] getBoundVariableSorts() {
        int n = this.getNumBound();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.create(this.getContext(), Native.getQuantifierBoundSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return sortArray;
    }

    public Expr<R> getBody() {
        return Expr.create(this.getContext(), Native.getQuantifierBody(this.getContext().nCtx(), this.getNativeObject()));
    }

    @Override
    public Lambda<R> translate(Context context) {
        return (Lambda)super.translate(context);
    }

    public static <R extends Sort> Lambda<R> of(Context context, Sort[] sortArray, Symbol[] symbolArray, Expr<R> expr) {
        context.checkContextMatch(sortArray);
        context.checkContextMatch(symbolArray);
        context.checkContextMatch(expr);
        if (sortArray.length != symbolArray.length) {
            throw new Z3Exception("Number of sorts does not match number of names");
        }
        long l = Native.mkLambda(context.nCtx(), AST.arrayLength(sortArray), AST.arrayToNative(sortArray), Symbol.arrayToNative(symbolArray), expr.getNativeObject());
        return new Lambda<R>(context, l);
    }

    public static <R extends Sort> Lambda<R> of(Context context, Expr<?>[] exprArray, Expr<R> expr) {
        context.checkContextMatch(expr);
        long l = Native.mkLambdaConst(context.nCtx(), AST.arrayLength(exprArray), AST.arrayToNative(exprArray), expr.getNativeObject());
        return new Lambda<R>(context, l);
    }

    Lambda(Context context, long l) {
        super(context, l);
    }
}

