/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Vector;
import vrpn.TrackerRemote;

public class TrackerRemoteListener
implements TrackerRemote.PositionChangeListener,
TrackerRemote.VelocityChangeListener,
TrackerRemote.AccelerationChangeListener {
    public static final int ALL_UPDATES = 0;
    public static final int LAST_UPDATE = 1;
    protected Vector trackerUpdates = new Vector();
    protected Vector velocityUpdates = new Vector();
    protected Vector accelerationUpdates = new Vector();
    protected int trackerBufferMode = 1;
    protected int velocityBufferMode = 1;
    protected int accelerationBufferMode = 1;

    public TrackerRemoteListener(TrackerRemote trackerRemote) {
        trackerRemote.addPositionChangeListener((TrackerRemote.PositionChangeListener)this);
        trackerRemote.addVelocityChangeListener((TrackerRemote.VelocityChangeListener)this);
        trackerRemote.addAccelerationChangeListener((TrackerRemote.AccelerationChangeListener)this);
    }

    public synchronized void setModeLastTrackerUpdate() {
        this.trackerBufferMode = 1;
        if (!this.trackerUpdates.isEmpty()) {
            Object e = this.trackerUpdates.lastElement();
            this.trackerUpdates.removeAllElements();
            this.trackerUpdates.addElement(e);
        }
    }

    public synchronized void setModeLastVelocityUpdate() {
        this.velocityBufferMode = 1;
        if (!this.velocityUpdates.isEmpty()) {
            Object e = this.velocityUpdates.lastElement();
            this.velocityUpdates.removeAllElements();
            this.velocityUpdates.addElement(e);
        }
    }

    public synchronized void setModeLastAccelerationUpdate() {
        this.accelerationBufferMode = 1;
        if (!this.accelerationUpdates.isEmpty()) {
            Object e = this.accelerationUpdates.lastElement();
            this.accelerationUpdates.removeAllElements();
            this.accelerationUpdates.addElement(e);
        }
    }

    public synchronized void setModeAllTrackerUpdates() {
        if (this.trackerBufferMode == 1) {
            this.trackerUpdates.removeAllElements();
        }
        this.trackerBufferMode = 0;
    }

    public synchronized void setModeAllVelocityUpdates() {
        if (this.velocityBufferMode == 1) {
            this.velocityUpdates.removeAllElements();
        }
        this.velocityBufferMode = 0;
    }

    public synchronized void setModeAllAccelerationUpdates() {
        if (this.accelerationBufferMode == 1) {
            this.accelerationUpdates.removeAllElements();
        }
        this.accelerationBufferMode = 0;
    }

    public synchronized int getModeTrackerUpdate() {
        return this.trackerBufferMode;
    }

    public synchronized int getModeVelocityUpdate() {
        return this.velocityBufferMode;
    }

    public synchronized int getModeAccelerationUpdate() {
        return this.accelerationBufferMode;
    }

    public synchronized Vector getTrackerUpdate() {
        Vector vector = new Vector();
        if (this.trackerUpdates.isEmpty()) {
            return vector;
        }
        if (this.trackerBufferMode == 1) {
            vector.addElement(this.trackerUpdates.lastElement());
        } else if (this.trackerBufferMode == 0) {
            for (int i = 0; i < this.trackerUpdates.size(); ++i) {
                vector.addElement(this.trackerUpdates.elementAt(i));
            }
            this.trackerUpdates.removeAllElements();
        }
        return vector;
    }

    public synchronized Vector getVelocityUpdate() {
        Vector vector = new Vector();
        if (this.velocityUpdates.isEmpty()) {
            return vector;
        }
        if (this.velocityBufferMode == 1) {
            vector.addElement(this.velocityUpdates.lastElement());
        } else if (this.velocityBufferMode == 0) {
            for (int i = 0; i < this.velocityUpdates.size(); ++i) {
                vector.addElement(this.velocityUpdates.elementAt(i));
            }
            this.velocityUpdates.removeAllElements();
        }
        return vector;
    }

    public synchronized Vector getAcclerationUpdate() {
        Vector vector = new Vector();
        if (this.accelerationUpdates.isEmpty()) {
            return vector;
        }
        if (this.accelerationBufferMode == 1) {
            vector.addElement(this.accelerationUpdates.lastElement());
        } else if (this.accelerationBufferMode == 0) {
            for (int i = 0; i < this.accelerationUpdates.size(); ++i) {
                vector.addElement(this.accelerationUpdates.elementAt(i));
            }
            this.accelerationUpdates.removeAllElements();
        }
        return vector;
    }

    public synchronized TrackerRemote.TrackerUpdate getLastTrackerUpdate() {
        if (this.trackerUpdates.isEmpty()) {
            return null;
        }
        return (TrackerRemote.TrackerUpdate)this.trackerUpdates.lastElement();
    }

    public synchronized TrackerRemote.VelocityUpdate getLastVelocityUpdate() {
        if (this.velocityUpdates.isEmpty()) {
            return null;
        }
        return (TrackerRemote.VelocityUpdate)this.velocityUpdates.lastElement();
    }

    public synchronized TrackerRemote.AccelerationUpdate getLastAccelerationUpdate() {
        if (this.accelerationUpdates.isEmpty()) {
            return null;
        }
        return (TrackerRemote.AccelerationUpdate)this.accelerationUpdates.lastElement();
    }

    public synchronized void trackerPositionUpdate(TrackerRemote.TrackerUpdate trackerUpdate, TrackerRemote trackerRemote) {
        if (this.trackerBufferMode == 1) {
            this.trackerUpdates.removeAllElements();
        }
        this.trackerUpdates.addElement(trackerUpdate);
    }

    public synchronized void trackerVelocityUpdate(TrackerRemote.VelocityUpdate velocityUpdate, TrackerRemote trackerRemote) {
        if (this.velocityBufferMode == 1) {
            this.velocityUpdates.removeAllElements();
        }
        this.velocityUpdates.addElement(velocityUpdate);
    }

    public synchronized void trackerAccelerationUpdate(TrackerRemote.AccelerationUpdate accelerationUpdate, TrackerRemote trackerRemote) {
        if (this.accelerationBufferMode == 1) {
            this.accelerationUpdates.removeAllElements();
        }
        this.accelerationUpdates.addElement(accelerationUpdate);
    }
}

