## Security

Thank you for taking the time to contribute to the security of [tofuutils/tenv](https://github.com/tofuutils/tenv). This document outlines the steps to report vulnerabilities and our approach to addressing security issues. Please report it to us as described below.

## Reporting Security Issues

**Please do not report security vulnerabilities through public GitHub issues.**

If you discover a vulnerability, please follow these steps:

1. Contact us directly via the secure channels listed below.
2. Please include the requested information listed below (as much as you can provide) to help us better understand the nature and scope of the possible issue:
  * Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
  * Full paths of source file(s) related to the manifestation of the issue
  * The location of the affected source code (tag/branch/commit or direct URL)
  * Any special configuration required to reproduce the issue
  * Step-by-step instructions to reproduce the issue
  * Proof-of-concept or exploit code (if possible)
  * Impact of the issue, including how an attacker might exploit the issue
  * Any suggested fixes.

This information will help us triage your report more quickly.

## Preferred Languages

We prefer all communications to be in English.

## Contact
To contact us, use [OpenTofu Community](https://opentofucommunity.slack.com/) slack, `#tofuutils` channel. You can ping Alexander Sharov or Denis Vaumoron there to discuss any issues.

## Disclosure Policy

We follow a responsible disclosure process:
1. Acknowledge receipt of the vulnerability report.
2. Assess and prioritize the issue based on severity.
3. Work on a fix and test the solution.
4. Release a patch and publicly announce the resolution.
