private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_361_0 {
	meta:
		name = "Succeeded"
		size = 6
	strings:
		$1 = { 85 C0 0F 9D C0 C3 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "Failed"
		size = 6
	strings:
		$1 = { 85 C0 0F 9C C0 C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "HResultCode"
		size = 6
		altNames = "ResultCode"
	strings:
		$1 = { 25 FF FF 00 00 C3 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "HResultFacility"
		size = 9
		altNames = "ResultFacility"
	strings:
		$1 = { C1 E8 10 25 FF 1F 00 00 C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "ResultSeverity"
		size = 4
	strings:
		$1 = { C1 E8 1F C3 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "MakeResult"
		size = 13
	strings:
		$1 = { C1 E0 1F C1 E2 10 0B C2 0B C8 8B C1 C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "LHashValOfName"
		size = 10
		refs = "0005 LHashValOfNameSys"
	strings:
		$1 = { 52 50 6A 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "WHashValOfLHashVal"
		size = 5
	strings:
		$1 = { 66 25 FF FF C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "IsHashValCompatible"
		size = 17
	strings:
		$1 = { 25 00 00 FF 00 81 E2 00 00 FF 00 3B C2 0F 94 C0 C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__58D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12365_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__189 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11930_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__71 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12069_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__460 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12091_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__B8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12108_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__69 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12187_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__59 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12211_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__B7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12219_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__60 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12225_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__5A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12247_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__9E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11916_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__172 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12378_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__74 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12412_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__78 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12444_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__B9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12473_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__5C 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12496_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__97 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12501_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__53 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12772_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__25D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12784_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__DE 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13097_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1F1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10452_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__C5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10073_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__191 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10075_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__CD 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10194_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__11F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10221_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__F7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10225_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__56 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10241_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__118 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10343_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__6B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10369_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__C8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10417_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__128 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13171_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__2EA 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10726_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__D4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10729_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__76 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11006_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1DE 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11034_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__99 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11036_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__29 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11392_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1D8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11403_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__15A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11760_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__3E5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15622_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__6E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14921_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__D7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14925_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15354_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__210 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15389_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__D7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15488_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__BC 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15494_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__54 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15508_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__33 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15579_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__139 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15589_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__60 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14877_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__38 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15667_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__D1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15694_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__30 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15696_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__3F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17797_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1F62 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17950_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__25C 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18013_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__180 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18169_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__20B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18220_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__8A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13679_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__102 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13173_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__184 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13313_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__11E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13539_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__170 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13555_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__7C 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13563_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__13 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13608_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__C1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13626_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__213 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13628_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__18 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13630_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9996_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__105 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13942_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__2C0 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13944_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__13 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13960_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__3B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13981_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__29 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14768_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__C6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14838_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__128 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14862_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__A6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14864_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__F9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5090_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__33C 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3811_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__24 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3830_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__7B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3838_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__37 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4361_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__24A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4427_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__166 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4451_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__115 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4670_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__21F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4715_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__109 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4717_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__A9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3809_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__43 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5105_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__4F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5371_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__2B8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5387_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__52 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5498_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1B1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5506_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__4D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6276_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__E4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6311_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__DB 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6429_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__BF 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1114_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__8A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__8E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__67 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_735_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__7C 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_740_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__60 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_758_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__80 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1071_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__ABF 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1073_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__95 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1089_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__B9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1100_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__64 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6431_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__AC 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1124_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__5D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1235_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__8B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1460_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__BE 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2006_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__BF 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3159_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__581 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3189_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__12B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3320_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__33 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3322_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1CF 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9249_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__68 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8425_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__38 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8665_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__22B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8728_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__C6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8805_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__13E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8822_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__24 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8824_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__6E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9052_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1B6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9080_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__37 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9082_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__B 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8423_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__55 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9262_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9346_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__121 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9362_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9434_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__3D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9535_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__257 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9740_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__53A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9815_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__143 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9968_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__C6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7173_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1C1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6555_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__AE 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6771_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__69 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6773_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__6D 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6775_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__4F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6788_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__39 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6896_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1A0 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_6909_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__3F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7060_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__1FF 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7073_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__A0 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__6A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7185_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__38 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7190_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__4F 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7541_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__9E 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7554_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__64 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7577_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__A8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8247_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__217 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8395_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__19 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8419_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__8A 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "ActiveX"
		size = 8
		refs = "0002 _NV__58D"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "AxMaxMin"
		size = 8
		refs = "0002 _NV__60"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "AxisIncr"
		size = 8
		refs = "0002 _NV__7C"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1072_0 {
	meta:
		name = "Bde"
		size = 8
		refs = "0002 _NV__ABF"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1074_0 {
	meta:
		name = "BdeConst"
		size = 8
		refs = "0002 _NV__95"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1101_0 {
	meta:
		name = "BrushDlg"
		size = 8
		refs = "0002 _NV__64"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3812_0 {
	meta:
		name = "CPL"
		size = 8
		refs = "0002 _NV__24"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1236_0 {
	meta:
		name = "Calendar"
		size = 8
		refs = "0002 _NV__8B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2007_0 {
	meta:
		name = "ColorGrd"
		size = 8
		refs = "0002 _NV__BF"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2923_0 {
	meta:
		name = "ComCtrls"
		size = 8
		refs = "0002 _NV__6AF"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3321_0 {
	meta:
		name = "ComStrs"
		size = 8
		refs = "0002 _NV__33"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3190_0 {
	meta:
		name = "CommDlg"
		size = 8
		refs = "0002 _NV__12B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3160_0 {
	meta:
		name = "Commctrl"
		size = 8
		refs = "0002 _NV__581"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3323_0 {
	meta:
		name = "Consts"
		size = 8
		refs = "0002 _NV__1CF"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3810_0 {
	meta:
		name = "CopyPrsr"
		size = 8
		refs = "0002 _NV__43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4428_0 {
	meta:
		name = "DBCGrids"
		size = 8
		refs = "0002 _NV__166"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4452_0 {
	meta:
		name = "DBChart"
		size = 8
		refs = "0002 _NV__115"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4671_0 {
	meta:
		name = "DBClient"
		size = 8
		refs = "0002 _NV__21F"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4716_0 {
	meta:
		name = "DBCommon"
		size = 8
		refs = "0002 _NV__109"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5372_0 {
	meta:
		name = "DBGrids"
		size = 8
		refs = "0002 _NV__2B8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5388_0 {
	meta:
		name = "DBLogDlg"
		size = 8
		refs = "0002 _NV__52"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5499_0 {
	meta:
		name = "DBLookup"
		size = 8
		refs = "0002 _NV__1B1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5507_0 {
	meta:
		name = "DBPWDlg"
		size = 8
		refs = "0002 _NV__4D"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6170_0 {
	meta:
		name = "DBWeb"
		size = 8
		refs = "0002 _NV__C6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6556_0 {
	meta:
		name = "DRTable"
		size = 8
		refs = "0002 _NV__AE"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6774_0 {
	meta:
		name = "DSIntf"
		size = 8
		refs = "0002 _NV__6D"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4362_0 {
	meta:
		name = "Db"
		size = 8
		refs = "0002 _NV__24A"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4718_0 {
	meta:
		name = "DbConsts"
		size = 8
		refs = "0002 _NV__A9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5120_0 {
	meta:
		name = "Dbexcept"
		size = 8
		refs = "0002 _NV__68"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6312_0 {
	meta:
		name = "Ddeml"
		size = 8
		refs = "0002 _NV__DB"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6430_0 {
	meta:
		name = "DirOutln"
		size = 8
		refs = "0002 _NV__BF"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6432_0 {
	meta:
		name = "Dlgs"
		size = 8
		refs = "0002 _NV__AC"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6752_0 {
	meta:
		name = "DsgnIntf"
		size = 8
		refs = "0002 _NV__1A4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6772_0 {
	meta:
		name = "DsgnWnds"
		size = 8
		refs = "0002 _NV__69"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6776_0 {
	meta:
		name = "DsnDBCst"
		size = 8
		refs = "0002 _NV__4F"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6897_0 {
	meta:
		name = "EditIntf"
		size = 8
		refs = "0002 _NV__1A0"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6910_0 {
	meta:
		name = "Exptintf"
		size = 8
		refs = "0002 _NV__3F"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7061_0 {
	meta:
		name = "ExtCtrls"
		size = 8
		refs = "0002 _NV__1FF"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7074_0 {
	meta:
		name = "ExtDlgs"
		size = 8
		refs = "0002 _NV__A0"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7174_0 {
	meta:
		name = "FileCtrl"
		size = 8
		refs = "0002 _NV__1C1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7186_0 {
	meta:
		name = "FileIntf"
		size = 8
		refs = "0002 _NV__38"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7578_0 {
	meta:
		name = "Gauges"
		size = 8
		refs = "0002 _NV__A8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8248_0 {
	meta:
		name = "Grids"
		size = 8
		refs = "0002 _NV__217"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8394_0 {
	meta:
		name = "HTTPApp"
		size = 8
		refs = "0002 _NV__16B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8396_0 {
	meta:
		name = "IBConst"
		size = 8
		refs = "0002 _NV__19"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8420_0 {
	meta:
		name = "IBCtrls"
		size = 8
		refs = "0002 _NV__8A"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8426_0 {
	meta:
		name = "IBPROC32"
		size = 8
		refs = "0002 _NV__38"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9081_0 {
	meta:
		name = "IStreams"
		size = 8
		refs = "0002 _NV__37"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8424_0 {
	meta:
		name = "Ibevnts"
		size = 8
		refs = "0002 _NV__55"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8729_0 {
	meta:
		name = "Imagehlp"
		size = 8
		refs = "0002 _NV__C6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8806_0 {
	meta:
		name = "Imm"
		size = 8
		refs = "0002 _NV__13E"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8821_0 {
	meta:
		name = "IniFiles"
		size = 8
		refs = "0002 _NV__42"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9263_0 {
	meta:
		name = "LZExpand"
		size = 8
		refs = "0002 _NV__21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9250_0 {
	meta:
		name = "LibHelp"
		size = 8
		refs = "0002 _NV__68"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9741_0 {
	meta:
		name = "MMSystem"
		size = 8
		refs = "0002 _NV__53A"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9816_0 {
	meta:
		name = "MPlayer"
		size = 8
		refs = "0002 _NV__143"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9279_0 {
	meta:
		name = "Mapi"
		size = 8
		refs = "0002 _NV__75"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9347_0 {
	meta:
		name = "Mask"
		size = 8
		refs = "0002 _NV__121"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9363_0 {
	meta:
		name = "Masks"
		size = 8
		refs = "0002 _NV__32"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9435_0 {
	meta:
		name = "Math"
		size = 8
		refs = "0002 _NV__3D"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9536_0 {
	meta:
		name = "Messages"
		size = 8
		refs = "0002 _NV__257"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10730_0 {
	meta:
		name = "NB30"
		size = 8
		refs = "0002 _NV__76"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11007_0 {
	meta:
		name = "NSApi"
		size = 8
		refs = "0002 _NV__1DE"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11035_0 {
	meta:
		name = "OCXReg"
		size = 8
		refs = "0002 _NV__99"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11037_0 {
	meta:
		name = "OleConst"
		size = 8
		refs = "0002 _NV__29"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11393_0 {
	meta:
		name = "OleCtrls"
		size = 8
		refs = "0002 _NV__1D8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11404_0 {
	meta:
		name = "OleDlg"
		size = 8
		refs = "0002 _NV__15A"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11917_0 {
	meta:
		name = "Outline"
		size = 8
		refs = "0002 _NV__172"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11931_0 {
	meta:
		name = "PenDlg"
		size = 8
		refs = "0002 _NV__71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12070_0 {
	meta:
		name = "PenWin"
		size = 8
		refs = "0002 _NV__460"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12092_0 {
	meta:
		name = "PicEdit"
		size = 8
		refs = "0002 _NV__B8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12162_0 {
	meta:
		name = "Printers"
		size = 8
		refs = "0002 _NV__A8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12188_0 {
	meta:
		name = "Provider"
		size = 8
		refs = "0002 _NV__59"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12497_0 {
	meta:
		name = "QRPrev"
		size = 8
		refs = "0002 _NV__97"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12502_0 {
	meta:
		name = "QRPrgres"
		size = 8
		refs = "0002 _NV__53"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12248_0 {
	meta:
		name = "Qrcomped"
		size = 8
		refs = "0002 _NV__9E"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12366_0 {
	meta:
		name = "Qrctrls"
		size = 8
		refs = "0002 _NV__189"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13172_0 {
	meta:
		name = "RegStr"
		size = 8
		refs = "0002 _NV__2EA"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13170_0 {
	meta:
		name = "Registry"
		size = 8
		refs = "0002 _NV__78"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13174_0 {
	meta:
		name = "RichEdit"
		size = 8
		refs = "0002 _NV__184"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13631_0 {
	meta:
		name = "SMIntf"
		size = 8
		refs = "0002 _NV__E"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13314_0 {
	meta:
		name = "ScktComp"
		size = 8
		refs = "0002 _NV__11E"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13609_0 {
	meta:
		name = "ShellAPI"
		size = 8
		refs = "0002 _NV__C1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13627_0 {
	meta:
		name = "ShlObj"
		size = 8
		refs = "0002 _NV__213"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13680_0 {
	meta:
		name = "Spin"
		size = 8
		refs = "0002 _NV__102"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13943_0 {
	meta:
		name = "StdCtrls"
		size = 8
		refs = "0002 _NV__2C0"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13945_0 {
	meta:
		name = "StdVCL"
		size = 8
		refs = "0002 _NV__13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13961_0 {
	meta:
		name = "SyncObjs"
		size = 8
		refs = "0002 _NV__3B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13982_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _NV__29"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15509_0 {
	meta:
		name = "TLHelp32"
		size = 8
		refs = "0002 _NV__33"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14769_0 {
	meta:
		name = "Tabnotbk"
		size = 8
		refs = "0002 _NV__C6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14839_0 {
	meta:
		name = "Tabs"
		size = 8
		refs = "0002 _NV__128"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15495_0 {
	meta:
		name = "TeExport"
		size = 8
		refs = "0002 _NV__54"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14863_0 {
	meta:
		name = "TeeAbout"
		size = 8
		refs = "0002 _NV__A6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14878_0 {
	meta:
		name = "TeeFunci"
		size = 8
		refs = "0002 _NV__38"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14922_0 {
	meta:
		name = "TeeGally"
		size = 8
		refs = "0002 _NV__D7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14926_0 {
	meta:
		name = "TeeLisB"
		size = 8
		refs = "0002 _NV__D"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15390_0 {
	meta:
		name = "TeePrevi"
		size = 8
		refs = "0002 _NV__D7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15580_0 {
	meta:
		name = "ToolIntf"
		size = 8
		refs = "0002 _NV__139"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15590_0 {
	meta:
		name = "ToolWin"
		size = 8
		refs = "0002 _NV__60"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15623_0 {
	meta:
		name = "TypInfo"
		size = 8
		refs = "0002 _NV__6E"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15668_0 {
	meta:
		name = "UrlMon"
		size = 8
		refs = "0002 _NV__D1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15695_0 {
	meta:
		name = "VirtIntf"
		size = 8
		refs = "0002 _NV__30"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15697_0 {
	meta:
		name = "WebConst"
		size = 8
		refs = "0002 _NV__3F"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17951_0 {
	meta:
		name = "WinInet"
		size = 8
		refs = "0002 _NV__25C"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18014_0 {
	meta:
		name = "WinSock"
		size = 8
		refs = "0002 _NV__180"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18170_0 {
	meta:
		name = "WinSpool"
		size = 8
		refs = "0002 _NV__20B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18221_0 {
	meta:
		name = "WinSvc"
		size = 8
		refs = "0002 _NV__8A"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17798_0 {
	meta:
		name = "Windows"
		size = 8
		refs = "0002 _NV__1F62"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8823_0 {
	meta:
		name = "isapi"
		size = 8
		refs = "0002 _NV__24"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8825_0 {
	meta:
		name = "isapi2"
		size = 8
		refs = "0002 _NV__6E"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9053_0 {
	meta:
		name = "isp3"
		size = 8
		refs = "0002 _NV__1B6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9083_0 {
	meta:
		name = "jconsts"
		size = 8
		refs = "0002 _NV__B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10076_0 {
	meta:
		name = "mxConsts"
		size = 8
		refs = "0002 _NV__CD"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10195_0 {
	meta:
		name = "mxDB"
		size = 8
		refs = "0002 _NV__11F"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9997_0 {
	meta:
		name = "mxbutton"
		size = 8
		refs = "0002 _NV__105"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10074_0 {
	meta:
		name = "mxcommon"
		size = 8
		refs = "0002 _NV__191"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10222_0 {
	meta:
		name = "mxdcube"
		size = 8
		refs = "0002 _NV__F7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10226_0 {
	meta:
		name = "mxdsql"
		size = 8
		refs = "0002 _NV__56"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10242_0 {
	meta:
		name = "mxgraph"
		size = 8
		refs = "0002 _NV__118"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10331_0 {
	meta:
		name = "mxgrid"
		size = 8
		refs = "0002 _NV__1A7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10344_0 {
	meta:
		name = "mxpbar"
		size = 8
		refs = "0002 _NV__6B"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10370_0 {
	meta:
		name = "mxpivsrc"
		size = 8
		refs = "0002 _NV__C8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10418_0 {
	meta:
		name = "mxqedcom"
		size = 8
		refs = "0002 _NV__128"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10453_0 {
	meta:
		name = "mxqparse"
		size = 8
		refs = "0002 _NV__C5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10717_0 {
	meta:
		name = "mxstore"
		size = 8
		refs = "0002 _NV__2DB"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10727_0 {
	meta:
		name = "mxtables"
		size = 8
		refs = "0002 _NV__D4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12212_0 {
	meta:
		name = "qr2const"
		size = 8
		refs = "0002 _NV__B7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12220_0 {
	meta:
		name = "qrabout"
		size = 8
		refs = "0002 _NV__60"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12226_0 {
	meta:
		name = "qralias"
		size = 8
		refs = "0002 _NV__5A"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12379_0 {
	meta:
		name = "qrdatasu"
		size = 8
		refs = "0002 _NV__74"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12413_0 {
	meta:
		name = "qrexpbld"
		size = 8
		refs = "0002 _NV__78"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13629_0 {
	meta:
		name = "smconsts"
		size = 8
		refs = "0002 _NV__18"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14865_0 {
	meta:
		name = "teeconst"
		size = 8
		refs = "0002 _NV__F9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "TAreaSeriesEditor.FormShow"
		size = 108
		refs = "0005 Screen 000e TScreen.SetCursor 002c TCustomRadioGroup.SetItemIndex 003a TCustomCheckBox.SetChecked 004d TCustomComboBox.SetItemIndex 0065 TAreaSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 08 02 00 00 8B F0 33 D2 8A 96 10 01 00 00 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8A 56 48 8B 83 FC 01 00 00 E8 ?? ?? ?? ?? 33 D2 8A 96 E5 00 00 00 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8A 96 D0 00 00 00 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "TAreaSeriesEditor.RefreshShape"
		size = 82
		refs = "0017 TControl.SetVisible 002b TControl.SetEnabled 003e TAreaSeriesEditor.GetAreaColor 004b TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B 83 08 02 00 00 8A 50 48 80 F2 01 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 8B 83 04 02 00 00 8A 50 44 8B 83 00 02 00 00 E8 ?? ?? ?? ?? 8B B3 04 02 00 00 80 7E 44 00 74 14 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 86 BC 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "TAreaSeriesEditor.RGMultiAreaClick"
		size = 24
		refs = "0013 TAreaSeries.SetMultiArea"
	strings:
		$1 = { 8B 90 DC 01 00 00 8A 92 24 01 00 00 8B 80 08 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "TAreaSeriesEditor.CBColorEachClick"
		size = 36
		refs = "000a TCustomCheckBox.GetChecked 0017 TChartSeries.SetColorEachPoint 001e TAreaSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 8B D8 8B 83 FC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 08 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "TAreaSeriesEditor.GetAreaColor"
		size = 27
	strings:
		$1 = { 8B 80 08 02 00 00 8B 90 E0 00 00 00 81 FA 00 00 00 80 75 04 8B 40 44 C3 8B C2 C3 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "TAreaSeriesEditor.BAreaColorClick"
		size = 41
		refs = "0006 TAreaSeriesEditor.GetAreaColor 000f EditColor 0023 TAreaSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 08 02 00 00 8B 08 FF 51 4C 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "TAreaSeriesEditor.CBStairsClick"
		size = 29
		refs = "000a TCustomCheckBox.GetChecked 0017 TCustomSeries.SetStairs"
	strings:
		$1 = { 53 8B D8 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 08 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "TAreaSeriesEditor.CBAreaBrushChange"
		size = 29
		refs = "000a TCustomComboBox.GetItemIndex 0017 TCustomSeries.SetAreaBrush"
	strings:
		$1 = { 53 8B D8 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 08 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "TAreaSeriesEditor.BAreaLinesPenClick"
		size = 18
		refs = "000d EditChartPen"
	strings:
		$1 = { 8B 90 08 02 00 00 8B 92 D8 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "TAreaSeriesEditor.SHAreaColorMouseUp"
		size = 14
		refs = "0006 TAreaSeriesEditor.BAreaColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "TArrowSeriesEditor.SHArrowColorMouseUp"
		size = 14
		refs = "0006 TArrowSeriesEditor.BArrowColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_756_0 {
	meta:
		name = "TBarSeriesEditor.SHBarColorMouseUp"
		size = 14
		refs = "0006 TBarSeriesEditor.BBarColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_1097_0 {
	meta:
		name = "TBrushDialog.SHColorMouseUp"
		size = 14
		refs = "0006 TBrushDialog.BColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_8519_0 {
	meta:
		name = "TChartEditForm.PaintBox1MouseUp"
		size = 14
		refs = "0006 TChartEditForm.BGradientStartClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_8520_0 {
	meta:
		name = "TChartEditForm.PaintBox2MouseUp"
		size = 14
		refs = "0006 TChartEditForm.BGradientEndClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_13543_0 {
	meta:
		name = "TChartShapeEditor.Shape1MouseUp"
		size = 14
		refs = "0006 TChartShapeEditor.BShapeColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_11927_0 {
	meta:
		name = "TPenDialog.SHColorMouseUp"
		size = 14
		refs = "0006 TPenDialog.BColorClick"
	strings:
		$1 = { 55 8B EC 8B D0 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_382_0 {
	meta:
		name = "TAreaSeriesEditor.BAreaLinePenClick"
		size = 18
		refs = "000d EditChartPen"
	strings:
		$1 = { 8B 90 08 02 00 00 8B 92 DC 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "AreaEdit"
		size = 20
		refs = "0002 _NV__6A 000a _DV_TAreaSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "Arrowedi"
		size = 20
		refs = "0002 _NV__67 000a _DV_TArrowSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "BarEdit"
		size = 20
		refs = "0002 _NV__80 000a _DV_TBarSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1125_0 {
	meta:
		name = "BubblEdi"
		size = 20
		refs = "0002 _NV__5D 000a _DV_TBubbleSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3831_0 {
	meta:
		name = "CustEdit"
		size = 20
		refs = "0002 _NV__7B 000a _DV_TCustomSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7191_0 {
	meta:
		name = "FLineEdi"
		size = 20
		refs = "0002 _NV__4F 000a _DV_TFastLineSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7555_0 {
	meta:
		name = "GanttEdi"
		size = 20
		refs = "0002 _NV__64 000a _DV_TGanttSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8666_0 {
	meta:
		name = "IEditCha"
		size = 20
		refs = "0002 _NV__22B 000a _DV_TChartEditForm 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12109_0 {
	meta:
		name = "PieEdit"
		size = 20
		refs = "0002 _NV__69 000a _DV_TPieSeriesEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12785_0 {
	meta:
		name = "QrTee"
		size = 20
		refs = "0002 _NV__DE 000a _DV_TQRDBChart 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13556_0 {
	meta:
		name = "ShapeEdi"
		size = 20
		refs = "0002 _NV__7C 000a _DV_TChartShapeEditor 000f RegisterClass"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "TArrowSeries.Create"
		size = 204
		refs = "000e @ClassCreate 001c TPointSeries.Create 002d TChartValueList.SetDateTime 0032 TArrowSeries.Create 003b _Dn_TChartValueList 0040 TChartValueList.Create 0077 TSeriesPointer.SetInflateMargins 0084 TChartPen.SetVisible 008e TSeriesMarks.SetBackTransparent"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 CC 00 00 00 00 B2 01 8B 43 2C E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 10 01 00 00 B2 01 8B C6 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 14 01 00 00 33 D2 8B 83 D4 00 00 00 E8 ?? ?? ?? ?? 8B 43 3C 8B 40 1C 33 D2 E8 ?? ?? ?? ?? B2 01 8B 43 3C E8 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 45 6E 64 58 00 00 00 00 FF FF FF FF 04 00 00 00 45 6E 64 59 00 00 00 00 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "TArrowSeries.SetEndXValues"
		size = 14
		refs = "0009 TChartSeries.SetChartValueList"
		altNames = "TBubbleSeries.SetRadiusValues TGanttSeries.SetEndValues"
	strings:
		$1 = { 8D 88 10 01 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "TArrowSeries.SetEndYValues"
		size = 14
		refs = "0009 TChartSeries.SetChartValueList"
		altNames = "TGanttSeries.SetNextTask"
	strings:
		$1 = { 8D 88 14 01 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1103_0 {
	meta:
		name = "TBubbleSeries.SetSquared"
		size = 14
		refs = "0009 TChartSeries.SetBooleanProperty"
	strings:
		$1 = { 8D 88 14 01 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "TArrowSeries.AddArrow"
		size = 95
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B F0 FF 75 24 FF 75 20 FF 75 1C FF 75 18 8B 4D FC 8B C6 8B 18 FF 93 90 00 00 00 8B D8 8B 86 10 01 00 00 8B 55 10 89 50 18 8B 55 14 89 50 1C 8B 86 14 01 00 00 8B 55 08 89 50 18 8B 55 0C 89 50 1C 8B D3 8B C6 8B 08 FF 91 B8 00 00 00 8B C3 5E 5B 59 5D C2 20 00 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "TArrowSeries.FillSampleValues"
		size = 245
		refs = "0035 TChartSeries.CalcRandomBounds 003e @ROUND 0060 @RandInt 00db TArrowSeries.AddArrow 00e9 TChartSeries.RefreshSeries"
	strings:
		$1 = { 53 56 57 55 83 C4 BC 89 14 24 8B E8 8B C5 8B 10 FF 92 88 00 00 00 8D 44 24 24 50 8D 44 24 20 50 8D 44 24 34 50 8D 44 24 40 50 8D 4C 24 24 8B 54 24 10 8B C5 E8 ?? ?? ?? ?? DD 44 24 34 E8 ?? ?? ?? ?? 8B F8 8B 34 24 85 F6 0F 8E 97 00 00 00 DB 04 24 DC 4C 24 24 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 89 44 24 3C DB 44 24 3C DC 44 24 14 DD 5C 24 04 9B 8B C7 E8 ?? ?? ?? ?? 89 44 24 3C DB 44 24 3C DC 44 24 2C DD 5C 24 0C 9B FF 74 24 08 FF 74 24 08 FF 74 24 18 FF 74 24 18 8B C3 E8 ?? ?? ?? ?? 89 44 24 4C DB 44 24 4C DC 44 24 14 83 C4 F8 DD 1C 24 9B 8B C7 E8 ?? ?? ?? ?? 89 44 24 58 DB 44 24 58 DC 44 24 24 83 C4 F8 DD 1C 24 9B B9 00 00 00 80 33 D2 8B C5 E8 ?? ?? ?? ?? 4E 0F 85 69 FF FF FF 8B C5 E8 ?? ?? ?? ?? 83 C4 44 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "TArrowSeries.GetArrowWidth"
		size = 10
	strings:
		$1 = { 8B 80 D4 00 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "TArrowSeries.GetArrowHeight"
		size = 10
	strings:
		$1 = { 8B 80 D4 00 00 00 8B 40 08 C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "TArrowSeries.SetArrowWidth"
		size = 12
		refs = "0007 TSeriesPointer.SetHorizSize"
	strings:
		$1 = { 8B 80 D4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "TArrowSeries.SetArrowHeight"
		size = 12
		refs = "0007 TSeriesPointer.SetVertSize"
	strings:
		$1 = { 8B 80 D4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "_NF__AE"
		size = 78
		refs = "0021 @ROUND"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 DD 40 F8 8B 45 08 DC 48 F0 8B 45 08 DD 40 E8 8B 45 08 DC 48 E0 DE C1 E8 ?? ?? ?? ?? 89 03 8B 45 08 DD 40 F8 D9 E0 8B 45 08 DC 48 E0 8B 45 08 DD 40 E8 8B 45 08 DC 48 F0 DE C1 E8 ?? ?? ?? ?? 89 43 04 5B 5D C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "TArrowSeries.DrawValue"
		size = 800
		refs = "0043 TChartValueList.GetValue 0051 TChartSeries.CalcXPosValue 006f TChartSeries.CalcYPosValue 00aa TArrowSeries.DrawValue 00ba TArrowSeries.GetArrowWidth 00c4 TArrowSeries.GetArrowHeight 00cd @ROUND 00d3 MinLong 0152 _NF__AE 020c TSeriesPointer.PrepareCanvas 02a5 TCustomTeePanel.DoPolygon 02c9 TPen.SetColor 02d6 TCanvas.MoveTo 02e2 TCanvas.LineTo"
	strings:
		$1 = { 55 8B EC 81 C4 38 FF FF FF 53 56 57 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 48 89 45 DC 8B D6 8B C3 8B 08 FF 91 B0 00 00 00 89 45 AC 8B D6 8B C3 8B 08 FF 91 B4 00 00 00 89 45 B0 8B D6 8B 83 10 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 89 45 A4 8B D6 8B 83 14 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 8B F8 89 7D A8 8B 75 A4 2B 75 AC 8B 45 B0 2B C7 89 45 D4 8B C6 F7 EE 8B 55 D4 0F AF 55 D4 03 C2 89 85 70 FF FF FF DB 85 70 FF FF FF D9 FA DD 5D B4 9B DD 45 B4 D8 1D ?? ?? ?? ?? DF E0 9E 0F 86 3B 01 00 00 8B C3 E8 ?? ?? ?? ?? 89 45 D8 8B C3 E8 ?? ?? ?? ?? 50 DD 45 B4 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? DB 45 D4 DC 75 B4 DD 5D E0 9B 89 B5 70 FF FF FF DB 85 70 FF FF FF DC 75 B4 DD 5D F0 9B DB 45 A4 DC 4D F0 89 BD 70 FF FF FF DB 85 70 FF FF FF DC 4D E0 DE E9 DD 5D C4 9B DB 45 A4 DC 4D E0 89 BD 70 FF FF FF DB 85 70 FF FF FF DC 4D F0 DE C1 DD 5D BC 9B 89 85 70 FF FF FF DB 85 70 FF FF FF DC 6D C4 DD 5D F8 9B DB 45 D8 D8 0D ?? ?? ?? ?? DC 6D BC DD 5D E8 9B 55 8D 45 9C E8 ?? ?? ?? ?? 59 DB 45 D8 D8 0D ?? ?? ?? ?? DC 45 BC DD 5D E8 9B 55 8D 45 94 E8 ?? ?? ?? ?? 59 8B 43 40 80 B8 C8 01 00 00 00 74 75 DB 45 D8 D8 0D ?? ?? ?? ?? DD 5D CC 9B DD 45 BC DC 65 CC DD 5D E8 9B 55 8D 45 8C E8 ?? ?? ?? ?? 59 DD 45 BC DC 45 CC DD 5D E8 9B 55 8D 45 84 E8 ?? ?? ?? ?? 59 DB 45 AC DC 4D F0 DB 45 B0 DC 4D E0 DE E9 DD 5D F8 9B DD 45 BC DC 65 CC DD 5D E8 9B 55 8D 85 7C FF FF FF E8 ?? ?? ?? ?? 59 DD 45 BC DC 45 CC DD 5D E8 9B 55 8D 85 74 FF FF FF E8 ?? ?? ?? ?? 59 8B 73 40 80 BE C8 01 00 00 00 0F 84 A9 00 00 00 8B 55 DC 8B 83 D4 00 00 00 E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 89 85 38 FF FF FF 8B 85 78 FF FF FF 89 85 3C FF FF FF 8B 85 7C FF FF FF 89 85 40 FF FF FF 8B 45 80 89 85 44 FF FF FF 8B 45 8C 89 85 48 FF FF FF 8B 45 90 89 85 4C FF FF FF 8B 45 9C 89 85 50 FF FF FF 8B 45 A0 89 85 54 FF FF FF 8B 45 A4 89 85 58 FF FF FF 8B 45 A8 89 85 5C FF FF FF 8B 45 94 89 85 60 FF FF FF 8B 45 98 89 85 64 FF FF FF 8B 45 84 89 85 68 FF FF FF 8B 45 88 89 85 6C FF FF FF 8D 95 38 FF FF FF B9 06 00 00 00 8B C6 E8 ?? ?? ?? ?? EB 61 8B B6 50 01 00 00 8B 83 D4 00 00 00 8B 50 10 8B 46 10 8B 08 FF 51 08 8B 55 DC 8B 46 10 E8 ?? ?? ?? ?? 8B 4D B0 8B 55 AC 8B C6 E8 ?? ?? ?? ?? 8B CF 8B 55 A4 8B C6 E8 ?? ?? ?? ?? 8B 4D 98 8B 55 94 8B C6 E8 ?? ?? ?? ?? 8B CF 8B 55 A4 8B C6 E8 ?? ?? ?? ?? 8B 4D A0 8B 55 9C 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 00 3F 00 00 80 3E }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "TArrowSeries.MaxXValue"
		size = 48
		refs = "0009 TChartSeries.MaxXValue 0021 MaxDouble"
		altNames = "TGanttSeries.MaxXValue"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 10 01 00 00 FF 70 3C FF 70 38 E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "TArrowSeries.MinXValue"
		size = 48
		refs = "0009 TChartSeries.MinXValue 0021 MinDouble"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 10 01 00 00 FF 70 44 FF 70 40 E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "TArrowSeries.MaxYValue"
		size = 48
		refs = "0009 TChartSeries.MaxYValue 0021 MaxDouble"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 14 01 00 00 FF 70 3C FF 70 38 E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "TArrowSeries.MinYValue"
		size = 48
		refs = "0009 TChartSeries.MinYValue 0021 MinDouble"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 14 01 00 00 FF 70 44 FF 70 40 E8 ?? ?? ?? ?? DD 1C 24 9B DD 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "TArrowSeries.GetEditorClass"
		size = 48
		refs = "0006 TArrowSeries.GetEditorClass 000b @LStrLAsg"
	strings:
		$1 = { 53 8B DA 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 00 00 00 FF FF FF FF 12 00 00 00 54 41 72 72 6F 77 53 65 72 69 65 73 45 64 69 74 6F 72 00 00 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "TArrowSeries.GetStartXValues"
		size = 4
		altNames = "TDecisionSource.GetDecisionCube TGanttSeries.GetStartValues THorizBarSeries.MandatoryValueList TPrinterSettings.GetMinExtentY"
	strings:
		$1 = { 8B 40 2C C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "TArrowSeries.GetStartYValues"
		size = 4
		altNames = "TChartSeries.MandatoryValueList TPieSeries.GetPieValues"
	strings:
		$1 = { 8B 40 30 C3 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "TArrowSeries.PrepareForGallery"
		size = 51
		refs = "0006 TChartSeries.PrepareForGallery 0021 TArrowSeries.SetArrowWidth 002d TArrowSeries.SetArrowHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 03 00 00 00 8B C3 8B 08 FF 91 84 00 00 00 BA 0C 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 0C 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "TArrowSeries.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TArrowSeries 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1112_0 {
	meta:
		name = "TBubbleSeries.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TBubbleSeries 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15481_0 {
	meta:
		name = "TChartShape.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TChartShape 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7539_0 {
	meta:
		name = "TGanttSeries.IsValidSourceOf"
		size = 18
		refs = "0007 _DV_TGanttSeries 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "ArrowCha"
		size = 114
		refs = "000b ArrowCha 0017 _NV__8E 0024 TeeMsg_GalleryStandard 0029 LoadResString 0035 TeeMsg_GalleryArrow 0042 _DV_TArrowSeries 0048 RegisterTeeSeries 0062 @LStrArrayClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 2E 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 59 59 5D C3 }
	condition:
		$1
}

rule function_1115_0 {
	meta:
		name = "BubbleCh"
		size = 114
		refs = "000b BubbleCh 0017 _NV__8A 0024 TeeMsg_GalleryStandard 0029 LoadResString 0035 TeeMsg_GalleryBubble 0042 _DV_TBubbleSeries 0048 RegisterTeeSeries 0062 @LStrArrayClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 2E 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 59 59 5D C3 }
	condition:
		$1
}

rule function_15489_0 {
	meta:
		name = "TeeShape"
		size = 114
		refs = "000b TeeShape 0017 _NV__BC 0024 TeeMsg_GalleryStandard 0029 LoadResString 0035 TeeMsg_GalleryShape 0042 _DV_TChartShape 0048 RegisterTeeSeries 0062 @LStrArrayClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 2E 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 A1 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 59 59 5D C3 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "TArrowSeriesEditor.CBColorEachClick"
		size = 103
		refs = "000a TCustomCheckBox.GetChecked 0017 TChartSeries.SetColorEachPoint 002e TControl.SetEnabled 004d TBrush.SetColor 0061 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 8B 83 04 02 00 00 8A 50 48 80 F2 01 8B 83 FC 01 00 00 E8 ?? ?? ?? ?? 8B 83 04 02 00 00 80 78 48 00 74 13 8B 80 D4 00 00 00 8B 40 14 BA 00 00 00 80 E8 ?? ?? ?? ?? 8B 83 FC 01 00 00 8A 50 45 8B 83 00 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "TArrowSeriesEditor.BArrowColorClick"
		size = 52
		refs = "0010 EditColor 002d TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B B3 04 02 00 00 8B 56 44 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 51 4C 8B 83 00 02 00 00 8B 80 BC 00 00 00 8B 56 44 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "TArrowSeriesEditor.BPenClick"
		size = 21
		refs = "0010 EditChartPen"
	strings:
		$1 = { 8B 90 04 02 00 00 8B 92 D4 00 00 00 8B 52 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_412_0 {
	meta:
		name = "TArrowSeriesEditor.BBrushClick"
		size = 21
		refs = "0010 EditChartBrush"
	strings:
		$1 = { 8B 90 04 02 00 00 8B 92 D4 00 00 00 8B 52 14 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_413_0 {
	meta:
		name = "TArrowSeriesEditor.SEArrowWidthChange"
		size = 99
		refs = "000c TArrowSeriesEditor.SEArrowWidthChange 0020 TControl.GetText 0031 TSpinEdit.GetValue 003e TArrowSeries.SetArrowWidth 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 83 7D FC 00 74 18 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "TArrowSeriesEditor.SEArrowHeightChange"
		size = 99
		refs = "000c TArrowSeriesEditor.SEArrowHeightChange 0020 TControl.GetText 0031 TSpinEdit.GetValue 003e TArrowSeries.SetArrowHeight 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 83 7D FC 00 74 18 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_415_0 {
	meta:
		name = "TArrowSeriesEditor.FormShow"
		size = 106
		refs = "0005 Screen 000e TScreen.SetCursor 0027 TCustomCheckBox.SetChecked 002e TArrowSeries.GetArrowWidth 003b TSpinEdit.SetValue 0042 TArrowSeries.GetArrowHeight 0063 TBrush.SetColor"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 04 02 00 00 8B F0 8A 56 48 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 8B 83 00 02 00 00 8B 80 BC 00 00 00 8B 56 44 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "_NF__2AE"
		size = 74
		refs = "0014 TAggregatedObject._AddRef 001e TAggregatedObject._Release 0022 _NF__2AE"
	strings:
		$1 = { CC 83 44 24 04 F8 8B 44 24 04 8B 00 FF 20 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 08 00 00 00 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "_NF__2B5"
		size = 146
		refs = "0007 TConnectionPoint.GetConnectionInterface 0011 TConnectionPoint.GetConnectionPointContainer 001b TConnectionPoint.Advise 0025 TConnectionPoint.Unadvise 002f TConnectionPoint.EnumConnections 0046 TAggregatedObject._AddRef 0050 TAggregatedObject._Release 0056 _NF__2B5"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 8B 44 24 04 8B 00 FF 20 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 86 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "_NF__2B8"
		size = 101
		refs = "0007 TConnectionPoints.EnumConnectionPoints 0011 TConnectionPoints.FindConnectionPoint 001b TAggregatedObject.QueryInterface 0025 TAggregatedObject._AddRef 002f TAggregatedObject._Release 0035 _NF__2B8"
	strings:
		$1 = { CC 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 08 00 00 00 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "_NF__2BD"
		size = 1727
		refs = "0007 TActiveXControl.PreMessageFilter 0011 TActiveXControl.PostMessageFilter 001b TComObject.QueryInterface 0025 TComObject._AddRef 002f TComObject._Release 0039 TActiveXControl.GetPages 0061 TActiveXControl.GetDisplayString 006b TActiveXControl.MapPropertyToPage 0075 TActiveXControl.GetPredefinedStrings 007f TActiveXControl.GetPredefinedValue 00a7 TActiveXControl.ViewObjectGetExtent 00b1 TActiveXControl.Draw 00bb TActiveXControl.GetColorSet 00c5 TActiveXControl.Freeze 00cf TActiveXControl.Unfreeze 00d9 TActiveXControl.SetAdvise 00e3 TActiveXControl.GetAdvise 0165 TActiveXControl.TranslateAccelerator 016f TActiveXControl.OnFrameWindowActivate 0179 TActiveXControl.OnDocWindowActivate 0183 TActiveXControl.ResizeBorder 018d TActiveXControl.EnableModeless 0197 TActiveXControl.GetWindow 01a1 TActiveXControl.ContextSensitiveHelp 01c9 TActiveXControl.InPlaceDeactivate 01d3 TActiveXControl.UIDeactivate 01dd TActiveXControl.SetObjectRects 01e7 TActiveXControl.ReactivateAndUndo 0223 TActiveXControl.GetControlInfo 022d TActiveXControl.OnMnemonic 0237 TActiveXControl.OnAmbientPropertyChange 0241 TActiveXControl.FreezeEvents 0269 TActiveXControl.SetClientSite 0273 TActiveXControl.GetClientSite 027d TActiveXControl.SetHostNames 0287 TActiveXControl.Close 0291 TActiveXControl.SetMoniker 029b TActiveXControl.GetMoniker 02a5 TActiveXControl.InitFromData 02af TActiveXControl.GetClipboardData 02b9 TActiveXControl.DoVerb 02c3 TActiveXControl.EnumVerbs 02cd TActiveXControl.Update 02d7 TActiveXControl.IsUpToDate 02e1 TActiveXControl.GetUserClassID 02eb TActiveXControl.GetUserType 02f5 TActiveXControl.SetExtent 02ff TActiveXControl.GetExtent 0309 TActiveXControl.Advise 0313 TActiveXControl.Unadvise 031d TActiveXControl.EnumAdvise 0327 TActiveXControl.GetMiscStatus 0331 TActiveXControl.SetColorScheme 0359 TActiveXControl.IsDirty 0363 TActiveXControl.PersistStorageInitNew 036d TActiveXControl.PersistStorageLoad 0377 TActiveXControl.PersistStorageSave 0381 TActiveXControl.SaveCompleted 038b TActiveXControl.HandsOffStorage 0395 TActiveXControl.GetClassID 03bd TActiveXControl.InitNew 03d1 TActiveXControl.PersistStreamLoad 03db TActiveXControl.PersistStreamSave 03e5 TActiveXControl.GetSizeMax 0413 _NF__2BD"
	strings:
		$1 = { CC 83 44 24 04 B8 E9 ?? ?? ?? ?? 83 44 24 04 B8 E9 ?? ?? ?? ?? 83 44 24 04 B8 E9 ?? ?? ?? ?? 83 44 24 04 B8 E9 ?? ?? ?? ?? 83 44 24 04 B8 E9 ?? ?? ?? ?? 83 44 24 04 BC E9 ?? ?? ?? ?? 83 44 24 04 BC E9 ?? ?? ?? ?? 83 44 24 04 BC E9 ?? ?? ?? ?? 83 44 24 04 BC E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C0 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C4 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 C8 E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 CC E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 D8 E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 DC E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0B 00 00 00 01 0E 2B 74 E6 14 1B 10 91 4E 00 AA 00 30 0C AB ?? ?? ?? ?? 48 00 00 00 8B B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 44 00 00 00 AA D3 6B 37 45 38 1B 10 84 ED 08 00 2B 2E C7 13 ?? ?? ?? ?? 40 00 00 00 27 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 3C 00 00 00 0D 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 38 00 00 00 17 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 34 00 00 00 13 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 30 00 00 00 88 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 2C 00 00 00 12 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 28 00 00 00 0A 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 24 00 00 00 80 23 D5 7F 07 4E 1B 10 AE 2D 08 00 2B 2E C7 13 ?? ?? ?? ?? 20 00 00 00 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "_NF__2C3"
		size = 200
		refs = "005a TActiveFormControl.FreeOnRelease 0067 TComObject.QueryInterface 0074 TComObject._AddRef 0081 TComObject._Release 0088 _NF__2C3"
	strings:
		$1 = { CC 81 44 24 04 68 FF FF FF 8B 44 24 04 8B 00 FF 60 18 81 44 24 04 68 FF FF FF 8B 44 24 04 8B 00 FF 60 14 81 44 24 04 68 FF FF FF 8B 44 24 04 8B 00 FF 60 10 81 44 24 04 68 FF FF FF 8B 44 24 04 8B 00 FF 60 1C 05 68 FF FF FF 50 8B 00 8B 40 EC 87 04 24 C3 05 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? 81 44 24 04 68 FF FF FF E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 A0 92 78 E0 2F F5 CF 11 BD 2F 00 20 AF 0E 5B 81 ?? ?? ?? ?? 98 00 00 00 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "_NF__2D3"
		size = 462
		refs = "0007 TActiveXPropertyPage.EditProperty 0011 TActiveXPropertyPage.SetPageSite 001b TActiveXPropertyPage.Activate 0025 TActiveXPropertyPage.Deactivate 002f TActiveXPropertyPage.GetPageInfo 0039 TActiveXPropertyPage.SetObjects 0043 TActiveXPropertyPage.Show 004d TActiveXPropertyPage.Move 0057 TActiveXPropertyPage.IsPageDirty 0061 TActiveXPropertyPage.Apply 006b TActiveXPropertyPage.Help 0075 TActiveXPropertyPage.TranslateAccelerator 007f TComObject.QueryInterface 0089 TComObject._AddRef 0093 TComObject._Release 0126 _NF__2D3"
	strings:
		$1 = { CC 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? 83 44 24 04 E8 E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 65 46 E4 01 AC 24 1B 10 84 ED 08 00 2B 2E C7 13 ?? ?? ?? ?? 1C 00 00 00 8D B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 18 00 00 00 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "_NF__2DC"
		size = 100
		refs = "0007 TAdapterNotifier.OnChanged 0011 TAdapterNotifier.OnRequestEdit 001b TInterfacedObject.QueryInterface 0025 TInterfacedObject._AddRef 002f TInterfacedObject._Release 0034 _NF__2DC"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "_NF__2E0"
		size = 177
		refs = "0005 TFontAdapter.GetOleFont 000d TFontAdapter.SetOleFont 0017 TInterfacedObject.QueryInterface 0021 TInterfacedObject._AddRef 002b TInterfacedObject._Release 0059 _NF__2E0"
	strings:
		$1 = { CC 83 C0 E0 E9 ?? ?? ?? ?? 83 C0 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 C0 E4 50 8B 00 8B 00 87 04 24 C3 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 A0 5C A5 CB 57 0E D0 11 BD 2F 00 20 AF 0E 5B 81 ?? ?? ?? ?? 20 00 00 00 21 23 B6 1F A7 44 D0 11 9E 93 00 20 AF 3D 82 DA ?? ?? ?? ?? 1C 00 00 00 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "_NF__2E4"
		size = 178
		refs = "0005 TPictureAdapter.GetOlePicture 000d TPictureAdapter.SetOlePicture 0017 TInterfacedObject.QueryInterface 0021 TInterfacedObject._AddRef 002b TInterfacedObject._Release 005a _NF__2E4"
	strings:
		$1 = { CC 83 C0 E0 E9 ?? ?? ?? ?? 83 C0 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 44 24 04 E0 E9 ?? ?? ?? ?? 83 C0 E4 50 8B 00 8B 00 87 04 24 C3 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? 83 44 24 04 E4 E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 31 4D 5D 79 D7 43 D0 11 9E 92 00 20 AF 3D 82 DA ?? ?? ?? ?? 20 00 00 00 21 23 B6 1F A7 44 D0 11 9E 93 00 20 AF 3D 82 DA ?? ?? ?? ?? 1C 00 00 00 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "_NF__2E9"
		size = 344
		refs = "0005 TStringsAdapter.ReferenceStrings 000d TStringsAdapter.ReleaseStrings 0017 TInterfacedObject.QueryInterface 0021 TInterfacedObject._AddRef 002b TInterfacedObject._Release 0035 TStringsAdapter.Get_ControlDefault 003f TStringsAdapter.Set_ControlDefault 0049 TStringsAdapter.Count 0053 TStringsAdapter.Get_Item 005d TStringsAdapter.Set_Item 0067 TStringsAdapter.Remove 0071 TStringsAdapter.Clear 007b TStringsAdapter.Add 0085 TStringsAdapter._NewEnum 008f TAutoIntfObject.GetTypeInfoCount 0099 TAutoIntfObject.GetTypeInfo 00a3 TAutoIntfObject.GetIDsOfNames 00ad TAutoIntfObject.Invoke 00d0 _NF__2E9"
	strings:
		$1 = { CC 83 C0 D0 E9 ?? ?? ?? ?? 83 C0 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D0 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? 83 44 24 04 D4 E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 34 2F 9C 73 EC 52 D0 11 9E A6 00 20 AF 3D 82 DA ?? ?? ?? ?? 30 00 00 00 E2 DF 05 EE 49 55 D0 11 9E A9 00 20 AF 3D 82 DA ?? ?? ?? ?? 2C 00 00 00 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "_NF__2F1"
		size = 133
		refs = "006d SendMessage 007b DefWindowProc"
	strings:
		$1 = { 55 8B EC 53 56 8B 55 14 8B 4D 10 8B 45 0C 8B D8 83 C3 D5 83 EB 03 72 0D 83 EB 0B 74 08 81 EB D8 00 00 00 75 4E 8B D8 83 FB 2D 7F 0C 74 1E 83 EB 2B 74 1E 4B 74 20 EB 27 83 EB 39 74 0A 81 EB D8 00 00 00 74 16 EB 18 8B 72 04 EB 17 8B 72 04 EB 12 8B 72 04 EB 0D 8B 72 04 EB 08 8B F2 EB 04 33 C0 EB 1C 52 51 05 00 20 00 00 50 56 E8 ?? ?? ?? ?? EB 0C 52 51 50 8B 45 08 50 E8 ?? ?? ?? ?? 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "_NF__2F2"
		size = 312
		refs = "0010 _NF__2F2 001c _NV__2F0 0033 @FillChar 0041 HInstance 0049 GetClassInfo 005e _NF__2F1 006f RegisterClass 007c SWindowClass 0081 LoadResString 008b _Dn_EOutOfResources 0090 Exception.Create 0095 @RaiseExcept 00ae GetSystemMetrics 00da CreateWindowEx 00f6 SetWindowPos 0111 @LStrClr 0117 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 33 C0 89 45 D4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 1D ?? ?? ?? ?? 85 DB 0F 85 D8 00 00 00 8D 45 D8 33 C9 BA 28 00 00 00 E8 ?? ?? ?? ?? 8D 45 D8 50 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? 85 C0 75 48 A1 ?? ?? ?? ?? 8B 00 89 45 E8 C7 45 DC ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 45 FC 8D 45 D8 50 E8 ?? ?? ?? ?? 66 85 C0 75 21 8D 55 D4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D D4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 A1 ?? ?? ?? ?? 8B 00 50 6A 00 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 50 6A 00 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 50 68 00 00 00 80 6A 00 8B 45 FC 50 68 80 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 5C 6A 00 6A 00 6A 00 6A 00 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C3 44 41 58 50 61 72 6B 69 6E 67 57 69 6E 64 6F 77 00 00 00 00 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "_NF__2F3"
		size = 43
		refs = "0002 ExceptObject 000c _Dn_EOleSysError 0011 @IsClass"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 83 7B 0C 00 7D 05 8B 43 0C 5B C3 B8 FF FF 00 80 5B C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "_NF__2F4"
		size = 36
		refs = "0012 TList.Get 0017 TObject.Free"
	strings:
		$1 = { 53 56 8B F0 8B 5E 08 4B 83 FB 00 7C 14 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4B 83 FB FF 75 EC 5E 5B C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "_NF__2F5"
		size = 23
		refs = "000a _NF__2F4 0011 TObject.Free"
	strings:
		$1 = { 53 8B D8 85 DB 74 0E 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "_NF__2F6"
		size = 42
		refs = "0006 CoTaskMemAlloc 0016 OleError 0021 @FillChar"
	strings:
		$1 = { 53 56 8B F0 56 E8 ?? ?? ?? ?? 8B D8 85 DB 75 0A B8 0E 00 07 80 E8 ?? ?? ?? ?? 8B C3 33 C9 8B D6 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "_NF__2F7"
		size = 11
		refs = "0006 CoTaskMemFree"
	strings:
		$1 = { 85 C0 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "_NF__2F8"
		size = 108
		refs = "000d _NF__2F8 001d @WStrFromLStr 0025 @WStrLen 0031 _NF__2F6 003b @WStrToPWChar 0044 Move 0059 @WStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 40 8B D8 03 DB 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B D6 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "_NF__2F9"
		size = 164
		refs = "001a _NF__2F9 002c @IntfClear 0083 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 4D FC 8B FA 8B F0 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 03 8D 45 F8 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 85 C0 7C 25 8D 45 F4 E8 ?? ?? ?? ?? 50 57 8B 45 F8 50 8B 00 FF 50 10 85 C0 7C 0E 53 8B 45 FC 50 8B 45 F4 50 8B 00 FF 50 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_11215_0 {
	meta:
		name = "_NF__1DF"
		size = 164
		refs = "001a _NF__1DF 002c @IntfClear 0083 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 4D FC 8B FA 8B F0 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 03 8D 45 F8 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 85 C0 7C 25 8D 45 F4 E8 ?? ?? ?? ?? 50 57 8B 45 F8 50 8B 00 FF 50 10 85 C0 7C 0E 53 8B 45 FC 50 8B 45 F4 50 8B 00 FF 50 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "_NF__2FA"
		size = 164
		refs = "0014 _NF__2FA 0027 @IntfClear 0084 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3B 00 74 42 8D 45 FC E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 85 C0 7C 2B 8D 45 F8 E8 ?? ?? ?? ?? 50 57 8B 45 FC 50 8B 00 FF 50 10 85 C0 7C 14 8B 03 50 8B 45 F8 50 8B 00 FF 50 18 85 C0 7C 04 33 C0 89 03 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_11216_0 {
	meta:
		name = "_NF__1E0"
		size = 164
		refs = "0014 _NF__1E0 0027 @IntfClear 0084 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3B 00 74 42 8D 45 FC E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 85 C0 7C 2B 8D 45 F8 E8 ?? ?? ?? ?? 50 57 8B 45 FC 50 8B 00 FF 50 10 85 C0 7C 14 8B 03 50 8B 45 F8 50 8B 00 FF 50 18 85 C0 7C 04 33 C0 89 03 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 00 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "_NF__2FB"
		size = 76
		refs = "0011 _DV_TFontAdapter 0016 TFontAdapter.Create 0023 @IntfCopy 002d _NF__2FB 0032 @IntfCast"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 1C 00 75 1B 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 1C 8D 43 1C E8 ?? ?? ?? ?? 8B C6 8B 53 1C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 A0 5C A5 CB 57 0E D0 11 BD 2F 00 20 AF 0E 5B 81 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "_NF__2FC"
		size = 76
		refs = "0011 _DV_TPictureAdapter 0016 TPictureAdapter.Create 0023 @IntfCopy 002d _NF__2FC 0032 @IntfCast"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 10 00 75 1B 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 1C 8D 43 10 E8 ?? ?? ?? ?? 8B C6 8B 53 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 31 4D 5D 79 D7 43 D0 11 9E 92 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "GetOleFont"
		size = 79
		refs = "000f GetOleFont 001f _NF__2FB 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 8B 08 FF 51 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "GetOlePicture"
		size = 79
		refs = "000f GetOlePicture 001f _NF__2FC 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 8B 08 FF 51 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "SetOleFont"
		size = 79
		refs = "000f SetOleFont 001f _NF__2FB 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 8B 08 FF 51 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "SetOlePicture"
		size = 79
		refs = "000f SetOlePicture 001f _NF__2FC 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 8B 08 FF 51 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "_NF__309"
		size = 54
		refs = "0006 GetKeyState"
	strings:
		$1 = { 53 33 DB 6A 10 E8 ?? ?? ?? ?? 66 85 C0 7D 05 BB 01 00 00 00 6A 11 E8 ?? ?? ?? ?? 66 85 C0 7D 03 83 CB 02 6A 12 E8 ?? ?? ?? ?? 66 85 C0 7D 03 83 CB 04 8B C3 5B C3 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "_NF__30B"
		size = 23
		refs = "0011 _NV__30A"
	strings:
		$1 = { 51 88 04 24 8A 04 24 24 07 25 FF 00 00 00 0F B6 80 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "_NF__30C"
		size = 10
	strings:
		$1 = { 8B C8 B8 01 00 00 00 D3 E0 C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "TOleStream.Create"
		size = 51
		refs = "000b @ClassCreate 001b @IntfCopy"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 04 8B D6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_14658_0 {
	meta:
		name = "Exception.Create"
		size = 51
		refs = "000b @ClassCreate 001b @LStrAsg"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 04 8B D6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_8807_0 {
	meta:
		name = "TIniFile.Create"
		size = 51
		refs = "000b @ClassCreate 001b @LStrAsg"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8D 47 04 8B D6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "TOleStream.Read"
		size = 35
		refs = "0017 OleCheck"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 8B D8 54 57 56 8B 43 04 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 04 24 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "TOleStream.Seek"
		size = 61
		refs = "002a OleCheck 0032 @ROUND"
	strings:
		$1 = { 53 56 57 83 C4 F4 8B F9 8B F2 8B D8 54 0F B7 C7 50 89 74 24 10 DB 44 24 10 83 C4 F8 DF 3C 24 9B 8B 43 04 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? DF 2C 24 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "TOleStream.Write"
		size = 35
		refs = "0017 OleCheck"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 8B D8 54 57 56 8B 43 04 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 8B 04 24 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "TAggregatedObject.Create"
		size = 30
		refs = "0008 @ClassCreate"
		altNames = "TDragControlObject.Create THandleStream.Create TOleObjectEditor.Create"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 04 84 D2 74 0A 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "TAggregatedObject.GetController"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "TAggregatedObject.QueryInterface"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 04 50 8B 00 FF 10 5D C2 0C 00 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "TAggregatedObject._AddRef"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 04 50 8B 00 FF 50 04 5D C2 04 00 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "TAggregatedObject._Release"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 04 50 8B 00 FF 50 08 5D C2 04 00 }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "TComObject.ObjQueryInterface"
		size = 38
		refs = "0010 TObject.GetInterface"
		altNames = "TComObjectFactory.QueryInterface TContainedObject.QueryInterface TInterfacedObject.QueryInterface _NF__347"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 4D 10 8B 55 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 05 B8 02 40 00 80 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_459_0 {
	meta:
		name = "_NF__32F"
		size = 131
		refs = "0007 _NF__334 0011 _NF__335 001b _NF__336 0025 _NF__337 003c TAggregatedObject._AddRef 0046 TAggregatedObject._Release 004b _NF__32F"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 8B 44 24 04 8B 00 FF 20 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 87 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "_NF__332"
		size = 133
		refs = "0010 @ClassCreate 001e _NF__332 002e TAggregatedObject.GetController 003a TAggregatedObject.Create 0061 @IntfClear 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 10 8B 45 08 89 47 14 8B 46 24 8B 40 08 89 47 18 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "_NF__334"
		size = 114
		refs = "001b TList.Get 0034 @IntfCopy"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 10 8B 5D 08 33 F6 EB 33 8B 43 10 8B 40 24 8B 53 14 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 19 33 C0 89 04 F7 8D 04 F7 8B 55 FC E8 ?? ?? ?? ?? 8B 43 14 40 89 44 F7 04 46 FF 43 14 3B 75 0C 7D 08 8B 43 14 3B 43 18 7C C0 83 7D 14 00 74 05 8B 45 14 89 30 3B 75 0C 75 04 33 C0 EB 05 B8 01 00 00 00 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "_NF__335"
		size = 68
		refs = "001d TList.Get"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 BF 01 00 00 00 EB 16 8B 43 10 8B 40 24 8B 53 14 E8 ?? ?? ?? ?? 85 C0 74 01 4E FF 43 14 85 F6 7E 08 8B 43 14 3B 43 18 7C DE 85 F6 75 02 33 FF 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "_NF__336"
		size = 17
		altNames = "_NF__35B"
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 89 50 14 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "_NF__337"
		size = 102
		refs = "0018 _NF__337 002c _NV__330 0031 _NF__332 003e @IntfCopy 004f @HandleAnyException 0059 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 14 50 8B 4B 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 0C 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "_NF__35C"
		size = 102
		refs = "0018 _NF__35C 002c _NV__355 0031 _NF__357 003e @IntfCopy 004f @HandleAnyException 0059 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 14 50 8B 4B 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 0C 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "TConnectionPoint.Create"
		size = 188
		refs = "0016 @ClassCreate 0025 TConnectionPoint.Create 0035 TAggregatedObject.GetController 0041 TAggregatedObject.Create 0050 TList.Add 0057 _Dn_TList 005c TObject.Create 0095 @IntfClear 009b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 4D F8 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C6 89 43 10 8B 40 0C 8B D3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 24 8B 45 14 8B F0 8D 7B 14 B9 04 00 00 00 F3 A5 8A 45 10 88 43 30 8B 45 08 89 43 28 8B 45 0C 89 43 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 59 59 5D C2 10 00 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "TConnectionPoint.Destroy"
		size = 108
		refs = "0015 TList.Remove 0031 TList.Get 003e _NF__343 004a TObject.Free 0056 TObject.Destroy 0061 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 8B 45 10 85 C0 74 0A 8B 40 0C 8B D5 E8 ?? ?? ?? ?? 8B 45 24 85 C0 74 2E 8B 78 08 4F 85 FF 7C 1E 47 33 F6 8B D6 8B 45 24 E8 ?? ?? ?? ?? 85 C0 74 09 8B D6 8B C5 E8 ?? ?? ?? ?? 46 4F 75 E5 8B 45 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C5 E8 ?? ?? ?? ?? 84 DB 74 07 8B C5 E8 ?? ?? ?? ?? 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "_NF__342"
		size = 74
		refs = "0011 TList.Get 002d TList.Add 0038 TList.Put"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F0 33 DB EB 0E 8B D3 8B C7 E8 ?? ?? ?? ?? 85 C0 75 09 43 8B 7E 24 3B 5F 08 7C EA 8B 46 24 3B 58 08 7C 09 8B D5 E8 ?? ?? ?? ?? EB 09 8B CD 8B D3 E8 ?? ?? ?? ?? 55 8B 45 00 FF 50 04 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "_NF__343"
		size = 49
		refs = "0010 TList.Get 001f TList.Put"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 8B D6 8B 43 24 E8 ?? ?? ?? ?? 89 45 FC 33 C9 8B D6 8B 43 24 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 08 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "TConnectionPoint.GetConnectionInterface"
		size = 31
	strings:
		$1 = { 55 8B EC 56 57 8B 45 08 8B 55 0C 8B FA 8D 70 14 B9 04 00 00 00 F3 A5 33 C0 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "TConnectionPoint.GetConnectionPointContainer"
		size = 39
		refs = "001c @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 45 0C 8B 53 10 83 C2 08 E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "TConnectionPoint.Advise"
		size = 118
		refs = "0026 TConnectionPoint.Advise 0046 _NF__342 005d @HandleAnyException 0062 _NF__2F3 0069 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 80 7B 30 00 75 10 8B 43 24 83 78 08 00 7E 07 BB 02 02 04 80 EB 4B 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 7B 2A 00 74 0A B1 01 8B D6 8B 43 2C FF 53 28 8B D6 8B C3 E8 ?? ?? ?? ?? 40 8B 55 10 89 02 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "TConnectionPoint.Unadvise"
		size = 134
		refs = "001f TList.Get 0032 TConnectionPoint.Unadvise 005c _NF__343 006d @HandleAnyException 0072 _NF__2F3 0079 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 4E 85 F6 7C 16 8B 43 24 3B 70 08 7D 0E 8B 43 24 8B D6 E8 ?? ?? ?? ?? 85 C0 75 07 BB 00 02 04 80 EB 4F 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 7B 2A 00 74 14 8B 43 24 8B D6 E8 ?? ?? ?? ?? 8B D0 33 C9 8B 43 2C FF 53 28 8B D6 8B C3 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "TConnectionPoint.EnumConnections"
		size = 101
		refs = "0018 TConnectionPoint.EnumConnections 0029 _NV__330 002e _NF__332 003b @IntfCopy 004c @HandleAnyException 0051 _NF__2F3 0058 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 0C 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "_NF__354"
		size = 130
		refs = "0007 _NF__359 0011 _NF__35A 001b _NF__35B 0025 _NF__35C 003c TAggregatedObject._AddRef 0046 TAggregatedObject._Release 004a _NF__354"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 8B 44 24 04 8B 00 FF 20 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 85 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "_NF__357"
		size = 124
		refs = "0010 @ClassCreate 001e _NF__357 002e TAggregatedObject.GetController 003a TAggregatedObject.Create 0058 @IntfClear 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 10 8B 45 08 89 47 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "_NF__359"
		size = 109
		refs = "001b TList.Get"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 0C 8B 5D 08 33 F6 EB 2A 8B 43 10 8B 40 0C 8B 53 14 E8 ?? ?? ?? ?? 83 C0 0C 89 45 FC 8B 45 FC 50 8B 00 FF 50 04 8B 45 10 8B 55 FC 89 14 B0 46 FF 43 14 3B FE 7E 0E 8B 43 10 8B 40 0C 8B 40 08 3B 43 14 7F C4 83 7D 14 00 74 05 8B 45 14 89 30 3B FE 75 04 33 C0 EB 05 B8 01 00 00 00 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "_NF__35A"
		size = 48
	strings:
		$1 = { 55 8B EC 53 8B 55 0C 8B 45 08 8B 48 10 8B 49 0C 8B 49 08 8B 58 14 03 DA 3B CB 7C 07 01 50 14 33 C0 EB 08 89 48 14 B8 01 00 00 00 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TConnectionPoints.Create"
		size = 61
		refs = "000a @ClassCreate 0017 TAggregatedObject.Create 001e _Dn_TList 0023 TObject.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "TConnectionPoints.Destroy"
		size = 30
		refs = "000a _NF__2F5 0015 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 0C E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "TConnectionPoints.CreateConnectionPoint"
		size = 31
		refs = "000d _DV_TConnectionPoint 0017 TConnectionPoint.Create"
	strings:
		$1 = { 55 8B EC 52 51 FF 75 0C FF 75 08 8B 15 ?? ?? ?? ?? B1 01 92 87 CA E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "TConnectionPoints.EnumConnectionPoints"
		size = 99
		refs = "0018 TConnectionPoints.EnumConnectionPoints 0029 _NV__355 002e _NF__357 003b @IntfCopy 004c @HandleAnyException 0056 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 0C 8B 45 0C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "TConnectionPoints.FindConnectionPoint"
		size = 99
		refs = "002b TList.Get 003a IsEqualGUID 004b @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 10 85 C0 74 04 33 D2 89 10 8B 45 08 8B 40 0C 8B 70 08 4E 85 F6 7C 38 46 33 FF 8B 45 08 8B 40 0C 8B D7 E8 ?? ?? ?? ?? 8B D8 8B 45 0C 50 8D 43 14 50 E8 ?? ?? ?? ?? 84 C0 74 11 8B 45 10 8B D3 83 C2 0C E8 ?? ?? ?? ?? 33 C0 EB 09 47 4E 75 CB B8 00 02 04 80 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "_NF__372"
		size = 127
		refs = "000f @ClassCreate 001d TWinControl.CreateParented"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 7D 08 89 BE 18 01 00 00 8B D6 8B C7 8B 08 FF 51 3C 8B 86 18 01 00 00 8B 50 38 52 8B 50 3C 52 33 C9 33 D2 8B 18 FF 53 4C 8B 86 18 01 00 00 8B 50 38 52 8B 40 3C 50 8B 4E 34 8B 56 30 8B C6 8B 18 FF 53 4C 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "_NF__373"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 18 01 00 00 8B 08 FF 51 40 5E C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "_NF__374"
		size = 58
		refs = "0011 _Dn_TWinControl 0016 @IsClass 0021 TWinControl.GetHandle 0027 SetFocus 0032 TWinControl.WMSetFocus"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B B3 18 01 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "_NF__375"
		size = 167
		refs = "0027 _NF__375 0091 @HandleFinally 009e TWinControl.WMSize"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 F8 89 45 FC 8B 45 FC 80 B8 1C 01 00 00 00 75 7E 8B 45 FC C6 80 1C 01 00 00 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F8 0F B7 40 08 50 8B 45 F8 0F B7 40 0A 50 8B 45 FC 8B 80 18 01 00 00 33 C9 33 D2 8B 18 FF 53 4C 8B 45 FC 8B 80 18 01 00 00 8B 50 38 52 8B 40 3C 50 8B 45 FC 8B 48 34 8B 45 FC 8B 50 30 8B 45 FC 8B 18 FF 53 4C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 1C 01 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "_NF__376"
		size = 196
		refs = "0007 _NF__37B 0011 _NF__37C 001b _NF__37D 0025 _NF__37E 002f _NF__37A 0039 TInterfacedObject._AddRef 0043 TInterfacedObject._Release 0068 _NF__376"
	strings:
		$1 = { CC 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 10 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "_NF__379"
		size = 150
		refs = "000f @ClassCreate 0021 @IntfAddRef 0029 _NF__379 0038 TObject.Create 004e @IntfClear 005d OleCheck 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F8 8B 75 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C7 E8 ?? ?? ?? ?? 56 57 83 C7 18 B9 04 00 00 00 F3 A5 5F 5E 8D 47 14 E8 ?? ?? ?? ?? 50 56 8B 45 FC 50 8B 00 FF 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "_NF__37A"
		size = 77
		refs = "0013 TInterfacedObject.QueryInterface 0024 IsEqualGUID 0034 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 8B 75 0C 8B 5D 08 57 56 53 E8 ?? ?? ?? ?? 3D 02 40 00 80 75 28 8D 43 18 50 56 E8 ?? ?? ?? ?? 84 C0 74 10 8B C7 8B D3 83 C2 10 E8 ?? ?? ?? ?? 33 C0 EB 0A 57 56 8B 43 14 50 8B 00 FF 10 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "_NF__37B"
		size = 23
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 52 8B 40 14 50 8B 00 FF 50 0C 5D C2 08 00 }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "_NF__37C"
		size = 31
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 14 50 8B 00 FF 50 10 5D C2 10 00 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "_NF__37D"
		size = 39
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 14 50 8B 00 FF 50 14 5D C2 18 00 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "_NF__37E"
		size = 54
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 28 52 8B 55 24 52 8B 55 20 52 8B 55 1C 52 66 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 14 50 8B 00 FF 50 18 33 C0 5D C2 24 00 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "_NF__37F"
		size = 291
		refs = "0007 _NF__385 0011 _NF__386 001b _NF__387 0025 _NF__388 002f _NF__389 0039 _NF__38A 0043 _NF__38B 004d _NF__38C 0057 _NF__38D 0061 _NF__38E 006b _NF__38F 0075 _NF__384 007f TInterfacedObject._AddRef 0089 TInterfacedObject._Release 00ab _NF__37F"
	strings:
		$1 = { CC 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F0 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 00 1D 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 10 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "_NF__382"
		size = 117
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 _NF__382 0034 TObject.Create 003f @IntfCopy 0054 @IntfClear 005a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 14 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "TTextCont.Destroy"
		size = 34
		refs = "000e TObject.Destroy 0019 @ClassDestroy"
		altNames = "TTextRec.Destroy _NF__383"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10240_0 {
	meta:
		name = "TDecisionGraphDataLink.Destroy"
		size = 34
		refs = "000e TDecisionDataLink.Destroy 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10315_0 {
	meta:
		name = "TDecisionGridDataLink.Destroy"
		size = 34
		refs = "000e TDecisionDataLink.Destroy 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10545_0 {
	meta:
		name = "TMultiDimDataLink.Destroy"
		size = 34
		refs = "000e TDataLink.Destroy 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10368_0 {
	meta:
		name = "TPivotDataLink.Destroy"
		size = 34
		refs = "000e TDecisionDataLink.Destroy 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13068_0 {
	meta:
		name = "TQRDesigner.Destroy"
		size = 34
		refs = "000e TControl.Destroy 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "_NF__384"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 14 50 8B 00 FF 10 5D C2 0C 00 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "TActiveXControl.ContextSensitiveHelp"
		size = 12
		altNames = "TActiveXControl.GetSizeMax TActiveXControl.SetColorScheme TActiveXControl.Unfreeze TActiveXPropertyPage.EditProperty TActiveXPropertyPage.Help _NF__351 _NF__355 _NF__365 _NF__385 _NF__386 _NF__389 _NF__38F"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "TActiveXControl.SetMoniker"
		size = 12
		altNames = "_NF__263 _NF__271 _NF__354 _NF__35D _NF__387 _NF__38B"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 0C 00 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "TStreamAdapter.Clone"
		size = 23
		altNames = "_NF__352 _NF__388 _NF__38D"
	strings:
		$1 = { 55 8B EC 8B 45 0C 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "_NF__38A"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 0C 33 D2 89 10 B8 05 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "TActiveXControl.HandsOffStorage"
		size = 9
		altNames = "TActiveXControl.IsUpToDate TActiveXControl.Update TCustomBarSeries.InternalClicked TDataSet.Locate TIVCLStreamAdapter.GetModifyTime _NF__268 _NF__34A _NF__359 _NF__38C"
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "TActiveXControl.ReactivateAndUndo"
		size = 12
		altNames = "_NF__26A _NF__274 _NF__34F _NF__350 _NF__356 _NF__360 _NF__38E"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 04 00 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "TActiveXControl.Initialize"
		size = 220
		refs = "000c _DV_TConnectionPoints 0011 TConnectionPoints.Create 0026 _NF__399 0033 TConnectionPoints.CreateConnectionPoint 003c TActiveXControl.Initialize 004e _NF__2F2 005d TWinControl.CreateParented 0080 _NV__370 0085 _NF__372"
	strings:
		$1 = { 53 56 8B F0 8B CE 83 C1 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 50 8B 46 10 89 46 4C 83 78 6C 00 74 13 56 68 ?? ?? ?? ?? 8D 50 70 33 C9 8B 46 50 E8 ?? ?? ?? ?? 6A 00 6A 00 BA ?? ?? ?? ?? B1 01 8B 46 50 E8 ?? ?? ?? ?? 89 46 58 E8 ?? ?? ?? ?? 8B C8 8B 46 4C 8B 40 60 B2 01 E8 ?? ?? ?? ?? 8B D8 89 9E 84 00 00 00 F6 43 41 40 74 22 8B 86 84 00 00 00 50 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 90 00 00 00 EB 06 89 9E 90 00 00 00 8B 86 84 00 00 00 8B 50 28 89 96 88 00 00 00 8B 50 2C 89 96 8C 00 00 00 8B 86 84 00 00 00 89 70 2C 8B 16 8B 52 44 89 50 28 8B C6 8B 10 FF 52 34 5E 5B C3 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "TActiveXControl.Destroy"
		size = 106
		refs = "002f TObject.Free 0056 TComObject.Destroy 0061 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 66 83 BE 8A 00 00 00 00 74 18 8B 86 84 00 00 00 8B 96 88 00 00 00 89 50 28 8B 96 8C 00 00 00 89 50 2C 8B 86 84 00 00 00 E8 ?? ?? ?? ?? 8B 86 90 00 00 00 3B 86 84 00 00 00 74 05 E8 ?? ?? ?? ?? 8B 46 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "_NF__395"
		size = 29
		refs = "000d @IntfClear 0013 CreateOleAdviseHolder"
	strings:
		$1 = { 53 8B D8 83 7B 78 00 75 10 8D 43 78 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "TActiveForm.DefinePropertyPages"
		size = 7
		altNames = "TActiveXControl.DefinePropertyPages TChartSeries.DoSeriesMouseUp TComponent.GetChildren TCustomChart.FillSeriesSourceItems TCustomRadioGroup.GetChildren TCustomRemoteServer.GetProviderNames TDBNavigator.GetChildren TDragObject.Finished TIVCLStreamAdapter.SetModifyTime TPropertyEditor.GetProperties TPropertyEditor.GetValues TSpinEdit.GetChildren TTabSet.GetChildren _NF__279"
	strings:
		$1 = { 55 8B EC 5D C2 08 00 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "_NF__399"
		size = 92
		refs = "000e @IntfClear 0020 OleCheck 0030 _NV__377 0035 _NF__379"
	strings:
		$1 = { 56 57 8B FA 8B F0 84 C9 74 3E 8D 46 54 E8 ?? ?? ?? ?? 50 8B 46 4C 83 C0 70 50 57 8B 07 FF 10 E8 ?? ?? ?? ?? 8B 46 4C 83 C0 70 50 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 0C 8B C6 8B 08 FF 51 24 5F 5E C3 8D 46 54 E8 ?? ?? ?? ?? 33 D2 8B C6 8B 08 FF 51 24 5F 5E C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "TActiveXControl.GetPropertyValue"
		size = 7
		altNames = "TChartSeries.DoSeriesMouseMove TChartSeries.PrepareLegendCanvas TComponent.UpdateRegistry TCustomGrid.SetEditText TIVCLStreamAdapter.Flush TQRExportFilter.Start _NF__27A _NF__27B"
	strings:
		$1 = { 55 8B EC 5D C2 04 00 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TActiveXControl.InPlaceActivate"
		size = 624
		refs = "001c TControl.SetVisible 0038 TActiveXControl.InPlaceActivate 0051 OleError 005c @IntfClear 0072 OleCheck 0139 TWinControl.SetParentWindow 016e @HandleAnyException 01b0 _NF__2F3 01b7 @DoneExcept 01f9 TWinControl.GetHandle 01ff SetFocus"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 57 8B DA 89 45 FC 33 F6 8B 45 FC 8B 80 90 00 00 00 B2 01 E8 ?? ?? ?? ?? C6 45 FB 00 8B 45 FC 80 B8 95 00 00 00 00 0F 85 91 01 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 83 78 5C 00 75 0A B8 05 40 00 80 E8 ?? ?? ?? ?? 8B 45 FC 83 C0 6C E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 8B 40 5C 50 8B 00 FF 10 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 6C 50 8B 00 FF 50 14 85 C0 74 0A B8 05 40 00 80 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 6C 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? C6 45 FB 01 8D 45 F4 50 8B 45 FC 8B 40 6C 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? C7 45 C0 14 00 00 00 8D 45 C0 50 8D 45 D4 50 8D 45 E4 50 8B 45 FC 83 C0 74 E8 ?? ?? ?? ?? 50 8B 45 FC 83 C0 70 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 40 6C 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 8B 45 FC 83 78 70 00 75 0A B8 05 40 00 80 E8 ?? ?? ?? ?? 8B 4D EC 8B 45 E4 2B C8 51 8B 4D F0 8B 55 E8 2B CA 51 8B 4D FC 8B 89 90 00 00 00 91 87 D1 8B 38 FF 57 4C 8B 45 FC 8B 80 90 00 00 00 8B 55 F4 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 90 00 00 00 B2 01 E8 ?? ?? ?? ?? 8B 45 FC C6 80 95 00 00 00 01 8B 45 FC 8B 40 5C 50 8B 00 FF 50 18 33 C0 5A 59 59 64 89 10 EB 58 E9 ?? ?? ?? ?? 8B 45 FC C6 80 95 00 00 00 00 8B 45 FC 83 C0 74 E8 ?? ?? ?? ?? 8B 45 FC 83 C0 70 E8 ?? ?? ?? ?? 80 7D FB 00 74 0C 8B 45 FC 8B 40 6C 50 8B 00 FF 50 2C 8B 45 FC 83 C0 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? E9 95 00 00 00 E8 ?? ?? ?? ?? 84 DB 0F 84 88 00 00 00 8B 45 FC 80 B8 96 00 00 00 00 75 7C 8B 45 FC C6 80 96 00 00 00 01 8B 45 FC 8B 40 6C 50 8B 00 FF 50 1C 8B 45 FC 8B 80 90 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 00 8B 5D FC 83 C3 34 53 8B 45 FC 8B 40 70 50 8B 00 FF 50 20 8B 45 FC 83 78 74 00 74 0F 6A 00 53 8B 45 FC 8B 40 74 50 8B 00 FF 50 20 6A 00 8B 45 FC 8B 40 70 50 8B 00 FF 50 1C 8B 45 FC 83 78 74 00 74 0E 6A 00 8B 45 FC 8B 40 74 50 8B 00 FF 50 1C 8B C6 5F 5E 5B 8B E5 5D C3 00 00 19 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TActiveXControl.LoadFromStream"
		size = 85
		refs = "000a _DV_TOleStream 0011 TOleStream.Create 001c TActiveXControl.LoadFromStream 0030 TStream.ReadComponent 0045 TObject.Free 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 93 84 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TActiveXControl.ObjQueryInterface"
		size = 176
		refs = "000d TActiveXControl.ObjQueryInterface 0013 IsEqualGUID 0032 TComObject.ObjQueryInterface 005a _NV__380 005f _NF__382 006c @IntfCopy 007b TObject.GetInterface"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 84 C0 74 10 8B 43 4C F6 40 66 01 75 07 BF 02 40 00 80 EB 5A 8B 45 10 50 56 53 E8 ?? ?? ?? ?? 8B F8 85 FF 74 49 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 84 C0 74 27 8B 45 10 33 D2 89 10 8B CB 83 C1 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 10 8B 45 10 E8 ?? ?? ?? ?? EB 13 8B 4D 10 8B D6 8B 43 50 E8 ?? ?? ?? ?? 84 C0 74 02 33 FF 8B C7 5F 5E 5B 5D C2 0C 00 00 00 01 0E 2B 74 E6 14 1B 10 91 4E 00 AA 00 30 0C AB 1D 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "_NF__3B9"
		size = 133
		refs = "0015 _NF__3B9 002c @LStrFromWStr 0044 GetThreadLocale 0050 GUID_NULL 005c OleCheck 0071 @LStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 C9 89 4D F0 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 89 45 F4 8D 45 F0 8B 55 FC E8 ?? ?? ?? ?? 83 7D F0 00 75 09 C7 45 F8 FF FF FF FF EB 21 8D 45 F8 50 E8 ?? ?? ?? ?? 50 6A 01 8D 45 F4 50 A1 ?? ?? ?? ?? 50 53 8B 03 FF 50 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TActiveXControl.PropRequestEdit"
		size = 240
		refs = "001a TConnectData 001f @InitializeRecord 0027 TActiveXControl.PropRequestEdit 0038 _NF__3B9 0042 @IntfClear 004c TConnectionPoint.EnumConnections 0051 OleCheck 0064 @IntfCast 0090 @FinalizeRecord 00d1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 89 4D FC 8B F2 8B F8 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B3 01 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F0 8D 45 FC E8 ?? ?? ?? ?? 50 8B 47 58 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2B 56 8D 45 EC 8B 55 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 10 85 C0 0F 94 C3 8D 45 F4 E8 ?? ?? ?? ?? 84 DB 74 22 8D 45 F0 50 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 6A 01 8B 45 FC 50 8B 00 FF 50 0C 85 C0 74 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C3 5F 5E 5B 8B E5 5D C3 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TActiveXControl.PropChanged"
		size = 228
		refs = "0019 TConnectData 001e @InitializeRecord 0026 TActiveXControl.PropChanged 0035 _NF__3B9 003f @IntfClear 0049 TConnectionPoint.EnumConnections 004e OleCheck 0061 @IntfCast 0084 @FinalizeRecord 00c5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 89 4D FC 8B DA 8B F0 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 8D 45 FC E8 ?? ?? ?? ?? 50 8B 46 58 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 22 53 8D 45 EC 8B 55 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 0C 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 15 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 50 6A 01 8B 45 FC 50 8B 00 FF 50 0C 85 C0 74 BC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 5E 5B 8B E5 5D C3 00 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "_NF__3C0"
		size = 109
		refs = "000c TWinControl.HandleAllocated 0023 TWinControl.GetHandle 0029 GetWindow 0031 TActiveXControl.InPlaceDeactivate 003c TWinControl.DestroyHandle 0045 TActiveXControl.InPlaceActivate 0065 SetWindowPos"
	strings:
		$1 = { 53 56 57 8B F0 8B 86 90 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 55 8A 9E 96 00 00 00 6A 03 8B 86 90 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 8B 86 90 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 85 C0 75 1C 6A 13 6A 00 6A 00 6A 00 6A 00 57 8B 86 90 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TActiveXControl.SaveToStream"
		size = 163
		refs = "000c _DV_TOleStream 0013 TOleStream.Create 001e TActiveXControl.SaveToStream 0033 _Dn_TWriter 0038 TFiler.Create 0060 TWriter.WriteDescendent 0075 TObject.Free 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B D8 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 C6 40 20 01 8B 93 84 00 00 00 33 C9 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TActiveXControl.ShowPropertyDialog"
		size = 360
		refs = "0015 TActiveXControl.ShowPropertyDialog 0045 TActiveXControl.GetPages 004a OleCheck 0095 @IntfCopy 00aa @IntfDispCall 00b5 @WStrToPWChar 00c9 GetSystemDefaultLCID 00d3 GetActiveWindow 00e2 _NF__633 0111 @HandleFinally 0128 _NF__2F7 0145 @WStrClr 014d @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 EC 33 D2 89 55 EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 78 60 00 74 14 8B 45 FC 8B 40 60 50 8B 00 FF 50 24 85 C0 0F 84 F8 00 00 00 8D 45 F0 50 8B 45 FC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F0 00 0F 8E B1 00 00 00 8B 45 FC 83 78 70 00 74 0E 6A 00 8B 45 FC 8B 40 70 50 8B 00 FF 50 34 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B 55 FC 83 C2 04 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 FC 8B 40 68 50 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC E8 ?? ?? ?? ?? 50 6A 01 8D 45 F8 50 8B 45 F0 50 8B 45 F4 50 E8 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? B9 10 00 00 00 BA 10 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 78 70 00 74 0E 6A FF 8B 45 FC 8B 40 70 50 8B 00 FF 50 34 C3 E9 ?? ?? ?? ?? EB E1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 00 42 FD FF FF 08 02 00 00 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TActiveXControl.StdClickEvent"
		size = 36
		refs = "0007 TActiveXControl.StdClickEvent 0012 @IntfDispCall"
	strings:
		$1 = { 83 78 54 00 74 13 68 ?? ?? ?? ?? 8B 40 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C C3 00 00 A8 FD FF FF 00 01 00 00 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "TActiveXControl.StdDblClickEvent"
		size = 36
		refs = "0007 TActiveXControl.StdDblClickEvent 0012 @IntfDispCall"
	strings:
		$1 = { 83 78 54 00 74 13 68 ?? ?? ?? ?? 8B 40 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C C3 00 00 A7 FD FF FF 00 01 00 00 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "TActiveXControl.StdKeyDownEvent"
		size = 64
		refs = "0013 _NF__30B 001a TActiveXControl.StdKeyDownEvent 0025 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 83 7B 54 00 74 1D 8A 45 08 E8 ?? ?? ?? ?? 50 56 68 ?? ?? ?? ?? 8B 43 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5E 5B 5D C2 04 00 00 00 A6 FD FF FF 00 01 02 00 82 02 00 00 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "TActiveXControl.StdKeyUpEvent"
		size = 64
		refs = "0013 _NF__30B 001a TActiveXControl.StdKeyUpEvent 0025 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 83 7B 54 00 74 1D 8A 45 08 E8 ?? ?? ?? ?? 50 56 68 ?? ?? ?? ?? 8B 43 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5E 5B 5D C2 04 00 00 00 A6 FD FF FF 00 01 02 00 82 02 00 00 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "TActiveXControl.StdKeyPressEvent"
		size = 60
		refs = "0014 TActiveXControl.StdKeyPressEvent 001f @IntfDispCall"
	strings:
		$1 = { 53 51 8B D9 83 78 54 00 74 22 33 D2 8A 13 66 89 14 24 54 68 ?? ?? ?? ?? 8B 40 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 66 8B 04 24 88 03 5A 5B C3 00 A5 FD FF FF 00 01 01 00 82 00 00 00 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TActiveXControl.StdMouseDownEvent"
		size = 80
		refs = "001b _NF__30B 0023 _NF__30C 0029 TActiveXControl.StdMouseDownEvent 0034 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B D9 8B F0 83 7E 54 00 74 2C 8B 45 08 50 8B 45 0C 50 8A 45 10 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 46 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B 5D C2 0C 00 00 00 00 A3 FD FF FF 00 01 04 00 02 02 03 03 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TActiveXControl.StdMouseMoveEvent"
		size = 84
		refs = "001c _NF__30B 002f TActiveXControl.StdMouseMoveEvent 003a @IntfDispCall"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 83 7B 54 00 74 31 8B 45 08 50 8B 45 0C 50 8A 45 FF E8 ?? ?? ?? ?? 50 33 C0 8A 45 FF C1 E8 03 66 83 E0 07 50 68 ?? ?? ?? ?? 8B 43 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 5B 59 5D C2 08 00 00 A2 FD FF FF 00 01 04 00 02 02 03 03 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TActiveXControl.StdMouseUpEvent"
		size = 80
		refs = "001b _NF__30B 0023 _NF__30C 0029 TActiveXControl.StdMouseUpEvent 0034 @IntfDispCall"
	strings:
		$1 = { 55 8B EC 53 56 8B D9 8B F0 83 7E 54 00 74 2C 8B 45 08 50 8B 45 0C 50 8A 45 10 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 46 54 50 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B 5D C2 0C 00 00 00 00 A1 FD FF FF 00 01 04 00 02 02 03 03 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "_NF__3EE"
		size = 41
		refs = "0023 @IntfClear"
	strings:
		$1 = { 53 8B D8 83 7B 7C 00 74 1E 6A FF 6A 01 8B 43 7C 50 8B 00 FF 50 10 F6 83 80 00 00 00 04 74 08 8D 43 7C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "_NF__3EF"
		size = 79
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8B 5B FC 8B 03 3D 00 20 00 00 7C 0D 3D 00 24 00 00 7D 06 81 03 00 9C 00 00 8B 45 08 8B 70 F8 8B D3 8B 86 8C 00 00 00 FF 96 88 00 00 00 8B 03 3D 00 BC 00 00 7C 0D 3D 00 C0 00 00 7D 06 81 2B 00 9C 00 00 5E 5B 5D C3 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "TActiveXControl.WndProc"
		size = 490
		refs = "00c8 _NF__3EF 0113 TControl.SetVisible 012b TActiveXControl.UIDeactivate 015c _NF__3C0 016d _NF__3EE"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 55 FC 89 45 F8 8B 45 F8 8B 80 84 00 00 00 8B B8 CC 00 00 00 8B 75 FC 8B 36 81 FE 00 B0 00 00 7C 0B 8B 45 FC 81 FE 00 C0 00 00 7C 15 8B 45 F8 83 78 64 00 74 0C 8B 45 F8 80 B8 95 00 00 00 00 75 04 33 DB EB 02 B3 01 84 DB 74 31 8D 45 F4 50 8B 45 FC 83 C0 0C 50 8B 45 FC 8B 40 08 50 8B 45 FC 8B 40 04 50 8B 45 FC 56 57 8B 45 F8 8B 40 64 50 8B 00 FF 50 0C 48 0F 84 5D 01 00 00 8B 45 FC 8B 00 3D 0B B0 00 00 7F 21 74 65 83 C0 F9 83 E8 02 72 2A 83 E8 03 0F 84 CE 00 00 00 83 E8 78 0F 84 E2 00 00 00 E9 F9 00 00 00 2D 33 B0 00 00 74 7E 48 0F 84 B2 00 00 00 E9 E6 00 00 00 55 E8 ?? ?? ?? ?? 59 8B 45 F8 83 78 60 00 0F 84 D9 00 00 00 8B 45 FC 83 38 07 0F 94 C0 F6 D8 1B C0 50 8B 45 F8 8B 40 60 50 8B 00 FF 50 20 E9 BA 00 00 00 8B 45 F8 8B 80 90 00 00 00 8B 55 F8 8B 92 84 00 00 00 3B C2 74 08 8A 52 44 E8 ?? ?? ?? ?? 8B 45 F8 8B 80 90 00 00 00 80 78 44 00 75 09 8B 45 F8 50 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 EB 7B 8B 45 F8 80 B8 95 00 00 00 00 74 1E 8B 45 F8 8B 80 84 00 00 00 8B 55 F8 3B 82 90 00 00 00 75 0A 8B 45 F8 E8 ?? ?? ?? ?? EB 51 55 E8 ?? ?? ?? ?? 59 8B 45 F8 E8 ?? ?? ?? ?? EB 40 55 E8 ?? ?? ?? ?? 59 8B 45 F8 80 B8 95 00 00 00 00 75 2D 8B 45 F8 E8 ?? ?? ?? ?? EB 23 55 E8 ?? ?? ?? ?? 59 8B 45 FC 83 78 0C FF 75 13 8B 45 FC C7 40 0C 01 00 00 00 EB 07 55 E8 ?? ?? ?? ?? 59 84 DB 74 2C 8B 45 F4 50 8B 45 FC 83 C0 0C 50 8B 45 FC 8B 40 08 50 8B 45 FC 8B 40 04 50 8B 45 FC 8B 00 50 57 8B 45 F8 8B 40 64 50 8B 00 FF 50 10 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "TActiveXControl.Get_BackColor"
		size = 65
		refs = "000e TActiveXControl.Get_BackColor 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 80 84 00 00 00 8B 40 54 8B 55 0C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TActiveXControl.Get_Caption"
		size = 98
		refs = "001b TActiveXControl.Get_Caption 002f TControl.GetText 003a @WStrFromLStr 004c @HandleAutoException 0054 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "TActiveXControl.Get_Text"
		size = 98
		refs = "001b TActiveXControl.Get_Text 002f TControl.GetText 003a @WStrFromLStr 004c @HandleAutoException 0054 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "TActiveXControl.Get_Enabled"
		size = 70
		refs = "000e TActiveXControl.Get_Enabled 0039 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 80 84 00 00 00 8A 40 45 F6 D8 1B C0 8B 55 0C 66 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TActiveXControl.Get_Font"
		size = 79
		refs = "0019 TActiveXControl.Get_Font 0030 GetOleFont 0042 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 0C 8B 83 84 00 00 00 8B 40 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "TActiveXControl.Get_ForeColor"
		size = 68
		refs = "000e TActiveXControl.Get_ForeColor 0037 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 80 84 00 00 00 8B 40 50 8B 40 14 8B 55 0C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "TActiveXControl.Get_HWnd"
		size = 67
		refs = "000e TActiveXControl.Get_HWnd 001f TWinControl.GetHandle 0036 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 8B 55 0C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "TActiveXControl.Get_TabStop"
		size = 73
		refs = "000e TActiveXControl.Get_TabStop 003c @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 80 84 00 00 00 8A 80 D4 00 00 00 F6 D8 1B C0 8B 55 0C 66 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "TActiveXControl.Set_BackColor"
		size = 65
		refs = "000e TActiveXControl.Set_BackColor 0022 TControl.SetColor 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 0C 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "TActiveXControl.Set_Caption"
		size = 87
		refs = "0010 TActiveXControl.Set_Caption 0021 @LStrFromWStr 002f TControl.SetText 0041 @HandleAutoException 0049 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 0C E8 ?? ?? ?? ?? 8B 55 FC 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "TActiveXControl.Set_Text"
		size = 87
		refs = "0010 TActiveXControl.Set_Text 0021 @LStrFromWStr 002f TControl.SetText 0041 @HandleAutoException 0049 @LStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 0C E8 ?? ?? ?? ?? 8B 55 FC 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TActiveXControl.Set_Enabled"
		size = 73
		refs = "000e TActiveXControl.Set_Enabled 002a TControl.SetEnabled 003c @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 66 8B 55 0C 66 F7 DA 1B D2 F7 DA 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TActiveXControl.Set_TabStop"
		size = 73
		refs = "000e TActiveXControl.Set_TabStop 002a TWinControl.SetTabStop 003c @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 66 8B 55 0C 66 F7 DA 1B D2 F7 DA 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TActiveXControl.Set_Font"
		size = 68
		refs = "000e TActiveXControl.Set_Font 0025 SetOleFont 0037 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 80 84 00 00 00 8B 40 50 8B 55 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "TActiveXControl.Set_ForeColor"
		size = 68
		refs = "000e TActiveXControl.Set_ForeColor 0025 TFont.SetColor 0037 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 80 84 00 00 00 8B 40 50 8B 55 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "TActiveXControl.GetClassID"
		size = 34
		altNames = "TActiveXControl.GetUserClassID"
	strings:
		$1 = { 55 8B EC 56 57 8B 45 08 8B 40 10 8B 55 0C 8D 70 1C 8B FA B9 04 00 00 00 F3 A5 33 C0 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "TActiveXControl.IsDirty"
		size = 28
	strings:
		$1 = { 55 8B EC 8B 45 08 80 B8 94 00 00 00 00 74 04 33 C0 EB 05 B8 01 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TActiveXControl.PersistStreamLoad"
		size = 78
		refs = "000d TActiveXControl.PersistStreamLoad 0035 @HandleAnyException 003a _NF__2F3 0041 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 0C 8B C3 8B 08 FF 51 38 C6 83 94 00 00 00 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "TActiveXControl.PersistStreamSave"
		size = 84
		refs = "000d TActiveXControl.PersistStreamSave 003b @HandleAnyException 0040 _NF__2F3 0047 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 0C 8B C6 8B 08 FF 51 40 83 7D 10 00 74 07 C6 86 94 00 00 00 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TActiveXControl.InitNew"
		size = 68
		refs = "000d TActiveXControl.InitNew 002b @HandleAnyException 0030 _NF__2F3 0037 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 C6 80 94 00 00 00 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TActiveXControl.PersistStorageInitNew"
		size = 16
		refs = "0008 TActiveXControl.InitNew"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "TActiveXControl.PersistStorageLoad"
		size = 200
		refs = "000f TActiveXControl.PersistStorageLoad 002b @IntfClear 0045 OleCheck 0067 @HandleAnyException 006c _NF__2F3 0073 @DoneExcept 008e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 10 6A 00 68 ?? ?? ?? ?? 8B 45 0C 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 8B 08 FF 51 38 C6 83 94 00 00 00 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 08 00 00 00 43 00 4F 00 4E 00 54 00 52 00 4F 00 4C 00 53 00 41 00 56 00 45 00 53 00 54 00 52 00 45 00 41 00 4D 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TActiveXControl.PersistStorageSave"
		size = 196
		refs = "000f TActiveXControl.PersistStorageSave 002b @IntfClear 0048 OleCheck 0063 @HandleAnyException 0068 _NF__2F3 006f @DoneExcept 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 68 11 10 00 00 68 ?? ?? ?? ?? 8B 45 0C 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 55 FC 8B C6 8B 08 FF 51 40 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 0C 00 00 00 43 00 4F 00 4E 00 54 00 52 00 4F 00 4C 00 53 00 41 00 56 00 45 00 53 00 54 00 52 00 45 00 41 00 4D 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "TActiveXControl.SaveCompleted"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 C6 80 94 00 00 00 00 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "TActiveXControl.SetClientSite"
		size = 204
		refs = "0022 @IntfCopy 002a @IntfClear 0030 TActiveXControl.SetClientSite 006c TActiveXControl.OnAmbientPropertyChange"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 0C 8B 5D 08 85 F6 74 63 83 7B 5C 00 74 07 B8 05 40 00 80 EB 78 8D 43 5C 8B D6 E8 ?? ?? ?? ?? 8D 43 60 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 8B 43 4C F6 40 66 01 74 13 8D 43 64 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 8D 43 68 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 8B 06 FF 10 6A 00 53 E8 ?? ?? ?? ?? EB 20 8D 43 68 E8 ?? ?? ?? ?? 8D 43 64 E8 ?? ?? ?? ?? 8D 43 60 E8 ?? ?? ?? ?? 8D 43 5C E8 ?? ?? ?? ?? 33 C0 5E 5B 5D C2 08 00 00 00 89 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 01 0E 2B 74 E6 14 1B 10 91 4E 00 AA 00 30 0C AB 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "TActiveXControl.GetClientSite"
		size = 36
		refs = "0019 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 45 0C 8B 53 5C E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "TActiveXControl.SetHostNames"
		size = 9
		altNames = "TDataSet.CurrToBCD _NF__248 _NF__366"
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 0C 00 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TActiveXControl.Close"
		size = 48
		refs = "0027 TActiveXControl.InPlaceDeactivate"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 7D 0C 01 74 18 80 BB 94 00 00 00 00 74 0F 83 7B 5C 00 74 09 8B 43 5C 50 8B 00 FF 50 0C 53 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TActiveXControl.GetMoniker"
		size = 23
		altNames = "_NF__34B"
	strings:
		$1 = { 55 8B EC 8B 45 14 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TActiveXControl.InitFromData"
		size = 12
		altNames = "_NF__25C"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "TActiveXControl.GetClipboardData"
		size = 23
		altNames = "TActiveXControl.GetDisplayString"
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 74 04 33 D2 89 10 B8 01 40 00 80 5D C2 0C 00 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TActiveXControl.DoVerb"
		size = 203
		refs = "0010 TActiveXControl.DoVerb 0050 TActiveXControl.InPlaceActivate 006e TControl.SetVisible 0079 TActiveXControl.ShowPropertyDialog 008d TStrings.IndexOfObject 00b2 @HandleAnyException 00b7 _NF__2F3 00be @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 0C 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 83 C0 07 83 F8 07 77 5D FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B D8 EB 4F 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D8 EB 42 8B 86 90 00 00 00 33 D2 E8 ?? ?? ?? ?? 33 DB EB 31 8B C6 E8 ?? ?? ?? ?? 33 DB EB 26 8B 46 4C 8B 80 80 00 00 00 8B D7 E8 ?? ?? ?? ?? 85 C0 7C 0D 8B D7 8B C6 8B 08 FF 51 3C 33 DB EB 05 BB 80 01 04 00 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 1C 00 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TActiveXControl.EnumVerbs"
		size = 44
		refs = "0016 @IntfClear 0023 OleRegEnumVerbs"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 45 0C E8 ?? ?? ?? ?? 50 8B 43 10 83 C0 1C 50 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TActiveXControl.GetUserType"
		size = 30
		refs = "0016 OleRegGetUserType"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 10 83 C0 1C 50 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TActiveXControl.SetExtent"
		size = 152
		refs = "0010 TActiveXControl.SetExtent 0026 OleError 0030 Screen 003e MulDiv 007f @HandleAnyException 0084 _NF__2F3 008b @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 10 8B 5D 08 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 7D 0C 01 74 0A B8 6B 00 04 80 E8 ?? ?? ?? ?? 68 EC 09 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 8B 06 50 E8 ?? ?? ?? ?? 8B F8 68 EC 09 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 8B 46 04 50 E8 ?? ?? ?? ?? 8B D0 8B 83 90 00 00 00 57 52 8B 48 34 8B 50 30 8B 18 FF 53 4C 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TActiveXControl.GetExtent"
		size = 99
		refs = "0019 Screen 0033 MulDiv"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 10 8B 5D 08 83 7D 0C 01 74 07 B8 6B 00 04 80 EB 45 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 68 EC 09 00 00 8B 83 90 00 00 00 8B 40 38 50 E8 ?? ?? ?? ?? 89 06 A1 ?? ?? ?? ?? 8B 00 8B 40 34 50 68 EC 09 00 00 8B 83 90 00 00 00 8B 40 3C 50 E8 ?? ?? ?? ?? 89 46 04 33 C0 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "TActiveXControl.Advise"
		size = 40
		refs = "000a _NF__395"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B C3 E8 ?? ?? ?? ?? 85 C0 75 11 8B 45 10 50 8B 45 0C 50 8B 43 78 50 8B 00 FF 50 0C 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TActiveXControl.Unadvise"
		size = 36
		refs = "000a _NF__395"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B C3 E8 ?? ?? ?? ?? 85 C0 75 0D 8B 45 0C 50 8B 43 78 50 8B 00 FF 50 10 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TActiveXControl.EnumAdvise"
		size = 52
		refs = "0015 _NF__395 0021 @IntfClear"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B C3 E8 ?? ?? ?? ?? 85 C0 75 12 8B 45 0C E8 ?? ?? ?? ?? 50 8B 43 78 50 8B 00 FF 50 14 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TActiveXControl.GetMiscStatus"
		size = 36
	strings:
		$1 = { 55 8B EC 8B 45 08 83 7D 0C 01 74 07 B8 6B 00 04 80 EB 0D 8B 40 4C 8B 40 64 8B 55 10 89 02 33 C0 5D C2 0C 00 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TActiveXControl.GetControlInfo"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 45 0C C7 00 10 00 00 00 33 D2 89 50 04 66 C7 40 08 00 00 33 D2 89 50 0C 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TActiveXControl.OnDocWindowActivate"
		size = 17
		refs = "0009 TActiveXControl.InPlaceActivate"
		altNames = "TActiveXControl.OnFrameWindowActivate TActiveXControl.OnMnemonic"
	strings:
		$1 = { 55 8B EC 8B 45 08 B2 01 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TActiveXControl.OnAmbientPropertyChange"
		size = 360
		refs = "0015 TActiveXControl.OnAmbientPropertyChange 0043 @IntfDispCall 0058 TControl.Perform 0076 _Dn_TFont 007b TFont.Create 00b7 TFont.SetColor 00d7 SetOleFont 00ff @HandleAnyException 0104 @DoneExcept 0119 TObject.Free 011f @HandleFinally 0138 @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C0 89 45 F8 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B B3 90 00 00 00 85 F6 0F 84 F8 00 00 00 83 7B 68 00 0F 84 EE 00 00 00 68 ?? ?? ?? ?? 8B 43 68 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 50 8B C6 B9 01 00 00 00 BA 09 B0 00 00 E8 ?? ?? ?? ?? 6A 01 8B 83 90 00 00 00 B9 01 00 00 00 BA 11 B0 00 00 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 ?? ?? ?? ?? 8B 43 68 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 8B 45 FC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 43 68 50 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 50 8B 83 90 00 00 00 B9 01 00 00 00 BA 08 B0 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 59 5D C2 08 00 00 43 FD FF FF 03 02 00 00 40 FD FF FF 03 02 00 00 41 FD FF FF 09 02 00 00 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TActiveXControl.FreezeEvents"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C F7 DA 1B D2 F7 DA 88 90 97 00 00 00 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TActiveXControl.GetWindow"
		size = 52
		refs = "000e TWinControl.HandleAllocated 001d TWinControl.GetHandle"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 14 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 8B 55 0C 89 02 33 C0 EB 05 B8 05 40 00 80 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "TActiveXControl.InPlaceDeactivate"
		size = 113
		refs = "0012 TActiveXControl.UIDeactivate 0026 TControl.SetVisible 002b _NF__2F2 0038 TWinControl.SetParentWindow 0040 @IntfClear"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 80 BB 95 00 00 00 00 74 4D 53 E8 ?? ?? ?? ?? C6 83 95 00 00 00 00 33 D2 8B 83 90 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 8D 43 74 E8 ?? ?? ?? ?? 8D 43 70 E8 ?? ?? ?? ?? 8B 43 6C 50 8B 00 FF 50 2C 8D 43 6C E8 ?? ?? ?? ?? 33 D2 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TActiveXControl.UIDeactivate"
		size = 73
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 80 BB 96 00 00 00 00 74 32 83 7B 74 00 74 0D 6A 00 6A 00 8B 43 74 50 8B 00 FF 50 20 6A 00 6A 00 8B 43 70 50 8B 00 FF 50 20 6A 00 8B 43 6C 50 8B 00 FF 50 28 C6 83 96 00 00 00 00 33 C0 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "TActiveXControl.SetObjectRects"
		size = 75
		refs = "000d TActiveXControl.SetObjectRects 0021 TControl.SetBoundsRect 0032 @HandleAnyException 0037 _NF__2F3 003e @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 0C 8B 80 90 00 00 00 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TActiveXControl.TranslateAccelerator"
		size = 348
		refs = "0026 FindControl 0034 GetParent 0065 TControl.Perform 00eb TranslateMessage 00f1 DispatchMessage 0109 GetParentForm 0137 _NF__309"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 0C 8B 43 04 3D 00 01 00 00 0F 8C 15 01 00 00 3D 08 01 00 00 0F 8F 0A 01 00 00 8B 03 E8 ?? ?? ?? ?? 8B F8 85 FF 75 1F 8B 33 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 09 8B C6 E8 ?? ?? ?? ?? 8B F8 85 F6 74 04 85 FF 74 E3 85 FF 0F 84 D6 00 00 00 33 F6 57 8B 4B 08 BA 2E B0 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 85 E1 00 00 00 33 C0 89 45 FC 8B 43 08 83 F8 1B 7F 13 74 32 83 E8 03 74 2D 83 E8 06 74 16 83 E8 04 74 23 EB 28 83 C0 DF 83 E8 08 72 10 83 E8 02 74 14 EB 19 C7 45 FC 02 00 00 00 EB 10 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 04 00 00 00 83 7D FC 00 74 38 6A 00 8B 4B 08 BA 1E B0 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 15 6A 00 33 C9 BA 87 00 00 00 8B C7 E8 ?? ?? ?? ?? 23 45 FC 74 0E 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? EB 5B 81 7B 04 00 01 00 00 75 11 83 7F 24 00 74 0B 8B C7 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 85 FF 74 16 8B 43 0C 50 8B 4B 08 BA 05 B0 00 00 8B C7 E8 ?? ?? ?? ?? 48 74 25 8B 45 08 83 78 60 00 74 17 E8 ?? ?? ?? ?? 50 53 8B 45 08 8B 40 60 50 8B 00 FF 50 1C 8B F0 EB 05 BE 01 00 00 00 8B C6 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "TActiveXControl.ResizeBorder"
		size = 9
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 10 00 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "TActiveXControl.EnableModeless"
		size = 9
		altNames = "TAdapterNotifier.OnRequestEdit TStreamAdapter.Commit _NF__26C _NF__320 _NF__32A _NF__34E _NF__357 _NF__36B _NF__36C _NF__373"
	strings:
		$1 = { 55 8B EC 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "TActiveXControl.Draw"
		size = 330
		refs = "000d TActiveXControl.Draw 0023 OleError 0047 TControl.SetVisible 0057 TWinControl.GetHandle 005d ShowWindow 007b LPtoDP 0084 SaveDC 00a4 SetViewportOrgEx 00b3 SetWindowOrgEx 00be SetMapMode 00d6 TWinControl.PaintTo 00f0 RestoreDC 00f6 @HandleFinally 012f @HandleAnyException 0134 _NF__2F3 013b @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 7D 0C 01 74 0A B8 6B 00 04 80 E8 ?? ?? ?? ?? 8B 45 08 8B 80 84 00 00 00 8A 50 44 88 55 FB 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 B2 01 E8 ?? ?? ?? ?? 6A 01 8B 45 08 8B 80 90 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 24 8B F0 8D 7D E8 B9 04 00 00 00 F3 A5 6A 02 8D 45 E8 50 8B 45 20 50 E8 ?? ?? ?? ?? 8B 45 20 50 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 6A 00 6A 00 8B 45 20 50 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 8B 45 20 50 E8 ?? ?? ?? ?? 6A 01 8B 45 20 50 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 45 08 8B 80 84 00 00 00 8B 4D E8 8B 55 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 8B 45 20 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 80 84 00 00 00 8A 55 FB E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C2 2C 00 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "TActiveXControl.GetColorSet"
		size = 12
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 1C 00 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "TActiveXControl.Freeze"
		size = 12
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 14 00 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "TActiveXControl.SetAdvise"
		size = 63
		refs = "0024 @IntfCopy 0034 _NF__3EE"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 F6 45 0C 01 75 07 B8 6B 00 04 80 EB 26 8B 45 10 89 83 80 00 00 00 8D 43 7C 8B 55 14 E8 ?? ?? ?? ?? F6 83 80 00 00 00 02 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "TActiveXControl.GetAdvise"
		size = 75
		refs = "003e @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 8B 75 0C 8B 5D 08 8B 45 14 85 C0 74 04 33 D2 89 10 85 F6 74 06 C7 06 01 00 00 00 85 FF 74 08 8B 83 80 00 00 00 89 07 8B 45 14 85 C0 74 0B 8B 45 14 8B 53 7C E8 ?? ?? ?? ?? 33 C0 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_610_0 {
	meta:
		name = "TActiveXControl.ViewObjectGetExtent"
		size = 24
		refs = "0010 TActiveXControl.GetExtent"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 18 52 8B 55 0C 52 50 E8 ?? ?? ?? ?? 5D C2 14 00 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "TActiveXControl.MapPropertyToPage"
		size = 40
		refs = "000e GUID_NULL"
	strings:
		$1 = { 55 8B EC 56 57 8B 45 10 85 C0 74 11 8B 15 ?? ?? ?? ?? 8B F2 8B F8 B9 04 00 00 00 F3 A5 B8 01 40 00 80 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule function_613_0 {
	meta:
		name = "TActiveXControl.GetPredefinedStrings"
		size = 455
		refs = "0015 TActiveXControl.GetPredefinedStrings 0077 _Dn_TStringList 007c TObject.Create 00ba _NF__2F6 00e7 _NF__2F8 0146 TObject.Free 014c @HandleFinally 015d @HandleAnyException 0179 _NF__2F7 0192 _NF__2F3 019a @DoneExcept 01af @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C0 89 45 E8 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F8 33 C0 89 45 F4 33 C0 89 45 EC 8B 45 10 85 C0 74 07 8B 45 14 85 C0 75 0C C7 45 FC 03 40 00 80 E9 56 01 00 00 8B 45 10 33 D2 89 10 8B 45 10 33 D2 89 50 04 8B 45 14 33 D2 89 10 8B 45 14 33 D2 89 50 04 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D F0 8B 55 0C 8B C3 8B 18 FF 53 2C 84 C0 0F 84 88 00 00 00 8B 45 F0 8B 10 FF 52 14 89 45 EC 8B 5D EC C1 E3 02 8B C3 E8 ?? ?? ?? ?? 89 45 F8 8B C3 E8 ?? ?? ?? ?? 89 45 F4 8B 75 EC 4E 85 F6 7C 32 46 33 DB 8D 4D E8 8B D3 8B 45 F0 8B 38 FF 57 0C 8B 45 E8 E8 ?? ?? ?? ?? 8B 55 F8 89 04 9A 8B D3 8B 45 F0 8B 08 FF 51 18 8B 55 F4 89 04 9A 43 4E 75 D1 8B 45 10 8B 55 EC 89 10 8B 45 10 8B 55 F8 89 50 04 8B 45 14 8B 55 EC 89 10 8B 45 14 8B 55 F4 89 50 04 33 C0 89 45 FC EB 07 C7 45 FC 01 40 00 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 EB 42 E9 ?? ?? ?? ?? 83 7D F8 00 74 1A 8B 75 EC 4E 85 F6 7C 12 46 33 DB 8B 45 F8 8B 04 98 E8 ?? ?? ?? ?? 43 4E 75 F1 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "TActiveXControl.GetPredefinedValue"
		size = 118
		refs = "0028 TActiveXControl.GetPredefinedValue 004a @VarCopy 0061 @VarClr 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 8B 5D 08 8B 45 14 8B 55 14 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 50 8B 4D 10 8B 55 0C 8B C3 8B 18 FF 53 30 8B 45 14 8D 55 F0 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "_NF__4F4"
		size = 34
	strings:
		$1 = { 53 56 57 8B 58 04 85 DB 74 11 8B 48 08 03 C9 8D 3C CB 8B F2 B9 04 00 00 00 F3 A5 FF 40 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "TActiveXControl.GetPages"
		size = 224
		refs = "0011 TActiveXControl.GetPages 001e _NV__4F2 0023 TObject.Create 003d _NF__4F4 0052 _NF__2F6 00a5 _NF__2F7 00ad TObject.Free 00b3 @HandleFinally 00c6 @HandleAnyException 00cb _NF__2F3 00d2 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 0C 8B 5D 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 50 68 ?? ?? ?? ?? 8B C3 8B 10 FF 52 20 8B 45 FC 8B 40 08 C1 E0 04 E8 ?? ?? ?? ?? 8B 55 FC 89 42 04 8B 45 FC 33 D2 89 50 08 8B 45 FC 50 68 ?? ?? ?? ?? 8B C3 8B 10 FF 52 20 8B 45 FC 8B 40 08 89 06 8B 45 FC 8B 40 04 89 46 04 8B 45 FC 33 D2 89 50 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E1 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TActiveXControl.PreMessageFilter"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 64 00 74 23 8B 55 20 52 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 64 50 8B 00 FF 50 0C EB 02 33 C0 5D C2 1C 00 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TActiveXControl.PostMessageFilter"
		size = 53
	strings:
		$1 = { 55 8B EC 8B 45 08 83 78 64 00 74 23 8B 55 20 52 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 64 50 8B 00 FF 50 10 EB 02 33 C0 5D C2 1C 00 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TActiveXControlFactory.Create"
		size = 332
		refs = "0016 @ClassCreate 0026 TActiveXControlFactory.Create 0045 TAutoObjectFactory.Create 0075 TTypedComObjectFactory.GetInterfaceTypeInfo 0080 @IntfCopy 0098 OleCheck 00bd _Dn_TStringList 00c2 TObject.Create 00d6 TActiveXControlFactory.AddVerb 00e0 @WStrFromLStr 010f @IntfClear 0115 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 8B 75 0C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 18 89 43 60 8B 45 1C 50 8B 45 14 50 6A 02 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 45 08 83 C8 01 83 C8 10 0D 80 00 00 00 0D 00 01 00 00 0D 00 00 02 00 89 43 64 8B 45 10 89 43 68 8D 4D F4 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 8D 43 6C E8 ?? ?? ?? ?? 83 7B 6C 00 74 30 8D 45 F8 50 8B 43 6C 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 45 F8 56 8B F0 8D 7B 70 B9 04 00 00 00 F3 A5 5E 8B 45 F8 50 8B 43 6C 50 8B 00 FF 50 4C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 80 00 00 00 B9 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 43 48 8B D6 E8 ?? ?? ?? ?? 85 F6 0F 95 C0 88 43 51 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 84 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 8B E5 5D C2 18 00 00 00 FF FF FF FF 0A 00 00 00 50 72 6F 70 65 72 74 69 65 73 00 00 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "TActiveXControlFactory.Destroy"
		size = 56
		refs = "000d TObject.Free 0024 TComObjectFactory.Destroy 002f @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 80 00 00 00 E8 ?? ?? ?? ?? 8B 86 84 00 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "TActiveXControlFactory.AddVerb"
		size = 16
	strings:
		$1 = { 53 8B 80 80 00 00 00 87 CA 8B 18 FF 53 38 5B C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "TActiveXControlFactory.GetLicenseFileName"
		size = 104
		refs = "000f TActiveXControlFactory.GetLicenseFileName 002f ChangeFileExt 0044 @LStrClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 43 14 8B 08 FF 51 0C 8B 45 FC 8B CE BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 2E 6C 69 63 00 00 00 00 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "TActiveXControlFactory.HasMachineLicense"
		size = 252
		refs = "0013 TActiveXControlFactory.HasMachineLicense 0077 @HandleAnyException 007e @DoneExcept 00a6 @WStrFromLStr 00df @WStrClr 00e7 @LStrClr 00ed @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B3 01 8B 45 FC 80 78 51 00 0F 84 A2 00 00 00 8B 45 FC 80 B8 88 00 00 00 00 75 4A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 FC 8B 08 FF 51 1C 8B 55 F8 8B 45 FC 8B 80 84 00 00 00 8B 08 FF 51 58 8B 45 FC C6 80 88 00 00 00 01 33 C0 5A 59 59 64 89 10 EB 0C E9 ?? ?? ?? ?? 33 DB E8 ?? ?? ?? ?? 84 DB 74 48 33 F6 33 DB EB 2C 8D 4D F8 8B 45 FC 8B 80 84 00 00 00 8B D6 8B 18 FF 53 0C 8B 55 F8 8D 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 08 FF 51 0C 8B D8 46 8B 45 FC 8B 80 84 00 00 00 8B 10 FF 52 14 3B F0 7D 04 84 DB 74 BE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "TActiveXControlFactory.UpdateRegistry"
		size = 852
		refs = "0017 TActiveXControlFactory.UpdateRegistry 0028 GUIDToString 0038 @LStrCat3 004c TTypedComObjectFactory.UpdateRegistry 006b CreateRegKey 0076 IntToStr 00c3 @LStrCatN 0151 @LStrCat 01e3 DeleteRegKey 0285 @LStrArrayClr 028d @LStrClr 0293 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8D 43 1C E8 ?? ?? ?? ?? 8B 4D F0 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7D FF 00 0F 84 56 01 00 00 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 B9 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8D 55 F0 8B 43 64 E8 ?? ?? ?? ?? 8B 45 F0 50 8D 45 EC B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 EC 33 D2 59 E8 ?? ?? ?? ?? 8D 55 EC 8B 43 14 8B 08 FF 51 0C FF 75 EC 68 ?? ?? ?? ?? 8D 55 E8 8B 43 68 E8 ?? ?? ?? ?? FF 75 E8 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 50 8D 45 EC B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 EC 33 D2 59 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 33 C9 33 D2 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 33 C9 33 D2 E8 ?? ?? ?? ?? 8B 83 80 00 00 00 8B 10 FF 52 14 48 85 C0 0F 8C 3D 01 00 00 40 89 45 F4 33 F6 8D 4D F0 8B D6 8B 83 80 00 00 00 8B 38 FF 57 0C 8D 45 F0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 50 FF 75 F8 68 ?? ?? ?? ?? 8B D6 8B 83 80 00 00 00 8B 08 FF 51 18 8D 55 E8 E8 ?? ?? ?? ?? FF 75 E8 8D 45 EC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 EC 33 D2 59 E8 ?? ?? ?? ?? 46 FF 4D F4 75 A1 E9 D3 00 00 00 8B 83 80 00 00 00 8B 10 FF 52 14 48 85 C0 7C 41 40 89 45 F4 33 F6 FF 75 F8 68 ?? ?? ?? ?? 8B D6 8B 83 80 00 00 00 8B 08 FF 51 18 8D 55 EC E8 ?? ?? ?? ?? FF 75 EC 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 46 FF 4D F4 75 C5 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 B9 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 FF FF FF FF 06 00 00 00 43 4C 53 49 44 5C 00 00 FF FF FF FF 0B 00 00 00 5C 4D 69 73 63 53 74 61 74 75 73 00 FF FF FF FF 01 00 00 00 30 00 00 00 FF FF FF FF 0D 00 00 00 5C 4D 69 73 63 53 74 61 74 75 73 5C 31 00 00 00 FF FF FF FF 01 00 00 00 2C 00 00 00 FF FF FF FF 10 00 00 00 5C 54 6F 6F 6C 62 6F 78 42 69 74 6D 61 70 33 32 00 00 00 00 FF FF FF FF 08 00 00 00 5C 43 6F 6E 74 72 6F 6C 00 00 00 00 FF FF FF FF 05 00 00 00 5C 56 65 72 62 00 00 00 FF FF FF FF 04 00 00 00 2C 30 2C 32 00 00 00 00 FF FF FF FF 06 00 00 00 5C 56 65 72 62 5C 00 00 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TActiveFormControl.DefinePropertyPages"
		size = 52
		refs = "0011 _DV_TActiveForm 0016 @IsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B D8 8B B3 84 00 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 10 FF 75 0C FF 75 08 8B C6 8B 10 FF 92 80 00 00 00 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TActiveFormControl.InitializeControl"
		size = 132
		refs = "000d TActiveFormControl.InitializeControl 001a TActiveXControl.InitializeControl 002c @IntfCast 0040 _DV_TActiveForm 0045 @AsClass 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D3 83 C2 04 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B B3 84 00 00 00 89 46 1C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 88 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 A0 92 78 E0 2F F5 CF 11 BD 2F 00 20 AF 0E 5B 81 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TActiveFormControl.Invoke"
		size = 70
	strings:
		$1 = { 55 8B EC 53 8B 55 18 8B 45 08 F6 C2 0C 74 04 66 BA 0C 00 8B 5D 28 53 8B 5D 24 53 8B 5D 20 53 8B 5D 1C 53 52 8B 55 0C 52 8B 48 10 8B 51 5C 8B 52 14 03 90 84 00 00 00 52 8B 41 58 50 8B 00 FF 50 2C 5B 5D C2 24 00 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TActiveFormControl.ObjQueryInterface"
		size = 62
		refs = "0020 TObject.GetInterface 002c TActiveXControl.ObjQueryInterface"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 10 8B 75 0C 8B 5D 08 33 C0 89 45 FC 8B CF 8B D6 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B 57 56 53 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TActiveFormControl.EventSinkChanged"
		size = 46
		refs = "0011 _DV_TActiveForm 0016 @IsClass"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B B3 84 00 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D7 8B C6 8B 08 FF 91 84 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TActiveForm.Create"
		size = 88
		refs = "000a @ClassCreate 001e TCustomForm.Create 0027 TCustomForm.SetBorderStyle 002d TActiveForm.Create 0034 TCustomForm.SetBorderIcons 003d TWinControl.SetTabStop"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 C6 86 DC 01 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 8A 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TActiveForm.SetAxBorderStyle"
		size = 26
		refs = "0015 TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 DC 01 00 00 74 11 88 90 DC 01 00 00 F6 40 20 10 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TActiveForm.CreateParams"
		size = 83
		refs = "000b TCustomForm.CreateParams"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? F6 43 20 10 75 3B 81 66 04 FF FF 3F FF 8A 83 DC 01 00 00 FE C8 74 0A FE C8 74 0F FE C8 74 14 EB 20 81 4E 04 00 00 80 00 EB 17 81 4E 08 00 02 00 00 EB 0E 81 4E 04 00 00 40 00 81 4E 08 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TActiveForm.WantChildKey"
		size = 59
		refs = "0029 TControl.Perform"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B 33 81 FE 02 01 00 00 75 06 83 7B 04 09 74 1E 8B 43 08 50 8B 4B 04 8B D6 81 C2 00 BC 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TActiveFormFactory.GetIntfEntry"
		size = 33
		refs = "0017 TObject.GetInterfaceEntry"
	strings:
		$1 = { 56 57 83 C4 F0 8B F2 8D 3C 24 B9 04 00 00 00 F3 A5 8B D4 8B 40 60 E8 ?? ?? ?? ?? 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "TPropertyPage.Modified"
		size = 18
		refs = "000d _NF__566"
	strings:
		$1 = { 8B 90 DC 01 00 00 85 D2 74 07 8B C2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "_NF__558"
		size = 141
		refs = "000f _NF__558 0031 OleCheck 0040 TStrings.IndexOfObject 004e @LStrFromWStr 0073 @LStrClr 007b @WStrClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 6A 00 6A 00 8D 45 FC 50 53 8B 45 08 8B 40 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B F3 8B D6 E8 ?? ?? ?? ?? 40 75 1B 8D 45 F8 8B 55 FC E8 ?? ?? ?? ?? 8B 55 F8 8B 45 08 8B 40 F8 8B CE 8B 18 FF 53 38 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "_NF__559"
		size = 261
		refs = "0015 _NF__559 0052 @IntfClear 0061 OleCheck 0091 IsEqualGUID 00d9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F8 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 00 66 8B 43 04 66 83 E8 1A 74 0B 66 83 E8 03 74 1B E9 A7 00 00 00 8B 45 08 50 8B 13 8B C6 E8 ?? ?? ?? ?? 59 88 45 FF E9 91 00 00 00 8D 45 F8 E8 ?? ?? ?? ?? 50 8B 03 50 56 8B 06 FF 50 38 E8 ?? ?? ?? ?? 8D 45 F4 50 8B 45 F8 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 83 C0 E8 50 8B 45 F4 50 E8 ?? ?? ?? ?? 88 45 FF 80 7D FF 00 75 1F 8B 45 F4 83 78 28 06 75 16 8B 45 08 50 8B 45 F4 8D 50 3C 8B 45 F8 E8 ?? ?? ?? ?? 59 88 45 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 00 FF 50 4C C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "_NF__55A"
		size = 148
		refs = "002f OleCheck 0037 _NF__55A 0059 @TryFinallyExit 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 89 4D F8 89 45 FC 4A 85 D2 7C 77 42 89 55 EC C7 45 F4 00 00 00 00 8D 45 F0 50 8B 45 F4 50 8B 45 FC 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 00 3B 45 F8 75 14 8B 45 F0 8B 40 10 23 45 08 74 09 B3 01 E8 ?? ?? ?? ?? EB 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 50 8B 45 FC 50 8B 00 FF 50 50 C3 E9 ?? ?? ?? ?? EB EB FF 45 F4 FF 4D EC 75 94 33 DB 8B C3 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_645_0 {
	meta:
		name = "TPropertyPage.EnumCtlProps"
		size = 644
		refs = "002b TPropertyPage.EnumCtlProps 003f @VarToIntf 004f @IntfCast 0057 @IntfClear 006a OleCheck 00eb _NF__559 00fb _NF__558 011c @HandleFinally 0184 _NF__55A"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 DB 89 5D CC 89 5D FC 89 5D E0 8B F2 8D 7D E8 51 B9 04 00 00 00 F3 A5 59 89 4D F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 CC 8D 93 E0 01 00 00 E8 ?? ?? ?? ?? 8B 55 CC 8D 45 E0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 8B 45 E0 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 83 7D FC 00 0F 84 C8 01 00 00 8D 45 DC 50 8B 45 FC 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 DC 0F B7 40 2E 48 85 C0 0F 8C 82 00 00 00 40 89 45 D0 C7 45 E4 00 00 00 00 8D 45 D4 50 8B 45 E4 50 8B 45 FC 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 D4 F6 40 1C 01 74 20 55 8B 45 D4 8D 50 0C 8B 45 FC E8 ?? ?? ?? ?? 59 84 C0 74 0C 55 8B 45 D4 8B 00 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 D4 50 8B 45 FC 50 8B 00 FF 50 54 C3 E9 ?? ?? ?? ?? EB EB FF 45 E4 FF 4D D0 75 89 8B 45 DC 0F B7 40 2C 48 85 C0 0F 8C E4 00 00 00 40 89 45 D0 C7 45 E4 00 00 00 00 8D 45 D8 50 8B 45 E4 50 8B 45 FC 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 D8 83 78 10 02 75 2E 6A 0C 8B 45 D8 8B 08 8B 45 DC 0F B7 50 2C 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 14 55 8B 45 D8 8D 50 20 8B 45 FC E8 ?? ?? ?? ?? 59 84 C0 75 44 8B 45 D8 F6 40 10 0C 74 47 6A 02 8B 45 D8 8B 08 8B 45 DC 0F B7 50 2C 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 2D 55 8B 45 D8 0F BF 40 18 03 C0 8B 55 D8 8B 52 08 8D 54 C2 F0 8B 45 FC E8 ?? ?? ?? ?? 59 84 C0 74 0C 55 8B 45 D8 8B 00 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 D8 50 8B 45 FC 50 8B 00 FF 50 50 C3 E9 ?? ?? ?? ?? EB EB FF 45 E4 FF 4D D0 0F 85 27 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 DC 50 8B 45 FC 50 8B 00 FF 50 4C C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_647_0 {
	meta:
		name = "TActiveXPropertyPage.Initialize"
		size = 50
		refs = "0021 TCustomForm.SetBorderStyle 002b TCustomForm.SetPosition"
	strings:
		$1 = { 53 56 8B D8 8B 43 10 8B 40 18 33 C9 B2 01 FF 50 24 8B F0 89 73 20 89 9E DC 01 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? 33 D2 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_648_0 {
	meta:
		name = "TActiveXPropertyPage.Destroy"
		size = 30
		refs = "000a TObject.Free 0015 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 20 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_649_0 {
	meta:
		name = "_NF__566"
		size = 28
	strings:
		$1 = { 80 78 28 00 74 15 C6 40 29 01 83 78 24 00 74 0B 6A 03 8B 40 24 50 8B 00 FF 50 0C C3 }
	condition:
		$1
}

rule function_650_0 {
	meta:
		name = "TActiveXPropertyPage.SetPageSite"
		size = 25
		refs = "000e @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8D 43 24 8B 55 0C E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "TActiveXPropertyPage.Activate"
		size = 119
		refs = "000d TActiveXPropertyPage.Activate 001e TControl.SetBoundsRect 0029 TWinControl.SetParentWindow 0036 VarIsNull 005e @HandleAnyException 0063 _NF__2F3 006a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 10 8B 43 20 E8 ?? ?? ?? ?? 8B 43 20 8B 55 0C E8 ?? ?? ?? ?? 8B 43 20 05 E0 01 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B 8B 43 20 8B 10 FF 92 84 00 00 00 C6 43 28 01 C6 43 29 00 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "TActiveXPropertyPage.Deactivate"
		size = 83
		refs = "000d TActiveXPropertyPage.Deactivate 001f TCustomForm.Hide 0029 TWinControl.SetParentWindow 003a @HandleAnyException 003f _NF__2F3 0046 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 43 28 00 8B 43 20 E8 ?? ?? ?? ?? 8B 43 20 33 D2 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "TActiveXPropertyPage.GetPageInfo"
		size = 165
		refs = "0012 TActiveXPropertyPage.GetPageInfo 0035 @FillChar 0040 TControl.GetText 0048 _NF__2F8 006e @HandleAnyException 0073 _NF__2F3 007a @DoneExcept 008f @LStrClr 0095 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 75 0C 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 04 33 C9 BA 18 00 00 00 E8 ?? ?? ?? ?? 8D 55 FC 8B 43 20 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 46 04 8B 43 20 8B 40 38 89 46 08 8B 43 20 8B 40 3C 89 46 0C 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "TActiveXPropertyPage.SetObjects"
		size = 184
		refs = "000f TActiveXPropertyPage.SetObjects 0032 Null 0037 @VarCopy 004f @IntfCast 005d @VarFromDisp 006e @HandleAnyException 0073 _NF__2F3 007a @DoneExcept 008f @IntfClear 0095 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 20 8D 86 E0 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D 0C 00 7E 20 8D 45 FC 8B 55 10 8B 12 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8D 86 E0 01 00 00 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C2 0C 00 00 00 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_655_0 {
	meta:
		name = "TActiveXPropertyPage.Show"
		size = 76
		refs = "000d TActiveXPropertyPage.Show 0022 TCustomForm.SetVisible 0033 @HandleAnyException 0038 _NF__2F3 003f @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 7D 0C 00 0F 95 C2 8B 40 20 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "TActiveXPropertyPage.Move"
		size = 72
		refs = "000d TActiveXPropertyPage.Move 001e TControl.SetBoundsRect 002f @HandleAnyException 0034 _NF__2F3 003b @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 0C 8B 40 20 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_657_0 {
	meta:
		name = "TActiveXPropertyPage.IsPageDirty"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 45 08 80 78 29 00 74 04 33 C0 EB 05 B8 01 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "_NF__580"
		size = 324
		refs = "0012 TConnectData 0017 @InitializeRecord 001f _NF__580 003c @VarToIntf 0044 @IntfClear 0088 OleCheck 009c @IntfCast 00bf @FinalizeRecord 0118 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 51 8D 45 E8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 08 8B 52 08 8B 52 20 81 C2 E0 01 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 10 85 C0 75 79 8D 45 F4 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 10 85 C0 75 5E 8D 45 F0 E8 ?? ?? ?? ?? 50 8B 45 F4 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? EB 23 6A FF 8D 45 E0 8B 55 E8 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 50 8B 00 FF 50 0C 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 E4 50 8B 15 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 50 6A 01 8B 45 F0 50 8B 00 FF 50 0C 85 C0 74 BB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C2 8B E5 5D C3 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_659_0 {
	meta:
		name = "TActiveXPropertyPage.Apply"
		size = 86
		refs = "000a TActiveXPropertyPage.Apply 002b _NF__580 003d @HandleAnyException 0042 _NF__2F3 0049 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 20 8B 10 FF 92 80 00 00 00 8B 45 08 C6 40 29 00 55 E8 ?? ?? ?? ?? 59 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_661_0 {
	meta:
		name = "TActiveXPropertyPage.TranslateAccelerator"
		size = 113
		refs = "000d TActiveXPropertyPage.TranslateAccelerator 0029 TWinControl.GetHandle 002f GetWindowLong 0044 SetWindowLong 0058 @HandleAnyException 005d _NF__2F3 0064 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 20 83 BE CC 00 00 00 00 74 25 6A EC 8B 43 20 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 0D 00 00 01 00 50 6A EC 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? BB 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_663_0 {
	meta:
		name = "TActiveXPropertyPageFactory.Create"
		size = 208
		refs = "0019 @ClassCreate 002b TActiveXPropertyPageFactory.Create 0049 TObject.ClassName 0065 Format 0076 TComObjectFactory.Create 008b @LStrClr 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 56 57 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F9 88 55 FF 8B D8 8B 75 0C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8B 45 08 50 6A 00 8D 45 F8 50 8D 95 F0 FE FF FF 8B C6 E8 ?? ?? ?? ?? 8D 85 F0 FE FF FF 89 45 F0 C6 45 F4 04 8D 55 F0 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 6A 02 8B CF 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 8B E5 5D C2 08 00 00 00 FF FF FF FF 10 00 00 00 25 73 20 70 72 6F 70 65 72 74 79 20 70 61 67 65 00 00 00 00 }
	condition:
		$1
}

rule function_664_0 {
	meta:
		name = "TActiveXPropertyPageFactory.CreateComObject"
		size = 16
		refs = "0004 _DV_TActiveXPropertyPage 000b TComObject.CreateFromFactory"
	strings:
		$1 = { 52 8B C8 A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15678_0 {
	meta:
		name = "TComponentFactory.CreateComObject"
		size = 16
		refs = "0004 _NV__54 000b TComObject.CreateFromFactory"
	strings:
		$1 = { 52 8B C8 A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_665_0 {
	meta:
		name = "TCustomAdapter.Create"
		size = 64
		refs = "000a @ClassCreate 0017 _DV_TAdapterNotifier 001c TAdapterNotifier.Create 0029 @IntfCopy"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 04 8D 46 14 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "TCustomAdapter.Destroy"
		size = 29
		refs = "0009 TCustomAdapter.ReleaseOleObject 0014 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1511_0 {
	meta:
		name = "TList.Destroy"
		size = 29
		refs = "0009 TList.Clear 0014 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4734_0 {
	meta:
		name = "TPaintControl.Destroy"
		size = 29
		refs = "0009 TPaintControl.DestroyHandle 0014 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "TCustomAdapter.Changed"
		size = 12
		refs = "0007 TCustomAdapter.ReleaseOleObject"
	strings:
		$1 = { 80 78 18 00 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "TCustomAdapter.ConnectOleObject"
		size = 132
		refs = "000e @IntfAddRef 0016 TCustomAdapter.ConnectOleObject 0029 TCustomAdapter.ReleaseOleObject 0043 _NF__2F9 004e @IntfCopy 0063 @IntfClear 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 0C 00 74 07 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 14 8D 43 10 50 BA ?? ?? ?? ?? 8B 4B 14 8B 45 FC E8 ?? ?? ?? ?? 8D 43 0C 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "TCustomAdapter.ReleaseOleObject"
		size = 48
		refs = "0007 TCustomAdapter.ReleaseOleObject 000f _NF__2FA 0017 @IntfClear"
	strings:
		$1 = { 53 8B D8 8D 4B 10 BA ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 8D 43 0C E8 ?? ?? ?? ?? 5B C3 00 00 00 02 BC FB 9B F1 EF 1A 10 84 ED 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "TAdapterNotifier.Create"
		size = 30
		refs = "0008 @ClassCreate"
		altNames = "_NF__21E"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 10 84 D2 74 0A 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "TAdapterNotifier.OnChanged"
		size = 69
		refs = "000d TAdapterNotifier.OnChanged 002c @HandleAnyException 0031 _NF__2F3 0038 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 40 10 8B 10 FF 52 04 33 DB 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TFontAdapter.Create"
		size = 53
		refs = "000b @ClassCreate 001a TCustomAdapter.Create"
		altNames = "TPictureAdapter.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 24 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "TFontAdapter.Update"
		size = 456
		refs = "0019 TFontAdapter.Update 003f @IntfCast 0047 @WStrClr 00d0 _Dn_TFont 00d5 TFont.Create 0106 @LStrFromWStr 0111 TFont.SetName 0121 @ROUND 012b TFont.SetSize 0135 TFont.SetStyle 0140 TFont.SetCharset 016a TObject.Free 0170 @HandleFinally 0187 @LStrClr 018f @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 33 D2 89 55 DC 89 55 F4 89 55 E0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 78 18 00 0F 85 46 01 00 00 8D 45 E0 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 50 8B 45 E0 50 8B 00 FF 50 0C 8D 45 EC 50 8B 45 E0 50 8B 00 FF 50 14 8A 1D ?? ?? ?? ?? 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 1C 83 7D E8 00 74 03 80 CB 01 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 24 83 7D E8 00 74 03 80 CB 02 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 2C 83 7D E8 00 74 03 80 CB 04 8D 45 E8 50 8B 45 E0 50 8B 00 FF 50 34 83 7D E8 00 74 03 80 CB 08 8D 45 E6 50 8B 45 E0 50 8B 00 FF 50 44 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC C6 40 18 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 50 24 8B 45 F8 8B 08 FF 51 08 8D 45 DC 8B 55 F4 E8 ?? ?? ?? ?? 8B 55 DC 8B 45 F8 E8 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? DF 6D EC DE C9 E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 8A 55 E6 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 24 8B 55 F8 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 18 00 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5B 8B E5 5D C3 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB 00 00 00 00 2C 65 19 E2 58 17 B7 D1 F1 3F 00 00 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TFontAdapter.Changed"
		size = 400
		refs = "0011 TFontAdapter.Changed 004c @IntfCast 005a TFont.GetName 0065 @WStrFromLStr 007d TFont.GetSize 00a4 TFont.GetStyle 011c TFont.GetCharset 0145 @HandleFinally 015c @LStrClr 0164 @WStrClr 016c @IntfClear"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 78 18 00 0F 85 23 01 00 00 8B 45 FC C6 40 18 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 F0 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 00 FF 50 10 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? 89 45 EC DB 45 EC D8 0D ?? ?? ?? ?? 83 C4 F8 DF 3C 24 9B 8B 45 F8 50 8B 00 FF 50 18 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? A8 01 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 20 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? A8 02 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 28 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? A8 04 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 30 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? A8 08 0F 95 C0 F6 D8 1B C0 50 8B 45 F8 50 8B 00 FF 50 38 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? 25 FF 00 00 00 50 8B 45 F8 50 8B 00 FF 50 48 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 18 00 C3 E9 ?? ?? ?? ?? EB F1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B E5 5D C3 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB 00 40 1C 46 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "TFontAdapter.GetOleFont"
		size = 356
		refs = "001b TFontAdapter.GetOleFont 0036 TFont.GetName 0041 @WStrFromLStr 0050 @WStrToPWChar 005b TFont.GetSize 0073 TFont.GetStyle 008d TFont.GetCharset 00da @IntfClear 00e9 _NF__634 00ee OleCheck 00f8 TCustomAdapter.ConnectOleObject 0107 @IntfCast 011c @LStrClr 012c @WStrClr 0132 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 33 C9 89 4D D4 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 0C 00 0F 85 CD 00 00 00 8D 55 D4 8B 43 24 E8 ?? ?? ?? ?? 8B 55 D4 8D 45 FC E8 ?? ?? ?? ?? C7 45 D8 20 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 89 45 DC 8B 43 24 E8 ?? ?? ?? ?? 89 45 D0 DB 45 D0 D8 0D ?? ?? ?? ?? DF 7D E0 9B 8B 43 24 E8 ?? ?? ?? ?? A8 01 74 08 66 C7 45 E8 BC 02 EB 06 66 C7 45 E8 90 01 8B 43 24 E8 ?? ?? ?? ?? 25 FF 00 00 00 66 89 45 EA 8B 43 24 E8 ?? ?? ?? ?? A8 02 0F 95 C0 F6 D8 1B C0 89 45 EC 8B 43 24 E8 ?? ?? ?? ?? A8 04 0F 95 C0 F6 D8 1B C0 89 45 F0 8B 43 24 E8 ?? ?? ?? ?? A8 08 0F 95 C0 F6 D8 1B C0 89 45 F4 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 53 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 00 40 1C 46 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB 03 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TFontAdapter.SetOleFont"
		size = 108
		refs = "000f TFontAdapter.SetOleFont 0024 @IntfCast 002e TCustomAdapter.ConnectOleObject 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 02 E0 F6 BE 74 A8 1A 10 8B BA 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "TPictureAdapter.Update"
		size = 140
		refs = "0013 _DV_TOleGraphic 0018 TGraphic.Create 0023 TPictureAdapter.Update 003f @IntfCast 004d TPicture.SetGraphic 0069 TObject.Free 006f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC C6 40 18 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 83 C0 18 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 40 24 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 18 00 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E9 59 59 5D C3 00 00 00 80 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "TPictureAdapter.GetOlePicture"
		size = 564
		refs = "0033 _Dn_TBitmap 0038 @IsClass 004f TBitmap.Create 005a TPictureAdapter.GetOlePicture 0079 TBitmap.ReleaseHandle 0084 TBitmap.ReleasePalette 00a0 TObject.Free 00a6 @HandleFinally 00b0 _Dn_TIcon 00c7 TPicture.GetIcon 00cc TIcon.GetHandle 00e3 _Dn_TMetafile 00fc TMetafile.Create 0118 TPicture.GetWidth 012d TPicture.GetHeight 0143 _Dn_TMetafileCanvas 0148 TMetafileCanvas.Create 016f TCanvas.Draw 0194 TMetafile.ReleaseHandle 01bf TPicture.GetMetafile 01c4 TMetafile.GetHandle 01cf @IntfClear 01e4 _NF__635 01e9 OleCheck 01f6 TCustomAdapter.ConnectOleObject 0209 @IntfCast"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 89 55 F8 89 45 FC 8B 45 FC 83 78 0C 00 0F 85 DF 01 00 00 C6 45 F7 00 C7 45 D4 14 00 00 00 8B 45 FC 8B 70 24 8B 5E 04 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 6C C7 45 D8 01 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 24 8B 50 04 8B 45 EC 8B 08 FF 51 08 8B 45 EC E8 ?? ?? ?? ?? 89 45 DC 8B 45 EC E8 ?? ?? ?? ?? 89 45 E0 C6 45 F7 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1B C7 45 D8 03 00 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 DC E9 F3 00 00 00 C7 45 D8 04 00 00 00 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 85 C8 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 FC 8B 40 24 E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 34 6A 00 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 24 8B 40 04 50 33 C9 33 D2 8B 45 E8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F0 E8 ?? ?? ?? ?? 89 45 DC C6 45 F7 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 DC 8B 45 F8 E8 ?? ?? ?? ?? 50 8A 45 F7 F6 D8 1B C9 BA ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 12 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 8B 52 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 00 80 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB 81 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "TPictureAdapter.SetOlePicture"
		size = 19
		refs = "0006 TCustomAdapter.ConnectOleObject"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 04 5B C3 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "TOleGraphic.Assign"
		size = 49
		refs = "000a _DV_TOleGraphic 000f @IsClass 001e @IntfCopy 002a TPersistent.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8D 43 18 8B 56 18 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "TOleGraphic.Draw"
		size = 271
		refs = "001f TCanvas.Lock 0027 TOleGraphic.Draw 0035 TCanvas.GetHandle 0051 SelectPalette 0059 RealizePalette 008c PlayEnhMetaFile 0099 TOleGraphic.GetMMHeight 00a3 TOleGraphic.GetMMWidth 00d8 OleCheck 00fc TCanvas.Unlock 0102 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 4D F8 89 55 FC 8B D8 83 7B 18 00 0F 84 ED 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8B C3 8B 10 FF 52 24 8B F8 C6 45 F7 00 85 FF 74 15 6A FF 57 56 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? C6 45 F7 01 8D 45 F4 50 8B 43 18 50 8B 00 FF 50 14 66 83 7D F4 04 75 1D 8D 45 F0 50 8B 43 18 50 8B 00 FF 50 0C 8B 45 F8 50 8B 45 F0 50 56 E8 ?? ?? ?? ?? EB 4A 8B 45 F8 50 8B C3 E8 ?? ?? ?? ?? F7 D8 50 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 6A 00 8B 45 F8 8B 40 0C 50 8B 45 F8 8B 40 08 50 8B 45 F8 8B 40 04 50 8B 45 F8 8B 00 50 56 8B 43 18 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 80 7D F7 00 74 09 6A FF 57 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "TOleGraphic.GetEmpty"
		size = 41
	strings:
		$1 = { 53 51 8B D8 83 7B 18 00 74 1A 54 8B 43 18 50 8B 00 FF 50 14 85 C0 75 0C 66 83 3C 24 00 7E 05 33 C0 5A 5B C3 B0 01 5A 5B C3 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "_NF__5D2"
		size = 70
		refs = "0012 GetDC 001c SetMapMode 0034 LPtoDP 003c ReleaseDC"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F0 8D 3C 24 A5 A5 8B DA 6A 00 E8 ?? ?? ?? ?? 8B F0 6A 03 56 E8 ?? ?? ?? ?? 8B 04 24 89 03 8B 44 24 04 89 43 04 F7 5B 04 6A 01 53 56 E8 ?? ?? ?? ?? 56 6A 00 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "TOleGraphic.GetHeight"
		size = 46
		refs = "0009 TOleGraphic.GetMMHeight 0016 Point 0021 _NF__5D2"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8D 4C 24 08 33 C0 E8 ?? ?? ?? ?? 8D 44 24 08 8B D4 E8 ?? ?? ?? ?? 8B 44 24 04 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TOleGraphic.GetMMHeight"
		size = 27
	strings:
		$1 = { 51 33 D2 89 14 24 83 78 18 00 74 0A 54 8B 40 18 50 8B 00 FF 50 1C 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TOleGraphic.GetMMWidth"
		size = 27
	strings:
		$1 = { 51 33 D2 89 14 24 83 78 18 00 74 0A 54 8B 40 18 50 8B 00 FF 50 18 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TOleGraphic.GetPalette"
		size = 27
	strings:
		$1 = { 51 33 D2 89 14 24 83 78 18 00 74 0A 54 8B 40 18 50 8B 00 FF 50 10 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TOleGraphic.GetTransparent"
		size = 30
	strings:
		$1 = { 51 33 D2 83 78 18 00 74 11 54 8B 40 18 50 8B 00 FF 50 40 F6 04 24 02 0F 95 C2 8B C2 5A C3 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "TOleGraphic.GetWidth"
		size = 43
		refs = "0009 TOleGraphic.GetMMWidth 0014 Point 001f _NF__5D2"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 4C 24 08 33 D2 E8 ?? ?? ?? ?? 8D 44 24 08 8B D4 E8 ?? ?? ?? ?? 8B 04 24 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "_NF__5DF"
		size = 24
		refs = "0008 _Dn_EInvalidGraphicOperation 000d Exception.Create 0012 @RaiseExcept"
		altNames = "_NF__D6"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3863_0 {
	meta:
		name = "DatabaseError"
		size = 24
		refs = "0008 _DV_EDatabaseError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5533_0 {
	meta:
		name = "DbiError"
		size = 24
		refs = "0008 _DV_EDBEngineError 000d EDBEngineError.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9436_0 {
	meta:
		name = "_NF__10D"
		size = 24
		refs = "0008 _DV_EMenuError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7945_0 {
	meta:
		name = "_NF__21A"
		size = 24
		refs = "0008 _DV_EInvalidGridOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14477_0 {
	meta:
		name = "_NF__287"
		size = 24
		refs = "0008 _DV_EConvertError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5121_0 {
	meta:
		name = "_NF__2B9"
		size = 24
		refs = "0008 _Dn_EInvalidGridOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9364_0 {
	meta:
		name = "_NF__3F"
		size = 24
		refs = "0008 _DV_EInvalidArgument 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7715_0 {
	meta:
		name = "_NF__404"
		size = 24
		refs = "0008 _DV_EInvalidGraphicOperation 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7716_0 {
	meta:
		name = "_NF__405"
		size = 24
		refs = "0008 _DV_EInvalidGraphic 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1709_0 {
	meta:
		name = "_NF__4D1"
		size = 24
		refs = "0008 _DV_EReadError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2148_0 {
	meta:
		name = "_NF__81C"
		size = 24
		refs = "0008 _DV_ETreeViewError 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12111_0 {
	meta:
		name = "_NF__AB"
		size = 24
		refs = "0008 _DV_EPrinter 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6068_0 {
	meta:
		name = "_NF__C7"
		size = 24
		refs = "0008 _Dn_Exception 000d Exception.Create 0012 @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_694_0 {
	meta:
		name = "TOleGraphic.SetHeight"
		size = 72
		refs = "0009 TOleGraphic.SetHeight 0017 SOleGraphic 001c LoadResString 0024 _NF__5DF 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_7931_0 {
	meta:
		name = "TIcon.SetHeight"
		size = 72
		refs = "0009 TIcon.SetHeight 0017 SChangeIconSize 001c LoadResString 0024 _NF__404 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_7932_0 {
	meta:
		name = "TIcon.SetWidth"
		size = 72
		refs = "0009 TIcon.SetWidth 0017 SChangeIconSize 001c LoadResString 0024 _NF__404 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9132_0 {
	meta:
		name = "TJPEGImage.SetHeight"
		size = 72
		refs = "0009 TJPEGImage.SetHeight 0017 sChangeJPGSize 001c LoadResString 0024 _NF__D6 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9138_0 {
	meta:
		name = "TJPEGImage.SetWidth"
		size = 72
		refs = "0009 TJPEGImage.SetWidth 0017 sChangeJPGSize 001c LoadResString 0024 _NF__D6 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_696_0 {
	meta:
		name = "TOleGraphic.SetWidth"
		size = 72
		refs = "0009 TOleGraphic.SetWidth 0017 SOleGraphic 001c LoadResString 0024 _NF__5DF 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8214_0 {
	meta:
		name = "TStringGridStrings.Delete"
		size = 72
		refs = "0009 TStringGridStrings.Delete 0017 SInvalidStringGridOp 001c LoadResString 0024 _NF__21A 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9437_0 {
	meta:
		name = "_NF__10E"
		size = 72
		refs = "0009 _NF__10E 0017 SMenuIndexError 001c LoadResString 0024 _NF__10D 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_7717_0 {
	meta:
		name = "_NF__406"
		size = 72
		refs = "0009 _NF__406 0017 SInvalidBitmap 001c LoadResString 0024 _NF__405 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_7718_0 {
	meta:
		name = "_NF__407"
		size = 72
		refs = "0009 _NF__407 0017 SInvalidIcon 001c LoadResString 0024 _NF__405 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_7719_0 {
	meta:
		name = "_NF__408"
		size = 72
		refs = "0009 _NF__408 0017 SInvalidMetafile 001c LoadResString 0024 _NF__405 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1710_0 {
	meta:
		name = "_NF__4D2"
		size = 72
		refs = "0009 _NF__4D2 0017 SInvalidPropertyValue 001c LoadResString 0024 _NF__4D1 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1711_0 {
	meta:
		name = "_NF__4D3"
		size = 72
		refs = "0009 _NF__4D3 0017 SUnknownProperty 001c LoadResString 0024 _NF__4D1 0039 @LStrClr 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_695_0 {
	meta:
		name = "TOleGraphic.SetPalette"
		size = 30
		refs = "0017 OleCheck"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 18 00 74 0F 56 8B 43 18 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "TOleGraphic.LoadFromStream"
		size = 72
		refs = "0007 TOleGraphic.LoadFromStream 000f @IntfClear 0019 _Dn_TStreamAdapter 001e TStreamAdapter.Create 002b _NF__636 0030 OleCheck"
	strings:
		$1 = { 53 56 8B F2 8B D8 68 ?? ?? ?? ?? 8D 43 18 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 0C 83 C9 FF 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 80 09 F8 7B 32 BF 1A 10 8B BB 00 AA 00 30 0C AB }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "TOleGraphic.SaveToStream"
		size = 128
		refs = "000f TOleGraphic.SaveToStream 0020 _Dn_TStreamAdapter 0025 TStreamAdapter.Create 0039 @IntfCast 0047 OleCheck 005c @IntfClear 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A FF 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 0C 50 8D 45 FC 8B 53 18 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 09 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TOleGraphic.LoadFromClipboardFormat"
		size = 76
		refs = "000a TOleGraphic.LoadFromClipboardFormat 0018 SOleGraphic 001d LoadResString 0025 _NF__5DF 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_7934_0 {
	meta:
		name = "TIcon.LoadFromClipboardFormat"
		size = 76
		refs = "000a TIcon.LoadFromClipboardFormat 0018 SIconToClipboard 001d LoadResString 0025 _NF__404 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_7935_0 {
	meta:
		name = "TIcon.SaveToClipboardFormat"
		size = 76
		refs = "000a TIcon.SaveToClipboardFormat 0018 SIconToClipboard 001d LoadResString 0025 _NF__404 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "TOleGraphic.SaveToClipboardFormat"
		size = 76
		refs = "000a TOleGraphic.SaveToClipboardFormat 0018 SOleGraphic 001d LoadResString 0025 _NF__5DF 003a @LStrClr 0040 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "_NF__5FC"
		size = 132
		refs = "0007 _NF__600 0011 _NF__601 001b _NF__602 0025 _NF__603 003c TAggregatedObject._AddRef 0046 TAggregatedObject._Release 004c _NF__5FC"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 8B 44 24 04 8B 00 FF 20 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 01 01 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "_NF__5FF"
		size = 62
		refs = "000b @ClassCreate 001c TAggregatedObject.Create 0026 @IntfCopy"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8D 47 14 8B D6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "_NF__600"
		size = 193
		refs = "0018 _NF__600 002a @VarClr 003a @CheckAutoResult 0045 @VarToWStr 004d @WStrToPWChar 00aa @WStrClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 8B 7D 0C 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB EB 35 8D 45 EC E8 ?? ?? ?? ?? 50 53 8B 46 14 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 10 89 04 9A 43 FF 46 10 3B FB 7E 1A 8D 45 E8 50 8B 46 14 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 E8 3B 46 10 7F AD 83 7D 14 00 74 05 8B 45 14 89 18 3B FB 75 04 33 DB EB 05 BB 01 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_705_0 {
	meta:
		name = "_NF__601"
		size = 85
		refs = "001a @CheckAutoResult"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 0C 8B 5D 08 8D 45 FC 50 8B 43 14 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 FC 8B 53 10 03 D6 3B C2 7C 07 01 73 10 33 C0 EB 1D 8D 45 FC 50 8B 43 14 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 FC 89 43 10 B8 01 00 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "_NF__602"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 89 50 10 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "_NF__603"
		size = 50
		refs = "001a _NF__5FF 0027 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8B 4B 14 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D0 83 C2 0C 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "TStringsAdapter.Create"
		size = 160
		refs = "0010 @ClassCreate 001e TStringsAdapter.Create 002c @IntfClear 0038 LIBID_StdVCL 003e LoadRegTypeLib 0043 OleCheck 0054 TAutoIntfObject.Create 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 6A 00 6A 00 6A 01 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D FC 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 34 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C3 00 00 E2 DF 05 EE 49 55 D0 11 9E A9 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "TStringsAdapter.ReferenceStrings"
		size = 4
	strings:
		$1 = { 89 50 34 C3 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "TStringsAdapter.ReleaseStrings"
		size = 6
	strings:
		$1 = { 33 D2 89 50 34 C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "TStringsAdapter.Get_ControlDefault"
		size = 98
		refs = "0025 TStringsAdapter.Get_ControlDefault 0033 @VarClr 003e TStringsAdapter.Get_Item 0043 @CheckAutoResult 0055 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 10 8B 55 10 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 10 E8 ?? ?? ?? ?? 50 8B 45 0C 50 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "TStringsAdapter.Set_ControlDefault"
		size = 94
		refs = "000d @VarAddRef 0016 TStringsAdapter.Set_ControlDefault 0032 TStringsAdapter.Set_Item 0037 @CheckAutoResult 0049 @HandleAutoException 0051 @VarClr"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8D 45 10 E8 ?? ?? ?? ?? 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 8B 45 0C 50 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "TStringsAdapter.Count"
		size = 74
		refs = "0011 TStringsAdapter.Count 003d @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 0C 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 06 8B 7B 34 85 FF 74 09 8B C7 8B 10 FF 52 14 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "TStringsAdapter.Get_Item"
		size = 152
		refs = "0029 TStringsAdapter.Get_Item 0038 Null 003d @OleVarFromVar 005c @WStrFromLStr 0067 @VarFromWStr 0079 @HandleAutoException 0081 @LStrClr 0089 @WStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B 5D 08 8B 45 10 8B 55 10 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 73 34 85 F6 74 23 8D 4D F8 8B 55 0C 8B C6 8B 18 FF 53 0C 8B 55 F8 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "TStringsAdapter.Set_Item"
		size = 109
		refs = "000f @VarAddRef 0018 TStringsAdapter.Set_Item 0030 @VarToLStr 004f @HandleAutoException 0057 @LStrClr 005f @VarClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 5D 08 8D 45 10 E8 ?? ?? ?? ?? 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 34 85 F6 74 18 8D 45 FC 8D 55 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 55 0C 8B C6 8B 18 FF 53 20 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 18 00 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "TStringsAdapter.Remove"
		size = 68
		refs = "000e TStringsAdapter.Remove 0037 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 70 34 85 F6 74 0A 8B 55 0C 8B C6 8B 08 FF 51 44 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "TStringsAdapter.Clear"
		size = 65
		refs = "000e TStringsAdapter.Clear 0034 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 50 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 70 34 85 F6 74 07 8B C6 8B 10 FF 52 40 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "TStringsAdapter.Add"
		size = 117
		refs = "0012 @VarAddRef 001b TStringsAdapter.Add 0039 @VarToLStr 0057 @HandleAutoException 005f @LStrClr 0067 @VarClr"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B 75 1C 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 06 FF FF FF FF 8B 7B 34 85 FF 74 17 8D 45 FC 8D 55 0C E8 ?? ?? ?? ?? 8B 55 FC 8B C7 8B 08 FF 51 34 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 18 00 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "TStringsAdapter._NewEnum"
		size = 92
		refs = "0019 TStringsAdapter._NewEnum 002b _NV__5FD 0030 _NF__5FF 003d @IntfCopy 004f @HandleAutoException"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 83 C1 2C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 08 8B 45 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "GetOleStrings"
		size = 84
		refs = "0009 @IntfClear 001c _DV_TStringsAdapter 0021 TStringsAdapter.Create 002d TStrings.SetStringsAdapter 0037 GetOleStrings 003c @IntfCast"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 85 DB 74 2F 83 7B 08 00 75 1A 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 30 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 53 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 00 E2 DF 05 EE 49 55 D0 11 9E A9 00 20 AF 3D 82 DA }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "SetOleStrings"
		size = 167
		refs = "0018 SetOleStrings 003b @CheckAutoResult 004e @VarClr 0069 @VarToLStr 0094 @LStrClr 009a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 55 8B C7 8B 10 FF 52 40 8D 45 F8 50 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D F8 4B 85 DB 7C 34 43 33 F6 8D 45 E4 E8 ?? ?? ?? ?? 50 56 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8D 55 E4 8D 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B C7 8B 08 FF 51 34 46 4B 75 CF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "_NF__632"
		size = 292
		refs = "000a SetErrorMode 0015 _NF__632 0021 _NV__62D 002e LoadLibrary 004c GetProcAddress 0051 _NV__62E 0066 _NV__62F 007b _NV__630 0090 _NV__631 00ac @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 68 00 80 00 00 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 75 6C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 54 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 59 5D C3 00 00 00 6F 6C 65 70 72 6F 33 32 2E 64 6C 6C 00 00 00 00 4F 6C 65 43 72 65 61 74 65 50 72 6F 70 65 72 74 79 46 72 61 6D 65 00 00 4F 6C 65 43 72 65 61 74 65 46 6F 6E 74 49 6E 64 69 72 65 63 74 00 00 00 4F 6C 65 43 72 65 61 74 65 50 69 63 74 75 72 65 49 6E 64 69 72 65 63 74 00 00 00 00 4F 6C 65 4C 6F 61 64 50 69 63 74 75 72 65 00 00 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "_NF__633"
		size = 66
		refs = "0006 _NV__62E"
	strings:
		$1 = { 55 8B EC 53 83 3D ?? ?? ?? ?? 00 74 2B 8B 5D 08 53 8B 5D 0C 53 8B 5D 10 53 8B 5D 14 53 8B 5D 18 53 8B 5D 1C 53 8B 5D 20 53 8B 5D 24 53 51 52 50 FF 15 ?? ?? ?? ?? EB 05 B8 FF FF 00 80 5B 5D C2 20 00 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "_NF__634"
		size = 25
		refs = "0002 _NV__62F"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 0A 51 52 50 FF 15 ?? ?? ?? ?? C3 B8 FF FF 00 80 C3 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "_NF__635"
		size = 38
		refs = "0006 _NV__630"
	strings:
		$1 = { 55 8B EC 53 83 3D ?? ?? ?? ?? 00 74 0F 8B 5D 08 53 51 52 50 FF 15 ?? ?? ?? ?? EB 05 B8 FF FF 00 80 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "_NF__636"
		size = 111
		refs = "0011 @IntfAddRef 0019 _NF__636 0025 _NV__631 005a @IntfClear 0060 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 74 18 8B 45 08 50 8B 45 0C 50 56 53 8B 45 FC 50 FF 15 ?? ?? ?? ?? 8B D8 EB 05 BB FF FF 00 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "Finalization"
		size = 88
		refs = "0007 Finalization 0013 _NV__2EC 001b _NV__2F0 0029 DestroyWindow 002f _NV__62D 003d FreeLibrary 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 28 83 3D ?? ?? ?? ?? 00 74 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "AxCtrls"
		size = 35
		refs = "0002 _NV__2EC 000a _DV_TOleGraphic 0014 _Dn_TPicture 0019 TPicture.RegisterFileFormat 001e _NF__632"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 19 A1 ?? ?? ?? ?? 50 33 C9 33 D2 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "TAxisIncrement.FormShow"
		size = 454
		refs = "000d TAxisIncrement.FormShow 0018 Screen 0021 TScreen.SetCursor 0032 TControl.SetVisible 004d TControl.SetEnabled 005e TCustomCheckBox.SetChecked 0079 TeeMsg_EnterDateTime 007e LoadResString 0085 TAxisIncrement.SetEditText 00a4 TCustomRadioGroup.SetItemIndex 00b7 TCustomComboBox.SetItemIndex 00c4 TControl.SetText 013c @LStrClr 0151 FloatToStr 017f TControl.SetTop 01bb @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8A 93 F8 01 00 00 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8B 83 DC 01 00 00 83 B8 24 01 00 00 00 0F 94 C2 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8A 93 F9 01 00 00 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 80 BB F8 01 00 00 00 0F 84 99 00 00 00 8B 83 E4 01 00 00 8D 50 60 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 80 BB F9 01 00 00 00 74 53 80 BB 04 02 00 00 19 74 4A 33 D2 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 33 D2 8A 93 04 02 00 00 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 8B 83 E0 01 00 00 8B 10 FF 52 78 E9 BF 00 00 00 BA 01 00 00 00 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 83 CA FF 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? E9 9C 00 00 00 33 D2 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? BA 01 00 00 00 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B 83 E4 01 00 00 83 C0 60 E8 ?? ?? ?? ?? DD 83 FC 01 00 00 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 8B 83 E4 01 00 00 8B 70 34 8B 93 F0 01 00 00 2B 72 34 8B 93 E8 01 00 00 8B 52 34 E8 ?? ?? ?? ?? 8B 83 E4 01 00 00 8B 50 34 2B D6 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 8B 83 E4 01 00 00 8B 10 FF 52 78 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "TAxisIncrement.SetEditText"
		size = 344
		refs = "0011 TAxisIncrement.SetEditText 002d DateTimeStep 003a TimeToStr 0048 TControl.SetText 006d @INT 007c FloatToStr 0095 @FRAC 00b0 TControl.GetText 00e2 @LStrCatN 012a @LStrArrayClr 0132 @LStrClr 0138 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 DD 83 FC 01 00 00 D8 1D ?? ?? ?? ?? DF E0 9E 77 25 A1 ?? ?? ?? ?? FF 70 04 FF 30 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? E9 C3 00 00 00 DD 83 FC 01 00 00 D8 1D ?? ?? ?? ?? DF E0 9E 0F 82 8C 00 00 00 DD 83 FC 01 00 00 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? DD 83 FC 01 00 00 E8 ?? ?? ?? ?? D8 1D ?? ?? ?? ?? DF E0 9E 74 70 8D 55 F4 8B B3 E4 01 00 00 8B C6 E8 ?? ?? ?? ?? FF 75 F4 68 ?? ?? ?? ?? DD 83 FC 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8D 45 FC E8 ?? ?? ?? ?? FF 75 FC 8D 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 22 FF B3 00 02 00 00 FF B3 FC 01 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5E 5B 8B E5 5D C3 00 00 00 00 00 00 80 3F FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "TAxisIncrement.RadioGroup1Click"
		size = 218
		refs = "0024 TControl.SetEnabled 0031 TCustomCheckBox.SetChecked 006b TCustomComboBox.SetItemIndex 00c9 TAxisIncrement.SetEditText"
	strings:
		$1 = { 53 8B D8 8B 83 DC 01 00 00 8B 80 24 01 00 00 83 E8 01 72 07 74 75 E9 BD 00 00 00 33 D2 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? B2 01 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? C6 83 F9 01 00 00 01 B2 01 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? B2 01 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 8A 83 04 02 00 00 3C 19 74 11 33 D2 8A D0 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? EB 0D 33 D2 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 8B 83 E0 01 00 00 8B 10 FF 52 78 5B C3 33 D2 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? C6 83 F9 01 00 00 00 33 D2 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? B2 01 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 83 E4 01 00 00 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "TAxisIncrement.BitBtn1Click"
		size = 608
		refs = "001e TAxisIncrement.BitBtn1Click 0062 TCustomComboBox.GetItemIndex 006b DateTimeStep 0097 TControl.GetText 00a4 AnsiPos 00d1 StrToTime 00ed @HandleOnException 00f5 _Dn_Exception 0112 StrToFloat 0121 @DoneExcept 014b @LStrCopy 01ee TeeMsg_IncorrectMaxMinValue 01f3 LoadResString 020c Format 0214 ShowMessage 0233 @LStrArrayClr 0246 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 C9 89 4D E4 89 4D E0 89 4D F8 89 4D F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 F8 01 00 00 00 0F 84 53 01 00 00 8B 45 FC 8B 80 DC 01 00 00 83 B8 24 01 00 00 00 75 32 8B 45 FC 8B 80 E0 01 00 00 E8 ?? ?? ?? ?? 83 E0 7F 8B 15 ?? ?? ?? ?? 8B 4D FC 8B 1C C2 89 99 FC 01 00 00 8B 5C C2 04 89 99 00 02 00 00 E9 32 01 00 00 8D 55 F8 8B 45 FC 8B 80 E4 01 00 00 E8 ?? ?? ?? ?? 8B 55 F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 7C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 FC 8B 80 E4 01 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC DD 98 FC 01 00 00 9B 33 C0 5A 59 59 64 89 10 E9 D0 00 00 00 E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 8D 55 F8 8B 45 FC 8B 80 E4 01 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC DD 98 FC 01 00 00 9B E8 ?? ?? ?? ?? E9 92 00 00 00 8D 45 F8 50 8D 55 F4 8B 45 FC 8B 80 E4 01 00 00 E8 ?? ?? ?? ?? 8B 45 F4 8B CB 49 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? DB 7D E8 9B 8D 45 F8 50 8D 55 F4 8B 45 FC 8B 80 E4 01 00 00 E8 ?? ?? ?? ?? 8B 45 F4 8D 53 01 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? DB 6D E8 DE C1 8B 45 FC DD 98 FC 01 00 00 9B EB 23 8D 55 F8 8B 45 FC 8B 80 E4 01 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC DD 98 FC 01 00 00 9B 8B 45 FC C7 80 50 01 00 00 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 4A E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8D 45 E4 50 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E0 50 8B 43 04 89 45 D8 C6 45 DC 0B 8D 55 D8 33 C9 58 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "TAxisIncrement.CBExactClick"
		size = 77
		refs = "000b TCustomCheckBox.GetChecked 0027 TCustomRadioGroup.SetItemIndex 0034 TControl.SetEnabled 003b TAxisIncrement.SetEditText"
	strings:
		$1 = { 53 56 8B F0 8B 86 F4 01 00 00 E8 ?? ?? ?? ?? 8B D8 88 9E F9 01 00 00 84 DB 75 2F BA 01 00 00 00 8B 86 DC 01 00 00 E8 ?? ?? ?? ?? B2 01 8B 86 E4 01 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 86 E4 01 00 00 8B 10 FF 52 78 5E 5B C3 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "TAxisIncrement.CBStepsChange"
		size = 22
		refs = "000a TCustomComboBox.GetItemIndex"
	strings:
		$1 = { 53 8B D8 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 88 83 04 02 00 00 5B C3 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "TAxisMaxMin.FormShow"
		size = 316
		refs = "000c TAxisMaxMin.FormShow 0017 Screen 0020 TScreen.SetCursor 004e DateToStr 005c TControl.SetText 006b TControl.SetVisible 008c TimeToStr 00aa @LStrClr 00c0 TeeMsg_AxisDlgValue 00c5 LoadResString 00e8 FloatToStr 012b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 80 BB F4 01 00 00 00 74 73 DD 83 F8 01 00 00 D8 1D ?? ?? ?? ?? DF E0 9E 72 24 FF B3 FC 01 00 00 FF B3 F8 01 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? EB 1A 33 D2 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? FF B3 FC 01 00 00 FF B3 F8 01 00 00 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? EB 74 8B 83 E4 01 00 00 83 C0 60 E8 ?? ?? ?? ?? 8B 83 E8 01 00 00 83 C0 60 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? DD 83 F8 01 00 00 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 00 00 00 00 80 3F }
	condition:
		$1
}

rule function_738_0 {
	meta:
		name = "TAxisMaxMin.BitBtn1Click"
		size = 352
		refs = "0015 TAxisMaxMin.BitBtn1Click 0048 TControl.GetText 006e @LStrCatN 0076 StrToDateTime 0095 StrToTime 00b4 StrToFloat 00d4 @HandleOnException 00dc _Dn_Exception 00ee TeeMsg_IncorrectMaxMinValue 00f3 LoadResString 010c Format 0114 ShowMessage 0119 @DoneExcept 0133 @LStrArrayClr 0146 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB F4 01 00 00 00 74 6C 8B B3 E4 01 00 00 80 7E 44 00 74 41 8D 55 F8 8B C6 E8 ?? ?? ?? ?? FF 75 F8 68 ?? ?? ?? ?? 8D 55 F4 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? FF 75 F4 8D 45 FC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? DD 9B F8 01 00 00 9B EB 3C 8D 55 FC 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? DD 9B F8 01 00 00 9B EB 1D 8D 55 FC 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? DD 9B F8 01 00 00 9B C7 83 50 01 00 00 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 4A E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8D 45 F0 50 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 43 04 89 45 E4 C6 45 E8 0B 8D 55 E4 33 C9 58 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "TAxisMaxMin.BitBtn2Click"
		size = 11
		altNames = "TQRTableSelect.CancelClick"
	strings:
		$1 = { C7 80 50 01 00 00 02 00 00 00 C3 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "TBarSeriesEditor.FormShow"
		size = 309
		refs = "000d TBarSeriesEditor.FormShow 0018 Screen 0021 TScreen.SetCursor 0046 TCustomComboBox.SetItemIndex 0057 TSpinEdit.SetValue 0079 TCustomCheckBox.SetChecked 008e FloatToStr 009c TControl.SetText 00ad TControl.SetEnabled 00c0 TCustomRadioGroup.SetItemIndex 0108 TBarSeriesEditor.RefreshShape 0124 @LStrClr 012a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? C6 83 28 02 00 00 01 8B 43 0C 89 83 2C 02 00 00 8B F0 33 D2 8A 96 D4 00 00 00 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 8B 96 D0 00 00 00 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B 96 F4 00 00 00 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 8A 96 D5 00 00 00 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? DD 86 D8 00 00 00 83 C4 F4 DB 3C 24 9B 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8A 96 D5 00 00 00 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 33 D2 8A 96 E8 00 00 00 8B 83 FC 01 00 00 E8 ?? ?? ?? ?? 8A 56 48 8B 83 1C 02 00 00 E8 ?? ?? ?? ?? 8A 96 F8 00 00 00 8B 83 24 02 00 00 E8 ?? ?? ?? ?? 8A 96 F1 00 00 00 8B 83 0C 02 00 00 E8 ?? ?? ?? ?? 8A 96 F0 00 00 00 8B 83 10 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? C6 83 28 02 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "TBarSeriesEditor.RefreshShape"
		size = 80
		refs = "0016 TControl.SetVisible 002a TControl.SetEnabled 004a TBrush.SetColor"
	strings:
		$1 = { 53 8B D8 8B 83 2C 02 00 00 8A 50 48 80 F2 01 8B 83 18 02 00 00 E8 ?? ?? ?? ?? 8B 83 18 02 00 00 8A 50 44 8B 83 20 02 00 00 E8 ?? ?? ?? ?? 8B 83 18 02 00 00 80 78 44 00 74 14 8B 93 2C 02 00 00 8B 52 44 8B 80 BC 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "TBarSeriesEditor.SEBarwidthChange"
		size = 108
		refs = "000c TBarSeriesEditor.SEBarwidthChange 0029 TControl.GetText 003a TSpinEdit.GetValue 0047 TCustomBarSeries.SetBarWidthPercent 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB 28 02 00 00 00 75 2C 8D 55 FC 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 83 7D FC 00 74 18 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "TBarSeriesEditor.CBYOriginClick"
		size = 78
		refs = "0013 TCustomCheckBox.GetChecked 0020 TCustomBarSeries.SetUseYOrigin 0037 TControl.SetEnabled"
	strings:
		$1 = { 53 8B D8 80 BB 28 02 00 00 00 75 40 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 8B 83 2C 02 00 00 8A 90 D5 00 00 00 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8B 83 F8 01 00 00 80 78 45 00 74 05 8B 10 FF 52 78 5B C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "TBarSeriesEditor.EYOriginChange"
		size = 124
		refs = "000c TBarSeriesEditor.EYOriginChange 0029 TControl.GetText 0045 StrToFloat 0057 TCustomBarSeries.SetYOrigin 006c @LStrClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB 28 02 00 00 00 75 3C 8D 55 FC 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 83 7D FC 00 74 28 8D 55 FC 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_747_0 {
	meta:
		name = "TBarSeriesEditor.CBBarStyleChange"
		size = 38
		refs = "0013 TCustomComboBox.GetItemIndex 0020 TCustomBarSeries.SetBarStyle"
	strings:
		$1 = { 53 8B D8 80 BB 28 02 00 00 00 75 18 8B 83 E4 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "TBarSeriesEditor.BBarPenClick"
		size = 18
		refs = "000d EditChartPen"
	strings:
		$1 = { 8B 90 2C 02 00 00 8B 92 E0 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "TBarSeriesEditor.BBarBrushClick"
		size = 18
		refs = "000d EditChartBrush"
	strings:
		$1 = { 8B 90 2C 02 00 00 8B 92 E4 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "TBarSeriesEditor.RGMultiBarClick"
		size = 33
		refs = "001c TCustomBarSeries.SetMultiBar"
	strings:
		$1 = { 80 B8 28 02 00 00 00 75 17 8B 90 FC 01 00 00 8A 92 24 01 00 00 8B 80 2C 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "TBarSeriesEditor.CBColorEachClick"
		size = 45
		refs = "0013 TCustomCheckBox.GetChecked 0020 TChartSeries.SetColorEachPoint 0027 TBarSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 8B D8 80 BB 28 02 00 00 00 75 1F 8B 83 1C 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "TBarSeriesEditor.BBarColorClick"
		size = 52
		refs = "0010 EditColor 0026 TCustomCheckBox.SetChecked 002d TBarSeriesEditor.RefreshShape"
	strings:
		$1 = { 53 56 8B D8 8B B3 2C 02 00 00 8B 56 44 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 51 4C 33 D2 8B 83 1C 02 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "TBarSeriesEditor.CBDarkBarClick"
		size = 38
		refs = "0013 TCustomCheckBox.GetChecked 0020 TCustomBarSeries.SetDark3d"
	strings:
		$1 = { 53 8B D8 80 BB 28 02 00 00 00 75 18 8B 83 0C 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_754_0 {
	meta:
		name = "TBarSeriesEditor.CBBarSideMarginsClick"
		size = 38
		refs = "0013 TCustomCheckBox.GetChecked 0020 TCustomBarSeries.SetSideMargins"
	strings:
		$1 = { 53 8B D8 80 BB 28 02 00 00 00 75 18 8B 83 10 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "TBarSeriesEditor.SEBarOffsetChange"
		size = 108
		refs = "000c TBarSeriesEditor.SEBarOffsetChange 0029 TControl.GetText 003a TSpinEdit.GetValue 0047 TCustomBarSeries.SetOffsetPercent 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB 28 02 00 00 00 75 2C 8D 55 FC 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 83 7D FC 00 74 18 8B 83 04 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "TBarSeriesEditor.CBMarksAutoPositionClick"
		size = 29
		refs = "000a TCustomCheckBox.GetChecked 0017 TCustomBarSeries.SetAutoMarkPosition"
	strings:
		$1 = { 53 8B D8 8B 83 24 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 2C 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "ErrCat"
		size = 7
		altNames = "HiByte"
	strings:
		$1 = { 0F B7 C0 C1 E8 08 C3 }
	condition:
		$1
}

rule function_761_0 {
	meta:
		name = "ErrCode"
		size = 5
	strings:
		$1 = { 66 25 FF 00 C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "DbiInit"
		size = 21
		refs = "000d DbiInitFn"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 68 90 01 00 00 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_763_0 {
	meta:
		name = "_NF__AC6"
		size = 6082
		refs = "000b _NF__AC6 0010 _NV__FB3 0028 _NF__FB6"
	strings:
		$1 = { 57 56 52 0F B7 C0 8B D0 03 C0 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 89 57 04 66 8B 14 06 0F B7 D2 89 57 08 8B C7 5A 5E 5F 50 E8 ?? ?? ?? ?? A9 00 00 FF FF 74 01 50 C3 EB C9 66 B8 00 00 EB F8 66 B8 01 00 EB F2 66 B8 02 00 EB EC 66 B8 03 00 EB E6 66 B8 04 00 EB E0 66 B8 05 00 EB DA 66 B8 06 00 EB D4 66 B8 07 00 EB CE 66 B8 08 00 EB C8 66 B8 09 00 EB C2 66 B8 0A 00 EB BC 66 B8 0B 00 EB B6 66 B8 0C 00 EB B0 66 B8 0D 00 EB AA 66 B8 0E 00 EB A4 66 B8 0F 00 EB 9E 66 B8 10 00 EB 98 66 B8 11 00 EB 92 66 B8 12 00 EB 8C 66 B8 13 00 EB 86 E9 4C FF FF FF 66 B8 14 00 EB F5 66 B8 15 00 EB EF 66 B8 16 00 EB E9 66 B8 17 00 EB E3 66 B8 18 00 EB DD 66 B8 19 00 EB D7 66 B8 1A 00 EB D1 66 B8 1B 00 EB CB 66 B8 1C 00 EB C5 66 B8 1D 00 EB BF 66 B8 1E 00 EB B9 66 B8 1F 00 EB B3 66 B8 20 00 EB AD 66 B8 21 00 EB A7 66 B8 22 00 EB A1 66 B8 23 00 EB 9B 66 B8 24 00 EB 95 66 B8 25 00 EB 8F 66 B8 26 00 EB 89 66 B8 27 00 EB 83 E9 CF FE FF FF 66 B8 28 00 EB F5 66 B8 29 00 EB EF 66 B8 2A 00 EB E9 66 B8 2B 00 EB E3 66 B8 2C 00 EB DD 66 B8 2D 00 EB D7 66 B8 2E 00 EB D1 66 B8 2F 00 EB CB 66 B8 30 00 EB C5 66 B8 31 00 EB BF 66 B8 32 00 EB B9 66 B8 33 00 EB B3 66 B8 34 00 EB AD 66 B8 35 00 EB A7 66 B8 36 00 EB A1 66 B8 37 00 EB 9B 66 B8 38 00 EB 95 66 B8 39 00 EB 8F 66 B8 3A 00 EB 89 66 B8 3B 00 EB 83 E9 52 FE FF FF 66 B8 3C 00 EB F5 66 B8 3D 00 EB EF 66 B8 3E 00 EB E9 66 B8 3F 00 EB E3 66 B8 40 00 EB DD 66 B8 41 00 EB D7 66 B8 42 00 EB D1 66 B8 43 00 EB CB 66 B8 44 00 EB C5 66 B8 45 00 EB BF 66 B8 46 00 EB B9 66 B8 47 00 EB B3 66 B8 48 00 EB AD 66 B8 49 00 EB A7 66 B8 4A 00 EB A1 66 B8 4B 00 EB 9B 66 B8 4C 00 EB 95 66 B8 4D 00 EB 8F 66 B8 4E 00 EB 89 66 B8 4F 00 EB 83 E9 D5 FD FF FF 66 B8 50 00 EB F5 66 B8 51 00 EB EF 66 B8 52 00 EB E9 66 B8 53 00 EB E3 66 B8 54 00 EB DD 66 B8 55 00 EB D7 66 B8 56 00 EB D1 66 B8 57 00 EB CB 66 B8 58 00 EB C5 66 B8 59 00 EB BF 66 B8 5A 00 EB B9 66 B8 5B 00 EB B3 66 B8 5C 00 EB AD 66 B8 5D 00 EB A7 66 B8 5E 00 EB A1 66 B8 5F 00 EB 9B 66 B8 60 00 EB 95 66 B8 61 00 EB 8F 66 B8 62 00 EB 89 66 B8 63 00 EB 83 E9 58 FD FF FF 66 B8 64 00 EB F5 66 B8 65 00 EB EF 66 B8 66 00 EB E9 66 B8 67 00 EB E3 66 B8 68 00 EB DD 66 B8 69 00 EB D7 66 B8 6A 00 EB D1 66 B8 6B 00 EB CB 66 B8 6C 00 EB C5 66 B8 6D 00 EB BF 66 B8 6E 00 EB B9 66 B8 6F 00 EB B3 66 B8 70 00 EB AD 66 B8 71 00 EB A7 66 B8 72 00 EB A1 66 B8 73 00 EB 9B 66 B8 74 00 EB 95 66 B8 75 00 EB 8F 66 B8 76 00 EB 89 66 B8 77 00 EB 83 E9 DB FC FF FF 66 B8 78 00 EB F5 66 B8 79 00 EB EF 66 B8 7A 00 EB E9 66 B8 7B 00 EB E3 66 B8 7C 00 EB DD 66 B8 7D 00 EB D7 66 B8 7E 00 EB D1 66 B8 7F 00 EB CB 66 B8 80 00 EB C5 66 B8 81 00 EB BF 66 B8 82 00 EB B9 66 B8 83 00 EB B3 66 B8 84 00 EB AD 66 B8 85 00 EB A7 66 B8 86 00 EB A1 66 B8 87 00 EB 9B 66 B8 88 00 EB 95 66 B8 89 00 EB 8F 66 B8 8A 00 EB 89 66 B8 8B 00 EB 83 E9 5E FC FF FF 66 B8 8C 00 EB F5 66 B8 8D 00 EB EF 66 B8 8E 00 EB E9 66 B8 8F 00 EB E3 66 B8 90 00 EB DD 66 B8 91 00 EB D7 66 B8 92 00 EB D1 66 B8 93 00 EB CB 66 B8 94 00 EB C5 66 B8 95 00 EB BF 66 B8 96 00 EB B9 66 B8 97 00 EB B3 66 B8 98 00 EB AD 66 B8 99 00 EB A7 66 B8 9A 00 EB A1 66 B8 9B 00 EB 9B 66 B8 9C 00 EB 95 66 B8 9D 00 EB 8F 66 B8 9E 00 EB 89 66 B8 9F 00 EB 83 E9 E1 FB FF FF 66 B8 A0 00 EB F5 66 B8 A1 00 EB EF 66 B8 A2 00 EB E9 66 B8 A3 00 EB E3 66 B8 A4 00 EB DD 66 B8 A5 00 EB D7 66 B8 A6 00 EB D1 66 B8 A7 00 EB CB 66 B8 A8 00 EB C5 66 B8 A9 00 EB BF 66 B8 AA 00 EB B9 66 B8 AB 00 EB B3 66 B8 AC 00 EB AD 66 B8 AD 00 EB A7 66 B8 AE 00 EB A1 66 B8 AF 00 EB 9B 66 B8 B0 00 EB 95 66 B8 B1 00 EB 8F 66 B8 B2 00 EB 89 66 B8 B3 00 EB 83 E9 64 FB FF FF 66 B8 B4 00 EB F5 66 B8 B5 00 EB EF 66 B8 B6 00 EB E9 66 B8 B7 00 EB E3 66 B8 B8 00 EB DD 66 B8 B9 00 EB D7 66 B8 BA 00 EB D1 66 B8 BB 00 EB CB 66 B8 BC 00 EB C5 66 B8 BD 00 EB BF 66 B8 BE 00 EB B9 66 B8 BF 00 EB B3 66 B8 C0 00 EB AD 66 B8 C1 00 EB A7 66 B8 C2 00 EB A1 66 B8 C3 00 EB 9B 66 B8 C4 00 EB 95 66 B8 C5 00 EB 8F 66 B8 C6 00 EB 89 66 B8 C7 00 EB 83 E9 E7 FA FF FF 66 B8 C8 00 EB F5 66 B8 C9 00 EB EF 66 B8 CA 00 EB E9 66 B8 CB 00 EB E3 66 B8 CC 00 EB DD 66 B8 CD 00 EB D7 66 B8 CE 00 EB D1 66 B8 CF 00 EB CB 66 B8 D0 00 EB C5 66 B8 D1 00 EB BF 66 B8 D2 00 EB B9 66 B8 D3 00 EB B3 66 B8 D4 00 EB AD 66 B8 D5 00 EB A7 66 B8 D6 00 EB A1 66 B8 D7 00 EB 9B 66 B8 D8 00 EB 95 66 B8 D9 00 EB 8F 66 B8 DA 00 EB 89 66 B8 DB 00 EB 83 E9 6A FA FF FF 66 B8 DC 00 EB F5 66 B8 DD 00 EB EF 66 B8 DE 00 EB E9 66 B8 DF 00 EB E3 66 B8 E0 00 EB DD 66 B8 E1 00 EB D7 66 B8 E2 00 EB D1 66 B8 E3 00 EB CB 66 B8 E4 00 EB C5 66 B8 E5 00 EB BF 66 B8 E6 00 EB B9 66 B8 E7 00 EB B3 66 B8 E8 00 EB AD 66 B8 E9 00 EB A7 66 B8 EA 00 EB A1 66 B8 EB 00 EB 9B 66 B8 EC 00 EB 95 66 B8 ED 00 EB 8F 66 B8 EE 00 EB 89 66 B8 EF 00 EB 83 E9 ED F9 FF FF 66 B8 F0 00 EB F5 66 B8 F1 00 EB EF 66 B8 F2 00 EB E9 66 B8 F3 00 EB E3 66 B8 F4 00 EB DD 66 B8 F5 00 EB D7 66 B8 F6 00 EB D1 66 B8 F7 00 EB CB 66 B8 F8 00 EB C5 66 B8 F9 00 EB BF 66 B8 FA 00 EB B9 66 B8 FB 00 EB B3 66 B8 FC 00 EB AD 66 B8 FD 00 EB A7 66 B8 FE 00 EB A1 66 B8 FF 00 EB 9B 66 B8 00 01 EB 95 66 B8 01 01 EB 8F 66 B8 02 01 EB 89 66 B8 03 01 EB 83 E9 70 F9 FF FF 66 B8 04 01 EB F5 66 B8 05 01 EB EF 66 B8 06 01 EB E9 66 B8 07 01 EB E3 66 B8 08 01 EB DD 66 B8 09 01 EB D7 66 B8 0A 01 EB D1 66 B8 0B 01 EB CB 66 B8 0C 01 EB C5 66 B8 0D 01 EB BF 66 B8 0E 01 EB B9 66 B8 0F 01 EB B3 66 B8 10 01 EB AD 66 B8 11 01 EB A7 66 B8 12 01 EB A1 66 B8 13 01 EB 9B 66 B8 14 01 EB 95 66 B8 15 01 EB 8F 66 B8 16 01 EB 89 66 B8 17 01 EB 83 E9 F3 F8 FF FF 66 B8 18 01 EB F5 66 B8 19 01 EB EF 66 B8 1A 01 EB E9 66 B8 1B 01 EB E3 66 B8 1C 01 EB DD 66 B8 1D 01 EB D7 66 B8 1E 01 EB D1 66 B8 1F 01 EB CB 66 B8 20 01 EB C5 66 B8 21 01 EB BF 66 B8 22 01 EB B9 66 B8 23 01 EB B3 66 B8 24 01 EB AD 66 B8 25 01 EB A7 66 B8 26 01 EB A1 66 B8 27 01 EB 9B 66 B8 28 01 EB 95 66 B8 29 01 EB 8F 66 B8 2A 01 EB 89 66 B8 2B 01 EB 83 E9 76 F8 FF FF 66 B8 2C 01 EB F5 66 B8 2D 01 EB EF 66 B8 2E 01 EB E9 66 B8 2F 01 EB E3 66 B8 30 01 EB DD 66 B8 31 01 EB D7 66 B8 32 01 EB D1 66 B8 33 01 EB CB 66 B8 34 01 EB C5 66 B8 35 01 EB BF 66 B8 36 01 EB B9 66 B8 37 01 EB B3 66 B8 38 01 EB AD 66 B8 39 01 EB A7 66 B8 3A 01 EB A1 66 B8 3B 01 EB 9B 66 B8 3C 01 EB 95 66 B8 3D 01 EB 8F 66 B8 3E 01 EB 89 66 B8 3F 01 EB 83 E9 F9 F7 FF FF 66 B8 40 01 EB F5 66 B8 41 01 EB EF 66 B8 42 01 EB E9 66 B8 43 01 EB E3 66 B8 44 01 EB DD 66 B8 45 01 EB D7 66 B8 46 01 EB D1 66 B8 47 01 EB CB 66 B8 48 01 EB C5 66 B8 49 01 EB BF 66 B8 4A 01 EB B9 66 B8 4B 01 EB B3 66 B8 4C 01 EB AD 66 B8 4D 01 EB A7 66 B8 4E 01 EB A1 66 B8 4F 01 EB 9B 66 B8 50 01 EB 95 66 B8 51 01 EB 8F 66 B8 52 01 EB 89 66 B8 53 01 EB 83 E9 7C F7 FF FF 66 B8 54 01 EB F5 66 B8 55 01 EB EF 66 B8 56 01 EB E9 66 B8 57 01 EB E3 66 B8 58 01 EB DD 66 B8 59 01 EB D7 66 B8 5A 01 EB D1 66 B8 5B 01 EB CB 66 B8 5C 01 EB C5 66 B8 5D 01 EB BF 66 B8 5E 01 EB B9 66 B8 5F 01 EB B3 66 B8 60 01 EB AD 66 B8 61 01 EB A7 66 B8 62 01 EB A1 66 B8 63 01 EB 9B 66 B8 64 01 EB 95 66 B8 65 01 EB 8F 66 B8 66 01 EB 89 66 B8 67 01 EB 83 E9 FF F6 FF FF 66 B8 68 01 EB F5 66 B8 69 01 EB EF 66 B8 6A 01 EB E9 66 B8 6B 01 EB E3 66 B8 6C 01 EB DD 66 B8 6D 01 EB D7 66 B8 6E 01 EB D1 66 B8 6F 01 EB CB 66 B8 70 01 EB C5 66 B8 71 01 EB BF 66 B8 72 01 EB B9 66 B8 73 01 EB B3 66 B8 74 01 EB AD 66 B8 75 01 EB A7 66 B8 76 01 EB A1 66 B8 77 01 EB 9B 66 B8 78 01 EB 95 66 B8 79 01 EB 8F 66 B8 7A 01 EB 89 66 B8 7B 01 EB 83 E9 82 F6 FF FF 66 B8 7C 01 EB F5 66 B8 7D 01 EB EF 66 B8 7E 01 EB E9 66 B8 7F 01 EB E3 66 B8 80 01 EB DD 66 B8 81 01 EB D7 66 B8 82 01 EB D1 66 B8 83 01 EB CB 66 B8 84 01 EB C5 66 B8 85 01 EB BF 66 B8 86 01 EB B9 66 B8 87 01 EB B3 66 B8 88 01 EB AD 66 B8 89 01 EB A7 66 B8 8A 01 EB A1 66 B8 8B 01 EB 9B 66 B8 8C 01 EB 95 66 B8 8D 01 EB 8F 66 B8 8E 01 EB 89 66 B8 8F 01 EB 83 E9 05 F6 FF FF 66 B8 90 01 EB F5 66 B8 91 01 EB EF 66 B8 92 01 EB E9 66 B8 93 01 EB E3 66 B8 94 01 EB DD 66 B8 95 01 EB D7 66 B8 96 01 EB D1 66 B8 97 01 EB CB 66 B8 98 01 EB C5 66 B8 99 01 EB BF 66 B8 9A 01 EB B9 66 B8 9B 01 EB B3 66 B8 9C 01 EB AD 66 B8 9D 01 EB A7 66 B8 9E 01 EB A1 66 B8 9F 01 EB 9B 66 B8 A0 01 EB 95 66 B8 A1 01 EB 8F 66 B8 A2 01 EB 89 66 B8 A3 01 EB 83 E9 88 F5 FF FF 66 B8 A4 01 EB F5 66 B8 A5 01 EB EF 66 B8 A6 01 EB E9 66 B8 A7 01 EB E3 66 B8 A8 01 EB DD 66 B8 A9 01 EB D7 66 B8 AA 01 EB D1 66 B8 AB 01 EB CB 66 B8 AC 01 EB C5 66 B8 AD 01 EB BF 66 B8 AE 01 EB B9 66 B8 AF 01 EB B3 66 B8 B0 01 EB AD 66 B8 B1 01 EB A7 66 B8 B2 01 EB A1 66 B8 B3 01 EB 9B 66 B8 B4 01 EB 95 66 B8 B5 01 EB 8F 66 B8 B6 01 EB 89 66 B8 B7 01 EB 83 E9 0B F5 FF FF 66 B8 B8 01 EB F5 66 B8 B9 01 EB EF 66 B8 BA 01 EB E9 66 B8 BB 01 EB E3 66 B8 BC 01 EB DD 66 B8 BD 01 EB D7 66 B8 BE 01 EB D1 66 B8 BF 01 EB CB 66 B8 C0 01 EB C5 66 B8 C1 01 EB BF 66 B8 C2 01 EB B9 66 B8 C3 01 EB B3 66 B8 C4 01 EB AD 66 B8 C5 01 EB A7 66 B8 C6 01 EB A1 66 B8 C7 01 EB 9B 66 B8 C8 01 EB 95 66 B8 C9 01 EB 8F 66 B8 CA 01 EB 89 66 B8 CB 01 EB 83 E9 8E F4 FF FF 66 B8 CC 01 EB F5 66 B8 CD 01 EB EF 66 B8 CE 01 EB E9 66 B8 CF 01 EB E3 66 B8 D0 01 EB DD 66 B8 D1 01 EB D7 66 B8 D2 01 EB D1 66 B8 D3 01 EB CB 66 B8 D4 01 EB C5 66 B8 D5 01 EB BF 66 B8 D6 01 EB B9 66 B8 D7 01 EB B3 66 B8 D8 01 EB AD 66 B8 D9 01 EB A7 66 B8 DA 01 EB A1 66 B8 DB 01 EB 9B 66 B8 DC 01 EB 95 66 B8 DD 01 EB 8F 66 B8 DE 01 EB 89 66 B8 DF 01 EB 83 E9 11 F4 FF FF 66 B8 E0 01 EB F5 66 B8 E1 01 EB EF 66 B8 E2 01 EB E9 66 B8 E3 01 EB E3 66 B8 E4 01 EB DD 66 B8 E5 01 EB D7 66 B8 E6 01 EB D1 66 B8 E7 01 EB CB 66 B8 E8 01 EB C5 66 B8 E9 01 EB BF 66 B8 EA 01 EB B9 66 B8 EB 01 EB B3 66 B8 EC 01 EB AD 66 B8 ED 01 EB A7 66 B8 EE 01 EB A1 66 B8 EF 01 EB 9B 66 B8 F0 01 EB 95 66 B8 F1 01 EB 8F 66 B8 F2 01 EB 89 66 B8 F3 01 EB 83 E9 94 F3 FF FF 66 B8 F4 01 EB F5 66 B8 F5 01 EB EF 66 B8 F6 01 EB E9 66 B8 F7 01 EB E3 66 B8 F8 01 EB DD 66 B8 F9 01 EB D7 66 B8 FA 01 EB D1 66 B8 FB 01 EB CB 66 B8 FC 01 EB C5 66 B8 FD 01 EB BF 66 B8 FE 01 EB B9 66 B8 FF 01 EB B3 66 B8 00 02 EB AD 66 B8 01 02 EB A7 66 B8 02 02 EB A1 66 B8 03 02 EB 9B 66 B8 04 02 EB 95 66 B8 05 02 EB 8F 66 B8 06 02 EB 89 66 B8 07 02 EB 83 E9 17 F3 FF FF 66 B8 08 02 EB F5 66 B8 09 02 EB EF 66 B8 0A 02 EB E9 66 B8 0B 02 EB E3 66 B8 0C 02 EB DD 66 B8 0D 02 EB D7 66 B8 0E 02 EB D1 66 B8 0F 02 EB CB 66 B8 10 02 EB C5 66 B8 11 02 EB BF 66 B8 12 02 EB B9 66 B8 13 02 EB B3 66 B8 14 02 EB AD 66 B8 15 02 EB A7 66 B8 16 02 EB A1 66 B8 17 02 EB 9B 66 B8 18 02 EB 95 66 B8 19 02 EB 8F 66 B8 1A 02 EB 89 66 B8 1B 02 EB 83 E9 9A F2 FF FF 66 B8 1C 02 EB F5 66 B8 1D 02 EB EF 66 B8 1E 02 EB E9 66 B8 1F 02 EB E3 66 B8 20 02 EB DD 66 B8 21 02 EB D7 66 B8 22 02 EB D1 66 B8 23 02 EB CB 66 B8 24 02 EB C5 66 B8 25 02 EB BF 66 B8 26 02 EB B9 66 B8 27 02 EB B3 66 B8 28 02 EB AD 66 B8 29 02 EB A7 66 B8 2A 02 EB A1 66 B8 2B 02 EB 9B 66 B8 2C 02 EB 95 66 B8 2D 02 EB 8F 66 B8 2E 02 EB 89 66 B8 2F 02 EB 83 E9 1D F2 FF FF 66 B8 30 02 EB F5 66 B8 31 02 EB EF 66 B8 32 02 EB E9 66 B8 33 02 EB E3 66 B8 34 02 EB DD 66 B8 35 02 EB D7 66 B8 36 02 EB D1 66 B8 37 02 EB CB 66 B8 38 02 EB C5 66 B8 39 02 EB BF 66 B8 3A 02 EB B9 66 B8 3B 02 EB B3 66 B8 3C 02 EB AD 66 B8 3D 02 EB A7 66 B8 3E 02 EB A1 66 B8 3F 02 EB 9B 66 B8 40 02 EB 95 66 B8 41 02 EB 8F 66 B8 42 02 EB 89 66 B8 43 02 EB 83 E9 A0 F1 FF FF 66 B8 44 02 EB F5 66 B8 45 02 EB EF 66 B8 46 02 EB E9 66 B8 47 02 EB E3 66 B8 48 02 EB DD 66 B8 49 02 EB D7 66 B8 4A 02 EB D1 66 B8 4B 02 EB CB 66 B8 4C 02 EB C5 66 B8 4D 02 EB BF 66 B8 4E 02 EB B9 66 B8 4F 02 EB B3 66 B8 50 02 EB AD 66 B8 51 02 EB A7 66 B8 52 02 EB A1 66 B8 53 02 EB 9B 66 B8 54 02 EB 95 66 B8 55 02 EB 8F 66 B8 56 02 EB 89 66 B8 57 02 EB 83 E9 23 F1 FF FF 66 B8 58 02 EB F5 66 B8 59 02 EB EF 66 B8 5A 02 EB E9 66 B8 5B 02 EB E3 66 B8 5C 02 EB DD 66 B8 5D 02 EB D7 66 B8 5E 02 EB D1 66 B8 5F 02 EB CB 66 B8 60 02 EB C5 66 B8 61 02 EB BF 66 B8 62 02 EB B9 66 B8 63 02 EB B3 66 B8 64 02 EB AD 66 B8 65 02 EB A7 66 B8 66 02 EB A1 66 B8 67 02 EB 9B 66 B8 68 02 EB 95 66 B8 69 02 EB 8F 66 B8 6A 02 EB 89 66 B8 6B 02 EB 83 E9 A6 F0 FF FF 66 B8 6C 02 EB F5 66 B8 6D 02 EB EF 66 B8 6E 02 EB E9 66 B8 6F 02 EB E3 66 B8 70 02 EB DD 66 B8 71 02 EB D7 66 B8 72 02 EB D1 66 B8 73 02 EB CB 66 B8 74 02 EB C5 66 B8 75 02 EB BF 66 B8 76 02 EB B9 66 B8 77 02 EB B3 66 B8 78 02 EB AD 66 B8 79 02 EB A7 66 B8 7A 02 EB A1 66 B8 7B 02 EB 9B 66 B8 7C 02 EB 95 66 B8 7D 02 EB 8F 66 B8 7E 02 EB 89 66 B8 7F 02 EB 83 E9 29 F0 FF FF 66 B8 80 02 EB F5 66 B8 81 02 EB EF 66 B8 82 02 EB E9 66 B8 83 02 EB E3 66 B8 84 02 EB DD 66 B8 85 02 EB D7 66 B8 86 02 EB }
	condition:
		$1
}

rule function_1066_0 {
	meta:
		name = "_NF__FB5"
		size = 1233
		refs = "00a7 IsDBCSLeadByte 00d0 GetCurrentDirectoryA 00e4 FatalAppExitA 014b GlobalAlloc 0151 GlobalLock 016d FindFirstFileA 0178 FindClose 01a0 _NV__FBC 01aa RegOpenKeyExA 01cd RegQueryValueExA 01dd RegCloseKey 01f4 _NV__FBD 01f9 InitializeCriticalSection 0222 DeleteCriticalSection 023b InterlockedIncrement 0249 CreateMutexA 0263 InterlockedDecrement 026d ReleaseMutex 027b CloseHandle 0285 EnterCriticalSection 02a3 LeaveCriticalSection 02c1 SetErrorMode 030c LoadLibraryA 0347 SearchPathA 036e GetLastError 039e _NV__FBE 03a8 _NV__FBF 0468 GetModuleHandleA"
	strings:
		$1 = { 55 8B EC 53 8B 55 08 8B 45 0C 80 38 00 74 0A 8A 08 40 8A 1A 42 3A CB 74 F1 80 38 00 75 0C 80 3A 00 75 07 B8 01 00 00 00 EB 02 33 C0 5B 5D C2 08 00 55 8B EC 53 56 57 8B 75 08 8B 55 0C 8B 4D 10 66 85 F6 74 2E 33 C0 EB 0F 0F B7 D8 8D 3C 19 0F B7 D8 8A 1C 1A 88 1F 40 0F B7 D8 80 3C 1A 00 74 0B 0F B7 D8 0F B7 FE 4F 3B DF 7C DD 0F B7 C0 C6 04 01 00 5F 5E 5B 5D C2 0C 00 55 8B EC 53 56 57 8B 7D 08 8B 75 0C 83 C8 FF 33 DB 3B FB 7E 2E 8A 14 1E 84 D2 75 05 83 C8 FF EB 22 48 75 07 B8 02 00 00 00 EB 13 52 E8 ?? ?? ?? ?? 85 C0 74 07 B8 01 00 00 00 EB 02 33 C0 43 3B FB 7F D2 5F 5E 5B 5D C2 08 00 55 8B EC 53 8B 5D 0C 53 FF 75 08 E8 ?? ?? ?? ?? 8B C3 5B 5D C2 08 00 55 8B EC FF 75 08 6A 00 E8 ?? ?? ?? ?? 5D C2 04 00 55 8B EC 53 56 8B 75 10 8B DE 8B 45 0C 33 D2 EB 08 8A 08 40 43 88 4B FF 42 80 38 00 75 F3 3B F3 74 1A 80 7B FF 5C 75 10 56 0F BF C2 48 50 E8 5B FF FF FF 83 F8 02 75 04 C6 03 5C 43 8B 45 08 EB 07 8A 10 40 43 88 53 FF 80 38 00 75 F4 C6 03 00 5E 5B 5D C2 0C 00 55 8B EC FF 75 08 6A 40 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5D C2 04 00 55 8B EC 81 C4 C0 FE FF FF 8D 85 C0 FE FF FF 50 FF 75 08 E8 ?? ?? ?? ?? 83 F8 FF 74 0D 50 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 02 33 C0 8B E5 5D C2 04 00 55 8B EC 83 C4 F8 53 33 DB 8D 45 FC 50 68 19 00 02 00 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 31 0F B7 55 08 89 55 F8 8D 4D F8 51 FF 75 0C 6A 00 6A 00 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 85 C0 74 04 66 BB 04 2A FF 75 FC E8 ?? ?? ?? ?? EB 04 66 BB 04 2A 8B C3 5B 59 59 5D C2 08 00 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 5D C3 55 8B EC 83 3D ?? ?? ?? ?? 00 74 11 33 C0 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 55 8B EC 53 83 3D ?? ?? ?? ?? 00 75 4A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 8B D8 83 3D ?? ?? ?? ?? 00 75 05 E8 93 FF FF FF 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 53 E8 ?? ?? ?? ?? EB 0C 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5B 5D C3 55 8B EC 83 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 55 8B EC 81 C4 F0 FC FF FF 53 56 57 8B 5D 08 8B 75 0C 68 00 80 00 00 E8 ?? ?? ?? ?? 8B F8 85 DB 74 04 8B C3 EB 17 8D 95 F8 FE FF FF 52 68 04 01 00 00 E8 E4 FD FF FF 8D 85 F8 FE FF FF 8D 95 F0 FC FF FF 52 50 56 E8 F8 FD FF FF 8D 8D F0 FC FF FF 51 E8 59 FE FF FF 85 C0 74 12 8D 85 F0 FC FF FF 50 E8 ?? ?? ?? ?? 8B D8 85 DB 75 5C 8D 85 F4 FD FF FF 50 68 04 01 00 00 E8 64 FE FF FF 66 85 C0 75 35 8D 55 FC 52 8D 8D F0 FC FF FF 51 68 04 01 00 00 6A 00 56 8D 85 F4 FD FF FF 50 E8 ?? ?? ?? ?? 85 C0 74 12 8D 95 F0 FC FF FF 52 E8 ?? ?? ?? ?? 8B D8 85 DB 75 11 56 E8 ?? ?? ?? ?? 8B D8 85 DB 75 05 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C2 08 00 55 8B EC 8B 45 08 5D C2 04 00 55 8B EC 5D C2 04 00 55 8B EC 53 56 57 8B 75 08 BF ?? ?? ?? ?? E8 81 FE FF FF B8 ?? ?? ?? ?? 2B C7 B9 30 00 00 00 33 D2 F7 F1 33 DB 3B C3 76 11 8B D3 03 D2 8D 14 52 3B 34 D7 74 05 43 3B C3 77 EF 3B C3 76 64 33 F6 EB 20 8B C3 C1 E0 04 8D 04 40 03 C7 50 56 8B D3 03 D2 8D 14 52 8B 4C D7 2A FF 34 B1 E8 C6 00 00 00 46 8B C3 03 C0 8D 04 40 0F B7 54 C7 04 3B F2 72 D0 8B CB C1 E1 04 8D 0C 49 03 CF 51 E8 6D FF FF FF 8B D3 03 D2 8D 14 52 33 C9 89 0C D0 8B D3 03 D2 8D 14 52 66 C7 44 D0 2E 00 00 50 E8 57 FF FF FF E8 CE FD FF FF 5F 5E 5B 5D C2 04 00 55 8B EC 51 53 56 57 8B 7D 08 33 C0 89 45 FC 57 E8 2C FF FF FF 8B D8 85 DB 75 06 66 B8 01 25 EB 50 8D 57 06 52 E8 ?? ?? ?? ?? 8B F0 85 F6 75 24 83 C7 06 57 6A 00 E8 2C FE FF FF 8B F0 85 F6 75 0C 53 E8 04 FF FF FF 66 B8 0A 21 EB 24 C7 45 FC 01 00 00 00 89 33 66 8B 55 FC 66 09 53 2E 53 E8 E7 FE FF FF 56 68 ?? ?? ?? ?? E8 15 02 00 00 33 C0 5F 5E 5B 59 5D C2 04 00 55 8B EC 8B 45 10 8B 50 26 8B 4D 0C 8B 45 08 89 04 8A 5D C2 0C 00 }
	condition:
		$1
}

rule function_1067_0 {
	meta:
		name = "_NF__FB6"
		size = 661
		refs = "0040 GetProcAddress 007e _NV__FBE 0090 _NV__FBF 00ce FreeLibrary 01c3 _NV__FBC 0264 GetLastError"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 75 08 8B 1E 8B 7E 04 E8 44 FD FF FF 85 C0 75 07 B8 06 2A 00 00 EB 42 83 3B 00 75 12 53 E8 48 FF FF FF 66 85 C0 74 07 0F B7 D0 8B C2 EB 2B 66 8B 46 08 0F B7 D0 52 FF 33 E8 ?? ?? ?? ?? 8B F0 85 F6 75 07 B8 4F 27 00 00 EB 0F 53 57 56 E8 91 FF FF FF E8 62 FD FF FF 8B C6 5F 5E 5B 5D C2 04 00 55 8B EC E8 B0 FC FF FF B8 01 00 00 00 5D C3 55 8B EC 51 53 56 57 BF ?? ?? ?? ?? E8 D0 FC FF FF 85 C0 0F 84 B5 00 00 00 B8 ?? ?? ?? ?? 2B C7 B9 30 00 00 00 33 D2 F7 F1 89 45 FC 33 DB 3B 5D FC 73 63 8B C3 03 C0 8D 04 40 8B 34 C7 85 F6 74 1B 56 E8 6E 01 00 00 8B C3 03 C0 8D 04 40 66 83 7C C7 2E 00 74 06 56 E8 ?? ?? ?? ?? 33 F6 EB 20 8B C3 C1 E0 04 8D 04 40 03 C7 50 56 8B D3 03 D2 8D 14 52 8B 4C D7 2A FF 34 B1 E8 F5 FE FF FF 46 8B C3 03 C0 8D 04 40 0F B7 54 C7 04 3B F2 72 D0 43 3B 5D FC 72 9D 57 E8 A0 FD FF FF 33 DB 3B 5D FC 73 20 8B D3 03 D2 8D 14 52 33 C9 89 0C D0 8B D3 03 D2 8D 14 52 66 C7 44 D0 2E 00 00 43 3B 5D FC 72 E0 50 E8 7D FD FF FF E8 F4 FB FF FF 5F 5E 5B 59 5D C3 55 8B EC 53 56 57 8B 75 0C 56 FF 75 08 E8 D3 F9 FF FF 85 C0 74 0A B8 01 00 00 00 E9 84 00 00 00 B8 ?? ?? ?? ?? 2D ?? ?? ?? ?? B9 30 00 00 00 33 D2 F7 F1 8B F8 33 DB 3B FB 76 67 8B C3 C1 E0 04 8D 04 40 05 ?? ?? ?? ?? 50 56 E8 96 F9 FF FF 85 C0 75 4A 8B D3 03 D2 8D 14 52 83 3C D5 ?? ?? ?? ?? 00 74 04 33 C0 EB 3C 68 ?? ?? ?? ?? E8 F6 FC FF FF 8B D8 85 DB 75 0A 68 ?? ?? ?? ?? E8 3E FA FF FF 8D 43 06 50 FF 75 08 6A 20 E8 86 F9 FF FF 53 E8 DC FC FF FF B8 01 00 00 00 EB 07 43 3B FB 77 99 33 C0 5F 5E 5B 5D C2 08 00 55 8B EC 83 C4 F4 68 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 66 C7 45 F4 01 00 C7 45 F6 ?? ?? ?? ?? 8B 55 08 89 55 FA 85 C0 74 06 8D 4D F4 51 FF D0 8B E5 5D C2 08 00 55 8B EC 53 8B 5D 08 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 74 04 FF D0 EB 16 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 74 07 68 ?? ?? ?? ?? FF D0 5B 5D C2 04 00 55 8B EC E8 ?? ?? ?? ?? 83 C0 FE 83 E8 02 72 11 83 E8 0A 74 12 83 E8 70 74 07 83 E8 23 74 02 EB 0C 66 B8 08 21 EB 0A 66 B8 01 25 EB 04 66 B8 09 21 5D C2 04 00 }
	condition:
		$1
}

rule function_1068_0 {
	meta:
		name = "DbiInitFn"
		size = 251
		refs = "0017 _NV__FBC 0075 GetProcAddress 00d8 FreeLibrary"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C0 89 45 FC 33 D2 89 55 F8 33 FF 83 3D ?? ?? ?? ?? 00 75 40 68 ?? ?? ?? ?? 6A 00 E8 19 FB FF FF 8B D8 85 DB 75 0F 53 E8 95 FF FF FF 8B F0 33 DB E9 8D 00 00 00 C7 45 F8 01 00 00 00 E8 87 FD FF FF 85 C0 75 06 66 BE 01 25 EB 77 C7 45 FC 01 00 00 00 EB 06 8B 1D ?? ?? ?? ?? E8 59 FA FF FF BF 01 00 00 00 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 75 06 66 BE 06 2A EB 49 FF 75 0C 66 8B 55 08 52 FF D0 8B F0 66 85 F6 75 38 66 83 3D ?? ?? ?? ?? 00 75 12 68 ?? ?? ?? ?? E8 75 FB FF FF 89 18 50 E8 77 FB FF FF 68 ?? ?? ?? ?? E8 63 FB FF FF 66 FF 00 50 E8 64 FB FF FF E8 63 FA FF FF 33 C0 EB 26 85 DB 74 0C 83 7D F8 00 74 06 53 E8 ?? ?? ?? ?? 83 7D FC 00 74 05 E8 FA FC FF FF 85 FF 74 05 E8 3B FA FF FF 8B C6 5F 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1069_0 {
	meta:
		name = "DbiExit"
		size = 128
		refs = "0006 _NV__FBC 0011 GetProcAddress 0062 FreeLibrary"
	strings:
		$1 = { 55 8B EC 53 56 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 06 66 B8 4F 27 EB 5B FF D3 66 85 C0 75 54 66 83 3D ?? ?? ?? ?? 00 76 48 68 ?? ?? ?? ?? E8 E6 FA FF FF 8B D8 85 DB 74 03 66 FF 0B 66 83 3D ?? ?? ?? ?? 00 75 25 68 ?? ?? ?? ?? E8 C9 FA FF FF 8B F0 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 74 04 33 C0 89 06 56 E8 B8 FA FF FF 53 E8 B2 FA FF FF 33 C0 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1070_0 {
	meta:
		name = "DbiDLLExit"
		size = 100
		refs = "0008 _NV__FBF 000d _NV__FBE 0033 _NV__FB4 005e DbiGetSysVersion"
	strings:
		$1 = { 55 8B EC 53 56 33 F6 B8 ?? ?? ?? ?? 2D ?? ?? ?? ?? B9 30 00 00 00 33 D2 F7 F1 85 C0 74 07 E8 43 FC FF FF EB 2D E8 1D F9 FF FF 85 C0 75 04 8B C6 EB 22 BB ?? ?? ?? ?? 8B 03 85 C0 74 10 50 E8 D8 FD FF FF 33 D2 89 13 66 C7 43 2E 00 00 E8 D6 F8 FF FF 8B C6 5E 5B 5D C3 55 8B EC 6A 00 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_1075_0 {
	meta:
		name = "EUpdateError.Create"
		size = 154
		refs = "000e @ClassCreate 001d @LStrAddRef 002d EUpdateError.Create 003e @LStrAsg 005a Exception.Create 006f @LStrClr 007d @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 10 8B 55 10 E8 ?? ?? ?? ?? 66 8B 45 0C 66 89 46 0C 66 8B 45 08 66 89 46 0E 8B 4D FC 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1076_0 {
	meta:
		name = "_NF__C2"
		size = 39
		refs = "000c _DV_TProvider 0011 TProvider.Create"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D7 8B C3 8B 08 FF 51 28 89 73 34 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1077_0 {
	meta:
		name = "TProvider.Create"
		size = 82
		refs = "000b @ClassCreate 001c TComponent.Create 0024 _Dn_TDBDataSet 0029 @IsClass"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 03 89 77 34 66 C7 47 28 FF FF C6 47 63 01 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1078_0 {
	meta:
		name = "TProvider.Notification"
		size = 45
		refs = "0010 TComponent.Notification"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 10 83 7F 34 00 74 0A 3B 77 34 75 05 33 C0 89 47 34 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1079_0 {
	meta:
		name = "TProvider.DoOnGetData"
		size = 177
		refs = "0014 TProvider.DoOnGetData 0031 _Dn_TClientDataSet 0036 TClientDataSet.Create 0044 TClientDataSet.SetData 004f TClientDataSet.AppendData 0060 TClientDataSet.GetChangeCount 006c TClientDataSet.MergeChangeLog 0077 TClientDataSet.GetData 0081 @VarCopy 0089 TClientDataSet.EmptyDataSet 009e @VarClr 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 7B 76 00 74 68 8B 43 54 85 C0 75 1E 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 7B 54 8B D6 8B C7 E8 ?? ?? ?? ?? EB 09 8B D6 33 C9 E8 ?? ?? ?? ?? 8B 53 54 8B 43 78 FF 53 74 8B 43 54 E8 ?? ?? ?? ?? 85 C0 7E 1D 8B 43 54 E8 ?? ?? ?? ?? 8D 55 F0 8B 43 54 E8 ?? ?? ?? ?? 8D 55 F0 8B C6 E8 ?? ?? ?? ?? 8B 43 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1080_0 {
	meta:
		name = "TProvider.GetRecords"
		size = 540
		refs = "0021 TProvider.GetRecords 0038 SMissingDataSet 003d LoadResString 0045 DatabaseError 0073 TDataSet.GetActive 0082 TDataSet.Open 00a9 TDataSet.CheckBrowseMode 00c4 DbiSetToEnd 00e6 DbiSetToBegin 00f3 TDataSet.UpdateCursorPos 010b DbiGetPriorRecord 0122 TBDEDataSet.ConstraintCallBack 0139 DsProviderGetDataPacket 013e Check 0149 SafeArrayToVariant 0154 @OleVarFromVar 018b DbiGetNextRecord 01a3 TDataSet.CursorPosChanged 01c2 TProvider.DoOnGetData 01d1 @HandleAnyException 01e1 @RaiseAgain 01e6 @DoneExcept 01fb @VarClr 0203 @LStrClr 0209 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 78 34 00 75 15 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8A 1D ?? ?? ?? ?? 8B 45 FC 80 78 63 00 75 04 85 F6 75 10 80 CB 08 8B 45 FC 66 83 78 28 00 74 03 80 CB 02 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 84 C0 75 19 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 8B 45 FC C6 40 62 01 8B 45 FC C6 40 60 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 8B 45 FC 80 78 60 00 74 14 8B 45 FC 8B 40 34 8B 80 2C 01 00 00 50 E8 ?? ?? ?? ?? EB 45 83 FE FF 75 1D 8B 45 FC 83 78 5C 00 75 14 8B 45 FC 8B 40 34 8B 80 2C 01 00 00 50 E8 ?? ?? ?? ?? EB 23 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 8B 45 FC 8B 40 34 8B 80 2C 01 00 00 50 E8 ?? ?? ?? ?? 89 37 8D 45 F4 50 8D 45 F8 50 57 8B 45 FC 8B 40 34 50 68 ?? ?? ?? ?? 33 C0 8A C3 50 8B 45 FC 8B 40 34 8B 80 2C 01 00 00 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 E0 8B 45 F8 E8 ?? ?? ?? ?? 8D 55 E0 8B 45 08 E8 ?? ?? ?? ?? 8B 07 8B 55 FC 01 42 5C 3B 37 74 0C 33 D2 8B 45 FC 8B 08 FF 51 40 EB 4B 8B 45 FC C6 40 63 00 6A 00 6A 00 6A 00 8B 45 FC 8B 40 34 8B 80 2C 01 00 00 50 E8 ?? ?? ?? ?? 66 3D 02 22 0F 94 C0 8B 55 FC 88 42 60 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 34 8A 15 ?? ?? ?? ?? 8B 08 FF 91 A4 01 00 00 8B 55 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1A E9 ?? ?? ?? ?? 83 CA FF 8B 45 FC 8B 08 FF 51 40 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 00 00 00 00 }
	condition:
		$1
}

rule function_1081_0 {
	meta:
		name = "TProvider.Reset"
		size = 91
		refs = "001c TDataSet.Close 0028 TDataSet.GetActive 0034 TDataSet.First 004f TObject.Free"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 34 00 74 2C 80 7B 62 00 74 12 80 7B 61 00 75 0C 8B 43 34 E8 ?? ?? ?? ?? C6 43 62 00 8B 43 34 E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 34 E8 ?? ?? ?? ?? 66 F7 DE 1B C0 F7 D8 88 43 63 33 C0 89 43 5C C6 43 60 00 8B 43 54 E8 ?? ?? ?? ?? 33 C0 89 43 54 5E 5B C3 }
	condition:
		$1
}

rule function_1082_0 {
	meta:
		name = "_NF__D5"
		size = 339
		refs = "0019 _NF__D5 002f VarArrayHighBound 0038 TBDEDataSet.GetIndexFieldCount 0066 @VarArrayGet 0071 VarIsArray 00aa @VarToLStr 00b4 TDataSet.FieldByName 00f3 TBDEDataSet.GetIndexField 0130 @VarClr 0138 @LStrClr 0146 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 83 C0 F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B C7 E8 ?? ?? ?? ?? 3B D8 7C 0A 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 8B F3 85 F6 0F 8C CB 00 00 00 46 33 DB 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 75 6A 00 6A 01 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 DC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 8D 45 EC E8 ?? ?? ?? ?? 8B 55 EC 8B C7 E8 ?? ?? ?? ?? 50 6A 01 6A 01 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 DC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 58 8B 08 FF 51 7C EB 29 8B D3 8B C7 E8 ?? ?? ?? ?? 50 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 58 8B 08 FF 51 7C 43 4E 0F 85 38 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1083_0 {
	meta:
		name = "_NF__D6"
		size = 358
		refs = "0019 _NF__D6 002a VarIsNull 0042 VarArrayHighBound 004b TParams.Count 0079 @VarArrayGet 0084 VarIsArray 00bd @VarToLStr 00c7 TParams.ParamByName 00fb TParam.SetAsVariant 0106 TParams.GetParam 0143 @VarClr 014b @LStrClr 0159 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 84 C0 0F 85 FC 00 00 00 8B 45 08 83 C0 F0 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B C7 E8 ?? ?? ?? ?? 3B D8 7C 0A 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 8B F3 85 F6 0F 8C CB 00 00 00 46 33 DB 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 75 6A 00 6A 01 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 DC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 8D 45 EC E8 ?? ?? ?? ?? 8B 55 EC 8B C7 E8 ?? ?? ?? ?? 50 6A 01 6A 01 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 DC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 58 E8 ?? ?? ?? ?? EB 29 8B D3 8B C7 E8 ?? ?? ?? ?? 50 53 6A 01 8B 45 08 83 C0 F0 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 F0 58 E8 ?? ?? ?? ?? 43 4E 0F 85 38 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1084_0 {
	meta:
		name = "TProvider.SetParams"
		size = 374
		refs = "0029 @VarAddRef 0031 TProvider.SetParams 0049 VarIsNull 0055 VarIsArray 0075 VarArrayOf 0080 @OleVarFromVar 008b _Dn_TTable 0090 @IsClass 00a9 TTable.CancelRange 00b9 TDataSet.Open 00c0 TTable.SetRangeStart 00c9 _NF__D5 00d1 TTable.SetRangeEnd 00e2 TTable.ApplyRange 00f3 _Dn_TQuery 0106 _Dn_TStoredProc 012d _NF__D6 015b @VarClr 0169 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 33 C9 89 4D E0 89 4D E4 89 4D E8 89 4D EC 8B F2 8D 7D F0 B9 04 00 00 00 F3 A5 8B F8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7F 34 00 0F 84 05 01 00 00 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 75 33 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 75 27 57 8D 75 F0 8D 7D D0 B9 04 00 00 00 F3 A5 5F 8D 45 D0 8D 4D E0 33 D2 E8 ?? ?? ?? ?? 8D 55 E0 8D 45 F0 E8 ?? ?? ?? ?? 8B 5F 34 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 54 8B F3 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 10 8B C6 E8 ?? ?? ?? ?? C6 47 61 00 E9 8B 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 55 8B 47 34 E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? 55 8B 47 34 E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? C6 47 61 01 EB 55 8B 77 34 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 84 DB 75 11 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2E 8B 47 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 DB 74 0F 55 8B 86 F8 01 00 00 E8 ?? ?? ?? ?? 59 EB 0D 55 8B 86 F4 01 00 00 E8 ?? ?? ?? ?? 59 33 D2 8B C7 8B 08 FF 51 40 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1085_0 {
	meta:
		name = "_NF__DA"
		size = 199
		refs = "000d _NF__DA 001e _Dn_TQuery 0023 @IsClass 0040 @LStrAsg 0048 @LStrClr 0052 _Dn_TTable 0066 @LStrLen 0076 @LStrSetLength 007f TDBDataSet.GetDBLocale 0088 @LStrToPChar 0099 AnsiToNative 00bc @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 73 34 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 23 8D 55 FC 8B 86 F0 01 00 00 8B 08 FF 51 1C 8B 55 FC 8D 43 4C E8 ?? ?? ?? ?? 8D 43 48 E8 ?? ?? ?? ?? EB 57 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 46 8B 86 F8 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 2D 8D 43 48 8B D6 E8 ?? ?? ?? ?? 56 8B 43 34 E8 ?? ?? ?? ?? 50 8B 43 48 E8 ?? ?? ?? ?? 8B C8 8B 43 34 8B 90 F8 01 00 00 58 E8 ?? ?? ?? ?? 8D 43 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1086_0 {
	meta:
		name = "TProvider.DoOnUpdateData"
		size = 62
		refs = "0010 _Dn_TClientDataSet 0015 TClientDataSet.Create 0024 TClientDataSet.SetData 002e TClientDataSet.SetReadOnly"
	strings:
		$1 = { 53 56 8B D8 66 83 7B 6E 00 74 30 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 50 8D 53 38 8B C6 E8 ?? ?? ?? ?? B2 01 8B 43 50 E8 ?? ?? ?? ?? 8B 53 50 8B 43 70 FF 53 6C 5E 5B C3 }
	condition:
		$1
}

rule function_1087_0 {
	meta:
		name = "TProvider.ApplyUpdates"
		size = 526
		refs = "0046 @VarAddRef 004e TProvider.ApplyUpdates 0062 @VarCopy 0078 TProvider.DoOnUpdateData 008c SMissingDataSet 0091 LoadResString 009c DatabaseError 00a4 _NF__DA 00af TDBDataSet.OpenDatabase 00d9 _NF__E2 00fa @LStrToPChar 0110 TBDEDataSet.ConstraintCallBack 0151 DsResolver 0156 Check 0164 SafeArrayToVariant 0172 @OleVarFromVar 018d TDBDataSet.CloseDatabase 0193 @HandleFinally 01ad TObject.Free 01c1 Null 01e6 @VarClr 01f1 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 64 FF FF FF 53 56 57 33 DB 89 9D 64 FF FF FF 89 9D 68 FF FF FF 89 9D 6C FF FF FF 89 9D 70 FF FF FF 89 9D 74 FF FF FF 8B F2 8D 7D E8 51 B9 04 00 00 00 F3 A5 59 8B F1 89 45 FC 8B 5D 0C 8D 45 E8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 C0 38 8D 55 E8 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 78 34 00 75 1B 8D 95 74 FF FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 74 FF FF FF E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 89 45 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 FC 8B C6 89 42 58 89 03 8B 45 FC 66 83 78 66 00 74 07 B8 ?? ?? ?? ?? EB 02 33 C0 8B 55 FC 8B 52 40 89 55 C8 89 45 B8 8B 45 FC 89 45 A8 8B 45 FC 8B 40 48 E8 ?? ?? ?? ?? 89 45 88 8B 45 FC 8B 40 4C E8 ?? ?? ?? ?? 89 45 98 B8 ?? ?? ?? ?? 89 85 78 FF FF FF 8D 45 D8 50 53 8B 45 FC 8B 40 34 50 8D 85 78 FF FF FF 50 8D 45 B8 50 8D 45 A8 50 8D 45 88 50 8D 45 98 50 6A 00 6A 00 6A 00 8B 45 F8 8B 40 38 50 8D 45 C8 50 6A 01 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 95 64 FF FF FF 8B 45 D8 E8 ?? ?? ?? ?? 8D 95 64 FF FF FF 8B 45 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 34 8B 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 50 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 50 50 8B 45 FC 83 C0 38 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 64 FF FF FF E8 ?? ?? ?? ?? 8D 85 74 FF FF FF E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1088_0 {
	meta:
		name = "_NF__E2"
		size = 404
		refs = "0019 _NF__E2 0040 _Dn_TClientDataSet 0045 TClientDataSet.Create 005c TClientDataSet.SetData 008f TClientDataSet.SetAltRecBuffers 00d0 @LStrFromPChar 00f3 _DV_EUpdateError 00f8 EUpdateError.Create 00fd @RaiseExcept 010c @HandleOnException 0136 @DoneExcept 0145 @HandleAnyException 014a Application 0154 TApplication.HandleException 017d @LStrArrayClr 0183 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B 7D 28 8B 75 24 8B 5D 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 08 83 78 50 00 75 26 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 08 89 42 50 8B 45 08 8D 50 38 8B 45 08 8B 40 50 E8 ?? ?? ?? ?? 80 FB 02 75 06 C6 45 FE 02 EB 0F 80 FB 04 75 06 C6 45 FE 01 EB 04 C6 45 FE 00 80 7D FE 02 75 15 8B 45 2C 50 8B 45 08 8B 40 50 8B CF 8B D6 E8 ?? ?? ?? ?? EB 13 8B 45 2C 50 8B 45 08 8B 40 50 8B CE 8B D7 E8 ?? ?? ?? ?? 8B 45 08 83 78 58 00 74 06 C6 45 FF 00 EB 04 C6 45 FF 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 45 F8 8B 55 20 E8 ?? ?? ?? ?? 8B 45 F8 50 66 8B 45 18 50 66 8B 45 0C 50 8D 45 F4 8B 55 1C E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 2F E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 8A 55 FE 52 8D 55 FF 52 8B 55 08 8B 52 50 8B 5D 08 8B C8 8B 43 68 FF 53 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1D E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 55 08 E8 ?? ?? ?? ?? C6 45 FF 01 E8 ?? ?? ?? ?? 33 DB 8A 5D FF 43 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5F 5E 5B 8B E5 5D C2 28 00 }
	condition:
		$1
}

rule function_1090_0 {
	meta:
		name = "BdeProv"
		size = 31
		refs = "0002 _NV__B9 000a CreateProviderProc 001a _NF__C2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 15 A1 ?? ?? ?? ?? 83 38 00 75 0B A1 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1091_0 {
	meta:
		name = "InternalEditFont"
		size = 116
		refs = "000e _Dn_TFontDialog 0013 TFontDialog.Create 001e InternalEditFont 0061 TObject.Free 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 55 FC 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 40 4C 8B 55 FC 8B 08 FF 51 08 8B 45 F8 8B 10 FF 52 34 84 C0 74 0E 8B 45 F8 8B 50 4C 8B 45 FC 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 59 59 5D C3 }
	condition:
		$1
}

rule function_1092_0 {
	meta:
		name = "EditChartBrush"
		size = 88
		refs = "000c _DV_TBrushDialog 0011 TCustomForm.Create 001c EditChartBrush 0033 TCustomForm.ShowModal 0048 TObject.Free 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 89 98 F4 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1093_0 {
	meta:
		name = "TBrushDialog.RedrawShape"
		size = 82
		refs = "000a TBrush.GetStyle 001a TControl.SetEnabled 0025 TBrush.GetColor 0038 TBrush.SetColor 004c TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 84 C0 0F 95 C2 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 EC 01 00 00 8B 80 BC 00 00 00 E8 ?? ?? ?? ?? 8B 83 E8 01 00 00 8A 50 45 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1094_0 {
	meta:
		name = "TBrushDialog.FormShow"
		size = 118
		refs = "0005 Screen 000e TScreen.SetCursor 0015 _Dn_TChartBrush 001a TChartBrush.Create 003a TBrush.GetStyle 004b TCustomRadioGroup.SetItemIndex 006f TBrushDialog.RedrawShape"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 F8 01 00 00 8B 93 F4 01 00 00 8B C6 8B 08 FF 51 08 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 84 C0 75 0F 33 D2 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? EB 1B 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 33 D2 8A D0 4A 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1095_0 {
	meta:
		name = "TBrushDialog.RGStyleClick"
		size = 60
		refs = "001b TBrush.SetStyle 0036 TBrushDialog.RedrawShape"
	strings:
		$1 = { 53 8B D8 8B 83 DC 01 00 00 83 B8 24 01 00 00 00 75 0F 33 D2 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? EB 12 8A 90 24 01 00 00 42 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1096_0 {
	meta:
		name = "TBrushDialog.BColorClick"
		size = 45
		refs = "000d TBrush.GetColor 0016 EditColor 001f TBrush.SetColor 0026 TBrushDialog.RedrawShape"
	strings:
		$1 = { 53 56 8B D8 8B B3 F4 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1098_0 {
	meta:
		name = "TBrushDialog.Button3Click"
		size = 32
	strings:
		$1 = { 53 8B D8 8B 93 F8 01 00 00 8B 83 F4 01 00 00 8B 08 FF 51 08 C7 83 50 01 00 00 02 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1099_0 {
	meta:
		name = "TBrushDialog.FormClose"
		size = 12
		refs = "0007 TObject.Free"
	strings:
		$1 = { 8B 80 F8 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6029_0 {
	meta:
		name = "TQuery.ParamByName"
		size = 12
		refs = "0007 TParams.ParamByName"
	strings:
		$1 = { 8B 80 F8 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6020_0 {
	meta:
		name = "TQuery.SetParamsList"
		size = 12
		refs = "0007 TParams.AssignValues"
	strings:
		$1 = { 8B 80 F8 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1102_0 {
	meta:
		name = "TBubbleSeries.Create"
		size = 152
		refs = "000a @ClassCreate 0017 TPointSeries.Create 001c TBubbleSeries.Create 0025 _Dn_TChartValueList 002a TChartValueList.Create 003d TSeriesPointer.SetInflateMargins 004a TSeriesPointer.SetStyle 0057 TChartPen.SetVisible 0061 TSeriesMarks.SetBackTransparent 0071 TChartSeries.SetColorEachPoint"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 10 01 00 00 33 D2 8B 86 D4 00 00 00 E8 ?? ?? ?? ?? B2 01 8B 86 D4 00 00 00 E8 ?? ?? ?? ?? 8B 46 3C 8B 40 1C 33 D2 E8 ?? ?? ?? ?? B2 01 8B 46 3C E8 ?? ?? ?? ?? C6 86 14 01 00 00 01 B2 01 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 FF FF FF FF 06 00 00 00 52 61 64 69 75 73 00 00 }
	condition:
		$1
}

rule function_1105_0 {
	meta:
		name = "TBubbleSeries.AddBubble"
		size = 77
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B F0 FF 75 1C FF 75 18 FF 75 14 FF 75 10 8B 4D FC 8B C6 8B 18 FF 93 90 00 00 00 8B D8 8B 86 10 01 00 00 8B 55 08 89 50 18 8B 55 0C 89 50 1C 8B D3 8B C6 8B 08 FF 91 B8 00 00 00 8B C3 5E 5B 59 5D C2 18 00 }
	condition:
		$1
}

rule function_1106_0 {
	meta:
		name = "TBubbleSeries.FillSampleValues"
		size = 200
		refs = "0032 TChartSeries.CalcRandomBounds 0043 @ROUND 0048 @RandInt 0082 TBubbleSeries.FillSampleValues 009c TBubbleSeries.AddBubble 00af TChartSeries.RefreshSeries"
	strings:
		$1 = { 53 56 57 55 83 C4 CC 8B DA 8B F0 8B FC 8D 6C 24 20 8B C6 8B 10 FF 92 88 00 00 00 8D 44 24 10 50 8D 44 24 0C 50 8D 44 24 20 50 55 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 85 DB 7E 72 FF 77 04 FF 37 DD 45 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 30 DB 44 24 30 83 C4 F8 DD 1C 24 9B B8 19 00 00 00 E8 ?? ?? ?? ?? 83 C0 0A 89 44 24 3C DB 44 24 3C DC 7D 00 E8 ?? ?? ?? ?? 89 44 24 40 DB 44 24 40 DB 2D ?? ?? ?? ?? DC 4D 00 DE C1 83 C4 F8 DD 1C 24 9B B9 00 00 00 80 33 D2 8B C6 E8 ?? ?? ?? ?? DD 07 DC 44 24 10 DD 1F 9B 4B 75 8E 8B C6 E8 ?? ?? ?? ?? 83 C4 34 5D 5F 5E 5B C3 00 0A D7 A3 70 3D 0A D7 A3 FA 3F 00 00 }
	condition:
		$1
}

rule function_1107_0 {
	meta:
		name = "TBubbleSeries.DrawValue"
		size = 181
		refs = "0010 TChartValueList.GetValue 001e TChartSeries.CalcYSizeValue 0036 TSeriesPointer.ChangeHorizSize 0053 TChartSeries.CalcXSizeValue 006d TSeriesPointer.ChangeVertSize 0085 TSeriesPointer.PrepareCanvas"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B 83 10 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 8B F8 80 BB 14 01 00 00 00 74 0F 8B D7 8B 83 D4 00 00 00 E8 ?? ?? ?? ?? EB 28 8B D6 8B 83 10 01 00 00 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 D4 00 00 00 E8 ?? ?? ?? ?? 8B D7 8B 83 D4 00 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 51 48 8B F8 8B D7 8B 83 D4 00 00 00 E8 ?? ?? ?? ?? 57 56 8B D6 8B C3 8B 08 FF 91 B4 00 00 00 50 8B D6 8B C3 8B 08 FF 91 B0 00 00 00 8B D0 8B C3 59 8B 18 FF 93 10 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1108_0 {
	meta:
		name = "TBubbleSeries.MaxYValue"
		size = 105
		refs = "000b TChartSeries.MaxYValue 0016 TChartSeries.Count 0043 TChartValueList.GetValue 0053 MaxDouble"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F0 8B C6 E8 ?? ?? ?? ?? DD 1C 24 9B 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 3E 47 33 DB FF 74 24 04 FF 74 24 04 8B D3 8B C6 8B 08 FF 51 40 DD 5C 24 10 9B 8B D3 8B 86 10 01 00 00 E8 ?? ?? ?? ?? DC 44 24 10 83 C4 F8 DD 1C 24 9B E8 ?? ?? ?? ?? DD 1C 24 9B 43 4F 75 C5 DD 04 24 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1109_0 {
	meta:
		name = "TBubbleSeries.MinYValue"
		size = 105
		refs = "000b TChartSeries.MinYValue 0016 TChartSeries.Count 0043 TChartValueList.GetValue 0053 MinDouble"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F0 8B C6 E8 ?? ?? ?? ?? DD 1C 24 9B 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 3E 47 33 DB FF 74 24 04 FF 74 24 04 8B D3 8B C6 8B 08 FF 51 40 DD 5C 24 10 9B 8B D3 8B 86 10 01 00 00 E8 ?? ?? ?? ?? DC 6C 24 10 83 C4 F8 DD 1C 24 9B E8 ?? ?? ?? ?? DD 1C 24 9B 43 4F 75 C5 DD 04 24 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1110_0 {
	meta:
		name = "TBubbleSeries.Assign"
		size = 47
		refs = "000a _DV_TBubbleSeries 000f @IsClass 0028 TPointSeries.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8A 86 14 01 00 00 88 83 14 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1111_0 {
	meta:
		name = "TBubbleSeries.GetEditorClass"
		size = 48
		refs = "0006 TBubbleSeries.GetEditorClass 000b @LStrLAsg"
	strings:
		$1 = { 53 8B DA 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 00 00 00 FF FF FF FF 13 00 00 00 54 42 75 62 62 6C 65 53 65 72 69 65 73 45 64 69 74 6F 72 00 }
	condition:
		$1
}

rule function_1113_0 {
	meta:
		name = "TBubbleSeries.DrawLegendShape"
		size = 70
		refs = "0016 MinLong 0025 TSeriesPointer.ChangeHorizSize 0032 TSeriesPointer.ChangeVertSize 003d TCustomSeries.DrawLegendShape"
	strings:
		$1 = { 53 56 57 55 8B D9 8B EA 8B F0 8B 53 0C 2B 53 04 8B 43 08 2B 03 E8 ?? ?? ?? ?? 8B F8 8B D7 8B 86 D4 00 00 00 E8 ?? ?? ?? ?? 8B D7 8B 86 D4 00 00 00 E8 ?? ?? ?? ?? 8B CB 8B D5 8B C6 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1116_0 {
	meta:
		name = "TBubbleSeriesEditor.FormShow"
		size = 151
		refs = "0005 Screen 000e TScreen.SetCursor 002d TCustomCheckBox.SetChecked 0043 TCustomRadioGroup.SetItemIndex 005b TControl.SetEnabled 007d TBrush.GetColor"
	strings:
		$1 = { 53 56 8B D8 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B 43 0C 89 83 F8 01 00 00 8B F0 8B 86 D4 00 00 00 8A 50 0C 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B 86 D4 00 00 00 33 D2 8A 50 0D 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 8B 86 D4 00 00 00 80 78 0D 00 0F 94 C2 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B 86 D4 00 00 00 8A 50 19 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 8B 86 D4 00 00 00 8B 40 14 E8 ?? ?? ?? ?? 3D 00 00 00 80 0F 94 C2 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1117_0 {
	meta:
		name = "TBubbleSeriesEditor.CB3dPointClick"
		size = 35
		refs = "000a TCustomCheckBox.GetChecked 001d TSeriesPointer.Set3D"
	strings:
		$1 = { 53 8B D8 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 F8 01 00 00 8B 80 D4 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1118_0 {
	meta:
		name = "TBubbleSeriesEditor.BPointFillColorClick"
		size = 60
		refs = "0016 TBrush.GetColor 001f EditColor 0028 TBrush.SetColor 0035 TCustomCheckBox.SetChecked"
	strings:
		$1 = { 53 56 8B D8 8B 83 F8 01 00 00 8B 80 D4 00 00 00 8B 70 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 33 D2 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1119_0 {
	meta:
		name = "TBubbleSeriesEditor.CBPointColorDefClick"
		size = 45
		refs = "000a TCustomCheckBox.GetChecked 0027 TBrush.SetColor"
	strings:
		$1 = { 53 8B D8 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 19 8B 83 F8 01 00 00 8B 80 D4 00 00 00 8B 40 14 BA 00 00 00 80 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1120_0 {
	meta:
		name = "TBubbleSeriesEditor.BPoinPenColClick"
		size = 21
		refs = "0010 EditChartPen"
	strings:
		$1 = { 8B 90 F8 01 00 00 8B 92 D4 00 00 00 8B 52 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1121_0 {
	meta:
		name = "TBubbleSeriesEditor.FormCreate"
		size = 9
	strings:
		$1 = { 33 D2 89 90 F8 01 00 00 C3 }
	condition:
		$1
}

rule function_1122_0 {
	meta:
		name = "TBubbleSeriesEditor.CBInflateClick"
		size = 35
		refs = "000a TCustomCheckBox.GetChecked 001d TSeriesPointer.SetInflateMargins"
	strings:
		$1 = { 53 8B D8 8B 83 E0 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 F8 01 00 00 8B 80 D4 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1123_0 {
	meta:
		name = "TBubbleSeriesEditor.RGStyleClick"
		size = 64
		refs = "001c TSeriesPointer.SetStyle 003a TControl.SetEnabled"
	strings:
		$1 = { 53 8B D8 8B 83 E8 01 00 00 8A 90 24 01 00 00 8B 83 F8 01 00 00 8B 80 D4 00 00 00 E8 ?? ?? ?? ?? 8B 83 F8 01 00 00 8B 80 D4 00 00 00 80 78 0D 00 0F 94 C2 8B 83 DC 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1126_0 {
	meta:
		name = "_NF__15C"
		size = 88
	strings:
		$1 = { 42 42 4F 4B 00 00 00 00 42 42 43 41 4E 43 45 4C 00 00 00 00 42 42 48 45 4C 50 00 00 42 42 59 45 53 00 00 00 42 42 4E 4F 00 00 00 00 42 42 43 4C 4F 53 45 00 42 42 41 42 4F 52 54 00 42 42 52 45 54 52 59 00 42 42 49 47 4E 4F 52 45 00 00 00 00 42 42 41 4C 4C 00 00 00 }
	condition:
		$1
}

rule function_1127_0 {
	meta:
		name = "DrawButtonFace"
		size = 624
		refs = "0019 NewStyleControls 0049 TBrush.SetColor 0053 TBrush.SetStyle 005a TCanvas.GetHandle 0070 DrawEdge 00eb TPen.SetColor 0117 TCanvas.Rectangle 012f TCanvas.SetPixel 017c InflateRect 01c6 Frame3D 01e4 Point 0233 TCanvas.Polyline 0250 Rect 0263 OffsetRect"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 89 4D FC 8B F2 8B D8 8B 45 18 84 C0 75 0B 8B 15 ?? ?? ?? ?? 80 3A 00 75 08 3C 02 74 04 33 C0 EB 02 B0 01 56 8D 7D EC B9 04 00 00 00 F3 A5 5E 84 C0 0F 84 A2 00 00 00 BA 0F 00 00 80 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 80 7D 10 00 74 3E 6A 03 6A 08 8D 45 EC 50 53 E8 ?? ?? ?? ?? 6A 0C 6A 02 8D 45 EC 50 53 E8 ?? ?? ?? ?? FF 4D F8 FF 4D F4 FF 45 F0 FF 45 EC 68 03 08 00 00 6A 02 8D 45 EC 50 53 E8 ?? ?? ?? ?? E9 93 01 00 00 6A 0C 6A 01 8D 45 EC 50 53 E8 ?? ?? ?? ?? FF 4D F8 FF 4D F4 6A 03 6A 04 8D 45 EC 50 53 E8 ?? ?? ?? ?? FF 45 F0 FF 45 EC 68 0C 08 00 00 6A 04 8D 45 EC 50 53 E8 ?? ?? ?? ?? E9 55 01 00 00 BA 06 00 00 80 8B 43 10 E8 ?? ?? ?? ?? BA 0F 00 00 80 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 4D F0 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 80 7D 14 00 74 4C 68 0F 00 00 80 8B 4D F0 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 68 0F 00 00 80 8B 4D F8 49 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 68 0F 00 00 80 8B 55 F4 4A 8B 4D F0 8B C3 E8 ?? ?? ?? ?? 68 0F 00 00 80 8B 4D F8 49 8B 55 F4 4A 8B C3 E8 ?? ?? ?? ?? 80 7D 0C 00 74 2C 6A FF 6A FF 8D 45 EC 50 E8 ?? ?? ?? ?? B2 01 8B 43 14 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F8 50 8B 4D F0 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 EC 50 E8 ?? ?? ?? ?? 80 7D 10 00 75 1A 68 10 00 00 80 8B 45 FC 50 8D 55 EC B9 14 00 00 80 8B C3 E8 ?? ?? ?? ?? EB 6B BA 10 00 00 80 8B 43 10 E8 ?? ?? ?? ?? 8D 4D CC 8B 55 F8 4A 8B 45 EC E8 ?? ?? ?? ?? 8B 45 CC 89 45 D4 8B 45 D0 89 45 D8 8D 4D C4 8B 55 F0 8B 45 EC E8 ?? ?? ?? ?? 8B 45 C4 89 45 DC 8B 45 C8 89 45 E0 8D 4D BC 8B 55 F0 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 BC 89 45 E4 8B 45 C0 89 45 E8 8D 55 D4 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 46 0C 83 E8 02 50 8B 45 08 50 8B 4E 08 83 E9 02 8B 56 04 42 8B 06 40 E8 ?? ?? ?? ?? 80 7D 10 00 74 0D 6A 01 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_1128_0 {
	meta:
		name = "_NF__168"
		size = 142
		refs = "000d _NF__168 001f _NV__15F 0029 _Dn_TBitmap 002e TBitmap.Create 003f _NV__15B 0044 @LStrFromPChar 004d HInstance 005f TBitmap.LoadFromResourceName 007b @LStrClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B F3 83 E6 7F 83 3C B5 ?? ?? ?? ?? 00 75 3D B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 B5 ?? ?? ?? ?? 8D 45 FC 8B 14 B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC 8B 15 ?? ?? ?? ?? 8B 12 33 C0 8A C3 8B 04 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 1C B5 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1129_0 {
	meta:
		name = "_NF__16F"
		size = 71
		refs = "000d @ClassCreate 001e TCustomImageList.CreateSize 0025 _Dn_TBits 002a TObject.Create"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 64 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1130_0 {
	meta:
		name = "_NF__170"
		size = 42
		refs = "000a TObject.Free 0016 TCustomImageList.Destroy 0021 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 64 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1131_0 {
	meta:
		name = "_NF__171"
		size = 63
		refs = "0008 TBits.OpenBit 001d TCustomImageList.Add 002a TBits.SetSize 0036 TBits.SetBit"
	strings:
		$1 = { 53 56 8B D8 8B 43 64 E8 ?? ?? ?? ?? 8B F0 8B 43 64 3B 70 04 7C 18 33 C9 33 D2 8B C3 E8 ?? ?? ?? ?? 8B F0 8D 56 01 8B 43 64 E8 ?? ?? ?? ?? B1 01 8B D6 8B 43 64 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1132_0 {
	meta:
		name = "_NF__172"
		size = 41
		refs = "000d _NF__171 001b TCustomImageList.ReplaceMasked"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 55 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? FF 43 68 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1133_0 {
	meta:
		name = "_NF__173"
		size = 38
		refs = "000c TBits.GetBit 001f TBits.SetBit"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 64 E8 ?? ?? ?? ?? 84 C0 74 0F FF 4B 68 33 C9 8B D6 8B 43 64 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1134_0 {
	meta:
		name = "TComponentList.Create"
		size = 61
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TList"
		altNames = "TQRExportFilterLibrary.Create _NF__174 _NF__1A6 _NF__1B8"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12507_0 {
	meta:
		name = "TQRLibrary.Create"
		size = 61
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TStringList"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1135_0 {
	meta:
		name = "TComponentList.Destroy"
		size = 42
		refs = "000a TObject.Free 0016 TObject.Destroy 0021 @ClassDestroy"
		altNames = "TQRExportFilterLibrary.Destroy TQRLibrary.Destroy _NF__175"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7775_0 {
	meta:
		name = "TPicture.Destroy"
		size = 42
		refs = "000a TObject.Free 0016 TPersistent.Destroy 0021 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9074_0 {
	meta:
		name = "TVirtualStream.Destroy"
		size = 42
		refs = "000a TInterface.Free 0016 TObject.Destroy 0021 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1136_0 {
	meta:
		name = "_NF__176"
		size = 93
		refs = "001e TList.Get 0040 _NV__169 0045 _NF__16F 0051 TList.Add"
	strings:
		$1 = { 53 56 57 55 51 89 0C 24 8B EA 8B F8 8B 47 04 8B 70 08 4E 83 FE 00 7C 1F 8B D6 8B 47 04 E8 ?? ?? ?? ?? 8B D8 3B 6B 28 75 08 8B 04 24 3B 43 24 74 24 4E 83 FE FF 75 E1 8B 04 24 50 8B CD B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D3 8B 47 04 E8 ?? ?? ?? ?? 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1137_0 {
	meta:
		name = "_NF__177"
		size = 32
		refs = "0013 TList.Remove 001a TObject.Free"
	strings:
		$1 = { 53 8B DA 85 DB 74 17 83 7B 68 00 75 11 8B D3 8B 40 04 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1138_0 {
	meta:
		name = "_NF__178"
		size = 11
	strings:
		$1 = { 8B 40 04 83 78 08 00 0F 94 C0 C3 }
	condition:
		$1
}

rule function_1139_0 {
	meta:
		name = "_NF__17C"
		size = 193
		refs = "0007 _NV__17A 000e _Dn_TBitmap 0013 TBitmap.Create 0034 TBitmap.GetCanvas 0040 TBrush.SetStyle 004d TBrush.SetColor 006c Rect 0075 TCanvas.FillRect 00aa TCanvas.SetPixel"
	strings:
		$1 = { 53 56 57 83 C4 F0 BB ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 03 BA 08 00 00 00 8B 03 8B 08 FF 51 40 BA 08 00 00 00 8B 03 8B 08 FF 51 34 8B 03 E8 ?? ?? ?? ?? 8B F8 33 D2 8B 47 14 E8 ?? ?? ?? ?? BA 0F 00 00 80 8B 47 14 E8 ?? ?? ?? ?? 8B 03 8B 10 FF 52 20 50 8D 44 24 04 50 8B 03 8B 10 FF 52 2C 8B C8 33 D2 33 C0 E8 ?? ?? ?? ?? 8B D4 8B C7 E8 ?? ?? ?? ?? 33 F6 33 DB 8B C6 25 01 00 00 80 79 05 48 83 C8 FE 40 8B D3 81 E2 01 00 00 80 79 05 4A 83 CA FE 42 3B C2 75 10 68 14 00 00 80 8B CE 8B D3 8B C7 E8 ?? ?? ?? ?? 43 83 FB 08 75 C9 46 83 FE 08 75 C1 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1140_0 {
	meta:
		name = "_NF__17D"
		size = 138
		refs = "000e @ClassCreate 001c TObject.Create 0023 _Dn_TBitmap 0028 TBitmap.Create 0037 _NF__180 005b _NV__179 0065 _NV__16B 006a _NF__174"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 04 89 5E 08 C7 46 04 ?? ?? ?? ?? C7 43 1C 80 80 00 00 C6 43 20 01 33 C0 33 D2 8A D0 C7 44 93 0C FF FF FF FF 40 3C 04 75 EF 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1141_0 {
	meta:
		name = "_NF__17E"
		size = 89
		refs = "000a TObject.Free 0011 _NF__17F 0017 _NV__179 0024 _NF__178 0045 TObject.Destroy 0050 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 04 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 1F A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1142_0 {
	meta:
		name = "_NF__17F"
		size = 71
		refs = "001f _NF__173 0035 _NV__179 003a _NF__177"
	strings:
		$1 = { 53 56 57 8B F0 33 DB 8B FB 83 E7 7F 8B 44 BE 0C 83 F8 FF 74 0E 33 D2 8A D3 8B D0 8B 46 08 E8 ?? ?? ?? ?? C7 44 BE 0C FF FF FF FF 43 80 FB 04 75 D6 8B 56 08 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 46 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1143_0 {
	meta:
		name = "_NF__180"
		size = 46
		refs = "000e TBitmap.GetTransparentColor 0018 _NF__17F"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 3B D6 75 20 8B C6 E8 ?? ?? ?? ?? 89 43 1C 8B C3 E8 ?? ?? ?? ?? 66 83 7B 26 00 74 08 8B D3 8B 43 28 FF 53 24 5E 5B C3 }
	condition:
		$1
}

rule function_1144_0 {
	meta:
		name = "_NF__181"
		size = 118
		refs = "0009 _NF__17F 0029 TBitmap.GetTransparentColor 006f _NF__182"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 46 04 8B 08 FF 51 08 85 DB 74 58 8B C3 8B 10 FF 52 20 85 C0 7E 4D 8B C3 E8 ?? ?? ?? ?? 89 46 1C 8B C3 8B 10 FF 52 2C 50 8B C3 8B 10 FF 52 20 5A 92 8B CA 99 F7 F9 85 D2 75 29 8B C3 8B 10 FF 52 2C 50 8B C3 8B 10 FF 52 20 5A 92 8B CA 99 F7 F9 83 F8 04 7E 05 B8 01 00 00 00 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1145_0 {
	meta:
		name = "_NF__182"
		size = 38
		refs = "0012 _NF__17F 001f _NF__180"
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 5E 20 74 18 84 DB 76 14 8B C6 E8 ?? ?? ?? ?? 88 5E 20 8B 56 04 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1146_0 {
	meta:
		name = "_NF__183"
		size = 1494
		refs = "0088 _NV__179 0092 _NV__16B 0097 _NF__174 00aa _NF__176 00b7 _Dn_TBitmap 00bc TBitmap.Create 00c7 _NF__183 00f1 Rect 00f9 TBitmap.GetCanvas 0106 TBrush.SetColor 0116 CopyPalette 017a TCanvas.CopyRect 019a _NF__172 0258 TBitmap.SetMonochrome 02b7 TCanvas.GetHandle 02c1 SetTextColor 02cc SetBkColor 02ef BitBlt 037d ColorToRGB 043e TBitmap.GetMonochrome 0457 TFont.SetColor 04a1 TCanvas.FillRect 0566 TObject.Free 0574 @HandleFinally 05c9 TBitmap.Dormant"
	strings:
		$1 = { 55 8B EC 83 C4 C8 53 56 57 88 55 FB 89 45 FC 80 7D FB 02 75 0D 8B 45 FC 80 78 20 03 73 04 C6 45 FB 00 33 C0 8A 45 FB 8B 55 FC 8B 5C 82 0C 83 FB FF 0F 85 96 05 00 00 8B 45 FC 8B 40 04 8B 10 FF 52 2C 8B F0 8B 45 FC 8B 40 04 8B 10 FF 52 20 0B F0 0F 84 76 05 00 00 8B 45 FC 8B 40 04 8B 10 FF 52 2C 8B 55 FC 0F B6 52 20 8B CA 99 F7 F9 8B F8 8B 45 FC 8B 40 04 8B 10 FF 52 20 8B F0 8B 45 FC 83 78 08 00 75 2E 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B CE 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B 45 F4 8B 08 FF 51 40 8B D6 8B 45 F4 8B 08 FF 51 34 56 8D 45 D8 50 8B CF 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 04 8B 10 FF 52 24 E8 ?? ?? ?? ?? 8B D0 8B 45 F4 8B 08 FF 51 38 8A 5D FB 8B 45 FC 3A 58 20 7C 02 33 DB 56 8D 45 C8 50 33 C9 8A CB 41 0F AF CF 33 C0 8A C3 F7 EF 33 D2 E8 ?? ?? ?? ?? 8A 45 FB 2C 01 72 0B 74 7F 48 2C 02 0F 83 3C 04 00 00 8D 45 C8 50 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 50 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 04 80 78 28 01 75 25 8B 45 FC 8B 48 1C 8B 45 FC 8B 40 08 8B 55 F4 E8 ?? ?? ?? ?? 33 D2 8A 55 FB 8B 4D FC 89 44 91 0C E9 EA 03 00 00 8B 45 FC 8B 40 08 B9 00 00 00 20 8B 55 F4 E8 ?? ?? ?? ?? 33 D2 8A 55 FB 8B 4D FC 89 44 91 0C E9 C6 03 00 00 33 C0 89 45 EC 33 C0 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC 8B 50 04 8B 45 F0 8B 08 FF 51 08 B2 01 8B 45 F0 8B 08 FF 51 68 8B 45 FC 80 78 20 01 0F 86 D8 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? 89 45 E8 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 8B C8 8D 55 D8 8B 45 E8 E8 ?? ?? ?? ?? B2 01 8B 45 EC E8 ?? ?? ?? ?? 8B D7 8B 45 EC 8B 08 FF 51 40 8B D6 8B 45 EC 8B 08 FF 51 34 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 BA FF FF FF 00 E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 E8 8B 40 14 BA 14 00 00 80 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 6A 00 53 E8 ?? ?? ?? ?? 68 FF FF FF 00 53 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 53 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 BA 80 80 80 00 E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 E8 8B 40 14 BA 10 00 00 80 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 6A 00 53 E8 ?? ?? ?? ?? 68 FF FF FF 00 53 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 53 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 50 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 5A E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC E8 ?? ?? ?? ?? 8D 55 D8 59 E8 ?? ?? ?? ?? 8B 45 E8 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 6A 00 53 E8 ?? ?? ?? ?? 68 FF FF FF 00 53 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 53 E8 ?? ?? ?? ?? E9 4F 01 00 00 8B 45 FC 8B 50 04 8B 45 EC 8B 08 FF 51 08 B2 01 8B 45 EC 8B 08 FF 51 68 8B 45 EC E8 ?? ?? ?? ?? 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B D7 8B 45 EC 8B 08 FF 51 40 8B 45 EC E8 ?? ?? ?? ?? 84 C0 74 34 8B 45 EC E8 ?? ?? ?? ?? 8B 40 0C BA FF FF FF 00 E8 ?? ?? ?? ?? 33 D2 8B 45 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B 40 14 BA FF FF FF 00 E8 ?? ?? ?? ?? B2 01 8B 45 EC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 8B 43 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 43 14 BA 14 00 00 80 E8 ?? ?? ?? ?? 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 FF FF FF 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 01 6A 01 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 43 14 BA 10 00 00 80 E8 ?? ?? ?? ?? 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 FF FF FF 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 46 07 E2 00 6A 00 6A 00 8B 45 EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 6A 00 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B 45 FC 8B 40 08 B9 00 00 00 20 8B 55 F4 E8 ?? ?? ?? ?? 33 D2 8A 55 FB 8B 4D FC 89 44 91 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 8A 45 FB 8B 55 FC 8B 5C 82 0C 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1147_0 {
	meta:
		name = "_NF__184"
		size = 186
		refs = "003a _NF__183 0067 TCanvas.GetHandle 0071 TCustomImageList.GetHandle 0077 ImageList_DrawEx 008a ColorToRGB"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 89 55 FC 8B D8 83 7B 04 00 0F 84 9A 00 00 00 8B 43 04 8B 10 FF 52 2C 85 C0 0F 84 8A 00 00 00 8B 43 04 8B 10 FF 52 20 85 C0 74 7E 8A 55 0C 8B C3 E8 ?? ?? ?? ?? 8B F8 80 7D 08 00 75 06 80 7D 0C 03 75 31 6A 01 68 FF FF FF 1F 68 FF FF FF 1F 6A 00 6A 00 8B 46 04 50 8B 06 50 8B 45 FC E8 ?? ?? ?? ?? 50 57 8B 43 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 35 6A 00 68 FF FF FF 1F B8 0F 00 00 80 E8 ?? ?? ?? ?? 50 6A 00 6A 00 8B 46 04 50 8B 06 50 8B 45 FC E8 ?? ?? ?? ?? 50 57 8B 43 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1148_0 {
	meta:
		name = "_NF__185"
		size = 207
		refs = "0022 TBrush.SetStyle 0035 OffsetRect 0042 TFont.SetColor 004f @LStrLen 0057 @LStrToPChar 0061 TCanvas.GetHandle 0067 DrawText"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B 75 0C 8D 7D F0 51 B9 04 00 00 00 F3 A5 59 8B F1 8B DA B2 01 8B 43 14 E8 ?? ?? ?? ?? 80 7D 08 01 75 77 6A 01 6A 01 8D 45 F0 50 E8 ?? ?? ?? ?? BA 14 00 00 80 8B 43 0C E8 ?? ?? ?? ?? 6A 00 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 8B F8 57 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 F0 50 E8 ?? ?? ?? ?? BA 10 00 00 80 8B 43 0C E8 ?? ?? ?? ?? 6A 00 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 57 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 23 6A 25 8D 45 F0 50 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1149_0 {
	meta:
		name = "_NF__186"
		size = 744
		refs = "0026 Point 0071 @LStrLen 0089 Rect 00ae @LStrToPChar 00b7 TCanvas.GetHandle 00bd DrawText 02db OffsetRect"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 57 8B D9 89 55 F8 89 45 FC 8B 7D 08 8B 75 0C 8B 53 0C 2B 53 04 8B 43 08 2B 03 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 FC 83 78 04 00 74 2E 8B 45 FC 8B 40 04 8B 10 FF 52 20 50 8B 45 FC 8B 40 04 8B 10 FF 52 2C 8B 55 FC 0F B6 52 20 8B CA 99 F7 F9 8D 4D E0 5A E8 ?? ?? ?? ?? EB 0C 8D 4D E0 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 1C E8 ?? ?? ?? ?? 85 C0 7E 5D 6A 00 8D 45 C0 50 8B 4B 08 2B 0B 33 D2 33 C0 E8 ?? ?? ?? ?? 56 57 8D 75 C0 B9 04 00 00 00 F3 A5 5F 5E 68 00 04 00 00 57 8B 45 1C E8 ?? ?? ?? ?? 50 8B 45 1C E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 57 0C 2B 57 04 8B 47 08 2B 07 8D 4D D8 E8 ?? ?? ?? ?? EB 2B 6A 00 8D 45 C0 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 56 57 8D 75 C0 B9 04 00 00 00 F3 A5 5F 5E 8D 4D D8 33 D2 33 C0 E8 ?? ?? ?? ?? 8A 45 18 2C 02 73 23 8B 45 EC 8B D0 2B 55 E4 42 D1 FA 79 03 83 D2 00 89 56 04 2B 45 DC 40 D1 F8 79 03 83 D0 00 89 45 F4 EB 20 8B 45 E8 8B D0 2B 55 E0 42 D1 FA 79 03 83 D2 00 89 16 2B 45 D8 40 D1 F8 79 03 83 D0 00 89 45 F0 83 7D D8 00 74 06 83 7D E0 00 75 05 33 C0 89 45 10 83 7D 14 FF 0F 85 97 00 00 00 83 7D 10 FF 75 4A 8D 4D D0 8B 55 E4 03 55 DC 8B 45 E0 03 45 D8 E8 ?? ?? ?? ?? 8A 45 18 2C 02 73 13 8B 45 E8 2B 45 D0 B9 03 00 00 00 99 F7 F9 89 45 14 EB 11 8B 45 EC 2B 45 D4 B9 03 00 00 00 99 F7 F9 89 45 14 8B 45 14 89 45 10 E9 96 00 00 00 8D 4D D0 8B 55 E4 03 55 10 03 55 DC 8B 45 E0 03 45 10 03 45 D8 E8 ?? ?? ?? ?? 8A 45 18 2C 02 73 13 8B 45 E8 2B 45 D0 40 D1 F8 79 03 83 D0 00 89 45 14 EB 62 8B 45 EC 2B 45 D4 40 D1 F8 79 03 83 D0 00 89 45 14 EB 4F 83 7D 10 FF 75 49 8B 45 14 03 45 E4 8B 55 EC 2B D0 8B 45 14 03 45 E0 50 8B 45 E8 59 2B C1 8D 4D D0 E8 ?? ?? ?? ?? 8A 45 18 2C 02 73 12 8B 45 D0 2B 45 D8 D1 F8 79 03 83 D0 00 89 45 10 EB 10 8B 45 D4 2B 45 DC D1 F8 79 03 83 D0 00 89 45 10 8A 45 18 2C 01 72 0C 74 1A FE C8 74 2C FE C8 74 39 EB 4C 8B 45 14 89 06 03 45 E0 03 45 10 89 45 F0 EB 3C 8B 45 E8 2B 45 14 2B 45 E0 89 06 2B 45 10 2B 45 D8 89 45 F0 EB 26 8B 45 14 89 46 04 03 45 E4 03 45 10 89 45 F4 EB 15 8B 45 EC 2B 45 14 2B 45 E4 89 46 04 2B 45 10 2B 45 DC 89 45 F4 8B 03 8B 55 20 03 02 01 06 8B 43 04 8B 55 20 03 42 04 01 46 04 8B 53 04 03 55 F4 8B 45 20 8B 00 03 D0 52 8B 13 03 55 F0 8B 4D 20 03 D0 52 57 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule function_1150_0 {
	meta:
		name = "_NF__187"
		size = 104
		refs = "0034 _NF__186 0048 _NF__184 005b _NF__185"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 20 8B 45 24 50 57 8A 45 1C 50 8B 45 18 50 8B 45 14 50 8D 45 F4 50 8B 45 08 50 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 8A 45 10 50 8A 45 0C 50 8D 4D F4 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 45 08 50 8A 45 10 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule function_1151_0 {
	meta:
		name = "TSpeedButton.Create"
		size = 160
		refs = "000e @ClassCreate 001c TGraphicControl.Create 0031 TSpeedButton.Create 003c _NV__16D 0041 _NF__17D 0057 _NF__1B5 0060 TControl.SetParentFont 0081 _NV__17B"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 19 6A 19 33 C9 33 D2 8B C3 8B 30 FF 56 4C 66 A1 ?? ?? ?? ?? 66 89 43 40 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 BC 00 00 00 8B 83 BC 00 00 00 89 58 28 C7 40 24 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? C7 83 C4 00 00 00 04 00 00 00 C7 83 C8 00 00 00 FF FF FF FF C6 83 C3 00 00 00 00 FF 05 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 C2 00 00 00 }
	condition:
		$1
}

rule function_1152_0 {
	meta:
		name = "TSpeedButton.Destroy"
		size = 77
		refs = "000d TObject.Free 0013 _NV__17B 0021 _NV__17A 0039 TGraphicControl.Destroy 0044 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 BC 00 00 00 E8 ?? ?? ?? ?? FF 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 11 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1153_0 {
	meta:
		name = "TSpeedButton.Paint"
		size = 524
		refs = "0013 TSpeedButton.Paint 0068 TCanvas.SetFont 007c Rect 00ae TCanvas.GetHandle 00b4 DrawFrameControl 00e9 _NV__190 0104 _NV__18F 011a DrawEdge 0127 InflateRect 0154 _NV__17A 015c _NF__17C 0170 TBrush.SetBitmap 017e TCanvas.FillRect 01a6 TControl.GetText 01e5 _NF__187 01fa @LStrClr 0200 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 33 D2 89 55 D4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 45 00 75 10 C6 83 CE 00 00 00 01 C6 83 C1 00 00 00 00 EB 2B 80 BB CE 00 00 00 01 75 22 80 BB C0 00 00 00 00 74 12 83 BB B8 00 00 00 00 74 09 C6 83 CE 00 00 00 03 EB 07 C6 83 CE 00 00 00 00 8B 53 50 8B 83 B4 00 00 00 E8 ?? ?? ?? ?? 8B 43 3C 50 8D 45 E8 50 8B 4B 38 33 D2 33 C0 E8 ?? ?? ?? ?? 80 BB CC 00 00 00 00 75 31 BE 10 20 00 00 8A 83 CE 00 00 00 04 FE 2C 02 73 06 81 CE 00 02 00 00 56 6A 04 8D 45 E8 50 8B 83 B4 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 71 8A 83 CE 00 00 00 04 FE 2C 02 72 18 80 BB CD 00 00 00 00 74 09 80 BB CE 00 00 00 01 75 06 F6 43 20 10 74 40 33 C0 8A 83 CC 00 00 00 8B 04 85 ?? ?? ?? ?? 83 C8 0F 50 8A 83 CE 00 00 00 04 FE 2C 02 0F 92 C0 83 E0 7F 8B 04 85 ?? ?? ?? ?? 50 8D 45 E8 50 8B 83 B4 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? 8A 83 CE 00 00 00 04 FE 2C 02 73 5B 80 BB CE 00 00 00 03 75 42 80 BB CC 00 00 00 00 74 09 80 BB CD 00 00 00 00 75 30 83 3D ?? ?? ?? ?? 00 75 05 E8 ?? ?? ?? ?? 8B 83 B4 00 00 00 8B 40 14 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 E8 8B 83 B4 00 00 00 E8 ?? ?? ?? ?? C7 45 F8 01 00 00 00 C7 45 FC 01 00 00 00 EB 0A 33 C0 89 45 F8 33 C0 89 45 FC 8D 45 F8 50 8D 55 D4 8B C3 E8 ?? ?? ?? ?? 8B 45 D4 50 8A 83 C3 00 00 00 50 8B 83 C8 00 00 00 50 8B 83 C4 00 00 00 50 8A 83 CE 00 00 00 50 8A 83 CC 00 00 00 50 8D 45 D8 50 8D 4D E8 8B 93 B4 00 00 00 8B 83 BC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1154_0 {
	meta:
		name = "_NF__193"
		size = 94
		refs = "0018 GetCursorPos 0021 FindDragTarget 0043 TControl.Perform"
	strings:
		$1 = { 53 56 83 C4 F8 8B F0 80 BE CC 00 00 00 00 74 49 80 7E 45 00 74 43 54 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 3B F0 0F 94 C3 80 F3 01 88 9E CD 00 00 00 84 DB 74 12 6A 00 33 C9 BA 14 B0 00 00 8B C6 E8 ?? ?? ?? ?? EB 10 6A 00 33 C9 BA 13 B0 00 00 8B C6 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1155_0 {
	meta:
		name = "TSpeedButton.Loaded"
		size = 37
		refs = "0006 TComponent.Loaded 001f _NF__183"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 7B 45 00 74 04 33 C0 EB 02 B0 01 8B D0 8B 83 BC 00 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1156_0 {
	meta:
		name = "TSpeedButton.MouseDown"
		size = 80
		refs = "001d TControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 8A 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 84 DB 75 24 80 7E 45 00 74 1E 80 BE C0 00 00 00 00 75 0E C6 86 CE 00 00 00 02 8B C6 8B 10 FF 52 44 C6 86 C1 00 00 00 01 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1157_0 {
	meta:
		name = "TSpeedButton.MouseMove"
		size = 142
		refs = "001a TControl.MouseMove 0041 TControl.GetClientWidth 0050 TControl.GetClientHeight"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 88 55 FF 8B D8 8B 7D 08 57 8B CE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB C1 00 00 00 00 74 5F 80 BB C0 00 00 00 00 75 06 C6 45 FE 00 EB 04 C6 45 FE 03 85 F6 7C 2D 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 22 85 FF 7C 1E 8B C3 E8 ?? ?? ?? ?? 3B F8 7F 13 80 BB C0 00 00 00 00 74 06 C6 45 FE 03 EB 04 C6 45 FE 02 8A 45 FE 3A 83 CE 00 00 00 74 10 8A 45 FE 88 83 CE 00 00 00 8B C3 8B 10 FF 52 44 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1158_0 {
	meta:
		name = "TSpeedButton.MouseUp"
		size = 233
		refs = "0020 TControl.MouseUp 003f TControl.GetClientWidth 004e TControl.GetClientHeight 009e TSpeedButton.SetDown 00d6 @CallDynaInst 00dd _NF__193"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FE 88 55 FF 8B F0 8B 7D 08 8B 5D 0C 53 57 8A 4D FE 8A 55 FF 8B C6 E8 ?? ?? ?? ?? 80 BE C1 00 00 00 00 0F 84 B0 00 00 00 C6 86 C1 00 00 00 00 85 DB 7C 1A 8B C6 E8 ?? ?? ?? ?? 3B D8 7D 0F 85 FF 7C 0B 8B C6 E8 ?? ?? ?? ?? 3B F8 7E 04 33 C0 EB 02 B0 01 8B D8 83 BE B8 00 00 00 00 75 27 C6 86 CE 00 00 00 00 C6 86 CD 00 00 00 00 84 DB 74 52 8A 86 CE 00 00 00 04 FE 2C 02 72 46 8B C6 8B 10 FF 52 44 EB 3D 84 DB 74 22 8A 96 C0 00 00 00 80 F2 01 8B C6 E8 ?? ?? ?? ?? 80 BE C0 00 00 00 00 74 20 8B C6 8B 10 FF 52 48 EB 17 80 BE C0 00 00 00 00 74 07 C6 86 CE 00 00 00 03 8B C6 8B 10 FF 52 48 84 DB 74 0B 8B C6 66 BB F0 FF E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1160_0 {
	meta:
		name = "TSpeedButton.GetPalette"
		size = 17
		refs = "0006 TSpeedButton.GetGlyph"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 52 24 5B C3 }
	condition:
		$1
}

rule function_1195_0 {
	meta:
		name = "TBitBtn.GetPalette"
		size = 17
		refs = "0006 TBitBtn.GetGlyph"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 52 24 5B C3 }
	condition:
		$1
}

rule function_1161_0 {
	meta:
		name = "TSpeedButton.GetGlyph"
		size = 10
	strings:
		$1 = { 8B 80 BC 00 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_1162_0 {
	meta:
		name = "TSpeedButton.SetGlyph"
		size = 23
		refs = "000a _NF__181"
	strings:
		$1 = { 56 8B F0 8B 86 BC 00 00 00 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1163_0 {
	meta:
		name = "TSpeedButton.GetNumGlyphs"
		size = 10
	strings:
		$1 = { 8B 80 BC 00 00 00 8A 40 20 C3 }
	condition:
		$1
}

rule function_1164_0 {
	meta:
		name = "TSpeedButton.SetNumGlyphs"
		size = 43
		refs = "001e _NF__182"
	strings:
		$1 = { 56 8B F0 84 D2 73 04 B2 01 EB 07 80 FA 04 76 02 B2 04 8B 86 BC 00 00 00 3A 50 20 74 0C E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1165_0 {
	meta:
		name = "TControl.CMColorChanged"
		size = 6
		altNames = "TControl.CMEnabledChanged TControl.CMFontChanged TCustomTeePanel.CanvasChanged TQRShape.StyleChanged TShape.StyleChanged TSpeedButton.CMFontChanged TSpeedButton.CMTextChanged _NF__1B5 _NF__1ED"
	strings:
		$1 = { 8B 10 FF 52 44 C3 }
	condition:
		$1
}

rule function_1166_0 {
	meta:
		name = "_NF__1B6"
		size = 54
		refs = "002e TWinControl.Broadcast"
	strings:
		$1 = { 83 C4 F0 8B 90 B8 00 00 00 85 D2 74 25 83 78 24 00 74 1F C7 04 24 18 B0 00 00 89 54 24 04 89 44 24 08 33 D2 89 54 24 0C 8B D4 8B 40 24 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_1167_0 {
	meta:
		name = "TSpeedButton.SetDown"
		size = 106
		refs = "0063 _NF__1B6"
	strings:
		$1 = { 53 56 8B DA 8B F0 83 BE B8 00 00 00 00 75 02 33 DB 3A 9E C0 00 00 00 74 4E 80 BE C0 00 00 00 00 74 09 80 BE C2 00 00 00 00 74 3C 88 9E C0 00 00 00 84 DB 74 19 80 BE CE 00 00 00 00 75 07 8B C6 8B 10 FF 52 44 C6 86 CE 00 00 00 03 EB 0E C6 86 CE 00 00 00 00 8B C6 8B 10 FF 52 48 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1168_0 {
	meta:
		name = "TSpeedButton.SetFlat"
		size = 68
		refs = "0017 TSpeedButton.SetFlat"
	strings:
		$1 = { 56 8B F0 3A 96 CC 00 00 00 74 31 88 96 CC 00 00 00 84 D2 74 12 66 A1 ?? ?? ?? ?? F7 D0 66 23 46 40 66 89 46 40 EB 0E 66 A1 ?? ?? ?? ?? 66 0B 46 40 66 89 46 40 8B C6 8B 10 FF 52 44 5E C3 00 00 40 00 00 00 }
	condition:
		$1
}

rule function_1169_0 {
	meta:
		name = "TSpeedButton.SetGroupIndex"
		size = 20
		refs = "000f _NF__1B6"
	strings:
		$1 = { 3B 90 B8 00 00 00 74 0B 89 90 B8 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1170_0 {
	meta:
		name = "TSpeedButton.SetLayout"
		size = 26
	strings:
		$1 = { 56 8B F0 3A 96 C3 00 00 00 74 0D 88 96 C3 00 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1171_0 {
	meta:
		name = "TSpeedButton.SetMargin"
		size = 31
	strings:
		$1 = { 56 8B F0 3B 96 C8 00 00 00 74 12 83 FA FF 7C 0D 89 96 C8 00 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1172_0 {
	meta:
		name = "TSpeedButton.SetSpacing"
		size = 26
	strings:
		$1 = { 56 8B F0 3B 96 C4 00 00 00 74 0D 89 96 C4 00 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1173_0 {
	meta:
		name = "TSpeedButton.SetAllowAllUp"
		size = 20
		refs = "000f _NF__1B6"
	strings:
		$1 = { 3A 90 C2 00 00 00 74 0B 88 90 C2 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1174_0 {
	meta:
		name = "TSpeedButton.WMLButtonDblClk"
		size = 34
		refs = "0007 TControl.WMLButtonDblClk 001b @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE C0 00 00 00 00 74 0B 8B C6 66 BB EF FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1175_0 {
	meta:
		name = "TSpeedButton.CMEnabledChanged"
		size = 41
		refs = "000a _NV__1CF 0015 _NF__183 001c _NF__193"
	strings:
		$1 = { 53 8B D8 33 C0 8A 43 45 8A 90 ?? ?? ?? ?? 8B 83 BC 00 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 48 5B C3 }
	condition:
		$1
}

rule function_1176_0 {
	meta:
		name = "TSpeedButton.CMButtonPressed"
		size = 76
	strings:
		$1 = { 53 56 8B D8 8B 42 04 3B 83 B8 00 00 00 75 3A 8B 72 08 3B DE 74 33 80 BE C0 00 00 00 00 74 1E 80 BB C0 00 00 00 00 74 15 C6 83 C0 00 00 00 00 C6 83 CE 00 00 00 00 8B C3 8B 10 FF 52 44 8A 86 C2 00 00 00 88 83 C2 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1177_0 {
	meta:
		name = "TSpeedButton.CMDialogChar"
		size = 122
		refs = "0010 TSpeedButton.CMDialogChar 0020 TControl.GetText 002c IsAccel 0041 @CallDynaInst 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 66 8B 47 04 E8 ?? ?? ?? ?? 84 C0 74 1A 80 7E 45 00 74 14 8B C6 66 BB F0 FF E8 ?? ?? ?? ?? C7 47 0C 01 00 00 00 EB 09 8B D7 8B C6 8B 08 FF 51 F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1180_0 {
	meta:
		name = "TSpeedButton.CMSysColorChange"
		size = 33
		refs = "000d _NF__17F 001a _NF__183"
	strings:
		$1 = { 53 56 8B D8 8B B3 BC 00 00 00 8B C6 E8 ?? ?? ?? ?? 8A 93 CE 00 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1181_0 {
	meta:
		name = "TSpeedButton.CMMouseEnter"
		size = 50
		refs = "0006 TControl.CMMouseEnter"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE CC 00 00 00 00 74 1D 80 BE CD 00 00 00 00 75 14 80 7E 45 00 74 0E C6 86 CD 00 00 00 01 8B C6 8B 10 FF 52 48 5E C3 }
	condition:
		$1
}

rule function_1182_0 {
	meta:
		name = "TSpeedButton.CMMouseLeave"
		size = 59
		refs = "0006 TControl.CMMouseLeave"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE CC 00 00 00 00 74 26 80 BE CD 00 00 00 00 74 1D 80 7E 45 00 74 17 80 BE C1 00 00 00 00 75 0E C6 86 CD 00 00 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1183_0 {
	meta:
		name = "TBitBtn.Create"
		size = 139
		refs = "000a @ClassCreate 0017 TButton.Create 001e _NV__16D 0023 _NF__17D 0039 _NF__210 0040 _Dn_TCanvas 0045 TCanvas.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 28 01 00 00 8B 86 28 01 00 00 89 70 28 C7 40 24 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 24 01 00 00 C6 86 2C 01 00 00 00 C6 86 2D 01 00 00 00 C6 86 2E 01 00 00 00 C7 86 30 01 00 00 04 00 00 00 C7 86 34 01 00 00 FF FF FF FF 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1184_0 {
	meta:
		name = "TBitBtn.Destroy"
		size = 56
		refs = "000e TWinControl.Destroy 0019 TObject.Free 002f @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 8B 86 28 01 00 00 E8 ?? ?? ?? ?? 8B 86 24 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1185_0 {
	meta:
		name = "TBitBtn.CreateHandle"
		size = 39
		refs = "0013 TWinControl.CreateHandle 0020 _NF__183"
	strings:
		$1 = { 53 56 8B F0 80 7E 45 00 74 04 33 DB EB 02 B3 01 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 86 28 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1186_0 {
	meta:
		name = "TBitBtn.CreateParams"
		size = 16
		refs = "0006 TButton.CreateParams"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? 83 4B 04 0B 5B C3 }
	condition:
		$1
}

rule function_1187_0 {
	meta:
		name = "TBitBtn.SetButtonStyle"
		size = 20
		refs = "000f TControl.Refresh"
	strings:
		$1 = { 3A 90 38 01 00 00 74 0B 88 90 38 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1188_0 {
	meta:
		name = "TBitBtn.Click"
		size = 108
		refs = "0014 GetParentForm 001d TCustomForm.Close 0026 TButton.Click 0046 Application 0054 TApplication.HelpContext"
	strings:
		$1 = { 53 8B D8 8A 83 2D 01 00 00 2C 03 74 1F 2C 03 75 52 8B C3 E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? EB 47 8B C3 E8 ?? ?? ?? ?? 5B C3 8B C3 EB 03 8B 40 24 85 C0 74 09 83 B8 E0 00 00 00 00 74 F0 85 C0 74 16 8B 15 ?? ?? ?? ?? 8B 12 8B 80 E0 00 00 00 92 E8 ?? ?? ?? ?? EB 10 8B C3 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1189_0 {
	meta:
		name = "TBitBtn.CNMeasureItem"
		size = 16
	strings:
		$1 = { 8B 52 08 8B 48 38 89 4A 0C 8B 40 3C 89 42 10 C3 }
	condition:
		$1
}

rule function_1190_0 {
	meta:
		name = "TBitBtn.CNDrawItem"
		size = 9
		refs = "0004 _NF__1FF"
	strings:
		$1 = { 8B 52 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1191_0 {
	meta:
		name = "_NF__1FF"
		size = 634
		refs = "0016 _NF__1FF 002a TCanvas.SetHandle 0097 TPen.SetColor 00aa TPen.SetWidth 00ba TBrush.SetStyle 00d3 TCanvas.Rectangle 00e0 InflateRect 011d TBrush.SetColor 0158 DrawFrameControl 0186 TCanvas.SetFont 0197 OffsetRect 01a3 Point 01b1 TControl.GetText 01e8 _NF__187 023f TCanvas.GetHandle 0245 DrawFocusRect 0267 @LStrClr 026d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 C9 89 4D CC 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 56 18 8B 87 24 01 00 00 E8 ?? ?? ?? ?? 8D 55 E8 8B C7 8B 08 FF 51 2C 8B 46 10 A8 01 0F 95 C3 A8 10 0F 95 45 FF 80 7F 45 00 75 06 C6 45 FE 01 EB 0E 84 DB 74 06 C6 45 FE 02 EB 04 C6 45 FE 00 C7 45 F8 10 20 00 00 84 DB 74 07 81 4D F8 00 02 00 00 A8 04 74 07 81 4D F8 00 01 00 00 8A 87 38 01 00 00 0A 45 FF 74 5C 8B 87 24 01 00 00 8B 40 10 BA 06 00 00 80 E8 ?? ?? ?? ?? 8B 87 24 01 00 00 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 87 24 01 00 00 8B 40 14 B2 01 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 F4 50 8B 4D EC 8B 55 E8 8B 87 24 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? 84 DB 74 61 8B 87 24 01 00 00 8B 40 10 BA 10 00 00 80 E8 ?? ?? ?? ?? 8B 87 24 01 00 00 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 87 24 01 00 00 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 F4 50 8B 4D EC 8B 55 E8 8B 87 24 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? EB 13 8B 45 F8 50 6A 04 8D 45 E8 50 8B 46 18 50 E8 ?? ?? ?? ?? 80 BF 38 01 00 00 00 74 17 8D 55 E8 8B C7 8B 08 FF 51 2C 6A FF 6A FF 8D 45 E8 50 E8 ?? ?? ?? ?? 8B 57 50 8B 87 24 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 6A 01 6A 01 8D 45 E8 50 E8 ?? ?? ?? ?? 8D 4D D0 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 D0 50 8D 55 CC 8B C7 E8 ?? ?? ?? ?? 8B 45 CC 50 8A 87 2E 01 00 00 50 8B 87 34 01 00 00 50 8B 87 30 01 00 00 50 8A 45 FE 50 6A 00 8D 45 D8 50 8D 4D E8 8B 97 24 01 00 00 8B 87 28 01 00 00 E8 ?? ?? ?? ?? 8A 87 38 01 00 00 22 45 FF 74 52 8D 55 E8 8B C7 8B 08 FF 51 2C 6A FC 6A FC 8D 45 E8 50 E8 ?? ?? ?? ?? 8B 87 24 01 00 00 8B 40 10 BA 06 00 00 80 E8 ?? ?? ?? ?? 8B 87 24 01 00 00 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8D 45 E8 50 8B 87 24 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 D2 8B 87 24 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1192_0 {
	meta:
		name = "TBitBtn.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1193_0 {
	meta:
		name = "TBitBtn.CMEnabledChanged"
		size = 19
		refs = "0006 TWinControl.CMEnabledChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1994_0 {
	meta:
		name = "TColorGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_13845_0 {
	meta:
		name = "TCustomCheckBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_13689_0 {
	meta:
		name = "TCustomGroupBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_4423_0 {
	meta:
		name = "TDBCtrlGrid.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_4935_0 {
	meta:
		name = "TDBImage.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_7024_0 {
	meta:
		name = "THeader.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_2146_0 {
	meta:
		name = "THeaderControl.WMWindowPosChanged"
		size = 19
		refs = "0006 TWinControl.WMWindowPosChanged"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1194_0 {
	meta:
		name = "TBitBtn.WMLButtonDblClk"
		size = 18
		refs = "000d TControl.Perform"
	strings:
		$1 = { 8B 4A 08 51 8B 4A 04 BA 01 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1196_0 {
	meta:
		name = "TBitBtn.SetGlyph"
		size = 30
		refs = "000a _NF__181"
	strings:
		$1 = { 56 8B F0 8B 86 28 01 00 00 E8 ?? ?? ?? ?? C6 86 39 01 00 00 01 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1197_0 {
	meta:
		name = "TBitBtn.GetGlyph"
		size = 10
	strings:
		$1 = { 8B 80 28 01 00 00 8B 40 04 C3 }
	condition:
		$1
}

rule function_1198_0 {
	meta:
		name = "TCustomPanel.CMTextChanged"
		size = 12
		altNames = "TTabbedNotebook.CMTabFontChanged _NF__210 _NF__308"
	strings:
		$1 = { 56 8B F0 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1199_0 {
	meta:
		name = "TBitBtn.IsCustom"
		size = 17
		refs = "0006 TBitBtn.GetKind"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 94 C0 5B C3 }
	condition:
		$1
}

rule function_1200_0 {
	meta:
		name = "TBitBtn.SetStyle"
		size = 26
	strings:
		$1 = { 56 8B F0 3A 96 2C 01 00 00 74 0D 88 96 2C 01 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1201_0 {
	meta:
		name = "TBitBtn.SetKind"
		size = 270
		refs = "0012 TBitBtn.SetKind 0043 TButton.SetDefault 0069 TControl.GetText 0080 _NV__15D 0092 LoadResString 009c TControl.SetText 00a7 _NV__15E 00b4 _NF__168 00c1 _NF__181 00ca TBitBtn.SetNumGlyphs 00f3 @LStrClr 0101 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 9E 2D 01 00 00 0F 84 BA 00 00 00 84 DB 0F 84 A5 00 00 00 8B C3 2C 01 74 08 2C 03 74 04 33 D2 EB 02 B2 01 8B C6 E8 ?? ?? ?? ?? 8B C3 2C 02 74 08 2C 03 74 04 33 C0 EB 02 B0 01 88 86 1D 01 00 00 F6 46 20 01 74 10 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 83 7D FC 00 74 06 F6 46 20 01 75 27 33 C0 8A C3 8B 3C 85 ?? ?? ?? ?? 85 FF 74 18 8D 55 F8 33 C0 8A C3 8B C7 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 33 C0 8A C3 8B 04 85 ?? ?? ?? ?? 89 86 20 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 86 28 01 00 00 E8 ?? ?? ?? ?? B2 02 8B C6 E8 ?? ?? ?? ?? C6 86 39 01 00 00 00 88 9E 2D 01 00 00 8B C6 8B 10 FF 52 44 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1202_0 {
	meta:
		name = "TBitBtn.IsCustomCaption"
		size = 121
		refs = "000e TBitBtn.IsCustomCaption 0026 _NV__15D 002b LoadResString 0039 TControl.GetText 0042 CompareStr 005e @LStrClr 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 33 C0 8A 83 2D 01 00 00 8B 04 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 85 C0 0F 95 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1203_0 {
	meta:
		name = "TBitBtn.GetKind"
		size = 108
		refs = "0049 _NV__15E"
	strings:
		$1 = { 80 B8 2D 01 00 00 00 74 5C 8A 90 2D 01 00 00 8B CA 80 E9 01 74 09 80 E9 03 74 04 33 C9 EB 02 B1 01 32 88 1C 01 00 00 75 35 8B CA 80 E9 02 74 09 80 E9 03 74 04 33 C9 EB 02 B1 01 32 88 1D 01 00 00 75 1B 83 E2 7F 8B 14 95 ?? ?? ?? ?? 3B 90 20 01 00 00 75 09 80 B8 39 01 00 00 00 74 07 C6 80 2D 01 00 00 00 8A 80 2D 01 00 00 C3 }
	condition:
		$1
}

rule function_1204_0 {
	meta:
		name = "TBitBtn.SetLayout"
		size = 26
	strings:
		$1 = { 56 8B F0 3A 96 2E 01 00 00 74 0D 88 96 2E 01 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1205_0 {
	meta:
		name = "TBitBtn.GetNumGlyphs"
		size = 10
	strings:
		$1 = { 8B 80 28 01 00 00 8A 40 20 C3 }
	condition:
		$1
}

rule function_1206_0 {
	meta:
		name = "TBitBtn.SetNumGlyphs"
		size = 43
		refs = "001e _NF__182"
	strings:
		$1 = { 56 8B F0 84 D2 73 04 B2 01 EB 07 80 FA 04 76 02 B2 04 8B 86 28 01 00 00 3A 50 20 74 0C E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1207_0 {
	meta:
		name = "TBitBtn.SetSpacing"
		size = 26
	strings:
		$1 = { 56 8B F0 3B 96 30 01 00 00 74 0D 89 96 30 01 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1208_0 {
	meta:
		name = "TBitBtn.SetMargin"
		size = 31
	strings:
		$1 = { 56 8B F0 3B 96 34 01 00 00 74 12 83 FA FF 7C 0D 89 96 34 01 00 00 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_1209_0 {
	meta:
		name = "_NF__22B"
		size = 26
		refs = "0005 _NV__15F 000c TObject.Free"
	strings:
		$1 = { 53 56 B3 0B BE ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 83 C6 04 FE CB 75 F2 5E 5B C3 }
	condition:
		$1
}

rule function_1211_0 {
	meta:
		name = "Finalization"
		size = 53
		refs = "0007 Finalization 0013 _NV__15A 001a _NF__22B 002d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1427_0 {
	meta:
		name = "Finalization"
		size = 53
		refs = "0007 Finalization 0013 _NV__21D 001a _NF__3AA 002d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11210_0 {
	meta:
		name = "Finalization"
		size = 53
		refs = "0007 Finalization 0013 _NV__223 001a OleUninitialize 002d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1212_0 {
	meta:
		name = "Buttons"
		size = 37
		refs = "0002 _NV__15A 000a _NF__22C 000f @InitImports 0014 _NV__15F 0020 @FillChar"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 1B B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 33 C9 BA 2C 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1213_0 {
	meta:
		name = "TCalendar.Create"
		size = 168
		refs = "000a @ClassCreate 0017 TCustomGrid.Create 0027 TCustomGrid.SetFixedCols 0033 TCustomGrid.SetFixedRows 003f TCustomGrid.SetColCount 004b TCustomGrid.SetRowCount 0054 TCustomGrid.SetScrollBars 005b TCalendar.Create 0072 TCustomGrid.SetOptions 0077 Date"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 B7 01 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 07 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 07 00 00 00 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? F7 D2 66 23 96 54 01 00 00 66 0B 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 9E A0 01 00 00 9B 8B C6 8B 10 FF 92 9C 00 00 00 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 10 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_1214_0 {
	meta:
		name = "TCalendar.Change"
		size = 29
		altNames = "TCustomForm.DoHide"
	strings:
		$1 = { 53 66 83 B8 AE 01 00 00 00 74 10 8B D8 8B D0 8B 83 B0 01 00 00 FF 93 AC 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1215_0 {
	meta:
		name = "TCalendar.Click"
		size = 113
		refs = "000c TCalendar.Click 0019 TControl.Click 0030 TCalendar.GetCellText 003e StrToInt 004c TCalendar.SetDateElement 0061 @LStrClr 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 50 8B 8B 38 01 00 00 8B 93 34 01 00 00 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 16 8B 45 FC E8 ?? ?? ?? ?? 8B C8 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1216_0 {
	meta:
		name = "TCalendar.IsLeapYear"
		size = 57
	strings:
		$1 = { 53 8B CA 8B C1 25 03 00 00 80 79 05 48 83 C8 FC 40 85 C0 75 1C 8B C1 BB 64 00 00 00 99 F7 FB 85 D2 75 12 8B C1 B9 90 01 00 00 99 F7 F9 85 D2 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_1217_0 {
	meta:
		name = "TCalendar.DaysPerMonth"
		size = 46
		refs = "000d _NV__97"
	strings:
		$1 = { 53 56 57 55 8B F1 8B EA 8B D8 8B 3C B5 ?? ?? ?? ?? 83 FE 02 75 11 8B D5 8B C3 8B 08 FF 91 98 00 00 00 84 C0 74 01 47 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1218_0 {
	meta:
		name = "TCalendar.DaysThisMonth"
		size = 43
		refs = "000b TCalendar.GetDateElement"
	strings:
		$1 = { 53 8B D8 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 50 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 59 8B 18 FF 93 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1219_0 {
	meta:
		name = "TCalendar.DrawCell"
		size = 181
		refs = "0027 TCalendar.DrawCell 003c TCalendar.GetCellText 004c TCanvas.TextHeight 006e TCanvas.TextWidth 008b TCanvas.TextRect 00a0 @LStrClr 00a6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D FC 8B 75 0C 8D 7D EC 51 B9 04 00 00 00 F3 A5 59 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 9B 18 01 00 00 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 F8 8B 7D F0 2B D7 2B D0 D1 FA 79 03 83 D2 00 03 D7 52 8B 45 FC 50 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 4D F4 8B 75 EC 2B CE 2B C8 D1 F9 79 03 83 D1 00 03 CE 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1220_0 {
	meta:
		name = "TCalendar.GetCellText"
		size = 112
		refs = "0024 ShortDayNames 002e @LStrLAsg 005a @LStrClr 0065 IntToStr"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 8B 7D 08 85 C9 75 23 33 C0 8A 83 B5 01 00 00 03 C6 B9 07 00 00 00 99 F7 F9 A1 ?? ?? ?? ?? 8B 14 90 8B C7 E8 ?? ?? ?? ?? EB 35 03 B3 A8 01 00 00 49 8B C1 C1 E0 03 2B C1 03 F0 83 FE 01 7C 0E 8B C3 8B 10 FF 92 94 00 00 00 3B F0 7E 09 8B C7 E8 ?? ?? ?? ?? EB 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1221_0 {
	meta:
		name = "TCalendar.SelectCell"
		size = 121
		refs = "0012 TCalendar.SelectCell 0039 TCalendar.GetCellText 004e TCustomGrid.SelectCell 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB B6 01 00 00 00 75 09 80 BB B4 01 00 00 00 75 15 8D 45 FC 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 75 04 33 DB EB 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1222_0 {
	meta:
		name = "TCalendar.SetCalendarDate"
		size = 50
		refs = "0029 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 89 83 A0 01 00 00 8B 45 0C 89 83 A4 01 00 00 8B C3 8B 10 FF 92 9C 00 00 00 8B C3 66 BB CC FF E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1223_0 {
	meta:
		name = "TCalendar.StoreCalendarDate"
		size = 9
	strings:
		$1 = { 8A 80 B7 01 00 00 34 01 C3 }
	condition:
		$1
}

rule function_1224_0 {
	meta:
		name = "TCalendar.GetDateElement"
		size = 73
		refs = "001f DecodeDate"
	strings:
		$1 = { 53 83 C4 F8 8B DA FF B0 A4 01 00 00 FF B0 A0 01 00 00 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 4B 74 08 4B 74 0B 4B 74 0F EB 14 0F B7 04 24 EB 11 0F B7 44 24 02 EB 0A 0F B7 44 24 04 EB 03 83 C8 FF 59 5A 5B C3 }
	condition:
		$1
}

rule function_1225_0 {
	meta:
		name = "TCalendar.SetDateElement"
		size = 183
		refs = "002d DecodeDate 008a EncodeDate 00ad @CallDynaInst"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F1 8B FA 8B D8 85 F6 0F 8E 9D 00 00 00 FF B3 A4 01 00 00 FF B3 A0 01 00 00 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 4F 74 08 4F 74 13 4F 74 25 EB 75 0F B7 04 24 3B F0 74 6D 66 89 34 24 EB 31 83 FE 0C 7F 62 0F B7 44 24 02 3B F0 74 59 66 89 74 24 02 EB 1C 8B C3 8B 10 FF 92 94 00 00 00 3B F0 7F 44 0F B7 44 24 04 3B F0 74 3B 66 89 74 24 04 66 8B 4C 24 04 66 8B 54 24 02 66 8B 04 24 E8 ?? ?? ?? ?? DD 9B A0 01 00 00 9B C6 83 B7 01 00 00 00 8B C3 8B 10 FF 92 9C 00 00 00 8B C3 66 BB CC FF E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1226_0 {
	meta:
		name = "TCalendar.SetStartOfWeek"
		size = 29
	strings:
		$1 = { 56 8B F0 3A 96 B5 01 00 00 74 10 88 96 B5 01 00 00 8B C6 8B 10 FF 92 9C 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1227_0 {
	meta:
		name = "TCalendar.SetUseCurrentDate"
		size = 45
		refs = "0016 Date"
	strings:
		$1 = { 56 8B F0 3A 96 B7 01 00 00 74 20 88 96 B7 01 00 00 84 D2 74 16 E8 ?? ?? ?? ?? DD 9E A0 01 00 00 9B 8B C6 8B 10 FF 92 9C 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1228_0 {
	meta:
		name = "TCalendar.ChangeMonth"
		size = 243
		refs = "0024 DecodeDate 0061 EncodeDate 00e7 TCalendar.SetCalendarDate"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 8B FA 8B D8 FF B3 A4 01 00 00 FF B3 A0 01 00 00 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 0F B7 74 24 04 85 FF 7E 1A 0F B7 4C 24 02 0F B7 14 24 8B C3 8B 28 FF 95 90 00 00 00 66 89 44 24 04 EB 07 66 C7 44 24 04 01 00 66 8B 4C 24 04 66 8B 54 24 02 66 8B 04 24 E8 ?? ?? ?? ?? DD 5C 24 08 9B 89 7C 24 10 DB 44 24 10 DC 44 24 08 DD 5C 24 08 9B FF 74 24 0C FF 74 24 0C 8D 4C 24 0C 8D 54 24 0A 8D 44 24 08 E8 ?? ?? ?? ?? 0F B7 4C 24 02 0F B7 14 24 8B C3 8B 38 FF 97 90 00 00 00 3B F0 7D 07 66 89 74 24 04 EB 18 0F B7 4C 24 02 0F B7 14 24 8B C3 8B 30 FF 96 90 00 00 00 66 89 44 24 04 66 8B 4C 24 04 66 8B 54 24 02 66 8B 04 24 E8 ?? ?? ?? ?? 83 C4 F8 DD 1C 24 9B 8B C3 E8 ?? ?? ?? ?? 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1229_0 {
	meta:
		name = "TCalendar.PrevMonth"
		size = 9
		refs = "0004 TCalendar.ChangeMonth"
	strings:
		$1 = { 83 CA FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4295_0 {
	meta:
		name = "TDataSet.Prior"
		size = 9
		refs = "0004 TDataSet.MoveBy"
	strings:
		$1 = { 83 CA FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1230_0 {
	meta:
		name = "TCalendar.NextMonth"
		size = 11
		refs = "0006 TCalendar.ChangeMonth"
	strings:
		$1 = { BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4294_0 {
	meta:
		name = "TDataSet.Next"
		size = 11
		refs = "0006 TDataSet.MoveBy"
	strings:
		$1 = { BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12393_0 {
	meta:
		name = "TQRExprBuilder.AddAndClick"
		size = 28
		refs = "0001 TQRExprBuilder.AddAndClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 05 00 00 00 20 41 4E 44 20 00 00 00 }
	condition:
		$1
}

rule function_12385_0 {
	meta:
		name = "TQRExprBuilder.AddDivClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddDivClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 2F 20 00 }
	condition:
		$1
}

rule function_12396_0 {
	meta:
		name = "TQRExprBuilder.AddEqualClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddEqualClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 3D 20 00 }
	condition:
		$1
}

rule function_12398_0 {
	meta:
		name = "TQRExprBuilder.AddLargerClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddLargerClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 3E 20 00 }
	condition:
		$1
}

rule function_12383_0 {
	meta:
		name = "TQRExprBuilder.AddMinusClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddMinusClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 2D 20 00 }
	condition:
		$1
}

rule function_12384_0 {
	meta:
		name = "TQRExprBuilder.AddMulClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddMulClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 2A 20 00 }
	condition:
		$1
}

rule function_12395_0 {
	meta:
		name = "TQRExprBuilder.AddNotClick"
		size = 28
		refs = "0001 TQRExprBuilder.AddNotClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 05 00 00 00 20 4E 4F 54 20 00 00 00 }
	condition:
		$1
}

rule function_12401_0 {
	meta:
		name = "TQRExprBuilder.AddNotEqualClick"
		size = 28
		refs = "0001 TQRExprBuilder.AddNotEqualClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 04 00 00 00 20 3C 3E 20 00 00 00 00 }
	condition:
		$1
}

rule function_12394_0 {
	meta:
		name = "TQRExprBuilder.AddOrClick"
		size = 28
		refs = "0001 TQRExprBuilder.AddOrClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 04 00 00 00 20 4F 52 20 00 00 00 00 }
	condition:
		$1
}

rule function_12382_0 {
	meta:
		name = "TQRExprBuilder.AddPlusClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddPlusClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 2B 20 00 }
	condition:
		$1
}

rule function_12397_0 {
	meta:
		name = "TQRExprBuilder.AddSmallerClick"
		size = 24
		refs = "0001 TQRExprBuilder.AddSmallerClick 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 03 00 00 00 20 3C 20 00 }
	condition:
		$1
}

rule function_12400_0 {
	meta:
		name = "TQRExprBuilder.Button1Click"
		size = 28
		refs = "0001 TQRExprBuilder.Button1Click 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 04 00 00 00 20 3E 3D 20 00 00 00 00 }
	condition:
		$1
}

rule function_12399_0 {
	meta:
		name = "TQRExprBuilder.Button2Click"
		size = 28
		refs = "0001 TQRExprBuilder.Button2Click 0006 _NF__79"
	strings:
		$1 = { BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 00 FF FF FF FF 04 00 00 00 20 3C 3D 20 00 00 00 00 }
	condition:
		$1
}

rule function_1231_0 {
	meta:
		name = "TCalendar.NextYear"
		size = 111
		refs = "000b TCalendar.GetDateElement 004e TCalendar.SetDateElement"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 98 00 00 00 84 C0 74 33 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 02 75 22 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 1D 75 11 B9 1C 00 00 00 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C8 41 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1232_0 {
	meta:
		name = "TCalendar.PrevYear"
		size = 111
		refs = "000b TCalendar.GetDateElement 004e TCalendar.SetDateElement"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 98 00 00 00 84 C0 74 33 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 02 75 22 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 F8 1D 75 11 B9 1C 00 00 00 BA 03 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C8 49 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1233_0 {
	meta:
		name = "TCalendar.UpdateCalendar"
		size = 246
		refs = "0018 TCalendar.UpdateCalendar 003b DecodeDate 004c EncodeDate 005b DayOfWeek 00c6 TCustomGrid.MoveColRow 00eb @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 89 45 FC 8B 45 FC C6 80 B6 01 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC FF B0 A4 01 00 00 FF B0 A0 01 00 00 8D 4D F6 8D 55 F8 8D 45 FA E8 ?? ?? ?? ?? 66 B9 01 00 66 8B 55 F8 66 8B 45 FA E8 ?? ?? ?? ?? DD 5D EC 9B FF 75 F0 FF 75 EC E8 ?? ?? ?? ?? 8B 55 FC 0F B6 92 B5 01 00 00 2B C2 83 C0 07 B9 07 00 00 00 99 F7 F9 BB 02 00 00 00 2B DA 8B 45 FC 89 98 A8 01 00 00 83 FB 02 75 0D 8B 45 FC C7 80 A8 01 00 00 FB FF FF FF 6A 00 6A 00 0F B7 4D F6 8B 45 FC 2B 88 A8 01 00 00 8B C1 BB 07 00 00 00 99 F7 FB 52 8B C1 B9 07 00 00 00 99 F7 F9 40 8B C8 8B 45 FC 5A E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 44 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 B6 01 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1234_0 {
	meta:
		name = "TCalendar.WMSize"
		size = 68
		refs = "0025 TCustomGrid.SetDefaultColWidth 003c TCustomGrid.SetDefaultRowHeight"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B B3 50 01 00 00 03 F6 8D 34 76 0F B7 47 08 2B C6 B9 07 00 00 00 99 F7 F9 8B D0 8B C3 E8 ?? ?? ?? ?? 0F B7 47 0A 2B C6 B9 07 00 00 00 99 F7 F9 8B D0 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1237_0 {
	meta:
		name = "_NF__92"
		size = 660
	strings:
		$1 = { FF FF FF FF 0E 00 00 00 52 45 51 55 45 53 54 5F 4D 45 54 48 4F 44 00 00 FF FF FF FF 0F 00 00 00 53 45 52 56 45 52 5F 50 52 4F 54 4F 43 4F 4C 00 FF FF FF FF 03 00 00 00 55 52 4C 00 FF FF FF FF 0C 00 00 00 51 55 45 52 59 5F 53 54 52 49 4E 47 00 00 00 00 FF FF FF FF 09 00 00 00 50 41 54 48 5F 49 4E 46 4F 00 00 00 FF FF FF FF 0F 00 00 00 50 41 54 48 5F 54 52 41 4E 53 4C 41 54 45 44 00 FF FF FF FF 12 00 00 00 48 54 54 50 5F 43 41 43 48 45 5F 43 4F 4E 54 52 4F 4C 00 00 FF FF FF FF 09 00 00 00 48 54 54 50 5F 44 41 54 45 00 00 00 FF FF FF FF 0B 00 00 00 48 54 54 50 5F 41 43 43 45 50 54 00 FF FF FF FF 09 00 00 00 48 54 54 50 5F 46 52 4F 4D 00 00 00 FF FF FF FF 09 00 00 00 48 54 54 50 5F 48 4F 53 54 00 00 00 FF FF FF FF 16 00 00 00 48 54 54 50 5F 49 46 5F 4D 4F 44 49 46 49 45 44 5F 53 49 4E 43 45 00 00 FF FF FF FF 0C 00 00 00 48 54 54 50 5F 52 45 46 45 52 45 52 00 00 00 00 FF FF FF FF 0F 00 00 00 48 54 54 50 5F 55 53 45 52 5F 41 47 45 4E 54 00 FF FF FF FF 15 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 45 4E 43 4F 44 49 4E 47 00 00 00 FF FF FF FF 11 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 54 59 50 45 00 00 00 FF FF FF FF 13 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 4C 45 4E 47 54 48 00 FF FF FF FF 14 00 00 00 48 54 54 50 5F 43 4F 4E 54 45 4E 54 5F 56 45 52 53 49 4F 4E 00 00 00 00 FF FF FF FF 11 00 00 00 48 54 54 50 5F 44 45 52 49 56 45 44 5F 46 52 4F 4D 00 00 00 FF FF FF FF 0C 00 00 00 48 54 54 50 5F 45 58 50 49 52 45 53 00 00 00 00 FF FF FF FF 0A 00 00 00 48 54 54 50 5F 54 49 54 4C 45 00 00 FF FF FF FF 0B 00 00 00 52 45 4D 4F 54 45 5F 41 44 44 52 00 FF FF FF FF 0B 00 00 00 52 45 4D 4F 54 45 5F 48 4F 53 54 00 FF FF FF FF 0B 00 00 00 53 43 52 49 50 54 5F 4E 41 4D 45 00 FF FF FF FF 0B 00 00 00 53 45 52 56 45 52 5F 50 4F 52 54 00 FF FF FF FF 0F 00 00 00 48 54 54 50 5F 43 4F 4E 4E 45 43 54 49 4F 4E 00 FF FF FF FF 0B 00 00 00 48 54 54 50 5F 43 4F 4F 4B 49 45 00 FF FF FF FF 12 00 00 00 48 54 54 50 5F 41 55 54 48 4F 52 49 5A 41 54 49 4F 4E 00 00 }
	condition:
		$1
}

rule function_1238_0 {
	meta:
		name = "TCGIRequest.Create"
		size = 133
		refs = "0010 @ClassCreate 001c TCGIRequest.Create 002b TWebRequest.Create 004e @LStrAsg 0063 @LStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? BA 10 00 00 00 8B C6 8B 08 FF 51 08 8B D0 8D 4D FC 8B C6 8B 38 FF 57 10 8B 55 FC 8D 46 14 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1239_0 {
	meta:
		name = "_NF__96"
		size = 72
		refs = "0009 _NF__96 000e @LStrPos 0023 @LStrCopy 002f @LStrLAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 75 15 56 B9 FF FF FF 7F BA 06 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 00 00 FF FF FF FF 05 00 00 00 48 54 54 50 5F 00 00 00 }
	condition:
		$1
}

rule function_1240_0 {
	meta:
		name = "TCGIRequest.GetFieldByName"
		size = 181
		refs = "001f TCGIRequest.GetFieldByName 0038 @LStrToPChar 003e GetEnvironmentVariable 004d @LStrFromPCharLen 006b _NF__96 00a3 @LStrClr 00a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 04 F0 FF FF 50 83 C4 FC 53 56 33 DB 89 9D FC EF FF FF 8B D9 8B F2 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8D 85 00 F0 FF FF 50 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8D 95 00 F0 FF FF 8B C3 E8 ?? ?? ?? ?? 83 3B 00 75 39 68 00 10 00 00 8D 85 00 F0 FF FF 50 8D 95 FC EF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 85 FC EF FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8D 95 00 F0 FF FF 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 FC EF FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1241_0 {
	meta:
		name = "TCGIRequest.GetStringVariable"
		size = 46
		refs = "0014 @LStrLAsg 001f _NV__91"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 83 FE 19 75 0C 8B C7 8B 53 14 E8 ?? ?? ?? ?? EB 10 8B CF 8B 14 B5 ?? ?? ?? ?? 8B C3 8B 18 FF 53 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1242_0 {
	meta:
		name = "TCGIRequest.GetDateVariable"
		size = 112
		refs = "0015 TCGIRequest.GetDateVariable 0034 ParseDate 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B C3 8B 18 FF 13 83 7D F4 00 74 0E 8B 45 F4 E8 ?? ?? ?? ?? DD 5D F8 9B EB 0C 33 C0 89 45 F8 C7 45 FC 00 00 F0 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DD 45 F8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_8830_0 {
	meta:
		name = "TISAPIRequest.GetDateVariable"
		size = 112
		refs = "0015 TISAPIRequest.GetDateVariable 0034 ParseDate 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B C3 8B 18 FF 13 83 7D F4 00 74 0E 8B 45 F4 E8 ?? ?? ?? ?? DD 5D F8 9B EB 0C 33 C0 89 45 F8 C7 45 FC 00 00 F0 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DD 45 F8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1243_0 {
	meta:
		name = "TCGIRequest.GetIntegerVariable"
		size = 85
		refs = "000f TCGIRequest.GetIntegerVariable 002b StrToIntDef 0042 @LStrClr 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B D6 8B C3 8B 18 FF 13 83 CA FF 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1244_0 {
	meta:
		name = "TCGIRequest.ReadClient"
		size = 13
		refs = "0001 Input 0008 FileRead"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1247_0 {
	meta:
		name = "TCGIRequest.WriteClient"
		size = 13
		refs = "0001 Output 0008 FileWrite"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1245_0 {
	meta:
		name = "TCGIRequest.ReadString"
		size = 38
		refs = "000b @LStrSetLength 0016 Input 001f FileRead"
	strings:
		$1 = { 53 56 8B F1 8B DA 8B C6 8B D3 E8 ?? ?? ?? ?? 85 DB 7E 10 8B 16 A1 ?? ?? ?? ?? 8B 00 8B CB E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1248_0 {
	meta:
		name = "TCGIRequest.WriteString"
		size = 53
		refs = "000b @LStrLen 0014 Output 001b FileWrite"
	strings:
		$1 = { 53 56 8B DA 85 DB 74 28 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 0F 94 C0 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1249_0 {
	meta:
		name = "TCGIResponse.Create"
		size = 256
		refs = "0015 @ClassCreate 0022 TCGIResponse.Create 0031 TWebResponse.Create 00bc @LStrClr 00c2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 BA 01 00 00 00 8B 43 10 8B 30 FF 16 83 7D F8 00 75 0E B9 ?? ?? ?? ?? 33 D2 8B C3 8B 30 FF 56 04 BA C8 00 00 00 8B C3 8B 08 FF 51 28 68 00 00 F0 BF 6A 00 BA 02 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 BA 01 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 33 D2 8B C3 8B 08 FF 51 0C B9 ?? ?? ?? ?? BA 08 00 00 00 8B C3 8B 30 FF 56 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C3 FF FF FF FF 03 00 00 00 31 2E 30 00 FF FF FF FF 09 00 00 00 74 65 78 74 2F 68 74 6D 6C 00 00 00 }
	condition:
		$1
}

rule function_8837_0 {
	meta:
		name = "TISAPIResponse.Create"
		size = 256
		refs = "0015 @ClassCreate 0022 TISAPIResponse.Create 0031 TWebResponse.Create 00bc @LStrClr 00c2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 BA 01 00 00 00 8B 43 10 8B 30 FF 16 83 7D F8 00 75 0E B9 ?? ?? ?? ?? 33 D2 8B C3 8B 30 FF 56 04 BA C8 00 00 00 8B C3 8B 08 FF 51 28 68 00 00 F0 BF 6A 00 BA 02 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 BA 01 00 00 00 8B C3 8B 08 FF 51 0C 68 00 00 F0 BF 6A 00 33 D2 8B C3 8B 08 FF 51 0C B9 ?? ?? ?? ?? BA 08 00 00 00 8B C3 8B 30 FF 56 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 59 5D C3 FF FF FF FF 03 00 00 00 31 2E 30 00 FF FF FF FF 09 00 00 00 74 65 78 74 2F 68 74 6D 6C 00 00 00 }
	condition:
		$1
}

rule function_1250_0 {
	meta:
		name = "TCGIResponse.GetContent"
		size = 19
		refs = "000c @LStrLAsg"
		altNames = "TISAPIResponse.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 64 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1251_0 {
	meta:
		name = "TCGIResponse.GetDateVariable"
		size = 48
	strings:
		$1 = { 83 C4 F8 85 D2 7C 16 83 FA 03 7D 11 8B 4C D0 4C 89 0C 24 8B 4C D0 50 89 4C 24 04 EB 0D 33 C0 89 04 24 C7 44 24 04 00 00 F0 BF DD 04 24 59 5A C3 }
	condition:
		$1
}

rule function_1252_0 {
	meta:
		name = "TCGIResponse.GetIntegerVariable"
		size = 18
	strings:
		$1 = { 85 D2 7C 0A 83 FA 02 7D 05 8B 44 90 48 C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_1254_0 {
	meta:
		name = "TCGIResponse.GetStatusCode"
		size = 4
		altNames = "TISAPIResponse.GetStatusCode TStringList.GetCapacity"
	strings:
		$1 = { 8B 40 14 C3 }
	condition:
		$1
}

rule function_1255_0 {
	meta:
		name = "TCGIResponse.GetStringVariable"
		size = 33
		refs = "0019 @LStrLAsg"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 85 DB 7C 10 83 FB 0C 7D 0B 8B C7 8B 54 9E 18 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1256_0 {
	meta:
		name = "TCGIResponse.Sent"
		size = 4
		altNames = "TDataSet.GetFound TISAPIResponse.Sent"
	strings:
		$1 = { 8A 40 68 C3 }
	condition:
		$1
}

rule function_1257_0 {
	meta:
		name = "TCGIResponse.SetContent"
		size = 38
		refs = "000c @LStrAsg 0014 @LStrLen"
		altNames = "TISAPIResponse.SetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 64 8B D6 E8 ?? ?? ?? ?? 8B 43 64 E8 ?? ?? ?? ?? 8B C8 33 D2 8B C3 8B 18 FF 53 14 5E 5B C3 }
	condition:
		$1
}

rule function_1258_0 {
	meta:
		name = "TCGIResponse.SetDateVariable"
		size = 44
		altNames = "TISAPIResponse.SetDateVariable"
	strings:
		$1 = { 55 8B EC 8B C8 85 D2 7C 1F 83 FA 02 7F 1A DD 45 08 DC 5C D1 4C DF E0 9E 74 0E 8B 45 08 89 44 D1 4C 8B 45 0C 89 44 D1 50 5D C2 08 00 }
	condition:
		$1
}

rule function_1259_0 {
	meta:
		name = "TCGIResponse.SetIntegerVariable"
		size = 34
	strings:
		$1 = { 53 51 8B D8 85 D2 7C 17 85 D2 7F 13 89 0C 24 DB 04 24 DC 5C D3 4C DF E0 9E 74 04 89 4C 93 48 5A 5B C3 }
	condition:
		$1
}

rule function_1261_0 {
	meta:
		name = "TCGIResponse.SetStatusCode"
		size = 92
		refs = "000f TCGIResponse.SetStatusCode 0027 StatusString 004b @LStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 73 14 74 1C 89 73 14 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC BA 01 00 00 00 8B C3 8B 18 FF 53 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_8849_0 {
	meta:
		name = "TISAPIResponse.SetStatusCode"
		size = 92
		refs = "000f TISAPIResponse.SetStatusCode 0027 StatusString 004b @LStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 73 14 74 1C 89 73 14 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 4D FC BA 01 00 00 00 8B C3 8B 18 FF 53 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1262_0 {
	meta:
		name = "TCGIResponse.SetStringVariable"
		size = 33
		refs = "0019 @LStrAsg"
		altNames = "TISAPIResponse.SetStringVariable"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 85 DB 7C 10 83 FB 0B 7F 0B 8D 44 9E 18 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1263_0 {
	meta:
		name = "_NF__DE"
		size = 110
		refs = "0015 _NF__DE 0036 Format 0044 @LStrCat 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 28 8D 45 FC 50 89 5D F4 C6 45 F8 0B 8D 55 F4 33 C9 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 8B 45 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_8851_0 {
	meta:
		name = "_NF__CD"
		size = 110
		refs = "0015 _NF__CD 0036 Format 0044 @LStrCat 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 28 8D 45 FC 50 89 5D F4 C6 45 F8 0B 8D 55 F4 33 C9 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 8B 45 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1264_0 {
	meta:
		name = "TCGIResponse.SendResponse"
		size = 1212
		refs = "001a TCGIResponse.SendResponse 0094 Format 00a3 @LStrLAsg 00b1 _NF__DE 00d7 TCollection.GetCount 00ec TCookieCollection.GetCookie 00f4 TCookie.GetHeaderValue 015a FormatDateTime 0165 @LStrCat 01eb TWebResponse.AddCustomHeaders 026a IntToStr 02e2 @LStrArrayClr 02e8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 D2 89 55 F4 89 55 F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 BA 01 00 00 00 8B 43 10 8B 30 FF 16 83 7D F4 00 0F 84 57 02 00 00 8D 4D F4 BA 01 00 00 00 8B C3 8B 30 FF 16 83 7D F4 00 74 49 8B C3 8B 10 FF 52 24 85 C0 7E 3E 8D 45 F8 50 8B C3 8B 10 FF 52 24 89 45 E4 C6 45 E8 00 8D 4D F4 BA 01 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 89 45 EC C6 45 F0 0B 8D 55 E4 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 55 BA ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 05 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 43 0C E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 28 46 33 FF 55 8B D7 8B 43 0C E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 47 4E 75 DB 55 8D 4D F4 BA 0A 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 BA 01 00 00 00 8B C3 8B 08 FF 51 08 D8 1D ?? ?? ?? ?? DF E0 9E 76 2B BA 01 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 55 F4 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8D 45 FC E8 ?? ?? ?? ?? BA 02 00 00 00 8B C3 8B 08 FF 51 08 D8 1D ?? ?? ?? ?? DF E0 9E 76 2B BA 02 00 00 00 8B C3 8B 08 FF 51 08 83 C4 F8 DD 1C 24 9B 8D 55 F4 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8D 45 FC E8 ?? ?? ?? ?? 55 8D 4D F4 BA 0B 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 03 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 55 8D 4D F4 BA 09 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 07 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8D 4D F4 BA 08 00 00 00 8B C3 8B 30 FF 16 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 55 F4 8B C3 8B 08 FF 51 18 83 7D F4 00 75 06 83 7B 04 00 74 20 55 33 D2 8B C3 8B 08 FF 51 10 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 43 10 8B 08 FF 51 1C 8B 43 04 85 C0 75 17 8D 55 F4 8B C3 8B 08 FF 51 18 8B 55 F4 8B 43 10 8B 08 FF 51 1C EB 16 85 C0 74 12 8B D0 8B C3 8B 08 FF 51 40 33 D2 8B C3 8B 08 FF 51 20 C6 43 68 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 FF FF FF FF 05 00 00 00 25 64 20 25 73 00 00 00 FF FF FF FF 06 00 00 00 32 30 30 20 4F 4B 00 00 FF FF FF FF 0C 00 00 00 53 74 61 74 75 73 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 0B 00 00 00 41 6C 6C 6F 77 3A 20 25 73 0D 0A 00 FF FF FF FF 10 00 00 00 53 65 74 2D 43 6F 6F 6B 69 65 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 12 00 00 00 44 65 72 69 76 65 64 2D 46 72 6F 6D 3A 20 25 73 0D 0A 00 00 00 00 00 00 FF FF FF FF 2C 00 00 00 22 45 78 70 69 72 65 73 3A 20 22 64 64 64 2C 20 64 64 20 6D 6D 6D 20 79 79 79 79 20 68 68 3A 6D 6D 3A 73 73 20 22 47 4D 54 22 0D 0A 00 00 00 00 FF FF FF FF 32 00 00 00 22 4C 61 73 74 2D 4D 6F 64 69 66 69 65 64 3A 20 22 64 64 64 2C 20 64 64 20 6D 6D 6D 20 79 79 79 79 20 68 68 3A 6D 6D 3A 73 73 20 22 47 4D 54 22 0D 0A 00 00 FF FF FF FF 0B 00 00 00 54 69 74 6C 65 3A 20 25 73 0D 0A 00 FF FF FF FF 16 00 00 00 57 57 57 2D 41 75 74 68 65 6E 74 69 63 61 74 65 3A 20 25 73 0D 0A 00 00 FF FF FF FF 15 00 00 00 43 6F 6E 74 65 6E 74 2D 56 65 72 73 69 6F 6E 3A 20 25 73 0D 0A 00 00 00 FF FF FF FF 16 00 00 00 43 6F 6E 74 65 6E 74 2D 45 6E 63 6F 64 69 6E 67 3A 20 25 73 0D 0A 00 00 FF FF FF FF 12 00 00 00 43 6F 6E 74 65 6E 74 2D 54 79 70 65 3A 20 25 73 0D 0A 00 00 FF FF FF FF 14 00 00 00 43 6F 6E 74 65 6E 74 2D 4C 65 6E 67 74 68 3A 20 25 73 0D 0A 00 00 00 00 FF FF FF FF 0C 00 00 00 43 6F 6E 74 65 6E 74 3A 0D 0A 0D 0A 00 00 00 00 }
	condition:
		$1
}

rule function_1265_0 {
	meta:
		name = "TCGIResponse.SendRedirect"
		size = 132
		refs = "0015 TCGIResponse.SendRedirect 0035 Format 0059 @LStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 89 75 F4 C6 45 F8 0B 8D 55 F4 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 43 10 8B 08 FF 51 1C C6 43 68 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 00 FF FF FF FF 0C 00 00 00 4C 6F 63 61 74 69 6F 6E 3A 20 25 73 00 00 00 00 }
	condition:
		$1
}

rule function_1266_0 {
	meta:
		name = "TCGIResponse.SendStream"
		size = 91
		refs = "0040 TStream.GetPosition 0049 TStream.GetSize"
		altNames = "TISAPIResponse.SendStream"
	strings:
		$1 = { 53 56 57 50 B8 02 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 84 24 00 20 00 00 83 C4 04 8B DA 8B F0 EB 1A 8B D4 B9 00 20 00 00 8B C3 8B 38 FF 57 04 8B D4 8B C8 8B 46 10 8B 38 FF 57 18 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C3 E8 ?? ?? ?? ?? 3B F8 7C D2 81 C4 00 20 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1267_0 {
	meta:
		name = "_NF__E8"
		size = 592
	strings:
		$1 = { FF FF FF FF 0E 00 00 00 52 65 71 75 65 73 74 20 4D 65 74 68 6F 64 00 00 FF FF FF FF 10 00 00 00 52 65 71 75 65 73 74 20 50 72 6F 74 6F 63 6F 6C 00 00 00 00 FF FF FF FF 03 00 00 00 55 72 6C 00 FF FF FF FF 0C 00 00 00 51 75 65 72 79 20 53 74 72 69 6E 67 00 00 00 00 FF FF FF FF 0C 00 00 00 4C 6F 67 69 63 61 6C 20 50 61 74 68 00 00 00 00 FF FF FF FF 0D 00 00 00 50 68 79 73 69 63 61 6C 20 50 61 74 68 00 00 00 FF FF FF FF 0D 00 00 00 43 61 63 68 65 20 43 6F 6E 74 72 6F 6C 00 00 00 FF FF FF FF 04 00 00 00 44 61 74 65 00 00 00 00 FF FF FF FF 06 00 00 00 41 63 63 65 70 74 00 00 FF FF FF FF 04 00 00 00 46 72 6F 6D 00 00 00 00 FF FF FF FF 04 00 00 00 48 6F 73 74 00 00 00 00 FF FF FF FF 11 00 00 00 49 66 2D 4D 6F 64 69 66 69 65 64 2D 53 69 6E 63 65 00 00 00 FF FF FF FF 07 00 00 00 52 65 66 65 72 65 72 00 FF FF FF FF 0A 00 00 00 55 73 65 72 2D 41 67 65 6E 74 00 00 FF FF FF FF 10 00 00 00 43 6F 6E 74 65 6E 74 2D 45 6E 63 6F 64 69 6E 67 00 00 00 00 FF FF FF FF 0C 00 00 00 43 6F 6E 74 65 6E 74 20 54 79 70 65 00 00 00 00 FF FF FF FF 0E 00 00 00 43 6F 6E 74 65 6E 74 20 4C 65 6E 67 74 68 00 00 FF FF FF FF 0F 00 00 00 43 6F 6E 74 65 6E 74 20 56 65 72 73 69 6F 6E 00 FF FF FF FF 0C 00 00 00 44 65 72 69 76 65 64 2D 46 72 6F 6D 00 00 00 00 FF FF FF FF 07 00 00 00 45 78 70 69 72 65 73 00 FF FF FF FF 05 00 00 00 54 69 74 6C 65 00 00 00 FF FF FF FF 0E 00 00 00 52 65 6D 6F 74 65 20 41 64 64 72 65 73 73 00 00 FF FF FF FF 0B 00 00 00 52 65 6D 6F 74 65 20 48 6F 73 74 00 FF FF FF FF 0F 00 00 00 45 78 65 63 75 74 61 62 6C 65 20 50 61 74 68 00 FF FF FF FF 0B 00 00 00 53 65 72 76 65 72 20 50 6F 72 74 00 FF FF FF FF 0A 00 00 00 43 6F 6E 6E 65 63 74 69 6F 6E 00 00 FF FF FF FF 06 00 00 00 43 6F 6F 6B 69 65 00 00 FF FF FF FF 0D 00 00 00 41 75 74 68 6F 72 69 7A 61 74 69 6F 6E 00 00 00 }
	condition:
		$1
}

rule function_1268_0 {
	meta:
		name = "TWinCGIRequest.Create"
		size = 320
		refs = "000f @ClassCreate 001e @LStrAddRef 0036 TWinCGIRequest.Create 0046 _Dn_TIniFile 004b TIniFile.Create 006d TIniFile.ReadString 0097 _Dn_TFileStream 009c TFileStream.Create 00bc TCGIRequest.Create 00d1 @LStrClr 00de @LStrArrayClr 00e4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 0C E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 77 18 83 7D 0C 00 75 17 6A 00 8D 45 0C 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 83 7D 08 00 75 18 6A 00 8D 45 08 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 47 18 E8 ?? ?? ?? ?? 6A 40 8B 4D 0C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 1C 6A 41 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 20 33 D2 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 08 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C2 08 00 00 00 FF FF FF FF 0C 00 00 00 43 6F 6E 74 65 6E 74 20 46 69 6C 65 00 00 00 00 FF FF FF FF 06 00 00 00 53 79 73 74 65 6D 00 00 FF FF FF FF 0B 00 00 00 4F 75 74 70 75 74 20 46 69 6C 65 00 }
	condition:
		$1
}

rule function_1269_0 {
	meta:
		name = "TWinCGIRequest.Destroy"
		size = 58
		refs = "000a TObject.Free 0026 TWebRequest.Destroy 0031 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 18 E8 ?? ?? ?? ?? 8B 46 1C E8 ?? ?? ?? ?? 8B 46 20 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1270_0 {
	meta:
		name = "TWinCGIRequest.GetFieldByName"
		size = 56
		refs = "000f TWinCGIRequest.GetFieldByName 0017 TIniFile.ReadString"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 6A 00 57 8B CE BA ?? ?? ?? ?? 8B 43 18 E8 ?? ?? ?? ?? 5F 5E 5B C3 00 FF FF FF FF 0D 00 00 00 45 78 74 72 61 20 48 65 61 64 65 72 73 00 00 00 }
	condition:
		$1
}

rule function_1271_0 {
	meta:
		name = "_NF__F5"
		size = 268
		refs = "0014 _NF__F5 0021 _Dn_TStringList 0026 TObject.Create 004d TIniFile.ReadSection 0054 @LStrClr 008f @LStrCatN 00a1 @LStrLen 00ab @LStrSetLength 00c0 TObject.Free 00c6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 40 18 8B 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 32 46 C7 45 F8 00 00 00 00 FF 33 8D 4D F4 8B 55 F8 8B 45 FC 8B 38 FF 57 0C FF 75 F4 68 ?? ?? ?? ?? 8B C3 BA 03 00 00 00 E8 ?? ?? ?? ?? FF 45 F8 4E 75 D6 83 3B 00 74 11 8B 03 E8 ?? ?? ?? ?? 8B D0 4A 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 FF FF FF FF 06 00 00 00 41 63 63 65 70 74 00 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_1272_0 {
	meta:
		name = "TWinCGIRequest.GetStringVariable"
		size = 248
		refs = "0018 TWinCGIRequest.GetStringVariable 0069 _NV__E7 0079 TIniFile.ReadString 0088 @LStrLAsg 0093 _NF__F5 00c3 @LStrClr 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 83 F8 1C 77 7B 8A 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 01 01 00 01 01 01 00 00 03 00 00 00 00 00 00 01 01 00 00 00 00 01 01 01 01 02 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 00 56 8B 0C 9D ?? ?? ?? ?? 8B 45 FC 8B 40 18 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 48 8B C6 8B 55 FC 8B 52 14 E8 ?? ?? ?? ?? EB 39 55 8D 45 F8 E8 ?? ?? ?? ?? 59 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 23 85 DB 7C 18 83 FB 1C 7F 13 8B CE 8B 14 9D ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 20 EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 00 00 FF FF FF FF 03 00 00 00 43 47 49 00 }
	condition:
		$1
}

rule function_1273_0 {
	meta:
		name = "TWinCGIRequest.ReadClient"
		size = 11
	strings:
		$1 = { 53 8B 40 1C 8B 18 FF 53 04 5B C3 }
	condition:
		$1
}

rule function_1274_0 {
	meta:
		name = "TWinCGIRequest.ReadString"
		size = 38
		refs = "000e @LStrSetLength"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C7 8B D3 E8 ?? ?? ?? ?? 85 DB 7E 0C 8B 17 8B CB 8B 46 1C 8B 18 FF 53 04 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1276_0 {
	meta:
		name = "TWinCGIRequest.WriteClient"
		size = 11
	strings:
		$1 = { 53 8B 40 20 8B 18 FF 53 08 5B C3 }
	condition:
		$1
}

rule function_1277_0 {
	meta:
		name = "TWinCGIRequest.WriteString"
		size = 51
		refs = "000d @LStrLen"
	strings:
		$1 = { 53 56 8B DA 8B F0 85 DB 74 24 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D3 8B 46 20 8B 30 FF 56 08 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 0F 94 C0 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1278_0 {
	meta:
		name = "_NF__10A"
		size = 468
		refs = "0021 _NF__10A 0038 TObject.ClassName 005e sInternalServerError 0063 LoadResString 0074 Format 008a @LStrLen 00a8 IsConsole 00bf Output 00c6 FileWrite 00ec _Dn_TFileStream 00f1 TFileStream.Create 0141 TObject.Free 0147 @HandleFinally 0161 @LStrClr 016e @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 53 56 33 C9 89 8D E0 FE FF FF 89 4D FC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 95 E4 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 E4 FE FF FF 89 45 E4 C6 45 E8 04 8B 43 04 89 45 EC C6 45 F0 0B 8D 45 E4 50 8D 95 E0 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 E0 FE FF FF B9 01 00 00 00 5A E8 ?? ?? ?? ?? 8D 45 F8 50 8B 43 04 89 45 E4 C6 45 E8 0B 8B 45 FC E8 ?? ?? ?? ?? 89 45 EC C6 45 F0 00 8D 55 E4 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 34 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? EB 68 6A 41 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B 45 F4 8B 18 FF 53 08 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B 45 F4 8B 18 FF 53 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E0 FE FF FF E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 FF FF FF FF 49 00 00 00 53 74 61 74 75 73 3A 20 35 30 30 20 25 73 0D 0A 43 6F 6E 74 65 6E 74 2D 54 79 70 65 3A 20 74 65 78 74 2F 68 74 6D 6C 0D 0A 43 6F 6E 74 65 6E 74 2D 4C 65 6E 67 74 68 3A 20 25 64 0D 0A 43 6F 6E 74 65 6E 74 3A 0D 0A 0D 0A 00 00 00 }
	condition:
		$1
}

rule function_1279_0 {
	meta:
		name = "_NF__10B"
		size = 324
		refs = "0025 _NF__10B 0030 IsConsole 003c _DV_TCGIRequest 0041 TCGIRequest.Create 0058 ParamStr 0093 _DV_TWinCGIRequest 0098 TWinCGIRequest.Create 00c8 @LStrToPChar 00e9 GetPrivateProfileString 00f9 @LStrFromPCharLen 0116 @LStrArrayClr 011c @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 EC FE FF FF 53 56 33 D2 89 95 F4 FE FF FF 89 95 F0 FE FF FF 89 95 EC FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 80 38 00 74 13 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E9 B1 00 00 00 8D 95 F4 FE FF FF B8 02 00 00 00 E8 ?? ?? ?? ?? 8B 85 F4 FE FF FF 50 8D 95 F0 FE FF FF B8 03 00 00 00 E8 ?? ?? ?? ?? 8B 85 F0 FE FF FF 50 8D 95 EC FE FF FF B8 01 00 00 00 E8 ?? ?? ?? ?? 8B 8D EC FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 53 44 B8 03 00 00 00 E8 ?? ?? ?? ?? 83 7B 44 00 75 4C 8D 95 F4 FE FF FF B8 01 00 00 00 E8 ?? ?? ?? ?? 8B 85 F4 FE FF FF E8 ?? ?? ?? ?? 50 68 05 01 00 00 8D 85 FB FE FF FF 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8D 95 FB FE FF FF 8D 43 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 EC FE FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5E 5B 8B E5 5D C3 00 00 00 00 00 00 4F 75 74 70 75 74 20 46 69 6C 65 00 53 79 73 74 65 6D 00 00 }
	condition:
		$1
}

rule function_1280_0 {
	meta:
		name = "_NF__10C"
		size = 40
		refs = "0001 IsConsole 000d _DV_TCGIResponse 0014 TCGIResponse.Create 001c _DV_TWinCGIResponse"
	strings:
		$1 = { A1 ?? ?? ?? ?? 80 38 00 74 0F 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1281_0 {
	meta:
		name = "TCGIApplication.Run"
		size = 242
		refs = "0010 TWebApplication.Run 0015 IsConsole 001f Output 0024 @RewritText 0029 @_IOTest 002e Input 0033 @ResetText 0040 TCGIApplication.Run 004e _NF__10B 006a _NF__10C 0089 TWebApplication.HandleRequest 009e TObject.Free 00a4 @HandleFinally 00d2 @HandleAnyException 00d7 ExceptObject 00e2 _NF__10A 00e7 @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 1E A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D F4 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 EB 1A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 52 44 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1282_0 {
	meta:
		name = "_NF__10F"
		size = 23
		refs = "0005 _DV_TCGIApplication 000a TWebApplication.Create 0010 Application"
	strings:
		$1 = { 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_8864_0 {
	meta:
		name = "_NF__E8"
		size = 23
		refs = "0005 _DV_TISAPIApplication 000a TWebApplication.Create 0010 Application"
	strings:
		$1 = { 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_1283_0 {
	meta:
		name = "_NF__110"
		size = 22
		refs = "0001 Application 0008 TObject.Free"
		altNames = "_NF__E9"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 D2 89 10 C3 }
	condition:
		$1
}

rule function_1284_0 {
	meta:
		name = "Finalization"
		size = 95
		refs = "0007 Finalization 0013 _NV__90 001a _NF__110 001f _NV__E7 002a String 002f @FinalizeArray 0034 _NV__91 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 2F E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? B9 1D 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? B9 1D 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1285_0 {
	meta:
		name = "CGIApp"
		size = 15
		refs = "0002 _NV__90 000a _NF__10F"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8867_0 {
	meta:
		name = "ISAPIApp"
		size = 15
		refs = "0002 _NV__7F 000a _NF__E8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1461_0 {
	meta:
		name = "checklst"
		size = 15
		refs = "0002 _NV__BE 000a _NF__C3"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1286_0 {
	meta:
		name = "GradientFill"
		size = 452
		refs = "003c GetRValue 004b GetGValue 005a GetBValue 00a3 TCanvas.GetHandle 00c5 MulDiv 00f3 RGB 00f9 CreateSolidBrush 0103 SelectObject 0153 PatBlt 01ad DeleteObject"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 8B D9 8B FA 89 45 FC 80 7D 08 00 74 0A 8B 47 08 2B 07 89 45 F8 EB 09 8B 47 0C 2B 47 04 89 45 F8 8B 75 F8 81 FE 00 01 00 00 7E 05 BE 00 01 00 00 8B C3 E8 ?? ?? ?? ?? 25 FF 00 00 00 89 45 DC 8B C3 E8 ?? ?? ?? ?? 25 FF 00 00 00 89 45 E0 8B C3 E8 ?? ?? ?? ?? 25 FF 00 00 00 89 45 E4 8B 45 0C E8 ?? ?? ?? ?? 25 FF 00 00 00 2B 45 DC 89 45 D0 8B 45 0C E8 ?? ?? ?? ?? 25 FF 00 00 00 2B 45 E0 89 45 D4 8B 45 0C E8 ?? ?? ?? ?? 25 FF 00 00 00 2B 45 E4 89 45 D8 8B 45 FC E8 ?? ?? ?? ?? 89 45 EC 8B C6 48 85 C0 0F 8C 06 01 00 00 40 89 45 E8 33 DB 8B C6 48 50 8B 45 D8 50 53 E8 ?? ?? ?? ?? 02 45 E4 50 8B C6 48 50 8B 45 D4 50 53 E8 ?? ?? ?? ?? 02 45 E0 50 8B C6 48 50 8B 45 D0 50 53 E8 ?? ?? ?? ?? 02 45 DC 5A 59 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 8B 45 EC 50 E8 ?? ?? ?? ?? 89 45 F0 80 7D 08 00 74 49 56 8B 45 F8 50 53 E8 ?? ?? ?? ?? 8B 57 08 2B D0 89 55 F4 68 21 00 F0 00 8B 47 0C 2B 47 04 50 56 8B 45 F8 50 8D 43 01 50 E8 ?? ?? ?? ?? 8B 57 08 2B D0 2B 55 F4 52 8B 47 04 50 8B 45 F4 50 8B 45 EC 50 E8 ?? ?? ?? ?? EB 45 56 8B 45 F8 50 53 E8 ?? ?? ?? ?? 8B 57 0C 2B D0 89 55 F4 68 21 00 F0 00 56 8B 45 F8 50 8D 43 01 50 E8 ?? ?? ?? ?? 8B 57 0C 2B D0 2B 55 F4 52 8B 47 08 2B 07 50 8B 45 F4 50 8B 07 50 8B 45 EC 50 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 EC 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 43 FF 4D E8 0F 85 00 FF FF FF 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1287_0 {
	meta:
		name = "GetDefaultPattern"
		size = 20
		refs = "000f _NV__224"
	strings:
		$1 = { 8B C8 8B C1 B9 06 00 00 00 99 F7 F9 42 8A 82 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1288_0 {
	meta:
		name = "_NF__227"
		size = 45
		refs = "0011 _Dn_TForm 0016 @IsClass 0027 @AsClass"
	strings:
		$1 = { 53 8B 58 04 EB 03 8B 5B 04 85 DB 74 11 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1289_0 {
	meta:
		name = "TChartGradient.Create"
		size = 71
		refs = "000b @ClassCreate 001a TObject.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 04 C6 47 09 00 C7 47 0C FF FF FF 00 C7 47 10 FF FF 00 00 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1290_0 {
	meta:
		name = "TChartGradient.SetVisible"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 08 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14965_0 {
	meta:
		name = "TSeriesMarks.SetVisible"
		size = 14
		refs = "0009 TChartSeries.SetBooleanProperty"
	strings:
		$1 = { 8D 48 08 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1291_0 {
	meta:
		name = "TChartGradient.SetDirection"
		size = 17
	strings:
		$1 = { 3A 50 09 74 0B 88 50 09 8B 40 04 8B 10 FF 52 44 C3 }
	condition:
		$1
}

rule function_1292_0 {
	meta:
		name = "TChartGradient.SetStartColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 0C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15210_0 {
	meta:
		name = "TChartAxis.SetVisible"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 0C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15270_0 {
	meta:
		name = "TCustomChartLegend.SetResizeChart"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 0C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14969_0 {
	meta:
		name = "TSeriesMarks.SetBackColor"
		size = 14
		refs = "0009 TChartSeries.SetColorProperty"
	strings:
		$1 = { 8D 48 0C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1293_0 {
	meta:
		name = "TChartGradient.SetEndColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 10 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15194_0 {
	meta:
		name = "TChartAxis.SetLabels"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 10 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15163_0 {
	meta:
		name = "TChartAxisTitle.SetCaption"
		size = 14
		refs = "0009 TCustomTeePanel.SetStringProperty"
	strings:
		$1 = { 8D 48 10 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14970_0 {
	meta:
		name = "TSeriesMarks.SetBackTransparent"
		size = 14
		refs = "0009 TChartSeries.SetBooleanProperty"
	strings:
		$1 = { 8D 48 10 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1294_0 {
	meta:
		name = "TChartGradient.Assign"
		size = 64
		refs = "000a _DV_TChartGradient 000f @IsClass 0039 TPersistent.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C6 8A 50 08 88 53 08 8A 50 09 88 53 09 8B 50 0C 89 53 0C 8B 40 10 89 43 10 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1295_0 {
	meta:
		name = "TChartWall.Create"
		size = 128
		refs = "000b @ClassCreate 001a TObject.Create 002b _Dn_TBrush 0030 TBrush.Create 004d _Dn_TChartPen 0052 TChartPen.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 14 C7 47 04 00 00 00 80 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 77 0C 8B 47 14 89 46 08 8B 00 8B 80 88 00 00 00 89 46 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 77 08 8B 47 14 89 46 08 8B 00 8B 80 88 00 00 00 89 46 04 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1296_0 {
	meta:
		name = "TChartWall.Destroy"
		size = 50
		refs = "000a TObject.Free 001e TPersistent.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 08 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1297_0 {
	meta:
		name = "TChartWall.Assign"
		size = 75
		refs = "000b _DV_TChartWall 0010 @IsClass 0043 TPersistent.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 26 8B FE 8B 47 04 89 43 04 8B 57 0C 8B 43 0C 8B 08 FF 51 08 8B 57 08 8B 43 08 8B 08 FF 51 08 8B 47 10 89 43 10 EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1298_0 {
	meta:
		name = "TChartWall.SetPen"
		size = 9
		altNames = "TWebResponse.SetCustomHeaders"
	strings:
		$1 = { 8B 40 08 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1299_0 {
	meta:
		name = "TChartWall.SetBrush"
		size = 9
		altNames = "TColumnTitle.SetFont"
	strings:
		$1 = { 8B 40 0C 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1300_0 {
	meta:
		name = "TChartWall.SetSize"
		size = 14
		refs = "0009 TCustomTeePanel.SetLongintProperty"
	strings:
		$1 = { 8D 48 10 8B 40 14 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1301_0 {
	meta:
		name = "TChartWall.SetColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 04 8B 40 14 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1302_0 {
	meta:
		name = "TChartBrush.Create"
		size = 58
		refs = "000a @ClassCreate 0017 TBrush.Create 0023 TBrush.SetColor"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 00 00 00 80 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1303_0 {
	meta:
		name = "TChartTitle.Create"
		size = 163
		refs = "000e @ClassCreate 001c TChartFontObject.Create 0023 _Dn_TStringList 0028 TObject.Create 0040 TFont.SetColor 0047 _Dn_TChartHiddenPen 004c TChartHiddenPen.Create 006d _DV_TChartBrush 0072 TChartBrush.Create"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 C6 43 14 01 C6 43 0C 02 BA 00 00 FF 00 8B 43 08 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 18 8B 43 04 89 46 08 8B 00 8B 80 88 00 00 00 89 46 04 C6 43 1C 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 20 8B 43 04 89 46 08 8B 00 8B 80 88 00 00 00 89 46 04 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1304_0 {
	meta:
		name = "TChartTitle.Assign"
		size = 90
		refs = "000b _DV_TChartTitle 0010 @IsClass 0052 TChartFontObject.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B FE 8B 57 10 8B 43 10 8B 08 FF 51 08 8A 47 0C 88 43 0C 8A 47 14 88 43 14 8B 57 18 8B 43 18 8B 08 FF 51 08 8A 47 1C 88 43 1C 8B 57 20 8B 43 20 8B 08 FF 51 08 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1305_0 {
	meta:
		name = "TChartTitle.IsTitleFontStored"
		size = 160
		refs = "000d TChartTitle.IsTitleFontStored 0020 TFont.GetName 002c GetDefaultFontName 0035 @LStrCmp 003e TFont.GetSize 0045 GetDefaultFontSize 0059 TFont.GetStyle 0080 @LStrClr 008e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 58 08 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 75 30 8B C3 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 3B F0 75 1E 81 7B 14 00 00 FF 00 75 15 8B C3 E8 ?? ?? ?? ?? 8A 15 ?? ?? ?? ?? 3A D0 75 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5E 5B 59 59 5D C3 00 00 00 00 }
	condition:
		$1
}

rule function_1306_0 {
	meta:
		name = "TChartTitle.Destroy"
		size = 58
		refs = "000a TObject.Free 0026 TChartFontObject.Destroy 0031 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 10 E8 ?? ?? ?? ?? 8B 46 18 E8 ?? ?? ?? ?? 8B 46 20 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1307_0 {
	meta:
		name = "TChartTitle.SetText"
		size = 20
		refs = "000e TChartFontObject.Repaint"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1308_0 {
	meta:
		name = "TChartTitle.SetVisible"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 14 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15268_0 {
	meta:
		name = "TCustomChartLegend.SetHorizMargin"
		size = 14
		refs = "0009 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 8D 48 14 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1309_0 {
	meta:
		name = "TChartTitle.SetAdjustFrame"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 48 1C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15206_0 {
	meta:
		name = "TChartAxis.SetTitleSize"
		size = 14
		refs = "0009 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 8D 48 1C 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1310_0 {
	meta:
		name = "TChartTitle.SetAlignment"
		size = 14
		refs = "0009 TChartFontObject.Repaint"
	strings:
		$1 = { 3A 50 0C 74 08 88 50 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1311_0 {
	meta:
		name = "TChartTitle.SetBrush"
		size = 9
		altNames = "TSeriesMarks.SetArrow"
	strings:
		$1 = { 8B 40 20 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1312_0 {
	meta:
		name = "TChartTitle.SetFrame"
		size = 9
	strings:
		$1 = { 8B 40 18 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1313_0 {
	meta:
		name = "TChartTitle.Clicked"
		size = 62
		refs = "0019 Point 002a PtInRect"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F9 8B F2 8B D8 80 7B 14 00 74 20 8B CC 8B D7 8B C6 E8 ?? ?? ?? ?? FF 74 24 04 FF 74 24 04 8D 43 24 50 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 02 B0 01 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1314_0 {
	meta:
		name = "TCustomChart.Create"
		size = 468
		refs = "0019 @ClassCreate 0026 TCustomChart.Create 0035 TCustomAxisPanel.Create 003e _DV_TChartTitle 0043 TChartTitle.Create 0070 TObject.ClassName 007e @LStrFromString 00a4 TFont.SetColor 00a9 GetDefaultFontSize 00b2 TFont.SetSize 00bf TFont.SetStyle 00c8 _DV_TChartGradient 00cd TChartGradient.Create 00dc _DV_TChartWall 00e1 TChartWall.Create 00f5 TChartWall.SetColor 0125 _Dn_TPicture 012a TPicture.Create 0183 Rect 01ab @LStrClr 01b1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 E8 FE FF FF 53 56 57 33 DB 89 5D F8 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 44 02 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 48 02 00 00 F6 43 20 10 74 5C 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B 83 44 02 00 00 8B 40 10 8B 08 FF 51 34 8B 83 48 02 00 00 8B 70 08 BA FF 00 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8A 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 34 02 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 38 02 00 00 BA FF FF 80 00 8B C6 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 3C 02 00 00 BA FF FF FF 00 8B C6 E8 ?? ?? ?? ?? C6 83 2B 02 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 30 02 00 00 89 5E 0C 8B 03 8B 80 88 00 00 00 89 46 08 C7 83 24 02 00 00 08 00 00 00 C6 83 29 02 00 00 01 C6 83 2A 02 00 00 03 C6 83 20 02 00 00 00 C6 83 A0 02 00 00 01 6A 0F 8D 85 E8 FE FF FF 50 B9 0F 00 00 00 BA 0F 00 00 00 B8 0F 00 00 00 E8 ?? ?? ?? ?? 8D B5 E8 FE FF FF 8D BB F4 02 00 00 B9 04 00 00 00 F3 A5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 8B E5 5D C3 02 00 00 00 }
	condition:
		$1
}

rule function_1315_0 {
	meta:
		name = "TCustomChart.Destroy"
		size = 100
		refs = "000d TObject.Free 0050 TCustomAxisPanel.Destroy 005b @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 44 02 00 00 E8 ?? ?? ?? ?? 8B 86 48 02 00 00 E8 ?? ?? ?? ?? 8B 86 3C 02 00 00 E8 ?? ?? ?? ?? 8B 86 38 02 00 00 E8 ?? ?? ?? ?? 8B 86 34 02 00 00 E8 ?? ?? ?? ?? 8B 86 30 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1316_0 {
	meta:
		name = "TCustomChart.SetTitle"
		size = 12
	strings:
		$1 = { 8B 80 44 02 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1317_0 {
	meta:
		name = "TCustomChart.SetBackImage"
		size = 12
	strings:
		$1 = { 8B 80 30 02 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1318_0 {
	meta:
		name = "TCustomChart.SetBackImageInside"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 88 2C 02 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1319_0 {
	meta:
		name = "TCustomChart.SetFoot"
		size = 12
	strings:
		$1 = { 8B 80 48 02 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1320_0 {
	meta:
		name = "TCustomChart.SetBackImageMode"
		size = 20
	strings:
		$1 = { 3A 90 2B 02 00 00 74 0B 88 90 2B 02 00 00 8B 10 FF 52 44 C3 }
	condition:
		$1
}

rule function_1321_0 {
	meta:
		name = "_NF__28C"
		size = 42
	strings:
		$1 = { 8A 48 0D 88 0A 8A 48 0F 88 4A 01 8A 48 0E 88 4A 02 8B 48 54 89 4A 04 8B 48 58 89 4A 08 8B 48 4C 89 4A 0C 8B 48 50 89 4A 10 C3 }
	condition:
		$1
}

rule function_1322_0 {
	meta:
		name = "_NF__28D"
		size = 64
		refs = "000f _NF__28C"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 B8 01 00 00 E8 ?? ?? ?? ?? 8D 56 3C 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 8D 56 14 8B 83 C0 01 00 00 E8 ?? ?? ?? ?? 8D 56 28 8B 83 C4 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1324_0 {
	meta:
		name = "_NF__28F"
		size = 64
		refs = "000f _NF__28E"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 B8 01 00 00 E8 ?? ?? ?? ?? 8D 56 3C 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 8D 56 14 8B 83 C0 01 00 00 E8 ?? ?? ?? ?? 8D 56 28 8B 83 C4 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1323_0 {
	meta:
		name = "_NF__28E"
		size = 63
		refs = "000b TChartAxis.SetAutomatic 0015 TChartAxis.SetAutomaticMinimum 001f TChartAxis.SetAutomaticMaximum 0038 TChartAxis.SetMinMax"
	strings:
		$1 = { 53 56 8B F2 8B D8 8A 16 8B C3 E8 ?? ?? ?? ?? 8A 56 01 8B C3 E8 ?? ?? ?? ?? 8A 56 02 8B C3 E8 ?? ?? ?? ?? 80 7B 0D 00 75 13 FF 76 08 FF 76 04 FF 76 10 FF 76 0C 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1325_0 {
	meta:
		name = "TCustomChart.SetGradient"
		size = 12
	strings:
		$1 = { 8B 80 34 02 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1326_0 {
	meta:
		name = "TCustomChart.SetLeftWall"
		size = 12
	strings:
		$1 = { 8B 80 38 02 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1327_0 {
	meta:
		name = "TCustomChart.SetBottomWall"
		size = 12
	strings:
		$1 = { 8B 80 3C 02 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1328_0 {
	meta:
		name = "_NF__299"
		size = 77
		refs = "0023 TCustomChart.DrawTitle"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 8B 80 44 02 00 00 80 78 14 00 74 12 8B 55 08 8B D0 8B 45 08 8B 40 FC B1 01 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 80 48 02 00 00 80 78 14 00 74 12 8B 55 08 8B D0 8B 45 08 8B 40 FC 33 C9 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_1329_0 {
	meta:
		name = "TCustomChart.DrawTitlesAndLegend"
		size = 110
		refs = "0020 TChartSeriesList.CountActive 0045 _NF__299"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 8B 80 B4 01 00 00 80 78 2C 00 74 4E 8B 45 FC 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 85 C0 7E 3C 8B 45 FC 8B 90 B4 01 00 00 8A 42 2D 84 C0 74 04 3C 01 75 10 8B C2 8B 10 FF 52 18 55 E8 ?? ?? ?? ?? 59 EB 1F 55 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 80 B4 01 00 00 8B 10 FF 52 18 59 5D C3 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_1330_0 {
	meta:
		name = "TCustomChart.DrawBitmap"
		size = 338
		refs = "0043 TCanvas.StretchDraw 005a TCustomAxisPanel.ClipRectangle 006e TPicture.GetWidth 007c TPicture.GetHeight 00c7 TCanvas.Draw 0146 TCustomAxisPanel.UnClipRectangle"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F2 8B D8 8B 83 30 02 00 00 8B 40 04 85 C0 0F 84 2E 01 00 00 8B 56 0C 2B 56 04 89 54 24 08 8B 56 08 2B 16 89 54 24 0C 80 BB 2B 02 00 00 00 75 14 8B C8 8B D6 8B 83 50 01 00 00 E8 ?? ?? ?? ?? E9 FE 00 00 00 80 BB A0 01 00 00 00 75 09 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 2B 02 00 00 01 75 79 8B 83 30 02 00 00 E8 ?? ?? ?? ?? 89 04 24 8B 83 30 02 00 00 E8 ?? ?? ?? ?? 89 44 24 04 83 3C 24 00 0F 8E AC 00 00 00 83 7C 24 04 00 0F 8E A1 00 00 00 33 ED 3B 6C 24 08 0F 8D 95 00 00 00 33 FF 3B 7C 24 0C 7D 27 8B 83 30 02 00 00 8B 40 04 50 8B 4E 04 03 CD 8B 16 03 D7 8B 83 50 01 00 00 E8 ?? ?? ?? ?? 03 3C 24 3B 7C 24 0C 7C D9 03 6C 24 04 3B 6C 24 08 7C C7 EB 5A 8B D6 8B C3 8B 08 FF 91 D0 00 00 00 8B 83 30 02 00 00 E8 ?? ?? ?? ?? 8B 7C 24 0C 2B F8 D1 FF 79 03 83 D7 00 03 3E 8B 83 30 02 00 00 E8 ?? ?? ?? ?? 8B 6C 24 08 2B E8 D1 FD 79 03 83 D5 00 03 6E 04 8B 83 30 02 00 00 8B 40 04 50 8B CD 8B D7 8B 83 50 01 00 00 E8 ?? ?? ?? ?? 80 BB A0 01 00 00 00 75 07 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1331_0 {
	meta:
		name = "TCustomChart.FillPanelRect"
		size = 140
		refs = "004c GradientFill 005d PrintTeePanel 0070 TBrush.SetColor 007a TBrush.SetStyle 0083 TCanvas.FillRect"
	strings:
		$1 = { 53 56 57 55 8B F2 8B 90 34 02 00 00 80 7A 08 00 74 40 8A 4A 09 84 C9 74 05 80 F9 02 75 08 8B 6A 0C 8B 7A 10 EB 06 8B 7A 0C 8B 6A 10 57 8A 4A 09 80 F9 02 74 09 80 F9 03 74 04 33 D2 EB 02 B2 01 52 8B D6 8B 80 50 01 00 00 8B CD E8 ?? ?? ?? ?? EB 35 8A 90 A0 01 00 00 80 F2 01 0A 15 ?? ?? ?? ?? 74 24 8B 98 50 01 00 00 8B 50 54 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1332_0 {
	meta:
		name = "TCustomChart.BackWallsPaint"
		size = 60
		refs = "0020 TCustomAxisPanel.BackWallRect 0033 TCustomAxisPanel.BackWallsPaint"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B 83 30 02 00 00 83 78 04 00 74 1E 80 BB 2C 02 00 00 00 74 15 8B D4 8B C3 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 91 D4 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1333_0 {
	meta:
		name = "_NF__2A4"
		size = 107
		refs = "0035 Frame3D"
	strings:
		$1 = { 55 8B EC 84 C0 74 62 3C 01 75 30 68 14 00 00 80 8B 45 08 8B 40 EC 8B 80 20 01 00 00 50 8B 45 08 8D 50 F0 8B 45 08 8B 40 EC 8B 80 50 01 00 00 B9 10 00 00 80 E8 ?? ?? ?? ?? EB 2E 68 10 00 00 80 8B 45 08 8B 40 EC 8B 80 20 01 00 00 50 8B 45 08 8D 50 F0 8B 45 08 8B 40 EC 8B 80 50 01 00 00 B9 14 00 00 80 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_1334_0 {
	meta:
		name = "TCustomChart.PanelPaint"
		size = 231
		refs = "0070 TPen.SetStyle 007c TPen.SetWidth 0085 TPen.SetMode 0098 TBrush.SetStyle 00a7 _NF__2A4 00cc Frame3D"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 45 EC 8B F2 8D 7D F0 B9 04 00 00 00 F3 A5 8D 55 F0 8B 45 EC 8B 08 FF 91 D0 00 00 00 8B 45 EC 8B 80 30 02 00 00 83 78 04 00 74 1A 8B 45 EC 80 B8 2C 02 00 00 00 75 0E 8D 55 F0 8B 45 EC 8B 08 FF 91 D4 00 00 00 8B 45 EC 80 B8 A0 01 00 00 00 0F 85 81 00 00 00 8B 45 EC 8B 80 50 01 00 00 8B 58 10 33 D2 8B C3 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 04 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 8B 80 50 01 00 00 8B 40 14 B2 01 E8 ?? ?? ?? ?? 55 8B 45 EC 8A 80 1D 01 00 00 E8 ?? ?? ?? ?? 59 8B 45 EC 8B 40 54 50 8B 55 EC 8B 92 24 01 00 00 52 8B C8 8D 55 F0 8B 45 EC 8B 80 50 01 00 00 E8 ?? ?? ?? ?? 55 8B 45 EC 8A 80 1C 01 00 00 E8 ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1335_0 {
	meta:
		name = "TCustomChart.CalcWallSize"
		size = 59
	strings:
		$1 = { 33 C9 80 B8 C8 01 00 00 00 74 2D 80 B8 C9 01 00 00 00 74 24 3B 90 C0 01 00 00 75 0B 8B 80 38 02 00 00 8B 48 10 EB 11 3B 90 BC 01 00 00 75 09 8B 80 3C 02 00 00 8B 48 10 8B C1 C3 }
	condition:
		$1
}

rule function_1336_0 {
	meta:
		name = "_NF__2AB"
		size = 153
		refs = "0038 TPen.SetStyle 0049 TBrush.GetStyle 005e TBrush.GetColor 0079 TCustomTeePanel.SetBrushCanvas 0092 TBrush.SetStyle"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 43 08 80 78 18 00 74 17 8B 55 08 8B 52 FC 8B 92 50 01 00 00 8B 52 10 92 8B 08 FF 51 08 EB 16 8B 45 08 8B 40 FC 8B 80 50 01 00 00 8B 40 10 B2 05 E8 ?? ?? ?? ?? 81 7B 04 00 00 00 80 75 0C 8B 43 0C E8 ?? ?? ?? ?? 84 C0 74 2F 8B 43 0C E8 ?? ?? ?? ?? 50 8B 43 0C E8 ?? ?? ?? ?? 50 8B 45 08 8B 40 FC 8B 90 50 01 00 00 8B 45 08 8B 40 FC 8B 4B 04 E8 ?? ?? ?? ?? 5B 5D C3 8B 45 08 8B 40 FC 8B 80 50 01 00 00 8B 40 14 B2 01 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1337_0 {
	meta:
		name = "TCustomChart.DrawWalls"
		size = 671
		refs = "0017 _NF__2AB 0069 Point 00aa TCustomTeePanel.DoPolygon 00d6 TCanvas.Rectangle"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 89 45 FC 55 8B 45 FC 8B 80 38 02 00 00 E8 ?? ?? ?? ?? 59 8B 45 FC 8B B0 38 02 00 00 8B 45 FC 8D 98 80 01 00 00 8B 45 FC 8B 53 04 2B 90 60 01 00 00 89 55 F8 8B 45 FC 8B B8 5C 01 00 00 03 3B 89 7D F4 8B 45 F4 89 45 D4 8B 45 F8 89 45 D8 8B 45 FC 8B 53 0C 2B 90 60 01 00 00 8D 4D CC 8B C7 E8 ?? ?? ?? ?? 8B 45 CC 89 45 DC 8B 45 D0 89 45 E0 8D 4D C4 8B 53 0C 42 8B 03 E8 ?? ?? ?? ?? 8B 45 C4 89 45 E4 8B 45 C8 89 45 E8 8B 03 89 45 EC 8B 43 04 89 45 F0 8D 55 D4 B9 03 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 56 10 85 D2 0F 8E 80 00 00 00 8B 03 8B C8 2B CA 51 8B 53 04 52 8B 4B 0C 41 8B 55 FC FF B2 50 01 00 00 8B D0 42 58 E8 ?? ?? ?? ?? 8B 45 F4 89 45 D4 8B 45 F8 89 45 D8 8D 4D CC 8B C7 2B 46 10 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 CC 89 45 DC 8B 45 D0 89 45 E0 8D 4D C4 8B 03 2B 46 10 8B 53 04 E8 ?? ?? ?? ?? 8B 45 C4 89 45 E4 8B 45 C8 89 45 E8 8B 03 89 45 EC 8B 43 04 89 45 F0 8D 55 D4 B9 03 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 55 8B 45 FC 8B 80 3C 02 00 00 E8 ?? ?? ?? ?? 59 8B 45 FC 8B B0 3C 02 00 00 8B 45 FC 8D 98 80 01 00 00 8B 45 FC 8B 53 0C 2B 90 60 01 00 00 4A 89 55 F8 8B 45 FC 8B B8 5C 01 00 00 8B C7 03 43 08 89 45 F4 8D 4D CC 8B C7 03 03 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 CC 89 45 D4 8B 45 D0 89 45 D8 8B 45 F4 89 45 DC 8B 45 F8 89 45 E0 8D 4D C4 8B 53 0C 8B 43 08 E8 ?? ?? ?? ?? 8B 45 C4 89 45 E4 8B 45 C8 89 45 E8 8D 4D BC 8B 53 0C 8B 03 E8 ?? ?? ?? ?? 8B 45 BC 89 45 EC 8B 45 C0 89 45 F0 8D 55 D4 B9 03 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 83 7E 10 00 0F 8E A8 00 00 00 8B 43 08 50 8B 46 10 8B 7B 0C 03 C7 40 50 8B 45 FC 8B 90 C0 01 00 00 8B 45 FC 8B 08 FF 91 A0 00 00 00 8B 13 2B D0 8B 45 FC 8B 80 50 01 00 00 8B CF E8 ?? ?? ?? ?? 8B 45 F4 89 45 D4 8B 45 F8 89 45 D8 8D 4D CC 8B 56 10 03 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 CC 89 45 DC 8B 45 D0 89 45 E0 8D 4D C4 8B 56 10 03 53 0C 8B 43 08 48 E8 ?? ?? ?? ?? 8B 45 C4 89 45 E4 8B 45 C8 89 45 E8 8D 4D BC 8B 43 08 48 8B 53 0C E8 ?? ?? ?? ?? 8B 45 BC 89 45 EC 8B 45 C0 89 45 F0 8D 55 D4 B9 03 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1338_0 {
	meta:
		name = "_NF__2AE"
		size = 117
	strings:
		$1 = { 55 8B EC 53 56 8B F0 8B 45 08 8B 40 FC 8B D6 8B 08 FF 91 90 00 00 00 8B 55 08 8B 52 F8 8A 52 0C 80 EA 01 72 04 74 0A EB 14 8B 45 08 8B 40 E8 EB 2A 8B 55 08 8B 52 F0 2B D0 8B C2 EB 1E 8B 55 08 8B 52 E8 8B 4D 08 03 51 F0 D1 FA 79 03 83 D2 00 D1 F8 79 03 83 D0 00 2B D0 8B C2 56 8B 55 08 8B 4A EC 8B 55 08 8B 52 FC 92 8B 18 FF 93 84 00 00 00 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1339_0 {
	meta:
		name = "TCustomChart.DrawTitle"
		size = 872
		refs = "001b TCustomChart.DrawTitle 0043 TCustomTeePanel.TeeCharHeight 005c TBrush.GetColor 006d TBrush.SetStyle 0080 TPen.GetColor 00a1 TPen.GetWidth 018b InflateRect 0256 TCustomTeePanel.DoRectangle 0266 TCanvas.GetHandle 026c SetBkMode 02a9 _NF__2AE 0340 TCustomTeePanel.ReCalcWidthHeight 0355 @LStrClr 035b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 33 DB 89 5D D0 88 4D E7 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 98 50 01 00 00 8B 45 F8 8B 50 08 8B 45 FC 8B 08 FF 91 80 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 89 45 E0 8B 45 F8 8B 50 20 8B 43 14 8B 08 FF 51 08 8B 43 14 E8 ?? ?? ?? ?? 3D 00 00 00 80 75 0A 8B 43 14 B2 01 E8 ?? ?? ?? ?? 8B 45 F8 8B 70 18 80 7E 18 00 74 0E 8B C6 E8 ?? ?? ?? ?? 3D 00 00 00 80 75 04 33 C0 EB 02 B0 01 88 45 DB 80 7D DB 00 74 0D 8B 45 F8 8B 40 18 E8 ?? ?? ?? ?? EB 02 33 C0 8B 55 FC 8B 92 80 01 00 00 03 D0 89 55 E8 80 7D E7 00 74 20 8B 55 FC 8B 92 84 01 00 00 89 55 EC 80 7D DB 00 74 03 01 45 EC 8B 55 EC 83 EA 05 89 55 F4 EB 1E 8B 55 FC 8B 92 8C 01 00 00 89 55 F4 80 7D DB 00 74 03 29 45 F4 8B 55 F4 83 C2 05 89 55 EC 8B 55 FC 8B 92 88 01 00 00 89 55 F0 80 7D DB 00 74 03 29 45 F0 8B 45 F8 8D 78 24 8D 75 E8 B9 04 00 00 00 F3 A5 80 7D DB 00 74 1A 8B 45 F8 8B 50 18 8B 43 10 8B 08 FF 51 08 8B 43 10 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 8B C7 03 C0 89 45 D4 80 7D E7 00 74 19 8B 45 F8 8B 40 10 8B 10 FF 52 14 F7 6D E0 03 45 EC 8B 55 F8 89 42 30 EB 19 8B 45 F8 8B 40 10 8B 10 FF 52 14 F7 6D E0 8B 55 F4 2B D0 8B 45 F8 89 50 28 57 57 8B 45 F8 83 C0 24 50 E8 ?? ?? ?? ?? 80 7D DB 00 0F 84 AD 00 00 00 8B 45 F8 80 78 1C 00 0F 84 A0 00 00 00 33 C0 89 45 DC 8B 45 F8 8B 40 10 8B 10 FF 52 14 8B F0 4E 85 F6 7C 2F 46 33 DB 8D 4D D0 8B 45 F8 8B 40 10 8B D3 8B 38 FF 57 0C 8B 55 D0 8B 45 FC 8B 08 FF 91 90 00 00 00 8B F8 3B 7D DC 7E 03 89 7D DC 43 4E 75 D4 8B 45 D4 01 45 DC 8B 45 F8 83 C0 24 8B 55 F8 8A 52 0C 80 EA 01 72 08 74 10 FE CA 74 16 EB 3B 8B 10 03 55 DC 89 50 08 EB 31 8B 50 08 2B 55 DC 89 10 EB 27 8B 10 03 50 08 D1 FA 79 03 83 D2 00 8B 4D DC D1 F9 79 03 83 D1 00 8B DA 2B D9 2B 5D D4 89 18 03 D1 03 55 D4 89 50 08 80 7D DB 00 74 0E 8B 45 F8 8D 50 24 8B 45 FC E8 ?? ?? ?? ?? 6A 01 8B 45 FC 8B 80 50 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 7D E7 00 74 44 8B 45 F8 8B 40 10 8B 10 FF 52 14 8B F0 4E 85 F6 7C 74 46 33 DB 8B 45 EC 03 45 E0 89 45 F4 55 8D 4D D0 8B 45 F8 8B 40 10 8B D3 8B 38 FF 57 0C 8B 45 D0 E8 ?? ?? ?? ?? 59 8B 45 F4 89 45 EC 43 4E 75 D3 EB 42 8B 45 F8 8B 40 10 8B 10 FF 52 14 8B D8 4B 83 FB 00 7C 2F 8B 45 F4 2B 45 E0 89 45 EC 55 8D 4D D0 8B 45 F8 8B 40 10 8B D3 8B 30 FF 56 0C 8B 45 D0 E8 ?? ?? ?? ?? 59 8B 45 EC 89 45 F4 4B 83 FB FF 75 D1 80 7D DB 00 74 14 80 7D E7 00 74 08 8B 45 D4 01 45 F4 EB 06 8B 45 D4 29 45 EC 80 7D E7 00 74 11 8B 45 F4 83 C0 05 8B 55 FC 89 82 84 01 00 00 EB 0F 8B 45 EC 83 E8 05 8B 55 FC 89 82 8C 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1340_0 {
	meta:
		name = "TCustomChart.DrawToMetaCanvas"
		size = 115
		refs = "002e TCustomChart.DrawToMetaCanvas 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 45 FC 8B 45 FC C6 80 58 01 00 00 01 8B 45 FC 8A 80 D6 01 00 00 88 45 FB 8B 45 FC C6 80 D6 01 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 18 FF 93 C4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8A 55 FB 88 90 D6 01 00 00 8B 45 FC C6 80 58 01 00 00 00 C3 E9 ?? ?? ?? ?? EB E2 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1341_0 {
	meta:
		name = "TCustomChart.SaveToMetafile"
		size = 39
		refs = "001d TCustomChart.SaveToMetafileRect"
	strings:
		$1 = { 53 56 83 C4 F0 8B F2 8B D8 8B D4 8B C3 8B 08 FF 91 94 00 00 00 54 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_1342_0 {
	meta:
		name = "TCustomChart.SaveToMetafileEnh"
		size = 39
		refs = "001d TCustomChart.SaveToMetafileRect"
	strings:
		$1 = { 53 56 83 C4 F0 8B F2 8B D8 8B D4 8B C3 8B 08 FF 91 94 00 00 00 54 8B CE B2 01 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_1343_0 {
	meta:
		name = "TCustomChart.SaveToMetafileRect"
		size = 146
		refs = "000d TCustomChart.TeeCreateMetafile 0018 TCustomChart.SaveToMetafileRect 002c _Dn_TFileStream 0031 TFileStream.Create 0062 TObject.Free 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B D9 8B 4D 08 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 FF FF 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B 45 FC 8B 08 FF 51 54 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1344_0 {
	meta:
		name = "TCustomChart.SaveToBitmapFile"
		size = 150
		refs = "000f _Dn_TBitmap 0014 TBitmap.Create 001f TCustomChart.SaveToBitmapFile 0056 TBitmap.GetCanvas 0084 TObject.Free 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 8B 08 FF 91 94 00 00 00 8B 55 F4 2B 55 EC 8B 45 FC 8B 08 FF 51 40 8B 55 F8 2B 55 F0 8B 45 FC 8B 08 FF 51 34 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8D 4D EC 8B C3 8B 18 FF 93 C4 00 00 00 8B D6 8B 45 FC 8B 08 FF 51 4C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1345_0 {
	meta:
		name = "TCustomChart.PrintPortrait"
		size = 8
		refs = "0003 TCustomChart.PrintOrientation"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7458_0 {
	meta:
		name = "TApplication.NormalizeTopMosts"
		size = 8
		refs = "0003 _NF__638"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1562_0 {
	meta:
		name = "TCollectionItem.SetDisplayName"
		size = 8
		refs = "0003 TCollectionItem.Changed"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3439_0 {
	meta:
		name = "TControl.Hide"
		size = 8
		refs = "0003 TControl.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7386_0 {
	meta:
		name = "TCustomForm.Hide"
		size = 8
		refs = "0003 TCustomForm.SetVisible"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9317_0 {
	meta:
		name = "TCustomMaskEdit.Clear"
		size = 8
		refs = "0003 TCustomMaskEdit.SetText"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13282_0 {
	meta:
		name = "TCustomSocket.Close"
		size = 8
		refs = "0003 TCustomSocket.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4218_0 {
	meta:
		name = "TDataSet.Close"
		size = 8
		refs = "0003 TDataSet.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3906_0 {
	meta:
		name = "TField.Clear"
		size = 8
		refs = "0003 TField.SetData"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1519_0 {
	meta:
		name = "TList.First"
		size = 8
		refs = "0003 TList.Get"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11796_0 {
	meta:
		name = "TOutlineNode.Collapse"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9981_0 {
	meta:
		name = "TPivotButton.DragCanceled"
		size = 8
		refs = "0003 _NF__130"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6603_0 {
	meta:
		name = "TPropertyEditor.GetOrdValue"
		size = 8
		refs = "0003 TPropertyEditor.GetOrdValueAt"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1746_0 {
	meta:
		name = "TReader.ReadListEnd"
		size = 8
		refs = "0003 _NF__4DA"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5566_0 {
	meta:
		name = "TSession.Close"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2172_0 {
	meta:
		name = "TTreeNode.GetCut"
		size = 8
		refs = "0003 _NF__832"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3509_0 {
	meta:
		name = "TWinControl.Realign"
		size = 8
		refs = "0003 _NF__58E"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1800_0 {
	meta:
		name = "TWriter.WriteListEnd"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6090_0 {
	meta:
		name = "_NF__101"
		size = 8
		refs = "0003 TCollectionItem.Changed"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1346_0 {
	meta:
		name = "TCustomChart.PrintLandscape"
		size = 8
		refs = "0003 TCustomChart.PrintOrientation"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7459_0 {
	meta:
		name = "TApplication.NormalizeAllTopMosts"
		size = 8
		refs = "0003 _NF__638"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9856_0 {
	meta:
		name = "TBaseArray.GetAutoSize"
		size = 8
		refs = "0003 TBaseArray.HasFlag"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13281_0 {
	meta:
		name = "TCustomSocket.Open"
		size = 8
		refs = "0003 TCustomSocket.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4217_0 {
	meta:
		name = "TDataSet.Open"
		size = 8
		refs = "0003 TDataSet.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11795_0 {
	meta:
		name = "TOutlineNode.Expand"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6036_0 {
	meta:
		name = "TQuery.CreateHandle"
		size = 8
		refs = "0003 _NF__991"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1745_0 {
	meta:
		name = "TReader.ReadListBegin"
		size = 8
		refs = "0003 _NF__4DA"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5606_0 {
	meta:
		name = "TSession.Open"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5988_0 {
	meta:
		name = "TStoredProc.CreateHandle"
		size = 8
		refs = "0003 _NF__933"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2174_0 {
	meta:
		name = "TTreeNode.GetDropTarget"
		size = 8
		refs = "0003 _NF__832"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1799_0 {
	meta:
		name = "TWriter.WriteListBegin"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1347_0 {
	meta:
		name = "TCustomChart.PrintOrientation"
		size = 95
		refs = "000b Printer 0010 TPrinter.GetOrientation 001f TPrinter.SetOrientation 0027 TCustomChart.PrintOrientation 0034 TCustomChart.Print 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 8B F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 45 FF E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8A 55 FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1348_0 {
	meta:
		name = "TCustomChart.CalcMetaBounds"
		size = 199
		refs = "002d TCustomTeePanel.GetWidthHeight 003f MulDiv"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F9 8B DA 8B F0 8B 43 08 2B 03 8B 55 0C 89 02 8B 43 0C 2B 43 04 8B 55 08 89 02 8D 4D F8 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 6A 64 8B 86 40 02 00 00 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 55 FC 2B D0 89 17 6A 64 8B 86 40 02 00 00 50 8B 45 F8 50 E8 ?? ?? ?? ?? 8B 55 F8 2B D0 8B 45 10 89 10 8B 45 0C 8B 00 50 8B 07 50 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 45 0C 8B 00 50 8B 07 50 8B 43 08 50 E8 ?? ?? ?? ?? 89 43 08 8B 45 08 8B 00 50 8B 45 10 8B 00 50 8B 43 04 50 E8 ?? ?? ?? ?? 89 43 04 8B 45 08 8B 00 50 8B 45 10 8B 00 50 8B 43 0C 50 E8 ?? ?? ?? ?? 89 43 0C 5F 5E 5B 59 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1349_0 {
	meta:
		name = "TCustomChart.PrintPartialCanvas"
		size = 240
		refs = "0031 SwapInteger 0066 TCustomChart.CalcMetaBounds 006d TCanvas.GetHandle 0075 SaveDC 007f SetMapMode 008b SetWindowOrgEx 009d SetWindowExtEx 00af SetViewportExtEx 00bb SetViewportOrgEx 00cf TCustomChart.DrawToMetaCanvas 00e4 RestoreDC"
	strings:
		$1 = { 53 56 57 55 83 C4 E0 8B D9 8B FA 8B F0 56 57 8B F3 8D 7C 24 18 B9 04 00 00 00 F3 A5 5F 5E 8B 44 24 10 3B 44 24 18 7E 0D 8D 54 24 18 8D 44 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 3B 44 24 1C 7E 0D 8D 54 24 1C 8D 44 24 14 E8 ?? ?? ?? ?? 8D 44 24 0C 50 8D 44 24 04 50 8D 44 24 0C 50 8D 4C 24 14 8D 54 24 1C 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 53 E8 ?? ?? ?? ?? 8B E8 6A 08 53 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 53 E8 ?? ?? ?? ?? 6A 00 8B 44 24 10 50 8B 44 24 10 50 53 E8 ?? ?? ?? ?? 6A 00 8B 44 24 08 50 8B 44 24 08 50 53 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 53 E8 ?? ?? ?? ?? C6 86 A0 01 00 00 01 8D 4C 24 10 8B D7 8B C6 E8 ?? ?? ?? ?? C6 86 A0 01 00 00 00 55 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1350_0 {
	meta:
		name = "TCustomChart.PrintPartial"
		size = 30
		refs = "0007 Printer 000c TPrinter.GetCanvas 0017 TCustomChart.PrintPartialCanvas"
	strings:
		$1 = { 53 56 8B F2 8B D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1351_0 {
	meta:
		name = "TCustomChart.PrintRect"
		size = 140
		refs = "000a Printer 0015 @LStrAsg 001f TPrinter.BeginDoc 0027 TCustomChart.PrintRect 0036 TCustomChart.PrintPartial 0040 TPrinter.EndDoc 004f @HandleOnException 0057 _Dn_Exception 0065 TPrinter.Abort 007f @RaiseAgain 0084 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 E8 ?? ?? ?? ?? 83 C0 18 8B 53 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 3A E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 78 1C 00 74 0A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1352_0 {
	meta:
		name = "_NF__2DD"
		size = 41
		refs = "0011 @ROUND"
	strings:
		$1 = { 55 8B EC 84 C0 74 10 8B 45 10 DB 40 FC DC 4D 08 E8 ?? ?? ?? ?? EB 0E 8B 45 10 DB 40 F8 DC 4D 08 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_1353_0 {
	meta:
		name = "_NF__2DE"
		size = 84
		refs = "0012 _NF__2DE"
	strings:
		$1 = { 55 8B EC 83 C4 F4 84 C0 74 20 89 55 F4 DB 45 F4 D8 0D ?? ?? ?? ?? 8B 45 08 DB 40 FC D8 0D ?? ?? ?? ?? DE F9 DD 5D F8 9B EB 1E 89 55 F4 DB 45 F4 D8 0D ?? ?? ?? ?? 8B 45 08 DB 40 F8 D8 0D ?? ?? ?? ?? DE F9 DD 5D F8 9B DD 45 F8 8B E5 5D C3 00 00 00 80 3F }
	condition:
		$1
}

rule function_1354_0 {
	meta:
		name = "TCustomChart.ChartPrintRect"
		size = 308
		refs = "000f Printer 0014 TPrinter.GetHandle 001a GetDeviceCaps 003d TPrinter.GetPageWidth 0046 _NF__2DE 004d TCustomChart.ChartPrintRect 0071 _NF__2DD 00af TPrinter.GetPageHeight"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B F2 8B D8 6A 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 FC 6A 5A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 F8 55 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 B0 01 E8 ?? ?? ?? ?? 59 DB 2D ?? ?? ?? ?? DE C9 DD 5D F0 9B 55 DB 83 F4 02 00 00 D8 0D ?? ?? ?? ?? DC 4D F0 83 C4 F8 DD 1C 24 9B B0 01 E8 ?? ?? ?? ?? 59 89 06 55 DB 83 FC 02 00 00 D8 0D ?? ?? ?? ?? DC 4D F0 83 C4 F8 DD 1C 24 9B B0 01 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 2B C2 89 46 08 55 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 33 C0 E8 ?? ?? ?? ?? 59 DB 2D ?? ?? ?? ?? DE C9 DD 5D F0 9B 55 DB 83 F8 02 00 00 D8 0D ?? ?? ?? ?? DC 4D F0 83 C4 F8 DD 1C 24 9B 33 C0 E8 ?? ?? ?? ?? 59 89 46 04 55 DB 83 00 03 00 00 D8 0D ?? ?? ?? ?? DC 4D F0 83 C4 F8 DD 1C 24 9B 33 C0 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 2B C2 89 46 0C 5E 5B 8B E5 5D C3 00 00 00 0A D7 A3 70 3D 0A D7 A3 F8 3F 00 00 00 00 80 3F }
	condition:
		$1
}

rule function_1355_0 {
	meta:
		name = "TCustomChart.Print"
		size = 29
		refs = "000b TCustomChart.ChartPrintRect 0014 TCustomChart.PrintRect"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1356_0 {
	meta:
		name = "TCustomChart.SeriesUp"
		size = 43
		refs = "000a TList.IndexOf 001e TList.Exchange"
	strings:
		$1 = { 53 8B D8 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 85 C0 7E 17 8B C8 49 8B D0 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 44 5B C3 }
	condition:
		$1
}

rule function_1357_0 {
	meta:
		name = "TCustomChart.SeriesDown"
		size = 46
		refs = "000a TList.IndexOf 0021 TList.Exchange"
	strings:
		$1 = { 53 8B D8 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B 93 AC 01 00 00 8B 4A 08 49 3B C1 7D 10 8D 48 01 92 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 44 5B C3 }
	condition:
		$1
}

rule function_1358_0 {
	meta:
		name = "TCustomChart.PreviousPage"
		size = 34
	strings:
		$1 = { 83 B8 08 02 00 00 00 7E 18 83 B8 04 02 00 00 01 7E 0F 8B 90 04 02 00 00 4A 8B 08 FF 91 98 00 00 00 C3 }
	condition:
		$1
}

rule function_1359_0 {
	meta:
		name = "TCustomChart.NextPage"
		size = 52
		refs = "0014 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 83 BE 08 02 00 00 00 7E 24 8B C6 66 BB D9 FF E8 ?? ?? ?? ?? 3B 86 04 02 00 00 7E 11 8B 96 04 02 00 00 42 8B C6 8B 08 FF 91 98 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1360_0 {
	meta:
		name = "_NF__2ED"
		size = 56
		refs = "000b AnimatedZoomFactor 0030 TChartAxis.SetMinMax"
	strings:
		$1 = { 55 8B EC DD 45 10 DC 60 54 DC 35 ?? ?? ?? ?? DC 40 54 83 C4 F8 DD 1C 24 9B DD 40 4C DC 65 08 DC 35 ?? ?? ?? ?? DC 68 4C 83 C4 F8 DD 1C 24 9B E8 ?? ?? ?? ?? 5D C2 10 00 }
	condition:
		$1
}

rule function_1361_0 {
	meta:
		name = "TCustomChart.DoZoom"
		size = 271
		refs = "001f _NF__28D 0064 _NF__2ED 00bc TControl.Refresh 00e3 TCustomAxisPanel.DoZoom"
	strings:
		$1 = { 55 8B EC 83 C4 AC 53 56 57 89 4D FC 8B FA 8B D8 80 BB A0 02 00 00 00 74 23 8D 55 AC 8B C3 E8 ?? ?? ?? ?? 57 8D 75 AC 8D BB 50 02 00 00 B9 14 00 00 00 F3 A5 5F C6 83 A0 02 00 00 00 80 BB 28 02 00 00 00 74 7E 8B B3 24 02 00 00 4E 85 F6 7E 73 FF 77 04 FF 37 8B 45 FC FF 70 04 FF 30 8B 83 B8 01 00 00 E8 ?? ?? ?? ?? 8B 45 1C FF 70 04 FF 30 8B 45 18 FF 70 04 FF 30 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 8B 45 14 FF 70 04 FF 30 8B 45 10 FF 70 04 FF 30 8B 83 C0 01 00 00 E8 ?? ?? ?? ?? 8B 45 0C FF 70 04 FF 30 8B 45 08 FF 70 04 FF 30 8B 83 C4 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 4E 75 8D 8B 45 1C 50 8B 45 18 50 8B 45 14 50 8B 45 10 50 8B 45 0C 50 8B 45 08 50 8B 4D FC 8B D7 8B C3 E8 ?? ?? ?? ?? C6 83 4C 02 00 00 01 66 83 BB E6 02 00 00 00 74 0E 8B D3 8B 83 E8 02 00 00 FF 93 E4 02 00 00 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_1362_0 {
	meta:
		name = "TCustomChart.SetAnimatedZoom"
		size = 14
		refs = "0009 TCustomTeePanel.SetBooleanProperty"
	strings:
		$1 = { 8D 88 28 02 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1363_0 {
	meta:
		name = "TCustomChart.SetAnimatedZoomSteps"
		size = 14
		refs = "0009 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 8D 88 24 02 00 00 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1364_0 {
	meta:
		name = "TCustomChart.ZoomRect"
		size = 44
	strings:
		$1 = { 56 8B F0 8B 86 A4 01 00 00 8B 0A 89 48 08 8B 4A 04 89 48 0C 8B 4A 08 89 48 10 8B 52 0C 89 50 14 8B C6 8B 10 FF 92 9C 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1365_0 {
	meta:
		name = "_NF__301"
		size = 120
		refs = "002b TChartAxis.CalcMinMax 003d _NF__301"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 8B F1 8B DA 8B 50 54 89 55 F0 8B 50 58 89 55 F4 8B 50 4C 89 55 E8 8B 50 50 89 55 EC 8D 4D E8 8D 55 F0 E8 ?? ?? ?? ?? DD 45 E8 DC 65 F0 8B 45 08 DD 40 08 D8 25 ?? ?? ?? ?? DE C9 DB 2D ?? ?? ?? ?? DE C9 DD 5D F8 9B DD 45 F0 DC 45 F8 DD 1B 9B DD 45 E8 DC 65 F8 DD 1E 9B 5E 5B 8B E5 5D C3 00 00 00 C8 42 0A D7 A3 70 3D 0A D7 A3 F8 3F 00 00 }
	condition:
		$1
}

rule function_1366_0 {
	meta:
		name = "TCustomChart.ZoomPercent"
		size = 141
		refs = "0018 _NF__301"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 8B D8 55 8D 4D F0 8D 55 F8 8B 83 B8 01 00 00 E8 ?? ?? ?? ?? 59 55 8D 4D D0 8D 55 D8 8B 83 C0 01 00 00 E8 ?? ?? ?? ?? 59 55 8D 4D C0 8D 55 C8 8B 83 C4 01 00 00 E8 ?? ?? ?? ?? 59 55 8D 4D E0 8D 55 E8 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 59 8D 45 E8 50 8D 45 E0 50 8D 45 D8 50 8D 45 D0 50 8D 45 C8 50 8D 45 C0 50 8D 4D F0 8D 55 F8 8B C3 8B 30 FF 96 A8 00 00 00 8B C3 8B 10 FF 52 48 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1367_0 {
	meta:
		name = "_NF__305"
		size = 50
		refs = "0015 TChartAxis.Clicked"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 48 FC 8B 45 08 8B 50 F8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 12 8B 55 08 8B 52 F4 C6 02 02 8B 55 08 8B 52 F4 89 5A 0C 5B 5D C3 }
	condition:
		$1
}

rule function_1368_0 {
	meta:
		name = "TCustomChart.CalcClickedPart"
		size = 386
		refs = "004c PtInRect 0073 TCustomAxisPanel.GetSeries 00cb _NF__305 011c TChartTitle.Clicked 0155 TCustomAxisPanel.ChartRegionRect 016d TChartSeriesList.CountActive"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 8B F2 8D 7D F8 A5 A5 89 4D F4 8B D8 8B 45 F4 C6 00 00 8B 45 F4 C7 40 04 FF FF FF FF 8B 45 F4 33 D2 89 50 08 8B 45 F4 33 D2 89 50 0C 8B B3 B4 01 00 00 80 7E 2C 00 74 1E FF 75 FC FF 75 F8 8D 46 30 50 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 45 F4 C6 00 01 E9 1C 01 00 00 8B 83 AC 01 00 00 8B 70 08 4E 83 FE 00 7C 55 8B D6 8B C3 E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 80 78 58 00 74 3A 8B 4D FC 8B 55 F8 8B 45 F0 8B 38 FF 97 C0 00 00 00 8B 55 F4 89 42 04 8B 45 F4 83 78 04 FF 74 1A 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 89 42 08 8B 45 F4 C6 00 03 E9 BE 00 00 00 4E 83 FE FF 75 AB 55 8B 83 B8 01 00 00 E8 ?? ?? ?? ?? 59 84 C0 0F 85 A3 00 00 00 55 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 59 84 C0 0F 85 8E 00 00 00 55 8B 83 C0 01 00 00 E8 ?? ?? ?? ?? 59 84 C0 75 7D 55 8B 83 C4 01 00 00 E8 ?? ?? ?? ?? 59 84 C0 75 6C 8B 4D FC 8B 55 F8 8B 83 44 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 08 8B 45 F4 C6 00 04 EB 4F 8B 4D FC 8B 55 F8 8B 83 48 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 08 8B 45 F4 C6 00 05 EB 32 FF 75 FC FF 75 F8 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 85 C0 74 15 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 85 C0 7E 06 8B 45 F4 C6 00 06 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1369_0 {
	meta:
		name = "_NF__30A"
		size = 204
		refs = "001a TeeZoomMouseButton 002a TeeZoomKeyShift 0039 TControl.SetCursor 0056 TZoomPanningRecord.Activate 0061 TCustomTeePanel.DrawZoomRectangle 0083 TeeScrollMouseButton 0093 TeeScrollKeyShift"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 80 B8 29 02 00 00 00 74 5A 8B 45 08 8A 40 FB 3A 05 ?? ?? ?? ?? 75 4C 8B 45 08 8A 40 FA F7 D0 22 05 ?? ?? ?? ?? 75 3C 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 8B 45 08 8B 48 08 8B 45 08 8B 50 0C 8B 45 08 8B 40 FC 8B 80 A4 01 00 00 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 C6 40 F9 01 8B 45 08 8B 40 FC 80 B8 2A 02 00 00 00 74 4F 8B 45 08 8A 40 FB 3A 05 ?? ?? ?? ?? 75 41 8B 45 08 8A 40 FA F7 D0 22 05 ?? ?? ?? ?? 75 31 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 8B 45 08 8B 48 08 8B 45 08 8B 50 0C 8B 45 08 8B 40 FC 8B 80 A8 01 00 00 E8 ?? ?? ?? ?? 8B 45 08 C6 40 F9 01 5D C3 }
	condition:
		$1
}

rule function_1370_0 {
	meta:
		name = "_NF__30B"
		size = 105
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 66 83 B8 BE 02 00 00 00 74 52 8B 45 08 8B 40 FC C6 80 20 02 00 00 01 8B 45 08 8A 40 FA 50 8B 45 08 8B 40 0C 50 8B 45 08 8B 40 08 50 8B 45 08 8B 58 FC 8B 45 08 8A 48 FB 8B 45 08 8B 50 FC 8B 83 C0 02 00 00 FF 93 BC 02 00 00 8B 45 08 8B 40 FC 8A 80 20 02 00 00 8B 55 08 88 42 F9 5B 5D C3 }
	condition:
		$1
}

rule function_1371_0 {
	meta:
		name = "TCustomChart.MouseDown"
		size = 509
		refs = "0022 TControl.MouseDown 0071 Point 007f TCustomChart.CalcClickedPart 016d _NF__30A 01cd _NF__30B"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 88 4D FA 88 55 FB 89 45 FC 8B 45 0C 50 8B 45 08 50 8A 4D FA 8A 55 FB 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 A4 01 00 00 80 78 04 00 0F 85 BD 01 00 00 8B 45 FC 8B 80 A8 01 00 00 80 78 04 00 0F 85 AA 01 00 00 8B 45 FC 80 B8 20 02 00 00 00 74 0F 8B 45 FC C6 80 20 02 00 00 00 E9 8F 01 00 00 8D 4D E0 8B 55 08 8B 45 0C E8 ?? ?? ?? ?? 8D 55 E0 8D 4D E8 8B 45 FC E8 ?? ?? ?? ?? C6 45 F9 00 8A 45 E8 FE C8 74 19 FE C8 0F 84 DE 00 00 00 FE C8 74 5A 2C 03 0F 84 29 01 00 00 E9 38 01 00 00 8B 45 FC 66 83 B8 AE 02 00 00 00 0F 84 27 01 00 00 8B 45 FC C6 80 20 02 00 00 01 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 5D FC 8A 4D FB 8B 55 FC 8B 83 B0 02 00 00 FF 93 AC 02 00 00 8B 45 FC 8A 80 20 02 00 00 88 45 F9 E9 EB 00 00 00 8A 45 FB 50 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 4D EC 8B 5D F0 8B D3 8B C3 8B 18 FF 93 E0 00 00 00 88 45 F9 8B 45 FC 66 83 B8 B6 02 00 00 00 74 3F 8B 45 FC C6 80 20 02 00 00 01 8B 45 EC 50 8A 45 FB 50 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 5D FC 8B 4D F0 8B 55 FC 8B 83 B8 02 00 00 FF 93 B4 02 00 00 8B 45 FC 8A 80 20 02 00 00 88 45 F9 80 7D F9 00 75 74 55 E8 ?? ?? ?? ?? 59 EB 6B 8B 45 FC 66 83 B8 B6 02 00 00 00 74 3B 8B 45 FC C6 80 20 02 00 00 01 8A 45 FB 50 8A 45 FA 50 8B 45 0C 50 8B 45 08 50 8B 5D FC 8B 4D F4 8B 55 FC 8B 83 A8 02 00 00 FF 93 A4 02 00 00 8B 45 FC 8A 80 20 02 00 00 88 45 F9 80 7D F9 00 75 1D 55 E8 ?? ?? ?? ?? 59 EB 14 55 E8 ?? ?? ?? ?? 59 80 7D F9 00 75 07 55 E8 ?? ?? ?? ?? 59 80 7D F9 00 75 07 55 E8 ?? ?? ?? ?? 59 8B 45 FC C6 80 20 02 00 00 00 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1372_0 {
	meta:
		name = "_NF__312"
		size = 147
		refs = "0014 TChartAxis.CalcPosPoint 0088 TChartAxis.SetMinMax"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? DD 5D DC 9B 8B D7 8B C3 E8 ?? ?? ?? ?? DC 6D DC DD 5D F8 9B DD 43 54 DC 45 F8 DD 5D F0 9B DD 43 4C DC 45 F8 DD 5D E8 9B C6 45 E7 01 8B 45 08 8B 40 FC 66 83 B8 EE 02 00 00 00 74 1F 8D 45 E8 50 8D 45 E7 50 8B 45 08 8B 70 FC 8D 4D F0 8B D3 8B 86 F0 02 00 00 FF 96 EC 02 00 00 80 7D E7 00 74 13 FF 75 F4 FF 75 F0 FF 75 EC FF 75 E8 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1373_0 {
	meta:
		name = "_NF__313"
		size = 198
		refs = "0014 TCustomAxisPanel.SeriesCount 002b TCustomAxisPanel.GetSeries 006d TControl.SetCursor"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 C6 45 FF 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 5C 43 33 F6 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 80 78 58 00 74 3C 8B 45 F8 66 83 78 70 00 74 32 8B 45 08 8B 48 08 8B 45 08 8B 50 F8 8B 45 F8 8B 38 FF 97 C0 00 00 00 40 74 18 8B 45 08 8B 40 FC 8B 55 F8 66 8B 52 70 E8 ?? ?? ?? ?? C6 45 FF 01 EB 04 46 4B 75 A7 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 2F 43 33 F6 8B 45 08 8B 40 08 50 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 08 8B 4A F8 8B 55 08 8A 52 F7 8B 38 FF 97 DC 00 00 00 46 4B 75 D4 8A 45 FF 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1374_0 {
	meta:
		name = "TCustomChart.MouseMove"
		size = 519
		refs = "0020 TControl.MouseMove 0058 TCustomTeePanel.DrawZoomRectangle 0092 Point 00a3 TCustomAxisPanel.ChartRegionRect 00ac PtInRect 00d1 TZoomPanningRecord.Check 00e8 _NF__28D 0135 _NF__312 01e3 _NF__313 01fa TControl.SetCursor"
	strings:
		$1 = { 55 8B EC 83 C4 8C 53 56 57 89 4D F8 88 55 F7 89 45 FC 8B 45 08 50 8B 4D F8 8A 55 F7 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC F6 40 20 10 0F 85 CD 01 00 00 8B 45 FC 8B 98 A4 01 00 00 80 7B 04 00 74 35 8B 45 F8 3B 43 10 75 0C 8B 45 08 3B 43 14 0F 84 AA 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 89 43 10 8B 45 08 89 43 14 8B 45 FC E8 ?? ?? ?? ?? E9 89 01 00 00 8B 45 FC 8B B0 A8 01 00 00 80 7E 04 00 0F 84 59 01 00 00 8D 4D EC 8B 55 08 8B 45 F8 E8 ?? ?? ?? ?? FF 75 F0 FF 75 EC 8D 55 DC 8B 45 FC E8 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 85 C0 0F 84 1A 01 00 00 8B 45 F8 3B 46 10 75 0C 8B 45 08 3B 46 14 0F 84 32 01 00 00 33 DB 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 80 B8 A0 02 00 00 00 74 2A 8D 55 8C 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 56 8D 75 8C 8D B8 50 02 00 00 B9 14 00 00 00 F3 A5 5E 8B 45 FC C6 80 A0 02 00 00 00 8B 55 F8 3B 56 10 74 3F 8B 45 FC 8A 80 2A 02 00 00 3C 01 74 04 3C 03 75 2E 55 8B 45 FC 8B 80 BC 01 00 00 8B 4D F8 8B 56 10 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 B8 01 00 00 8B 4D F8 8B 56 10 E8 ?? ?? ?? ?? 59 B3 01 8B 55 08 3B 56 14 74 3F 8B 45 FC 8A 80 2A 02 00 00 3C 02 74 04 3C 03 75 2E 55 8B 45 FC 8B 80 C0 01 00 00 8B 4D 08 8B 56 14 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 C4 01 00 00 8B 4D 08 8B 56 14 E8 ?? ?? ?? ?? 59 B3 01 8B 45 F8 89 46 10 8B 45 08 89 46 14 84 DB 74 55 8B 45 FC 66 83 B8 DE 02 00 00 00 74 12 8B 5D FC 8B 55 FC 8B 83 E0 02 00 00 FF 93 DC 02 00 00 8B 45 FC 8B 10 FF 52 44 EB 2C 8B 45 FC 8B 80 A8 01 00 00 C6 40 04 00 EB 1D 55 E8 ?? ?? ?? ?? 59 84 C0 75 12 8B 45 FC 66 8B 90 A2 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1375_0 {
	meta:
		name = "TCustomChart.UndoZoom"
		size = 72
		refs = "0015 _NF__28F"
	strings:
		$1 = { 53 8B D8 80 BB A0 02 00 00 00 75 0D 8D 93 50 02 00 00 8B C3 E8 ?? ?? ?? ?? C6 83 A0 02 00 00 01 66 83 BB D6 02 00 00 00 74 0E 8B D3 8B 83 D8 02 00 00 FF 93 D4 02 00 00 8B C3 8B 10 FF 52 44 C6 83 4C 02 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1376_0 {
	meta:
		name = "TCustomChart.MouseUp"
		size = 253
		refs = "0022 TControl.MouseUp 0029 TCustomAxisPanel.SeriesCount 004a TCustomAxisPanel.GetSeries 007d TCustomTeePanel.DrawZoomRectangle 008d TPen.SetMode"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 88 4D FE 88 55 FF 8B D8 8B 45 0C 50 8B 45 08 50 8A 4D FE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 2E 46 C7 45 F8 00 00 00 00 8B 45 0C 50 8B 45 08 50 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8A 4D FE 8A 55 FF 8B 38 FF 97 E4 00 00 00 FF 45 F8 4E 75 DA 8B 83 A4 01 00 00 80 78 04 00 74 7C 80 7D FF 00 75 76 8B F0 C6 46 04 00 8B C3 E8 ?? ?? ?? ?? 8B 83 50 01 00 00 8B 40 10 B2 04 E8 ?? ?? ?? ?? 8B 45 0C 89 46 10 8B 45 08 89 46 14 8B 46 10 2B 46 08 99 33 C2 2B C2 83 F8 10 7E 3D 8B 46 14 2B 46 0C 99 33 C2 2B C2 83 F8 10 7E 2D 8B 46 10 3B 46 08 7E 14 8B 46 14 3B 46 0C 7E 0C 8B C3 8B 10 FF 92 9C 00 00 00 EB 0A 8B C3 8B 10 FF 92 E0 00 00 00 8B C3 8B 10 FF 52 44 8B 83 A8 01 00 00 C6 40 04 00 5F 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1377_0 {
	meta:
		name = "TCustomChart.Paint"
		size = 58
		refs = "0012 TCustomTeePanel.ReDrawChartBitmap"
	strings:
		$1 = { 53 83 C4 F0 8B D8 80 BB A0 01 00 00 00 75 26 8B C3 E8 ?? ?? ?? ?? 84 C0 75 1B 8B D4 8B C3 8B 08 FF 51 2C 8B CC 8B 93 48 01 00 00 8B C3 8B 18 FF 93 C4 00 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1379_0 {
	meta:
		name = "TCustomChart.WMGetDlgCode"
		size = 16
	strings:
		$1 = { 56 8B F2 8B D6 8B 08 FF 51 F0 83 4E 0C 01 5E C3 }
	condition:
		$1
}

rule function_1380_0 {
	meta:
		name = "TCustomChart.CMMouseLeave"
		size = 32
		refs = "0010 TControl.SetCursor 0019 TControl.CMMouseLeave"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 8B 93 A2 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1381_0 {
	meta:
		name = "_NF__32B"
		size = 101
		refs = "0014 TCustomAxisPanel.IsAxisVisible 0032 TChartAxis.CalcRect 0046 IntersectRect"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 84 C0 74 42 8B 45 08 8D 70 EC 8D 7D F0 B9 04 00 00 00 F3 A5 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 08 83 C0 EC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 85 C0 74 10 8B 45 08 8D 78 EC 8D 75 F0 B9 04 00 00 00 F3 A5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1382_0 {
	meta:
		name = "TCustomChart.CalcAxisRect"
		size = 223
		refs = "0018 TChartAxis.AdjustMaxMin 0046 TCustomAxisPanel.CalcSize3DWalls 006d TCustomTeePanel.ReCalcWidthHeight 008d _NF__32B"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 45 FC 8D 5D FC 8B 03 8B 80 C0 01 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 C4 01 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 B8 01 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 BC 01 00 00 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 03 8B 80 5C 01 00 00 8B 13 29 82 88 01 00 00 8B 03 8B 80 60 01 00 00 8B 13 01 82 84 01 00 00 8B 03 E8 ?? ?? ?? ?? 8B 03 8D B0 80 01 00 00 8D 7D EC B9 04 00 00 00 F3 A5 55 8B 03 8B 80 C0 01 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 C4 01 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 B8 01 00 00 E8 ?? ?? ?? ?? 59 55 8B 03 8B 80 BC 01 00 00 E8 ?? ?? ?? ?? 59 8B 03 8D B8 80 01 00 00 8D 75 EC B9 04 00 00 00 F3 A5 8B 03 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1383_0 {
	meta:
		name = "_NF__32E"
		size = 251
		refs = "0018 Rect 0046 TCustomAxisPanel.GetSeries 0065 TChartSeries.GetHorizAxis 0085 MaxLong 00ab TChartSeries.GetVertAxis 00f1 TChartAxis.AdjustMaxMinRect"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 89 45 FC 6A 00 8D 45 E0 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 80 AC 01 00 00 8B 70 08 4E 85 F6 0F 8C B6 00 00 00 46 C7 45 F0 00 00 00 00 8B 45 08 8B 40 FC 8B 55 F0 E8 ?? ?? ?? ?? 8B D8 80 7B 58 00 0F 84 8A 00 00 00 8B 45 FC 80 B8 8F 00 00 00 00 74 3A 8B C3 E8 ?? ?? ?? ?? 3B 45 FC 75 2E 8D 4D F4 8D 55 F8 8B C3 8B 18 FF 93 F8 00 00 00 8B 55 F8 8B 45 E0 E8 ?? ?? ?? ?? 89 45 E0 8B 55 F4 8B 45 E8 E8 ?? ?? ?? ?? 89 45 E8 EB 44 8B 45 FC 80 B8 8F 00 00 00 00 75 38 8B C3 E8 ?? ?? ?? ?? 3B 45 FC 75 2C 8D 4D F4 8D 55 F8 8B C3 8B 18 FF 93 FC 00 00 00 8B 55 F8 8B 45 E4 E8 ?? ?? ?? ?? 89 45 E4 8B 55 F4 8B 45 EC E8 ?? ?? ?? ?? 89 45 EC FF 45 F0 4E 0F 85 52 FF FF FF 8D 55 E0 8B 45 FC E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1384_0 {
	meta:
		name = "TCustomChart.CalcSeriesRect"
		size = 74
		refs = "0012 _NF__32E"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 55 8B 45 FC 8B 80 B8 01 00 00 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 C0 01 00 00 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 C4 01 00 00 E8 ?? ?? ?? ?? 59 55 8B 45 FC 8B 80 BC 01 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_1385_0 {
	meta:
		name = "TCustomChart.Assign"
		size = 178
		refs = "000b _DV_TCustomChart 0010 @IsClass 0072 TCustomChart.SetAnimatedZoom 007f TCustomChart.SetAnimatedZoomSteps 00aa TCustomAxisPanel.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 89 00 00 00 8B FE 8B 97 38 02 00 00 8B 83 38 02 00 00 8B 08 FF 51 08 8B 97 3C 02 00 00 8B 83 3C 02 00 00 8B 08 FF 51 08 8B 97 34 02 00 00 8B 83 34 02 00 00 8B 08 FF 51 08 8A 87 2A 02 00 00 88 83 2A 02 00 00 8A 87 29 02 00 00 88 83 29 02 00 00 8A 97 28 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B 97 24 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B 97 48 02 00 00 8B 83 48 02 00 00 8B 08 FF 51 08 8B 97 44 02 00 00 8B 83 44 02 00 00 8B 08 FF 51 08 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1386_0 {
	meta:
		name = "TCustomChart.CopyToClipboardBitmap"
		size = 149
		refs = "000c _Dn_TBitmap 0011 TBitmap.Create 001c TCustomChart.CopyToClipboardBitmap 0053 TBitmap.GetCanvas 0067 Clipboard 0084 TObject.Free 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 8B 08 FF 91 94 00 00 00 8B 55 F4 2B 55 EC 8B 45 FC 8B 08 FF 51 40 8B 55 F8 2B 55 F0 8B 45 FC 8B 08 FF 51 34 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8D 4D EC 8B C3 8B 18 FF 93 C4 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1387_0 {
	meta:
		name = "TCustomChart.TeeCreateMetafile"
		size = 174
		refs = "0012 _Dn_TMetafile 0017 TMetafile.Create 002a MaxLong 0061 _Dn_TMetafileCanvas 0066 TMetafileCanvas.Create 0071 TCustomChart.TeeCreateMetafile 0083 TCustomChart.DrawToMetaCanvas 0098 TObject.Free 009e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F9 8B DA 8B F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 8B 57 08 2B 17 4A B8 01 00 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 08 FF 51 40 8B 57 0C 2B 57 04 4A B8 01 00 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 08 FF 51 34 8B 45 FC 88 58 1C 6A 00 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CF 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1388_0 {
	meta:
		name = "TCustomChart.CopyToClipboardMetafile"
		size = 102
		refs = "0021 TCustomChart.TeeCreateMetafile 002c TCustomChart.CopyToClipboardMetafile 0037 Clipboard 0054 TObject.Free 005a @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 8B DA 8B F0 8D 55 EC 8B C6 8B 08 FF 91 94 00 00 00 8D 4D EC 8B D3 8B C6 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 8B 55 FC 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1389_0 {
	meta:
		name = "TCustomChart.IsScreenHighColor"
		size = 30
		refs = "000c TCanvas.GetHandle 0012 GetDeviceCaps"
	strings:
		$1 = { 53 8B D8 6A 0C 8B 83 50 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 F8 10 0F 9D C0 5B C3 }
	condition:
		$1
}

rule function_1390_0 {
	meta:
		name = "TCustomChart.ExchangeSeries"
		size = 99
		refs = "0015 TList.Exchange 001e TCustomAxisPanel.GetSeries 0023 TComponent.GetComponentIndex 0043 TComponent.SetComponentIndex"
	strings:
		$1 = { 53 56 57 55 8B F9 8B F2 8B D8 8B CF 8B D6 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 8B D7 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D6 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 48 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1391_0 {
	meta:
		name = "TCustomChart.GetPalette"
		size = 57
		refs = "001c _Dn_TBitmap 0021 @IsClass"
	strings:
		$1 = { 53 56 57 8B D8 33 FF 8B B3 30 02 00 00 85 F6 74 22 83 7E 04 00 74 1C 8B 46 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0A 8B 46 04 8B 10 FF 52 24 8B F8 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1393_0 {
	meta:
		name = "TCustomChart.FillValueSourceItems"
		size = 100
		refs = "000c TChartSeries.GetDataSource 001d _Dn_TChartSeries 0022 @IsClass 0038 TChartSeries.ValuesListCount 004c TChartSeries.GetValueList"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 5A 04 8B C3 E8 ?? ?? ?? ?? 85 C0 74 49 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 33 8B C3 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1A 43 33 F6 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 50 20 8B 45 0C FF 55 08 46 4B 75 E9 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1394_0 {
	meta:
		name = "TChartLegend.Create"
		size = 101
		refs = "000e @ClassCreate 001c TCustomChartLegend.Create 002f _Dn_TChartHiddenPen 0034 TChartHiddenPen.Create"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 89 43 40 C7 43 44 03 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 48 8B 43 04 89 46 08 8B 00 8B 80 88 00 00 00 89 46 04 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1395_0 {
	meta:
		name = "TChartLegend.Destroy"
		size = 42
		refs = "000a TObject.Free 0016 TCustomChartLegend.Destroy 0021 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 48 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1396_0 {
	meta:
		name = "TChartLegend.SetShadowColor"
		size = 14
		refs = "0009 TCustomTeePanel.SetColorProperty"
	strings:
		$1 = { 8D 48 40 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15218_0 {
	meta:
		name = "TChartAxis.SetMinorTickLength"
		size = 14
		refs = "0009 TCustomTeePanel.SetIntegerProperty"
	strings:
		$1 = { 8D 48 40 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1397_0 {
	meta:
		name = "TChartAxis.SetMinorTickCount"
		size = 14
		refs = "0009 TCustomTeePanel.SetIntegerProperty"
		altNames = "TChartLegend.SetShadowSize"
	strings:
		$1 = { 8D 48 44 8B 40 04 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1398_0 {
	meta:
		name = "TChartLegend.SetDividingLines"
		size = 9
	strings:
		$1 = { 8B 40 48 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_1399_0 {
	meta:
		name = "_NF__35D"
		size = 99
		refs = "0024 TPen.GetWidth 004a TChartLegend.TotalLegendItems 0053 MinLong"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B DA 8B 55 08 3B 42 F8 7E 4A 8B 45 08 83 78 F4 00 7E 41 8B 45 08 8B 40 FC 8B 40 24 E8 ?? ?? ?? ?? 03 C0 50 8B C3 5A 2B C2 8B 55 08 2B 42 F8 03 C6 8B 55 08 8B 4A F4 99 F7 F9 8B D8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 8B C3 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1400_0 {
	meta:
		name = "TChartLegend.MaxLegendValues"
		size = 92
		refs = "0038 _NF__35D"
	strings:
		$1 = { 55 8B EC 83 C4 F4 89 4D F4 89 55 F8 89 45 FC 8B 45 FC 8B 40 04 8B 55 FC 8A 52 2D 84 D2 74 05 80 FA 01 75 1B 55 8B 88 84 01 00 00 8B 90 94 01 00 00 8B 80 8C 01 00 00 E8 ?? ?? ?? ?? 59 EB 19 55 8B 88 80 01 00 00 8B 90 90 01 00 00 8B 80 88 01 00 00 E8 ?? ?? ?? ?? 59 8B E5 5D C3 }
	condition:
		$1
}

rule function_1401_0 {
	meta:
		name = "TChartLegend.TotalLegendItems"
		size = 119
		refs = "0017 TCustomAxisPanel.SeriesCount 002b TCustomAxisPanel.GetSeries 0049 TCustomAxisPanel.GetASeries 005c TChartSeries.Count 006a MaxLong"
	strings:
		$1 = { 53 56 57 55 8B D8 33 FF 8A 43 2F 3C 01 74 04 3C 03 75 32 8B 43 04 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 1E 46 33 ED 8B D5 8B 43 04 E8 ?? ?? ?? ?? 80 78 58 00 74 07 80 78 72 00 74 01 47 45 4E 75 E5 2B 7B 28 EB 20 8B 43 04 E8 ?? ?? ?? ?? 8B F0 85 F6 74 12 80 7E 72 00 74 0C 8B C6 E8 ?? ?? ?? ?? 8B F8 2B 7B 28 8B D7 33 C0 E8 ?? ?? ?? ?? 8B F8 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1402_0 {
	meta:
		name = "TChartLegend.MaxLegendWidth"
		size = 161
		refs = "0016 TChartLegend.MaxLegendWidth 002b TChartLegend.TotalLegendItems 0059 TCustomAxisPanel.FormattedLegend 0070 MaxLong 008d @LStrClr 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F0 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 83 7D FC FF 75 0D 8B C3 E8 ?? ?? ?? ?? 03 43 28 48 EB 07 8B 43 28 03 45 FC 48 8B 53 04 89 55 F4 8B 53 28 8B D8 2B DA 7C 31 43 89 55 F8 8D 4D F0 8B 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 F4 8B 08 FF 91 90 00 00 00 8B D0 8B C6 E8 ?? ?? ?? ?? 8B F0 FF 45 F8 4B 75 D3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1403_0 {
	meta:
		name = "TChartLegend.GetColorRect"
		size = 48
	strings:
		$1 = { 55 8B EC 51 53 89 4D FC 8B 5D 08 8B CA 2B 48 4C 89 0B 03 48 4C 89 4B 08 8B 45 FC 83 C0 02 89 43 04 8B 45 0C 83 E8 02 89 43 0C 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1404_0 {
	meta:
		name = "_NF__36C"
		size = 617
		refs = "0018 _NF__36C 0029 TChartLegend.TotalLegendItems 004b TBrush.SetStyle 005c TBrush.SetColor 0107 TCustomAxisPanel.FormattedLegend 013d TChartLegend.GetColorRect 015b TCustomAxisPanel.ActiveSeriesLegend 01ab TCustomTeePanel.DoRectangle 01e8 TCanvas.GetHandle 01ee SetBkMode 021f TCustomTeePanel.DoHorizLine 0241 TCustomTeePanel.DoVertLine 0256 @LStrClr 025c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 C9 89 4D EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B 45 F8 0F 8E 0F 02 00 00 8B 45 08 8B 40 F8 8B 70 04 8B 9E 50 01 00 00 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 50 20 8B 43 14 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8A 40 2D 84 C0 74 07 8B 55 08 3C 01 75 24 8B 45 08 8B 40 F4 89 45 F4 8B 45 08 8B 40 F8 8B 40 34 40 8B 55 08 8B 52 F0 0F AF 55 F8 03 C2 89 45 F0 EB 2B 8B 45 08 8B 40 EC 8B 55 08 8B 52 F8 03 42 4C 83 C0 04 F7 6D F8 8B 55 08 03 42 F4 89 45 F4 8B 45 08 8B 40 F8 8B 40 34 40 89 45 F0 66 83 BE C6 02 00 00 00 74 27 8D 45 F4 50 8D 45 F0 50 8B 45 08 83 C0 FC 50 8B 45 08 8B 40 F8 8B 50 04 8B 4D FC 8B 86 C8 02 00 00 FF 96 C4 02 00 00 B2 01 8B 43 14 E8 ?? ?? ?? ?? 8D 4D EC 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 4D F0 8B 55 F4 8B C6 8B 38 FF 97 84 00 00 00 8B 45 08 8B 40 F0 03 45 F0 50 8D 45 DC 50 8B 55 F4 83 EA 04 8B 45 08 8B 40 F8 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8A 40 2F 3C 01 74 07 8B 55 08 3C 03 75 1A 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8D 4D DC 83 CA FF 8B 18 FF 93 EC 00 00 00 EB 40 8B 45 08 83 78 E8 00 74 16 8D 4D DC 8B 45 08 8B 40 E8 8B 55 FC 8B 18 FF 93 EC 00 00 00 EB 21 BA FF FF FF 00 8B 43 14 E8 ?? ?? ?? ?? 33 D2 8B 43 14 E8 ?? ?? ?? ?? 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 83 7D F8 00 0F 8E 8C 00 00 00 8B 45 08 8B 40 F8 8B 40 48 80 78 18 00 74 7D 8B 45 08 8B 40 F8 8B 50 48 8B 86 50 01 00 00 8B 40 10 8B 08 FF 51 08 6A 01 8B 86 50 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8A 40 2D 84 C0 74 07 8B 55 08 3C 01 75 1F 8B 45 F0 50 8B 45 08 8B 40 F8 8B 48 38 8B 45 08 8B 40 F8 8B 50 30 8B C6 E8 ?? ?? ?? ?? EB 20 8B 45 08 8B 40 F8 8B 40 3C 50 8B 45 08 8B 40 F8 8B 48 34 8B 55 DC 83 EA 04 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1405_0 {
	meta:
		name = "_NF__36D"
		size = 57
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 48 EC 8B 45 08 8B 40 F8 03 48 4C 83 C1 04 8B 45 08 8B 40 F8 BA 08 00 00 00 8B 18 FF 53 14 8B 55 08 89 42 E4 8B 45 08 C7 40 E0 01 00 00 00 5B 5D C3 }
	condition:
		$1
}

rule function_1406_0 {
	meta:
		name = "TChartLegend.Draw"
		size = 1692
		refs = "001d TCustomChartLegend.CalcLegendStyle 0043 TCustomTeePanel.TeeCharHeight 0051 TChartLegend.MaxLegendWidth 006c TChartLegend.Draw 0073 @ROUND 0084 TPen.GetWidth 00d9 _NF__36D 0301 MinLong 037c TBrush.SetStyle 038d TBrush.SetColor 03b1 TPen.GetColor 03c5 TPen.SetColor 03d7 TPen.SetStyle 03fc TCanvas.Rectangle 0484 Rect 048f TCanvas.FillRect 0513 TPen.SetWidth 051a TCustomAxisPanel.GetASeries 054c _NF__36C 0606 MulDiv 067f TCustomTeePanel.ReCalcWidthHeight"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 89 45 F8 8B 45 F8 83 78 04 00 0F 84 6A 06 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 58 04 8B 83 50 01 00 00 89 45 D0 8B 45 F8 8B 50 08 8B C3 8B 08 FF 91 80 00 00 00 8B C3 E8 ?? ?? ?? ?? 89 45 F0 83 CA FF 8B 45 F8 E8 ?? ?? ?? ?? 83 C0 04 89 45 EC 8B 45 F8 8B 40 10 F7 6D EC 89 45 CC DB 45 CC DB 2D ?? ?? ?? ?? DE C9 E8 ?? ?? ?? ?? 8B 55 F8 89 42 4C 8B 45 F8 8B 40 24 E8 ?? ?? ?? ?? 89 45 D4 8B 45 F8 8A 40 2D 2C 02 74 4E FE C8 0F 85 83 00 00 00 8B 45 F8 8B 93 8C 01 00 00 2B 50 44 8B 45 F8 89 50 3C 8B 45 F8 8B 40 24 80 78 18 00 74 0A 8B 45 D4 40 8B 55 F8 29 42 3C 8B 45 F8 8B 40 3C 83 E8 02 2B 45 F0 8B 55 F8 89 42 34 55 E8 ?? ?? ?? ?? 59 E9 A7 00 00 00 8B 45 F8 8B 93 84 01 00 00 89 50 34 8B 45 F8 8B 40 24 80 78 18 00 74 0A 8B 45 D4 40 8B 55 F8 01 42 34 8B 45 F8 8B 40 34 83 C0 02 03 45 F0 8B 55 F8 89 42 3C 55 E8 ?? ?? ?? ?? 59 EB 6A 8B B3 7C 01 00 00 8B BB 74 01 00 00 2B F7 8B 45 F8 DB 40 1C D8 0D ?? ?? ?? ?? 89 75 CC DB 45 CC DE C9 DB 2D ?? ?? ?? ?? DE C9 E8 ?? ?? ?? ?? 03 C7 8B 55 F8 89 42 34 C7 45 E4 01 00 00 00 8B 45 F8 8B 50 34 8B 4D F0 8B 45 F8 8B 30 FF 56 14 89 45 E0 8B 45 F8 8B 40 34 83 C0 02 8B 55 F0 0F AF 55 E0 03 C2 8B 55 F8 89 42 3C 33 C0 89 45 DC 8B 45 F8 8A 40 2D 2C 01 72 14 0F 84 A1 00 00 00 48 2C 02 0F 82 36 01 00 00 E9 9A 01 00 00 8B 55 E0 8B 45 F8 E8 ?? ?? ?? ?? 89 45 EC 8B 45 F8 8B 93 80 01 00 00 89 50 30 8B 45 F8 8B 40 24 80 78 18 00 74 0A 8B 45 D4 40 8B 55 F8 01 42 30 8B 45 F8 8B 40 30 83 C0 04 89 45 FC 8B 75 FC 83 C6 04 03 75 EC 83 C6 02 8B 45 F8 2B 70 30 8B 45 F8 0F AF 70 10 89 75 CC DB 45 CC DB 2D ?? ?? ?? ?? DE C9 E8 ?? ?? ?? ?? 8B F8 8B 45 F8 89 78 4C 03 7D FC 83 C7 04 89 7D F4 8B 45 F4 03 45 EC 83 C0 02 8B 55 F8 89 42 38 8B 45 E0 89 45 DC E9 07 01 00 00 8B 55 E0 8B 45 F8 E8 ?? ?? ?? ?? 89 45 EC 8B 45 F8 8B 93 88 01 00 00 89 50 38 8B 45 F8 8B 40 24 80 78 18 00 74 0A 8B 45 D4 40 8B 55 F8 29 42 38 8B 45 F8 8B 40 44 8B 55 F8 29 42 38 8B 45 F8 8B 40 38 2B 45 EC 83 E8 02 89 45 F4 8B 75 F4 83 EE 04 83 EE 04 8B 45 F8 8B 40 10 8B 55 F8 8B 52 38 2B D6 F7 EA 89 45 CC DB 45 CC DB 2D ?? ?? ?? ?? DE C9 E8 ?? ?? ?? ?? 8B F8 8B 45 F8 89 78 4C 8B 45 F4 2B C7 83 E8 04 89 45 FC 8B 45 FC 83 E8 04 8B 55 F8 89 42 30 8B 45 E0 89 45 DC EB 69 8B 45 F8 8B 40 4C 03 45 EC 83 C0 04 F7 6D E4 83 C0 08 8B 55 F8 8B 52 44 03 D2 03 D0 8B 83 90 01 00 00 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B 93 98 01 00 00 2B D0 8B 4D F8 89 51 30 03 83 98 01 00 00 8B 55 F8 89 42 38 8B 45 F8 8B 40 30 83 C0 04 89 45 FC 8B 45 F8 8B 40 4C 03 45 FC 83 C0 04 89 45 F4 8B 45 E4 89 45 DC 66 83 BB CE 02 00 00 00 74 18 8B 45 F8 8D 48 30 8B 45 F8 8B 50 04 8B 83 D0 02 00 00 FF 93 CC 02 00 00 83 7D DC 00 0F 8E 10 03 00 00 8B 45 D0 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B 45 F8 8B 50 20 8B 45 D0 8B 40 14 E8 ?? ?? ?? ?? 8B 45 F8 8B 40 24 80 78 18 00 74 31 8B D0 8B 45 D0 8B 40 10 8B 08 FF 51 08 8B 45 D0 8B 40 10 E8 ?? ?? ?? ?? 3D 00 00 00 80 75 0D 8B 45 D0 8B 40 10 33 D2 E8 ?? ?? ?? ?? 8B 75 D4 EB 0F 8B 45 D0 8B 40 10 B2 05 E8 ?? ?? ?? ?? 33 F6 8B 45 F8 83 C0 30 8B 50 08 03 D6 52 8B 50 0C 03 D6 52 8B 48 04 2B CE 8B 10 2B D6 8B 45 D0 E8 ?? ?? ?? ?? 8B 45 F8 83 78 44 00 0F 8E C5 00 00 00 8B 45 D0 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B 45 F8 8B 50 40 8B 45 D0 8B 40 14 E8 ?? ?? ?? ?? 85 F6 75 05 83 CE FF EB 21 F7 C6 01 00 00 00 74 0D 8B C6 D1 F8 79 03 83 D0 00 03 F0 EB 0C 8B C6 D1 F8 79 03 83 D0 00 03 F0 4E 8B 45 F8 8D 78 30 8B 47 0C 03 C6 8B 55 F8 03 42 44 50 8D 45 BC 50 8B 4F 08 03 CE 8B 45 F8 03 48 44 8B 07 8B 55 F8 03 42 44 8B 57 0C 03 D6 E8 ?? ?? ?? ?? 8D 55 BC 8B 45 D0 E8 ?? ?? ?? ?? 8B 45 F8 8D 78 30 8B 47 0C 03 C6 8B 55 F8 03 42 44 50 8D 45 BC 50 8B 4F 08 03 CE 8B 45 F8 03 48 44 8B 57 04 8B 45 F8 03 50 44 8B 47 08 03 C6 E8 ?? ?? ?? ?? 8D 55 BC 8B 45 D0 E8 ?? ?? ?? ?? 8B 45 F8 83 78 20 00 75 12 8B 45 D0 8B 40 10 BA FF FF FF 00 E8 ?? ?? ?? ?? EB 0D 8B 45 D0 8B 40 10 33 D2 E8 ?? ?? ?? ?? 8B 45 D0 8B 40 10 33 D2 E8 ?? ?? ?? ?? 8B 45 D0 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 89 45 E8 8B 45 F8 8B 40 28 8B D0 03 55 DC 4A 89 55 D8 8B 55 F8 80 7A 2E 00 74 1E 8B 75 D8 8B F8 2B FE 7F 34 4F 55 8B 55 D8 2B D6 8B C6 E8 ?? ?? ?? ?? 59 4E 47 75 EE EB 1F 8B F0 8B 7D D8 2B FE 7C 16 47 55 8B 45 F8 8B D6 2B 50 28 8B C6 E8 ?? ?? ?? ?? 59 46 4F 75 EB 8B 45 F8 80 78 0C 00 74 52 8B 45 F8 8A 40 2D 2C 01 72 0C 74 18 FE C8 74 22 FE C8 74 32 EB 3C 8B 45 F8 8B 40 38 89 83 80 01 00 00 EB 2E 8B 45 F8 8B 40 30 89 83 88 01 00 00 EB 20 8B 45 F8 8B 40 3C 8B 55 F8 03 42 44 89 83 84 01 00 00 EB 0C 8B 45 F8 8B 40 34 89 83 8C 01 00 00 8D B3 80 01 00 00 8B 45 F8 8A 40 2D 2C 01 72 0F 74 2F FE C8 74 4F FE C8 74 6F E9 8C 00 00 00 8B 45 F8 8B 40 14 85 C0 75 14 6A 64 8B 83 90 01 00 00 50 6A 03 E8 ?? ?? ?? ?? 01 06 EB 6E 01 06 EB 6A 8B 45 F8 8B 40 14 85 C0 75 15 6A 64 8B 83 90 01 00 00 50 6A 03 E8 ?? ?? ?? ?? 29 46 08 EB 4B 29 46 08 EB 46 8B 45 F8 8B 40 18 85 C0 75 15 6A 64 8B 83 94 01 00 00 50 6A 03 E8 ?? ?? ?? ?? 01 46 04 EB 27 01 46 04 EB 22 8B 45 F8 8B 40 18 85 C0 75 15 6A 64 8B 83 94 01 00 00 50 6A 03 E8 ?? ?? ?? ?? 29 46 0C EB 03 29 46 0C 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 00 00 0A D7 A3 70 3D 0A D7 A3 F8 3F 00 00 00 00 80 3F }
	condition:
		$1
}

rule function_1407_0 {
	meta:
		name = "TChartLegend.FormattedValue"
		size = 492
		refs = "001c TChartLegend.FormattedValue 00a4 FormatFloat 0103 @LStrCatN 0167 TChartSeries.GetHorizAxis 01a9 TChartAxis.LabelValue 01c3 @LStrArrayClr 01c9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E8 89 5D E4 8B D9 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 FB FF 0F 84 7E 01 00 00 8B 4D 08 8B D3 8B 45 FC 8B 38 FF 57 44 80 7E 0E 00 0F 84 67 01 00 00 8B D3 8B 45 FC 8B 08 FF 91 C8 00 00 00 DD 5D F4 9B 8B 45 FC 8B 10 FF 92 D0 00 00 00 8B D0 DD 42 30 D8 1D ?? ?? ?? ?? DF E0 9E 75 0E 33 C0 89 45 EC C7 45 F0 00 00 59 40 EB 10 D9 05 ?? ?? ?? ?? DC 4D F4 DC 72 30 DD 5D EC 9B DD 45 F4 83 C4 F4 DB 3C 24 9B 8D 55 E8 8B 45 FC 8B 40 50 E8 ?? ?? ?? ?? DD 45 EC 83 C4 F4 DB 3C 24 9B 8D 55 E4 8B 45 FC 8B 40 54 E8 ?? ?? ?? ?? 33 C0 8A 46 0E 83 F8 05 0F 87 DF 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 75 E8 68 ?? ?? ?? ?? 8B 45 08 FF 30 8B 45 08 BA 03 00 00 00 E8 ?? ?? ?? ?? E9 A1 00 00 00 8B 45 08 FF 30 68 ?? ?? ?? ?? FF 75 E8 8B 45 08 BA 03 00 00 00 E8 ?? ?? ?? ?? E9 82 00 00 00 FF 75 E4 68 ?? ?? ?? ?? 8B 45 08 FF 30 8B 45 08 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 66 8B 45 08 FF 30 68 ?? ?? ?? ?? FF 75 E4 8B 45 08 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 4A 8B 45 FC E8 ?? ?? ?? ?? 8B F0 85 F6 75 21 8B D3 8B 45 FC 8B 08 FF 51 3C 83 C4 F4 DB 3C 24 9B 8B 55 08 8B 45 FC 8B 40 50 E8 ?? ?? ?? ?? EB 1B 8B D3 8B 45 FC 8B 08 FF 51 3C 83 C4 F8 DD 1C 24 9B 8B 55 08 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C2 04 00 00 00 00 00 00 00 C8 42 FF FF FF FF 01 00 00 00 20 00 00 00 }
	condition:
		$1
}

rule function_1408_0 {
	meta:
		name = "TeeGetUniqueName"
		size = 220
		refs = "001c TeeGetUniqueName 002a @LStrClr 0032 _Dn_TCustomForm 0037 @IsClass 006e IntToStr 007c @LStrCat3 00a1 TComponent.FindComponent 00b0 @LStrLAsg 00ca @LStrArrayClr 00d0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 DB 89 5D F0 89 5D F4 89 4D F8 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B DE 83 BB 54 01 00 00 00 74 11 8B 4D F8 8B 83 54 01 00 00 8B 55 FC 8B 18 FF 53 3C 8B 45 F8 83 38 00 75 51 BB 01 00 00 00 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 4D F0 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? EB 19 43 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 4D F0 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 55 F4 8B C6 E8 ?? ?? ?? ?? 85 C0 75 D9 8B 45 F8 8B 55 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1409_0 {
	meta:
		name = "_NF__377"
		size = 40
		refs = "0009 _NF__377 0010 TeeGetUniqueName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 00 FF FF FF FF 06 00 00 00 53 65 72 69 65 73 00 00 }
	condition:
		$1
}

rule function_1410_0 {
	meta:
		name = "_NF__378"
		size = 176
		refs = "0012 _NF__378 0027 IntToStr 0037 @LStrCat3 005e TComponent.FindComponent 006c @LStrLAsg 0086 @LStrArrayClr 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 01 00 00 00 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 4D F8 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1B 43 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 4D F8 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 85 C0 75 D7 8B C7 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 59 59 5D C3 00 00 00 FF FF FF FF 0B 00 00 00 54 65 65 46 75 6E 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_1411_0 {
	meta:
		name = "AssignSeries"
		size = 514
		refs = "0016 AssignSeries 010c @LStrLAsg 0117 TList.Get 0129 TList.IndexOf 0135 TList.Add 014a TList.Remove 0154 TChartSeries.AddLinkedSeries 015e TChartSeries.RemoveLinkedSeries 0195 TList.Exchange 019c TObject.Free 01b1 TChartSeries.GetDataSource 01da TChartSeries.RefreshSeries 01ef @LStrClr 01f5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 13 8B 06 8B 08 FF 51 08 8B 06 8B 13 8B 8A A4 00 00 00 89 88 A4 00 00 00 8B 8A A8 00 00 00 89 88 A8 00 00 00 8B 06 8B 13 8B 8A 9C 00 00 00 89 88 9C 00 00 00 8B 8A A0 00 00 00 89 88 A0 00 00 00 8B 06 8B 13 8B 8A 84 00 00 00 89 88 84 00 00 00 8B 8A 88 00 00 00 89 88 88 00 00 00 8B 06 8B 13 8B 4A 7C 89 48 7C 8B 8A 80 00 00 00 89 88 80 00 00 00 8B 06 8B 13 8B 8A 8C 00 00 00 89 88 8C 00 00 00 8B 8A 90 00 00 00 89 88 90 00 00 00 8B 06 8B 13 8B 8A AC 00 00 00 89 88 AC 00 00 00 8B 8A B0 00 00 00 89 88 B0 00 00 00 8B 06 8B 13 8B 8A B4 00 00 00 89 88 B4 00 00 00 8B 8A B8 00 00 00 89 88 B8 00 00 00 8B 06 8B 13 8B 8A 94 00 00 00 89 88 94 00 00 00 8B 8A 98 00 00 00 89 88 98 00 00 00 8D 45 FC 8B 13 8B 52 08 E8 ?? ?? ?? ?? EB 50 8B C7 33 D2 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 8B 78 60 8B 16 8B C7 E8 ?? ?? ?? ?? 40 75 09 8B 16 8B C7 E8 ?? ?? ?? ?? 8B 13 8B C7 E8 ?? ?? ?? ?? 40 74 09 8B 13 8B C7 E8 ?? ?? ?? ?? 8B 06 8B 55 F4 E8 ?? ?? ?? ?? 8B 03 8B 55 F4 E8 ?? ?? ?? ?? 8B 03 8B 78 28 83 7F 08 00 7F A5 8B 03 8B 40 40 8B B8 AC 01 00 00 8B 13 8B C7 E8 ?? ?? ?? ?? 89 45 F8 8B 16 8B C7 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 33 C0 89 03 8B 06 8B 55 FC 8B 08 FF 51 18 8B 06 E8 ?? ?? ?? ?? 85 C0 75 1E 8B 06 F6 40 20 10 74 16 8B 06 8B 10 FF 92 80 00 00 00 8B D0 8B 06 8B 08 FF 91 84 00 00 00 8B 06 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1412_0 {
	meta:
		name = "CreateNewTeeFunction"
		size = 101
		refs = "000d CreateNewTeeFunction 0028 TTeeFunction.SetParentSeries 0033 _NF__378 0052 @LStrClr 0058 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4B 04 8B C2 B2 01 FF 50 24 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8D 55 FC 8B 43 04 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 8B 08 FF 51 18 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1413_0 {
	meta:
		name = "CreateNewSeries"
		size = 134
		refs = "001d CreateNewSeries 0043 _NF__377 005a CreateNewTeeFunction 006f @LStrClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 89 4D F8 89 55 FC 8B F0 8B 7D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE B2 01 8B 45 F8 FF 50 24 8B D8 8B 55 FC 8B C3 8B 08 FF 51 50 8D 55 F4 8B C6 E8 ?? ?? ?? ?? 8B 55 F4 8B C3 8B 08 FF 51 18 85 FF 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1414_0 {
	meta:
		name = "CloneChartSeries"
		size = 81
		refs = "0012 TObject.ClassType 0029 CreateNewSeries 003b TChartSeries.GetDataSource 0048 TChartSeries.AssignValues"
	strings:
		$1 = { 53 56 8B D8 8B 73 74 85 F6 75 04 33 F6 EB 09 8B C6 E8 ?? ?? ?? ?? 8B F0 56 8B C3 E8 ?? ?? ?? ?? 8B C8 8B 53 40 8B 43 04 E8 ?? ?? ?? ?? 8B F0 8B D3 8B C6 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 85 C0 75 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1415_0 {
	meta:
		name = "ChangeSeriesType"
		size = 64
		refs = "000a TObject.ClassType 0021 CreateNewSeries 0033 AssignSeries"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B 03 E8 ?? ?? ?? ?? 3B F0 74 2A 6A 00 8B 03 8B 50 40 8B 03 8B 40 04 8B CE E8 ?? ?? ?? ?? 89 04 24 83 3C 24 00 74 0E 8B D4 8B C3 E8 ?? ?? ?? ?? 8B 04 24 89 03 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1416_0 {
	meta:
		name = "ChangeAllSeriesType"
		size = 57
		refs = "000c TCustomAxisPanel.SeriesCount 001f TCustomAxisPanel.GetSeries 002b ChangeSeriesType"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F8 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1C 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 89 04 24 8B C4 8B D5 E8 ?? ?? ?? ?? 46 4B 75 E7 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1417_0 {
	meta:
		name = "GetTeeSeriesType"
		size = 38
		refs = "000a TeeSeriesList 000f TList.Get"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 8B FE 8B F0 B9 0D 00 00 00 F3 A5 66 A5 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1418_0 {
	meta:
		name = "RegisterTeeSeriesFunction"
		size = 233
		refs = "001b RegisterClass 002f TeeSeriesList 0039 _Dn_TList 003e TObject.Create 005d GetTeeSeriesType 0078 @GetMem 0097 @LStrToString 00a7 @PStrNCpy 00dc TList.Add"
	strings:
		$1 = { 55 8B EC 81 C4 C0 FE FF FF 53 56 57 89 4D F8 89 55 FC 8B F8 85 FF 74 07 8B C7 E8 ?? ?? ?? ?? 83 7D FC 00 74 08 8B 45 FC E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 58 08 4B 85 DB 7C 1E 43 33 F6 8D 55 C0 8B C6 E8 ?? ?? ?? ?? 3B 7D C0 75 08 8B 45 C4 3B 45 FC 74 72 46 4B 75 E5 B8 36 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B DE 89 3B 8B 45 FC 89 43 04 8D 85 C0 FE FF FF 8B 55 F8 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 C0 FE FF FF 8D 43 08 B1 14 E8 ?? ?? ?? ?? 8D 85 C0 FE FF FF 8B 55 0C B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 C0 FE FF FF 8D 43 1D B1 14 E8 ?? ?? ?? ?? 8B 45 08 89 43 32 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1419_0 {
	meta:
		name = "RegisterTeeSeries"
		size = 21
		refs = "000d RegisterTeeSeriesFunction"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 51 33 C9 87 CA E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_1420_0 {
	meta:
		name = "RegisterTeeFunction"
		size = 22
		refs = "000e RegisterTeeSeriesFunction"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 51 33 C9 91 87 CA E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_1421_0 {
	meta:
		name = "RegisterTeeBasicFunction"
		size = 86
		refs = "000f RegisterTeeBasicFunction 001f TeeMsg_GalleryFunctions 0024 LoadResString 0030 RegisterTeeFunction 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 02 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1422_0 {
	meta:
		name = "GetTeeFunctionDescription"
		size = 74
		refs = "000e @LStrClr 0013 TeeSeriesList 0027 GetTeeSeriesType 0038 @LStrFromString"
	strings:
		$1 = { 53 56 57 55 83 C4 C8 8B EA 8B F8 8B C5 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 58 08 4B 85 DB 7C 23 43 33 F6 8B D4 8B C6 E8 ?? ?? ?? ?? 3B 7C 24 04 75 0D 8B C5 8D 54 24 08 E8 ?? ?? ?? ?? EB 04 46 4B 75 E0 83 C4 38 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1423_0 {
	meta:
		name = "_NF__3A3"
		size = 86
		refs = "0009 TeeSeriesList 001d TList.Get 0038 @FreeMem 0042 TList.Delete"
	strings:
		$1 = { 53 56 57 55 8B FA 8B D8 BD ?? ?? ?? ?? 83 7D 00 00 74 3E 33 F6 EB 32 8B D6 8B 45 00 E8 ?? ?? ?? ?? 84 DB 74 04 3B 38 74 09 84 DB 75 1B 3B 78 04 75 16 BA 36 00 00 00 E8 ?? ?? ?? ?? 8B D6 8B 45 00 E8 ?? ?? ?? ?? EB 01 46 8B 45 00 3B 70 08 7C C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1424_0 {
	meta:
		name = "UnRegisterTeeSeries"
		size = 29
		refs = "0010 _NF__3A3"
	strings:
		$1 = { 53 56 8B F2 85 F6 7C 12 46 8B D8 8B 13 B0 01 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_1425_0 {
	meta:
		name = "UnRegisterTeeFunctions"
		size = 29
		refs = "0010 _NF__3A3"
	strings:
		$1 = { 53 56 8B F2 85 F6 7C 12 46 8B D8 8B 13 33 C0 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_1426_0 {
	meta:
		name = "_NF__3AA"
		size = 59
		refs = "0004 TeeSeriesList 001a TList.Get 0024 @FreeMem 002f TObject.Free"
	strings:
		$1 = { 53 56 57 BF ?? ?? ?? ?? 8B 07 8B 58 08 4B 85 DB 7C 1A 43 33 F6 8B D6 8B 07 E8 ?? ?? ?? ?? BA 36 00 00 00 E8 ?? ?? ?? ?? 46 4B 75 E9 8B 07 E8 ?? ?? ?? ?? 33 C0 89 07 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1428_0 {
	meta:
		name = "Chart"
		size = 368
		refs = "000f Chart 001b _NV__21D 0029 TeeSeriesList 0031 AnimatedZoomFactor 0041 TeeZoomMouseButton 0048 TeeScrollMouseButton 0053 TeeZoomKeyShift 005d TeeScrollKeyShift 0063 PrintTeePanel 0069 _DV_TChartLegend 0071 _DV_TChartGradient 0079 _DV_TChartWall 0081 _DV_TChartTitle 0091 RegisterClasses 0099 TeeMsg_FunctionAdd 009e LoadResString 00a6 _Dn_TAddTeeFunction 00ab RegisterTeeBasicFunction 00b3 TeeMsg_FunctionSubtract 00c0 _Dn_TSubtractTeeFunction 00cd TeeMsg_FunctionMultiply 00da _Dn_TMultiplyTeeFunction 00e7 TeeMsg_FunctionDivide 00f4 _Dn_TDivideTeeFunction 0101 TeeMsg_FunctionHigh 010e _Dn_THighTeeFunction 011b TeeMsg_FunctionLow 0128 _Dn_TLowTeeFunction 0135 TeeMsg_FunctionAverage 0142 _Dn_TAverageTeeFunction 015c @LStrClr 0162 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 33 C0 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 0F 83 25 01 00 00 33 C0 A3 ?? ?? ?? ?? 33 C0 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 08 40 C6 05 ?? ?? ?? ?? 00 C6 05 ?? ?? ?? ?? 01 A0 ?? ?? ?? ?? A2 ?? ?? ?? ?? A0 ?? ?? ?? ?? A2 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 A1 ?? ?? ?? ?? 89 45 F0 A1 ?? ?? ?? ?? 89 45 F4 A1 ?? ?? ?? ?? 89 45 F8 A1 ?? ?? ?? ?? 89 45 FC 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 00 00 00 00 }
	condition:
		$1
}

rule function_1429_0 {
	meta:
		name = "_NF__C3"
		size = 131
		refs = "0007 _Dn_TBitmap 000c TBitmap.Create 0017 _NF__C3 0029 LoadBitmap 0033 TBitmap.SetHandle 004a _NV__C1 005f _NV__C2 0074 TObject.Free 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 F7 7F 00 00 6A 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 2C 85 C0 79 03 83 C0 03 C1 F8 02 A3 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 20 B9 03 00 00 00 99 F7 F9 A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1430_0 {
	meta:
		name = "_NF__C4"
		size = 14
	strings:
		$1 = { 84 D2 74 05 C6 40 08 01 C3 C6 40 08 00 C3 }
	condition:
		$1
}

rule function_1431_0 {
	meta:
		name = "_NF__C5"
		size = 8
	strings:
		$1 = { 80 78 08 01 0F 94 C0 C3 }
	condition:
		$1
}

rule function_1433_0 {
	meta:
		name = "TCheckListBox.Destroy"
		size = 45
		refs = "000d TObject.Free 0019 TCustomListBox.Destroy 0024 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 64 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1434_0 {
	meta:
		name = "TCheckListBox.CreateWnd"
		size = 42
		refs = "0006 TCustomListBox.CreateWnd 0015 TObject.Free 0024 _NF__D6"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 64 01 00 00 85 C0 74 0D E8 ?? ?? ?? ?? 33 C0 89 83 64 01 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1435_0 {
	meta:
		name = "TCheckListBox.DestroyWnd"
		size = 174
		refs = "001a _Dn_TList 001f TObject.Create 0051 TCheckListBox.GetState 0060 TList.Add 0069 _NF__FF 007d TCustomListBox.DestroyWnd 0095 TList.Get 009a TObject.Free"
	strings:
		$1 = { 53 56 57 55 8B F8 33 ED 8B 87 18 01 00 00 8B 10 FF 52 14 85 C0 7E 63 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 87 64 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 8B 87 18 01 00 00 8B 10 FF 52 14 8B F0 4E 85 F6 7C 31 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 33 D2 8A D0 8B 87 64 01 00 00 E8 ?? ?? ?? ?? 8B D3 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C5 E8 ?? ?? ?? ?? 43 4E 75 D2 8B C7 E8 ?? ?? ?? ?? 85 ED 74 24 8B 75 08 4E 85 F6 7C 15 46 33 DB 8B D3 8B C5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 43 4E 75 EE 8B C5 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1436_0 {
	meta:
		name = "TCheckListBox.CreateParams"
		size = 22
		refs = "0006 TCustomListBox.CreateParams"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? F6 43 04 30 75 04 83 4B 04 10 5B C3 }
	condition:
		$1
}

rule function_1437_0 {
	meta:
		name = "TCheckListBox.GetCheckWidth"
		size = 9
		refs = "0001 _NV__C1"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 C0 02 C3 }
	condition:
		$1
}

rule function_1438_0 {
	meta:
		name = "TCheckListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d _NF__D6"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2670_0 {
	meta:
		name = "TAnimate.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d TControl.RequestAlign"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2889_0 {
	meta:
		name = "TCoolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2840_0 {
	meta:
		name = "TCoolBar.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d _NF__F5D"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13837_0 {
	meta:
		name = "TCustomCheckBox.Click"
		size = 19
		refs = "0006 TControl.Changed 000d TControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10229_0 {
	meta:
		name = "TCustomDecisionGraph.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d _NF__127"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8145_0 {
	meta:
		name = "TCustomGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8150_0 {
	meta:
		name = "TCustomGrid.ColWidthsChanged"
		size = 19
		refs = "0006 _NF__327 000d _NF__39D"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8151_0 {
	meta:
		name = "TCustomGrid.RowHeightsChanged"
		size = 19
		refs = "0006 _NF__327 000d _NF__39D"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8140_0 {
	meta:
		name = "TCustomGrid.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d _NF__327"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13706_0 {
	meta:
		name = "TCustomLabel.CMFontChanged"
		size = 19
		refs = "0006 TControl.CMFontChanged 000d _NF__2F1"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13694_0 {
	meta:
		name = "TCustomLabel.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d _NF__2F1"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13907_0 {
	meta:
		name = "TCustomListBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d _NF__4C7"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7043_0 {
	meta:
		name = "TCustomRadioGroup.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d _NF__338"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7044_0 {
	meta:
		name = "TCustomRadioGroup.WMSize"
		size = 19
		refs = "0006 TCustomGroupBox.WMSize 000d _NF__338"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13932_0 {
	meta:
		name = "TCustomStaticText.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d _NF__578"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13934_0 {
	meta:
		name = "TCustomStaticText.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d _NF__578"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2265_0 {
	meta:
		name = "TCustomTreeView.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_4806_0 {
	meta:
		name = "TDBComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d _NF__439"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5425_0 {
	meta:
		name = "TDBLookupCombo.CMFontChanged"
		size = 19
		refs = "0006 TCustomEdit.CMFontChanged 000d _NF__203"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5013_0 {
	meta:
		name = "TDBLookupListBox.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d _NF__653"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10365_0 {
	meta:
		name = "TDecisionPivot.SetBorderStyle"
		size = 19
		refs = "0006 TCustomPanel.SetBorderStyle 000d TDecisionPivot.NewPanelSetup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10364_0 {
	meta:
		name = "TDecisionPivot.SetBorderWidth"
		size = 19
		refs = "0006 TCustomPanel.SetBorderWidth 000d TDecisionPivot.NewPanelSetup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7117_0 {
	meta:
		name = "TDirectoryListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d _NF__230"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7112_0 {
	meta:
		name = "TDirectoryListBox.DblClick"
		size = 19
		refs = "0006 TControl.DblClick 000d TDirectoryListBox.OpenCurrent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13533_0 {
	meta:
		name = "TFastLineSeries.DrawAllValues"
		size = 19
		refs = "0006 TFastLineSeries.PrepareCanvas 000d TChartSeries.DrawAllValues"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7144_0 {
	meta:
		name = "TFileListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d _NF__273"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7151_0 {
	meta:
		name = "TFilterComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TFilterComboBox.BuildList"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2131_0 {
	meta:
		name = "THeaderControl.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d _NF__80B"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9776_0 {
	meta:
		name = "TMediaPlayer.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d _NF__161"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12234_0 {
	meta:
		name = "TQRCompEd.Apply1Click"
		size = 19
		refs = "0006 _NF__A0 000d _NF__9F"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12233_0 {
	meta:
		name = "TQRCompEd.OK1Click"
		size = 19
		refs = "0006 _NF__A0 000d TCustomForm.Close"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6012_0 {
	meta:
		name = "TQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7247_0 {
	meta:
		name = "TScrollingWinControl.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d _NF__44E"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13661_0 {
	meta:
		name = "TSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d _NF__156"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5986_0 {
	meta:
		name = "TStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14900_0 {
	meta:
		name = "TTeeGalleryPanel.Resize"
		size = 19
		refs = "0006 TCustomPanel.Resize 000d TTeeGalleryPanel.ResizeCharts"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2795_0 {
	meta:
		name = "TToolBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2796_0 {
	meta:
		name = "TToolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1439_0 {
	meta:
		name = "_NF__D6"
		size = 92
		refs = "0007 TWinControl.HandleAllocated 0022 TCanvas.SetFont 0027 _NF__D6 0032 TCanvas.TextHeight 0049 TControl.Perform"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 3E 80 BB 2C 01 00 00 00 75 35 8B 53 50 8B 83 20 01 00 00 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 83 20 01 00 00 E8 ?? ?? ?? ?? 8B F0 89 B3 58 01 00 00 56 33 C9 BA A0 01 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 FF FF FF FF 02 00 00 00 57 67 00 00 }
	condition:
		$1
}

rule function_1440_0 {
	meta:
		name = "TCheckListBox.DrawItem"
		size = 263
		refs = "0048 TCheckListBox.GetCheckWidth 005a TCheckListBox.GetState 0067 _NF__DF 00ae TCheckListBox.DrawItem 00c2 TCustomListBox.DrawItem 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 8B F1 8D 7D E4 B9 04 00 00 00 F3 A5 8B F2 89 45 FC 8B 5D 08 8B 45 FC 8B 80 18 01 00 00 8B 10 FF 52 14 3B F0 7D 3C 56 8D 75 E4 8D 7D D4 B9 04 00 00 00 F3 A5 5E 8B 45 E4 89 45 DC 8B 45 FC E8 ?? ?? ?? ?? 8B 55 DC 2B D0 89 55 D4 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8D 55 D4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 B8 2C 01 00 00 00 75 79 8B 45 FC 66 83 B8 46 01 00 00 00 74 6C 8B 45 FC 8B 90 44 01 00 00 89 55 F4 8B 90 48 01 00 00 89 55 F8 8B 45 FC 33 D2 89 90 44 01 00 00 89 90 48 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 53 8D 4D E4 8B D6 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 55 F4 89 90 44 01 00 00 8B 55 F8 89 90 48 01 00 00 C3 E9 ?? ?? ?? ?? EB E3 53 8D 4D E4 8B D6 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1441_0 {
	meta:
		name = "TCheckListBox.CNDrawItem"
		size = 33
		refs = "000d TCheckListBox.GetCheckWidth 0019 TCustomListBox.CNDrawItem"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 7E 08 8B C3 E8 ?? ?? ?? ?? 01 47 1C 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1442_0 {
	meta:
		name = "_NF__DF"
		size = 162
		refs = "0038 _NV__C1 007a _NV__C2 0091 TCanvas.GetHandle 0097 DrawFrameControl"
	strings:
		$1 = { 53 56 57 83 C4 E0 8B F2 8D 3C 24 51 B9 04 00 00 00 F3 A5 59 8B F0 80 E9 01 72 09 75 0B BB 00 04 00 00 EB 09 33 DB EB 05 BB 08 04 00 00 8B 54 24 08 8B 04 24 2B D0 2B 15 ?? ?? ?? ?? D1 FA 79 03 83 D2 00 03 D0 89 54 24 10 8B 54 24 0C 8B 44 24 04 2B D0 2B 15 ?? ?? ?? ?? D1 FA 79 03 83 D2 00 03 D0 89 54 24 14 8B 44 24 10 03 05 ?? ?? ?? ?? 89 44 24 18 8B 44 24 14 03 05 ?? ?? ?? ?? 89 44 24 1C 53 6A 04 8D 44 24 18 50 8B 86 20 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1443_0 {
	meta:
		name = "TCheckListBox.SetChecked"
		size = 51
		refs = "000e TCheckListBox.GetChecked 001b _NF__FE 0022 _NF__C4 002b _NF__E8"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 3A D8 74 19 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1444_0 {
	meta:
		name = "TCheckListBox.SetState"
		size = 47
		refs = "000e TCheckListBox.GetState 001b _NF__FE 0027 _NF__E8"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 3A D8 74 15 8B D6 8B C7 E8 ?? ?? ?? ?? 88 58 08 8B D6 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1445_0 {
	meta:
		name = "_NF__E8"
		size = 85
		refs = "0010 TCustomListBox.ItemRect 0017 TCheckListBox.GetCheckWidth 0038 TWinControl.GetHandle 003e InvalidateRect 004b UpdateWindow"
	strings:
		$1 = { 53 56 83 C4 F0 8B F2 8B D8 8B CC 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 03 04 24 89 44 24 08 F6 43 40 40 0F 95 C0 34 01 F6 D8 1B C0 50 8D 44 24 04 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_1446_0 {
	meta:
		name = "TCheckListBox.GetChecked"
		size = 41
		refs = "000b _NF__101 0018 _NF__FE 001d _NF__C5"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1447_0 {
	meta:
		name = "TCheckListBox.GetState"
		size = 47
		refs = "000b _NF__101 0018 _NF__FE 0023 _NV__BF 0028 _NF__C6"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0F 8B D6 8B C3 E8 ?? ?? ?? ?? 8A 40 08 5E 5B C3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1448_0 {
	meta:
		name = "TCheckListBox.KeyPress"
		size = 39
		refs = "000b TWinControl.KeyPress 0017 TCustomListBox.GetItemIndex 0020 _NF__F8"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 80 3E 20 75 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1449_0 {
	meta:
		name = "TCheckListBox.MouseDown"
		size = 115
		refs = "0022 TControl.MouseDown 002e Point 003a TCustomListBox.ItemAtPos 004d TCustomListBox.ItemRect 0058 TCheckListBox.GetCheckWidth 0066 _NF__F8"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 88 4D FE 88 55 FF 8B D8 8B 75 08 8B 7D 0C 57 56 8A 4D FE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 8D 4D F4 8B D6 8B C7 E8 ?? ?? ?? ?? 8D 55 F4 B1 01 8B C3 E8 ?? ?? ?? ?? 8B F0 83 FE FF 74 25 8D 4D E4 8B D6 8B C3 E8 ?? ?? ?? ?? 2B 7D E4 57 8B C3 E8 ?? ?? ?? ?? 5A 3B D0 7D 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1450_0 {
	meta:
		name = "_NF__F8"
		size = 97
		refs = "001e TCheckListBox.GetState 004f TCheckListBox.SetState 005a @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 7C 54 8B 83 18 01 00 00 8B 10 FF 52 14 3B F0 7D 45 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D0 80 EA 01 72 08 74 17 FE CA 74 17 EB 17 80 BB 54 01 00 00 00 74 04 B0 02 EB 0A B0 01 EB 06 33 C0 EB 02 B0 01 8B C8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BB D7 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1451_0 {
	meta:
		name = "TCheckListBox.ClickCheck"
		size = 29
		altNames = "TCoolBar.Resize TCustomRichEdit.SelectionChange"
	strings:
		$1 = { 53 66 83 B8 5E 01 00 00 00 74 10 8B D8 8B D0 8B 83 60 01 00 00 FF 93 5C 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1452_0 {
	meta:
		name = "TCheckListBox.GetItemData"
		size = 40
		refs = "000e _NF__101 001b _NF__FE"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 33 FF 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 78 04 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1453_0 {
	meta:
		name = "_NF__FE"
		size = 31
		refs = "000b _NF__FF 0018 _NF__100"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 75 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1454_0 {
	meta:
		name = "_NF__FF"
		size = 153
		refs = "0015 _NF__FF 0024 TCustomListBox.GetItemData 0040 SListIndexError 0045 LoadResString 004f _Dn_EListError 0054 Exception.CreateFmt 0059 @RaiseExcept 0065 _NV__BF 006a @IsClass 0085 @LStrClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D8 83 FB FF 75 2E 89 75 F8 C6 45 FC 00 8D 45 F8 50 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 DB 74 13 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1455_0 {
	meta:
		name = "_NF__100"
		size = 38
		refs = "000a _NV__BF 000f TObject.Create 001c TCustomListBox.SetItemData"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B CE 8B D7 8B C3 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1456_0 {
	meta:
		name = "_NF__101"
		size = 23
		refs = "000b _NF__FF"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5E 5B C3 }
	condition:
		$1
}

rule function_13126_0 {
	meta:
		name = "TRegistry.ReadBool"
		size = 23
		refs = "000b TRegistry.ReadInteger"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1457_0 {
	meta:
		name = "TCheckListBox.SetItemData"
		size = 68
		refs = "000e _NF__FE 002c TList.Get 003c TList.Delete"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F0 89 7E 04 8B BB 64 01 00 00 85 FF 74 1F 83 7F 08 00 7E 19 33 D2 8B C7 E8 ?? ?? ?? ?? 88 46 08 33 D2 8B 83 64 01 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1458_0 {
	meta:
		name = "TCheckListBox.ResetContent"
		size = 68
		refs = "001f _NF__101 002c _NF__FE 0031 TObject.Free 003c TCustomListBox.ResetContent"
	strings:
		$1 = { 53 56 57 8B F8 8B 87 18 01 00 00 8B 10 FF 52 14 8B F0 4E 85 F6 7C 22 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 84 C0 74 0E 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 43 4E 75 E1 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1459_0 {
	meta:
		name = "TCheckListBox.DeleteString"
		size = 45
		refs = "000b _NF__101 0018 _NF__FE 001d TObject.Free 0026 TCustomListBox.DeleteString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1470_0 {
	meta:
		name = "_NF__1C2"
		size = 228
		refs = "0007 TStreamAdapter.Read 0011 TStreamAdapter.Write 001b TStreamAdapter.Seek 0025 TStreamAdapter.SetSize 002f TStreamAdapter.CopyTo 0039 TStreamAdapter.Commit 0043 TStreamAdapter.Revert 004d TStreamAdapter.LockRegion 0057 TStreamAdapter.UnlockRegion 0061 TStreamAdapter.Stat 006b TStreamAdapter.Clone 0075 TInterfacedObject.QueryInterface 007f TInterfacedObject._AddRef 0089 TInterfacedObject._Release 0090 _NF__1C2"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 0C 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_11055_0 {
	meta:
		name = "_NF__23B"
		size = 197
		refs = "0007 _NF__248 0011 _NF__240 001b _NF__241 0025 _NF__242 002f _NF__243 0039 _NF__244 0043 _NF__245 004d _NF__246 0057 _NF__247 0061 TInterfacedObject.QueryInterface 006b TInterfacedObject._AddRef 0075 TInterfacedObject._Release 0079 _NF__23B"
	strings:
		$1 = { CC 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? 83 44 24 04 F4 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 0C 00 00 00 }
	condition:
		$1
}

rule function_1475_0 {
	meta:
		name = "Point"
		size = 6
	strings:
		$1 = { 89 01 89 51 04 C3 }
	condition:
		$1
}

rule function_1476_0 {
	meta:
		name = "SmallPoint"
		size = 15
	strings:
		$1 = { 51 66 89 04 24 66 89 54 24 02 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_1477_0 {
	meta:
		name = "Rect"
		size = 26
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 89 03 89 53 04 89 4B 08 8B 45 0C 89 43 0C 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1478_0 {
	meta:
		name = "Bounds"
		size = 28
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 89 03 89 53 04 03 C8 89 4B 08 03 55 0C 89 53 0C 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1479_0 {
	meta:
		name = "_NF__244"
		size = 11
	strings:
		$1 = { 8B 40 D4 09 C0 74 03 8B 40 02 C3 }
	condition:
		$1
}

rule function_1480_0 {
	meta:
		name = "_NF__245"
		size = 129
		refs = "0015 _NF__245 0027 SClassNotFound 002c LoadResString 0042 Format 004c _DV_EClassNotFound 0051 Exception.Create 0056 @RaiseExcept 0070 @LStrArrayClr 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 FC 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 89 5D F0 C6 45 F4 0B 8D 55 F0 33 C9 58 E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1481_0 {
	meta:
		name = "GetClass"
		size = 96
		refs = "0007 _NV__22E 001e TList.Get 0029 TObject.ClassNameIs 0038 _NV__22F"
	strings:
		$1 = { 53 56 57 55 8B E8 A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 22 46 33 DB 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 8B D5 8B C7 E8 ?? ?? ?? ?? 84 C0 75 28 43 4E 75 E1 8B D5 A1 ?? ?? ?? ?? 8B 08 FF 51 50 8B D8 85 DB 7C 10 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 18 8B F8 EB 02 33 FF 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1482_0 {
	meta:
		name = "FindClass"
		size = 29
		refs = "0007 GetClass 0014 _NF__245"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 07 8B C6 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1483_0 {
	meta:
		name = "_NF__24A"
		size = 201
		refs = "0018 _NF__24A 0023 TObject.ClassType 0030 _NF__244 005c TObject.ClassName 006a @LStrFromString 0075 CompareText 0087 TObject.ClassParent 0093 _DV_TPersistent 009d FindClass 00b4 @LStrClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 56 57 33 C9 89 4D F0 89 55 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 E8 ?? ?? ?? ?? 89 45 F4 EB 62 8B 45 F4 E8 ?? ?? ?? ?? 8B F0 85 F6 74 49 0F BF 1E 4B 85 DB 7C 41 43 C7 45 F8 00 00 00 00 8B 45 F8 8B 44 86 02 8B 38 8D 95 F0 FE FF FF 8B C7 E8 ?? ?? ?? ?? 8D 95 F0 FE FF FF 8D 45 F0 E8 ?? ?? ?? ?? 8B 45 F0 8B 55 FC E8 ?? ?? ?? ?? 85 C0 74 26 FF 45 F8 4B 75 C7 8B 45 F4 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 3B 05 ?? ?? ?? ?? 75 93 8B 45 FC E8 ?? ?? ?? ?? 8B F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1484_0 {
	meta:
		name = "RegisterClass"
		size = 239
		refs = "0019 _NV__22E 0021 RegisterClass 0039 TObject.ClassName 0047 @LStrFromString 004f GetClass 0077 SDuplicateClass 007c LoadResString 0089 _DV_EFilerError 008e Exception.CreateFmt 0093 @RaiseExcept 009c TList.Add 00a2 _DV_TPersistent 00ab TObject.ClassParent 00b6 TList.IndexOf 00d5 @LStrClr 00e3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F0 FE FF FF 53 56 33 D2 89 95 F0 FE FF FF 89 55 FC 8B D8 BE ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E9 81 00 00 00 8D 95 FC FE FF FF 8B C3 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 40 8B 45 FC 89 85 F4 FE FF FF C6 85 F8 FE FF FF 0B 8D 85 F4 FE FF FF 50 6A 00 8D 95 F0 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 06 E8 ?? ?? ?? ?? 3B 1D ?? ?? ?? ?? 74 19 8B C3 E8 ?? ?? ?? ?? 8B D8 8B D3 8B 06 E8 ?? ?? ?? ?? 40 0F 84 6F FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F0 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1485_0 {
	meta:
		name = "RegisterClasses"
		size = 48
		refs = "001c RegisterClass"
	strings:
		$1 = { 55 8B EC 53 56 8B CA 8B 1C 88 49 53 79 F9 8B C4 8B F2 85 F6 7C 10 46 8B D8 8B 03 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F3 8B 75 F8 8B 5D FC 8B E5 5D C3 }
	condition:
		$1
}

rule function_1488_0 {
	meta:
		name = "UnRegisterClasses"
		size = 48
		refs = "001c UnRegisterClass"
	strings:
		$1 = { 55 8B EC 53 56 8B CA 8B 1C 88 49 53 79 F9 8B C4 8B F2 85 F6 7C 10 46 8B D8 8B 03 E8 ?? ?? ?? ?? 83 C3 04 4E 75 F3 8B 75 F8 8B 5D FC 8B E5 5D C3 }
	condition:
		$1
}

rule function_1486_0 {
	meta:
		name = "RegisterClassAlias"
		size = 30
		refs = "0009 RegisterClass 0012 _NV__22F"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B CB 8B D6 A1 ?? ?? ?? ?? 8B 18 FF 53 38 5E 5B C3 }
	condition:
		$1
}

rule function_1487_0 {
	meta:
		name = "UnRegisterClass"
		size = 13
		refs = "0003 _NV__22E 0008 TList.Remove"
	strings:
		$1 = { 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5381_0 {
	meta:
		name = "_NF__82"
		size = 13
		refs = "0003 _NV__81 0008 _NF__7F"
	strings:
		$1 = { 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1489_0 {
	meta:
		name = "UnRegisterModuleClasses"
		size = 146
		refs = "000c _NV__22E 0025 TList.Get 002b VirtualQuery 003e TList.Delete 0049 _NV__22F"
	strings:
		$1 = { 53 56 57 55 83 C4 E4 8B F0 8B FC BD ?? ?? ?? ?? 8B 45 00 8B 58 08 4B 83 FB 00 7C 2C 6A 1C 57 8B D3 8B 45 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 F6 74 05 3B 77 04 75 0A 8B D3 8B 45 00 E8 ?? ?? ?? ?? 4B 83 FB FF 75 D4 A1 ?? ?? ?? ?? 8B 10 FF 52 14 8B D8 4B 83 FB 00 7C 30 6A 1C 57 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 18 50 E8 ?? ?? ?? ?? 85 F6 74 05 3B 77 04 75 0C 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 44 4B 83 FB FF 75 D0 83 C4 1C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1490_0 {
	meta:
		name = "RegisterComponents"
		size = 121
		refs = "0016 RegisterComponents 0022 RegisterComponentsProc 0035 SRegisterError 003a LoadResString 0044 _DV_EComponentError 0049 Exception.Create 004e @RaiseExcept 0063 @LStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D9 8B 34 9A 4B 56 79 F9 8B D4 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 83 3D ?? ?? ?? ?? 00 74 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 75 F4 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1491_0 {
	meta:
		name = "RegisterNoIcon"
		size = 117
		refs = "0015 RegisterNoIcon 0021 RegisterNoIconProc 0034 SRegisterError 0039 LoadResString 0043 _DV_EComponentError 0048 Exception.Create 004d @RaiseExcept 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B CA 8B 1C 88 49 53 79 F9 8B C4 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 3D ?? ?? ?? ?? 00 74 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1492_0 {
	meta:
		name = "RegisterNonActiveX"
		size = 121
		refs = "0016 RegisterNonActiveX 0022 RegisterNonActiveXProc 0035 SRegisterError 003a LoadResString 0044 _DV_EComponentError 0049 Exception.Create 004e @RaiseExcept 0063 @LStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B 34 98 4B 56 79 F9 8B C4 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 83 3D ?? ?? ?? ?? 00 74 08 FF 15 ?? ?? ?? ?? EB 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 75 F4 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1493_0 {
	meta:
		name = "_NF__267"
		size = 48
		refs = "000b @ClassCreate"
	strings:
		$1 = { 55 8B EC 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 04 8B 4D 0C 89 48 08 8B 4D 08 89 48 0C 84 D2 74 0A 64 8F 05 00 00 00 00 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule function_1494_0 {
	meta:
		name = "RegisterIntegerConsts"
		size = 41
		refs = "0010 _NV__265 0015 _NF__267 001c _NV__230 0021 TList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 56 57 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1495_0 {
	meta:
		name = "IdentToInt"
		size = 64
		refs = "001c CompareText"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 55 FC 8B F8 8B 75 08 85 F6 7C 23 46 8D 59 04 8B D7 8B 03 E8 ?? ?? ?? ?? 85 C0 75 0C B0 01 8B 55 FC 8B 4B FC 89 0A EB 08 83 C3 08 4E 75 E1 33 C0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1496_0 {
	meta:
		name = "IntToIdent"
		size = 59
		refs = "0023 @LStrAsg"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B 55 08 85 D2 7C 1C 42 8B 7D FC 3B 07 75 0E B3 01 8B C6 8B 57 04 E8 ?? ?? ?? ?? EB 08 83 C7 08 4A 75 E8 33 DB 8B C3 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1497_0 {
	meta:
		name = "_NF__276"
		size = 133
		refs = "0013 HInstance 001e @LStrToPChar 0025 FindResource 003a _DV_TResourceStream 003f TResourceStream.Create 004a _NF__276 005a TStream.ReadComponent 0071 TObject.Free 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 8B DA 8B F8 85 DB 75 08 8B 1D ?? ?? ?? ?? 8B 1B 6A 0A 8B C7 E8 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 84 C0 74 4D 57 6A 0A 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 16 8B 45 FC E8 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 B0 01 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1498_0 {
	meta:
		name = "BeginGlobalLoading"
		size = 34
		refs = "0002 _NV__277 0007 _NV__278 000c TList.Add 0013 _DV_TList 0018 TObject.Create"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1499_0 {
	meta:
		name = "NotifyGlobalLoading"
		size = 42
		refs = "0003 _NV__277 001a TList.Get"
	strings:
		$1 = { 53 56 A1 ?? ?? ?? ?? 8B 58 08 4B 85 DB 7C 18 43 33 F6 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 0C 46 4B 75 EB 5E 5B C3 }
	condition:
		$1
}

rule function_1500_0 {
	meta:
		name = "EndGlobalLoading"
		size = 45
		refs = "0001 _NV__277 0006 TObject.Free 000b _NV__278 0010 TList.Last 0028 TList.Delete"
	strings:
		$1 = { A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 50 08 4A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1501_0 {
	meta:
		name = "_NF__27C"
		size = 165
		refs = "0016 _NF__27C 0024 _DV_TComponent 0039 TObject.ClassParent 004e TObject.ClassName 005c @LStrFromString 0067 FindClassHInstance 006c FindResourceHInstance 007a _NF__276 0091 @LStrClr 0097 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 D2 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 3B 35 ?? ?? ?? ?? 74 56 8B 45 08 3B 70 F8 74 4E 8B 45 08 50 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B D8 8D 95 FC FE FF FF 8B C6 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC 50 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 08 8D 48 FC 58 E8 ?? ?? ?? ?? 0A D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1502_0 {
	meta:
		name = "InitInheritedComponent"
		size = 87
		refs = "000d BeginGlobalLoading 0015 InitInheritedComponent 0024 TObject.ClassType 0029 _NF__27C 0032 NotifyGlobalLoading 0044 EndGlobalLoading 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 89 55 F8 89 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 55 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 88 45 F7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F3 8A 45 F7 8B E5 5D C3 }
	condition:
		$1
}

rule function_1503_0 {
	meta:
		name = "InitComponentRes"
		size = 39
		refs = "000b TObject.ClassType 0010 FindClassHInstance 0015 FindResourceHInstance 0020 _NF__276"
	strings:
		$1 = { 53 51 89 14 24 8B D8 8B 04 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B CC 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1504_0 {
	meta:
		name = "ReadComponentRes"
		size = 166
		refs = "0016 ReadComponentRes 002a TObject.ClassType 002f FindClassHInstance 0034 FindResourceHInstance 0046 _NF__276 0064 SResNotFound 0069 LoadResString 0073 _DV_EResNotFound 0078 Exception.CreateFmt 007d @RaiseExcept 0092 @LStrClr 0098 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F0 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D FC 00 74 16 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 8D 4D FC 8B D3 8B C6 E8 ?? ?? ?? ?? 84 C0 74 05 8B 5D FC EB 2E 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1505_0 {
	meta:
		name = "ReadComponentResEx"
		size = 140
		refs = "0015 ReadComponentResEx 002c _NF__276 004a SResNotFound 004f LoadResString 0059 _DV_EResNotFound 005e Exception.CreateFmt 0063 @RaiseExcept 0078 @LStrClr 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F0 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 FC 8D 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 05 8B 5D FC EB 2E 89 5D F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1506_0 {
	meta:
		name = "ReadComponentResFile"
		size = 92
		refs = "0010 _DV_TFileStream 0015 TFileStream.Create 0020 ReadComponentResFile 0030 TStream.ReadComponentRes 0048 TObject.Free 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 6A 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1507_0 {
	meta:
		name = "WriteComponentResFile"
		size = 170
		refs = "0015 WriteComponentResFile 0029 _DV_TFileStream 002e TFileStream.Create 004c TObject.ClassName 005a @LStrFromString 0067 TStream.WriteComponentRes 007c TObject.Free 0082 @HandleFinally 0099 @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 33 C9 89 4D F8 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 68 FF FF 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B CB 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1508_0 {
	meta:
		name = "_NF__28F"
		size = 86
		refs = "0011 _DV_TWriter 0016 TFiler.Create 0021 _NF__28F 0031 TWriter.WriteCollection 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 68 00 04 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1509_0 {
	meta:
		name = "CollectionsEqual"
		size = 273
		refs = "0014 TObject.ClassType 002c TCollection.GetCount 0044 _DV_TMemoryStream 0049 TObject.Create 0054 CollectionsEqual 0064 _NF__28F 0093 TStream.GetSize 00bc CompareMem 00de TObject.Free 00e4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B F2 8B D8 C6 45 FF 00 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 3B F8 0F 85 DE 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 3B F8 0F 85 C6 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 F4 E8 ?? ?? ?? ?? 3B D8 75 1F 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 45 F4 8B 50 04 8B 45 F8 8B 40 04 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 45 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1510_0 {
	meta:
		name = "LineStart"
		size = 30
	strings:
		$1 = { 57 89 D7 89 D1 29 C1 83 E9 01 76 10 89 C2 4F B0 0A FD F2 AE FC 89 D0 75 03 8D 47 02 5F C3 }
	condition:
		$1
}

rule function_1512_0 {
	meta:
		name = "TList.Add"
		size = 36
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B 73 08 3B 73 0C 75 06 8B C3 8B 10 FF 12 8B 43 04 89 3C B0 FF 43 08 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1513_0 {
	meta:
		name = "TList.Clear"
		size = 23
		refs = "0008 TList.SetCount 0011 TList.SetCapacity"
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1514_0 {
	meta:
		name = "TList.Delete"
		size = 126
		refs = "000f TList.Delete 0026 SListIndexError 002b LoadResString 0058 Move 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 FF 4B 08 8B 43 08 3B F0 7D 19 2B C6 8B C8 C1 E1 02 8B 43 04 8D 14 B0 8B 43 04 8D 44 B0 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1515_0 {
	meta:
		name = "_NF__2A1"
		size = 4
		altNames = "_NF__379"
	strings:
		$1 = { 8B 45 04 C3 }
	condition:
		$1
}

rule function_1516_0 {
	meta:
		name = "TList.Error"
		size = 55
		refs = "000a _NF__2A1 0024 _DV_EListError 0029 Exception.CreateFmt 002e @RaiseExcept"
	strings:
		$1 = { 53 56 83 C4 F8 8B F1 8B DA E8 ?? ?? ?? ?? 50 89 74 24 04 C6 44 24 08 00 8D 44 24 04 50 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1597_0 {
	meta:
		name = "TStrings.Error"
		size = 55
		refs = "000a _NF__379 0024 _DV_EStringListError 0029 Exception.CreateFmt 002e @RaiseExcept"
	strings:
		$1 = { 53 56 83 C4 F8 8B F1 8B DA E8 ?? ?? ?? ?? 50 89 74 24 04 C6 44 24 08 00 8D 44 24 04 50 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1517_0 {
	meta:
		name = "TList.Exchange"
		size = 158
		refs = "0018 TList.Exchange 002f SListIndexError 0034 LoadResString 008b @LStrClr 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B 03 FF 50 04 85 FF 7C 05 3B 7B 08 7C 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CF 8B 03 FF 50 04 8B 43 04 8B 14 B0 89 55 FC 8B 53 04 8B 14 BA 89 14 B0 8B 55 FC 89 14 B8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1518_0 {
	meta:
		name = "TList.Expand"
		size = 21
	strings:
		$1 = { 53 8B D8 8B 43 08 3B 43 0C 75 06 8B C3 8B 10 FF 12 8B C3 5B C3 }
	condition:
		$1
}

rule function_1520_0 {
	meta:
		name = "TList.Get"
		size = 99
		refs = "000f TList.Get 0026 SListIndexError 002b LoadResString 0050 @LStrClr 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 8B 43 04 8B 1C B0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1521_0 {
	meta:
		name = "TList.Grow"
		size = 49
		refs = "002c TList.SetCapacity"
	strings:
		$1 = { 8B 50 0C 83 FA 40 7E 0E 8B CA 85 C9 79 03 83 C1 03 C1 F9 02 EB 11 83 FA 08 7E 07 B9 10 00 00 00 EB 05 B9 04 00 00 00 03 CA 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1522_0 {
	meta:
		name = "TList.IndexOf"
		size = 31
	strings:
		$1 = { 53 33 C9 EB 01 41 3B 48 08 7D 08 8B 58 04 3B 14 8B 75 F2 3B 48 08 75 03 83 C9 FF 8B C1 5B C3 }
	condition:
		$1
}

rule function_1523_0 {
	meta:
		name = "TList.Insert"
		size = 159
		refs = "0018 TList.Insert 002f SListIndexError 0034 LoadResString 006c Move 008d @LStrClr 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7E 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B 03 FF 50 04 8B 43 08 3B 43 0C 75 06 8B C3 8B 10 FF 12 8B 43 08 3B F0 7D 19 2B C6 8B C8 C1 E1 02 8B 43 04 8D 54 B0 04 8B 43 04 8D 04 B0 E8 ?? ?? ?? ?? 8B 43 04 8B 55 FC 89 14 B0 FF 43 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1524_0 {
	meta:
		name = "TList.Last"
		size = 10
		refs = "0005 TList.Get"
	strings:
		$1 = { 8B 50 08 4A E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1525_0 {
	meta:
		name = "TList.Move"
		size = 139
		refs = "0018 TList.Move 0033 SListIndexError 0038 LoadResString 004b TList.Get 0057 TList.Delete 0063 TList.Insert 0078 @LStrClr 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F1 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B F7 74 41 85 F6 7C 05 3B 73 08 7C 17 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B 03 FF 50 04 8B D7 8B C3 E8 ?? ?? ?? ?? 89 45 FC 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1526_0 {
	meta:
		name = "TList.Put"
		size = 101
		refs = "0012 TList.Put 0029 SListIndexError 002e LoadResString 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 08 7C 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 8B 43 04 89 3C B0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1527_0 {
	meta:
		name = "TList.Remove"
		size = 32
		refs = "0007 TList.IndexOf 0017 TList.Delete"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 83 FE FF 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1528_0 {
	meta:
		name = "TList.Pack"
		size = 44
		refs = "0012 TList.Get 001f TList.Delete"
	strings:
		$1 = { 53 56 8B F0 8B 5E 08 4B 83 FB 00 7C 1C 8B D3 8B C6 E8 ?? ?? ?? ?? 85 C0 75 09 8B D3 8B C6 E8 ?? ?? ?? ?? 4B 83 FB FF 75 E4 5E 5B C3 }
	condition:
		$1
}

rule function_1529_0 {
	meta:
		name = "TList.SetCapacity"
		size = 116
		refs = "000f TList.SetCapacity 002a SListCapacityError 002f LoadResString 004b @ReallocMem 0063 @LStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 73 08 7C 08 81 FE FF FF FF 07 7E 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 3B 73 0C 74 10 8B D6 C1 E2 02 8D 43 04 E8 ?? ?? ?? ?? 89 73 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1530_0 {
	meta:
		name = "TList.SetCount"
		size = 141
		refs = "000f TList.SetCount 0029 SListCountError 002e LoadResString 0046 TList.SetCapacity 0064 @FillChar 007c @LStrClr 0082 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 08 81 FE FF FF FF 07 7E 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B 03 FF 50 04 3B 73 0C 7E 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 08 3B F0 7E 17 8B 53 04 8D 14 82 8B CE 2B C8 8B C1 C1 E0 02 33 C9 92 E8 ?? ?? ?? ?? 89 73 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1531_0 {
	meta:
		name = "_NF__2CF"
		size = 129
		refs = "006c _NF__2CF"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D F8 89 55 FC 8B F8 8B 5D FC 8B 75 F8 8B 45 FC 03 45 F8 D1 E8 8B 04 87 89 45 F4 EB 01 43 8B 55 F4 8B 04 9F FF 55 08 85 C0 7C F2 EB 01 4E 8B 55 F4 8B 04 B7 FF 55 08 85 C0 7F F2 3B F3 7C 0E 8B 04 9F 8B 14 B7 89 14 9F 89 04 B7 43 4E 3B F3 7D CD 3B 75 FC 7E 10 8B 45 08 50 8B CE 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 89 5D FC 3B 5D F8 7C 99 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1532_0 {
	meta:
		name = "TList.Sort"
		size = 30
		refs = "0019 _NF__2CF"
	strings:
		$1 = { 8B 48 04 85 C9 74 16 83 78 08 00 7E 10 52 8B 50 08 4A 8B C1 33 C9 87 D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1533_0 {
	meta:
		name = "TThreadList.Create"
		size = 70
		refs = "000a @ClassCreate 0017 TObject.Create 0020 InitializeCriticalSection 0027 _DV_TList"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 08 50 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1534_0 {
	meta:
		name = "TThreadList.Destroy"
		size = 121
		refs = "0010 TThreadList.LockList 0018 TThreadList.Destroy 0029 TObject.Free 0037 TObject.Destroy 004c TThreadList.UnlockList 0058 DeleteCriticalSection 005e @HandleFinally 006e @ClassDestroy"
	strings:
		$1 = { 55 8B EC 83 C4 F8 88 55 FB 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8A 55 FB 80 E2 FE 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 08 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 80 7D FB 00 74 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 59 59 5D C3 }
	condition:
		$1
}

rule function_9962_0 {
	meta:
		name = "TThreadCustomArray.Destroy"
		size = 121
		refs = "0010 TThreadCustomArray.LockArray 0018 TThreadCustomArray.Destroy 0029 TObject.Free 0037 TObject.Destroy 004c TThreadCustomArray.UnlockArray 0058 DeleteCriticalSection 005e @HandleFinally 006e @ClassDestroy"
	strings:
		$1 = { 55 8B EC 83 C4 F8 88 55 FB 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 8A 55 FB 80 E2 FE 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 08 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 80 7D FB 00 74 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 59 59 5D C3 }
	condition:
		$1
}

rule function_1535_0 {
	meta:
		name = "TThreadList.Add"
		size = 94
		refs = "000e TThreadList.LockList 0016 TThreadList.Add 0029 TList.IndexOf 0039 TList.Add 004e TThreadList.UnlockList 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 8B D3 E8 ?? ?? ?? ?? 40 75 0D 8B 45 FC 8B 40 04 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1536_0 {
	meta:
		name = "TThreadList.Clear"
		size = 72
		refs = "000b TThreadList.LockList 0013 TThreadList.Clear 0024 TList.Clear 0039 TThreadList.UnlockList 003f @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1537_0 {
	meta:
		name = "TThreadCustomArray.LockArray"
		size = 17
		refs = "0008 EnterCriticalSection"
		altNames = "TThreadList.LockList"
	strings:
		$1 = { 53 8B D8 8D 43 08 50 E8 ?? ?? ?? ?? 8B 43 04 5B C3 }
	condition:
		$1
}

rule function_1538_0 {
	meta:
		name = "TThreadList.Remove"
		size = 78
		refs = "000e TThreadList.LockList 0016 TThreadList.Remove 0029 TList.Remove 003e TThreadList.UnlockList 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 04 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1539_0 {
	meta:
		name = "TThreadCustomArray.UnlockArray"
		size = 10
		refs = "0005 LeaveCriticalSection"
		altNames = "TThreadList.UnlockList _NF__2A5"
	strings:
		$1 = { 83 C0 08 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7594_0 {
	meta:
		name = "_NF__2A4"
		size = 10
		refs = "0005 EnterCriticalSection"
	strings:
		$1 = { 83 C0 08 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1540_0 {
	meta:
		name = "TBits.Destroy"
		size = 43
		refs = "000b TBits.SetSize 0017 TObject.Destroy 0022 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1555_0 {
	meta:
		name = "TCollectionItem.Destroy"
		size = 43
		refs = "000b TCollectionItem.SetCollection 0017 TPersistent.Destroy 0022 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10162_0 {
	meta:
		name = "TDecisionDataLink.Destroy"
		size = 43
		refs = "000b TDecisionDataLink.SetDecisionSource 0017 TPersistent.Destroy 0022 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1585_0 {
	meta:
		name = "TStrings.Destroy"
		size = 43
		refs = "000b TStrings.SetStringsAdapter 0017 TPersistent.Destroy 0022 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1541_0 {
	meta:
		name = "_NF__2EC"
		size = 84
		refs = "0009 _NF__2EC 0017 SBitsIndexError 001c LoadResString 0026 _DV_EBitsError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_7720_0 {
	meta:
		name = "_NF__409"
		size = 84
		refs = "0009 _NF__409 0017 SOutOfResources 001c LoadResString 0026 _Dn_EOutOfResources 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8181_0 {
	meta:
		name = "_NF__42D"
		size = 84
		refs = "0009 _NF__42D 0017 SListIndexError 001c LoadResString 0026 _Dn_EListError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_8202_0 {
	meta:
		name = "_NF__442"
		size = 84
		refs = "0009 _NF__442 0017 SPutObjectError 001c LoadResString 0026 _NV__411 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_2012_0 {
	meta:
		name = "_NF__6BC"
		size = 84
		refs = "0009 _NF__6BC 0017 sTabAccessError 001c LoadResString 0026 _Dn_EListError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9413_0 {
	meta:
		name = "_NF__BE"
		size = 84
		refs = "0009 _NF__BE 0017 SIntOverflow 001c LoadResString 0026 _Dn_EIntOverflow 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9821_0 {
	meta:
		name = "_NF__CE"
		size = 84
		refs = "0009 _NF__CE 0017 sLowCapacityError 001c LoadResString 0026 _DV_ELowCapacityError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_9829_0 {
	meta:
		name = "_NF__D6"
		size = 84
		refs = "0009 _NF__D6 0017 sDupeItem 001c LoadResString 0026 _DV_EArrayError 002b Exception.Create 0030 @RaiseExcept 0045 @LStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1542_0 {
	meta:
		name = "_NF__20D"
		size = 11
		altNames = "_NF__2ED"
	strings:
		$1 = { 8B C8 3B D0 7D 02 8B CA 8B C1 C3 }
	condition:
		$1
}

rule function_1543_0 {
	meta:
		name = "TBits.SetSize"
		size = 162
		refs = "0019 _NF__2EC 0056 @GetMem 0065 @FillChar 0078 _NF__2ED 0085 Move 008f @FreeMem"
	strings:
		$1 = { 53 56 57 55 51 8B F2 8B D8 3B 73 04 0F 84 8A 00 00 00 85 F6 7D 07 8B C3 E8 ?? ?? ?? ?? 8D 46 20 48 85 C0 79 03 83 C0 1F C1 F8 05 8B F8 C1 E7 02 8B 43 04 83 C0 20 48 85 C0 79 03 83 C0 1F C1 F8 05 8B E8 C1 E5 02 3B EF 74 4F 33 C0 89 04 24 85 FF 74 16 8B C7 E8 ?? ?? ?? ?? 89 04 24 8B 04 24 33 C9 8B D7 E8 ?? ?? ?? ?? 85 ED 74 26 83 3C 24 00 74 16 8B D7 8B C5 E8 ?? ?? ?? ?? 8B C8 8B 14 24 8B 43 08 E8 ?? ?? ?? ?? 8B D5 8B 43 08 E8 ?? ?? ?? ?? 8B 04 24 89 43 08 89 73 04 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1544_0 {
	meta:
		name = "TBits.SetBit"
		size = 44
		refs = "0019 _NF__2EC 0022 TBits.SetSize"
	strings:
		$1 = { 3B 50 04 73 0F 8B 40 08 08 C9 74 04 0F AB 10 C3 0F B3 10 C3 83 FA 00 0F 8C ?? ?? ?? ?? 50 52 51 42 E8 ?? ?? ?? ?? 59 5A 58 EB DA C3 }
	condition:
		$1
}

rule function_1545_0 {
	meta:
		name = "TBits.GetBit"
		size = 21
		refs = "0005 _NF__2EC"
	strings:
		$1 = { 3B 50 04 0F 83 ?? ?? ?? ?? 8B 40 08 0F A3 10 19 C0 83 E0 01 C3 }
	condition:
		$1
}

rule function_1546_0 {
	meta:
		name = "TBits.OpenBit"
		size = 120
		refs = "0027 TBits.OpenBit"
	strings:
		$1 = { 53 56 57 51 8B D8 8B 43 04 83 C0 20 48 85 C0 79 03 83 C0 1F C1 F8 05 48 85 C0 7C 4D 40 89 04 24 33 F6 8B 43 08 8B 15 ?? ?? ?? ?? 3B 14 B0 74 33 8B 43 08 8B 3C B0 33 C0 8B D0 80 FA 1F 77 06 83 E2 7F 0F A3 D7 72 17 8B D6 C1 E2 05 83 E0 7F 03 D0 8B C2 8B 53 04 3B C2 7C 12 8B C2 EB 0E 40 3C 20 75 D5 46 FF 0C 24 75 B9 8B 43 04 5A 5F 5E 5B C3 00 00 00 FF FF FF FF }
	condition:
		$1
}

rule function_1547_0 {
	meta:
		name = "TPersistent.Destroy"
		size = 41
		refs = "0009 RemoveFixups 0015 TObject.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_3371_0 {
	meta:
		name = "TControlCanvas.Destroy"
		size = 41
		refs = "0009 TControlCanvas.FreeHandle 0015 TCanvas.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10571_0 {
	meta:
		name = "TDataCache.Destroy"
		size = 41
		refs = "0009 TDataCache.FreeCache 0015 TObject.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5150_0 {
	meta:
		name = "TGridDataLink.Destroy"
		size = 41
		refs = "0009 TGridDataLink.ClearMapping 0015 TDataLink.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6107_0 {
	meta:
		name = "THTTPDataLink.Destroy"
		size = 41
		refs = "0009 THTTPDataLink.ClearMapping 0015 TDataLink.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2548_0 {
	meta:
		name = "TListItems.Destroy"
		size = 41
		refs = "0009 TListItems.Clear 0015 TPersistent.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1676_0 {
	meta:
		name = "TMemoryStream.Destroy"
		size = 41
		refs = "0009 TMemoryStream.Clear 0015 TObject.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_11114_0 {
	meta:
		name = "TOleContainer.Destroy"
		size = 41
		refs = "0009 TOleContainer.DestroyObject 0015 TCustomControl.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13104_0 {
	meta:
		name = "TRegistry.Destroy"
		size = 41
		refs = "0009 TRegistry.CloseKey 0015 TObject.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2214_0 {
	meta:
		name = "TTreeNodes.Destroy"
		size = 41
		refs = "0009 TTreeNodes.Clear 0015 TPersistent.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1779_0 {
	meta:
		name = "TWriter.Destroy"
		size = 41
		refs = "0009 _NF__575 0015 TFiler.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6235_0 {
	meta:
		name = "_NF__18A"
		size = 41
		refs = "0009 _NF__191 0015 TPersistent.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7847_0 {
	meta:
		name = "_NF__552"
		size = 41
		refs = "0009 _NF__553 0015 TCanvas.Destroy 0020 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1548_0 {
	meta:
		name = "TPersistent.Assign"
		size = 18
		refs = "000d _NF__300"
	strings:
		$1 = { 85 D2 74 06 92 8B 08 FF 11 C3 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1549_0 {
	meta:
		name = "_NF__300"
		size = 240
		refs = "001e _NF__300 0035 TObject.ClassName 0043 @LStrFromString 0052 @LStrLAsg 0096 SAssignError 009b LoadResString 00a8 _Dn_EConvertError 00ad Exception.CreateFmt 00b2 @RaiseExcept 00ca @LStrClr 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 E8 FE FF FF 53 56 33 C9 89 8D E8 FE FF FF 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 74 1D 8D 95 FC FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? EB 0D 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 89 85 EC FE FF FF C6 85 F0 FE FF FF 0B 8D 95 FC FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 FC FE FF FF 89 85 F4 FE FF FF C6 85 F8 FE FF FF 04 8D 85 EC FE FF FF 50 6A 01 8D 95 E8 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D E8 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E8 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 FF FF FF FF 03 00 00 00 6E 69 6C 00 }
	condition:
		$1
}

rule function_1552_0 {
	meta:
		name = "TPersistent.GetNamePath"
		size = 176
		refs = "0019 TPersistent.GetNamePath 002c TObject.ClassName 0039 @LStrFromString 0044 @CallDynaInst 007b @LStrCatN 0090 @LStrClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 57 33 C9 89 4D FC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 FC FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B C7 E8 ?? ?? ?? ?? 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 85 C0 74 33 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 8D 55 FC 66 BB FE FF E8 ?? ?? ?? ?? 83 7D FC 00 74 16 FF 75 FC 68 ?? ?? ?? ?? FF 37 8B C7 BA 03 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1554_0 {
	meta:
		name = "TCollectionItem.Create"
		size = 46
		refs = "000a @ClassCreate 0017 TCollectionItem.SetCollection"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D1 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8177_0 {
	meta:
		name = "_NF__429"
		size = 46
		refs = "000a @ClassCreate 0017 _NF__433"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D1 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1556_0 {
	meta:
		name = "TCollectionItem.Changed"
		size = 33
	strings:
		$1 = { 56 8B 70 04 85 F6 74 17 83 7E 0C 00 75 11 84 D2 74 04 33 D2 EB 02 8B D0 8B C6 8B 08 FF 51 10 5E C3 }
	condition:
		$1
}

rule function_1557_0 {
	meta:
		name = "TCollectionItem.GetIndex"
		size = 21
		refs = "000c TList.IndexOf"
	strings:
		$1 = { 8B 50 04 85 D2 74 0A 8B 52 08 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_1558_0 {
	meta:
		name = "TCollectionItem.GetDisplayName"
		size = 39
		refs = "0011 TObject.ClassName 001a @LStrFromString"
		altNames = "TDragObject.GetName"
	strings:
		$1 = { 53 56 81 C4 00 FF FF FF 8B F2 8B D8 8B D4 8B 03 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1559_0 {
	meta:
		name = "TCollectionItem.GetNamePath"
		size = 180
		refs = "0019 TCollectionItem.GetNamePath 0035 @CallDynaInst 0046 TCollectionItem.GetIndex 005f Format 006e TObject.ClassName 007b @LStrFromString 0090 @LStrClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 EC FE FF FF 53 56 57 33 C9 89 4D EC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7E 04 00 74 3C 57 8D 55 EC 8B 46 04 66 BB FE FF E8 ?? ?? ?? ?? 8B 45 EC 89 45 F0 C6 45 F4 0B 8B C6 E8 ?? ?? ?? ?? 89 45 F8 C6 45 FC 00 8D 55 F0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1A 8D 95 EC FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 EC FE FF FF 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 06 00 00 00 25 73 5B 25 64 5D 00 00 }
	condition:
		$1
}

rule function_1560_0 {
	meta:
		name = "TCollectionItem.GetOwner"
		size = 4
		altNames = "TComponent.GetOwner TTextCont.GetFirst"
	strings:
		$1 = { 8B 40 04 C3 }
	condition:
		$1
}

rule function_1561_0 {
	meta:
		name = "TCollectionItem.SetCollection"
		size = 40
		refs = "0014 _NF__350 0021 _NF__34F"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 3B F0 74 18 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1563_0 {
	meta:
		name = "TCollectionItem.SetIndex"
		size = 47
		refs = "0009 TCollectionItem.GetIndex 001f TList.Move 0028 TCollectionItem.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 1B 3B F0 74 17 8B 53 04 8B 52 08 8B CE 92 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1564_0 {
	meta:
		name = "TCollection.Create"
		size = 55
		refs = "000a @ClassCreate 0018 _DV_TList 001d TObject.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_3881_0 {
	meta:
		name = "TFieldDefs.Create"
		size = 55
		refs = "000a @ClassCreate 0018 _Dn_TList 001d TObject.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4147_0 {
	meta:
		name = "TIndexDefs.Create"
		size = 55
		refs = "000a @ClassCreate 0018 _Dn_TList 001d TObject.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1565_0 {
	meta:
		name = "TCollection.Destroy"
		size = 62
		refs = "0016 TCollection.Clear 001e TObject.Free 002a TPersistent.Destroy 0035 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 C7 46 0C 01 00 00 00 83 7E 08 00 74 07 8B C6 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1566_0 {
	meta:
		name = "TCollection.Add"
		size = 11
	strings:
		$1 = { 8B C8 B2 01 8B 40 04 FF 50 18 C3 }
	condition:
		$1
}

rule function_1567_0 {
	meta:
		name = "TCollection.Assign"
		size = 149
		refs = "0010 _DV_TCollection 0015 @IsClass 0021 TCollection.BeginUpdate 0029 TCollection.Assign 0037 TCollection.Clear 003e TCollection.GetCount 0051 TCollection.GetItem 005a TCollection.Add 0079 TCollection.EndUpdate 007f @HandleFinally 008b TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F2 89 45 FC 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 68 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1F 43 33 FF 8B D7 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 47 4B 75 E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D6 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1568_0 {
	meta:
		name = "TCollection.BeginUpdate"
		size = 4
	strings:
		$1 = { FF 40 0C C3 }
	condition:
		$1
}

rule function_1569_0 {
	meta:
		name = "TCollection.Changed"
		size = 14
	strings:
		$1 = { 83 78 0C 00 75 07 33 D2 8B 08 FF 51 10 C3 }
	condition:
		$1
}

rule function_1570_0 {
	meta:
		name = "TCollection.Clear"
		size = 101
		refs = "0018 TCollection.BeginUpdate 0020 TCollection.Clear 002f TList.Last 0034 TObject.Free 0055 TCollection.EndUpdate 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC 8B 40 08 83 78 08 00 7E 4D 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 58 08 83 7B 08 00 7F E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1571_0 {
	meta:
		name = "TCollection.EndUpdate"
		size = 9
		refs = "0004 TCollection.Changed"
	strings:
		$1 = { FF 48 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1572_0 {
	meta:
		name = "TCollection.FindItemID"
		size = 48
		refs = "001c TList.Get"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B 47 08 8B 58 08 4B 85 DB 7C 16 43 33 F6 8B 47 08 8B D6 E8 ?? ?? ?? ?? 3B 68 08 74 06 46 4B 75 ED 33 C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1574_0 {
	meta:
		name = "TCollection.GetAttr"
		size = 12
		refs = "0006 @LStrClr"
		altNames = "TCustomModule.GetVerb"
	strings:
		$1 = { 53 8B D9 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_4480_0 {
	meta:
		name = "TCustomRemoteServer.GetProvider"
		size = 12
		refs = "0006 @IntfClear"
	strings:
		$1 = { 53 8B D9 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1575_0 {
	meta:
		name = "TCollection.GetItemAttr"
		size = 32
		refs = "000e TCollection.GetItem"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 55 08 8B 08 FF 51 0C 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1576_0 {
	meta:
		name = "TChartValueList.Count"
		size = 7
		altNames = "TCollection.GetCount TFieldDefs.GetCount TIndexDefs.GetCount"
	strings:
		$1 = { 8B 40 08 8B 40 08 C3 }
	condition:
		$1
}

rule function_1577_0 {
	meta:
		name = "TCollection.GetItem"
		size = 9
		refs = "0004 TList.Get"
		altNames = "TFieldDefs.GetItem TIndexDefs.GetItem"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9934_0 {
	meta:
		name = "TCustomArray.GetInteger"
		size = 9
		refs = "0004 TIntArray.GetItem"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10577_0 {
	meta:
		name = "TDataCache.SetDimension"
		size = 9
		refs = "0004 TList.Insert"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12557_0 {
	meta:
		name = "TQRFiFo.Put"
		size = 9
		refs = "0004 TList.Add"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12726_0 {
	meta:
		name = "TQRPrinter.GetBin"
		size = 9
		refs = "0004 TPrinterSettings.GetOutputBin"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12727_0 {
	meta:
		name = "TQRPrinter.GetCopies"
		size = 9
		refs = "0004 TPrinterSettings.GetCopies"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12728_0 {
	meta:
		name = "TQRPrinter.GetDuplex"
		size = 9
		refs = "0004 TPrinterSettings.GetDuplex"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12730_0 {
	meta:
		name = "TQRPrinter.GetOrientation"
		size = 9
		refs = "0004 TPrinterSettings.GetOrientation"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12731_0 {
	meta:
		name = "TQRPrinter.GetPaperLength"
		size = 9
		refs = "0004 TPrinterSettings.GetPaperLength"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12735_0 {
	meta:
		name = "TQRPrinter.GetPaperSize"
		size = 9
		refs = "0004 TPrinterSettings.GetPaperSize"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12734_0 {
	meta:
		name = "TQRPrinter.GetPaperWidth"
		size = 9
		refs = "0004 TPrinterSettings.GetPaperWidth"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12739_0 {
	meta:
		name = "TQRPrinter.SetBin"
		size = 9
		refs = "0004 TPrinterSettings.SetOutputBin"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12740_0 {
	meta:
		name = "TQRPrinter.SetCopies"
		size = 9
		refs = "0004 TPrinterSettings.SetCopies"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12742_0 {
	meta:
		name = "TQRPrinter.SetDuplex"
		size = 9
		refs = "0004 TPrinterSettings.SetDuplex"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12743_0 {
	meta:
		name = "TQRPrinter.SetOrientation"
		size = 9
		refs = "0004 TPrinterSettings.SetOrientation"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12747_0 {
	meta:
		name = "TQRPrinter.SetPaperLength"
		size = 9
		refs = "0004 TPrinterSettings.SetPaperLength"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12748_0 {
	meta:
		name = "TQRPrinter.SetPaperSize"
		size = 9
		refs = "0004 TPrinterSettings.SetPaperSize"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12744_0 {
	meta:
		name = "TQRPrinter.SetPaperWidth"
		size = 9
		refs = "0004 TPrinterSettings.SetPaperWidth"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8296_0 {
	meta:
		name = "TWebResponse.SetCustomHeader"
		size = 9
		refs = "0004 TStrings.SetValue"
	strings:
		$1 = { 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1578_0 {
	meta:
		name = "TCollection.GetNamePath"
		size = 200
		refs = "001c TCollection.GetNamePath 002f TObject.ClassName 003c @LStrFromString 0047 @CallDynaInst 0072 TCollection.GetPropName 008f @LStrCatN 00a9 @LStrArrayClr 00af @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 57 33 C9 89 4D FC 89 4D F8 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 F8 FE FF FF 8B 06 E8 ?? ?? ?? ?? 8D 95 F8 FE FF FF 8B C7 E8 ?? ?? ?? ?? 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 85 C0 74 44 8B C6 66 BB FF FF E8 ?? ?? ?? ?? 8D 55 FC 66 BB FE FF E8 ?? ?? ?? ?? 83 7D FC 00 74 27 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 83 7D F8 00 74 17 FF 75 FC 68 ?? ?? ?? ?? FF 75 F8 8B C7 BA 03 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1579_0 {
	meta:
		name = "TCollection.GetPropName"
		size = 281
		refs = "0019 @LStrLAsg 0025 @CallDynaInst 0048 TObject.ClassInfo 005f GetTypeData 0080 @GetMem 008b TCollection.GetPropName 00a3 GetPropInfos 00cc GetOrdProp 00df @LStrFromString 00f8 @FreeMem 00fe @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 55 F8 89 45 FC 8B 45 F8 8B 55 FC 8B 52 14 E8 ?? ?? ?? ?? 8B 45 FC 66 BB FF FF E8 ?? ?? ?? ?? 89 45 F0 8B 45 F8 83 38 00 0F 85 DA 00 00 00 83 7D F0 00 0F 84 D0 00 00 00 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 85 C0 0F 84 BE 00 00 00 8B 45 F0 8B 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 A5 00 00 00 66 83 7B 08 00 0F 84 9A 00 00 00 0F BF 43 08 C1 E0 02 E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 8B 55 F4 E8 ?? ?? ?? ?? 0F BF 7B 08 4F 85 FF 7C 37 47 33 DB 8B 45 F4 8B 34 98 8B 06 8B 00 80 38 07 75 21 8B 45 F4 8B 14 98 8B 45 F0 E8 ?? ?? ?? ?? 3B 45 FC 75 0E 8B 45 FC 83 C0 14 8D 56 1A E8 ?? ?? ?? ?? 43 4F 75 CC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 8B 55 FC 8B 52 14 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1580_0 {
	meta:
		name = "_NF__34F"
		size = 139
		refs = "000f _NF__34F 001f @IsClass 002b SInvalidProperty 0030 LoadResString 003a _DV_TList 003f TList.Error 0049 TList.Add 0065 TCollection.Changed 007a @LStrClr 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 53 04 E8 ?? ?? ?? ?? 84 C0 75 1C 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 33 C9 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B 43 08 E8 ?? ?? ?? ?? 89 5E 04 8B 43 10 89 46 08 FF 43 10 8B D6 8B C3 8B 08 FF 51 0C 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1581_0 {
	meta:
		name = "_NF__350"
		size = 31
		refs = "000c TList.Remove 0018 TCollection.Changed"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 08 E8 ?? ?? ?? ?? 33 C0 89 46 04 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1582_0 {
	meta:
		name = "TCollection.SetItem"
		size = 30
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 08 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1586_0 {
	meta:
		name = "TStrings.Add"
		size = 33
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B C3 8B 10 FF 52 14 8B F0 8B CF 8B D6 8B C3 8B 18 FF 53 54 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1587_0 {
	meta:
		name = "TStrings.AddObject"
		size = 33
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 8B 08 FF 51 34 8B F0 8B CF 8B D6 8B C3 8B 18 FF 53 24 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1588_0 {
	meta:
		name = "TStrings.Append"
		size = 6
	strings:
		$1 = { 8B 08 FF 51 34 C3 }
	condition:
		$1
}

rule function_1589_0 {
	meta:
		name = "TStrings.AddStrings"
		size = 181
		refs = "0018 TStrings.AddStrings 0026 TStrings.BeginUpdate 0085 TStrings.EndUpdate 008b @HandleFinally 00a2 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 14 8B F0 4E 85 F6 7C 2D 46 33 DB 8D 4D F4 8B D3 8B 45 F8 8B 38 FF 57 0C 8B 45 F4 50 8B D3 8B 45 F8 8B 08 FF 51 18 8B C8 8B 45 FC 5A 8B 38 FF 57 38 43 4E 75 D6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1590_0 {
	meta:
		name = "TStrings.Assign"
		size = 110
		refs = "000e _DV_TStrings 0013 @IsClass 001f TStrings.BeginUpdate 0027 TStrings.Assign 0054 TStrings.EndUpdate 005a @HandleFinally 0066 TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 45 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 40 8B D3 8B 45 FC 8B 08 FF 51 3C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5B 59 5D C3 }
	condition:
		$1
}

rule function_1591_0 {
	meta:
		name = "TStrings.BeginUpdate"
		size = 23
	strings:
		$1 = { 53 8B D8 83 7B 04 00 75 09 B2 01 8B C3 8B 08 FF 51 30 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_1592_0 {
	meta:
		name = "_NF__370"
		size = 85
		refs = "001b _DV_TStrings 0020 @IsClass 0034 TStrings.Equals"
	strings:
		$1 = { 55 8B EC 53 56 8B 45 08 8B 40 FC 8B 70 1C 85 F6 74 2D B3 01 8B 45 08 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 27 8B 45 08 8B D6 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 80 F3 01 EB 10 8B 45 08 8B 40 F8 8B 10 FF 52 14 85 C0 0F 9F C3 8B C3 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1593_0 {
	meta:
		name = "TStrings.DefineProperties"
		size = 76
		refs = "0012 _NF__3B3 001b _NF__3D0 0021 _NF__370 0029 TStrings.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 13 5B 59 59 5D C3 00 00 00 FF FF FF FF 07 00 00 00 53 74 72 69 6E 67 73 00 }
	condition:
		$1
}

rule function_1594_0 {
	meta:
		name = "TStrings.EndUpdate"
		size = 17
	strings:
		$1 = { FF 48 04 83 78 04 00 75 07 33 D2 8B 08 FF 51 30 C3 }
	condition:
		$1
}

rule function_1595_0 {
	meta:
		name = "TStrings.Equals"
		size = 166
		refs = "001b TStrings.Equals 006c @LStrCmp 0090 @LStrArrayClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D F0 89 4D EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 00 8B 45 FC 8B 10 FF 52 14 8B D8 8B 45 F8 8B 10 FF 52 14 3B D8 75 3B 8B F3 4E 85 F6 7C 30 46 33 DB 8D 4D F0 8B D3 8B 45 FC 8B 38 FF 57 0C 8B 45 F0 50 8D 4D EC 8B D3 8B 45 F8 8B 38 FF 57 0C 8B 55 EC 58 E8 ?? ?? ?? ?? 75 08 43 4E 75 D3 C6 45 F7 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8A 45 F7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1598_0 {
	meta:
		name = "TStrings.Exchange"
		size = 230
		refs = "001c TStrings.Exchange 002a TStrings.BeginUpdate 00b1 TStrings.EndUpdate 00b7 @HandleFinally 00d3 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F0 89 5D F4 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D3 8B 45 FC 8B 38 FF 57 0C 8B D3 8B 45 FC 8B 08 FF 51 18 89 45 F8 8D 4D F0 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 4D F0 8B D3 8B 45 FC 8B 38 FF 57 20 8B D6 8B 45 FC 8B 08 FF 51 18 8B C8 8B D3 8B 45 FC 8B 18 FF 53 24 8B 4D F4 8B D6 8B 45 FC 8B 18 FF 53 20 8B 4D F8 8B D6 8B 45 FC 8B 18 FF 53 24 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1599_0 {
	meta:
		name = "TDataLink.DataSetScrolled"
		size = 6
		altNames = "TDataLink.LayoutChanged TStrings.GetCapacity"
	strings:
		$1 = { 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1600_0 {
	meta:
		name = "TStrings.GetCommaText"
		size = 352
		refs = "001d TStrings.GetCommaText 0051 @LStrLAsg 005d @LStrClr 0087 @LStrToPChar 0091 CharNext 00ae @_CToPasStr 00c3 @AStrCmp 00d2 AnsiQuotedStr 00f3 @LStrCatN 0106 @LStrLen 0114 @LStrDelete 0137 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 EC FE FF FF 53 56 57 33 C9 89 4D EC 89 4D F8 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B D8 83 FB 01 75 24 8D 4D EC 33 D2 8B 45 FC 8B 38 FF 57 0C 83 7D EC 00 75 11 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 BE 00 00 00 8B C6 E8 ?? ?? ?? ?? 4B 85 DB 0F 8C 99 00 00 00 43 89 5D F0 C7 45 F4 00 00 00 00 8D 4D F8 8B 55 F4 8B 45 FC 8B 18 FF 53 0C 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 EB 08 53 E8 ?? ?? ?? ?? 8B D8 8A 03 2C 21 72 08 2C 01 74 04 2C 0A 75 EA 8D 85 EC FE FF FF 8B D3 E8 ?? ?? ?? ?? 8D 85 EC FE FF FF BA ?? ?? ?? ?? 33 C9 8A 08 41 E8 ?? ?? ?? ?? 74 18 8D 4D EC B2 22 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F8 E8 ?? ?? ?? ?? FF 36 FF 75 F8 68 ?? ?? ?? ?? 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? FF 45 F4 FF 4D F0 0F 85 72 FF FF FF 8B 06 E8 ?? ?? ?? ?? 8B D0 8B C6 B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 FF FF FF FF 02 00 00 00 22 22 00 00 01 00 00 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_1601_0 {
	meta:
		name = "TStrings.GetName"
		size = 76
		refs = "0017 TStrings.GetName 001c AnsiPos 002a @LStrSetLength"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 8B 30 FF 56 0C 8B 13 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 8B D0 4A 8B C3 E8 ?? ?? ?? ?? EB 09 8B C3 33 D2 E8 ?? ?? ?? ?? 5F 5E 5B C3 00 00 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1603_0 {
	meta:
		name = "TStrings.GetText"
		size = 82
		refs = "000c TStrings.GetText 0024 @LStrToPChar 0029 StrNew 0040 @LStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 8B 08 FF 51 1C 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1604_0 {
	meta:
		name = "TStrings.GetTextStr"
		size = 229
		refs = "001b TStrings.GetTextStr 0054 @LStrLen 006b @LStrFromPCharLen 00a8 Move 00d2 @LStrArrayClr 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D E8 89 4D EC 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 89 45 F0 33 DB 8B 75 F0 4E 85 F6 7C 29 46 C7 45 F4 00 00 00 00 8D 4D E8 8B 55 F4 8B 45 FC 8B 38 FF 57 0C 8B 45 E8 E8 ?? ?? ?? ?? 83 C0 02 03 D8 FF 45 F4 4E 75 DF 8B 45 F8 8B CB 33 D2 E8 ?? ?? ?? ?? 8B 5D F8 8B 1B 8B 75 F0 4E 85 F6 7C 40 46 C7 45 F4 00 00 00 00 8D 4D EC 8B 55 F4 8B 45 FC 8B 38 FF 57 0C 8B 45 EC E8 ?? ?? ?? ?? 8B F8 85 FF 74 0E 8B D3 8B 45 EC 8B CF E8 ?? ?? ?? ?? 03 DF C6 03 0D 43 C6 03 0A 43 FF 45 F4 4E 75 C8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1605_0 {
	meta:
		name = "TStrings.GetValue"
		size = 140
		refs = "0019 TStrings.GetValue 0029 TStrings.IndexOfName 004b @LStrLen 005b @LStrCopy 0065 @LStrClr 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 2E 8B 45 F8 50 8D 4D F4 8B D6 8B C3 8B 18 FF 53 0C 8B 45 F4 50 8B 45 FC E8 ?? ?? ?? ?? 8B D0 83 C2 02 B9 FF FF FF 7F 58 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1606_0 {
	meta:
		name = "TStrings.IndexOf"
		size = 125
		refs = "0018 TStrings.IndexOf 0048 AnsiCompareText 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 23 43 33 F6 8D 4D F4 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 85 C0 74 07 46 4B 75 E0 83 CE FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1607_0 {
	meta:
		name = "TStrings.IndexOfName"
		size = 196
		refs = "001a TStrings.IndexOfName 0052 AnsiPos 006c @LStrCopy 0077 AnsiCompareText 00a2 @LStrArrayClr 00a8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 89 4D F0 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 52 46 C7 45 F4 00 00 00 00 8D 4D F0 8B 55 F4 8B 45 FC 8B 18 FF 53 0C 8B 55 F0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 23 8D 45 EC 50 8B CB 49 BA 01 00 00 00 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 EC 8B 55 F8 E8 ?? ?? ?? ?? 85 C0 74 0D FF 45 F4 4E 75 B6 C7 45 F4 FF FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F4 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1608_0 {
	meta:
		name = "TStrings.IndexOfObject"
		size = 52
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B C7 8B 10 FF 52 14 8B D8 4B 85 DB 7C 14 43 33 F6 8B D6 8B C7 8B 08 FF 51 18 3B E8 74 07 46 4B 75 EF 83 CE FF 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1609_0 {
	meta:
		name = "TStrings.InsertObject"
		size = 46
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B DA 8B F0 8B 4D FC 8B D3 8B C6 8B 38 FF 57 54 8B 4D 08 8B D3 8B C6 8B 18 FF 53 24 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1610_0 {
	meta:
		name = "TStrings.LoadFromFile"
		size = 83
		refs = "000c _DV_TFileStream 0013 TFileStream.Create 001e TStrings.LoadFromFile 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 56 8B F0 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C6 8B 08 FF 51 5C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 59 5D C3 }
	condition:
		$1
}

rule function_1611_0 {
	meta:
		name = "TStrings.LoadFromStream"
		size = 171
		refs = "0016 TStrings.LoadFromStream 0024 TStrings.BeginUpdate 0039 TStream.GetSize 0042 TStream.GetPosition 0050 @LStrFromPCharLen 007c TStrings.EndUpdate 0082 @HandleFinally 0099 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 2B F0 8D 45 F8 8B CE 33 D2 E8 ?? ?? ?? ?? 8B 55 F8 8B CE 8B C3 8B 18 FF 53 04 8B 55 F8 8B 45 FC 8B 08 FF 51 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1612_0 {
	meta:
		name = "TStrings.Move"
		size = 175
		refs = "0019 TStrings.Move 002b TStrings.BeginUpdate 006a TStrings.InsertObject 007f TStrings.EndUpdate 0085 @HandleFinally 009c @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F1 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B F3 74 64 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D3 8B 45 FC 8B 38 FF 57 0C 8B D3 8B 45 FC 8B 08 FF 51 18 8B F8 8B D3 8B 45 FC 8B 08 FF 51 44 57 8B 4D F8 8B D6 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1613_0 {
	meta:
		name = "TStrings.Put"
		size = 47
		refs = "0026 TStrings.InsertObject"
	strings:
		$1 = { 53 56 57 55 8B E9 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 18 8B F8 8B D6 8B C3 8B 08 FF 51 44 57 8B CD 8B D6 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1615_0 {
	meta:
		name = "_NF__3B3"
		size = 175
		refs = "0015 _NF__3B3 0023 TReader.ReadListBegin 002b TStrings.BeginUpdate 004e TReader.ReadString 0061 TReader.EndOfList 007a TStrings.EndUpdate 0080 @HandleFinally 008a TReader.ReadListEnd 009f @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 40 EB 16 8D 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 08 FF 51 34 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 DE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_1616_0 {
	meta:
		name = "TStrings.SaveToFile"
		size = 86
		refs = "000f _DV_TFileStream 0016 TFileStream.Create 0021 TStrings.SaveToFile 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 56 8B F0 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C6 8B 08 FF 51 68 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 59 5D C3 }
	condition:
		$1
}

rule function_1617_0 {
	meta:
		name = "TStrings.SaveToStream"
		size = 89
		refs = "000f TStrings.SaveToStream 0027 @LStrLen 0033 TStream.WriteBuffer 0048 @LStrClr 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 8B 08 FF 51 1C 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1619_0 {
	meta:
		name = "TStrings.SetCommaText"
		size = 287
		refs = "0019 TStrings.SetCommaText 0027 TStrings.BeginUpdate 0044 @LStrToPChar 0050 CharNext 006d AnsiExtractQuotedStr 0097 @LStrFromPCharLen 00f0 TStrings.EndUpdate 00f6 @HandleFinally 010d @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 89 45 FC 8D 5D F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 10 FF 52 40 8B C6 E8 ?? ?? ?? ?? 89 03 EB 0A 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 48 2C 20 72 ED EB 74 3C 22 75 0E 8D 4D F4 8B C3 B2 22 E8 ?? ?? ?? ?? EB 28 8B 33 EB 0A 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 3C 20 76 04 3C 2C 75 EA 8B 0B 2B CE 8D 45 F4 8B D6 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC 8B 08 FF 51 34 EB 0A 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 48 2C 20 72 ED 8B 03 80 38 2C 75 13 8B 03 50 E8 ?? ?? ?? ?? 89 03 8B 03 8A 00 48 2C 20 72 ED 8B 03 8A 00 84 C0 75 84 64 8F 05 00 00 00 00 83 C4 08 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1620_0 {
	meta:
		name = "TStrings.SetStringsAdapter"
		size = 49
		refs = "001a @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 08 00 74 08 8B 43 08 8B 10 FF 52 10 8D 43 08 8B D6 E8 ?? ?? ?? ?? 83 7B 08 00 74 0A 8B D3 8B 43 08 8B 08 FF 51 0C 5E 5B C3 }
	condition:
		$1
}

rule function_1621_0 {
	meta:
		name = "TStrings.SetText"
		size = 79
		refs = "000f TStrings.SetText 001f @LStrFromPChar 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 8B 08 FF 51 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1622_0 {
	meta:
		name = "TStrings.SetTextStr"
		size = 192
		refs = "0015 TStrings.SetTextStr 0023 TStrings.BeginUpdate 0061 @LStrFromPCharLen 0092 TStrings.EndUpdate 0098 @HandleFinally 00af @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 10 FF 52 40 85 DB 74 40 EB 39 8B C3 EB 01 43 8A 13 84 D2 74 0A 80 EA 0A 74 05 80 EA 03 75 EF 8B CB 2B C8 8D 55 F8 92 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 8B 08 FF 51 34 80 3B 0D 75 01 43 80 3B 0A 75 01 43 80 3B 00 75 C2 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1624_0 {
	meta:
		name = "TStrings.SetValue"
		size = 164
		refs = "0019 TStrings.SetValue 0028 TStrings.IndexOfName 0055 @LStrCatN 0085 @LStrClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 89 4D FC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 33 85 DB 7D 0B 33 D2 8B C6 8B 08 FF 51 34 8B D8 57 68 ?? ?? ?? ?? FF 75 FC 8D 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 4D F8 8B D3 8B C6 8B 18 FF 53 20 EB 0D 85 DB 7C 09 8B D3 8B C6 8B 08 FF 51 44 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1625_0 {
	meta:
		name = "_NF__3D0"
		size = 132
		refs = "0018 _NF__3D0 0026 TWriter.WriteListBegin 0050 TWriter.WriteString 005c TWriter.WriteListEnd 0071 @LStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 1F 43 33 F6 8D 4D F4 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 46 4B 75 E4 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1626_0 {
	meta:
		name = "TStringList.Destroy"
		size = 87
		refs = "001e TStrings.Destroy 002f TStringItem 0035 @FinalizeArray 004e @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 33 C0 89 46 1C 89 46 20 33 C0 89 46 24 89 46 28 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 8B 46 10 85 C0 74 10 8B 56 0C 8B C8 A1 ?? ?? ?? ?? 92 E8 ?? ?? ?? ?? 33 C0 89 46 10 33 D2 8B C6 8B 08 FF 51 28 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1627_0 {
	meta:
		name = "TStringList.Add"
		size = 151
		refs = "0016 TStringList.Add 004f SDuplicateString 0054 LoadResString 0060 TStrings.Error 006c _NF__3FB 0081 @LStrClr 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 18 00 75 08 8B 43 10 89 45 FC EB 36 8D 4D FC 8B D6 8B C3 8B 38 FF 57 78 84 C0 74 26 8A 43 19 2C 01 72 2B FE C8 74 02 EB 19 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 33 C9 8B C3 E8 ?? ?? ?? ?? 8B CE 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1628_0 {
	meta:
		name = "TStringList.Changed"
		size = 26
	strings:
		$1 = { 53 83 78 04 00 75 11 66 83 78 1E 00 74 0A 8B D8 8B D0 8B 43 20 FF 53 1C 5B C3 }
	condition:
		$1
}

rule function_1629_0 {
	meta:
		name = "TStringList.Changing"
		size = 26
	strings:
		$1 = { 53 83 78 04 00 75 11 66 83 78 26 00 74 0A 8B D8 8B D0 8B 43 28 FF 53 24 5B C3 }
	condition:
		$1
}

rule function_1630_0 {
	meta:
		name = "TStringList.Clear"
		size = 56
		refs = "0018 TStringItem 001d @FinalizeArray"
	strings:
		$1 = { 53 8B D8 83 7B 10 00 74 2D 8B C3 8B 10 FF 52 74 8B 43 0C 8B 4B 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 43 10 33 D2 8B C3 8B 08 FF 51 28 8B C3 8B 10 FF 52 70 5B C3 }
	condition:
		$1
}

rule function_1631_0 {
	meta:
		name = "TStringList.Delete"
		size = 159
		refs = "000f TStringList.Delete 0026 SListIndexError 002b LoadResString 0037 TStrings.Error 004a TStringItem 004f @Finalize 0072 Move 008e @LStrClr 0094 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B 43 0C 8D 04 F0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 4B 10 8B 43 10 3B F0 7D 19 2B C6 8B C8 C1 E1 03 8B 43 0C 8D 14 F0 8B 43 0C 8D 44 F0 08 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1632_0 {
	meta:
		name = "TStringList.Exchange"
		size = 156
		refs = "0012 TStringList.Exchange 0029 SListIndexError 002e LoadResString 003a TStrings.Error 006e _NF__3E4 008a @LStrClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 85 FF 7C 05 3B 7B 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CF 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1633_0 {
	meta:
		name = "_NF__3E4"
		size = 35
	strings:
		$1 = { 53 8B 58 0C 8D 14 D3 8B 40 0C 8D 04 C8 8B 0A 8B 18 89 1A 89 08 8B 4A 04 8B 58 04 89 5A 04 89 48 04 5B C3 }
	condition:
		$1
}

rule function_1634_0 {
	meta:
		name = "TStringList.Find"
		size = 101
		refs = "002e AnsiCompareText"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 4C 24 04 89 14 24 8B E8 C6 44 24 08 00 33 F6 8B 7D 10 4F 3B FE 7C 34 8D 1C 37 D1 EB 8B 45 0C 8B 04 D8 8B 14 24 E8 ?? ?? ?? ?? 85 C0 7D 05 8D 73 01 EB 14 8B FB 4F 85 C0 75 0D C6 44 24 08 01 80 7D 19 01 74 02 8B F3 3B FE 7D CC 8B 44 24 04 89 30 8A 44 24 08 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1635_0 {
	meta:
		name = "TStringList.Get"
		size = 110
		refs = "0012 TStringList.Get 0029 SListIndexError 002e LoadResString 003a TStrings.Error 0047 @LStrLAsg 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C7 8B 53 0C 8B 14 F2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1637_0 {
	meta:
		name = "TStringList.GetCount"
		size = 4
	strings:
		$1 = { 8B 40 10 C3 }
	condition:
		$1
}

rule function_1638_0 {
	meta:
		name = "TStringList.GetObject"
		size = 102
		refs = "000f TStringList.GetObject 0026 SListIndexError 002b LoadResString 0037 TStrings.Error 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B 43 0C 8B 5C F0 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1639_0 {
	meta:
		name = "_NF__3F3"
		size = 51
	strings:
		$1 = { 56 8B 50 14 83 FA 40 7E 0E 8B F2 85 F6 79 03 83 C6 03 C1 FE 02 EB 11 83 FA 08 7E 07 BE 10 00 00 00 EB 05 BE 04 00 00 00 03 F2 8B D6 8B 08 FF 51 28 5E C3 }
	condition:
		$1
}

rule function_1640_0 {
	meta:
		name = "TStringList.IndexOf"
		size = 56
		refs = "0012 TStrings.IndexOf"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 80 7B 18 00 75 0E 8B D6 8B C3 E8 ?? ?? ?? ?? 89 04 24 EB 16 8B CC 8B D6 8B C3 8B 18 FF 53 78 84 C0 75 07 C7 04 24 FF FF FF FF 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1641_0 {
	meta:
		name = "TStringList.Insert"
		size = 139
		refs = "0012 TStringList.Insert 0026 SSortedListError 002b LoadResString 0037 TStrings.Error 0048 SListIndexError 0064 _NF__3FB 0079 @LStrClr 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 18 00 74 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 33 C9 8B C3 E8 ?? ?? ?? ?? 85 F6 7C 05 3B 73 10 7E 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1642_0 {
	meta:
		name = "_NF__3FB"
		size = 103
		refs = "001b _NF__3F3 003b Move 0055 @LStrAsg"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 8B 10 FF 52 74 8B 43 10 3B 43 14 75 07 8B C3 E8 ?? ?? ?? ?? 8B 43 10 3B F0 7D 19 2B C6 8B C8 C1 E1 03 8B 43 0C 8D 54 F0 08 8B 43 0C 8D 04 F0 E8 ?? ?? ?? ?? 8B 43 0C 8D 04 F0 8B F0 33 C0 89 06 33 C0 89 46 04 8B C6 8B D7 E8 ?? ?? ?? ?? FF 43 10 8B C3 8B 10 FF 52 70 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1643_0 {
	meta:
		name = "TStringList.Put"
		size = 155
		refs = "0012 TStringList.Put 0026 SSortedListError 002b LoadResString 0037 TStrings.Error 0048 SListIndexError 006d @LStrAsg 0089 @LStrClr 008f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 18 00 74 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 33 C9 8B C3 E8 ?? ?? ?? ?? 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B 43 0C 8D 04 F0 8B D7 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1644_0 {
	meta:
		name = "TStringList.PutObject"
		size = 118
		refs = "0012 TStringList.PutObject 0029 SListIndexError 002e LoadResString 003a TStrings.Error 0064 @LStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 7C 05 3B 73 10 7C 19 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 74 8B 43 0C 89 7C F0 04 8B C3 8B 10 FF 52 70 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1645_0 {
	meta:
		name = "_NF__404"
		size = 188
		refs = "001a _NF__404 003c @LStrLAsg 004d AnsiCompareText 0075 _NF__3E4 00a9 @LStrClr 00af @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 89 4D F8 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5D FC 8B 75 F8 8D 45 F4 8B 55 FC 03 55 F8 D1 EA 8B 4F 0C 8B 14 D1 E8 ?? ?? ?? ?? EB 01 43 8B 47 0C 8B 04 D8 8B 55 F4 E8 ?? ?? ?? ?? 85 C0 7C ED EB 01 4E 8B 47 0C 8B 04 F0 8B 55 F4 E8 ?? ?? ?? ?? 85 C0 7F ED 3B F3 7C 0D 8B CE 8B D3 8B C7 E8 ?? ?? ?? ?? 43 4E 3B F3 7D C4 3B 75 FC 7E 0C 8B CE 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 89 5D FC 3B 5D F8 7C 8C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1646_0 {
	meta:
		name = "TStringList.SetCapacity"
		size = 25
		refs = "000f @ReallocMem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 C1 E2 03 8D 43 0C E8 ?? ?? ?? ?? 89 73 14 5E 5B C3 }
	condition:
		$1
}

rule function_1647_0 {
	meta:
		name = "TStringList.SetSorted"
		size = 28
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 5E 18 74 0E 84 DB 74 07 8B C6 8B 10 FF 52 7C 88 5E 18 5E 5B C3 }
	condition:
		$1
}

rule function_1648_0 {
	meta:
		name = "TStringList.SetUpdateState"
		size = 16
	strings:
		$1 = { 84 D2 74 06 8B 10 FF 52 74 C3 8B 10 FF 52 70 C3 }
	condition:
		$1
}

rule function_1649_0 {
	meta:
		name = "TStringList.Sort"
		size = 44
		refs = "001f _NF__404"
	strings:
		$1 = { 53 8B D8 80 7B 18 00 75 21 83 7B 10 01 7E 1B 8B C3 8B 10 FF 52 74 8B 4B 10 49 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 70 5B C3 }
	condition:
		$1
}

rule function_1650_0 {
	meta:
		name = "TStream.GetPosition"
		size = 14
	strings:
		$1 = { 53 66 B9 01 00 33 D2 8B 18 FF 53 0C 5B C3 }
	condition:
		$1
}

rule function_1651_0 {
	meta:
		name = "TStream.SetPosition"
		size = 10
	strings:
		$1 = { 53 33 C9 8B 18 FF 53 0C 5B C3 }
	condition:
		$1
}

rule function_1652_0 {
	meta:
		name = "TStream.GetSize"
		size = 52
	strings:
		$1 = { 53 56 57 8B D8 66 B9 01 00 33 D2 8B C3 8B 30 FF 56 0C 8B F0 66 B9 02 00 33 D2 8B C3 8B 38 FF 57 0C 8B F8 33 C9 8B D6 8B C3 8B 18 FF 53 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1654_0 {
	meta:
		name = "TStream.ReadBuffer"
		size = 122
		refs = "0018 TStream.ReadBuffer 003a SReadError 003f LoadResString 0049 _DV_EReadError 004e Exception.Create 0053 @RaiseExcept 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 8B D9 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 31 8B 55 FC 8B CB 8B C6 8B 30 FF 56 04 3B D8 74 21 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1655_0 {
	meta:
		name = "TStream.WriteBuffer"
		size = 122
		refs = "0018 TStream.WriteBuffer 003a SWriteError 003f LoadResString 0049 _DV_EWriteError 004e Exception.Create 0053 @RaiseExcept 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 8B D9 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 31 8B 55 FC 8B CB 8B C6 8B 30 FF 56 08 3B D8 74 21 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1656_0 {
	meta:
		name = "TStream.CopyFrom"
		size = 180
		refs = "001b TStream.SetPosition 0023 TStream.GetSize 0044 @GetMem 004f TStream.CopyFrom 0074 TStream.ReadBuffer 0080 TStream.WriteBuffer 009e @FreeMem 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B D9 89 55 F8 89 45 FC 85 DB 75 14 33 D2 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 89 5D F4 81 FB 00 F0 00 00 7E 09 C7 45 F0 00 F0 00 00 EB 03 89 5D F0 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 2D 3B 5D F0 7E 05 8B 75 F0 EB 02 8B F3 8B 7D EC 8B D7 8B CE 8B 45 F8 E8 ?? ?? ?? ?? 8B D7 8B CE 8B 45 FC E8 ?? ?? ?? ?? 2B DE 85 DB 75 D3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F0 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1657_0 {
	meta:
		name = "TStream.ReadComponent"
		size = 95
		refs = "0013 _DV_TReader 0018 TFiler.Create 0023 TStream.ReadComponent 0033 TReader.ReadRootComponent 004b TObject.Free 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 68 00 10 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1658_0 {
	meta:
		name = "TStream.WriteComponent"
		size = 8
		refs = "0003 TStream.WriteDescendent"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14383_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6785_0 {
	meta:
		name = "EditChart"
		size = 8
		refs = "0003 EditChartPage"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7912_0 {
	meta:
		name = "TBitmap.SaveToStream"
		size = 8
		refs = "0003 _NF__5E9"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4601_0 {
	meta:
		name = "TClientDataSet.SetIndexName"
		size = 8
		refs = "0003 _NF__37E"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3798_0 {
	meta:
		name = "TCopyParser.SkipToken"
		size = 8
		refs = "0003 _NF__79"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5670_0 {
	meta:
		name = "TDatabase.SetDriverName"
		size = 8
		refs = "0003 _NF__5E2"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7986_0 {
	meta:
		name = "TInplaceEdit.UpdateLoc"
		size = 8
		refs = "0003 _NF__263"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5608_0 {
	meta:
		name = "TSession.OpenDatabase"
		size = 8
		refs = "0003 _NF__568"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8242_0 {
	meta:
		name = "TStringGrid.GetRows"
		size = 8
		refs = "0003 _NF__497"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5864_0 {
	meta:
		name = "TTable.SetIndexName"
		size = 8
		refs = "0003 _NF__7F0"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5902_0 {
	meta:
		name = "TTable.UnlockTable"
		size = 8
		refs = "0003 _NF__84E"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1821_0 {
	meta:
		name = "TWriter.WriteRootComponent"
		size = 8
		refs = "0003 TWriter.WriteDescendent"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17736_0 {
	meta:
		name = "ZeroMemory"
		size = 8
		refs = "0003 @FillChar"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1659_0 {
	meta:
		name = "TStream.WriteDescendent"
		size = 92
		refs = "0014 _DV_TWriter 0019 TFiler.Create 0024 TStream.WriteDescendent 0036 TWriter.WriteDescendent 004b TObject.Free 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 68 00 10 00 00 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1660_0 {
	meta:
		name = "TStream.ReadComponentRes"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 TStream.ReadComponent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1861_0 {
	meta:
		name = "ObjectResourceToText"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 ObjectBinaryToText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5369_0 {
	meta:
		name = "TCustomDBGrid.WMSetFocus"
		size = 25
		refs = "0009 _NF__4F9 0012 TCustomGrid.WMSetFocus"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4931_0 {
	meta:
		name = "TDBImage.WMLButtonDblClk"
		size = 25
		refs = "0009 TDBImage.LoadPicture 0012 TControl.WMLButtonDblClk"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5061_0 {
	meta:
		name = "TDBLookupComboBox.WMCancelMode"
		size = 25
		refs = "0009 _NF__69E 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5035_0 {
	meta:
		name = "TDBLookupListBox.WMCancelMode"
		size = 25
		refs = "0009 _NF__651 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5143_0 {
	meta:
		name = "_NF__2D6"
		size = 25
		refs = "0009 _NF__2D2 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1661_0 {
	meta:
		name = "TStream.WriteComponentRes"
		size = 8
		refs = "0003 TStream.WriteDescendentRes"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14680_0 {
	meta:
		name = "Beep"
		size = 8
		refs = "0003 MessageBeep"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7739_0 {
	meta:
		name = "GetDIBSizes"
		size = 8
		refs = "0003 _NF__42C"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11847_0 {
	meta:
		name = "TCustomOutline.Add"
		size = 8
		refs = "0003 TCustomOutline.AddObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11849_0 {
	meta:
		name = "TCustomOutline.AddChild"
		size = 8
		refs = "0003 TCustomOutline.AddChildObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11845_0 {
	meta:
		name = "TCustomOutline.Insert"
		size = 8
		refs = "0003 TCustomOutline.InsertObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4306_0 {
	meta:
		name = "TDataSet.InsertRecord"
		size = 8
		refs = "0003 _NF__6C5"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7419_0 {
	meta:
		name = "TScreen.GetWidth"
		size = 8
		refs = "0003 GetSystemMetrics"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2225_0 {
	meta:
		name = "TTreeNodes.Add"
		size = 8
		refs = "0003 TTreeNodes.AddObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2221_0 {
	meta:
		name = "TTreeNodes.AddChild"
		size = 8
		refs = "0003 TTreeNodes.AddChildObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2219_0 {
	meta:
		name = "TTreeNodes.AddChildFirst"
		size = 8
		refs = "0003 TTreeNodes.AddChildObjectFirst"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2223_0 {
	meta:
		name = "TTreeNodes.AddFirst"
		size = 8
		refs = "0003 TTreeNodes.AddObjectFirst"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2228_0 {
	meta:
		name = "TTreeNodes.Insert"
		size = 8
		refs = "0003 TTreeNodes.InsertObject"
	strings:
		$1 = { 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1662_0 {
	meta:
		name = "TStream.WriteDescendentRes"
		size = 167
		refs = "0028 StrPLCopy 002d StrUpper 0032 StrLen 0052 TStream.WriteBuffer 0059 TStream.GetPosition 0068 TStream.WriteDescendent 0080 TStream.SetPosition"
	strings:
		$1 = { 55 8B EC 83 C4 A8 53 56 89 4D FC 8B F2 8B D8 8D 45 A8 C6 00 FF 8D 45 A9 66 C7 00 0A 00 8D 45 AB B9 3F 00 00 00 8B D6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 0A 8D 54 05 A2 66 C7 02 30 10 8D 54 05 A4 33 C9 89 0A 8D 55 A8 8B C8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 4D 08 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 2B C6 89 45 F8 8B D6 83 EA 04 8B C3 E8 ?? ?? ?? ?? 8D 55 F8 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 55 F8 03 D6 8B C3 E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1663_0 {
	meta:
		name = "TStream.ReadResHeader"
		size = 177
		refs = "0013 TStream.ReadResHeader 0028 @FillChar 0055 StrLen 0071 SInvalidImage 0076 LoadResString 0080 _DV_EInvalidImage 0085 Exception.Create 008a @RaiseExcept 009f @LStrClr 00a5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 AC 53 56 33 D2 89 55 AC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 B0 33 C9 BA 50 00 00 00 E8 ?? ?? ?? ?? 8D 55 B0 B9 4F 00 00 00 8B C3 8B 30 FF 56 04 8B F0 8D 45 B0 80 38 FF 75 28 8D 45 B1 66 83 38 0A 75 1F 8D 45 B0 83 C0 03 E8 ?? ?? ?? ?? 8B D0 83 C2 0A 2B D6 66 B9 01 00 8B C3 8B 18 FF 53 0C EB 21 8D 55 AC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D AC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 AC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1665_0 {
	meta:
		name = "THandleStream.Read"
		size = 16
		refs = "0004 FileRead"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? 83 F8 FF 75 02 33 C0 C3 }
	condition:
		$1
}

rule function_1666_0 {
	meta:
		name = "THandleStream.Write"
		size = 16
		refs = "0004 FileWrite"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? 83 F8 FF 75 02 33 C0 C3 }
	condition:
		$1
}

rule function_1667_0 {
	meta:
		name = "THandleStream.Seek"
		size = 12
		refs = "0007 FileSeek"
	strings:
		$1 = { 0F B7 C9 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1668_0 {
	meta:
		name = "THandleStream.SetSize"
		size = 30
		refs = "0012 SetEndOfFile 0017 Win32Check"
	strings:
		$1 = { 53 56 8B D8 33 C9 8B C3 8B 30 FF 56 0C 8B 43 04 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1669_0 {
	meta:
		name = "TFileStream.Create"
		size = 245
		refs = "0016 @ClassCreate 0028 TFileStream.Create 003f FileCreate 005d SFCreateError 0062 LoadResString 006c _DV_EFCreateError 0071 Exception.CreateFmt 0076 @RaiseExcept 0082 FileOpen 00a0 SFOpenError 00af _DV_EFOpenError 00ce @LStrClr 00d4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F0 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 88 55 FF 8B D8 8B 7D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B7 C7 3D FF FF 00 00 75 40 8B C6 E8 ?? ?? ?? ?? 8B F8 89 7B 04 85 FF 7D 71 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 41 0F B7 D7 8B C6 E8 ?? ?? ?? ?? 89 43 04 83 7B 04 00 7D 2E 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1670_0 {
	meta:
		name = "TFileStream.Destroy"
		size = 34
		refs = "000e FileClose 0019 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 04 85 C0 7C 05 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1671_0 {
	meta:
		name = "TCustomMemoryStream.SetPointer"
		size = 7
	strings:
		$1 = { 89 50 04 89 48 08 C3 }
	condition:
		$1
}

rule function_1672_0 {
	meta:
		name = "TCustomMemoryStream.Read"
		size = 56
		refs = "0027 Move"
	strings:
		$1 = { 53 56 57 8B D8 8B 7B 0C 85 FF 7C 24 85 C9 7C 20 8B 73 08 2B F7 85 F6 7E 17 3B CE 7D 02 8B F1 8B 43 04 03 C7 8B CE E8 ?? ?? ?? ?? 01 73 0C EB 02 33 F6 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1673_0 {
	meta:
		name = "TCustomMemoryStream.Seek"
		size = 35
	strings:
		$1 = { 66 83 E9 01 72 09 74 0C 66 FF C9 74 0C EB 10 89 50 0C EB 0B 01 50 0C EB 06 03 50 08 89 50 0C 8B 40 0C C3 }
	condition:
		$1
}

rule function_1674_0 {
	meta:
		name = "TCustomMemoryStream.SaveToStream"
		size = 22
		refs = "0010 TStream.WriteBuffer"
	strings:
		$1 = { 53 8B 48 08 85 C9 74 0C 8B 58 04 87 DA 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1675_0 {
	meta:
		name = "TCustomMemoryStream.SaveToFile"
		size = 86
		refs = "000f _DV_TFileStream 0016 TFileStream.Create 0021 TCustomMemoryStream.SaveToFile 0031 TCustomMemoryStream.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4132_0 {
	meta:
		name = "TBlobField.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TBlobField.SaveToFile 0031 TBlobField.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4536_0 {
	meta:
		name = "TClientDataSet.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TClientDataSet.SaveToFile 0031 TClientDataSet.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11909_0 {
	meta:
		name = "TCustomOutline.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TCustomOutline.SaveToFile 0031 TCustomOutline.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2320_0 {
	meta:
		name = "TCustomTreeView.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TCustomTreeView.SaveToFile 0031 TCustomTreeView.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_5249_0 {
	meta:
		name = "TDBGridColumns.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TDBGridColumns.SaveToFile 0031 TDBGridColumns.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11167_0 {
	meta:
		name = "TOleContainer.SaveToFile"
		size = 86
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TOleContainer.SaveToFile 0031 TOleContainer.SaveToStream 0046 TObject.Free 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 68 FF FF 00 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1677_0 {
	meta:
		name = "TMemoryStream.Clear"
		size = 24
		refs = "0008 TMemoryStream.SetCapacity"
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 89 43 08 33 C0 89 43 0C 5B C3 }
	condition:
		$1
}

rule function_1678_0 {
	meta:
		name = "TMemoryStream.LoadFromStream"
		size = 53
		refs = "000c TStream.SetPosition 0013 TStream.GetSize 002d TStream.ReadBuffer"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 8B D3 8B C6 8B 08 FF 11 85 DB 74 0C 8B 56 04 8B CB 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1679_0 {
	meta:
		name = "TMemoryStream.LoadFromFile"
		size = 83
		refs = "000c _DV_TFileStream 0013 TFileStream.Create 001e TMemoryStream.LoadFromFile 002e TMemoryStream.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4128_0 {
	meta:
		name = "TBlobField.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TBlobField.LoadFromFile 002e TBlobField.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4534_0 {
	meta:
		name = "TClientDataSet.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TClientDataSet.LoadFromFile 002e TClientDataSet.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11901_0 {
	meta:
		name = "TCustomOutline.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TCustomOutline.LoadFromFile 002e TCustomOutline.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2318_0 {
	meta:
		name = "TCustomTreeView.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TCustomTreeView.LoadFromFile 002e TCustomTreeView.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_5245_0 {
	meta:
		name = "TDBGridColumns.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TDBGridColumns.LoadFromFile 002e TDBGridColumns.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11152_0 {
	meta:
		name = "TOleContainer.LoadFromFile"
		size = 83
		refs = "000c _Dn_TFileStream 0013 TFileStream.Create 001e TOleContainer.LoadFromFile 002e TOleContainer.LoadFromStream 0043 TObject.Free 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1680_0 {
	meta:
		name = "TMemoryStream.SetCapacity"
		size = 37
		refs = "0018 TCustomMemoryStream.SetPointer"
	strings:
		$1 = { 53 51 89 14 24 8B D8 8B D4 8B C3 8B 08 FF 51 10 8B D0 8B 4B 08 8B C3 E8 ?? ?? ?? ?? 8B 04 24 89 43 10 5A 5B C3 }
	condition:
		$1
}

rule function_1681_0 {
	meta:
		name = "TMemoryStream.SetSize"
		size = 41
		refs = "001e TMemoryStream.SetCapacity"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 3B 73 0C 7D 0D 66 B9 02 00 33 D2 8B C3 8B 38 FF 57 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 89 73 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1682_0 {
	meta:
		name = "TMemoryStream.Realloc"
		size = 190
		refs = "000c TMemoryStream.Realloc 0041 GlobalFreePtr 004e HeapAllocFlags 0058 GlobalAllocPtr 006e GlobalReAllocPtr 007c SMemoryStreamError 0081 LoadResString 008b _DV_EStreamError 0090 Exception.Create 0095 @RaiseExcept 00aa @LStrClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 83 3A 00 7E 10 8B 0A 81 C1 FF 1F 00 00 81 E1 00 E0 FF FF 89 0A 8B 70 04 8B DE 8B 3A 8B 48 10 3B F9 74 60 83 3A 00 75 0B 8B C6 E8 ?? ?? ?? ?? 33 DB EB 50 85 C9 75 13 A1 ?? ?? ?? ?? 0F B7 00 8B 12 E8 ?? ?? ?? ?? 8B D8 EB 14 8B 0D ?? ?? ?? ?? 0F B7 09 8B 12 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1683_0 {
	meta:
		name = "TMemoryStream.Write"
		size = 80
		refs = "002c TMemoryStream.SetCapacity 003e Move"
	strings:
		$1 = { 53 56 57 55 8B F1 8B EA 8B D8 8B 43 0C 85 C0 7C 38 85 F6 7C 34 8B F8 03 FE 85 FF 7E 2C 3B 7B 08 7E 11 3B 7B 10 7E 09 8B D7 8B C3 E8 ?? ?? ?? ?? 89 7B 08 8B 53 04 03 53 0C 8B C5 8B CE E8 ?? ?? ?? ?? 89 7B 0C 8B C6 EB 02 33 C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1684_0 {
	meta:
		name = "TStringStream.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0024 @LStrAsg"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8D 47 04 8B D6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1685_0 {
	meta:
		name = "TStringStream.Read"
		size = 61
		refs = "000e @LStrLen 0021 UniqueString 002f Move"
	strings:
		$1 = { 53 56 57 55 8B F9 8B EA 8B D8 8B 43 04 E8 ?? ?? ?? ?? 8B F0 2B 73 08 3B FE 7D 02 8B F7 8D 43 04 E8 ?? ?? ?? ?? 8B 53 08 03 C2 8B D5 8B CE E8 ?? ?? ?? ?? 01 73 08 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1686_0 {
	meta:
		name = "TStringStream.Write"
		size = 54
		refs = "0012 @LStrSetLength 001a UniqueString 0029 Move"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B F1 8B 53 08 03 D6 8D 43 04 E8 ?? ?? ?? ?? 8D 43 04 E8 ?? ?? ?? ?? 8B 53 08 8D 14 10 8B C7 8B CE E8 ?? ?? ?? ?? 01 73 08 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1687_0 {
	meta:
		name = "TStringStream.Seek"
		size = 87
		refs = "0023 @LStrLen"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 E9 01 72 09 74 0C 66 FF C9 74 0C EB 17 89 73 08 EB 12 01 73 08 EB 0D 8B 43 04 E8 ?? ?? ?? ?? 2B C6 89 43 08 8B 43 04 E8 ?? ?? ?? ?? 3B 43 08 7D 0D 8B 43 04 E8 ?? ?? ?? ?? 89 43 08 EB 0B 83 7B 08 00 7D 05 33 C0 89 43 08 8B 43 08 5E 5B C3 }
	condition:
		$1
}

rule function_1688_0 {
	meta:
		name = "TStringStream.ReadString"
		size = 60
		refs = "000e @LStrLen 0021 UniqueString 0030 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B D8 8B 43 04 E8 ?? ?? ?? ?? 8B F0 2B 73 08 3B FE 7D 02 8B F7 8D 43 04 E8 ?? ?? ?? ?? 8B 53 08 8D 14 10 8B C5 8B CE E8 ?? ?? ?? ?? 01 73 08 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1689_0 {
	meta:
		name = "TStringStream.WriteString"
		size = 34
		refs = "0009 @LStrLen 0011 @LStrToPChar"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 59 8B 18 FF 53 08 5E 5B C3 }
	condition:
		$1
}

rule function_1690_0 {
	meta:
		name = "TStringStream.SetSize"
		size = 27
		refs = "000c @LStrSetLength"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 04 8B D6 E8 ?? ?? ?? ?? 3B 73 08 7D 03 89 73 08 5E 5B C3 }
	condition:
		$1
}

rule function_1691_0 {
	meta:
		name = "TResourceStream.Create"
		size = 79
		refs = "000e @ClassCreate 001d TObject.Create 0029 @LStrToPChar 0034 _NF__4A9"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 0C E8 ?? ?? ?? ?? 8B C8 8B D6 8B C7 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1692_0 {
	meta:
		name = "TResourceStream.CreateFromID"
		size = 72
		refs = "000e @ClassCreate 001d TObject.Create 002d _NF__4A9"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D 0C 8B D6 8B C7 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1693_0 {
	meta:
		name = "_NF__4A8"
		size = 129
		refs = "0012 _NF__4A8 0024 SResNotFound 0029 LoadResString 0043 Format 004d _DV_EResNotFound 0052 Exception.Create 0057 @RaiseExcept 0071 @LStrArrayClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 33 C0 89 45 FC 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 55 08 8B 52 FC 89 55 F0 C6 45 F4 06 8D 55 F0 33 C9 E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B E5 5D C3 }
	condition:
		$1
}

rule function_1694_0 {
	meta:
		name = "_NF__4A9"
		size = 108
		refs = "0018 FindResource 0027 _NF__4A8 0032 LoadResource 004c SizeofResource 0056 LockResource 0060 TCustomMemoryStream.SetPointer"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 45 08 50 8B 45 FC 50 56 E8 ?? ?? ?? ?? 8B F8 89 7B 10 85 FF 75 07 55 E8 ?? ?? ?? ?? 59 8B 43 10 50 56 E8 ?? ?? ?? ?? 8B F8 89 7B 14 85 FF 75 07 55 E8 ?? ?? ?? ?? 59 8B 43 10 50 56 E8 ?? ?? ?? ?? 50 8B 43 14 50 E8 ?? ?? ?? ?? 8B D0 8B C3 59 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1695_0 {
	meta:
		name = "TResourceStream.Destroy"
		size = 51
		refs = "000a UnlockResource 0013 FreeResource 001f TObject.Destroy 002a @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 14 E8 ?? ?? ?? ?? 8B 46 14 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1696_0 {
	meta:
		name = "TResourceStream.Write"
		size = 88
		refs = "000a TResourceStream.Write 0018 SCantWriteResourceStreamError 001d LoadResString 0027 _DV_EStreamError 002c Exception.Create 0031 @RaiseExcept 0046 @LStrClr 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1697_0 {
	meta:
		name = "TFiler.Create"
		size = 64
		refs = "000e @ClassCreate 001f @GetMem"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 8B 75 08 89 4F 04 8B C6 E8 ?? ?? ?? ?? 89 47 08 89 77 0C 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1698_0 {
	meta:
		name = "TFiler.Destroy"
		size = 37
		refs = "0011 @FreeMem 001c @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 46 08 85 C0 74 08 8B 56 0C E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1699_0 {
	meta:
		name = "_NF__4BC"
		size = 80
		refs = "000d @ClassCreate 002b @LStrAsg"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 89 4E 04 8B 45 14 89 46 08 8B 45 10 89 46 0C 8D 46 10 8B 55 0C E8 ?? ?? ?? ?? 8D 46 14 8B 55 08 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1700_0 {
	meta:
		name = "_NF__4BD"
		size = 56
		refs = "000f TList.IndexOf 0031 TList.Add"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 85 C0 7D 1E 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 85 C0 7C 0D 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1701_0 {
	meta:
		name = "_NF__4BE"
		size = 69
		refs = "000f TList.IndexOf 0020 TList.Delete 003e TList.Add"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 83 F8 FF 74 0C 8B 55 08 8B 52 FC 92 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 85 C0 7D 0D 8B 45 08 8B 40 F8 8B D3 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1702_0 {
	meta:
		name = "GlobalFixupReferences"
		size = 392
		refs = "000b FindGlobalComponent 0017 _NV__4BB 0028 _DV_TList 002d TObject.Create 0038 GlobalFixupReferences 006e TList.Get 008a GetOrdProp 009c TComponent.FindComponent 00b2 CompareText 00c7 SetOrdProp 00d0 _NF__4BD 00dd TList.Delete 00e4 TObject.Free 00ef _NF__4BE 011a @HandleFinally 013e _DV_TComponent 0143 @IsClass"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 83 3D ?? ?? ?? ?? 00 0F 84 5A 01 00 00 A1 ?? ?? ?? ?? 83 78 08 00 0F 8E 4B 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 E9 8F 00 00 00 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 43 10 FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 0F 8B 53 0C 8B 43 04 E8 ?? ?? ?? ?? 85 C0 74 58 85 FF 74 35 8B 53 14 8B C7 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 14 8B 43 14 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 03 89 7D F4 8B 53 0C 8B 43 04 8B 4D F4 E8 ?? ?? ?? ?? 55 8B 43 04 E8 ?? ?? ?? ?? 59 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? EB 0B 55 8B 43 04 E8 ?? ?? ?? ?? 59 46 A1 ?? ?? ?? ?? 3B 70 08 0F 8C 63 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 8B 58 08 4B 85 DB 7C 28 43 33 F6 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B F8 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 04 80 67 20 7F 46 4B 75 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 05 00 00 00 4F 57 4E 45 52 00 00 00 }
	condition:
		$1
}

rule function_1703_0 {
	meta:
		name = "_NF__4C0"
		size = 131
		refs = "0018 _NF__4C0 004c CompareText 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F0 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 01 8B 45 FC 8B 10 FF 52 14 8B D8 4B 85 DB 7C 23 43 33 F6 8D 4D F0 8B D6 8B 45 FC 8B 38 FF 57 0C 8B 55 F0 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 74 08 46 4B 75 E0 C6 45 F7 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 F7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1704_0 {
	meta:
		name = "GetFixupReferenceNames"
		size = 85
		refs = "000b _NV__4BB 0022 TList.Get 0038 _NF__4C0"
	strings:
		$1 = { 53 56 57 55 51 89 14 24 8B F8 A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 38 46 33 ED 8B D5 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 FF 74 05 3B 7B 08 75 1A 8B 53 10 8B 04 24 E8 ?? ?? ?? ?? 84 C0 75 0B 8B 53 10 8B 04 24 8B 08 FF 51 34 45 4E 75 CB 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1705_0 {
	meta:
		name = "RedirectFixupReferences"
		size = 98
		refs = "0011 _NV__4BB 0028 TList.Get 003e CompareText 004e @LStrAsg 0057 GlobalFixupReferences"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 4C 24 04 89 14 24 8B F8 A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 39 46 33 ED 8B D5 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 FF 74 05 3B 7B 08 75 1B 8B 53 10 8B 04 24 E8 ?? ?? ?? ?? 85 C0 75 0C 8D 43 10 8B 54 24 04 E8 ?? ?? ?? ?? 45 4E 75 CA E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1706_0 {
	meta:
		name = "RemoveFixupReferences"
		size = 93
		refs = "0009 _NV__4BB 001e TList.Get 0037 CompareText 0047 TList.Delete 004e TObject.Free"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 A1 ?? ?? ?? ?? 8B 58 08 4B 83 FB 00 7C 42 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 FF 74 05 3B 7E 08 75 25 85 ED 74 0E 8B 56 10 8B C5 E8 ?? ?? ?? ?? 85 C0 75 13 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 4B 83 FB FF 75 BE 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1707_0 {
	meta:
		name = "RemoveFixups"
		size = 68
		refs = "0007 _NV__4BB 001d TList.Get 002e TList.Delete 0035 TObject.Free"
	strings:
		$1 = { 53 56 57 55 8B F8 BD ?? ?? ?? ?? 8B 45 00 8B 58 08 4B 83 FB 00 7C 28 8B D3 8B 45 00 E8 ?? ?? ?? ?? 8B F0 3B 7E 04 75 11 8B D3 8B 45 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 4B 83 FB FF 75 D8 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1708_0 {
	meta:
		name = "GetFixupInstanceNames"
		size = 105
		refs = "0011 _NV__4BB 0028 TList.Get 003e CompareText 004c _NF__4C0"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B E9 89 54 24 04 89 04 24 A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 45 46 33 FF 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 43 08 3B 04 24 75 28 8B 53 10 8B 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 18 8B 53 14 8B C5 E8 ?? ?? ?? ?? 84 C0 75 0A 8B 53 14 8B C5 8B 08 FF 51 34 47 4E 75 BE 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1712_0 {
	meta:
		name = "_NF__4D4"
		size = 22
		refs = "0002 GetEnumValue 000e _NF__4D2"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 83 FB FF 75 05 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_1713_0 {
	meta:
		name = "TReader.Destroy"
		size = 54
		refs = "0021 TFiler.Destroy 002c @ClassDestroy"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B 56 10 2B 56 14 66 B9 01 00 8B 46 04 8B 38 FF 57 0C 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1714_0 {
	meta:
		name = "TReader.BeginReferences"
		size = 97
		refs = "000a _DV_TList 000f TObject.Create 001d TReader.BeginReferences 0045 @HandleAnyException 0050 TObject.Free 0055 @RaiseAgain 005a @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 89 45 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 30 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 2C 33 C0 5A 59 59 64 89 10 59 5D C3 E9 ?? ?? ?? ?? 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule function_1715_0 {
	meta:
		name = "_NF__4DA"
		size = 35
		refs = "0009 TReader.ReadValue 0017 _NF__542 001c _NF__4D2"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 3A D8 74 0F FF 4E 10 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1716_0 {
	meta:
		name = "TReader.DefineProperty"
		size = 52
		refs = "000f CompareText 002a @LStrClr"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 8B 53 60 8B C6 E8 ?? ?? ?? ?? 85 C0 75 17 66 83 7D 12 00 74 10 8B D3 8B 45 14 FF 55 10 8D 43 60 E8 ?? ?? ?? ?? 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1717_0 {
	meta:
		name = "TReader.DefineBinaryProperty"
		size = 217
		refs = "0015 CompareText 0030 TReader.ReadValue 0042 _NF__542 004e _NF__4D2 0055 _DV_TMemoryStream 005a TObject.Create 0065 TReader.DefineBinaryProperty 007b TReader.Read 00bb TObject.Free 00c1 @HandleFinally 00ce @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 8B DA 89 45 FC 8B 45 FC 8B 50 60 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 85 B1 00 00 00 66 83 7D 12 00 0F 84 A6 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 3C 0A 74 1A 8B 45 FC FF 48 10 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C6 40 5C 01 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F4 B9 04 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 8B 08 FF 11 8B 45 F8 8B 50 04 8B 4D F4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC C6 40 5C 01 8B 55 F8 8B 45 14 FF 55 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 83 C0 60 E8 ?? ?? ?? ?? 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_1718_0 {
	meta:
		name = "TReader.EndOfList"
		size = 20
		refs = "0006 TReader.ReadValue"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 94 C0 FF 4B 10 5B C3 }
	condition:
		$1
}

rule function_1719_0 {
	meta:
		name = "TReader.EndReferences"
		size = 25
		refs = "0006 _NF__4F7 000e TObject.Free"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 30 E8 ?? ?? ?? ?? 33 C0 89 43 30 5B C3 }
	condition:
		$1
}

rule function_1720_0 {
	meta:
		name = "TReader.Error"
		size = 32
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 56 00 74 0D 54 8B D8 8B CA 8B D0 8B 43 58 FF 53 54 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_1721_0 {
	meta:
		name = "TReader.FindMethod"
		size = 102
		refs = "001b @LStrToString 0026 TObject.MethodAddress 0055 _NF__4D2"
	strings:
		$1 = { 53 56 57 81 C4 F8 FE FF FF 8B F1 8B FA 8B D8 8D 44 24 08 8B D6 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 54 24 08 8B 07 E8 ?? ?? ?? ?? 89 04 24 83 3C 24 00 0F 94 44 24 04 66 83 7B 36 00 74 10 54 8D 44 24 08 50 8B CE 8B D3 8B 43 38 FF 53 34 80 7C 24 04 00 74 05 E8 ?? ?? ?? ?? 8B 04 24 81 C4 08 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1722_0 {
	meta:
		name = "_NF__4F2"
		size = 256
		refs = "0015 _NF__4F2 0055 TList.Get 0062 @LStrLAsg 007b TComponent.FindComponent 008e CompareText 00a5 SetOrdProp 00c0 _NF__4F7 00c6 @HandleFinally 00dd @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 2C 85 C0 0F 84 9F 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 78 08 4F 85 FF 7C 6C 47 C7 45 F8 00 00 00 00 8B 45 FC 8B 40 2C 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 8D 45 F4 8B 53 14 E8 ?? ?? ?? ?? 8D 55 F4 8B 45 FC 8B 08 FF 51 18 8B 45 FC 8B 40 18 8B 55 F4 E8 ?? ?? ?? ?? 8B F0 85 F6 75 17 BA ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 75 06 8B 45 FC 8B 70 18 8B 53 0C 8B 43 04 8B CE E8 ?? ?? ?? ?? FF 45 F8 4F 75 9C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 FF FF FF FF 05 00 00 00 4F 57 4E 45 52 00 00 00 }
	condition:
		$1
}

rule function_1723_0 {
	meta:
		name = "TReader.FixupReferences"
		size = 54
		refs = "0008 _NF__4F2 000d GlobalFixupReferences 0025 TList.Get"
	strings:
		$1 = { 53 56 57 8B F8 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 30 8B 58 08 4B 85 DB 7C 16 43 33 F6 8B D6 8B 47 30 E8 ?? ?? ?? ?? 8B 10 FF 52 0C 46 4B 75 ED 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1724_0 {
	meta:
		name = "TReader.FlushBuffer"
		size = 32
		refs = "0006 TReader.GetPosition 0010 TStream.SetPosition"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 43 04 E8 ?? ?? ?? ?? 33 C0 89 43 10 33 C0 89 43 14 5B C3 }
	condition:
		$1
}

rule function_1725_0 {
	meta:
		name = "_NF__4F7"
		size = 59
		refs = "001d TList.Get 0022 TObject.Free"
	strings:
		$1 = { 53 56 57 8B D8 8B 43 2C 85 C0 74 2B 8B 70 08 4E 85 F6 7C 16 46 33 FF 8B D7 8B 43 2C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 47 4E 75 ED 8B 43 2C E8 ?? ?? ?? ?? 33 C0 89 43 2C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1726_0 {
	meta:
		name = "TReader.GetPosition"
		size = 21
		refs = "0007 TStream.GetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 8B 53 14 2B 53 10 2B C2 5B C3 }
	condition:
		$1
}

rule function_1727_0 {
	meta:
		name = "TReader.NextValue"
		size = 15
		refs = "0006 TReader.ReadValue"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? FF 4B 10 5B C3 }
	condition:
		$1
}

rule function_1729_0 {
	meta:
		name = "TReader.Read"
		size = 73
		refs = "0016 _NF__501"
	strings:
		$1 = { 56 57 53 89 D7 89 CB 89 C6 EB 36 8B 4E 14 2B 4E 10 77 0A 89 F0 E8 ?? ?? ?? ?? 8B 4E 14 39 D9 72 02 89 D9 56 29 CB 8B 46 08 03 46 10 01 4E 10 89 C6 89 CA C1 E9 02 FC F3 A5 89 D1 83 E1 03 F3 A4 5E 09 DB 75 C6 5B 5F 5E C3 }
	condition:
		$1
}

rule function_1730_0 {
	meta:
		name = "_NF__501"
		size = 118
		refs = "000d _NF__501 0032 SReadError 0037 LoadResString 0041 _DV_EReadError 0046 Exception.Create 004b @RaiseExcept 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 08 8B 4B 0C 8B 43 04 8B 30 FF 56 04 8B F0 89 73 14 85 F6 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 43 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1731_0 {
	meta:
		name = "TReader.ReadBoolean"
		size = 17
		refs = "0006 TReader.ReadValue"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 09 0F 94 C0 5B C3 }
	condition:
		$1
}

rule function_1732_0 {
	meta:
		name = "TReader.ReadChar"
		size = 129
		refs = "0012 TReader.ReadChar 0021 _NF__4DA 0030 TReader.Read 0044 TReader.ReadStr 0049 _NF__4D2 006d @LStrClr 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 06 8B C3 E8 ?? ?? ?? ?? 8D 55 FF B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8A 45 FF 3C 01 74 12 FF 4B 10 8D 55 F8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 FF B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1733_0 {
	meta:
		name = "TReader.ReadCollection"
		size = 172
		refs = "000f TCollection.BeginUpdate 0017 TReader.ReadCollection 0024 TReader.EndOfList 0030 TCollection.Clear 0039 TReader.NextValue 0046 TReader.ReadInteger 004e TCollection.Add 0057 TReader.ReadListBegin 0062 _NF__523 0074 TReader.ReadListEnd 009b TCollection.EndUpdate 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 4C 8B 45 FC E8 ?? ?? ?? ?? EB 42 8B C3 E8 ?? ?? ?? ?? 04 FE 2C 03 73 07 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 EC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 B3 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1734_0 {
	meta:
		name = "_NF__509"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 08 F6 40 FF 01 75 09 8B 45 08 83 78 F8 00 74 04 33 C0 5D C3 B0 01 5D C3 }
	condition:
		$1
}

rule function_1735_0 {
	meta:
		name = "_NF__50A"
		size = 94
		refs = "000a ExceptObject 0010 _Dn_Exception 0015 @IsClass 0022 _NF__509 002e TObject.Free 003f _NF__54B"
	strings:
		$1 = { 55 8B EC 53 56 8B F0 33 DB E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 3B 8B 45 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 07 8B 06 E8 ?? ?? ?? ?? 33 C0 89 06 8B 45 08 8B 40 F4 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 8B 40 F4 8B 08 FF 51 0C 8B D8 8B C3 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1736_0 {
	meta:
		name = "_NF__50B"
		size = 120
		refs = "000a _NF__50B 0024 _NF__24A 0051 @HandleAnyException 0060 _NF__50A 006a @RaiseAgain 006f @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 EC 8B 45 08 8B 40 F4 8B 40 18 E8 ?? ?? ?? ?? 8B 55 08 8B 52 F4 8B 4A 24 B2 01 FF 50 24 8B 55 08 89 42 F0 8B 45 08 8B 40 F0 80 48 20 01 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 59 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1737_0 {
	meta:
		name = "_NF__50C"
		size = 117
		refs = "000a _NF__50C 0028 @CallDynaInst 004e @HandleAnyException 005d _NF__50A 0067 @RaiseAgain 006c @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F4 8B 50 28 8B 45 08 8B 40 F0 66 BB F9 FF E8 ?? ?? ?? ?? 8B 45 08 8D 48 E8 8B 45 08 8B 50 F0 8B 45 08 8B 40 F4 8B 18 FF 53 14 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 59 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1738_0 {
	meta:
		name = "_NF__50D"
		size = 139
		refs = "000a _NF__50D 0024 _NF__24A 004c @CallDynaInst 0064 @HandleAnyException 0073 _NF__50A 007d @RaiseAgain 0082 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 EC 8B 45 08 8B 40 F4 8B 40 18 E8 ?? ?? ?? ?? 8B C8 8B 45 08 8B 50 E8 8B 45 08 8B 40 F4 8B 18 FF 53 1C 8B 55 08 89 42 F0 8B 45 08 8B 40 F0 66 BB F3 FF E8 ?? ?? ?? ?? 8B 55 08 8B 52 F4 89 42 28 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 59 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1739_0 {
	meta:
		name = "TReader.ReadComponent"
		size = 378
		refs = "0019 TReader.ReadComponent 002d TReader.ReadPrefix 0038 TReader.ReadStr 0072 _NF__50D 007b _NF__50B 00a7 _NF__50C 00bb @TryFinallyExit 00f4 @CallDynaInst 0102 TList.Add 0111 @HandleAnyException 0117 _NF__509 0124 TObject.Free 0129 @RaiseAgain 012e @DoneExcept 014a @HandleFinally 0166 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 33 C9 89 4D EC 89 4D E8 89 55 F8 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D E4 8D 55 FF 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 EC 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 8B 40 28 89 45 E0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 89 45 F0 83 7D F0 00 75 16 F6 45 FF 01 74 09 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 83 7D F0 00 0F 84 A8 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 80 48 20 01 F6 45 FF 01 75 07 55 E8 ?? ?? ?? ?? 59 83 7D F0 00 75 12 33 C0 5A 59 59 64 89 10 E8 ?? ?? ?? ?? E9 8C 00 00 00 8B 45 F0 80 48 20 02 8B 55 F4 8B 45 F0 8B 08 FF 51 14 8B 45 F0 80 60 20 FD F6 45 FF 02 74 15 8B 45 F4 8B 40 28 8B 4D E4 8B 55 F0 66 BB FA FF E8 ?? ?? ?? ?? 8B 45 F4 8B 40 30 8B 55 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 22 E9 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 08 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 8B 55 E0 89 50 28 C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1740_0 {
	meta:
		name = "_NF__511"
		size = 112
		refs = "0016 _DV_TList 001b TObject.Create 0029 _NF__511 0039 _NF__512 0041 _NF__4F2 0056 _NF__4F7 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 83 78 2C 00 75 4F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 2C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5B 59 5D C3 }
	condition:
		$1
}

rule function_1741_0 {
	meta:
		name = "_NF__512"
		size = 208
		refs = "0016 _NF__523 001e TReader.EndOfList 002a TReader.ReadListEnd 0047 @CallDynaInst 0055 _NF__512 008a TReader.ReadComponent 00c3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B F2 89 45 FC EB 0A 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 EA 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 28 89 45 F8 8B 45 FC 8B 40 24 89 45 F4 8B C6 66 BB FB FF E8 ?? ?? ?? ?? 8B 55 FC 89 42 28 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 66 BB FC FF E8 ?? ?? ?? ?? 8B F8 8B 45 FC 89 78 24 85 FF 75 18 8B 45 FC 8B 40 18 8B 55 FC 89 42 24 EB 0A 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 EA 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 55 F8 89 50 28 8B 45 FC 8B 55 F4 89 50 24 C3 E9 ?? ?? ?? ?? EB E6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1742_0 {
	meta:
		name = "TReader.ReadFloat"
		size = 63
		refs = "0009 TReader.ReadValue 001b TReader.Read 0027 TReader.ReadInteger"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 05 75 10 8B D4 B9 0A 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 16 FF 4B 10 8B C3 E8 ?? ?? ?? ?? 89 44 24 0C DB 44 24 0C DB 3C 24 9B DB 2C 24 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1743_0 {
	meta:
		name = "TReader.ReadIdent"
		size = 180
		refs = "000a TReader.ReadValue 002a TReader.Read 0038 @LStrFromPCharLen 003f UniqueString 0056 TReader.ReadIdent 005b @LStrLAsg 007e _NF__4D2"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 2C 07 74 0E FE C8 74 3D FE C8 74 47 2C 04 74 51 EB 5D 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C9 8A 0C 24 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 33 C9 8A 0C 24 8B C3 E8 ?? ?? ?? ?? EB 2F 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 21 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 13 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 5A 5E 5B C3 00 00 FF FF FF FF 05 00 00 00 46 61 6C 73 65 00 00 00 FF FF FF FF 04 00 00 00 54 72 75 65 00 00 00 00 FF FF FF FF 03 00 00 00 6E 69 6C 00 }
	condition:
		$1
}

rule function_1744_0 {
	meta:
		name = "TReader.ReadInteger"
		size = 107
		refs = "0009 TReader.ReadValue 0027 TReader.Read 0060 _NF__4D2"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 E8 ?? ?? ?? ?? 2C 02 74 0A FE C8 74 20 FE C8 74 36 EB 44 8D 54 24 04 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 0F BE 44 24 04 89 04 24 EB 2F 8D 54 24 06 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 0F BF 44 24 06 89 04 24 EB 15 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_1747_0 {
	meta:
		name = "TReader.ReadPrefix"
		size = 64
		refs = "000a TReader.ReadPrefix 0013 TReader.NextValue 0020 TReader.ReadValue 0030 TReader.ReadInteger"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 A0 ?? ?? ?? ?? 88 06 8B C3 E8 ?? ?? ?? ?? 24 F0 3C F0 75 19 8B C3 E8 ?? ?? ?? ?? 24 0F 88 06 F6 06 02 74 09 8B C3 E8 ?? ?? ?? ?? 89 07 5F 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1748_0 {
	meta:
		name = "_NF__521"
		size = 266
		refs = "001b _NF__521 0029 @LStrClr 0035 _DV_TComponent 003a @IsClass 004f @LStrLAsg 0068 TObject.ClassName 0076 @LStrFromString 00bd SPropertyException 00c2 LoadResString 00cf _DV_EReadError 00d4 Exception.CreateFmt 00d9 @RaiseExcept 00ff @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 53 33 D2 89 95 E0 FE FF FF 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8D 45 FC 8B 55 08 8B 52 FC 8B 52 08 E8 ?? ?? ?? ?? 83 7D FC 00 75 21 8D 95 FC FE FF FF 8B 45 08 8B 40 FC 8B 00 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC 89 85 E4 FE FF FF C6 85 E8 FE FF FF 0B 8B 45 08 8B 40 F8 89 85 EC FE FF FF C6 85 F0 FE FF FF 0B 8B 43 04 89 85 F4 FE FF FF C6 85 F8 FE FF FF 0B 8D 85 E4 FE FF FF 50 6A 02 8D 95 E0 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D E0 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E0 FE FF FF E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1749_0 {
	meta:
		name = "_NF__522"
		size = 83
		refs = "0009 _NF__522 001a _NF__542 0022 SInvalidPropertyPath 0027 LoadResString 002f _NF__4D1 0044 @LStrClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1750_0 {
	meta:
		name = "_NF__523"
		size = 466
		refs = "0018 _NF__523 0037 TReader.ReadStr 0052 @LStrLen 0089 @LStrCopy 0097 TObject.ClassInfo 00a2 GetPropInfo 00b0 _NF__4FC 00c8 GetOrdProp 00d4 _DV_TPersistent 00d9 @IsClass 00e3 _NF__522 0118 _NF__527 0153 @HandleOnException 015b _Dn_Exception 0165 _NF__521 016b @DoneExcept 01a5 @RaiseAgain 01bf @LStrClr 01c5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D F8 89 55 FC 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 BB 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B F0 8B 45 FC 89 45 F0 8B 45 F4 C6 40 5C 01 8B FB EB 01 43 3B F3 7C 0A 8B 45 F8 80 7C 18 FF 2E 75 F1 8B 45 F4 83 C0 60 50 8B CB 2B CF 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 3B F3 7C 63 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 8B 55 F4 8B 52 60 E8 ?? ?? ?? ?? 8B F8 85 FF 75 08 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 89 45 EC 8B 07 8B 00 80 38 07 75 0D 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 8B 45 EC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 07 55 E8 ?? ?? ?? ?? 59 8B 45 EC 89 45 F0 43 E9 71 FF FF FF 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 8B 55 F4 8B 52 60 E8 ?? ?? ?? ?? 8B F8 85 FF 74 0F 8B CF 8B 55 F0 8B 45 F4 E8 ?? ?? ?? ?? EB 2A 8B 45 F4 C6 40 5C 00 8B 55 F4 8B 45 F0 8B 08 FF 51 04 8B 45 F4 C6 40 5C 01 8B 45 F4 83 78 60 00 74 08 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1D E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 35 E9 ?? ?? ?? ?? 01 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 89 C3 8B 45 F4 80 78 5C 00 74 0F 8B 53 04 8B 45 F4 8B 08 FF 51 0C 84 C0 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1751_0 {
	meta:
		name = "_NF__525"
		size = 105
		refs = "0013 _NV__230 002a TList.Get 0053 SetOrdProp 005e _NF__4D2"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 4D F4 89 55 F8 89 45 FC A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 3E 46 33 FF 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 F8 8B 00 8B 00 3B 43 04 75 1D 8D 55 F0 8B 45 F4 FF 53 08 84 C0 74 10 8B 4D F0 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? EB 09 47 4E 75 C5 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1752_0 {
	meta:
		name = "_NF__526"
		size = 236
		refs = "0017 _NF__526 0025 @LStrClr 002f @LStrLAsg 003b @LStrPos 0054 @LStrCopy 0086 _NV__4B9 008b _NF__4BC 00a3 TList.Add 00ac _NV__4BB 00cb @LStrArrayClr 00d1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B D9 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 F4 8B D3 E8 ?? ?? ?? ?? 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 26 8D 45 F8 50 8B CE 49 BA 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8D 45 F4 50 8D 56 01 B9 FF FF FF 7F 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 18 50 8B 45 FC 50 8B 45 F8 50 8B 45 F4 50 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 83 7D F8 00 75 12 8B 45 08 8B 40 FC 8B 40 2C 8B D3 E8 ?? ?? ?? ?? EB 0C 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1753_0 {
	meta:
		name = "_NF__527"
		size = 585
		refs = "0019 _NF__527 002f SReadOnlyProperty 0034 LoadResString 003c _NF__4D1 008c TReader.NextValue 009b TReader.ReadIdent 00a8 _NF__525 00b5 TReader.ReadInteger 00c1 SetOrdProp 00ce TReader.ReadChar 00f6 _NF__4D4 010f TReader.ReadFloat 0120 SetFloatProp 0130 TReader.ReadString 013d SetStrProp 014c _NF__531 0177 TReader.ReadValue 019a GetOrdProp 01a4 TReader.ReadCollection 01bf _NF__526 01db _NV__524 01e5 SetMethodProp 0237 @LStrClr 023d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 DB 89 5D EC 8B D9 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B F3 83 7E 08 00 75 15 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B 06 8B 30 33 C0 8A 06 83 F8 0B 0F 87 D5 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 3C 07 75 1D 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 4D EC 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 75 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 5C 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C9 8A C8 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 41 01 00 00 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 55 EC 8B C6 E8 ?? ?? ?? ?? 8B C8 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 1B 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 FD 00 00 00 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 4D EC 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 E0 00 00 00 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B C8 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 C5 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 2C 0D 74 06 FE C8 74 1B EB 37 8B 45 FC E8 ?? ?? ?? ?? 33 C9 8B D3 8B 45 F8 E8 ?? ?? ?? ?? E9 9A 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 7C 55 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 4D EC 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 59 EB 60 8B 45 FC E8 ?? ?? ?? ?? 3C 0D 75 19 8B 45 FC E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D3 8B 45 F8 E8 ?? ?? ?? ?? EB 3B 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 4D EC 8B 45 FC 8B 50 18 8B 45 FC 8B 30 FF 56 10 89 45 F0 8B 45 FC 8B 40 18 89 45 F4 83 7D F0 00 74 0D 8D 4D F0 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1754_0 {
	meta:
		name = "_NF__528"
		size = 112
		refs = "0012 @LStrClr 0018 FindGlobalComponent 0024 @LStrLAsg 0043 _NF__528 0048 Format"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B DA 8B F8 33 F6 8B C3 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 39 8B C3 8B D7 E8 ?? ?? ?? ?? EB 22 46 53 89 7D F0 C6 45 F4 0B 89 75 F8 C6 45 FC 00 8D 55 F0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 FF 15 ?? ?? ?? ?? 85 C0 75 D2 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 05 00 00 00 25 73 5F 25 64 00 00 00 }
	condition:
		$1
}

rule function_1755_0 {
	meta:
		name = "TReader.ReadRootComponent"
		size = 545
		refs = "0019 TReader.ReadRootComponent 0027 TReader.ReadSignature 0048 TReader.ReadPrefix 0059 TReader.ReadStr 0061 FindClass 00c0 _NF__528 00da _NV__277 00f2 _DV_TList 00f7 TObject.Create 011c TList.Add 0181 TList.Get 01ad TObject.Free 01bb @HandleFinally 01c2 GlobalFixupReferences 01d1 @HandleAnyException 01db RemoveFixupReferences 01ee @RaiseAgain 01f3 @DoneExcept 020d @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 33 C9 89 4D E8 89 4D E4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F0 8D 55 EF 8B 45 FC E8 ?? ?? ?? ?? 83 7D F8 00 75 35 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 33 C9 B2 01 FF 50 24 89 45 F4 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F4 8B 08 FF 51 18 EB 48 8B 45 F8 89 45 F4 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 F6 40 20 10 74 0D 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? EB 21 8D 55 E4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E4 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F4 8B 08 FF 51 18 8B 45 FC 8B 55 F4 89 50 18 83 3D ?? ?? ?? ?? 00 74 0E 8B 45 FC 8B 15 ?? ?? ?? ?? 89 50 30 EB 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 30 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 50 18 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 18 8B 55 FC 89 42 24 8B 45 FC 8B 40 18 80 48 20 01 8B 45 FC 8B 40 18 80 48 20 02 8B 45 FC 8B 40 18 8B 55 FC 8B 08 FF 51 14 8B 45 FC 8B 40 18 80 60 20 FD 83 3D ?? ?? ?? ?? 00 75 2F 8B 45 FC 8B 40 30 8B 58 08 4B 85 DB 7C 21 43 C7 45 F0 00 00 00 00 8B 45 FC 8B 40 30 8B 55 F0 E8 ?? ?? ?? ?? 8B 10 FF 52 0C FF 45 F0 4B 75 E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0B 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 50 30 C3 E9 ?? ?? ?? ?? EB DC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 27 E9 ?? ?? ?? ?? 33 D2 8B 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 75 08 8B 45 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F4 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1756_0 {
	meta:
		name = "TReader.ReadComponents"
		size = 137
		refs = "001d TReader.BeginReferences 0025 TReader.ReadComponents 0035 TReader.ReadSignature 003f TReader.ReadComponent 004f TReader.EndOfList 005b TReader.ReadListEnd 0063 TReader.FixupReferences 0078 TReader.EndReferences 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 89 50 18 8B 45 FC 89 50 24 8B 45 FC 89 48 28 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 EB 1A 8B 45 FC E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 DA 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1757_0 {
	meta:
		name = "_NF__531"
		size = 184
		refs = "0016 _NF__531 0032 TReader.ReadValue 003b _NF__4D2 0042 GetTypeData 0054 TReader.ReadStr 0064 _NF__4D4 007d @HandleAnyException 0085 _NF__53D 008a @RaiseAgain 008f @DoneExcept 00a4 @LStrClr 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 3C 0B 74 05 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 40 01 8B 30 33 DB 8D 55 F8 8B 45 FC E8 ?? ?? ?? ?? 83 7D F8 00 74 14 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 83 F8 1F 77 E0 0F AB C3 EB DB 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1758_0 {
	meta:
		name = "TReader.ReadSignature"
		size = 103
		refs = "000f TReader.ReadSignature 0022 TReader.Read 002b _NV__22D 0035 SInvalidImage 003a LoadResString 0042 _NF__4D1 0057 @LStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 33 D2 89 55 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC 3B 05 ?? ?? ?? ?? 74 15 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_1759_0 {
	meta:
		name = "TReader.ReadStr"
		size = 60
		refs = "0011 TReader.Read 001f @LStrFromPCharLen 0026 UniqueString"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 C9 8A 0C 24 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 33 C9 8A 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1760_0 {
	meta:
		name = "TReader.ReadString"
		size = 94
		refs = "000f TReader.ReadValue 0027 TReader.Read 003e _NF__4D2 004a @LStrFromPCharLen"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 33 C0 89 04 24 8B C3 E8 ?? ?? ?? ?? 2C 06 74 06 2C 06 74 12 EB 20 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 15 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C6 8B 0C 24 33 D2 E8 ?? ?? ?? ?? 8B 16 8B 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1761_0 {
	meta:
		name = "TReader.ReadValue"
		size = 18
		refs = "0009 TReader.Read"
	strings:
		$1 = { 51 8B D4 B9 01 00 00 00 E8 ?? ?? ?? ?? 8A 04 24 5A C3 }
	condition:
		$1
}

rule function_1762_0 {
	meta:
		name = "TReader.SetPosition"
		size = 23
		refs = "0007 TStream.SetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 33 C0 89 43 10 33 C0 89 43 14 5B C3 }
	condition:
		$1
}

rule function_1763_0 {
	meta:
		name = "_NF__53D"
		size = 71
		refs = "000c _NF__53D 001c TReader.ReadStr 0037 @LStrClr 003d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 75 F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1764_0 {
	meta:
		name = "_NF__53E"
		size = 40
		refs = "000f _NF__542 0016 TReader.EndOfList 0021 TReader.ReadListEnd"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 C3 FC EB 07 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EE 8B 03 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1765_0 {
	meta:
		name = "_NF__53F"
		size = 84
		refs = "002a TReader.Read"
	strings:
		$1 = { 55 8B EC 81 C4 00 FF FF FF 53 8B D8 85 DB 7E 3F 81 FB 00 01 00 00 7E 1E 8D 95 00 FF FF FF 8B 45 08 8B 40 FC B9 00 01 00 00 E8 ?? ?? ?? ?? 81 EB 00 01 00 00 EB 15 8D 95 00 FF FF FF 8B 45 08 8B 40 FC 8B CB E8 ?? ?? ?? ?? 33 DB 85 DB 7F C1 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1766_0 {
	meta:
		name = "_NF__540"
		size = 39
		refs = "0013 TReader.Read 001f _NF__53F"
	strings:
		$1 = { 55 8B EC 51 8D 55 FC 8B 45 08 8B 40 FC B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_1767_0 {
	meta:
		name = "_NF__541"
		size = 95
		refs = "000f TReader.NextValue 001c _NF__542 002a _NF__53F 0034 _NF__54A 003b TReader.EndOfList 0046 TReader.ReadListEnd"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 C3 FC EB 3E 8B 03 E8 ?? ?? ?? ?? 04 FE 2C 03 73 07 8B 03 E8 ?? ?? ?? ?? 8B 45 08 50 B8 01 00 00 00 E8 ?? ?? ?? ?? 59 EB 07 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EE 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 B7 8B 03 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1768_0 {
	meta:
		name = "_NF__542"
		size = 254
		refs = "0012 _NF__542 0020 TReader.ReadValue 0077 _NF__53E 0085 _NF__53F 00bd TReader.ReadStr 00c5 _NF__540 00d0 _NF__53D 00d8 _NF__541 00ee @LStrClr 00f4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 33 D2 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 83 E0 7F 83 F8 0E 0F 87 AD 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 68 55 E8 ?? ?? ?? ?? 59 EB 5F 55 B8 01 00 00 00 E8 ?? ?? ?? ?? 59 EB 51 55 B8 02 00 00 00 E8 ?? ?? ?? ?? 59 EB 43 55 B8 04 00 00 00 E8 ?? ?? ?? ?? 59 EB 35 55 B8 0A 00 00 00 E8 ?? ?? ?? ?? 59 EB 27 8D 55 F8 8B 45 FC E8 ?? ?? ?? ?? EB 1A 55 E8 ?? ?? ?? ?? 59 EB 11 8B 45 FC E8 ?? ?? ?? ?? EB 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_1769_0 {
	meta:
		name = "_NF__543"
		size = 109
		refs = "0009 _NF__543 001a TReader.ReadValue 0027 TWriter.WriteValue 0035 TReader.ReadStr 0043 TWriter.WriteStr 005e @LStrClr 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 55 FC E8 ?? ?? ?? ?? 83 7D FC 00 75 DE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1770_0 {
	meta:
		name = "_NF__544"
		size = 73
		refs = "0014 TReader.ReadValue 001d TWriter.WriteValue 0028 TReader.CopyValue 002f TReader.EndOfList 003a TReader.ReadListEnd 0041 TWriter.WriteListEnd"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 83 C3 F8 8B 75 08 83 C6 FC 8B 03 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? EB 09 8B 16 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EC 8B 03 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1771_0 {
	meta:
		name = "_NF__545"
		size = 141
		refs = "0036 TReader.Read 004c TWriter.Write"
	strings:
		$1 = { 55 8B EC 50 B8 02 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 45 FC 83 C4 04 53 8B D8 81 FB 00 20 00 00 7E 3A 8D 95 00 E0 FF FF 8B 45 08 8B 40 F8 B9 00 20 00 00 E8 ?? ?? ?? ?? 8D 95 00 E0 FF FF 8B 45 08 8B 40 FC B9 00 20 00 00 E8 ?? ?? ?? ?? 81 EB 00 20 00 00 81 FB 00 20 00 00 7F C6 85 DB 7E 26 8D 95 00 E0 FF FF 8B 45 08 8B 40 F8 8B CB E8 ?? ?? ?? ?? 8D 95 00 E0 FF FF 8B 45 08 8B 40 FC 8B CB E8 ?? ?? ?? ?? 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1772_0 {
	meta:
		name = "_NF__546"
		size = 82
		refs = "000b TReader.ReadValue 0018 TWriter.WriteValue 002b TReader.Read 003e TWriter.Write 004a _NF__545"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 F8 B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 FC B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_1773_0 {
	meta:
		name = "TReader.CopyValue"
		size = 289
		refs = "0015 TReader.CopyValue 0023 TReader.NextValue 007a TReader.ReadValue 0084 TWriter.WriteValue 008c _NF__544 0097 TReader.ReadInteger 00a1 TWriter.WriteInteger 00ab TReader.ReadFloat 00ba TWriter.WriteFloat 00c7 TReader.ReadStr 00d2 TWriter.WriteStr 00df TReader.ReadIdent 00ea TWriter.WriteIdent 00f2 _NF__546 00fb _NF__543 0111 @LStrClr 0117 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 33 C9 89 4D F4 89 55 FC 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 83 E0 7F 83 F8 0E 0F 87 CD 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 76 55 E8 ?? ?? ?? ?? 59 EB 6D 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 59 8B 45 F8 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B 45 FC E8 ?? ?? ?? ?? EB 40 8D 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? EB 28 8D 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? EB 10 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_1774_0 {
	meta:
		name = "_NF__54A"
		size = 72
		refs = "000c _NF__54A 001c TReader.ReadStr 0023 _NF__542 0038 @LStrClr 003e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1775_0 {
	meta:
		name = "_NF__54B"
		size = 155
		refs = "0012 _NF__54B 0029 TReader.ReadPrefix 0033 TReader.ReadStr 0046 _NF__54A 004d TReader.EndOfList 0058 TReader.ReadListEnd 008a @LStrClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 33 C9 89 4D F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 84 D2 74 2A 8D 4D F8 8D 55 FF 8B C3 E8 ?? ?? ?? ?? 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8D 55 F4 8B C3 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 EE 8B C3 E8 ?? ?? ?? ?? EB 09 B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 EC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1776_0 {
	meta:
		name = "TReader.FindAncestorComponent"
		size = 192
		refs = "001b TReader.FindAncestorComponent 002b @LStrLAsg 0036 TComponent.FindComponent 0074 SAncestorNotFound 0079 LoadResString 0083 _DV_EReadError 0088 Exception.CreateFmt 008d @RaiseExcept 00a2 @LStrClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 89 5D F8 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D6 E8 ?? ?? ?? ?? 8B 55 F8 8B 43 18 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 4E 66 83 7B 4E 00 74 10 57 8D 45 FC 50 8B 4D F8 8B D3 8B 43 50 FF 53 4C 83 7D FC 00 75 31 8B 45 F8 89 45 F0 C6 45 F4 0B 8D 45 F0 50 6A 00 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B 45 FC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1777_0 {
	meta:
		name = "TReader.ReferenceName"
		size = 22
	strings:
		$1 = { 53 66 83 78 46 00 74 0C 8B CA 8B D8 8B D0 8B 43 48 FF 53 44 5B C3 }
	condition:
		$1
}

rule function_1778_0 {
	meta:
		name = "TReader.SetName"
		size = 40
	strings:
		$1 = { 53 56 57 8B F1 8B DA 66 83 78 3E 00 74 0D 56 8B F8 8B CB 8B D0 8B 47 40 FF 57 3C 8B 16 8B C3 8B 08 FF 51 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1780_0 {
	meta:
		name = "_NF__55A"
		size = 9
		refs = "0004 TList.Add"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1781_0 {
	meta:
		name = "TWriter.DefineProperty"
		size = 37
		refs = "0014 _NF__5AD"
	strings:
		$1 = { 55 8B EC 53 8B D8 84 C9 74 16 66 83 7D 0A 00 74 0F 8B C3 E8 ?? ?? ?? ?? 8B D3 8B 45 0C FF 55 08 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1782_0 {
	meta:
		name = "TWriter.DefineBinaryProperty"
		size = 42
		refs = "0014 _NF__5AD 0021 TWriter.WriteBinary"
	strings:
		$1 = { 55 8B EC 53 8B D8 84 C9 74 1B 66 83 7D 0A 00 74 14 8B C3 E8 ?? ?? ?? ?? FF 75 0C FF 75 08 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1783_0 {
	meta:
		name = "TWriter.GetPosition"
		size = 16
		refs = "0007 TStream.GetPosition"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 03 43 10 5B C3 }
	condition:
		$1
}

rule function_1785_0 {
	meta:
		name = "TWriter.SetPosition"
		size = 55
		refs = "000a TStream.GetPosition 001e _NF__575 0028 TStream.SetPosition"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 E8 ?? ?? ?? ?? 3B C6 7F 09 8B 53 10 03 D0 3B F2 7E 14 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 2B F0 89 73 10 5E 5B C3 }
	condition:
		$1
}

rule function_1786_0 {
	meta:
		name = "TWriter.Write"
		size = 73
		refs = "0016 _NF__575"
	strings:
		$1 = { 56 57 53 89 D6 89 CB 89 C7 EB 36 8B 4F 0C 2B 4F 10 77 0A 89 F8 E8 ?? ?? ?? ?? 8B 4F 0C 39 D9 72 02 89 D9 29 CB 57 8B 47 08 03 47 10 01 4F 10 89 C7 89 CA C1 E9 02 FC F3 A5 89 D1 83 E1 03 F3 A4 5F 09 DB 75 C6 5B 5F 5E C3 }
	condition:
		$1
}

rule function_1787_0 {
	meta:
		name = "TWriter.WriteBinary"
		size = 134
		refs = "000c _DV_TMemoryStream 0011 TObject.Create 001c TWriter.WriteBinary 0034 TWriter.WriteValue 003c TStream.GetSize 004e TWriter.Write 0073 TObject.Free 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B 45 0C FF 55 08 B2 0A 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 45 F8 8D 55 F8 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 50 04 8B 4D F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1788_0 {
	meta:
		name = "_NF__575"
		size = 24
		refs = "000d TStream.WriteBuffer"
	strings:
		$1 = { 53 8B D8 8B 53 08 8B 4B 10 8B 43 04 E8 ?? ?? ?? ?? 33 C0 89 43 10 5B C3 }
	condition:
		$1
}

rule function_1789_0 {
	meta:
		name = "TWriter.WriteBoolean"
		size = 20
		refs = "0007 TWriter.WriteValue"
	strings:
		$1 = { 84 D2 74 08 B2 09 E8 ?? ?? ?? ?? C3 B2 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1790_0 {
	meta:
		name = "TWriter.WriteChar"
		size = 79
		refs = "000f TWriter.WriteChar 001f @LStrFromChar 0029 TWriter.WriteString 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1791_0 {
	meta:
		name = "TWriter.WriteCollection"
		size = 82
		refs = "000d TWriter.WriteValue 0014 TCollection.GetCount 0025 TWriter.WriteListBegin 002e TCollection.GetItem 0037 _NF__59B 003e TWriter.WriteListEnd"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 B2 0E 8B C3 E8 ?? ?? ?? ?? 8B C5 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 27 46 33 FF 8B C3 E8 ?? ?? ?? ?? 8B D7 8B C5 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 47 4E 75 DC 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1792_0 {
	meta:
		name = "_NF__57F"
		size = 77
		refs = "002a TList.Get 0037 CompareText"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 8B 45 08 8B 40 FC 8B 40 2C 8B 58 08 4B 85 DB 7C 28 43 33 FF 8B 45 08 8B 40 FC 8B 40 2C 8B D7 E8 ?? ?? ?? ?? 8B F0 8B 55 FC 8B 46 08 E8 ?? ?? ?? ?? 85 C0 74 06 47 4B 75 DB 33 F6 8B C6 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1793_0 {
	meta:
		name = "TWriter.WriteComponent"
		size = 57
		refs = "001c _NF__57F"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 80 4B 20 04 8B 45 FC 83 78 2C 00 74 10 55 8B 43 08 E8 ?? ?? ?? ?? 59 8B 55 FC 89 42 1C 8B 55 FC 8B C3 8B 08 FF 51 20 80 63 20 FB 5B 59 5D C3 }
	condition:
		$1
}

rule function_1794_0 {
	meta:
		name = "TWriter.WriteData"
		size = 724
		refs = "001c TWriter.WriteData 0032 TObject.ClassName 0045 @LStrLen 0066 _NF__575 006e TWriter.GetPosition 00b5 TList.Get 00d2 TWriter.WritePrefix 00f3 @LStrFromString 0101 TWriter.WriteStr 014f _NF__59B 0157 TWriter.WriteListEnd 01c5 _DV_TComponent 01ca @IsClass 01d5 _DV_TList 01da TObject.Create 01e9 _NF__55A 01fe @CallDynaInst 0207 TWriter.WriteComponent 0231 TObject.Free 0237 @HandleFinally 02a3 TWriter.SetPosition 02bb @LStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 DC FE FF FF 53 33 C9 89 8D DC FE FF FF 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 95 E0 FE FF FF 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 33 DB 8A 9D E0 FE FF FF 8B 45 F8 8B 40 08 E8 ?? ?? ?? ?? 03 D8 43 83 C3 05 83 C3 03 8B 45 FC 8B 40 0C 8B 55 FC 2B 42 10 3B D8 7E 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 45 F4 A0 ?? ?? ?? ?? 88 45 E3 8B 45 FC 83 78 1C 00 74 04 80 4D E3 01 8B 45 FC 8B 58 2C 85 DB 74 31 8B 45 FC 8B 40 30 3B 43 08 7D 26 8B 45 FC 83 78 1C 00 74 19 8B 45 FC 8B 50 30 8B 45 FC 8B 40 2C E8 ?? ?? ?? ?? 8B 55 FC 3B 42 1C 74 04 80 4D E3 02 8B 45 FC 8B 48 34 8A 55 E3 8B 45 FC E8 ?? ?? ?? ?? 8D 95 E0 FE FF FF 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 8D 95 E0 FE FF FF 8D 85 DC FE FF FF E8 ?? ?? ?? ?? 8B 95 DC FE FF FF 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 50 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC 8B 40 2C 85 C0 74 20 8B 55 FC 8B 52 30 3B 50 08 7D 15 8B 45 FC 83 78 1C 00 74 06 8B 45 FC FF 40 30 8B 45 FC FF 40 34 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 2C 89 45 EC 8B 45 FC 8B 40 30 89 45 E8 8B 45 FC 8B 40 34 89 45 E4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 33 D2 89 50 2C 8B 45 FC 33 D2 89 50 30 8B 45 FC 33 D2 89 50 34 8B 45 FC 80 78 20 00 0F 85 94 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 58 1C 85 DB 74 41 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 30 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 2C 8B 45 FC 50 68 ?? ?? ?? ?? 8B 45 FC 8B 50 24 8B 45 FC 8B 40 1C 66 BB FD FF E8 ?? ?? ?? ?? 8B 45 FC 50 68 ?? ?? ?? ?? 8B 45 FC 8B 50 18 8B 45 F8 66 BB FD FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 2C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 55 EC 89 50 2C 8B 45 FC 8B 55 E8 89 50 30 8B 45 FC 8B 55 E4 89 50 34 C3 E9 ?? ?? ?? ?? EB DD 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 18 3B 45 F8 74 27 A0 ?? ?? ?? ?? 3A 45 E3 75 1D 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F0 83 C2 02 3B C2 75 0B 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 DC FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 00 00 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_1795_0 {
	meta:
		name = "TWriter.WriteDescendent"
		size = 34
		refs = "0012 TWriter.WriteSignature 001b TWriter.WriteComponent"
	strings:
		$1 = { 53 56 8B F2 8B D8 89 4B 24 89 4B 1C 89 73 18 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1796_0 {
	meta:
		name = "TWriter.WriteFloat"
		size = 35
		refs = "000b TWriter.WriteValue 001a TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 B2 05 8B C3 E8 ?? ?? ?? ?? 8D 55 08 B9 0A 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_1797_0 {
	meta:
		name = "TWriter.WriteIdent"
		size = 156
		refs = "0007 TWriter.WriteIdent 000e CompareText 001b TWriter.WriteValue 0066 TWriter.WriteStr"
	strings:
		$1 = { 53 56 8B F2 8B D8 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0C B2 08 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B B2 09 8B C3 E8 ?? ?? ?? ?? EB 2D BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B B2 0D 8B C3 E8 ?? ?? ?? ?? EB 12 B2 07 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 00 00 00 FF FF FF FF 05 00 00 00 46 61 6C 73 65 00 00 00 FF FF FF FF 04 00 00 00 54 72 75 65 00 00 00 00 FF FF FF FF 03 00 00 00 6E 69 6C 00 }
	condition:
		$1
}

rule function_1798_0 {
	meta:
		name = "TWriter.WriteInteger"
		size = 114
		refs = "0018 TWriter.WriteValue 0026 TWriter.Write"
	strings:
		$1 = { 53 51 89 14 24 8B D8 83 3C 24 80 7C 20 83 3C 24 7F 7F 1A B2 02 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 81 3C 24 00 80 FF FF 7C 22 81 3C 24 FF 7F 00 00 7F 19 B2 03 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 17 B2 04 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1801_0 {
	meta:
		name = "TWriter.WritePrefix"
		size = 68
		refs = "000b TWriter.WritePrefix 0029 TWriter.Write 0038 TWriter.WriteInteger"
	strings:
		$1 = { 53 56 51 8B F1 88 14 24 8B D8 A0 ?? ?? ?? ?? 3A 04 24 74 28 8A 04 24 0C F0 88 44 24 01 8D 54 24 01 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? F6 04 24 02 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_1802_0 {
	meta:
		name = "_NF__59B"
		size = 194
		refs = "0015 TObject.ClassInfo 001a GetTypeData 0036 @GetMem 0041 _NF__59B 0059 GetPropInfos 0074 IsStoredProp 0085 _NF__5AC 00a4 @FreeMem 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 55 F8 89 45 FC 8B 45 F8 8B 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BF 40 08 89 45 F4 83 7D F4 00 0F 8E 81 00 00 00 8B 45 F4 C1 E0 02 E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 8B 55 F0 E8 ?? ?? ?? ?? 8B 75 F4 4E 85 F6 7C 28 46 33 FF 8B 45 F0 8B 1C B8 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 74 0D 8B CB 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 47 4E 75 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F4 C1 E2 02 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 55 FC 8B 45 F8 8B 08 FF 51 04 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1803_0 {
	meta:
		name = "_NF__59C"
		size = 74
		refs = "0017 TObject.ClassType"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 83 78 1C 00 74 30 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 3B D8 74 16 8B 45 08 8B 40 F8 8B 55 08 8B 52 FC 3B 42 18 74 05 33 C0 5B 5D C3 B0 01 5B 5D C3 }
	condition:
		$1
}

rule function_1804_0 {
	meta:
		name = "_NF__59D"
		size = 82
		refs = "0009 _NF__59D 0020 @LStrFromString 002e _NF__5AD 0043 @LStrClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 08 8B 52 F4 83 C2 1A E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1805_0 {
	meta:
		name = "_NF__59E"
		size = 147
		refs = "000e _NF__59E 001f GetTypeData 0031 TWriter.WriteValue 004b GetEnumName 0059 TWriter.WriteStr 0081 @LStrClr 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 F0 E8 ?? ?? ?? ?? 8B 40 01 8B 38 8B 45 08 8B 40 FC B2 0B E8 ?? ?? ?? ?? 33 DB 8B C3 83 F8 1F 77 03 0F A3 C6 73 1A 8D 4D FC 8B D3 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 43 83 FB 20 75 D4 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1806_0 {
	meta:
		name = "_NF__59F"
		size = 155
		refs = "0018 _NF__59F 0023 _NV__230 003a TList.Get 005f TWriter.WriteIdent 0073 TWriter.WriteInteger 0088 @LStrClr 008e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 70 08 4E 85 F6 7C 3A 46 33 FF 8B D7 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC 3B 43 04 75 1D 8D 55 F4 8B 45 F8 FF 53 0C 84 C0 74 14 8B 45 08 8B 40 FC 8B 55 F4 E8 ?? ?? ?? ?? EB 12 47 4E 75 C9 8B 45 08 8B 40 FC 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1807_0 {
	meta:
		name = "_NF__5A0"
		size = 161
		refs = "000c _NF__5A0 001b _NF__59D 002d @LStrLAsg 0049 @LStrClr 0056 TWriter.WriteCollection 0074 @LStrAsg 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 E8 ?? ?? ?? ?? 59 8D 45 FC 8B 55 08 8B 52 FC 8B 52 28 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 83 C0 28 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 83 C0 28 8B 55 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1808_0 {
	meta:
		name = "_NF__5A1"
		size = 80
		refs = "000b _NF__59C 002a GetOrdProp"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 25 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 08 3B 42 FC 0F 94 C0 5D C3 8B 45 08 8B 40 FC 8B 55 08 8B 52 08 8B 52 F4 3B 42 14 0F 94 C0 5D C3 }
	condition:
		$1
}

rule function_1809_0 {
	meta:
		name = "_NF__5A2"
		size = 212
		refs = "000f _NF__5A2 0026 GetOrdProp 002f _NF__5A1 003d _NF__59D 006e _NF__59F 007f TWriter.WriteChar 008d _NF__59E 00a1 GetEnumName 00af TWriter.WriteIdent 00c4 @LStrClr 00ca @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 33 C0 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 89 45 FC 55 E8 ?? ?? ?? ?? 59 84 C0 75 7B 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 F0 8A 00 FE C8 74 0E FE C8 74 23 FE C8 74 3E 2C 03 74 2B EB 57 8B 45 08 50 8B 45 08 8B 40 F4 8B 00 8B 00 8B 55 FC E8 ?? ?? ?? ?? 59 EB 3E 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB 2E 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 EB 1F 8D 4D F8 8B 45 08 8B 40 F0 8B 55 FC E8 ?? ?? ?? ?? 8B 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 59 5D C3 }
	condition:
		$1
}

rule function_1810_0 {
	meta:
		name = "_NF__5A3"
		size = 88
		refs = "000b _NF__59C 002a GetFloatProp 0046 _NF__5A3"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 2A 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 45 08 DB 68 F6 DE D9 DF E0 9E 0F 94 C0 5D C3 8B 45 08 DB 68 F6 D8 1D ?? ?? ?? ?? DF E0 9E 0F 94 C0 5D C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1811_0 {
	meta:
		name = "_NF__5A4"
		size = 74
		refs = "0013 GetFloatProp 001d _NF__5A3 002b _NF__59D 0042 TWriter.WriteFloat"
	strings:
		$1 = { 55 8B EC 83 C4 F4 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? DB 7D F6 9B 55 E8 ?? ?? ?? ?? 59 84 C0 75 20 8B 45 08 50 E8 ?? ?? ?? ?? 59 66 8B 45 FE 50 FF 75 FA FF 75 F6 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_1812_0 {
	meta:
		name = "_NF__5A5"
		size = 130
		refs = "000a _NF__5A5 001c _NF__59C 003e GetStrProp 004c @LStrCmp 0070 @LStrClr 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 30 8D 4D FC 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 0F 94 C3 EB 0A 8B 45 08 83 78 FC 00 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1813_0 {
	meta:
		name = "_NF__5A6"
		size = 106
		refs = "0009 _NF__5A6 0023 GetStrProp 0029 _NF__5A5 0037 _NF__59D 0046 TWriter.WriteString 005b @LStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 75 18 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1814_0 {
	meta:
		name = "_NF__5A7"
		size = 143
		refs = "000e _NF__59C 002d GetOrdProp 0075 CompareText"
	strings:
		$1 = { 55 8B EC 53 33 DB 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 6C 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B D8 85 DB 74 4C 8B 43 04 8B 55 08 8B 52 08 8B 52 FC 3B 42 24 75 3B 8B 45 08 83 78 FC 00 74 32 8B 45 08 8B 40 FC 8B 40 04 8B 55 08 8B 52 08 8B 52 FC 3B 42 18 75 1B 8B 45 08 8B 40 FC 8B 50 08 8B 43 08 E8 ?? ?? ?? ?? 85 C0 75 06 8B 45 08 8B 58 FC 8B 45 08 3B 58 FC 0F 94 C0 5B 5D C3 }
	condition:
		$1
}

rule function_1815_0 {
	meta:
		name = "_NF__5A8"
		size = 160
		refs = "0023 @LStrLAsg 0036 _NF__5A8 0058 @LStrCatN 0069 @LStrCat3"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 8B 45 08 8B 40 08 8B 40 FC 8B 40 18 8B 7B 04 3B C7 75 0C 8B C6 8B 53 08 E8 ?? ?? ?? ?? EB 44 8B 55 08 8B 52 08 3B C3 75 0E 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2C 85 FF 74 19 FF 77 08 68 ?? ?? ?? ?? FF 73 08 8B C6 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 0F 8B C6 B9 ?? ?? ?? ?? 8B 53 08 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 00 00 FF FF FF FF 05 00 00 00 4F 77 6E 65 72 00 00 00 FF FF FF FF 01 00 00 00 2E 00 00 00 FF FF FF FF 06 00 00 00 2E 4F 77 6E 65 72 00 00 }
	condition:
		$1
}

rule function_1816_0 {
	meta:
		name = "_NF__5A9"
		size = 548
		refs = "000e _NF__5A9 0025 GetOrdProp 0034 _NF__5A7 0042 _NF__59D 0050 TWriter.WriteValue 005e _DV_TPersistent 0063 @IsClass 0074 _DV_TComponent 0098 _NF__5A8 00a4 @LStrLAsg 00c6 TWriter.WriteIdent 00d4 _DV_TCollection 00e6 _NF__59C 0109 CollectionsEqual 011d _NF__5A0 0168 @LStrFromString 0183 @LStrCatN 01bc _NF__59B 01e6 @LStrAsg 01ec @HandleFinally 0208 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 27 55 E8 ?? ?? ?? ?? 59 84 C0 75 1C 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC B2 0D E8 ?? ?? ?? ?? E9 99 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 83 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4E 55 E8 ?? ?? ?? ?? 59 84 C0 0F 85 62 01 00 00 55 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 59 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 83 7D F0 00 0F 84 40 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC 8B 55 F0 E8 ?? ?? ?? ?? E9 23 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 46 8B 45 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 26 8B 45 08 8B 50 F4 8B 45 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 84 C0 0F 85 DD 00 00 00 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 E9 CB 00 00 00 8B 45 08 8B 40 FC 8B 40 1C 89 45 F8 8D 45 F4 8B 55 08 8B 52 FC 8B 52 28 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC FF 70 28 8D 45 EC 8B 55 08 8B 52 F4 83 C2 1A E8 ?? ?? ?? ?? FF 75 EC 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 83 C0 28 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 1D 8B 45 08 8B 50 F4 8B 45 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 55 08 8B 52 FC 89 42 1C 8B 45 08 8B 40 FC 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 55 F8 89 50 1C 8B 45 08 8B 40 FC 83 C0 28 8B 55 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B E5 5D C3 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1817_0 {
	meta:
		name = "_NF__5AA"
		size = 131
		refs = "0015 _NF__59C 0037 GetMethodProp 006a TObject.MethodName"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 33 DB 8B 45 08 8B 40 08 50 E8 ?? ?? ?? ?? 59 84 C0 74 20 8D 4D F8 8B 45 08 8B 40 08 8B 50 F4 8B 45 08 8B 40 08 8B 40 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 5D F8 8B 45 08 3B 58 F8 74 35 8B 45 08 8B 70 F8 85 F6 74 27 8D 8D F8 FE FF FF 8B 45 08 8B D6 8B 45 08 8B 40 08 8B 40 FC 8B 40 18 8B 00 E8 ?? ?? ?? ?? 80 BD F8 FE FF FF 00 74 04 33 C0 EB 02 B0 01 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1818_0 {
	meta:
		name = "_NF__5AB"
		size = 178
		refs = "0013 _NF__5AB 002d GetMethodProp 0033 _NF__5AA 0041 _NF__59D 0056 TWriter.WriteValue 0070 TObject.MethodName 007e @LStrFromString 008c TWriter.WriteIdent 00a1 @LStrClr 00a7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 33 C0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 75 54 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 5D F8 85 DB 75 0F 8B 45 08 8B 40 FC B2 0D E8 ?? ?? ?? ?? EB 34 8D 8D F4 FE FF FF 8B 45 08 8B 40 FC 8B 40 18 8B 00 8B D3 E8 ?? ?? ?? ?? 8D 95 F4 FE FF FF 8D 45 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1819_0 {
	meta:
		name = "_NF__5AC"
		size = 138
		refs = "002c _NF__5AC 005d _NF__5A2 0066 _NF__5A4 006f _NF__5A6 0078 _NF__5A9 0081 _NF__5AB"
	strings:
		$1 = { 55 8B EC 83 C4 F0 89 4D F4 89 55 F8 89 45 FC 8B 45 F4 83 78 08 00 74 6E 8B 00 8B 00 89 45 F0 8B 45 F0 0F B6 00 83 F8 0B 77 5C 8A 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 00 01 01 01 02 03 01 04 05 00 03 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 EB 22 55 E8 ?? ?? ?? ?? 59 EB 19 55 E8 ?? ?? ?? ?? 59 EB 10 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 8B E5 5D C3 }
	condition:
		$1
}

rule function_1820_0 {
	meta:
		name = "_NF__5AD"
		size = 82
		refs = "000f _NF__5AD 0022 @LStrCat3 002c TWriter.WriteStr 0041 @LStrClr 0047 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B CE 8B 53 28 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1822_0 {
	meta:
		name = "TWriter.WriteSignature"
		size = 16
		refs = "0001 _NV__22D 000b TWriter.Write"
	strings:
		$1 = { BA ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1823_0 {
	meta:
		name = "TWriter.WriteStr"
		size = 70
		refs = "000a @LStrLen 002b TWriter.Write 0032 @LStrToPChar"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 89 04 24 81 3C 24 FF 00 00 00 7E 07 C7 04 24 FF 00 00 00 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1824_0 {
	meta:
		name = "TWriter.WriteString"
		size = 90
		refs = "000a @LStrLen 001f TWriter.WriteValue 002d TWriter.Write"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 89 04 24 81 3C 24 FF 00 00 00 7F 19 B2 06 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 01 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 17 B2 0C 8B C3 E8 ?? ?? ?? ?? 8B D4 B9 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 0C 24 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1825_0 {
	meta:
		name = "TWriter.WriteValue"
		size = 18
		refs = "000c TWriter.Write"
	strings:
		$1 = { 51 88 14 24 8B D4 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_1826_0 {
	meta:
		name = "_NF__5BC"
		size = 60
		refs = "0025 _NF__5BC"
	strings:
		$1 = { 56 57 89 C6 89 D7 BA 00 00 00 00 EB 10 30 31 32 33 34 35 36 37 38 39 41 42 43 44 45 46 AC 88 C2 80 E2 0F 8A A2 ?? ?? ?? ?? 88 C2 C0 EA 04 8A 82 ?? ?? ?? ?? 66 AB 49 75 E4 5F 5E C3 }
	condition:
		$1
}

rule function_1827_0 {
	meta:
		name = "_NF__5BD"
		size = 136
		refs = "0057 _NF__5BD"
	strings:
		$1 = { 56 57 53 89 C6 89 D7 89 D3 BA 00 00 00 00 EB 37 00 01 02 03 04 05 06 07 08 09 FF FF FF FF FF FF FF 0A 0B 0C 0D 0E 0F FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 0A 0B 0C 0D 0E 0F 66 AD 80 F8 30 72 32 80 F8 66 77 2D 88 C2 8A 82 ?? ?? ?? ?? 80 F8 FF 74 20 C0 E0 04 80 FC 30 72 18 80 FC 66 77 13 88 E2 8A A2 ?? ?? ?? ?? 80 FC FF 74 06 08 E0 AA 49 75 C7 89 F8 29 D8 5B 5F 5E C3 }
	condition:
		$1
}

rule function_1828_0 {
	meta:
		name = "TParser.Create"
		size = 106
		refs = "000b @ClassCreate 001c @GetMem 0052 TParser.NextToken"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 89 4F 04 B8 00 10 00 00 E8 ?? ?? ?? ?? 8B F0 89 77 0C C6 06 00 89 77 10 8B 47 0C 05 00 10 00 00 89 47 14 8B 47 0C 89 47 18 8B 47 0C 89 47 1C 8B 47 0C 89 47 20 C7 47 28 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1829_0 {
	meta:
		name = "TParser.Destroy"
		size = 56
		refs = "0023 @FreeMem 002e @ClassDestroy"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 83 7E 0C 00 74 1A 8B 56 20 2B 56 10 66 B9 01 00 8B 46 04 8B 38 FF 57 0C 8B 46 0C E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1830_0 {
	meta:
		name = "TParser.CheckToken"
		size = 198
		refs = "0015 TParser.CheckToken 0039 SIdentifierExpected 003e LoadResString 0048 TParser.Error 0052 SStringExpected 006b SNumberExpected 0086 SCharExpected 009f TParser.ErrorFmt 00b4 @LStrClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 5E 2D 74 7F 8B C3 FE C8 74 0B FE C8 74 20 48 2C 02 72 34 EB 4B 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 55 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 3C 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 23 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 88 5D F4 C6 45 F8 02 8D 4D F4 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1831_0 {
	meta:
		name = "TParser.CheckTokenSymbol"
		size = 116
		refs = "0015 TParser.CheckTokenSymbol 0024 TParser.TokenSymbolIs 0032 SSymbolExpected 0037 LoadResString 004d TParser.ErrorFmt 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 75 25 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 89 75 F4 C6 45 F8 0B 8D 4D F4 8B C3 5A E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3779_0 {
	meta:
		name = "TCopyParser.CheckTokenSymbol"
		size = 116
		refs = "0015 TCopyParser.CheckTokenSymbol 0024 TCopyParser.TokenSymbolIs 0032 SSymbolExpected 0037 LoadResString 004d TCopyParser.ErrorFmt 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 75 25 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 89 75 F4 C6 45 F8 0B 8D 4D F4 8B C3 5A E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1833_0 {
	meta:
		name = "TParser.ErrorFmt"
		size = 91
		refs = "0012 TParser.ErrorFmt 0028 Format 0032 TParser.ErrorStr 0047 @LStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8B D7 8B 4D 08 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_3790_0 {
	meta:
		name = "TCopyParser.ErrorFmt"
		size = 91
		refs = "0012 TCopyParser.ErrorFmt 0028 Format 0032 TCopyParser.ErrorStr 0047 @LStrClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8B D7 8B 4D 08 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1834_0 {
	meta:
		name = "TParser.ErrorStr"
		size = 122
		refs = "0015 TParser.ErrorStr 003a SParseError 003f LoadResString 0049 _DV_EParserError 004e Exception.CreateFmt 0053 @RaiseExcept 0068 @LStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 89 75 F0 C6 45 F4 0B 8B 43 28 89 45 F8 C6 45 FC 00 8D 45 F0 50 6A 01 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1835_0 {
	meta:
		name = "TParser.HexToBinary"
		size = 183
		refs = "001d TParser.HexToBinary 002a _NF__5DC 003c _NF__5BD 004d SInvalidBinary 0052 LoadResString 005f TParser.Error 008c TParser.NextToken 00a4 @LStrClr 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FE FF FF 53 56 57 33 C9 89 8D F8 FE FF FF 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? EB 51 8D 95 FC FE FF FF B9 00 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 75 1D 8D 95 F8 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 F8 FE FF FF 8B C3 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B CE 8B 45 FC 8B 38 FF 57 08 8B C6 03 C0 01 43 18 8B C3 E8 ?? ?? ?? ?? 8B 43 18 80 38 7D 75 A7 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F8 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1836_0 {
	meta:
		name = "TParser.NextToken"
		size = 415
		refs = "0014 TParser.NextToken 0021 _NF__5DC 00e7 SInvalidString 00ec LoadResString 00f6 TParser.Error 0189 @LStrClr 018f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 8B 5E 18 89 5E 20 33 C0 8A 03 83 F8 30 7D 1F 83 E8 23 74 64 48 0F 84 D3 00 00 00 83 E8 03 74 58 83 E8 06 0F 84 E3 00 00 00 E9 10 01 00 00 83 C0 D0 83 E8 0A 0F 82 D2 00 00 00 83 C0 F9 83 E8 1A 72 11 83 E8 04 74 0C 83 C0 FE 83 E8 1A 0F 83 EB 00 00 00 43 EB 01 43 8A 03 04 D0 2C 0A 72 F7 04 F9 2C 1A 72 F1 2C 04 74 ED 04 FE 2C 1A 72 E7 C6 45 FF 01 E9 D2 00 00 00 8B FB 8A 03 2C 23 74 06 2C 04 74 25 EB 5F 43 33 C0 EB 0F 03 C0 8D 04 80 33 D2 8A 13 83 EA 30 03 C2 43 8A 13 80 C2 D0 80 EA 0A 72 E7 88 07 47 EB D1 43 8A 03 2C 01 72 0E 2C 09 74 0A 2C 03 74 06 2C 1A 74 1B EB 1F 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 06 43 80 3B 27 75 9D 8A 03 88 07 47 43 EB C5 89 7E 24 C6 45 FF 02 EB 5C 43 EB 01 43 8A 03 04 D0 2C 0A 72 F7 04 F9 2C 06 72 F1 04 E6 2C 06 72 EB C6 45 FF 03 EB 3E 43 EB 01 43 8A 03 04 D0 2C 0A 72 F7 C6 45 FF 03 EB 05 43 C6 45 FF 04 8A 03 2C 2B 74 F5 04 FE 2C 02 72 EF 48 2C 0A 72 EA 2C 0B 74 E6 2C 20 74 E2 EB 0C 8A 03 88 45 FF 80 7D FF 00 74 01 43 89 5E 18 8A 45 FF 88 46 2D 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8A 45 FF 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1837_0 {
	meta:
		name = "_NF__5DB"
		size = 199
		refs = "000e _NF__5DB 003b Move 0071 LineStart 0083 SLineTooLong 0088 LoadResString 0092 TParser.Error 00b5 @LStrClr 00bb @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 18 2B 43 0C 01 43 08 8B 43 1C 8A 53 2C 88 10 8B 73 10 8B 43 18 2B F0 85 F6 74 0A 8B 53 0C 8B CE E8 ?? ?? ?? ?? 03 73 0C 89 73 10 8B 4B 14 2B 4B 10 8B 53 10 8B 43 04 8B 30 FF 56 04 01 43 10 8B 43 0C 89 43 18 8B 73 10 89 73 1C 3B 73 14 75 2C 8B D6 4A 8B 43 0C E8 ?? ?? ?? ?? 8B F8 89 7B 1C 3B 7B 0C 75 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 43 1C 8A 00 88 43 2C 8B 43 1C C6 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1838_0 {
	meta:
		name = "_NF__5DC"
		size = 51
		refs = "001b _NF__5DB"
	strings:
		$1 = { 53 8B D8 8B 43 18 8A 00 2C 01 72 0C 2C 09 74 19 04 E9 2C DF 72 1B EB 14 8B C3 E8 ?? ?? ?? ?? 8B 43 18 80 38 00 74 0A EB DA FF 43 28 FF 43 18 EB D2 5B C3 }
	condition:
		$1
}

rule function_1839_0 {
	meta:
		name = "TParser.SourcePos"
		size = 12
	strings:
		$1 = { 8B 50 20 2B 50 0C 03 50 08 8B C2 C3 }
	condition:
		$1
}

rule function_1840_0 {
	meta:
		name = "TParser.TokenFloat"
		size = 87
		refs = "0012 TParser.TokenFloat 0022 TParser.TokenString 002a StrToFloat 0043 @LStrClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F0 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? DB 7D F6 9B 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DB 6D F6 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3803_0 {
	meta:
		name = "TCopyParser.TokenFloat"
		size = 87
		refs = "0012 TCopyParser.TokenFloat 0022 TCopyParser.TokenString 002a StrToFloat 0043 @LStrClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F0 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? DB 7D F6 9B 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DB 6D F6 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1841_0 {
	meta:
		name = "TParser.TokenInt"
		size = 77
		refs = "000c TParser.TokenInt 001c TParser.TokenString 0024 StrToInt 003b @LStrClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_3804_0 {
	meta:
		name = "TCopyParser.TokenInt"
		size = 77
		refs = "000c TCopyParser.TokenInt 001c TCopyParser.TokenString 0024 StrToInt 003b @LStrClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_9302_0 {
	meta:
		name = "TCustomMaskEdit.GetTextLen"
		size = 77
		refs = "000c TCustomMaskEdit.GetTextLen 001c TCustomMaskEdit.GetText 0024 @LStrLen 003b @LStrClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1842_0 {
	meta:
		name = "TParser.TokenString"
		size = 30
		refs = "0019 @LStrFromPCharLen"
	strings:
		$1 = { 80 78 2D 02 75 08 8B 48 24 2B 48 20 EB 06 8B 48 18 2B 48 20 8B 40 20 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1843_0 {
	meta:
		name = "TParser.TokenSymbolIs"
		size = 99
		refs = "000f TParser.TokenSymbolIs 0025 TParser.TokenString 002f CompareText 0050 @LStrClr 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7B 2D 01 75 18 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1844_0 {
	meta:
		name = "TParser.TokenComponentIdent"
		size = 159
		refs = "0010 TParser.TokenComponentIdent 001f TParser.CheckToken 003f SIdentifierExpected 0044 LoadResString 004e TParser.Error 0078 TParser.TokenString 008d @LStrClr 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 8B C6 E8 ?? ?? ?? ?? 8B 5E 18 EB 43 43 8A 03 04 BF 2C 1A 72 21 2C 04 74 1D 04 FE 2C 1A 72 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 43 8A 03 04 D0 2C 0A 72 F7 04 F9 2C 1A 72 F1 2C 04 74 ED 04 FE 2C 1A 72 E7 80 3B 2E 74 B8 89 5E 18 8B D7 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1845_0 {
	meta:
		name = "_NF__5EB"
		size = 41
		refs = "000f _NV__5EA 001f TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 58 FC 85 DB 7E 18 BA ?? ?? ?? ?? 8B 45 08 8B 40 F8 B9 02 00 00 00 E8 ?? ?? ?? ?? 4B 75 E8 5B 5D C3 }
	condition:
		$1
}

rule function_1846_0 {
	meta:
		name = "_NF__5EC"
		size = 38
		refs = "0009 @LStrLen 0011 @LStrToPChar 001f TWriter.Write"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 F8 59 E8 ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule function_1847_0 {
	meta:
		name = "_NF__5ED"
		size = 44
		refs = "0008 _NF__5ED 000d _NF__5EC 0017 _NF__5EB"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 5D C3 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_1848_0 {
	meta:
		name = "_NF__5EE"
		size = 372
		refs = "000e _NF__5EE 0025 TReader.ReadPrefix 0033 TReader.ReadStr 004a _NF__5EB 005f _NF__5EC 00c4 IntToStr 0100 @LStrClr 010d @LStrArrayClr 0113 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F0 8D 55 F7 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 F6 45 F7 01 74 11 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 0F 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 83 7D F8 00 74 1C 8B 45 08 50 8B 45 F8 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 FC E8 ?? ?? ?? ?? 59 F6 45 F7 02 74 36 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8D 55 EC 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 8B E5 5D C3 00 00 00 FF FF FF FF 0A 00 00 00 69 6E 68 65 72 69 74 65 64 20 00 00 FF FF FF FF 07 00 00 00 6F 62 6A 65 63 74 20 00 FF FF FF FF 02 00 00 00 3A 20 00 00 FF FF FF FF 02 00 00 00 20 5B 00 00 FF FF FF FF 01 00 00 00 5D 00 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_1849_0 {
	meta:
		name = "_NF__5EF"
		size = 208
		refs = "0013 TReader.ReadValue 001c _NF__5EF 0021 _NF__5EC 003a TReader.Read 0052 _NF__5ED 007e _NF__5BC 0090 TWriter.Write"
	strings:
		$1 = { 55 8B EC 83 C4 9C 53 56 57 8D 7D FC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC 8B D7 8B 45 08 8B 40 F4 B9 04 00 00 00 E8 ?? ?? ?? ?? 83 3F 20 0F 9D C3 83 3F 00 7E 52 84 DB 74 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 83 3F 20 7C 07 BE 20 00 00 00 EB 02 8B 37 8D 55 DC 8B 45 08 8B 40 F4 8B CE E8 ?? ?? ?? ?? 8D 55 9C 8D 45 DC 8B CE E8 ?? ?? ?? ?? 8B CE 03 C9 8D 55 9C 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 29 37 83 3F 00 7F AE 8B 45 08 FF 48 FC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 00 FF FF FF FF 01 00 00 00 7B 00 00 00 FF FF FF FF 01 00 00 00 7D 00 00 00 }
	condition:
		$1
}

rule function_1850_0 {
	meta:
		name = "_NF__5F0"
		size = 1220
		refs = "0016 _NF__5F0 0023 TReader.NextValue 0079 TReader.ReadValue 0087 _NF__5EC 0099 _NF__5ED 00ab TReader.EndOfList 00b6 TReader.ReadListEnd 00db TReader.ReadInteger 00e3 IntToStr 00fc TReader.ReadFloat 010b FloatToStr 0123 TReader.ReadString 012b @LStrLen 01bd UniqueString 01d4 TWriter.Write 025b @HandleFinally 026b TReader.ReadIdent 0282 _NF__5EF 02aa TReader.ReadStr 036e _NF__4DA 037f _NF__5F1 03a1 _NF__5EB 03f6 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B 75 08 83 C6 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 06 E8 ?? ?? ?? ?? 83 E0 7F 83 F8 0E 0F 87 AD 03 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC EB 14 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 06 E8 ?? ?? ?? ?? 84 C0 74 E1 8B 06 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 0C 03 00 00 8B 45 08 50 8B 06 E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 59 E9 EB 02 00 00 8B 45 08 50 8B 06 E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 59 E9 C3 02 00 00 8D 55 F8 8B 06 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B F0 85 F6 75 14 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 97 02 00 00 BB 01 00 00 00 8B 45 08 FF 40 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 83 FE 40 7E 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B FB 8B 45 F8 8A 44 18 FF 3C 20 72 6B 8B 55 F8 3C 27 74 64 89 5D FC 43 3B F3 7C 1D 8B 45 F8 80 7C 18 FF 20 72 13 8B 45 F8 80 7C 18 FF 27 74 09 8B C3 2B C7 83 F8 40 7C DE 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 FC 8D 54 10 FF 8B CB 2B 4D FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 2D 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 F8 0F B6 44 18 FF 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 59 43 8B C3 2B C7 83 F8 40 7C 1F 3B F3 7E 1B 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B FB 3B F3 0F 8D 2D FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 FF 48 FC C3 E9 ?? ?? ?? ?? EB F2 8B 45 08 50 8D 55 F4 8B 06 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 59 E9 63 01 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 59 E9 54 01 00 00 8B 06 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 DB 8D 55 F8 8B 06 E8 ?? ?? ?? ?? 83 7D F8 00 74 23 85 DB 7E 0F 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 8B 45 F8 E8 ?? ?? ?? ?? 59 43 EB CD 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E9 F5 00 00 00 8B 06 E8 ?? ?? ?? ?? 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC E9 A9 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 06 E8 ?? ?? ?? ?? 04 FE 2C 03 73 28 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 06 B2 01 E8 ?? ?? ?? ?? 8B 45 08 FF 40 FC EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 06 E8 ?? ?? ?? ?? 84 C0 74 EB 8B 06 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 06 E8 ?? ?? ?? ?? 84 C0 0F 84 48 FF FF FF 8B 06 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 FF FF FF FF 01 00 00 00 28 00 00 00 FF FF FF FF 01 00 00 00 29 00 00 00 FF FF FF FF 02 00 00 00 27 27 00 00 FF FF FF FF 01 00 00 00 27 00 00 00 FF FF FF FF 01 00 00 00 23 00 00 00 FF FF FF FF 02 00 00 00 20 2B 00 00 FF FF FF FF 01 00 00 00 5B 00 00 00 FF FF FF FF 02 00 00 00 2C 20 00 00 FF FF FF FF 01 00 00 00 5D 00 00 00 FF FF FF FF 01 00 00 00 3C 00 00 00 FF FF FF FF 04 00 00 00 69 74 65 6D 00 00 00 00 FF FF FF FF 02 00 00 00 20 5B 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 FF FF FF FF 03 00 00 00 65 6E 64 00 FF FF FF FF 01 00 00 00 3E 00 00 00 }
	condition:
		$1
}

rule function_1851_0 {
	meta:
		name = "_NF__5F1"
		size = 152
		refs = "0009 _NF__5F1 0018 _NF__5EB 002b TReader.ReadStr 0033 _NF__5EC 004c _NF__5F0 0071 @LStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 8D 55 FC 8B 45 08 8B 40 F4 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 FF FF FF FF 03 00 00 00 20 3D 20 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_1852_0 {
	meta:
		name = "_NF__5F2"
		size = 136
		refs = "000f _NF__5EE 0021 _NF__5F1 0029 TReader.EndOfList 0034 TReader.ReadListEnd 003f _NF__5F2 0061 _NF__5EB 0070 _NF__5EC"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 83 C3 F4 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 FF 40 FC EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EB 8B 03 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 03 E8 ?? ?? ?? ?? 84 C0 74 EB 8B 03 E8 ?? ?? ?? ?? 8B 45 08 FF 48 FC 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5B 5D C3 FF FF FF FF 05 00 00 00 65 6E 64 0D 0A 00 00 00 }
	condition:
		$1
}

rule function_1853_0 {
	meta:
		name = "ObjectBinaryToText"
		size = 196
		refs = "001b _DV_TReader 0020 TFiler.Create 0028 DecimalSeparator 003d ObjectBinaryToText 0051 _DV_TWriter 006f TReader.ReadSignature 0075 _NF__5F2 008b TObject.Free 0091 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B F2 8B D8 33 C0 89 45 FC 68 00 10 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 A1 ?? ?? ?? ?? 8A 00 88 45 F3 A1 ?? ?? ?? ?? C6 00 2E 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 55 F3 88 10 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1854_0 {
	meta:
		name = "_NF__5F6"
		size = 96
		refs = "001a TParser.NextToken 0027 TParser.CheckToken 0032 TParser.TokenInt"
	strings:
		$1 = { 55 8B EC 53 83 CB FF 8B 45 08 8B 40 FC 80 78 2D 5B 75 48 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 03 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 5D E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_1855_0 {
	meta:
		name = "_NF__5F7"
		size = 260
		refs = "0012 _NF__5F7 0025 TParser.CheckToken 0033 TParser.TokenString 003b @LStrClr 0046 TParser.NextToken 006d @LStrLAsg 0095 _NF__5F6 00b7 TWriter.WritePrefix 00c5 TWriter.WriteStr 00ed @LStrArrayClr 00f3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 88 45 FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 3C 3A 75 3C 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8D 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8A 1D ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B F0 80 7D FF 00 74 03 80 CB 01 85 F6 7E 03 80 CB 02 8B 45 08 8B 40 F8 8B CE 8B D3 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 55 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_1856_0 {
	meta:
		name = "_NF__5F8"
		size = 124
		refs = "0016 _NF__5F8 0025 TParser.TokenString 002e TParser.NextToken 0037 TParser.CheckToken 004b @LStrCat 006b @LStrClr 0071 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 8B 75 08 8B 76 08 83 C6 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 06 E8 ?? ?? ?? ?? EB 24 8B 06 E8 ?? ?? ?? ?? 8B 06 B2 02 E8 ?? ?? ?? ?? 8D 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 3C 2B 74 D1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1857_0 {
	meta:
		name = "_NF__5F9"
		size = 720
		refs = "0009 _NF__5F9 0025 _NF__5F8 0034 TWriter.WriteString 0086 TParser.TokenComponentIdent 0094 TWriter.WriteIdent 00a4 TParser.TokenInt 00b1 TWriter.WriteInteger 00c1 TParser.TokenFloat 00d3 TWriter.WriteFloat 00e3 TParser.NextToken 00f0 TWriter.WriteValue 0109 TParser.CheckToken 0117 TParser.TokenString 0125 TWriter.WriteStr 0176 TWriter.WriteListBegin 0199 TWriter.WriteListEnd 01aa TParser.HexToBinary 01b5 TWriter.WriteBinary 01e4 TParser.CheckTokenSymbol 01f8 _NF__5F6 0220 _NF__5FA 0231 TParser.TokenSymbolIs 0270 SInvalidProperty 0275 LoadResString 0283 TParser.Error 02a3 @LStrClr 02a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8A 40 2D 3C 02 75 1D 55 8D 45 FC E8 ?? ?? ?? ?? 59 8B 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 55 02 00 00 8B 55 08 25 FF 00 00 00 83 F8 28 7F 16 0F 84 14 01 00 00 48 74 29 83 E8 02 74 45 48 74 5F E9 0C 02 00 00 83 E8 3C 0F 84 55 01 00 00 83 E8 1F 74 6E 83 E8 20 0F 84 2B 01 00 00 E9 F0 01 00 00 8D 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 EA 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 CD 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 83 C4 F4 DB 3C 24 9B 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 AB 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 B2 0B E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 80 78 2D 5D 74 52 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8D 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 3C 5D 74 1A 8B 45 08 8B 40 FC B2 2C E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB AE 8B 45 08 8B 40 F8 33 D2 E8 ?? ?? ?? ?? E9 23 01 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC 80 78 2D 29 75 EA 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 E5 00 00 00 8B 45 08 8B 40 FC 50 68 ?? ?? ?? ?? 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? E9 C9 00 00 00 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 B2 0E E8 ?? ?? ?? ?? EB 77 8B 45 08 8B 40 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 0C 8B 55 08 8B 52 F8 92 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 45 08 8B 40 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E2 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 80 78 2D 3E 0F 85 79 FF FF FF 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 1B 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 00 00 FF FF FF FF 04 00 00 00 69 74 65 6D 00 00 00 00 FF FF FF FF 03 00 00 00 65 6E 64 00 }
	condition:
		$1
}

rule function_1858_0 {
	meta:
		name = "_NF__5FA"
		size = 212
		refs = "0012 _NF__5FA 0021 TParser.CheckToken 002b TParser.TokenString 0032 TParser.NextToken 0066 @LStrCatN 0083 TWriter.WriteStr 009c _NF__5F9 00b7 @LStrArrayClr 00bd @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B 5D 08 83 C3 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 03 B2 01 E8 ?? ?? ?? ?? 8D 55 FC 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? EB 39 8B 03 E8 ?? ?? ?? ?? 8B 03 B2 01 E8 ?? ?? ?? ?? FF 75 FC 68 ?? ?? ?? ?? 8D 55 F8 8B 03 E8 ?? ?? ?? ?? FF 75 F8 8D 45 FC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 03 80 78 2D 2E 74 BF 8B 45 08 8B 40 F8 8B 55 FC E8 ?? ?? ?? ?? 8B 03 B2 3D E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1859_0 {
	meta:
		name = "_NF__5FB"
		size = 236
		refs = "0010 _NF__5FB 0015 TParser.TokenSymbolIs 0029 TParser.CheckTokenSymbol 0030 TParser.NextToken 003b _NF__5F7 0047 _NF__5FA 0083 TWriter.WriteListEnd"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 83 C6 FC 33 DB 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 04 B3 01 EB 0C 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 59 EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 20 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 10 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 C6 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? EB 0A 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B 06 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E6 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 5E 5B 5D C3 00 00 00 FF FF FF FF 09 00 00 00 49 4E 48 45 52 49 54 45 44 00 00 00 FF FF FF FF 06 00 00 00 4F 42 4A 45 43 54 00 00 FF FF FF FF 03 00 00 00 45 4E 44 00 }
	condition:
		$1
}

rule function_1860_0 {
	meta:
		name = "ObjectTextToBinary"
		size = 186
		refs = "0011 _DV_TParser 0016 TParser.Create 001e DecimalSeparator 0033 ObjectTextToBinary 0047 _DV_TWriter 004c TFiler.Create 0065 TWriter.WriteSignature 006b _NF__5FB 0081 TObject.Free 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 8B F2 8B D8 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC A1 ?? ?? ?? ?? 8A 00 88 45 F7 A1 ?? ?? ?? ?? C6 00 2E 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 10 00 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 55 F7 88 10 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1862_0 {
	meta:
		name = "ObjectTextToResource"
		size = 332
		refs = "0010 _DV_TMemoryStream 0015 TObject.Create 0020 ObjectTextToResource 0030 ObjectTextToBinary 0038 TStream.GetSize 0049 @FillChar 0056 TStream.SetPosition 00dc StrUpper 0139 TObject.Free 013f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 A4 53 56 57 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 8D 45 A4 33 C9 BA 50 00 00 00 E8 ?? ?? ?? ?? BA 04 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 FF B9 01 00 00 00 8B 45 F4 8B 38 FF 57 04 8A 45 FF 24 F0 3C F0 75 55 A8 02 74 41 8D 55 FF B9 01 00 00 00 8B 45 F4 8B 38 FF 57 04 8A 45 FF 2C 02 74 0A FE C8 74 0C FE C8 74 0E EB 10 C6 45 FF 01 EB 0A C6 45 FF 02 EB 04 C6 45 FF 04 33 C9 8A 4D FF 8D 55 F8 8B 45 F4 8B 38 FF 57 04 8D 55 FF B9 01 00 00 00 8B 45 F4 8B 38 FF 57 04 33 C9 8A 4D FF 8D 55 A7 8B 45 F4 8B 38 FF 57 04 8D 45 A7 E8 ?? ?? ?? ?? 8D 45 A4 C6 00 FF 8D 45 A5 66 C7 00 0A 00 33 C0 8A 45 FF 8D 44 05 A8 66 C7 00 30 10 33 C0 8A 45 FF 8D 44 05 AA 89 18 33 C9 8A 4D FF 83 C1 0A 8D 55 A4 8B C6 8B 38 FF 57 08 8B 45 F4 8B 50 04 8B CB 8B C6 8B 18 FF 53 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1863_0 {
	meta:
		name = "_NF__609"
		size = 178
		refs = "0020 _NF__609 0045 @HandleAnyException 004a @GetTls 0050 RaiseList 007c @DoneExcept 0087 DestroyWindow 00a0 DefWindowProc"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 0C 8B D0 81 EA FE 8F 00 00 74 6E 4A 75 7B 33 C0 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 14 33 D2 89 50 24 8B D8 8B 43 20 FF 53 1C 33 C0 5A 59 59 64 89 10 EB 63 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 24 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 40 08 8B 55 14 89 42 24 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 33 D2 89 50 08 E8 ?? ?? ?? ?? EB 25 8B 45 08 50 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 15 8B 55 14 52 8B 55 10 52 50 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_1864_0 {
	meta:
		name = "_NF__60B"
		size = 16
	strings:
		$1 = { 54 54 68 72 65 61 64 57 69 6E 64 6F 77 00 00 00 }
	condition:
		$1
}

rule function_1865_0 {
	meta:
		name = "_NF__60C"
		size = 144
		refs = "0007 HInstance 000e _NV__60A 0025 GetClassInfo 0034 _NF__609 0050 UnregisterClass 005a RegisterClass 0075 _NF__60C 0081 CreateWindow"
	strings:
		$1 = { 55 8B EC 83 C4 D8 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 8D 45 D8 50 A1 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 84 C0 74 0A BA ?? ?? ?? ?? 3B 55 DC 74 21 84 C0 74 13 A1 ?? ?? ?? ?? 8B 00 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 A1 ?? ?? ?? ?? 8B 00 50 6A 00 BA ?? ?? ?? ?? 33 C9 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1866_0 {
	meta:
		name = "_NF__60D"
		size = 26
		refs = "0002 _NV__608 000a _NF__60C 000f _NV__607"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0A E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1867_0 {
	meta:
		name = "_NF__60E"
		size = 36
		refs = "0002 _NV__608 0019 _NV__607 001f PostMessage"
	strings:
		$1 = { FF 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 14 6A 00 6A 00 68 FE 8F 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1868_0 {
	meta:
		name = "_NF__60F"
		size = 52
		refs = "0023 TObject.Free 002a EndThread"
	strings:
		$1 = { 53 56 57 8B F8 8B C7 8B 10 FF 52 04 8A 5F 0E 8B 77 10 C6 47 0F 01 8B C7 8B 10 FF 12 84 DB 74 07 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1869_0 {
	meta:
		name = "TThread.Create"
		size = 101
		refs = "000f @ClassCreate 001f TObject.Create 0024 _NF__60D 003d _NF__60F 0046 BeginThread"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B D9 88 55 FF 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 5F 0D 33 F6 84 DB 74 05 BE 04 00 00 00 57 56 8D 47 08 50 B9 ?? ?? ?? ?? 33 D2 33 C0 E8 ?? ?? ?? ?? 89 47 04 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1870_0 {
	meta:
		name = "TThread.Destroy"
		size = 78
		refs = "0015 TThread.Terminate 001c TThread.WaitFor 0029 CloseHandle 0035 TObject.Destroy 003a _NF__60E 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 80 7E 0F 00 75 14 80 7E 0D 00 75 0E 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 46 04 85 C0 74 06 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1871_0 {
	meta:
		name = "_NF__617"
		size = 13
	strings:
		$1 = { 53 8B D8 8B D0 8B 43 18 FF 53 14 5B C3 }
	condition:
		$1
}

rule function_1872_0 {
	meta:
		name = "TThread.DoTerminate"
		size = 19
		refs = "0009 _NF__617 000e TThread.Synchronize"
	strings:
		$1 = { 66 83 78 16 00 74 0B 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1873_0 {
	meta:
		name = "TThread.GetPriority"
		size = 38
		refs = "0006 GetThreadPriority 0011 _NV__61A"
	strings:
		$1 = { 56 8B 40 04 50 E8 ?? ?? ?? ?? 8B F0 B0 03 33 D2 B9 ?? ?? ?? ?? 3B 31 75 02 8B C2 42 83 C1 04 80 FA 07 75 F1 5E C3 }
	condition:
		$1
}

rule function_1874_0 {
	meta:
		name = "TThread.SetPriority"
		size = 21
		refs = "0006 _NV__61A 0010 SetThreadPriority"
	strings:
		$1 = { 83 E2 7F 8B 14 95 ?? ?? ?? ?? 52 8B 40 04 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1875_0 {
	meta:
		name = "TThread.Synchronize"
		size = 59
		refs = "0020 _NV__607 0026 SendMessage 0032 @RaiseExcept"
	strings:
		$1 = { 55 8B EC 53 8B D8 33 C0 89 43 24 8B 45 08 89 43 1C 8B 45 0C 89 43 20 53 6A 00 68 FF 8F 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 43 24 85 C0 74 05 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1876_0 {
	meta:
		name = "TThread.SetSuspended"
		size = 22
		refs = "000a TThread.Suspend 0011 TThread.Resume"
	strings:
		$1 = { 3A 50 0D 74 10 84 D2 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1877_0 {
	meta:
		name = "TThread.Suspend"
		size = 14
		refs = "0009 SuspendThread"
	strings:
		$1 = { C6 40 0D 01 8B 40 04 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1878_0 {
	meta:
		name = "TThread.Resume"
		size = 21
		refs = "0008 ResumeThread"
	strings:
		$1 = { 53 8B D8 8B 43 04 50 E8 ?? ?? ?? ?? 48 75 04 C6 43 0D 00 5B C3 }
	condition:
		$1
}

rule function_1879_0 {
	meta:
		name = "TThread.Terminate"
		size = 5
	strings:
		$1 = { C6 40 0C 01 C3 }
	condition:
		$1
}

rule function_1880_0 {
	meta:
		name = "TThread.WaitFor"
		size = 90
		refs = "0007 GetCurrentThreadId 000d MainThreadID 0023 PeekMessage 0034 MsgWaitForMultipleObjects 0044 WaitForSingleObject 004e GetExitCodeThread"
	strings:
		$1 = { 53 83 C4 E0 8B D8 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 2A EB 12 6A 00 6A 00 6A 00 6A 00 8D 44 24 14 50 E8 ?? ?? ?? ?? 6A 40 6A FF 6A 00 8D 43 04 50 6A 01 E8 ?? ?? ?? ?? 48 74 DA EB 0B 6A FF 8B 43 04 50 E8 ?? ?? ?? ?? 54 8B 43 04 50 E8 ?? ?? ?? ?? 8B 04 24 83 C4 20 5B C3 }
	condition:
		$1
}

rule function_1881_0 {
	meta:
		name = "TComponent.Create"
		size = 68
		refs = "000b @ClassCreate 0016 TComponent.Create 0026 TComponent.InsertComponent"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 A0 ?? ?? ?? ?? 88 47 21 85 F6 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_1882_0 {
	meta:
		name = "TComponent.Destroy"
		size = 126
		refs = "0022 TList.Get 0037 TObject.Free 0043 TComponent.Destroying 004a TComponent.DestroyComponents 0058 TComponent.RemoveComponent 0065 TPersistent.Destroy 0072 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 51 88 14 24 8B D8 8B 43 14 85 C0 74 2F 8B 70 08 4E 85 F6 7C 1A 46 33 FF 8B D7 8B 43 14 E8 ?? ?? ?? ?? B1 01 8B D3 8B 28 FF 55 10 47 4E 75 E9 8B 43 14 E8 ?? ?? ?? ?? 33 C0 89 43 14 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 43 04 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8A 14 24 80 E2 FE 8B C3 E8 ?? ?? ?? ?? 80 3C 24 00 74 07 8B C3 E8 ?? ?? ?? ?? 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1883_0 {
	meta:
		name = "TComponent.FreeNotification"
		size = 75
		refs = "001b _DV_TList 0020 TObject.Create 002d TList.IndexOf 003b TList.Add 0044 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 85 C0 74 05 3B 46 04 74 36 83 7B 14 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 14 8B D6 8B 43 14 E8 ?? ?? ?? ?? 85 C0 7D 13 8B D6 8B 43 14 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1884_0 {
	meta:
		name = "_NF__638"
		size = 20
		refs = "0009 TReader.ReadInteger"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 66 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_1885_0 {
	meta:
		name = "_NF__639"
		size = 20
		refs = "0009 TReader.ReadInteger"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 66 89 43 1A 5E 5B C3 }
	condition:
		$1
}

rule function_1886_0 {
	meta:
		name = "_NF__63A"
		size = 11
		refs = "0006 TWriter.WriteInteger"
	strings:
		$1 = { 0F B7 40 18 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1887_0 {
	meta:
		name = "_NF__63B"
		size = 11
		refs = "0006 TWriter.WriteInteger"
	strings:
		$1 = { 0F B7 40 1A 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1888_0 {
	meta:
		name = "_NF__63C"
		size = 43
		refs = "000f _DV_TList 0014 TObject.Create 0021 TList.Add"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 10 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 8B D6 8B 43 10 E8 ?? ?? ?? ?? 89 5E 04 5E 5B C3 }
	condition:
		$1
}

rule function_1889_0 {
	meta:
		name = "_NF__63D"
		size = 37
		refs = "000c TList.Remove 001a TObject.Free"
	strings:
		$1 = { 53 8B D8 33 C0 89 42 04 8B 43 10 E8 ?? ?? ?? ?? 8B 43 10 83 78 08 00 75 0A E8 ?? ?? ?? ?? 33 C0 89 43 10 5B C3 }
	condition:
		$1
}

rule function_1890_0 {
	meta:
		name = "TComponent.InsertComponent"
		size = 83
		refs = "0010 @CallDynaInst 0028 _NF__63C 0031 _NF__696 0040 TComponent.SetDesigning"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B D7 8B C6 66 BB F5 FF E8 ?? ?? ?? ?? 8B 46 08 50 33 C9 8B D6 8B C7 8B 18 FF 53 1C 8B D6 8B C7 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? F6 47 20 10 74 09 B2 01 8B C6 E8 ?? ?? ?? ?? 33 C9 8B D6 8B C7 8B 18 FF 53 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1891_0 {
	meta:
		name = "TComponent.RemoveComponent"
		size = 63
		refs = "0017 _NF__696 0020 _NF__63D 0029 TComponent.SetDesigning"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 B1 01 8B D3 8B C6 8B 38 FF 57 10 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 00 8B 4B 08 8B D3 8B C6 8B 18 FF 53 1C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1892_0 {
	meta:
		name = "TComponent.DestroyComponents"
		size = 41
		refs = "0007 TList.Last 0012 _NF__63D"
	strings:
		$1 = { 53 56 8B D8 EB 19 E8 ?? ?? ?? ?? 8B F0 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B C6 8B 08 FF 51 FC 8B 43 10 85 C0 75 E0 5E 5B C3 }
	condition:
		$1
}

rule function_1893_0 {
	meta:
		name = "TComponent.Destroying"
		size = 56
		refs = "0027 TList.Get 002c TComponent.Destroying"
	strings:
		$1 = { 53 56 57 8B D8 F6 43 20 08 75 29 80 4B 20 08 8B 43 10 85 C0 74 1E 8B 70 08 4E 85 F6 7C 16 46 33 FF 8B D7 8B 43 10 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 47 4E 75 ED 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1894_0 {
	meta:
		name = "TComponent.Notification"
		size = 108
		refs = "0022 TList.Remove 0030 TObject.Free 0051 TList.Get"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 88 4C 24 04 89 14 24 8B D8 8B 43 14 85 C0 74 22 80 7C 24 04 01 75 1B 8B 14 24 E8 ?? ?? ?? ?? 8B 43 14 83 78 08 00 75 0A E8 ?? ?? ?? ?? 33 C0 89 43 14 8B 43 10 85 C0 74 25 8B 70 08 4E 85 F6 7C 1D 46 33 FF 8B D7 8B 43 10 E8 ?? ?? ?? ?? 8A 4C 24 04 8B 14 24 8B 28 FF 55 10 47 4E 75 E6 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1895_0 {
	meta:
		name = "TComponent.DefineProperties"
		size = 132
		refs = "001f _NF__638 0025 _NF__63A 0035 TComponent.DefineProperties 0041 _NF__639 0047 _NF__63B"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F2 8B D8 33 C0 89 45 FC 8B 46 1C 85 C0 74 06 8B 40 18 89 45 FC 53 68 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 66 8B 43 18 66 3B 45 FC 0F 95 C1 BA ?? ?? ?? ?? 8B C6 8B 38 FF 17 53 68 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 66 8B 45 FE 66 3B 43 1A 0F 95 C1 BA ?? ?? ?? ?? 8B C6 8B 18 FF 13 5F 5E 5B 59 5D C3 00 FF FF FF FF 04 00 00 00 4C 65 66 74 00 00 00 00 FF FF FF FF 03 00 00 00 54 6F 70 00 }
	condition:
		$1
}

rule function_1900_0 {
	meta:
		name = "TComponent.GetNamePath"
		size = 19
		refs = "000c @LStrLAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 08 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1905_0 {
	meta:
		name = "TComponent.Updating"
		size = 9
	strings:
		$1 = { 53 8B D8 80 4B 20 40 5B C3 }
	condition:
		$1
}

rule function_1906_0 {
	meta:
		name = "TComponent.Updated"
		size = 9
	strings:
		$1 = { 53 8B D8 80 63 20 BF 5B C3 }
	condition:
		$1
}

rule function_1907_0 {
	meta:
		name = "TComponent.Loaded"
		size = 9
	strings:
		$1 = { 53 8B D8 80 63 20 FE 5B C3 }
	condition:
		$1
}

rule function_1909_0 {
	meta:
		name = "TComponent.WriteState"
		size = 7
	strings:
		$1 = { 92 8B 08 FF 51 0C C3 }
	condition:
		$1
}

rule function_1910_0 {
	meta:
		name = "TComponent.ValidateRename"
		size = 179
		refs = "001c TComponent.ValidateRename 0030 CompareText 003d TComponent.FindComponent 0056 SDuplicateName 005b LoadResString 0065 _DV_EComponentError 006a Exception.CreateFmt 006f @RaiseExcept 009e @LStrClr 00a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F0 89 4D FC 8B FA 8B D8 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 49 8B D6 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 3B 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 74 2E 89 75 F4 C6 45 F8 0B 8D 45 F4 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 43 20 10 74 14 83 7B 04 00 74 0E 56 8B 4D FC 8B D7 8B 43 04 8B 18 FF 53 1C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1911_0 {
	meta:
		name = "TComponent.ValidateContainer"
		size = 20
		refs = "000d @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 8B C2 8B D6 66 BB F4 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1913_0 {
	meta:
		name = "TComponent.FindComponent"
		size = 77
		refs = "002a TList.Get 0037 CompareText"
	strings:
		$1 = { 53 56 57 55 51 89 14 24 8B F8 83 3C 24 00 74 33 83 7F 10 00 74 2D 8B 47 10 8B 58 08 4B 85 DB 7C 22 43 33 ED 8B D5 8B 47 10 E8 ?? ?? ?? ?? 8B F0 8B 14 24 8B 46 08 E8 ?? ?? ?? ?? 85 C0 74 06 45 4B 75 E1 33 F6 8B C6 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1914_0 {
	meta:
		name = "TComponent.SetName"
		size = 203
		refs = "0016 TComponent.SetName 0026 @LStrCmp 0033 IsValidIdent 004c SInvalidName 0051 LoadResString 005b _DV_EComponentError 0060 Exception.CreateFmt 0065 @RaiseExcept 0091 _NF__696 009a TComponent.ChangeName 00b8 @LStrClr 00be @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 08 8B D6 E8 ?? ?? ?? ?? 74 7B 85 F6 74 39 8B C6 E8 ?? ?? ?? ?? 84 C0 75 2E 89 75 F8 C6 45 FC 0B 8D 45 F8 50 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7B 04 85 FF 74 0F 56 8B 4B 08 8B D3 8B C7 8B 38 FF 57 1C EB 0D 56 8B 4B 08 33 D2 8B C3 8B 38 FF 57 1C 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1915_0 {
	meta:
		name = "TComponent.ChangeName"
		size = 19
		refs = "000c @LStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 08 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1916_0 {
	meta:
		name = "TComponent.GetComponentIndex"
		size = 27
		refs = "0012 TList.IndexOf"
	strings:
		$1 = { 8B 50 04 85 D2 74 10 83 7A 10 00 74 0A 8B 52 10 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_1917_0 {
	meta:
		name = "TComponent.GetComponent"
		size = 107
		refs = "000f TComponent.GetComponent 0023 SListIndexError 0028 LoadResString 0032 _DV_TList 0037 TList.Error 0041 TList.Get 0058 @LStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 10 00 75 1C 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B CE A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B 43 10 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1918_0 {
	meta:
		name = "TComponent.GetComponentCount"
		size = 14
	strings:
		$1 = { 8B 50 10 85 D2 74 04 8B 42 08 C3 33 C0 C3 }
	condition:
		$1
}

rule function_1919_0 {
	meta:
		name = "TComponent.SetComponentIndex"
		size = 81
		refs = "0014 TList.IndexOf 003a TList.Delete 0049 TList.Insert"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 43 04 85 C0 74 3F 8B 40 10 8B D3 E8 ?? ?? ?? ?? 85 C0 7C 31 8B 53 04 8B 7A 10 8B 57 08 85 F6 7D 02 33 F6 3B D6 7F 03 8B F2 4E 3B C6 74 17 8B D7 92 E8 ?? ?? ?? ?? 8B 43 04 8B 40 10 8B CB 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1920_0 {
	meta:
		name = "TComponent.SetAncestor"
		size = 64
		refs = "0019 TComponent.GetComponentCount 002c TComponent.GetComponent 0033 TComponent.SetAncestor"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F8 84 DB 74 06 80 4F 20 20 EB 04 80 67 20 DF 8B C7 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 7C 17 45 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 46 4D 75 EC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1921_0 {
	meta:
		name = "TComponent.SetDesigning"
		size = 64
		refs = "0019 TComponent.GetComponentCount 002c TComponent.GetComponent 0033 TComponent.SetDesigning"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F8 84 DB 74 06 80 4F 20 10 EB 04 80 67 20 EF 8B C7 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 7C 17 45 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 46 4D 75 EC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1922_0 {
	meta:
		name = "_NF__696"
		size = 70
		refs = "001f @LStrToString 0028 TObject.FieldAddress"
	strings:
		$1 = { 53 56 57 81 C4 00 FF FF FF 8B DA 8B F8 8B 77 04 85 F6 74 28 8B C4 8B 57 08 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0C 84 DB 74 04 89 38 EB 04 33 D2 89 10 81 C4 00 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1923_0 {
	meta:
		name = "TComponent.GetComObject"
		size = 212
		refs = "001b TComponent.GetComObject 002d CreateVCLComObjectProc 004b TObject.ClassName 0069 SNoComSupport 006e LoadResString 007b _DV_EComponentError 0080 Exception.CreateFmt 0085 @RaiseExcept 008c @IntfClear 00b2 @LStrClr 00b8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 56 33 C9 89 8D F4 FE FF FF 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 1C 00 75 5E 83 3D ?? ?? ?? ?? 00 74 08 8B C3 FF 15 ?? ?? ?? ?? 83 7B 1C 00 75 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 43 1C 50 8B 00 FF 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_1924_0 {
	meta:
		name = "TComponent.SafeCallException"
		size = 24
		refs = "0012 TObject.SafeCallException"
	strings:
		$1 = { 53 83 78 1C 00 74 0A 8B 40 1C 8B 18 FF 53 1C 5B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1925_0 {
	meta:
		name = "TComponent.FreeOnRelease"
		size = 15
	strings:
		$1 = { 83 78 1C 00 74 08 8B 40 1C 8B 10 FF 52 20 C3 }
	condition:
		$1
}

rule function_1927_0 {
	meta:
		name = "TComponent.QueryInterface"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 10 5D C2 0C 00 }
	condition:
		$1
}

rule function_1928_0 {
	meta:
		name = "TComponent._AddRef"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 1C 50 8B 00 FF 50 04 5D C2 04 00 }
	condition:
		$1
}

rule function_1929_0 {
	meta:
		name = "TComponent._Release"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 1C 50 8B 00 FF 50 08 5D C2 04 00 }
	condition:
		$1
}

rule function_1930_0 {
	meta:
		name = "TComponent.GetTypeInfoCount"
		size = 23
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 0C 5D C2 08 00 }
	condition:
		$1
}

rule function_1931_0 {
	meta:
		name = "TComponent.GetTypeInfo"
		size = 31
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 10 5D C2 10 00 }
	condition:
		$1
}

rule function_1932_0 {
	meta:
		name = "TComponent.GetIDsOfNames"
		size = 39
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 1C 52 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 14 5D C2 18 00 }
	condition:
		$1
}

rule function_1933_0 {
	meta:
		name = "TComponent.Invoke"
		size = 52
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 28 52 8B 55 24 52 8B 55 20 52 8B 55 1C 52 66 8B 55 18 52 8B 55 14 52 8B 55 10 52 8B 55 0C 52 8B 40 1C 50 8B 00 FF 50 18 5D C2 24 00 }
	condition:
		$1
}

rule function_1934_0 {
	meta:
		name = "TStreamAdapter.Create"
		size = 53
		refs = "000b @ClassCreate 001a TObject.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 10 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1935_0 {
	meta:
		name = "TStreamAdapter.Read"
		size = 103
		refs = "0010 TStreamAdapter.Read 0050 @HandleAnyException 005a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 55 0C 8B 45 08 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 85 D2 75 0F BB 09 00 03 80 33 C0 5A 59 59 64 89 10 EB 31 8B 40 10 8B 4D 10 8B 18 FF 53 04 83 7D 14 00 74 05 8B 55 14 89 02 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1936_0 {
	meta:
		name = "TStreamAdapter.Write"
		size = 103
		refs = "0010 TStreamAdapter.Write 0050 @HandleAnyException 005a @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 55 0C 8B 45 08 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 85 D2 75 0F BB 09 00 03 80 33 C0 5A 59 59 64 89 10 EB 31 8B 40 10 8B 4D 10 8B 18 FF 53 08 83 7D 14 00 74 05 8B 55 14 89 02 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB 03 01 03 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_1937_0 {
	meta:
		name = "TStreamAdapter.Seek"
		size = 127
		refs = "0011 TStreamAdapter.Seek 0037 @TRUNC 0067 @HandleAnyException 0071 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 14 8B 75 08 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 85 DB 7C 05 83 FB 02 7E 0F BB 01 00 03 80 33 C0 5A 59 59 64 89 10 EB 42 DF 6D 0C E8 ?? ?? ?? ?? 8B D0 8B 46 10 8B CB 8B 18 FF 53 0C 8B 55 18 85 D2 74 0C 89 45 FC DB 45 FC 8B 45 18 DF 38 9B 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB 09 00 03 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 14 00 }
	condition:
		$1
}

rule function_1938_0 {
	meta:
		name = "TStreamAdapter.SetSize"
		size = 109
		refs = "000e TStreamAdapter.SetSize 001c @TRUNC 002d TStream.GetSize 0055 @HandleAnyException 005f @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 DF 6D 0C E8 ?? ?? ?? ?? 8B D0 8B 43 10 8B 08 FF 11 8B 43 10 E8 ?? ?? ?? ?? 89 45 FC DB 45 FC DF 6D 0C DE D9 DF E0 9E 74 07 BB 05 40 00 80 EB 02 33 DB 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BB FF FF 00 80 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1939_0 {
	meta:
		name = "TStreamAdapter.CopyTo"
		size = 260
		refs = "0013 @IntfAddRef 001b TStreamAdapter.CopyTo 0037 @TRUNC 0042 @GetMem 009e @FreeMem 00a4 @HandleFinally 00cb @HandleAnyException 00d7 @DoneExcept 00ec @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B 5D 18 8B 75 08 8B 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 DF 6D 10 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 E8 ?? ?? ?? ?? 89 45 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F8 8B 46 10 8B 4D F4 8B 30 FF 56 04 85 DB 74 09 89 45 EC DB 45 EC DF 3B 9B 8D 45 F0 50 8B 45 F4 50 8B 45 F8 50 8B 45 0C 50 8B 00 FF 50 10 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 83 7D FC 00 75 10 8B 45 1C 85 C0 74 09 DB 45 F0 8B 45 1C DF 38 9B 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? C7 45 FC FF FF 00 80 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_1941_0 {
	meta:
		name = "TStreamAdapter.Revert"
		size = 12
	strings:
		$1 = { 55 8B EC B8 02 01 03 80 5D C2 04 00 }
	condition:
		$1
}

rule function_1942_0 {
	meta:
		name = "TStreamAdapter.LockRegion"
		size = 12
		altNames = "TStreamAdapter.UnlockRegion"
	strings:
		$1 = { 55 8B EC B8 01 00 03 80 5D C2 18 00 }
	condition:
		$1
}

rule function_1944_0 {
	meta:
		name = "TStreamAdapter.Stat"
		size = 130
		refs = "0013 TStreamAdapter.Stat 002c TStream.GetSize 006a @HandleAnyException 0074 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 0C 8B 7D 08 33 F6 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 3E C7 43 04 02 00 00 00 8B 47 10 E8 ?? ?? ?? ?? 89 45 FC DB 45 FC DF 7B 08 9B 33 C0 89 43 10 33 C0 89 43 14 33 C0 89 43 18 33 C0 89 43 1C 33 C0 89 43 20 33 C0 89 43 24 C7 43 2C 01 00 00 00 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BE FF FF 00 80 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1946_0 {
	meta:
		name = "_NF__6F7"
		size = 50
		refs = "0004 _NV__230 001a TList.Get 001f TObject.Free"
	strings:
		$1 = { 53 56 57 BF ?? ?? ?? ?? 8B 07 8B 58 08 4B 85 DB 7C 15 43 33 F6 8B D6 8B 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4B 75 EE 8B 07 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1948_0 {
	meta:
		name = "Finalization"
		size = 124
		refs = "0007 Finalization 0013 _NV__22C 001a HInstance 0021 UnRegisterModuleClasses 0026 _NV__22E 002b TObject.Free 0030 _NV__22F 003a _NF__6F7 0043 RemoveFixupReferences 0048 _NV__4BB 0052 _NV__278 005c _NF__6F8 0061 RemoveModuleUnloadProc 0074 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 4C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 33 C0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1949_0 {
	meta:
		name = "Classes"
		size = 115
		refs = "0002 _NV__22C 000a _NF__6F8 000f AddModuleUnloadProc 0016 _DV_TList 001b TObject.Create 0020 _NV__22E 0027 _DV_TStringList 0031 _NV__22F 0042 _NV__230 0053 _NV__4BB 0058 GetCurrentThreadId 005d MainThreadID 006e _NV__278"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 69 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1950_0 {
	meta:
		name = "TClipboard.Clear"
		size = 66
		refs = "000b TClipboard.Open 0013 TClipboard.Clear 001e EmptyClipboard 0033 TClipboard.Close 0039 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1951_0 {
	meta:
		name = "_NF__71"
		size = 28
		refs = "0012 TClipboard.Clear"
	strings:
		$1 = { 53 8B D8 83 7B 04 00 74 11 80 7B 0D 00 75 0B 8B C3 E8 ?? ?? ?? ?? C6 43 0D 01 5B C3 }
	condition:
		$1
}

rule function_1952_0 {
	meta:
		name = "TClipboard.Close"
		size = 44
		refs = "0013 CloseClipboard 0021 DeallocateHWnd"
	strings:
		$1 = { 53 8B D8 83 7B 04 00 74 21 FF 4B 04 83 7B 04 00 75 18 E8 ?? ?? ?? ?? 80 7B 0C 00 74 08 8B 43 08 E8 ?? ?? ?? ?? 33 C0 89 43 08 5B C3 }
	condition:
		$1
}

rule function_1953_0 {
	meta:
		name = "TClipboard.Open"
		size = 62
		refs = "000a Application 001c _NF__76 0021 AllocateHWnd 0031 OpenClipboard"
	strings:
		$1 = { 53 8B D8 83 7B 04 00 75 30 A1 ?? ?? ?? ?? 8B 00 8B 40 24 89 43 08 85 C0 75 12 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 08 C6 43 0C 01 8B 43 08 50 E8 ?? ?? ?? ?? C6 43 0D 00 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_1954_0 {
	meta:
		name = "_NF__76"
		size = 32
		refs = "0016 DefWindowProc"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 43 08 50 8B 43 04 50 8B 03 50 8B 46 08 50 E8 ?? ?? ?? ?? 89 43 0C 5E 5B C3 }
	condition:
		$1
}

rule function_1955_0 {
	meta:
		name = "TClipboard.GetComponent"
		size = 414
		refs = "0019 TClipboard.Open 0021 TClipboard.GetComponent 002e CF_COMPONENT 0034 GetClipboardData 0042 @TryFinallyExit 0050 GlobalLock 0075 _Dn_TMemoryStream 007a TObject.Create 0094 GlobalSize 00a0 TStream.WriteBuffer 00aa TStream.SetPosition 00b9 _Dn_TReader 00be TFiler.Create 00df TReader.ReadRootComponent 00fa TComponent.InsertComponent 0109 @HandleAnyException 0111 TObject.Free 0116 @RaiseAgain 011b @DoneExcept 0136 @HandleFinally 016b GlobalUnlock 0188 TClipboard.Close"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B F1 8B DA 89 45 FC 33 C0 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B7 05 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 0A E8 ?? ?? ?? ?? E9 49 01 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 0A E8 ?? ?? ?? ?? E9 30 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 50 E8 ?? ?? ?? ?? 8B C8 8B D7 8B 45 F0 E8 ?? ?? ?? ?? 33 D2 8B 45 F0 E8 ?? ?? ?? ?? 68 00 01 00 00 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 89 70 28 33 D2 8B 45 EC E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1956_0 {
	meta:
		name = "_NF__7B"
		size = 223
		refs = "0017 TClipboard.Open 001f _NF__7B 002d GlobalAlloc 0047 GlobalLock 0060 Move 0068 _NF__71 0075 SetClipboardData 008b GlobalUnlock 0091 @HandleFinally 00a2 @HandleAnyException 00ab GlobalFree 00b0 @RaiseAgain 00b5 @DoneExcept 00ca TClipboard.Close"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F9 8B F2 89 45 FC 8B 5D 08 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 53 6A 02 E8 ?? ?? ?? ?? 89 45 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 F8 50 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D0 8B C7 8B CB E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 50 0F B7 C6 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 EB 18 E9 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1957_0 {
	meta:
		name = "TClipboard.SetComponent"
		size = 112
		refs = "000d _Dn_TMemoryStream 0012 TObject.Create 001d TClipboard.SetComponent 002d TStream.WriteComponent 0035 TStream.GetSize 0043 CF_COMPONENT 004a _NF__7B 005f TObject.Free 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC 8B 48 04 66 8B 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1958_0 {
	meta:
		name = "TClipboard.GetTextBuf"
		size = 79
		refs = "000d TClipboard.Open 0014 GetClipboardData 0024 GlobalLock 0030 StrLCopy 0035 StrLen 003d GlobalUnlock 0044 TClipboard.Close"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 8B D8 85 DB 75 04 33 FF EB 1F 53 E8 ?? ?? ?? ?? 8B D0 8B CD 49 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 53 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1959_0 {
	meta:
		name = "TClipboard.SetTextBuf"
		size = 31
		refs = "0009 StrLen 0018 _NF__7B"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 40 50 8B CE 66 BA 01 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1960_0 {
	meta:
		name = "TClipboard.GetAsText"
		size = 126
		refs = "0010 TClipboard.Open 0017 GetClipboardData 0022 TClipboard.GetAsText 0037 GlobalLock 0040 @LStrFromPChar 0049 @LStrClr 0065 GlobalUnlock 006d TClipboard.Close 0073 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F8 00 74 14 8B 45 F8 50 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D F8 00 74 09 8B 45 F8 50 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E1 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1961_0 {
	meta:
		name = "TClipboard.SetAsText"
		size = 38
		refs = "0009 @LStrLen 0012 @LStrToPChar 001f _NF__7B"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 8B C8 66 BA 01 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1962_0 {
	meta:
		name = "_NF__8B"
		size = 236
		refs = "0017 _NF__8B 0025 TClipboard.Open 003a EnumClipboardFormats 0048 _Dn_TPicture 004d TPicture.SupportsClipboardFormat 005a GetClipboardData 006f TPicture.LoadFromClipboardFormat 0074 @TryFinallyExit 008e SInvalidClipFmt 0093 LoadResString 009d _Dn_Exception 00a2 Exception.Create 00a7 @RaiseExcept 00bc TClipboard.Close 00c2 @HandleFinally 00d9 @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 8B FA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 00 E8 ?? ?? ?? ?? 8B D8 66 85 DB 74 45 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 25 0F B7 C3 50 E8 ?? ?? ?? ?? 8B F0 6A 09 E8 ?? ?? ?? ?? 50 8B CE 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 4E 0F B7 C3 50 E8 ?? ?? ?? ?? 8B D8 66 85 DB 75 BB 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1963_0 {
	meta:
		name = "_NF__8C"
		size = 101
		refs = "0010 TClipboard.Open 0018 _NF__8C 0025 GetClipboardData 0053 TClipboard.Close 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B FA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 02 E8 ?? ?? ?? ?? 8B D8 6A 09 E8 ?? ?? ?? ?? 8B F0 56 8B CB 66 BA 02 00 8B C7 8B 18 FF 53 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1964_0 {
	meta:
		name = "_NF__8D"
		size = 97
		refs = "000f TClipboard.Open 0017 _NF__8D 0024 GetClipboardData 0050 TClipboard.Close 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 03 E8 ?? ?? ?? ?? 8B D8 6A 09 E8 ?? ?? ?? ?? 50 8B CB 66 BA 03 00 8B C6 8B 18 FF 53 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1965_0 {
	meta:
		name = "TClipboard.AssignTo"
		size = 103
		refs = "000a _Dn_TPicture 000f @IsClass 001c _NF__8B 0027 _Dn_TBitmap 0039 _NF__8C 0043 _Dn_TMetafile 0055 _NF__8D 0060 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 25 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1966_0 {
	meta:
		name = "_NF__91"
		size = 129
		refs = "0010 TClipboard.Open 0018 _NF__91 0026 _NF__71 003c TPicture.SaveToClipboardFormat 004a SetClipboardData 0070 TClipboard.Close 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F0 8D 45 F0 50 8D 4D F8 8D 55 F6 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 0F B7 45 F6 50 E8 ?? ?? ?? ?? 83 7D F0 00 74 0B 8B 45 F0 50 6A 09 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1967_0 {
	meta:
		name = "_NF__92"
		size = 129
		refs = "0010 TClipboard.Open 0018 _NF__92 0026 _NF__71 004a SetClipboardData 0070 TClipboard.Close 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 89 45 F0 8D 45 F0 50 8D 4D F8 8D 55 F6 8B C3 8B 18 FF 53 5C 8B 45 F8 50 0F B7 45 F6 50 E8 ?? ?? ?? ?? 83 7D F0 00 74 0B 8B 45 F0 50 6A 09 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1968_0 {
	meta:
		name = "TClipboard.Assign"
		size = 75
		refs = "000a _Dn_TPicture 000f @IsClass 001c _NF__91 0027 _Dn_TGraphic 0039 _NF__92 0044 TPersistent.Assign"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5949_0 {
	meta:
		name = "TParam.Assign"
		size = 75
		refs = "000a _DV_TParam 000f @IsClass 001c TParam.AssignParam 0027 _Dn_TField 0039 TParam.AssignField 0044 TPersistent.Assign"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B D3 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1969_0 {
	meta:
		name = "TClipboard.GetAsHandle"
		size = 83
		refs = "0010 TClipboard.Open 0018 TClipboard.GetAsHandle 0027 GetClipboardData 003f TClipboard.Close 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B7 C3 50 E8 ?? ?? ?? ?? 89 45 F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1970_0 {
	meta:
		name = "TClipboard.SetAsHandle"
		size = 87
		refs = "0011 TClipboard.Open 0019 TClipboard.SetAsHandle 0027 _NF__71 0031 SetClipboardData 0046 TClipboard.Close 004c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 56 0F B7 C3 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1972_0 {
	meta:
		name = "TClipboard.GetFormats"
		size = 106
		refs = "0010 TClipboard.Open 0018 TClipboard.GetFormats 0025 EnumClipboardFormats 0055 TClipboard.Close 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 E8 ?? ?? ?? ?? 66 89 45 FA 85 DB 7E 13 4B 0F B7 45 FA 50 E8 ?? ?? ?? ?? 66 89 45 FA 85 DB 7F ED 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 66 8B 45 FA 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1973_0 {
	meta:
		name = "_NF__A2"
		size = 125
		refs = "000c TClipboard.Open 0014 _NF__A2 0025 EnumClipboardFormats 0033 _Dn_TPicture 0038 TPicture.SupportsClipboardFormat 006a TClipboard.Close 0070 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 00 6A 00 E8 ?? ?? ?? ?? 8B D8 66 85 DB 74 26 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 C6 45 FF 01 EB 10 0F B7 C3 50 E8 ?? ?? ?? ?? 8B D8 66 85 DB 75 DA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8A 45 FF 5B 59 5D C3 }
	condition:
		$1
}

rule function_1974_0 {
	meta:
		name = "TClipboard.HasFormat"
		size = 53
		refs = "000f IsClipboardFormatAvailable 001a CF_PICTURE 0022 _NF__A2"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 0F B7 C3 50 E8 ?? ?? ?? ?? 85 C0 75 18 66 3B 1D ?? ?? ?? ?? 75 0B 55 E8 ?? ?? ?? ?? 59 84 C0 75 04 33 C0 EB 02 B0 01 5B 59 5D C3 }
	condition:
		$1
}

rule function_1975_0 {
	meta:
		name = "Clipboard"
		size = 32
		refs = "0002 _NV__A6 000c _DV_TClipboard 0011 TObject.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12159_0 {
	meta:
		name = "Printer"
		size = 32
		refs = "0002 _NV__A9 000c _DV_TPrinter 0011 TPrinter.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12771_0 {
	meta:
		name = "QRPrinter"
		size = 32
		refs = "0002 _NV__25F 000c _DV_TQRPrinter 0011 TQRPrinter.Create"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7772_0 {
	meta:
		name = "_NF__47C"
		size = 32
		refs = "0002 _NV__47B 000c _NV__46A 0011 _NF__46C"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_7773_0 {
	meta:
		name = "_NF__47D"
		size = 32
		refs = "0002 _NV__47A 000c _NV__473 0011 _NF__475"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1976_0 {
	meta:
		name = "SetClipboard"
		size = 14
		refs = "0002 _NV__A6"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C2 C3 }
	condition:
		$1
}

rule function_12160_0 {
	meta:
		name = "SetPrinter"
		size = 14
		refs = "0002 _NV__A9"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C2 C3 }
	condition:
		$1
}

rule function_1977_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _NV__6E 001a _NV__A6 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5382_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _NV__73 001a _NV__81 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12161_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _NV__A8 001a _NV__A9 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12209_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _NV__45 001a _NV__55 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1978_0 {
	meta:
		name = "Clipbrd"
		size = 88
		refs = "0002 _NV__6E 000a Clipbrd 000f RegisterClipboardFormat 0015 CF_PICTURE 0025 CF_COMPONENT 002c _NV__A6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 27 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 00 00 00 44 65 6C 70 68 69 20 50 69 63 74 75 72 65 00 00 44 65 6C 70 68 69 20 43 6F 6D 70 6F 6E 65 6E 74 00 00 00 00 }
	condition:
		$1
}

rule function_1979_0 {
	meta:
		name = "TColorGrid.Create"
		size = 200
		refs = "000e @ClassCreate 001c TCustomControl.Create 0022 TColorGrid.Create 005f TControl.SetColor 006f TBrush.SetStyle 007f TPen.SetColor 00a0 GetStockObject 00a6 GetPaletteEntries"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 66 0B 43 40 66 89 43 40 C6 83 90 01 00 00 02 C7 83 88 01 00 00 04 00 00 00 C7 83 8C 01 00 00 04 00 00 00 C6 83 78 01 00 00 01 C6 83 79 01 00 00 01 BA 0F 00 00 80 8B C3 E8 ?? ?? ?? ?? 8B 83 18 01 00 00 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B 83 18 01 00 00 8B 40 10 33 D2 E8 ?? ?? ?? ?? 6A 64 6A 64 33 C9 33 D2 8B C3 8B 30 FF 56 4C 8D 83 1C 01 00 00 50 6A 14 6A 00 6A 0F E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 40 00 00 00 }
	condition:
		$1
}

rule function_1980_0 {
	meta:
		name = "TColorGrid.ColorToIndex"
		size = 88
		refs = "0014 ColorToRGB 002c RGB"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 14 24 8B E8 33 FF 33 DB 8B 04 24 E8 ?? ?? ?? ?? 89 44 24 04 8D B4 9D 1C 01 00 00 8A 4E 02 8A 56 01 8A 06 E8 ?? ?? ?? ?? 3B 44 24 04 74 19 83 FB 08 7C 05 83 FB 08 7E 03 43 EB 03 83 C3 04 47 83 FB 14 7C D0 83 CF FF 8B C7 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1981_0 {
	meta:
		name = "TColorGrid.CreateWnd"
		size = 48
		refs = "0006 TWinControl.CreateWnd 000f TWinControl.GetHandle 0015 GetWindowLong 002a SetWindowLong"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 6A F0 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 0D 00 00 00 04 50 6A F0 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1982_0 {
	meta:
		name = "_NF__C9"
		size = 518
		refs = "0064 Bounds 0080 TPen.SetColor 009d TCanvas.Rectangle 00ab InflateRect 00c6 Frame3D 00ee RGB 00fe TBrush.SetColor 0190 TCanvas.GetHandle 0196 DrawFocusRect 01b2 TPen.SetMode"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 88 0C 24 8B CA 8B D8 85 C9 0F 8C E8 01 00 00 83 F9 0F 0F 8F DF 01 00 00 83 F9 08 7D 04 8B F1 EB 03 8D 71 04 8B C1 8B AB 88 01 00 00 99 F7 FD 8B F8 0F AF BB 84 01 00 00 8B C1 99 F7 FD 0F AF 93 80 01 00 00 8B EA 8B 83 84 01 00 00 50 8D 44 24 08 50 8B 8B 80 01 00 00 8B D7 8B C5 E8 ?? ?? ?? ?? 80 BB D5 00 00 00 00 74 5B 8B 83 18 01 00 00 8B 40 10 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 44 24 0C 50 E8 ?? ?? ?? ?? 68 14 00 00 80 6A 02 8D 54 24 0C B9 10 00 00 80 8B 83 18 01 00 00 E8 ?? ?? ?? ?? EB 10 8B 83 18 01 00 00 8B 40 10 33 D2 E8 ?? ?? ?? ?? 8D 84 B3 1C 01 00 00 8B F0 8A 4E 02 8A 56 01 8A 06 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 80 BB D5 00 00 00 00 74 1D 8A 4E 02 8A 56 01 8A 06 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 80 3C 24 00 75 22 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B 83 18 01 00 00 E8 ?? ?? ?? ?? E9 AE 00 00 00 80 BB D5 00 00 00 00 74 43 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 6A FF 6A FF 8D 44 24 0C 50 E8 ?? ?? ?? ?? 8D 44 24 04 50 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 62 8B 9B 18 01 00 00 8B 43 10 33 D2 E8 ?? ?? ?? ?? 8B 43 10 B2 03 E8 ?? ?? ?? ?? 8B 44 24 0C 50 8B 44 24 14 50 8B 4C 24 10 8B 54 24 0C 8B C3 E8 ?? ?? ?? ?? 8B 43 10 B2 04 E8 ?? ?? ?? ?? 8B 44 24 0C 83 E8 02 50 8B 44 24 14 83 E8 02 50 8B 4C 24 10 83 C1 02 8B 54 24 0C 83 C2 02 8B C3 E8 ?? ?? ?? ?? 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1983_0 {
	meta:
		name = "_NF__CA"
		size = 10
	strings:
		$1 = { 84 C0 74 03 8B C2 C3 8B C1 C3 }
	condition:
		$1
}

rule function_1984_0 {
	meta:
		name = "_NF__CB"
		size = 675
		refs = "0014 _NF__CB 0027 TCanvas.GetHandle 002d SetBkMode 005b SFB 0060 LoadResString 006a SFG 009a _NF__CA 00d7 RGB 00e7 TFont.SetColor 013a @LStrToPChar 014c DrawText 0187 SBG 0290 @LStrClr 0296 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 01 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 80 BB 78 01 00 00 00 0F 84 10 01 00 00 8B 83 70 01 00 00 3B 83 74 01 00 00 75 18 80 BB 79 01 00 00 00 74 0F 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 70 01 00 00 83 F8 08 7C 03 83 C0 04 8B 84 83 1C 01 00 00 89 45 FC 80 7D FC 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FC 80 7D FD 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FD 80 7D FE 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FE 8A 4D FE 8A 55 FD 8A 45 FC E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B 83 70 01 00 00 99 F7 BB 88 01 00 00 8B CA 8B BB 80 01 00 00 0F AF CF 89 4D E8 03 CF 89 4D F0 8B 83 70 01 00 00 99 F7 BB 88 01 00 00 8B C8 8B BB 84 01 00 00 0F AF CF 89 4D EC 03 CF 89 4D F4 68 25 01 00 00 8D 45 E8 50 6A FF 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 BB 79 01 00 00 00 0F 84 10 01 00 00 8B 83 70 01 00 00 3B 83 74 01 00 00 75 18 80 BB 78 01 00 00 00 74 0F 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 74 01 00 00 83 F8 08 7C 03 83 C0 04 8B 84 83 1C 01 00 00 89 45 FC 80 7D FC 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FC 80 7D FD 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FD 80 7D FE 80 0F 93 C0 B9 FF 00 00 00 33 D2 E8 ?? ?? ?? ?? 88 45 FE 8A 4D FE 8A 55 FD 8A 45 FC E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B 83 74 01 00 00 99 F7 BB 88 01 00 00 8B CA 8B BB 80 01 00 00 0F AF CF 89 4D E8 03 CF 89 4D F0 8B 83 74 01 00 00 99 F7 BB 88 01 00 00 8B C8 8B BB 84 01 00 00 0F AF CF 89 4D EC 03 CF 89 4D F4 68 25 01 00 00 8D 45 E8 50 6A FF 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 56 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1985_0 {
	meta:
		name = "TColorGrid.EnableForeground"
		size = 68
		refs = "0037 _NF__C9 003e _NF__CB"
	strings:
		$1 = { 53 8B D8 3A 93 78 01 00 00 74 37 88 93 78 01 00 00 8B 83 70 01 00 00 3B 83 7C 01 00 00 75 09 80 BB 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B 93 70 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1986_0 {
	meta:
		name = "TColorGrid.EnableBackground"
		size = 68
		refs = "0037 _NF__C9 003e _NF__CB"
	strings:
		$1 = { 53 8B D8 3A 93 79 01 00 00 74 37 88 93 79 01 00 00 8B 83 74 01 00 00 3B 83 7C 01 00 00 75 09 80 BB 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B 93 74 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1987_0 {
	meta:
		name = "TColorGrid.GetForegroundColor"
		size = 37
		refs = "001f RGB"
	strings:
		$1 = { 53 8B 90 70 01 00 00 83 FA 08 7C 03 83 C2 04 8D 9C 90 1C 01 00 00 8A 4B 02 8A 53 01 8A 03 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1988_0 {
	meta:
		name = "TColorGrid.GetBackgroundColor"
		size = 37
		refs = "001f RGB"
	strings:
		$1 = { 53 8B 90 74 01 00 00 83 FA 08 7C 03 83 C2 04 8D 9C 90 1C 01 00 00 8A 4B 02 8A 53 01 8A 03 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1989_0 {
	meta:
		name = "TColorGrid.WMSetFocus"
		size = 47
		refs = "0018 _NF__C9 001f _NF__CB 0028 TWinControl.WMSetFocus"
	strings:
		$1 = { 53 56 8B F2 8B D8 C6 83 91 01 00 00 01 B1 01 8B 93 7C 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1990_0 {
	meta:
		name = "TColorGrid.WMKillFocus"
		size = 47
		refs = "0018 _NF__C9 001f _NF__CB 0028 TWinControl.WMKillFocus"
	strings:
		$1 = { 53 56 8B F2 8B D8 C6 83 91 01 00 00 00 33 C9 8B 93 7C 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1991_0 {
	meta:
		name = "TColorGrid.KeyDown"
		size = 520
		refs = "0014 TWinControl.KeyDown 004c TColorGrid.KeyDown 00d7 _NF__C9 00ea TColorGrid.SetForegroundIndex 00f3 TColorGrid.SetSelection 00fe @CallDynaInst 0159 TColorGrid.SetBackgroundIndex"
	strings:
		$1 = { 53 56 57 55 51 88 0C 24 8B EA 8B F0 8B D5 8A 0C 24 8B C6 E8 ?? ?? ?? ?? 8B 8E 7C 01 00 00 8B F9 8B 9E 88 01 00 00 8B C3 F7 AE 8C 01 00 00 0F B7 55 00 83 FA 27 7F 35 0F 84 8D 01 00 00 83 C2 E0 83 FA 06 0F 87 94 01 00 00 FF 24 95 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 FA 46 7F 19 74 25 83 EA 28 0F 84 25 01 00 00 83 EA 1A 0F 84 82 00 00 00 E9 53 01 00 00 83 EA 62 74 78 83 EA 04 0F 85 45 01 00 00 80 BE 78 01 00 00 00 75 44 80 BE 6C 01 00 00 00 74 3B C6 86 78 01 00 00 01 8B 86 70 01 00 00 3B 86 7C 01 00 00 75 09 80 BE 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B 96 70 01 00 00 8B C6 E8 ?? ?? ?? ?? C7 86 70 01 00 00 FF FF FF FF 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB F0 FF E8 ?? ?? ?? ?? E9 E4 00 00 00 80 BE 79 01 00 00 00 75 44 80 BE 6C 01 00 00 00 74 3B C6 86 79 01 00 00 01 8B 86 74 01 00 00 3B 86 7C 01 00 00 75 09 80 BE 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B 96 74 01 00 00 8B C6 E8 ?? ?? ?? ?? C7 86 74 01 00 00 FF FF FF FF 8B D7 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB F0 FF E8 ?? ?? ?? ?? EB 78 33 FF EB 74 3B D9 7F 06 8B F9 2B FB EB 6A 85 C9 74 09 8B F8 2B FB 03 F9 4F EB 5D 8B F8 4F EB 58 85 C9 74 05 8B F9 4F EB 4F 8B F8 4F EB 4A 8B D1 03 D3 3B C2 7E 0E 8B BE 7C 01 00 00 03 BE 88 01 00 00 EB 34 48 3B C8 74 0A 8B C1 99 F7 FB 8B FA 47 EB 25 33 FF EB 21 48 3B C8 74 05 8B F9 47 EB 17 33 FF EB 13 8B F8 4F EB 0E 8B D5 8A 0C 24 8B C6 E8 ?? ?? ?? ?? EB 17 66 C7 45 00 00 00 3B BE 7C 01 00 00 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1992_0 {
	meta:
		name = "TColorGrid.WMGetDlgCode"
		size = 8
		altNames = "TDBCtrlGrid.WMGetDlgCode TDBLookupControl.WMGetDlgCode"
	strings:
		$1 = { C7 42 0C 81 00 00 00 C3 }
	condition:
		$1
}

rule function_1993_0 {
	meta:
		name = "TColorGrid.WMSize"
		size = 21
		refs = "0006 TWinControl.WMSize 000f _NF__10C"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13761_0 {
	meta:
		name = "TCustomMemo.Loaded"
		size = 21
		refs = "0006 TComponent.Loaded 000f TCustomEdit.SetModified"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2425_0 {
	meta:
		name = "TCustomRichEdit.Clear"
		size = 21
		refs = "0006 TCustomEdit.Clear 000f TCustomEdit.SetModified"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5059_0 {
	meta:
		name = "TDBLookupComboBox.CMFontChanged"
		size = 21
		refs = "0006 TWinControl.CMFontChanged 000f TControl.SetHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5062_0 {
	meta:
		name = "TDBLookupComboBox.WMKillFocus"
		size = 21
		refs = "0006 TDBLookupControl.WMKillFocus 000f TDBLookupComboBox.CloseUp"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5644_0 {
	meta:
		name = "TDatabase.Commit"
		size = 21
		refs = "0006 _NF__5AC 000f _NF__5B6"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11183_0 {
	meta:
		name = "TOleContainer.WMKillFocus"
		size = 21
		refs = "0006 TWinControl.WMKillFocus 000f _NF__2F9"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1995_0 {
	meta:
		name = "TColorGrid.MouseDown"
		size = 281
		refs = "001e TControl.MouseDown 0037 TColorGrid.SquareFromPos 0080 _NF__C9 0093 TColorGrid.SetForegroundIndex 009e TControl.SetMouseCapture 00f4 TColorGrid.SetBackgroundIndex 00fd TColorGrid.SetSelection"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FF 8B DA 8B F8 8B 75 0C 56 8B 45 08 50 8A 4D FF 8B D3 8B C7 E8 ?? ?? ?? ?? 88 9F 9C 01 00 00 C6 87 9D 01 00 00 01 8B 4D 08 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F0 84 DB 75 58 80 BF 78 01 00 00 00 75 44 80 BF 6C 01 00 00 00 74 3B C6 87 78 01 00 00 01 8B 87 70 01 00 00 3B 87 7C 01 00 00 75 09 80 BF 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B 97 70 01 00 00 8B C7 E8 ?? ?? ?? ?? C7 87 70 01 00 00 FF FF FF FF 8B D6 8B C7 E8 ?? ?? ?? ?? EB 5F B2 01 8B C7 E8 ?? ?? ?? ?? 80 BF 79 01 00 00 00 75 44 80 BF 6C 01 00 00 00 74 3B C6 87 79 01 00 00 01 8B 87 74 01 00 00 3B 87 7C 01 00 00 75 09 80 BF 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B 97 74 01 00 00 8B C7 E8 ?? ?? ?? ?? C7 87 74 01 00 00 FF FF FF FF 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 80 BF D4 00 00 00 00 74 07 8B C7 8B 10 FF 52 78 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1996_0 {
	meta:
		name = "TColorGrid.MouseMove"
		size = 98
		refs = "001a TControl.MouseMove 002e TColorGrid.SquareFromPos 0042 TColorGrid.SetForegroundIndex 004d TColorGrid.SetBackgroundIndex 0056 TColorGrid.SetSelection"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 88 55 FF 8B D8 8B 7D 08 57 8B CE 8A 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB 9D 01 00 00 00 74 33 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F0 80 BB 9C 01 00 00 00 75 0B 8B D6 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1997_0 {
	meta:
		name = "TColorGrid.MouseUp"
		size = 59
		refs = "0018 TControl.MouseUp 0031 TControl.SetMouseCapture"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 8B 45 0C 50 8B 45 08 50 8A 4D FF 8B C3 E8 ?? ?? ?? ?? C6 83 9D 01 00 00 00 80 BB 9C 01 00 00 01 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1998_0 {
	meta:
		name = "TColorGrid.Paint"
		size = 113
		refs = "0011 TCanvas.SetFont 0043 _NF__C9 0067 _NF__CB"
	strings:
		$1 = { 53 56 57 55 51 8B D8 8B 53 50 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 8B 83 8C 01 00 00 85 C0 7C 32 40 89 04 24 33 ED 8B B3 88 01 00 00 85 F6 7C 1C 46 33 FF 8B C5 F7 AB 88 01 00 00 03 C7 33 C9 8B D0 8B C3 E8 ?? ?? ?? ?? 47 4E 75 E7 45 FF 0C 24 75 D4 8A 8B 91 01 00 00 8B 93 7C 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1999_0 {
	meta:
		name = "TColorGrid.SetBackgroundIndex"
		size = 138
		refs = "003b _NF__C9 0078 _NF__CB 0083 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 74 01 00 00 3B F0 74 77 80 BB 79 01 00 00 00 74 6E 8B 93 74 01 00 00 3B 93 7C 01 00 00 75 09 80 BB 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 89 83 74 01 00 00 3B 83 70 01 00 00 75 26 8B 93 74 01 00 00 3B 93 7C 01 00 00 75 09 80 BB 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BB DB FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2000_0 {
	meta:
		name = "TColorGrid.SetForegroundIndex"
		size = 138
		refs = "003b _NF__C9 0078 _NF__CB 0083 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 70 01 00 00 3B F0 74 77 80 BB 78 01 00 00 00 74 6E 8B 93 70 01 00 00 3B 93 7C 01 00 00 75 09 80 BB 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 89 83 70 01 00 00 3B 83 74 01 00 00 75 26 8B 93 70 01 00 00 3B 93 7C 01 00 00 75 09 80 BB 91 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BB DB FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2001_0 {
	meta:
		name = "TColorGrid.SetGridOrdering"
		size = 60
		refs = "0036 _NF__10C"
	strings:
		$1 = { 53 3A 90 90 01 00 00 74 31 8B DA 88 98 90 01 00 00 8B CB BA 10 00 00 00 D3 EA 89 90 88 01 00 00 8A 88 90 01 00 00 BA 01 00 00 00 D3 E2 89 90 8C 01 00 00 B2 01 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2002_0 {
	meta:
		name = "TColorGrid.SetSelection"
		size = 60
		refs = "0017 _NF__C9 0035 _NF__CB"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 7C 01 00 00 3B F0 74 29 33 C9 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 89 83 7C 01 00 00 8A 8B 91 01 00 00 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2003_0 {
	meta:
		name = "TColorGrid.SquareFromPos"
		size = 76
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 38 48 3B F0 7E 04 8B F0 EB 06 85 F6 7D 02 33 F6 8B 43 3C 48 3B C8 7E 04 8B C8 EB 06 85 C9 7D 02 33 C9 8B C1 99 F7 BB 84 01 00 00 8B C8 0F AF 8B 88 01 00 00 8B C6 99 F7 BB 80 01 00 00 03 C8 8B C1 5E 5B C3 }
	condition:
		$1
}

rule function_2004_0 {
	meta:
		name = "_NF__10C"
		size = 124
		refs = "003c Bounds 0045 TControl.SetBoundsRect"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B DA 8B F0 8B 46 38 8B 8E 88 01 00 00 99 F7 F9 8B E8 0F AF E9 8B 46 3C 8B 8E 8C 01 00 00 99 F7 F9 8B F8 0F AF F9 57 8D 44 24 04 50 8B CD 8B 56 34 8B 46 30 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 8B 46 38 99 F7 BE 88 01 00 00 89 86 80 01 00 00 8B 46 3C 99 F7 BE 8C 01 00 00 89 86 84 01 00 00 84 DB 74 07 8B C6 8B 10 FF 52 44 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2005_0 {
	meta:
		name = "TColorGrid.Change"
		size = 36
		refs = "0006 TControl.Changed"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 66 83 BB 96 01 00 00 00 74 0E 8B D3 8B 83 98 01 00 00 FF 93 94 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2008_0 {
	meta:
		name = "_NF__6B1"
		size = 12
	strings:
		$1 = { FF FF FF FF 03 00 00 00 72 74 66 00 }
	condition:
		$1
}

rule function_2009_0 {
	meta:
		name = "_NF__6B3"
		size = 12
	strings:
		$1 = { FF FF FF FF 03 00 00 00 74 78 74 00 }
	condition:
		$1
}

rule function_2010_0 {
	meta:
		name = "InitCommonControl"
		size = 43
		refs = "0012 InitCommonControlsEx 0021 InitCommonControls"
	strings:
		$1 = { 53 83 C4 F8 C7 04 24 08 00 00 00 89 44 24 04 8B C4 E8 ?? ?? ?? ?? F7 D8 1B DB F7 DB 84 DB 75 05 E8 ?? ?? ?? ?? 8B C3 59 5A 5B C3 }
	condition:
		$1
}

rule function_2011_0 {
	meta:
		name = "CheckCommonControl"
		size = 99
		refs = "000c CheckCommonControl 0019 InitCommonControl 0025 sInvalidComCtl32 002a LoadResString 0034 _Dn_EComponentError 0039 Exception.Create 003e @RaiseExcept 0053 @LStrClr 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2013_0 {
	meta:
		name = "_NF__6BD"
		size = 45
		refs = "0010 TWinControl.GetHandle 0016 SendMessage 001f _NF__6BC 0027 _NF__6F9"
	strings:
		$1 = { 53 8B D8 6A 00 6A 00 68 09 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2014_0 {
	meta:
		name = "_NF__6BE"
		size = 48
		refs = "0012 TWinControl.GetHandle 0018 SendMessage 0021 _NF__6BC 0029 _NF__6F9"
	strings:
		$1 = { 53 56 8B F2 8B D8 6A 00 56 68 08 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2015_0 {
	meta:
		name = "_NF__6BF"
		size = 100
		refs = "0037 TWinControl.GetHandle 003d SendMessage 0046 _NF__6BC 0056 @LStrFromArray"
	strings:
		$1 = { 53 56 57 81 C4 04 F0 FF FF 50 83 C4 E4 8B F9 8B F2 8B D8 C7 04 24 01 00 00 00 8D 44 24 1C 89 44 24 0C C7 44 24 10 00 10 00 00 8B C4 50 56 68 05 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 8B C7 8D 54 24 1C B9 00 10 00 00 E8 ?? ?? ?? ?? 81 C4 1C 10 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2016_0 {
	meta:
		name = "_NF__6C0"
		size = 28
		refs = "0010 TWinControl.GetHandle 0016 SendMessage"
	strings:
		$1 = { 53 8B D8 6A 00 6A 00 68 04 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2017_0 {
	meta:
		name = "_NF__6C1"
		size = 58
		refs = "001d TWinControl.GetHandle 0023 SendMessage 002c _NF__6BC"
	strings:
		$1 = { 53 56 83 C4 E4 8B F2 8B D8 C7 04 24 08 00 00 00 8B C4 50 56 68 05 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 8B 44 24 18 83 C4 1C 5E 5B C3 }
	condition:
		$1
}

rule function_2018_0 {
	meta:
		name = "_NF__6C2"
		size = 77
		refs = "0016 @LStrToPChar 002b TWinControl.GetHandle 0031 SendMessage 003a _NF__6BC 0042 _NF__6F9"
	strings:
		$1 = { 53 56 57 83 C4 E4 8B F9 8B F2 8B D8 C7 04 24 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 44 24 0C 8B C4 50 56 68 06 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 83 C4 1C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2019_0 {
	meta:
		name = "_NF__6C3"
		size = 58
		refs = "0021 TWinControl.GetHandle 0027 SendMessage 0030 _NF__6BC"
	strings:
		$1 = { 53 56 83 C4 E4 8B F2 8B D8 C7 04 24 08 00 00 00 89 4C 24 18 8B C4 50 56 68 06 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B C3 }
	condition:
		$1
}

rule function_2020_0 {
	meta:
		name = "_NF__6C4"
		size = 77
		refs = "0016 @LStrToPChar 002b TWinControl.GetHandle 0031 SendMessage 003a _NF__6BC 0042 _NF__6F9"
	strings:
		$1 = { 53 56 57 83 C4 E4 8B F9 8B F2 8B D8 C7 04 24 01 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 44 24 0C 8B C4 50 56 68 07 13 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 7D 05 E8 ?? ?? ?? ?? 8B 43 0C E8 ?? ?? ?? ?? 83 C4 1C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2021_0 {
	meta:
		name = "_NF__6C5"
		size = 68
		refs = "001f TWinControl.GetHandle 0025 SendMessage 003c _NF__6F9"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B 7E 0C 88 9F 29 01 00 00 6A 00 8B C3 34 01 83 E0 7F 50 6A 0B 8B C7 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 F3 01 84 DB 74 10 8B 46 0C 8B 10 FF 52 44 8B 46 0C E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2022_0 {
	meta:
		name = "TCustomTabControl.Create"
		size = 128
		refs = "000e @ClassCreate 001c TWinControl.Create 0028 TControl.SetWidth 0034 TControl.SetHeight 003d TWinControl.SetTabStop 0043 TCustomTabControl.Create 004e _NV__6BA 0053 TObject.Create"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? BA 21 01 00 00 8B C3 E8 ?? ?? ?? ?? BA C1 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 66 89 43 40 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 18 01 00 00 89 5E 0C 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 81 00 00 00 }
	condition:
		$1
}

rule function_2023_0 {
	meta:
		name = "TCustomTabControl.Destroy"
		size = 56
		refs = "000d TObject.Free 0024 TWinControl.Destroy 002f @ClassDestroy"
		altNames = "TScrollingWinControl.Destroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2024_0 {
	meta:
		name = "TCustomTabControl.CanChange"
		size = 40
		altNames = "TCustomUpDown.CanChange"
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 3A 01 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 3C 01 00 00 FF 93 38 01 00 00 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2025_0 {
	meta:
		name = "TCustomTabControl.Change"
		size = 29
		altNames = "TScrollBox.Resize TStatusBar.Resize"
	strings:
		$1 = { 53 66 83 B8 32 01 00 00 00 74 10 8B D8 8B D0 8B 83 34 01 00 00 FF 93 30 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2026_0 {
	meta:
		name = "TCustomTabControl.CreateParams"
		size = 180
		refs = "000c InitCommonControl 0015 TWinControl.CreateParams 001a TCustomTabControl.CreateParams 0023 TWinControl.CreateSubClass 003a _NV__6D1"
	strings:
		$1 = { 53 56 8B F2 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 46 04 0D 00 00 00 02 33 D2 8A 93 2C 01 00 00 0B 04 95 ?? ?? ?? ?? 89 46 04 80 BB D4 00 00 00 00 75 07 81 4E 04 00 80 00 00 80 BB 28 01 00 00 00 74 07 81 4E 04 00 02 00 00 66 83 BB 24 01 00 00 00 74 07 81 4E 04 00 04 00 00 80 BB 2A 01 00 00 00 74 0A F6 43 20 10 75 04 83 4E 04 40 80 BB 2B 01 00 00 00 74 04 83 4E 04 01 8B 46 24 83 E0 FC 83 C8 08 89 46 24 5E 5B C3 00 00 00 53 79 73 54 61 62 43 6F 6E 74 72 6F 6C 33 32 00 }
	condition:
		$1
}

rule function_2027_0 {
	meta:
		name = "TCustomTabControl.CreateWnd"
		size = 85
		refs = "0007 TWinControl.CreateWnd 0017 _NF__6FA 003b TCustomTabControl.SetTabIndex 0046 TObject.Free"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 83 BB 24 01 00 00 00 74 07 8B C3 E8 ?? ?? ?? ?? 8B B3 1C 01 00 00 85 F6 74 2D 8B D6 8B 83 18 01 00 00 8B 08 FF 51 08 8B 93 20 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B 83 1C 01 00 00 E8 ?? ?? ?? ?? 33 C0 89 83 1C 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2028_0 {
	meta:
		name = "TCustomTabControl.DestroyWnd"
		size = 75
		refs = "0016 _Dn_TStringList 001b TObject.Create 0037 TCustomTabControl.GetTabIndex 0044 TWinControl.DestroyWnd"
	strings:
		$1 = { 53 56 8B D8 8B 83 18 01 00 00 8B 10 FF 52 14 85 C0 7E 2E B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 1C 01 00 00 8B 93 18 01 00 00 8B C6 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 89 83 20 01 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2029_0 {
	meta:
		name = "TCustomTabControl.AlignControls"
		size = 56
		refs = "0011 TCustomTabControl.GetDisplayRect 002d TWinControl.AlignControls"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F1 8B FA 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 56 57 8B FE 8D 74 24 08 B9 04 00 00 00 F3 A5 5F 5E 8B CE 8B D7 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2030_0 {
	meta:
		name = "TCustomTabControl.GetDisplayRect"
		size = 43
		refs = "001a TWinControl.GetHandle 0020 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 2C 56 6A 00 68 28 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 46 04 02 5E 5B C3 }
	condition:
		$1
}

rule function_2031_0 {
	meta:
		name = "TCustomTabControl.GetTabIndex"
		size = 27
		refs = "000f TWinControl.GetHandle 0015 SendMessage"
	strings:
		$1 = { 53 8B D8 6A 00 6A 00 68 0B 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2032_0 {
	meta:
		name = "TCustomTabControl.SetHotTrack"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
		altNames = "THeader.SetBorderStyle"
	strings:
		$1 = { 3A 90 2A 01 00 00 74 0B 88 90 2A 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2033_0 {
	meta:
		name = "TCustomTabControl.SetMultiLine"
		size = 30
		refs = "0019 TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 28 01 00 00 74 15 88 90 28 01 00 00 84 D2 75 06 88 90 2B 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2034_0 {
	meta:
		name = "TCustomTabControl.SetScrollOpposite"
		size = 30
		refs = "0019 TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 2B 01 00 00 74 15 88 90 2B 01 00 00 84 D2 74 06 88 90 28 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2035_0 {
	meta:
		name = "TCustomTabControl.SetTabHeight"
		size = 170
		refs = "0018 TCustomTabControl.SetTabHeight 0039 TObject.ClassName 0057 SPropertyOutOfRange 005c LoadResString 0069 _Dn_EInvalidOperation 006e Exception.CreateFmt 0073 @RaiseExcept 0081 _NF__6FA 0099 @LStrClr 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 33 C9 89 8D F4 FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 3B 93 26 01 00 00 74 5A 66 85 D2 7D 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 89 93 26 01 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2036_0 {
	meta:
		name = "TCustomTabControl.SetTabIndex"
		size = 30
		refs = "0011 TWinControl.GetHandle 0017 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 6A 00 56 68 0C 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2037_0 {
	meta:
		name = "TCustomListBox.SetStyle"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
		altNames = "TCustomListView.SetMultiSelect TCustomTabControl.SetTabPosition TDateTimePicker.SetDateFormat TScrollBox.SetBorderStyle"
	strings:
		$1 = { 3A 90 2C 01 00 00 74 0B 88 90 2C 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2038_0 {
	meta:
		name = "TCustomComboBox.SetItems"
		size = 16
		altNames = "TCustomListBox.SetItems TCustomTabControl.SetTabs"
	strings:
		$1 = { 56 8B F0 8B 86 18 01 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_2039_0 {
	meta:
		name = "TCustomTabControl.SetTabWidth"
		size = 196
		refs = "0018 TCustomTabControl.SetTabWidth 0039 TObject.ClassName 0057 SPropertyOutOfRange 005c LoadResString 0069 _Dn_EInvalidOperation 006e Exception.CreateFmt 0073 @RaiseExcept 0092 TWinControl.RecreateWnd 009b _NF__6FA 00b3 @LStrClr 00b9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 33 C9 89 8D F4 FE FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 3B 93 24 01 00 00 74 74 66 85 D2 7D 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 8B 83 24 01 00 00 66 89 93 24 01 00 00 66 85 C0 74 05 66 85 D2 75 09 8B C3 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2040_0 {
	meta:
		name = "_NF__6F9"
		size = 63
		refs = "000f TWinControl.HandleAllocated 002c TWinControl.GetHandle 0032 SendMessage 0039 TWinControl.Realign"
	strings:
		$1 = { 53 8B D8 80 BB 29 01 00 00 00 75 31 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1F 0F B7 43 38 0F B7 53 3C C1 E2 10 0B C2 50 6A 00 6A 05 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2041_0 {
	meta:
		name = "_NF__6FA"
		size = 39
		refs = "0014 TWinControl.GetHandle 001a SendMessage 0021 _NF__6F9"
	strings:
		$1 = { 53 8B D8 8B 83 24 01 00 00 50 6A 00 68 29 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2042_0 {
	meta:
		name = "TCustomTabControl.WMDestroy"
		size = 67
		refs = "0008 GetFocus 0015 TWinControl.GetHandle 0027 IsChild 0032 SetFocus 003b TWinControl.WMDestroy"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 E8 ?? ?? ?? ?? 8B F0 85 F6 74 24 8B C3 E8 ?? ?? ?? ?? 3B F0 74 12 56 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 6A 00 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2043_0 {
	meta:
		name = "TCustomTabControl.WMEraseBkgnd"
		size = 31
		refs = "001a TWinControl.WMEraseBkgnd"
	strings:
		$1 = { 80 B8 14 01 00 00 00 74 10 8B 4A 04 3B 4A 08 74 08 C7 42 0C 01 00 00 00 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2044_0 {
	meta:
		name = "TCoolBar.WMNotifyFormat"
		size = 36
		refs = "0014 TWinControl.GetHandle 001a DefWindowProc"
		altNames = "TCustomTabControl.WMNotifyFormat TToolBar.WMNotifyFormat"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 43 08 50 8B 43 04 50 8B 03 50 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 43 0C 5E 5B C3 }
	condition:
		$1
}

rule function_2045_0 {
	meta:
		name = "TCustomTabControl.WMSize"
		size = 31
		refs = "0006 TWinControl.WMSize 0013 TWinControl.GetHandle 0019 RedrawWindow"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 6A 05 6A 00 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2046_0 {
	meta:
		name = "TCustomTabControl.CMFontChanged"
		size = 39
		refs = "0006 TWinControl.CMFontChanged 000d TWinControl.HandleAllocated 0021 TControl.Perform"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 6A 00 33 C9 BA 05 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2047_0 {
	meta:
		name = "TCoolBar.CMSysColorChange"
		size = 39
		refs = "000b TWinControl.CMSysColorChange"
		altNames = "TCustomTabControl.CMSysColorChange TCustomTreeView.CMSysColorChange"
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B C6 E8 ?? ?? ?? ?? F6 46 20 01 75 0F C7 07 15 00 00 00 8B D7 8B C6 8B 08 FF 51 F0 5F 5E C3 }
	condition:
		$1
}

rule function_2048_0 {
	meta:
		name = "TCustomTabControl.CMTabStopChanged"
		size = 12
		refs = "0007 TWinControl.RecreateWnd"
	strings:
		$1 = { F6 40 20 10 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2049_0 {
	meta:
		name = "TCustomTabControl.CNNotify"
		size = 67
		refs = "001e @CallDynaInst"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 47 08 8B 40 08 2D D8 FD FF FF 74 10 48 75 28 8B C6 66 BB DA FF E8 ?? ?? ?? ?? EB 1B C7 47 0C 01 00 00 00 8B C6 66 BB DB FF E8 ?? ?? ?? ?? 84 C0 74 05 33 C0 89 47 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2050_0 {
	meta:
		name = "TTabSheet.Create"
		size = 92
		refs = "000a @ClassCreate 0017 TWinControl.Create 0020 TControl.SetAlign 0026 TTabSheet.Create 0037 TControl.SetVisible"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 05 8B C6 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 66 0B 46 40 66 89 46 40 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 1C 01 00 00 01 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 00 01 04 00 00 }
	condition:
		$1
}

rule function_2051_0 {
	meta:
		name = "TTabSheet.Destroy"
		size = 51
		refs = "0013 _NF__74E 001f TWinControl.Destroy 002a @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 18 01 00 00 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2052_0 {
	meta:
		name = "TTabSheet.GetPageIndex"
		size = 27
		refs = "0012 TList.IndexOf"
	strings:
		$1 = { 8B 90 18 01 00 00 85 D2 74 0D 8B 92 40 01 00 00 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_2053_0 {
	meta:
		name = "TTabSheet.GetTabIndex"
		size = 77
		refs = "0017 TTabSheet.GetPageIndex 0034 TList.Get"
	strings:
		$1 = { 53 56 57 55 8B F0 33 ED 80 BE 1D 01 00 00 00 75 03 4D EB 32 8B C6 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 24 43 33 FF 8B 86 18 01 00 00 8B 80 40 01 00 00 8B D7 E8 ?? ?? ?? ?? 80 B8 1D 01 00 00 00 74 01 45 47 4B 75 DF 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2054_0 {
	meta:
		name = "TCustomGroupBox.CreateParams"
		size = 16
		refs = "0006 TWinControl.CreateParams"
		altNames = "TDBCtrlPanel.CreateParams TScrollingWinControl.CreateParams TTabSet.CreateParams TTabSheet.CreateParams"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? 83 63 24 FC 5B C3 }
	condition:
		$1
}

rule function_2055_0 {
	meta:
		name = "TTabSheet.ReadState"
		size = 49
		refs = "000c TWinControl.ReadState 0017 _DV_TPageControl 001c @IsClass 0029 TTabSheet.SetPageControl"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 28 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_3954_0 {
	meta:
		name = "TField.ReadState"
		size = 49
		refs = "000c TComponent.ReadState 0017 _DV_TDataSet 001c @IsClass 0029 TField.SetDataSet"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 28 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2056_0 {
	meta:
		name = "TTabSheet.SetPageControl"
		size = 52
		refs = "0017 _NF__74E 002d _NF__74B"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 18 01 00 00 3B F0 74 21 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 51 3C 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2057_0 {
	meta:
		name = "TTabSheet.SetPageIndex"
		size = 212
		refs = "0016 TTabSheet.SetPageIndex 0054 sPageIndexError 0059 LoadResString 0063 _Dn_EListError 0068 Exception.CreateFmt 006d @RaiseExcept 0074 TTabSheet.GetTabIndex 007d TTabSheet.GetPageIndex 0092 TList.Move 00ac _NF__74D 00c1 @LStrClr 00c7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 18 01 00 00 85 C0 0F 84 82 00 00 00 8B 80 40 01 00 00 8B 78 08 4F 3B FE 7D 35 89 75 F0 C6 45 F4 00 89 7D F8 C6 45 FC 00 8D 45 F0 50 6A 01 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 80 40 01 00 00 8B CE E8 ?? ?? ?? ?? 85 FF 7C 16 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D7 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2058_0 {
	meta:
		name = "_NF__72A"
		size = 59
		refs = "001f _NF__74C 002e _NF__73C"
	strings:
		$1 = { 53 8B D8 3A 93 1D 01 00 00 74 2E 84 D2 74 16 C6 83 1D 01 00 00 01 8B D3 8B 83 18 01 00 00 E8 ?? ?? ?? ?? EB 14 8B D3 8B 83 18 01 00 00 E8 ?? ?? ?? ?? C6 83 1D 01 00 00 00 5B C3 }
	condition:
		$1
}

rule function_2059_0 {
	meta:
		name = "TTabSheet.SetTabVisible"
		size = 20
		refs = "000f _NF__72E"
	strings:
		$1 = { 3A 90 1C 01 00 00 74 0B 88 90 1C 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13839_0 {
	meta:
		name = "TCustomCheckBox.SetAlignment"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 1C 01 00 00 74 0B 88 90 1C 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13894_0 {
	meta:
		name = "TCustomListBox.SetBorderStyle"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 1C 01 00 00 74 0B 88 90 1C 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13851_0 {
	meta:
		name = "TRadioButton.SetAlignment"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 1C 01 00 00 74 0B 88 90 1C 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2060_0 {
	meta:
		name = "_NF__72E"
		size = 30
		refs = "0019 _NF__72A"
	strings:
		$1 = { 83 B8 18 01 00 00 00 74 09 80 B8 1C 01 00 00 00 75 04 33 D2 EB 02 B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2061_0 {
	meta:
		name = "TTabSheet.CMTextChanged"
		size = 23
		refs = "0012 _NF__75C"
	strings:
		$1 = { 80 B8 1D 01 00 00 00 74 0D 8B D0 8B 80 18 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2062_0 {
	meta:
		name = "TPageControl.Create"
		size = 80
		refs = "000a @ClassCreate 0017 TCustomTabControl.Create 001d TPageControl.Create 0028 _Dn_TList 002d TObject.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 66 89 46 40 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 40 01 00 00 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 C0 00 00 00 }
	condition:
		$1
}

rule function_2063_0 {
	meta:
		name = "TPageControl.Destroy"
		size = 91
		refs = "0022 TList.Get 0039 TObject.Free 0045 TCustomTabControl.Destroy 0050 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F0 8B 86 40 01 00 00 8B 68 08 4D 85 ED 7C 1C 45 33 FF 8B D7 8B 86 40 01 00 00 E8 ?? ?? ?? ?? 33 D2 89 90 18 01 00 00 47 4D 75 E7 8B 86 40 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2064_0 {
	meta:
		name = "TPageControl.Change"
		size = 56
		refs = "0006 _NF__75D 0013 GetParentForm 0032 TCustomTabControl.Change"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 20 10 74 1F 8B C3 E8 ?? ?? ?? ?? 85 C0 74 14 83 B8 54 01 00 00 00 74 0B 8B 80 54 01 00 00 8B 10 FF 52 04 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2065_0 {
	meta:
		name = "_NF__73B"
		size = 218
		refs = "0016 GetParentForm 0036 TWinControl.ContainsControl 0047 TCustomForm.SetActiveControl 0052 TControl.BringToFront 005b TControl.SetVisible 007d TWinControl.CanFocus 00d2 TWinControl.SelectFirst"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 3B BB 44 01 00 00 0F 84 C3 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 74 2B 83 BB 44 01 00 00 00 74 22 8B 96 2C 01 00 00 8B 83 44 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 0D 8B 93 44 01 00 00 8B C6 E8 ?? ?? ?? ?? 85 FF 74 4A 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 85 F6 74 36 83 BB 44 01 00 00 00 74 2D 8B 86 2C 01 00 00 3B 83 44 01 00 00 75 1F 8B C7 E8 ?? ?? ?? ?? 84 C0 74 0B 8B D7 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 83 44 01 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 89 BB 44 01 00 00 85 F6 74 22 83 BB 44 01 00 00 00 74 19 8B 86 2C 01 00 00 3B 83 44 01 00 00 75 0B 8B 83 44 01 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2066_0 {
	meta:
		name = "_NF__73C"
		size = 36
		refs = "0009 TTabSheet.GetTabIndex 001d _NF__75D"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 08 FF 51 44 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2067_0 {
	meta:
		name = "TPageControl.FindNextPage"
		size = 136
		refs = "0019 TList.IndexOf 0067 TList.Get"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FF 8B F0 8B 86 40 01 00 00 83 78 08 00 74 66 E8 ?? ?? ?? ?? 8B F8 83 FF FF 75 14 80 7D FF 00 74 0C 8B 86 40 01 00 00 8B 78 08 4F EB 02 33 FF 8B DF 80 7D FF 00 74 10 43 8B 86 40 01 00 00 3B 58 08 75 12 33 DB EB 0E 85 DB 75 09 8B 86 40 01 00 00 8B 58 08 4B 8B D3 8B 86 40 01 00 00 E8 ?? ?? ?? ?? 80 7D 08 00 74 0F 80 B8 1C 01 00 00 00 75 06 3B FB 75 BC 33 C0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2068_0 {
	meta:
		name = "TPageControl.GetChildren"
		size = 64
		refs = "0029 TList.Get"
		altNames = "TTabbedNotebook.GetChildren"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC 8B 80 40 01 00 00 8B 58 08 4B 85 DB 7C 1F 43 33 F6 8B D6 8B 45 FC 8B 80 40 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 46 4B 75 E4 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2069_0 {
	meta:
		name = "TPageControl.GetPage"
		size = 12
		refs = "0007 TList.Get"
	strings:
		$1 = { 8B 80 40 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2642_0 {
	meta:
		name = "TCustomListView.GetColumnFromIndex"
		size = 12
		refs = "0007 TListColumns.GetItem"
	strings:
		$1 = { 8B 80 40 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5406_0 {
	meta:
		name = "TDBLookupCombo.SetDataField"
		size = 12
		refs = "0007 TFieldDataLink.SetFieldName"
	strings:
		$1 = { 8B 80 40 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2070_0 {
	meta:
		name = "TPageControl.GetPageCount"
		size = 10
	strings:
		$1 = { 8B 80 40 01 00 00 8B 40 08 C3 }
	condition:
		$1
}

rule function_2071_0 {
	meta:
		name = "_NF__74B"
		size = 35
		refs = "000f TList.Add 001c _NF__72E"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 83 40 01 00 00 E8 ?? ?? ?? ?? 89 9E 18 01 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2072_0 {
	meta:
		name = "_NF__74C"
		size = 102
		refs = "000f _NF__74C 0020 TControl.GetText 002b TTabSheet.GetTabIndex 0039 TStrings.InsertObject 0040 _NF__75D 0055 @LStrClr 005b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 59 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2073_0 {
	meta:
		name = "_NF__74D"
		size = 24
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B D7 8B 86 18 01 00 00 8B 18 FF 53 60 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2074_0 {
	meta:
		name = "_NF__74E"
		size = 56
		refs = "0013 TPageControl.SetActivePage 001c _NF__72A 0031 TList.Remove"
	strings:
		$1 = { 53 56 8B DA 8B F0 3B 9E 44 01 00 00 75 09 33 D2 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 89 83 18 01 00 00 8B D3 8B 86 40 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2075_0 {
	meta:
		name = "TPageControl.SelectNextPage"
		size = 82
		refs = "0012 TPageControl.FindNextPage 002b @CallDynaInst 0036 TTabSheet.GetTabIndex 003f TCustomTabControl.SetTabIndex"
	strings:
		$1 = { 53 56 57 8B F0 6A 01 8B CA 8B C6 8B 96 44 01 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 74 32 3B BE 44 01 00 00 74 2A 8B C6 66 BB DB FF E8 ?? ?? ?? ?? 84 C0 74 1B 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BB DA FF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2076_0 {
	meta:
		name = "TPageControl.SetActivePage"
		size = 62
		refs = "0017 _NF__73B 0022 TTabSheet.GetTabIndex 002b TCustomTabControl.SetTabIndex"
	strings:
		$1 = { 53 56 8B DA 8B F0 85 DB 74 08 3B B3 18 01 00 00 75 29 8B D3 8B C6 E8 ?? ?? ?? ?? 85 DB 74 12 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? EB 0A 83 CA FF 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2077_0 {
	meta:
		name = "TPageControl.SetChildOrder"
		size = 10
		refs = "0005 TTabSheet.SetPageIndex"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5716_0 {
	meta:
		name = "TBDEDataSet.BCDToCurr"
		size = 10
		refs = "0005 FMTBCDToCurr"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4565_0 {
	meta:
		name = "TClientDataSet.BCDToCurr"
		size = 10
		refs = "0005 FMTBCDToCurr"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2457_0 {
	meta:
		name = "TCustomRichEdit.RegisterConversionFormat"
		size = 10
		refs = "0005 _NF__B2A"
	strings:
		$1 = { 8B C2 8B D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2078_0 {
	meta:
		name = "TPageControl.ShowControl"
		size = 52
		refs = "000a _DV_TTabSheet 000f @IsClass 0024 TPageControl.SetActivePage 002d TWinControl.ShowControl"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 3B 9E 18 01 00 00 75 09 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2079_0 {
	meta:
		name = "_NF__75C"
		size = 94
		refs = "000f _NF__75C 001f TControl.GetText 002a TTabSheet.GetTabIndex 004d @LStrClr 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 59 8B 18 FF 53 20 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2080_0 {
	meta:
		name = "_NF__75D"
		size = 45
		refs = "0006 TCustomTabControl.GetTabIndex 0027 TPageControl.SetActivePage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 1D 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 83 18 01 00 00 8B 08 FF 51 18 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2081_0 {
	meta:
		name = "TPageControl.CMDesignHitTest"
		size = 91
		refs = "0012 SmallPointToPoint 0032 TWinControl.GetHandle 0038 SendMessage 0045 TCustomTabControl.GetTabIndex"
	strings:
		$1 = { 53 56 57 83 C4 EC 8B FA 8B D8 8D 54 24 0C 8B 47 08 E8 ?? ?? ?? ?? 8B 44 24 0C 89 04 24 8B 44 24 10 89 44 24 04 8B C4 50 6A 00 68 0D 13 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 12 8B C3 E8 ?? ?? ?? ?? 3B F0 74 07 C7 47 0C 01 00 00 00 83 C4 14 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2082_0 {
	meta:
		name = "TPageControl.CMDialogKey"
		size = 67
		refs = "0010 GetKeyState 0029 TPageControl.SelectNextPage 003c TWinControl.CMDialogKey"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 7E 04 09 75 2A 6A 11 E8 ?? ?? ?? ?? 66 85 C0 7D 1E 6A 10 E8 ?? ?? ?? ?? 66 85 C0 0F 9D C2 8B C3 E8 ?? ?? ?? ?? C7 46 0C 01 00 00 00 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2083_0 {
	meta:
		name = "TStatusPanel.Create"
		size = 57
		refs = "000a @ClassCreate 0022 TCollectionItem.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 C7 46 10 32 00 00 00 C6 46 15 01 33 D2 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2084_0 {
	meta:
		name = "TStatusPanel.Assign"
		size = 91
		refs = "000b _DV_TStatusPanel 0010 @IsClass 0020 TStatusPanel.SetText 002a TStatusPanel.SetWidth 0034 TStatusPanel.SetAlignment 003e TStatusPanel.SetBevel 0048 TStatusPanel.SetStyle 0053 TPersistent.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 36 8B FE 8B 57 0C 8B C3 E8 ?? ?? ?? ?? 8B 57 10 8B C3 E8 ?? ?? ?? ?? 8A 57 14 8B C3 E8 ?? ?? ?? ?? 8A 57 15 8B C3 E8 ?? ?? ?? ?? 8A 57 16 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2085_0 {
	meta:
		name = "THeaderSection.GetDisplayName"
		size = 33
		refs = "000c @LStrLAsg 001a TCollectionItem.GetDisplayName"
		altNames = "TListColumn.GetDisplayName TStatusPanel.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 0C E8 ?? ?? ?? ?? 83 3E 00 75 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2086_0 {
	meta:
		name = "THTMLTableColumn.SetAlign"
		size = 16
		refs = "000b TCollectionItem.Changed"
		altNames = "TStatusPanel.SetAlignment"
	strings:
		$1 = { 3A 50 14 74 0A 88 50 14 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2087_0 {
	meta:
		name = "TStatusPanel.SetBevel"
		size = 16
		refs = "000b TCollectionItem.Changed"
	strings:
		$1 = { 3A 50 15 74 0A 88 50 15 B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2088_0 {
	meta:
		name = "TStatusPanel.SetStyle"
		size = 16
		refs = "000b TCollectionItem.Changed"
	strings:
		$1 = { 3A 50 16 74 0A 88 50 16 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2089_0 {
	meta:
		name = "THeaderSection.SetText"
		size = 40
		refs = "000c @LStrCmp 0018 @LStrAsg 0021 TCollectionItem.Changed"
		altNames = "TStatusPanel.SetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 0C 8B D6 E8 ?? ?? ?? ?? 74 13 8D 43 0C 8B D6 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2090_0 {
	meta:
		name = "TStatusPanel.SetWidth"
		size = 16
		refs = "000b TCollectionItem.Changed"
	strings:
		$1 = { 3B 50 10 74 0A 89 50 10 B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2091_0 {
	meta:
		name = "TStatusPanels.Create"
		size = 59
		refs = "000b @ClassCreate 0017 _DV_TStatusPanel 0020 TCollection.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 0D ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 18 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_4200_0 {
	meta:
		name = "TCheckConstraints.Create"
		size = 59
		refs = "000b @ClassCreate 0017 _DV_TCheckConstraint 0020 TCollection.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 0D ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 18 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2827_0 {
	meta:
		name = "TCoolBands.Create"
		size = 59
		refs = "000b @ClassCreate 0017 _DV_TCoolBand 0020 TCollection.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 0D ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 18 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2122_0 {
	meta:
		name = "THeaderSections.Create"
		size = 59
		refs = "000b @ClassCreate 0017 _DV_THeaderSection 0020 TCollection.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 0D ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 18 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2506_0 {
	meta:
		name = "TListColumns.Create"
		size = 59
		refs = "000b @ClassCreate 0017 _DV_TListColumn 0020 TCollection.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B 0D ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 18 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2092_0 {
	meta:
		name = "TCheckConstraints.Add"
		size = 12
		refs = "0006 TCollection.Add"
		altNames = "TCookieCollection.Add TCoolBands.Add TDBGridColumns.Add TDimensionItems.Add THTMLTableColumns.Add THeaderSections.Add TListColumns.Add TStatusPanels.Add TWebActionItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10675_0 {
	meta:
		name = "TCubeDims.Add"
		size = 12
		refs = "0006 TDimensionItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10725_0 {
	meta:
		name = "TQueryDims.Add"
		size = 12
		refs = "0006 TDimensionItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14585_0 {
	meta:
		name = "_NF__394"
		size = 12
		refs = "0006 @LStrClr"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9737_0 {
	meta:
		name = "mci_HMS_Second"
		size = 12
		refs = "0006 HiWord"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9728_0 {
	meta:
		name = "mci_MSF_Frame"
		size = 12
		refs = "0006 HiWord"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9732_0 {
	meta:
		name = "mci_TMSF_Second"
		size = 12
		refs = "0006 HiWord"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2093_0 {
	meta:
		name = "TCheckConstraints.GetItem"
		size = 18
		refs = "000b TCollection.GetItem"
		altNames = "TCookieCollection.GetCookie TCoolBands.GetItem TDBGridColumns.GetColumn TDimensionItems.GetDimensionItem TDisplayDims.GetDisplayDim THTMLTableColumns.GetColumn THeaderSections.GetItem TListColumns.GetItem TStatusPanels.GetItem TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10673_0 {
	meta:
		name = "TCubeDims.GetCubeDim"
		size = 18
		refs = "000b TDimensionItems.GetDimensionItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13691_0 {
	meta:
		name = "TCustomLabel.GetLabelText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9301_0 {
	meta:
		name = "TCustomMaskEdit.GetEditText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5409_0 {
	meta:
		name = "TDBLookupCombo.GetDisplayValue"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3927_0 {
	meta:
		name = "TField.GetDisplayLabel"
		size = 18
		refs = "000b TField.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11254_0 {
	meta:
		name = "TOleControl.GetByteProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11283_0 {
	meta:
		name = "TOleControl.GetShortIntProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11289_0 {
	meta:
		name = "TOleControl.GetWordProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10723_0 {
	meta:
		name = "TQueryDims.GetQueryDim"
		size = 18
		refs = "000b TDimensionItems.GetDimensionItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6644_0 {
	meta:
		name = "TStringProperty.GetValue"
		size = 18
		refs = "000b TPropertyEditor.GetStrValue"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2094_0 {
	meta:
		name = "TCheckConstraints.GetOwner"
		size = 4
		altNames = "TCoolBands.GetOwner TDBGridColumns.GetOwner TDimensionItems.GetOwner THTMLTableColumns.GetOwner THeaderSections.GetOwner TListColumns.GetOwner TPrinterSettings.GetCopies TStatusPanels.GetOwner TWebActionItems.GetOwner"
	strings:
		$1 = { 8B 40 18 C3 }
	condition:
		$1
}

rule function_2096_0 {
	meta:
		name = "TStatusPanels.Update"
		size = 41
		refs = "000d TCollectionItem.GetIndex 0017 _NF__7AC 0022 _NF__7AD"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2834_0 {
	meta:
		name = "TCoolBands.Update"
		size = 41
		refs = "000d TCollectionItem.GetIndex 0017 _NF__F5A 0022 _NF__F5D"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2127_0 {
	meta:
		name = "THeaderSections.Update"
		size = 41
		refs = "000d TCollectionItem.GetIndex 0017 _NF__80A 0022 _NF__80B"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2511_0 {
	meta:
		name = "TListColumns.Update"
		size = 41
		refs = "000d TCollectionItem.GetIndex 0017 TCustomListView.UpdateColumn 0022 TCustomListView.UpdateColumns"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2097_0 {
	meta:
		name = "TStatusBar.Create"
		size = 160
		refs = "000e @ClassCreate 001c TWinControl.Create 0022 TStatusBar.Create 0032 TControl.SetColor 003e TControl.SetHeight 0047 TControl.SetAlign 0050 _DV_TStatusPanels 0055 TStatusPanels.Create 0062 _Dn_TControlCanvas 0067 TCanvas.Create 0078 TControlCanvas.SetControl"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 66 89 43 40 BA 0F 00 00 80 8B C3 E8 ?? ?? ?? ?? BA 13 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 02 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 18 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 1C 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? C6 83 25 01 00 00 01 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 CA 00 00 00 }
	condition:
		$1
}

rule function_2098_0 {
	meta:
		name = "THeaderControl.Destroy"
		size = 56
		refs = "000d TObject.Free 0024 TWinControl.Destroy 002f @ClassDestroy"
		altNames = "TStatusBar.Destroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2099_0 {
	meta:
		name = "TStatusBar.CreateParams"
		size = 88
		refs = "000c InitCommonControl 0015 TWinControl.CreateParams 001a TStatusBar.CreateParams 0023 TWinControl.CreateSubClass"
	strings:
		$1 = { 53 56 8B DA 8B F0 B8 04 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 80 BE 25 01 00 00 00 74 09 81 4B 04 00 01 00 00 EB 04 83 4B 04 01 83 63 24 FD 5E 5B C3 6D 73 63 74 6C 73 5F 73 74 61 74 75 73 62 61 72 33 32 00 00 }
	condition:
		$1
}

rule function_2100_0 {
	meta:
		name = "TStatusBar.CreateWnd"
		size = 94
		refs = "0006 TWinControl.CreateWnd 000d _NF__7AD 0021 @LStrToPChar 0033 TWinControl.GetHandle 0039 SendMessage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 BB 20 01 00 00 00 74 23 8B 83 20 01 00 00 E8 ?? ?? ?? ?? 50 68 FF 00 00 00 68 01 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 BB 24 01 00 00 00 74 16 6A 00 6A 01 68 09 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2101_0 {
	meta:
		name = "TStatusBar.DrawPanel"
		size = 47
		refs = "0029 TCanvas.FillRect"
	strings:
		$1 = { 53 66 83 B8 2A 01 00 00 00 74 15 51 8B D8 8B CA 8B D0 8B 83 2C 01 00 00 FF 93 28 01 00 00 5B C3 8B D1 8B 80 1C 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2103_0 {
	meta:
		name = "TGanttSeries.SetConnectingPen"
		size = 12
		altNames = "THeaderControl.SetSections TScrollingWinControl.SetHorzScrollBar TStatusBar.SetPanels"
	strings:
		$1 = { 8B 80 18 01 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_2104_0 {
	meta:
		name = "TStatusBar.SetSimplePanel"
		size = 59
		refs = "0014 TWinControl.HandleAllocated 002f TWinControl.GetHandle 0035 SendMessage"
	strings:
		$1 = { 53 8B D8 3A 93 24 01 00 00 74 2E 88 93 24 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 6A 00 33 C0 8A 83 24 01 00 00 50 68 09 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2105_0 {
	meta:
		name = "TStatusBar.SetSimpleText"
		size = 83
		refs = "000f @LStrCmp 001e @LStrAsg 0025 TWinControl.HandleAllocated 0034 @LStrToPChar 0046 TWinControl.GetHandle 004c SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 20 01 00 00 8B D6 E8 ?? ?? ?? ?? 74 3B 8D 83 20 01 00 00 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 23 8B 83 20 01 00 00 E8 ?? ?? ?? ?? 50 68 FF 00 00 00 68 01 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2106_0 {
	meta:
		name = "TStatusBar.SetSizeGrip"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 25 01 00 00 74 0B 88 90 25 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2107_0 {
	meta:
		name = "_NF__7AC"
		size = 264
		refs = "0010 _NF__7AC 001d TWinControl.HandleAllocated 0032 TStatusPanels.GetItem 0066 @LStrLAsg 0081 @LStrCat3 009b @LStrToPChar 00a3 TCollectionItem.GetIndex 00b2 TWinControl.GetHandle 00b8 SendMessage 00c9 InvalidateRect 00de @LStrClr 00e4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 A4 00 00 00 8B D6 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 8B F0 33 FF 8A 46 15 2C 01 72 06 FE C8 74 09 EB 0C BF 00 01 00 00 EB 05 BF 00 02 00 00 80 7E 16 01 75 06 81 CF 00 10 00 00 8D 45 FC 8B 56 0C E8 ?? ?? ?? ?? 8A 46 14 FE C8 74 16 FE C8 75 22 8D 45 FC 8B 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 10 8D 45 FC 8B 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 0B F8 57 68 01 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A FF 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 FF FF FF FF 01 00 00 00 09 00 00 00 FF FF FF FF 02 00 00 00 09 09 00 00 }
	condition:
		$1
}

rule function_2108_0 {
	meta:
		name = "_NF__7AD"
		size = 260
		refs = "000f TWinControl.HandleAllocated 0022 TCollection.GetCount 0056 TWinControl.GetHandle 005c SendMessage 0061 _NF__7AD 009b TStatusPanels.GetItem 00ea _NF__7AC"
	strings:
		$1 = { 53 56 57 55 81 C4 F8 FD FF FF 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 D7 00 00 00 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 89 04 24 81 3C 24 80 00 00 00 7E 07 C7 04 24 80 00 00 00 83 3C 24 00 75 3C C7 44 24 08 FF FF FF FF 8D 44 24 08 50 6A 01 68 04 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 01 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 77 33 C0 89 44 24 04 8B 34 24 83 EE 02 85 F6 7C 28 46 33 ED 8D 7C 24 08 8B D5 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 8B 40 10 01 44 24 04 8B 44 24 04 89 07 45 83 C7 04 4E 75 DF 8B 04 24 C7 44 84 04 FF FF FF FF 8D 44 24 08 50 8B 44 24 04 50 68 04 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 34 24 4E 85 F6 7C 10 46 33 ED 8B D5 8B C3 E8 ?? ?? ?? ?? 45 4E 75 F3 81 C4 08 02 00 00 5D 5F 5E 5B C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_2109_0 {
	meta:
		name = "TStatusBar.CNDrawItem"
		size = 156
		refs = "0011 SaveDC 0022 TCanvas.SetHandle 0030 TCanvas.SetFont 0043 TBrush.SetColor 0053 TBrush.SetStyle 0061 TStatusPanels.GetItem 0071 @CallDynaInst 008b RestoreDC"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F0 8B 7D 08 8B 47 18 50 E8 ?? ?? ?? ?? 89 04 24 8B 57 18 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 56 50 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 86 1C 01 00 00 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 86 1C 01 00 00 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B 57 08 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D0 8D 4F 1C 8B C6 66 BB DB FF E8 ?? ?? ?? ?? 33 D2 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 04 24 50 8B 47 18 50 E8 ?? ?? ?? ?? C7 45 0C 01 00 00 00 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2110_0 {
	meta:
		name = "TStatusBar.WMSize"
		size = 31
		refs = "0011 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 F6 46 20 01 75 0B 8B C6 66 BB DA FF E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 48 5E 5B C3 }
	condition:
		$1
}

rule function_2111_0 {
	meta:
		name = "THeaderSection.Create"
		size = 64
		refs = "000a @ClassCreate 0029 TCollectionItem.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 C7 46 10 32 00 00 00 C7 46 18 10 27 00 00 C6 46 1E 01 33 D2 8B C6 E8 ?? ?? ?? ?? 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2112_0 {
	meta:
		name = "THeaderSection.Assign"
		size = 107
		refs = "000b _DV_THeaderSection 0010 @IsClass 0020 THeaderSection.SetText 002a THeaderSection.SetWidth 0034 THeaderSection.SetMinWidth 003e THeaderSection.SetMaxWidth 0048 THeaderSection.SetAlignment 0052 THeaderSection.SetStyle 0063 TPersistent.Assign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 46 8B FE 8B 57 0C 8B C3 E8 ?? ?? ?? ?? 8B 57 10 8B C3 E8 ?? ?? ?? ?? 8B 57 14 8B C3 E8 ?? ?? ?? ?? 8B 57 18 8B C3 E8 ?? ?? ?? ?? 8A 57 1C 8B C3 E8 ?? ?? ?? ?? 8A 57 1D 8B C3 E8 ?? ?? ?? ?? 8A 47 1E 88 43 1E EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2114_0 {
	meta:
		name = "THeaderSection.GetLeft"
		size = 49
		refs = "000b TCollectionItem.GetIndex 001f THeaderSections.GetItem"
	strings:
		$1 = { 53 56 57 55 8B F8 33 ED 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 14 43 33 F6 8B D6 8B 47 04 E8 ?? ?? ?? ?? 03 68 10 46 4B 75 EF 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2115_0 {
	meta:
		name = "THeaderSection.GetRight"
		size = 15
		refs = "0006 THeaderSection.GetLeft"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 03 43 10 5B C3 }
	condition:
		$1
}

rule function_2116_0 {
	meta:
		name = "THeaderSection.SetAlignment"
		size = 16
		refs = "000b TCollectionItem.Changed"
	strings:
		$1 = { 3A 50 1C 74 0A 88 50 1C 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2117_0 {
	meta:
		name = "THeaderSection.SetMaxWidth"
		size = 34
		refs = "001d THeaderSection.SetWidth"
	strings:
		$1 = { 8B 48 14 3B D1 7D 02 8B D1 81 FA 10 27 00 00 7E 05 BA 10 27 00 00 89 50 18 8B 50 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2118_0 {
	meta:
		name = "THeaderSection.SetMinWidth"
		size = 27
		refs = "0016 THeaderSection.SetWidth"
	strings:
		$1 = { 85 D2 7D 02 33 D2 8B 48 18 3B D1 7E 02 8B D1 89 50 14 8B 50 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2119_0 {
	meta:
		name = "THeaderSection.SetStyle"
		size = 16
		refs = "000b TCollectionItem.Changed"
	strings:
		$1 = { 3A 50 1D 74 0A 88 50 1D 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2121_0 {
	meta:
		name = "THeaderSection.SetWidth"
		size = 63
		refs = "0021 TCollectionItem.GetIndex 002b TCollection.GetCount 0038 TCollectionItem.Changed"
	strings:
		$1 = { 53 56 8B D8 8B 43 14 3B D0 7D 02 8B D0 8B 43 18 3B D0 7E 02 8B D0 3B 53 10 74 21 89 53 10 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 43 04 E8 ?? ?? ?? ?? 48 3B F0 0F 9C C2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2128_0 {
	meta:
		name = "THeaderControl.Create"
		size = 140
		refs = "000e @ClassCreate 001c TWinControl.Create 0022 THeaderControl.Create 002f TControl.SetAlign 003b TControl.SetHeight 0044 _DV_THeaderSections 0049 THeaderSections.Create 0056 _Dn_TControlCanvas 005b TCanvas.Create 006c TControlCanvas.SetControl"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 66 89 43 40 B2 01 8B C3 E8 ?? ?? ?? ?? BA 11 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 18 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 1C 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_2130_0 {
	meta:
		name = "THeaderControl.CreateParams"
		size = 76
		refs = "000c InitCommonControl 0015 TWinControl.CreateParams 001a THeaderControl.CreateParams 0023 TWinControl.CreateSubClass"
	strings:
		$1 = { 53 56 8B DA 8B F0 B8 01 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 83 4B 04 02 80 BE 20 01 00 00 00 74 04 83 4B 04 04 83 63 24 FC 5E 5B C3 00 53 79 73 48 65 61 64 65 72 33 32 00 }
	condition:
		$1
}

rule function_2132_0 {
	meta:
		name = "THeaderControl.DrawSection"
		size = 57
		refs = "0030 TCanvas.FillRect"
	strings:
		$1 = { 55 8B EC 53 66 83 B8 26 01 00 00 00 74 19 51 8A 4D 08 51 8B D8 8B CA 8B D0 8B 83 28 01 00 00 FF 93 24 01 00 00 EB 0D 8B D1 8B 80 1C 01 00 00 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2133_0 {
	meta:
		name = "TCustomPanel.Resize"
		size = 29
		altNames = "THeaderControl.Resize"
	strings:
		$1 = { 53 66 83 B8 2E 01 00 00 00 74 10 8B D8 8B D0 8B 83 30 01 00 00 FF 93 2C 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2134_0 {
	meta:
		name = "THeaderControl.SectionClick"
		size = 31
	strings:
		$1 = { 53 66 83 B8 36 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 38 01 00 00 FF 93 34 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2135_0 {
	meta:
		name = "THeaderControl.SectionResize"
		size = 31
	strings:
		$1 = { 53 66 83 B8 3E 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 40 01 00 00 FF 93 3C 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2136_0 {
	meta:
		name = "THeaderControl.SectionTrack"
		size = 42
	strings:
		$1 = { 55 8B EC 53 66 83 B8 46 01 00 00 00 74 17 51 8A 4D 08 51 8B D8 8B CA 8B D0 8B 83 48 01 00 00 FF 93 44 01 00 00 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2137_0 {
	meta:
		name = "TAnimate.SetCenter"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
		altNames = "TCustomComboBox.SetSorted TCustomStaticText.SetShowAccelChar THeaderControl.SetHotTrack"
	strings:
		$1 = { 3A 90 20 01 00 00 74 0B 88 90 20 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2139_0 {
	meta:
		name = "_NF__809"
		size = 170
		refs = "0013 THeaderSections.GetItem 0023 @FillChar 0039 @LStrToPChar 0045 @LStrLen 0090 TCollectionItem.GetIndex 0099 TWinControl.GetHandle 009f SendMessage"
	strings:
		$1 = { 53 56 57 83 C4 E4 8B FA 8B F0 8B D1 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D8 8B C4 33 C9 BA 1C 00 00 00 E8 ?? ?? ?? ?? C7 04 24 07 00 00 00 8B 43 10 89 44 24 04 8B 43 0C E8 ?? ?? ?? ?? 89 44 24 08 8B 43 0C E8 ?? ?? ?? ?? 89 44 24 10 8A 43 1C 2C 01 72 04 74 0A EB 12 33 C0 89 44 24 14 EB 12 C7 44 24 14 01 00 00 00 EB 08 C7 44 24 14 02 00 00 00 80 7B 1D 01 75 0A 81 4C 24 14 00 80 00 00 EB 08 81 4C 24 14 00 40 00 00 8B C4 50 8B C3 E8 ?? ?? ?? ?? 50 57 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2140_0 {
	meta:
		name = "_NF__80A"
		size = 34
		refs = "0009 TWinControl.HandleAllocated 001b _NF__809"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE BA 04 12 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2141_0 {
	meta:
		name = "_NF__80B"
		size = 114
		refs = "0008 TWinControl.HandleAllocated 001c TWinControl.GetHandle 0022 SendMessage 004e TCollection.GetCount 0066 _NF__809"
	strings:
		$1 = { 53 56 57 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 74 5E 6A 00 6A 00 68 00 12 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1A 43 6A 00 6A 00 68 02 12 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 4B 75 E7 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 15 43 33 FF 8B CF BA 01 12 00 00 8B C6 E8 ?? ?? ?? ?? 47 4B 75 EE 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2142_0 {
	meta:
		name = "THeaderControl.CNDrawItem"
		size = 164
		refs = "0011 SaveDC 0022 TCanvas.SetHandle 0030 TCanvas.SetFont 0043 TBrush.SetColor 0053 TBrush.SetStyle 0069 THeaderSections.GetItem 0079 @CallDynaInst 0093 RestoreDC"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F0 8B 7D 08 8B 47 18 50 E8 ?? ?? ?? ?? 89 04 24 8B 57 18 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 56 50 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 86 1C 01 00 00 8B 40 14 BA 0F 00 00 80 E8 ?? ?? ?? ?? 8B 86 1C 01 00 00 8B 40 14 33 D2 E8 ?? ?? ?? ?? F6 47 10 01 0F 95 C0 50 8B 57 08 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D0 8D 4F 1C 8B C6 66 BB DB FF E8 ?? ?? ?? ?? 33 D2 8B 86 1C 01 00 00 E8 ?? ?? ?? ?? 8B 04 24 50 8B 47 18 50 E8 ?? ?? ?? ?? C7 45 0C 01 00 00 00 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2143_0 {
	meta:
		name = "THeaderControl.CNNotify"
		size = 239
		refs = "002e THeaderSections.GetItem 003b @CallDynaInst"
	strings:
		$1 = { 53 56 57 55 51 8B F0 8B 5A 08 8B 43 08 05 34 01 00 00 83 E8 03 72 66 83 E8 03 74 08 48 74 25 E9 C5 00 00 00 8B 53 0C 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B C6 66 BB D9 FF E8 ?? ?? ?? ?? E9 A5 00 00 00 8B 43 14 F6 00 01 0F 84 99 00 00 00 8B 53 0C 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 43 14 8B 40 04 3B 47 10 74 7E 89 47 10 8B D7 8B C6 66 BB D8 FF E8 ?? ?? ?? ?? EB 6C 8B 53 0C 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 43 08 2D CD FE FF FF 74 09 48 75 0C C6 04 24 00 EB 0A C6 04 24 02 EB 04 C6 04 24 01 8B 6B 14 8B 55 04 8B 47 14 3B D0 7D 03 89 45 04 8B 55 04 8B 47 18 3B D0 7E 03 89 45 04 8A 04 24 50 8B 53 0C 8B 86 18 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 4D 04 8B C6 66 BB D7 FF E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2144_0 {
	meta:
		name = "THeaderControl.WMLButtonDown"
		size = 96
		refs = "0026 TWinControl.GetHandle 002c SendMessage 0046 THeaderSections.GetItem 0055 TControl.WMLButtonDown"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B FA 8B D8 0F BF 47 08 89 04 24 0F BF 47 0A 89 44 24 04 8B C4 50 6A 00 68 06 12 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 1A F6 44 24 08 02 74 13 8B D6 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 80 78 1E 00 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2145_0 {
	meta:
		name = "THeaderControl.WMSize"
		size = 31
		refs = "0007 TWinControl.WMSize 0018 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? F6 46 20 01 75 0B 8B C6 66 BB DA FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2147_0 {
	meta:
		name = "_NF__81B"
		size = 108
		refs = "000f TTreeNode.GetTreeView 004c @LStrToPChar 005b lstrcmp"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 0C 8B 5D 08 8B C3 E8 ?? ?? ?? ?? 66 83 B8 BA 01 00 00 00 74 2B 56 8B 45 10 50 8D 45 FC 50 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B CB 8B 86 BC 01 00 00 FF 96 B8 01 00 00 EB 1A 8B 46 08 E8 ?? ?? ?? ?? 50 8B 43 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_2149_0 {
	meta:
		name = "_NF__81D"
		size = 60
		refs = "0021 _DV_ETreeViewError 0026 Exception.CreateFmt 002b @RaiseExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D9 03 DB 43 8B 34 9A 4B 56 79 F9 8B D4 8B F9 8B F2 8B D8 56 57 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D F4 8B 75 F8 8B 5D FC 8B E5 5D C3 }
	condition:
		$1
}

rule function_2150_0 {
	meta:
		name = "TTreeNode.Create"
		size = 67
		refs = "000b @ClassCreate 001a TObject.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? C7 47 1C FF FF FF FF C7 47 20 FF FF FF FF 89 77 04 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2151_0 {
	meta:
		name = "TTreeNode.Destroy"
		size = 165
		refs = "0025 TTreeNode.GetParent 003a TTreeNode.IndexOf 004f _NF__83F 005c TTreeNode.SetExpanded 0065 TTreeNode.SetChildren 0072 TTreeNode.GetHandle 007a TreeView_DeleteItem 0083 TTreeNode.SetData 008f TPersistent.Destroy 009a @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 C6 45 24 01 8B 45 04 8B 40 04 3B A8 68 01 00 00 75 08 33 D2 89 90 68 01 00 00 8B C5 E8 ?? ?? ?? ?? 8B F0 85 F6 74 3A 80 7E 24 00 75 34 8B D5 8B C6 E8 ?? ?? ?? ?? 40 74 07 BF 01 00 00 00 EB 02 33 FF 8B D7 8B C6 E8 ?? ?? ?? ?? 84 C0 74 12 33 D2 8B C5 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 83 7D 10 00 74 0F 8B C5 E8 ?? ?? ?? ?? 8B 55 10 E8 ?? ?? ?? ?? 33 D2 8B C5 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C5 E8 ?? ?? ?? ?? 84 DB 74 07 8B C5 E8 ?? ?? ?? ?? 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2152_0 {
	meta:
		name = "TTreeNode.GetHandle"
		size = 17
		refs = "0006 TTreeNode.GetTreeView 000b TWinControl.GetHandle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2613_0 {
	meta:
		name = "TCustomListView.GetSelCount"
		size = 17
		refs = "0006 TWinControl.GetHandle 000b ListView_GetSelectedCount"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2283_0 {
	meta:
		name = "TCustomTreeView.GetIndent"
		size = 17
		refs = "0006 TWinControl.GetHandle 000b TreeView_GetIndent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2524_0 {
	meta:
		name = "TListItem.GetHandle"
		size = 17
		refs = "0006 TListItem.GetListView 000b TWinControl.GetHandle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12754_0 {
	meta:
		name = "_NF__4B1"
		size = 17
		refs = "0006 TQRPrinter.GetCanvas 000b TObject.Free"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9733_0 {
	meta:
		name = "mci_TMSF_Frame"
		size = 17
		refs = "0006 HiWord 000b HiByte"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2153_0 {
	meta:
		name = "TListItem.GetListView"
		size = 7
		altNames = "TTreeNode.GetTreeView"
	strings:
		$1 = { 8B 40 04 8B 40 04 C3 }
	condition:
		$1
}

rule function_2154_0 {
	meta:
		name = "TTreeNode.HasAsParent"
		size = 62
		refs = "000d TTreeNode.GetParent 0032 TTreeNode.HasAsParent"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 2F 8B C3 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 22 8B C3 E8 ?? ?? ?? ?? 3B F0 75 04 B0 01 EB 13 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_2155_0 {
	meta:
		name = "TTreeNode.SetText"
		size = 123
		refs = "000f @LStrAsg 002c TTreeNode.GetHandle 0033 TreeView_SetItem 003a TTreeNode.GetTreeView 0053 TTreeNode.GetParent 0063 TTreeNode.AlphaSort 0071 TCustomTreeView.AlphaSort"
	strings:
		$1 = { 53 56 83 C4 D8 8B F2 8B D8 8D 43 08 8B D6 E8 ?? ?? ?? ?? C7 04 24 01 00 00 00 8B 43 10 89 44 24 04 C7 44 24 10 FF FF FF FF 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8A 80 38 01 00 00 04 FE 2C 02 73 2B 80 7B 25 00 74 25 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 28 5E 5B C3 }
	condition:
		$1
}

rule function_2156_0 {
	meta:
		name = "TTreeNode.SetData"
		size = 95
		refs = "0009 TTreeNode.GetTreeView 003b TTreeNode.GetParent 004b TTreeNode.AlphaSort 0059 TCustomTreeView.AlphaSort"
	strings:
		$1 = { 53 8B D8 89 53 0C 8B C3 E8 ?? ?? ?? ?? 8A 80 38 01 00 00 2C 01 74 04 2C 02 75 42 8B C3 E8 ?? ?? ?? ?? 66 83 B8 BA 01 00 00 00 74 31 80 7B 24 00 75 2B 80 7B 25 00 74 25 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2157_0 {
	meta:
		name = "_NF__832"
		size = 140
		refs = "001e TTreeNode.GetHandle 0027 TreeView_GetItem 003c _NF__832"
	strings:
		$1 = { 53 56 83 C4 D4 88 14 24 8B F0 33 DB C7 44 24 04 08 00 00 00 8B 46 10 89 44 24 08 8B C6 E8 ?? ?? ?? ?? 8D 54 24 04 E8 ?? ?? ?? ?? 85 C0 74 55 33 C0 8A 04 24 83 F8 04 77 4B FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F6 44 24 0C 04 0F 95 C3 EB 26 F6 44 24 0C 01 0F 95 C3 EB 1C F6 44 24 0C 02 0F 95 C3 EB 12 F6 44 24 0C 20 0F 95 C3 EB 08 F6 44 24 0C 08 0F 95 C3 8B C3 83 C4 2C 5E 5B C3 }
	condition:
		$1
}

rule function_2158_0 {
	meta:
		name = "TTreeNode.SetImageIndex"
		size = 50
		refs = "0022 TTreeNode.GetHandle 0029 TreeView_SetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 89 53 14 C7 04 24 12 00 00 00 8B 43 10 89 44 24 04 C7 44 24 18 FF FF FF FF 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2159_0 {
	meta:
		name = "TTreeNode.SetSelectedIndex"
		size = 50
		refs = "0022 TTreeNode.GetHandle 0029 TreeView_SetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 89 53 18 C7 04 24 30 00 00 00 8B 43 10 89 44 24 04 C7 44 24 1C FF FF FF FF 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2160_0 {
	meta:
		name = "TTreeNode.SetOverlayIndex"
		size = 66
		refs = "0026 IndexToOverlayMask 0031 TTreeNode.GetHandle 0038 TreeView_SetItem"
	strings:
		$1 = { 53 56 83 C4 D8 8B D8 8B F2 89 73 1C C7 04 24 18 00 00 00 C7 44 24 0C 00 0F 00 00 8B 43 10 89 44 24 04 8B C6 40 E8 ?? ?? ?? ?? 89 44 24 08 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5E 5B C3 }
	condition:
		$1
}

rule function_2161_0 {
	meta:
		name = "TTreeNode.SetStateIndex"
		size = 71
		refs = "002b IndexToStateImageMask 0036 TTreeNode.GetHandle 003d TreeView_SetItem"
	strings:
		$1 = { 53 56 83 C4 D8 8B F2 8B D8 89 73 20 85 F6 7C 01 4E C7 04 24 18 00 00 00 C7 44 24 0C 00 F0 00 00 8B 43 10 89 44 24 04 8D 46 01 E8 ?? ?? ?? ?? 89 44 24 08 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5E 5B C3 }
	condition:
		$1
}

rule function_2162_0 {
	meta:
		name = "_NF__83F"
		size = 46
		refs = "000a TTreeNode.GetFirstChild 0016 TTreeNode.GetNextChild"
	strings:
		$1 = { 53 56 57 8B F2 33 FF 33 DB E8 ?? ?? ?? ?? 85 C0 74 10 47 8B D0 E8 ?? ?? ?? ?? 3B F7 7C 0A 85 C0 75 F0 3B F7 75 02 B3 01 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2163_0 {
	meta:
		name = "_NF__840"
		size = 75
		refs = "000d TTreeNode.GetChildren 001e TTreeNode.GetTreeView 0029 @CallDynaInst"
	strings:
		$1 = { 53 56 51 88 14 24 8B F0 33 DB 8B C6 E8 ?? ?? ?? ?? 84 C0 74 30 80 3C 24 00 74 16 8B C6 E8 ?? ?? ?? ?? 8B D6 66 BB D8 FF E8 ?? ?? ?? ?? 8B D8 EB 14 8B C6 E8 ?? ?? ?? ?? 8B D6 66 BB D9 FF E8 ?? ?? ?? ?? 8B D8 8B C3 5A 5E 5B C3 }
	condition:
		$1
}

rule function_2164_0 {
	meta:
		name = "_NF__841"
		size = 62
		refs = "0009 TTreeNode.GetChildren 0018 TTreeNode.GetTreeView 0023 @CallDynaInst"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 74 2A 84 DB 74 14 8B C6 E8 ?? ?? ?? ?? 8B D6 66 BB D4 FF E8 ?? ?? ?? ?? EB 12 8B C6 E8 ?? ?? ?? ?? 8B D6 66 BB D6 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2165_0 {
	meta:
		name = "_NF__842"
		size = 226
		refs = "0019 _NF__842 0020 TTreeNode.GetNext 0034 TTreeNode.HasAsParent 0045 TTreeNode.GetTreeView 006a _NF__840 007d _NF__841 00a8 TTreeNode.GetHandle 00b5 TreeView_Expand 00d7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 84 C9 74 32 8B 75 FC 33 C9 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 AF 00 00 00 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 84 C0 75 D6 E9 9C 00 00 00 8B 45 FC E8 ?? ?? ?? ?? C6 80 70 01 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 84 DB 74 1F B2 01 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 2E BE 02 00 00 00 B2 01 8B 45 FC E8 ?? ?? ?? ?? EB 1D 33 D2 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 0F BE 01 00 00 00 33 D2 8B 45 FC E8 ?? ?? ?? ?? 85 F6 74 15 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 52 10 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C6 80 70 01 00 00 00 C3 E9 ?? ?? ?? ?? EB E9 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2166_0 {
	meta:
		name = "TTreeNode.Expand"
		size = 10
		refs = "0005 _NF__842"
	strings:
		$1 = { 8B CA B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2167_0 {
	meta:
		name = "TTreeNode.Collapse"
		size = 10
		refs = "0005 _NF__842"
	strings:
		$1 = { 8B CA 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2168_0 {
	meta:
		name = "TTreeNode.GetExpanded"
		size = 8
		refs = "0003 _NF__832"
	strings:
		$1 = { B2 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2169_0 {
	meta:
		name = "TTreeNode.SetExpanded"
		size = 20
		refs = "0007 TTreeNode.Expand 000f TTreeNode.Collapse"
	strings:
		$1 = { 84 D2 74 08 33 D2 E8 ?? ?? ?? ?? C3 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2170_0 {
	meta:
		name = "TTreeNode.GetSelected"
		size = 8
		refs = "0003 _NF__832"
	strings:
		$1 = { B2 03 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2171_0 {
	meta:
		name = "TTreeNode.SetSelected"
		size = 51
		refs = "000a TTreeNode.GetHandle 0012 TreeView_SelectItem 001b TTreeNode.GetSelected"
	strings:
		$1 = { 53 8B D8 84 D2 74 11 8B C3 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2175_0 {
	meta:
		name = "TTreeNode.SetDropTarget"
		size = 51
		refs = "000a TTreeNode.GetHandle 0012 TreeView_SelectDropTarget 001b TTreeNode.GetDropTarget"
	strings:
		$1 = { 53 8B D8 84 D2 74 11 8B C3 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2173_0 {
	meta:
		name = "TTreeNode.SetCut"
		size = 65
		refs = "0031 TTreeNode.GetHandle 0038 TreeView_SetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 84 D2 74 05 83 C8 FF EB 02 33 C0 C7 04 24 08 00 00 00 8B 53 10 89 54 24 04 BA 04 00 00 00 89 54 24 0C 23 C2 89 44 24 08 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2176_0 {
	meta:
		name = "TTreeNode.GetChildren"
		size = 55
		refs = "0017 TTreeNode.GetHandle 001e TreeView_GetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 C7 04 24 40 00 00 00 8B 43 10 89 44 24 04 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 85 C0 74 0A 83 7C 24 20 00 0F 9F C0 EB 02 33 C0 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2177_0 {
	meta:
		name = "TTreeNode.SetFocused"
		size = 65
		refs = "0031 TTreeNode.GetHandle 0038 TreeView_SetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 84 D2 74 05 83 C8 FF EB 02 33 C0 C7 04 24 08 00 00 00 8B 53 10 89 54 24 04 BA 01 00 00 00 89 54 24 0C 23 C2 89 44 24 08 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2178_0 {
	meta:
		name = "TTreeNode.GetFocused"
		size = 8
		refs = "0003 _NF__832"
	strings:
		$1 = { B2 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2179_0 {
	meta:
		name = "TTreeNode.SetChildren"
		size = 47
		refs = "001f TTreeNode.GetHandle 0026 TreeView_SetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 C7 04 24 40 00 00 00 8B 43 10 89 44 24 04 33 C0 8A C2 89 44 24 20 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2180_0 {
	meta:
		name = "TTreeNode.GetParent"
		size = 34
		refs = "000a TTreeNodes.GetHandle 0012 TreeView_GetParent 001b TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 8B C6 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2187_0 {
	meta:
		name = "TTreeNode.GetFirstChild"
		size = 34
		refs = "000a TTreeNodes.GetHandle 0012 TreeView_GetChild 001b TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 8B C6 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2181_0 {
	meta:
		name = "TTreeNode.GetNextSibling"
		size = 34
		refs = "000a TTreeNodes.GetHandle 0012 TreeView_GetNextSibling 001b TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 8B C6 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2182_0 {
	meta:
		name = "TTreeNode.GetPrevSibling"
		size = 34
		refs = "000a TTreeNodes.GetHandle 0012 TreeView_GetPrevSibling 001b TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 8B C6 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2184_0 {
	meta:
		name = "TTreeNode.GetPrevVisible"
		size = 34
		refs = "000a TTreeNodes.GetHandle 0012 TreeView_GetPrevVisible 001b TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 8B D8 8B 73 04 8B C6 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2183_0 {
	meta:
		name = "TTreeNode.GetNextVisible"
		size = 50
		refs = "0007 TTreeNode.IsNodeVisible 0015 TTreeNodes.GetHandle 001d TreeView_GetNextVisible 0026 TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1E 8B 73 04 8B C6 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_2185_0 {
	meta:
		name = "TTreeNode.GetNextChild"
		size = 15
		refs = "0007 TTreeNode.GetNextSibling"
	strings:
		$1 = { 85 D2 74 08 8B C2 E8 ?? ?? ?? ?? C3 33 C0 C3 }
	condition:
		$1
}

rule function_2186_0 {
	meta:
		name = "TTreeNode.GetPrevChild"
		size = 15
		refs = "0007 TTreeNode.GetPrevSibling"
	strings:
		$1 = { 85 D2 74 08 8B C2 E8 ?? ?? ?? ?? C3 33 C0 C3 }
	condition:
		$1
}

rule function_2188_0 {
	meta:
		name = "TTreeNode.GetLastChild"
		size = 31
		refs = "0002 TTreeNode.GetFirstChild 0013 TTreeNode.GetNextSibling"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 85 DB 74 0F 8B C3 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 75 F3 8B C3 5B C3 }
	condition:
		$1
}

rule function_2189_0 {
	meta:
		name = "TTreeNode.GetNext"
		size = 85
		refs = "0009 TTreeNodes.GetHandle 0015 TreeView_GetChild 0023 TreeView_GetNextSibling 0031 TreeView_GetParent 004d TTreeNodes.GetNode"
	strings:
		$1 = { 53 56 57 8B F8 8B 47 04 E8 ?? ?? ?? ?? 8B F0 8B 57 10 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 57 10 8B C6 E8 ?? ?? ?? ?? 8B 5F 10 EB 14 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 8B D3 8B C6 E8 ?? ?? ?? ?? 85 C0 75 04 85 DB 75 E4 8B 57 04 92 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2190_0 {
	meta:
		name = "TTreeNode.GetPrev"
		size = 48
		refs = "0007 TTreeNode.GetPrevSibling 0018 TTreeNode.GetLastChild 0025 TTreeNode.GetParent"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 11 8B C3 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 75 F3 EB 09 8B C6 E8 ?? ?? ?? ?? 8B D8 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_2191_0 {
	meta:
		name = "TTreeNode.GetAbsoluteIndex"
		size = 22
		refs = "000a TTreeNode.GetPrev"
		altNames = "TTreeNode.GetIndex"
	strings:
		$1 = { 53 83 CB FF 85 C0 74 0A 43 E8 ?? ?? ?? ?? 85 C0 75 F6 8B C3 5B C3 }
	condition:
		$1
}

rule function_2193_0 {
	meta:
		name = "TTreeNode.GetItem"
		size = 119
		refs = "0010 TTreeNode.GetItem 001d TTreeNode.GetFirstChild 002a TTreeNode.GetNextChild 0041 SListIndexError 0046 LoadResString 004e _NF__81C 0063 @LStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 8B D8 EB 0C 8B D3 8B C7 E8 ?? ?? ?? ?? 8B D8 4E 85 DB 74 04 85 F6 7F EC 85 DB 75 15 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2194_0 {
	meta:
		name = "TTreeNode.SetItem"
		size = 29
		refs = "000e TTreeNode.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5744_0 {
	meta:
		name = "TBDEDataSet.SetIndexField"
		size = 29
		refs = "000e TBDEDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_4602_0 {
	meta:
		name = "TClientDataSet.SetIndexField"
		size = 29
		refs = "000e TClientDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_8288_0 {
	meta:
		name = "TCookieCollection.SetCookie"
		size = 29
		refs = "000e TCookieCollection.GetCookie"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10674_0 {
	meta:
		name = "TCubeDims.SetCubeDim"
		size = 29
		refs = "000e TCubeDims.GetCubeDim"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5251_0 {
	meta:
		name = "TDBGridColumns.SetColumn"
		size = 29
		refs = "000e TDBGridColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10007_0 {
	meta:
		name = "TDimensionItems.SetDimensionItem"
		size = 29
		refs = "000e TDimensionItems.GetDimensionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10320_0 {
	meta:
		name = "TDisplayDims.SetDisplayDim"
		size = 29
		refs = "000e TDisplayDims.GetDisplayDim"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_6099_0 {
	meta:
		name = "THTMLTableColumns.SetColumn"
		size = 29
		refs = "000e THTMLTableColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2555_0 {
	meta:
		name = "TListItems.SetItem"
		size = 29
		refs = "000e TListItems.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10724_0 {
	meta:
		name = "TQueryDims.SetQueryDim"
		size = 29
		refs = "000e TQueryDims.GetQueryDim"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2237_0 {
	meta:
		name = "TTreeNodes.SetItem"
		size = 29
		refs = "000e TTreeNodes.GetNodeFromIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_8353_0 {
	meta:
		name = "TWebActionItems.SetActionItem"
		size = 29
		refs = "000e TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2195_0 {
	meta:
		name = "TTreeNode.IndexOf"
		size = 52
		refs = "000d TTreeNode.GetFirstChild 001f TTreeNode.GetNextChild"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 83 CE FF 8B C3 E8 ?? ?? ?? ?? 85 C0 74 12 46 3B F8 74 0D 8B D0 8B C3 E8 ?? ?? ?? ?? 85 C0 75 EE 85 C0 75 03 83 CE FF 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2196_0 {
	meta:
		name = "TTreeNode.GetCount"
		size = 28
		refs = "0004 TTreeNode.GetFirstChild 0010 TTreeNode.GetNextChild"
	strings:
		$1 = { 53 33 DB E8 ?? ?? ?? ?? 85 C0 74 0C 43 8B D0 E8 ?? ?? ?? ?? 85 C0 75 F4 8B C3 5B C3 }
	condition:
		$1
}

rule function_2197_0 {
	meta:
		name = "TTreeNode.EndEdit"
		size = 25
		refs = "0009 TTreeNode.GetHandle 0012 TreeView_EndEditLabelNow"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? F6 DB 1B D2 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2198_0 {
	meta:
		name = "_NF__892"
		size = 378
		refs = "001a _NF__892 0043 TTreeNode.GetChildren 004d TTreeNode.GetSelected 0057 TTreeNode.GetParent 006c _NF__83F 007e TTreeNode.SetExpanded 008c TTreeNode.SetChildren 00a5 TTreeNode.GetHandle 00ad TreeView_SetItem 00bc TTreeNodes.CreateItem 00d0 TTreeNodes.AddItem 00de sInsertError 00e3 LoadResString 00ed _Dn_EOutOfResources 00f2 Exception.Create 00f7 @RaiseExcept 00fe TTreeNode.GetCount 0112 TTreeNode.GetItem 0130 TreeView_DeleteItem 0150 TTreeNode.SetSelected 0165 @LStrClr 016b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 A0 53 56 57 33 DB 89 5D A0 89 4D FC 8B D8 8B 7D 0C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 7D 08 02 75 11 83 7D FC 00 74 0B 8B 45 FC 8B 40 10 89 45 F8 EB 05 33 C0 89 45 F8 8B C3 E8 ?? ?? ?? ?? 88 45 F7 8B C3 E8 ?? ?? ?? ?? 88 45 F6 8B C3 E8 ?? ?? ?? ?? 85 C0 74 31 8B C3 E8 ?? ?? ?? ?? BA 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 1C 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? C7 45 CC 04 00 00 00 8B 43 10 89 45 D0 33 C0 89 45 F0 8B C3 E8 ?? ?? ?? ?? 8D 55 CC E8 ?? ?? ?? ?? 8B 73 04 8D 4D A4 8B D3 8B C6 E8 ?? ?? ?? ?? 8D 45 A4 50 8A 45 08 50 8B 4D F8 8B D7 8B C6 E8 ?? ?? ?? ?? 8B F8 85 FF 75 21 8D 55 A0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D A0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 4E 83 FE 00 7C 1B 57 6A 00 8B D6 8B C3 E8 ?? ?? ?? ?? 33 C9 8B D3 E8 ?? ?? ?? ?? 4E 83 FE FF 75 E5 8B C3 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 89 7B 10 8B D3 8B C3 8B 08 FF 51 08 8A 55 F7 8B C3 E8 ?? ?? ?? ?? 8A 55 F6 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 A0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_2199_0 {
	meta:
		name = "TTreeNode.MoveTo"
		size = 378
		refs = "0015 TTreeNode.GetTreeView 0075 TTreeNode.MoveTo 0089 TTreeNode.HasAsParent 00a7 TTreeNode.GetParent 00e1 TTreeNode.GetPrevSibling 0106 _NF__892 011d TTreeNode.SetChildren 0126 TTreeNode.SetExpanded 016d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 88 4D FB 8B FA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 90 A8 01 00 00 89 55 F0 8B 90 AC 01 00 00 89 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 90 B0 01 00 00 89 55 E8 8B 90 B4 01 00 00 89 55 EC 8B 45 FC E8 ?? ?? ?? ?? 33 D2 89 90 A8 01 00 00 89 90 AC 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 D2 89 90 B0 01 00 00 89 90 B4 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 85 FF 74 12 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 84 C0 0F 85 95 00 00 00 B3 01 85 FF 74 14 8A 45 FB 04 FE 2C 02 72 0B 8B C7 E8 ?? ?? ?? ?? 8B F0 EB 02 8B F7 33 C0 8A 45 FB 83 F8 04 77 36 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 01 EB 17 33 DB EB 13 8B C7 E8 ?? ?? ?? ?? 8B F8 85 FF 75 04 33 DB EB 02 B3 02 85 F6 74 05 8B 46 10 EB 02 33 C0 50 53 8B CF 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B F0 85 F6 74 12 B2 01 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F0 89 90 A8 01 00 00 8B 55 F4 89 90 AC 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E8 89 90 B0 01 00 00 8B 55 EC 89 90 B4 01 00 00 C3 E9 ?? ?? ?? ?? EB C4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2200_0 {
	meta:
		name = "TTreeNode.MakeVisible"
		size = 20
		refs = "0006 TTreeNode.GetHandle 000e TreeView_EnsureVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2201_0 {
	meta:
		name = "TTreeNode.GetLevel"
		size = 26
		refs = "0004 TTreeNode.GetParent"
	strings:
		$1 = { 53 33 DB E8 ?? ?? ?? ?? 85 C0 74 0A 43 E8 ?? ?? ?? ?? 85 C0 75 F6 8B C3 5B C3 }
	condition:
		$1
}

rule function_2202_0 {
	meta:
		name = "TTreeNode.IsNodeVisible"
		size = 38
		refs = "000b TTreeNode.GetHandle 0017 TreeView_GetItemRect"
	strings:
		$1 = { 53 83 C4 F0 8B D8 6A FF 8B C3 E8 ?? ?? ?? ?? 8D 4C 24 04 8B 53 10 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_2203_0 {
	meta:
		name = "TTreeNode.EditText"
		size = 25
		refs = "0006 TTreeNode.GetHandle 000e TreeView_EditLabel"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 53 10 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5B C3 }
	condition:
		$1
}

rule function_2204_0 {
	meta:
		name = "TTreeNode.DisplayRect"
		size = 49
		refs = "0013 @FillChar 001f TTreeNode.GetHandle 0029 TreeView_GetItemRect"
	strings:
		$1 = { 53 56 57 8B F1 8B DA 8B F8 8B C6 33 C9 BA 10 00 00 00 E8 ?? ?? ?? ?? F6 DB 1B C0 50 8B C7 E8 ?? ?? ?? ?? 8B CE 8B 57 10 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2205_0 {
	meta:
		name = "TTreeNode.AlphaSort"
		size = 10
		refs = "0005 TTreeNode.CustomSort"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4628_0 {
	meta:
		name = "TClientDataSet.EditKey"
		size = 10
		refs = "0005 TClientDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5875_0 {
	meta:
		name = "TTable.EditKey"
		size = 10
		refs = "0005 TBDEDataSet.SetKeyBuffer"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3102_0 {
	meta:
		name = "TreeView_GetRoot"
		size = 10
		refs = "0005 TreeView_GetNextItem"
	strings:
		$1 = { 33 C9 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2206_0 {
	meta:
		name = "TTreeNode.CustomSort"
		size = 62
		refs = "000b _NF__81B 0026 TTreeNode.GetHandle 002f TreeView_SortChildrenCB"
	strings:
		$1 = { 53 83 C4 F4 8B D8 85 D2 75 0B B8 ?? ?? ?? ?? 89 44 24 04 EB 04 89 54 24 04 8B 43 10 89 04 24 89 4C 24 08 8B C3 E8 ?? ?? ?? ?? 8B D4 33 C9 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 C4 0C 5B C3 }
	condition:
		$1
}

rule function_2207_0 {
	meta:
		name = "TTreeNode.Delete"
		size = 12
		refs = "0007 TObject.Free"
	strings:
		$1 = { 80 78 24 00 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2208_0 {
	meta:
		name = "TTreeNode.DeleteChildren"
		size = 39
		refs = "0006 TTreeNode.GetTreeView 000b TWinControl.GetHandle 0018 TreeView_Expand 0021 TTreeNode.SetChildren"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 01 80 00 00 8B 53 10 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2209_0 {
	meta:
		name = "TTreeNode.Assign"
		size = 162
		refs = "000a _DV_TTreeNode 000f @IsClass 001d TTreeNode.SetText 0027 TTreeNode.SetData 0031 TTreeNode.SetImageIndex 003b TTreeNode.SetSelectedIndex 0045 TTreeNode.SetStateIndex 004f TTreeNode.SetOverlayIndex 0056 TTreeNode.GetFocused 005f TTreeNode.SetFocused 0066 TTreeNode.GetDropTarget 006f TTreeNode.SetDropTarget 0076 TTreeNode.GetCut 007f TTreeNode.SetCut 0086 TTreeNode.GetChildren 008f TTreeNode.SetChildren 009b TPersistent.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 7F 8B 56 08 8B C3 E8 ?? ?? ?? ?? 8B 56 0C 8B C3 E8 ?? ?? ?? ?? 8B 56 14 8B C3 E8 ?? ?? ?? ?? 8B 56 18 8B C3 E8 ?? ?? ?? ?? 8B 56 20 8B C3 E8 ?? ?? ?? ?? 8B 56 1C 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2210_0 {
	meta:
		name = "_NF__8AF"
		size = 37
		refs = "000d @LStrCmp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 08 8B 56 08 E8 ?? ?? ?? ?? 75 08 8B 43 0C 3B 46 0C 74 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_2211_0 {
	meta:
		name = "_NF__8B0"
		size = 206
		refs = "0019 _NF__8B0 002f TStream.ReadBuffer 0047 @LStrFromString 0051 TTreeNode.SetText 005a TTreeNode.SetImageIndex 0064 TTreeNode.SetSelectedIndex 006e TTreeNode.SetStateIndex 0078 TTreeNode.SetOverlayIndex 0082 TTreeNode.SetData 0099 TTreeNodes.AddChild 00bb @LStrClr 00c1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 8B F1 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 B9 04 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D6 8B 4D F8 8B 45 FC E8 ?? ?? ?? ?? 8D 45 F4 8D 56 18 E8 ?? ?? ?? ?? 8B 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 16 8B C3 E8 ?? ?? ?? ?? 8B 56 04 8B C3 E8 ?? ?? ?? ?? 8B 56 08 8B C3 E8 ?? ?? ?? ?? 8B 56 0C 8B C3 E8 ?? ?? ?? ?? 8B 56 10 8B C3 E8 ?? ?? ?? ?? 8B 46 14 8B F8 4F 85 FF 7C 1A 47 33 C9 8B D3 8B 43 04 E8 ?? ?? ?? ?? 8B CE 8B 55 FC E8 ?? ?? ?? ?? 4F 75 E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2212_0 {
	meta:
		name = "_NF__8B1"
		size = 174
		refs = "0012 @LStrLen 003c @LStrToString 0060 TTreeNode.GetCount 0076 TStream.WriteBuffer 0095 TTreeNode.GetItem 009f _NF__8B1"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 14 24 8B D8 8B 43 08 E8 ?? ?? ?? ?? 3D FF 00 00 00 7E 05 B8 FF 00 00 00 05 18 01 00 00 2D FF 00 00 00 89 44 24 04 8D 46 18 8B 53 08 B9 FF 00 00 00 E8 ?? ?? ?? ?? 8B 43 14 89 06 8B 43 18 89 46 04 8B 43 1C 89 46 0C 8B 43 20 89 46 08 8B 43 0C 89 46 10 8B C3 E8 ?? ?? ?? ?? 8B F8 89 7E 14 8D 54 24 04 B9 04 00 00 00 8B 04 24 E8 ?? ?? ?? ?? 8B D6 8B 4C 24 04 8B 04 24 E8 ?? ?? ?? ?? 4F 85 FF 7C 1A 47 33 ED 8B D5 8B C3 E8 ?? ?? ?? ?? 8B CE 8B 14 24 E8 ?? ?? ?? ?? 45 4F 75 E9 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2213_0 {
	meta:
		name = "TCustomModule.Create"
		size = 53
		refs = "000b @ClassCreate 001a TObject.Create"
		altNames = "THTMLTagAttributes.Create TListItems.Create TParaAttributes.Create TQRSubDetailGroupBands.Create TQuickRepBands.Create TTreeNodes.Create TVirtualStream.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 04 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2215_0 {
	meta:
		name = "TTreeNodes.GetCount"
		size = 33
		refs = "0007 TWinControl.HandleAllocated 0012 TTreeNodes.GetHandle 0017 TreeView_GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 0E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2551_0 {
	meta:
		name = "TListItems.GetCount"
		size = 33
		refs = "0007 TWinControl.HandleAllocated 0012 TListItems.GetHandle 0017 ListView_GetItemCount"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 0E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2216_0 {
	meta:
		name = "TListItems.GetHandle"
		size = 9
		refs = "0004 TWinControl.GetHandle"
		altNames = "TTreeNodes.GetHandle"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6588_0 {
	meta:
		name = "TComponentList.Add"
		size = 9
		refs = "0004 TList.Add"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6586_0 {
	meta:
		name = "TComponentList.Get"
		size = 9
		refs = "0004 TList.Get"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3890_0 {
	meta:
		name = "TFieldDefs.Update"
		size = 9
		refs = "0004 _NF__61E"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12736_0 {
	meta:
		name = "TQRPrinter.GetPrinterIndex"
		size = 9
		refs = "0004 TPrinter.GetPrinterIndex"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12737_0 {
	meta:
		name = "TQRPrinter.GetPrinters"
		size = 9
		refs = "0004 TPrinter.GetPrinters"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12935_0 {
	meta:
		name = "TQRSubDetailGroupBands.GetFooterBand"
		size = 9
		refs = "0004 TQRSubDetail.GetFooterBand"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12934_0 {
	meta:
		name = "TQRSubDetailGroupBands.GetHeaderBand"
		size = 9
		refs = "0004 TQRSubDetail.GetHeaderBand"
	strings:
		$1 = { 8B 40 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2217_0 {
	meta:
		name = "TTreeNodes.Delete"
		size = 52
		refs = "002d TTreeNode.Delete"
	strings:
		$1 = { 53 56 8B DA 83 7B 10 00 75 20 8B 50 04 66 83 BA C2 01 00 00 00 74 13 8B 70 04 8B CB 8B D0 8B 86 C4 01 00 00 FF 96 C0 01 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2218_0 {
	meta:
		name = "TTreeNodes.Clear"
		size = 29
		refs = "0007 TWinControl.HandleAllocated 0012 TTreeNodes.GetHandle 0017 TreeView_DeleteAllItems"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2556_0 {
	meta:
		name = "TListItems.Clear"
		size = 29
		refs = "0007 TWinControl.HandleAllocated 0012 TListItems.GetHandle 0017 ListView_DeleteAllItems"
	strings:
		$1 = { 53 8B D8 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2220_0 {
	meta:
		name = "TTreeNodes.AddChildObjectFirst"
		size = 20
		refs = "000b TTreeNodes.InternalAddObject"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 6A 00 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_7741_0 {
	meta:
		name = "GetDIB"
		size = 20
		refs = "000b _NF__431"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 6A 00 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2222_0 {
	meta:
		name = "TTreeNodes.AddChildObject"
		size = 20
		refs = "000b TTreeNodes.InternalAddObject"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 6A 01 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2224_0 {
	meta:
		name = "TTreeNodes.AddObjectFirst"
		size = 43
		refs = "0010 TTreeNode.GetParent 0021 TTreeNodes.InternalAddObject"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 85 D2 74 09 8B C2 E8 ?? ?? ?? ?? 8B D0 8B 45 08 50 6A 00 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2226_0 {
	meta:
		name = "_NF__8E1"
		size = 83
		refs = "0014 TTreeNode.GetParent 0021 TTreeNode.IsNodeVisible 0034 TTreeNode.DisplayRect 0043 TWinControl.GetHandle 0049 InvalidateRect"
	strings:
		$1 = { 53 56 83 C4 F0 8B DA 8B F0 83 7E 08 01 7D 3E EB 09 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 74 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 74 E8 85 DB 74 20 8B CC 33 D2 8B C3 E8 ?? ?? ?? ?? 6A FF 8D 44 24 04 50 8B 46 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_2227_0 {
	meta:
		name = "TTreeNodes.AddObject"
		size = 43
		refs = "0010 TTreeNode.GetParent 0021 TTreeNodes.InternalAddObject"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 85 D2 74 09 8B C2 E8 ?? ?? ?? ?? 8B D0 8B 45 08 50 6A 01 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2229_0 {
	meta:
		name = "_NF__8EB"
		size = 31
		refs = "000f TTreeNode.SetChildren 0018 _NF__8E1"
	strings:
		$1 = { 53 56 8B DA 8B F0 85 DB 74 12 B2 01 8B C3 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2230_0 {
	meta:
		name = "TTreeNodes.InsertObject"
		size = 311
		refs = "0019 TTreeNodes.InsertObject 0053 TTreeNode.GetParent 0069 TTreeNode.GetPrevSibling 0086 TTreeNode.SetData 0091 TTreeNode.SetText 009e TTreeNodes.CreateItem 00b2 TTreeNodes.AddItem 00c0 sInsertError 00c5 LoadResString 00cf _Dn_EOutOfResources 00d4 Exception.Create 00d9 @RaiseExcept 00e9 _NF__8EB 00f8 @HandleAnyException 0100 TObject.Free 0105 @RaiseAgain 010a @DoneExcept 011f @LStrClr 0125 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 57 33 DB 89 5D C0 89 4D FC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 46 04 8B 10 FF 52 7C 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 33 C0 89 45 F4 33 C0 89 45 F0 C6 45 EF 02 85 FF 74 2F 8B C7 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 06 8B 45 F0 8B 58 10 8B C7 E8 ?? ?? ?? ?? 8B F8 85 FF 74 08 8B 47 10 89 45 F4 EB 04 C6 45 EF 00 8B 55 08 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8D 4D C4 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 8D 45 C4 50 8A 45 EF 50 8B 4D F4 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 21 8D 55 C0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D C0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 89 58 10 8B 55 F0 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2231_0 {
	meta:
		name = "TTreeNodes.InternalAddObject"
		size = 253
		refs = "0019 TTreeNodes.InternalAddObject 004e TTreeNode.SetData 0059 TTreeNode.SetText 0066 TTreeNodes.CreateItem 0079 TTreeNodes.AddItem 0087 sInsertError 008c LoadResString 0096 _Dn_EOutOfResources 009b Exception.Create 00a0 @RaiseExcept 00af _NF__8EB 00be @HandleAnyException 00c6 TObject.Free 00cb @RaiseAgain 00d0 @DoneExcept 00e5 @LStrClr 00eb @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 33 DB 89 5D CC 89 4D FC 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 46 04 8B 10 FF 52 7C 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 05 8B 5F 10 EB 02 33 DB 8B 55 0C 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8D 4D D0 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 8D 45 D0 50 8A 45 08 50 33 C9 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 21 8D 55 CC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D CC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 89 58 10 8B D7 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_2232_0 {
	meta:
		name = "TTreeNodes.CreateItem"
		size = 35
	strings:
		$1 = { C6 42 25 01 C7 01 27 00 00 00 89 51 24 C7 41 10 FF FF FF FF C7 41 18 FF FF FF FF C7 41 1C FF FF FF FF C3 }
	condition:
		$1
}

rule function_2233_0 {
	meta:
		name = "TTreeNodes.AddItem"
		size = 89
		refs = "0044 TTreeNodes.GetHandle 004c TreeView_InsertItem"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 8B D8 89 55 D0 8A 45 08 2C 01 72 08 74 0F FE C8 74 14 EB 15 C7 45 D4 01 00 FF FF EB 0C C7 45 D4 02 00 FF FF EB 03 89 4D D4 8B 45 0C 8B F0 8D 7D D8 B9 0A 00 00 00 F3 A5 8B C3 E8 ?? ?? ?? ?? 8D 55 D0 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_2234_0 {
	meta:
		name = "TTreeNodes.GetFirstNode"
		size = 26
		refs = "0006 TTreeNodes.GetHandle 000b TreeView_GetRoot 0014 TTreeNodes.GetNode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2235_0 {
	meta:
		name = "TTreeNodes.GetNodeFromIndex"
		size = 111
		refs = "000d TTreeNodes.GetNodeFromIndex 0018 TTreeNodes.GetFirstNode 0023 TTreeNode.GetNext 003a sInvalidIndex 003f LoadResString 0047 _NF__81C 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 E8 ?? ?? ?? ?? 8B D8 EB 0A 8B C3 E8 ?? ?? ?? ?? 8B D8 4E 85 F6 74 04 85 DB 75 EE 85 DB 75 15 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2236_0 {
	meta:
		name = "TTreeNodes.GetNode"
		size = 48
		refs = "0014 TTreeNodes.GetHandle 001b TreeView_GetItem"
	strings:
		$1 = { 53 83 C4 D8 8B D8 89 54 24 04 C7 04 24 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 85 C0 74 06 8B 44 24 24 EB 02 33 C0 83 C4 28 5B C3 }
	condition:
		$1
}

rule function_2238_0 {
	meta:
		name = "TTreeNodes.BeginUpdate"
		size = 23
		refs = "000e TTreeNodes.SetUpdateState"
	strings:
		$1 = { 53 8B D8 83 7B 08 00 75 09 B2 01 8B C3 E8 ?? ?? ?? ?? FF 43 08 5B C3 }
	condition:
		$1
}

rule function_2557_0 {
	meta:
		name = "TListItems.BeginUpdate"
		size = 23
		refs = "000e TListItems.SetUpdateState"
	strings:
		$1 = { 53 8B D8 83 7B 08 00 75 09 B2 01 8B C3 E8 ?? ?? ?? ?? FF 43 08 5B C3 }
	condition:
		$1
}

rule function_2239_0 {
	meta:
		name = "TTreeNodes.SetUpdateState"
		size = 86
		refs = "0015 TTreeNodes.GetHandle 001b SendMessage 0035 TCustomTreeView.SetSortType 004f TControl.Refresh"
	strings:
		$1 = { 53 56 8B DA 8B F0 6A 00 8B C3 34 01 83 E0 7F 50 6A 0B 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 84 DB 74 19 8B 46 04 8A 90 38 01 00 00 88 90 72 01 00 00 33 D2 E8 ?? ?? ?? ?? 5E 5B C3 8B 5E 04 8A 93 72 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2240_0 {
	meta:
		name = "TTreeNodes.EndUpdate"
		size = 17
		refs = "000c TTreeNodes.SetUpdateState"
	strings:
		$1 = { FF 48 08 83 78 08 00 75 07 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2559_0 {
	meta:
		name = "TListItems.EndUpdate"
		size = 17
		refs = "000c TListItems.SetUpdateState"
	strings:
		$1 = { FF 48 08 83 78 08 00 75 07 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2241_0 {
	meta:
		name = "TTreeNodes.Assign"
		size = 136
		refs = "000e _DV_TTreeNodes 0013 @IsClass 001e TTreeNodes.Clear 0025 _Dn_TMemoryStream 002a TObject.Create 0035 TTreeNodes.Assign 0045 _NF__91B 004f TStream.SetPosition 0059 _NF__91A 006e TObject.Free 0074 @HandleFinally 007f TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 5F 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2242_0 {
	meta:
		name = "_NF__916"
		size = 142
		refs = "001f TTreeNodes.GetCount 004f TTreeNodes.GetNodeFromIndex 0063 _NF__8AF"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 08 8B 40 FC 8B 40 1C 89 45 FC 33 DB 83 7D FC 00 74 5B 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B F0 75 42 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 40 47 33 F6 8B D6 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 08 8B 40 F8 8B D6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D8 80 F3 01 84 DB 75 16 46 4F 75 D5 EB 10 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 85 C0 0F 9F C3 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2243_0 {
	meta:
		name = "TTreeNodes.DefineProperties"
		size = 88
		refs = "0014 TPersistent.DefineProperties 001d _NF__91A 0026 _NF__91B 002c _NF__916 0034 TTreeNodes.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_11833_0 {
	meta:
		name = "TCustomOutline.DefineProperties"
		size = 88
		refs = "0014 TCustomGrid.DefineProperties 001d _NF__203 0026 _NF__204 002c _NF__1FF 0034 TCustomOutline.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_2562_0 {
	meta:
		name = "TListItems.DefineProperties"
		size = 88
		refs = "0014 TPersistent.DefineProperties 001d _NF__C3D 0026 _NF__C3F 002c _NF__C39 0034 TListItems.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_5930_0 {
	meta:
		name = "TParams.DefineProperties"
		size = 88
		refs = "0014 TPersistent.DefineProperties 001d _NF__89F 0026 _NF__8A0 002c _NF__89B 0034 TParams.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 FF FF FF FF 04 00 00 00 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_2244_0 {
	meta:
		name = "_NF__91A"
		size = 78
		refs = "0010 TTreeNodes.Clear 001e TStream.ReadBuffer 0032 TTreeNodes.Add 003d _NF__8B0"
	strings:
		$1 = { 53 56 57 81 C4 E4 FE FF FF 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D4 B9 04 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 1C 24 4B 85 DB 7C 1A 43 33 C9 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 4C 24 04 8B D7 E8 ?? ?? ?? ?? 4B 75 E7 81 C4 1C 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2245_0 {
	meta:
		name = "_NF__91B"
		size = 110
		refs = "0015 TTreeNodes.GetFirstNode 0025 TTreeNode.GetNextSibling 0039 TStream.WriteBuffer 0053 _NF__8B1"
	strings:
		$1 = { 53 56 57 81 C4 E4 FE FF FF 8B F2 8B F8 33 C0 89 04 24 8B C7 E8 ?? ?? ?? ?? 8B D8 85 DB 74 10 FF 04 24 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 F0 8B D4 B9 04 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 85 DB 74 1A 8D 4C 24 04 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 E6 81 C4 1C 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2246_0 {
	meta:
		name = "_NF__91E"
		size = 53
		refs = "000b @ClassCreate 001a TObject.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2247_0 {
	meta:
		name = "_NF__91F"
		size = 84
		refs = "000c @LStrClr 0016 TTreeNodes.GetNodeFromIndex 001f TTreeNode.GetLevel 002e _NF__91F 0033 @LStrCat"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B C3 E8 ?? ?? ?? ?? 8B 46 0C 8B D7 E8 ?? ?? ?? ?? 8B F8 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 10 46 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 4E 75 F1 8B C3 8B 57 08 E8 ?? ?? ?? ?? 5F 5E 5B C3 FF FF FF FF 01 00 00 00 09 00 00 00 }
	condition:
		$1
}

rule function_2248_0 {
	meta:
		name = "_NF__920"
		size = 22
	strings:
		$1 = { 33 C0 89 01 EB 03 42 FF 01 8A 02 2C 09 74 F7 2C 17 74 F3 8B C2 C3 }
	condition:
		$1
}

rule function_2249_0 {
	meta:
		name = "_NF__921"
		size = 22
		refs = "000c TTreeNodes.GetNodeFromIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? 8B 40 0C 5E 5B C3 }
	condition:
		$1
}

rule function_2250_0 {
	meta:
		name = "_NF__922"
		size = 30
		refs = "000f TTreeNodes.GetNodeFromIndex 0016 TTreeNode.SetData"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_6968_0 {
	meta:
		name = "_NF__2A1"
		size = 30
		refs = "000f TList.Get 0016 TControl.GetText"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_6969_0 {
	meta:
		name = "_NF__2A2"
		size = 30
		refs = "000f TList.Get 0016 TControl.SetText"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_14733_0 {
	meta:
		name = "_NF__CB"
		size = 30
		refs = "000f TList.Get 0016 TControl.GetText"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2251_0 {
	meta:
		name = "_NF__923"
		size = 9
		refs = "0004 TTreeNodes.GetCount"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5542_0 {
	meta:
		name = "EDBEngineError.GetError"
		size = 9
		refs = "0004 TList.Get"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8221_0 {
	meta:
		name = "TStringGridStrings.SetUpdateState"
		size = 9
		refs = "0004 _NF__495"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11814_0 {
	meta:
		name = "_NF__1E6"
		size = 9
		refs = "0004 TCustomOutline.GetItemCount"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11815_0 {
	meta:
		name = "_NF__1E7"
		size = 9
		refs = "0004 TCustomOutline.Clear"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6970_0 {
	meta:
		name = "_NF__2A3"
		size = 9
		refs = "0004 TList.Get"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8204_0 {
	meta:
		name = "_NF__444"
		size = 9
		refs = "0004 _NF__42E"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2252_0 {
	meta:
		name = "_NF__924"
		size = 9
		refs = "0004 TTreeNodes.Clear"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14735_0 {
	meta:
		name = "_NF__CD"
		size = 9
		refs = "0004 TList.Get"
	strings:
		$1 = { 8B 40 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2253_0 {
	meta:
		name = "_NF__925"
		size = 24
		refs = "000c TTreeNodes.GetNodeFromIndex 0011 TTreeNode.Delete"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2254_0 {
	meta:
		name = "_NF__926"
		size = 53
		refs = "0016 TTreeNodes.GetHandle 001c SendMessage 002e TControl.Refresh"
	strings:
		$1 = { 53 56 8B DA 8B F0 6A 00 8B C3 34 01 83 E0 7F 50 6A 0B 8B 46 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 F3 01 84 DB 74 0B 8B 46 0C 8B 40 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2255_0 {
	meta:
		name = "_NF__927"
		size = 291
		refs = "001a _NF__927 0032 @LStrLen 004d @LStrToPChar 0059 _NF__920 0063 @LStrFromPChar 0075 TTreeNodes.GetNodeFromIndex 007e TTreeNode.GetLevel 0099 sInvalidLevel 009e LoadResString 00a6 _NF__81C 00bb TTreeNode.GetParent 00f3 TTreeNodes.AddChild 010d @LStrArrayClr 0113 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D E8 89 4D EC 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 8B 10 FF 52 14 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 48 75 0C 8B 45 FC 80 38 1A 0F 84 B2 00 00 00 33 DB 33 F6 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8D 4D F4 8B C7 E8 ?? ?? ?? ?? 8B D0 8D 45 EC E8 ?? ?? ?? ?? 83 7D F8 00 7E 17 8B 55 F8 4A 8B 47 0C E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 3B 75 F4 7C 04 85 DB 75 1F 8B 45 F4 2B C6 48 7E 55 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? EB 3E 8B 45 F4 2B C6 7F 37 48 96 89 45 F0 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 1F 8B 45 F0 2B 45 F4 85 C0 7E 15 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? FF 4D F0 46 75 CE 8B 4D EC 8B D3 8B 47 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2256_0 {
	meta:
		name = "_NF__928"
		size = 34
		refs = "000f TTreeNodes.GetNodeFromIndex 001a TTreeNodes.Insert"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B 58 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D0 8B CF 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2257_0 {
	meta:
		name = "_NF__929"
		size = 538
		refs = "001a _NF__929 0027 _Dn_TStringList 002c TObject.Create 003a TTreeNodes.BeginUpdate 009b @LStrToPChar 00a8 _NF__920 00b2 @LStrFromPChar 00c6 TTreeNodes.AddChild 00d4 TTreeNode.GetLevel 00e0 TTreeNode.GetParent 0169 sInvalidLevelEx 016e LoadResString 0194 _NF__81D 01b6 TTreeNodes.EndUpdate 01be TObject.Free 01c4 @HandleFinally 01d5 @HandleAnyException 01e8 @RaiseAgain 01ed @DoneExcept 0207 @LStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 C9 89 4D E8 89 4D EC 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 40 8B D3 8B 45 F8 8B 08 FF 51 5C 33 DB 8B 45 F8 8B 10 FF 52 14 8B F0 4E 85 F6 0F 8C 21 01 00 00 46 C7 45 F0 00 00 00 00 8D 4D E8 8B 55 F0 8B 45 F8 8B 38 FF 57 0C 8B 45 E8 E8 ?? ?? ?? ?? 8B D0 8D 4D F4 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8D 45 EC E8 ?? ?? ?? ?? 85 DB 75 17 8B 45 FC 8B 40 0C 8B 4D EC 33 D2 E8 ?? ?? ?? ?? 8B D8 E9 C7 00 00 00 8B C3 E8 ?? ?? ?? ?? 3B 45 F4 75 1E 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 40 0C 8B 4D EC E8 ?? ?? ?? ?? 8B D8 E9 9D 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 4A 3B C2 75 14 8B 45 FC 8B 40 0C 8B 4D EC 8B D3 E8 ?? ?? ?? ?? 8B D8 EB 7A 8B C3 E8 ?? ?? ?? ?? 3B 45 F4 7E 3B 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 09 8B C3 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 3B 45 F4 7F EB 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 40 0C 8B 4D EC E8 ?? ?? ?? ?? 8B D8 EB 33 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 50 8B 45 F4 89 45 D8 C6 45 DC 00 8B 45 EC 89 45 E0 C6 45 E4 0B 8D 55 D8 B9 01 00 00 00 58 E8 ?? ?? ?? ?? FF 45 F0 4E 0F 85 E7 FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 33 C0 5A 59 59 64 89 10 EB 1D E9 ?? ?? ?? ?? 8B 45 FC 8B 40 0C 8B 40 04 8B 10 FF 52 44 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2258_0 {
	meta:
		name = "_NF__92A"
		size = 216
		refs = "0016 _NF__92A 0031 TTreeNodes.GetNodeFromIndex 003f @LStrClr 0046 TTreeNode.GetLevel 005b @LStrCat 0076 @LStrCatN 007e @LStrLen 0092 TTreeNode.GetNext 00b3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 14 85 C0 7E 71 8B 43 0C 33 D2 E8 ?? ?? ?? ?? 8B F0 85 F6 74 61 8D 45 F8 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 11 43 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 4B 75 F0 FF 75 F8 FF 76 08 68 ?? ?? ?? ?? 8D 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B 45 FC 8B 18 FF 53 08 8B C6 E8 ?? ?? ?? ?? 8B F0 85 F6 75 9F 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 00 FF FF FF FF 01 00 00 00 09 00 00 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_2259_0 {
	meta:
		name = "TCustomTreeView.Create"
		size = 296
		refs = "000e @ClassCreate 001c TWinControl.Create 0022 TCustomTreeView.Create 003f TControl.SetWidth 004b TControl.SetHeight 0054 TWinControl.SetTabStop 005d TControl.SetParentColor 0066 _DV_TTreeNodes 006b TTreeNodes.Create 00a2 _Dn_TImageList 00a7 TCustomImageList.CreateSize 00bd _NF__940 00c2 MakeObjectInstance 00cf _Dn_TChangeLink 00d4 TObject.Create 00e6 _NF__9C2"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? F7 D0 66 23 43 40 66 0B 05 ?? ?? ?? ?? 66 89 43 40 BA 79 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 61 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 34 01 00 00 C6 83 1B 01 00 00 01 C6 83 1A 01 00 00 01 C6 83 19 01 00 00 01 C6 83 18 01 00 00 01 C6 83 4C 01 00 00 01 6A 20 B9 20 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 30 01 00 00 C7 83 48 01 00 00 FF FF FF FF 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 54 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 28 01 00 00 89 5E 0C C7 46 08 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 2C 01 00 00 89 5E 0C C7 46 08 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 02 00 00 00 00 60 00 00 }
	condition:
		$1
}

rule function_2260_0 {
	meta:
		name = "TCustomTreeView.Destroy"
		size = 111
		refs = "000d TObject.Free 0039 FreeObjectInstance 005b TWinControl.Destroy 0066 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 34 01 00 00 E8 ?? ?? ?? ?? 8B 86 3C 01 00 00 E8 ?? ?? ?? ?? 8B 86 30 01 00 00 E8 ?? ?? ?? ?? 8B 86 50 01 00 00 E8 ?? ?? ?? ?? 8B 86 54 01 00 00 E8 ?? ?? ?? ?? 8B 86 28 01 00 00 E8 ?? ?? ?? ?? 8B 86 2C 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2261_0 {
	meta:
		name = "TCustomTreeView.CreateParams"
		size = 212
		refs = "000c InitCommonControl 0015 TWinControl.CreateParams 001a TCustomTreeView.CreateParams 0023 TWinControl.CreateSubClass 0035 _NV__933 0044 _NV__932 0053 _NV__934 0062 _NV__935 0071 _NV__936 0080 _NV__937 008c _NV__938 009d NewStyleControls"
	strings:
		$1 = { 53 56 8B F2 8B D8 B8 02 00 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 46 04 33 D2 8A 93 18 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 1B 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 19 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 1A 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 1C 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 4C 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 53 49 0B 04 95 ?? ?? ?? ?? 89 46 04 80 BB D5 00 00 00 00 74 21 A1 ?? ?? ?? ?? 80 38 00 74 17 80 BB 1B 01 00 00 01 75 0E 81 66 04 FF FF 7F FF 81 4E 08 00 02 00 00 83 66 24 FC 5E 5B C3 53 79 73 54 72 65 65 56 69 65 77 33 32 00 00 00 }
	condition:
		$1
}

rule function_2262_0 {
	meta:
		name = "TCustomTreeView.CreateWnd"
		size = 242
		refs = "000e TWinControl.CreateWnd 0025 _NF__91A 004b TTreeNodes.GetNodeFromIndex 0054 TCustomTreeView.SetTopItem 0076 TCustomTreeView.SetSelection 0092 TCustomTreeView.SetIndent 00a3 TCustomImageList.HandleAllocated 00b2 TCustomImageList.GetHandle 00bd _NF__9C1"
	strings:
		$1 = { 53 56 8B D8 C6 83 73 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 83 50 01 00 00 85 C0 74 66 8B D0 8B 83 34 01 00 00 E8 ?? ?? ?? ?? B2 01 8B 83 50 01 00 00 8B 08 FF 51 FC 33 C0 89 83 50 01 00 00 8B 93 40 01 00 00 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 89 83 40 01 00 00 8B 93 44 01 00 00 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 89 83 44 01 00 00 8B 83 48 01 00 00 83 F8 FF 74 09 8B D0 8B C3 E8 ?? ?? ?? ?? 8B B3 20 01 00 00 85 F6 74 21 8B C6 E8 ?? ?? ?? ?? 84 C0 74 16 8B 83 20 01 00 00 E8 ?? ?? ?? ?? 8B D0 33 C9 8B C3 E8 ?? ?? ?? ?? 8B B3 24 01 00 00 85 F6 74 24 8B C6 E8 ?? ?? ?? ?? 84 C0 74 19 8B 83 24 01 00 00 E8 ?? ?? ?? ?? 8B D0 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2263_0 {
	meta:
		name = "TCustomTreeView.DestroyWnd"
		size = 147
		refs = "0012 TTreeNodes.GetCount 001d _Dn_TMemoryStream 0022 TObject.Create 0037 _NF__91B 0044 TStream.SetPosition 004b TCustomTreeView.GetTopItem 0058 TTreeNode.GetAbsoluteIndex 0065 TCustomTreeView.GetSelection 007f TCustomTreeView.GetIndent 008c TWinControl.DestroyWnd"
	strings:
		$1 = { 53 56 8B D8 C6 83 73 01 00 00 01 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 85 C0 7E 62 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 50 01 00 00 8B D6 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 50 01 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 74 0D 8B C6 E8 ?? ?? ?? ?? 89 83 40 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 74 0D 8B C6 E8 ?? ?? ?? ?? 89 83 44 01 00 00 8B C3 E8 ?? ?? ?? ?? 89 83 48 01 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2264_0 {
	meta:
		name = "_NF__940"
		size = 256
		refs = "0010 _NF__940 0057 TWinControl.DoKeyDown 0072 TWinControl.DoKeyPress 008a TWinControl.DoKeyUp 00d0 CallWindowProc 00e2 @HandleAnyException 00e7 Application 00f1 TApplication.HandleException 00f6 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 03 3D 05 01 00 00 7F 16 74 5F 2D 00 01 00 00 74 25 48 74 55 48 74 3A 83 E8 02 74 1A EB 77 2D 00 BD 00 00 74 5C 83 E8 02 74 57 83 E8 02 74 52 83 E8 02 74 4D EB 5F 8B D3 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 51 33 C0 5A 59 59 64 89 10 E9 8E 00 00 00 8B D3 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 36 33 C0 5A 59 59 64 89 10 EB 76 8B D3 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 1E 33 C0 5A 59 59 64 89 10 EB 5E 8B D3 8B 45 FC 8B 08 FF 51 40 33 C0 5A 59 59 64 89 10 EB 4A 8B 43 08 50 8B 43 04 50 8B 03 50 8B 45 FC 8B 80 5C 01 00 00 50 8B 45 FC 8B 80 58 01 00 00 50 E8 ?? ?? ?? ?? 89 43 0C 33 C0 5A 59 59 64 89 10 EB 19 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2266_0 {
	meta:
		name = "TCustomTreeView.CMCtl3DChanged"
		size = 28
		refs = "0006 TWinControl.CMCtl3DChanged 0016 TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 1B 01 00 00 01 75 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2268_0 {
	meta:
		name = "TCustomTreeView.AlphaSort"
		size = 105
		refs = "000a TWinControl.HandleAllocated 0019 TCustomTreeView.CustomSort 0027 TTreeNodes.GetCount 003e TTreeNodes.GetNodeFromIndex 0047 TTreeNode.GetChildren 0052 TTreeNode.AlphaSort"
	strings:
		$1 = { 53 56 57 55 51 8B F8 8B C7 E8 ?? ?? ?? ?? 84 C0 74 4A 33 C9 33 D2 8B C7 E8 ?? ?? ?? ?? 88 04 24 8B 87 34 01 00 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 2E 46 33 ED 8B D5 8B 87 34 01 00 00 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 07 8B C3 E8 ?? ?? ?? ?? 45 4E 75 DB EB 04 C6 04 24 00 8A 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2269_0 {
	meta:
		name = "TCustomTreeView.CustomSort"
		size = 181
		refs = "0018 TWinControl.HandleAllocated 002b _NF__81B 004f TWinControl.GetHandle 005a TreeView_SortChildrenCB 006f TTreeNodes.GetCount 0086 TTreeNodes.GetNodeFromIndex 008f TTreeNode.GetChildren 00a1 TTreeNode.CustomSort"
	strings:
		$1 = { 53 56 57 55 83 C4 E8 89 4C 24 04 89 14 24 8B F8 C6 44 24 08 00 8B C7 E8 ?? ?? ?? ?? 84 C0 0F 84 85 00 00 00 83 3C 24 00 75 0B B8 ?? ?? ?? ?? 89 44 24 10 EB 07 8B 04 24 89 44 24 10 C7 44 24 0C 00 00 FF FF 8B 44 24 04 89 44 24 14 8B C7 E8 ?? ?? ?? ?? 8D 54 24 0C 33 C9 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 88 44 24 08 8B 87 34 01 00 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 2F 46 33 ED 8B D5 8B 87 34 01 00 00 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B 4C 24 04 8B 14 24 8B C3 E8 ?? ?? ?? ?? 45 4E 75 D4 8A 44 24 08 83 C4 18 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2270_0 {
	meta:
		name = "TCustomTreeView.SetSortType"
		size = 56
		refs = "0033 TCustomTreeView.AlphaSort"
	strings:
		$1 = { 3A 90 38 01 00 00 74 2F 88 90 38 01 00 00 8A 90 38 01 00 00 8B CA 80 E9 01 74 05 80 E9 02 75 0A 66 83 B8 BA 01 00 00 00 75 08 80 C2 FE 80 EA 02 73 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2271_0 {
	meta:
		name = "_NF__953"
		size = 71
		refs = "000d TWinControl.HandleAllocated 001a TWinControl.GetHandle 0020 GetWindowLong 003e SetWindowLong"
	strings:
		$1 = { 53 56 57 55 8B D9 8B FA 8B E8 8B C5 E8 ?? ?? ?? ?? 84 C0 74 2D 6A F0 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 84 DB 75 06 F7 D7 23 F7 EB 02 0B F7 56 6A F0 8B C5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2272_0 {
	meta:
		name = "TCustomTreeView.SetBorderStyle"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 1B 01 00 00 74 0B 88 90 1B 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2273_0 {
	meta:
		name = "TCustomTreeView.SetDragMode"
		size = 40
		refs = "0018 _NF__953 0021 TControl.SetDragMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 5E 49 74 11 84 DB 0F 94 C1 BA 10 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2274_0 {
	meta:
		name = "TCustomTreeView.SetButtonStyle"
		size = 27
		refs = "0016 _NF__953"
	strings:
		$1 = { 3A 90 1A 01 00 00 74 12 88 90 1A 01 00 00 8B CA BA 01 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2275_0 {
	meta:
		name = "TCustomTreeView.SetLineStyle"
		size = 27
		refs = "0016 _NF__953"
	strings:
		$1 = { 3A 90 18 01 00 00 74 12 88 90 18 01 00 00 8B CA BA 02 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2276_0 {
	meta:
		name = "TCustomTreeView.SetRootStyle"
		size = 27
		refs = "0016 _NF__953"
	strings:
		$1 = { 3A 90 19 01 00 00 74 12 88 90 19 01 00 00 8B CA BA 04 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2277_0 {
	meta:
		name = "TCustomTreeView.SetReadOnly"
		size = 30
		refs = "0019 _NF__953"
	strings:
		$1 = { 3A 90 1C 01 00 00 74 15 88 90 1C 01 00 00 8B CA 80 F1 01 BA 08 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2278_0 {
	meta:
		name = "TCustomTreeView.SetHideSelection"
		size = 43
		refs = "001e _NF__953"
	strings:
		$1 = { 56 8B F0 3A 96 4C 01 00 00 74 1E 88 96 4C 01 00 00 8B CA 80 F1 01 8B C6 BA 20 00 00 00 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 44 5E C3 }
	condition:
		$1
}

rule function_2279_0 {
	meta:
		name = "TCustomTreeView.GetNodeAt"
		size = 55
		refs = "0010 TWinControl.GetHandle 0017 TreeView_HitTest 002a TTreeNodes.GetNode"
	strings:
		$1 = { 53 83 C4 F0 8B D8 89 14 24 89 4C 24 04 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 85 C0 74 11 8B 54 24 0C 8B 83 34 01 00 00 E8 ?? ?? ?? ?? EB 02 33 C0 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_2280_0 {
	meta:
		name = "TCustomTreeView.GetHitTestInfoAt"
		size = 168
		refs = "000d TCustomTreeView.GetHitTestInfoAt 001b TWinControl.GetHandle 0022 TreeView_HitTest"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F9 8B D8 66 8B 35 ?? ?? ?? ?? 89 14 24 89 7C 24 04 8B C3 E8 ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 8B 5C 24 08 F6 C7 01 74 04 66 83 CE 01 F6 C7 02 74 04 66 83 CE 02 F6 C3 01 74 04 66 83 CE 04 F6 C3 46 74 04 66 83 CE 08 F6 C3 10 74 04 66 83 CE 10 F6 C3 02 74 04 66 83 CE 20 F6 C3 08 74 04 66 83 CE 40 F6 C3 04 74 05 66 81 CE 80 00 F6 C3 20 74 05 66 81 CE 00 01 F6 C3 40 74 05 66 81 CE 00 02 F6 C7 08 74 05 66 81 CE 00 04 F6 C7 04 74 05 66 81 CE 00 08 8B C6 83 C4 10 5F 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_2281_0 {
	meta:
		name = "TCustomTreeView.SetTreeNodes"
		size = 16
	strings:
		$1 = { 56 8B F0 8B 86 34 01 00 00 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_2282_0 {
	meta:
		name = "TCustomTreeView.SetIndent"
		size = 34
		refs = "0009 TCustomTreeView.GetIndent 0014 TWinControl.GetHandle 001b TreeView_SetIndent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 3B F0 74 0E 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2284_0 {
	meta:
		name = "TCustomTreeView.FullExpand"
		size = 42
		refs = "0008 TTreeNodes.GetFirstNode 0017 TTreeNode.Expand 001e TTreeNode.GetNextSibling"
	strings:
		$1 = { 53 8B 80 34 01 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 16 B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 EA 5B C3 }
	condition:
		$1
}

rule function_2285_0 {
	meta:
		name = "TCustomTreeView.FullCollapse"
		size = 42
		refs = "0008 TTreeNodes.GetFirstNode 0017 TTreeNode.Collapse 001e TTreeNode.GetNextSibling"
	strings:
		$1 = { 53 8B 80 34 01 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 16 B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 EA 5B C3 }
	condition:
		$1
}

rule function_2286_0 {
	meta:
		name = "TCustomTreeView.Loaded"
		size = 25
		refs = "0006 TComponent.Loaded 0013 TCustomTreeView.FullExpand"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 20 10 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2287_0 {
	meta:
		name = "TCustomTreeView.GetTopItem"
		size = 45
		refs = "0006 TWinControl.HandleAllocated 0011 TWinControl.GetHandle 0016 TreeView_GetFirstVisible 0023 TTreeNodes.GetNode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2288_0 {
	meta:
		name = "TCustomTreeView.SetTopItem"
		size = 39
		refs = "0009 TWinControl.HandleAllocated 0018 TWinControl.GetHandle 0020 TreeView_SelectSetFirstVisible"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 13 85 F6 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 56 10 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2289_0 {
	meta:
		name = "TCustomTreeView.GetSelection"
		size = 71
		refs = "0006 TWinControl.HandleAllocated 002b TWinControl.GetHandle 0030 TreeView_GetSelection 003d TTreeNodes.GetNode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 35 80 BB 71 01 00 00 00 74 11 83 BB 64 01 00 00 00 74 08 8B 83 64 01 00 00 EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2290_0 {
	meta:
		name = "TCustomTreeView.SetSelection"
		size = 34
		refs = "000c TTreeNode.SetSelected 0015 TWinControl.GetHandle 001c TreeView_SelectItem"
	strings:
		$1 = { 53 8B D8 85 D2 74 0B 8B C2 B2 01 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2291_0 {
	meta:
		name = "TCustomTreeView.GetDropTarget"
		size = 55
		refs = "0006 TWinControl.HandleAllocated 0011 TWinControl.GetHandle 0016 TreeView_GetDropHilite 0023 TTreeNodes.GetNode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 25 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 83 68 01 00 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2292_0 {
	meta:
		name = "TCustomTreeView.SetDropTarget"
		size = 49
		refs = "0009 TWinControl.HandleAllocated 001a TTreeNode.SetDropTarget 0023 TWinControl.GetHandle 002a TreeView_SelectDropTarget"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 85 F6 74 0B B2 01 8B C6 E8 ?? ?? ?? ?? EB 0E 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2293_0 {
	meta:
		name = "_NF__98E"
		size = 25
		refs = "0014 TTreeNodes.GetNode"
	strings:
		$1 = { F6 42 08 04 74 04 8B 42 24 C3 8B 52 04 8B 80 34 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2294_0 {
	meta:
		name = "TCustomTreeView.IsEditing"
		size = 39
		refs = "0006 TWinControl.GetHandle 000b TreeView_GetEditControl 0017 IsWindowVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 0A 53 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_2622_0 {
	meta:
		name = "TCustomListView.IsEditing"
		size = 39
		refs = "0006 TWinControl.GetHandle 000b ListView_GetEditControl 0017 IsWindowVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 0A 53 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_2295_0 {
	meta:
		name = "TCustomTreeView.CNNotify"
		size = 991
		refs = "0016 TCustomTreeView.CNNotify 00b1 _NF__98E 00c6 TControl.Dragging 00e4 @CallDynaInst 0100 TWinControl.GetHandle 0105 TreeView_GetEditControl 0115 GetWindowLong 0130 SetWindowLong 02a0 TTreeNodes.Delete 02d3 @LStrFromPChar 02de TTreeNode.SetText 030d @LStrToPChar 031a StrLCopy 032a _NF__9A5 0343 _NF__9A6 0360 GetCursorPos 036d TControl.ScreenToClient 0375 PointToSmallPoint 038d TCustomTreeView.GetNodeAt 039c MakeLong 03ab TControl.Perform 03cc @LStrClr 03d2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 33 C9 89 4D E0 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 57 08 8B C2 8B 40 08 3D 6B FE FF FF 7F 33 0F 84 19 01 00 00 05 9B 01 00 00 83 F8 05 0F 87 78 03 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3D 6E FE FF FF 7F 1D 0F 84 DB 01 00 00 2D 6C FE FF FF 0F 84 2F 02 00 00 48 0F 84 66 02 00 00 E9 35 03 00 00 2D 6F FE FF FF 0F 84 85 01 00 00 2D 8C 01 00 00 0F 84 B6 02 00 00 E9 1A 03 00 00 C6 86 60 01 00 00 01 8B 5F 08 8D 53 38 8B C6 E8 ?? ?? ?? ?? 89 86 6C 01 00 00 E9 FB 02 00 00 89 55 F0 8B C6 E8 ?? ?? ?? ?? 84 C0 75 1E 8B 45 F0 8D 50 0C 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 66 BB DB FF E8 ?? ?? ?? ?? 84 C0 75 07 C7 47 0C 01 00 00 00 83 7F 0C 00 0F 85 BE 02 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E 5C 01 00 00 6A FC 53 E8 ?? ?? ?? ?? 89 86 58 01 00 00 8B 86 54 01 00 00 50 6A FC 8B 86 5C 01 00 00 50 E8 ?? ?? ?? ?? E9 82 02 00 00 8B C2 8D 50 0C 8B C6 66 BB D5 FF E8 ?? ?? ?? ?? E9 6D 02 00 00 80 BE 70 01 00 00 00 0F 85 60 02 00 00 89 55 EC 8B 45 EC 8D 50 38 8B C6 E8 ?? ?? ?? ?? 89 45 FC 8B 45 EC 83 78 0C 02 75 1E 8B 55 FC 8B C6 66 BB D8 FF E8 ?? ?? ?? ?? 84 C0 75 0C C7 47 0C 01 00 00 00 E9 26 02 00 00 8B 45 EC 83 78 0C 01 0F 85 19 02 00 00 8B 55 FC 8B C6 66 BB D9 FF E8 ?? ?? ?? ?? 84 C0 0F 85 03 02 00 00 C7 47 0C 01 00 00 00 E9 F7 01 00 00 80 BE 70 01 00 00 00 0F 85 EA 01 00 00 8B 5F 08 8D 53 38 8B C6 E8 ?? ?? ?? ?? 89 45 FC 8B 43 0C 83 F8 02 75 13 8B 55 FC 8B C6 66 BB D4 FF E8 ?? ?? ?? ?? E9 BF 01 00 00 48 0F 85 B8 01 00 00 8B 55 FC 8B C6 66 BB D6 FF E8 ?? ?? ?? ?? E9 A5 01 00 00 8B 47 08 89 45 E8 8B 45 E8 8D 50 38 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 66 BB DA FF E8 ?? ?? ?? ?? 84 C0 0F 85 7D 01 00 00 C7 47 0C 01 00 00 00 E9 71 01 00 00 8B DA 8D 53 38 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 66 BB D7 FF E8 ?? ?? ?? ?? E9 53 01 00 00 80 BE 73 01 00 00 00 0F 85 46 01 00 00 8B C2 8D 50 10 8B C6 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 2D 01 00 00 8B 45 FC 33 D2 89 50 10 8B 55 FC 8B 86 34 01 00 00 E8 ?? ?? ?? ?? E9 12 01 00 00 8B DA 8D 53 0C 8B C6 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 F9 00 00 00 F6 43 0C 01 0F 84 EF 00 00 00 8D 45 E0 8B 53 1C E8 ?? ?? ?? ?? 8B 55 E0 8B 45 FC E8 ?? ?? ?? ?? E9 D4 00 00 00 8B DA 8D 53 0C 8B C6 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 BB 00 00 00 F6 43 0C 01 74 18 8B 45 FC 8B 40 08 E8 ?? ?? ?? ?? 8B D0 8B 4B 20 8B 43 1C E8 ?? ?? ?? ?? F6 43 0C 02 74 13 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 14 89 43 24 F6 43 0C 20 74 7E 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 18 89 43 28 EB 69 80 BE 71 01 00 00 00 74 56 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 4D D8 8D 55 F4 8B C6 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 89 45 E4 66 8B 7D E6 0F BF CF 66 8B 5D E4 0F BF D3 8B C6 E8 ?? ?? ?? ?? 89 86 64 01 00 00 8B D7 8B C3 E8 ?? ?? ?? ?? 50 33 C9 BA 05 02 00 00 8B C6 E8 ?? ?? ?? ?? EB 0A C7 86 64 01 00 00 01 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2296_0 {
	meta:
		name = "TCustomTreeView.GetDragImages"
		size = 30
		refs = "000a TCustomImageList.GetCount"
	strings:
		$1 = { 53 8B D8 8B 83 30 01 00 00 E8 ?? ?? ?? ?? 85 C0 7E 08 8B 83 30 01 00 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_2297_0 {
	meta:
		name = "TCustomTreeView.WndProc"
		size = 100
		refs = "0022 TControl.Dragging 0035 TWinControl.IsControlMouseMsg 003e TCustomTreeView.WndProc 004d TObject.Dispatch 0058 TWinControl.WndProc"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 F6 43 20 10 75 46 8B 3E 81 FF 01 02 00 00 74 08 81 FF 03 02 00 00 75 34 8B C3 E8 ?? ?? ?? ?? 84 C0 75 29 80 7B 49 01 75 23 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 75 1F A0 ?? ?? ?? ?? 0A 43 42 88 43 42 8B D6 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 01 00 00 00 }
	condition:
		$1
}

rule function_13902_0 {
	meta:
		name = "TCustomListBox.WndProc"
		size = 100
		refs = "0022 TControl.Dragging 0035 TWinControl.IsControlMouseMsg 003e TCustomListBox.WndProc 004d TObject.Dispatch 0058 TWinControl.WndProc"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 F6 43 20 10 75 46 8B 3E 81 FF 01 02 00 00 74 08 81 FF 03 02 00 00 75 34 8B C3 E8 ?? ?? ?? ?? 84 C0 75 29 80 7B 49 01 75 23 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 75 1F A0 ?? ?? ?? ?? 0A 43 42 88 43 42 8B D6 8B C3 E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 01 00 00 00 }
	condition:
		$1
}

rule function_2298_0 {
	meta:
		name = "TCustomTreeView.DoStartDrag"
		size = 136
		refs = "000a TControl.DoStartDrag 002a GetCursorPos 0037 TControl.ScreenToClient 0046 TCustomTreeView.GetNodeAt 0053 TWinControl.GetHandle 005b TreeView_CreateDragImage 006e TCustomImageList.SetHandle 007e TCustomImageList.SetDragImage"
	strings:
		$1 = { 53 56 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B B3 6C 01 00 00 33 C0 89 83 68 01 00 00 33 C0 89 83 6C 01 00 00 85 F6 75 24 54 E8 ?? ?? ?? ?? 8D 4C 24 08 8B D4 8B C3 E8 ?? ?? ?? ?? 8B 4C 24 0C 8B 54 24 08 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 74 32 8B C3 E8 ?? ?? ?? ?? 8B 56 10 E8 ?? ?? ?? ?? 85 C0 74 1F 8B 9B 30 01 00 00 8B D0 8B C3 E8 ?? ?? ?? ?? 6A 02 B9 02 00 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_2299_0 {
	meta:
		name = "TCustomTreeView.DoEndDrag"
		size = 30
		refs = "000d TControl.DoEndDrag"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 33 C0 89 83 68 01 00 00 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2300_0 {
	meta:
		name = "TCustomTreeView.CMDrag"
		size = 133
		refs = "000f TWinControl.CMDrag 002e TControl.ScreenToClient 0049 _NF__9A4 005a TCustomTreeView.GetDropTarget 0069 TCustomTreeView.SetDropTarget"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 08 8A 46 04 FE C8 74 32 FE C8 74 06 FE C8 74 52 EB 58 8B CC 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 44 24 04 50 83 7E 0C 00 0F 95 C0 50 8B 4C 24 08 8B 57 08 8B C3 E8 ?? ?? ?? ?? EB 30 8B 47 08 8B 10 FF 52 14 8B C3 E8 ?? ?? ?? ?? 89 83 68 01 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 47 08 8B 10 FF 52 18 EB 08 33 C0 89 83 68 01 00 00 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2301_0 {
	meta:
		name = "_NF__9A4"
		size = 94
		refs = "0017 TCustomTreeView.GetNodeAt 0024 TCustomTreeView.GetDropTarget 004b TTreeNode.SetDropTarget"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B FA 8B D8 8B 4D 0C 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 74 35 8B C3 E8 ?? ?? ?? ?? 3B F0 75 08 3B B3 68 01 00 00 75 22 33 C0 89 83 68 01 00 00 8B DF 8B C3 8B 10 FF 52 14 8A 55 08 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 18 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2302_0 {
	meta:
		name = "_NF__9A5"
		size = 31
	strings:
		$1 = { 53 66 83 B8 CA 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 CC 01 00 00 FF 93 C8 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2303_0 {
	meta:
		name = "_NF__9A6"
		size = 31
	strings:
		$1 = { 53 66 83 B8 D2 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 D4 01 00 00 FF 93 D0 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2304_0 {
	meta:
		name = "TCustomListView.CanEdit"
		size = 41
		altNames = "TCustomTreeView.CanChange"
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 AA 01 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 AC 01 00 00 FF 93 A8 01 00 00 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2305_0 {
	meta:
		name = "TCustomTreeView.Change"
		size = 31
	strings:
		$1 = { 53 66 83 B8 B2 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 B4 01 00 00 FF 93 B0 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2306_0 {
	meta:
		name = "TCustomTreeView.Expand"
		size = 31
	strings:
		$1 = { 53 66 83 B8 8A 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 8C 01 00 00 FF 93 88 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2307_0 {
	meta:
		name = "TCustomTreeView.CanExpand"
		size = 41
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 92 01 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 94 01 00 00 FF 93 90 01 00 00 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2308_0 {
	meta:
		name = "TCustomListView.ColClick"
		size = 31
		altNames = "TCustomTreeView.Collapse"
	strings:
		$1 = { 53 66 83 B8 9A 01 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 9C 01 00 00 FF 93 98 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2309_0 {
	meta:
		name = "TCustomTreeView.CanCollapse"
		size = 41
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 A2 01 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 A4 01 00 00 FF 93 A0 01 00 00 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2310_0 {
	meta:
		name = "TCustomTreeView.CanEdit"
		size = 41
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 7A 01 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 7C 01 00 00 FF 93 78 01 00 00 8A 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_2311_0 {
	meta:
		name = "TCustomTreeView.Edit"
		size = 133
		refs = "0010 TCustomTreeView.Edit 0027 @LStrFromPChar 0030 _NF__98E 005e TTreeNode.SetText 0073 @LStrClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 7E 10 85 FF 74 41 8D 45 FC 8B D7 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F0 66 83 BB 82 01 00 00 00 74 14 8D 45 FC 50 8B CE 8B D3 8B 83 84 01 00 00 FF 93 80 01 00 00 85 F6 74 0A 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2312_0 {
	meta:
		name = "TCustomTreeView.CreateNode"
		size = 19
		refs = "0009 _DV_TTreeNode 000e TTreeNode.Create"
	strings:
		$1 = { 8B 88 34 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2313_0 {
	meta:
		name = "_NF__9C1"
		size = 40
		refs = "000c TWinControl.HandleAllocated 0017 TWinControl.GetHandle 0020 TreeView_SetImageList"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? 8B CF 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2579_0 {
	meta:
		name = "_NF__C6E"
		size = 40
		refs = "000c TWinControl.HandleAllocated 0017 TWinControl.GetHandle 0020 ListView_SetImageList"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? 8B CF 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2314_0 {
	meta:
		name = "_NF__9C2"
		size = 70
		refs = "0009 TWinControl.HandleAllocated 0014 TCustomImageList.GetHandle 0027 _NF__9C1"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 32 8B C6 E8 ?? ?? ?? ?? 3B B3 20 01 00 00 75 0D 33 C9 8B D0 8B C3 E8 ?? ?? ?? ?? EB 16 3B B3 24 01 00 00 75 0E B9 02 00 00 00 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2315_0 {
	meta:
		name = "TCustomTreeView.Notification"
		size = 63
		refs = "0010 TControl.Notification 0026 TCustomTreeView.SetImages 0037 TCustomTreeView.SetStateImages"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 8B F8 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 22 3B B7 20 01 00 00 75 09 33 D2 8B C7 E8 ?? ?? ?? ?? 3B B7 24 01 00 00 75 09 33 D2 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2316_0 {
	meta:
		name = "TCustomTreeView.SetImages"
		size = 89
		refs = "0017 TCustomImageList.UnRegisterChanges 002e TCustomImageList.RegisterChanges 0039 TCustomImageList.GetHandle 0044 _NF__9C1"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 20 01 00 00 85 C0 74 0B 8B 93 28 01 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 20 01 00 00 85 C0 74 24 8B 93 28 01 00 00 E8 ?? ?? ?? ?? 8B 83 20 01 00 00 E8 ?? ?? ?? ?? 8B D0 33 C9 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 33 C9 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2317_0 {
	meta:
		name = "TCustomTreeView.SetStateImages"
		size = 95
		refs = "0017 TCustomImageList.UnRegisterChanges 002e TCustomImageList.RegisterChanges 0039 TCustomImageList.GetHandle 0047 _NF__9C1"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 24 01 00 00 85 C0 74 0B 8B 93 2C 01 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 24 01 00 00 85 C0 74 27 8B 93 2C 01 00 00 E8 ?? ?? ?? ?? 8B 83 24 01 00 00 E8 ?? ?? ?? ?? 8B D0 B9 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 B9 02 00 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2319_0 {
	meta:
		name = "TCustomTreeView.LoadFromStream"
		size = 85
		refs = "0010 _NV__91C 0015 _NF__91E 0020 TCustomTreeView.LoadFromStream 0030 _NF__929 0045 TObject.Free 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 8B 88 34 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2321_0 {
	meta:
		name = "TCustomTreeView.SaveToStream"
		size = 85
		refs = "0010 _NV__91C 0015 _NF__91E 0020 TCustomTreeView.SaveToStream 0030 _NF__92A 0045 TObject.Free 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 8B 88 34 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2322_0 {
	meta:
		name = "TCustomTreeView.WMRButtonDown"
		size = 183
		refs = "001b TCustomTreeView.WMRButtonDown 0037 TControl.WMRButtonDown 004c GetCursorPos 005a TControl.ScreenToClient 0062 PointToSmallPoint 0072 MakeLong 0082 TControl.Perform 00ac @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 56 8B F2 89 45 FC 8B 45 FC 33 D2 89 90 64 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 71 01 00 00 00 75 57 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 B8 64 01 00 00 00 74 4B 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 4D E8 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 89 45 F0 66 8B 55 F2 66 8B 45 F0 E8 ?? ?? ?? ?? 50 33 C9 BA 05 02 00 00 8B 45 FC E8 ?? ?? ?? ?? EB 0A 8B D6 8B 45 FC 8B 08 FF 51 F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 64 01 00 00 C3 E9 ?? ?? ?? ?? EB ED 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_2323_0 {
	meta:
		name = "_NF__9DC"
		size = 73
		refs = "0029 KeysToShiftState 0040 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FE 88 55 FF 8B F0 8B 45 08 8B 40 FC F6 40 41 10 75 2A 0F BF 46 08 50 0F BF 46 0A 50 66 8B 46 04 E8 ?? ?? ?? ?? 8B C8 0A 4D FE 8B 45 08 8B 40 FC 8A 55 FF 66 BB E8 FF E8 ?? ?? ?? ?? 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2324_0 {
	meta:
		name = "TCustomTreeView.WMRButtonUp"
		size = 60
		refs = "001b TCustomTreeView.WMRButtonUp 0022 _NF__9DC 002d TControl.WMRButtonUp"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 80 B8 71 01 00 00 00 74 11 55 8B C3 8A 0D ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 59 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5B 59 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_2325_0 {
	meta:
		name = "TCustomTreeView.WMLButtonDown"
		size = 242
		refs = "0025 TCustomTreeView.WMLButtonDown 0035 TControl.WMLButtonDown 005f GetCursorPos 006d TControl.ScreenToClient 0075 PointToSmallPoint 0085 MakeLong 0095 TControl.Perform 00a7 TCustomTreeView.GetNodeAt 00b6 TTreeNode.SetFocused 00bf TTreeNode.SetSelected 00c9 TControl.BeginDrag 00e7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 8B DA 89 45 FC 8B 45 FC C6 80 60 01 00 00 00 8B 45 FC 33 D2 89 90 6C 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 78 49 01 0F 85 87 00 00 00 8B 45 FC 8B 10 FF 52 78 8B 45 FC 80 B8 60 01 00 00 00 75 41 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 4D E8 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 89 45 F0 66 8B 55 F2 66 8B 45 F0 E8 ?? ?? ?? ?? 50 33 C9 BA 02 02 00 00 8B 45 FC E8 ?? ?? ?? ?? EB 32 0F BF 4B 0A 0F BF 53 08 8B 45 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 1C B2 01 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 6C 01 00 00 C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2326_0 {
	meta:
		name = "TCustomTreeView.WMNotify"
		size = 259
		refs = "001d GetCursorPos 002a TControl.ScreenToClient 0047 TCustomTreeView.GetNodeAt 0069 @WStrFromLStr 0079 @WStrLen 008b @WStrSetLength 0096 @WStrToPWChar 00a8 @FillChar 00c6 Move 00e5 SetWindowPos 00f7 TWinControl.WMNotify"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F2 8B D8 8B 46 08 81 78 08 EE FD FF FF 0F 85 D7 00 00 00 54 E8 ?? ?? ?? ?? 8D 4C 24 08 8B D4 8B C3 E8 ?? ?? ?? ?? 8B 44 24 08 89 04 24 8B 44 24 0C 89 44 24 04 8B 4C 24 04 8B 14 24 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 0F 84 A6 00 00 00 83 7F 08 00 0F 84 9C 00 00 00 8D 83 74 01 00 00 8B 57 08 E8 ?? ?? ?? ?? BF 50 00 00 00 8B 83 74 01 00 00 E8 ?? ?? ?? ?? 3B F8 7F 0E 8B D7 4A 8D 83 74 01 00 00 E8 ?? ?? ?? ?? 8B 83 74 01 00 00 E8 ?? ?? ?? ?? 8B 6E 08 89 45 0C 8D 45 10 33 C9 8B D7 E8 ?? ?? ?? ?? 8B 83 74 01 00 00 E8 ?? ?? ?? ?? 8B C8 8B 46 08 8D 50 10 8B 83 74 01 00 00 E8 ?? ?? ?? ?? 8B 46 08 33 D2 89 90 B0 00 00 00 6A 13 6A 00 6A 00 6A 00 6A 00 6A 00 8B 00 50 E8 ?? ?? ?? ?? C7 46 0C 01 00 00 00 EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2327_0 {
	meta:
		name = "TTrackBar.Create"
		size = 168
		refs = "000a @ClassCreate 0017 TWinControl.Create 0023 TControl.SetWidth 002f TControl.SetHeight 0038 TWinControl.SetTabStop 0083 TTrackBar.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 96 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 2D 00 00 00 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 33 C0 89 86 24 01 00 00 C7 86 28 01 00 00 0A 00 00 00 C7 86 1C 01 00 00 01 00 00 00 C7 86 20 01 00 00 02 00 00 00 C7 86 2C 01 00 00 01 00 00 00 C6 86 19 01 00 00 00 C6 86 1A 01 00 00 01 C6 86 18 01 00 00 00 66 A1 ?? ?? ?? ?? F7 D0 66 23 46 40 66 89 46 40 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 80 00 00 00 }
	condition:
		$1
}

rule function_2328_0 {
	meta:
		name = "TTrackBar.CreateParams"
		size = 128
		refs = "000c InitCommonControl 0015 TWinControl.CreateParams 001a TTrackBar.CreateParams 0023 TWinControl.CreateSubClass 0035 _NV__9EA 0044 _NV__9EB 0053 _NV__9EC"
	strings:
		$1 = { 53 56 8B F2 8B D8 B8 04 00 00 00 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 46 04 33 D2 8A 93 18 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 1A 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 19 01 00 00 0B 04 95 ?? ?? ?? ?? 83 C8 20 89 46 04 8B 46 24 83 E0 FC 83 C8 08 89 46 24 5E 5B C3 6D 73 63 74 6C 73 5F 74 72 61 63 6B 62 61 72 33 32 00 00 00 }
	condition:
		$1
}

rule function_2329_0 {
	meta:
		name = "TTrackBar.CreateWnd"
		size = 196
		refs = "0006 TWinControl.CreateWnd 000d TWinControl.HandleAllocated 002a TWinControl.GetHandle 0030 SendMessage 0088 _NF__A19"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 A9 00 00 00 8B 83 1C 01 00 00 50 6A 00 68 17 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 83 20 01 00 00 50 6A 00 68 15 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 83 24 01 00 00 50 6A 00 68 07 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 83 28 01 00 00 50 6A 00 68 08 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 83 30 01 00 00 50 6A 01 68 05 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 01 8B 83 2C 01 00 00 50 68 14 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2331_0 {
	meta:
		name = "TTrackBar.CNHScroll"
		size = 75
		refs = "001b TWinControl.GetHandle 0021 SendMessage"
		altNames = "TTrackBar.CNVScroll"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 F0 6A 00 6A 00 68 00 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 83 30 01 00 00 66 83 BB 3E 01 00 00 00 74 0E 8B D3 8B 83 40 01 00 00 FF 93 3C 01 00 00 33 C0 89 46 0C 5E 5B C3 }
	condition:
		$1
}

rule function_2333_0 {
	meta:
		name = "TTrackBar.SetOrientation"
		size = 76
		refs = "0013 TTrackBar.SetOrientation 003c TWinControl.RecreateWnd"
	strings:
		$1 = { 53 56 8B D8 3A 93 18 01 00 00 74 34 88 93 18 01 00 00 A0 ?? ?? ?? ?? 22 43 20 8A 15 ?? ?? ?? ?? 3A D0 75 15 8B 43 3C 50 8B 43 38 50 8B 4B 34 8B 53 30 8B C3 8B 30 FF 56 4C 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 00 41 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_2334_0 {
	meta:
		name = "_NF__9FD"
		size = 318
		refs = "001e _NF__9FD 0036 TObject.ClassName 0054 SPropertyOutOfRange 0059 LoadResString 0066 _Dn_EInvalidOperation 006b Exception.CreateFmt 0070 @RaiseExcept 0093 TWinControl.HandleAllocated 00a6 TWinControl.GetHandle 00ac SendMessage 0129 @LStrClr 012f @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 56 57 33 DB 89 9D F4 FE FF FF 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B 7D 08 7E 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B FE 7E 02 8B F7 3B 75 08 7E 03 8B 75 08 3B BB 24 01 00 00 74 26 89 BB 24 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 15 57 6A 01 68 07 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 83 28 01 00 00 3B 45 08 74 2C 8B 45 08 89 83 28 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 18 8B 45 08 50 6A 01 68 08 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 3B B3 30 01 00 00 74 26 89 B3 30 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 15 56 6A 01 68 05 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2335_0 {
	meta:
		name = "TTrackBar.SetPosition"
		size = 19
		refs = "000e _NF__9FD"
	strings:
		$1 = { 8B 88 28 01 00 00 51 8B 88 24 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2336_0 {
	meta:
		name = "TTrackBar.SetMin"
		size = 21
		refs = "0010 _NF__9FD"
	strings:
		$1 = { 8B 88 28 01 00 00 51 8B CA 8B 90 30 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2337_0 {
	meta:
		name = "TTrackBar.SetMax"
		size = 19
		refs = "000e _NF__9FD"
	strings:
		$1 = { 52 8B 88 24 01 00 00 8B 90 30 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2338_0 {
	meta:
		name = "TTrackBar.SetFrequency"
		size = 57
		refs = "0014 TWinControl.HandleAllocated 002d TWinControl.GetHandle 0033 SendMessage"
	strings:
		$1 = { 53 8B D8 3B 93 2C 01 00 00 74 2C 89 93 2C 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 6A 01 8B 83 2C 01 00 00 50 68 14 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2339_0 {
	meta:
		name = "TTrackBar.SetTick"
		size = 41
		refs = "0009 TWinControl.HandleAllocated 001c TWinControl.GetHandle 0022 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 15 56 6A 00 68 04 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2340_0 {
	meta:
		name = "TCustomListView.SetReadOnly"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
		altNames = "TCustomStaticText.SetBorderStyle TTrackBar.SetTickStyle"
	strings:
		$1 = { 3A 90 1A 01 00 00 74 0B 88 90 1A 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2341_0 {
	meta:
		name = "TTrackBar.SetTickMarks"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 19 01 00 00 74 0B 88 90 19 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2342_0 {
	meta:
		name = "TTrackBar.SetLineSize"
		size = 57
		refs = "0014 TWinControl.HandleAllocated 002d TWinControl.GetHandle 0033 SendMessage"
	strings:
		$1 = { 53 8B D8 3B 93 1C 01 00 00 74 2C 89 93 1C 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 8B 83 1C 01 00 00 50 6A 00 68 17 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2343_0 {
	meta:
		name = "TTrackBar.SetPageSize"
		size = 57
		refs = "0014 TWinControl.HandleAllocated 002d TWinControl.GetHandle 0033 SendMessage"
	strings:
		$1 = { 53 8B D8 3B 93 20 01 00 00 74 2C 89 93 20 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 8B 83 20 01 00 00 50 6A 00 68 15 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2344_0 {
	meta:
		name = "_NF__A19"
		size = 98
		refs = "0006 TWinControl.HandleAllocated 002c TWinControl.GetHandle 0032 SendMessage 0047 MakeLong"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 52 83 BB 34 01 00 00 00 75 21 83 BB 38 01 00 00 00 75 18 6A 00 6A 01 68 13 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 28 66 8B 93 38 01 00 00 66 8B 83 34 01 00 00 E8 ?? ?? ?? ?? 50 6A 01 68 0A 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2345_0 {
	meta:
		name = "TTrackBar.SetSelStart"
		size = 20
		refs = "000f _NF__A19"
	strings:
		$1 = { 3B 90 34 01 00 00 74 0B 89 90 34 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2346_0 {
	meta:
		name = "TTrackBar.SetSelEnd"
		size = 20
		refs = "000f _NF__A19"
	strings:
		$1 = { 3B 90 38 01 00 00 74 0B 89 90 38 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2347_0 {
	meta:
		name = "_NF__A20"
		size = 117
		refs = "000f _NF__A20 0037 SOutOfRange 003c LoadResString 0046 _Dn_Exception 004b Exception.CreateFmt 0050 @RaiseExcept 0065 @LStrClr 006b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 33 C0 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F0 C6 45 F4 00 C7 45 F8 FF FF 00 00 C6 45 FC 00 8D 45 F0 50 6A 01 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_2348_0 {
	meta:
		name = "TProgressBar.Create"
		size = 124
		refs = "000b @ClassCreate 001b InitCommonControl 002c TWinControl.Create 0038 TControl.SetWidth 003f GetSystemMetrics 0048 TControl.SetHeight"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 B8 20 00 00 00 E8 ?? ?? ?? ?? 88 87 28 01 00 00 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? BA 96 00 00 00 8B C7 E8 ?? ?? ?? ?? 6A 14 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 33 C0 89 87 18 01 00 00 C7 87 1C 01 00 00 64 00 00 00 C7 87 20 01 00 00 0A 00 00 00 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2349_0 {
	meta:
		name = "TProgressBar.CreateParams"
		size = 68
		refs = "0010 InitCommonControls 0019 TWinControl.CreateParams 001e TProgressBar.CreateParams 0027 TWinControl.CreateSubClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 BB 28 01 00 00 00 75 05 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 00 00 6D 73 63 74 6C 73 5F 70 72 6F 67 72 65 73 73 33 32 00 00 00 }
	condition:
		$1
}

rule function_2350_0 {
	meta:
		name = "TProgressBar.CreateWnd"
		size = 135
		refs = "0006 TWinControl.CreateWnd 0029 TWinControl.GetHandle 002f SendMessage 0044 MakeLong 0081 TProgressBar.SetPosition"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 28 01 00 00 00 74 22 8B 83 1C 01 00 00 50 8B 83 18 01 00 00 50 68 06 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 28 66 8B 93 1C 01 00 00 66 8B 83 18 01 00 00 E8 ?? ?? ?? ?? 50 6A 00 68 01 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 00 8B 83 20 01 00 00 50 68 04 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 93 24 01 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2351_0 {
	meta:
		name = "TProgressBar.GetMin"
		size = 55
		refs = "0006 TWinControl.HandleAllocated 0023 TWinControl.GetHandle 0029 SendMessage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 21 80 BB 28 01 00 00 00 74 18 6A 00 6A 01 68 07 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 8B 83 18 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2352_0 {
	meta:
		name = "TProgressBar.GetMax"
		size = 55
		refs = "0006 TWinControl.HandleAllocated 0023 TWinControl.GetHandle 0029 SendMessage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 21 80 BB 28 01 00 00 00 74 18 6A 00 6A 00 68 07 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 8B 83 1C 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2353_0 {
	meta:
		name = "TProgressBar.GetPosition"
		size = 79
		refs = "0006 TWinControl.HandleAllocated 0023 TWinControl.GetHandle 0029 SendMessage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 39 80 BB 28 01 00 00 00 74 18 6A 00 6A 00 68 08 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 1E 6A 00 6A 00 68 03 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 8B 83 24 01 00 00 5B C3 }
	condition:
		$1
}

rule function_2354_0 {
	meta:
		name = "_NF__A30"
		size = 321
		refs = "001e _NF__A30 0035 TObject.ClassName 0053 SPropertyOutOfRange 0058 LoadResString 0065 _Dn_EInvalidOperation 006a Exception.CreateFmt 006f @RaiseExcept 0095 _NF__A20 00ac TWinControl.HandleAllocated 00c7 TWinControl.GetHandle 00cd SendMessage 00d8 MakeLong 012e @LStrClr 0134 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FE FF FF 53 56 57 33 DB 89 9D F4 FE FF FF 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B F7 7E 47 8D 95 F8 FE FF FF 8B 03 E8 ?? ?? ?? ?? 8D 85 F8 FE FF FF 89 45 F8 C6 45 FC 04 8D 45 F8 50 6A 00 8D 95 F4 FE FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D F4 FE FF FF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 BB 28 01 00 00 00 75 1D 85 F6 7C 14 81 FE FF FF 00 00 7F 0C 85 FF 7C 08 81 FF FF FF 00 00 7E 05 E8 ?? ?? ?? ?? 3B B3 18 01 00 00 75 08 3B BB 1C 01 00 00 74 71 8B C3 E8 ?? ?? ?? ?? 84 C0 74 5A 80 BB 28 01 00 00 00 74 16 57 56 68 06 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 1E 8B D7 8B C6 E8 ?? ?? ?? ?? 50 6A 00 68 01 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 3B B3 18 01 00 00 7D 15 6A 00 56 68 02 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 B3 18 01 00 00 89 BB 1C 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 F4 FE FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2355_0 {
	meta:
		name = "TProgressBar.SetMin"
		size = 12
		refs = "0007 _NF__A30"
	strings:
		$1 = { 8B 88 1C 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2356_0 {
	meta:
		name = "TProgressBar.SetMax"
		size = 14
		refs = "0009 _NF__A30"
	strings:
		$1 = { 8B CA 8B 90 18 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_2357_0 {
	meta:
		name = "TProgressBar.SetPosition"
		size = 76
		refs = "001c _NF__A20 0023 TWinControl.HandleAllocated 0036 TWinControl.GetHandle 003c SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 BB 28 01 00 00 00 75 11 85 F6 7C 08 81 FE FF FF 00 00 7E 05 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 18 6A 00 56 68 02 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 89 B3 24 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2358_0 {
	meta:
		name = "TProgressBar.SetStep"
		size = 57
		refs = "0014 TWinControl.HandleAllocated 002d TWinControl.GetHandle 0033 SendMessage"
	strings:
		$1 = { 53 8B D8 3B 93 20 01 00 00 74 2C 89 93 20 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 6A 00 8B 83 20 01 00 00 50 68 04 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2359_0 {
	meta:
		name = "TProgressBar.StepIt"
		size = 38
		refs = "0006 TWinControl.HandleAllocated 001a TWinControl.GetHandle 0020 SendMessage"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 16 6A 00 6A 00 68 05 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2360_0 {
	meta:
		name = "TProgressBar.StepBy"
		size = 41
		refs = "0009 TWinControl.HandleAllocated 001c TWinControl.GetHandle 0022 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 15 6A 00 56 68 03 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2361_0 {
	meta:
		name = "TTextAttributes.Create"
		size = 65
		refs = "000e @ClassCreate 001d TObject.Create"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 04 8A 45 08 88 47 08 84 DB 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2362_0 {
	meta:
		name = "TTextAttributes.InitFormat"
		size = 25
		refs = "000d @FillChar"
	strings:
		$1 = { 53 8B DA 8B C3 33 C9 BA 3C 00 00 00 E8 ?? ?? ?? ?? C7 03 3C 00 00 00 5B C3 }
	condition:
		$1
}

rule function_2363_0 {
	meta:
		name = "TTextAttributes.GetConsistentAttributes"
		size = 184
		refs = "0007 TTextAttributes.GetConsistentAttributes 0012 TWinControl.HandleAllocated 002f TTextAttributes.InitFormat 004c TWinControl.GetHandle 0052 SendMessage"
	strings:
		$1 = { 53 83 C4 C0 8B D8 A0 ?? ?? ?? ?? 88 04 24 8B 43 04 E8 ?? ?? ?? ?? 84 C0 0F 84 8D 00 00 00 80 7B 08 00 0F 85 83 00 00 00 8D 54 24 04 8B C3 E8 ?? ?? ?? ?? 8D 44 24 04 50 80 7B 08 00 0F 94 C0 83 E0 7F 50 68 3A 04 00 00 8B 43 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 5C 24 08 F6 C3 01 74 04 80 0C 24 01 F7 C3 00 00 00 40 74 04 80 0C 24 02 F7 C3 00 00 00 20 74 04 80 0C 24 04 F6 C3 02 74 04 80 0C 24 08 F7 C3 00 00 00 80 74 04 80 0C 24 10 F6 C3 08 74 04 80 0C 24 20 F6 C3 04 74 04 80 0C 24 40 F6 C3 10 74 04 80 0C 24 80 8A 04 24 83 C4 40 5B C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_2364_0 {
	meta:
		name = "_NF__A4C"
		size = 61
		refs = "000b TTextAttributes.InitFormat 0013 TWinControl.HandleAllocated 0030 TWinControl.GetHandle 0036 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 1F 56 80 7B 08 00 0F 94 C0 83 E0 7F 50 68 3A 04 00 00 8B 43 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2365_0 {
	meta:
		name = "_NF__A4D"
		size = 59
		refs = "001a TWinControl.HandleAllocated 002d TWinControl.GetHandle 0033 SendMessage"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 80 7B 08 00 75 07 BE 01 00 00 00 EB 02 33 F6 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 15 57 56 68 44 04 00 00 8B 43 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2366_0 {
	meta:
		name = "TTextAttributes.GetCharset"
		size = 18
		refs = "0006 _NF__A4C"
	strings:
		$1 = { 83 C4 C4 8B D4 E8 ?? ?? ?? ?? 8A 44 24 18 83 C4 3C C3 }
	condition:
		$1
}

rule function_2367_0 {
	meta:
		name = "TTextAttributes.SetCharset"
		size = 45
		refs = "000e TTextAttributes.InitFormat 0023 _NF__A4D"
	strings:
		$1 = { 53 56 83 C4 C4 8B DA 8B F0 8B D4 8B C6 E8 ?? ?? ?? ?? C7 44 24 04 00 00 00 08 88 5C 24 18 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 3C 5E 5B C3 }
	condition:
		$1
}

rule function_2368_0 {
	meta:
		name = "TTextAttributes.GetProtected"
		size = 27
		refs = "0006 _NF__A4C"
	strings:
		$1 = { 83 C4 C4 8B D4 E8 ?? ?? ?? ?? F6 44 24 08 10 74 04 B0 01 EB 02 33 C0 83 C4 3C C3 }
	condition:
		$1
}

rule function_2369_0 {
	meta:
		name = "TTextAttributes.SetProtected"
		size = 53
		refs = "000e TTextAttributes.InitFormat 002b _NF__A4D"
	strings:
		$1 = { 53 56 83 C4 C4 8B DA 8B F0 8B D4 8B C6 E8 ?? ?? ?? ?? C7 44 24 04 10 00 00 00 84 DB 74 08 C7 44 24 08 10 00 00 00 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 3C 5E 5B C3 }
	condition:
		$1
}

rule function_2370_0 {
	meta:
		name = "TTextAttributes.GetColor"
		size = 32
		refs = "0006 _NF__A4C"
	strings:
		$1 = { 83 C4 C4 8B D4 E8 ?? ?? ?? ?? F6 44 24 0B 40 74 07 B8 08 00 00 80 EB 04 8B 44 24 14 83 C4 3C C3 }
	condition:
		$1
}

rule function_2371_0 {
	meta:
		name = "TTextAttributes.SetColor"
		size = 70
		refs = "000e TTextAttributes.InitFormat 002f ColorToRGB 003c _NF__A4D"
	strings:
		$1 = { 53 56 83 C4 C4 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? C7 44 24 04 00 00 00 40 81 FE 08 00 00 80 75 0A C7 44 24 08 00 00 00 40 EB 0B 8B C6 E8 ?? ?? ?? ?? 89 44 24 14 8B D4 8B C3 E8 ?? ?? ?? ?? 83 C4 3C 5E 5B C3 }
	condition:
		$1
}

rule function_2372_0 {
	meta:
		name = "TTextAttributes.GetName"
		size = 34
		refs = "0009 _NF__A4C 0019 @LStrFromArray"
	strings:
		$1 = { 53 83 C4 C4 8B DA 8B D4 E8 ?? ?? ?? ?? 8B C3 8D 54 24 1A B9 20 00 00 00 E8 ?? ?? ?? ?? 83 C4 3C 5B C3 }
	condition:
		$1
}

rule function_2373_0 {
	meta:
		name = "TTextAttributes.SetName"
		size = 111
		refs = "0010 @LStrAddRef 0018 TTextAttributes.SetName 0028 TTextAttributes.InitFormat 003f StrPLCopy 0049 _NF__A4D 005e @LStrClr 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 C0 8B C3 E8 ?? ?? ?? ?? C7 45 C4 00 00 00 20 8D 45 DA B9 20 00 00 00 8B 55 FC E8 ?? ?? ?? ?? 8D 55 C0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2374_0 {
	meta:
		name = "TTextAttributes.GetStyle"
		size = 80
		refs = "0007 TTextAttributes.GetStyle 000e _NF__A4C"
	strings:
		$1 = { 53 56 83 C4 C4 8A 1D ?? ?? ?? ?? 8B D4 E8 ?? ?? ?? ?? 8B 74 24 08 F7 C6 01 00 00 00 74 03 80 CB 01 F7 C6 02 00 00 00 74 03 80 CB 02 F7 C6 04 00 00 00 74 03 80 CB 04 F7 C6 08 00 00 00 74 03 80 CB 08 8B C3 83 C4 3C 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_2375_0 {
	meta:
		name = "TTextAttributes.SetStyle"
		size = 88
		refs = "0010 TTextAttributes.InitFormat 004f _NF__A4D"
	strings:
		$1 = { 53 83 C4 C0 88 14 24 8B D8 8D 54 24 04 8B C3 E8 ?? ?? ?? ?? C7 44 24 08 0F 00 00 00 F6 04 24 01 74 05 83 4C 24 0C 01 F6 04 24 02 74 05 83 4C 24 0C 02 F6 04 24 04 74 05 83 4C 24 0C 04 F6 04 24 08 74 05 83 4C 24 0C 08 8D 54 24 04 8B C3 E8 ?? ?? ?? ?? 83 C4 40 5B C3 }
	condition:
		$1
}

rule function_2376_0 {
	meta:
		name = "TTextAttributes.GetSize"
		size = 26
		refs = "0006 _NF__A4C"
	strings:
		$1 = { 83 C4 C4 8B D4 E8 ?? ?? ?? ?? 8B 44 24 0C B9 14 00 00 00 99 F7 F9 83 C4 3C C3 }
	condition:
		$1
}

rule function_2377_0 {
	meta:
		name = "TTextAttributes.SetSize"
		size = 53
		refs = "000e TTextAttributes.InitFormat 002b _NF__A4D"
	strings:
		$1 = { 53 56 83 C4 C4 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? C7 44 24 04 00 00 00 80 8B C6 C1 E0 02 8D 04 80 89 44 24 0C 8B D4 8B C3 E8 ?? ?? ?? ?? 83 C4 3C 5E 5B C3 }
	condition:
		$1
}

rule function_2378_0 {
	meta:
		name = "TTextAttributes.GetHeight"
		size = 30
		refs = "0012 TTextAttributes.GetSize 0018 MulDiv"
	strings:
		$1 = { 53 8B D8 6A 48 8B 43 04 8B 80 50 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2379_0 {
	meta:
		name = "TTextAttributes.SetHeight"
		size = 36
		refs = "0014 MulDiv 001d TTextAttributes.SetSize"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 8B 80 50 01 00 00 50 6A 48 56 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2380_0 {
	meta:
		name = "TTextAttributes.GetPitch"
		size = 46
		refs = "0006 _NF__A4C"
	strings:
		$1 = { 83 C4 C4 8B D4 E8 ?? ?? ?? ?? 8A 44 24 19 24 03 2C 01 72 08 74 0E FE C8 74 06 EB 0C 33 C0 EB 0A B0 01 EB 06 B0 02 EB 02 33 C0 83 C4 3C C3 }
	condition:
		$1
}

rule function_2381_0 {
	meta:
		name = "TTextAttributes.SetPitch"
		size = 62
		refs = "000e TTextAttributes.InitFormat 0034 _NF__A4D"
	strings:
		$1 = { 53 56 83 C4 C4 8B DA 8B F0 8B D4 8B C6 E8 ?? ?? ?? ?? FE CB 74 06 FE CB 74 09 EB 0E C6 44 24 19 02 EB 0C C6 44 24 19 01 EB 05 C6 44 24 19 00 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 3C 5E 5B C3 }
	condition:
		$1
}

rule function_2382_0 {
	meta:
		name = "TTextAttributes.Assign"
		size = 290
		refs = "0010 TTextAttributes.Assign 001e _Dn_TFont 0023 @IsClass 0033 TTextAttributes.SetColor 003d TFont.GetName 0047 TTextAttributes.SetName 004e TFont.GetCharset 0057 TTextAttributes.SetCharset 005e TFont.GetStyle 0067 TTextAttributes.SetStyle 006e TFont.GetSize 0077 TTextAttributes.SetSize 007e TFont.GetPitch 0087 TTextAttributes.SetPitch 0091 _DV_TTextAttributes 00a3 TTextAttributes.GetColor 00b6 TTextAttributes.GetName 00c7 TTextAttributes.GetCharset 00d7 TTextAttributes.GetStyle 00e7 TTextAttributes.GetPitch 00fb TPersistent.Assign 0110 @LStrClr 0116 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 62 8B FB 8B 57 14 8B C6 E8 ?? ?? ?? ?? 8D 55 FC 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? EB 72 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 58 8B FB 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8D 55 FC 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2383_0 {
	meta:
		name = "TTextAttributes.AssignTo"
		size = 296
		refs = "0010 TTextAttributes.AssignTo 001e _Dn_TFont 0023 @IsClass 002e TTextAttributes.GetColor 0039 TFont.SetColor 0043 TTextAttributes.GetName 004d TFont.SetName 0054 TTextAttributes.GetCharset 005d TFont.SetCharset 0064 TTextAttributes.GetStyle 006d TFont.SetStyle 0074 TTextAttributes.GetSize 007d TFont.SetSize 0084 TTextAttributes.GetPitch 008d TFont.SetPitch 0097 _DV_TTextAttributes 00b2 TTextAttributes.SetColor 00c6 TTextAttributes.SetName 00d6 TTextAttributes.SetCharset 00e6 TTextAttributes.SetStyle 00f6 TTextAttributes.SetPitch 0101 TPersistent.AssignTo 0116 @LStrClr 011c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 68 8B C6 E8 ?? ?? ?? ?? 8B D0 8B FB 8B C7 E8 ?? ?? ?? ?? 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? EB 72 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 58 8B C6 E8 ?? ?? ?? ?? 8B D0 8B FB 8B C7 E8 ?? ?? ?? ?? 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? EB 09 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2385_0 {
	meta:
		name = "_NF__A80"
		size = 25
		refs = "000d @FillChar"
	strings:
		$1 = { 53 8B DA 8B C3 33 C9 BA 9C 00 00 00 E8 ?? ?? ?? ?? C7 03 9C 00 00 00 5B C3 }
	condition:
		$1
}

rule function_2386_0 {
	meta:
		name = "_NF__A81"
		size = 52
		refs = "000b _NF__A80 0013 TWinControl.HandleAllocated 0027 TWinControl.GetHandle 002d SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 16 56 6A 00 68 3D 04 00 00 8B 43 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2387_0 {
	meta:
		name = "_NF__A82"
		size = 43
		refs = "000a TWinControl.HandleAllocated 001e TWinControl.GetHandle 0024 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 04 E8 ?? ?? ?? ?? 84 C0 74 16 56 6A 00 68 47 04 00 00 8B 43 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2388_0 {
	meta:
		name = "TParaAttributes.GetAlignment"
		size = 26
		refs = "0009 _NF__A81"
	strings:
		$1 = { 81 C4 64 FF FF FF 8B D4 E8 ?? ?? ?? ?? 66 8B 44 24 18 48 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule function_2389_0 {
	meta:
		name = "TParaAttributes.SetAlignment"
		size = 57
		refs = "0011 _NF__A80 002c _NF__A82"
	strings:
		$1 = { 53 56 81 C4 64 FF FF FF 8B DA 8B F0 8B D4 8B C6 E8 ?? ?? ?? ?? C7 44 24 04 08 00 00 00 33 C0 8A C3 40 66 89 44 24 18 8B D4 8B C6 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2390_0 {
	meta:
		name = "TParaAttributes.GetNumbering"
		size = 24
		refs = "0009 _NF__A81"
	strings:
		$1 = { 81 C4 64 FF FF FF 8B D4 E8 ?? ?? ?? ?? 8A 44 24 08 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule function_2391_0 {
	meta:
		name = "TParaAttributes.SetNumbering"
		size = 99
		refs = "0017 TParaAttributes.GetLeftIndent 0028 TParaAttributes.SetLeftIndent 003c _NF__A80 0056 _NF__A82"
	strings:
		$1 = { 53 56 81 C4 64 FF FF FF 8B DA 8B F0 8B C3 2C 01 72 1C 75 23 8B C6 E8 ?? ?? ?? ?? 83 F8 0A 7D 17 BA 0A 00 00 00 8B C6 E8 ?? ?? ?? ?? EB 09 33 D2 8B C6 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? C7 44 24 04 20 00 00 00 33 C0 8A C3 66 89 44 24 08 8B D4 8B C6 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2392_0 {
	meta:
		name = "TParaAttributes.GetFirstIndent"
		size = 32
		refs = "0009 _NF__A81"
	strings:
		$1 = { 81 C4 64 FF FF FF 8B D4 E8 ?? ?? ?? ?? 8B 44 24 0C B9 14 00 00 00 99 F7 F9 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule function_2393_0 {
	meta:
		name = "TParaAttributes.SetFirstIndent"
		size = 59
		refs = "0011 _NF__A80 002e _NF__A82"
	strings:
		$1 = { 53 56 81 C4 64 FF FF FF 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? C7 44 24 04 01 00 00 00 8B C6 C1 E0 02 8D 04 80 89 44 24 0C 8B D4 8B C3 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2394_0 {
	meta:
		name = "TParaAttributes.GetLeftIndent"
		size = 32
		refs = "0009 _NF__A81"
	strings:
		$1 = { 81 C4 64 FF FF FF 8B D4 E8 ?? ?? ?? ?? 8B 44 24 14 B9 14 00 00 00 99 F7 F9 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule function_2395_0 {
	meta:
		name = "TParaAttributes.SetLeftIndent"
		size = 59
		refs = "0011 _NF__A80 002e _NF__A82"
	strings:
		$1 = { 53 56 81 C4 64 FF FF FF 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? C7 44 24 04 04 00 00 00 8B C6 C1 E0 02 8D 04 80 89 44 24 14 8B D4 8B C3 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2396_0 {
	meta:
		name = "TParaAttributes.GetRightIndent"
		size = 32
		refs = "0009 _NF__A81"
	strings:
		$1 = { 81 C4 64 FF FF FF 8B D4 E8 ?? ?? ?? ?? 8B 44 24 10 B9 14 00 00 00 99 F7 F9 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule function_2397_0 {
	meta:
		name = "TParaAttributes.SetRightIndent"
		size = 59
		refs = "0011 _NF__A80 002e _NF__A82"
	strings:
		$1 = { 53 56 81 C4 64 FF FF FF 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? C7 44 24 04 02 00 00 00 8B C6 C1 E0 02 8D 04 80 89 44 24 10 8B D4 8B C3 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2398_0 {
	meta:
		name = "TParaAttributes.GetTab"
		size = 40
		refs = "000c _NF__A81"
	strings:
		$1 = { 53 81 C4 64 FF FF FF 8B DA 8B D4 E8 ?? ?? ?? ?? 33 C0 8A C3 8B 44 84 1C B9 14 00 00 00 99 F7 F9 81 C4 9C 00 00 00 5B C3 }
	condition:
		$1
}

rule function_2399_0 {
	meta:
		name = "TParaAttributes.SetTab"
		size = 83
		refs = "0014 _NF__A81 0045 _NF__A82"
	strings:
		$1 = { 53 56 57 81 C4 64 FF FF FF 8B F9 8B DA 8B F0 8B D4 8B C6 E8 ?? ?? ?? ?? 8B C7 C1 E0 02 8D 04 80 33 D2 8A D3 89 44 94 1C C7 44 24 04 10 00 00 00 33 C0 8A C3 66 3B 44 24 1A 7E 05 66 89 44 24 1A 8B D4 8B C6 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2400_0 {
	meta:
		name = "TParaAttributes.GetTabCount"
		size = 25
		refs = "0009 _NF__A81"
	strings:
		$1 = { 81 C4 64 FF FF FF 8B D4 E8 ?? ?? ?? ?? 0F BF 44 24 1A 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule function_2401_0 {
	meta:
		name = "TParaAttributes.SetTabCount"
		size = 52
		refs = "0011 _NF__A81 0027 _NF__A82"
	strings:
		$1 = { 53 56 81 C4 64 FF FF FF 8B F2 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? C7 44 24 04 10 00 00 00 66 89 74 24 1A 8B D4 8B C3 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_2402_0 {
	meta:
		name = "TParaAttributes.Assign"
		size = 153
		refs = "000c _DV_TParaAttributes 0011 @IsClass 001e TParaAttributes.GetAlignment 0027 TParaAttributes.SetAlignment 002e TParaAttributes.GetFirstIndent 0037 TParaAttributes.SetFirstIndent 003e TParaAttributes.GetLeftIndent 0047 TParaAttributes.SetLeftIndent 004e TParaAttributes.GetRightIndent 0057 TParaAttributes.SetRightIndent 005e TParaAttributes.GetNumbering 0067 TParaAttributes.SetNumbering 0074 TParaAttributes.GetTab 007f TParaAttributes.SetTab 0090 TPersistent.Assign"
	strings:
		$1 = { 53 56 57 55 8B FA 8B F0 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 72 8B DF 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 33 ED 8B DD 8B D3 8B C7 E8 ?? ?? ?? ?? 8B C8 8B D3 8B C6 E8 ?? ?? ?? ?? 45 83 FD 20 75 E4 EB 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2403_0 {
	meta:
		name = "TConversion.ConvertReadStream"
		size = 20
	strings:
		$1 = { 55 8B EC 53 8B C1 8B 4D 08 92 8B 18 FF 53 04 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2404_0 {
	meta:
		name = "TConversion.ConvertWriteStream"
		size = 20
	strings:
		$1 = { 55 8B EC 53 8B C1 8B 4D 08 92 8B 18 FF 53 08 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_2405_0 {
	meta:
		name = "_NF__AB8"
		size = 118
		refs = "0033 _NF__AB8 0041 TStrings.AddStrings 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 89 45 FC 8B 45 FC 8B 40 0C 8B 88 5C 01 00 00 89 4D F4 8B 88 60 01 00 00 89 4D F8 33 C9 89 88 5C 01 00 00 89 88 60 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C 8B 55 F4 89 90 5C 01 00 00 8B 55 F8 89 90 60 01 00 00 C3 E9 ?? ?? ?? ?? EB E0 8B E5 5D C3 }
	condition:
		$1
}

rule function_2406_0 {
	meta:
		name = "_NF__AB9"
		size = 86
		refs = "0011 TWinControl.GetHandle 0017 SendMessage"
	strings:
		$1 = { 53 56 8B D8 6A 00 6A 00 68 BA 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 6A 00 6A 00 8B C6 48 50 68 BB 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 68 C1 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 01 4E 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2407_0 {
	meta:
		name = "_NF__ABA"
		size = 83
		refs = "0024 TWinControl.GetHandle 002a SendMessage 0045 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 81 C4 04 F0 FF FF 50 8B F9 8B F2 8B D8 8B C4 66 C7 00 00 10 8B C4 50 56 68 C4 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 7C 04 FE 0D 75 0A 80 7C 04 FF 0A 75 03 83 E8 02 8B D4 8B CF 91 E8 ?? ?? ?? ?? 81 C4 00 10 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2408_0 {
	meta:
		name = "_NF__ABB"
		size = 140
		refs = "001d TWinControl.GetHandle 0023 SendMessage 006b @LStrToPChar"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B E9 8B F2 8B D8 85 F6 7C 74 6A 00 56 68 BB 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 89 3C 24 47 74 56 6A 00 8B 44 24 04 50 68 C1 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 03 04 24 89 44 24 04 8B C4 50 6A 00 68 37 04 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C5 E8 ?? ?? ?? ?? 50 6A 00 68 C2 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2409_0 {
	meta:
		name = "_NF__ABC"
		size = 384
		refs = "001c _NF__ABC 003a TWinControl.GetHandle 0040 SendMessage 00d8 @LStrFromPChar 00e3 Format 00eb @LStrToPChar 0116 @LStrLen 0125 sRichEditInsertError 012a LoadResString 0134 _Dn_EOutOfResources 0139 Exception.Create 013e @RaiseExcept 0153 @LStrClr 0161 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 89 5D F0 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 0F 8C 14 01 00 00 6A 00 56 68 BB 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 89 7D F4 85 FF 7C 07 BE ?? ?? ?? ?? EB 4D 6A 00 4E 56 68 BB 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 89 7D F4 85 FF 0F 8C CA 00 00 00 6A 00 8B 45 F4 50 68 C1 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 0F 84 A9 00 00 00 01 45 F4 BE ?? ?? ?? ?? 8B 45 F4 89 45 F8 8D 45 F4 50 6A 00 68 37 04 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 FC 89 45 E8 C6 45 EC 0B 8D 45 E8 50 8D 45 E4 8B D6 E8 ?? ?? ?? ?? 8B 45 E4 33 C9 5A E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 50 6A 00 68 C2 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 92 84 00 00 00 8B D8 8B 45 F0 E8 ?? ?? ?? ?? 03 45 F8 3B D8 74 21 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D E4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 00 00 25 73 0D 0A 00 00 00 00 0D 0A 25 73 00 00 00 00 }
	condition:
		$1
}

rule function_2411_0 {
	meta:
		name = "_NF__ABF"
		size = 170
		refs = "001e TWinControl.GetHandle 0024 SendMessage 008a _NV__ABD"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8B D8 85 F6 0F 8C 92 00 00 00 6A 00 56 68 BB 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 89 3C 24 47 74 74 6A 00 46 56 68 BB 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 89 7C 24 04 47 75 21 6A 00 8B 44 24 04 50 68 C1 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 03 04 24 89 44 24 04 8B C4 50 6A 00 68 37 04 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 6A 00 68 C2 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_2412_0 {
	meta:
		name = "_NF__388"
		size = 12
		altNames = "_NF__AC0"
	strings:
		$1 = { 8B 40 0C 8B 10 FF 92 94 00 00 00 C3 }
	condition:
		$1
}

rule function_2413_0 {
	meta:
		name = "_NF__AC1"
		size = 67
		refs = "0016 TWinControl.GetHandle 001c SendMessage 002b TControl.Refresh 003c TControl.Perform"
	strings:
		$1 = { 53 56 8B DA 8B F0 6A 00 8B C3 34 01 83 E0 7F 50 6A 0B 8B 46 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 80 F3 01 84 DB 74 19 8B 46 0C E8 ?? ?? ?? ?? 6A 00 33 C9 BA 12 B0 00 00 8B 46 0C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2414_0 {
	meta:
		name = "_NF__AC2"
		size = 89
		refs = "0015 TWinControl.GetHandle 001b SendMessage"
	strings:
		$1 = { 53 56 8B 58 0C 84 D2 74 1D 6A 00 6A 00 68 3B 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 83 CE 01 EB 1B 6A 00 6A 00 68 3B 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F0 83 E6 FE 56 6A 00 68 45 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2415_0 {
	meta:
		name = "_NF__AC3"
		size = 79
		refs = "0010 _NF__AC2 0018 _NF__AC3 0028 TStrings.SetTextStr 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EE 5B 59 5D C3 }
	condition:
		$1
}

rule function_2416_0 {
	meta:
		name = "_NF__AC4"
		size = 54
	strings:
		$1 = { 56 57 89 C7 89 D6 89 C2 FC AC 08 C0 74 1F 80 F8 0A 74 11 AA 80 F8 0D 75 F0 B0 0A AA AC 80 F8 0A 74 E7 EB E6 B8 0D 0A 00 00 66 AB EB DC AA 8D 47 FF 29 D0 5F 5E C3 }
	condition:
		$1
}

rule function_2417_0 {
	meta:
		name = "_NF__AC5"
		size = 93
		refs = "000f _NF__AC5 0046 @HandleAnyException 0050 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 33 F6 8B 5D 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 14 33 D2 89 10 83 3B 00 74 16 8B 45 10 50 8B 53 04 8B 03 8B 4D 0C 8B 18 FF 53 04 8B 55 14 89 02 33 C0 5A 59 59 64 89 10 EB 0F E9 ?? ?? ?? ?? BE 02 00 00 00 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule function_2418_0 {
	meta:
		name = "_NF__AC6"
		size = 243
		refs = "001e StrAlloc 0029 _NF__AC6 009c _NF__AC4 00ab Move 00ba @HandleAnyException 00c6 @DoneExcept 00db StrDispose 00e1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B 5D 14 8B 75 10 33 C0 89 45 FC 8B 45 08 89 45 F0 8D 46 01 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 D1 FE 79 03 83 D6 00 33 C0 89 03 8B 45 F8 03 C6 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 83 38 00 74 15 56 8B 45 F0 8B 50 04 8B 45 F0 8B 00 8B 4D F4 8B 30 FF 16 89 03 83 3B 00 7E 39 8B 03 8B 55 F4 C6 04 02 00 8B 03 8B 55 F4 80 7C 02 FF 0D 75 0A 8B 03 8B 55 F4 C6 44 02 FF 00 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 89 03 8B 0B 8B 55 0C 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 11 E9 ?? ?? ?? ?? C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_2419_0 {
	meta:
		name = "_NF__AC7"
		size = 350
		refs = "0017 _NF__AC7 0042 TObject.Create 0064 _NF__AC6 0073 TStream.GetPosition 009f TWinControl.GetHandle 00a5 SendMessage 00b9 TStream.SetPosition 00f7 sRichEditLoadFail 00fc LoadResString 0106 _Dn_EOutOfResources 010b Exception.Create 0110 @RaiseExcept 012e TObject.Free 0134 @HandleFinally 014b @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 33 C9 89 4D E0 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 89 75 F8 8B 45 FC 8B 40 14 85 C0 74 05 89 45 F0 EB 16 8B 45 FC 8B 40 0C 8B 80 68 01 00 00 B2 01 E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 89 45 E4 B8 ?? ?? ?? ?? 89 45 EC 33 C0 89 45 E8 8B C6 E8 ?? ?? ?? ?? 8B F8 8B 45 FC 80 78 10 00 74 07 BB 01 00 00 00 EB 05 BB 02 00 00 00 8D 45 E4 50 53 68 49 04 00 00 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 FB 02 75 66 83 7D E8 00 74 60 8B D7 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 80 78 10 00 74 07 BB 02 00 00 00 EB 05 BB 01 00 00 00 8D 45 E4 50 53 68 49 04 00 00 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 7D E8 00 74 21 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D E0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 78 14 00 75 08 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2420_0 {
	meta:
		name = "_NF__AC8"
		size = 269
		refs = "0015 _NF__AC8 003d TObject.Create 0062 _NF__AC5 0094 TWinControl.GetHandle 009a SendMessage 00a8 sRichEditSaveFail 00ad LoadResString 00b7 _Dn_EOutOfResources 00bc Exception.Create 00c1 @RaiseExcept 00df TObject.Free 00e5 @HandleFinally 00fc @LStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 33 C9 89 4D E0 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 14 85 C0 74 05 89 45 F0 EB 16 8B 45 FC 8B 40 0C 8B 80 68 01 00 00 B2 01 E8 ?? ?? ?? ?? 89 45 F0 89 5D F8 8B 45 F0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 89 45 E4 B8 ?? ?? ?? ?? 89 45 EC 33 C0 89 45 E8 8B 45 FC 80 78 10 00 74 07 BB 01 00 00 00 EB 05 BB 02 00 00 00 8D 45 E4 50 53 68 4A 04 00 00 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 7D E8 00 74 21 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D E0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 78 14 00 75 08 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2421_0 {
	meta:
		name = "_NF__AC9"
		size = 235
		refs = "0015 _NF__AC9 0025 ExtractFileExt 0030 AnsiLowerCaseFileName 0042 @LStrDelete 0048 _NV__6B4 0059 @LStrCmp 006b _NV__6B2 0074 TObject.Create 0092 TStrings.LoadFromFile 00a1 @HandleAnyException 00ac TObject.Free 00b9 @RaiseAgain 00be @DoneExcept 00d8 @LStrArrayClr 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B FA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F4 8B C7 E8 ?? ?? ?? ?? 8B 45 F4 8D 55 F8 E8 ?? ?? ?? ?? 8D 45 F8 B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 DB 74 16 8B F3 8B 46 04 8B 55 F8 E8 ?? ?? ?? ?? 74 07 8B 5E 08 85 DB 75 EA 85 DB 75 05 BB ?? ?? ?? ?? 8B 03 B2 01 E8 ?? ?? ?? ?? 8B 55 FC 89 42 14 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 22 E9 ?? ?? ?? ?? 8B 45 FC 8B 40 14 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 50 14 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2422_0 {
	meta:
		name = "_NF__ACA"
		size = 235
		refs = "0015 _NF__ACA 0025 ExtractFileExt 0030 AnsiLowerCaseFileName 0042 @LStrDelete 0048 _NV__6B4 0059 @LStrCmp 006b _NV__6B2 0074 TObject.Create 0092 TStrings.SaveToFile 00a1 @HandleAnyException 00ac TObject.Free 00b9 @RaiseAgain 00be @DoneExcept 00d8 @LStrArrayClr 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B FA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F4 8B C7 E8 ?? ?? ?? ?? 8B 45 F4 8D 55 F8 E8 ?? ?? ?? ?? 8D 45 F8 B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 DB 74 16 8B F3 8B 46 04 8B 55 F8 E8 ?? ?? ?? ?? 74 07 8B 5E 08 85 DB 75 EA 85 DB 75 05 BB ?? ?? ?? ?? 8B 03 B2 01 E8 ?? ?? ?? ?? 8B 55 FC 89 42 14 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 22 E9 ?? ?? ?? ?? 8B 45 FC 8B 40 14 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 50 14 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2423_0 {
	meta:
		name = "TCustomRichEdit.Create"
		size = 242
		refs = "000e @ClassCreate 001c TCustomMemo.Create 0027 _DV_TTextAttributes 002c TTextAttributes.Create 0051 _DV_TParaAttributes 0056 TParaAttributes.Create 0063 _NV__AB6 0068 TObject.Create 007c TWinControl.SetTabStop 0088 TControl.SetWidth 0094 TControl.SetHeight 009d TCustomEdit.SetAutoSize 00ad TCustomRichEdit.SetHideScrollBars 00b4 GetDC 00be GetDeviceCaps 00c9 _DV_TConversion 00d7 ReleaseDC"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 44 01 00 00 6A 01 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 48 01 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 4C 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 54 01 00 00 89 5E 0C B2 01 8B C3 E8 ?? ?? ?? ?? BA B9 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 59 00 00 00 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 64 01 00 00 01 B2 01 8B C3 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 8B F0 6A 5A 56 E8 ?? ?? ?? ?? 89 83 50 01 00 00 A1 ?? ?? ?? ?? 89 83 68 01 00 00 56 6A 00 E8 ?? ?? ?? ?? 80 7D FF 00 74 0A 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2424_0 {
	meta:
		name = "TCustomRichEdit.Destroy"
		size = 89
		refs = "000d TObject.Free 0045 TCustomMemo.Destroy 0050 @ClassDestroy"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B 86 44 01 00 00 E8 ?? ?? ?? ?? 8B 86 48 01 00 00 E8 ?? ?? ?? ?? 8B 86 4C 01 00 00 E8 ?? ?? ?? ?? 8B 86 54 01 00 00 E8 ?? ?? ?? ?? 8B 86 58 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FE 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2426_0 {
	meta:
		name = "TCustomRichEdit.CreateParams"
		size = 160
		refs = "000d SetErrorMode 0014 TCustomRichEdit.CreateParams 0019 LoadLibrary 0045 TCustomMemo.CreateParams 0053 TWinControl.CreateSubClass 0065 _NV__AD4 0074 _NV__AD5"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 68 00 80 00 00 E8 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 3C 01 00 00 8B 83 3C 01 00 00 85 C0 7E 0D 83 F8 20 7D 08 33 C0 89 83 3C 01 00 00 57 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 46 04 33 D2 8A 93 40 01 00 00 0B 04 95 ?? ?? ?? ?? 33 D2 8A 93 64 01 00 00 0B 04 95 ?? ?? ?? ?? 89 46 04 83 66 24 FC 5F 5E 5B C3 00 52 49 43 48 45 44 33 32 2E 44 4C 4C 00 00 00 00 52 49 43 48 45 44 49 54 00 00 00 00 }
	condition:
		$1
}

rule function_2427_0 {
	meta:
		name = "TCustomRichEdit.CreateWnd"
		size = 265
		refs = "000d TCustomEdit.CreateWnd 0012 SysLocale 0029 GetDefFontCharSet 0036 TFont.SetCharset 004a TWinControl.GetHandle 0050 SendMessage 005b ColorToRGB 0085 TCustomRichEdit.GetPlainText 0092 TCustomRichEdit.SetPlainText 009a TCustomRichEdit.CreateWnd 00c5 TObject.Free 00ee @HandleFinally 0101 TCustomEdit.SetModified"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 78 08 00 74 1E A1 ?? ?? ?? ?? 66 83 78 04 11 74 12 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 40 50 E8 ?? ?? ?? ?? 68 01 00 2C 00 6A 00 68 45 04 00 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 54 E8 ?? ?? ?? ?? 50 6A 00 68 43 04 00 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 FC 83 B8 58 01 00 00 00 74 73 8B 45 FC E8 ?? ?? ?? ?? 88 45 FB 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 90 58 01 00 00 8B 45 FC 8B 80 54 01 00 00 8B 08 FF 51 5C 8B 45 FC 8B 80 58 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 58 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8A 55 FB 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 FC 8A 90 65 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_2428_0 {
	meta:
		name = "TCustomRichEdit.DestroyWnd"
		size = 165
		refs = "000d TCustomEdit.GetModified 001d _Dn_TMemoryStream 0022 TObject.Create 0033 TCustomRichEdit.GetPlainText 0040 TCustomRichEdit.SetPlainText 0048 TCustomRichEdit.DestroyWnd 0075 TStream.SetPosition 0093 @HandleFinally 009d TCustomEdit.DestroyWnd"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 88 82 65 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 82 58 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 88 45 FB 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 90 58 01 00 00 8B 45 FC 8B 80 54 01 00 00 8B 08 FF 51 68 8B 45 FC 8B 80 58 01 00 00 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8A 55 FB 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 FC E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_2429_0 {
	meta:
		name = "TCustomRichEdit.WMNCDestroy"
		size = 28
		refs = "0006 TCustomMemo.WMNCDestroy 0016 FreeLibrary"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 3C 01 00 00 85 C0 74 06 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_2430_0 {
	meta:
		name = "TCustomRichEdit.CMFontChanged"
		size = 15
		altNames = "TCustomRichEdit.WMSetFont"
	strings:
		$1 = { 8B 50 50 8B 80 48 01 00 00 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_2432_0 {
	meta:
		name = "TCustomRichEdit.DoSetMaxLength"
		size = 30
		refs = "0011 TWinControl.GetHandle 0017 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 56 6A 00 68 35 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2433_0 {
	meta:
		name = "TCustomRichEdit.GetSelLength"
		size = 40
		refs = "0013 TWinControl.GetHandle 0019 SendMessage"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C4 50 6A 00 68 34 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 44 24 04 2B 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_2434_0 {
	meta:
		name = "TCustomRichEdit.GetSelStart"
		size = 36
		refs = "0013 TWinControl.GetHandle 0019 SendMessage"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C4 50 6A 00 68 34 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 04 24 59 5A 5B C3 }
	condition:
		$1
}

rule function_2435_0 {
	meta:
		name = "TCustomRichEdit.GetSelTextBuf"
		size = 114
		refs = "0012 TCustomRichEdit.GetSelTextBuf 002d @LStrLen 0049 StrPLCopy 005e @LStrClr 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F1 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 8B 08 FF 91 88 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 3B F0 7D 02 8B DE 8B CB 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2436_0 {
	meta:
		name = "TCustomRichEdit.GetSelText"
		size = 65
		refs = "0016 @LStrSetLength 001d @LStrToPChar 002c TWinControl.GetHandle 0032 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 80 00 00 00 8B D0 42 8B C6 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 50 6A 00 68 3E 04 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D6 92 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2437_0 {
	meta:
		name = "TCustomRichEdit.SetHideScrollBars"
		size = 20
		refs = "000f TWinControl.