private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_0_0 {
	meta:
		name = "TActionBarAccessibility.accDoDefaultAction"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.accDoDefaultAction 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 14 00 }
	condition:
		$1
}

rule function_1_0 {
	meta:
		name = "TActionBarAccessibility.accHitTest"
		size = 324
		refs = "0024 VariantInit 003b _Dn_TActionBarItem 0040 @IsClass 0052 Point 0063 TControl.ScreenToClient 007c TCollectionItem.GetIndex 0088 @OleVarFromInt 009b _Dn_TActionClientItem 00de TWinControl.ControlAtPos 010c TControl.GetBoundsRect 0117 PtInRect"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 8B 7D 14 8B 5D 08 8B C7 85 FF 74 0D 33 D2 89 57 0C 89 57 08 89 57 04 89 17 57 E8 ?? ?? ?? ?? 66 C7 07 03 00 33 F6 C7 45 FC 01 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4E 8D 4D EC 8B 55 10 8B 45 0C E8 ?? ?? ?? ?? 8D 55 EC 8D 4D F4 8B 43 0C 8B 40 0C E8 ?? ?? ?? ?? 8B 43 0C 8B 70 0C 85 F6 0F 84 C3 00 00 00 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 42 8B C7 B1 FC E8 ?? ?? ?? ?? 33 C0 89 45 FC E9 A2 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 5A 8B 43 0C 83 78 44 00 74 51 6A 00 6A 00 8D 4D E4 8B 55 10 8B 45 0C E8 ?? ?? ?? ?? 8D 55 E4 8D 4D EC 8B 43 0C 8B 70 18 8B C6 E8 ?? ?? ?? ?? 8D 55 EC 8B C6 B1 01 E8 ?? ?? ?? ?? 8B F0 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 42 8B C7 B1 FC E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 36 85 F6 74 2B 8D 55 D4 8B C6 E8 ?? ?? ?? ?? 8D 45 D4 8D 55 F4 E8 ?? ?? ?? ?? 84 C0 74 12 8B C7 33 D2 B1 01 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 07 C7 45 FC 01 00 00 00 8B 45 FC 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_2_0 {
	meta:
		name = "TActionBarAccessibility.accLocation"
		size = 288
		refs = "0019 @VarAddRef 0021 TActionBarAccessibility.accLocation 0038 @OleVarFromInt 0043 @VarCmpEQ 0050 _Dn_TActionBarItem 0055 @IsClass 006b TActionClient.GetItems 0077 @VarCopy 0091 @VarSub 0099 @VarToInteger 00a1 TActionClients.GetActionClient 00bf TControl.ClientToScreen 00f7 OleVariant 0101 @FinalizeArray 0109 @VarClr 010f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 1C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 E8 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 E8 8D 45 1C E8 ?? ?? ?? ?? 75 1E 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 8B 5F 0C EB 46 8B 5F 44 EB 41 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 1C 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 C8 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C8 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 8B 58 44 85 DB 74 39 8D 55 B8 8B C3 8B 08 FF 51 44 8D 55 B8 8D 4D F8 8B C3 E8 ?? ?? ?? ?? 8B 45 0C 8B 55 F8 89 10 8B 45 10 8B 55 FC 89 10 8B 45 14 8B 53 48 89 10 8B 45 18 8B 53 4C 89 10 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 1C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C6 5F 5E 5B 8B E5 5D C2 24 00 }
	condition:
		$1
}

rule function_3_0 {
	meta:
		name = "TActionBarAccessibility.accNavigate"
		size = 90
		refs = "0008 @VarAddRef 0027 TActionBarAccessibility.accNavigate 0047 @VarClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 10 E8 ?? ?? ?? ?? 8B 45 20 8B 55 20 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 1C 00 }
	condition:
		$1
}

rule function_4_0 {
	meta:
		name = "TActionBarAccessibility.Get_accFocus"
		size = 35
		altNames = "TActionBarAccessibility.Get_accSelection"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 55 0C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A B8 03 00 02 80 5D C2 08 00 }
	condition:
		$1
}

rule function_5_0 {
	meta:
		name = "TActionBarAccessibility.Create"
		size = 78
		refs = "000e @ClassCreate 002c @IntfCopy 0037 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 89 4F 10 8B 75 08 89 77 0C 8D 46 34 8B D7 85 D2 74 03 83 EA EC E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_6_0 {
	meta:
		name = "TActionBarAccessibility.GetIDsOfNames"
		size = 12
		altNames = "TBaseDebugScriptSite.GetDeferredText TBaseDebugScriptSite.GetScriptTextAttributes TEventDispatch.GetIDsOfNames TLocalAppServer.GetIDsOfNames TMSDOMEventHandler.GetIDsOfNames TOleControl.GetIDsOfNames TSOAPAppServerAdapter.GetIDsOfNames TServerEventDispatch.GetIDsOfNames"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 18 00 }
	condition:
		$1
}

rule function_7_0 {
	meta:
		name = "CmpUnimplemented"
		size = 12
		altNames = "TActionBarAccessibility.GetTypeInfo TActiveXControl.InitFromData TActiveXControl.SetData TDataDispatch.GetTypeInfo TDataObject.SetData TLocalAppServer.GetTypeInfo TMSDOMEventHandler.GetTypeInfo TObjectDispatch.GetTypeInfo TSOAPAppServerAdapter.GetTypeInfo"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_8_0 {
	meta:
		name = "TActionBarAccessibility.GetTypeInfoCount"
		size = 12
		altNames = "TActiveScriptSite.GetLCID TActiveXControl.ContextSensitiveHelp TActiveXControl.GetSizeMax TActiveXControl.QueryGetData TActiveXControl.SetColorScheme TActiveXControl.Unfreeze TDownLoadURL.GetPriority TDownLoadURL.OnLowResource TLocalAppServer.GetTypeInfoCount TMSDOMEventHandler.GetTypeInfoCount TObjectDispatch.GetTypeInfoCount TOleControl.LockInPlaceActive TOleControl.OnFocus TOleControl.SetBorderSpace TOleLinkStub.GetUpdateOptions TOleLinkStub.SetSourceDisplayName TOleLinkStub.SetUpdateOptions TOleLinkStub.Update TPropertyPageImpl.EditProperty TPropertyPageImpl.Help TSOAPAppServerAdapter.GetTypeInfoCount UniUnimplemented"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_9_0 {
	meta:
		name = "TActionBarAccessibility.Get_accChild"
		size = 297
		refs = "0018 @VarAddRef 002b TActionBarAccessibility.Get_accChild 003d @OleVarFromInt 0048 @VarCmpEQ 005c TActionClient.GetItems 0061 TCollection.GetCount 0078 @VarCmpGT 0082 @IntfClear 009f @VarCopy 00b9 @VarSub 00c1 @VarToInteger 00c9 TActionClients.GetActionClient 00d3 _DV_TActionBarAccessibility 00d8 TActionBarAccessibility.Create 00e9 @IntfCopy 0101 OleVariant 010b @FinalizeArray 0113 @VarClr 0119 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 0A BB 57 00 07 80 E9 97 00 00 00 8B 43 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8D 45 E0 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0F 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 EB 62 8B 73 0C 8B C6 E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 1C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accChild"
		size = 297
		refs = "0018 @VarAddRef 002b TActionMenuBarAccessibility.Get_accChild 003d @OleVarFromInt 0048 @VarCmpEQ 005c TActionClient.GetItems 0061 TCollection.GetCount 0078 @VarCmpGT 0082 @IntfClear 009f @VarCopy 00b9 @VarSub 00c1 @VarToInteger 00c9 TActionClients.GetActionClient 00d3 _DV_TActionMenuBarAccessibility 00d8 TActionBarAccessibility.Create 00e9 @IntfCopy 0101 OleVariant 010b @FinalizeArray 0113 @VarClr 0119 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 0A BB 57 00 07 80 E9 97 00 00 00 8B 43 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8D 45 E0 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0F 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 EB 62 8B 73 0C 8B C6 E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 1C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_10_0 {
	meta:
		name = "TActionBarAccessibility.Get_accChildCount"
		size = 32
		refs = "000b TActionClient.GetItems 0010 TCollection.GetCount"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 43 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 0C 89 02 33 C0 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "TActionBarAccessibility.Get_accDefaultAction"
		size = 78
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accDefaultAction 003b @VarClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "TActionBarAccessibility.Get_accHelp"
		size = 78
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accHelp 003b @VarClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "TActionBarAccessibility.Get_accDescription"
		size = 361
		refs = "0019 @VarAddRef 002c TActionBarAccessibility.Get_accDescription 0043 @OleVarFromInt 004e @VarCmpEQ 005b _Dn_TActionBarItem 0060 @IsClass 0075 GetLongHint 0080 @WStrFromUStr 00a8 TActionClient.GetItems 00b4 @VarCopy 00ce @VarSub 00d6 @VarToInteger 00de TActionClients.GetActionClient 00e3 TActionClientItem.GetAction 012b OleVariant 0135 @FinalizeArray 0142 @UStrArrayClr 014a @VarClr 0158 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 50 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8D 55 EC 8B 47 0C 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? EB 77 8D 55 E8 8B 47 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 1C E8 ?? ?? ?? ?? EB 59 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 C4 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C4 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 7C 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 C0 8B 45 C0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "TActionBarAccessibility.Get_accHelpTopic"
		size = 186
		refs = "0021 @VarAddRef 0029 TActionBarAccessibility.Get_accHelpTopic 0037 @WStrClr 004c @OleVarFromInt 0057 @VarCmpEQ 0062 _Dn_TActionClientItem 0067 @IsClass 0073 TActionClientItem.GetAction 009b @VarClr 00a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B 75 20 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8D 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C E8 ?? ?? ?? ?? 33 C0 89 06 BF 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 10 E8 ?? ?? ?? ?? 75 2D 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1B 8B 43 0C E8 ?? ?? ?? ?? 85 C0 74 0F 8B 43 0C E8 ?? ?? ?? ?? 8B 40 74 89 06 33 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C7 5F 5E 5B 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "TActionBarAccessibility.Get_accKeyboardShortcut"
		size = 441
		refs = "001a @VarAddRef 002d TActionBarAccessibility.Get_accKeyboardShortcut 0044 @OleVarFromInt 004f @VarCmpEQ 0060 _Dn_TActionBarItem 0065 @IsClass 0071 @WStrClr 007d TActionClientItem.GetAction 008c TActionClientItem.GetCaption 0097 GetHotkey 00a2 @WStrFromUStr 00bb ShortCutToText 00ec TActionClient.GetItems 00f8 @VarCopy 0112 @VarSub 011a @VarToInteger 0122 TActionClients.GetActionClient 0173 OleVariant 017d @FinalizeArray 0185 @UStrClr 0192 @UStrArrayClr 019a @VarClr 01a8 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 8F 00 00 00 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B 45 1C E8 ?? ?? ?? ?? E9 E7 00 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 23 8D 55 E8 8B 43 0C E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? EB 22 8B 43 0C E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E0 8B 45 E0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 7D 33 F6 EB 79 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 CC E8 ?? ?? ?? ?? 8D 45 BC BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 BC 8D 45 CC E8 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8D 55 DC E8 ?? ?? ?? ?? 8B 55 DC 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E0 8B 45 E0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 BC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "TActionBarAccessibility.Get_accName"
		size = 422
		refs = "001a @VarAddRef 002d TActionBarAccessibility.Get_accName 0041 @OleVarFromInt 004c @VarCmpEQ 0059 _Dn_TActionClientItem 005e @IsClass 006c TActionClientItem.GetCaption 0077 StripHotkey 0082 @WStrFromUStr 008f _Dn_TActionBarItem 00a7 TControl.GetText 00b4 TActionClient.GetItems 00b9 TCollection.GetCount 00d0 @VarCmpGT 00ed @VarCopy 0107 @VarSub 010f @VarToInteger 0117 TActionClients.GetActionClient 014b OleVariant 0155 @FinalizeArray 0162 @UStrArrayClr 016a @VarClr 0172 @UStrClr 0195 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 0A 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 5E 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 25 8D 55 E8 8B C7 E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? E9 AE 00 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 99 00 00 00 8D 55 E4 8B 47 0C E8 ?? ?? ?? ?? E9 89 00 00 00 8B 43 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8D 45 D4 B1 FC E8 ?? ?? ?? ?? 8D 55 D4 8D 45 0C E8 ?? ?? ?? ?? 7E 07 BE 01 00 00 00 EB 5C 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 BC E8 ?? ?? ?? ?? 8D 45 AC BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 AC 8D 45 BC E8 ?? ?? ?? ?? 8D 45 BC E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 8D 55 CC E8 ?? ?? ?? ?? 8B 45 CC 8D 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 8B 45 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 AC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB AB 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "TActionBarAccessibility.Get_accParent"
		size = 50
		refs = "0026 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 B8 01 00 00 00 8B 73 10 85 F6 74 0D 8B 45 0C 8B 56 34 E8 ?? ?? ?? ?? 33 C0 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "TActionBarAccessibility.Get_accRole"
		size = 244
		refs = "0013 @VarAddRef 0032 TActionBarAccessibility.Get_accRole 0043 VariantInit 0057 @OleVarFromInt 0062 @VarCmpEQ 006d _Dn_TActionBarItem 0072 @IsClass 0095 _Dn_TCustomActionMainMenuBar 00d5 @VarClr 00e3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 52 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 02 00 00 00 EB 3E 8B 43 0C 8B 78 44 85 FF 74 1E 8B 47 30 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 0B 00 00 00 EB 16 8B 45 1C C7 40 08 0C 00 00 00 EB 0A 8B 45 1C C7 40 08 0C 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "TActionBarAccessibility.accSelect"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.accSelect 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "TActionBarAccessibility.Get_accState"
		size = 650
		refs = "0019 @VarAddRef 0038 TActionBarAccessibility.Get_accState 0049 VariantInit 005f @OleVarFromInt 006a @VarCmpEQ 0079 _Dn_TActionBarItem 007e @IsClass 0093 _Dn_TActionClientItem 00c5 IsVisible 00dc IsEnabled 00f4 IsChecked 0111 TActionClient.GetItems 011d @VarCopy 0137 @VarSub 013f @VarToInteger 0149 TActionClients.GetActionClient 0198 TActionClient.GetHasItems 01a2 HasPopup 0261 OleVariant 026b @FinalizeArray 0273 @VarClr 0279 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 12 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 8F 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 0C 8B 70 0C EB 18 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 43 0C 8B 70 44 85 F6 75 0A BF 57 00 07 80 E9 98 01 00 00 8B 45 1C C7 40 08 84 00 10 00 0F B6 46 57 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 4C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 3C 0F B6 40 69 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 49 01 00 00 8B 45 1C C7 40 08 84 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 D0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 D0 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8B F0 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 57 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 B0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 B0 8D 45 C0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 A0 E8 ?? ?? ?? ?? 8D 45 90 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 90 8D 45 A0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 4C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 80 E8 ?? ?? ?? ?? 8D 85 70 FF FF FF BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 95 70 FF FF FF 8D 45 80 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 CC 00 00 00 84 C0 74 07 8B 45 1C 83 48 08 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 70 FF FF FF 8B 15 ?? ?? ?? ?? B9 09 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C7 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "TActionBarAccessibility.Get_accValue"
		size = 86
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accValue 0029 @WStrClr 0043 @VarClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_23_0 {
	meta:
		name = "TActionBarAccessibility.Invoke"
		size = 12
		altNames = "TLocalAppServer.Invoke TSOAPAppServerAdapter.Invoke"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 24 00 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "TActionBarAccessibility.Set_accName"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.Set_accName 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_25_0 {
	meta:
		name = "TActionBarAccessibility.Set_accValue"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.Set_accValue 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accDescription"
		size = 232
		refs = "0014 @VarAddRef 0027 TActionMenuBarAccessibility.Get_accDescription 003a @WStrClr 0046 @OleVarFromInt 0051 @VarCmpEQ 005e TActionClientItem.GetCaption 006b @UStrCat 0076 @WStrFromUStr 00a7 @UStrClr 00af @VarClr 00bd @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8B 45 1C E8 ?? ?? ?? ?? 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 23 8D 55 EC 8B 43 0C E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E8 8B 45 E8 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C6 5E 5B 8B E5 5D C2 18 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 20 00 6D 00 65 00 6E 00 75 00 00 00 }
	condition:
		$1
}

rule function_28_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accRole"
		size = 202
		refs = "0012 @VarAddRef 0031 TActionMenuBarAccessibility.Get_accRole 0042 VariantInit 0056 @OleVarFromInt 0061 @VarCmpEQ 006c _Dn_TActionBarItem 0071 @IsClass 00ac @VarClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 2A 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 02 00 00 00 EB 16 8B 45 1C C7 40 08 0C 00 00 00 EB 0A 8B 45 1C C7 40 08 0C 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_29_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accState"
		size = 769
		refs = "0019 @VarAddRef 0038 TActionMenuBarAccessibility.Get_accState 0049 VariantInit 005f @OleVarFromInt 006a @VarCmpEQ 0079 _Dn_TActionBarItem 007e @IsClass 0093 _Dn_TActionClientItem 00bb IsVisible 00d2 IsEnabled 00ec IsChecked 0109 TActionClientItem.GetAction 0153 TActionClient.GetItems 0158 TCollection.GetCount 016f @VarCmpGT 018f @VarCopy 01a9 @VarSub 01b1 @VarToInteger 01bb TActionClients.GetActionClient 01c6 Beep 0255 TActionClient.GetHasItems 025f HasPopup 02d8 OleVariant 02e2 @FinalizeArray 02ea @VarClr 02f0 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 14 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 DB 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 0C 8B 70 0C EB 18 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 43 0C 8B 70 44 85 F6 74 51 8B 45 1C C7 40 08 04 00 10 00 0F B6 46 57 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 4C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 92 CC 00 00 00 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 C8 01 00 00 8B 45 1C C7 40 08 04 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 85 C0 0F 84 AE 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 0F B6 80 86 00 00 00 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 0F B6 40 6A 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 74 01 00 00 8B 43 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8D 45 E0 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0A BF 57 00 07 80 E9 44 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B F0 8B D6 58 E8 ?? ?? ?? ?? 83 78 44 00 75 05 E8 ?? ?? ?? ?? 8B 45 1C C7 40 08 04 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 B0 E8 ?? ?? ?? ?? 8D 45 A0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 A0 8D 45 B0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 57 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 90 E8 ?? ?? ?? ?? 8D 45 80 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 80 8D 45 90 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8D 85 60 FF FF FF BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 95 60 FF FF FF 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 4C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 60 FF FF FF 8B 15 ?? ?? ?? ?? B9 0A 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C7 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_30_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_3 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38297_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37937_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38013_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38139_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38258_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38266_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38279_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37827_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38516_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38525_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38653_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38689_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38710_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38742_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38763_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38781_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37246_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36664_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36666_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36727_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36733_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36933_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36937_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37164_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37180_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37182_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38802_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37248_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37478_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37689_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37715_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37738_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37810_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_37814_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40221_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40014_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40054_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40092_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40109_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40134_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40142_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40173_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40009_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40246_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40248_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40355_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40404_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40665_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40821_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40843_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40876_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_40898_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41044_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39590_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38821_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_38997_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39032_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39041_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39230_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_84 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39244_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39362_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39657_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39688_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39711_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39753_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39865_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39944_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34858_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34368_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34487_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34517_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34554_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34586_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34690_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34750_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34781_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34820_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34854_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34302_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34862_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34981_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_94 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34995_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35013_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35133_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35149_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35180_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35255_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35257_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33859_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33312_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33324_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33421_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33435_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33470_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33496_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33514_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33840_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33851_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35259_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33864_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34029_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_34060_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35704_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35980_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36010_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36012_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36080_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36090_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36115_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36142_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35601_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36215_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36300_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36308_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36320_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36371_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36481_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36520_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36527_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36544_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36571_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35358_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35261_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35265_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35509_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_35564_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55854_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55665_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55673_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55744_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55758_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55816_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55177_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_56967_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57250_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_52004_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_52054_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_52193_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_52195_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_54006_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_54726_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_54740_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_54856_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_54939_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55145_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_64247_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60444_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60496_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60725_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_92 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60789_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60831_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_61052_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_61160_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_61206_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_64155_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_92 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60442_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_61 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_64264_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_64304_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_64339_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_65468_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66235_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66263_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66307_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66309_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66547_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66611_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_66613_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57499_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57804_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57879_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57904_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57910_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_57929_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_58275_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_58482_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_58859_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_58881_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59538_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_18 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59604_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59614_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59629_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59693_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59803_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59805_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_59848_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60037_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60337_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_13 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_60339_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43778_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43091_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_221 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43103_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43278_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43309_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43734_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_43757_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_42768_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_44454_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_17 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_44466_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_44538_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_44644_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_12 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_45002_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_45004_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_45953_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46293_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41051_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41172_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41189_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41195_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41206_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41212_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41223_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41231_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46808_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41463_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41476_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41546_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41579_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_41780_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_42005_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_42563_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50409_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50067_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50136_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50138_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50201_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50396_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50399_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50065_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50459_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50639_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50688_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50690_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_51279_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_51383_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_83 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_51782_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_72 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_51792_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46811_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46929_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46945_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46960_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_47908_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_47910_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_47929_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_47994_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_47997_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_48028_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_48030_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33217_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_48180_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_48599_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_22 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_48984_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_91 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_49058_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_49326_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_49328_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_49373_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22737_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_20045_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_22 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_20480_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_20503_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_21807_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_21946_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22368_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22595_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22712_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19157_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22802_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_22826_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23050_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23203_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23396_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_64 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23398_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23433_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16543_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_81 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16555_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16903_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17062_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17092_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17401_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17458_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17581_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17635_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17902_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_33 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_17986_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23438_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18065_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18078_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18097_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18112_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18131_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18183_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18293_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_18992_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_94 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19126_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_19133_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24746_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24550_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24553_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24575_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24591_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24657_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24683_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24720_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24724_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24548_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24779_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24879_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24899_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24910_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24916_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24983_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24997_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25010_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25122_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25138_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25213_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23445_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23529_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23531_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23544_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23726_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23827_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23838_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24218_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_51 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24319_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24526_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24544_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_24546_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8235_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5015_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5044_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5046_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5049_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_5051_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7177_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7214_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_7302_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_31 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3601_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8237_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8528_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_8686_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_9828_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10082_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10163_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10209_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10517_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1894_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_90_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1315_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_51 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1337_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1443_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1447_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1458_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10530_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2005_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2198_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2200_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2327_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_12 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2664_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_2982_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3011_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3087_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3222_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14670_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14737_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14764_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_74 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14875_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_43 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15116_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15120_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15250_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15324_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15490_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_51 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15578_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14550_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_12 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15684_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15735_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15742_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15759_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15768_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16154_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16259_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13529_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_61 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10613_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10615_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10633_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_10635_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11081_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11371_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11414_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11525_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11548_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11589_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_12376_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25217_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13659_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_91 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13699_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13975_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13977_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14178_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14295_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14298_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14398_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14474_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30234_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29939_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29951_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29979_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30089_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30113_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30131_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30148_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30175_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30225_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29931_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30283_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30591_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30607_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30609_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29051_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29141_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29196_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29233_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29336_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_41 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29612_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29641_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29643_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29711_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29721_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29746_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29773_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31899_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_36 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31563_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31611_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31627_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31834_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_02 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31852_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31897_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31559_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31923_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31929_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32087_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32178_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32646_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32823_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33034_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33159_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33192_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33203_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30922_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30934_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30948_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_30965_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31031_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31089_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31111_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31144_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31244_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31264_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31270_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31338_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31350_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31352_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31464_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31480_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31555_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26500_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26677_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26888_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27013_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27046_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27057_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27071_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27078_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27228_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26023_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27286_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27540_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27551_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27559_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27733_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27764_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25633_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25221_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25269_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25285_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25493_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_02 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25594_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25596_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25624_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25699_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_11 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25701_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_36 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25725_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25731_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25778_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_21 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25932_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28940_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_7 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28750_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28766_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28797_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28872_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_8 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28874_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28882_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28747_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28946_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28415_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_01 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27965_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28006_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28065_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28072_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28215_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_6 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28245_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_9 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28282_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_4 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28311_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28475_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28506_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28545_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_5 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28579_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_2 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28624_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_28744_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_32 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_31_0 {
	meta:
		name = "ABAccessibility"
		size = 8
		refs = "0002 _DV_3"
		altNames = "ActnPopup ApacheHTTP ApacheTwoHTTP AspTlb AutoDisp Contnrs DBXDataExpressMetaDataProvider DBXDataStoreMetaDataReader DBXDataStoreMetaDataWriter DBXInformixMetaDataWriter DBXInterbaseMetaDataWriter DBXMessageHandlerJSonClient DBXMetaDataCommandFactory DBXMetaDataReader DBXMsSqlMetaDataWriter DBXMySqlMetaDataWriter DBXReaderTableStorage DBXSybaseASAMetaDataWriter DBXSybaseASEMetaDataWriter DBXTypedTableStorage DSCommonServer DSProd DSTCPServerTransport DSTransport DbgSiteAS IBConnectionBroker IBUpdateSQLEditor IWBaseComponent IWBaseHTMLComponent IWBaseHTMLControl IWBaseWAPComponent IWBaseWAPControl IWCompButton IWCompButton32 IWCompButtonWAP IWCompCheckBoxWAP IWCompCheckbox32 IWCompDynamicChartLegend IWCompEditWAP IWCompFlash IWCompLabel IWCompLabel32 IWCompLabelWAP IWCompMemo IWCompMemo32 IWCompQuickTime IWCompRadioButton IWCompRadioButton32 IWCompRadioButtonWAP IWCompRectangle IWCompRectangle32 IWCompText IWCompText32 IWContainer IWDBExtCtrls32 IWDataModulePool IWDsnFormPreview IWDsnLayoutMgrHTML IWForm IWGridCommon IWHTML40Container IWProgressIndicator IWRegion32 IWScriptEvents IWSessionList IWStreams IWTemplateProcessorHTML IWTemplateProcessorHTML32 IWTemplateProcessorWAP IWVCLComponent IdBaseComponent IdCoder IdCoder00E IdCoder3to4 IdCoderQuotedPrintable IdContainers IdCoreDsnRegister IdCustomHTTPServer IdExceptionCore IdFTPListOutput IdHTTPProxyServer IdHashCRC IdIPAddrMon IdIPMCastClient IdIPWatch IdMailBox IdMappedPOP3 IdMappedPortTCP IdMessageClient IdMessageCollection IdNetworkCalculator IdRawHeaders IdRemoteCMDClient IdReplyFTP IdSASLUserPass IdSNMP IdSNTP IdSchedulerOfThread IdServerInterceptLogBase IdSimpleServer IdSocketHandle IdSocks IdSysLogMessage IdTCPClient IdTCPServer IdThreadComponent IdTime IdTimeServer IdTimeUDP IdTimeUDPServer IdUDPClient IdURI ImgList InBaseComponent InCoder InCoder00E InCoder3to4 InCoderQuotedPrintable InContainers InCustomHTTPServer InExceptionCore InFTPListOutput InHTTPProxyServer InHashCRC InIPAddrMon InIPMCastClient InIPWatch InMailBox InMappedPOP3 InMappedPortTCP InMessageClient InMessageCollection InNetworkCalculator InRawHeaders InRemoteCMDClient InReplyFTP InSASLUserPass InSNMP InSNTP InSchedulerOfThread InServerInterceptLogBase InSimpleServer InSocketHandle InSocks InSysLogMessage InTCPClient InTCPServer InThreadComponent InTime InTimeServer InTimeUDP InTimeUDPServer InUDPClient InURI IndySockTransport IsapiHTTP MPlayer Masks MidasCon PagItems Printers SConnect SOAPAttach SOAPHTTPPasInv SOAPHTTPTrans SWService ScktMain SimpleDS SockAppReg SqlEdit SqlReg TabNotBk TeeDBEdit TeeEdiGene TeeNavigator TeePenDlg WSILIntf XMLBrokr XMLIniFile XMLIntf XMLSchemaTags frmIBFilterFieldEditorU"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1459_0 {
	meta:
		name = "ADOConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1895_0 {
	meta:
		name = "ADOInt"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33_0 {
	meta:
		name = "AccCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "AclAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93_0 {
	meta:
		name = "ActivDbgLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "ActiveX"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "ActnColorMaps"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "ActnCtrls"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1338_0 {
	meta:
		name = "ActnRes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1444_0 {
	meta:
		name = "AdaptReq"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1448_0 {
	meta:
		name = "AddConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1457_0 {
	meta:
		name = "AdoConEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2201_0 {
	meta:
		name = "AscrLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2328_0 {
	meta:
		name = "AutoAdap"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2983_0 {
	meta:
		name = "BDE"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2665_0 {
	meta:
		name = "BandActn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2990_0 {
	meta:
		name = "BrkrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3088_0 {
	meta:
		name = "ButtonGroup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3502_0 {
	meta:
		name = "CGIHTTP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5047_0 {
	meta:
		name = "COMAdmin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3223_0 {
	meta:
		name = "Calendar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3602_0 {
	meta:
		name = "Character"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4912_0 {
	meta:
		name = "ClassRegistry"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5016_0 {
	meta:
		name = "CmAdmCtl"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5045_0 {
	meta:
		name = "ColorGrd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5050_0 {
	meta:
		name = "ComApp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5052_0 {
	meta:
		name = "ComConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7215_0 {
	meta:
		name = "ComStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7217_0 {
	meta:
		name = "ComSvcs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7023_0 {
	meta:
		name = "CommCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7053_0 {
	meta:
		name = "CommDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7178_0 {
	meta:
		name = "CompProd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7219_0 {
	meta:
		name = "Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8236_0 {
	meta:
		name = "CopyPrsr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8238_0 {
	meta:
		name = "CorbCnst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8240_0 {
	meta:
		name = "Cpl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8407_0 {
	meta:
		name = "CtlConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9829_0 {
	meta:
		name = "DBActns"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10056_0 {
	meta:
		name = "DBAdapt"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10083_0 {
	meta:
		name = "DBBdeWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10096_0 {
	meta:
		name = "DBByteBuffer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10164_0 {
	meta:
		name = "DBCGrids"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10210_0 {
	meta:
		name = "DBChart"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10516_0 {
	meta:
		name = "DBClient"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10518_0 {
	meta:
		name = "DBClientActnRes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10531_0 {
	meta:
		name = "DBClientActns"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10614_0 {
	meta:
		name = "DBCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10616_0 {
	meta:
		name = "DBCommonTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10634_0 {
	meta:
		name = "DBConnAdmin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10636_0 {
	meta:
		name = "DBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11082_0 {
	meta:
		name = "DBDrvEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11372_0 {
	meta:
		name = "DBGrids"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11549_0 {
	meta:
		name = "DBOleCtl"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11568_0 {
	meta:
		name = "DBOleEdt"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11590_0 {
	meta:
		name = "DBPlatform"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12286_0 {
	meta:
		name = "DBWeb"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12377_0 {
	meta:
		name = "DBXClient"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13530_0 {
	meta:
		name = "DBXCommonTable"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13660_0 {
	meta:
		name = "DBXCustomDataGenerator"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13849_0 {
	meta:
		name = "DBXDBMetaData"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13976_0 {
	meta:
		name = "DBXDBReaders"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13833_0 {
	meta:
		name = "DBXDb2MetaDataReader"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13841_0 {
	meta:
		name = "DBXDb2MetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14179_0 {
	meta:
		name = "DBXDelegate"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14296_0 {
	meta:
		name = "DBXDynalinkNative"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14299_0 {
	meta:
		name = "DBXEntReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14399_0 {
	meta:
		name = "DBXInformixMetaDataReader"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14475_0 {
	meta:
		name = "DBXInterbaseMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14551_0 {
	meta:
		name = "DBXMessageHandlerCommon"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14614_0 {
	meta:
		name = "DBXMessageHandlerJSonCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14671_0 {
	meta:
		name = "DBXMessageHandlerJSonServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14707_0 {
	meta:
		name = "DBXMessageHandlerServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14738_0 {
	meta:
		name = "DBXMetaDataCommand"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14763_0 {
	meta:
		name = "DBXMetaDataError"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14765_0 {
	meta:
		name = "DBXMetaDataNames"
		size = 8
		refs = "0002 _DV_74"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14876_0 {
	meta:
		name = "DBXMetaDataProvider"
		size = 8
		refs = "0002 _DV_43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15121_0 {
	meta:
		name = "DBXMetaDataUtil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15251_0 {
	meta:
		name = "DBXMetaDataWriter"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15325_0 {
	meta:
		name = "DBXMsSqlMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15491_0 {
	meta:
		name = "DBXMySqlMetaDataReader"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15579_0 {
	meta:
		name = "DBXOracleMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15589_0 {
	meta:
		name = "DBXOracleMetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15685_0 {
	meta:
		name = "DBXPlatform"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15760_0 {
	meta:
		name = "DBXReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15804_0 {
	meta:
		name = "DBXSqlScanner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16039_0 {
	meta:
		name = "DBXStream"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16103_0 {
	meta:
		name = "DBXStreamPlatform"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16050_0 {
	meta:
		name = "DBXStreamer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16155_0 {
	meta:
		name = "DBXSybaseASAMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16237_0 {
	meta:
		name = "DBXSybaseASEMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16260_0 {
	meta:
		name = "DBXTableFactory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16556_0 {
	meta:
		name = "DBXTransport"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15736_0 {
	meta:
		name = "DBXpress"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15743_0 {
	meta:
		name = "DBXpressWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17063_0 {
	meta:
		name = "DDEml"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17636_0 {
	meta:
		name = "DSCommonProxy"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17987_0 {
	meta:
		name = "DSCommonTable"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18012_0 {
	meta:
		name = "DSConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18066_0 {
	meta:
		name = "DSIndy10ServerTransportReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18079_0 {
	meta:
		name = "DSNames"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18098_0 {
	meta:
		name = "DSProviderClientReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18113_0 {
	meta:
		name = "DSProxy"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18132_0 {
	meta:
		name = "DSProxyDesigner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18184_0 {
	meta:
		name = "DSReflect"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18257_0 {
	meta:
		name = "DSServerReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18294_0 {
	meta:
		name = "DSUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18329_0 {
	meta:
		name = "DUnitAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18335_0 {
	meta:
		name = "DUnitMainForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8529_0 {
	meta:
		name = "DataBkr"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8687_0 {
	meta:
		name = "DateUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11112_0 {
	meta:
		name = "DbExcept"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13700_0 {
	meta:
		name = "DbxDataGenerator"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13978_0 {
	meta:
		name = "DbxDefaultTestDriverUnits"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15769_0 {
	meta:
		name = "DbxSocketChannelNative"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15785_0 {
	meta:
		name = "DbxSqlEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16284_0 {
	meta:
		name = "DbxTest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17093_0 {
	meta:
		name = "DelegateForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17400_0 {
	meta:
		name = "DirOutln"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17402_0 {
	meta:
		name = "Dlgs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17582_0 {
	meta:
		name = "DrTable"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18356_0 {
	meta:
		name = "DwmApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18371_0 {
	meta:
		name = "EditChar"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18385_0 {
	meta:
		name = "EncdDecd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18473_0 {
	meta:
		name = "ExtActns"
		size = 8
		refs = "0002 _DV_72"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19127_0 {
	meta:
		name = "FileCtrl"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19158_0 {
	meta:
		name = "FldEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20504_0 {
	meta:
		name = "GIFConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_21947_0 {
	meta:
		name = "GUITestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19858_0 {
	meta:
		name = "Gauges"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20046_0 {
	meta:
		name = "Generics.Collections"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20481_0 {
	meta:
		name = "Generics.Defaults"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_21808_0 {
	meta:
		name = "Grids"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22215_0 {
	meta:
		name = "HTTPApp"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22369_0 {
	meta:
		name = "HTTPD"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22534_0 {
	meta:
		name = "HTTPD2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22596_0 {
	meta:
		name = "HTTPParse"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22681_0 {
	meta:
		name = "HTTPProd"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22685_0 {
	meta:
		name = "HTTPSOAPToPasBind"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22713_0 {
	meta:
		name = "HTTPUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_21977_0 {
	meta:
		name = "HelpIntfs"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22738_0 {
	meta:
		name = "IBBatchMove"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22772_0 {
	meta:
		name = "IBBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22801_0 {
	meta:
		name = "IBConnectionBrokerEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22803_0 {
	meta:
		name = "IBConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22827_0 {
	meta:
		name = "IBCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23397_0 {
	meta:
		name = "IBDBReg"
		size = 8
		refs = "0002 _DV_64"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23399_0 {
	meta:
		name = "IBDCLConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23185_0 {
	meta:
		name = "IBDatabase"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23204_0 {
	meta:
		name = "IBDatabaseEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23267_0 {
	meta:
		name = "IBDatabaseINI"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23244_0 {
	meta:
		name = "IBDatabaseInfo"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23401_0 {
	meta:
		name = "IBErrorCodes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23434_0 {
	meta:
		name = "IBEvents"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23439_0 {
	meta:
		name = "IBEventsEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23443_0 {
	meta:
		name = "IBEvnts"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23446_0 {
	meta:
		name = "IBExternals"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23490_0 {
	meta:
		name = "IBExtract"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23532_0 {
	meta:
		name = "IBFilterSummary"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23534_0 {
	meta:
		name = "IBGeneratorEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23545_0 {
	meta:
		name = "IBHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23588_0 {
	meta:
		name = "IBInstallHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23727_0 {
	meta:
		name = "IBProc32"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23768_0 {
	meta:
		name = "IBQuery"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23776_0 {
	meta:
		name = "IBRestoreEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24219_0 {
	meta:
		name = "IBSQL"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23828_0 {
	meta:
		name = "IBScript"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23839_0 {
	meta:
		name = "IBSecurityEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23851_0 {
	meta:
		name = "IBServiceEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24008_0 {
	meta:
		name = "IBServices"
		size = 8
		refs = "0002 _DV_62"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24320_0 {
	meta:
		name = "IBStoredProc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24402_0 {
	meta:
		name = "IBTable"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24420_0 {
	meta:
		name = "IBTransactionEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24435_0 {
	meta:
		name = "IBUpdateSQL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24525_0 {
	meta:
		name = "IBVclReg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24527_0 {
	meta:
		name = "IBVisualConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24529_0 {
	meta:
		name = "IBXConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24534_0 {
	meta:
		name = "IBXMLHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37479_0 {
	meta:
		name = "IWBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37515_0 {
	meta:
		name = "IWBaseContainerLayout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37581_0 {
	meta:
		name = "IWBaseForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37593_0 {
	meta:
		name = "IWBaseHTML40Component"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37686_0 {
	meta:
		name = "IWBaseHTMLForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37690_0 {
	meta:
		name = "IWBaseHTMLInterfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37709_0 {
	meta:
		name = "IWBaseInterfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37716_0 {
	meta:
		name = "IWBaseLayoutComponent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37739_0 {
	meta:
		name = "IWBaseRenderContext"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37811_0 {
	meta:
		name = "IWBaseWAPForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37815_0 {
	meta:
		name = "IWBaseWAPInterfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38711_0 {
	meta:
		name = "IWCSStdCtrls"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37828_0 {
	meta:
		name = "IWCallBack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37836_0 {
	meta:
		name = "IWClientSideDataset"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37844_0 {
	meta:
		name = "IWClientSideDatasetBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37853_0 {
	meta:
		name = "IWClientSideDatasetDBLink"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37871_0 {
	meta:
		name = "IWCompActiveX"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37938_0 {
	meta:
		name = "IWCompCalendar"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38014_0 {
	meta:
		name = "IWCompEdit"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38033_0 {
	meta:
		name = "IWCompEdit32"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38197_0 {
	meta:
		name = "IWCompListBoxWAP"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38170_0 {
	meta:
		name = "IWCompListbox32"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38267_0 {
	meta:
		name = "IWCompMPEG"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38280_0 {
	meta:
		name = "IWCompObject"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38305_0 {
	meta:
		name = "IWCompProgressBar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38446_0 {
	meta:
		name = "IWCompTimeEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38377_0 {
	meta:
		name = "IWCompress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38494_0 {
	meta:
		name = "IWContainer32Layout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38517_0 {
	meta:
		name = "IWContainerBorderOptions"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38526_0 {
	meta:
		name = "IWContainerLayout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38654_0 {
	meta:
		name = "IWControl"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38674_0 {
	meta:
		name = "IWControl32"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38690_0 {
	meta:
		name = "IWControlWAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38743_0 {
	meta:
		name = "IWDBCommon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38764_0 {
	meta:
		name = "IWDBExtCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38782_0 {
	meta:
		name = "IWDBExtCtrlsWAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38803_0 {
	meta:
		name = "IWDBGrids"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38822_0 {
	meta:
		name = "IWDBGrids32"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38998_0 {
	meta:
		name = "IWDBStdCtrls32"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39033_0 {
	meta:
		name = "IWDBStdCtrlsWAP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39042_0 {
	meta:
		name = "IWDsnAppWizForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39096_0 {
	meta:
		name = "IWDsnColorDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39100_0 {
	meta:
		name = "IWDsnControlAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39103_0 {
	meta:
		name = "IWDsnDesignerDestroyer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39121_0 {
	meta:
		name = "IWDsnFormWizard"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39125_0 {
	meta:
		name = "IWDsnFrameWizard"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39240_0 {
	meta:
		name = "IWDsnScriptEvents"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39245_0 {
	meta:
		name = "IWDsnTabControl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39339_0 {
	meta:
		name = "IWDsnTestWizard"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39363_0 {
	meta:
		name = "IWDsnTreeView"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39570_0 {
	meta:
		name = "IWDsnWizard"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39593_0 {
	meta:
		name = "IWException"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39658_0 {
	meta:
		name = "IWExtCtrls"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39689_0 {
	meta:
		name = "IWExtCtrls32"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39712_0 {
	meta:
		name = "IWExtCtrlsWAP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39754_0 {
	meta:
		name = "IWFileReference"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39771_0 {
	meta:
		name = "IWFont"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39829_0 {
	meta:
		name = "IWForm32"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39843_0 {
	meta:
		name = "IWFormDsn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39863_0 {
	meta:
		name = "IWFormWAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39866_0 {
	meta:
		name = "IWGIF"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39945_0 {
	meta:
		name = "IWGrids"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39980_0 {
	meta:
		name = "IWGrids32"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40010_0 {
	meta:
		name = "IWGridsWAP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40015_0 {
	meta:
		name = "IWHTML32Interfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40043_0 {
	meta:
		name = "IWHTML40Interfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40055_0 {
	meta:
		name = "IWHTMLContainer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40093_0 {
	meta:
		name = "IWHTMLControls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40110_0 {
	meta:
		name = "IWHTMLControls32"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40135_0 {
	meta:
		name = "IWImageList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40183_0 {
	meta:
		name = "IWJQueryWidget"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40174_0 {
	meta:
		name = "IWJpegOptions"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40222_0 {
	meta:
		name = "IWLayoutMgrForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40247_0 {
	meta:
		name = "IWLayoutMgrHTML32"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40249_0 {
	meta:
		name = "IWLayoutMgrHTMLInterface"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40310_0 {
	meta:
		name = "IWMain"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40356_0 {
	meta:
		name = "IWMarkupLanguageTag"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40405_0 {
	meta:
		name = "IWPageForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40414_0 {
	meta:
		name = "IWPageForm32"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40666_0 {
	meta:
		name = "IWRenderContext"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40822_0 {
	meta:
		name = "IWServerControllerBase"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40877_0 {
	meta:
		name = "IWStandAloneServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40899_0 {
	meta:
		name = "IWTemplateProcessing"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41049_0 {
	meta:
		name = "IWTypes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41052_0 {
	meta:
		name = "IWUserSessionBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41075_0 {
	meta:
		name = "IWUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41127_0 {
	meta:
		name = "IWVCLBaseContainer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41171_0 {
	meta:
		name = "IWVCLBaseControl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41173_0 {
	meta:
		name = "IWVCLClasses"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41190_0 {
	meta:
		name = "IWVertFlowLayoutMgr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41207_0 {
	meta:
		name = "IWWAPControls"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41224_0 {
	meta:
		name = "IWWAPRenderContext"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41232_0 {
	meta:
		name = "IWWMLFormLayout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41196_0 {
	meta:
		name = "IWWapContainerLayout"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41213_0 {
	meta:
		name = "IWWapInterfaces"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41238_0 {
	meta:
		name = "IWXHTMLMPFormLayout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41245_0 {
	meta:
		name = "IWXMLTag"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24576_0 {
	meta:
		name = "IdASN1Util"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24545_0 {
	meta:
		name = "IdAboutVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24547_0 {
	meta:
		name = "IdAllAuthentications"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24549_0 {
	meta:
		name = "IdAllFTPListParsers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24551_0 {
	meta:
		name = "IdAllHeaderCoders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24554_0 {
	meta:
		name = "IdAntiFreeze"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24562_0 {
	meta:
		name = "IdAntiFreezeBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24578_0 {
	meta:
		name = "IdAssignedNumbers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24592_0 {
	meta:
		name = "IdAttachment"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24601_0 {
	meta:
		name = "IdAttachmentFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24614_0 {
	meta:
		name = "IdAttachmentMemory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24658_0 {
	meta:
		name = "IdAuthenticationManager"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24684_0 {
	meta:
		name = "IdBlockCipherIntercept"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24721_0 {
	meta:
		name = "IdBuffer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25011_0 {
	meta:
		name = "IdCTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24725_0 {
	meta:
		name = "IdChargenServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24729_0 {
	meta:
		name = "IdChargenUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24747_0 {
	meta:
		name = "IdCmdTCPClient"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24780_0 {
	meta:
		name = "IdCmdTCPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24830_0 {
	meta:
		name = "IdCoderHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24880_0 {
	meta:
		name = "IdCommandHandlers"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24900_0 {
	meta:
		name = "IdCompressionIntercept"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24911_0 {
	meta:
		name = "IdCompressorZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24917_0 {
	meta:
		name = "IdConnectThroughHttpProxy"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24941_0 {
	meta:
		name = "IdContext"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24984_0 {
	meta:
		name = "IdCookie"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24998_0 {
	meta:
		name = "IdCookieManager"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25123_0 {
	meta:
		name = "IdCustomTCPServer"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25139_0 {
	meta:
		name = "IdCustomTransparentProxy"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25245_0 {
	meta:
		name = "IdDICT"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25270_0 {
	meta:
		name = "IdDICTCommon"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25286_0 {
	meta:
		name = "IdDICTServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25494_0 {
	meta:
		name = "IdDNSResolver"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25595_0 {
	meta:
		name = "IdDNSServer"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25210_0 {
	meta:
		name = "IdDateTimeStamp"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25214_0 {
	meta:
		name = "IdDayTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25218_0 {
	meta:
		name = "IdDayTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25222_0 {
	meta:
		name = "IdDayTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25226_0 {
	meta:
		name = "IdDayTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25290_0 {
	meta:
		name = "IdDiscardServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25293_0 {
	meta:
		name = "IdDiscardUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25597_0 {
	meta:
		name = "IdDsnCoreResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25625_0 {
	meta:
		name = "IdDsnPropEdBindingVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25632_0 {
	meta:
		name = "IdDsnRegister"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25634_0 {
	meta:
		name = "IdDsnResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25651_0 {
	meta:
		name = "IdDsnSASLListEditorFormVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25691_0 {
	meta:
		name = "IdEMailAddress"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25655_0 {
	meta:
		name = "IdEcho"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25659_0 {
	meta:
		name = "IdEchoServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25663_0 {
	meta:
		name = "IdEchoUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25667_0 {
	meta:
		name = "IdEchoUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25700_0 {
	meta:
		name = "IdException"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25726_0 {
	meta:
		name = "IdExplicitTLSClientServerBase"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25779_0 {
	meta:
		name = "IdFSP"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25913_0 {
	meta:
		name = "IdFTP"
		size = 8
		refs = "0002 _DV_82"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25933_0 {
	meta:
		name = "IdFTPBaseFileSystem"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26013_0 {
	meta:
		name = "IdFTPCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26024_0 {
	meta:
		name = "IdFTPList"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26501_0 {
	meta:
		name = "IdFTPListTypes"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26678_0 {
	meta:
		name = "IdFTPServerContextBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25732_0 {
	meta:
		name = "IdFinger"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25736_0 {
	meta:
		name = "IdFingerServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26889_0 {
	meta:
		name = "IdGlobalCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27006_0 {
	meta:
		name = "IdGopher"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27008_0 {
	meta:
		name = "IdGopherConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27014_0 {
	meta:
		name = "IdGopherServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27132_0 {
	meta:
		name = "IdHMACMD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27196_0 {
	meta:
		name = "IdHTTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27229_0 {
	meta:
		name = "IdHTTPHeaderInfo"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27243_0 {
	meta:
		name = "IdHTTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27047_0 {
	meta:
		name = "IdHash"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27058_0 {
	meta:
		name = "IdHashElf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27072_0 {
	meta:
		name = "IdHashMessageDigest"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27079_0 {
	meta:
		name = "IdHashSHA1"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27120_0 {
	meta:
		name = "IdHeaderList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27469_0 {
	meta:
		name = "IdIMAP4"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27541_0 {
	meta:
		name = "IdIMAP4Server"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27651_0 {
	meta:
		name = "IdIOHandler"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27672_0 {
	meta:
		name = "IdIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27695_0 {
	meta:
		name = "IdIOHandlerStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27707_0 {
	meta:
		name = "IdIPAddress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27734_0 {
	meta:
		name = "IdIPMCastBase"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27765_0 {
	meta:
		name = "IdIPMCastServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27897_0 {
	meta:
		name = "IdIRC"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27269_0 {
	meta:
		name = "IdIcmpClient"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27280_0 {
	meta:
		name = "IdIdent"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27287_0 {
	meta:
		name = "IdIdentServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27552_0 {
	meta:
		name = "IdIntercept"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27560_0 {
	meta:
		name = "IdInterceptSimLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27565_0 {
	meta:
		name = "IdInterceptThrottler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27945_0 {
	meta:
		name = "IdIrcServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28007_0 {
	meta:
		name = "IdLPR"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27966_0 {
	meta:
		name = "IdLogDebug"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27971_0 {
	meta:
		name = "IdLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27981_0 {
	meta:
		name = "IdLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27988_0 {
	meta:
		name = "IdLogStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28031_0 {
	meta:
		name = "IdMappedFTP"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28066_0 {
	meta:
		name = "IdMappedPortUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28073_0 {
	meta:
		name = "IdMappedTelnet"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28124_0 {
	meta:
		name = "IdMessage"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28149_0 {
	meta:
		name = "IdMessageBuilder"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28198_0 {
	meta:
		name = "IdMessageCoder"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28283_0 {
	meta:
		name = "IdMessageParts"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28312_0 {
	meta:
		name = "IdMultipartFormData"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28416_0 {
	meta:
		name = "IdNNTP"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28476_0 {
	meta:
		name = "IdNNTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28487_0 {
	meta:
		name = "IdNTLM"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28507_0 {
	meta:
		name = "IdOSFileName"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28522_0 {
	meta:
		name = "IdOTPCalculator"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28546_0 {
	meta:
		name = "IdPOP3"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28576_0 {
	meta:
		name = "IdPOP3Server"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28588_0 {
	meta:
		name = "IdQOTDUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28593_0 {
	meta:
		name = "IdQOTDUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28580_0 {
	meta:
		name = "IdQotd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28584_0 {
	meta:
		name = "IdQotdServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28891_0 {
	meta:
		name = "IdRSH"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28895_0 {
	meta:
		name = "IdRSHServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28607_0 {
	meta:
		name = "IdRawBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28609_0 {
	meta:
		name = "IdRawClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28625_0 {
	meta:
		name = "IdRawFunctions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28748_0 {
	meta:
		name = "IdRegister"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28751_0 {
	meta:
		name = "IdRegisterCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28767_0 {
	meta:
		name = "IdRemoteCMDServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28798_0 {
	meta:
		name = "IdReply"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28824_0 {
	meta:
		name = "IdReplyIMAP4"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28839_0 {
	meta:
		name = "IdReplyPOP3"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28852_0 {
	meta:
		name = "IdReplyRFC"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28873_0 {
	meta:
		name = "IdReplySMTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28875_0 {
	meta:
		name = "IdResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28877_0 {
	meta:
		name = "IdResourceStringsCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28879_0 {
	meta:
		name = "IdResourceStringsProtocols"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28883_0 {
	meta:
		name = "IdRexec"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28887_0 {
	meta:
		name = "IdRexecServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28912_0 {
	meta:
		name = "IdSASLAnonymous"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28930_0 {
	meta:
		name = "IdSASLCollection"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28941_0 {
	meta:
		name = "IdSASLDigest"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28947_0 {
	meta:
		name = "IdSASLExternal"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28953_0 {
	meta:
		name = "IdSASLLogin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28960_0 {
	meta:
		name = "IdSASLOTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28965_0 {
	meta:
		name = "IdSASLPlain"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28971_0 {
	meta:
		name = "IdSASLSKey"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28983_0 {
	meta:
		name = "IdSASL_CRAMBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28987_0 {
	meta:
		name = "IdSASL_CRAM_MD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28991_0 {
	meta:
		name = "IdSASL_CRAM_SHA1"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29094_0 {
	meta:
		name = "IdSMTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29114_0 {
	meta:
		name = "IdSMTPBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29142_0 {
	meta:
		name = "IdSMTPRelay"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29197_0 {
	meta:
		name = "IdSMTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29234_0 {
	meta:
		name = "IdSNPP"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29001_0 {
	meta:
		name = "IdScheduler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29015_0 {
	meta:
		name = "IdSchedulerOfThreadDefault"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29024_0 {
	meta:
		name = "IdSchedulerOfThreadPool"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29052_0 {
	meta:
		name = "IdServerIOHandler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29057_0 {
	meta:
		name = "IdServerIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29061_0 {
	meta:
		name = "IdServerIOHandlerStack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29039_0 {
	meta:
		name = "IdServerInterceptLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29044_0 {
	meta:
		name = "IdServerInterceptLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29337_0 {
	meta:
		name = "IdSocksServer"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29642_0 {
	meta:
		name = "IdStackBSDBase"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29644_0 {
	meta:
		name = "IdStackConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29707_0 {
	meta:
		name = "IdStream"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29712_0 {
	meta:
		name = "IdStreamVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29722_0 {
	meta:
		name = "IdStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29747_0 {
	meta:
		name = "IdStruct"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29767_0 {
	meta:
		name = "IdSync"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29774_0 {
	meta:
		name = "IdSysLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29818_0 {
	meta:
		name = "IdSysLogServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29822_0 {
	meta:
		name = "IdSystat"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29826_0 {
	meta:
		name = "IdSystatServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29830_0 {
	meta:
		name = "IdSystatUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29835_0 {
	meta:
		name = "IdSystatUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29907_0 {
	meta:
		name = "IdTCPConnection"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29917_0 {
	meta:
		name = "IdTCPStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29847_0 {
	meta:
		name = "IdTask"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29932_0 {
	meta:
		name = "IdTelnet"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29940_0 {
	meta:
		name = "IdTelnetServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29952_0 {
	meta:
		name = "IdText"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30090_0 {
	meta:
		name = "IdThreadSafe"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30114_0 {
	meta:
		name = "IdTraceRoute"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30125_0 {
	meta:
		name = "IdTrivialFTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30132_0 {
	meta:
		name = "IdTrivialFTPBase"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30149_0 {
	meta:
		name = "IdTrivialFTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30176_0 {
	meta:
		name = "IdUDPBase"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30223_0 {
	meta:
		name = "IdUDPServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30226_0 {
	meta:
		name = "IdUnixTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30229_0 {
	meta:
		name = "IdUnixTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30232_0 {
	meta:
		name = "IdUnixTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30235_0 {
	meta:
		name = "IdUnixTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30282_0 {
	meta:
		name = "IdUserAccounts"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30284_0 {
	meta:
		name = "IdUserPassProvider"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30343_0 {
	meta:
		name = "IdVCard"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30361_0 {
	meta:
		name = "IdWebDAV"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30369_0 {
	meta:
		name = "IdWhoIsServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30365_0 {
	meta:
		name = "IdWhois"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30544_0 {
	meta:
		name = "IdWship6"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30546_0 {
	meta:
		name = "IdYarn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30592_0 {
	meta:
		name = "IdZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30608_0 {
	meta:
		name = "IdZLibCompressorBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30610_0 {
	meta:
		name = "IdZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30672_0 {
	meta:
		name = "IdZLibHeaders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30736_0 {
	meta:
		name = "ImageHlp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30894_0 {
	meta:
		name = "Imm"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30949_0 {
	meta:
		name = "InASN1Util"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30923_0 {
	meta:
		name = "InAllAuthentications"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30925_0 {
	meta:
		name = "InAllFTPListParsers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30927_0 {
	meta:
		name = "InAllHeaderCoders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30935_0 {
	meta:
		name = "InAntiFreezeBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30951_0 {
	meta:
		name = "InAssignedNumbers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30966_0 {
	meta:
		name = "InAttachment"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30988_0 {
	meta:
		name = "InAttachmentMemory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31032_0 {
	meta:
		name = "InAuthenticationManager"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31086_0 {
	meta:
		name = "InBuffer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31353_0 {
	meta:
		name = "InCTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31090_0 {
	meta:
		name = "InChargenServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31094_0 {
	meta:
		name = "InChargenUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31112_0 {
	meta:
		name = "InCmdTCPClient"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31145_0 {
	meta:
		name = "InCmdTCPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31195_0 {
	meta:
		name = "InCoderHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31245_0 {
	meta:
		name = "InCommandHandlers"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31265_0 {
	meta:
		name = "InCompressionIntercept"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31271_0 {
	meta:
		name = "InConnectThroughHttpProxy"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31295_0 {
	meta:
		name = "InContext"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31339_0 {
	meta:
		name = "InCookie"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31351_0 {
	meta:
		name = "InCookieManager"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31465_0 {
	meta:
		name = "InCustomTCPServer"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31481_0 {
	meta:
		name = "InCustomTransparentProxy"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31587_0 {
	meta:
		name = "InDICT"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31612_0 {
	meta:
		name = "InDICTCommon"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31628_0 {
	meta:
		name = "InDICTServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31835_0 {
	meta:
		name = "InDNSResolver"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31552_0 {
	meta:
		name = "InDateTimeStamp"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31556_0 {
	meta:
		name = "InDayTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31560_0 {
	meta:
		name = "InDayTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31564_0 {
	meta:
		name = "InDayTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31568_0 {
	meta:
		name = "InDayTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31632_0 {
	meta:
		name = "InDiscardServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31635_0 {
	meta:
		name = "InDiscardUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31889_0 {
	meta:
		name = "InEMailAddress"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31853_0 {
	meta:
		name = "InEcho"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31857_0 {
	meta:
		name = "InEchoServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31861_0 {
	meta:
		name = "InEchoUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31865_0 {
	meta:
		name = "InEchoUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31898_0 {
	meta:
		name = "InException"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31924_0 {
	meta:
		name = "InExplicitTLSClientServerBase"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32068_0 {
	meta:
		name = "InFTP"
		size = 8
		refs = "0002 _DV_82"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32088_0 {
	meta:
		name = "InFTPBaseFileSystem"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32168_0 {
	meta:
		name = "InFTPCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32179_0 {
	meta:
		name = "InFTPList"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32647_0 {
	meta:
		name = "InFTPListTypes"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32824_0 {
	meta:
		name = "InFTPServerContextBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31930_0 {
	meta:
		name = "InFinger"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31934_0 {
	meta:
		name = "InFingerServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33035_0 {
	meta:
		name = "InGlobalCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33152_0 {
	meta:
		name = "InGopher"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33154_0 {
	meta:
		name = "InGopherConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33160_0 {
	meta:
		name = "InGopherServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33313_0 {
	meta:
		name = "InHL7"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33325_0 {
	meta:
		name = "InHMACMD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33389_0 {
	meta:
		name = "InHTTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33422_0 {
	meta:
		name = "InHTTPHeaderInfo"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33436_0 {
	meta:
		name = "InHTTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33471_0 {
	meta:
		name = "InHTTPWebBrokerBridge"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33193_0 {
	meta:
		name = "InHash"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33204_0 {
	meta:
		name = "InHashElf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33218_0 {
	meta:
		name = "InHashMessageDigest"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33225_0 {
	meta:
		name = "InHashSHA1"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33261_0 {
	meta:
		name = "InHeaderList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33769_0 {
	meta:
		name = "InIMAP4"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33841_0 {
	meta:
		name = "InIMAP4Server"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33972_0 {
	meta:
		name = "InIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33995_0 {
	meta:
		name = "InIOHandlerStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34007_0 {
	meta:
		name = "InIPAddress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34030_0 {
	meta:
		name = "InIPMCastBase"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34061_0 {
	meta:
		name = "InIPMCastServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34193_0 {
	meta:
		name = "InIRC"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34241_0 {
	meta:
		name = "InIRCServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33497_0 {
	meta:
		name = "InIcmpClient"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33508_0 {
	meta:
		name = "InIdent"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33515_0 {
	meta:
		name = "InIdentServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33852_0 {
	meta:
		name = "InIntercept"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33860_0 {
	meta:
		name = "InInterceptSimLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33865_0 {
	meta:
		name = "InInterceptThrottler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34303_0 {
	meta:
		name = "InLPR"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34262_0 {
	meta:
		name = "InLogDebug"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34267_0 {
	meta:
		name = "InLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34277_0 {
	meta:
		name = "InLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34284_0 {
	meta:
		name = "InLogStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34327_0 {
	meta:
		name = "InMappedFTP"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34362_0 {
	meta:
		name = "InMappedPortUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34369_0 {
	meta:
		name = "InMappedTelnet"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34420_0 {
	meta:
		name = "InMessage"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34555_0 {
	meta:
		name = "InMessageParts"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34587_0 {
	meta:
		name = "InMultipartFormData"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34691_0 {
	meta:
		name = "InNNTP"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34751_0 {
	meta:
		name = "InNNTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34762_0 {
	meta:
		name = "InNTLM"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34782_0 {
	meta:
		name = "InOSFileName"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34797_0 {
	meta:
		name = "InOTPCalculator"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34821_0 {
	meta:
		name = "InPOP3"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34851_0 {
	meta:
		name = "InPOP3Server"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34855_0 {
	meta:
		name = "InQotd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34859_0 {
	meta:
		name = "InQotdServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34863_0 {
	meta:
		name = "InQotdUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34868_0 {
	meta:
		name = "InQotdUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35274_0 {
	meta:
		name = "InRSH"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35278_0 {
	meta:
		name = "InRSHServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34996_0 {
	meta:
		name = "InRawBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34998_0 {
	meta:
		name = "InRawClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35014_0 {
	meta:
		name = "InRawFunctions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35150_0 {
	meta:
		name = "InRemoteCMDServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35181_0 {
	meta:
		name = "InReply"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35207_0 {
	meta:
		name = "InReplyIMAP4"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35222_0 {
	meta:
		name = "InReplyPOP3"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35235_0 {
	meta:
		name = "InReplyRFC"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35256_0 {
	meta:
		name = "InReplySMTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35258_0 {
	meta:
		name = "InResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35260_0 {
	meta:
		name = "InResourceStringsCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35262_0 {
	meta:
		name = "InResourceStringsProtocols"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35266_0 {
	meta:
		name = "InRexec"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35270_0 {
	meta:
		name = "InRexecServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35295_0 {
	meta:
		name = "InSASLAnonymous"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35313_0 {
	meta:
		name = "InSASLCollection"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35319_0 {
	meta:
		name = "InSASLExternal"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35325_0 {
	meta:
		name = "InSASLLogin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35332_0 {
	meta:
		name = "InSASLOTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35337_0 {
	meta:
		name = "InSASLPlain"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35343_0 {
	meta:
		name = "InSASLSKey"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35355_0 {
	meta:
		name = "InSASL_CRAMBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35359_0 {
	meta:
		name = "InSASL_CRAM_MD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35462_0 {
	meta:
		name = "InSMTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35482_0 {
	meta:
		name = "InSMTPBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35510_0 {
	meta:
		name = "InSMTPRelay"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35565_0 {
	meta:
		name = "InSMTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35602_0 {
	meta:
		name = "InSNPP"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35369_0 {
	meta:
		name = "InScheduler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35383_0 {
	meta:
		name = "InSchedulerOfThreadDefault"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35392_0 {
	meta:
		name = "InSchedulerOfThreadPool"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35420_0 {
	meta:
		name = "InServerIOHandler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35425_0 {
	meta:
		name = "InServerIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35429_0 {
	meta:
		name = "InServerIOHandlerStack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35407_0 {
	meta:
		name = "InServerInterceptLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35412_0 {
	meta:
		name = "InServerInterceptLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35705_0 {
	meta:
		name = "InSocksServer"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36011_0 {
	meta:
		name = "InStackBSDBase"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36013_0 {
	meta:
		name = "InStackConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36076_0 {
	meta:
		name = "InStream"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36081_0 {
	meta:
		name = "InStreamVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36091_0 {
	meta:
		name = "InStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36116_0 {
	meta:
		name = "InStruct"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36143_0 {
	meta:
		name = "InSysLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36187_0 {
	meta:
		name = "InSysLogServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36191_0 {
	meta:
		name = "InSystat"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36195_0 {
	meta:
		name = "InSystatServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36199_0 {
	meta:
		name = "InSystatUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36204_0 {
	meta:
		name = "InSystatUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36276_0 {
	meta:
		name = "InTCPConnection"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36286_0 {
	meta:
		name = "InTCPStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36216_0 {
	meta:
		name = "InTask"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36301_0 {
	meta:
		name = "InTelnet"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36309_0 {
	meta:
		name = "InTelnetServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36482_0 {
	meta:
		name = "InThreadSafe"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36521_0 {
	meta:
		name = "InTrivialFTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36528_0 {
	meta:
		name = "InTrivialFTPBase"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36545_0 {
	meta:
		name = "InTrivialFTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36572_0 {
	meta:
		name = "InUDPBase"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36619_0 {
	meta:
		name = "InUDPServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36665_0 {
	meta:
		name = "InUserAccounts"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36667_0 {
	meta:
		name = "InUserPassProvider"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36726_0 {
	meta:
		name = "InVCard"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36938_0 {
	meta:
		name = "InWhois"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36942_0 {
	meta:
		name = "InWhoisServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37119_0 {
	meta:
		name = "InYarn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37165_0 {
	meta:
		name = "InZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37181_0 {
	meta:
		name = "InZLibCompressorBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37183_0 {
	meta:
		name = "InZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37245_0 {
	meta:
		name = "InZLibHeaders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33587_0 {
	meta:
		name = "IniFiles"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36344_0 {
	meta:
		name = "IntfInfo"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36728_0 {
	meta:
		name = "InvConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36934_0 {
	meta:
		name = "InvRules"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36734_0 {
	meta:
		name = "Invoker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37247_0 {
	meta:
		name = "Isapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37249_0 {
	meta:
		name = "Isapi2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41247_0 {
	meta:
		name = "JConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41477_0 {
	meta:
		name = "LZExpand"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41464_0 {
	meta:
		name = "ListActns"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41781_0 {
	meta:
		name = "MConnect"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42769_0 {
	meta:
		name = "MMSystem"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43092_0 {
	meta:
		name = "MSHTML"
		size = 8
		refs = "0002 _DV_221"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41492_0 {
	meta:
		name = "Mapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41547_0 {
	meta:
		name = "Mask"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41580_0 {
	meta:
		name = "MaskUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41729_0 {
	meta:
		name = "Math"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42006_0 {
	meta:
		name = "Messages"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42125_0 {
	meta:
		name = "MidComp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42127_0 {
	meta:
		name = "MidConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42564_0 {
	meta:
		name = "MidProd"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42008_0 {
	meta:
		name = "Midas"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43300_0 {
	meta:
		name = "MtsRdm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43279_0 {
	meta:
		name = "Mtsobj"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43310_0 {
	meta:
		name = "Mtx"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43325_0 {
	meta:
		name = "Nb30"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43361_0 {
	meta:
		name = "Ns30Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43397_0 {
	meta:
		name = "Ns35Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43433_0 {
	meta:
		name = "Ns36Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43710_0 {
	meta:
		name = "Nsapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45062_0 {
	meta:
		name = "OPConvert"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43735_0 {
	meta:
		name = "ObjAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43758_0 {
	meta:
		name = "ObjBrkr"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43779_0 {
	meta:
		name = "ObjComAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44455_0 {
	meta:
		name = "Ole2"
		size = 8
		refs = "0002 _DV_17"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44539_0 {
	meta:
		name = "OleConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44645_0 {
	meta:
		name = "OleCtl"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45005_0 {
	meta:
		name = "OleDB"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45032_0 {
	meta:
		name = "OleDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45954_0 {
	meta:
		name = "Outline"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46294_0 {
	meta:
		name = "PenWin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46557_0 {
	meta:
		name = "PrivateHeap"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46783_0 {
	meta:
		name = "Provider"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46809_0 {
	meta:
		name = "PsAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48031_0 {
	meta:
		name = "RTLConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46930_0 {
	meta:
		name = "RegStr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46928_0 {
	meta:
		name = "Registry"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46946_0 {
	meta:
		name = "ReqFiles"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46961_0 {
	meta:
		name = "ReqImpl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47832_0 {
	meta:
		name = "RibbonActnCtrls"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47911_0 {
	meta:
		name = "RibbonConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47930_0 {
	meta:
		name = "RibbonGalleryBar"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47995_0 {
	meta:
		name = "RibbonStyleActnCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47998_0 {
	meta:
		name = "RichEdit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48029_0 {
	meta:
		name = "Rio"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49327_0 {
	meta:
		name = "SHDocVw"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49563_0 {
	meta:
		name = "SHFolder"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50139_0 {
	meta:
		name = "SMINTF"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50202_0 {
	meta:
		name = "SOAPAttachIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50241_0 {
	meta:
		name = "SOAPConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50280_0 {
	meta:
		name = "SOAPDm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50291_0 {
	meta:
		name = "SOAPDomConv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50297_0 {
	meta:
		name = "SOAPEnv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50318_0 {
	meta:
		name = "SOAPHTTPClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50323_0 {
	meta:
		name = "SOAPHTTPDisp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50397_0 {
	meta:
		name = "SOAPLinked"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50410_0 {
	meta:
		name = "SOAPPasInv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52086_0 {
	meta:
		name = "SWStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48033_0 {
	meta:
		name = "ScktCnst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48181_0 {
	meta:
		name = "ScktComp"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48505_0 {
	meta:
		name = "ScreenTips"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48600_0 {
	meta:
		name = "ScrptMgr"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48985_0 {
	meta:
		name = "Series"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50048_0 {
	meta:
		name = "ShLwApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49059_0 {
	meta:
		name = "ShadowWnd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49374_0 {
	meta:
		name = "ShellAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49329_0 {
	meta:
		name = "ShellAnimations"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49376_0 {
	meta:
		name = "ShellConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49597_0 {
	meta:
		name = "ShlObj"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50066_0 {
	meta:
		name = "SimpleDSReg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50088_0 {
	meta:
		name = "SiteConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50137_0 {
	meta:
		name = "SiteProd"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50460_0 {
	meta:
		name = "SockAppNotify"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50594_0 {
	meta:
		name = "SockHTTP"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50617_0 {
	meta:
		name = "SockRequestInterpreter"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50640_0 {
	meta:
		name = "SockTransport"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50689_0 {
	meta:
		name = "Spin"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50691_0 {
	meta:
		name = "SqlConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51280_0 {
	meta:
		name = "StdActnMenus"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51384_0 {
	meta:
		name = "StdActns"
		size = 8
		refs = "0002 _DV_83"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51783_0 {
	meta:
		name = "StdCtrls"
		size = 8
		refs = "0002 _DV_72"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51793_0 {
	meta:
		name = "StdVCL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51856_0 {
	meta:
		name = "StrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51925_0 {
	meta:
		name = "SvrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52003_0 {
	meta:
		name = "SvrHTTPIndy"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52005_0 {
	meta:
		name = "SvrInfoConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52055_0 {
	meta:
		name = "SvrSockRequest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52196_0 {
	meta:
		name = "SysConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52230_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54007_0 {
	meta:
		name = "TConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53986_0 {
	meta:
		name = "Tabs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57475_0 {
	meta:
		name = "TeExport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54573_0 {
	meta:
		name = "TeeAxMaxMin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54568_0 {
	meta:
		name = "TeeAxisIncr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54645_0 {
	meta:
		name = "TeeBrushDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54727_0 {
	meta:
		name = "TeeChartGrid"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54788_0 {
	meta:
		name = "TeeCustomShapeEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54857_0 {
	meta:
		name = "TeeData"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54940_0 {
	meta:
		name = "TeeDraw3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54967_0 {
	meta:
		name = "TeeEdi3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55041_0 {
	meta:
		name = "TeeEdiAxis"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55062_0 {
	meta:
		name = "TeeEdiFont"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55146_0 {
	meta:
		name = "TeeEdiGrad"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55178_0 {
	meta:
		name = "TeeEdiLege"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55194_0 {
	meta:
		name = "TeeEdiPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55218_0 {
	meta:
		name = "TeeEdiPane"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55306_0 {
	meta:
		name = "TeeEdiSeri"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55415_0 {
	meta:
		name = "TeeEdiTitl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55438_0 {
	meta:
		name = "TeeEdiWall"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55666_0 {
	meta:
		name = "TeeFiltersEditor"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55690_0 {
	meta:
		name = "TeeFormatting"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55716_0 {
	meta:
		name = "TeeFuncEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55759_0 {
	meta:
		name = "TeeGalleryAlternate"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55944_0 {
	meta:
		name = "TeeLisB"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56932_0 {
	meta:
		name = "TeePrevi"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56968_0 {
	meta:
		name = "TeePreviewPanel"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57251_0 {
	meta:
		name = "TeeSelectList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57269_0 {
	meta:
		name = "TeeShadowEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57346_0 {
	meta:
		name = "TeeSourceEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57434_0 {
	meta:
		name = "TeeSymbolEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57500_0 {
	meta:
		name = "TestExtensions"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57754_0 {
	meta:
		name = "TextTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57805_0 {
	meta:
		name = "ThemedActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57857_0 {
	meta:
		name = "Themes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57880_0 {
	meta:
		name = "TlHelp32"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57905_0 {
	meta:
		name = "ToolWin"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57911_0 {
	meta:
		name = "TriggerTest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58072_0 {
	meta:
		name = "TypInfo"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57930_0 {
	meta:
		name = "Types"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58078_0 {
	meta:
		name = "UDDIHelper"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58151_0 {
	meta:
		name = "UrlMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58882_0 {
	meta:
		name = "VDBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58276_0 {
	meta:
		name = "ValEdit"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58483_0 {
	meta:
		name = "VarHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64156_0 {
	meta:
		name = "WSDLBind"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64168_0 {
	meta:
		name = "WSDLIntf"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64248_0 {
	meta:
		name = "WSDLItems"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64265_0 {
	meta:
		name = "WSDLNode"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58884_0 {
	meta:
		name = "WbmConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59605_0 {
	meta:
		name = "WebAuto"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59615_0 {
	meta:
		name = "WebBroker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59628_0 {
	meta:
		name = "WebBrokerSOAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59630_0 {
	meta:
		name = "WebCat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59694_0 {
	meta:
		name = "WebCntxt"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59804_0 {
	meta:
		name = "WebComp"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59806_0 {
	meta:
		name = "WebConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59849_0 {
	meta:
		name = "WebContnrs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60003_0 {
	meta:
		name = "WebDisp"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60038_0 {
	meta:
		name = "WebFact"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60338_0 {
	meta:
		name = "WebForm"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60340_0 {
	meta:
		name = "WebLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60443_0 {
	meta:
		name = "WebModu"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60445_0 {
	meta:
		name = "WebNode"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60726_0 {
	meta:
		name = "WebScript_TLB"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60790_0 {
	meta:
		name = "WebServExp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60832_0 {
	meta:
		name = "WebSess"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61026_0 {
	meta:
		name = "WebSnapObjs"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61053_0 {
	meta:
		name = "WebUsers"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61207_0 {
	meta:
		name = "WideStrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63774_0 {
	meta:
		name = "WinInet"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63837_0 {
	meta:
		name = "WinSock"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63996_0 {
	meta:
		name = "WinSpool"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64048_0 {
	meta:
		name = "WinSvc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65469_0 {
	meta:
		name = "XMLBindGen"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65534_0 {
	meta:
		name = "XMLConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65780_0 {
	meta:
		name = "XMLDoc"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66187_0 {
	meta:
		name = "XMLSchema"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66308_0 {
	meta:
		name = "XPActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66310_0 {
	meta:
		name = "XPMan"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66548_0 {
	meta:
		name = "XSLProd"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66264_0 {
	meta:
		name = "Xmlxform"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66612_0 {
	meta:
		name = "ZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66614_0 {
	meta:
		name = "ZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2985_0 {
	meta:
		name = "bdeconst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11526_0 {
	meta:
		name = "dblookup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19799_0 {
	meta:
		name = "frmIBAvailableFieldsU"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34982_0 {
	meta:
		name = "inquire_v1"
		size = 8
		refs = "0002 _DV_94"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43104_0 {
	meta:
		name = "msxml"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44467_0 {
	meta:
		name = "oleacc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46493_0 {
	meta:
		name = "pnglang"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46812_0 {
	meta:
		name = "qcreport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66236_0 {
	meta:
		name = "xmlutil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94_0 {
	meta:
		name = "ValidProgID"
		size = 488
		refs = "000f ValidProgID 003b @InternalUStrFromLStr 008b @UStrLAsg 00a4 @UStrCopy 00fd @UStrToPWChar 0114 CompareString 0146 CompareText 015a UpperCase 0167 Pos 0187 @UStrArrayClr 018d @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 85 C0 74 1C 8B D0 83 EA 0A 66 83 3A 02 74 11 8B 45 08 8B 50 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 83 F8 07 0F 8E D1 00 00 00 8B 45 08 8B 40 FC 85 C0 74 1C 8B D0 83 EA 0A 66 83 3A 02 74 11 8B 45 08 8B 50 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F4 50 8B D3 83 EA 06 8B 45 08 8B 40 FC B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F4 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F4 8B 55 F4 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 56 8B 45 F4 E8 ?? ?? ?? ?? 50 53 8B 45 F8 E8 ?? ?? ?? ?? 50 6A 00 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 85 C0 0F 95 C3 EB 02 B3 01 8D 45 F0 50 8B 45 08 8B 40 FC B9 03 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 02 33 DB 8D 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 04 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 07 00 00 00 2E 00 45 00 6E 00 63 00 6F 00 64 00 65 00 00 00 B0 04 02 00 FF FF FF FF 03 00 00 00 58 00 4D 00 4C 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 53 00 49 00 47 00 4E 00 45 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_95_0 {
	meta:
		name = "GetActiveScriptParse"
		size = 804
		refs = "0039 GetActiveScriptParse 004f @IntfClear 005e CLSID_StdComponentCategoryMgr 0064 CoCreateInstance 0081 CATID_ActiveScriptParse 0091 OleCheck 00af ClassIDToProgID 00b5 ValidProgID 00d4 @HandleAnyException 00ea @UStrFromWArray 00fb StringToGUID 0114 sInvalidEntryInCategories 0119 LoadResString 012c @DoneExcept 015f RegOpenKey 01a3 GUIDToString 01cb Format 01d9 @UStrToPWChar 01e3 RegQueryValue 0249 RegEnumKey 0267 RegCloseKey 026d @HandleFinally 028c @UStrArrayClr 0294 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 B0 FD FF FF 53 56 57 33 D2 89 95 B0 FD FF FF 89 95 B4 FD FF FF 89 95 B8 FD FF FF 89 95 BC FD FF FF 89 55 FC 89 55 F8 89 55 F4 89 55 F0 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 8B 10 FF 52 44 8D 45 F4 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 01 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A9 00 00 00 80 0F 85 DD 00 00 00 8D 45 F8 E8 ?? ?? ?? ?? 50 6A 00 6A 00 68 ?? ?? ?? ?? 6A 01 8B 45 F4 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? E9 96 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8D 45 D0 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 0B 8B 55 FC 8B 45 EC 8B 08 FF 51 38 33 C0 5A 59 59 64 89 10 EB 5D E9 ?? ?? ?? ?? 8D 85 BC FD FF FF 8D 95 D0 FD FF FF B9 00 01 00 00 E8 ?? ?? ?? ?? 8B 85 BC FD FF FF 8D 95 C0 FD FF FF E8 ?? ?? ?? ?? 8D 85 C0 FD FF FF 8D 55 FC E8 ?? ?? ?? ?? 8D 95 B8 FD FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 B8 FD FF FF 8B 45 EC 8B 08 FF 51 38 E8 ?? ?? ?? ?? 8D 45 E8 50 8D 45 D0 50 6A 01 8B 45 F8 50 8B 00 FF 50 0C 85 C0 0F 84 4F FF FF FF E9 23 01 00 00 8D 45 E0 50 68 ?? ?? ?? ?? 68 00 00 00 80 E8 ?? ?? ?? ?? 85 C0 0F 84 08 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB E9 B7 00 00 00 8D 45 F0 50 8D 85 D0 FD FF FF 89 85 C0 FD FF FF C6 85 C4 FD FF FF 0A 8D 95 B4 FD FF FF B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 B4 FD FF FF 89 85 C8 FD FF FF C6 85 CC FD FF FF 11 8D 95 C0 FD FF FF B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 E4 50 6A 00 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 E0 50 E8 ?? ?? ?? ?? 85 C0 75 4B 8D 85 B0 FD FF FF 8D 95 D0 FD FF FF B9 00 01 00 00 E8 ?? ?? ?? ?? 8B 85 B0 FD FF FF 8D 95 C0 FD FF FF E8 ?? ?? ?? ?? 8D 85 C0 FD FF FF 8D 55 FC E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 0B 8B 55 FC 8B 45 EC 8B 08 FF 51 38 43 68 00 02 00 00 8D 85 D0 FD FF FF 50 53 8B 45 E0 50 E8 ?? ?? ?? ?? 85 C0 0F 84 2B FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E0 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 B0 FD FF FF BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 5F 5E 5B 8B E5 5D C3 00 13 E0 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 43 00 4C 00 53 00 49 00 44 00 00 00 B0 04 02 00 FF FF FF FF 1C 00 00 00 25 00 73 00 5C 00 49 00 6D 00 70 00 6C 00 65 00 6D 00 65 00 6E 00 74 00 65 00 64 00 20 00 43 00 61 00 74 00 65 00 67 00 6F 00 72 00 69 00 65 00 73 00 5C 00 25 00 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_96_0 {
	meta:
		name = "TActiveScriptLanguages.Create"
		size = 110
		refs = "000a @ClassCreate 0014 ProgIDList 001e _Dn_TStringList 0023 TStringList.Create 0032 GetActiveScriptParse 0050 TAbstractActiveScriptLanguages.Create 005b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 83 3D ?? ?? ?? ?? 00 75 28 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 10 FF 92 A0 00 00 00 A1 ?? ?? ?? ?? 89 46 04 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_97_0 {
	meta:
		name = "GetOwner"
		size = 4
		altNames = "GetThreadHandle IdSslMASN1StringType InSSLMASN1StringType TAbstractWebPageInfo.GetFactory TAbstractWebPageModuleFactory.GetWebPageInfo TActionBarItem.GetActionBars TActionClient.GetOwningCollection TActionClientItem.GetActionClients TActionListItem.Owner TActiveScriptLanguages.List TBaseWebModuleFactory.GetComponentClass TButtonCategory.GetCategories TCollectionItem.GetOwner TComponent.GetOwner TDBXBaseMetaDataReader.GetContext TDBXBaseMetaDataWriter.GetContext TDBXCommandHandler.GetCommandHandle TDBXDataGeneratorColumn.GetMetaDataColumn TDBXInt32Object.IntValue TDBXMetaDataProvider.GetWriter TDBXSocketChannel.GetChannelInfo TDefaultWebModuleFactory.GetComponentClass TGrpButtonItem.GetCollection TIWBaseHTMLComponentContext.GetHTMLTag TIWBaseWAPComponentContext.getWapTag TParameter.GetParameters TSQLVAR_V1.GetSQLVAR TSQLVAR_V2.GetSQLVAR TScriptError.GetLine TScriptObjectFactories.GetObjectList TWebComponentList.GetOwner TWebContext.GetWebModules TWebDesignContext.GetSession"
	strings:
		$1 = { 8B 40 04 C3 }
	condition:
		$1
}

rule function_98_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a ProgIDList 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32320_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPEPLF 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32440_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPSterCommExpOS390 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32434_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPPCNFSD 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32427_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPOS2 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32411_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPNovellNetware 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32403_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPNCSAforMACOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32397_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPNCSAforDOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32360_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPMusic 001f RegisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32342_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPMicrowareOS9 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32336_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPKA9Q 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32326_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPHellSoft 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32474_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPStratusVOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32314_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPDistinctTCPIP 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32308_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPCiscoIOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32303_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPChameleonNewt 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32297_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPGOS8 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32291_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TInFTPLPGOS7 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32250_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPAS400 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_29766_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_4 001a _DV_TIdNotify 001f TIdNotify.FreeThread 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27104_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TIdHeaderCoderUTF8 001f UnregisterHeaderCoder 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27099_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TIdHeaderCoderPlain 001f UnregisterHeaderCoder 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32604_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPXecomMicroRTOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55452_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TEMFExportFormat 001f UnRegisterTeeExportFormat 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_55395_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a TeeOnShowEditor 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_54623_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TBMPExportFormat 001f UnRegisterTeeExportFormat 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_47831_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_15 001a FFadeManager 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_46547_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a FPrinter 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_45792_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a ConverterRegistry 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_36135_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_4 001a _DV_TIdNotify 001f TIdNotify.FreeThread 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33245_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TInHeaderCoderPlain 001f UnregisterHeaderCoder 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_33229_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TInHeaderCoder2022JP 001f UnregisterHeaderCoder 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_27083_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TIdHeaderCoder2022JP 001f UnregisterHeaderCoder 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32596_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPWinQVNet 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32590_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPWindowsNT 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32583_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPWfFTP 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32576_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPVxWorks 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32542_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPVMS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32503_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPTSXPlus 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32495_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPTOPS20 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32488_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPTandemGuardian 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_32482_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TInFTPLPSuperTCP 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16171_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXSybaseASAMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26181_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPKA9Q 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26171_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPHellSoft 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26165_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPEPLF 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26159_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPDistinctTCPIP 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26153_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPCiscoIOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26148_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPChameleonNewt 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26142_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPGOS8 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26136_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TIdFTPLPGOS7 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26095_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPAS400 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_16256_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXSybaseASEMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26187_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPMicrowareOS9 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15591_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXOracleMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15511_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXMySqlMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15338_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXMsSqlMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_15257_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXMetaDataWriterFactory 001f TDBXMetaDataWriterFactory.FreeWriterRegistry 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14491_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXInterbaseMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_14413_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXInformixMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13843_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXDb2MetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_13781_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a _DV_TDBXDataStoreMetaDataCommandFactory 001f TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_11407_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_2 001a InputReqClass 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26333_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPTandemGuardian 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26458_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPXecomMicroRTOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26450_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPWinQVNet 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26444_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPWindowsNT 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26437_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPWfFTP 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26430_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPVxWorks 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26396_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPVMS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26357_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPUnisysClearPath 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26348_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPTSXPlus 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26340_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPTOPS20 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_4943_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a FClipboard 001f TObject.Free 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26327_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPSuperTCP 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26319_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPStratusVOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26285_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPSterCommExpOS390 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26279_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPPCNFSD 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26272_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPOS2 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26256_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPNovellNetware 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26248_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPNCSAforMACOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26242_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPNCSAforDOS 001f UnregisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_26205_0 {
	meta:
		name = "Finalization"
		size = 58
		refs = "0007 Finalization 0013 _DV_3 001a _DV_TIdFTPLPMusic 001f RegisterFTPListParser 0032 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_99_0 {
	meta:
		name = "ActiveScriptCat"
		size = 23
		refs = "0002 _DV_2 000a ActiveScriptLanguagesClass 0010 _DV_TActiveScriptLanguages"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_2343_0 {
	meta:
		name = "AutoAdapAS"
		size = 23
		refs = "0002 _DV_1 000a DispatcherClass 0010 _DV_TEnumDispatcherAS"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_3250_0 {
	meta:
		name = "CaptionedDockTree"
		size = 23
		refs = "0002 _DV_3 000a DefaultDockTreeClass 0010 _DV_TCaptionedDockTree"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_10076_0 {
	meta:
		name = "DBAdaptImg"
		size = 23
		refs = "0002 _DV_3 000a DataSetAdapterImageFieldClass 0010 _DV_TDataSetAdapterImageField"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_17459_0 {
	meta:
		name = "DockTabSet"
		size = 23
		refs = "0002 _DV_6 000a DefaultDockTreeClass 0010 _DV_TCaptionedTabDockTree"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "Succeeded"
		size = 9
	strings:
		$1 = { A9 00 00 00 80 0F 94 C0 C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "Failed"
		size = 9
	strings:
		$1 = { A9 00 00 00 80 0F 95 C0 C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "HResultCode"
		size = 6
		altNames = "ResultCode"
	strings:
		$1 = { 25 FF FF 00 00 C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "HResultFacility"
		size = 9
		altNames = "ResultFacility"
	strings:
		$1 = { C1 E8 10 25 FF 1F 00 00 C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "ResultSeverity"
		size = 4
	strings:
		$1 = { C1 E8 1F C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "MakeResult"
		size = 13
	strings:
		$1 = { C1 E0 1F C1 E2 10 0B C2 0B C8 8B C1 C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "LHashValOfName"
		size = 10
		refs = "0005 LHashValOfNameSys"
	strings:
		$1 = { 52 50 6A 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "LANGIDFROMLCID"
		size = 5
		altNames = "WHashValOfLHashVal"
	strings:
		$1 = { 66 25 FF FF C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "IsHashValCompatible"
		size = 17
	strings:
		$1 = { 25 00 00 FF 00 81 E2 00 00 FF 00 3B C2 0F 94 C0 C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "EventRefFromWpLp"
		size = 4
		altNames = "GetBValue GetMValue HiWord PROPSETHDR_OSVER_KIND WSAGetAsyncError WSAGetSelectError mci_HMS_Second mci_MSF_Frame mci_TMSF_Second"
	strings:
		$1 = { C1 E8 10 C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "ErrCat"
		size = 7
		altNames = "HiByte PROPSETHDR_OSVER_MINOR mci_HMS_Minute mci_MSF_Second mci_TMSF_Minute"
	strings:
		$1 = { 0F B7 C0 C1 E8 08 C3 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "TStandardColorMap.SetColor"
		size = 53
		refs = "0013 GetHighLightColor 002e TCustomActionBarColorMap.SetColor"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 40 74 1E BA 13 00 00 00 8B C6 E8 ?? ?? ?? ?? 89 43 6C BA 0A 00 00 00 8B C6 E8 ?? ?? ?? ?? 89 43 60 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "TStandardColorMap.UpdateColors"
		size = 242
		refs = "0007 TCustomActionBarColorMap.UpdateColors 001f SystemParametersInfo 00a6 GetHighLightColor"
	strings:
		$1 = { 53 51 8B D8 8B C3 E8 ?? ?? ?? ?? 33 C0 89 04 24 6A 00 8D 44 24 04 50 6A 00 68 22 10 00 00 E8 ?? ?? ?? ?? C7 43 38 0F 00 00 FF C7 43 34 0F 00 00 FF C7 43 3C 08 00 00 FF BA 0F 00 00 FF 8B C3 8B 08 FF 51 30 83 3C 24 00 74 09 C7 43 74 04 00 00 FF EB 07 C7 43 74 0F 00 00 FF C7 43 48 11 00 00 FF C7 43 4C 14 00 00 FF C7 43 44 00 00 00 20 BA 08 00 00 FF 8B C3 8B 08 FF 51 34 C7 43 78 14 00 00 FF C7 43 7C 16 00 00 FF C7 83 80 00 00 00 10 00 00 FF C7 83 84 00 00 00 15 00 00 FF BA 13 00 00 00 8B 43 40 E8 ?? ?? ?? ?? 89 43 6C C7 43 54 00 00 00 20 C7 43 5C 00 00 00 20 83 3C 24 00 74 09 C7 43 68 1D 00 00 FF EB 07 C7 43 68 0D 00 00 FF C7 43 64 0E 00 00 FF C7 43 58 10 00 00 FF BA 12 00 00 00 8B 43 40 E8 ?? ?? ?? ?? 89 43 60 5A 5B C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TXPColorMap.UpdateColors"
		size = 188
		refs = "0006 TCustomActionBarColorMap.UpdateColors 0080 GetHighLightColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 0F 00 00 FF 8B C3 8B 08 FF 51 30 C7 43 74 05 00 00 FF C7 43 38 31 69 C6 00 C7 43 34 0F 00 00 FF C7 43 3C 08 00 00 FF C7 43 48 11 00 00 FF C7 43 4C 14 00 00 FF C7 43 44 80 80 80 00 BA 08 00 00 FF 8B C3 8B 08 FF 51 34 C7 43 78 FF FF FF 00 C7 43 7C 8A 86 7A 00 C7 83 80 00 00 00 FF FF FF 00 C7 83 84 00 00 00 8A 86 7A 00 BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 6C C7 43 54 00 00 00 20 C7 43 5C 00 00 00 20 C7 43 68 C6 D3 EF 00 33 C0 89 43 64 C7 43 58 15 00 00 FF BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 60 5B C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "TTwilightColorMap.UpdateColors"
		size = 140
		refs = "0006 TCustomActionBarColorMap.UpdateColors"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 51 30 33 C0 89 43 74 C7 43 48 11 00 00 FF 33 C0 89 43 4C C7 43 44 15 00 00 FF BA FF FF FF 00 8B C3 8B 08 FF 51 34 33 C0 89 43 78 C7 43 7C 15 00 00 FF 33 C0 89 83 80 00 00 00 C7 83 84 00 00 00 15 00 00 FF 33 C0 89 43 6C C7 43 54 00 00 00 20 C7 43 5C FF FF FF 00 C7 43 34 15 00 00 FF 33 C0 89 43 3C C7 43 68 15 00 00 FF 33 C0 89 43 64 33 C0 89 43 58 33 C0 89 43 60 5B C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "TThemedColorMap.UpdateColors"
		size = 539
		refs = "0008 TCustomActionBarColorMap.UpdateColors 007f GetHighLightColor 00ba ThemeServices 00c1 TThemeServices.GetTheme 00d7 GetThemeColor"
	strings:
		$1 = { 53 56 51 8B D8 8B C3 E8 ?? ?? ?? ?? BA 1E 00 00 FF 8B C3 8B 08 FF 51 30 C7 43 74 04 00 00 FF C7 43 38 64 64 64 00 C7 43 34 1D 00 00 FF C7 43 3C 08 00 00 FF C7 43 48 11 00 00 FF C7 43 4C F4 F7 FC 00 C7 43 44 80 80 80 00 33 D2 8B C3 8B 08 FF 51 34 C7 43 78 F4 F7 FC 00 C7 43 7C 64 64 64 00 C7 83 80 00 00 00 F4 F7 FC 00 C7 83 84 00 00 00 64 64 64 00 BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 6C C7 43 54 00 00 00 20 C7 43 5C 00 00 00 20 C7 43 68 1D 00 00 FF 33 C0 89 43 64 C7 43 58 15 00 00 FF BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 60 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B F0 85 F6 74 40 54 68 DF 0E 00 00 6A 01 6A 01 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 38 54 68 DB 0E 00 00 6A 01 6A 01 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 0A 8B 14 24 8B C3 8B 08 FF 51 34 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 F6 00 00 00 54 68 DB 0E 00 00 6A 02 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 3C 54 68 DB 0E 00 00 6A 03 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 48 54 68 DD 0E 00 00 6A 03 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 4C 54 68 DD 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 78 54 68 DF 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 7C 54 68 DD 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 09 8B 04 24 89 83 80 00 00 00 54 68 DF 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 09 8B 04 24 89 83 84 00 00 00 54 68 DB 0E 00 00 6A 02 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 64 5A 5E 5B C3 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "TCustomButtonControl.Create"
		size = 80
		refs = "000a @ClassCreate 0017 TCustomActionControl.Create 001c TCustomButtonControl.Create 0038 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 46 50 C6 86 ED 01 00 00 01 C6 86 EE 01 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 80 00 04 00 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "TCustomButtonControl.CalcBounds"
		size = 23
		refs = "0006 TCustomActionControl.CalcBounds 0011 TControl.SetWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 53 48 42 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "TCustomButtonControl.Click"
		size = 24
		refs = "0012 TCustomActionControl.Click"
	strings:
		$1 = { 53 8B D8 B2 01 8B C3 8B 08 FF 91 E4 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1308_0 {
	meta:
		name = "TCustomMenuButton.Keyed"
		size = 24
		refs = "0012 TCustomActionControl.Keyed"
	strings:
		$1 = { 53 8B D8 B2 01 8B C3 8B 08 FF 91 E4 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "TCustomButtonControl.CMEnabledChanged"
		size = 22
		refs = "0006 TCustomButtonControl.UpdateTracking"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 84 00 00 00 5B C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "TCustomButtonControl.CMTextChanged"
		size = 90
		refs = "0017 TCustomActionControl.GetActionBar 0039 TControl.SetWidth 0047 TControl.SetHeight 0053 TCustomActionControl.CMTextChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 74 3A 8B C3 E8 ?? ?? ?? ?? 85 C0 74 20 8B C3 E8 ?? ?? ?? ?? 0F B6 80 7F 02 00 00 2C 02 73 0E BA 08 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 18 BA 06 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "TCustomButtonControl.CMMouseEnter"
		size = 67
		refs = "0006 TControl.CMMouseEnter 0028 GetCapture"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB ED 01 00 00 00 74 2E 80 BB EB 01 00 00 00 75 25 8B C3 8B 10 FF 52 4C 84 C0 74 1A E8 ?? ?? ?? ?? 85 C0 75 11 C6 83 EB 01 00 00 01 8B C3 8B 10 FF 92 84 00 00 00 5B C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "TCustomButtonControl.CMMouseLeave"
		size = 77
		refs = "0006 TControl.CMMouseLeave"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB ED 01 00 00 00 74 38 8B C3 8B 10 FF 52 4C 84 C0 74 2D C6 83 EB 01 00 00 00 8B C3 8B 10 FF 92 CC 00 00 00 84 C0 75 07 C6 83 EE 01 00 00 00 C6 83 EA 01 00 00 00 8B C3 8B 10 FF 92 84 00 00 00 5B C3 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "TCustomButtonControl.DrawBackground"
		size = 99
		refs = "0028 TBrush.GetColor 0032 GetHighLightColor 0049 AllocPatternBitmap 0052 TBrush.SetBitmap 005b TCustomActionControl.DrawBackground"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B C3 8B 10 FF 92 CC 00 00 00 84 C0 74 41 80 BB EB 01 00 00 00 75 38 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? BA 13 00 00 00 E8 ?? ?? ?? ?? 50 8B 83 A0 01 00 00 8B 70 14 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "TCustomButtonControl.Loaded"
		size = 45
		refs = "0006 TControl.Loaded 0027 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 3C 85 C0 74 16 8B C6 8B 10 FF 52 3C 8B D0 B1 01 8B C6 66 BE EF FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "TCustomButtonControl.MouseDown"
		size = 91
		refs = "001e TControl.MouseDown 003f TCustomButtonControl.SetState"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 84 DB 75 2E 8B C6 8B 10 FF 52 4C 84 C0 74 23 80 BE E9 01 00 00 00 75 13 B2 02 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 80 00 00 00 C6 86 EA 01 00 00 01 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "TCustomButtonControl.MouseMove"
		size = 166
		refs = "001b TControl.MouseMove 0042 TControl.GetClientWidth 0051 TControl.GetClientHeight 009a TCustomButtonControl.UpdateTracking"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 88 55 FF 8B D8 8B 7D 08 57 8B CE 0F B6 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB EA 01 00 00 00 74 66 80 BB E9 01 00 00 00 75 06 C6 45 FE 00 EB 04 C6 45 FE 03 85 F6 7C 2D 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 22 85 FF 7C 1E 8B C3 E8 ?? ?? ?? ?? 3B F8 7F 13 80 BB E9 01 00 00 00 74 06 C6 45 FE 03 EB 04 C6 45 FE 02 0F B6 45 FE 3A 83 EE 01 00 00 74 26 0F B6 45 FE 88 83 EE 01 00 00 8B C3 8B 10 FF 92 80 00 00 00 EB 10 80 BB EB 01 00 00 00 75 07 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "TCustomButtonControl.MouseUp"
		size = 330
		refs = "0022 TControl.MouseUp 0041 TControl.GetClientWidth 0050 TControl.GetClientHeight 006e TActionClientItem.GetAction 0074 _Dn_TCustomAction 0079 @IsClass 00f7 TCustomButtonControl.SetDown 0137 @CallDynaInst 013e TCustomButtonControl.UpdateTracking"
	strings:
		$1 = { 55 8B EC 51 53 56 57 88 4D FE 88 55 FF 8B D8 8B 7D 08 8B 75 0C 56 57 0F B6 4D FE 0F B6 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB EA 01 00 00 00 0F 84 0F 01 00 00 C6 83 EA 01 00 00 00 85 F6 7C 1A 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 0F 85 FF 7C 0B 8B C3 E8 ?? ?? ?? ?? 3B F8 7E 04 33 C0 EB 02 B0 01 88 45 FD 8B B3 AC 01 00 00 85 F6 74 79 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 63 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 83 78 6C 00 74 25 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 80 B8 95 00 00 00 00 74 3E 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 80 78 69 00 74 2D C6 83 EE 01 00 00 00 C6 83 EB 01 00 00 00 80 7D FD 00 74 5F 0F B6 83 EE 01 00 00 04 FE 2C 02 72 52 8B C3 8B 10 FF 92 80 00 00 00 EB 46 80 7D FD 00 74 26 0F B6 93 E9 01 00 00 80 F2 01 8B C3 E8 ?? ?? ?? ?? 80 BB E9 01 00 00 00 74 26 8B C3 8B 10 FF 92 84 00 00 00 EB 1A 80 BB E9 01 00 00 00 74 07 C6 83 EE 01 00 00 03 8B C3 8B 10 FF 92 84 00 00 00 80 7D FD 00 74 0B 8B C3 66 BE EB FF E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "TCustomButtonControl.Paint"
		size = 101
		refs = "0009 TCustomActionControl.Paint 002a TPen.SetWidth"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 75 45 8B 83 A0 01 00 00 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 51 44 54 8B C3 8B 10 FF 92 CC 00 00 00 84 C0 75 0D 80 BB EE 01 00 00 02 74 04 33 C9 EB 02 B1 01 8B C3 5A 8B 18 FF 93 F0 00 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "TCustomButtonControl.SetActionClient"
		size = 60
		refs = "000b TCustomActionControl.SetActionClient"
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 4C 84 C0 74 12 85 FF 74 0E 8B C6 8B 10 FF 92 D4 00 00 00 84 C0 74 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 51 64 5F 5E C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "TCustomButtonControl.SetAllowAllUp"
		size = 15
	strings:
		$1 = { 3A 90 E8 01 00 00 74 06 88 90 E8 01 00 00 C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "TCustomButtonControl.SetDown"
		size = 106
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 D0 00 00 00 84 C0 75 02 33 DB 3A 9E E9 01 00 00 74 49 80 BE E9 01 00 00 00 74 09 80 BE E8 01 00 00 00 74 37 88 9E E9 01 00 00 84 DB 74 1C 80 BE EE 01 00 00 00 75 0A 8B C6 8B 10 FF 92 80 00 00 00 C6 86 EE 01 00 00 03 EB 11 C6 86 EE 01 00 00 00 8B C6 8B 10 FF 92 84 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "TCustomButtonControl.SetFlat"
		size = 23
	strings:
		$1 = { 3A 90 ED 01 00 00 74 0E 88 90 ED 01 00 00 8B 10 FF 92 80 00 00 00 C3 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "TCustomButtonControl.SetSelected"
		size = 19
		refs = "0006 TCustomActionControl.SetSelected"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 83 EB 01 00 00 00 5B C3 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "TCustomButtonControl.SetState"
		size = 23
	strings:
		$1 = { 3A 90 EE 01 00 00 74 0E 88 90 EE 01 00 00 8B 10 FF 92 80 00 00 00 C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "TCustomButtonControl.SetBounds"
		size = 36
		refs = "0011 TControl.SetBounds"
	strings:
		$1 = { 55 8B EC 56 8B F0 8B 45 0C 50 8B 45 08 50 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 94 00 00 00 5E 5D C2 08 00 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "TCustomButtonControl.UpdateTracking"
		size = 105
		refs = "0023 GetCursorPos 002c FindDragTarget 004e TControl.Perform"
	strings:
		$1 = { 53 56 83 C4 F8 8B F0 F6 46 1C 08 75 57 80 BE ED 01 00 00 00 74 4E 8B C6 8B 10 FF 52 4C 84 C0 74 43 54 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 3B F0 0F 94 C3 80 F3 01 88 9E EB 01 00 00 84 DB 74 12 6A 00 33 C9 BA 14 B0 00 00 8B C6 E8 ?? ?? ?? ?? EB 10 6A 00 33 C9 BA 13 B0 00 00 8B C6 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "TCustomButtonControl.WMLButtonDblClk"
		size = 34
		refs = "0007 TControl.WMLButtonDblClk 001b @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB E9 01 00 00 00 74 0B 8B C3 66 BE EA FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "TCustomButtonControl.SetGlyphLayout"
		size = 24
		refs = "0006 TCustomActionControl.SetGlyphLayout 0012 TCustomActionControl.SetSpacing"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "TCustomButtonControl.DrawLargeGlyph"
		size = 85
		refs = "004a TCustomActionControl.DrawLargeGlyph"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 8B D8 8B 04 24 89 44 24 08 8B 44 24 04 89 44 24 0C F6 43 1C 10 75 1F 80 BB EE 01 00 00 02 74 0E 8B C3 8B 10 FF 92 CC 00 00 00 84 C0 74 08 FF 44 24 08 FF 44 24 0C 8D 54 24 08 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "TCustomButtonControl.CMDialogChar"
		size = 12
		altNames = "TCustomCategoryPanelGroup.WMNCHitTest TCustomCombo.WMDeleteItem TCustomCombo.WMDrawItem TCustomCombo.WMMeasureItem TCustomForm.CMUIActivate TProgressBar.WMEraseBkGnd TScrollBar.WMEraseBkgnd TScrollBox.WMNCHitTest"
	strings:
		$1 = { 56 8B F0 8B C6 8B 08 FF 51 F0 5E C3 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "TCustomUtilityButton.Create"
		size = 142
		refs = "000e @ClassCreate 001c TCustomButtonControl.Create 003d _Dn_TTimer 0042 TTimer.Create 0053 TTimer.SetEnabled 0059 TCustomUtilityButton.OnDelay 0060 TTimer.SetOnTimer 006c TTimer.SetInterval 0079 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 0C 02 00 00 00 C7 83 F0 01 00 00 02 00 00 00 C6 83 0D 02 00 00 01 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 F8 01 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? BA EE 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "TCustomUtilityButton.Destroy"
		size = 48
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001e TCustomActionControl.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 F8 01 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "TCustomUtilityButton.Click"
		size = 29
		altNames = "TWinControl.DoExit"
	strings:
		$1 = { 53 66 83 B8 02 02 00 00 00 74 10 8B D8 8B D0 8B 83 04 02 00 00 FF 93 00 02 00 00 5B C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "TCustomUtilityButton.CMMouseEnter"
		size = 34
		refs = "0006 TCustomButtonControl.CMMouseEnter 001c TTimer.SetEnabled"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 0C 02 00 00 00 74 0D B2 01 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "TCustomUtilityButton.CMMouseLeave"
		size = 25
		refs = "0006 TCustomButtonControl.CMMouseLeave 0013 TTimer.SetEnabled"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "TCustomUtilityButton.DrawArrows"
		size = 270
		refs = "0049 Offset 0068 Point 00e4 DrawArrow 0103 DrawChevron"
	strings:
		$1 = { 53 56 57 83 C4 F4 8B F0 33 DB C6 44 24 08 00 0F B6 86 F4 01 00 00 2C 02 72 54 2C 02 0F 83 9A 00 00 00 8B 56 4C D1 FA 79 03 83 D2 00 8B BE F0 01 00 00 8B C7 D1 F8 79 03 83 D0 00 2B D0 80 FB 02 0F 94 C0 83 E0 7F 03 14 85 ?? ?? ?? ?? 8B 46 48 D1 F8 79 03 83 D0 00 2B C7 0F B6 4C 24 08 03 04 8D ?? ?? ?? ?? 8B CC E8 ?? ?? ?? ?? EB 4E 80 FB 02 0F 94 C0 83 E0 7F 8B 14 85 ?? ?? ?? ?? 8B 46 4C D1 F8 79 03 83 D0 00 8B BE F0 01 00 00 2B C7 03 D0 8B 46 48 D1 F8 79 03 83 D0 00 D1 FF 79 03 83 D7 00 2B C7 80 FB 02 0F 94 C1 83 E1 7F 03 04 8D ?? ?? ?? ?? 8B CC E8 ?? ?? ?? ?? 0F B6 86 0D 02 00 00 2C 01 72 04 74 21 EB 3C 8B 86 F0 01 00 00 50 8D 4C 24 04 0F B6 96 F4 01 00 00 8B 86 A0 01 00 00 E8 ?? ?? ?? ?? EB 1D 8B 86 F0 01 00 00 50 8D 4C 24 04 0F B6 96 F4 01 00 00 8B 86 A0 01 00 00 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "TCustomUtilityButton.MouseDown"
		size = 58
		refs = "001a TTimer.SetEnabled 002f TCustomButtonControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 84 DB 75 0D 33 D2 8B 86 F8 01 00 00 E8 ?? ?? ?? ?? 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "TCustomUtilityButton.OnDelay"
		size = 62
		refs = "0012 TTimer.SetEnabled 002c TTimer.SetInterval 0037 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 0F B6 93 0C 02 00 00 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 80 BB 0C 02 00 00 00 74 11 8B 93 08 02 00 00 8B 83 F8 01 00 00 E8 ?? ?? ?? ?? 8B C3 66 BE EB FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "TCustomUtilityButton.SetArrowSize"
		size = 23
	strings:
		$1 = { 3B 90 F0 01 00 00 74 0E 89 90 F0 01 00 00 8B 10 FF 92 80 00 00 00 C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TCustomUtilityButton.SetArrowType"
		size = 23
	strings:
		$1 = { 3A 90 0D 02 00 00 74 0E 88 90 0D 02 00 00 8B 10 FF 92 80 00 00 00 C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TCustomUtilityButton.SetDirection"
		size = 23
	strings:
		$1 = { 3A 90 F4 01 00 00 74 0E 88 90 F4 01 00 00 8B 10 FF 92 80 00 00 00 C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TCustomUtilityButton.Paint"
		size = 51
		refs = "0006 TCustomButtonControl.Paint 000d TCustomActionControl.GetActionBar 0012 TCustomActionBar.GetColorMap 0023 TPen.SetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 50 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 F4 00 00 00 5B C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TCustomToolScrollBtn.CalcBounds"
		size = 67
		refs = "0006 TCustomActionControl.GetActionBar 0026 TControl.SetHeight 0034 TControl.SetWidth 003d TCustomButtonControl.CalcBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 2C 8B C3 E8 ?? ?? ?? ?? 0F B6 40 5B 48 2C 02 73 0E BA 0D 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 15 BA 0B 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "TCustomToolScrollBtn.Create"
		size = 69
		refs = "000a @ClassCreate 0017 TCustomUtilityButton.Create 0022 SMoreButtons 0027 LoadResString 0032 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TCustomToolScrollBtn.DrawArrows"
		size = 285
		refs = "002e Point 0067 TCustomActionControl.GetActionBar 006c TCustomActionBar.GetColorMap 007d TPen.SetColor 00a7 _DV_TCustomActionToolBar 00ac @IsClass 00b7 TCustomActionToolBar.GetHiddenCount 00d8 DrawChevron 0108 ArrowDirection 0113 DrawArrow"
	strings:
		$1 = { 53 56 83 C4 F0 8B D8 0F B6 83 F4 01 00 00 2C 02 72 22 2C 02 73 43 8B CC 8B 43 48 D1 F8 79 03 83 D0 00 2B 83 F0 01 00 00 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 25 8B 43 48 D1 F8 79 03 83 D0 00 8B 93 F0 01 00 00 D1 FA 79 03 83 D2 00 2B C2 8B CC BA 03 00 00 00 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 4C 84 C0 74 1F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 50 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 48 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 8B 73 30 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 28 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 1D 8B 83 F0 01 00 00 50 8D 4C 24 04 0F B6 93 F4 01 00 00 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 6A 02 8D 4C 24 0C 8B 53 4C 83 EA 08 8B 43 48 D1 F8 79 03 83 D0 00 2B 83 F0 01 00 00 E8 ?? ?? ?? ?? 8D 4C 24 0C 0F B6 43 5B 0F B6 90 ?? ?? ?? ?? 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TCustomDropDownButton.CalcBounds"
		size = 34
		refs = "0006 TCustomButtonControl.CalcBounds 001c TControl.SetWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 F8 00 00 00 8B D0 03 53 48 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "TCustomDropDownButton.Click"
		size = 38
		refs = "0020 TCustomButtonControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 00 01 00 00 84 C0 74 0C 8B C3 8B 10 FF 92 04 01 00 00 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TCustomDropDownButton.CMMouseleave"
		size = 19
		refs = "0006 TCustomButtonControl.CMMouseLeave"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 83 F0 01 00 00 00 5B C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TCustomDropDownButton.DrawDropDownArrow"
		size = 159
		refs = "0014 TCustomActionControl.GetActionBar 0019 TCustomActionBar.GetColorMap 002a TPen.SetColor 0064 TControl.GetClientWidth 0072 TControl.GetClientHeight 0086 Point 0097 DrawArrow"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B C3 8B 10 FF 52 4C 84 C0 74 1F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 50 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 48 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 6A 02 8B C3 8B 10 FF 92 F8 00 00 00 D1 F8 79 03 83 D0 00 50 8B C3 E8 ?? ?? ?? ?? 5A 2B C2 83 E8 03 50 8B C3 E8 ?? ?? ?? ?? 8B D0 D1 FA 79 03 83 D2 00 4A 8D 4C 24 08 58 E8 ?? ?? ?? ?? 8D 4C 24 04 B2 03 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 59 5A 5B C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TCustomDropDownButton.DrawFrame"
		size = 104
		refs = "0035 TCustomButtonControl.DrawFrame"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 A5 A5 8B D9 8B F0 83 6C 24 08 09 84 DB 74 0E 8B C6 8B 10 FF 92 00 01 00 00 84 C0 74 04 33 C9 EB 02 B1 01 8B D4 8B C6 E8 ?? ?? ?? ?? 8B 44 24 08 89 04 24 83 44 24 08 09 84 DB 75 0D 80 BE F0 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "TCustomDropDownButton.DropDownClick"
		size = 276
		refs = "001d _Dn_TCustomActionPopupMenu 0022 @AsClass 002d TCustomDropDownButton.DropDownClick 005c Point 006a TControl.ClientToScreen 0098 TCustomButtonControl.SetFlat 00a0 TCustomActionControl.GetActionBar 00a5 TCustomActionBar.GetColorMap 00c6 TCustomActionPopupMenu.Popup 00ed @HandleFinally 0104 TObject.Free"
	strings:
		$1 = { 55 8B EC 83 C4 E8 89 45 FC 8B 45 FC 8B 10 FF 92 FC 00 00 00 33 C9 B2 01 FF 50 2C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 90 AC 01 00 00 8B 45 F8 8B 08 FF 91 30 01 00 00 8D 4D E8 8B 45 FC 8B 50 4C 42 8B 45 FC 8B 40 40 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 89 90 18 03 00 00 8B 45 FC C6 80 F0 01 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F8 8B 08 FF 91 38 01 00 00 8B 45 FC 8B 55 F0 2B 50 40 8B 4D F4 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 F0 01 00 00 00 B2 01 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "PICEmptyString"
		size = 6
		altNames = "TCustomDropDownButton.GetDropDownButtonWidth _DF_. get_crc_table zlibVersion"
	strings:
		$1 = { B8 09 00 00 00 C3 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "TCustomDropDownButton.GetPopupClass"
		size = 51
		refs = "0007 TCustomActionControl.GetActionBar 0015 _Dn_TActionBarStyleEx 001a @AsClass"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 5C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 51 0C 5E 5B C3 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "TCustomDropDownButton.MouseDown"
		size = 92
		refs = "001e TCustomButtonControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 00 01 00 00 84 C0 74 07 C6 86 EE 01 00 00 00 8B C6 8B 10 FF 92 00 01 00 00 84 C0 74 04 84 DB 74 04 33 C0 EB 02 B0 01 88 86 F0 01 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TCustomDropDownButton.MouseOverDropDown"
		size = 103
		refs = "000b Mouse 0012 TMouse.GetCursorPos 001f TControl.ScreenToClient 0027 TControl.GetClientHeight 003f TControl.GetClientWidth 0054 Rect 005e PtInRect"
	strings:
		$1 = { 53 83 C4 E0 8B D8 8D 54 24 08 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8D 54 24 08 8B CC 8B C3 E8 ?? ?? ?? ?? 54 8B C3 E8 ?? ?? ?? ?? 50 8D 44 24 18 50 8B C3 8B 10 FF 92 F8 00 00 00 50 8B C3 E8 ?? ?? ?? ?? 5A 2B C2 50 8B C3 E8 ?? ?? ?? ?? 8B C8 33 D2 58 E8 ?? ?? ?? ?? 8D 44 24 14 5A E8 ?? ?? ?? ?? 83 C4 20 5B C3 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TCustomDropDownButton.Paint"
		size = 22
		refs = "0006 TCustomButtonControl.Paint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 F4 00 00 00 5B C3 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TCustomActionCombo.BeginAutoDrag"
		size = 18
		refs = "000c @CallDynaInst"
	strings:
		$1 = { 56 8B 80 08 03 00 00 66 BE ED FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "TCustomActionCombo.DesignWndProc"
		size = 24
		refs = "0006 TControl.DesignWndProc"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? 8B 13 81 EA 01 02 00 00 75 02 B0 01 5B C3 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "TCustomActionCombo.DragDrop"
		size = 37
	strings:
		$1 = { 55 8B EC 53 56 57 8B FA 8B F0 8B 45 08 50 8B D7 8B 86 08 03 00 00 8B 18 FF 93 98 00 00 00 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "TCustomActionCombo.DragOver"
		size = 121
		refs = "0023 TControl.DragOver 003a _Dn_TActionDragObject 003f @IsClass 004b _Dn_TActionItemDragObject 005c _Dn_TCategoryDragObject"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B DA 8B F0 8B 7D 08 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 86 08 03 00 00 83 B8 AC 01 00 00 00 74 11 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 26 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 15 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 07 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "TCustomComboControl.Create"
		size = 154
		refs = "000f @ClassCreate 001d TCustomActionControl.Create 0026 _DV_TCustomActionCombo 002b TCustomComboBoxEx.Create 003c TWinControl.SetTabStop 004c TControl.SetWidth 0062 TCustomComboControl.ComboClick 0084 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E E8 01 00 00 8B C3 33 D2 E8 ?? ?? ?? ?? 8B 86 E8 01 00 00 BA 64 00 00 00 E8 ?? ?? ?? ?? 8B BE E8 01 00 00 89 B7 14 01 00 00 C7 87 10 01 00 00 ?? ?? ?? ?? 89 B7 08 03 00 00 F6 47 1C 10 74 09 8B C7 B2 01 8B 08 FF 51 60 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TCustomComboControl.Destroy"
		size = 56
		refs = "0003 @BeforeDestruction 001a TObject.Free 0026 TCustomActionControl.Destroy 0031 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 86 E8 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "TCustomComboControl.CalcBounds"
		size = 78
		refs = "0006 TCustomActionControl.CalcBounds 0011 TWinControl.HandleAllocated 0036 TControl.SetWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 33 8B C3 8B 10 FF 92 9C 00 00 00 84 C0 74 15 8B 83 E8 01 00 00 8B 50 48 03 53 48 8B C3 E8 ?? ?? ?? ?? EB 10 8B 83 E8 01 00 00 8B 50 48 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TCustomComboControl.Click"
		size = 30
		refs = "0018 TCustomActionControl.Click"
		altNames = "TRibbonCustomControl.Click"
	strings:
		$1 = { 53 8B D8 F6 43 1C 10 74 0C B2 01 8B C3 8B 08 FF 91 E4 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "TCustomComboControl.CMVisiblechanged"
		size = 27
		refs = "0006 TControl.CMVisibleChanged 0015 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 0F B6 53 57 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "TCustomComboControl.ComboClick"
		size = 48
		refs = "0007 TCustomActionControl.GetActionBar 0029 @CallDynaInst"
		altNames = "TRibbonComboControl.ComboClick"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 1E 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 0B 8B C3 66 BE EB FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "TCustomActionCombo.ComboWndProc"
		size = 57
		refs = "000f TControl.GetDragMode 002e TCustomCombo.ComboWndProc"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 01 75 0C 8B 06 05 00 FF FF FF 83 E8 0A 72 0F 8B 45 08 50 8B D6 8B CF 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "TCustomComboControl.Paint"
		size = 49
		refs = "0007 TCustomActionControl.Paint 0018 TWinControl.HandleAllocated"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B B3 E8 01 00 00 85 F6 74 19 8B C6 E8 ?? ?? ?? ?? 84 C0 74 0E 8B 83 E8 01 00 00 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "TCustomComboControl.SetActionClient"
		size = 68
		refs = "000c TCustomActionControl.SetActionClient 0024 TActionClientItem.GetAction 003c TControl.SetAction"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 F6 74 2C 8B 83 E8 01 00 00 8B 10 FF 52 3C 8B F8 8B C6 E8 ?? ?? ?? ?? 3B F8 74 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 E8 01 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "TCustomComboControl.SetBounds"
		size = 174
		refs = "0017 TControl.SetBounds"
	strings:
		$1 = { 55 8B EC 53 56 57 8B FA 8B F0 8B 45 0C 50 8B 45 08 50 8B D7 8B C6 E8 ?? ?? ?? ?? 8B 86 E8 01 00 00 85 C0 74 78 8B 5E 4C D1 FB 79 03 83 D3 00 03 5E 44 8B 40 4C D1 F8 79 03 83 D0 00 2B D8 8B C6 8B 10 FF 92 9C 00 00 00 84 C0 74 31 8B 86 E8 01 00 00 8B 40 48 50 8B 86 E8 01 00 00 8B 40 4C 50 8B 96 DC 01 00 00 03 D7 83 C2 05 8B CB 8B 86 E8 01 00 00 8B 18 FF 93 88 00 00 00 EB 20 8B 46 48 50 8B 86 E8 01 00 00 8B 40 4C 50 8B CB 8B D7 8B 86 E8 01 00 00 8B 18 FF 93 88 00 00 00 8B C6 8B 10 FF 92 94 00 00 00 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TCustomComboControl.SetDragMode"
		size = 31
		refs = "000b TControl.SetDragMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 86 E8 01 00 00 8B 08 FF 51 60 5E 5B C3 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TCustomComboControl.SetParent"
		size = 39
		refs = "001f TControl.SetParent"
	strings:
		$1 = { 56 57 55 8B FA 8B F0 8B AE E8 01 00 00 85 ED 74 09 8B D7 8B C5 8B 08 FF 51 68 8B D7 8B C6 E8 ?? ?? ?? ?? 5D 5F 5E C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TCustomActionDockBar.Create"
		size = 117
		refs = "000a @ClassCreate 0017 TCustomActionBar.Create 0020 TControl.SetAlign 0062 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 8B 00 00 00 01 C6 86 E0 02 00 00 00 33 C0 89 86 E8 02 00 00 C6 86 D8 02 00 00 00 C7 86 E4 02 00 00 7D 00 00 00 33 C0 89 86 F0 02 00 00 33 C0 89 86 F4 02 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "TCustomActionDockBar.CalcDockedWidth"
		size = 59
		refs = "0010 TCustomActionBar.FindFirstVisibleItem 002b TCustomActionBar.FindNextVisibleItem"
	strings:
		$1 = { 53 56 57 8B F0 8B BE B0 02 00 00 03 FF 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 1B 8B 43 44 03 78 48 03 BE 80 02 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 E5 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "TCustomActionDockBar.CustomAlignPosition"
		size = 405
		refs = "0024 TCustomActionDockBar.ScrollButtonsVisible 0043 TCustomActionBar.CustomAlignPosition 0051 _Dn_TCustomActionControl 0056 @IsClass 006b TControl.GetClientHeight 008a TControl.GetClientWidth 00b2 Rect 0114 TCustomActionBar.GetItems 0119 TCollection.GetCount"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 8B 75 08 8D 7D E4 A5 A5 A5 A5 89 4D F8 89 55 FC 8B D8 8B 75 0C 8B 7D 18 8B C3 E8 ?? ?? ?? ?? 84 C0 75 20 57 8B 45 14 50 8B 45 10 50 56 8D 45 E4 50 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? E9 40 01 00 00 8B 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 2A 01 00 00 83 7D E8 00 75 76 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 50 8D 45 D4 50 B2 01 8B C3 8B 08 FF 91 04 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 04 01 00 00 03 83 B0 02 00 00 8B 93 AC 02 00 00 59 E8 ?? ?? ?? ?? 56 57 8B FE 8D 75 D4 A5 A5 A5 A5 5F 5E 83 BB E8 02 00 00 00 7E 12 8B 83 F4 02 00 00 8B 40 4C 03 83 80 02 00 00 01 46 04 8B 45 FC 89 45 F4 8B 45 E8 3B 83 E8 02 00 00 0F 8C 93 00 00 00 8B 46 04 89 07 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 8B 17 8B 4D F4 03 51 4C 3B C2 7C 34 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 3B 45 E8 74 2A 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 8B 93 F0 02 00 00 2B 42 4C 8B 17 8B 4D F4 03 51 4C 3B C2 7D 08 C7 07 01 00 00 80 EB 19 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 3B 45 E8 0F 94 C0 88 83 E0 02 00 00 8B 06 8B 55 F8 89 02 8B 46 08 8B 55 14 89 02 8B 45 F4 8B 40 4C 03 83 80 02 00 00 01 46 04 EB 06 C7 07 01 00 00 80 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "TCustomActionDockBar.Dock"
		size = 136
		refs = "0015 TControl.Dock 0031 TActionBarItem.SetAutoSize 0075 TControl.SetWidth 007e TControl.SetHeight"
	strings:
		$1 = { 56 57 83 C4 F0 8B F1 8D 3C 24 A5 A5 A5 A5 8B F0 8B CC 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 50 84 C0 74 1C 8B 86 68 02 00 00 85 C0 74 07 B2 01 E8 ?? ?? ?? ?? 33 D2 8B C6 8B 08 FF 51 60 EB 42 33 D2 8B C6 8B 08 FF 51 60 8B 86 68 02 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 78 01 00 00 8B 96 B0 02 00 00 03 D2 3B C2 74 09 8B D0 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TCustomActionDockBar.CreateControls"
		size = 46
		refs = "0006 TCustomActionBar.CreateControls"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB D8 02 00 00 00 74 09 80 BB 7F 02 00 00 02 74 04 33 D2 EB 02 B2 01 8B C3 8B 08 FF 91 70 01 00 00 5B C3 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "TCustomActionDockBar.CreateScrollButtons"
		size = 319
		refs = "0014 TObject.Free 0037 _Dn_TActionBarStyleEx 003c @AsClass 006a TControl.SetAlign 007a TControl.SetHeight 008e TCustomUtilityButton.SetDirection 00a7 TControl.SetVisible 00bd TCustomActionDockBar.ScrollDownClickHandler 0137 TCustomActionDockBar.ScrollUpClickHandler"
	strings:
		$1 = { 56 57 55 8B F0 8D 86 F0 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 F4 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 5C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 14 8B F8 8B CE B2 01 8B C7 FF 50 2C 8B E8 89 AE F0 02 00 00 8B D6 8B C5 8B 08 FF 51 68 B2 02 8B 86 F0 02 00 00 E8 ?? ?? ?? ?? BA 0D 00 00 00 8B 86 F0 02 00 00 E8 ?? ?? ?? ?? 8B 86 F0 02 00 00 C6 80 0C 02 00 00 01 B2 03 E8 ?? ?? ?? ?? 8B 86 F0 02 00 00 8B 96 E4 02 00 00 89 90 08 02 00 00 33 D2 E8 ?? ?? ?? ?? 8B 86 F0 02 00 00 89 B0 04 02 00 00 C7 80 00 02 00 00 ?? ?? ?? ?? 8B CE B2 01 8B C7 FF 50 2C 8B E8 89 AE F4 02 00 00 8B D6 8B C5 8B 08 FF 51 68 B2 01 8B 86 F4 02 00 00 E8 ?? ?? ?? ?? BA 0D 00 00 00 8B 86 F4 02 00 00 E8 ?? ?? ?? ?? 8B 86 F4 02 00 00 C6 80 0C 02 00 00 01 B2 02 E8 ?? ?? ?? ?? 8B 86 F4 02 00 00 8B 96 E4 02 00 00 89 90 08 02 00 00 33 D2 E8 ?? ?? ?? ?? 8B 86 F4 02 00 00 89 B0 04 02 00 00 C7 80 00 02 00 00 ?? ?? ?? ?? 5D 5F 5E C3 }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "TCustomActionDockBar.DoEndDock"
		size = 41
		refs = "000d TControl.DoEndDock 0018 TObject.Free"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B 83 DC 02 00 00 E8 ?? ?? ?? ?? 33 C0 89 83 DC 02 00 00 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TCustomActionDockBar.DoStartDock"
		size = 44
		refs = "000c TControl.DoStartDock 0015 _Dn_TToolDockObject 001a TToolDockObject.Create"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 BB DC 02 00 00 89 3E 5F 5E 5B C3 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TCustomActionDockBar.DoScrollDown"
		size = 22
		refs = "0011 TCustomActionDockBar.SetVisibleIndex"
	strings:
		$1 = { 80 B8 E0 02 00 00 00 75 0C 8B 90 E8 02 00 00 42 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "TCustomActionDockBar.DoScrollUp"
		size = 13
		refs = "0008 TCustomActionDockBar.SetVisibleIndex"
	strings:
		$1 = { 8B 90 E8 02 00 00 4A E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TCustomActionDockBar.GetSiteInfo"
		size = 96
		refs = "0024 TWinControl.GetSiteInfo 0031 _Dn_TCustomActionControl 0036 @IsClass 0042 _Dn_TSpeedButton"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 8B 75 0C 8D 7D F4 A5 A5 89 4D FC 8B F2 8B 5D 08 8D 55 F4 52 53 8B 4D FC 8B D6 E8 ?? ?? ?? ?? 80 3B 00 74 22 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 15 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 03 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "TCustomActionDockBar.Loaded"
		size = 53
		refs = "0008 TWinControl.GetControlCount 001b TWinControl.GetControl 0022 TControl.SetHostDockSite 002d TCustomActionBar.Loaded"
	strings:
		$1 = { 53 56 57 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 17 46 33 FF 8B D7 8B C3 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 47 4E 75 EC 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "TCustomActionDockBar.MakeLastItemVisible"
		size = 86
		refs = "000c @DynArrayHigh 0015 TCustomActionBar.GetItems 001c TActionClients.GetActionClient 0035 TControl.GetClientHeight 004e TCustomActionDockBar.SetVisibleIndex"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 EC 02 00 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 78 4C 8B 83 EC 02 00 00 03 3C B0 EB 01 4E 8B C3 E8 ?? ?? ?? ?? 8B 93 EC 02 00 00 8B CF 2B 0C B2 3B C1 7F E9 8D 56 01 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "TCustomActionDockBar.GenerateControlHeightLookup"
		size = 171
		refs = "0009 TCustomActionBar.HasItems 0018 TCustomActionBar.GetItems 001d TCollection.GetCount 002f :TCustomActionDockBar.:1 0034 @DynArraySetLength 005d TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 91 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 83 EC 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 ED 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 40 47 33 F6 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 25 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 40 4C 8B 93 EC 02 00 00 89 2C B2 03 83 80 02 00 00 03 E8 46 4F 75 C3 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 93 EC 02 00 00 89 6C 82 FC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "TCustomActionDockBar.Resize"
		size = 29
		refs = "0006 TCustomActionBar.Resize 000d TWinControl.Realign"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 74 01 00 00 5B C3 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TCustomActionDockBar.ScrollButtonsVisible"
		size = 48
	strings:
		$1 = { 83 B8 F0 02 00 00 00 74 21 83 B8 F4 02 00 00 00 74 18 8B 90 F0 02 00 00 80 7A 57 00 75 0F 8B 80 F4 02 00 00 80 78 57 00 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TCustomActionDockBar.ScrollDownClickHandler"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 64 01 00 00 C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TCustomActionDockBar.ScrollUpClickHandler"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 68 01 00 00 C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TCustomActionDockBar.SetAllowScrolling"
		size = 53
	strings:
		$1 = { 56 8B F0 3A 96 D8 02 00 00 74 28 88 96 D8 02 00 00 80 BE D8 02 00 00 00 74 09 80 BE 7F 02 00 00 02 74 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 91 70 01 00 00 5E C3 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "TCustomActionDockBar.SetOrientation"
		size = 46
		refs = "0006 TCustomActionBar.SetOrientation"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE D8 02 00 00 00 74 09 80 BE 7F 02 00 00 02 74 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 91 70 01 00 00 5E C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TCustomActionDockBar.SetupScrolling"
		size = 106
		refs = "0036 :TCustomActionDockBar.:1 003b @DynArraySetLength 0051 TObject.Free"
	strings:
		$1 = { 56 8B F0 84 D2 74 20 8B C6 8B 10 FF 92 60 01 00 00 8B C6 8B 10 FF 92 6C 01 00 00 8B C6 8B 10 FF 92 74 01 00 00 5E C3 6A 00 8D 86 EC 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8D 86 F4 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 F0 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TCustomActionDockBar.SetVisibleIndex"
		size = 36
		refs = "0014 TWinControl.Realign"
	strings:
		$1 = { 56 8B F0 3B 96 E8 02 00 00 74 17 89 96 E8 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 74 01 00 00 5E C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "TCustomActionDockBar.ShowScrollButtons"
		size = 105
		refs = "000a @DynArrayHigh 0014 TCustomActionBar.GetItems 0019 TCollection.GetCount 004e TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B 83 EC 02 00 00 E8 ?? ?? ?? ?? 40 7E 56 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 93 EC 02 00 00 8B 44 82 FC 8B 93 AC 02 00 00 03 D2 8B 4B 4C 2B CA 3B C1 7E 09 80 BB E0 02 00 00 00 74 04 33 D2 EB 02 B2 01 8B 83 F0 02 00 00 E8 ?? ?? ?? ?? 83 BB E8 02 00 00 00 0F 9F C2 8B 83 F4 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "TCustomActionToolBar.Create"
		size = 140
		refs = "000a @ClassCreate 0017 TCustomActionDockBar.Create 0020 TControl.SetAlign 002c TControl.SetHeight 0038 TCustomActionBar.SetHorzMargin 003f TCustomActionToolBar.Create 0046 TToolWindow.SetEdgeBorders 004f TToolWindow.SetEdgeInner 0058 TToolWindow.SetEdgeOuter 0061 TCustomActionBar.SetHorzSeparator 006a TCustomActionBar.SetVertSeparator 0075 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? BA 1D 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "TCustomActionToolBar.Destroy"
		size = 76
		refs = "0003 @BeforeDestruction 0012 TObject.Free 003a TCustomActionBar.Destroy 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 04 03 00 00 E8 ?? ?? ?? ?? 83 BE 0C 03 00 00 00 74 13 8D 86 0C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TCustomActionToolBar.AutoSizingChanged"
		size = 162
		refs = "0008 TCustomActionBar.AutoSizingChanged 000f TCustomActionBar.GetAutoSizing 002a TOrderedList.Pop 0031 TControl.SetVisible 0042 TOrderedList.Count 0059 TObject.Free 009a @CallDynaInst"
	strings:
		$1 = { 53 56 57 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 84 C0 75 1E 8B C6 8B 10 FF 92 8C 01 00 00 EB 7B 8B 86 04 03 00 00 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 9E 04 03 00 00 85 DB 74 0B 8B C3 E8 ?? ?? ?? ?? 85 C0 7F D9 8D 86 04 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 10 01 00 00 84 C0 75 15 8D 86 0C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? EB 13 8B BE 0C 03 00 00 85 FF 74 09 33 D2 8B C7 8B 08 FF 51 64 8B C6 66 BE D0 FF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TCustomActionToolBar.CalcButtonWidth"
		size = 72
	strings:
		$1 = { 53 56 57 55 8B F8 83 CD FF 8B C7 8B 10 FF 92 20 01 00 00 8B F0 4E 85 F6 7C 27 46 33 DB 8B D3 8B C7 8B 08 FF 91 14 01 00 00 3B 68 48 7D 0F 8B D3 8B C7 8B 08 FF 91 14 01 00 00 8B 68 48 43 4E 75 DC 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TCustomActionToolBar.CalcDockedWidth"
		size = 25
		refs = "0006 TCustomActionDockBar.CalcDockedWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 93 0C 03 00 00 85 D2 74 03 03 42 48 5B C3 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "TCustomActionToolBar.CreateControl"
		size = 122
		refs = "000a TCustomActionBar.CreateControl 001c TCustomActionControl.SetSpacing 0037 Rect 0040 TCustomActionControl.SetMargins 0063 TActionClient.GetItems 006e TCustomActionControl.SetSmallIcon"
	strings:
		$1 = { 56 57 83 C4 F0 8B F8 8B C7 E8 ?? ?? ?? ?? 8B F0 85 F6 74 5E BA 03 00 00 00 8B C6 E8 ?? ?? ?? ?? 6A 04 8D 44 24 04 50 B9 04 00 00 00 BA 04 00 00 00 B8 04 00 00 00 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 8B 87 68 02 00 00 85 C0 74 24 0F B6 50 3D 8B C6 8B 08 FF 91 E0 00 00 00 8B 87 68 02 00 00 E8 ?? ?? ?? ?? 0F B6 50 29 8B C6 E8 ?? ?? ?? ?? 8B C6 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TCustomActionToolBar.CreateControls"
		size = 41
		refs = "0012 TObject.Free 0023 TCustomActionDockBar.CreateControls"
	strings:
		$1 = { 53 8B D8 8D 83 0C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 8C 01 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TCustomActionToolBar.DisableHiding"
		size = 7
	strings:
		$1 = { FF 80 F8 02 00 00 C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TCustomActionBar.GetControlClass"
		size = 27
		altNames = "TCustomActionToolBar.GetControlClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 5C 01 00 00 8B CE 8B D3 8B 18 FF 13 5E 5B C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "TCustomActionToolBar.DoDropCategory"
		size = 138
		refs = "001e Point 0028 TCustomActionBar.FindNearestControl 0040 TCollectionItem.GetIndex 004b TActionDragObject.GetActionCount 005f TActionDragObject.GetAction 006b TActionClient.GetItems 0073 TCollection.Insert 0079 TActionClientItem.SetAction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B D9 89 55 FC 8B F8 33 C0 89 45 F8 8D 4D F0 8B 55 08 8B C3 E8 ?? ?? ?? ?? 8D 55 F0 8B C7 E8 ?? ?? ?? ?? 85 C0 74 17 83 B8 AC 01 00 00 00 74 0E 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 2B 43 33 F6 8B D6 8B 45 FC E8 ?? ?? ?? ?? 50 8B 87 68 02 00 00 E8 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 46 4B 75 D8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TCustomActionToolBar.DoScrollBtnClick"
		size = 628
		refs = "0016 TActionClient.GetItems 001f _Dn_TCustomizeActionClientItem 0024 TActionClientItem.Create 0044 TCollection.GetCount 0070 TActionClients.GetActionClient 007b TList.IndexOf 008b TActionClients.Add 0094 TCustomActionToolBar.DoScrollBtnClick 00c3 TActionClientItem.SetUsageCount 00fb _Dn_TCustomizeActionToolBar 0100 @AsClass 010a TCustomActionBar.GetColorMap 015e TWinControl.Realign 0199 Point 01a7 TControl.ClientToScreen 0217 TCustomActionPopupMenu.Popup 0232 TObject.Free 025c @CallDynaInst 0262 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 89 45 FC 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 D2 8B 45 F8 8B 08 FF 51 2C 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 7C 46 33 DB 8B 45 FC 8B B8 04 03 00 00 85 FF 74 68 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 50 44 8B 47 04 E8 ?? ?? ?? ?? 40 74 45 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 0F B6 15 ?? ?? ?? ?? 8B C7 8B 08 FF 51 24 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B D0 8B C7 8B 08 FF 51 08 83 CA FF 8B C7 E8 ?? ?? ?? ?? 43 4E 75 87 8B 45 FC 8B 10 FF 92 84 01 00 00 8B 4D FC B2 01 FF 50 2C 8B D8 8B 45 FC 89 98 08 03 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 38 01 00 00 8B 45 FC 8B 80 08 03 00 00 89 83 2C 03 00 00 8B 45 FC 8B 80 0C 03 00 00 89 83 18 03 00 00 8B 55 FC 8B C3 8B 08 FF 51 68 8B 55 F8 8B C3 8B 08 FF 91 30 01 00 00 B2 01 8B C3 8B 08 FF 91 94 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 0F B6 80 7F 02 00 00 2C 02 72 67 74 3B FE C8 0F 85 94 00 00 00 8B 45 FC 8B B0 0C 03 00 00 8B 56 44 8B 45 FC 8B 80 08 03 00 00 2B 50 4C 8D 4D E8 8B 46 40 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F0 8B 45 FC E8 ?? ?? ?? ?? EB 61 8B 45 FC 8B B0 0C 03 00 00 8B 56 44 03 56 4C 8D 4D E8 8B 46 40 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F0 8B 45 FC E8 ?? ?? ?? ?? EB 37 8B 45 FC 8B B0 0C 03 00 00 8B 56 44 03 56 4C 8B 46 40 8B 4D FC 8B 89 08 03 00 00 2B 41 48 03 46 48 8D 4D E8 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F0 8B 45 FC E8 ?? ?? ?? ?? 8B 4D F4 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 08 03 00 00 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 08 03 00 00 8B 45 F8 8B 40 44 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 66 BE D0 FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 5F 5E 5B 8B E5 5D C3 00 07 00 00 00 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TCustomActionToolBar.DrawBackground"
		size = 321
		refs = "000a TCustomActionBar.DrawBackground 0023 TCustomActionBar.GetAutoSizing"
	strings:
		$1 = { 53 56 57 55 51 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 20 01 00 00 85 C0 0F 84 1B 01 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 0C 01 00 00 8B C6 8B 10 FF 92 54 01 00 00 8B F8 8B C6 8B 10 FF 92 F8 00 00 00 8B D8 85 FF 0F 84 EC 00 00 00 85 DB 0F 84 E4 00 00 00 83 7F 44 00 0F 84 DA 00 00 00 83 7B 44 00 0F 84 D0 00 00 00 8B 47 44 8B 40 44 8B 53 44 3B 42 44 0F 84 BE 00 00 00 80 BE B4 02 00 00 00 74 55 0F B6 86 7F 02 00 00 2C 02 73 4A 8B BE A8 02 00 00 4F 85 FF 7E 3F C7 04 24 01 00 00 00 8B 86 AC 02 00 00 03 C0 8B D0 8B 4B 44 03 51 4C 83 C0 02 8B 4B 44 03 41 4C 8B 0C 24 49 0F AF C1 03 D0 42 B9 02 00 00 00 8B C6 8B 28 FF 95 7C 01 00 00 FF 04 24 4F 75 C8 80 BE C0 02 00 00 00 74 57 0F B6 86 7F 02 00 00 04 FE 2C 02 73 4A 8B BE A4 02 00 00 4F 85 FF 7E 3F C7 04 24 01 00 00 00 8B 86 B0 02 00 00 03 C0 8B D0 8B 4B 44 03 51 48 83 C0 02 8B 4B 44 03 41 48 8B 0C 24 49 0F AF C1 03 D0 42 B9 02 00 00 00 8B C6 8B 28 FF 95 7C 01 00 00 FF 04 24 4F 75 C8 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TCustomActionToolBar.DrawSeparator"
		size = 291
		refs = "0025 Point 002c TControl.GetClientHeight 006c TControl.GetClientWidth 008f TPen.SetWidth 0096 TCustomActionBar.GetColorMap 00a1 TPen.SetColor 00b1 TCanvas.MoveTo 00c2 TCanvas.LineTo 00ce TCustomActionBarColorMap.GetUnusedColor"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F9 8B DA 8B F0 0F B6 86 7F 02 00 00 04 FE 2C 02 73 28 8B CC 8B D7 4A 8B EB 4D 8B C5 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 2B D7 42 8D 4C 24 08 8B C5 E8 ?? ?? ?? ?? EB 3E 33 D2 8B C6 8B 08 FF 91 04 01 00 00 03 C7 8B CC 8B EB 4D 8B D5 E8 ?? ?? ?? ?? B2 01 8B C6 8B 08 FF 91 04 01 00 00 50 8B C6 E8 ?? ?? ?? ?? 2B C7 5A 2B C2 8D 4C 24 08 8B D5 E8 ?? ?? ?? ?? 8B 9E 74 02 00 00 BA 01 00 00 00 8B 43 10 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 50 58 8B 43 10 E8 ?? ?? ?? ?? 8B 4C 24 04 8B 3C 24 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 4C 24 0C 8B 6C 24 08 8B D5 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 10 E8 ?? ?? ?? ?? 3B EF 75 1F 8B F7 46 8B D6 8B 4C 24 04 8B C3 E8 ?? ?? ?? ?? 8B D6 8B 4C 24 0C 8B C3 E8 ?? ?? ?? ?? EB 1C 8B 4C 24 04 41 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 4C 24 0C 41 8B D5 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TCustomActionToolBar.EnableHiding"
		size = 30
		refs = "0019 TCustomActionToolBar.HideUnusedItems"
	strings:
		$1 = { 83 B8 F8 02 00 00 00 7E 14 FF 88 F8 02 00 00 83 B8 F8 02 00 00 00 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TCustomActionToolBar.GetHiddenCount"
		size = 24
		refs = "000f TOrderedList.Count"
	strings:
		$1 = { 33 D2 8B 88 04 03 00 00 85 C9 74 09 8B C1 E8 ?? ?? ?? ?? 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "HideItem"
		size = 537
		refs = "004a TControl.GetBoundsRect 0107 TControl.GetClientWidth 01cb TControl.GetClientHeight"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B D8 33 C0 85 DB 0F 84 FF 01 00 00 8B 55 08 8B 52 FC 3B 93 AC 01 00 00 0F 85 A0 00 00 00 8B 55 08 8B 52 F8 0F B6 92 7F 02 00 00 80 EA 01 72 0C 74 22 FE CA 74 54 FE CA 74 35 EB 64 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 08 3B 42 E8 0F 9D C0 EB 4C 8B 55 08 8B 52 F0 8B 45 08 8B 40 E8 2B D0 8B 4D 08 03 D0 3B 53 40 0F 9D C0 EB 31 8B 55 08 8B 52 F4 8B 45 08 8B 40 EC 2B D0 8B 4D 08 03 D0 3B 53 44 0F 9D C0 EB 16 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 55 08 3B 42 EC 0F 9D C0 84 C0 74 0C 8B 83 AC 01 00 00 80 78 30 00 75 07 33 C0 E9 54 01 00 00 B0 01 E9 4D 01 00 00 8B 55 08 8B 52 F8 0F B6 92 7F 02 00 00 80 EA 01 72 17 74 7D FE CA 0F 84 E2 00 00 00 FE CA 0F 84 A5 00 00 00 E9 24 01 00 00 8B 45 08 8B 40 F8 B2 01 8B 08 FF 91 04 01 00 00 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B 40 F8 2B B0 B0 02 00 00 58 2B F0 8B 45 08 8B 40 F0 8B 55 08 2B 42 E8 2B F0 8D 55 F0 8B 45 08 8B 40 FC 8B 40 44 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 08 8B 52 F8 03 82 80 02 00 00 03 43 48 3B F0 0F 9C C0 E9 BC 00 00 00 8B 55 08 8B 52 FC 8B 52 44 8B 52 40 8B 4D 08 8B 49 F8 2B 91 80 02 00 00 8B 4D 08 8B 49 F0 8B 45 08 8B 40 E8 2B C8 8B 75 08 03 C8 2B D1 3B 53 48 0F 9C C0 E9 84 00 00 00 8B 55 08 8B 52 FC 8B 52 44 8B 52 44 8B 4D 08 8B 49 F8 2B 91 80 02 00 00 8B 4D 08 8B 49 F4 8B 45 08 8B 40 EC 2B C8 8B 75 08 03 C8 2B D1 3B 53 4C 0F 9C C0 EB 4F 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B 40 F8 2B B0 80 02 00 00 8B 45 08 8B 40 F8 2B B0 AC 02 00 00 8B 45 08 8B 40 F4 8B 55 08 2B 42 EC 2B F0 8D 55 F0 8B 45 08 8B 40 FC 8B 40 44 E8 ?? ?? ?? ?? 8B 45 FC 03 43 4C 3B F0 0F 9C C0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "TCustomActionToolBar.HideUnusedItems"
		size = 544
		refs = "0012 TCustomActionBar.GetAutoSizing 003f TControl.GetBoundsRect 0052 Rect 0059 TCustomActionBar.FindLastVisibleItem 0072 HideItem 0088 TActionClient.GetItems 0097 TCustomActionBar.FindLeastUsedItem 00b7 TCustomActionBar.FindFirstVisibleItem 00d2 _DV_TItemsStack 00d7 TOrderedList.Create 00fd TCustomActionToolBar.HideUnusedItems 0110 TOrderedList.Push 011a TControl.SetVisible 0136 TOrderedList.Count 014c TOrderedList.Peek 019f TOrderedList.Pop 01d1 TObject.Free 01ec TCustomActionToolBar.GetHiddenCount"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 89 45 F8 8D 7D F8 8B 07 E8 ?? ?? ?? ?? 84 C0 0F 85 F4 01 00 00 8B 07 83 B8 F8 02 00 00 00 0F 8F E5 01 00 00 8B 07 8B 98 0C 03 00 00 85 DB 74 0C 8D 55 E8 8B C3 E8 ?? ?? ?? ?? EB 11 6A 00 8D 45 E8 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 07 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 A8 01 00 00 55 8B 45 FC 8B 40 44 E8 ?? ?? ?? ?? 59 84 C0 0F 84 A4 00 00 00 8B 07 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 80 78 2A 00 74 0D B2 01 8B 07 E8 ?? ?? ?? ?? 8B D8 EB 03 8B 5D FC 85 DB 0F 84 2B 01 00 00 80 7B 30 00 0F 84 21 01 00 00 8B 07 E8 ?? ?? ?? ?? 3B 45 FC 0F 84 11 01 00 00 8B 07 83 B8 04 03 00 00 00 75 1E B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 17 89 82 04 03 00 00 8B 07 8B 10 FF 92 8C 01 00 00 8B 07 F6 40 1C 10 74 0F 8B 73 44 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 8B 07 8B 80 04 03 00 00 8B 53 44 E8 ?? ?? ?? ?? 33 D2 8B 43 44 E8 ?? ?? ?? ?? E9 B2 00 00 00 8B 07 8B 98 04 03 00 00 85 DB 0F 84 A2 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 8E 93 00 00 00 55 8B 07 8B 80 04 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 84 C0 75 7B 8B 07 F6 40 1C 10 74 1B 8B 07 8B 80 04 03 00 00 E8 ?? ?? ?? ?? 8B D8 8B 43 50 0B 05 ?? ?? ?? ?? 89 43 50 8B 07 8B 80 04 03 00 00 E8 ?? ?? ?? ?? 8B 80 AC 01 00 00 80 78 30 00 74 14 8B 07 8B 80 04 03 00 00 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 07 8B 98 04 03 00 00 85 DB 74 1F 8B C3 E8 ?? ?? ?? ?? 85 C0 75 14 8B 07 05 04 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 07 8B B0 0C 03 00 00 85 F6 74 31 8B 07 F6 40 1C 10 75 1C 8B 07 E8 ?? ?? ?? ?? 85 C0 7F 15 8B 07 8B 80 6C 02 00 00 83 B8 90 00 00 00 00 75 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 51 64 5F 5E 5B 8B E5 5D C3 00 00 00 00 04 00 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TCustomActionToolBar.ScrollBtnClick"
		size = 27
	strings:
		$1 = { 83 B8 08 03 00 00 00 75 11 83 B8 68 02 00 00 00 74 08 8B 10 FF 92 88 01 00 00 C3 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "TCustomActionToolBar.SetOrientation"
		size = 215
		refs = "000e TCustomActionToolBar.DisableHiding 0016 TCustomActionToolBar.SetOrientation 0038 TOrderedList.Pop 003f TControl.SetVisible 004d TOrderedList.Count 0066 TObject.Free 0070 TCustomActionDockBar.SetOrientation 008e ArrowDirection 0093 TCustomUtilityButton.SetDirection 00a4 BtnAlignment 00b2 TControl.SetAlign 00c7 TCustomActionToolBar.EnableHiding 00cd @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 83 B8 04 03 00 00 00 74 29 EB 15 8B 45 FC 8B 80 04 03 00 00 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 04 03 00 00 E8 ?? ?? ?? ?? 85 C0 7F D9 8B 45 FC 05 04 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 0C 03 00 00 85 C0 74 35 8B 55 FC 0F B6 92 7F 02 00 00 0F B6 92 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 0F B6 80 7F 02 00 00 0F B6 90 ?? ?? ?? ?? 8B 45 FC 8B 80 0C 03 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "TCustomActionToolBar.SetupDropDownBtn"
		size = 244
		refs = "0007 TCustomActionBar.GetAutoSizing 004d SMoreButtons 0052 LoadResString 0060 ArrowDirection 0067 TCustomUtilityButton.SetDirection 0075 BtnAlignment 007c TControl.SetAlign 0089 TCustomActionToolBar.GetHiddenCount 00bb TControl.SetParentColor 00c6 TActionClient.HasBackground 00cf TCustomActionControl.SetTransparent 00ed TCustomActionToolBar.ScrollBtnClick"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 85 DE 00 00 00 83 BB 0C 03 00 00 00 0F 85 D1 00 00 00 83 BB 68 02 00 00 00 0F 84 C4 00 00 00 8B C3 8B 10 FF 92 80 01 00 00 8B CB B2 01 FF 50 2C 8B F0 89 B3 0C 03 00 00 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 83 7F 02 00 00 0F B6 90 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 83 7F 02 00 00 0F B6 90 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? F6 46 1C 10 75 1A 8B C3 E8 ?? ?? ?? ?? 85 C0 7F 13 8B 83 6C 02 00 00 83 B8 90 00 00 00 00 75 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 51 64 8B D3 8B C6 8B 08 FF 51 68 B2 01 8B C6 E8 ?? ?? ?? ?? 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 83 0C 03 00 00 8B 10 FF 92 E8 00 00 00 89 9E 04 02 00 00 C7 86 00 02 00 00 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TCustomActionToolBar.Reset"
		size = 143
		refs = "000b TCustomActionToolBar.DisableHiding 0013 TCustomActionToolBar.Reset 0035 TOrderedList.Pop 003c TControl.SetVisible 004a TOrderedList.Count 0063 TObject.Free 006b TCustomActionBar.Reset 0080 TCustomActionToolBar.EnableHiding 0086 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 83 B8 04 03 00 00 00 74 3E EB 15 8B 45 FC 8B 80 04 03 00 00 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 04 03 00 00 E8 ?? ?? ?? ?? 85 C0 7F D9 8B 45 FC 05 04 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "TCustomActionToolBar.CMColorchanged"
		size = 54
		refs = "0006 TWinControl.CMColorChanged 0015 ColorAdjustLuma"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 C9 BA AB FF FF FF 8B 43 6C E8 ?? ?? ?? ?? 89 83 FC 02 00 00 33 C9 BA 55 00 00 00 8B 43 6C E8 ?? ?? ?? ?? 89 83 00 03 00 00 5B C3 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "TCustomActionToolBar.SetBounds"
		size = 44
		refs = "0011 TCustomActionBar.SetBounds 0018 TCustomActionBar.GetAutoSizing 0023 TCustomActionToolBar.HideUnusedItems"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 0C 50 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "TCustomActionToolBar.DragDrop"
		size = 74
		refs = "0015 TCustomActionBar.DragDrop 0034 TCustomActionBar.GetAutoSizing 003f TCustomActionToolBar.HideUnusedItems"
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B D8 8B 45 08 50 8B 4D FC 8B C3 E8 ?? ?? ?? ?? 8B 43 48 50 8B 43 4C 50 8B 4B 44 8B 53 40 8B C3 8B 30 FF 96 88 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "TCustomActionToolBar.GetPopupClass"
		size = 33
		refs = "000f _Dn_TActionBarStyleEx 0014 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 5C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 0C 5B C3 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "TCustomActionToolBar.GetScrollBtnClass"
		size = 31
		refs = "000f _Dn_TActionBarStyleEx 0014 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 5C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 14 5B C3 }
	condition:
		$1
}

rule function_607_0 {
	meta:
		name = "RegisterActions"
		size = 53
		refs = "0006 RegisterActionsProc 001b SInvalidActionRegistration 0022 _Dn_Exception 0027 Exception.CreateRes 002c @RaiseExcept"
	strings:
		$1 = { 55 8B EC 53 83 3D ?? ?? ?? ?? 00 74 0C 8B 5D 08 53 FF 15 ?? ?? ?? ?? EB 17 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "UnRegisterActions"
		size = 40
		refs = "0002 UnRegisterActionsProc 0012 SInvalidActionUnregistration 0019 _Dn_Exception 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_610_0 {
	meta:
		name = "CreateAction"
		size = 40
		refs = "0002 CreateActionProc 0012 SInvalidActionCreation 0019 _Dn_Exception 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4046_0 {
	meta:
		name = "RegisterNoIcon"
		size = 40
		refs = "0002 RegisterNoIconProc 0012 SRegisterError 0019 _DV_EComponentError 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_59703_0 {
	meta:
		name = "RegisterWebComponents"
		size = 40
		refs = "0002 RegisterWebComponentsProc 0012 sInvalidWebComponentsRegistration 0019 _Dn_Exception 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "EnumRegisteredActions"
		size = 53
		refs = "0005 EnumRegisteredActionsProc 001c SInvalidActionEnumeration 0023 _Dn_Exception 0028 Exception.CreateRes 002d @RaiseExcept"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 0E FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 17 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_59705_0 {
	meta:
		name = "EnumRegisteredWebComponents"
		size = 53
		refs = "0005 EnumRegisteredWebComponentsProc 001c sInvalidWebComponentsEnumeration 0023 _Dn_Exception 0028 Exception.CreateRes 002d @RaiseExcept"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 0E FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 17 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_611_0 {
	meta:
		name = "TContainedAction.Destroy"
		size = 51
		refs = "0003 @BeforeDestruction 0015 TCustomActionList.RemoveAction 0021 TBasicAction.Destroy 002c @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 5C 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "TContainedAction.GetIndex"
		size = 21
		refs = "000c TList.IndexOf"
	strings:
		$1 = { 8B 50 5C 85 D2 74 0A 8B 52 30 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "TContainedAction.GetParentComponent"
		size = 16
		refs = "000b TComponent.GetParentComponent"
	strings:
		$1 = { 8B 50 5C 85 D2 74 03 8B C2 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "TContainedAction.HasParent"
		size = 15
		refs = "000a TComponent.HasParent"
	strings:
		$1 = { 83 78 5C 00 74 03 B0 01 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "TContainedAction.ReadState"
		size = 49
		refs = "000c TComponent.ReadState 0017 _DV_TCustomActionList 001c @IsClass 0029 TContainedAction.SetActionList"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 2C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5129_0 {
	meta:
		name = "TTabSheet.ReadState"
		size = 49
		refs = "000c TWinControl.ReadState 0017 _DV_TPageControl 001c @IsClass 0029 TTabSheet.SetPageControl"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 2C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TContainedAction.SetIndex"
		size = 71
		refs = "000a TContainedAction.GetIndex 0030 TList.Delete 003f TList.Insert"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 31 8B 53 5C 8B 7A 30 8B 57 08 85 F6 7D 02 33 F6 3B D6 7F 03 8B F2 4E 3B C6 74 17 8B D7 92 E8 ?? ?? ?? ?? 8B 43 5C 8B 40 30 8B CB 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TContainedAction.SetCategory"
		size = 43
		refs = "000c @UStrEqual 0018 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 58 E8 ?? ?? ?? ?? 74 16 8D 43 58 8B D6 E8 ?? ?? ?? ?? 8B 43 5C 85 C0 74 05 8B 10 FF 52 30 5E 5B C3 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TContainedAction.SetActionList"
		size = 40
		refs = "0014 TCustomActionList.RemoveAction 0021 TCustomActionList.AddAction"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 5C 3B F0 74 18 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "TContainedAction.SetParentComponent"
		size = 41
		refs = "0010 _DV_TCustomActionList 0015 @IsClass 0022 TContainedAction.SetActionList"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 01 75 1A 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "TContainedAction.Execute"
		size = 85
		refs = "0015 @CallDynaInst 001e Application 0027 TApplication.ExecuteAction 0032 TBasicAction.Execute 0044 SendAppMessage"
	strings:
		$1 = { 53 56 57 8B D8 8B 7B 5C 85 FF 74 11 8B D3 8B C7 66 BE F3 FF E8 ?? ?? ?? ?? 84 C0 75 32 A1 ?? ?? ?? ?? 8B 00 8B D3 E8 ?? ?? ?? ?? 84 C0 75 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 15 8B CB 33 D2 B8 40 B0 00 00 E8 ?? ?? ?? ?? 48 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "TContainedAction.Update"
		size = 85
		refs = "0015 @CallDynaInst 001e Application 0027 TApplication.UpdateAction 0032 TBasicAction.Update 0044 SendAppMessage"
	strings:
		$1 = { 53 56 57 8B D8 8B 7B 5C 85 FF 74 11 8B D3 8B C7 66 BE F0 FF E8 ?? ?? ?? ?? 84 C0 75 32 A1 ?? ?? ?? ?? 8B 00 8B D3 E8 ?? ?? ?? ?? 84 C0 75 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 15 8B CB 33 D2 B8 3F B0 00 00 E8 ?? ?? ?? ?? 48 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "TActionListEnumerator.Create"
		size = 67
		refs = "000b @ClassCreate 001a TObject.Create 002f @AfterConstruction"
		altNames = "TCollectionEnumerator.Create TComponentEnumerator.Create TFavoriteLinkItemsEnumerator.Create TFieldsEnumerator.Create TInterfaceListEnumerator.Create TKeyTipListEnumerator.Create TListEnumerator.Create TListItemsEnumerator.Create TMenuItemEnumerator.Create TStringsEnumerator.Create TTaskDialogButtonsEnumerator.Create TToolBarEnumerator.Create TTreeNodesEnumerator.Create TWideStringsEnumerator.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? C7 47 04 FF FF FF FF 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "TActionListEnumerator.GetCurrent"
		size = 12
		refs = "0007 TCustomActionList.GetAction"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4174_0 {
	meta:
		name = "TCollectionEnumerator.GetCurrent"
		size = 12
		refs = "0007 TCollection.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4655_0 {
	meta:
		name = "TComponentEnumerator.GetCurrent"
		size = 12
		refs = "0007 TComponent.GetComponent"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17225_0 {
	meta:
		name = "TFavoriteLinkItemsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TFavoriteLinkItems.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8809_0 {
	meta:
		name = "TFieldsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TFields.GetField"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_47597_0 {
	meta:
		name = "TKeyTipListEnumerator.GetCurrent"
		size = 12
		refs = "0007 TKeyTipList.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4077_0 {
	meta:
		name = "TListEnumerator.GetCurrent"
		size = 12
		refs = "0007 TList.Get"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5830_0 {
	meta:
		name = "TListItemsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TListItems.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_41817_0 {
	meta:
		name = "TMenuItemEnumerator.GetCurrent"
		size = 12
		refs = "0007 TMenuItem.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17304_0 {
	meta:
		name = "TTaskDialogButtonsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TTaskDialogButtons.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6096_0 {
	meta:
		name = "TToolBarEnumerator.GetCurrent"
		size = 12
		refs = "0007 TToolBar.GetButton"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5387_0 {
	meta:
		name = "TTreeNodesEnumerator.GetCurrent"
		size = 12
		refs = "0007 TTreeNodes.GetNodeFromIndex"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TActionListEnumerator.MoveNext"
		size = 27
		refs = "0007 TCustomActionList.GetActionCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_4175_0 {
	meta:
		name = "TCollectionEnumerator.MoveNext"
		size = 27
		refs = "0007 TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_4656_0 {
	meta:
		name = "TComponentEnumerator.MoveNext"
		size = 27
		refs = "0007 TComponent.GetComponentCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_17226_0 {
	meta:
		name = "TFavoriteLinkItemsEnumerator.MoveNext"
		size = 27
		refs = "0007 TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_8810_0 {
	meta:
		name = "TFieldsEnumerator.MoveNext"
		size = 27
		refs = "0007 TFields.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_4115_0 {
	meta:
		name = "TInterfaceListEnumerator.MoveNext"
		size = 27
		refs = "0007 TInterfaceList.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_47598_0 {
	meta:
		name = "TKeyTipListEnumerator.MoveNext"
		size = 27
		refs = "0007 TKeyTipList.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_5831_0 {
	meta:
		name = "TListItemsEnumerator.MoveNext"
		size = 27
		refs = "0007 TListItems.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_41818_0 {
	meta:
		name = "TMenuItemEnumerator.MoveNext"
		size = 27
		refs = "0007 TMenuItem.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_17305_0 {
	meta:
		name = "TTaskDialogButtonsEnumerator.MoveNext"
		size = 27
		refs = "0007 TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_6097_0 {
	meta:
		name = "TToolBarEnumerator.MoveNext"
		size = 27
		refs = "0007 TToolBar.GetButtonCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_5388_0 {
	meta:
		name = "TTreeNodesEnumerator.MoveNext"
		size = 27
		refs = "0007 TTreeNodes.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_626_0 {
	meta:
		name = "TCustomActionList.Create"
		size = 108
		refs = "000e @ClassCreate 001c TComponent.Create 0023 _Dn_TList 0028 TObject.Create 0032 _Dn_TChangeLink 0046 TCustomActionList.ImageListChange 0057 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 30 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 34 89 5E 0C C7 46 08 ?? ?? ?? ?? C6 43 58 00 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TCustomActionList.Destroy"
		size = 86
		refs = "0004 @BeforeDestruction 0010 TObject.Free 0019 TList.Last 0043 TComponent.Destroy 004e @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F8 8B 47 34 E8 ?? ?? ?? ?? EB 0C 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 77 30 83 7E 08 00 7F EB 8D 47 30 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C7 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TCustomActionList.GetChildren"
		size = 71
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 89 55 F8 89 45 FC 8B 45 FC 8B 40 30 8B 58 08 4B 85 DB 7C 23 43 33 F6 8B 45 FC 8B 40 30 8B 40 04 8B 04 B0 8B 50 04 3B 55 F8 75 08 8B D0 8B 45 0C FF 55 08 46 4B 75 E0 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TCustomActionList.SetChildOrder"
		size = 47
		refs = "000f TList.IndexOf 001b _DV_TContainedAction 0020 @AsClass 0027 TContainedAction.SetIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 85 C0 7C 14 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TCustomActionList.GetAction"
		size = 19
		refs = "000c TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2166_0 {
	meta:
		name = "TMultiCaster.GetAppEvents"
		size = 19
		refs = "000c TComponentList.GetItems"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60528_0 {
	meta:
		name = "TScriptProducer.GetScript"
		size = 19
		refs = "000c TScriptFile.GetScript"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TCustomActionList.GetActionCount"
		size = 7
		altNames = "TIWBaseComponent.get_ExtraTagParams TMultiCaster.GetCount TWebContainedContainerComponent.GetWebComponents TWebContainerComponent.GetWebComponents"
	strings:
		$1 = { 8B 40 30 8B 40 08 C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "TCustomActionList.GetEnumerator"
		size = 15
		refs = "0005 _DV_TActionListEnumerator 000a TActionListEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_44510_0 {
	meta:
		name = "TAutoObject.CreateAutoDispatch"
		size = 15
		refs = "0005 _DV_TAutoDispatch 000a TAutoDispatch.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4187_0 {
	meta:
		name = "TCollection.GetEnumerator"
		size = 15
		refs = "0005 _DV_TCollectionEnumerator 000a TCollectionEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11164_0 {
	meta:
		name = "TColumn.CreateTitle"
		size = 15
		refs = "0005 _DV_TColumnTitle 000a TColumnTitle.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4679_0 {
	meta:
		name = "TComponent.GetEnumerator"
		size = 15
		refs = "0005 _DV_TComponentEnumerator 000a TComponentEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58924_0 {
	meta:
		name = "TCustomAdapter.CreateErrorsList"
		size = 15
		refs = "0005 _DV_TAdapterErrorsList 000a TAdapterErrorsList.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11269_0 {
	meta:
		name = "TCustomDBGrid.CreateDataLink"
		size = 15
		refs = "0005 _DV_TGridDataLink 000a TGridDataLink.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11270_0 {
	meta:
		name = "TCustomDBGrid.CreateEditor"
		size = 15
		refs = "0005 _DV_TDBGridInplaceEdit 000a TDBGridInplaceEdit.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21607_0 {
	meta:
		name = "TCustomGrid.CreateEditor"
		size = 15
		refs = "0005 _DV_TInplaceEdit 000a TInplaceEdit.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5313_0 {
	meta:
		name = "TCustomHeaderControl.CreateSections"
		size = 15
		refs = "0005 _DV_THeaderSections 000a THeaderSections.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5917_0 {
	meta:
		name = "TCustomListView.CreateListItems"
		size = 15
		refs = "0005 _DV_TListItems 000a TListItems.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5239_0 {
	meta:
		name = "TCustomStatusBar.CreatePanels"
		size = 15
		refs = "0005 _DV_TStatusPanels 000a TStatusPanels.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5506_0 {
	meta:
		name = "TCustomTreeView.CreateNodes"
		size = 15
		refs = "0005 _DV_TTreeNodes 000a TTreeNodes.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13269_0 {
	meta:
		name = "TDBXDriverHelp.CreateTDBXParameter"
		size = 15
		refs = "0005 _DV_TDBXParameter 000a TDBXParameter.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13270_0 {
	meta:
		name = "TDBXDriverHelp.CreateTDBXProperties"
		size = 15
		refs = "0005 _DV_TDBXProperties 000a TDBXProperties.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13271_0 {
	meta:
		name = "TDBXDriverHelp.CreateTDBXValueType"
		size = 15
		refs = "0005 _DV_TDBXValueType 000a TDBXValueType.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_53804_0 {
	meta:
		name = "TEncoding.GetEncoding"
		size = 15
		refs = "0005 _DV_TMBCSEncoding 000a TMBCSEncoding.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17229_0 {
	meta:
		name = "TFavoriteLinkItems.GetEnumerator"
		size = 15
		refs = "0005 _DV_TFavoriteLinkItemsEnumerator 000a TFavoriteLinkItemsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8825_0 {
	meta:
		name = "TFields.GetEnumerator"
		size = 15
		refs = "0005 _DV_TFieldsEnumerator 000a TFieldsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24972_0 {
	meta:
		name = "TIdCookies.Add"
		size = 15
		refs = "0005 _DV_TIdCookieRFC2109 000a TIdCookieRFC2109.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24973_0 {
	meta:
		name = "TIdCookies.Add2"
		size = 15
		refs = "0005 _DV_TIdCookieRFC2965 000a TIdCookieRFC2965.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24981_0 {
	meta:
		name = "TIdServerCookies.Add"
		size = 15
		refs = "0005 _DV_TIdServerCookie 000a TIdServerCookie.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4125_0 {
	meta:
		name = "TInterfaceList.GetEnumerator"
		size = 15
		refs = "0005 _DV_TInterfaceListEnumerator 000a TInterfaceListEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4090_0 {
	meta:
		name = "TList.GetEnumerator"
		size = 15
		refs = "0005 _DV_TListEnumerator 000a TListEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5838_0 {
	meta:
		name = "TListItems.GetEnumerator"
		size = 15
		refs = "0005 _DV_TListItemsEnumerator 000a TListItemsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10025_0 {
	meta:
		name = "TLocateParamsList.Add"
		size = 15
		refs = "0005 _DV_TLocateParams 000a TLocateParams.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_41917_0 {
	meta:
		name = "TMenu.CreateMenuItem"
		size = 15
		refs = "0005 _DV_TMenuItem 000a TMenuItem.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_41838_0 {
	meta:
		name = "TMenuItem.GetEnumerator"
		size = 15
		refs = "0005 _DV_TMenuItemEnumerator 000a TMenuItemEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50534_0 {
	meta:
		name = "TServerSocketThread.CreateThread"
		size = 15
		refs = "0005 _DV_TClientSocketThread 000a TClientSocketThread.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4233_0 {
	meta:
		name = "TStrings.GetEnumerator"
		size = 15
		refs = "0005 _DV_TStringsEnumerator 000a TStringsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17310_0 {
	meta:
		name = "TTaskDialogButtons.GetEnumerator"
		size = 15
		refs = "0005 _DV_TTaskDialogButtonsEnumerator 000a TTaskDialogButtonsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6122_0 {
	meta:
		name = "TToolBar.GetEnumerator"
		size = 15
		refs = "0005 _DV_TToolBarEnumerator 000a TToolBarEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5412_0 {
	meta:
		name = "TTreeNodes.GetEnumerator"
		size = 15
		refs = "0005 _DV_TTreeNodesEnumerator 000a TTreeNodesEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_61088_0 {
	meta:
		name = "TWideStrings.GetEnumerator"
		size = 15
		refs = "0005 _DV_TWideStringsEnumerator 000a TWideStringsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TCustomActionList.SetAction"
		size = 30
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TCustomActionList.SetImages"
		size = 51
		refs = "0011 TCustomImageList.UnRegisterChanges 0022 TCustomImageList.RegisterChanges 002c TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 38 85 C0 74 08 8B 53 34 E8 ?? ?? ?? ?? 8B C6 89 43 38 85 C0 74 12 8B 53 34 E8 ?? ?? ?? ?? 8B D3 8B 43 38 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "TCustomActionList.ImageListChange"
		size = 11
	strings:
		$1 = { 3B 50 38 75 05 8B 10 FF 52 30 C3 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "TCustomActionList.Notification"
		size = 77
		refs = "0010 TComponent.Notification 0033 _DV_TContainedAction 0038 @IsClass 0045 TCustomActionList.RemoveAction"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 FB 01 75 30 3B 7E 38 75 0B 33 D2 8B C6 8B 08 FF 51 34 EB 20 83 7E 30 00 74 1A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TCustomActionList.AddAction"
		size = 31
		refs = "000c TList.Add 0018 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 89 5E 5C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TCustomActionList.RemoveAction"
		size = 37
		refs = "000c TList.Remove 0019 TComponent.RemoveFreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 30 E8 ?? ?? ?? ?? 85 C0 7C 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C0 89 46 5C 5E 5B C3 }
	condition:
		$1
}

rule function_639_0 {
	meta:
		name = "TCustomActionList.Change"
		size = 102
		refs = "0041 _Dn_TForm 0046 @IsClass"
	strings:
		$1 = { 53 56 57 8B D8 66 83 7B 42 00 74 08 8B D3 8B 43 44 FF 53 40 8B 43 30 8B 70 08 4E 85 F6 7C 15 46 33 FF 8B 43 30 8B 40 04 8B 04 B8 8B 10 FF 52 30 47 4E 75 EE F6 43 1C 10 74 28 8B 73 04 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 83 BE A8 02 00 00 00 74 0B 8B 86 A8 02 00 00 8B 10 FF 52 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "TCustomActionList.IsShortCut"
		size = 164
		refs = "0012 IsAltGRPressed 001e KeyDataToShiftState 002b ShortCut 0057 _DV_TCustomAction 005c @IsClass 0079 TCustomAction.GetSecondaryShortCuts 0080 TShortCutList.IndexOfShortCut"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 89 04 24 C6 44 24 04 00 E8 ?? ?? ?? ?? 84 C0 75 7E 8B 46 08 E8 ?? ?? ?? ?? 8B D8 0F B7 46 04 8B D3 E8 ?? ?? ?? ?? 8B E8 66 85 ED 74 62 8B 04 24 8B 40 30 8B 70 08 4E 85 F6 7C 54 46 33 FF 8B 04 24 8B 40 30 8B 40 04 8B 1C B8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 30 66 3B AB 84 00 00 00 74 1A 83 BB 90 00 00 00 00 74 1E 8B C3 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 40 74 0D 8B C3 8B 10 FF 52 50 88 44 24 04 EB 04 47 4E 75 AF 0F B6 44 24 04 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "TCustomActionList.ExecuteAction"
		size = 30
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 4A 00 74 0A 8B CC 8B D8 8B 43 4C FF 53 48 0F B6 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "TCustomActionList.UpdateAction"
		size = 30
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 52 00 74 0A 8B CC 8B D8 8B 43 54 FF 53 50 0F B6 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "TCustomActionList.SetState"
		size = 163
		refs = "0060 TCustomAction.SetEnabled"
	strings:
		$1 = { 53 56 57 55 51 88 14 24 8B D8 0F B6 43 58 3A 04 24 0F 84 86 00 00 00 88 44 24 01 0F B6 04 24 88 43 58 3C 01 74 77 8B 43 30 8B 70 08 4E 85 F6 7C 5D 46 33 ED 8B 43 30 8B 40 04 8B 3C A8 0F B6 04 24 2C 01 72 06 FE C8 74 24 EB 3F 85 FF 74 15 80 7C 24 01 02 75 0E 0F B6 97 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C7 8B 10 FF 52 44 EB 1D 85 FF 74 19 80 3C 24 02 75 13 0F B6 47 6A 88 87 94 00 00 00 B2 01 8B C7 E8 ?? ?? ?? ?? 45 4E 75 A6 66 83 7B 62 00 74 08 8B D3 8B 43 64 FF 53 60 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "TActionLink.IsCaptionLinked"
		size = 19
		refs = "0008 _DV_TCustomAction 000d @IsClass"
		altNames = "TActionLink.IsCheckedLinked TActionLink.IsEnabledLinked TActionLink.IsGroupIndexLinked TActionLink.IsHelpContextLinked TActionLink.IsHelpLinked TActionLink.IsHintLinked TActionLink.IsImageIndexLinked TActionLink.IsShortCutLinked TActionLink.IsVisibleLinked"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7414_0 {
	meta:
		name = "TControlActionLink.IsDropdownMenuLinked"
		size = 19
		refs = "0008 _DV_TCustomControlAction 000d @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7416_0 {
	meta:
		name = "TControlActionLink.IsEnableDropdownLinked"
		size = 19
		refs = "0008 _DV_TCustomControlAction 000d @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_41454_0 {
	meta:
		name = "TListActionLink.IsActiveLinked"
		size = 19
		refs = "0008 _DV_TCustomListAction 000d @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "TCustomAction.Create"
		size = 82
		refs = "000a @ClassCreate 0017 TBasicAction.Create 003f @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 6A 01 C7 86 80 00 00 00 FF FF FF FF C6 86 86 00 00 00 01 33 C0 89 86 90 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "TCustomAction.Destroy"
		size = 87
		refs = "0003 @BeforeDestruction 0012 TObject.Free 0045 TContainedAction.Destroy 0050 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 98 00 00 00 E8 ?? ?? ?? ?? 8B 86 9C 00 00 00 E8 ?? ?? ?? ?? 83 BE 90 00 00 00 00 74 13 8D 86 90 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "TCustomAction.AssignTo"
		size = 266
		refs = "000b _DV_TCustomAction 0010 @IsClass 0028 TCustomAction.SetAutoCheck 0032 TCustomAction.SetCaption 003d TCustomAction.SetChecked 0048 TCustomAction.SetEnabled 0052 TCustomAction.SetGroupIndex 0071 TCustomAction.SetHelpType 007b TCustomAction.SetHint 0088 TCustomAction.SetImageIndex 008f TCustomAction.GetSecondaryShortCuts 0098 TCustomAction.SetSecondaryShortCuts 00a6 TCustomAction.SetShortCut 00b4 TCustomAction.SetVisible 0102 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 E1 00 00 00 0F B6 93 95 00 00 00 8B FE 8B C7 E8 ?? ?? ?? ?? 8B 53 64 8B C7 E8 ?? ?? ?? ?? 0F B6 53 69 8B C7 E8 ?? ?? ?? ?? 0F B6 53 6A 8B C7 E8 ?? ?? ?? ?? 8B 53 6C 8B C7 E8 ?? ?? ?? ?? 8B 53 74 8B C7 8B 08 FF 51 48 8B 53 78 8B C7 8B 08 FF 51 4C 0F B6 53 70 8B C7 E8 ?? ?? ?? ?? 8B 53 7C 8B C7 E8 ?? ?? ?? ?? 8B 93 80 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 0F B7 93 84 00 00 00 8B C7 E8 ?? ?? ?? ?? 0F B6 93 86 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 43 0C 89 47 0C FF 73 44 FF 73 40 8B C7 8B 10 FF 52 34 8B 83 88 00 00 00 89 87 88 00 00 00 8B 83 8C 00 00 00 89 87 8C 00 00 00 8B 43 48 89 47 48 8B 43 4C 89 47 4C 8B 43 38 89 47 38 8B 43 3C 89 47 3C EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "TCustomAction.SetAutoCheck"
		size = 94
		refs = "0024 TList.Get 002a _DV_TActionLink 002f @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 9D 95 00 00 00 74 49 8B 45 50 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 48 46 4F 75 D2 88 9D 95 00 00 00 8B C5 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "TCustomAction.SetCaption"
		size = 95
		refs = "0010 @UStrEqual 002f _DV_TActionLink 0034 @AsClass 004f @UStrAsg"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 8B 53 64 E8 ?? ?? ?? ?? 74 44 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 4C 47 4E 75 DC 8D 43 64 8B 14 24 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "TCustomAction.SetChecked"
		size = 261
		refs = "0024 TCustomAction.SetChecked 0059 _DV_TActionLink 005e @AsClass 0090 TCustomActionList.GetActionCount 00a7 TCustomActionList.GetAction 00b6 _DV_TCustomAction 00bb @IsClass 00f9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 8B 45 FC 80 78 68 00 0F 85 E6 00 00 00 8B 45 FC C6 40 68 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 3A 58 69 0F 84 A9 00 00 00 8B 45 FC 8B 40 50 8B 78 08 4F 85 FF 7C 29 47 33 F6 8B 45 FC 8B 40 50 8B 40 04 8B 04 B0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 07 8B D3 8B 08 FF 51 50 46 4F 75 DA 8B 45 FC 88 58 69 8B 45 FC 83 78 6C 00 7E 5B 8B 45 FC 80 78 69 00 74 52 8B 45 FC 8B 40 5C E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 40 47 33 F6 8B 45 FC 8B 40 5C 8B D6 E8 ?? ?? ?? ?? 8B D8 3B 5D FC 74 25 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B 43 6C 8B 55 FC 3B 42 6C 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 46 4F 75 C3 8B 45 FC 8B 10 FF 52 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 68 00 C3 E9 ?? ?? ?? ?? EB F1 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "TCustomAction.SetEnabled"
		size = 122
		refs = "004d _DV_TActionLink 0052 @AsClass"
	strings:
		$1 = { 53 56 57 51 88 14 24 8B D8 0F B6 04 24 3A 43 6A 74 63 8B 43 5C 85 C0 74 1B 0F B6 50 58 80 FA 01 75 09 0F B6 04 24 88 43 6A EB 4A 80 FA 02 75 04 C6 04 24 01 8B 43 50 8B 70 08 4E 85 F6 7C 28 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 0F B6 14 24 8B 08 FF 51 54 47 4E 75 DB 0F B6 04 24 88 43 6A 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TCustomAction.SetGroupIndex"
		size = 85
		refs = "0030 _DV_TActionLink 0035 @AsClass"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 3B 43 6C 74 3F 8B 04 24 89 43 6C 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 58 47 4E 75 DC 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "TCustomAction.SetHelpType"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 5D 70 74 46 8B 45 50 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 64 46 4F 75 D2 88 5D 70 8B C5 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TCustomAction.SetHelpKeyword"
		size = 102
		refs = "000e @UStrEqual 0028 TList.Get 002e _DV_TActionLink 0033 @IsClass 0056 @UStrAsg"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B C5 8B 53 78 E8 ?? ?? ?? ?? 74 4D 8B 43 50 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 50 E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 60 46 4F 75 D2 8D 43 78 8B D5 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "TCustomAction.SetHelpContext"
		size = 85
		refs = "002a _DV_TActionLink 002f @AsClass"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 3B 43 74 74 3F 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 5C 47 4E 75 DC 8B 04 24 89 43 74 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TCustomAction.SetHint"
		size = 95
		refs = "0010 @UStrEqual 002f _DV_TActionLink 0034 @AsClass 004f @UStrAsg"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 8B 53 7C E8 ?? ?? ?? ?? 74 44 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 68 47 4E 75 DC 8D 43 7C 8B 14 24 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_678_0 {
	meta:
		name = "TCustomAction.SetImageIndex"
		size = 91
		refs = "002d _DV_TActionLink 0032 @AsClass"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 3B 83 80 00 00 00 74 42 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 6C 47 4E 75 DC 8B 04 24 89 83 80 00 00 00 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "TCustomAction.SetShortCut"
		size = 97
		refs = "0030 _DV_TActionLink 0035 @AsClass"
	strings:
		$1 = { 53 56 57 51 66 89 14 24 8B D8 0F B7 04 24 66 3B 83 84 00 00 00 74 45 8B 43 50 8B 70 08 4E 85 F6 7C 28 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 0F B7 14 24 8B 08 FF 51 70 47 4E 75 DB 0F B7 04 24 66 89 83 84 00 00 00 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "TCustomAction.SetVisible"
		size = 94
		refs = "002e _DV_TActionLink 0033 @AsClass"
	strings:
		$1 = { 53 56 57 51 88 14 24 8B D8 0F B6 04 24 3A 83 86 00 00 00 74 44 8B 43 50 8B 70 08 4E 85 F6 7C 28 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 0F B6 14 24 8B 08 FF 51 74 47 4E 75 DB 0F B6 04 24 88 83 86 00 00 00 8B C3 8B 10 FF 52 30 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "TCustomAction.SetName"
		size = 76
		refs = "000e @UStrEqual 002e TComponent.SetName 0044 TCustomAction.SetCaption"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 46 08 8B 56 64 E8 ?? ?? ?? ?? 75 0D 8B 5E 04 85 DB 74 0A F6 43 1C 01 74 04 33 C0 EB 02 B0 01 8B D8 8B D7 8B C6 E8 ?? ?? ?? ?? 84 DB 74 12 8B 46 50 83 78 08 00 75 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "TCustomAction.DoHint"
		size = 39
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 8A 00 00 00 00 74 10 8B CC 8B D8 8B 83 8C 00 00 00 FF 93 88 00 00 00 0F B6 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "TCustomAction.Execute"
		size = 97
		refs = "0044 TCustomAction.SetChecked 0051 TContainedAction.Execute"
	strings:
		$1 = { 53 8B D8 33 C0 8B 53 5C 85 D2 74 06 80 7A 58 00 75 4D 8B C3 8B 10 FF 52 44 80 7B 6A 00 74 29 80 BB 95 00 00 00 00 74 20 80 7B 69 00 74 0C 80 7B 69 00 74 14 83 7B 6C 00 75 0E 0F B6 53 69 80 F2 01 8B C3 E8 ?? ?? ?? ?? 80 7B 6A 00 74 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 5B C3 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "TCustomAction.GetSecondaryShortCuts"
		size = 38
		refs = "000f _DV_TShortCutList 0014 TStringList.Create"
	strings:
		$1 = { 53 8B D8 83 BB 90 00 00 00 00 75 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 90 00 00 00 8B 83 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "TCustomAction.SetSecondaryShortCuts"
		size = 49
		refs = "0012 _DV_TShortCutList 0017 TStringList.Create"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 BB 90 00 00 00 00 75 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 90 00 00 00 8B D6 8B 83 90 00 00 00 8B 08 FF 51 08 5E 5B C3 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "TCustomAction.IsSecondaryShortCutsStored"
		size = 35
	strings:
		$1 = { 53 56 8B D8 8B B3 90 00 00 00 85 F6 74 0B 8B C6 8B 10 FF 52 14 85 C0 7F 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "TCustomAction.HandleShortCut"
		size = 12
		refs = "0006 @CallDynaInst"
	strings:
		$1 = { 56 66 BE EF FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TShortCutList.Add"
		size = 43
		refs = "000c TStringList.Add 0015 TextToShortCut"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 0F B7 C8 8B D7 8B C3 8B 18 FF 53 24 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TIdCookieList.GetCookie"
		size = 18
		altNames = "TShortCutList.GetShortCuts TdomAttr.getName TdomDocumentType.getName TdomElement.getTagName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 18 5E 5B C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TAction.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TCustomAction.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 60 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TShortCutList.IndexOfShortCut"
		size = 65
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F8 C7 04 24 FF FF FF FF 8B C7 8B 10 FF 52 14 8B F0 4E 85 F6 7C 1A 46 33 DB 8B D3 8B C7 8B 08 FF 51 18 66 3B E8 75 05 89 1C 24 EB 04 43 4E 75 E9 8B 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "ActnList"
		size = 42
		refs = "0002 _DV_9 000b _Dn_TControl 0010 _DV_TCustomActionList 0015 GroupDescendentsWith 0020 _DV_TContainedAction"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 20 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "TXToolDockForm.CMDialogChar"
		size = 54
		refs = "0008 Application 002e TWinControl.CMDialogChar"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 A1 ?? ?? ?? ?? 8B 00 8B 78 40 85 FF 74 0E 8B D3 A1 ?? ?? ?? ?? 8B C7 8B 08 FF 51 EC 83 7B 0C 00 75 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "NotifyDesigner"
		size = 39
		refs = "0002 ActionBarDesigner"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1D 85 C0 74 0D 85 C0 74 15 80 B8 7C 02 00 00 00 74 0C 8B D0 A1 ?? ?? ?? ?? 8B 08 FF 51 14 C3 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "TCustomActionManager.Create"
		size = 360
		refs = "0018 @ClassCreate 0025 TCustomActionManager.Create 0034 TCustomActionList.Create 004a TCustomActionManager.CreateActionBars 0054 _Dn_TStringList 0059 TStringList.Create 0069 cDefaultSchedule 009c TStrings.GetName 00a9 TStrings.GetValue 00b1 StrToInt 00cc _Dn_TChangeLink 00d1 TObject.Create 00e3 TCustomActionManager.ImageListChange 0139 @UStrArrayClr 013f @HandleFinally 014e @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 DB 89 5D F0 89 5D EC 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? F7 D0 22 46 24 88 46 24 8B C6 E8 ?? ?? ?? ?? 89 46 6C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E AC 00 00 00 8B C3 8B 15 ?? ?? ?? ?? 8B 08 FF 51 2C 8B 86 AC 00 00 00 8B 10 FF 52 14 48 85 C0 7C 47 40 89 45 F4 C7 45 F8 00 00 00 00 8B 9E AC 00 00 00 8D 4D EC 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 4D F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B C3 8B 18 FF 53 24 FF 45 F8 FF 4D F4 75 C4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E 98 00 00 00 89 73 0C C7 43 08 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E 80 00 00 00 89 73 0C C7 43 08 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E A0 00 00 00 89 73 0C C7 43 08 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 01 00 00 00 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TCustomActionManager.Destroy"
		size = 192
		refs = "0005 @BeforeDestruction 001c TObject.Free 0066 TCollection.GetCount 007d TActionBars.GetActionBar 00ac TCustomActionList.Destroy 00b7 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 E8 ?? ?? ?? ?? 8B DA 8B E8 8D 85 98 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 85 80 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 85 A0 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 85 AC 00 00 00 E8 ?? ?? ?? ?? 8B 45 6C E8 ?? ?? ?? ?? 8B B5 90 00 00 00 85 F6 74 32 8B C6 E8 ?? ?? ?? ?? 48 85 C0 7C 1B 40 89 C6 33 FF 8B 85 90 00 00 00 8B D7 E8 ?? ?? ?? ?? 33 D2 89 50 0C 47 4E 75 EA 8B 85 90 00 00 00 E8 ?? ?? ?? ?? 8B 85 8C 00 00 00 85 C0 74 05 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C5 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C5 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "TCustomActionManager.AddAction"
		size = 91
		refs = "001a TCollection.Add 0023 TCollectionItem.GetIndex 003b TActionClientItem.SetAction 0042 TActionClientItem.GetParentItem 0047 TActionClient.GetOwningCollection 004e TActionClientsCollection.InternalRethinkHotkeys"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F1 8B FA 33 DB 85 F6 74 42 83 7E 04 00 74 3C 8B 46 04 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 8B D0 0F B6 45 08 03 D0 8B C3 8B 08 FF 51 14 8B D7 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "AddActions"
		size = 383
		refs = "001e @UStrAddRef 0026 AddActions 0036 @DynArrayLength 004b TCustomActionList.GetActionCount 005d TActionArray 0062 @DynArraySetLength 0086 TCustomActionList.GetAction 0091 @UStrLAsg 00b9 @InternalUStrFromLStr 00f5 @UStrToPWChar 010c CompareString 0169 @UStrArrayClr 016f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D F8 89 5D F4 89 4D FC 89 55 EC 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 00 E8 ?? ?? ?? ?? 89 45 E8 83 7D EC 00 0F 84 0C 01 00 00 8B 45 EC E8 ?? ?? ?? ?? 03 45 E8 50 8B 45 F0 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 45 EC E8 ?? ?? ?? ?? 48 85 C0 0F 8C BF 00 00 00 40 89 45 E4 33 F6 8B D6 8B 45 EC E8 ?? ?? ?? ?? 8B 50 58 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F4 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F4 8B 55 F4 E8 ?? ?? ?? ?? 8B F8 85 FF 74 05 83 EF 04 8B 3F 57 8B 45 F4 E8 ?? ?? ?? ?? 50 53 8B 45 F8 E8 ?? ?? ?? ?? 50 6A 01 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 85 C0 75 18 8B D6 8B 45 EC E8 ?? ?? ?? ?? 8B 55 F0 8B 12 8B 4D E8 89 04 8A FF 45 E8 46 FF 4D E4 0F 85 47 FF FF FF 8B 45 E8 50 8B 45 F0 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "TCustomActionManager.AddCategory"
		size = 357
		refs = "001a @UStrAddRef 0022 TCustomActionManager.AddCategory 0044 AddActions 004b TCustomActionManager.GetLinkedActionLists 0050 TCollection.GetCount 0068 TActionListCollection.GetListItem 0085 @CallDynaInst 00a8 TActionClientItem.SetCaption 00be TCollectionItem.GetIndex 00d6 @DynArrayLength 00e8 TActionClient.GetItems 00ed TActionClients.Add 00f8 TActionClientItem.SetAction 0118 @HandleAnyException 0120 TObject.Free 0125 @RaiseAgain 012a @DoneExcept 0140 TActionArray 0145 @DynArrayClear 014d @UStrClr 0153 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F8 89 4D F4 89 55 FC 8B F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F0 83 7D F4 00 0F 84 F3 00 00 00 8D 45 F8 8B 4D FC 8B D7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 23 43 33 F6 8B C7 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 50 0C 8D 45 F8 8B 4D FC E8 ?? ?? ?? ?? 46 4B 75 E0 8B C7 66 BE EC FF E8 ?? ?? ?? ?? 33 C9 B2 01 FF 50 1C 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 F4 8B 50 04 8B 45 F0 8B 08 FF 51 10 8B 45 F4 E8 ?? ?? ?? ?? 8B D0 0F B6 45 08 03 D0 8B 45 F0 8B 08 FF 51 14 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1F 43 33 F6 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 14 B2 E8 ?? ?? ?? ?? 46 4B 75 E4 8B 45 F0 8B 40 44 B2 01 8B 08 FF 51 64 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 8B 45 F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "TCustomActionManager.AddSeparator"
		size = 116
		refs = "0010 TActionClientItem.GetActionClients 001d _DV_TActionClientItem 0022 TActionClientItem.Create 0029 TCustomActionManager.AddSeparator 0030 TActionClientItem.SetCaption 0037 TActionClientItem.GetParentItem 003c TActionClient.GetItems 004c TCollectionItem.GetIndex"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 33 FF 85 F6 74 51 8B C6 E8 ?? ?? ?? ?? 85 C0 74 46 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 BA ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 8B 08 FF 51 10 8B C6 E8 ?? ?? ?? ?? 8B D0 0F B6 C3 03 D0 8B C7 8B 08 FF 51 14 8B C7 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 7C 00 00 00 }
	condition:
		$1
}

rule function_705_0 {
	meta:
		name = "TCustomActionManager.Assign"
		size = 245
		refs = "000f TCustomActionManager.Assign 001e TPersistent.Assign 0026 _DV_TCustomActionManager 002b @IsClass 0072 TCustomActionManager.GetFileName 007c TCustomActionManager.SetFileName 00c1 TCustomActionManager.GetLinkedActionLists 00e4 @UStrClr 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 9C 00 00 00 8B 57 6C 8B 46 6C 8B 08 FF 51 08 8B 86 84 00 00 00 85 C0 74 0B 8B 97 84 00 00 00 8B 08 FF 51 08 8B 86 9C 00 00 00 85 C0 74 0B 8B 97 9C 00 00 00 8B 08 FF 51 08 8D 55 FC 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 38 85 C0 74 08 8B 57 38 8B 08 FF 51 08 8B 86 A4 00 00 00 85 C0 74 0B 8B 97 A4 00 00 00 8B 08 FF 51 08 8B 97 AC 00 00 00 8B 86 AC 00 00 00 8B 08 FF 51 08 83 BF 8C 00 00 00 00 74 15 8B C7 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 59 5D C3 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "TCustomActionManager.CompareAction"
		size = 48
		refs = "000b _DV_TActionClientItem 0010 @IsClass 001d TActionClientItem.GetAction"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B FE 8B C7 E8 ?? ?? ?? ?? 3B 43 68 75 06 89 BB 88 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "TCustomActionManager.CompareCaption"
		size = 244
		refs = "0015 TCustomActionManager.CompareCaption 0024 _DV_TActionClientItem 0029 @IsClass 003c TActionClientItem.GetCaption 0047 @UStrLAsg 0064 @InternalUStrFromLStr 00a0 @UStrToPWChar 00b7 CompareString 00e1 @UStrArrayClr 00e7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 55 F4 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 96 00 00 00 8D 55 FC 8B 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 8B 56 70 E8 ?? ?? ?? ?? 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B F8 85 FF 74 05 83 EF 04 8B 3F 57 8B 45 F8 E8 ?? ?? ?? ?? 50 53 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 85 C0 75 09 8B 45 F4 89 86 88 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "TCustomActionManager.CreateActionBars"
		size = 37
		refs = "000b @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 66 BE EE FF E8 ?? ?? ?? ?? 50 8B C3 66 BE EF FF E8 ?? ?? ?? ?? 8B CB B2 01 FF 50 28 5E 5B C3 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "TCustomActionManager.DeleteActionItems"
		size = 68
		refs = "0027 TCustomActionManager.FindItemByAction 0030 TObject.Free"
	strings:
		$1 = { 55 8B EC 51 53 56 8B D9 85 DB 78 07 8B 34 9A 4B 56 79 F9 8B D4 89 45 FC 8B F1 85 F6 7C 1C 46 8B DA 8B 13 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E7 8B 75 F4 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "StyleNameStored"
		size = 60
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 8B 40 20 85 C0 74 1A 8B 55 08 8B 52 F8 8B 92 E0 00 00 00 8B 4D 08 3B 90 E0 00 00 00 0F 95 C0 5D C3 8B 45 08 8B 40 F8 83 B8 E0 00 00 00 00 0F 95 C0 5D C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "TCustomActionManager.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TCustomActionManager.ReadStyleProp 0026 TCustomActionManager.WriteStyleProp 002c StyleNameStored 0034 TCustomActionManager.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 53 00 74 00 79 00 6C 00 65 00 4E 00 61 00 6D 00 65 00 00 00 }
	condition:
		$1
}

rule function_47031_0 {
	meta:
		name = "TCustomRibbon.DefineProperties"
		size = 104
		refs = "0014 TWinControl.DefineProperties 001d TCustomRibbon.ReadStyleProp 0026 TCustomRibbon.WriteStyleProp 002c StyleNameStored 0034 TCustomRibbon.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 53 00 74 00 79 00 6C 00 65 00 4E 00 61 00 6D 00 65 00 00 00 }
	condition:
		$1
}

rule function_1322_0 {
	meta:
		name = "TPopupActionBar.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TPopupActionBar.ReadStyleProp 0026 TPopupActionBar.WriteStyleProp 002c StyleNameStored 0034 TPopupActionBar.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 53 00 74 00 79 00 6C 00 65 00 4E 00 61 00 6D 00 65 00 00 00 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "TCustomActionManager.DeleteItem"
		size = 103
		refs = "000e @UStrAddRef 0016 TCustomActionManager.DeleteItem 002f @UStrAsg 0039 TCustomActionManager.FindItemByCaption 0042 TObject.Free 0057 @UStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 83 88 00 00 00 8D 43 70 8B 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "TCustomActionManager.FindClient"
		size = 31
	strings:
		$1 = { 53 85 D2 74 10 66 83 78 7A 00 74 09 83 B8 88 00 00 00 00 75 08 8B D8 8B 43 7C FF 53 78 5B C3 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "TCustomActionManager.FindItem"
		size = 35
		refs = "000d TCustomActionManager.FindClient 0017 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 53 8B D8 33 C0 89 83 88 00 00 00 53 68 ?? ?? ?? ?? 8B 43 6C 8B D0 E8 ?? ?? ?? ?? 8B 83 88 00 00 00 5B C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "TCustomActionManager.FindItemByAction"
		size = 19
		refs = "0006 TCustomActionManager.CompareAction 000e TCustomActionManager.FindItem"
	strings:
		$1 = { 89 40 7C C7 40 78 ?? ?? ?? ?? 89 50 68 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "TCustomActionManager.FindItemByCaption"
		size = 97
		refs = "000e @UStrAddRef 0016 TCustomActionManager.FindItemByCaption 0026 TCustomActionManager.CompareCaption 0031 @UStrAsg 0038 TCustomActionManager.FindItem 004f @UStrClr 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 89 5B 7C C7 43 78 ?? ?? ?? ?? 8D 43 70 8B 55 FC E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "TCustomActionManager.FindActionClient"
		size = 167
		refs = "001f TCollection.GetCount 0032 TActionClientsCollection.GetActionClient 0038 _DV_TActionClientItem 003d @IsClass 004f TActionClientItem.GetAction 0070 TActionClient.GetHasItems 0082 TActionClient.GetItems 0090 TCustomActionManager.FindActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 54 24 04 89 04 24 33 ED 85 F6 75 06 8B 04 24 8B 70 6C 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 74 47 33 DB 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 44 24 04 75 0D 8B D3 8B C6 E8 ?? ?? ?? ?? 8B E8 EB 38 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 22 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B 54 24 04 8B 04 24 E8 ?? ?? ?? ?? 8B E8 85 ED 75 04 43 4F 75 8F 8B C5 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "TCustomActionManager.FindActionBar"
		size = 141
		refs = "001f TCollection.GetCount 0032 TActionClientsCollection.GetActionClient 0056 TActionClient.GetHasItems 0068 TActionClient.GetItems 0076 TCustomActionManager.FindActionBar"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 54 24 04 89 04 24 33 ED 85 F6 75 06 8B 04 24 8B 70 6C 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 5A 47 33 DB 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 0C 3B 44 24 04 75 0D 8B D3 8B C6 E8 ?? ?? ?? ?? 8B E8 EB 38 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 22 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B 54 24 04 8B 04 24 E8 ?? ?? ?? ?? 8B E8 85 ED 75 04 43 4F 75 A9 8B C5 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "TCustomActionManager.LoadFromFile"
		size = 288
		refs = "001a TCustomActionManager.LoadFromFile 002c _Dn_TFileStream 0031 TFileStream.Create 005a TCustomActionManager.LoadFromStream 0069 @HandleAnyException 0076 TObject.Free 0084 SErrorLoadingFile 0089 LoadResString 00a2 Format 00b3 MessageDlg 00c0 @UStrToPWChar 00c6 DeleteFile 00cb @DoneExcept 00eb @HandleFinally 0107 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D F4 89 4D F0 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 20 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 67 E9 ?? ?? ?? ?? 8B 45 F8 33 D2 89 55 F8 E8 ?? ?? ?? ?? 6A 00 8D 45 F4 50 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 FC 89 45 E8 C6 45 EC 11 8D 55 E8 33 C9 58 E8 ?? ?? ?? ?? 8B 45 F4 0F B7 0D ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 83 F8 06 75 0E 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 33 D2 89 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 03 00 00 00 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "TCustomActionManager.LoadFromStream"
		size = 274
		refs = "0011 _Dn_TMemoryStream 0016 TObject.Create 002b TCustomActionManager.LoadFromStream 0043 TObject.Free 004b TCustomActionManager.CreateActionBars 007b TMemoryStream.LoadFromStream 0087 TStream.SetPosition 0092 TStream.ReadComponent 009a TComponent.Loaded 00a8 TCustomActionManager.SetupActionBars 00b3 TActionBars.Loaded 00c2 @HandleAnyException 00db @RaiseAgain 00e0 @DoneExcept 0105 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F2 89 45 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC C6 80 A8 00 00 00 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 90 00 00 00 85 C0 74 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 98 90 00 00 00 8B 45 FC 8B 50 6C 8B C3 8B 08 FF 51 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 F8 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 50 6C 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 FC 8B 90 90 00 00 00 8B 45 FC 8B 40 6C 8B 08 FF 51 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 A8 00 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "TCustomActionManager.Loaded"
		size = 216
		refs = "0009 TComponent.Loaded 001d TCustomActionManager.CreateActionBars 0040 FileExists 0051 TCustomActionManager.LoadFromFile 005d TCustomActionManager.SetupActionBars 0071 TCollection.GetCount 0085 TActionBars.GetActionBar 009d TCustomActionBar.GetColorMap"
	strings:
		$1 = { 53 56 57 55 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB A8 00 00 00 00 0F 85 B9 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 89 B3 90 00 00 00 8B 53 6C 8B C6 8B 08 FF 51 08 F6 43 1C 10 75 1E 8B 83 94 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 0F 8B 93 94 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 0A 8B 53 6C 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 75 06 8B 43 6C FF 40 28 8B 43 6C E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 57 47 33 F6 8B D6 8B 43 6C E8 ?? ?? ?? ?? 83 78 0C 00 74 40 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C E8 ?? ?? ?? ?? 8B E8 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 3B A8 D0 02 00 00 75 17 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 33 D2 8B 08 FF 91 38 01 00 00 46 4F 75 AC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "TCustomActionManager.LoadMenu"
		size = 178
		refs = "0013 TMenuItem.GetCount 002a TActionClients.Add 0035 TMenuItem.GetItem 003f TActionClientItem.SetCaption 004d TMenuItem.GetAction 0056 TActionClientItem.SetAction 005d TActionClientItem.GetAction 0070 TContainedAction.SetActionList 0093 TActionClient.GetItems 009f TCustomActionManager.LoadMenu"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F9 89 54 24 04 89 04 24 8B C7 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 0F 8C 89 00 00 00 45 33 F6 8B 44 24 04 E8 ?? ?? ?? ?? 8B D8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B 50 30 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 14 24 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 1D 8B D6 8B C7 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 44 24 04 59 E8 ?? ?? ?? ?? 46 4D 0F 85 7A FF FF FF 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "TCustomActionManager.Notification"
		size = 566
		refs = "0019 TCustomActionList.Notification 001e Application 005b TCustomActionManager.SaveToFile 007d TCustomActionManager.SetLargeImages 008e TCustomActionManager.SetLargeDisabledImages 009f TCustomActionManager.SetDisabledImages 00b1 _Dn_TContainedAction 00b6 @IsClass 00c9 TCustomActionManager.FindActionClient 00d2 _Dn_TList 00d7 TObject.Create 00e2 TCustomActionManager.Notification 00f3 TActionClientItem.GetActionClients 010e TWinControl.DisableAlign 0123 TList.Add 012a TCollectionItem.GetIndex 0138 TCollection.Delete 016e TList.Get 0181 TWinControl.EnableAlign 018d TObject.Free 0193 @HandleFinally 019d _DV_TCustomActionBar 01b4 TCustomActionManager.FindActionBar 01df _Dn_TCustomActionList 01fc TCollection.GetCount 0211 TActionListCollection.GetListItem"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 88 4D FF 8B F2 8B D8 0F B6 4D FF 8B D6 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 80 B8 A0 00 00 00 00 74 16 8B 83 94 00 00 00 85 C0 74 05 83 E8 04 8B 00 85 C0 0F 9F C0 EB 02 33 C0 84 C0 74 1D 80 BB B0 00 00 00 00 75 14 8B 93 94 00 00 00 8B C3 E8 ?? ?? ?? ?? C6 83 B0 00 00 00 01 80 7D FF 01 0F 85 BF 01 00 00 3B B3 A4 00 00 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 3B B3 9C 00 00 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 3B B3 84 00 00 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? F6 43 1C 08 0F 85 82 01 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D7 00 00 00 33 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 5D 8B C7 E8 ?? ?? ?? ?? 8B 40 20 83 78 0C 00 74 27 8B C7 E8 ?? ?? ?? ?? 8B 40 20 8B 40 0C E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 40 20 8B 50 0C 8B 45 F8 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 33 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 75 A3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 8B 58 08 4B 85 DB 7C 24 43 33 FF 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 74 0F 8B D7 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 47 4B 75 DF 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C1 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 31 8B 4B 6C 8B FE 8B D7 8B C3 E8 ?? ?? ?? ?? 85 C0 74 05 33 D2 89 50 0C 8B 8B 90 00 00 00 8B D7 8B C3 E8 ?? ?? ?? ?? 85 C0 74 5B 33 D2 89 50 0C EB 54 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 43 83 BB 8C 00 00 00 00 74 3A 8B 83 8C 00 00 00 E8 ?? ?? ?? ?? 8B F8 4F 83 FF 00 7C 27 8B 83 8C 00 00 00 8B D7 E8 ?? ?? ?? ?? 3B 70 0C 75 0F 8B 83 8C 00 00 00 8B D7 E8 ?? ?? ?? ?? EB 06 4F 83 FF FF 75 D9 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "TCustomActionManager.SaveToFile"
		size = 255
		refs = "0014 TCustomActionManager.SaveToFile 0040 ExpandFileName 004a _Dn_TFileStream 004f TFileStream.Create 0078 TCustomActionManager.SaveToStream 0087 @HandleAnyException 008c @DoneExcept 00a1 TObject.Free 00a7 @HandleFinally 00c0 SUnableToSaveSettings 00c5 LoadResString 00cd ShowMessage 00ec @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 8B 08 FF 51 38 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 FF FF 00 00 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 EB 1F E9 ?? ?? ?? ?? 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "TCustomActionManager.SaveToStream"
		size = 114
		refs = "000d _Dn_TMemoryStream 0012 TObject.Create 001d TCustomActionManager.SaveToStream 002d TStream.WriteComponent 0039 TStream.SetPosition 004c TStream.CopyFrom 0061 TObject.Free 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 6A 00 6A 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 12 52 50 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "TCustomActionManager.SetupActionBars"
		size = 180
		refs = "0009 TCollection.GetCount 002f TActionClientsCollection.GetActionClient 003e TActionClientsCollection.InternalRethinkHotkeys 0072 @CallDynaInst 00a3 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 55 8B DA 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 9A 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 0F 8C 88 00 00 00 45 33 FF 8B D7 8B C3 E8 ?? ?? ?? ?? 83 78 0C 00 74 6E B2 01 8B C3 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 50 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 5A 8B 08 FF 91 30 01 00 00 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 66 BE D0 FF E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 58 8B D7 8B C3 E8 ?? ?? ?? ?? 0F B6 40 30 50 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 5A E8 ?? ?? ?? ?? 47 4D 0F 85 7B FF FF FF 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "TCustomActionManager.SetActionBars"
		size = 13
	strings:
		$1 = { 56 8B F0 8B 46 6C 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "TCustomActionManager.SetDisabledImages"
		size = 222
		refs = "002f TCustomImageList.UnRegisterChanges 0046 TCustomImageList.RegisterChanges 0053 TComponent.FreeNotification 0061 TCollection.GetCount 0077 TActionBars.GetActionBar 007c TActionClient.GetItems 00a1 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B D8 8B 83 84 00 00 00 3B F0 74 06 F6 43 1C 08 74 04 33 D2 EB 02 B2 01 88 14 24 85 C0 74 0B 8B 93 80 00 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 84 00 00 00 85 C0 74 18 8B 93 80 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 80 3C 24 00 74 7A 8B 43 6C E8 ?? ?? ?? ?? 48 85 C0 7C 6D 40 89 44 24 04 33 ED 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 44 47 33 F6 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 E8 00 00 00 46 4F 75 BF 45 FF 4C 24 04 75 9A 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "TCustomActionManager.SetLargeDisabledImages"
		size = 222
		refs = "002f TCustomImageList.UnRegisterChanges 0046 TCustomImageList.RegisterChanges 0053 TComponent.FreeNotification 0061 TCollection.GetCount 0077 TActionBars.GetActionBar 007c TActionClient.GetItems 00a1 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B D8 8B 83 9C 00 00 00 3B F0 74 06 F6 43 1C 08 74 04 33 D2 EB 02 B2 01 88 14 24 85 C0 74 0B 8B 93 98 00 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 9C 00 00 00 85 C0 74 18 8B 93 98 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 9C 00 00 00 E8 ?? ?? ?? ?? 80 3C 24 00 74 7A 8B 43 6C E8 ?? ?? ?? ?? 48 85 C0 7C 6D 40 89 44 24 04 33 ED 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 44 47 33 F6 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 E8 00 00 00 46 4F 75 BF 45 FF 4C 24 04 75 9A 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "TCustomActionManager.SetImages"
		size = 161
		refs = "001b TCustomActionList.SetImages 0027 TCollection.GetCount 003c TActionBars.GetActionBar 0041 TActionClient.GetItems 0066 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 51 8B F8 3B 57 38 74 06 F6 47 1C 08 74 04 33 DB EB 02 B3 01 8B C7 E8 ?? ?? ?? ?? 84 DB 74 78 8B 47 6C E8 ?? ?? ?? ?? 48 85 C0 7C 6B 40 89 04 24 33 ED 8B 47 6C 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 44 46 33 DB 8B 47 6C 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B 47 6C 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 E8 00 00 00 43 4E 75 BF 45 FF 0C 24 75 9B 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "PrioritySort"
		size = 214
		refs = "0014 PrioritySort 0026 TStrings.GetName 004f @InternalUStrFromLStr 008b @UStrToPWChar 00a2 CompareString 00c1 @UStrArrayClr 00c7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 56 8B 45 F8 E8 ?? ?? ?? ?? 50 53 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "TCustomActionManager.SetPrioritySchedule"
		size = 392
		refs = "001b TCustomActionManager.SetPrioritySchedule 003d Trim 005d SRestoreDefaultSchedule 0062 LoadResString 0073 MessageDlg 0085 cDefaultSchedule 00a8 TStrings.GetName 00b0 StrToInt 00c9 TStrings.GetValue 00e6 PrioritySort 0165 @UStrArrayClr 0178 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 45 FC 8B 80 AC 00 00 00 8B 08 FF 51 1C 8B 45 F0 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 89 45 EC 8B 45 EC 85 C0 74 05 83 E8 04 8B 00 85 C0 75 49 6A 00 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 0F B7 0D ?? ?? ?? ?? B2 03 E8 ?? ?? ?? ?? 48 75 16 8B 45 FC 8B 80 AC 00 00 00 8B 15 ?? ?? ?? ?? 8B 08 FF 51 2C EB 55 8B 45 FC 8B 80 AC 00 00 00 8B 10 FF 52 44 EB 45 8D 4D E4 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? 8D 4D DC 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 4D E0 8B C3 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 AC 00 00 00 8B D3 8B 08 FF 51 08 BA ?? ?? ?? ?? 8B 45 FC 8B 80 AC 00 00 00 8B 08 FF 91 A4 00 00 00 8B 45 FC 8B 80 AC 00 00 00 8B 10 FF 52 14 48 85 C0 7C 41 40 89 45 F8 33 F6 8B 45 FC 8B 98 AC 00 00 00 8D 4D D4 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 55 D4 8D 4D D8 8B C3 E8 ?? ?? ?? ?? 8B 45 D8 E8 ?? ?? ?? ?? 8B C8 8B D6 8B C3 8B 18 FF 53 24 46 FF 4D F8 75 C5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 06 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5E 5B 8B E5 5D C3 0C 00 00 00 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "TCustomActionManager.GetUsage"
		size = 112
	strings:
		$1 = { 53 56 57 55 8B FA 8B F0 83 7F 48 FF 74 13 8B 86 AC 00 00 00 8B 10 FF 52 14 85 C0 74 04 33 C0 EB 02 B0 01 84 C0 75 44 8B 46 6C 8B 68 28 2B 6F 60 33 DB EB 01 43 8B 86 AC 00 00 00 8B 10 FF 52 14 3B D8 7D 05 3B 5F 48 7C EB 8B 86 AC 00 00 00 8B 10 FF 52 14 3B D8 75 01 4B 8B D3 8B 86 AC 00 00 00 8B 08 FF 51 18 3B E8 0F 9C C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "TCustomActionManager.IsPriorityScheduleStored"
		size = 215
		refs = "000f TCustomActionManager.IsPriorityScheduleStored 001e cDefaultSchedule 0023 @UStrLAsg 004e @InternalUStrFromLStr 008a @UStrToPWChar 00a1 CompareString 00c3 @UStrArrayClr 00c9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 F8 8B 83 AC 00 00 00 8B 08 FF 51 1C 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 56 8B 45 F8 E8 ?? ?? ?? ?? 50 53 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 85 C0 0F 95 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_735_0 {
	meta:
		name = "TCustomActionManager.ResetActionBar"
		size = 97
		refs = "0016 TActionBars.GetActionBar 002a TActionClient.SetActionBar 0037 TCollection.GetItem"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 83 BB 90 00 00 00 00 74 4D 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 78 0C 8B D6 8B 43 6C E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B D6 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 50 8B D6 8B 43 6C E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "TCustomActionManager.ResetClientUsageData"
		size = 52
		refs = "000b _DV_TActionClientItem 0010 @IsClass 001f TActionClientItem.SetUsageCount 002c TActionClientItem.SetLastSession"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 18 33 D2 8B FB 8B C7 E8 ?? ?? ?? ?? 8B 46 6C 8B 50 28 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "TCustomActionManager.ResetUsageData"
		size = 19
		refs = "0002 TCustomActionManager.ResetClientUsageData 000e TActionClientsCollection.IterateClients"
	strings:
		$1 = { 50 68 ?? ?? ?? ?? 8B 50 6C 8B CA 8B C1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_738_0 {
	meta:
		name = "TCustomActionManager.SetLargeImages"
		size = 222
		refs = "002f TCustomImageList.UnRegisterChanges 0046 TCustomImageList.RegisterChanges 0053 TComponent.FreeNotification 0061 TCollection.GetCount 0077 TActionBars.GetActionBar 007c TActionClient.GetItems 00a1 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B D8 8B 83 A4 00 00 00 3B F0 74 06 F6 43 1C 08 74 04 33 D2 EB 02 B2 01 88 14 24 85 C0 74 0B 8B 93 A0 00 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 A4 00 00 00 85 C0 74 18 8B 93 A0 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 A4 00 00 00 E8 ?? ?? ?? ?? 80 3C 24 00 74 7A 8B 43 6C E8 ?? ?? ?? ?? 48 85 C0 7C 6D 40 89 44 24 04 33 ED 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 44 47 33 F6 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 E8 00 00 00 46 4F 75 BF 45 FF 4C 24 04 75 9A 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "TCustomActionManager.SetLinkedActionLists"
		size = 57
		refs = "0010 _DV_TActionListItem 001a _DV_TActionListCollection 001f TOwnedCollection.Create"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 BB 8C 00 00 00 00 75 1A A1 ?? ?? ?? ?? 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 8C 00 00 00 8B D6 8B 83 8C 00 00 00 8B 08 FF 51 08 5E 5B C3 }
	condition:
		$1
}

rule function_740_0 {
	meta:
		name = "TCustomActionManager.Change"
		size = 30
		refs = "0006 TCustomActionList.Change 0018 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 6C 85 C0 74 0B 6A 00 6A 00 8B D0 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "TCustomActionManager.GetActionClientsClass"
		size = 59
		refs = "0004 _DV_TActionClients"
	strings:
		$1 = { 53 51 8B 15 ?? ?? ?? ?? 89 14 24 66 83 B8 D2 00 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 D4 00 00 00 FF 93 D0 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "TCustomActionManager.GetCommandPropertiesClass"
		size = 60
		refs = "0004 _DV_TButtonProperties"
	strings:
		$1 = { 53 51 8B 0D ?? ?? ?? ?? 89 0C 24 66 83 B8 EA 00 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 EC 00 00 00 FF 93 E8 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "TCustomActionManager.GetActionClientItemClass"
		size = 59
		refs = "0004 _DV_TActionClientItem"
	strings:
		$1 = { 53 51 8B 15 ?? ?? ?? ?? 89 14 24 66 83 B8 CA 00 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 CC 00 00 00 FF 93 C8 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "TCustomActionManager.GetActionBarsClass"
		size = 51
		refs = "0004 _DV_TActionBars"
	strings:
		$1 = { 53 56 8B 1D ?? ?? ?? ?? 66 83 B8 C2 00 00 00 00 74 12 8B F0 8B CB 8B D0 8B 86 C4 00 00 00 FF 96 C0 00 00 00 85 DB 75 06 8B 1D ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "TCustomActionManager.GetActionBarItemClass"
		size = 59
		refs = "0004 _DV_TActionBarItem"
	strings:
		$1 = { 53 51 8B 15 ?? ?? ?? ?? 89 14 24 66 83 B8 BA 00 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 BC 00 00 00 FF 93 B8 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "TCustomActionManager.IsLinkedActionListsStored"
		size = 36
		refs = "000f TCustomActionManager.GetLinkedActionLists 0014 TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 83 BB 8C 00 00 00 00 74 10 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7F 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_747_0 {
	meta:
		name = "TCustomActionManager.ImageListChange"
		size = 6
	strings:
		$1 = { 8B 10 FF 52 30 C3 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "TCustomActionManager.IsActionBarsStored"
		size = 18
		refs = "0007 TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 6C E8 ?? ?? ?? ?? 85 C0 0F 9F C0 5B C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "TCustomActionManager.GetFileName"
		size = 22
		refs = "000f @UStrAsg"
		altNames = "TIdUDPBase.GetHost"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 93 94 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "TCustomActionManager.SetFileName"
		size = 95
		refs = "000e @UStrAddRef 0016 TCustomActionManager.SetFileName 002a @UStrEqual 003a @UStrAsg 004f @UStrClr 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 93 94 00 00 00 E8 ?? ?? ?? ?? 74 0E 8D 83 94 00 00 00 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "TCustomActionManager.GetLinkedActionLists"
		size = 46
		refs = "000d _DV_TActionListItem 0017 _DV_TActionListCollection 001c TOwnedCollection.Create"
	strings:
		$1 = { 53 8B D8 83 BB 8C 00 00 00 00 75 1A A1 ?? ?? ?? ?? 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 8C 00 00 00 8B 83 8C 00 00 00 5B C3 }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "TCustomActionManager.ReadStyleProp"
		size = 223
		refs = "0017 TCustomActionManager.ReadStyleProp 0027 TReader.ReadString 0047 ActionBarStyles 0058 TActionBarStyleList.GetStyle 0062 TCustomActionManager.SetStyle 0071 @HandleAnyException 007f ApplicationHandleException 008b ExceptObject 009f ExceptAddr 00ab ShowException 00b2 @RaiseAgain 00b7 @DoneExcept 00cc @UStrClr 00d2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D FC 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 0F 84 86 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC A1 ?? ?? ?? ?? 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 4B E9 ?? ?? ?? ?? 8B 45 F8 F6 40 1C 10 74 33 A1 ?? ?? ?? ?? 66 83 78 02 00 74 14 E8 ?? ?? ?? ?? 8B D0 8B 1D ?? ?? ?? ?? 8B 43 04 FF 13 EB 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "TCustomActionManager.WriteStyleProp"
		size = 112
		refs = "0013 TCustomActionManager.WriteStyleProp 002e ActionBarStyles 0033 TActionBarStyleList.GetStyle 004a TWriter.WriteString 005f @UStrClr 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 89 55 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 90 E0 00 00 00 85 D2 74 04 8B DA EB 0E 33 D2 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8D 55 F8 8B C3 8B 08 FF 51 08 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_754_0 {
	meta:
		name = "TCustomActionManager.HasLinkedActionLists"
		size = 11
	strings:
		$1 = { 83 B8 8C 00 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "TCustomActionManager.AfterConstruction"
		size = 58
		refs = "0006 TObject.AfterConstruction 0018 DefaultActnBarStyle 001d ActionBarStyles 002e TActionBarStyleList.GetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 74 28 F6 43 1C 01 75 22 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 E0 00 00 00 5B C3 }
	condition:
		$1
}

rule function_756_0 {
	meta:
		name = "TCustomActionManager.SetStyle"
		size = 214
		refs = "001c TCollection.GetCount 0034 TActionBars.GetActionBar 0061 TCustomActionBar.GetColorMap 00cd NotifyDesigner"
	strings:
		$1 = { 53 56 57 55 8B D8 3B 93 E0 00 00 00 0F 84 BF 00 00 00 89 93 E0 00 00 00 8B 43 6C E8 ?? ?? ?? ?? 8B F8 4F 85 FF 0F 8C 81 00 00 00 47 33 F6 8B D6 8B 43 6C E8 ?? ?? ?? ?? 83 78 0C 00 74 6A 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 92 58 01 00 00 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C E8 ?? ?? ?? ?? 8B E8 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 3B A8 D0 02 00 00 75 17 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 33 D2 8B 08 FF 91 38 01 00 00 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 92 80 00 00 00 46 4F 75 82 66 83 BB DA 00 00 00 00 74 0E 8B D3 8B 83 DC 00 00 00 FF 93 D8 00 00 00 F6 43 1C 10 74 07 33 C0 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "TCustomActionManager.SetState"
		size = 133
		refs = "0013 TCustomActionList.SetState 0022 TCollection.GetEnumerator 002d TCustomActionManager.SetState 003d TCollectionEnumerator.GetCurrent 0053 TCollectionEnumerator.MoveNext 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 88 55 FF 8B D8 0F B6 55 FF 8B C3 E8 ?? ?? ?? ?? 8B 83 8C 00 00 00 85 C0 74 5F E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 16 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 8B 43 0C 0F B6 55 FF 8B 08 FF 51 38 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 75 DE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D F8 00 74 0A B2 01 8B 45 F8 8B 08 FF 51 FC C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_758_0 {
	meta:
		name = "TActionListItem.Assign"
		size = 198
		refs = "0016 TActionListItem.Assign 0026 TPersistent.Assign 002e _DV_TActionListItem 0033 @IsClass 0063 TActionListItem.SetActionList 006d TActionListItem.GetCaption 007b @UStrAsg 009d @HandleFinally 00b4 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 68 8B 45 FC 8B 70 04 85 F6 74 07 8B C6 8B 10 FF 52 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B F3 8B 56 0C 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 83 C0 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "TActionListItem.GetCaption"
		size = 75
		refs = "000e @UStrAsg 003d SNoName 0042 LoadResString"
	strings:
		$1 = { 53 56 57 51 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 8B 06 89 04 24 8B 04 24 85 C0 74 05 83 E8 04 8B 00 85 C0 75 1F 8B 7B 0C 85 FF 74 0C 8B C6 8B 57 08 E8 ?? ?? ?? ?? EB 0C 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "TActionListItem.GetDisplayName"
		size = 36
		refs = "0011 TActionListItem.GetCaption 001d TCollectionItem.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 0C 00 74 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "TActionListItem.SetActionList"
		size = 141
		refs = "0010 TActionListItem.SetActionList 001d TActionListItem.Owner 0022 TActionListCollection.GetActionManager 002e SCircularReferencesNotAllowed 0033 LoadResString 003d _Dn_Exception 0042 Exception.Create 0047 @RaiseExcept 0066 TComponent.FreeNotification 007b @UStrClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B F0 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 73 0C 74 1A 8B FE 89 7B 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_763_0 {
	meta:
		name = "TActionListCollection.GetActionManager"
		size = 12
		refs = "0006 TCollection.Owner"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1906_0 {
	meta:
		name = "FormatClearStr"
		size = 12
		refs = "0006 @LStrClr"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_814_0 {
	meta:
		name = "TActionBars.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_823_0 {
	meta:
		name = "TActionClients.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3384_0 {
	meta:
		name = "TButtonItem.GetNotifyTarget"
		size = 12
		refs = "0006 TButtonItem.GetButtonGroup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9431_0 {
	meta:
		name = "TCheckConstraints.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7252_0 {
	meta:
		name = "TClassList.First"
		size = 12
		refs = "0006 TList.First"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7256_0 {
	meta:
		name = "TClassList.Last"
		size = 12
		refs = "0006 TList.Last"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18595_0 {
	meta:
		name = "TColumnCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6436_0 {
	meta:
		name = "TComboExItems.Add"
		size = 12
		refs = "0006 TListControlItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7241_0 {
	meta:
		name = "TComponentList.First"
		size = 12
		refs = "0006 TObjectList.First"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7246_0 {
	meta:
		name = "TComponentList.Last"
		size = 12
		refs = "0006 TObjectList.Last"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18598_0 {
	meta:
		name = "TControlCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_22093_0 {
	meta:
		name = "TCookieCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6259_0 {
	meta:
		name = "TCoolBands.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11216_0 {
	meta:
		name = "TDBGridColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15891_0 {
	meta:
		name = "TDBXJSonStreamReader.ReadShort"
		size = 12
		refs = "0006 TDBXJSonStreamReader.ReadInt"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18080_0 {
	meta:
		name = "TDSPlatform.DefaultPackageName"
		size = 12
		refs = "0006 @WStrClr"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11535_0 {
	meta:
		name = "TDataBindings.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19176_0 {
	meta:
		name = "TFMTBcdData.GetAsSmallInt"
		size = 12
		refs = "0006 TFMTBcdData.GetAsInteger"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17228_0 {
	meta:
		name = "TFavoriteLinkItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8775_0 {
	meta:
		name = "TFieldDefs.AddFieldDef"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17220_0 {
	meta:
		name = "TFileTypeItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3075_0 {
	meta:
		name = "TGrpButtonItem.GetNotifyTarget"
		size = 12
		refs = "0006 TGrpButtonItem.GetButtonGroup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3078_0 {
	meta:
		name = "TGrpButtonItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12217_0 {
	meta:
		name = "THTMLTableColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24645_0 {
	meta:
		name = "TIdAuthenticationCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24856_0 {
	meta:
		name = "TIdCommandHandlers.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25254_0 {
	meta:
		name = "TIdDBList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25246_0 {
	meta:
		name = "TIdDefinitions.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25680_0 {
	meta:
		name = "TIdEMailAddressList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25772_0 {
	meta:
		name = "TIdFSPListItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26017_0 {
	meta:
		name = "TIdFTPListItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26045_0 {
	meta:
		name = "TIdFTPListOutput.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_28295_0 {
	meta:
		name = "TIdFormDataFields.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26993_0 {
	meta:
		name = "TIdGopherMenu.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_27296_0 {
	meta:
		name = "TIdImapMessageParts.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25264_0 {
	meta:
		name = "TIdMatchList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_28247_0 {
	meta:
		name = "TIdMessageCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_28789_0 {
	meta:
		name = "TIdReplies.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_28917_0 {
	meta:
		name = "TIdSASLEntries.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_29131_0 {
	meta:
		name = "TIdSMTPRelayStatusList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_29351_0 {
	meta:
		name = "TIdSSLRegistry.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25259_0 {
	meta:
		name = "TIdStrategyList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30314_0 {
	meta:
		name = "TIdVCardAddresses.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30308_0 {
	meta:
		name = "TIdVCardEMailAddresses.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30333_0 {
	meta:
		name = "TIdVCardMailingLabels.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30318_0 {
	meta:
		name = "TIdVCardTelephones.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9363_0 {
	meta:
		name = "TIndexDefs.AddIndexDef"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1107_0 {
	meta:
		name = "TMenuStack.Peek"
		size = 12
		refs = "0006 TOrderedList.PeekItem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7229_0 {
	meta:
		name = "TObjectList.First"
		size = 12
		refs = "0006 TList.First"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7233_0 {
	meta:
		name = "TObjectList.Last"
		size = 12
		refs = "0006 TList.Last"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7273_0 {
	meta:
		name = "TObjectQueue.Peek"
		size = 12
		refs = "0006 TOrderedList.Peek"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7274_0 {
	meta:
		name = "TObjectQueue.Pop"
		size = 12
		refs = "0006 TOrderedList.Pop"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7269_0 {
	meta:
		name = "TObjectStack.Peek"
		size = 12
		refs = "0006 TOrderedList.Peek"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7270_0 {
	meta:
		name = "TObjectStack.Pop"
		size = 12
		refs = "0006 TOrderedList.Pop"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18591_0 {
	meta:
		name = "TRowCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48435_0 {
	meta:
		name = "TScreenTipsCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5198_0 {
	meta:
		name = "TStatusPanels.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17307_0 {
	meta:
		name = "TTaskDialogButtons.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_22136_0 {
	meta:
		name = "TWebActionItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5778_0 {
	meta:
		name = "TWorkAreas.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_65134_0 {
	meta:
		name = "TXmlHandlers.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_764_0 {
	meta:
		name = "TActionBars.GetActionBar"
		size = 18
		refs = "000b TCollection.GetItem"
		altNames = "TActionClients.GetActionClient TActionClientsCollection.GetActionClient TActionListCollection.GetListItem TAggregates.GetItem TCellCollection.GetItem TChartCustomAxes.Get TCheckConstraints.GetItem TControlCollection.GetItem TCookieCollection.GetCookie TCoolBands.GetItem TDBGridColumns.GetColumn TDataBindings.GetItem TDependencies.GetItem TFavoriteLinkItems.GetItem TFieldDefs.GetFieldDef TFileTypeItems.GetItem TFilterItems.Get TGrpButtonItems.GetItem THTMLTableColumns.GetColumn THeaderSections.GetItem TIdAuthenticationCollection.GetAuthItem TIdCommandHandlers.GetItem TIdDBList.GetItems TIdDefinitions.GetItems TIdEMailAddressList.GetItem TIdFSPListItems.GetItems TIdFTPListItems.GetItems TIdFTPListOutput.GetItems TIdFormDataFields.GetFormDataField TIdGopherMenu.GetItem TIdImapMessageParts.GetItem TIdMatchList.GetItems TIdMessageParts.GetItem TIdReplies.GetItem TIdSASLEntries.GetItem TIdSMTPRelayStatusList.GetItems TIdSSLRegistry.GetItem TIdSocketHandles.GetItem TIdStrategyList.GetItems TIdUserAccounts.GetAccount TIdVCardAddresses.GetItem TIdVCardEMailAddresses.GetItem TIdVCardMailingLabels.GetItem TIdVCardTelephones.GetItem TIndexDefs.GetIndexDef TListColumns.GetItem TListControlItems.GetListItem TListGroups.GetItem TParameters.GetItem TQueryResult.GetItem TScreenTipsCollection.GetItem TSeriesGroups.Get TServerCollection.GetItem TStatusPanels.GetItem TTaskDialogButtons.GetItem TWebActionItems.GetActionItem TWebUserItems.GetUserItem TWorkAreas.GetItem TXmlHandlers.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53611_0 {
	meta:
		name = "AnsiLowerCaseFileName"
		size = 18
		refs = "000b AnsiLowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53105_0 {
	meta:
		name = "AnsiToUtf8"
		size = 18
		refs = "000b UTF8Encode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53612_0 {
	meta:
		name = "AnsiUpperCaseFileName"
		size = 18
		refs = "000b AnsiUpperCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3559_0 {
	meta:
		name = "ConvertFromUtf32"
		size = 18
		refs = "000b TCharacter.ConvertFromUtf32"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1998_0 {
	meta:
		name = "ExcludeTrailingBackslash"
		size = 18
		refs = "000b ExcludeTrailingPathDelimiter"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28492_0 {
	meta:
		name = "FileNameMSDOSToUnix"
		size = 18
		refs = "000b LowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28499_0 {
	meta:
		name = "FileNameMUSICSPToUnix"
		size = 18
		refs = "000b LowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28501_0 {
	meta:
		name = "FileNameMVSToUnix"
		size = 18
		refs = "000b LowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28497_0 {
	meta:
		name = "FileNameVMCMSToUnix"
		size = 18
		refs = "000b LowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28495_0 {
	meta:
		name = "FileNameWin32ToUnix"
		size = 18
		refs = "000b LowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1996_0 {
	meta:
		name = "IncludeTrailingBackslash"
		size = 18
		refs = "000b IncludeTrailingPathDelimiter"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_26804_0 {
	meta:
		name = "IndyExcludeTrailingPathDelimiter"
		size = 18
		refs = "000b ExcludeTrailingPathDelimiter"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_26803_0 {
	meta:
		name = "IndyIncludeTrailingPathDelimiter"
		size = 18
		refs = "000b IncludeTrailingPathDelimiter"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_26871_0 {
	meta:
		name = "IndyLowerCase"
		size = 18
		refs = "000b AnsiLowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_26872_0 {
	meta:
		name = "IndyUpperCase"
		size = 18
		refs = "000b AnsiUpperCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_52804_0 {
	meta:
		name = "LoadResStringU"
		size = 18
		refs = "000b LoadResString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53226_0 {
	meta:
		name = "LoadStr"
		size = 18
		refs = "000b FindStringResource"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10532_0 {
	meta:
		name = "MetaDataFromUnicode"
		size = 18
		refs = "000b UTF8Encode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60322_0 {
	meta:
		name = "TAdapterDataDisplay.GetAdapterModeOfAdapter"
		size = 18
		refs = "000b GetAdapterModeOfAdapterInParent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59038_0 {
	meta:
		name = "TAdapterNamedField.GetDefaultDisplayLabel"
		size = 18
		refs = "000b TAdapterNamedField.GetVariableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_56791_0 {
	meta:
		name = "TAxisItems.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59088_0 {
	meta:
		name = "TBaseAdapterAction.GetDefaultDisplayLabel"
		size = 18
		refs = "000b TBaseAdapterAction.GetActionName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59080_0 {
	meta:
		name = "TBaseAdapterAction.GetVariableName"
		size = 18
		refs = "000b TBaseAdapterAction.ImplGetVariableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59081_0 {
	meta:
		name = "TBaseAdapterAction.ImplGetVariableName"
		size = 18
		refs = "000b TBaseAdapterAction.GetActionName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7251_0 {
	meta:
		name = "TClassList.Extract"
		size = 18
		refs = "000b TList.Extract"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7253_0 {
	meta:
		name = "TClassList.GetItems"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6438_0 {
	meta:
		name = "TComboExItems.GetComboItem"
		size = 18
		refs = "000b TListControlItems.GetListItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7240_0 {
	meta:
		name = "TComponentList.Extract"
		size = 18
		refs = "000b TObjectList.Extract"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7242_0 {
	meta:
		name = "TComponentList.GetItems"
		size = 18
		refs = "000b TObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60323_0 {
	meta:
		name = "TCustomAdapterActionButton.GetAdapterModeOfAdapter"
		size = 18
		refs = "000b GetAdapterModeOfAdapterInParent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_51413_0 {
	meta:
		name = "TCustomLabel.GetLabelText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41501_0 {
	meta:
		name = "TCustomMaskEdit.GetEditText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_66545_0 {
	meta:
		name = "TCustomXSLPageProducer.GetProducerTemplateFileName"
		size = 18
		refs = "000b TXMLDocument.GetFileName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11436_0 {
	meta:
		name = "TDBLookupCombo.GetDisplayValue"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13997_0 {
	meta:
		name = "TDBXDelegateConnection.GetErrorEvent"
		size = 18
		refs = "000b TDBXConnection.GetErrorEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16369_0 {
	meta:
		name = "TDBXTraceCommand.GetCommandType"
		size = 18
		refs = "000b TDBXDelegateCommand.GetCommandType"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16370_0 {
	meta:
		name = "TDBXTraceCommand.GetErrorEvent"
		size = 18
		refs = "000b TDBXDelegateCommand.GetErrorEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16367_0 {
	meta:
		name = "TDBXTraceCommand.GetText"
		size = 18
		refs = "000b TDBXDelegateCommand.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16340_0 {
	meta:
		name = "TDBXTraceConnection.GetErrorEvent"
		size = 18
		refs = "000b TDBXDelegateConnection.GetErrorEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16346_0 {
	meta:
		name = "TDBXTraceConnection.GetTraceInfoEvent"
		size = 18
		refs = "000b TDBXDelegateConnection.GetTraceInfoEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8871_0 {
	meta:
		name = "TField.GetDisplayLabel"
		size = 18
		refs = "000b TField.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48571_0 {
	meta:
		name = "TFunction.GetBody"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48572_0 {
	meta:
		name = "TFunction.GetFunctionName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48568_0 {
	meta:
		name = "TFunctions.FindFunctionName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20749_0 {
	meta:
		name = "TGIFExtensionList.GetExtension"
		size = 18
		refs = "000b TGIFList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20899_0 {
	meta:
		name = "TGIFImageList.GetFrame"
		size = 18
		refs = "000b TGIFList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48578_0 {
	meta:
		name = "THTMLBlock.GetBlockName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48577_0 {
	meta:
		name = "THTMLBlock.GetHTML"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48574_0 {
	meta:
		name = "THTMLBlocks.FindBlockName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60550_0 {
	meta:
		name = "THTMLItems.GetHTMLItem"
		size = 18
		refs = "000b TObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23762_0 {
	meta:
		name = "TIBQuery.PSGetTableNameW"
		size = 18
		refs = "000b TIBCustomDataSet.PSGetTableNameW"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24956_0 {
	meta:
		name = "TIdCookieRFC2109.GetClientCookie"
		size = 18
		refs = "000b TIdNetscapeCookie.GetClientCookie"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24960_0 {
	meta:
		name = "TIdCookieRFC2965.GetCookie"
		size = 18
		refs = "000b TIdCookieRFC2109.GetCookie"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25574_0 {
	meta:
		name = "TIdDNSMap.GetItem"
		size = 18
		refs = "000b TIdObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24923_0 {
	meta:
		name = "TIdObjectList.GetItem"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25628_0 {
	meta:
		name = "TIdPropEdSASL.GetValue"
		size = 18
		refs = "000b TPropertyEditor.GetStrValue"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28921_0 {
	meta:
		name = "TIdSASLEntries.Insert"
		size = 18
		refs = "000b TCollection.Insert"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25344_0 {
	meta:
		name = "TIdTextModeRRs.GetItem"
		size = 18
		refs = "000b TIdObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7299_0 {
	meta:
		name = "TIntegerBucketList.GetData"
		size = 18
		refs = "000b TCustomBucketList.GetData"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7300_0 {
	meta:
		name = "TIntegerBucketList.Remove"
		size = 18
		refs = "000b TCustomBucketList.Remove"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10172_0 {
	meta:
		name = "TListOfDataSources.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1110_0 {
	meta:
		name = "TMenuList.GetMenu"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7295_0 {
	meta:
		name = "TObjectBucketList.GetData"
		size = 18
		refs = "000b TCustomBucketList.GetData"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7296_0 {
	meta:
		name = "TObjectBucketList.Remove"
		size = 18
		refs = "000b TCustomBucketList.Remove"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7227_0 {
	meta:
		name = "TObjectList.Extract"
		size = 18
		refs = "000b TList.Extract"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7230_0 {
	meta:
		name = "TObjectList.GetItem"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7275_0 {
	meta:
		name = "TObjectQueue.Push"
		size = 18
		refs = "000b TOrderedList.Push"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7271_0 {
	meta:
		name = "TObjectStack.Push"
		size = 18
		refs = "000b TOrderedList.Push"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44855_0 {
	meta:
		name = "TOleControl.GetByteProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44885_0 {
	meta:
		name = "TOleControl.GetShortIntProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44891_0 {
	meta:
		name = "TOleControl.GetWordProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46332_0 {
	meta:
		name = "TPNGList.GetItem"
		size = 18
		refs = "000b TPNGPointerList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50862_0 {
	meta:
		name = "TSQLConnection.GetDataSet"
		size = 18
		refs = "000b TCustomConnection.GetDataSet"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48440_0 {
	meta:
		name = "TScreenTipsCollection.Insert"
		size = 18
		refs = "000b TCollection.Insert"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48584_0 {
	meta:
		name = "TScriptBlock.GetBlockName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48583_0 {
	meta:
		name = "TScriptBlock.GetScript"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48580_0 {
	meta:
		name = "TScriptBlocks.FindBlockName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60591_0 {
	meta:
		name = "TScriptFile.GetLongName"
		size = 18
		refs = "000b TScriptFile.GetApplicationName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60593_0 {
	meta:
		name = "TScriptFile.GetShortName"
		size = 18
		refs = "000b TScriptFile.GetApplicationName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12120_0 {
	meta:
		name = "TStoredProc.PSGetTableName"
		size = 18
		refs = "000b TDataSet.PSGetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17549_0 {
	meta:
		name = "TTableList.GetItems"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_55512_0 {
	meta:
		name = "TTeeExportFormats.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_54478_0 {
	meta:
		name = "TTeeFilter.Description"
		size = 18
		refs = "000b TObject.ClassName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_56964_0 {
	meta:
		name = "TTeePanelsList.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48589_0 {
	meta:
		name = "TVar.GetScript"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48590_0 {
	meta:
		name = "TVar.GetVarName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48586_0 {
	meta:
		name = "TVars.FindVarName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50466_0 {
	meta:
		name = "TWebAppRegList.GetItem"
		size = 18
		refs = "000b TObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5782_0 {
	meta:
		name = "TWorkAreas.Insert"
		size = 18
		refs = "000b TCollection.Insert"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_65516_0 {
	meta:
		name = "TXMLBroker.SubmitFormVarName"
		size = 18
		refs = "000b TXMLBroker.HTMLSubmitFormName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_66484_0 {
	meta:
		name = "TXSBaseDuration.NativeToXSAsDateTime"
		size = 18
		refs = "000b TXSBaseCustomDateTime.NativeToXS"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_56969_0 {
	meta:
		name = "TeeStr"
		size = 18
		refs = "000b IntToStr"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3598_0 {
	meta:
		name = "ToLower"
		size = 18
		refs = "000b TCharacter.ToLower"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3600_0 {
	meta:
		name = "ToUpper"
		size = 18
		refs = "000b TCharacter.ToUpper"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_52731_0 {
	meta:
		name = "UTF8ShortStringToString"
		size = 18
		refs = "000b UTF8ToString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53103_0 {
	meta:
		name = "UTF8ToString"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53097_0 {
	meta:
		name = "UTF8ToWideString"
		size = 18
		refs = "000b UTF8Decode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53106_0 {
	meta:
		name = "Utf8ToAnsi"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_765_0 {
	meta:
		name = "TActionListCollection.SetListItem"
		size = 29
		refs = "000e TActionListCollection.GetListItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_11869_0 {
	meta:
		name = "TBDEDataSet.SetIndexField"
		size = 29
		refs = "000e TBDEDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_22095_0 {
	meta:
		name = "TCookieCollection.SetCookie"
		size = 29
		refs = "000e TCookieCollection.GetCookie"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1823_0 {
	meta:
		name = "TCustomADODataSet.SetIndexField"
		size = 29
		refs = "000e TCustomADODataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10380_0 {
	meta:
		name = "TCustomClientDataSet.SetIndexField"
		size = 29
		refs = "000e TCustomClientDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_11226_0 {
	meta:
		name = "TDBGridColumns.SetColumn"
		size = 29
		refs = "000e TDBGridColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_8820_0 {
	meta:
		name = "TFields.SetField"
		size = 29
		refs = "000e TFields.GetField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12222_0 {
	meta:
		name = "THTMLTableColumns.SetColumn"
		size = 29
		refs = "000e THTMLTableColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_24373_0 {
	meta:
		name = "TIBTable.SetIndexField"
		size = 29
		refs = "000e TIBTable.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_29133_0 {
	meta:
		name = "TIdSMTPRelayStatusList.SetItems"
		size = 29
		refs = "000e TIdSMTPRelayStatusList.GetItems"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5843_0 {
	meta:
		name = "TListItems.SetItem"
		size = 29
		refs = "000e TListItems.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_51040_0 {
	meta:
		name = "TSQLTable.SetIndexField"
		size = 29
		refs = "000e TSQLTable.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_22142_0 {
	meta:
		name = "TWebActionItems.SetActionItem"
		size = 29
		refs = "000e TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_61040_0 {
	meta:
		name = "TWebUserItems.SetUserItem"
		size = 29
		refs = "000e TWebUserItems.GetUserItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_768_0 {
	meta:
		name = "TActionClientsCollection.GetActionManager"
		size = 23
		refs = "0006 TCollection.Owner 000c _DV_TActionManager 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3395_0 {
	meta:
		name = "TButtonCategories.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TButtonCategory 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3386_0 {
	meta:
		name = "TButtonCollection.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TButtonItem 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1307_0 {
	meta:
		name = "TCustomMenuButton.GetMenu"
		size = 23
		refs = "0006 TCustomActionControl.GetActionBar 000c _DV_TCustomActionMenuBar 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1187_0 {
	meta:
		name = "TCustomMenuExpandBtn.GetMenu"
		size = 23
		refs = "0006 TCustomActionControl.GetActionBar 000c _DV_TCustomActionMenuBar 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_30271_0 {
	meta:
		name = "TIdUserAccounts.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TIdUserAccount 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47900_0 {
	meta:
		name = "TOptionItems.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TOptionItem 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47901_0 {
	meta:
		name = "TOptionItems.GetApplicationMenu"
		size = 23
		refs = "0006 TCollection.Owner 000c _DV_TRibbonApplicationMenuBar 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1572_0 {
	meta:
		name = "TParameters.AddParameter"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TParameter 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47263_0 {
	meta:
		name = "TRibbonTabs.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TRibbonTabItem 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47270_0 {
	meta:
		name = "TRibbonTabs.GetRibbon"
		size = 23
		refs = "0006 TCollection.Owner 000c _DV_TCustomRibbon 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "IfHotkeyAvailable"
		size = 46
		refs = "000b AnsiPos 0025 @UStrDelete"
	strings:
		$1 = { 55 8B EC 53 8B 55 08 8B 52 FC E8 ?? ?? ?? ?? 85 C0 0F 95 C3 84 DB 74 11 8B 55 08 83 C2 FC B9 01 00 00 00 92 E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_41898_0 {
	meta:
		name = "IfHotkeyAvailable"
		size = 46
		refs = "000b Pos 0025 @UStrDelete"
	strings:
		$1 = { 55 8B EC 53 8B 55 08 8B 52 FC E8 ?? ?? ?? ?? 85 C0 0F 95 C3 84 DB 74 11 8B 55 08 83 C2 FC B9 01 00 00 00 92 E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_770_0 {
	meta:
		name = "CopyToBest"
		size = 129
		refs = "0078 @UStrLAsg"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 8B 08 FF 51 08 8B 45 08 8B 40 F4 8B 10 FF 52 14 8B 55 08 89 42 F0 8B 45 08 8B 40 EC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 31 46 33 DB 8B 45 08 8B 40 EC 8B D3 8B 08 FF 51 18 50 8B 45 08 8B 40 EC 8B D3 8B 08 FF 51 18 8B 50 20 8B 45 08 8B 40 F8 59 8B 38 FF 57 3C 43 4E 75 D2 8B 45 08 83 C0 E8 8B 55 08 8B 52 FC E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_771_0 {
	meta:
		name = "InsertHotkeyFarEastFormat"
		size = 468
		refs = "001d InsertHotkeyFarEastFormat 0041 @InternalUStrFromLStr 0061 TCharacter.GetUnicodeCategory 00b8 @UStrCopy 00c5 @UStrEqual 0127 @UStrCatN 0160 @UStrInsert 017a @UStrArrayClr 0180 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 89 5D F0 89 4D F8 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 00 8B 06 85 C0 74 14 8B D0 83 EA 0A 66 83 3A 02 74 09 8B 16 8B C6 E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 8B D8 85 DB 7E 23 BF 01 00 00 00 8B 06 0F B7 44 78 FE E8 ?? ?? ?? ?? 3C 07 74 04 3C 0F 75 06 C6 45 F7 01 EB 04 47 4B 75 E2 80 7D F7 00 0F 84 CE 00 00 00 8B 06 85 C0 74 14 8B D0 83 EA 0A 66 83 3A 02 74 09 8B 16 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 F0 50 8B D3 83 EA 03 42 8B 06 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 62 8B 06 85 C0 74 14 8B D0 83 EA 0A 66 83 3A 02 74 09 8B 16 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 EC 50 8B CB 83 E9 03 8B 06 BA 01 00 00 00 E8 ?? ?? ?? ?? FF 75 EC 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 FC 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B C6 BA 06 00 00 00 E8 ?? ?? ?? ?? EB 37 FF 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 FC 68 ?? ?? ?? ?? 8B C6 BA 05 00 00 00 E8 ?? ?? ?? ?? EB 15 83 7D F8 00 74 0F 8B D6 8B 4D F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 03 00 00 00 2E 00 2E 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 28 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 26 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 29 00 00 00 }
	condition:
		$1
}

rule function_772_0 {
	meta:
		name = "TActionClientsCollection.InternalRethinkHotkeys"
		size = 1440
		refs = "002c TActionClientsCollection.InternalRethinkHotkeys 0054 ValidMenuHotkeys 005b @UStrLAsg 0062 _Dn_TStringList 0067 TStringList.Create 00b2 TCollection.GetCount 00d1 TActionClientsCollection.GetActionClient 00f3 @UStrEqual 0124 GetHotkey 012f UpperCase 0140 TCollection.GetItem 016b AnsiPos 0178 IfHotkeyAvailable 01a2 StripHotkey 01ab @UStrAsg 0263 @InternalUStrFromLStr 028d @UStrCopy 02ab SysLocale 02be InsertHotkeyFarEastFormat 02cf @UStrInsert 02fd @EnsureUnicodeString 0302 @UStrLen 032a CopyToBest 0489 @UStrDelete 04c0 TObject.Free 04de @HandleFinally 0554 @UStrArrayClr 0569 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 B4 53 56 33 C9 89 4D B4 89 4D B8 89 4D BC 89 4D C0 89 4D E4 89 4D E0 89 4D DC 89 4D FC 89 4D E8 89 45 D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 D7 00 8B 45 D8 80 78 1C 00 0F 84 F7 04 00 00 84 D2 0F 84 95 04 00 00 8D 45 FC 8B 15 ?? ?? ?? ?? 8B 12 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 D0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 89 45 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 D8 E8 ?? ?? ?? ?? 48 85 C0 0F 8C 20 01 00 00 40 89 45 C4 C7 45 CC 00 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 80 78 30 00 0F 84 F4 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 20 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 D6 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 83 78 20 00 0F 84 C1 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 20 8D 55 C0 E8 ?? ?? ?? ?? 8B 45 C0 8D 55 E4 E8 ?? ?? ?? ?? 83 7D E4 00 75 26 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 50 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 48 20 33 D2 8B 45 D0 8B 18 FF 53 64 EB 74 8B 15 ?? ?? ?? ?? 8B 12 8B 45 E4 E8 ?? ?? ?? ?? 85 C0 74 60 55 8B 45 E4 E8 ?? ?? ?? ?? 59 84 C0 75 52 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 83 C0 20 50 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 20 8D 55 BC E8 ?? ?? ?? ?? 8B 55 BC 58 E8 ?? ?? ?? ?? 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 50 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 48 20 33 D2 8B 45 D0 8B 18 FF 53 64 FF 45 CC FF 4D C4 0F 85 EB FE FF FF 8D 45 DC 8B 55 FC E8 ?? ?? ?? ?? 8B 45 D0 8B 10 FF 52 14 48 85 C0 0F 8C 92 01 00 00 40 89 45 C4 8D 45 FC 8B 55 DC E8 ?? ?? ?? ?? 8B 55 D0 8B 45 EC 8B 08 FF 51 08 8B 45 F4 8B 10 FF 52 44 8B 45 EC 8B 10 FF 52 14 48 83 F8 00 0F 8C EC 00 00 00 89 45 CC 8D 4D E0 8B 55 CC 8B 45 EC 8B 18 FF 53 0C BB 01 00 00 00 E9 AF 00 00 00 8B 75 E0 85 F6 74 18 8B C6 83 E8 0A 66 83 38 02 74 0D 8D 45 E0 8B 55 E0 E8 ?? ?? ?? ?? 8B F0 66 81 7C 5E FE 00 D8 72 0C 66 81 7C 5E FE FF DF 77 03 43 EB 7A 8D 45 B8 50 B9 01 00 00 00 8B D3 8B 45 E0 E8 ?? ?? ?? ?? 8B 45 B8 8D 55 E4 E8 ?? ?? ?? ?? 55 8B 45 E4 E8 ?? ?? ?? ?? 59 84 C0 74 4E A1 ?? ?? ?? ?? 80 78 0C 00 74 0F 8D 45 E0 8B CB 8B 55 E4 E8 ?? ?? ?? ?? EB 0F 8D 55 E0 8B CB B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 CC 8B 45 EC 8B 08 FF 51 18 8B C8 8B 55 E0 8B 45 F4 8B 18 FF 53 3C 8B 55 CC 8B 45 EC 8B 08 FF 51 48 EB 16 43 8D 45 E0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B D8 0F 8E 3C FF FF FF FF 4D CC 83 7D CC FF 0F 85 17 FF FF FF 8B 45 F4 8B 10 FF 52 14 3B 45 F0 7E 07 55 E8 ?? ?? ?? ?? 59 8B 45 EC 8B 10 FF 52 14 85 C0 7E 52 8B 45 EC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 3A 46 C7 45 CC 00 00 00 00 8B 55 CC 8B 45 EC 8B 08 FF 51 18 8B D0 8B 45 D0 8B 08 FF 51 5C 8B D8 8B 45 D0 8B 10 FF 52 14 8B C8 49 8B D3 8B 45 D0 8B 18 FF 53 78 FF 45 CC 4E 75 CE FF 4D C4 0F 85 72 FE FF FF 83 7D F0 00 75 07 55 E8 ?? ?? ?? ?? 59 8B 45 F8 8B 10 FF 52 14 85 C0 0F 9F 45 D7 8B 45 F8 8B 10 FF 52 14 48 85 C0 0F 8C F6 00 00 00 40 89 45 C4 C7 45 CC 00 00 00 00 8D 4D E0 8B 55 CC 8B 45 F8 8B 18 FF 53 0C A1 ?? ?? ?? ?? 80 78 0C 00 0F 84 AC 00 00 00 8B 55 E0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 97 00 00 00 83 7D E8 00 0F 84 8D 00 00 00 8B 55 E0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 7C 8B 45 E8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 E8 8B 55 E8 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 B4 50 B9 01 00 00 00 8B D3 8B 45 E8 E8 ?? ?? ?? ?? 8B 55 B4 8D 45 E0 33 C9 E8 ?? ?? ?? ?? 8B 45 E8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 E8 8B 55 E8 E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 8D 55 E8 B9 01 00 00 00 92 E8 ?? ?? ?? ?? 8B 55 CC 8B 45 F8 8B 08 FF 51 18 83 C0 20 8B 55 E0 E8 ?? ?? ?? ?? FF 45 CC FF 4D C4 0F 85 15 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 D0 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 8B 45 D8 E8 ?? ?? ?? ?? 48 85 C0 7C 4D 40 89 45 C4 C7 45 CC 00 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 83 78 2C 00 74 29 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 2C 80 78 1C 00 74 15 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 2C B2 01 E8 ?? ?? ?? ?? FF 45 CC FF 4D C4 75 BE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 B4 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D6 0F B6 45 D7 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 26 00 00 00 }
	condition:
		$1
}

rule function_773_0 {
	meta:
		name = "TActionClientsCollection.Create"
		size = 67
		refs = "000d @ClassCreate 001e TOwnedCollection.Create 002d @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 1C 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_774_0 {
	meta:
		name = "TActionClientsCollection.AfterConstruction"
		size = 16
		refs = "0006 TObject.AfterConstruction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_1883_0 {
	meta:
		name = "TADOBlobStream.Truncate"
		size = 16
		refs = "0006 TMemoryStream.Clear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_1882_0 {
	meta:
		name = "TADOBlobStream.Write"
		size = 16
		refs = "0006 TMemoryStream.Write"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_10488_0 {
	meta:
		name = "TClientBlobStream.Truncate"
		size = 16
		refs = "0006 TMemoryStream.Clear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_10487_0 {
	meta:
		name = "TClientBlobStream.Write"
		size = 16
		refs = "0006 TMemoryStream.Write"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_775_0 {
	meta:
		name = "UpdateActionBar"
		size = 55
		refs = "0007 TActionClient.GetItems 000c TCollection.GetCount 0030 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 20 8B C3 E8 ?? ?? ?? ?? 8B 50 20 85 D2 74 12 83 7A 0C 00 74 0C 8B 42 0C 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_776_0 {
	meta:
		name = "TActionClientsCollection.IterateClients"
		size = 290
		refs = "0018 TCollection.GetCount 0030 TActionClientsCollection.GetActionClient 0035 TActionClient.GetHasItems 0075 TActionClient.GetItems 007f TActionClientsCollection.IterateClients 008d UpdateActionBar"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 8B F2 89 45 FC 85 F6 0F 84 05 01 00 00 8B C6 E8 ?? ?? ?? ?? 48 85 C0 0F 8C F5 00 00 00 40 89 45 F8 33 DB 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 56 66 83 7D 0A 00 74 13 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 EB 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 30 FF 75 0C FF 75 08 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 7D 8B D3 8B C6 E8 ?? ?? ?? ?? 83 78 0C 00 74 38 66 83 7D 0A 00 74 13 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 EB 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 30 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 36 66 83 7D 0A 00 74 13 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 EB 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 30 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 43 FF 4D F8 0F 85 11 FF FF FF 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_777_0 {
	meta:
		name = "TActionClientsCollection.SetAutoHotKeys"
		size = 16
		refs = "000b TActionClientsCollection.InternalRethinkHotkeys"
	strings:
		$1 = { 3A 50 1C 74 0A 88 50 1C B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_778_0 {
	meta:
		name = "TActionClient.Create"
		size = 96
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 003a TActionClient.Create 0048 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 89 46 38 C6 46 14 00 C6 46 30 01 C6 46 28 01 C7 46 24 00 00 00 20 C6 46 14 00 0F B6 05 ?? ?? ?? ?? 88 46 31 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 07 00 00 00 }
	condition:
		$1
}

rule function_779_0 {
	meta:
		name = "TActionClient.Destroy"
		size = 121
		refs = "0004 @BeforeDestruction 0019 TObject.Free 0039 TActionClient.ClearActionBar 0056 TActionClient.FreeChildren 0064 TCollectionItem.Destroy 0071 @ClassDestroy"
	strings:
		$1 = { 53 56 51 E8 ?? ?? ?? ?? 88 14 24 8B D8 8D 43 1C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 73 0C 85 F6 74 12 F6 46 1C 08 75 0C 8B C6 33 D2 8B 08 FF 91 30 01 00 00 8B C3 E8 ?? ?? ?? ?? 83 7B 10 00 74 10 8D 43 10 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 0F B6 14 24 80 E2 FC 8B C3 E8 ?? ?? ?? ?? 80 3C 24 00 7E 07 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_780_0 {
	meta:
		name = "TActionClient.AreContextItemsStored"
		size = 74
		refs = "000d TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 83 7B 1C 00 74 39 8B 43 1C E8 ?? ?? ?? ?? 85 C0 7F 31 8B 43 1C 80 78 1C 00 74 28 8B 43 1C 80 78 28 01 75 1F 8B 43 1C 80 78 24 00 74 16 8B 43 1C 80 78 2A 00 74 0D 8B 43 1C 80 78 29 00 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_781_0 {
	meta:
		name = "TActionClient.Assign"
		size = 239
		refs = "000f _DV_TActionClient 0014 @IsClass 0035 TActionClient.Assign 0056 TActionClient.GetContextItems 0065 TActionClient.HasBackground 0070 TActionClient.GetBackground 008b TActionClient.SetBackgroundLayout 00a5 TActionClient.GetItems 00b8 TActionClient.SetActionBar 00da @HandleFinally 00e6 TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 C0 00 00 00 8B 45 FC 8B 70 04 85 F6 74 07 8B C6 8B 10 FF 52 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B F3 8B 56 24 8B 45 FC 8B 08 FF 51 28 83 7E 1C 00 74 10 8B 45 FC E8 ?? ?? ?? ?? 8B 56 1C 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 84 C0 74 16 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 0F B6 56 14 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 30 8B 45 FC 8B 08 FF 51 2C 83 7E 2C 00 74 10 8B 45 FC E8 ?? ?? ?? ?? 8B 56 2C 8B 08 FF 51 08 8B 56 0C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB E9 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_782_0 {
	meta:
		name = "TActionClient.ClearActionBar"
		size = 6
		altNames = "TTreeNodes.ClearCache"
	strings:
		$1 = { 33 D2 89 50 0C C3 }
	condition:
		$1
}

rule function_784_0 {
	meta:
		name = "TActionClient.FreeChildren"
		size = 93
		refs = "000f TCollection.GetCount 002f TActionClients.GetActionClient 0044 TActionClient.FreeChildren 0050 TObject.Free"
	strings:
		$1 = { 53 56 57 8B D8 8B 73 2C 85 F6 74 4D 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 35 8B 43 2C E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 26 47 33 F6 8B D6 8B 43 2C E8 ?? ?? ?? ?? 83 78 2C 00 74 0F 8B D6 8B 43 2C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4F 75 DD 8B 43 2C E8 ?? ?? ?? ?? 33 C0 89 43 2C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_785_0 {
	meta:
		name = "TActionClient.GetBackground"
		size = 29
		refs = "000c _Dn_TPicture 0011 TPicture.Create"
	strings:
		$1 = { 53 8B D8 83 7B 10 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 8B 43 10 5B C3 }
	condition:
		$1
}

rule function_54482_0 {
	meta:
		name = "TTeeFilter.GetRegion"
		size = 29
		refs = "000c _DV_TFilterRegion 0011 TObject.Create"
	strings:
		$1 = { 53 8B D8 83 7B 10 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 8B 43 10 5B C3 }
	condition:
		$1
}

rule function_786_0 {
	meta:
		name = "TActionClient.GetContextItems"
		size = 49
		refs = "000a _DV_TActionClientItem 0012 TActionClient.GetOwningCollection 0017 TActionClientsCollection.GetActionManager 0020 _DV_TActionClients 0025 TActionClients.Create"
	strings:
		$1 = { 53 8B D8 83 7B 1C 00 75 23 A1 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 1C 8B 43 1C 5B C3 }
	condition:
		$1
}

rule function_787_0 {
	meta:
		name = "TActionClient.GetHasItems"
		size = 32
		refs = "000e TCollection.GetCount"
	strings:
		$1 = { 53 56 8B D8 8B 73 2C 85 F6 74 0B 8B C6 E8 ?? ?? ?? ?? 85 C0 7F 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_788_0 {
	meta:
		name = "TActionClientItem.GetParentItem"
		size = 30
		refs = "0006 TActionClientItem.GetActionClients"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0C 8B C3 E8 ?? ?? ?? ?? 8B 40 20 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_789_0 {
	meta:
		name = "TActionClient.GetItems"
		size = 153
		refs = "0012 TActionClient.GetOwningCollection 0022 TActionClientsCollection.GetActionManager 003f @CallDynaInst 006a _DV_TActionClientItem 0080 _DV_TActionClients 0085 TActionClients.Create"
	strings:
		$1 = { 53 56 57 8B D8 83 7B 2C 00 0F 85 83 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 4F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 3F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 8B C7 66 BE EC FF E8 ?? ?? ?? ?? 50 8B C7 66 BE ED FF E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 58 FF 50 28 89 43 2C EB 23 A1 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 2C 8B 43 2C 89 58 20 8B 43 2C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_791_0 {
	meta:
		name = "TActionClient.HasBackground"
		size = 39
		altNames = "TActionClient.IsBackgroundStored"
	strings:
		$1 = { 53 56 8B D8 8B 73 10 85 F6 74 12 83 7E 0C 00 74 0C 8B 46 0C 8B 10 FF 52 20 84 C0 74 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_792_0 {
	meta:
		name = "TActionClient.HasVisibleItems"
		size = 113
		refs = "000b TActionClient.GetItems 0010 TCollection.GetCount 0028 TActionClients.GetActionClient 002d TActionClientItem.Unused 005c TActionClient.HasVisibleItems"
	strings:
		$1 = { 53 56 57 55 8B F0 33 DB 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 4F 47 33 ED 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 18 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 80 78 30 00 74 04 B3 01 EB 19 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 02 B3 01 45 4F 75 B4 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "TActionClient.IsChildItem"
		size = 83
		refs = "0014 TActionClient.GetItems 0024 TActionClient.GetOwningCollection"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 85 F6 74 10 85 F6 74 10 8B C6 E8 ?? ?? ?? ?? 3B 47 04 75 04 B3 01 EB 2C 8B C7 E8 ?? ?? ?? ?? 8B 78 20 85 FF 74 1E 8B C6 E8 ?? ?? ?? ?? 3B 47 04 75 04 B3 01 EB 0E 8B C7 E8 ?? ?? ?? ?? 8B 78 20 85 FF 75 E2 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_795_0 {
	meta:
		name = "TActionClient.IsItemsStored"
		size = 74
		refs = "000d TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 83 7B 2C 00 74 39 8B 43 2C E8 ?? ?? ?? ?? 85 C0 7F 31 8B 43 2C 80 78 1C 00 74 28 8B 43 2C 80 78 28 01 75 1F 8B 43 2C 80 78 24 00 74 16 8B 43 2C 80 78 2A 00 74 0D 8B 43 2C 80 78 29 00 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_797_0 {
	meta:
		name = "TActionClient.SetActionBar"
		size = 247
		refs = "0017 TActionClient.SetActionBar 0030 TActionClient.GetOwningCollection 004b SAssignSubItemError 0050 LoadResString 005a _Dn_Exception 005f Exception.Create 0064 @RaiseExcept 00a1 TActionClientsCollection.GetActionManager 00e4 @UStrClr 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 46 0C 3B 45 FC 0F 84 A6 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 41 8B 7B 20 85 FF 74 34 83 7F 0C 00 74 23 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8B C7 E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 85 DB 75 BF 8B 46 0C 85 C0 74 11 83 B8 68 02 00 00 00 74 08 8B 10 FF 92 E4 00 00 00 83 7D FC 00 74 34 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 40 1C 01 75 22 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 B8 A8 00 00 00 00 75 0D 8B D6 8B 45 FC 8B 08 FF 91 30 01 00 00 8B 45 FC 89 46 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "TActionClient.SetItems"
		size = 30
		refs = "0010 TObject.Free"
	strings:
		$1 = { 85 D2 75 11 83 C0 2C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 8B 40 2C 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "TActionClient.SetBackground"
		size = 127
		refs = "0018 TActionClient.GetHasItems 002a TCustomActionBar.GetItems 002f TCollection.GetCount 0048 TActionClients.GetActionClient 0060 TCustomActionControl.SetTransparent 006c TWinControl.Realign"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B 43 10 8B 08 FF 51 08 85 F6 74 66 8B C3 E8 ?? ?? ?? ?? 84 C0 74 5B 8B 73 0C 85 F6 74 54 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 7C 30 40 89 C6 33 FF 8B 43 0C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B 40 44 0F B6 53 14 80 C2 FD 80 EA 02 0F 92 C2 80 F2 01 E8 ?? ?? ?? ?? 47 4E 75 D5 8B 43 0C E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 92 80 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_800_0 {
	meta:
		name = "TActionClient.SetBackgroundLayout"
		size = 152
		refs = "0017 TActionClient.HasBackground 0022 TActionClient.GetHasItems 002d TActionClient.GetItems 0032 TCollection.GetCount 004a TActionClients.GetActionClient 0074 TCustomActionControl.SetTransparent"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F0 3A 5E 14 0F 84 82 00 00 00 88 5E 14 8B C6 E8 ?? ?? ?? ?? 84 C0 74 5D 8B C6 E8 ?? ?? ?? ?? 84 C0 74 52 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 3F 47 33 ED 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 83 78 44 00 74 24 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 8B 40 44 8B D3 80 C2 FD 80 EA 02 0F 92 C2 80 F2 01 E8 ?? ?? ?? ?? 45 4F 75 C4 8B 46 0C 85 C0 74 10 8B 10 FF 52 58 8B 46 0C 8B 10 FF 92 80 00 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_801_0 {
	meta:
		name = "TActionClient.SetChangesAllowed"
		size = 26
	strings:
		$1 = { 53 51 88 14 24 8B D8 0F B6 04 24 3A 43 31 74 07 0F B6 04 24 88 43 31 5A 5B C3 }
	condition:
		$1
}

rule function_802_0 {
	meta:
		name = "TActionClient.SetColor"
		size = 20
	strings:
		$1 = { 56 8B F0 3B 56 24 74 0A 89 56 24 8B C6 8B 10 FF 52 20 5E C3 }
	condition:
		$1
}

rule function_803_0 {
	meta:
		name = "TActionClient.SetContextItems"
		size = 4
		altNames = "TDBXContext.SetTraceLevel TDBXDelegateTable.SetTable TDBXDriverHelp.SetMetaDataReader TSeriesPointer.ChangeHorizSize TStreamLoader.SetTimeout"
	strings:
		$1 = { 89 50 1C C3 }
	condition:
		$1
}

rule function_804_0 {
	meta:
		name = "TActionClient.SetVisible"
		size = 16
		refs = "000b NotifyDesigner"
	strings:
		$1 = { 3A 50 30 74 0A 88 50 30 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_805_0 {
	meta:
		name = "TActionBarItem.ColorChanged"
		size = 38
		refs = "0017 TControl.SetParentColor 0021 TControl.SetColor"
	strings:
		$1 = { 8B 50 0C 85 D2 74 1E 8B 48 24 81 F9 00 00 00 20 75 0B 8B C2 B2 01 E8 ?? ?? ?? ?? EB 08 8B C1 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_806_0 {
	meta:
		name = "TActionBarItem.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TActionClient.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 3C 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_808_0 {
	meta:
		name = "TActionBarItem.GetDisplayName"
		size = 84
		refs = "0014 TActionBarItem.GetDisplayName 0019 @UStrCat3 0024 TCollectionItem.GetDisplayName"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 7B 0C 85 FF 74 11 8B 4F 08 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 0C 00 00 00 41 00 63 00 74 00 69 00 6F 00 6E 00 42 00 61 00 72 00 20 00 2D 00 3E 00 00 00 00 00 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "TActionBarItem.Refresh"
		size = 23
	strings:
		$1 = { 56 8B 70 0C 85 F6 74 0D F6 46 1C 01 75 07 8B C6 8B 10 FF 52 58 5E C3 }
	condition:
		$1
}

rule function_810_0 {
	meta:
		name = "TActionBarItem.SetAutoSize"
		size = 28
	strings:
		$1 = { 56 8B F0 3A 56 3C 74 12 88 56 3C 8B 46 0C 85 C0 74 08 8B 10 FF 92 E0 00 00 00 5E C3 }
	condition:
		$1
}

rule function_811_0 {
	meta:
		name = "TActionBarItem.SetGlyphLayout"
		size = 268
		refs = "002d TWinControl.DisableAlign 0035 TActionBarItem.SetGlyphLayout 0043 TActionClient.GetItems 0048 TCollection.GetCount 0061 TActionClients.GetActionClient 009f TWinControl.EnableAlign 00ae @CallDynaInst 00b4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 8B 45 FC 3A 58 3D 0F 84 EE 00 00 00 8B 45 FC 88 58 3D 8B 45 FC 8B 40 0C 85 C0 0F 84 8E 00 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 38 46 33 FF 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 83 78 44 00 74 1C 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B 40 44 8B D3 8B 08 FF 91 E0 00 00 00 47 4E 75 CB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 0C 66 BE D0 FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 38 46 33 FF 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 83 78 44 00 74 1C 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B 40 44 8B D3 8B 08 FF 91 E0 00 00 00 47 4E 75 CB 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_812_0 {
	meta:
		name = "TActionBarItem.SetVisible"
		size = 28
		refs = "0006 TActionClient.SetVisible 0016 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 0C 85 C0 74 09 0F B6 53 30 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_813_0 {
	meta:
		name = "TActionBars.Create"
		size = 86
		refs = "000d @ClassCreate 001e TActionClientsCollection.Create 002c TActionBars.SetShowHints 0035 TActionBars.SetHintShortCuts 0040 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 89 46 28 B2 01 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_815_0 {
	meta:
		name = "TActionBars.DoShowHint"
		size = 44
		refs = "000a _DV_TActionBarItem 000f @IsClass 0025 TControl.SetShowHint"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 12 83 7B 0C 00 74 0C 8B 43 0C 0F B6 56 2C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_817_0 {
	meta:
		name = "TActionBars.GetHintShortCuts"
		size = 25
		refs = "0004 Application"
	strings:
		$1 = { 33 C0 8B 15 ?? ?? ?? ?? 83 3A 00 74 0B A1 ?? ?? ?? ?? 8B 00 0F B6 40 78 C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "TActionBars.Loaded"
		size = 106
		refs = "000b TCollection.GetCount 001f TActionBars.GetActionBar 0028 _Dn_TCustomActionDockBar 002d @IsClass"
	strings:
		$1 = { 53 56 57 51 89 04 24 8B 04 24 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 4F 47 33 F6 8B D6 8B 04 24 E8 ?? ?? ?? ?? 8B 40 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2C 8B D6 8B 04 24 E8 ?? ?? ?? ?? 8B 58 0C 8B C3 8B 10 FF 92 78 01 00 00 50 8B 43 4C 50 8B 4B 44 8B 53 40 8B C3 8B 18 FF 93 88 00 00 00 46 4F 75 B4 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "TActionBars.Notify"
		size = 55
		refs = "000b TCollection.Notify 0018 _DV_TActionBarItem 001d @IsClass"
	strings:
		$1 = { 53 56 8B D9 8B F2 8B CB 8B D6 E8 ?? ?? ?? ?? 80 FB 02 75 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B 46 0C 85 C0 74 08 33 D2 89 90 68 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "TActionBars.SetShowHints"
		size = 22
		refs = "000a TActionBars.DoShowHint 0011 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 3A 50 2C 74 10 88 50 2C 50 68 ?? ?? ?? ?? 8B D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_821_0 {
	meta:
		name = "TActionBars.SetHintShortCuts"
		size = 21
		refs = "0001 Application"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 38 00 74 0A A1 ?? ?? ?? ?? 8B 00 88 50 78 C3 }
	condition:
		$1
}

rule function_822_0 {
	meta:
		name = "TActionClients.Create"
		size = 79
		refs = "000d @ClassCreate 001e TActionClientsCollection.Create 0039 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 28 01 C6 46 29 01 C6 46 2A 01 C6 46 1C 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "TActionClients.Assign"
		size = 90
		refs = "000c TCollection.Assign 0014 _DV_TActionClients 0019 @IsClass 002a TActionClientsCollection.SetAutoHotKeys 003c TActionClients.SetHideUnused 0047 TActionClients.SetCaptionOptions 0052 TActionClients.SetSmallIcons"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B FE 0F B6 57 1C 8B C3 E8 ?? ?? ?? ?? 0F B6 47 24 88 43 24 0F B6 57 2A 8B C3 E8 ?? ?? ?? ?? 0F B6 57 28 8B C3 E8 ?? ?? ?? ?? 0F B6 57 29 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "TActionClients.DoHideUnused"
		size = 56
		refs = "000b _DV_TActionClientItem 0010 @IsClass 0027 TActionClient.GetItems 0030 TActionClients.SetHideUnused"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B F3 C6 46 40 01 83 7E 2C 00 74 10 8B C6 E8 ?? ?? ?? ?? 0F B6 57 2A E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "TActionClients.DoShowCaptions"
		size = 37
		refs = "0007 _DV_TActionClientItem 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B 43 44 85 C0 74 08 8B 10 FF 92 E8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "TActionClients.Notify"
		size = 364
		refs = "0010 TCollection.Notify 0030 _DV_TActionClient 0035 @AsClass 004b TActionClient.GetOwningCollection 0052 TActionClientsCollection.InternalRethinkHotkeys 0084 TWinControl.HandleAllocated 00a5 _DV_TActionClientItem 00aa @IsClass 00bb TActionClientItem.GetParentItem 00fc TWinControl.GetHandle 0102 PostMessage 010b TActionClient.FreeChildren"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 EB 01 72 13 0F 84 82 00 00 00 FE CB 0F 84 E1 00 00 00 E9 3C 01 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5E 20 85 DB 0F 84 24 01 00 00 85 DB 74 0E 8B C3 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 33 DB 8B 56 20 8B 42 0C 85 C0 74 04 8B D8 EB 09 8B 42 18 85 C0 74 02 8B D8 83 7E 0C 00 0F 85 EF 00 00 00 85 DB 0F 84 E7 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 D8 00 00 00 8B D7 8B C3 8B 08 FF 91 4C 01 00 00 E9 C7 00 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 B2 00 00 00 8B DF 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 A1 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 78 18 00 0F 84 90 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 84 C0 74 7D 6A 00 6A 00 6A 05 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 60 8B C7 E8 ?? ?? ?? ?? 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 48 8B DF 8B C3 E8 ?? ?? ?? ?? 85 C0 74 3B 8B C3 E8 ?? ?? ?? ?? 83 78 18 00 74 2E 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 84 C0 74 1B 6A 00 6A 00 6A 05 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "TActionClients.SetCaptionOptions"
		size = 137
		refs = "0029 TWinControl.DisableAlign 0031 TActionClients.SetCaptionOptions 0040 TActionClients.DoShowCaptions 004b TActionClientsCollection.IterateClients 0066 TWinControl.EnableAlign 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 3A 50 28 74 77 8B 45 FC 88 50 28 8B 45 FC 8B 40 20 85 C0 74 53 83 78 0C 00 74 4D 8B 40 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 50 68 ?? ?? ?? ?? 8B 55 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 20 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 FC 50 68 ?? ?? ?? ?? 8B 55 FC 8B 45 FC E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "TActionClients.SetHideUnused"
		size = 41
		refs = "000e TActionClientsCollection.GetActionManager 001a TActionClients.DoHideUnused 0023 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 53 8B D8 3A 53 2A 74 1F 88 53 2A 8B C3 E8 ?? ?? ?? ?? F6 40 1C 01 75 0F 53 68 ?? ?? ?? ?? 8B D3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "TActionClients.SetSmallIcons"
		size = 141
		refs = "002c TWinControl.DisableAlign 0034 TActionClients.SetSmallIcons 0047 TActionClients.ToggleSmallIcons 0070 TWinControl.EnableAlign 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 3A 58 29 74 77 8B 45 FC 88 58 29 8B 45 FC 8B 40 20 85 C0 74 5A 83 78 0C 00 74 54 8B 40 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B 55 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 20 8B 40 0C 8B 10 FF 52 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 20 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B CB 8B 55 FC 8B 45 FC E8 ?? ?? ?? ?? 5B 59 5D C3 }
	condition:
		$1
}

rule function_833_0 {
	meta:
		name = "TActionClients.ToggleSmallIcons"
		size = 142
		refs = "0013 TCollection.GetCount 0026 TActionClients.GetActionClient 003f TCustomActionControl.SetSmallIcon 004d TActionClient.GetHasItems 005f TActionClient.GetItems 0066 TActionClients.SetSmallIcons 0080 TActionClients.ToggleSmallIcons"
	strings:
		$1 = { 53 56 57 55 51 8B D9 8B F2 89 04 24 85 F6 74 78 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 6A 47 33 ED 8B D5 8B C6 E8 ?? ?? ?? ?? 83 78 44 00 74 13 8B D5 8B C6 E8 ?? ?? ?? ?? 8B 40 44 8B D3 E8 ?? ?? ?? ?? 8B D5 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2F 8B D5 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B D5 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B CB 8B 04 24 E8 ?? ?? ?? ?? 45 4F 75 99 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_834_0 {
	meta:
		name = "TActionClients.VisibleCount"
		size = 52
		refs = "000b TCollection.GetCount 001e TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B F8 33 ED 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 17 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 80 78 30 00 74 01 45 46 4B 75 EC 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_835_0 {
	meta:
		name = "TActionClientLink.AssignClient"
		size = 25
		refs = "000a _DV_TActionClientItem 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_3424_0 {
	meta:
		name = "TButtonItemActionLink.AssignClient"
		size = 25
		refs = "000a _DV_TBaseButtonItem 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_7411_0 {
	meta:
		name = "TControlActionLink.AssignClient"
		size = 25
		refs = "000a _DV_TControl 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_41794_0 {
	meta:
		name = "TMenuActionLink.AssignClient"
		size = 25
		refs = "000a _DV_TMenuItem 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_836_0 {
	meta:
		name = "TActionClientLink.DoShowHint"
		size = 252
		refs = "0019 TActionClientLink.DoShowHint 002c _Dn_TCustomAction 0031 @IsClass 0043 @CallDynaInst 004c Application 0085 ShortCutToText 00a1 Format 00ab @UStrAsg 00c0 @UStrClr 00ce @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 C9 89 4D F8 89 4D E4 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 01 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 76 8B D7 8B 43 10 66 BE EE FF E8 ?? ?? ?? ?? 84 C0 74 64 A1 ?? ?? ?? ?? 8B 00 80 78 78 00 74 57 8B 43 10 66 83 B8 84 00 00 00 00 74 4A 83 3F 00 74 45 8D 45 F8 50 8B 07 89 45 E8 C6 45 EC 11 8D 55 E4 8B 43 10 0F B7 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F0 C6 45 F4 11 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 0F B6 45 FF 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 07 00 00 00 25 00 73 00 20 00 28 00 25 00 73 00 29 00 00 00 }
	condition:
		$1
}

rule function_7412_0 {
	meta:
		name = "TControlActionLink.DoShowHint"
		size = 252
		refs = "0019 TControlActionLink.DoShowHint 002c _Dn_TCustomAction 0031 @IsClass 0043 @CallDynaInst 004c Application 0085 ShortCutToText 00a1 Format 00ab @UStrAsg 00c0 @UStrClr 00ce @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 C9 89 4D F8 89 4D E4 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 01 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 76 8B D7 8B 43 10 66 BE EE FF E8 ?? ?? ?? ?? 84 C0 74 64 A1 ?? ?? ?? ?? 8B 00 80 78 78 00 74 57 8B 43 10 66 83 B8 84 00 00 00 00 74 4A 83 3F 00 74 45 8D 45 F8 50 8B 07 89 45 E8 C6 45 EC 11 8D 55 E4 8B 43 10 0F B7 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F0 C6 45 F4 11 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 0F B6 45 FF 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 07 00 00 00 25 00 73 00 20 00 28 00 25 00 73 00 29 00 00 00 }
	condition:
		$1
}

rule function_837_0 {
	meta:
		name = "TActionClientLink.IsCaptionLinked"
		size = 194
		refs = "0011 TActionClientLink.IsCaptionLinked 001e TActionLink.IsCaptionLinked 002d TActionClientItem.GetCaption 003a _Dn_TCustomAction 003f @AsClass 0048 @UStrEqual 0076 StripHotkey 00ae @UStrArrayClr 00b4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 84 C0 74 28 8D 55 FC 8B 46 18 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 46 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 64 58 E8 ?? ?? ?? ?? 74 04 33 DB EB 02 B3 01 84 DB 75 40 8B 46 18 8B 40 04 80 78 1C 00 74 34 8D 55 F4 8B 46 18 E8 ?? ?? ?? ?? 8B 45 F4 8D 55 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 46 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 64 58 E8 ?? ?? ?? ?? 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "TActionClientLink.IsEnabledLinked"
		size = 63
		refs = "0006 TActionLink.IsEnabledLinked 0028 _Dn_TCustomAction 002d @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 29 8B 43 18 83 78 44 00 74 20 8B 43 18 8B 40 44 8B 10 FF 52 4C 50 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 3A 50 6A 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_839_0 {
	meta:
		name = "TActionClientLink.IsHelpContextLinked"
		size = 47
		refs = "0006 TActionLink.IsHelpContextLinked 0013 _Dn_TCustomAction 0018 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 19 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 74 8B 53 18 3B 42 68 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_840_0 {
	meta:
		name = "TActionClientLink.IsHintLinked"
		size = 67
		refs = "0006 TActionLink.IsHintLinked 001c _Dn_TCustomAction 0021 @AsClass 0035 @UStrEqual"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 2D 8B 43 18 83 78 44 00 74 24 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 7C 8B 43 18 8B 40 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_841_0 {
	meta:
		name = "TActionClientLink.IsImageIndexLinked"
		size = 67
		refs = "0006 TActionLink.IsImageIndexLinked 001c _Dn_TCustomAction 0021 @AsClass 0035 @UStrEqual"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 2D 8B 43 18 83 78 44 00 74 24 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 7C 8B 43 18 8B 40 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_842_0 {
	meta:
		name = "TActionClientLink.IsOnExecuteLinked"
		size = 51
		refs = "0006 TBasicActionLink.IsOnExecuteLinked"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 8B 43 18 83 78 44 00 74 14 8B 43 18 8B 40 44 8B 80 10 01 00 00 8B 53 10 3B 42 40 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_843_0 {
	meta:
		name = "TActionClientLink.IsShortCutLinked"
		size = 52
		refs = "0006 TActionLink.IsShortCutLinked 0013 _Dn_TCustomAction 0018 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1E 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8B 53 18 66 3B 42 4C 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_844_0 {
	meta:
		name = "TActionClientLink.IsVisibleLinked"
		size = 51
		refs = "0006 TActionLink.IsVisibleLinked 0013 _Dn_TCustomAction 0018 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 80 86 00 00 00 8B 53 18 3A 42 30 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_845_0 {
	meta:
		name = "TActionClientLink.SetCaption"
		size = 30
		refs = "0017 TActionClientItem.SetCaption"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3430_0 {
	meta:
		name = "TButtonItemActionLink.SetCaption"
		size = 30
		refs = "0017 TBaseItem.SetCaption"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7421_0 {
	meta:
		name = "TControlActionLink.SetCaption"
		size = 30
		refs = "0017 TControl.SetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41807_0 {
	meta:
		name = "TMenuActionLink.SetCaption"
		size = 30
		refs = "0017 TMenuItem.SetCaption"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_846_0 {
	meta:
		name = "TActionClientLink.SetChecked"
		size = 46
		refs = "0006 TActionLink.SetChecked"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 24 84 C0 74 17 8B 43 18 83 78 44 00 74 0E 8B 43 18 8B 40 44 8B 10 FF 92 80 00 00 00 5B C3 }
	condition:
		$1
}

rule function_847_0 {
	meta:
		name = "TActionClientLink.SetEnabled"
		size = 36
	strings:
		$1 = { 56 51 88 14 24 8B F0 8B C6 8B 10 FF 52 28 84 C0 74 0F 8B 46 18 8B 40 44 0F B6 14 24 8B 08 FF 51 64 5A 5E C3 }
	condition:
		$1
}

rule function_848_0 {
	meta:
		name = "TActionClientLink.SetHelpContext"
		size = 26
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 30 84 C0 74 06 8B 43 18 89 70 68 5E 5B C3 }
	condition:
		$1
}

rule function_849_0 {
	meta:
		name = "TActionClientLink.SetHint"
		size = 38
		refs = "001f @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 38 84 C0 74 12 8B 43 18 8B 40 44 05 80 00 00 00 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_850_0 {
	meta:
		name = "TActionClientLink.SetImageIndex"
		size = 30
		refs = "0017 TActionClientItem.SetImageIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3432_0 {
	meta:
		name = "TButtonItemActionLink.SetImageIndex"
		size = 30
		refs = "0017 TBaseButtonItem.SetImageIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41812_0 {
	meta:
		name = "TMenuActionLink.SetImageIndex"
		size = 30
		refs = "0017 TMenuItem.SetImageIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_851_0 {
	meta:
		name = "TActionClientLink.SetOnExecute"
		size = 46
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 8B 10 FF 52 08 84 C0 74 18 8B 43 18 8B 40 44 8B 55 08 89 90 10 01 00 00 8B 55 0C 89 90 14 01 00 00 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_852_0 {
	meta:
		name = "TActionClientLink.SetShortCut"
		size = 30
		refs = "0017 TActionClientItem.SetShortCut"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 40 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41813_0 {
	meta:
		name = "TMenuActionLink.SetShortCut"
		size = 30
		refs = "0017 TMenuItem.SetShortCut"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 40 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_853_0 {
	meta:
		name = "TActionClientLink.SetVisible"
		size = 30
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 52 44 84 C0 74 0A 8B D3 8B 46 18 8B 08 FF 51 2C 5E 5B C3 }
	condition:
		$1
}

rule function_855_0 {
	meta:
		name = "TCaptionAttributes.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
		altNames = "TChartTheme.Create TCommandProperties.Create TConnectionData.Create TDBXByteReader.Create TDBXChannelInfo.Create TDBXInt32Object.Create TDBXJSonServerProtocolHandler.Create TDBXPropertiesItem.Create TDSAdapterClass.Create TDSDisconnectHandler.Create TDefaultWebModuleFactory.Create TGIFItem.Create THTMLTagAttributes.Create THandleStream.Create TIdSSLCipher.Create TIdSSLSocket.Create TIdSync.Create TIdTCPStream.Create TIdX509Info.Create TIdX509Name.Create TItemProp.Create TLayoutWebContent.Create TListItems.Create TLocalWebModuleContext.Create TParaAttributes.Create TSizeConstraints.Create TTreeNodes.Create TWebDisplay.Create TXMLData.Create TdomCMNodeList.create TdomNodeList.create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 04 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_856_0 {
	meta:
		name = "TCommandProperties.DoChanged"
		size = 24
	strings:
		$1 = { 53 66 83 78 0A 00 74 0E 8B D8 0F B6 48 10 8B D0 8B 43 0C FF 53 08 5B C3 }
	condition:
		$1
}

rule function_857_0 {
	meta:
		name = "TCommandProperties.GetControl"
		size = 7
	strings:
		$1 = { 8B 40 04 8B 40 44 C3 }
	condition:
		$1
}

rule function_858_0 {
	meta:
		name = "TCommandProperties.InvalidateControl"
		size = 54
		refs = "0009 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 85 C0 74 22 84 DB 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 E8 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_859_0 {
	meta:
		name = "TButtonProperties.Assign"
		size = 79
		refs = "000b TCommandProperties.Assign 0013 _DV_TButtonProperties 0018 @IsClass 0027 TButtonProperties.SetButtonSize 0032 TButtonProperties.SetButtonType 003d TButtonProperties.SetGroupPosition 0048 TButtonProperties.SetTextAssociation"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2C 0F B6 56 18 8B C3 E8 ?? ?? ?? ?? 0F B6 56 19 8B C3 E8 ?? ?? ?? ?? 0F B6 56 1A 8B C3 E8 ?? ?? ?? ?? 0F B6 56 1B 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_860_0 {
	meta:
		name = "TButtonProperties.Create"
		size = 69
		refs = "000a @ClassCreate 0017 TCommandProperties.Create 0032 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 19 00 C6 46 18 00 C6 46 1A 00 C6 46 1B 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_861_0 {
	meta:
		name = "TButtonProperties.SetButtonSize"
		size = 44
		refs = "000e TCommandProperties.GetControl 001e TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 3A 56 18 74 22 88 56 18 8B C6 E8 ?? ?? ?? ?? 85 C0 74 14 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 58 01 00 00 5E C3 }
	condition:
		$1
}

rule function_862_0 {
	meta:
		name = "TButtonProperties.SetButtonType"
		size = 44
		refs = "000e TCommandProperties.GetControl 001e TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 3A 56 19 74 22 88 56 19 8B C6 E8 ?? ?? ?? ?? 85 C0 74 14 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 58 01 00 00 5E C3 }
	condition:
		$1
}

rule function_863_0 {
	meta:
		name = "TButtonProperties.SetGroupPosition"
		size = 43
		refs = "0011 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 3A 53 1A 74 1F 88 53 1A 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_864_0 {
	meta:
		name = "TButtonProperties.SetTextAssociation"
		size = 44
		refs = "000e TCommandProperties.GetControl 001e TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 3A 56 1B 74 22 88 56 1B 8B C6 E8 ?? ?? ?? ?? 85 C0 74 14 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 58 01 00 00 5E C3 }
	condition:
		$1
}

rule function_865_0 {
	meta:
		name = "TGalleryProperties.Assign"
		size = 78
		refs = "000b TButtonProperties.Assign 0013 _DV_TGalleryProperties 0018 @IsClass 0023 TGalleryProperties.GetGalleryType 002c TGalleryProperties.SetGalleryType 0033 TGalleryProperties.GetItemsPerRow 003c TGalleryProperties.SetItemsPerRow 0047 TGalleryProperties.SetShowRichContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2B 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 0F B6 56 28 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_866_0 {
	meta:
		name = "TGalleryProperties.Create"
		size = 64
		refs = "000a @ClassCreate 0017 TButtonProperties.Create 002d @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 24 04 00 00 00 C6 46 20 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_867_0 {
	meta:
		name = "TDBXJSonStreamReader.GetBooleanValue"
		size = 5
		altNames = "TGalleryProperties.GetGalleryType"
	strings:
		$1 = { 0F B6 40 20 C3 }
	condition:
		$1
}

rule function_868_0 {
	meta:
		name = "TDBXParamsTable.GetStorage"
		size = 4
		altNames = "TDBXReaderTableStorage.GetStorage TGalleryProperties.GetItemsPerRow TIWBaseHTMLControlImplementation.getFont TStringList.GetCapacity TTestResult.RunCount TWideStringList.GetCapacity TXMLNode.GetHostNode"
	strings:
		$1 = { 8B 40 24 C3 }
	condition:
		$1
}

rule function_869_0 {
	meta:
		name = "TGalleryProperties.SetGalleryType"
		size = 9
	strings:
		$1 = { 3A 50 20 74 03 88 50 20 C3 }
	condition:
		$1
}

rule function_870_0 {
	meta:
		name = "TGalleryProperties.SetItemsPerRow"
		size = 22
		refs = "000e TCommandProperties.GetControl"
	strings:
		$1 = { 53 8B D8 3B 53 24 74 0C 89 53 24 8B C3 E8 ?? ?? ?? ?? 85 C0 5B C3 }
	condition:
		$1
}

rule function_871_0 {
	meta:
		name = "TGalleryProperties.SetShowRichContent"
		size = 14
	strings:
		$1 = { 3A 50 28 74 08 88 50 28 8B 10 FF 52 0C C3 }
	condition:
		$1
}

rule function_872_0 {
	meta:
		name = "TMenuProperties.Assign"
		size = 76
		refs = "000b TControlProperties.Assign 0013 _DV_TMenuProperties 0018 @IsClass 0026 TMenuProperties.SetContent 0030 TMenuProperties.SetFont 003a TMenuProperties.SetHeight 0045 TMenuProperties.SetShowRichContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 29 8B 56 30 8B C3 E8 ?? ?? ?? ?? 8B 56 34 8B C3 E8 ?? ?? ?? ?? 8B 56 3C 8B C3 E8 ?? ?? ?? ?? 0F B6 56 38 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_873_0 {
	meta:
		name = "TMenuProperties.Create"
		size = 83
		refs = "000a @ClassCreate 0017 TControlProperties.Create 001e _Dn_TFont 0023 TFont.Create 002d _Dn_TStringList 0032 TStringList.Create 0040 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 34 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 30 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_874_0 {
	meta:
		name = "TMenuProperties.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TPersistent.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 34 E8 ?? ?? ?? ?? 8B 46 30 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_875_0 {
	meta:
		name = "TCustomWebUserList.SetItems"
		size = 13
		altNames = "TIBDataSetUpdateObject.SetRefreshSQL TIBEvents.SetEvents TIdVCard.SetComments TMenuProperties.SetContent TSimpleObjectBroker.SetServers"
	strings:
		$1 = { 56 8B F0 8B 46 30 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_876_0 {
	meta:
		name = "TIdMessage.SetBccList"
		size = 13
		altNames = "TIdVCard.SetCategories TMenuProperties.SetFont"
	strings:
		$1 = { 56 8B F0 8B 46 34 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_877_0 {
	meta:
		name = "TMenuProperties.SetHeight"
		size = 79
		refs = "0010 TCommandProperties.GetControl 002f TCustomActionControl.GetActionBar 0048 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C2 89 43 3C 3B D0 74 3F 8B C3 E8 ?? ?? ?? ?? 85 C0 74 34 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 E8 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 15 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_878_0 {
	meta:
		name = "TMenuProperties.SetShowRichContent"
		size = 18
	strings:
		$1 = { 3A 50 38 74 0C 88 50 38 C6 40 10 02 8B 10 FF 52 0C C3 }
	condition:
		$1
}

rule function_879_0 {
	meta:
		name = "TTextProperties.Assign"
		size = 66
		refs = "000b TCheckBoxProperties.Assign 0013 _DV_TTextProperties 0018 @IsClass 0034 TTextProperties.SetFont"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1F 0F B6 46 20 88 43 20 0F B6 46 21 88 43 21 8B 56 24 8B C3 E8 ?? ?? ?? ?? 0F B6 46 28 88 43 28 5E 5B C3 }
	condition:
		$1
}

rule function_880_0 {
	meta:
		name = "TTextProperties.Create"
		size = 97
		refs = "000e @ClassCreate 001c TCheckBoxProperties.Create 0027 _Dn_TFont 002c TFont.Create 003b TTextProperties.FontChangeHandler 004c @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 43 20 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 24 89 5E 0C C7 46 08 ?? ?? ?? ?? C6 43 28 01 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_881_0 {
	meta:
		name = "TTextProperties.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TPersistent.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8699_0 {
	meta:
		name = "EUpdateError.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b Exception.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12199_0 {
	meta:
		name = "THTMLTableColumn.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TCollectionItem.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9405_0 {
	meta:
		name = "TMasterDataLink.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TDataLink.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5647_0 {
	meta:
		name = "TRichEditStrings.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TStrings.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_22120_0 {
	meta:
		name = "TWebActionItem.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TCollectionItem.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_882_0 {
	meta:
		name = "TTextProperties.FontChangeHandler"
		size = 39
		refs = "000d TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 C6 43 28 00 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_883_0 {
	meta:
		name = "TTextProperties.SetAlignment"
		size = 43
		refs = "0011 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 3A 53 20 74 1F 88 53 20 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_884_0 {
	meta:
		name = "TTextProperties.SetEllipsisPosition"
		size = 43
		refs = "0011 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 3A 53 21 74 1F 88 53 21 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_885_0 {
	meta:
		name = "TButtonCategory.SetItems"
		size = 13
		altNames = "TScreenTipItem.SetDisabledDescription TTextProperties.SetFont"
	strings:
		$1 = { 56 8B F0 8B 46 24 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_886_0 {
	meta:
		name = "TTextProperties.SetParentFont"
		size = 49
		refs = "0021 TCustomActionControl.GetActionBar 002b TTextProperties.SetFont"
	strings:
		$1 = { 53 8B D8 3A 53 28 74 27 88 53 28 80 7B 28 00 74 1E 8B 43 04 83 78 44 00 74 15 8B 43 04 8B 40 44 E8 ?? ?? ?? ?? 8B 50 64 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_887_0 {
	meta:
		name = "TControlProperties.Assign"
		size = 59
		refs = "000b TCheckBoxProperties.Assign 0013 _DV_TControlProperties 0018 @IsClass 0034 TControlProperties.SetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 18 8B C6 8B 50 20 89 53 20 8B 50 28 89 53 28 8B 50 24 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_888_0 {
	meta:
		name = "TControlProperties.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCheckBoxProperties.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 28 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_890_0 {
	meta:
		name = "TControlProperties.DoSetWidth"
		size = 77
		refs = "0007 TCheckBoxProperties.DoSetWidth 000e TCommandProperties.GetControl 002d TCustomActionControl.GetActionBar 0046 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 34 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 E8 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 15 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_891_0 {
	meta:
		name = "TControlProperties.SetContainedControl"
		size = 4
		altNames = "TDBXReaderValue.SetHandle TDockZone.SetZoneLimit"
	strings:
		$1 = { 89 50 20 C3 }
	condition:
		$1
}

rule function_892_0 {
	meta:
		name = "TControlProperties.SetLabelWidth"
		size = 14
	strings:
		$1 = { 3B 50 28 74 08 89 50 28 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_893_0 {
	meta:
		name = "TControlProperties.SetText"
		size = 40
		refs = "000c @UStrEqual 0018 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 24 8B D6 E8 ?? ?? ?? ?? 74 13 8D 43 24 8B D6 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 51 18 5E 5B C3 }
	condition:
		$1
}

rule function_894_0 {
	meta:
		name = "TComboBoxProperties.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TControlProperties.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 30 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_56686_0 {
	meta:
		name = "TTeeSeriesSource.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TComponent.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 30 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_895_0 {
	meta:
		name = "TActionClientItem.Create"
		size = 137
		refs = "000a @ClassCreate 001e TActionClient.Create 0052 @UStrAsg 0063 _DV_TButtonProperties 0068 TButtonProperties.Create 0076 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 C7 46 24 00 00 00 20 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 5C FF FF FF FF 33 C0 89 46 50 C6 46 55 01 C6 46 65 01 C6 46 56 01 C6 46 40 01 33 C0 89 46 48 33 C0 89 46 60 C6 46 6C 00 8D 46 70 33 D2 E8 ?? ?? ?? ?? C6 46 74 00 C6 46 75 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 78 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_896_0 {
	meta:
		name = "TActionClientItem.Destroy"
		size = 85
		refs = "0003 @BeforeDestruction 0017 TObject.Free 0043 TActionClient.Destroy 004e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 46 3C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 46 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 46 78 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_897_0 {
	meta:
		name = "TActionClientItem.ActionChange"
		size = 306
		refs = "0012 TActionClientItem.ActionChange 0020 _Dn_TCustomAction 0025 @IsClass 006f @UStrAsg 00a3 TActionClientItem.GetCaption 00b3 TActionClientItem.SetCaption 00ca TActionClientItem.SetImageIndex 00e3 TActionClientItem.SetShortCut 0120 @UStrClr 0126 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 DE 00 00 00 83 7E 44 00 74 62 84 DB 74 0C 8B 46 44 8B 10 FF 52 4C 3C 01 75 0C 0F B6 57 6A 8B 46 44 8B 08 FF 51 64 84 DB 74 0C 8B 46 44 83 B8 80 00 00 00 00 75 10 8B 46 44 05 80 00 00 00 8B 57 7C E8 ?? ?? ?? ?? 84 DB 74 0D 8B 46 44 66 83 B8 12 01 00 00 00 75 15 8B 46 44 8B 57 40 89 90 10 01 00 00 8B 57 44 89 90 14 01 00 00 84 DB 74 10 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 83 7D FC 00 75 0A 8B 57 64 8B C6 E8 ?? ?? ?? ?? 84 DB 74 06 83 7E 5C 00 75 0D 8B 97 80 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 66 83 7E 4C 00 75 0E 0F B7 97 84 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 DB 74 06 80 7E 30 01 75 0E 0F B6 97 86 00 00 00 8B C6 8B 08 FF 51 2C 84 DB 74 06 83 7E 68 00 75 06 8B 47 74 89 46 68 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_898_0 {
	meta:
		name = "TActionClientItem.Assign"
		size = 416
		refs = "0016 TActionClientItem.Assign 0026 TActionClient.Assign 002e _DV_TActionClientItem 0033 @IsClass 0063 TActionClientItem.GetAction 006d TActionClientItem.SetAction 0077 TActionClientItem.GetCaption 0082 TActionClientItem.SetCaption 0096 TActionClientItem.SetImageIndex 00a1 TActionClientItem.SetMergeIndex 00ac TActionClientItem.SetLastSession 00b8 TActionClientItem.SetShowCaption 00c4 TActionClientItem.SetShowGlyph 00d0 TActionClientItem.SetShowShortCut 00dc TActionClientItem.SetShortCut 00e7 TActionClientItem.SetUsageCount 00f3 TActionClientItem.SetDefault 0101 @UStrAsg 010d TActionClientItem.SetNewCol 0119 TActionClientItem.SetNewRow 0125 TActionClientItem.SetCommandStyle 0130 TActionClientItem.SetCommandProperties 0146 TActionClient.GetItems 0177 @HandleFinally 018e @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 3E 01 00 00 8B 45 FC 8B 70 04 85 F6 74 07 8B C6 8B 10 FF 52 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B F3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 46 68 8B 55 FC 89 42 68 8B 56 5C 8B 45 FC E8 ?? ?? ?? ?? 8B 56 50 8B 45 FC E8 ?? ?? ?? ?? 8B 56 60 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 55 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 65 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 56 8B 45 FC E8 ?? ?? ?? ?? 0F B7 56 4C 8B 45 FC E8 ?? ?? ?? ?? 8B 56 48 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 6C 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 70 8B 56 70 E8 ?? ?? ?? ?? 0F B6 56 75 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 74 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 76 8B 45 FC E8 ?? ?? ?? ?? 8B 56 78 8B 45 FC E8 ?? ?? ?? ?? 8B 46 7C 8B 55 FC 89 42 7C 83 7E 2C 00 74 16 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_899_0 {
	meta:
		name = "TActionClientItem.ColorChanged"
		size = 56
		refs = "001d TControl.SetParentColor 0028 TCustomActionControl.SetTransparent 0032 TControl.SetColor"
	strings:
		$1 = { 53 8B 50 44 85 D2 74 2E 8B 48 24 8B D9 81 EB FF FF FF 1F 74 0E 4B 75 16 8B C2 B2 01 E8 ?? ?? ?? ?? EB 13 8B C2 B2 01 E8 ?? ?? ?? ?? EB 08 8B C1 92 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_900_0 {
	meta:
		name = "TActionClientItem.DoActionChange"
		size = 35
		refs = "0009 TActionClientItem.GetAction 001c @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 3B F0 75 0F B1 01 8B D6 8B C3 66 BE FD FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_903_0 {
	meta:
		name = "TActionClientItem.GetAction"
		size = 15
	strings:
		$1 = { 33 D2 8B 48 3C 85 C9 74 03 8B 51 10 8B C2 C3 }
	condition:
		$1
}

rule function_904_0 {
	meta:
		name = "TActionClientItem.GetCaption"
		size = 168
		refs = "000b ActionBarDesigner 002e TActionClientItem.GetAction 0045 TCollectionItem.GetIndex 0059 TActionClientItem.GetCaption 005e Format 006a @UStrAsg"
	strings:
		$1 = { 53 56 83 C4 F8 8B F2 8B D8 83 3D ?? ?? ?? ?? 00 74 13 8B 43 20 85 C0 74 05 83 E8 04 8B 00 85 C0 0F 94 C0 EB 02 33 C0 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 34 01 EB 02 33 C0 84 C0 74 23 56 8B C3 E8 ?? ?? ?? ?? 89 44 24 04 C6 44 24 08 00 8D 54 24 04 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A 8B C6 8B 53 20 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 00 B0 04 02 00 FF FF FF FF 12 00 00 00 41 00 63 00 74 00 69 00 6F 00 6E 00 43 00 6C 00 69 00 65 00 6E 00 74 00 49 00 74 00 65 00 6D 00 25 00 64 00 00 00 00 00 }
	condition:
		$1
}

rule function_905_0 {
	meta:
		name = "TActionClientItem.GetDisplayName"
		size = 175
		refs = "0015 TActionClientItem.GetDisplayName 0024 TCollectionItem.GetDisplayName 002e TActionClientItem.GetCaption 0056 TActionClientItem.GetAction 005c _Dn_TCustomAction 0061 @IsClass 0088 @UStrAsg 009d @UStrClr 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 89 45 F8 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 0B 8B D6 8B C3 E8 ?? ?? ?? ?? EB 39 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 23 8B C3 E8 ?? ?? ?? ?? 8B D8 8B 43 64 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 0A 8B C6 8B 53 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_906_0 {
	meta:
		name = "TActionClientItem.HasGlyph"
		size = 169
		refs = "0012 TActionClient.GetOwningCollection 001d TActionClientItem.GetActionClients 002f TActionClientsCollection.GetActionManager 0062 TActionClientItem.GetAction 0093 TCustomImageList.GetCount"
	strings:
		$1 = { 53 56 57 8B F8 33 DB 33 F6 80 7F 65 00 74 50 8B C7 E8 ?? ?? ?? ?? 85 C0 74 45 8B C7 E8 ?? ?? ?? ?? 80 78 29 00 74 11 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 70 38 EB 4C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B0 A4 00 00 00 85 F6 75 36 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 70 38 EB 25 8B C7 E8 ?? ?? ?? ?? 85 C0 74 1A 8B C7 E8 ?? ?? ?? ?? 83 78 5C 00 74 0D 8B C7 E8 ?? ?? ?? ?? 8B 40 5C 8B 70 38 85 F6 74 1B 8B 5F 5C 83 FB FF 7E 0B 8B C6 E8 ?? ?? ?? ?? 3B D8 7C 04 33 C0 EB 02 B0 01 8B D8 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_907_0 {
	meta:
		name = "TActionClientItem.InitiateAction"
		size = 15
	strings:
		$1 = { 8B 50 3C 85 D2 74 07 8B C2 8B 10 FF 52 1C C3 }
	condition:
		$1
}

rule function_908_0 {
	meta:
		name = "TActionClientItem.IsCaptionStored"
		size = 260
		refs = "000f TActionClientItem.IsCaptionStored 001c TActionClientItem.GetAction 0031 _Dn_TCustomAction 0036 @IsClass 0048 TActionClientItem.GetCaption 005a @UStrLAsg 0077 @InternalUStrFromLStr 00b3 @UStrToPWChar 00ca CompareString 00f0 @UStrArrayClr 00f6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 B0 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 96 00 00 00 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 50 64 8D 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 56 8B 45 F8 E8 ?? ?? ?? ?? 50 53 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 85 C0 0F 95 C3 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_909_0 {
	meta:
		name = "TActionClientItem.Refresh"
		size = 18
	strings:
		$1 = { 8B 50 44 85 D2 74 0A 8B C2 8B 10 FF 92 E8 00 00 00 C3 }
	condition:
		$1
}

rule function_910_0 {
	meta:
		name = "TActionClientItem.ResetUsageData"
		size = 177
		refs = "0015 TActionClientItem.GetActionClients 001a TActionClientsCollection.GetActionManager 0040 TActionClient.GetOwningCollection 005a _DV_TActionBars 005f @IsClass 0079 _DV_TActionClientItem 009b TActionClientItem.SetLastSession"
	strings:
		$1 = { 53 56 57 8B F8 83 7F 48 FF 74 07 FF 47 48 C6 47 40 01 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 6C 8B 40 28 89 47 60 8B C7 E8 ?? ?? ?? ?? 8B 58 20 85 DB 74 78 8B C7 E8 ?? ?? ?? ?? 8B 40 20 E8 ?? ?? ?? ?? 8B F0 EB 0A 8B 46 20 E8 ?? ?? ?? ?? 8B F0 85 F6 74 11 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E1 85 F6 74 06 8B 46 28 89 47 60 85 DB 74 38 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 19 8B F3 C6 46 40 01 83 7E 48 FF 74 03 FF 46 48 8B 57 60 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 58 20 85 DB 75 C8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_911_0 {
	meta:
		name = "TActionClientItem.SetAction"
		size = 276
		refs = "000f TObject.Free 0020 TActionClientItem.GetAction 004f @CallDynaInst 0070 TActionClientItem.DoActionChange 007d TActionClientItem.GetActionClients 0082 TActionClientsCollection.GetActionManager 00af TComponent.FreeNotification"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 85 FF 75 12 8B 43 3C E8 ?? ?? ?? ?? 33 C0 89 43 3C E9 F3 00 00 00 8B C3 E8 ?? ?? ?? ?? 3B F8 0F 84 E4 00 00 00 83 7B 44 00 74 10 8D 43 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 83 7B 3C 00 75 15 8B C3 66 BE FC FF E8 ?? ?? ?? ?? 8B CB B2 01 FF 50 14 89 43 3C 8B D7 8B 43 3C 8B 08 FF 51 0C 8B 43 3C 89 58 0C C7 40 08 ?? ?? ?? ?? F6 47 1C 01 75 19 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 B8 A8 00 00 00 00 75 04 33 C9 EB 02 B1 01 8B D7 8B C3 66 BE FD FF E8 ?? ?? ?? ?? 8B 43 04 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 78 20 00 74 50 8B C3 E8 ?? ?? ?? ?? 8B 40 20 83 78 0C 00 74 19 8B C3 E8 ?? ?? ?? ?? 8B 40 20 8B 40 0C 8B D3 8B 08 FF 91 4C 01 00 00 EB 27 8B C3 E8 ?? ?? ?? ?? 8B 40 20 83 78 18 00 74 17 8B C3 E8 ?? ?? ?? ?? 8B 40 20 8B 40 18 8B D3 8B 08 FF 91 4C 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_912_0 {
	meta:
		name = "TActionClientItem.SetCaption"
		size = 152
		refs = "000d @UStrEqual 0019 @UStrAsg 0020 TActionClientItem.GetAction 002b TActionClientItem.SetCaption 0056 TActionClientItem.SetAction 005f TActionClientItem.SetShortCut 006d TControl.SetText"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B 47 20 8B D6 E8 ?? ?? ?? ?? 74 5E 8D 47 20 8B D6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 85 C0 75 1C 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 12 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 04 33 DB EB 02 B3 01 88 5F 54 84 DB 74 12 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 47 44 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 7C 00 00 00 }
	condition:
		$1
}

rule function_913_0 {
	meta:
		name = "TActionClientItem.SetControl"
		size = 74
		refs = "0017 TObject.Free 0027 TActionClientItem.GetAction 0036 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 44 74 3C 8D 43 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C6 89 43 44 85 C0 74 23 8B C3 E8 ?? ?? ?? ?? 8B D0 B1 01 8B C3 66 BE FD FF E8 ?? ?? ?? ?? 8B D3 8B 43 44 8B 08 FF 91 DC 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_914_0 {
	meta:
		name = "TActionClientItem.SetDefault"
		size = 95
		refs = "0016 TActionClientItem.GetActionClients 001b TCollection.GetCount 0033 TCollection.GetItem 0044 TActionClientItem.SetDefault"
	strings:
		$1 = { 53 56 57 8B D8 3A 53 6C 74 51 8B C2 88 43 6C 84 C0 74 39 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 26 46 33 FF 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 80 78 6C 00 74 0B 3B D8 74 07 33 D2 E8 ?? ?? ?? ?? 47 4E 75 DD 8B 43 44 85 C0 74 08 8B 10 FF 92 80 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_915_0 {
	meta:
		name = "TActionClientItem.SetImageIndex"
		size = 39
	strings:
		$1 = { 53 8B D8 3B 53 5C 74 1D 89 53 5C 8B 43 44 85 C0 74 13 8B 10 FF 92 E8 00 00 00 8B 43 44 8B 10 FF 92 80 00 00 00 5B C3 }
	condition:
		$1
}

rule function_916_0 {
	meta:
		name = "TActionClientItem.SetIndex"
		size = 35
		refs = "0006 TCollectionItem.SetIndex 001d NotifyDesigner"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 46 44 85 C0 74 08 8B 10 FF 92 D8 00 00 00 8B 46 0C E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_917_0 {
	meta:
		name = "TActionClientItem.SetLastSession"
		size = 13
	strings:
		$1 = { 3B 50 60 74 07 89 50 60 C6 40 40 01 C3 }
	condition:
		$1
}

rule function_918_0 {
	meta:
		name = "TActionClientItem.SetMergeIndex"
		size = 139
		refs = "0010 TCollectionItem.GetIndex 0024 TActionClientItem.GetActionClients 002a TActionClients.GetActionClient 0046 TCollection.GetCount"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 3B 6B 50 77 27 8B C3 E8 ?? ?? ?? ?? 85 C0 74 1C 8B C3 E8 ?? ?? ?? ?? 48 50 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 83 78 50 00 75 52 8B C3 E8 ?? ?? ?? ?? 8B F8 47 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 2B F7 7C 32 46 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B C8 8B 41 50 3B 43 50 75 05 89 69 50 EB 10 8B 43 50 2B 41 50 99 33 C2 2B C2 03 C5 89 41 50 47 4E 75 CF 89 6B 50 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_919_0 {
	meta:
		name = "TActionClientItem.SetNewCol"
		size = 49
		refs = "0016 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 53 56 8B F0 3A 56 75 74 25 88 56 75 8B 5E 44 85 DB 74 1B 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 8B 46 44 E8 ?? ?? ?? ?? 8B 10 FF 92 58 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_920_0 {
	meta:
		name = "TActionClientItem.SetNewRow"
		size = 49
		refs = "0016 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 53 56 8B F0 3A 56 74 74 25 88 56 74 8B 5E 44 85 DB 74 1B 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 8B 46 44 E8 ?? ?? ?? ?? 8B 10 FF 92 58 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_921_0 {
	meta:
		name = "TActionClientItem.SetShortCut"
		size = 97
		refs = "000f TActionClientItem.SetShortCut 0029 ShortCutToText 0034 @UStrAsg 0050 @UStrClr 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 3B 5E 4C 74 20 66 89 5E 4C 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8D 46 58 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_922_0 {
	meta:
		name = "TActionClientItem.SetShowCaption"
		size = 88
		refs = "000f TActionClientItem.GetActionClients 0014 TActionClientsCollection.GetActionManager 0037 TComponent.GetComponentCount"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 3A 5E 55 74 48 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 40 1C 01 75 2C 8B C6 8B 10 FF 52 34 84 C0 75 21 84 DB 75 16 8B 7E 44 85 FF 74 0B 8B C7 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 88 46 55 EB 03 88 5E 55 8B C6 8B 10 FF 52 30 5F 5E 5B C3 }
	condition:
		$1
}

rule function_923_0 {
	meta:
		name = "TActionClientItem.SetShowShortCut"
		size = 39
		refs = "0021 TWinControl.Realign"
	strings:
		$1 = { 53 8B D8 3A 53 56 74 1D 88 53 56 8B 43 44 85 C0 74 13 8B 10 FF 92 E8 00 00 00 8B 43 44 8B 40 30 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_924_0 {
	meta:
		name = "TActionClientItem.SetUsageCount"
		size = 40
	strings:
		$1 = { 81 FA FF FF FF 7F 75 07 33 D2 89 50 48 EB 03 89 50 48 C6 40 40 01 8B 50 44 85 D2 74 0A 8B C2 8B 10 FF 92 80 00 00 00 C3 }
	condition:
		$1
}

rule function_925_0 {
	meta:
		name = "TActionClientItem.SetVisible"
		size = 122
		refs = "002c TControl.SetVisible 0043 _DV_TXToolDockForm 0048 @IsClass"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 3A 5E 30 75 0C 8B 46 44 85 C0 74 63 3A 58 57 74 5E 88 5E 30 8B 46 44 85 C0 74 0E 3A 58 57 74 09 0F B6 56 30 E8 ?? ?? ?? ?? 8B 7E 0C 85 FF 74 3F 3A 5F 57 74 2A 8B 5F 30 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B C3 33 D2 E8 ?? ?? ?? ?? EB 0B 0F B6 56 30 8B C7 E8 ?? ?? ?? ?? 8B 46 0C F6 40 1C 10 75 07 8B C6 8B 10 FF 52 30 5F 5E 5B C3 }
	condition:
		$1
}

rule function_926_0 {
	meta:
		name = "TActionClientItem.SetChangesAllowed"
		size = 76
		refs = "000e TActionClient.SetChangesAllowed 0015 TActionClientItem.GetParentItem 001b _DV_TActionClientItem 0020 @IsClass 002b TActionClientItem.GetActionClients"
	strings:
		$1 = { 53 51 88 14 24 8B D8 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B C3 E8 ?? ?? ?? ?? 8B 40 20 0F B6 40 31 3A 43 31 76 0E 8B C3 E8 ?? ?? ?? ?? 0F B6 53 31 88 50 31 5A 5B C3 }
	condition:
		$1
}

rule function_927_0 {
	meta:
		name = "TActionClientItem.SetShowGlyph"
		size = 26
	strings:
		$1 = { 3A 50 65 74 14 88 50 65 8B 50 44 85 D2 74 0A 8B C2 8B 10 FF 92 E8 00 00 00 C3 }
	condition:
		$1
}

rule function_928_0 {
	meta:
		name = "TActionClientItem.SetCollection"
		size = 58
		refs = "0019 TObject.Free 0029 @CallDynaInst 0032 TCollectionItem.SetCollection"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 83 7B 44 00 74 20 8D 43 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 43 0C 85 C0 74 09 66 BE D0 FF E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_929_0 {
	meta:
		name = "TActionClientItem.SetCommandProperties"
		size = 146
		refs = "0011 TActionClientItem.SetCommandProperties 0023 TObject.Free 002c _DV_TCommandProperties 0031 TCommandProperties.Create 0040 TObject.ClassName 005a @UStrEqual 0080 @UStrArrayClr 0086 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 75 1B 8B 43 78 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 78 EB 30 8D 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 8B 43 78 8B 00 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 75 0A 8B D6 8B 43 78 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_930_0 {
	meta:
		name = "TActionClientItem.SetCommandStyle"
		size = 350
		refs = "0032 TActionClientItem.SetCommandStyle 0063 _DV_TGalleryProperties 0068 TGalleryProperties.Create 0079 _DV_TButtonProperties 007e TButtonProperties.Create 008f _DV_TMenuProperties 0094 TMenuProperties.Create 00a2 _DV_TTextProperties 00a7 TTextProperties.Create 00b5 _DV_TControlProperties 00ba TControlProperties.Create 00c8 _DV_TComboBoxProperties 00cd TComboBoxProperties.Create 00ec TActionClientItem.GetActionClients 00f1 TActionClientsCollection.GetActionManager 00fc @CallDynaInst 011f TObject.Free 0130 TCustomActionControl.GetActionBar 0141 TWinControl.GetAlignDisabled"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F8 3A 5F 76 0F 84 48 01 00 00 8B 47 78 85 C0 74 09 8B E8 33 C0 89 47 78 EB 02 33 ED 0F B6 C3 83 F8 09 0F 87 DF 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 E9 9A 00 00 00 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 E9 84 00 00 00 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 71 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 5E 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 4B 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 38 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 25 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D7 66 BE EB FF E8 ?? ?? ?? ?? 8B F0 8B CF B2 01 8B C6 FF 50 10 89 47 78 85 ED 74 0A 8B D5 8B 47 78 8B 08 FF 51 08 8B C5 E8 ?? ?? ?? ?? 88 5F 76 8B 5F 44 85 DB 74 2C 8B C3 E8 ?? ?? ?? ?? 85 C0 74 21 8B 47 44 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 10 8B 47 44 E8 ?? ?? ?? ?? 8B 10 FF 92 58 01 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_931_0 {
	meta:
		name = "CheckControl"
		size = 27
	strings:
		$1 = { 80 78 30 00 74 0F 83 78 44 00 74 09 8B 40 44 80 78 57 00 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_932_0 {
	meta:
		name = "TActionClientItem.Unused"
		size = 352
		refs = "0018 TActionClientItem.GetActionClients 0031 TActionClientsCollection.GetActionManager 0044 TCollectionItem.GetIndex 006d TActionClients.GetActionClient 00b1 TCollection.GetCount 0138 TActionClient.GetItems 0148 TActionClient.HasVisibleItems"
	strings:
		$1 = { 53 56 57 55 51 8B F0 0F B6 5E 64 80 7E 40 00 0F 84 43 01 00 00 8B C6 E8 ?? ?? ?? ?? 80 78 2A 00 75 07 33 DB E9 2F 01 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 80 7E 54 00 0F 84 E2 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 83 FF 00 7C 55 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 44 8B C6 E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 80 78 54 00 75 2E 8B C6 E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D0 8B C5 8B 08 FF 51 3C 8B D8 80 F3 01 84 DB 75 06 4F 83 FF FF 75 AB 84 DB 0F 84 A8 00 00 00 8B 46 04 E8 ?? ?? ?? ?? 48 85 C0 0F 8C 97 00 00 00 40 89 04 24 8B C6 E8 ?? ?? ?? ?? 50 8B 46 04 E8 ?? ?? ?? ?? 48 5A 3B D0 7D 44 8B C6 E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 80 78 54 00 75 61 8B C6 E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D0 8B C5 8B 08 FF 51 3C 8B D8 80 F3 01 84 DB 75 39 FF 0C 24 75 A1 EB 32 8B D6 8B C5 8B 08 FF 51 3C 8B D8 80 F3 01 84 DB 74 1C 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 0C 8B C6 E8 ?? ?? ?? ?? 8B D8 80 F3 01 C6 46 40 00 88 5E 64 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_933_0 {
	meta:
		name = "TActionClientItem.IsHelpContextStored"
		size = 32
	strings:
		$1 = { 53 56 8B D8 8B 73 3C 85 F6 74 10 8B C6 8B 10 FF 52 30 84 C0 74 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_934_0 {
	meta:
		name = "TActionDragObject.Create"
		size = 72
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TList 0035 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 48 C6 46 4C 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_935_0 {
	meta:
		name = "TActionDragObject.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
		altNames = "TDragDockObject.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 48 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_936_0 {
	meta:
		name = "TActionDragObject.AddAction"
		size = 9
		refs = "0004 TList.Add"
		altNames = "TActionDragObject.AddActionClass"
	strings:
		$1 = { 8B 40 48 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25070_0 {
	meta:
		name = "TIdHTTPDefaultSessionList.Add"
		size = 9
		refs = "0004 TThreadList.Add"
	strings:
		$1 = { 8B 40 48 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_938_0 {
	meta:
		name = "TActionDragObject.GetAction"
		size = 50
		refs = "0012 TList.Get 0019 ActionBarDesigner"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 7B 4C 00 74 19 8B D6 8B 43 48 E8 ?? ?? ?? ?? 8B D0 A1 ?? ?? ?? ?? 8B 08 FF 51 0C 5E 5B C3 8B D6 8B 43 48 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_939_0 {
	meta:
		name = "TActionDragObject.GetActionCount"
		size = 7
	strings:
		$1 = { 8B 40 48 8B 40 08 C3 }
	condition:
		$1
}

rule function_940_0 {
	meta:
		name = "TCategoryDragObject.Create"
		size = 124
		refs = "000e @ClassCreate 001d @UStrAddRef 0025 TCategoryDragObject.Create 0034 TActionDragObject.Create 003f @UStrAsg 0054 @UStrClr 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 50 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_941_0 {
	meta:
		name = "TActionItemDragObject.Finished"
		size = 143
		refs = "0021 TDragObject.Finished 003d Point 004a TControl.ScreenToClient 006f PtInRect 007b TObject.Free 0082 NotifyDesigner"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 89 4D FC 8B FA 8B D8 8B 45 0C 50 0F B6 45 08 50 8B 4D FC 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 43 48 8B 70 44 85 F6 74 57 3B F7 74 53 8D 4D EC 8B 55 0C 8B 45 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 4D F4 8B C6 E8 ?? ?? ?? ?? 80 7B 20 00 74 2B 80 7D 08 00 75 25 8D 55 DC 8B 43 48 8B 40 44 8B 08 FF 51 44 8D 45 DC 8D 55 F4 E8 ?? ?? ?? ?? 84 C0 75 08 8B 43 48 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_942_0 {
	meta:
		name = "ColorProc"
		size = 73
		refs = "000e _Dn_TCustomActionPopupMenu 0013 @IsClass 0021 TControl.SetColor 0034 TWinControl.HandleAllocated"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 DB 74 3C 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 56 74 8B C3 E8 ?? ?? ?? ?? EB 0A 8B 56 40 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0A 8B C3 8B 10 FF 92 80 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_943_0 {
	meta:
		name = "FontColorProc"
		size = 27
		refs = "0016 TFont.SetColor"
	strings:
		$1 = { 85 C0 74 16 8B 48 64 8B 49 18 3B 4A 50 74 0B 8B 40 64 8B 52 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_944_0 {
	meta:
		name = "TCustomActionBarColorMap.Add"
		size = 63
		refs = "0010 TList.IndexOf 001d TList.Add 0026 TComponent.FreeNotification 002f ColorProc 0038 FontColorProc"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 32 8B D6 8B 43 30 E8 ?? ?? ?? ?? 40 75 25 8B D6 8B 43 30 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_945_0 {
	meta:
		name = "TCustomActionBarColorMap.Create"
		size = 75
		refs = "000a @ClassCreate 0017 TComponent.Create 001e _Dn_TList 0023 TObject.Create 0038 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 30 8B C6 8B 10 FF 52 38 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_946_0 {
	meta:
		name = "TCustomActionBarColorMap.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 0017 TObject.Free 0023 TComponent.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 46 30 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47278_0 {
	meta:
		name = "TRibbonTabItem.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 0017 TObject.Free 0023 TCollectionItem.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 46 30 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_947_0 {
	meta:
		name = "TCustomActionBarColorMap.GetDisabledColor"
		size = 24
	strings:
		$1 = { 8B 50 44 F6 40 1C 10 75 0C 81 78 44 FF FF FF 1F 75 03 8B 50 40 8B C2 C3 }
	condition:
		$1
}

rule function_948_0 {
	meta:
		name = "TCustomActionBarColorMap.GetUnusedColor"
		size = 28
		refs = "0014 GetHighLightColor"
	strings:
		$1 = { 8B 50 60 81 FA 00 00 00 20 75 0E BA 13 00 00 00 8B 40 40 E8 ?? ?? ?? ?? C3 8B C2 C3 }
	condition:
		$1
}

rule function_949_0 {
	meta:
		name = "TCustomActionBarColorMap.Notification"
		size = 70
		refs = "0010 TComponent.Notification 001c _DV_TCustomActionBar 0021 @IsClass 002f TList.IndexOf 003e TList.Delete"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? FE CB 75 2A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 19 8B D7 8B 46 30 E8 ?? ?? ?? ?? 83 F8 FF 74 0A 8B D0 8B 46 30 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_950_0 {
	meta:
		name = "TCustomActionBarColorMap.Remove"
		size = 51
		refs = "0014 TList.IndexOf 0023 TList.Delete 002c TComponent.RemoveFreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 26 8B 43 30 85 C0 74 16 8B D6 E8 ?? ?? ?? ?? 83 F8 FF 74 0A 8B D0 8B 43 30 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_951_0 {
	meta:
		name = "TCustomActionBarColorMap.SetColor"
		size = 102
		refs = "000c ColorProc 0016 TCustomActionBarColorMap.UpdateActionBars 002c GetHighLightColor 0045 GetShadowColor"
	strings:
		$1 = { 53 8B D8 3B 53 40 74 5C 89 53 40 B8 ?? ?? ?? ?? 8B CA 8B D3 92 E8 ?? ?? ?? ?? 81 7B 60 00 00 00 20 75 10 BA 13 00 00 00 8B 43 40 E8 ?? ?? ?? ?? 89 43 60 81 7B 48 00 00 00 20 75 10 BA CE FF FF FF 8B 43 40 E8 ?? ?? ?? ?? 89 43 48 66 83 BB 8A 00 00 00 00 74 0E 8B D3 8B 83 8C 00 00 00 FF 93 88 00 00 00 5B C3 }
	condition:
		$1
}

rule function_952_0 {
	meta:
		name = "TCustomActionBarColorMap.SetFontColor"
		size = 81
		refs = "0020 GetShadowColor 0039 GetHighLightColor 0041 FontColorProc 004a TCustomActionBarColorMap.UpdateActionBars"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 50 74 43 89 73 50 81 7B 48 00 00 00 20 75 10 BA CE FF FF FF 8B 43 40 E8 ?? ?? ?? ?? 89 43 48 81 7B 4C 00 00 00 20 75 10 BA 13 00 00 00 8B 43 40 E8 ?? ?? ?? ?? 89 43 4C BA ?? ?? ?? ?? 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_953_0 {
	meta:
		name = "TCustomActionBarColorMap.UpdateColors"
		size = 6
	strings:
		$1 = { 33 D2 89 50 70 C3 }
	condition:
		$1
}

rule function_954_0 {
	meta:
		name = "TCustomActionBarColorMap.UpdateActionBars"
		size = 45
		refs = "001c TList.Get"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B 43 30 8B 70 08 4E 85 F6 7C 15 46 33 FF 8B D7 8B 43 30 E8 ?? ?? ?? ?? 8B D3 FF D5 47 4E 75 EE 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_955_0 {
	meta:
		name = "TCustomActionBarColorMap.Assign"
		size = 212
		refs = "000b _DV_TCustomActionBarColorMap 0010 @IsClass 0043 TCustomActionBarColorMap.GetDisabledColor 00b1 TCustomActionBarColorMap.GetUnusedColor"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 B4 00 00 00 8B FE 8B 47 34 89 43 34 8B 47 38 89 43 38 8B 47 3C 89 43 3C 8B 57 40 8B C3 8B 08 FF 51 30 8B 47 70 89 43 70 8B C7 E8 ?? ?? ?? ?? 89 43 44 8B 47 48 89 43 48 8B 47 4C 89 43 4C 8B 57 50 8B C3 8B 08 FF 51 34 8B 47 78 89 43 78 8B 47 7C 89 43 7C 8B 87 80 00 00 00 89 83 80 00 00 00 8B 87 84 00 00 00 89 83 84 00 00 00 8B 47 6C 89 43 6C 8B 47 54 89 43 54 8B 47 5C 89 43 5C 8B 47 74 89 43 74 8B 47 68 89 43 68 8B 47 64 89 43 64 8B 47 58 89 43 58 8B C7 E8 ?? ?? ?? ?? 89 43 60 8B 87 88 00 00 00 89 83 88 00 00 00 8B 87 8C 00 00 00 89 83 8C 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_956_0 {
	meta:
		name = "TCustomActionBar.Create"
		size = 208
		refs = "000e @ClassCreate 001c TToolWindow.Create 002a TCustomActionBar.SetupDefaultColorMap 004d _Dn_TControlCanvas 0052 TCanvas.Create 0063 TControlCanvas.SetControl 006c TCustomActionBar.Create 007b TControl.SetHeight 0087 TControl.SetWidth 0090 TWinControl.SetDoubleBuffered 00b6 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 7C 02 00 00 01 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 38 01 00 00 33 C0 89 83 6C 02 00 00 33 C0 89 83 68 02 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 74 02 00 00 8B C6 8B D3 E8 ?? ?? ?? ?? 8B 43 50 0B 05 ?? ?? ?? ?? 89 43 50 BA 32 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 96 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? C7 83 AC 02 00 00 01 00 00 00 33 C0 89 83 B0 02 00 00 C6 83 70 02 00 00 01 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 E8 00 00 00 }
	condition:
		$1
}

rule function_957_0 {
	meta:
		name = "TCustomActionBar.Destroy"
		size = 76
		refs = "0003 @BeforeDestruction 0010 TCustomActionBar.SetActionManager 001b TObject.Free 003a TWinControl.Destroy 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 86 74 02 00 00 E8 ?? ?? ?? ?? 8D 86 D0 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_958_0 {
	meta:
		name = "TCustomActionBar.AlignControls"
		size = 44
		refs = "0026 TWinControl.AlignControls"
	strings:
		$1 = { 53 C7 80 A4 02 00 00 01 00 00 00 C7 80 A8 02 00 00 01 00 00 00 33 DB 89 98 C8 02 00 00 33 DB 89 98 C4 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_960_0 {
	meta:
		name = "TCustomActionBar.BackgroundSize"
		size = 16
		refs = "000a Point"
		altNames = "TCustomImageList.GetHotSpot"
	strings:
		$1 = { 53 8B DA 8B CB 33 D2 33 C0 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_961_0 {
	meta:
		name = "TCustomActionBar.CalcInsertPosition"
		size = 228
		refs = "002c TCollectionItem.GetIndex 0060 TControl.GetBoundsRect 0099 TCustomActionBar.GetItems 009e TCollection.GetCount 00bf TCustomActionBar.HasItems"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 4D FC 8B F2 8B D8 85 F6 0F 84 A4 00 00 00 83 BE AC 01 00 00 00 0F 84 97 00 00 00 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 FC 3B 46 40 7D 0C 0F B6 83 7F 02 00 00 84 C0 75 01 4F 8B 45 08 3B 46 44 7D 0C 0F B6 83 7F 02 00 00 2C 02 75 01 4F 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B 45 F4 3B 45 FC 7D 0C 0F B6 83 7F 02 00 00 84 C0 75 01 47 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B 45 F8 3B 45 08 7D 0C 0F B6 83 7F 02 00 00 2C 02 75 01 47 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B F8 7E 0E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 FF 7D 21 33 FF EB 1D 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 8B C7 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_962_0 {
	meta:
		name = "TCustomActionBar.Clear"
		size = 143
		refs = "0018 TWinControl.DisableAlign 0020 TCustomActionBar.Clear 004b TObject.Free 005f TActionClient.ClearActionBar 007f TWinControl.EnableAlign 0085 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC 83 B8 68 02 00 00 00 74 77 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 20 01 00 00 8B D8 4B 83 FB 00 7C 18 8B D3 8B 45 FC 8B 08 FF 91 14 01 00 00 E8 ?? ?? ?? ?? 4B 83 FB FF 75 E8 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 68 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_963_0 {
	meta:
		name = "TCustomActionBar.CMEnabledchanged"
		size = 27
		refs = "000b TWinControl.CMEnabledChanged 0014 TWinControl.Broadcast"
		altNames = "TToolBar.CMEnabledChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12579_0 {
	meta:
		name = "TDBXDriverRegistry.GetRegisteredDriverNames"
		size = 27
		refs = "000b TDBXDriverRegistry.GetRegisteredDriverLoaderNames 0014 TDBXDriverRegistry.GetRegisteredDriverClassNames"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_56728_0 {
	meta:
		name = "TSeriesPointer.SetSize"
		size = 27
		refs = "000b TSeriesPointer.SetHorizSize 0014 TSeriesPointer.SetVertSize"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_54346_0 {
	meta:
		name = "TTeeShadow.SetSize"
		size = 27
		refs = "000b TTeeShadow.SetHorizSize 0014 TTeeShadow.SetVertSize"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7840_0 {
	meta:
		name = "TWinControl.CMSysFontChanged"
		size = 27
		refs = "000b TControl.CMSysFontChanged 0014 TWinControl.Broadcast"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_964_0 {
	meta:
		name = "TCustomActionBar.CreateControl"
		size = 308
		refs = "0023 TObject.Free 002c TActionClientItem.SetControl 003a @CallDynaInst 004c TWinControl.DisableAlign 0054 TCustomActionBar.CreateControl 008a ControlDragMode 009c TControl.SetAlign 00f7 @HandleAnyException 0104 @RaiseAgain 0109 @DoneExcept 011e TWinControl.EnableAlign 0124 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B DA 89 45 FC 33 C0 89 45 F8 85 DB 0F 84 0F 01 00 00 8B 43 44 85 C0 74 0E E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D3 8B 45 FC 66 BE B0 FF E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 E2 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC B2 01 8B C6 FF 50 2C 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 10 01 00 00 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 45 F8 8B 08 FF 51 60 B2 06 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 89 90 A8 01 00 00 8B 55 FC 8B 45 F8 8B 08 FF 51 68 8B 45 FC 0F B6 50 5F 8B 45 F8 8B 08 FF 51 70 8B D3 8B 45 F8 8B 08 FF 91 DC 00 00 00 8B 45 F8 8B 80 AC 01 00 00 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 10 FF 52 58 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_965_0 {
	meta:
		name = "TCustomActionBar.CreateControls"
		size = 255
		refs = "0020 TWinControl.DisableAlign 0028 TCustomActionBar.CreateControls 005d @TryFinallyExit 0069 TCollection.GetCount 007c TActionClients.GetActionClient 00a0 TActionClient.HasBackground 00c5 TCustomActionControl.SetTransparent 00ec TWinControl.EnableAlign 00f2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 8B 45 FC 83 B8 68 02 00 00 00 0F 84 DC 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 CC 02 00 00 00 74 0E 8B 45 FC 8B 80 68 02 00 00 8B 78 1C EB 0C 8B 45 FC 8B 80 68 02 00 00 8B 78 2C 85 FF 75 0A E8 ?? ?? ?? ?? E9 92 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 67 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 08 FF 91 4C 01 00 00 89 45 F8 83 7D F8 00 74 41 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 13 8B 45 FC 8B 80 68 02 00 00 0F B6 40 14 04 FD 2C 02 73 04 33 D2 EB 02 B2 01 8B 45 F8 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 FC 8B 08 FF 91 EC 00 00 00 46 4B 75 9C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_966_0 {
	meta:
		name = "TCustomActionBar.CustomAlignInsertBefore"
		size = 317
		refs = "000e _DV_TCustomActionControl 0015 @IsClass 0050 TCollectionItem.GetIndex 0105 TSizeConstraints.SetConstraints"
	strings:
		$1 = { 53 56 57 55 8B F9 8B F2 8B E8 8B C6 8B 1D ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 84 C0 74 0D 8B C7 8B D3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 8B D8 84 DB 0F 84 FC 00 00 00 8B 9E AC 01 00 00 85 DB 74 26 83 BF AC 01 00 00 00 74 1D 8B C3 E8 ?? ?? ?? ?? 50 8B 87 AC 01 00 00 E8 ?? ?? ?? ?? 5A 3B D0 0F 9C C0 8B D8 EB 02 33 DB 80 7E 57 00 74 14 8B 46 4C 3B 85 C4 02 00 00 7E 09 8B 46 4C 89 85 C4 02 00 00 80 7E 57 00 74 14 8B 46 48 3B 85 C8 02 00 00 7E 09 8B 46 48 89 85 C8 02 00 00 80 7F 57 00 74 14 8B 47 4C 3B 85 C4 02 00 00 7E 09 8B 47 4C 89 85 C4 02 00 00 80 7F 57 00 74 14 8B 47 48 3B 85 C8 02 00 00 7E 09 8B 47 48 89 85 C8 02 00 00 8B C5 8B 10 FF 52 50 84 C0 74 57 0F B6 85 7F 02 00 00 2C 02 72 21 2C 02 73 48 8B 8D AC 02 00 00 03 C9 03 8D C4 02 00 00 BA 02 00 00 00 8B 45 70 E8 ?? ?? ?? ?? EB 2B B2 02 8B C5 8B 08 FF 91 04 01 00 00 8B C8 8B 85 B0 02 00 00 03 C0 03 85 C8 02 00 00 03 C8 BA 03 00 00 00 8B 45 70 E8 ?? ?? ?? ?? 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_967_0 {
	meta:
		name = "TCustomActionBar.CustomAlignPosition"
		size = 1200
		refs = "0021 _DV_TCustomActionControl 0026 @IsClass 0059 TControl.GetClientHeight 0078 TControl.GetClientWidth 00a0 Rect 00e5 TCustomActionBar.GetAutoSizing 0167 SepSize"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B 75 08 8D 7D E8 A5 A5 A5 A5 89 4D FC 8B FA 8B D8 8B 75 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 75 04 00 00 89 7D F8 8B 45 E8 83 78 08 01 75 12 8B 47 48 89 83 C8 02 00 00 8B 47 4C 89 83 C4 02 00 00 83 7D EC 00 75 5B 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 50 8D 45 D8 50 B2 01 8B C3 8B 08 FF 91 04 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 04 01 00 00 03 83 B0 02 00 00 8B 93 AC 02 00 00 59 E8 ?? ?? ?? ?? 56 57 8B FE 8D 75 D8 A5 A5 A5 A5 5F 5E 0F B6 83 7F 02 00 00 2C 01 72 1B 0F 84 F8 00 00 00 FE C8 0F 84 0D 02 00 00 FE C8 0F 84 F6 02 00 00 E9 D0 03 00 00 8B C3 8B 10 FF 52 50 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 9C 00 00 00 83 7D EC 00 0F 84 92 00 00 00 8B 46 08 2B 06 8B 55 F8 8B 52 48 03 93 B0 02 00 00 3B C2 7D 7D 8B C3 E8 ?? ?? ?? ?? 2B 46 04 2B 83 AC 02 00 00 50 8D 45 D8 50 B2 01 8B C3 8B 08 FF 91 04 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 B0 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 04 01 00 00 03 83 B0 02 00 00 8B 93 AC 02 00 00 03 D2 0F B6 8B B4 02 00 00 03 14 8D ?? ?? ?? ?? 8B 4E 04 03 8B C4 02 00 00 03 D1 59 E8 ?? ?? ?? ?? 56 8B FE 8D 75 D8 A5 A5 A5 A5 5E FF 83 A8 02 00 00 8B 46 04 8B 55 18 89 02 8B 06 8B 55 FC 89 02 8B 45 10 8B 93 C4 02 00 00 89 10 8B 45 F8 8B 40 48 03 83 80 02 00 00 01 06 E9 ED 02 00 00 8B C3 8B 10 FF 52 50 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 94 00 00 00 83 7D EC 00 0F 84 8A 00 00 00 8B 46 08 2B 06 8B 55 F8 3B 42 48 7D 7D 8B C3 E8 ?? ?? ?? ?? 2B 46 04 2B 83 AC 02 00 00 50 8D 45 D8 50 B2 01 8B C3 8B 08 FF 91 04 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 B0 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 04 01 00 00 03 83 B0 02 00 00 8B 93 AC 02 00 00 03 D2 0F B6 8B B4 02 00 00 03 14 8D ?? ?? ?? ?? 8B 4E 04 03 8B C4 02 00 00 03 D1 59 E8 ?? ?? ?? ?? 56 8B FE 8D 75 D8 A5 A5 A5 A5 5E FF 83 A8 02 00 00 8B 46 04 8B 55 18 89 02 8B 45 EC 85 C0 75 27 8B 56 08 8B 45 F8 8B 40 48 2B D0 2B 93 B0 02 00 00 8B 4D FC 89 11 03 83 AC 02 00 00 03 83 80 02 00 00 29 46 08 EB 29 8B 4E 08 8B 55 F8 8B 52 48 2B CA 8B 7D FC 89 0F 8B 4D E8 8B 49 08 49 3B C1 75 05 29 56 08 EB 09 03 93 80 02 00 00 29 56 08 8B 45 10 8B 93 C4 02 00 00 89 10 E9 D0 01 00 00 8B C3 8B 10 FF 52 50 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 81 00 00 00 83 7D EC 00 74 7B 8B 46 0C 2B 46 04 8B 55 F8 3B 42 4C 7D 6D 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 50 8D 45 D8 50 B2 01 8B C3 8B 08 FF 91 04 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 8B C8 2B 8B B0 02 00 00 58 2B C8 8B 06 03 83 C8 02 00 00 8B 93 B0 02 00 00 03 D2 03 C2 0F B6 93 B4 02 00 00 03 04 95 ?? ?? ?? ?? 8B 93 AC 02 00 00 E8 ?? ?? ?? ?? 56 8B FE 8D 75 D8 A5 A5 A5 A5 5E FF 83 A4 02 00 00 83 7D EC 00 75 0D 8B 45 18 8B 93 AC 02 00 00 89 10 EB 08 8B 46 04 8B 55 18 89 02 B2 02 8B C3 8B 08 FF 91 04 01 00 00 03 83 C8 02 00 00 89 46 08 8B 06 8B 55 FC 89 02 8B 45 14 8B 93 C8 02 00 00 89 10 8B 45 F8 8B 40 4C 03 83 80 02 00 00 01 46 04 E9 DF 00 00 00 8B C3 8B 10 FF 52 50 84 C0 75 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 74 77 83 7D EC 00 74 71 8B 46 0C 2B 46 04 8B 55 F8 3B 42 4C 7D 63 8B C3 E8 ?? ?? ?? ?? 2B 83 AC 02 00 00 50 8D 45 D8 50 33 D2 8B C3 8B 08 FF 91 04 01 00 00 03 83 B0 02 00 00 8B 4E 08 2B 8B C8 02 00 00 8B 93 B0 02 00 00 03 D2 2B CA 0F B6 93 B4 02 00 00 2B 0C 95 ?? ?? ?? ?? 8B 93 AC 02 00 00 E8 ?? ?? ?? ?? 56 57 8B FE 8D 75 D8 A5 A5 A5 A5 5F 5E FF 83 A4 02 00 00 83 7D EC 00 75 17 8B C3 E8 ?? ?? ?? ?? 2B 47 4C 2B 83 B0 02 00 00 8B 55 18 89 02 EB 11 8B 46 0C 2B 47 4C 2B 83 80 02 00 00 8B 55 18 89 02 8B 56 08 8B 83 C8 02 00 00 2B D0 8B 4D FC 89 11 8B 55 14 89 02 8B 45 F8 8B 40 4C 03 83 80 02 00 00 29 46 0C 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_968_0 {
	meta:
		name = "TCustomActionBar.DrawBackground"
		size = 363
		refs = "001a TActionClient.HasBackground 003c TCustomActionBar.DrawBackground 005b TActionClient.GetBackground 0080 TCanvas.Draw 00ce TCanvas.StretchDraw 0102 TControl.GetClientWidth 011e TControl.GetClientHeight"
	strings:
		$1 = { 53 56 57 55 83 C4 E4 8B D8 8B B3 68 02 00 00 85 F6 0F 84 4C 01 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 3D 01 00 00 8B B3 68 02 00 00 0F B6 46 14 83 F8 04 0F 87 2A 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B 40 0C 50 8B C6 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 30 8B 53 48 2B D0 33 C9 8B 83 74 02 00 00 E8 ?? ?? ?? ?? E9 DA 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 40 0C 50 33 C9 33 D2 8B 83 74 02 00 00 E8 ?? ?? ?? ?? E9 BB 00 00 00 8D 54 24 0C 8B C3 8B 08 FF 51 44 8D 44 24 0C 50 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B 48 0C 8B 83 74 02 00 00 5A E8 ?? ?? ?? ?? E9 8C 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 30 89 44 24 04 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 24 8B E8 8B C3 E8 ?? ?? ?? ?? 99 F7 7C 24 04 85 C0 7C 54 40 89 44 24 08 C7 04 24 00 00 00 00 8B C3 E8 ?? ?? ?? ?? 99 F7 FD 8B F0 85 F6 7C 2F 46 33 FF 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B 40 0C 50 8B CD 0F AF CF 8B 54 24 08 0F AF 54 24 04 8B 83 74 02 00 00 E8 ?? ?? ?? ?? 47 4E 75 D4 FF 04 24 FF 4C 24 08 75 B8 83 C4 1C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_969_0 {
	meta:
		name = "TCustomActionBar.DragOver"
		size = 109
		refs = "0023 TControl.DragOver 0034 _DV_TActionDragObject 0039 @IsClass 0045 _DV_TActionItemDragObject"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 08 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 7C 02 00 00 00 74 2D 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B 46 48 3B 83 68 02 00 00 75 04 33 C0 EB 02 B0 01 88 07 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_970_0 {
	meta:
		name = "TCustomActionBar.DragDrop"
		size = 317
		refs = "001a TControl.DragDrop 002e _DV_TActionDragBaseClass 0033 @AsClass 0040 TCustomActionBar.SetActionManager 004b TActionBars.Add 006b TWinControl.DisableAlign 0073 TCustomActionBar.DragDrop 0081 _DV_TCategoryDragObject 0086 @IsClass 00a7 _DV_TActionDragObject 00cd _DV_TActionItemDragObject 0104 TActionClient.GetItems 010b TActionClientsCollection.InternalRethinkHotkeys 0121 TWinControl.EnableAlign 0129 TWinControl.Realign 012f @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 8B F2 89 45 FC 8B 45 08 50 8B CF 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 B8 68 02 00 00 00 75 3D 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 53 40 8B 45 FC E8 ?? ?? ?? ?? 8B 43 40 8B 40 6C E8 ?? ?? ?? ?? 8B 55 FC 89 82 68 02 00 00 8B 45 FC 8B 80 68 02 00 00 8B 55 FC 89 50 0C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 15 8B 45 08 50 8B CF 8B D6 8B 45 FC 8B 18 FF 93 50 01 00 00 EB 4A 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 15 8B 45 08 50 8B CF 8B D6 8B 45 FC 8B 18 FF 93 F0 00 00 00 EB 24 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 13 8B 45 08 50 8B CF 8B D6 8B 45 FC 8B 18 FF 93 F4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 68 02 00 00 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 68 02 00 00 8B 10 FF 52 30 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C5 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_971_0 {
	meta:
		name = "TCustomActionBar.DoGetControlClass"
		size = 56
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B D6 8B C3 8B 08 FF 91 1C 01 00 00 89 04 24 66 83 BB 92 02 00 00 00 74 11 54 8B CE 8B D3 8B 83 94 02 00 00 FF 93 90 02 00 00 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_972_0 {
	meta:
		name = "TCustomActionBar.DoControlCreated"
		size = 31
	strings:
		$1 = { 53 66 83 B8 8A 02 00 00 00 74 12 8B CA 8B D8 8B D0 8B 83 8C 02 00 00 FF 93 88 02 00 00 5B C3 }
	condition:
		$1
}

rule function_973_0 {
	meta:
		name = "TCustomActionBar.FindAccelItem"
		size = 188
		refs = "0018 TCustomActionBar.FindAccelItem 003e TCustomActionBar.GetItems 0046 TActionClients.GetActionClient 007a TActionClientItem.GetCaption 0086 IsAccel 00a7 @UStrClr 00ad @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 66 89 55 FE 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 10 FF 92 20 01 00 00 8B F8 4F 85 FF 7C 61 47 C7 45 F8 00 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 80 78 28 00 74 35 8B 43 44 8B 40 30 80 B8 E2 01 00 00 00 74 26 80 7B 30 00 74 20 80 7B 55 00 74 1A 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 0F B7 45 FE E8 ?? ?? ?? ?? 84 C0 75 08 FF 45 F8 4F 75 A7 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_974_0 {
	meta:
		name = "TCustomActionBar.FindFirst"
		size = 54
		refs = "000f TCustomActionBar.HasItems 001a TWinControl.GetControlCount 0025 TCustomActionBar.GetItems 002c TActionClients.GetActionClient"
	strings:
		$1 = { 53 8B D8 83 BB 68 02 00 00 00 74 26 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 8B C3 E8 ?? ?? ?? ?? 85 C0 7E 10 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_975_0 {
	meta:
		name = "TCustomActionBar.FindItemAt"
		size = 39
		refs = "0008 TWinControl.ControlAtPos 0012 _DV_TCustomActionControl 0017 @IsClass"
	strings:
		$1 = { 53 6A 00 6A 00 B1 01 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 04 8B C3 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_976_0 {
	meta:
		name = "TCustomActionBar.FindItemCaption"
		size = 291
		refs = "001b TCustomActionBar.FindItemCaption 0055 TControl.GetText 0060 @UStrLAsg 007d @InternalUStrFromLStr 00b9 @UStrToPWChar 00d0 CompareString 010d @UStrArrayClr 0113 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D FC 89 4D F8 89 55 F0 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 EC 8B 45 F4 8B 10 FF 92 20 01 00 00 48 85 C0 0F 8C B9 00 00 00 40 89 45 E8 33 F6 8B D6 8B 45 F4 8B 08 FF 91 14 01 00 00 8D 55 FC E8 ?? ?? ?? ?? 8D 45 F8 8B 55 F0 E8 ?? ?? ?? ?? 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 45 F8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 F8 8B 55 F8 E8 ?? ?? ?? ?? 8B F8 85 FF 74 05 83 EF 04 8B 3F 57 8B 45 F8 E8 ?? ?? ?? ?? 50 53 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 68 00 04 00 00 E8 ?? ?? ?? ?? 83 E8 02 85 C0 75 12 8B D6 8B 45 F4 8B 08 FF 91 14 01 00 00 89 45 EC EB 0A 46 FF 4D E8 0F 85 4D FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B 45 EC 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_977_0 {
	meta:
		name = "TCustomActionBar.FindLast"
		size = 56
		refs = "000f TCustomActionBar.HasItems 001a TCustomActionBar.GetItems 001f TCollection.GetCount 002e TActionClients.GetActionClient"
	strings:
		$1 = { 53 8B D8 83 BB 68 02 00 00 00 74 28 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 50 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_978_0 {
	meta:
		name = "TCustomActionBar.FindLeastUsedItem"
		size = 299
		refs = "0068 TCustomActionBar.GetItems 006f TActionClients.GetActionClient 011c TCustomActionBar.FindLastVisibleItem"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 88 14 24 8B D8 8B C3 8B 10 FF 92 54 01 00 00 8B F8 85 FF 0F 84 02 01 00 00 EB 10 33 C9 8B D7 8B C3 8B 30 FF 96 00 01 00 00 8B F8 85 FF 74 0F 83 7F 44 00 74 09 8B 47 44 80 78 57 00 74 DD 33 C0 89 44 24 04 8B C3 8B 10 FF 92 20 01 00 00 8B E8 4D 85 ED 0F 8E B5 00 00 00 BE 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 1A 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 57 3A 04 24 75 7A 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 85 C0 74 68 8B D6 8B C3 8B 08 FF 91 14 01 00 00 85 C0 74 58 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 93 6C 02 00 00 8B 52 6C 8B 52 28 2B 50 60 3B 54 24 04 7C 35 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B F8 8B D6 8B C3 8B 08 FF 91 14 01 00 00 8B 80 AC 01 00 00 8B 93 6C 02 00 00 8B 52 6C 8B 52 28 2B 50 60 89 54 24 04 46 4D 0F 85 50 FF FF FF 85 FF 75 09 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C7 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_979_0 {
	meta:
		name = "TCustomActionBar.FindLastVisibleItem"
		size = 64
	strings:
		$1 = { 53 56 57 8B F8 8B C7 8B 10 FF 92 F8 00 00 00 8B D8 EB 10 33 C9 8B D3 8B C7 8B 18 FF 93 00 01 00 00 8B D8 85 DB 74 13 83 7B 44 00 74 E6 8B 73 44 85 F6 74 06 80 7E 57 00 74 D9 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_980_0 {
	meta:
		name = "TCustomActionBar.FindFirstVisibleItem"
		size = 60
	strings:
		$1 = { 53 56 57 8B F8 8B C7 8B 10 FF 92 54 01 00 00 8B F0 EB 10 33 C9 8B D6 8B C7 8B 18 FF 93 FC 00 00 00 8B F0 85 F6 74 0F 83 7E 44 00 74 09 8B 46 44 80 78 57 00 74 DD 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_981_0 {
	meta:
		name = "PointToRow"
		size = 154
	strings:
		$1 = { 55 8B EC 83 C4 F8 56 57 8B F0 8D 7D F8 A5 A5 B8 01 00 00 00 8B 55 08 8B 52 FC 83 BA A8 02 00 00 01 7E 31 8B 45 08 8B 40 FC 8B 10 FF 92 08 01 00 00 8B 55 08 8B 52 FC 8B 8A A8 02 00 00 99 F7 F9 8B D0 B8 01 00 00 00 EB 01 40 8B CA 0F AF C8 3B 4D FC 7C F5 8B 55 08 8B 52 FC 83 BA A4 02 00 00 01 7E 31 8B 45 08 8B 40 FC 8B 10 FF 92 0C 01 00 00 8B 55 08 8B 52 FC 8B 8A A4 02 00 00 99 F7 F9 8B D0 B8 01 00 00 00 EB 01 40 8B CA 0F AF C8 3B 4D F8 7C F5 5F 5E 59 59 5D C3 }
	condition:
		$1
}

rule function_982_0 {
	meta:
		name = "TCustomActionBar.FindNearestControl"
		size = 513
		refs = "001a TWinControl.ControlAtPos 0024 _DV_TCustomActionControl 0029 @IsClass 0049 PointToRow 006f TCustomActionBar.GetItems 0076 TActionClients.GetActionClient 00b7 TControl.GetBoundsRect"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B F2 89 45 FC 6A 00 6A 00 8B D6 B1 01 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 89 5D F8 E9 BE 01 00 00 33 C0 89 45 F8 C7 45 F4 FF FF FF 7F 55 8B C6 E8 ?? ?? ?? ?? 59 89 45 EC 8B 45 FC 8B 10 FF 92 20 01 00 00 48 85 C0 0F 8C 92 01 00 00 40 89 45 E8 33 DB 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 83 78 44 00 0F 84 69 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 80 78 57 00 0F 84 4D 01 00 00 55 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 59 3B 45 EC 0F 85 20 01 00 00 8B 3E 8B 46 04 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 40 40 3B 06 7E 15 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 78 40 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 40 44 3B 46 04 7E 18 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 40 44 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 45 E0 3B 06 7D 1D 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 7D E0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 45 E4 3B 46 04 7D 20 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F0 8B 06 2B C7 8B 16 2B D7 F7 EA 8B 56 04 2B 55 F0 8B 4E 04 2B 4D F0 0F AF D1 03 C2 3B 45 F4 7D 18 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 89 45 F8 43 FF 4D E8 0F 85 74 FE FF FF 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_983_0 {
	meta:
		name = "TCustomActionBar.FindNextVisibleItem"
		size = 66
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 C9 8B D6 8B C7 8B 18 FF 93 FC 00 00 00 8B F0 EB 10 33 C9 8B D6 8B C7 8B 18 FF 93 FC 00 00 00 8B F0 85 F6 74 0F 83 7E 44 00 74 09 8B 46 44 80 78 57 00 74 DD 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_984_0 {
	meta:
		name = "TCustomActionBar.FindNext"
		size = 137
		refs = "0013 TCustomActionBar.HasItems 001e TCollectionItem.GetIndex 0026 TCustomActionBar.GetItems 002b TCollection.GetCount 0047 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B D9 8B F2 8B E8 33 FF 85 F6 74 62 8B C5 E8 ?? ?? ?? ?? 84 C0 74 34 8B C6 E8 ?? ?? ?? ?? 50 8B C5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 5A 3B D0 7D 1A 8B C6 E8 ?? ?? ?? ?? 40 50 8B C5 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F8 EB 33 84 DB 74 2F 8B C5 8B 10 FF 92 20 01 00 00 48 7E 22 8B C5 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B F8 EB 10 84 DB 74 0C 8B C5 8B 10 FF 92 54 01 00 00 8B F8 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_985_0 {
	meta:
		name = "TCustomActionBar.FindPrevious"
		size = 124
		refs = "0013 TCollectionItem.GetIndex 0027 TCustomActionBar.GetItems 002d TActionClients.GetActionClient 004e TCollection.GetCount"
	strings:
		$1 = { 53 56 57 55 8B D9 8B EA 8B F0 33 FF 85 ED 74 55 8B C5 E8 ?? ?? ?? ?? 85 C0 7E 1A 8B C5 E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F8 EB 40 84 DB 74 3C 8B C6 8B 10 FF 92 20 01 00 00 48 7E 2F 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F8 EB 10 84 DB 74 0C 8B C6 8B 10 FF 92 F8 00 00 00 8B F8 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_986_0 {
	meta:
		name = "TCustomActionBar.GetActionControl"
		size = 49
		refs = "001b TCustomActionBar.GetItems 0022 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 7C 22 8B C3 8B 10 FF 92 20 01 00 00 3B F0 7D 14 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_987_0 {
	meta:
		name = "TCustomActionBar.GetBannerWidth"
		size = 111
		refs = "0026 TActionClient.GetBackground 002b TPicture.GetBitmap"
	strings:
		$1 = { 56 57 8B F0 33 C0 8B BE 68 02 00 00 85 FF 74 5C 80 EA 01 72 08 74 1F FE CA 74 34 EB 4F 80 7F 14 03 75 49 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 30 EB 36 80 7F 14 04 75 30 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 30 EB 1D 0F B6 57 14 80 C2 FD 80 EA 02 73 11 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 30 5F 5E C3 }
	condition:
		$1
}

rule function_989_0 {
	meta:
		name = "TCustomActionBar.GetItems"
		size = 44
		refs = "0018 TActionClient.GetContextItems 0023 TActionClient.GetItems"
	strings:
		$1 = { 33 D2 8B 88 68 02 00 00 85 C9 74 1D 80 B8 CC 02 00 00 00 74 0B 8B C1 E8 ?? ?? ?? ?? 8B D0 EB 09 8B C1 E8 ?? ?? ?? ?? 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_990_0 {
	meta:
		name = "TCustomActionBar.HasItems"
		size = 67
		refs = "0029 TCollection.GetCount 003c TActionClient.GetHasItems"
	strings:
		$1 = { 53 56 8B D8 33 C0 8B 93 68 02 00 00 85 D2 74 30 80 BB CC 02 00 00 00 74 20 8B 83 68 02 00 00 8B 70 1C 85 F6 74 0B 8B C6 E8 ?? ?? ?? ?? 85 C0 7F 04 33 C0 EB 0B B0 01 EB 07 8B C2 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_991_0 {
	meta:
		name = "TCustomActionBar.ItemCount"
		size = 41
		refs = "000f TCustomActionBar.HasItems 001a TCustomActionBar.GetItems 001f TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 83 BB 68 02 00 00 00 74 19 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_992_0 {
	meta:
		name = "TCustomActionBar.Loaded"
		size = 59
		refs = "0006 TControl.Loaded 0019 TCustomActionBar.SetActionManager 0029 TCustomActionBar.SetupDefaultColorMap"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 6C 02 00 00 85 C0 74 09 8B D0 8B C3 E8 ?? ?? ?? ?? 83 BB 78 02 00 00 00 75 13 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 38 01 00 00 5B C3 }
	condition:
		$1
}

rule function_993_0 {
	meta:
		name = "TCustomActionBar.Notification"
		size = 82
		refs = "0010 TWinControl.Notification"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? FE CB 75 36 3B BE 6C 02 00 00 75 14 8B C6 8B 10 FF 92 E4 00 00 00 33 C0 89 86 6C 02 00 00 EB 1A 3B BE 78 02 00 00 75 12 F6 46 1C 08 75 0C 33 D2 8B C6 8B 08 FF 91 38 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_994_0 {
	meta:
		name = "TCustomActionBar.Paint"
		size = 39
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 24 01 00 00 66 83 BB 9A 02 00 00 00 74 0E 8B D3 8B 83 9C 02 00 00 FF 93 98 02 00 00 5B C3 }
	condition:
		$1
}

rule function_995_0 {
	meta:
		name = "TCustomActionBar.PaintWindow"
		size = 169
		refs = "0014 TCanvas.Lock 001c TCustomActionBar.PaintWindow 0032 TCanvas.SetHandle 004e TControlCanvas.UpdateTextFlags 007c @HandleFinally 0099 TCanvas.Unlock"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 74 02 00 00 8B D3 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 28 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 33 D2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5B 59 5D C3 }
	condition:
		$1
}

rule function_996_0 {
	meta:
		name = "TCustomActionBar.SetActionClient"
		size = 124
		refs = "0046 TControl.SetColor 004d TActionClient.GetOwningCollection 0052 TActionClientsCollection.GetActionManager 005b TCustomActionBar.SetActionManager"
	strings:
		$1 = { 53 56 8B DA 8B F0 3B 9E 68 02 00 00 74 6B 8B C6 8B 10 FF 92 E4 00 00 00 8B C3 89 86 68 02 00 00 85 C0 75 0D 8B C6 8B 10 FF 92 80 00 00 00 5E 5B C3 8B 86 68 02 00 00 8B 40 24 3D 00 00 00 20 74 09 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 89 9E 68 02 00 00 8B C6 8B 10 FF 92 E0 00 00 00 8B C6 8B 10 FF 92 E8 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_997_0 {
	meta:
		name = "TCustomActionBar.SetDesignMode"
		size = 604
		refs = "0030 TCustomActionBar.GetItems 0043 TCustomActionBar.SetDesignMode 009a TCustomActionBar.GetAutoSizing 00b9 Point 012e TControl.SetHeight 013d TControl.SetWidth 0149 TCollection.GetCount 016b TActionClients.GetActionClient 018e TControl.SetVisible 01f0 ControlDragMode 021a TActionClientItem.GetAction"
	strings:
		$1 = { 56 57 55 83 C4 F4 8B F0 3A 96 7D 02 00 00 0F 84 3D 02 00 00 88 96 7D 02 00 00 F6 46 1C 10 0F 85 2D 02 00 00 83 BE 68 02 00 00 00 74 0D 8B C6 E8 ?? ?? ?? ?? 80 78 24 00 74 12 8B 86 68 02 00 00 0F B6 15 ?? ?? ?? ?? 3A 50 31 75 2F 80 BE 7D 02 00 00 00 74 18 8B C6 8B 10 FF 52 4C 88 86 7E 02 00 00 33 D2 8B C6 8B 08 FF 51 64 EB 0E 0F B6 96 7E 02 00 00 8B C6 8B 08 FF 51 64 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 48 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 0B 8B C6 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 86 D4 02 00 00 8D 4C 24 04 8B 56 4C 8B 46 48 E8 ?? ?? ?? ?? 8B 44 24 04 89 86 B8 02 00 00 8B 44 24 08 89 86 BC 02 00 00 8B C6 8B 10 FF 92 10 01 00 00 84 C0 75 09 80 BE D4 02 00 00 00 74 0E 8B C6 8B 10 FF 92 20 01 00 00 85 C0 7F 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 91 34 01 00 00 8B C6 8B 10 FF 92 10 01 00 00 84 C0 75 2D 0F B6 86 7F 02 00 00 2C 02 72 06 2C 02 72 11 EB 1C 8B 96 BC 02 00 00 8B C6 E8 ?? ?? ?? ?? EB 0D 8B 96 B8 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 4D 85 ED 0F 8C F9 00 00 00 45 C7 04 24 00 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 14 24 E8 ?? ?? ?? ?? 8B F8 8B 47 44 85 C0 0F 84 CB 00 00 00 80 BE 7D 02 00 00 00 74 79 80 78 57 00 75 07 B2 01 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 3A 47 31 74 12 8B 86 68 02 00 00 0F B6 15 ?? ?? ?? ?? 3A 50 31 75 04 33 D2 EB 02 B2 01 8B 47 44 8B 08 FF 51 64 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 0C 8B 86 68 02 00 00 F6 40 31 02 75 10 8B 86 68 02 00 00 F6 40 31 04 75 04 33 C0 EB 02 B0 01 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 47 44 8B 08 FF 51 60 EB 49 33 D2 8B 08 FF 51 60 0F B6 47 30 84 C0 75 0A 8B D0 8B 47 44 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 85 C0 74 0E 8B C7 E8 ?? ?? ?? ?? 8B 10 FF 52 44 EB 0A B2 01 8B 47 44 8B 08 FF 51 64 33 D2 8B 47 44 8B 08 FF 91 E4 00 00 00 FF 04 24 4D 0F 85 0F FF FF FF 83 C4 0C 5D 5F 5E C3 00 00 00 00 }
	condition:
		$1
}

rule function_998_0 {
	meta:
		name = "TCustomActionBar.SetOrientation"
		size = 146
		refs = "0030 TWinControl.DisableAlign 0038 TCustomActionBar.SetOrientation 0081 TWinControl.EnableAlign 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC 3A 90 7F 02 00 00 74 79 8B 45 FC 88 90 7F 02 00 00 8B 45 FC 8B 10 FF 92 20 01 00 00 85 C0 7E 61 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 20 01 00 00 8B D8 4B 85 DB 7C 1C 43 33 F6 8B D6 8B 45 FC 8B 08 FF 91 14 01 00 00 8B 10 FF 92 E8 00 00 00 46 4B 75 E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_999_0 {
	meta:
		name = "TCustomActionBar.SetSpacing"
		size = 20
		refs = "000f TWinControl.Realign"
	strings:
		$1 = { 3B 90 80 02 00 00 74 0B 89 90 80 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1000_0 {
	meta:
		name = "TCustomActionBar.SetActionManager"
		size = 59
		refs = "0017 TComponent.RemoveFreeNotification 0034 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 6C 02 00 00 3B F0 74 28 85 C0 74 11 8B D3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 E4 00 00 00 8B C6 89 83 6C 02 00 00 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1001_0 {
	meta:
		name = "TCustomActionBar.SetPersistentHotKeys"
		size = 20
		refs = "000f TControl.Refresh"
	strings:
		$1 = { 3A 90 A0 02 00 00 74 0B 88 90 A0 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21642_0 {
	meta:
		name = "TCustomGrid.SetScrollBars"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 A0 02 00 00 74 0B 88 90 A0 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1002_0 {
	meta:
		name = "TCustomActionBar.DoDropActions"
		size = 173
		refs = "001c Point 0026 TCustomActionBar.FindNearestControl 0031 TCustomActionBar.CalcInsertPosition 003b TActionDragObject.GetActionCount 0061 TActionClient.GetItems 0068 TCollection.Insert 0076 TActionDragObject.GetAction 0089 TActionClients.GetActionClient 008f TActionClientItem.SetAction 0097 TCollectionItem.GetIndex"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B D9 89 55 FC 8B F0 8B 7D 08 57 8D 4D EC 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B D0 8B CB 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 61 8B 45 FC E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 52 47 C7 45 F8 00 00 00 00 8B 86 68 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 89 45 F4 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 50 8B 86 68 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 43 FF 45 F8 4F 75 B6 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1003_0 {
	meta:
		name = "TCustomActionBar.DoDropCategory"
		size = 318
		refs = "001c Point 0027 TCustomActionBar.FindNearestControl 0033 TCustomActionBar.CalcInsertPosition 003d TCustomActionBar.GetItems 0044 TCollection.Insert 0050 TActionClientItem.SetCaption 0057 TActionDragObject.GetActionCount 0066 TCollectionItem.GetIndex 0075 TActionClients.GetActionClient 00aa TActionClient.GetItems 00b7 _DV_TActionClientItem 00bc @AsClass 00c8 TActionDragObject.GetAction 00d2 TActionClientItem.SetAction 00e3 TActionClientItem.SetLastSession 0104 TActionClientItem.GetAction 010f TActionClient.GetHasItems 011f TActionClients.VisibleCount"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B D9 8B FA 89 45 FC 8B 75 08 56 8D 4D EC 8B D6 8B C3 E8 ?? ?? ?? ?? 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B CB 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B F0 8B 57 50 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 D2 00 00 00 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 57 50 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 48 85 C0 7C 60 40 89 45 F8 33 DB 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 8B D3 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 45 F4 E8 ?? ?? ?? ?? 8B 47 40 8B 40 6C 8B 50 28 8B 45 F4 E8 ?? ?? ?? ?? 43 FF 4D F8 75 A6 8B 46 44 8B 10 FF 92 E8 00 00 00 B2 01 8B C6 8B 08 FF 51 2C 8B C6 E8 ?? ?? ?? ?? 85 C0 75 1F 8B C6 E8 ?? ?? ?? ?? 84 C0 74 10 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7F 04 33 D2 EB 02 B2 01 8B 46 44 8B 08 FF 51 64 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1004_0 {
	meta:
		name = "TCustomActionBar.FindPreviousVisibleItem"
		size = 51
	strings:
		$1 = { 53 56 8B F0 33 C9 8B C6 8B 18 FF 93 00 01 00 00 8B D8 EB 10 33 C9 8B D3 8B C6 8B 18 FF 93 00 01 00 00 8B D8 85 DB 74 06 80 7B 30 00 74 E6 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1005_0 {
	meta:
		name = "TCustomActionBar.SetBiDiMode"
		size = 83
		refs = "0013 TControl.SetBiDiMode"
	strings:
		$1 = { 53 56 51 8B DA 8B F0 0F B6 46 5F 88 04 24 8B D3 8B C6 E8 ?? ?? ?? ?? 3A 1C 24 74 33 0F B6 86 7F 02 00 00 04 FE 2C 02 72 26 80 EB 01 72 07 80 EB 03 72 10 EB 1A 33 D2 8B C6 8B 08 FF 91 40 01 00 00 EB 0C B2 01 8B C6 8B 08 FF 91 40 01 00 00 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1006_0 {
	meta:
		name = "TCustomActionBar.GetBarHeight"
		size = 180
	strings:
		$1 = { 53 56 8B D8 8B 73 4C 8B C3 8B 10 FF 92 20 01 00 00 85 C0 0F 84 96 00 00 00 0F B6 43 5B 04 FD 2C 03 0F 82 88 00 00 00 8B 83 AC 02 00 00 8B F0 03 F6 8B 93 A8 02 00 00 8B CA 49 0F AF F1 8B 8B C4 02 00 00 0F AF CA 03 C8 03 F1 03 F0 80 BB B4 02 00 00 00 74 14 83 BB A8 02 00 00 01 7E 0B 8B 83 A8 02 00 00 48 03 C0 03 F0 F6 83 60 02 00 00 02 74 1A 0F B6 83 61 02 00 00 48 2C 02 73 01 46 0F B6 83 62 02 00 00 48 2C 02 73 01 46 F6 83 60 02 00 00 08 74 1A 0F B6 83 61 02 00 00 48 2C 02 73 01 46 0F B6 83 62 02 00 00 48 2C 02 73 01 46 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1007_0 {
	meta:
		name = "TCustomActionBar.GetBarWidth"
		size = 201
		refs = "001c TCustomActionBar.GetAutoSizing"
	strings:
		$1 = { 53 56 8B D8 8B 73 48 8B C3 8B 10 FF 92 20 01 00 00 85 C0 0F 84 AB 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 9C 00 00 00 0F B6 43 5B 48 2C 02 0F 82 8F 00 00 00 2C 02 0F 84 87 00 00 00 8B 83 B0 02 00 00 8B F0 03 F6 8B 93 A4 02 00 00 8B CA 49 0F AF F1 8B 8B C8 02 00 00 0F AF CA 03 C8 03 F1 03 F0 80 BB C0 02 00 00 00 74 13 83 BB A4 02 00 00 01 7E 0A 8B 83 A4 02 00 00 03 C0 03 F0 F6 83 60 02 00 00 01 74 1A 0F B6 83 61 02 00 00 48 2C 02 73 01 46 0F B6 83 62 02 00 00 48 2C 02 73 01 46 F6 83 60 02 00 00 04 74 0D 0F B6 83 61 02 00 00 48 2C 02 73 01 46 0F B6 83 62 02 00 00 48 2C 02 73 01 46 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1008_0 {
	meta:
		name = "TCustomActionBar.GetDesignMode"
		size = 34
	strings:
		$1 = { 80 B8 7C 02 00 00 00 75 03 33 C0 C3 F6 40 1C 10 75 0D 80 B8 7D 02 00 00 00 75 04 33 C0 EB 02 B0 01 C3 }
	condition:
		$1
}

rule function_1009_0 {
	meta:
		name = "TCustomActionBar.SetHorzMargin"
		size = 37
		refs = "0014 TWinControl.Realign 001f @CallDynaInst"
	strings:
		$1 = { 56 8B F0 3B 96 B0 02 00 00 74 18 89 96 B0 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BE EE FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1010_0 {
	meta:
		name = "TCustomActionBar.SetVertMargin"
		size = 37
		refs = "0014 TWinControl.Realign 001f @CallDynaInst"
	strings:
		$1 = { 56 8B F0 3B 96 AC 02 00 00 74 18 89 96 AC 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BE EE FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1011_0 {
	meta:
		name = "TCustomActionBar.SetHorzSeparator"
		size = 37
		refs = "0014 TWinControl.Realign 001f @CallDynaInst"
		altNames = "TCustomActionBar.SetVertSeparator"
	strings:
		$1 = { 56 8B F0 3A 96 B4 02 00 00 74 18 88 96 B4 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 66 BE EE FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1013_0 {
	meta:
		name = "TCustomActionBar.CMResetBar"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 2C 01 00 00 C3 }
	condition:
		$1
}

rule function_1014_0 {
	meta:
		name = "TCustomActionBar.CMThemeChanged"
		size = 27
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 8B 08 FF 91 38 01 00 00 8B C3 8B 10 FF 92 58 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1015_0 {
	meta:
		name = "TCustomActionBar.CMSysFontChanged"
		size = 46
		refs = "0011 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 F6 43 1C 01 75 21 8B C3 66 BE EE FF E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 91 38 01 00 00 8B C3 8B 10 FF 92 58 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1016_0 {
	meta:
		name = "TCustomActionBar.Reset"
		size = 126
		refs = "0019 TWinControl.DisableAlign 002d TCustomActionBar.Reset 003b TCollectionItem.GetIndex 004b TCustomActionManager.ResetActionBar 006e TWinControl.EnableAlign 0074 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 83 B8 6C 02 00 00 00 74 65 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 68 02 00 00 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 80 6C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 8B 08 FF 91 30 01 00 00 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 59 59 5D C3 }
	condition:
		$1
}

rule function_1019_0 {
	meta:
		name = "TCustomActionBar.VisibleChanging"
		size = 127
		refs = "0012 TCustomActionBar.VisibleChanging 001f TControl.VisibleChanging 0040 SCannotHideActionBand 0045 LoadResString 004f _Dn_Exception 0054 Exception.CreateFmt 0059 @RaiseExcept 006e @UStrClr 0074 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 33 D2 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 80 BB 70 02 00 00 00 75 31 8B 43 08 89 45 F8 C6 45 FC 11 8D 45 F8 50 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1020_0 {
	meta:
		name = "TCustomActionBar.WMContextMenu"
		size = 148
		refs = "000c TWinControl.WMContextMenu 001d TActionClient.GetContextItems 0022 TCollection.GetCount 002d TCustomActionBar.GetPopupMenuClass 003b _Dn_TCustomActionPopupMenu 0040 @AsClass 004e Application 005d TWinControl.SetParentWindow 0085 TCustomActionPopupMenu.Popup 008c TObject.Free"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B D7 8B C3 E8 ?? ?? ?? ?? 8B B3 68 02 00 00 85 F6 74 76 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 66 8B C3 E8 ?? ?? ?? ?? 8B 4B 04 B2 01 FF 50 2C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 C6 86 CC 02 00 00 01 A1 ?? ?? ?? ?? 8B 00 8B 90 70 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 8B 08 FF 51 68 8B 93 68 02 00 00 8B C6 8B 08 FF 91 30 01 00 00 0F BF 4F 0A 0F BF 57 08 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1021_0 {
	meta:
		name = "TCustomActionBar.GetAutoSizing"
		size = 43
		refs = "000e _DV_TActionBarItem 0013 @IsClass"
	strings:
		$1 = { 53 56 8B D8 8B B3 68 02 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 80 7E 3C 00 75 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_1022_0 {
	meta:
		name = "TCustomActionBar.SetAutoSizing"
		size = 54
		refs = "0011 _DV_TActionBarItem 0016 @IsClass 0023 TActionBarItem.SetAutoSize 002e @CallDynaInst"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 8B B7 68 02 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C7 66 BE EE FF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1023_0 {
	meta:
		name = "TCustomActionBar.DoDropItem"
		size = 272
		refs = "001a Point 0024 TCustomActionBar.FindNearestControl 0043 TCustomActionBar.GetItems 0061 TControl.GetBoundsRect 0086 TCollectionItem.GetIndex 0092 TActionClientItem.GetActionClients 0097 TCollection.GetCount"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 89 4D FC 8B F2 8B F8 8D 4D F0 8B 55 08 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F0 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 46 48 8B 40 44 85 C0 74 08 3B C3 0F 84 CB 00 00 00 85 DB 75 16 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 46 48 8B 08 FF 51 10 E9 A4 00 00 00 33 C0 89 45 F8 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 8B 45 E8 3B 45 FC 7C 12 8D 55 D0 8B C3 E8 ?? ?? ?? ?? 8B 45 DC 3B 45 08 7D 29 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 50 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 5A 3B D0 7D 07 C7 45 F8 01 00 00 00 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 8B 45 E0 3B 45 FC 7F 12 8D 55 D0 8B C3 E8 ?? ?? ?? ?? 8B 45 D4 3B 45 08 7E 05 33 C0 89 45 F8 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 46 48 8B 08 FF 51 10 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 03 55 F8 8B 46 48 8B 08 FF 51 14 8B 56 48 8B C7 8B 08 FF 91 4C 01 00 00 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1024_0 {
	meta:
		name = "TCustomActionBar.RecreateControls"
		size = 104
		refs = "0012 TActionClient.GetItems 0017 TCollection.GetCount 0033 TActionClients.GetActionClient 003b TObject.Free"
	strings:
		$1 = { 53 56 57 8B D8 8B B3 68 02 00 00 85 F6 74 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 38 47 33 F6 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 E8 ?? ?? ?? ?? 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 33 D2 89 50 44 46 4F 75 CB 8B C3 8B 10 FF 92 E8 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1025_0 {
	meta:
		name = "TCustomActionBar.SetBounds"
		size = 179
		refs = "0017 TWinControl.GetAlignDisabled 0027 _DV_TActionBarItem 002c @IsClass 00a6 TWinControl.SetBounds"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D F8 89 55 FC 8B D8 8B 75 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 75 79 8B 83 68 02 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 64 0F B6 43 5B 48 2C 02 72 11 8B C3 8B 10 FF 52 50 84 C0 74 13 80 7B 5B 00 75 0D 8B C3 8B 10 FF 92 08 01 00 00 89 45 08 0F B6 43 5B 04 FD 2C 02 72 11 8B C3 8B 10 FF 52 50 84 C0 74 14 80 7B 5B 00 75 0E 8B C3 8B 10 FF 92 0C 01 00 00 8B F8 EB 02 8B FE 8B C3 8B 10 FF 52 50 84 C0 75 07 3B 7B 48 74 02 8B F7 56 8B 45 08 50 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1026_0 {
	meta:
		name = "TCustomActionBar.WMPaint"
		size = 60
		refs = "000f TCustomActionBar.WMPaint 0020 TWinControl.WMPaint"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 55 01 75 29 0F B7 05 ?? ?? ?? ?? 66 0B 43 54 66 89 43 54 8B D6 8B C3 E8 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? F7 D0 66 23 43 54 66 89 43 54 5E 5B C3 00 01 00 00 }
	condition:
		$1
}

rule function_1027_0 {
	meta:
		name = "TCustomActionBar.SetColorMap"
		size = 127
		refs = "0017 TCustomActionBarColorMap.Remove 002a TCustomActionBar.SetupDefaultColorMap 003d TCustomActionBarColorMap.Add 004d TControl.SetColor 005e TWinControl.HandleAllocated 0072 TWinControl.GetHandle 0078 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 78 02 00 00 3B F0 74 6C 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8B C6 89 83 78 02 00 00 85 C0 75 0D 8B C3 E8 ?? ?? ?? ?? 89 83 78 02 00 00 8B D3 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 8B 83 78 02 00 00 8B 50 40 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 80 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 16 6A 00 6A 01 68 85 00 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1028_0 {
	meta:
		name = "TCustomActionBar.GetDefaultColorMapClass"
		size = 22
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 5C 01 00 00 8B D3 8B 08 FF 51 04 5B C3 }
	condition:
		$1
}

rule function_1029_0 {
	meta:
		name = "TCustomActionBar.SetupDefaultColorMap"
		size = 140
		refs = "0013 TObject.Free 0031 TCustomActionBar.SetupDefaultColorMap 0045 TComponent.SetSubComponent 0052 TCustomActionBarColorMap.Add"
	strings:
		$1 = { 53 56 8B D8 8D 83 D0 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 18 01 00 00 8B CB B2 01 FF 50 2C 8B F0 89 B3 D0 02 00 00 BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 18 B2 01 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 D0 02 00 00 E8 ?? ?? ?? ?? 8B 83 D0 02 00 00 5E 5B C3 00 B0 04 02 00 FF FF FF FF 0F 00 00 00 44 00 65 00 66 00 61 00 75 00 6C 00 74 00 43 00 6F 00 6C 00 6F 00 72 00 4D 00 61 00 70 00 00 00 }
	condition:
		$1
}

rule function_1030_0 {
	meta:
		name = "TCustomActionBar.NCPaint"
		size = 1776
		refs = "0014 TCustomActionBar.NCPaint 004f TCustomActionBar.GetColorMap 00b6 GetHighLightColor 00ce GetShadowColor 02dc TWinControl.GetHandle 02e2 GetClientRect 02f4 GetWindowRect 030a MapWindowPoints 031c OffsetRect 0332 ExcludeClipRect 0352 TCanvas.GetHandle 0373 TCanvas.SetHandle 0389 TPen.SetWidth 03e7 TPen.SetColor 0407 TCanvas.MoveTo 041c TCanvas.LineTo 06dc @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 8B FA 89 45 FC 8B 45 FC 0F B6 15 ?? ?? ?? ?? 3A 90 60 02 00 00 0F 84 BE 06 00 00 8B 45 FC 0F B6 80 62 02 00 00 8B C8 8B 55 FC 0F B6 92 61 02 00 00 02 CA 03 C0 02 C8 8D 04 52 02 C8 80 E9 03 88 4D EF 8B 45 FC E8 ?? ?? ?? ?? 8B 58 40 8B 45 FC E8 ?? ?? ?? ?? 8B 70 40 0F B6 45 EF 83 F8 0B 0F 87 34 02 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F0 E9 FA 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 E9 C5 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? BA E2 FF FF FF E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA E7 FF FF FF E8 ?? ?? ?? ?? 89 45 F0 E9 58 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 E9 F5 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F0 E9 92 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 EB 32 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 40 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 58 40 8B 45 FC E8 ?? ?? ?? ?? 8B 70 40 8D 45 DC 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 45 CC 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 02 8D 45 CC 50 8B 45 FC E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 8B 4D D0 F7 D9 8B 55 CC F7 DA 8D 45 DC E8 ?? ?? ?? ?? 8B 45 E8 50 8B 45 E4 50 8B 45 E0 50 8B 45 DC 50 57 E8 ?? ?? ?? ?? 8B 4D D0 F7 D9 8B 55 CC F7 DA 8D 45 CC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 74 02 00 00 8B D7 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 8B 40 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 02 75 3E 8B 45 FC F6 80 60 02 00 00 01 0F 84 AB 00 00 00 8B 45 FC 0F B6 80 62 02 00 00 48 2C 02 72 1F 8B 45 FC 80 B8 62 02 00 00 00 0F 85 8C 00 00 00 8B 45 FC 0F B6 80 61 02 00 00 48 2C 02 73 7D 8B 45 FC 8B 80 74 02 00 00 8B 40 10 8B 55 F4 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 02 74 29 8B 45 FC 8B 80 74 02 00 00 8B 4D D0 8B 55 D4 E8 ?? ?? ?? ?? 8B 55 CC 4A 8B 45 FC 8B 80 74 02 00 00 8B 4D D0 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 01 74 28 8B 45 FC 8B 80 74 02 00 00 8B 4D D0 8B 55 CC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 8B 4D D8 8B 55 CC E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 02 75 36 8B 45 FC F6 80 60 02 00 00 01 0F 84 AB 00 00 00 8B 45 FC 0F B6 80 62 02 00 00 48 2C 02 0F 83 98 00 00 00 8B 45 FC 0F B6 80 61 02 00 00 48 2C 02 0F 83 85 00 00 00 8B 45 FC 8B 80 74 02 00 00 8B 40 10 8B D3 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 02 74 2C 8B 4D D0 41 8B 55 D4 4A 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 4D D0 41 8B 55 CC 42 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 01 74 2E 8B 4D D0 41 8B 55 CC 42 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 4D D8 83 E9 02 8B 55 CC 42 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 08 75 42 8B 45 FC F6 80 60 02 00 00 04 0F 84 B5 00 00 00 8B 45 FC 0F B6 80 62 02 00 00 48 2C 02 72 23 8B 45 FC 80 B8 62 02 00 00 00 0F 85 96 00 00 00 8B 45 FC 0F B6 80 61 02 00 00 48 2C 02 0F 83 83 00 00 00 8B 45 FC 8B 80 74 02 00 00 8B 40 10 8B 55 F0 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 04 74 2B 8B 55 D4 4A 8B 45 FC 8B 80 74 02 00 00 8B 4D D0 E8 ?? ?? ?? ?? 8B 4D D8 49 8B 55 D4 4A 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 08 74 2C 8B 4D D8 49 8B 55 D4 4A 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 4D D8 49 8B 55 CC 4A 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 08 75 36 8B 45 FC F6 80 60 02 00 00 04 0F 84 B4 00 00 00 8B 45 FC 0F B6 80 62 02 00 00 48 2C 02 0F 83 A1 00 00 00 8B 45 FC 0F B6 80 61 02 00 00 48 2C 02 0F 83 8E 00 00 00 8B 45 FC 8B 80 74 02 00 00 8B 40 10 8B D6 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 04 74 32 8B 4D D0 41 8B 55 D4 83 EA 02 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 4D D8 83 E9 02 8B 55 D4 83 EA 02 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 60 02 00 00 08 74 31 8B 4D D8 83 E9 02 8B 55 D4 83 EA 02 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 4D D8 83 E9 02 8B 45 FC 8B 80 74 02 00 00 8B 55 CC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 8B 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1031_0 {
	meta:
		name = "TCustomActionBar.CMWinINIChange"
		size = 24
		refs = "0006 TWinControl.CMWinIniChange 000d TCustomActionBar.GetColorMap"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 38 5E C3 }
	condition:
		$1
}

rule function_1033_0 {
	meta:
		name = "TCustomActionBar.GetColorMap"
		size = 42
		refs = "0011 TCustomActionBar.SetupDefaultColorMap 0021 TControl.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B B3 78 02 00 00 85 F6 75 0D 8B C3 E8 ?? ?? ?? ?? 8B B3 D0 02 00 00 8B 56 40 8B C3 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1034_0 {
	meta:
		name = "TCustomActionBar.CMMouseLeave"
		size = 66
		refs = "0009 TControl.CMMouseLeave 0039 TWinControl.Broadcast"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 10 01 00 00 84 C0 74 22 C7 04 24 11 B4 00 00 33 C0 89 44 24 04 33 C0 89 44 24 08 33 C0 89 44 24 0C 8B D4 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1035_0 {
	meta:
		name = "TCustomActionBar.DesignWndProc"
		size = 51
		refs = "0013 Mouse 001a TMouse.GetIsDragging"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 8B 06 2D 14 B0 00 00 75 1B A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 74 0B 8B D6 8B C7 8B 08 FF 51 EC B3 01 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1036_0 {
	meta:
		name = "TCustomActionBar.Style"
		size = 39
		refs = "001d ActionBarStyles 0022 TActionBarStyleList.GetStyle"
	strings:
		$1 = { 8B 90 6C 02 00 00 85 D2 74 10 83 BA E0 00 00 00 00 74 07 8B 82 E0 00 00 00 C3 33 D2 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1037_0 {
	meta:
		name = "TCustomActionControl.Create"
		size = 168
		refs = "0011 @ClassCreate 001e TGraphicControl.Create 0027 TCustomActionControl.Create 0036 TControl.SetHeight 0042 TControl.SetWidth 0052 TControl.SetParentShowHint 006c Rect 008d @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 BA 16 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 16 00 00 00 8B C6 E8 ?? ?? ?? ?? C6 86 B1 01 00 00 00 B2 01 8B C6 E8 ?? ?? ?? ?? 6A 04 8D 45 F0 50 B9 04 00 00 00 BA 04 00 00 00 B8 04 00 00 00 E8 ?? ?? ?? ?? 56 8D BE BC 01 00 00 8D 75 F0 A5 A5 A5 A5 5E C6 86 E4 01 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 8B E5 5D C3 04 00 00 00 }
	condition:
		$1
}

rule function_1038_0 {
	meta:
		name = "TCustomActionControl.Destroy"
		size = 57
		refs = "0003 @BeforeDestruction 0027 TGraphicControl.Destroy 0032 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 AC 01 00 00 85 C0 74 0A 3B 70 44 75 05 33 D2 89 50 44 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1039_0 {
	meta:
		name = "TCustomActionControl.BeginAutoDrag"
		size = 36
		refs = "0010 Mouse 001e TControl.BeginDrag"
	strings:
		$1 = { 53 8B D8 B2 01 8B C3 8B 08 FF 91 E4 00 00 00 A1 ?? ?? ?? ?? 8B 00 8B 48 08 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1040_0 {
	meta:
		name = "TCustomActionControl.CaptionLength"
		size = 72
		refs = "001d TCustomActionControl.HasGlyph 002c TActionClientItem.GetActionClients"
		altNames = "TRibbonBaseButtonControl.CaptionLength"
	strings:
		$1 = { 53 8B D8 83 BB AC 01 00 00 00 74 0E 8B C3 8B 10 FF 92 9C 00 00 00 84 C0 75 1C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 80 78 28 02 75 0E 8B 83 DC 01 00 00 2B 83 D4 01 00 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_1041_0 {
	meta:
		name = "TCustomActionControl.CaptionHeight"
		size = 72
		refs = "001d TCustomActionControl.HasGlyph 002c TActionClientItem.GetActionClients"
		altNames = "TRibbonBaseButtonControl.CaptionHeight"
	strings:
		$1 = { 53 8B D8 83 BB AC 01 00 00 00 74 0E 8B C3 8B 10 FF 92 9C 00 00 00 84 C0 75 1C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 80 78 28 02 75 0E 8B 83 E0 01 00 00 2B 83 D8 01 00 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_1042_0 {
	meta:
		name = "TCustomActionControl.ActualSpacing"
		size = 48
		refs = "0018 TCustomActionControl.CaptionLength"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8D 3C 24 A5 A5 8B D8 83 3C 24 00 74 0B 8B C3 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 06 8B 83 D0 01 00 00 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_47448_0 {
	meta:
		name = "TRibbonBaseButtonControl.ActualSpacing"
		size = 48
		refs = "0018 TRibbonBaseButtonControl.CaptionLength"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8D 3C 24 A5 A5 8B D8 83 3C 24 00 74 0B 8B C3 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 06 8B 83 D0 01 00 00 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1043_0 {
	meta:
		name = "TCustomActionControl.CalcLayout"
		size = 654
		refs = "0036 TCustomActionControl.UpdateTextBounds 0081 Point 009e TCustomActionControl.ActualSpacing 00b1 TCustomActionControl.CaptionHeight 00cf OffsetRect 01e0 TCustomActionControl.CaptionLength"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B D8 83 BB AC 01 00 00 00 0F 84 70 02 00 00 8B D4 8B C3 8B 08 FF 91 C0 00 00 00 8B 83 A0 01 00 00 8B 40 0C 8B 53 64 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 8B 73 48 8B 7B 4C 0F B6 83 B1 01 00 00 8B D0 80 EA 02 72 0E 80 EA 02 0F 82 EE 00 00 00 E9 2A 02 00 00 84 C0 75 78 8B D7 D1 FA 79 03 83 D2 00 8B 44 24 04 D1 F8 79 03 83 D0 00 2B D0 8D 4C 24 08 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 8B 44 24 08 89 83 B4 01 00 00 8B 44 24 0C 89 83 B8 01 00 00 8B D4 8B C3 E8 ?? ?? ?? ?? 8B 93 BC 01 00 00 03 14 24 03 C2 50 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B CF D1 F9 79 03 83 D1 00 2B C8 8D 83 D4 01 00 00 5A E8 ?? ?? ?? ?? E9 AE 01 00 00 8B D7 D1 FA 79 03 83 D2 00 8B 44 24 04 D1 F8 79 03 83 D0 00 2B D0 8D 4C 24 08 8B C6 2B 83 C4 01 00 00 2B 04 24 E8 ?? ?? ?? ?? 8B 44 24 08 89 83 B4 01 00 00 8B 44 24 0C 89 83 B8 01 00 00 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B CF D1 F9 79 03 83 D1 00 2B C8 8D 83 D4 01 00 00 8B 93 BC 01 00 00 E8 ?? ?? ?? ?? E9 41 01 00 00 3C 02 0F 85 C6 00 00 00 8B C3 8B 10 FF 92 9C 00 00 00 84 C0 74 3A 8B C6 D1 F8 79 03 83 D0 00 8B 14 24 D1 FA 79 03 83 D2 00 2B C2 8D 4C 24 08 8B 93 C0 01 00 00 E8 ?? ?? ?? ?? 8B 44 24 08 89 83 B4 01 00 00 8B 44 24 0C 89 83 B8 01 00 00 EB 48 8B D7 D1 FA 79 03 83 D2 00 8B 44 24 04 D1 F8 79 03 83 D0 00 2B D0 8B C6 D1 F8 79 03 83 D0 00 8B 0C 24 D1 F9 79 03 83 D1 00 2B C1 8D 4C 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 89 83 B4 01 00 00 8B 44 24 0C 89 83 B8 01 00 00 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B D6 D1 FA 79 03 83 D2 00 2B D0 8B 8B B8 01 00 00 03 4C 24 04 03 8B D0 01 00 00 8D 83 D4 01 00 00 E8 ?? ?? ?? ?? EB 73 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B FE D1 FF 79 03 83 D7 00 8B D7 2B D0 8D 83 D4 01 00 00 8B 8B C0 01 00 00 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? 8B E8 8B C3 E8 ?? ?? ?? ?? 03 83 D8 01 00 00 03 E8 8B D5 8B C7 8B 0C 24 D1 F9 79 03 83 D1 00 2B C1 8D 4C 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 89 83 B4 01 00 00 8B 44 24 0C 89 83 B8 01 00 00 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1044_0 {
	meta:
		name = "TCustomActionControl.CMFontChanged"
		size = 31
		refs = "0006 TControl.CMFontChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 83 BB AC 01 00 00 00 74 0A 8B C3 8B 10 FF 92 E8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1045_0 {
	meta:
		name = "TCustomActionControl.Click"
		size = 92
		refs = "0016 TCustomActionControl.GetActionBar 0029 TCustomActionControl.ResetUsageData"
	strings:
		$1 = { 53 8B D8 8B 83 AC 01 00 00 85 C0 74 4D 83 78 3C 00 74 47 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 84 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 10 8B 83 AC 01 00 00 8B 40 3C 8B D3 8B 08 FF 51 18 5B C3 }
	condition:
		$1
}

rule function_1046_0 {
	meta:
		name = "TCustomActionControl.DesignWndProc"
		size = 147
		refs = "006f TActionClientItem.GetAction 0085 ActionBarDesigner"
	strings:
		$1 = { 53 56 8B F0 33 C0 8B 0A 81 F9 04 02 00 00 7D 14 83 E9 7B 74 2C 81 C1 7B FE FF FF 83 E9 03 72 36 74 40 EB 6C 81 C1 FC FD FF FF 83 E9 02 72 12 81 C1 F3 51 FF FF 83 E9 02 72 1C 83 E9 1A 74 17 EB 4F 8B 96 AC 01 00 00 85 D2 74 45 83 7A 1C 00 74 3F B0 01 5E 5B C3 8B C6 8B 08 FF 51 EC B0 01 5E 5B C3 8B 9E AC 01 00 00 85 DB 74 22 8B C3 E8 ?? ?? ?? ?? 85 C0 74 17 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 A1 ?? ?? ?? ?? 8B 08 FF 51 10 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_1047_0 {
	meta:
		name = "TCustomActionControl.DrawBackground"
		size = 385
		refs = "001a TCustomActionControl.GetActionBar 003b TWinControl.GetParentBackground 0055 TActionClient.HasBackground 0093 ThemeServices 0098 TThemeServices.GetThemesEnabled 00ae TBrush.GetColor 00bc TCustomActionBar.GetColorMap 00d0 TControl.GetBoundsRect 00ea TCanvas.GetHandle 00f7 TWinControl.GetHandle 0104 TThemeServices.DrawParentBackground 0114 TFont.SetHandle 0135 TBrush.GetBitmap 015b BrushStyle 0169 TBrush.SetStyle 0176 TCanvas.FillRect"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8B D8 80 BB CC 01 00 00 00 0F 85 14 01 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 05 01 00 00 83 BB AC 01 00 00 00 0F 84 F8 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3C 01 0F 85 E4 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 35 8B C3 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 B4 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 0F B6 40 14 04 FD 2C 02 0F 82 99 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 87 00 00 00 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 8B F8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 78 40 75 66 F6 43 52 04 74 60 8B D4 8B C3 E8 ?? ?? ?? ?? 6A 00 0F B6 83 E4 01 00 00 50 8D 44 24 08 50 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A 59 E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 0C 33 D2 E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 0C 8B 53 64 8B 08 FF 51 08 EB 4F 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 85 C0 75 30 80 BB E4 01 00 00 00 74 09 80 BB CC 01 00 00 00 74 04 33 C0 EB 02 B0 01 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 8B D6 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1048_0 {
	meta:
		name = "TCustomActionControl.DrawGlyph"
		size = 131
		refs = "000b TCustomActionControl.HasGlyph 007a TCustomImageList.Draw"
	strings:
		$1 = { 53 56 57 51 8B FA 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 6B 8B 83 AC 01 00 00 8B 40 5C 50 8D 4C 24 04 33 D2 8B C3 8B 30 FF 96 C8 00 00 00 8B F0 85 F6 74 4B 80 3C 24 00 75 21 8B C3 8B 10 FF 52 4C 84 C0 74 0C 8B 83 AC 01 00 00 83 78 5C FF 75 0A F6 43 1C 10 75 04 33 C0 EB 02 B0 01 8B 57 04 52 8B 93 AC 01 00 00 8B 52 5C 52 6A 03 6A 00 50 8B 0F 8B 93 A0 01 00 00 8B C6 E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1049_0 {
	meta:
		name = "TCustomActionControl.DrawLargeGlyph"
		size = 844
		refs = "0015 TCustomActionControl.HasGlyph 002a _Dn_TCustomAction 002f @IsClass 0064 Point 006b _Dn_TBitmap 0070 TBitmap.Create 007b TCustomActionControl.DrawLargeGlyph 00bc TBitmap.GetCanvas 00c9 TBrush.SetColor 00e4 TCanvas.GetClipRect 0108 Rect 0120 TCanvas.CopyRect 0144 TCanvas.FillRect 015f TCanvas.GetHandle 0171 TCustomImageList.GetHandle 0177 ImageList_DrawEx 01b6 TCanvas.StretchDraw 01c3 TBitmap.SetTransparentColor 01ef TBrush.GetColor 0238 TCanvas.Draw 0254 TActionClientItem.GetParentItem 0259 TActionClient.HasBackground 02ca ImageStates 02f5 TBrush.GetHandle 0307 DrawState 031c TObject.Free 0322 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 8B F2 8D 7D F8 A5 A5 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 24 03 00 00 8B C6 8B 10 FF 52 3C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 0A 03 00 00 8B 86 AC 01 00 00 8B 40 5C 50 8D 4D E7 B2 01 8B C6 8B 18 FF 93 C8 00 00 00 8B D8 8D 4D E8 BA 20 00 00 00 B8 20 00 00 00 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 34 8B 45 F0 8B 08 FF 51 44 8B 53 30 8B 45 F0 8B 08 FF 51 38 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 BA FF FF FF 00 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 4C 84 C0 74 4E 8B 45 F0 E8 ?? ?? ?? ?? 8D 55 D4 E8 ?? ?? ?? ?? 8D 45 D4 50 8B 45 F0 8B 10 FF 52 24 50 8D 45 C4 50 8B 45 F0 8B 10 FF 52 30 8B C8 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 C4 50 8B 45 F0 E8 ?? ?? ?? ?? 8B 8E A0 01 00 00 5A E8 ?? ?? ?? ?? EB 22 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 D4 E8 ?? ?? ?? ?? 8D 45 D4 50 8B 45 F0 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 6A 01 6A FF 6A FF 6A 00 6A 00 6A 00 6A 00 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 86 AC 01 00 00 8B 40 5C 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 5D E8 8B D3 8B 45 F4 8B 08 FF 51 44 8B 7D EC 8B D7 8B 45 F4 8B 08 FF 51 38 57 8D 45 D4 50 8B CB 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 D4 50 8B 45 F4 E8 ?? ?? ?? ?? 8B 4D F0 5A E8 ?? ?? ?? ?? BA FF FF FF 00 8B 45 F4 E8 ?? ?? ?? ?? B2 01 8B 45 F4 8B 08 FF 51 40 8B D3 8B 45 F0 8B 08 FF 51 44 8B D7 8B 45 F0 8B 08 FF 51 38 8B 86 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 50 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 14 5A E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 55 D4 E8 ?? ?? ?? ?? 8D 45 D4 50 8B 45 F0 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 F4 50 8B 45 F0 E8 ?? ?? ?? ?? 33 C9 33 D2 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 4C 84 C0 75 06 F6 46 1C 10 74 76 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 31 8B 7D FC 8B C7 03 45 EC 50 8D 45 D4 50 8B 5D F8 8B CB 03 4D E8 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 D4 8B 86 A0 01 00 00 8B 4D F4 E8 ?? ?? ?? ?? EB 79 8B 7D FC 8B C7 03 45 EC 50 8D 45 D4 50 8B 5D F8 8B CB 03 4D E8 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 D4 8B 86 A0 01 00 00 8B 4D F0 E8 ?? ?? ?? ?? EB 48 0F B6 45 E7 8B 04 85 ?? ?? ?? ?? 83 C8 04 50 6A 00 6A 00 8B 45 FC 50 8B 45 F8 50 6A 00 8B 45 F4 8B 10 FF 52 70 50 6A 00 8B 86 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 50 8B 86 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1050_0 {
	meta:
		name = "TCustomActionControl.DrawSeparator"
		size = 556
		refs = "000d TCustomActionControl.GetActionBar 002e TControl.GetClientWidth 003f Point 0046 TControl.GetClientHeight 00ae TPen.SetWidth 00d3 TCanvas.FillRect 00e4 TActionClientItem.Unused 00f4 TCustomActionBar.GetColorMap 0101 GetShadowColor 010b TPen.SetColor 014b TCanvas.MoveTo 015a TCanvas.LineTo 01a0 GetHighLightColor"
	strings:
		$1 = { 53 56 57 83 C4 E0 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 0C 02 00 00 8B C3 E8 ?? ?? ?? ?? 0F B6 80 7F 02 00 00 2C 02 73 3D 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B CC 8B D6 4A E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 2B C6 40 50 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8D 4C 24 0C 5A E8 ?? ?? ?? ?? EB 37 8B C3 E8 ?? ?? ?? ?? 8B D0 D1 FA 79 03 83 D2 00 8B CC 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 D1 FA 79 03 83 D2 00 8D 4C 24 08 8B 43 48 2B C6 E8 ?? ?? ?? ?? 8B B3 A0 01 00 00 BA 01 00 00 00 8B 46 10 E8 ?? ?? ?? ?? 80 BB CC 01 00 00 00 74 1C F6 43 1C 10 74 16 8D 54 24 10 8B C3 8B 08 FF 51 44 8D 54 24 10 8B C6 E8 ?? ?? ?? ?? 8B BB AC 01 00 00 85 FF 74 30 8B C7 E8 ?? ?? ?? ?? 84 C0 74 25 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 6C BA CE FF FF FF E8 ?? ?? ?? ?? 8B D0 8B 46 10 E8 ?? ?? ?? ?? EB 30 8B 7B 6C 81 FF 0F 00 00 FF 75 0F BA 10 00 00 FF 8B 46 10 E8 ?? ?? ?? ?? EB 16 BA CE FF FF FF 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 46 10 E8 ?? ?? ?? ?? 8B 4C 24 04 8B 14 24 8B C6 E8 ?? ?? ?? ?? 8B 4C 24 0C 8B 54 24 08 8B C6 E8 ?? ?? ?? ?? 8B BB AC 01 00 00 85 FF 74 48 8B C7 E8 ?? ?? ?? ?? 84 C0 74 3D 81 7B 6C 0F 00 00 FF 75 0F BA 14 00 00 FF 8B 46 10 E8 ?? ?? ?? ?? EB 54 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 6C BA 13 00 00 00 E8 ?? ?? ?? ?? 8B D0 8B 46 10 E8 ?? ?? ?? ?? EB 2F 81 7B 6C 0F 00 00 FF 75 0F BA 14 00 00 FF 8B 46 10 E8 ?? ?? ?? ?? EB 17 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 6C 8B 46 10 E8 ?? ?? ?? ?? 8B 5C 24 08 8B 04 24 3B D8 75 1F 8B D8 43 8B D3 8B 4C 24 04 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 4C 24 0C 8B C6 E8 ?? ?? ?? ?? EB 1C 8B 4C 24 04 41 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 4C 24 0C 41 8B D3 8B C6 E8 ?? ?? ?? ?? 83 C4 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1051_0 {
	meta:
		name = "TCustomActionControl.DrawText"
		size = 156
		refs = "0015 @UStrAddRef 001d TCustomActionControl.DrawText 002e TCanvas.GetHandle 004d @InternalUStrFromLStr 006b @UStrToPWChar 0072 DrawText 0087 @UStrClr 008d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D F8 89 55 FC 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 08 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 08 8B 55 08 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 7D F8 8B 3F 57 8B 45 FC 50 53 8B 45 08 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1052_0 {
	meta:
		name = "TCustomActionControl.DrawShadowedText"
		size = 303
		refs = "001b @UStrAddRef 0023 TCustomActionControl.DrawShadowedText 003b OffsetRect 004c TFont.SetColor 0057 TCanvas.GetHandle 0076 @InternalUStrFromLStr 0092 @UStrToPWChar 0099 DrawText 011a @UStrClr 0120 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B F2 8D 7D EC A5 A5 A5 A5 89 4D FC 8B D8 8B 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 0C 8B 55 08 E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 10 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 10 8B 55 10 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 8B 45 FC 50 8D 45 EC 50 56 8B 45 10 E8 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 8D 45 EC 83 C9 FF 83 CA FF E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 0C 8B 55 0C E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 10 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 10 8B 55 10 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 8B 45 FC 50 8D 45 EC 50 56 8B 45 10 E8 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1053_0 {
	meta:
		name = "TCustomActionControl.IsGrouped"
		size = 46
		refs = "000c _Dn_TCustomAction 0011 @IsClass"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 52 3C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B C3 8B 10 FF 52 3C 83 78 6C 00 7F 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_1054_0 {
	meta:
		name = "TCustomActionControl.Paint"
		size = 947
		refs = "0017 TCustomActionControl.Paint 003b BrushStyle 0049 TBrush.SetStyle 009f TBrush.SetColor 00a8 TCustomActionControl.GetActionBar 00ad TCustomActionBar.GetColorMap 00f9 TCustomActionBar.HasItems 0109 TCustomActionBar.GetItems 0146 TCustomActionControl.HasGlyph 0157 TControl.DrawTextBiDiModeFlags 0199 TFont.SetColor 019e ThemeServices 01a3 TThemeServices.GetThemesEnabled 0274 TControl.GetText 0313 OffsetRect 0346 TPen.SetColor 0359 TPen.SetWidth 035e Mouse 0365 TMouse.GetIsDragging 0386 TCustomActionControl.DrawDragDropPoint 03a0 @UStrArrayClr 03a6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 33 D2 89 55 D4 89 55 D8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 8B 08 FF 51 44 F6 43 1C 10 74 1E 0F B6 83 E4 01 00 00 0F B6 90 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? EB 30 80 BB E4 01 00 00 00 74 09 80 BB CC 01 00 00 00 74 04 33 C0 EB 02 B0 01 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 85 C0 74 1C 81 78 24 00 00 00 20 74 13 8B 50 24 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 40 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 8D 55 EC 8B C3 8B 08 FF 91 B0 00 00 00 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 74 14 BA 02 00 00 00 8B C3 8B 08 FF 91 BC 00 00 00 E9 DB 01 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 34 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 78 29 00 74 12 8D 93 B4 01 00 00 8B C3 8B 08 FF 91 A8 00 00 00 EB 10 8D 93 B4 01 00 00 8B C3 8B 08 FF 91 AC 00 00 00 8B C3 8B 10 FF 92 9C 00 00 00 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 85 7A 01 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 0D 00 01 00 00 89 45 FC 8D B3 D4 01 00 00 8D 7D DC A5 A5 A5 A5 8B 83 A0 01 00 00 8B 40 14 B2 01 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 50 8B 83 A0 01 00 00 8B 40 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B 83 A0 01 00 00 8B 40 0C 8B 53 64 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 6D 8B C3 8B 10 FF 52 4C 84 C0 75 14 8B C3 8B 10 FF 52 4C 84 C0 75 57 80 BB CC 01 00 00 00 74 4E 80 BB CC 01 00 00 00 74 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 64 8B 83 A0 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 4C 84 C0 75 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 48 8B 83 A0 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 1F 8B C3 8B 10 FF 52 4C 84 C0 75 14 8B C3 8B 10 FF 52 4C 84 C0 75 29 80 BB CC 01 00 00 00 74 20 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 45 D8 50 8D 4D FC 8D 55 DC 8B C3 8B 30 FF 96 B4 00 00 00 EB 3E 8D 55 D4 8B C3 E8 ?? ?? ?? ?? 8B 45 D4 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 48 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 4C 50 8B 4D FC 8D 55 DC 8B C3 8B 30 FF 96 B8 00 00 00 80 BB CC 01 00 00 00 0F 84 A1 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 92 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 74 7F 8D 55 EC 8B C3 8B 08 FF 51 44 8D 45 EC B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? FF 4D F4 FF 4D F8 8B 83 A0 01 00 00 8B 40 14 B2 01 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 70 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 8B 83 A0 01 00 00 8B 40 10 BA 02 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 75 0D 8D 55 EC 8B C3 8B 08 FF 91 A4 00 00 00 80 BB B0 01 00 00 00 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1055_0 {
	meta:
		name = "TAdapterNamedField.GetDisplayWidth"
		size = 6
		altNames = "TBaseAdapterAction.GetIteratorIndex TControl.DoMarginChange TCustomActionControl.PositionChanged TDBXDateValue.GetAsDate TDBXValue.GetAsDate"
	strings:
		$1 = { 8B 10 FF 52 58 C3 }
	condition:
		$1
}

rule function_1057_0 {
	meta:
		name = "TCustomActionControl.SetTransparent"
		size = 64
		refs = "0016 TCustomActionControl.SetTransparent"
	strings:
		$1 = { 53 8B D8 3A 93 E4 01 00 00 74 2E 88 93 E4 01 00 00 84 D2 74 0F A1 ?? ?? ?? ?? F7 D0 23 43 50 89 43 50 EB 0B A1 ?? ?? ?? ?? 0B 43 50 89 43 50 8B C3 8B 10 FF 92 80 00 00 00 5B C3 00 40 00 00 00 }
	condition:
		$1
}

rule function_1058_0 {
	meta:
		name = "TCustomActionControl.FindImageList"
		size = 281
		refs = "0017 TActionClient.GetOwningCollection 001c TActionClientsCollection.GetActionManager 0072 TActionClientItem.GetAction 00c3 TCustomActionControl.GetActionBar 00dc TCustomImageList.GetCount"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B D8 84 D2 74 45 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B0 9C 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B8 A4 00 00 00 85 FF 75 71 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 78 38 EB 5C 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B0 84 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 24 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 83 78 5C 00 74 13 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B 40 5C 8B 78 38 EB 13 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 78 38 8B C3 8B 10 FF 52 4C 84 C0 75 29 85 F6 74 25 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 12 83 7D 08 FF 7C 0C 8B C6 E8 ?? ?? ?? ?? 3B 45 08 7F 24 85 FF 74 16 83 7D 08 FF 7C 10 8B C7 E8 ?? ?? ?? ?? 3B 45 08 7E 04 8B C7 EB 02 33 C0 8B 55 FC C6 02 00 EB 08 8B C6 8B 55 FC C6 02 01 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1059_0 {
	meta:
		name = "TCustomActionControl.FindImageList"
		size = 28
	strings:
		$1 = { 53 56 57 51 8B F9 8B F0 57 8D 4C 24 04 8B C6 8B 18 FF 93 C8 00 00 00 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1060_0 {
	meta:
		name = "TCustomActionControl.GetImageSize"
		size = 307
		refs = "000d Point 0014 TCustomActionControl.HasGlyph 0037 TActionClientItem.GetActionClients 004c TActionClientItem.GetAction 00ab TActionClient.GetOwningCollection 00b0 TActionClientsCollection.GetActionManager"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 33 D2 33 C0 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 10 01 00 00 8B 83 AC 01 00 00 80 78 65 00 0F 84 00 01 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 80 78 29 00 0F 84 97 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 50 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 83 78 5C 00 0F 84 C7 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B 40 5C 83 78 38 00 0F 84 AF 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B 40 5C 8B 58 38 8B CE 8B 53 30 8B 43 34 E8 ?? ?? ?? ?? E9 8C 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 78 38 00 74 76 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 58 38 8B CE 8B 53 30 8B 43 34 E8 ?? ?? ?? ?? EB 54 8B CE BA 20 00 00 00 B8 20 00 00 00 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 A4 00 00 00 00 74 2A 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 A4 00 00 00 8B 50 30 3B 56 04 7E 03 89 56 04 8B 50 34 3B 16 7E 02 89 16 5E 5B C3 }
	condition:
		$1
}

rule function_1061_0 {
	meta:
		name = "TCustomActionControl.SetActionClient"
		size = 240
		refs = "000f TCustomActionControl.SetActionClient 002e TActionClient.SetActionBar 006f TCustomActionControl.SetTransparent 0078 TControl.SetParentColor 00a0 TControl.SetColor 00ab TControl.SetVisible 00b9 TActionClientItem.GetCaption 00c3 TControl.SetText 00d8 @UStrClr 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 AC 01 00 00 3B F0 0F 84 A0 00 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 89 B3 AC 01 00 00 8B C3 8B 10 FF 52 3C 85 C0 74 0B A1 ?? ?? ?? ?? 0B 43 50 89 43 50 85 F6 74 75 8B 83 AC 01 00 00 8B 40 24 8B D0 81 EA FF FF FF 1F 74 05 4A 74 16 EB 1F B2 01 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? EB 26 B2 01 8B C3 E8 ?? ?? ?? ?? EB 1B 3D 00 00 00 20 75 0B B2 01 8B C3 E8 ?? ?? ?? ?? EB 09 8B D0 8B C3 E8 ?? ?? ?? ?? 0F B6 56 30 8B C3 E8 ?? ?? ?? ?? 8D 55 FC 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 00 80 00 00 }
	condition:
		$1
}

rule function_1062_0 {
	meta:
		name = "TCustomActionControl.SetSelected"
		size = 206
		refs = "000f TCustomActionControl.SetSelected 0032 TCustomActionControl.UpdateSelection 004b TActionClientItem.GetAction 0065 GetLongHint 006d Application 0074 TApplication.SetHint 0082 TApplication.CancelHint 0091 TCollectionItem.GetIndex 009d TWinControl.GetHandle 00a8 NotifyWinEvent 00bd @UStrClr 00c3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 9E CC 01 00 00 0F 84 87 00 00 00 88 9E CC 01 00 00 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 80 00 00 00 84 DB 74 42 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 27 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B 40 7C 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? EB 0C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 DB 74 22 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 40 50 6A FC 8B 46 30 E8 ?? ?? ?? ?? 50 68 05 80 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1063_0 {
	meta:
		name = "TCustomActionControl.UpdateSelection"
		size = 48
		refs = "0028 TWinControl.Broadcast"
	strings:
		$1 = { 83 C4 F0 8B 50 30 85 D2 74 22 C7 04 24 02 B4 00 00 33 C9 89 4C 24 04 89 44 24 08 33 C9 89 4C 24 0C 8B CC 8B C2 8B D1 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_1064_0 {
	meta:
		name = "TCustomActionControl.CMItemSelected"
		size = 75
		refs = "0022 TCustomActionControl.GetActionBar 0031 ActionBarDesigner"
	strings:
		$1 = { 56 57 8B FA 8B F0 3B 77 08 0F 94 C2 8B C6 8B 08 FF 91 E4 00 00 00 80 BE CC 01 00 00 00 74 29 8B C6 E8 ?? ?? ?? ?? 80 B8 7C 02 00 00 00 74 19 83 3D ?? ?? ?? ?? 00 74 10 8B 96 AC 01 00 00 A1 ?? ?? ?? ?? 8B 08 FF 51 20 5F 5E C3 }
	condition:
		$1
}

rule function_1065_0 {
	meta:
		name = "TCustomActionControl.SetMargins"
		size = 87
	strings:
		$1 = { 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 A5 A5 8B 14 24 3B 90 BC 01 00 00 75 24 8B 54 24 04 3B 90 C8 01 00 00 75 18 8B 54 24 08 3B 90 C4 01 00 00 75 0C 8B 54 24 0C 3B 90 C8 01 00 00 74 14 8B F4 8D B8 BC 01 00 00 A5 A5 A5 A5 8B 10 FF 92 E8 00 00 00 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_1066_0 {
	meta:
		name = "TCustomActionControl.SetSpacing"
		size = 56
		refs = "0014 TCustomActionControl.GetActionBar 0024 TWinControl.GetAlignDisabled"
	strings:
		$1 = { 53 8B D8 3B 93 D0 01 00 00 74 2B 89 93 D0 01 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 1A 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0A 8B C3 8B 10 FF 92 E8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1067_0 {
	meta:
		name = "TCustomActionControl.SetGlyphLayout"
		size = 88
		refs = "0022 Rect"
	strings:
		$1 = { 53 56 83 C4 E8 8B DA 8B F0 3A 9E B1 01 00 00 74 41 8B 46 4C 50 8D 44 24 0C 50 8B 4E 48 33 D2 33 C0 E8 ?? ?? ?? ?? 33 C0 89 04 24 33 C0 89 44 24 04 88 9E B1 01 00 00 8B C6 8B 10 FF 92 E8 00 00 00 8B C6 8B 10 FF 52 58 8B C6 8B 10 FF 92 80 00 00 00 83 C4 18 5E 5B C3 }
	condition:
		$1
}

rule function_1068_0 {
	meta:
		name = "TCustomActionControl.Keyed"
		size = 42
		refs = "0007 TCustomActionControl.ResetUsageData 001d TWinControl.GetHandle 0023 PostMessage"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 73 30 85 F6 74 15 53 6A 00 68 04 B4 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1069_0 {
	meta:
		name = "TChartGalleryPanel.WMGetDlgCode"
		size = 8
		altNames = "TControl.CMHitTest TCustomActionControl.CMDesignHitTest TCustomRibbon.WMEraseBkgnd TCustomRibbon.WMGetDlgCode TCustomTeeNavigator.WMGetDlgCode TDBCtrlGrid.WMEraseBkgnd TDBCtrlPanel.WMEraseBkgnd TDBNavigator.WMGetDlgCode TMediaPlayer.WMGetDlgCode TPopupGrid.CMHintShow TRibbonSpinButton.WMGetDlgCode TSpinButton.WMGetDlgCode TTabbedNotebook.WMGetDlgCode"
	strings:
		$1 = { C7 42 0C 01 00 00 00 C3 }
	condition:
		$1
}

rule function_1070_0 {
	meta:
		name = "TCustomActionControl.CMHintShow"
		size = 54
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B B3 AC 01 00 00 85 F6 74 1F 83 7E 3C 00 74 19 8B 7D 08 8D 57 38 8B 46 3C 8B 08 FF 51 78 84 C0 75 07 C7 45 0C 01 00 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1071_0 {
	meta:
		name = "TCustomActionControl.DrawDesignFocus"
		size = 12
		refs = "0007 TCanvas.Rectangle"
	strings:
		$1 = { 8B 80 A0 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1783_0 {
	meta:
		name = "TCustomADODataSet.GetCommandTimeout"
		size = 12
		refs = "0007 TADOCommand.GetCommandTimeOut"
	strings:
		$1 = { 8B 80 A0 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1784_0 {
	meta:
		name = "TCustomADODataSet.SetCommandTimeout"
		size = 12
		refs = "0007 TADOCommand.SetCommandTimeOut"
	strings:
		$1 = { 8B 80 A0 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1072_0 {
	meta:
		name = "TCustomActionControl.ResetUsageData"
		size = 95
		refs = "000d TCustomActionControl.GetActionBar 0035 TActionClient.GetHasItems 0058 TActionClientItem.ResetUsageData"
	strings:
		$1 = { 53 56 8B D8 F6 43 1C 10 75 52 8B C3 E8 ?? ?? ?? ?? 85 C0 74 13 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 34 8B B3 AC 01 00 00 85 F6 74 2A 8B C6 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C3 8B 10 FF 52 4C 84 C0 74 14 83 BB AC 01 00 00 00 74 0B 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1073_0 {
	meta:
		name = "TCustomActionControl.DragDrop"
		size = 52
		refs = "0017 TControl.DragDrop"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 45 08 50 8B CF 8B D6 8B C3 8B 18 FF 93 98 00 00 00 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1074_0 {
	meta:
		name = "TCustomActionControl.DragOver"
		size = 428
		refs = "0023 TControl.DragOver 0033 TCustomActionControl.GetActionBar 0044 _DV_TActionDragObject 0049 @IsClass 0055 _DV_TActionItemDragObject 0066 _DV_TCategoryDragObject 00b6 TActionClient.IsChildItem 011b TCustomActionBar.FindNextVisibleItem 0140 TCustomActionBar.FindPreviousVisibleItem 01a0 TCustomActionControl.SetDropPoint"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 08 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 83 BB AC 01 00 00 00 74 43 8B C3 E8 ?? ?? ?? ?? 80 B8 7C 02 00 00 00 74 33 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 26 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 15 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 07 80 3F 00 74 3E 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2D 83 7E 48 00 0F 95 C0 34 01 88 07 80 3F 00 75 1D 8B 46 48 3B 83 AC 01 00 00 74 12 8B 56 48 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 34 01 88 07 80 3F 00 0F 84 DD 00 00 00 0F B6 45 0C 84 C0 74 08 2C 02 0F 85 CD 00 00 00 33 F6 8B C3 E8 ?? ?? ?? ?? 0F B6 80 7F 02 00 00 2C 01 72 0F 74 36 FE C8 74 57 FE C8 74 78 E9 96 00 00 00 8B 43 48 D1 F8 79 03 83 D0 00 3B 45 FC 0F 8D 83 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 93 AC 01 00 00 E8 ?? ?? ?? ?? 8B F0 EB 6D 8B 43 48 D1 F8 79 03 83 D0 00 3B 45 FC 7E 5E 8B C3 E8 ?? ?? ?? ?? 8B 93 AC 01 00 00 E8 ?? ?? ?? ?? 8B F0 EB 48 8B 43 4C D1 F8 79 03 83 D0 00 3B 45 10 7D 39 8B C3 E8 ?? ?? ?? ?? 8B 93 AC 01 00 00 E8 ?? ?? ?? ?? 8B F0 EB 23 8B 43 4C D1 F8 79 03 83 D0 00 3B 45 10 7E 14 8B C3 E8 ?? ?? ?? ?? 8B 93 AC 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 75 06 8B B3 AC 01 00 00 8B 46 44 B2 01 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1075_0 {
	meta:
		name = "TCustomActionControl.DrawDragDropPoint"
		size = 301
		refs = "000f TBrush.SetStyle 0016 TCustomActionControl.GetActionBar 001b TCustomActionBar.GetColorMap 002c TPen.SetColor 005f TCanvas.GetHandle 0065 PatBlt 0071 TControl.GetClientHeight 00e7 TControl.GetClientWidth"
	strings:
		$1 = { 53 8B D8 8B 83 A0 01 00 00 8B 40 14 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 70 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 0F B6 80 7F 02 00 00 2C 02 72 09 2C 02 72 79 E9 E0 00 00 00 68 49 00 5A 00 6A 02 6A 06 6A 00 6A 00 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 8B C3 E8 ?? ?? ?? ?? 83 E8 04 50 6A 02 6A 02 6A 02 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 8B C3 E8 ?? ?? ?? ?? 50 6A 06 8B C3 E8 ?? ?? ?? ?? 83 E8 02 50 6A 00 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 68 49 00 5A 00 6A 06 6A 02 6A 00 6A 00 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 6A 02 8B C3 E8 ?? ?? ?? ?? 83 E8 06 50 6A 02 6A 02 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 6A 06 6A 02 6A 00 8B C3 E8 ?? ?? ?? ?? 83 E8 04 50 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1076_0 {
	meta:
		name = "TCustomActionControl.DoStartDrag"
		size = 64
		refs = "0009 _DV_TActionItemDragObject 000e TObject.Create 0026 TActionClientItem.GetActionClients 002b TActionClientsCollection.GetActionManager 0039 TControl.DoStartDrag"
	strings:
		$1 = { 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 06 8B 06 8B 93 AC 01 00 00 89 50 48 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 16 89 42 40 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1077_0 {
	meta:
		name = "TCustomActionControl.HasGlyph"
		size = 49
	strings:
		$1 = { 53 8B D8 33 C0 83 BB AC 01 00 00 00 74 21 8B 83 AC 01 00 00 8B 10 FF 52 34 84 C0 74 0C 8B 83 AC 01 00 00 80 78 65 00 75 04 33 C0 EB 02 B0 01 5B C3 }
	condition:
		$1
}

rule function_1078_0 {
	meta:
		name = "TCustomActionControl.WMSetText"
		size = 31
		refs = "0019 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 8B C6 8B 08 FF 51 F0 8B 86 A8 01 00 00 85 C0 74 09 66 BE D0 FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1079_0 {
	meta:
		name = "TCustomActionControl.GetSeparator"
		size = 19
	strings:
		$1 = { 33 D2 8B 88 AC 01 00 00 85 C9 74 04 0F B6 51 54 8B C2 C3 }
	condition:
		$1
}

rule function_1080_0 {
	meta:
		name = "TCustomActionControl.GetShowCaption"
		size = 64
		refs = "0014 TActionClientItem.GetActionClients"
	strings:
		$1 = { 53 56 57 8B F0 B3 01 8B BE AC 01 00 00 85 FF 74 29 8B C7 E8 ?? ?? ?? ?? 0F B6 40 28 2C 01 72 08 74 0A FE C8 74 12 EB 12 33 DB EB 0E 8B 86 AC 01 00 00 0F B6 58 55 EB 02 B3 01 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1081_0 {
	meta:
		name = "TCustomActionControl.GetShowShortCut"
		size = 41
	strings:
		$1 = { 33 D2 83 B8 AC 01 00 00 00 74 1B 8B 90 AC 01 00 00 80 7A 56 00 74 07 66 83 7A 4C 00 75 04 33 C0 EB 02 B0 01 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_1082_0 {
	meta:
		name = "TCustomActionControl.IsChecked"
		size = 60
		refs = "0014 TActionClientItem.GetAction 001a _Dn_TCustomAction 001f @IsClass"
	strings:
		$1 = { 53 56 57 8B F8 33 DB 8B B7 AC 01 00 00 85 F6 74 25 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B 87 AC 01 00 00 E8 ?? ?? ?? ?? 0F B6 58 69 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1083_0 {
	meta:
		name = "TCustomActionControl.GetAction"
		size = 21
		refs = "000d TActionClientItem.GetAction"
	strings:
		$1 = { 8B 90 AC 01 00 00 85 D2 74 08 8B C2 E8 ?? ?? ?? ?? C3 33 C0 C3 }
	condition:
		$1
}

rule function_1084_0 {
	meta:
		name = "TCustomActionControl.InitiateAction"
		size = 24
	strings:
		$1 = { 56 57 8B F0 8B BE AC 01 00 00 85 FF 74 07 8B C7 8B 10 FF 52 38 5F 5E C3 }
	condition:
		$1
}

rule function_1085_0 {
	meta:
		name = "TCustomActionControl.GetActionBar"
		size = 19
		refs = "0008 _DV_TCustomActionBar 000d @AsClass"
	strings:
		$1 = { 53 8B D8 8B 43 30 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1086_0 {
	meta:
		name = "TCustomActionControl.CMTextChanged"
		size = 33
		refs = "000d TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 8B C6 8B 08 FF 51 F0 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0A 8B C6 8B 10 FF 92 E8 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1087_0 {
	meta:
		name = "TCustomActionControl.UpdateTextBounds"
		size = 242
		refs = "0017 TCustomActionControl.UpdateTextBounds 002e Rect 004f TCanvas.GetHandle 005f TActionClientItem.GetCaption 007d @UStrToPWChar 0084 DrawText 009d TControl.GetText 00d7 @UStrClr 00e5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 D2 89 55 E4 89 55 EC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8D 45 F0 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 75 F0 8D BB D4 01 00 00 A5 A5 A5 A5 83 BB AC 01 00 00 00 74 42 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B F0 8D 55 EC 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B 7D EC 8D 83 D4 01 00 00 8B D8 68 00 04 00 00 53 6A FF 89 7D E8 8B 45 E8 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? EB 3C 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B F0 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 7D E4 8D 83 D4 01 00 00 8B D8 68 00 04 00 00 53 6A FF 89 7D E8 8B 45 E8 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1088_0 {
	meta:
		name = "TCustomActionControl.CalcBounds"
		size = 270
		refs = "0035 TCustomActionControl.UpdateTextBounds 005a TCustomActionControl.ActualSpacing 006e TCustomActionControl.CaptionLength 007d TCustomActionControl.CaptionHeight"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F0 83 BE AC 01 00 00 00 0F 84 F3 00 00 00 8B D4 8B C6 8B 08 FF 91 C0 00 00 00 8B 86 A0 01 00 00 8B 40 0C 8B 56 64 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 8B 5E 48 8B 46 4C 0F B6 96 B1 01 00 00 80 EA 02 72 0A 80 EA 02 72 49 E9 86 00 00 00 8B D4 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 86 BC 01 00 00 03 04 24 03 D8 8B C6 E8 ?? ?? ?? ?? 03 D8 03 9E C4 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 54 24 04 3B C2 7D 02 8B C2 03 86 C0 01 00 00 03 86 C8 01 00 00 EB 42 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 86 BC 01 00 00 03 04 24 03 D8 03 9E C4 01 00 00 8B D4 8B C6 E8 ?? ?? ?? ?? 8B F8 8B 86 C0 01 00 00 03 44 24 04 03 F8 8B C6 E8 ?? ?? ?? ?? 03 F8 8B C7 03 86 C8 01 00 00 3B 5E 48 75 05 3B 46 4C 74 23 53 50 8B 4E 44 8B 56 40 8B C6 8B 18 FF 93 88 00 00 00 8B C6 8B 10 FF 92 94 00 00 00 8B C6 8B 10 FF 52 58 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1089_0 {
	meta:
		name = "TCustomActionControl.DoDragDrop"
		size = 615
		refs = "0024 TActionClientItem.GetActionClients 0029 TCollection.GetCount 0048 TActionClients.GetActionClient 0081 _DV_TActionDragObject 0086 @IsClass 0096 TCustomActionControl.GetActionBar 009b TWinControl.DisableAlign 00a8 TCustomActionBar.GetItems 00b5 TCustomActionControl.DoDragDrop 00c9 @AsClass 00d4 TActionDragObject.GetActionCount 00f3 TCollection.Insert 0110 TActionClientItem.SetLastSession 011a TActionDragObject.GetAction 0123 TActionClientItem.SetAction 015d TWinControl.EnableAlign 0163 @HandleFinally 016e _DV_TActionItemDragObject 01dd TCollectionItem.GetIndex 0216 ActionBarDesigner 0236 NotifyDesigner 025a TWinControl.Broadcast"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 89 55 F8 89 45 FC 33 C0 89 45 F4 8B 45 FC 8B 98 AC 01 00 00 85 DB 74 5B 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 48 46 33 DB 8B 45 FC 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 83 78 44 00 74 26 8B 45 FC 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 80 B8 B0 01 00 00 00 74 05 89 5D F4 EB 04 43 4E 75 BB 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D7 00 00 00 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 56 46 33 DB 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 E8 ?? ?? ?? ?? 8B F8 8B 45 FC E8 ?? ?? ?? ?? 8B 80 6C 02 00 00 8B 40 6C 8B 50 28 8B C7 E8 ?? ?? ?? ?? 8B D3 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B 55 F4 8B C7 8B 08 FF 51 14 43 4E 75 AD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 24 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D9 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 AE 00 00 00 8B 45 FC 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 8B 5D F8 8B 53 48 3B 42 04 74 41 8B 45 FC 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 43 48 8B 08 FF 51 10 8B 43 48 8B 55 F4 8B 08 FF 51 14 8B 45 FC E8 ?? ?? ?? ?? 8B 80 6C 02 00 00 8B 40 6C 8B 50 28 8B 43 48 E8 ?? ?? ?? ?? EB 54 8B 43 48 E8 ?? ?? ?? ?? 8B F0 8B 45 FC 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 3B F0 7D 03 FF 4D F4 8B 43 48 8B 55 F4 8B 08 FF 51 14 8B 45 FC E8 ?? ?? ?? ?? 80 B8 7C 02 00 00 00 74 19 83 3D ?? ?? ?? ?? 00 74 10 8B 45 F8 8B 50 48 A1 ?? ?? ?? ?? 8B 08 FF 51 20 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E0 11 B4 00 00 33 C0 89 45 E4 33 C0 89 45 E8 33 C0 89 45 EC 8D 55 E0 8B 45 FC 8B 40 30 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1090_0 {
	meta:
		name = "TCustomActionControl.SetSmallIcon"
		size = 36
	strings:
		$1 = { 56 8B F0 3A 96 CD 01 00 00 74 17 88 96 CD 01 00 00 8B C6 8B 10 FF 92 E8 00 00 00 8B C6 8B 10 FF 52 58 5E C3 }
	condition:
		$1
}

rule function_1091_0 {
	meta:
		name = "TCustomActionControl.WMContextMenu"
		size = 134
		refs = "000c TControl.WMContextMenu 001d TActionClient.GetContextItems 0022 TCollection.GetCount 002d TCustomActionControl.GetActionBar 0032 TCustomActionBar.GetPopupMenuClass 0040 _Dn_TCustomActionPopupMenu 0045 @AsClass 0077 TCustomActionPopupMenu.Popup 007e TObject.Free"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B D7 8B C3 E8 ?? ?? ?? ?? 8B B3 AC 01 00 00 85 F6 74 68 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 58 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4B 04 B2 01 FF 50 2C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 C6 86 CC 02 00 00 01 8B 53 30 8B C6 8B 08 FF 51 68 8B 93 AC 01 00 00 8B C6 8B 08 FF 91 30 01 00 00 0F BF 4F 0A 0F BF 57 08 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1092_0 {
	meta:
		name = "TCustomActionControl.SetDropPoint"
		size = 78
		refs = "003b TWinControl.Broadcast"
	strings:
		$1 = { 53 83 C4 F0 8B D8 3A 93 B0 01 00 00 74 3B 88 93 B0 01 00 00 84 D2 74 27 83 7B 30 00 74 21 C7 04 24 11 B4 00 00 33 C0 89 44 24 04 89 5C 24 08 33 C0 89 44 24 0C 8B D4 8B 43 30 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 80 00 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1093_0 {
	meta:
		name = "TCustomActionControl.CMItemDropPoint"
		size = 22
		refs = "0011 TCustomActionControl.SetDropPoint"
	strings:
		$1 = { 3B 42 08 74 10 80 B8 B0 01 00 00 00 74 07 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1094_0 {
	meta:
		name = "TActionBarStyleList.GetStyle"
		size = 124
		refs = "000c TActionBarStyleList.GetStyle 0018 ActionBarStyles 0023 SActionBarStyleMissing 0028 LoadResString 0032 _Dn_Exception 0037 Exception.Create 003c @RaiseExcept 004e _DV_TActionBarStyle 0053 @AsClass 006a @UStrClr 0070 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1095_0 {
	meta:
		name = "TCheckBoxProperties.Assign"
		size = 41
		refs = "000b TCommandProperties.Assign 0013 _DV_TCheckBoxProperties 0018 @IsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 46 18 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_1096_0 {
	meta:
		name = "TCheckBoxProperties.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCommandProperties.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_3367_0 {
	meta:
		name = "TBaseButtonItem.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13122_0 {
	meta:
		name = "TDBXByteArrayValue.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_41416_0 {
	meta:
		name = "TListControlItem.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1097_0 {
	meta:
		name = "TCheckBoxProperties.DoSetWidth"
		size = 31
		refs = "0006 TCommandProperties.GetControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 E8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1098_0 {
	meta:
		name = "TCheckBoxProperties.SetWidth"
		size = 14
	strings:
		$1 = { 3B 50 18 74 08 89 50 18 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1099_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_13 001a cDefaultSchedule 001f @UStrClr 0024 ActionBarDesigner 0029 @IntfClear 002e DefaultActnBarStyle 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1884_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_31 001a GlobalMalloc 001f @IntfClear 002e SIsAutoInc 0033 @WStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_3891_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_62 001a ColorPalettes 001f FreeAndNil 0024 TeeSeriesTypes 002e TeeToolTypes 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_25690_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_4 001a IETF_ATEXT 001f @UStrClr 0024 IETF_ATEXT_SPACE 002e IETF_QUOTABLE 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_50194_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_3 001a EOL 001f @LStrClr 002e EMPTY_STR 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1100_0 {
	meta:
		name = "ActnMan"
		size = 88
		refs = "0007 ActnMan 0013 _DV_13 001d ActionBarStyles 0023 _Dn_TControl 0028 _DV_TCustomActionBarColorMap 002d GroupDescendentsWith 0038 _DV_TActionClient 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 27 33 C0 A3 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1104_0 {
	meta:
		name = "GetShadow"
		size = 76
		refs = "0016 CheckWin32Version 002d SystemParametersInfo"
	strings:
		$1 = { 53 51 8B D8 C7 04 24 FF FF FF FF BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 24 6A 00 8D 44 24 04 50 6A 00 68 24 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 0D 83 3C 24 01 1B C0 40 88 83 94 03 00 00 0F B6 83 94 03 00 00 5A 5B C3 }
	condition:
		$1
}

rule function_1105_0 {
	meta:
		name = "TMenuStack.Create"
		size = 60
		refs = "000b @ClassCreate 001a TOrderedList.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_51053_0 {
	meta:
		name = "TConnectionData.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_14513_0 {
	meta:
		name = "TDBXCommandHandler.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_20747_0 {
	meta:
		name = "TGIFExtensionList.Create"
		size = 60
		refs = "000b @ClassCreate 001a TGIFList.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_20897_0 {
	meta:
		name = "TGIFImageList.Create"
		size = 60
		refs = "000b @ClassCreate 001a TGIFList.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1106_0 {
	meta:
		name = "TGIFList.GetItem"
		size = 19
		refs = "000c TList.Get"
		altNames = "TMenuStack.GetBars TNotifyList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14786_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetCatalogName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetCatalogName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14792_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetForeignKeyName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetForeignKeyName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14788_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetSchemaName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetSchemaName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14790_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetTableName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14798_0 {
	meta:
		name = "TDBXMetaDataIndex.GetCatalogName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetCatalogName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14804_0 {
	meta:
		name = "TDBXMetaDataIndex.GetIndexName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetIndexName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14800_0 {
	meta:
		name = "TDBXMetaDataIndex.GetSchemaName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetSchemaName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14802_0 {
	meta:
		name = "TDBXMetaDataIndex.GetTableName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14852_0 {
	meta:
		name = "TDBXMetaDataTable.GetCatalogName"
		size = 19
		refs = "000c TDBXTablesTableStorage.GetCatalogName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14854_0 {
	meta:
		name = "TDBXMetaDataTable.GetSchemaName"
		size = 19
		refs = "000c TDBXTablesTableStorage.GetSchemaName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14856_0 {
	meta:
		name = "TDBXMetaDataTable.GetTableName"
		size = 19
		refs = "000c TDBXTablesTableStorage.GetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25513_0 {
	meta:
		name = "TIdDNTreeNode.GetNode"
		size = 19
		refs = "000c TIdObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25501_0 {
	meta:
		name = "TIdMWayTreeNode.GetTreeNode"
		size = 19
		refs = "000c TIdObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10030_0 {
	meta:
		name = "TLocateParamsList.GetItem"
		size = 19
		refs = "000c TObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60631_0 {
	meta:
		name = "TScriptEnginesList.GetItem"
		size = 19
		refs = "000c TObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60621_0 {
	meta:
		name = "TScriptObjectFactories.GetFactory"
		size = 19
		refs = "000c TObjectList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2348_0 {
	meta:
		name = "TWebDispatch.GetPathInfo"
		size = 19
		refs = "000c TWebPathInfo.GetPathInfo"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1108_0 {
	meta:
		name = "TMenuStack.Pop"
		size = 160
		refs = "0020 TObject.Free 0053 TOrderedList.Count 005f _DV_TCustomActionPopupMenu 0064 @IsClass 006f TMenuStack.Peek 0084 @AsClass"
	strings:
		$1 = { 53 51 8B D8 8B C3 8B 10 FF 52 04 89 04 24 8B 43 08 F6 40 1C 10 74 0F 8B 04 24 33 D2 89 14 24 E8 ?? ?? ?? ?? EB 74 8B 04 24 8B 80 68 02 00 00 85 C0 74 67 33 D2 89 50 18 8B 04 24 33 D2 89 90 64 03 00 00 33 D2 8B 04 24 8B 08 FF 91 30 01 00 00 8B C3 E8 ?? ?? ?? ?? 48 75 33 8B 43 08 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 21 8B C3 E8 ?? ?? ?? ?? 05 5C 03 00 00 50 8B 44 24 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 89 02 EB 0D 8B 04 24 33 D2 89 14 24 E8 ?? ?? ?? ?? 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_1109_0 {
	meta:
		name = "TMenuStack.Push"
		size = 5
		altNames = "TSiteModuleHelper.FindVariable"
	strings:
		$1 = { 8B 08 FF 11 C3 }
	condition:
		$1
}

rule function_1111_0 {
	meta:
		name = "TInternalMDIAction.Destroy"
		size = 52
		refs = "0003 @BeforeDestruction 0016 TObject.Free 0022 TCustomAction.Destroy 002d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 A8 00 00 00 85 C0 74 05 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1112_0 {
	meta:
		name = "TInternalMDIAction.ExecuteTarget"
		size = 148
		refs = "0023 TWinControl.GetHandle 003a GetParent 0040 SendMessage 004d TCustomForm.Close 008e ShowWindow"
	strings:
		$1 = { 53 8B D8 0F B6 83 B0 00 00 00 2C 01 72 0C 74 36 FE C8 74 3F FE C8 74 67 EB 78 6A 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 68 22 02 00 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 5B C3 6A 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 68 23 02 00 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 6A 06 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1114_0 {
	meta:
		name = "TInternalMDIAction.UpdateTarget"
		size = 8
		refs = "0003 TCustomAction.SetEnabled"
		altNames = "TSendMail.UpdateTarget"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_48146_0 {
	meta:
		name = "TAbstractSocket.Open"
		size = 8
		refs = "0003 TAbstractSocket.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19695_0 {
	meta:
		name = "TApplication.NormalizeAllTopMosts"
		size = 8
		refs = "0003 TApplication.DoNormalizeTopMosts"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_54090_0 {
	meta:
		name = "TChartPen.Show"
		size = 8
		refs = "0003 TChartPen.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1224_0 {
	meta:
		name = "TCustomAddRemoveItem.SetEnabled"
		size = 8
		refs = "0003 TControl.SetEnabled"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_9886_0 {
	meta:
		name = "TCustomDataSetAdapter.RestoreDefaultAdapterMode"
		size = 8
		refs = "0003 TCustomDataSetAdapter.SetInDefaultMode"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_47336_0 {
	meta:
		name = "TCustomRibbonGroup.SetAutoSizing"
		size = 8
		refs = "0003 TCustomActionBar.SetAutoSizing"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57047_0 {
	meta:
		name = "TCustomTeePanel.PrintLandscape"
		size = 8
		refs = "0003 TCustomTeePanel.PrintOrientation"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19155_0 {
	meta:
		name = "TFieldEditForm.UpButtonClick"
		size = 8
		refs = "0003 TFieldEditForm.MoveDstSelected"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_55631_0 {
	meta:
		name = "TFiltersEditor.ImageResize"
		size = 8
		refs = "0003 TFiltersEditor.Preview"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17091_0 {
	meta:
		name = "TForm1.PoolTraceConnectButtonClick"
		size = 8
		refs = "0003 TForm1.OpenConnections"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17090_0 {
	meta:
		name = "TForm1.PooledBenchButtonClick"
		size = 8
		refs = "0003 TForm1.ConnectDisConnect"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23734_0 {
	meta:
		name = "TIBQuery.Prepare"
		size = 8
		refs = "0003 TIBQuery.SetPrepared"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24129_0 {
	meta:
		name = "TIBSQL.Close"
		size = 8
		refs = "0003 TIBSQL.InternalClose"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24139_0 {
	meta:
		name = "TIBSQL.FreeHandle"
		size = 8
		refs = "0003 TIBSQL.InternalFreeHandle"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24294_0 {
	meta:
		name = "TIBStoredProc.Prepare"
		size = 8
		refs = "0003 TIBStoredProc.SetPrepared"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24077_0 {
	meta:
		name = "TIBXSQLVAR.Clear"
		size = 8
		refs = "0003 TIBXSQLVAR.SetIsNull"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_45827_0 {
	meta:
		name = "TOutlineNode.Expand"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12147_0 {
	meta:
		name = "TQuery.CreateHandle"
		size = 8
		refs = "0003 TQuery.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4435_0 {
	meta:
		name = "TReader.ReadListBegin"
		size = 8
		refs = "0003 TReader.CheckValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_56797_0 {
	meta:
		name = "TSeriesGroup.Hide"
		size = 8
		refs = "0003 TSeriesGroup.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11715_0 {
	meta:
		name = "TSession.Open"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12094_0 {
	meta:
		name = "TStoredProc.CreateHandle"
		size = 8
		refs = "0003 TStoredProc.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_57124_0 {
	meta:
		name = "TTeeCustomShapeBrushPen.Show"
		size = 8
		refs = "0003 TTeeCustomShapeBrushPen.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_47796_0 {
	meta:
		name = "TTimerSpeedButton.CMMouseenter"
		size = 8
		refs = "0003 TTimerSpeedButton.SetMouseInControl"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5345_0 {
	meta:
		name = "TTreeNode.GetDropTarget"
		size = 8
		refs = "0003 TTreeNode.GetState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4503_0 {
	meta:
		name = "TWriter.WriteListBegin"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_58723_0 {
	meta:
		name = "VarIsArray"
		size = 8
		refs = "0003 VarIsArray"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1115_0 {
	meta:
		name = "UpdateMDIMenuButtons"
		size = 205
		refs = "0012 GetParent 001f FindControl 0027 MenuList 0042 TMenuList.GetMenu 0049 GetParentForm 0062 _DV_TCustomActionMainMenuBar 0067 @IsClass 0082 _Dn_TForm 0092 TCustomForm.get_MDIChildCount 00a6 TCustomActionMainMenuBar.MDIChildRestored 00b9 TCustomActionMainMenuBar.GetActiveMDIChild"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 08 8B 40 10 8B 40 0C 50 E8 ?? ?? ?? ?? 85 C0 0F 84 A9 00 00 00 E8 ?? ?? ?? ?? 89 45 FC A1 ?? ?? ?? ?? 8B 78 08 4F 85 FF 0F 8C 90 00 00 00 47 33 DB 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B F0 3B 75 FC 75 6B 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 50 8B 45 08 8B 40 10 81 78 08 21 02 00 00 75 2E 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C6 E8 ?? ?? ?? ?? 48 75 13 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1B 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 08 43 4F 0F 85 73 FF FF FF 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1116_0 {
	meta:
		name = "CallWindowHook"
		size = 153
		refs = "0030 UpdateMDIMenuButtons 0038 ActiveMenu 003e _DV_TCustomActionPopupMenu 0043 @IsClass 0073 UpdateActnMenusProc 008a MenuCallWndHook 0090 CallNextHookEx"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 85 DB 75 75 8B 45 10 8B 40 08 83 F8 1A 7F 0C 74 59 83 E8 05 74 11 48 74 17 EB 5E 2D 21 02 00 00 74 05 83 E8 08 75 52 55 E8 ?? ?? ?? ?? 59 EB 49 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 83 3D ?? ?? ?? ?? 00 74 2C A1 ?? ?? ?? ?? 80 B8 80 03 00 00 00 75 1E A1 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 EB 0F 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? 8B 45 10 50 8B 45 0C 50 53 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_1117_0 {
	meta:
		name = "AddMenuToList"
		size = 62
		refs = "0005 MenuList 000f _DV_TMenuList 0014 TObject.Create 0029 TList.IndexOf 0038 TList.Add"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 DB 74 1B 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 75 0C 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1118_0 {
	meta:
		name = "RemoveMenuFromList"
		size = 51
		refs = "0002 MenuList 0011 TList.Remove 002e TObject.Free"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 29 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 78 08 00 75 12 A1 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1119_0 {
	meta:
		name = "TMenuList.Notify"
		size = 100
		refs = "0014 GetCurrentThreadId 001c CallWindowHook 0024 SetWindowsHookEx 0029 MenuCallWndHook 004a UnhookWindowsHookEx 005c TList.Notify"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 84 DB 75 22 83 7E 08 01 75 1C E8 ?? ?? ?? ?? 50 6A 00 B8 ?? ?? ?? ?? 50 6A 04 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 26 80 FB 02 75 21 83 7E 08 00 75 1B 83 3D ?? ?? ?? ?? 00 74 12 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1120_0 {
	meta:
		name = "TCustomActionMenuBar.Create"
		size = 202
		refs = "000e @ClassCreate 001c TCustomActionDockBar.Create 002c TToolWindow.SetEdgeOuter 004b AddMenuToList 0068 Screen 0081 _Dn_TTimer 0086 TTimer.Create 0097 TTimer.SetEnabled 009d TCustomActionMenuBar.ActionIdleTimerProc 00a8 TTimer.SetOnTimer 00b5 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 FD 02 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? C7 86 28 03 00 00 A0 0F 00 00 C6 86 30 03 00 00 01 C6 86 FC 02 00 00 01 8B C6 E8 ?? ?? ?? ?? C7 86 40 03 00 00 96 00 00 00 C6 86 58 03 00 00 01 C6 86 59 03 00 00 01 A1 ?? ?? ?? ?? 8B 00 8B 90 80 00 00 00 8B 46 64 8B 08 FF 51 08 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E F8 02 00 00 8B C3 33 D2 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8B 86 F8 02 00 00 E8 ?? ?? ?? ?? 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1121_0 {
	meta:
		name = "TCustomActionMenuBar.Destroy"
		size = 92
		refs = "0003 @BeforeDestruction 000e RemoveMenuFromList 0033 TObject.Free 004a TCustomActionBar.Destroy 0055 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 86 14 03 00 00 85 C0 74 08 33 D2 89 90 64 03 00 00 8D 86 5C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 86 F8 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1122_0 {
	meta:
		name = "DefaultSystemAnimation"
		size = 319
		refs = "0018 SystemParametersInfo 001d AnimateWindowProc 0081 HideShow 009f TWinControl.GetHandle 00c4 TControl.GetBoundsRect 00d5 TControl.ClientToScreen 0105 UnfoldAnimationStyle"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 6A 00 8B 45 08 83 C0 FC 50 6A 00 68 02 10 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 0F 84 10 01 00 00 8B 45 08 8B 40 F8 8B 80 14 03 00 00 80 B8 FC 02 00 00 00 75 0D 8B 45 08 80 78 F7 00 0F 85 EE 00 00 00 8B 45 08 83 78 FC 00 0F 84 E1 00 00 00 6A 00 8B 45 08 83 C0 FC 50 6A 00 68 12 10 00 00 E8 ?? ?? ?? ?? 8B 45 08 83 78 FC 00 74 3B 8B 45 08 0F B6 40 F7 8B 04 85 ?? ?? ?? ?? 0D 00 00 08 00 50 8B 45 08 8B 40 F8 8B 80 40 03 00 00 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF D0 E9 88 00 00 00 8D 55 E8 8B 45 08 8B 40 F8 8B 98 18 03 00 00 8B C3 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F8 8B 45 08 8B 43 30 E8 ?? ?? ?? ?? 8B 45 08 8B 55 F8 89 50 EC 8B 55 FC 89 50 F0 8B 45 08 8B 40 F8 8B 40 44 8B 55 08 8B 52 F0 83 EA 05 3B C2 0F 9C C0 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 08 0F B6 52 F7 0B 04 95 ?? ?? ?? ?? 50 8B 45 08 8B 40 F8 8B 80 40 03 00 00 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF D0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1123_0 {
	meta:
		name = "DoAnimation"
		size = 322
		refs = "0017 AnimateWindowProc 0050 Point 005d TControl.ClientToScreen 0094 _DV_TCustomMenuItem 0099 @IsClass 00d7 TControl.GetBoundsRect 011c HideShow 012d TWinControl.GetHandle"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B F0 8D 7D F8 A5 A5 8B 7D 08 83 C7 F8 A1 ?? ?? ?? ?? 83 38 00 74 11 8B 07 8B 80 14 03 00 00 80 B8 FC 02 00 00 00 75 0D 8B 45 08 80 78 F7 00 0F 85 FD 00 00 00 8D 4D E8 8B 07 8B 98 18 03 00 00 8B 53 44 8B 43 40 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F0 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 55 F0 89 50 EC 8B 55 F4 89 50 F0 8B 07 80 B8 FD 02 00 00 03 75 0D 8B 45 08 80 78 F7 00 0F 84 B3 00 00 00 8B 07 8B 98 18 03 00 00 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 30 8B 53 44 8B 07 8B 80 18 03 00 00 8B 70 30 03 56 44 8B 43 40 03 46 40 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 8B 55 F0 89 50 EC 8B 55 F4 89 50 F0 EB 27 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8D 55 D8 8D 4D F0 8B 43 30 E8 ?? ?? ?? ?? 8B 45 08 8B 55 F0 89 50 EC 8B 55 F4 89 50 F0 8B 45 08 8B 40 F0 8B 17 8B 52 44 83 C2 02 3B C2 0F 9F C0 83 E0 7F 8B 44 85 F8 8B 55 08 0F B6 52 F7 0B 04 95 ?? ?? ?? ?? 50 8B 07 8B 80 40 03 00 00 50 8B 07 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF D0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1124_0 {
	meta:
		name = "TCustomActionMenuBar.Animate"
		size = 176
		refs = "004f DefaultSystemAnimation 0058 UnfoldAnimationStyle 005d DoAnimation 007c SlideAnimationStyle 00a2 FadeAnimationStyle"
	strings:
		$1 = { 55 8B EC 83 C4 EC 88 55 F7 89 45 F8 8B 45 F8 8B 10 FF 92 10 01 00 00 84 C0 0F 85 8D 00 00 00 8B 45 F8 8B 80 2C 03 00 00 80 B8 0B 03 00 00 00 75 7B 8B 45 F8 0F B6 80 FD 02 00 00 FE C8 74 0E FE C8 74 13 FE C8 74 1D FE C8 74 55 EB 5F 55 E8 ?? ?? ?? ?? 59 EB 56 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 48 8B 45 F8 83 B8 40 03 00 00 64 7E 22 8B 45 F8 83 A8 40 03 00 00 64 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 F8 83 80 40 03 00 00 64 EB 1A 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 0C 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B E5 5D C3 }
	condition:
		$1
}

rule function_1125_0 {
	meta:
		name = "TCustomActionMenuBar.CleanupStack"
		size = 52
		refs = "0011 TMenuStack.Peek"
	strings:
		$1 = { 53 56 8B D8 8B B3 74 03 00 00 85 F6 74 23 8B C6 E8 ?? ?? ?? ?? 80 B8 0A 03 00 00 00 75 13 8B 83 74 03 00 00 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1126_0 {
	meta:
		name = "TCustomActionMenuBar.ClearSubMenus"
		size = 65
		refs = "001d TOrderedList.Count 002f TMenuStack.Peek"
	strings:
		$1 = { 53 56 8B F0 80 BE 0A 03 00 00 00 74 31 83 BE 74 03 00 00 00 74 28 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7E 16 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 4B 75 EA 5E 5B C3 }
	condition:
		$1
}

rule function_1127_0 {
	meta:
		name = "TCustomActionMenuBar.CloseMenu"
		size = 149
		refs = "001a TCustomActionMenuBar.SetMouseControl 0050 TMenuStack.Peek 0068 TCustomActionMenuBar.GetSelected 008d TMenuStack.Pop"
	strings:
		$1 = { 53 56 57 8B F0 8B 86 2C 03 00 00 85 C0 74 0F 33 D2 89 90 00 03 00 00 33 D2 E8 ?? ?? ?? ?? 8B 86 14 03 00 00 85 C0 74 07 C6 80 FC 02 00 00 00 C6 86 0A 03 00 00 00 8B 9E 2C 03 00 00 85 DB 74 51 83 BB 74 03 00 00 00 74 48 8B 83 74 03 00 00 E8 ?? ?? ?? ?? 8B BE 2C 03 00 00 3B C7 75 28 C6 86 0A 03 00 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 74 21 8B C6 E8 ?? ?? ?? ?? 8B 40 44 33 D2 8B 08 FF 91 E4 00 00 00 EB 0B 8B 87 74 03 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1128_0 {
	meta:
		name = "TCustomActionMenuBar.CMItemClicked"
		size = 50
		refs = "001b TWinControl.GetHandle 0021 PostMessage"
		altNames = "TCustomActionMenuBar.CMItemKeyed"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 BB 0A 03 00 00 00 75 20 8B 46 08 50 6A 00 8B 06 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 B0 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1129_0 {
	meta:
		name = "TCustomActionMenuBar.CMEnterMenuLoop"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 B0 01 00 00 C3 }
	condition:
		$1
}

rule function_1131_0 {
	meta:
		name = "TCustomActionMenuBar.CreateControl"
		size = 112
		refs = "0007 TCustomActionBar.CreateControl 0012 TControl.SetShowHint 001b TActionClientItem.SetShowCaption 003b TActionClientItem.GetAction 0046 TActionClient.GetHasItems 0051 TActionClient.GetItems 0056 TActionClients.VisibleCount"
	strings:
		$1 = { 56 57 8B FA 8B D7 E8 ?? ?? ?? ?? 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 D4 00 00 00 84 C0 75 3E 8B C6 8B 10 FF 52 4C 84 C0 74 26 8B C7 E8 ?? ?? ?? ?? 85 C0 75 1F 8B C7 E8 ?? ?? ?? ?? 84 C0 74 10 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7F 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 51 64 8B C6 5F 5E C3 }
	condition:
		$1
}

rule function_1132_0 {
	meta:
		name = "TCustomActionMenuBar.CreatePopup"
		size = 647
		refs = "0041 TOrderedList.Count 0057 TMenuStack.Peek 0084 TActionClient.GetItems 0089 TActionClients.VisibleCount 00c0 TWinControl.DisableAlign 00c8 TCustomActionMenuBar.CreatePopup 00d6 TCustomActionBar.GetColorMap 00f6 TControl.SetColor 0145 TCustomActionMenuBar.SetParentMenu 01a8 TCustomActionBar.FindFirstVisibleItem 01e5 Application 01f5 TWinControl.SetParentWindow 0221 TWinControl.EnableAlign 0227 @HandleFinally 0231 TControl.Show 023a _DV_TCustomMenuButton 023f @IsClass 027a TTimer.SetEnabled"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 89 4D F8 8B F2 89 45 FC 33 C0 89 45 F4 8B 45 FC 80 B8 0A 03 00 00 00 0F 84 59 02 00 00 85 F6 0F 84 51 02 00 00 83 7D F8 00 0F 84 47 02 00 00 8B 45 FC 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 31 02 00 00 8B 45 FC 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B 80 18 03 00 00 3B 45 F8 0F 84 14 02 00 00 8B 45 F8 83 B8 AC 01 00 00 00 0F 84 04 02 00 00 8B 45 F8 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 E9 01 00 00 8B 55 F8 8B 45 FC 8B 08 FF 91 8C 01 00 00 8B 45 FC 33 D2 89 90 00 03 00 00 8B 45 FC 8B 10 FF 92 A0 01 00 00 89 45 F4 8B 45 F4 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 F4 8B 08 FF 91 38 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 50 74 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 2C 03 00 00 8B 55 F4 89 82 2C 03 00 00 8B 45 FC 0F B6 80 7C 02 00 00 8B 55 F4 88 82 7C 02 00 00 8B 45 F8 8B 80 AC 01 00 00 8B 55 F4 89 50 18 8B 45 FC 8B 50 64 8B 45 F4 8B 40 64 8B 08 FF 51 08 8B D6 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 C6 80 0A 03 00 00 01 8B 45 F4 8B 55 F8 89 90 18 03 00 00 8B 45 F8 8B 80 AC 01 00 00 0F B6 58 30 8B D0 8B 45 F4 8B 08 FF 91 30 01 00 00 8B 45 F8 8B 80 AC 01 00 00 8B D3 8B 08 FF 51 2C 8B 45 FC 80 B8 09 03 00 00 00 75 33 8B 45 FC 8B 10 FF 92 10 01 00 00 84 C0 75 24 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 74 18 8B 45 F8 8B 80 AC 01 00 00 E8 ?? ?? ?? ?? 80 78 2A 00 74 04 33 DB EB 02 B3 01 8B 45 F4 88 98 09 03 00 00 84 DB 74 0D 33 D2 8B 45 F4 8B 08 FF 91 94 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B 90 70 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 10 01 00 00 8B D0 8B 45 F4 8B 08 FF 91 3C 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B 45 F8 8B 10 FF 92 80 00 00 00 8B 45 F4 80 B8 08 03 00 00 00 74 0C 8B 45 F4 80 B8 09 03 00 00 00 74 04 33 D2 EB 02 B2 01 8B 45 FC 8B 80 68 03 00 00 E8 ?? ?? ?? ?? 8B 45 F4 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1133_0 {
	meta:
		name = "TCustomActionMenuBar.DoItemSelected"
		size = 183
		refs = "000a _DV_TCustomMenuItem 000f @IsClass 003c TTimer.SetEnabled 004d TMenuStack.Peek 0070 TCustomActionMenuBar.GetSelected 0079 TCustomActionBar.FindFirstVisibleItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8B 83 2C 03 00 00 89 B0 00 03 00 00 EB 08 33 C0 89 83 00 03 00 00 8B 83 2C 03 00 00 8B 80 78 03 00 00 B2 01 E8 ?? ?? ?? ?? 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 80 B8 08 03 00 00 00 74 5A 8B 83 2C 03 00 00 8B 80 68 03 00 00 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 74 13 8B 83 2C 03 00 00 8B 80 68 03 00 00 C7 40 0C 01 00 00 00 8B C3 8B 10 FF 92 10 01 00 00 8B D0 80 F2 01 8B 83 2C 03 00 00 8B 80 68 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1134_0 {
	meta:
		name = "TCustomActionMenuBar.ExecAction"
		size = 92
		refs = "0020 sndPlaySound 0027 TCustomActionMenuBar.ExecAction"
	strings:
		$1 = { 53 8B D8 85 D2 74 39 F6 43 1C 10 75 33 8B C3 8B 10 FF 92 10 01 00 00 84 C0 75 25 6A 02 6A 00 E8 ?? ?? ?? ?? 6A 13 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 7C 03 00 00 8B 40 3C 33 D2 8B 08 FF 51 18 5B C3 00 00 4D 00 65 00 6E 00 75 00 43 00 6F 00 6D 00 6D 00 61 00 6E 00 64 00 00 00 }
	condition:
		$1
}

rule function_1135_0 {
	meta:
		name = "TCustomActionMenuBar.DoGetPopupClass"
		size = 49
	strings:
		$1 = { 53 51 8B D8 8B C3 8B 10 FF 92 98 01 00 00 89 04 24 66 83 BB 3A 03 00 00 00 74 10 8B CC 8B D3 8B 83 3C 03 00 00 FF 93 38 03 00 00 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_1136_0 {
	meta:
		name = "TCustomActionMenuBar.DoItemClicked"
		size = 437
		refs = "0014 _DV_TCustomMenuButton 0019 @IsClass 0024 TCustomActionMenuBar.ClearSubMenus 0041 TActionClient.GetHasItems 0065 TMenuStack.Pop 0070 TMenuStack.Peek 00a5 TCustomActionMenuBar.GetSelected 00b2 TCustomActionMenuBar.ProcessMessages 00e4 TOrderedList.Count 0153 SystemParametersInfo 018d TMenuStack.GetBars 0194 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 55 51 8B DA 8B F0 33 FF 3B 73 04 75 2A 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 80 00 00 00 33 C0 89 86 00 03 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 E3 00 00 00 83 BE 00 03 00 00 00 74 31 EB 11 8B 86 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B 96 00 03 00 00 3B 42 30 75 D9 33 C0 89 86 00 03 00 00 80 7B 57 00 75 15 8B 86 74 03 00 00 E8 ?? ?? ?? ?? B2 01 8B 08 FF 91 94 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B E8 8B 86 2C 03 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 3B E8 0F 85 E8 00 00 00 83 BE 74 03 00 00 00 0F 84 DB 00 00 00 8B 43 30 3B 86 2C 03 00 00 75 31 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 48 7E 23 EB 13 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 48 7F DF 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B D0 8B CB 8B C6 8B 18 FF 93 7C 01 00 00 C6 86 FC 02 00 00 00 EB 7D 8B BB AC 01 00 00 8B C6 8B 10 FF 92 10 01 00 00 84 C0 75 69 6A 00 8D 44 24 04 50 6A 00 68 14 10 00 00 E8 ?? ?? ?? ?? 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 48 7E 37 83 3C 24 00 74 31 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B D8 83 EB 02 85 DB 7E 1D BD 01 00 00 00 8B D5 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 45 4B 75 E8 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 AC 01 00 00 8B C7 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1137_0 {
	meta:
		name = "TCustomActionMenuBar.DoItemKeyed"
		size = 137
		refs = "0018 TCustomActionMenuBar.DoItemKeyed 0040 TMenuStack.Peek 0045 TCustomActionBar.FindFirstVisibleItem 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 56 89 45 FC 8B 45 FC C6 80 0B 03 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 08 FF 91 80 01 00 00 89 45 F8 83 7D F8 00 75 2C 8B 45 FC 8B 80 74 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 83 7E 44 00 74 0D 8B 46 44 B2 01 8B 08 FF 91 E4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 0B 03 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 8B 45 F8 5E 59 59 5D C3 }
	condition:
		$1
}

rule function_1139_0 {
	meta:
		name = "TCustomActionMenuBar.IsDesignMsg"
		size = 191
		refs = "0016 Mouse 001d TMouse.GetIsDragging 0072 TWinControl.GetHandle 0079 GetForegroundWindow"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 8B 10 FF 92 10 01 00 00 84 C0 74 10 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 02 B0 01 84 C0 0F 84 88 00 00 00 83 BB 04 03 00 00 00 75 14 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 84 C0 74 0C 81 7E 04 02 02 00 00 0F 95 C0 EB 59 83 BB 10 03 00 00 00 74 16 8B 83 10 03 00 00 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 3B F8 75 04 33 C0 EB 02 B0 01 F6 43 1C 10 74 15 84 C0 74 09 81 7E 04 03 B4 00 00 75 04 33 C0 EB 1D B0 01 EB 19 8B 83 2C 03 00 00 85 C0 74 09 80 B8 0A 03 00 00 00 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1140_0 {
	meta:
		name = "TCustomActionMenuBar.DoMenuDelay"
		size = 227
		refs = "000f TTimer.SetEnabled 004f TMenuStack.Pop 0060 TOrderedList.Count 0074 TMenuStack.Peek 0085 GetCursorPos 009b TControl.ScreenToClient 00af TControl.GetBoundsRect 00b9 PtInRect"
	strings:
		$1 = { 53 83 C4 E0 8B D8 33 D2 8B 83 78 03 00 00 E8 ?? ?? ?? ?? 83 BB 00 03 00 00 00 0F 84 BE 00 00 00 8B 83 00 03 00 00 83 78 30 00 0F 84 AE 00 00 00 8B 80 AC 01 00 00 83 78 18 00 0F 85 9E 00 00 00 EB 11 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 48 7E 1C 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B 93 00 03 00 00 3B 42 30 75 BF 54 E8 ?? ?? ?? ?? 8B 83 74 03 00 00 E8 ?? ?? ?? ?? 8D 4C 24 08 8B D4 E8 ?? ?? ?? ?? 8D 44 24 08 50 8D 54 24 14 8B 83 00 03 00 00 E8 ?? ?? ?? ?? 8D 44 24 14 5A E8 ?? ?? ?? ?? 84 C0 74 1D 8B 83 74 03 00 00 E8 ?? ?? ?? ?? 8B D0 8B 8B 00 03 00 00 8B C3 8B 18 FF 93 7C 01 00 00 83 C4 20 5B C3 }
	condition:
		$1
}

rule function_1141_0 {
	meta:
		name = "TCustomActionMenuBar.DoneMenuLoop"
		size = 163
		refs = "0008 TCustomActionMenuBar.SetMouseControl 001b TObject.Free 0022 ActiveMenu 0030 ActionBarDesigner 0051 ShowCaret 0095 TWinControl.GetHandle 009d NotifyWinEvent"
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 83 5C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 BB 7C 02 00 00 00 74 18 A1 ?? ?? ?? ?? 83 38 00 74 0E A1 ?? ?? ?? ?? 8B 00 33 D2 8B 08 FF 51 18 C6 83 FC 02 00 00 01 6A 00 E8 ?? ?? ?? ?? 8D 83 78 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 74 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 68 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1142_0 {
	meta:
		name = "TCustomActionMenuBar.DoPopup"
		size = 31
	strings:
		$1 = { 53 66 83 B8 22 03 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 24 03 00 00 FF 93 20 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1143_0 {
	meta:
		name = "TCustomActionMenuBar.Expand"
		size = 199
		refs = "0034 TCustomActionBar.HasItems 0044 TWinControl.DisableAlign 004c TCustomActionMenuBar.Expand 005a TCustomActionBar.GetItems 005f TCollection.GetCount 0078 TActionClients.GetActionClient 0095 TControl.SetVisible 00b6 TWinControl.EnableAlign 00bc @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC C6 80 09 03 00 00 01 84 D2 74 0F 8B 45 FC 8B 80 2C 03 00 00 88 90 09 03 00 00 8B 45 FC C6 80 08 03 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 84 C0 0F 84 82 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 33 46 33 DB 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 0F B6 40 30 50 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 5A E8 ?? ?? ?? ?? 43 4E 75 D0 8B 45 FC 8B 10 FF 52 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1144_0 {
	meta:
		name = "TCustomActionMenuBar.ExpandTimer"
		size = 110
		refs = "000c TTimer.SetEnabled 001d TMenuStack.Peek 004a TCustomButtonControl.SetFlat"
	strings:
		$1 = { 56 8B F0 33 D2 8B 86 68 03 00 00 E8 ?? ?? ?? ?? 8B 86 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 80 B8 08 03 00 00 00 74 42 8B 86 68 03 00 00 83 78 0C 01 75 1A 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B 80 8C 03 00 00 33 D2 E8 ?? ?? ?? ?? EB 1C C6 86 09 03 00 00 01 8B 86 74 03 00 00 E8 ?? ?? ?? ?? B2 01 8B 08 FF 91 94 01 00 00 5E C3 }
	condition:
		$1
}

rule function_1145_0 {
	meta:
		name = "TCustomActionMenuBar.GetDesignMode"
		size = 47
		refs = "0006 TCustomActionBar.GetDesignMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 75 1F 83 BB 14 03 00 00 00 74 16 3B 9B 14 03 00 00 74 0E 8B 83 14 03 00 00 8B 10 FF 92 10 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1146_0 {
	meta:
		name = "TCustomActionMenuBar.GetMouseHoverItem"
		size = 183
		refs = "0030 TOrderedList.Count 0045 WindowFromPoint 0054 TMenuStack.GetBars 0059 TWinControl.GetHandle 007f TControl.ScreenToClient 008c TWinControl.ControlAtPos 009c _Dn_TCustomActionControl 00a1 @IsClass"
	strings:
		$1 = { 53 56 57 55 83 C4 D8 8B F2 8D 7C 24 04 B9 07 00 00 00 F3 A5 33 D2 89 14 24 33 FF 8B B0 2C 03 00 00 85 F6 0F 84 83 00 00 00 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B D8 4B 83 FB 00 7C 5C FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 8B E8 8B D3 8B 86 74 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B E8 75 31 8B D3 8B 86 74 03 00 00 E8 ?? ?? ?? ?? 8B F8 6A 00 6A 00 8D 4C 24 28 8D 54 24 20 8B C7 E8 ?? ?? ?? ?? 8D 54 24 28 B1 01 8B C7 E8 ?? ?? ?? ?? 8B F8 4B 83 FB FF 75 A4 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 03 89 3C 24 8B 04 24 83 C4 28 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1147_0 {
	meta:
		name = "TCustomActionMenuBar.GetPopupClass"
		size = 59
		refs = "0025 ActionBarStyles 002e TActionBarStyleList.GetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 5C 01 00 00 85 C0 74 13 8B C3 8B 10 FF 92 5C 01 00 00 8B D3 8B 08 FF 51 0C 5B C3 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 0C 5B C3 }
	condition:
		$1
}

rule function_1148_0 {
	meta:
		name = "TCustomActionMenuBar.GetSelected"
		size = 96
	strings:
		$1 = { 53 56 57 55 8B F0 33 ED 8B C6 8B 10 FF 92 20 01 00 00 8B F8 4F 85 FF 7C 40 47 33 DB 8B D3 8B C6 8B 08 FF 91 14 01 00 00 85 C0 74 29 8B D3 8B C6 8B 08 FF 91 14 01 00 00 80 B8 CC 01 00 00 00 74 14 8B D3 8B C6 8B 08 FF 91 14 01 00 00 8B A8 AC 01 00 00 EB 04 43 4F 75 C3 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1149_0 {
	meta:
		name = "TCustomActionMenuBar.InitMenuLoop"
		size = 374
		refs = "000c Mouse 0013 TMouse.GetCursorPos 005d SystemParametersInfo 007e GetParentForm 0093 _Dn_TTimer 0098 TTimer.Create 00a6 TCustomActionMenuBar.DoMenuDelay 00ad TTimer.SetOnTimer 00bb TTimer.SetInterval 00c8 TTimer.SetEnabled 00d1 _DV_TMenuStack 00d6 TMenuStack.Create 00e7 TMenuStack.Push 0119 TCustomActionMenuBar.ExpandTimer 012e HideCaret 0134 ActiveMenu 0142 ActionBarDesigner 0164 TWinControl.GetHandle 016c NotifyWinEvent"
	strings:
		$1 = { 53 56 83 C4 F4 8B D8 8D 54 24 04 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 44 24 04 89 83 6C 03 00 00 8B 44 24 08 89 83 70 03 00 00 33 C0 89 83 7C 03 00 00 C6 83 09 03 00 00 00 33 C0 89 83 00 03 00 00 F6 43 1C 10 74 09 C7 04 24 01 00 00 00 EB 19 6A 00 8D 44 24 04 50 6A 00 6A 6A E8 ?? ?? ?? ?? 83 3C 24 00 75 03 FF 04 24 F6 43 1C 10 75 1E 80 BB 59 03 00 00 00 74 15 B2 01 8B C3 E8 ?? ?? ?? ?? 85 C0 74 08 8B 10 FF 92 D8 00 00 00 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 78 03 00 00 53 68 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 14 24 8B 83 78 03 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 78 03 00 00 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 74 03 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 68 03 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 93 28 03 00 00 8B C6 E8 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C6 83 0A 03 00 00 01 6A 00 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 80 BB 7C 02 00 00 00 74 1C A1 ?? ?? ?? ?? 83 38 00 74 12 A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? 8B 08 FF 51 18 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 04 E8 ?? ?? ?? ?? 83 C4 0C 5E 5B C3 }
	condition:
		$1
}

rule function_1150_0 {
	meta:
		name = "TCustomActionMenuBar.MouseActivate"
		size = 54
		refs = "001d TControl.MouseActivate"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 8B 45 10 50 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B C3 E8 ?? ?? ?? ?? 84 C0 75 0B 80 BB 59 03 00 00 00 75 02 B0 03 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1151_0 {
	meta:
		name = "TCustomActionMenuBar.NewPopup"
		size = 153
		refs = "0014 TMenuStack.Peek 0047 TObject.Free 0079 @CallDynaInst 008f TMenuStack.Push"
	strings:
		$1 = { 53 56 57 8B F8 33 DB 8B 87 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 83 B8 5C 03 00 00 00 74 4D 8B 87 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B 98 5C 03 00 00 8D 83 8C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C6 83 08 03 00 00 00 C6 83 09 03 00 00 00 68 96 00 00 00 6A 32 33 C9 33 D2 8B C3 8B 30 FF 96 88 00 00 00 85 DB 75 14 8B C7 66 BE AF FF E8 ?? ?? ?? ?? 8B CF B2 01 FF 50 2C 8B D8 8B D3 8B 87 74 03 00 00 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1152_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMouseMsg"
		size = 288
		refs = "000f TCustomActionMenuBar.GetMouseHoverItem 0048 Mouse 004f TMouse.GetIsDragging 0062 WindowFromPoint 0075 TMenuStack.Peek 007a TWinControl.GetHandle 008b GetParentForm 00a3 TControl.ScreenToClient 00b0 TWinControl.ControlAtPos 00be _Dn_TCustomActionBar 00c3 @IsClass 00cf _Dn_TCustomActionControl 00f9 _DV_TCustomActionPopupMenu 0116 DispatchMessage"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 85 F9 00 00 00 8B 46 04 2D 00 02 00 00 74 22 48 0F 84 BF 00 00 00 83 C0 FE 83 E8 02 0F 82 B3 00 00 00 48 83 E8 02 0F 82 A9 00 00 00 E9 CD 00 00 00 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 0F 84 B9 00 00 00 FF 76 18 FF 76 14 E8 ?? ?? ?? ?? 8B F8 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B F8 0F 84 8E 00 00 00 B2 01 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 74 7F 6A 01 6A 00 8D 4C 24 08 8D 56 14 8B C3 E8 ?? ?? ?? ?? 8D 54 24 08 33 C9 8B C7 E8 ?? ?? ?? ?? 8B F8 85 FF 74 5A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 11 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 38 8B 83 2C 03 00 00 C6 80 0A 03 00 00 00 EB 29 F6 43 1C 10 75 15 8B 83 2C 03 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8B 83 2C 03 00 00 8B 10 FF 92 AC 01 00 00 56 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1153_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMenuLoop"
		size = 1096
		refs = "0033 TCustomActionMenuBar.ProcessMenuLoop 0047 PeekMessage 006e _DV_TCustomActionPopupMenu 0073 @IsClass 008b Application 0092 TApplication.IsKeyMsg 00a4 TCustomActionMenuBar.IsDesignMsg 00ae TranslateMessage 00b4 DispatchMessage 0164 KeyboardStateToShiftState 0181 TMenuStack.Peek 0186 TCustomActionMenuBar.GetSelected 01ad Screen 01e9 TApplication.HelpCommand 01fc TApplication.HelpContext 0209 Mouse 0210 TMouse.GetCursorPos 021b WindowFromPoint 0220 FindControl 0233 TControl.ScreenToClient 0243 TWinControl.ControlAtPos 024d _Dn_TMenuResizeActionControl 027e TCustomActionMenuBar.ProcessMessages 0376 PointsEqual 0398 TCustomActionMenuBar.DoItemSelected 03df PostQuitMessage 03f5 TCustomActionMenuBar.CleanupStack 0401 TCustomActionMenuBar.Idle 042f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 89 45 FC 8D 7D CC 33 C0 89 45 F8 8B 45 FC 80 B8 0A 03 00 00 00 0F 85 11 04 00 00 8B 45 FC 8B 10 FF 92 9C 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 01 6A 00 6A 00 6A 00 57 E8 ?? ?? ?? ?? 85 C0 0F 84 A8 03 00 00 8B 45 FC C6 80 80 03 00 00 00 83 7F 04 7B 75 1C 8B 45 FC 8B 80 2C 03 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 85 86 03 00 00 8B 45 FC F6 40 1C 10 74 16 8B D7 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 0F 85 67 03 00 00 8B D7 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 11 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 48 03 00 00 8B 47 04 8B D0 81 FA 00 01 00 00 7D 44 81 FA A1 00 00 00 7F 22 0F 84 2D 01 00 00 83 EA 10 0F 84 AC 01 00 00 83 EA 02 0F 84 E6 02 00 00 83 EA 3B 74 74 E9 F1 02 00 00 81 EA A4 00 00 00 0F 84 8D 01 00 00 83 EA 03 0F 84 84 01 00 00 E9 D7 02 00 00 81 FA 02 B4 00 00 7F 35 0F 84 75 02 00 00 81 C2 00 FF FF FF 83 EA 0A 0F 82 86 01 00 00 81 C2 0A FF FF FF 83 EA 0B 0F 82 0F 02 00 00 81 EA 16 AE 00 00 0F 84 47 01 00 00 E9 9A 02 00 00 81 EA 03 B4 00 00 0F 84 60 02 00 00 4A 0F 84 40 02 00 00 E9 82 02 00 00 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 3A D0 0F 85 7A 02 00 00 8B 45 FC 8B 80 74 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 5F 02 00 00 8B 45 FC 8B 80 74 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 58 68 85 DB 75 10 A1 ?? ?? ?? ?? 8B 00 8B 40 64 8B 98 60 01 00 00 8B 45 FC 8B 10 FF 92 AC 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 64 F6 80 80 02 00 00 08 74 18 A1 ?? ?? ?? ?? 8B 00 8B CB BA 08 00 00 00 E8 ?? ?? ?? ?? E9 FF 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B D3 E8 ?? ?? ?? ?? E9 EC 01 00 00 8D 55 F0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? FF 75 F4 FF 75 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 30 8D 4D E8 8D 55 F0 8B C6 E8 ?? ?? ?? ?? 6A 00 6A 00 8D 55 E8 33 C9 8B C6 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 84 DB 75 0B 8B 45 FC 8B 10 FF 92 AC 01 00 00 8B 45 FC 88 98 80 03 00 00 8B 45 FC 8B 80 2C 03 00 00 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 64 01 00 00 8B 45 FC 8B 10 FF 92 AC 01 00 00 8B 45 FC 8B 80 2C 03 00 00 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 40 01 00 00 8B 45 FC 80 B8 A0 02 00 00 00 75 0D B2 01 8B 45 FC 8B 08 FF 91 44 01 00 00 81 7F 04 04 01 00 00 75 2C 83 7F 08 12 75 26 8B 45 FC 8B 10 FF 92 AC 01 00 00 8B 45 FC C6 80 60 03 00 00 01 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 F2 00 00 00 83 7F 08 70 75 27 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 3A D0 0F 85 D8 00 00 00 8B 45 FC 8B 10 FF 92 10 01 00 00 84 C0 0F 85 C5 00 00 00 8D 5F 04 8B 45 FC 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 EC E9 A8 00 00 00 3D 0A 02 00 00 0F 84 B1 00 00 00 3D 00 02 00 00 75 27 8D 55 C4 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8D 55 C4 8B 45 FC 05 6C 03 00 00 E8 ?? ?? ?? ?? 84 C0 0F 85 83 00 00 00 8B D7 8B 45 FC 8B 08 FF 91 A8 01 00 00 EB 60 8B 57 0C 8B 45 FC E8 ?? ?? ?? ?? EB 53 8B 57 0C 8B 45 FC 8B 08 FF 91 84 01 00 00 8B 55 FC 89 82 7C 03 00 00 EB 3A 8B 57 0C 8B 45 FC 8B 08 FF 91 80 01 00 00 8B 55 FC 89 82 7C 03 00 00 EB 21 8B 45 FC C6 80 0A 03 00 00 00 8B 47 08 50 E8 ?? ?? ?? ?? EB 0C 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? EB 0A 8B D7 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 B8 0A 03 00 00 00 0F 85 28 FC FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 88 01 00 00 C3 E9 ?? ?? ?? ?? EB ED 8B 45 F8 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_1154_0 {
	meta:
		name = "SkipItems"
		size = 190
		refs = "0014 TCustomActionMenuBar.GetSelected"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 88 45 FF B3 01 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 89 06 E9 8C 00 00 00 80 7D FF 00 74 16 8B 16 8B 45 08 8B 40 FC B1 01 8B 18 FF 93 FC 00 00 00 89 06 EB 14 8B 16 8B 45 08 8B 40 FC B1 01 8B 18 FF 93 00 01 00 00 89 06 83 3E 00 74 51 8B 06 83 78 44 00 74 49 8B 45 08 8B 40 FC F6 40 1C 10 75 4B 8B 45 08 8B 40 FC 8B 10 FF 92 10 01 00 00 84 C0 74 10 8B 06 8B 40 44 8B 10 FF 52 4C 84 C0 75 2B EB 1B 8B 06 80 78 54 00 75 13 8B 06 8B 40 44 80 78 57 00 74 08 8B 06 80 78 76 02 75 0E 83 3E 00 0F 95 C3 84 DB 0F 85 6C FF FF FF 83 3E 00 0F 95 C0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1155_0 {
	meta:
		name = "CheckChangesAllowed"
		size = 135
		refs = "0015 CheckChangesAllowed 002b TActionClientItem.GetCaption 0043 SMoveNotAllowed 0048 LoadResString 0052 _Dn_Exception 0057 Exception.CreateFmt 005c @RaiseExcept 0076 @UStrArrayClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F4 89 55 F0 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 F6 43 31 02 75 3B 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 89 45 F8 C6 45 FC 11 8D 45 F8 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1156_0 {
	meta:
		name = "EnsureNextItemVisible"
		size = 146
		refs = "0049 TCustomActionDockBar.SetVisibleIndex 0068 TCustomActionDockBar.MakeLastItemVisible 0075 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F8 8B 45 08 8B 40 FC 80 B8 D8 02 00 00 00 74 76 8B 07 8B 40 44 81 78 44 01 00 00 80 75 68 8B 45 08 80 78 FB 00 74 21 8B 45 08 8B 40 FC 8B 98 F0 02 00 00 80 7B 57 00 75 3F 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? EB 30 8B 45 08 8B 40 FC 8B 98 F4 02 00 00 80 7B 57 00 75 1E 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB 11 8B C3 66 BE EB FF E8 ?? ?? ?? ?? 80 7B 57 00 74 0E 8B 07 8B 40 44 81 78 44 01 00 00 80 74 E1 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1157_0 {
	meta:
		name = "TCustomActionMenuBar.Select"
		size = 316
		refs = "0015 SkipItems 0032 TMenuStack.Peek 004f KeyboardStateToShiftState 0056 TCustomActionMenuBar.Select 006c TCustomActionMenuBar.GetSelected 0081 CheckChangesAllowed 0091 TCollectionItem.GetIndex 00ae EnsureNextItemVisible 00bd TCustomActionMenuBar.SelectItem 00d5 TActionClientItem.GetAction"
	strings:
		$1 = { 55 8B EC 83 C4 F4 88 55 FB 89 45 FC 55 8D 55 F4 0F B6 45 FB E8 ?? ?? ?? ?? 59 84 C0 0F 84 11 01 00 00 8B 45 FC 8B 80 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 3B 45 FC 0F 85 84 00 00 00 8B 45 FC 8B 10 FF 92 10 01 00 00 84 C0 74 5B E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 3A D0 75 4B 83 7D F4 00 0F 84 CB 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 85 C0 0F 84 BB 00 00 00 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 14 E9 8A 00 00 00 55 8D 45 F4 E8 ?? ?? ?? ?? 59 8B 45 F4 8B 50 44 8B 45 FC E8 ?? ?? ?? ?? EB 70 8B 45 F4 8B 40 44 8B 40 30 3B 45 FC 75 54 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 74 48 8B 45 FC 8B 80 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? C6 80 0A 03 00 00 00 8B 45 FC 8B 80 2C 03 00 00 33 D2 89 90 00 03 00 00 55 8D 45 F4 E8 ?? ?? ?? ?? 59 8B 45 F4 8B 40 44 B2 01 8B 08 FF 91 E4 00 00 00 EB 0E 8B 45 F4 8B 40 44 8B 10 FF 92 EC 00 00 00 8B E5 5D C3 00 04 00 00 00 }
	condition:
		$1
}

rule function_1158_0 {
	meta:
		name = "TCustomActionMenuBar.SelectItem"
		size = 21
	strings:
		$1 = { 56 8B F2 85 F6 74 0C B2 01 8B C6 8B 08 FF 91 E4 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1159_0 {
	meta:
		name = "TCustomActionMenuBar.SetDesignMode"
		size = 42
		refs = "0023 TCustomActionBar.SetDesignMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 10 01 00 00 3A D8 74 0A 8B C6 8B 10 FF 92 AC 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1160_0 {
	meta:
		name = "TCustomActionMenuBar.SetParentMenu"
		size = 109
	strings:
		$1 = { 56 57 8B F0 3B 96 14 03 00 00 74 5E 8B FA 89 BE 14 03 00 00 85 FF 74 52 89 B7 64 03 00 00 0F B6 97 A0 02 00 00 8B C6 8B 08 FF 91 44 01 00 00 8B 86 14 03 00 00 66 83 B8 92 02 00 00 00 74 18 8B 90 90 02 00 00 89 96 90 02 00 00 8B 90 94 02 00 00 89 96 94 02 00 00 8B 86 14 03 00 00 0F B6 80 FD 02 00 00 88 86 FD 02 00 00 5F 5E C3 }
	condition:
		$1
}

rule function_1161_0 {
	meta:
		name = "TCustomActionMenuBar.SetPersistentHotKeys"
		size = 98
		refs = "0017 TCustomActionBar.SetPersistentHotKeys 0031 TOrderedList.Count 004b TList.Get"
	strings:
		$1 = { 53 56 57 51 8B D8 3A 93 A0 02 00 00 0F 95 C0 22 C2 88 04 24 8B C3 E8 ?? ?? ?? ?? 80 3C 24 00 74 3C 83 BB 74 03 00 00 00 74 33 8B 83 74 03 00 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 21 46 33 FF 8B 83 74 03 00 00 8B 40 04 8B D7 E8 ?? ?? ?? ?? B2 01 8B 08 FF 91 44 01 00 00 47 4E 75 E2 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1162_0 {
	meta:
		name = "TCustomActionMenuBar.SetParent"
		size = 27
		refs = "0006 TWinControl.SetParent 000f GetParentForm"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 89 83 10 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1163_0 {
	meta:
		name = "TCustomActionMenuBar.TrackMenu"
		size = 314
		refs = "004d TCustomActionMenuBar.TrackMenu 007e TActionClientItem.GetAction 0084 _Dn_TCustomAction 0089 @IsClass 00d3 TActionClientItem.ResetUsageData 012f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 45 FC 8B 45 FC 80 B8 0A 03 00 00 00 0F 85 1B 01 00 00 8B 45 FC 8B 55 FC 89 90 2C 03 00 00 C6 45 FB 01 8B 45 FC 66 83 B8 4A 03 00 00 00 74 12 8B 5D FC 8B 55 FC 8B 83 4C 03 00 00 FF 93 48 03 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 A4 01 00 00 8B 45 FC 83 B8 7C 03 00 00 00 74 3B 8B 45 FC 8B 98 7C 03 00 00 85 DB 74 2A 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B 45 FC 8B 80 7C 03 00 00 E8 ?? ?? ?? ?? 80 78 6A 00 74 04 33 C0 EB 02 B0 01 88 45 FB 8B 45 FC 8B 10 FF 92 10 01 00 00 84 C0 75 40 8B 45 FC 83 B8 7C 03 00 00 00 74 34 8B 45 FC 8B 80 7C 03 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 8C 00 00 00 8B 45 FC 8B 80 7C 03 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 08 FF 91 90 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 66 83 B8 52 03 00 00 00 74 16 8B 5D FC 0F B6 4D FB 8B 55 FC 8B 83 54 03 00 00 FF 93 50 03 00 00 C3 E9 ?? ?? ?? ?? EB D5 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1164_0 {
	meta:
		name = "TCustomActionMenuBar.WndProc"
		size = 179
		refs = "004b IID_IAccessible 0051 LresultFromObject 0060 _Dn_TActionMenuBarAccessibility 0065 TActionBarAccessibility.Create 00ab TWinControl.WndProc"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B 03 83 E8 14 74 77 83 E8 29 74 0E 83 E8 47 0F 84 83 00 00 00 E9 85 00 00 00 83 7B 08 FC 75 7F 83 BE 68 02 00 00 00 74 76 8B BE 68 02 00 00 83 7F 34 00 74 1E 8B 86 68 02 00 00 8B 40 34 50 8B 43 04 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 43 0C EB 55 57 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 03 83 E8 F8 50 8B 43 04 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 43 0C EB 2A 80 BE 54 02 00 00 00 74 18 8B 43 04 3B 43 08 74 10 C7 43 0C 01 00 00 00 EB 10 C7 43 0C 01 00 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1165_0 {
	meta:
		name = "TCustomActionMenuBar.WMKeyDown"
		size = 828
		refs = "0017 TCustomActionMenuBar.WMKeyDown 0026 TWinControl.WMKeyDown 0060 KeyboardStateToShiftState 0090 TMenuStack.Peek 0097 TCustomActionBar.FindAccelItem 0115 @CallDynaInst 0133 TCustomActionBar.FindFirstVisibleItem 013d TCustomActionMenuBar.SelectItem 0149 TCustomActionBar.FindLastVisibleItem 015f TCustomActionMenuBar.GetSelected 019c DragDone 01a6 Mouse 01ad TMouse.GetIsDragging 01b6 CancelDrag 0202 SDeleteNotAllowed 0207 LoadResString 0211 _Dn_Exception 0216 Exception.Create 021b @RaiseExcept 0222 TActionClient.GetHasItems 0236 TActionClientItem.GetCaption 024c SDeleteItemWithSubItems 025c Format 026d MessageDlg 027b TCollectionItem.GetIndex 02bb TActionClient.GetItems 02c3 TCollection.Delete 02ef TWinControl.GetHandle 02f5 PostMessage 02fc NotifyDesigner 0316 @UStrArrayClr 0329 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B C6 E8 ?? ?? ?? ?? 80 BE 0A 03 00 00 00 0F 84 C9 02 00 00 83 BE 2C 03 00 00 00 74 6C 0F B7 43 04 83 C0 D0 66 83 E8 0A 72 12 83 C0 F9 66 83 E8 1A 72 09 83 C0 FB 66 83 E8 0A 73 4D E8 ?? ?? ?? ?? A8 04 75 44 0F B7 43 04 0F B7 F8 8B D0 83 C2 A0 66 83 EA 0A 73 09 0F B7 F8 83 C7 30 83 EF 60 8B 86 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B F8 85 FF 74 0B 8B 47 44 8B 10 FF 92 EC 00 00 00 0F B7 43 04 83 C0 F3 83 F8 21 0F 87 44 02 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 05 00 00 00 00 00 00 00 00 00 00 00 00 00 06 00 00 00 00 00 00 00 04 03 00 01 00 02 00 00 00 00 00 07 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 33 D2 8B C6 66 BE AE FF E8 ?? ?? ?? ?? E9 E2 01 00 00 B2 01 8B C6 66 BE AE FF E8 ?? ?? ?? ?? E9 D0 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 50 44 8B C6 E8 ?? ?? ?? ?? E9 BA 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 50 44 8B C6 E8 ?? ?? ?? ?? E9 A4 01 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 0F 84 95 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 EC 00 00 00 E9 7E 01 00 00 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 15 83 BE 04 03 00 00 00 74 0C 33 C0 E8 ?? ?? ?? ?? E9 5B 01 00 00 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 74 0A E8 ?? ?? ?? ?? E9 41 01 00 00 8B C6 8B 10 FF 92 AC 01 00 00 E9 32 01 00 00 8B C6 8B 10 FF 92 10 01 00 00 84 C0 0F 84 20 01 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 0F 84 11 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B F8 F6 47 31 04 75 21 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 84 C0 74 4E 6A 00 8D 45 F4 50 8D 55 E8 8B C7 E8 ?? ?? ?? ?? 8B 45 E8 89 45 EC C6 45 F0 11 8D 45 EC 50 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E4 33 C9 5A E8 ?? ?? ?? ?? 8B 45 F4 0F B7 0D ?? ?? ?? ?? B2 03 E8 ?? ?? ?? ?? 48 0F 85 88 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 45 FC 8B C6 8B 10 FF 92 20 01 00 00 48 3B 45 FC 75 12 33 C9 8B D7 8B C6 8B 18 FF 93 00 01 00 00 8B F8 EB 10 33 C9 8B D7 8B C6 8B 18 FF 93 FC 00 00 00 8B F8 8B 86 68 02 00 00 E8 ?? ?? ?? ?? 8B 55 FC E8 ?? ?? ?? ?? 85 FF 74 0F 8B 47 44 B2 01 8B 08 FF 91 E4 00 00 00 EB 1F 8B 86 18 03 00 00 50 6A 00 68 02 B4 00 00 8B 86 2C 03 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 00 00 0C 00 00 00 }
	condition:
		$1
}

rule function_1166_0 {
	meta:
		name = "TCustomActionMenuBar.WMMouseActivate"
		size = 34
		refs = "000b TWinControl.WMMouseActivate"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 0A 03 00 00 00 74 07 C7 46 0C 03 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1167_0 {
	meta:
		name = "TCustomActionMenuBar.WMSysKeyDown"
		size = 308
		refs = "000b TWinControl.WMSysKeyDown 0021 TCustomActionMenuBar.WMKeyDown 004a TCustomActionMenuBar.GetSelected 005e TActionClient.GetHasItems 00bd TCustomActionBar.FindNextVisibleItem 00cc TCustomActionBar.FindFirstVisibleItem 00f9 TCustomActionBar.FindPreviousVisibleItem 0108 TCustomActionBar.FindLastVisibleItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 0A 03 00 00 00 0F 84 15 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 0F B7 46 04 66 83 E8 12 0F 84 F0 00 00 00 66 83 E8 13 0F 84 AA 00 00 00 66 83 E8 02 0F 85 EA 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 DB 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 45 8B C3 E8 ?? ?? ?? ?? 83 78 18 00 75 38 8B C3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 4C 84 C0 75 0E 8B C3 8B 10 FF 92 10 01 00 00 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 EC 00 00 00 E9 86 00 00 00 8B B3 2C 03 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B 8B 83 2C 03 00 00 E8 ?? ?? ?? ?? 85 C0 74 5D 83 78 44 00 74 57 8B 40 44 8B 10 FF 92 EC 00 00 00 EB 4A 8B B3 2C 03 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B 8B 83 2C 03 00 00 E8 ?? ?? ?? ?? 85 C0 74 21 83 78 44 00 74 1B 8B 40 44 8B 10 FF 92 EC 00 00 00 EB 0E 8B 83 2C 03 00 00 8B 10 FF 92 AC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1168_0 {
	meta:
		name = "TCustomActionMenuBar.SetAnimateDuration"
		size = 22
	strings:
		$1 = { 85 D2 7F 0B C7 80 40 03 00 00 01 00 00 00 C3 89 90 40 03 00 00 C3 }
	condition:
		$1
}

rule function_1169_0 {
	meta:
		name = "IsScreenFont"
		size = 297
		refs = "0012 Screen 001a IsScreenFont 002d TFont.GetName 004a @UStrEqual 005d TFont.GetStyle 0090 TFont.GetPitch 00c2 TFont.GetHeight 00df TFont.GetSize 0114 @UStrArrayClr 011a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B 5D 08 83 C3 FC 8B 35 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 03 8B 40 64 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 8B 06 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 0F 85 A2 00 00 00 8B 06 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 50 8B 03 8B 40 64 E8 ?? ?? ?? ?? 5A 3A D0 0F 85 81 00 00 00 8B 03 8B 40 64 8B 40 18 8B 16 8B 92 80 00 00 00 3B 42 18 75 6C 8B 03 8B 40 64 E8 ?? ?? ?? ?? 50 8B 06 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 5A 3A D0 75 4F 8B 03 8B 40 64 8B 40 1C 8B 16 8B 92 80 00 00 00 3B 42 1C 75 3A 8B 03 8B 40 64 E8 ?? ?? ?? ?? 8B F8 8B 06 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 3B F8 75 1D 8B 03 8B 40 64 E8 ?? ?? ?? ?? 8B D8 8B 06 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 3B D8 74 04 33 C0 EB 02 B0 01 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1170_0 {
	meta:
		name = "TCustomActionMenuBar.CMFontchanged"
		size = 48
		refs = "000c TWinControl.CMFontChanged 0012 IsScreenFont 0028 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 51 56 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B 55 FC 88 82 58 03 00 00 8B 45 FC 66 BE EE FF E8 ?? ?? ?? ?? 5E 59 5D C3 }
	condition:
		$1
}

rule function_1171_0 {
	meta:
		name = "TCustomActionMenuBar.Notification"
		size = 86
		refs = "0010 TCustomActionBar.Notification 001d _Dn_TCustomActionControl 0022 @IsClass"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 FB 01 75 39 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 28 8B 87 AC 01 00 00 3B 86 7C 03 00 00 75 0A 33 C0 89 86 7C 03 00 00 EB 10 3B BE 0C 03 00 00 75 08 33 C0 89 86 0C 03 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1172_0 {
	meta:
		name = "TCustomActionMenuBar.DoMouseIdle"
		size = 21
		refs = "0005 GetCursorPos 000e FindDragTarget"
	strings:
		$1 = { 83 C4 F8 54 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 59 5A C3 }
	condition:
		$1
}

rule function_1173_0 {
	meta:
		name = "TCustomActionMenuBar.DoActionIdle"
		size = 110
		refs = "0004 Screen 000b TScreen.GetCustomFormCount 0023 TScreen.GetCustomForms 002c TWinControl.HandleAllocated 0037 TWinControl.GetHandle 003d IsWindowVisible 004e IsWindowEnabled 0062 TControl.Perform"
	strings:
		$1 = { 53 56 57 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 54 46 33 FF A1 ?? ?? ?? ?? 8B 00 8B D7 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 32 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 21 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 10 6A 00 33 C9 BA 45 B0 00 00 8B C3 E8 ?? ?? ?? ?? 47 4E 75 AF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1174_0 {
	meta:
		name = "TCustomActionMenuBar.ActionIdleTimerProc"
		size = 87
		refs = "000c TCustomActionMenuBar.ActionIdleTimerProc 001f TTimer.SetEnabled 0026 TCustomActionMenuBar.DoActionIdle 0035 @HandleAnyException 003b Application 0049 TApplication.HandleException 004e @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 F8 02 00 00 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1E E9 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1175_0 {
	meta:
		name = "TCustomActionMenuBar.Idle"
		size = 401
		refs = "0015 TCustomActionMenuBar.Idle 0020 Application 0043 TApplication.CancelHint 004b TCustomActionMenuBar.GetSelected 005c TActionClientItem.GetAction 0078 GetLongHint 0087 TApplication.SetHint 00f1 TCustomActionMenuBar.DoActionIdle 010d TTimer.SetInterval 011d TTimer.SetEnabled 012c @HandleAnyException 013b TApplication.HandleException 0140 @DoneExcept 0145 GetCurrentThreadId 014b MainThreadID 0156 CheckSynchronize 0169 WaitMessage 017e @UStrClr 0184 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 80 B8 84 00 00 00 00 74 18 8B 45 FC 83 B8 0C 03 00 00 00 75 0C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 3A 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 29 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 7C 8D 55 F4 E8 ?? ?? ?? ?? 8B 55 F4 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? EB 0C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C6 45 FB 01 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 A1 ?? ?? ?? ?? 8B 00 66 83 B8 32 01 00 00 00 74 1A 8B 1D ?? ?? ?? ?? 8B 1B 8D 4D FB 8B 55 FC 8B 83 34 01 00 00 FF 93 30 01 00 00 80 7D FB 00 74 45 A1 ?? ?? ?? ?? 8B 00 8B 90 BC 00 00 00 85 D2 7F 0A 8B 45 FC E8 ?? ?? ?? ?? EB 2A 8B 45 FC 8B 80 F8 02 00 00 80 78 40 00 75 1B 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 80 F8 02 00 00 B2 01 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 19 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 02 75 0F 33 C0 E8 ?? ?? ?? ?? 84 C0 74 04 C6 45 FB 00 80 7D FB 00 74 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1176_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMessage"
		size = 106
		refs = "0007 Application 0019 PeekMessage 002e TApplication.IsHintMsg 003b TApplication.IsMDIMsg 005a TranslateMessage 0060 DispatchMessage"
	strings:
		$1 = { 53 56 57 8B F2 8B 3D ?? ?? ?? ?? 8B 3F 33 DB 6A 01 6A 00 6A 00 6A 00 56 E8 ?? ?? ?? ?? 85 C0 74 43 B3 01 83 7E 04 12 74 3B 8B D6 8B C7 E8 ?? ?? ?? ?? 84 C0 75 2E 8B D6 8B C7 E8 ?? ?? ?? ?? 84 C0 75 21 8B 46 04 3D 00 01 00 00 72 0B 3D 09 01 00 00 77 04 33 DB EB 0C 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1177_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMessages"
		size = 24
		refs = "000b TCustomActionMenuBar.ProcessMessage"
	strings:
		$1 = { 53 83 C4 E4 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 84 C0 75 F3 83 C4 1C 5B C3 }
	condition:
		$1
}

rule function_19726_0 {
	meta:
		name = "TApplication.ProcessMessages"
		size = 24
		refs = "000b TApplication.ProcessMessage"
	strings:
		$1 = { 53 83 C4 E4 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 84 C0 75 F3 83 C4 1C 5B C3 }
	condition:
		$1
}

rule function_1178_0 {
	meta:
		name = "TCustomActionMenuBar.Style"
		size = 34
		refs = "001c TCustomActionBar.Style"
	strings:
		$1 = { 56 8B B0 2C 03 00 00 85 F6 74 10 3B F0 74 0C 8B C6 8B 10 FF 92 5C 01 00 00 5E C3 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1179_0 {
	meta:
		name = "TCustomActionMenuBar.SetUseSystemFont"
		size = 44
		refs = "0016 Screen"
	strings:
		$1 = { 56 8B F0 3A 96 58 03 00 00 74 1F 88 96 58 03 00 00 84 D2 74 15 A1 ?? ?? ?? ?? 8B 00 8B 90 80 00 00 00 8B 46 64 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1180_0 {
	meta:
		name = "TCustomActionMenuBar.Loaded"
		size = 42
		refs = "0006 TCustomActionDockBar.Loaded 0014 Screen"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 58 03 00 00 00 74 15 A1 ?? ?? ?? ?? 8B 00 8B 90 80 00 00 00 8B 43 64 8B 08 FF 51 08 5B C3 }
	condition:
		$1
}

rule function_1181_0 {
	meta:
		name = "TCustomActionMenuBar.RecreateControls"
		size = 31
		refs = "0012 TObject.Free 0019 TCustomActionBar.RecreateControls"
	strings:
		$1 = { 53 8B D8 8D 83 5C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1182_0 {
	meta:
		name = "TCustomActionMenuBar.SetMouseControl"
		size = 49
		refs = "0017 TComponent.RemoveFreeNotification 002a TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 0C 03 00 00 3B F0 74 1E 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8B C6 89 83 0C 03 00 00 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1183_0 {
	meta:
		name = "TCustomMenuExpandBtn.Create"
		size = 132
		refs = "000a @ClassCreate 0017 TCustomUtilityButton.Create 0020 TControl.SetAlign 0033 TCustomUtilityButton.SetArrowSize 003e SExpand 0043 LoadResString 004c TCustomUtilityButton.SetArrowType 0055 TCustomUtilityButton.SetDirection 005e TCustomMenuExpandBtn.Create 006c @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 06 8B C6 E8 ?? ?? ?? ?? C6 86 0C 02 00 00 01 BA 02 00 00 00 8B C6 E8 ?? ?? ?? ?? 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 03 8B C6 E8 ?? ?? ?? ?? 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 04 00 00 }
	condition:
		$1
}

rule function_1184_0 {
	meta:
		name = "TCustomMenuExpandBtn.DragOver"
		size = 13
	strings:
		$1 = { 55 8B EC 8B 45 08 C6 00 00 5D C2 0C 00 }
	condition:
		$1
}

rule function_1185_0 {
	meta:
		name = "TCustomMenuExpandBtn.DrawBackground"
		size = 115
		refs = "0010 OffsetRect 001a InflateRect 002a TCustomMenuExpandBtn.GetMenu 002f TCustomActionBar.GetColorMap 0034 TCustomActionBarColorMap.GetUnusedColor 0044 TBrush.SetColor 006c TCustomButtonControl.DrawBackground"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 B9 01 00 00 00 33 D2 E8 ?? ?? ?? ?? 6A FC 6A FE 56 E8 ?? ?? ?? ?? 80 BB EB 01 00 00 00 74 23 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 40 8B 83 A0 01 00 00 8B 40 14 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1186_0 {
	meta:
		name = "TCustomMenuExpandBtn.DrawFrame"
		size = 65
		refs = "001d OffsetRect 002b InflateRect 0036 TCustomButtonControl.DrawFrame"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 A5 A5 8B D9 8B F0 8B C4 B9 01 00 00 00 33 D2 E8 ?? ?? ?? ?? 6A FC 6A FE 8D 44 24 08 50 E8 ?? ?? ?? ?? 8B CB 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1188_0 {
	meta:
		name = "TCustomActionPopupMenu.Create"
		size = 216
		refs = "000b @ClassCreate 001c TCustomActionMenuBar.Create 0025 TCustomActionPopupMenu.Create 0031 TControl.SetVisible 003a TControl.SetAlign 004f TWinControl.SetBorderWidth 005d TToolWindow.SetEdgeBorders 0066 TToolWindow.SetEdgeInner 006f TToolWindow.SetEdgeOuter 0078 TCustomActionBar.SetVertMargin 0081 TCustomActionBar.SetHorzMargin 0092 _Dn_TCustomActionBar 0097 @IsClass 00a8 TCustomActionBar.SetActionManager 00b1 TCustomActionPopupMenu.SetShadow 00bc @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 47 50 0B 05 ?? ?? ?? ?? 89 47 50 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? B2 02 8B C7 8B 08 FF 91 40 01 00 00 33 D2 8B C7 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 8B 08 FF 51 5C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B 96 6C 02 00 00 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 00 04 00 00 0F 00 00 00 }
	condition:
		$1
}

rule function_1189_0 {
	meta:
		name = "TCustomActionPopupMenu.Destroy"
		size = 80
		refs = "0003 @BeforeDestruction 001f TControl.SetVisible 0032 TObject.Free 003e TCustomActionMenuBar.Destroy 0049 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 68 02 00 00 85 C0 74 05 33 D2 89 50 18 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 86 8C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1190_0 {
	meta:
		name = "TCustomActionPopupMenu.AddEdges"
		size = 340
		refs = "0027 TCustomActionBar.FindPreviousVisibleItem 0036 TCustomActionBar.FindNextVisibleItem 0043 TActionClientItem.Unused 0052 TCustomActionPopupMenu.AddEdges 00ce TCustomMenuItem.SetEdges 00ea _DV_TCustomMenuItem 00ef @IsClass"
	strings:
		$1 = { 53 56 57 55 51 8B DA 8B F0 85 DB 0F 84 31 01 00 00 83 BB AC 01 00 00 00 0F 84 24 01 00 00 8B 93 AC 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B F8 8B 93 AC 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B E8 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 85 00 00 00 0F B6 05 ?? ?? ?? ?? 88 04 24 80 BE 09 03 00 00 00 74 2E 85 FF 74 0B 8B C7 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C6 8B 10 FF 92 54 01 00 00 3B 83 AC 01 00 00 74 0D 0F B6 05 ?? ?? ?? ?? 0A 04 24 88 04 24 80 BE 09 03 00 00 00 74 2E 85 ED 74 0B 8B C5 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C6 8B 10 FF 92 F8 00 00 00 3B 83 AC 01 00 00 74 0D 0F B6 05 ?? ?? ?? ?? 0A 04 24 88 04 24 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? EB 6E 85 FF 74 33 8B C7 E8 ?? ?? ?? ?? 84 C0 74 28 8B 5F 44 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 0F B6 93 E8 01 00 00 0A 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 ED 74 33 8B C5 E8 ?? ?? ?? ?? 84 C0 74 28 8B 5D 44 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 0F B6 93 E8 01 00 00 0A 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 00 00 00 00 02 00 00 00 08 00 00 00 }
	condition:
		$1
}

rule function_1191_0 {
	meta:
		name = "TCustomActionPopupMenu.CMMouseLeave"
		size = 70
		refs = "0006 TCustomActionBar.CMMouseLeave 001b TCustomActionMenuBar.GetSelected"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 10 01 00 00 84 C0 75 2C 8B C6 E8 ?? ?? ?? ?? 85 C0 74 21 8B C6 E8 ?? ?? ?? ?? 83 78 18 00 75 14 8B C6 E8 ?? ?? ?? ?? 8B 40 44 33 D2 8B 08 FF 91 E4 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1192_0 {
	meta:
		name = "TCustomActionPopupMenu.CMVisibleChanged"
		size = 46
		refs = "0027 TWinControl.CMVisibleChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 7B 57 00 74 0C 8B C3 8B 10 FF 92 B8 01 00 00 EB 0A 8B C3 8B 10 FF 92 C0 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1193_0 {
	meta:
		name = "TCustomActionPopupMenu.CreateControl"
		size = 87
		refs = "0007 TCustomActionMenuBar.CreateControl 0011 _DV_TCustomMenuItem 0016 @IsClass 003a TActionClientItem.Unused 004e TControl.SetVisible"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B C3 8B 08 FF 91 B4 01 00 00 80 BB 09 03 00 00 00 75 1F 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 10 C6 83 08 03 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1194_0 {
	meta:
		name = "TCustomActionPopupMenu.CreateControls"
		size = 48
		refs = "0006 TCustomActionDockBar.CreateControls 001f TCustomActionBar.FindFirstVisibleItem 002a TCustomActionPopupMenu.SetupExpandBtn"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 09 03 00 00 00 75 1B 80 BB 08 03 00 00 00 74 12 8B C3 E8 ?? ?? ?? ?? 85 C0 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1195_0 {
	meta:
		name = "TCustomActionPopupMenu.CreateParams"
		size = 127
		refs = "000b TWinControl.CreateParams 0014 _Dn_TCustomForm 0019 @IsClass 0050 CheckWin32Version 005b GetShadow"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 30 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 1D 8B 46 04 25 FF FF FF BF 0D 00 00 00 80 0D 00 00 00 04 0D 00 00 00 02 83 C8 00 89 46 04 C7 46 24 09 08 00 00 BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 12 8B C3 E8 ?? ?? ?? ?? 84 C0 74 07 81 4E 24 00 00 02 00 8B C3 8B 10 FF 92 10 01 00 00 84 C0 75 04 83 4E 08 08 5E 5B C3 }
	condition:
		$1
}

rule function_1197_0 {
	meta:
		name = "TCustomActionPopupMenu.ExecAction"
		size = 25
		refs = "0009 TControl.Hide 0012 TCustomActionMenuBar.ExecAction"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4605_0 {
	meta:
		name = "ObjectResourceToText"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 ObjectBinaryToText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3304_0 {
	meta:
		name = "TCategoryButtons.DoStartDrag"
		size = 25
		refs = "0009 TCategoryButtons.GenerateDragImage 0012 TControl.DoStartDrag"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10884_0 {
	meta:
		name = "TDBImage.WMLButtonDblClk"
		size = 25
		refs = "0009 TDBImage.LoadPicture 0012 TControl.WMLButtonDblClk"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11033_0 {
	meta:
		name = "TDBLookupComboBox.WMCancelMode"
		size = 25
		refs = "0009 TDBLookupComboBox.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11002_0 {
	meta:
		name = "TDBLookupListBox.WMCancelMode"
		size = 25
		refs = "0009 TDBLookupListBox.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13729_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchSchemas"
		size = 25
		refs = "0009 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 0012 TDBXBaseMetaDataReader.FetchSchemas"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21796_0 {
	meta:
		name = "TInplaceEditList.WMCancelMode"
		size = 25
		refs = "0009 TInplaceEditList.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48938_0 {
	meta:
		name = "TPieSeries.WriteData"
		size = 25
		refs = "0009 TPieSeries.RemoveOtherSlice 0012 TChartSeries.WriteData"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4324_0 {
	meta:
		name = "TStream.ReadComponentRes"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 TStream.ReadComponent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_57888_0 {
	meta:
		name = "TToolWindow.CMBorderChanged"
		size = 25
		refs = "0009 TWinControl.RecreateWnd 0012 TWinControl.CMBorderChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1198_0 {
	meta:
		name = "TCustomActionPopupMenu.Expand"
		size = 317
		refs = "0019 TWinControl.DisableAlign 0021 TCustomActionPopupMenu.Expand 003b TControl.SetVisible 0050 TCustomActionMenuBar.Expand 0058 TCustomActionBar.GetItems 005d TCollection.GetCount 0076 TActionClients.GetActionClient 0094 _DV_TCustomMenuItem 0099 @IsClass 00ed TWinControl.EnableAlign 011b TWinControl.GetHandle 0121 SendMessage 0132 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B 45 FC C6 80 09 03 00 00 01 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 8C 03 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 C0 01 00 00 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 74 46 33 DB 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 80 78 30 00 74 58 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 37 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 50 44 8B 45 FC 8B 08 FF 91 B4 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 E8 00 00 00 43 4E 75 8F 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 18 03 00 00 85 C0 74 10 8B C8 8B 50 04 8B 45 FC 8B 18 FF 93 C4 01 00 00 6A 00 6A 01 68 85 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 B8 01 00 00 C3 E9 ?? ?? ?? ?? EB B1 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1199_0 {
	meta:
		name = "TCustomActionPopupMenu.ExpandClick"
		size = 57
		refs = "0012 TMenuStack.Pop 0023 TMenuStack.Peek"
	strings:
		$1 = { 53 8B D8 EB 11 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 8B 83 2C 03 00 00 8B 80 74 03 00 00 E8 ?? ?? ?? ?? 3B D8 75 DA B2 01 8B C3 8B 08 FF 91 94 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1200_0 {
	meta:
		name = "TCustomActionPopupMenu.Popup"
		size = 148
		refs = "0018 Application 0027 TWinControl.SetParentWindow 0034 TCustomActionBar.FindFirstVisibleItem 006d TCustomActionBar.GetColorMap 0082 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 8B 10 FF 92 20 01 00 00 85 C0 74 79 A1 ?? ?? ?? ?? 8B 00 8B 90 70 01 00 00 8B C3 E8 ?? ?? ?? ?? 89 9B 2C 03 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 75 0C 33 D2 8B C3 8B 08 FF 91 94 01 00 00 8B 43 48 50 8B 43 4C 50 8B CF 8B D6 8B C3 8B 30 FF 96 88 00 00 00 B2 01 8B C3 8B 08 FF 91 44 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 38 01 00 00 B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 B0 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1201_0 {
	meta:
		name = "MonitorSize"
		size = 9
	strings:
		$1 = { 85 C0 7E 02 03 D0 8B C2 C3 }
	condition:
		$1
}

rule function_1202_0 {
	meta:
		name = "TCustomActionPopupMenu.PositionPopup"
		size = 835
		refs = "0024 Point 002d Screen 0036 TScreen.MonitorFromPoint 004c TMonitor.GetLeft 0055 TMonitor.GetWidth 0097 TMonitor.GetWorkareaRect 0145 TControl.ClientToScreen 0179 TControl.GetBoundsRect 01a5 SystemParametersInfo 020d TScreen.MonitorFromRect 024a MonitorSize 0274 _DV_TCustomMenuItem 0279 @IsClass 02ab TMonitor.GetHeight 02b7 TMonitor.GetTop 02e7 _DV_TCustomMenuButton"
	strings:
		$1 = { 53 56 57 55 83 C4 B8 8B F9 8B EA 8B D8 85 ED 74 08 85 FF 0F 85 01 01 00 00 8D 4C 24 20 8B 53 44 8B 43 40 E8 ?? ?? ?? ?? 8D 54 24 20 A1 ?? ?? ?? ?? 8B 00 33 C9 E8 ?? ?? ?? ?? 8B F0 8B 7B 40 89 3C 24 8B 43 44 89 44 24 04 8B C6 E8 ?? ?? ?? ?? 8B E8 8B C6 E8 ?? ?? ?? ?? 03 E8 03 7B 48 3B EF 7D 18 8B C6 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 03 F8 2B 7B 48 89 3C 24 8B C6 E8 ?? ?? ?? ?? 3B 43 40 7E 0A 8B C6 E8 ?? ?? ?? ?? 89 04 24 8D 54 24 28 8B C6 E8 ?? ?? ?? ?? 8B 7C 24 2C 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 03 7C 24 44 8B 43 44 03 43 4C 3B F8 7D 0A 8B 43 44 2B 43 4C 89 44 24 04 8D 54 24 28 8B C6 E8 ?? ?? ?? ?? 8B 44 24 2C 3B 43 44 7E 13 8D 54 24 28 8B C6 E8 ?? ?? ?? ?? 8B 44 24 2C 89 44 24 04 8D 54 24 28 8B C6 E8 ?? ?? ?? ?? 8B 44 24 2C 3B 44 24 04 0F 8E 1F 02 00 00 8D 54 24 28 8B C6 E8 ?? ?? ?? ?? 8B 44 24 2C 89 44 24 04 E9 07 02 00 00 0F B6 85 7F 02 00 00 2C 01 72 04 74 24 EB 49 8B 57 44 03 57 4C 8D 4C 24 20 8B 47 40 40 E8 ?? ?? ?? ?? 8D 54 24 20 8B CC 8B C5 E8 ?? ?? ?? ?? EB 46 8B 57 44 03 57 4C 8B 47 40 2B 43 48 03 47 48 8D 4C 24 20 E8 ?? ?? ?? ?? 8D 54 24 20 8B CC 8B C5 E8 ?? ?? ?? ?? EB 1F 8D 54 24 28 8B C7 E8 ?? ?? ?? ?? 8D 54 24 28 8B CC 8B 47 30 E8 ?? ?? ?? ?? 8B 47 48 01 04 24 C7 44 24 08 FF FF FF FF 6A 00 8D 44 24 0C 50 6A 00 6A 1B E8 ?? ?? ?? ?? 8D 54 24 28 8B C7 E8 ?? ?? ?? ?? 8D 54 24 28 8D 4C 24 20 8B 47 30 E8 ?? ?? ?? ?? 8B 44 24 20 89 44 24 10 8B 44 24 24 89 44 24 14 8D 54 24 28 8B C7 E8 ?? ?? ?? ?? 8D 54 24 30 8D 4C 24 20 8B 47 30 E8 ?? ?? ?? ?? 8B 44 24 20 89 44 24 18 8B 44 24 24 89 44 24 1C 8D 54 24 10 A1 ?? ?? ?? ?? 8B 00 33 C9 E8 ?? ?? ?? ?? 8B F0 8B C6 E8 ?? ?? ?? ?? 3B 04 24 7E 0A 8B C6 E8 ?? ?? ?? ?? 89 04 24 8D 54 24 28 8B C6 E8 ?? ?? ?? ?? 8B 44 24 28 89 44 24 0C 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 44 24 0C E8 ?? ?? ?? ?? 8B 14 24 03 53 48 3B C2 7D 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 44 24 0C E8 ?? ?? ?? ?? 2B 43 48 89 04 24 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 27 8B C6 E8 ?? ?? ?? ?? 03 44 24 0C 2B 45 40 03 45 48 8B 14 24 03 53 48 3B C2 7D 0C 8B 45 40 2B 43 48 83 C0 02 89 04 24 8B C6 E8 ?? ?? ?? ?? 3B 43 4C 7D 0D 8B C6 E8 ?? ?? ?? ?? 89 44 24 04 EB 60 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 6C 24 04 8B D5 03 53 4C 3B C2 7D 3E 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 20 8B C6 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 3B 44 24 14 7D 19 2B 6F 4C 2B 6B 4C 89 6C 24 04 EB 0D 2B 6B 4C 03 6F 4C 83 C5 03 89 6C 24 04 8B 43 48 50 8B 43 4C 50 8B 4C 24 0C 8B 54 24 08 8B C3 8B 18 FF 93 88 00 00 00 83 C4 48 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1203_0 {
	meta:
		name = "TCustomActionPopupMenu.SetupExpandBtn"
		size = 176
		refs = "002f TControl.SetAlign 004b TCustomUtilityButton.SetArrowSize 0056 SExpand 005b LoadResString 0064 TCustomUtilityButton.SetArrowType 006d TCustomUtilityButton.SetDirection 0078 TActionClient.HasBackground 0099 TCustomActionControl.SetTransparent 00a9 TCustomActionPopupMenu.ExpandClick"
	strings:
		$1 = { 53 56 8B D8 83 BB 8C 03 00 00 00 0F 85 9C 00 00 00 8B C3 8B 10 FF 92 BC 01 00 00 8B CB B2 01 FF 50 2C 8B F0 89 B3 8C 03 00 00 B2 06 8B C6 E8 ?? ?? ?? ?? C6 86 0C 02 00 00 01 8B D3 8B C6 8B 08 FF 51 68 BA 02 00 00 00 8B C6 E8 ?? ?? ?? ?? 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 03 8B C6 E8 ?? ?? ?? ?? 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 10 8B 83 68 02 00 00 0F B6 40 14 04 FD 2C 02 73 04 33 D2 EB 02 B2 01 8B C6 E8 ?? ?? ?? ?? 89 9E 04 02 00 00 C7 86 00 02 00 00 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1204_0 {
	meta:
		name = "TCustomActionPopupMenu.SetOrientation"
		size = 46
		refs = "000e @CallDynaInst 0026 TCustomActionDockBar.SetOrientation"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 8B C7 66 BE AD FF E8 ?? ?? ?? ?? 8B D3 80 FA 07 77 06 83 E2 7F 0F A3 D0 73 09 8B D3 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1205_0 {
	meta:
		name = "TCustomActionPopupMenu.WMKeyDown"
		size = 688
		refs = "0055 TCustomActionMenuBar.GetSelected 0069 TCollectionItem.GetIndex 0071 TCustomActionBar.GetItems 0077 TCollection.Insert 007e TCustomActionPopupMenu.WMKeyDown 0085 TActionClientItem.SetCaption 008f TControl.SetVisible 0107 TActionClient.GetHasItems 0124 TActionClientItem.GetAction 012d KeyboardStateToShiftState 013d TActionClient.GetItems 0142 TActionClients.Add 020a TCustomActionBar.FindLastVisibleItem 0226 @CallDynaInst 022d TCustomActionBar.FindFirstVisibleItem 0237 TCustomActionMenuBar.SelectItem 028e NotifyDesigner 0297 TCustomActionMenuBar.WMKeyDown"
	strings:
		$1 = { 53 56 57 55 8B F2 8B F8 0F B7 46 04 83 F8 28 7F 1D 0F 84 CF 01 00 00 83 E8 25 0F 84 85 00 00 00 83 E8 02 0F 84 B9 00 00 00 E9 64 02 00 00 83 E8 2D 0F 84 06 02 00 00 83 E8 40 0F 85 52 02 00 00 8B C7 8B 10 FF 92 10 01 00 00 84 C0 0F 84 40 02 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 31 02 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B E8 BA ?? ?? ?? ?? 8B C5 E8 ?? ?? ?? ?? 8B 45 44 B2 01 E8 ?? ?? ?? ?? 8B 45 44 B2 01 8B 08 FF 91 E4 00 00 00 E9 ED 01 00 00 8B 87 64 03 00 00 85 C0 74 19 C6 80 0A 03 00 00 00 33 C0 89 87 64 03 00 00 33 C0 89 46 0C E9 CA 01 00 00 8B 87 14 03 00 00 85 C0 0F 84 BC 01 00 00 8B D6 8B 08 FF 51 EC E9 B0 01 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 DB 00 00 00 8B C7 8B 10 FF 92 10 01 00 00 84 C0 74 59 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 49 8B C7 E8 ?? ?? ?? ?? 80 78 54 00 75 3C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 2C E8 ?? ?? ?? ?? A8 04 74 23 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 80 00 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 45 8B C7 E8 ?? ?? ?? ?? 83 78 18 00 75 38 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 4C 84 C0 75 0E 8B C7 8B 10 FF 92 10 01 00 00 84 C0 74 17 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 EC 00 00 00 E9 E5 00 00 00 83 BF 74 03 00 00 00 0F 85 D8 00 00 00 8B D6 8B 87 2C 03 00 00 8B 08 FF 51 EC E9 C6 00 00 00 8B 87 2C 03 00 00 3B F8 0F 84 B8 00 00 00 8B D6 8B 08 FF 51 EC E9 AC 00 00 00 66 83 7E 04 28 0F 85 A1 00 00 00 80 BF 08 03 00 00 00 0F 84 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D8 8B C7 E8 ?? ?? ?? ?? 3B D8 74 09 E8 ?? ?? ?? ?? A8 04 74 77 8B 87 8C 03 00 00 66 BE EB FF E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 50 44 8B C7 E8 ?? ?? ?? ?? EB 5E F6 47 1C 10 74 58 8B C7 E8 ?? ?? ?? ?? 85 C0 74 4D 8B C7 E8 ?? ?? ?? ?? 8B E8 8B C5 E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? A8 01 74 01 43 8B 87 68 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B E8 8B 45 44 B2 01 8B 08 FF 91 E4 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1206_0 {
	meta:
		name = "TCustomActionPopupMenu.WMPrint"
		size = 31
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 F0 8B 56 04 8B C3 8B 08 FF 91 DC 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1207_0 {
	meta:
		name = "TCustomActionPopupMenu.WMPrintClient"
		size = 184
		refs = "0016 TCanvas.GetHandle 0021 TCustomActionPopupMenu.WMPrintClient 0038 TCanvas.SetHandle 0040 TCustomActionBar.GetColorMap 0054 TBrush.SetColor 005f TControl.GetBoundsRect 0070 TCanvas.FillRect 007a TWinControl.WMPrintClient 0089 TWinControl.PaintTo 00ad @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 8B DA 89 45 FC 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 04 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 50 40 8B 45 FC 8B 80 74 02 00 00 8B 40 14 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8D 55 E8 8B 45 FC 8B 80 74 02 00 00 E8 ?? ?? ?? ?? 8B D3 8B 45 FC E8 ?? ?? ?? ?? 6A 00 8B 53 04 33 C9 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 74 02 00 00 8B 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1208_0 {
	meta:
		name = "TCustomActionPopupMenu.ValidOrientations"
		size = 12
		refs = "0003 TCustomActionPopupMenu.ValidOrientations"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 0C 00 00 00 }
	condition:
		$1
}

rule function_52500_0 {
	meta:
		name = "GetMinimumBlockAlignment"
		size = 8
		refs = "0003 MinimumBlockAlignment"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17094_0 {
	meta:
		name = "TDesignerDebugScriptSite.BreakOnFirstStatement"
		size = 8
		refs = "0003 SetBreak"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1209_0 {
	meta:
		name = "TCustomActionPopupMenu.VisibleChanging"
		size = 372
		refs = "0008 TCustomActionBar.VisibleChanging 001b TWinControl.HandleAllocated 0026 TWinControl.GetHandle 002c IsWindowVisible 004b NotifyWinEvent 0071 TCustomActionBar.FindFirstVisibleItem 0085 TControl.SetVisible 008c TCustomActionBar.FindLastVisibleItem 00c9 TCustomActionBar.GetItems 00d0 TActionClients.GetActionClient 0100 TWinControl.HandleNeeded 010b @CallDynaInst 0133 TCustomActionMenuBar.Animate 014b sndPlaySound 0152 TCustomActionPopupMenu.VisibleChanging"
	strings:
		$1 = { 53 56 57 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 75 52 80 7B 57 00 74 39 8B C3 E8 ?? ?? ?? ?? 84 C0 74 41 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 30 3B 9B 2C 03 00 00 74 28 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 07 E8 ?? ?? ?? ?? EB 13 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 06 E8 ?? ?? ?? ?? 80 7B 57 00 0F 85 ED 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 80 78 54 00 74 0A 33 D2 8B 40 44 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 80 78 54 00 74 0A 33 D2 8B 40 44 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 10 01 00 00 84 C0 75 42 8B C3 8B 10 FF 92 20 01 00 00 8B F8 4F 85 FF 7C 31 47 33 F6 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 3C 00 74 16 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 3C 8B 10 FF 52 1C 46 4F 75 D2 83 BB 68 02 00 00 00 74 5E 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BE EE FF E8 ?? ?? ?? ?? 8B 8B 18 03 00 00 8B 93 14 03 00 00 8B C3 8B 30 FF 96 C4 01 00 00 83 BB 14 03 00 00 00 74 09 B2 01 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 75 1E 83 BB 2C 03 00 00 00 74 15 6A 02 6A 00 E8 ?? ?? ?? ?? 6A 13 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C3 00 4D 00 65 00 6E 00 75 00 50 00 6F 00 70 00 75 00 70 00 00 00 }
	condition:
		$1
}

rule function_1210_0 {
	meta:
		name = "TCustomActionPopupMenu.CloseMenu"
		size = 74
		refs = "000b TControl.SetVisible 001b Mouse 0022 TMouse.GetCursorPos 0042 TCustomActionMenuBar.CloseMenu"
	strings:
		$1 = { 53 83 C4 F8 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 83 BB 2C 03 00 00 00 74 27 8B D4 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 83 2C 03 00 00 8B 14 24 89 90 6C 03 00 00 8B 54 24 04 89 90 70 03 00 00 8B C3 E8 ?? ?? ?? ?? 59 5A 5B C3 }
	condition:
		$1
}

rule function_1211_0 {
	meta:
		name = "TCustomActionPopupMenu.GetClientRect"
		size = 32
		refs = "000b TWinControl.GetClientRect"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 91 04 01 00 00 01 06 5E 5B C3 }
	condition:
		$1
}

rule function_1213_0 {
	meta:
		name = "TCustomActionPopupMenu.CanAutoSize"
		size = 38
		refs = "000c TWinControl.CanAutoSize"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D8 B2 01 8B C7 8B 08 FF 91 04 01 00 00 01 06 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1214_0 {
	meta:
		name = "TCustomActionPopupMenu.DisplayShadow"
		size = 132
		refs = "000e CheckWin32Version 0019 GetShadow 003f _Dn_TShadowWindow 0044 TShadowWindow.CreateShadow 0071 TShadowWindow.SetControl"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 6C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 61 8B C3 8B 10 FF 92 10 01 00 00 84 C0 75 53 83 BB 90 03 00 00 00 75 2C 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 90 03 00 00 6A 01 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 88 03 00 00 8B 83 90 03 00 00 85 C0 74 14 8B D3 E8 ?? ?? ?? ?? 8B D3 8B 83 88 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1215_0 {
	meta:
		name = "TCustomActionPopupMenu.HideShadow"
		size = 55
		refs = "000e CheckWin32Version 0026 TControl.Hide"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 1F 83 BB 90 03 00 00 00 74 16 8B 83 90 03 00 00 E8 ?? ?? ?? ?? 8B 83 88 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1216_0 {
	meta:
		name = "TCustomActionPopupMenu.SetColorMap"
		size = 40
		refs = "0006 TCustomActionBar.SetColorMap 000d TCustomActionBar.GetColorMap 0022 TControl.SetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 11 8B C3 E8 ?? ?? ?? ?? 8B 50 74 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1217_0 {
	meta:
		name = "TCustomActionPopupMenu.Notification"
		size = 61
		refs = "0010 TCustomActionMenuBar.Notification 0023 _Dn_TControl 0028 @IsClass 0035 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? F6 46 1C 08 75 1F 80 FB 01 75 1A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 33 D2 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1218_0 {
	meta:
		name = "TCustomActionPopupMenu.SetShadow"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 94 03 00 00 74 0B 88 90 94 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1219_0 {
	meta:
		name = "TCustomActionPopupMenu.DrawBackground"
		size = 64
		refs = "0009 TCustomActionBar.DrawBackground 0010 TCustomActionBar.GetColorMap 0021 TBrush.SetColor 0037 TCanvas.FillRect"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 50 74 8B 83 74 02 00 00 8B 40 14 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 51 44 8B D4 8B 83 74 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1220_0 {
	meta:
		name = "TCustomActionPopupMenu.NewPopup"
		size = 34
		refs = "0007 TCustomActionMenuBar.NewPopup 0010 GetShadow 0019 TCustomActionPopupMenu.SetShadow"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1221_0 {
	meta:
		name = "TCustomAddRemoveItem.CalcBounds"
		size = 117
		refs = "000b TCustomMenuItem.CalcBounds 0018 TControl.SetWidth 0030 Point 005e OffsetRect"
	strings:
		$1 = { 53 56 57 83 C4 E8 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 53 48 83 C2 12 8B C3 E8 ?? ?? ?? ?? 8D 4C 24 10 8B 83 B4 01 00 00 83 C0 12 8B 93 B8 01 00 00 E8 ?? ?? ?? ?? 8B 44 24 10 89 83 B4 01 00 00 8B 44 24 14 89 83 B8 01 00 00 8D B3 D4 01 00 00 8B FC A5 A5 A5 A5 8B C4 33 C9 BA 12 00 00 00 E8 ?? ?? ?? ?? 8B F4 8D BB D4 01 00 00 A5 A5 A5 A5 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1222_0 {
	meta:
		name = "TCustomAddRemoveItem.IsActionVisible"
		size = 127
		refs = "001e TCustomActionControl.GetActionBar 0029 TActionClient.GetItems 0032 TCollection.GetCount 0045 TActionClients.GetActionClient 004a TActionClientItem.GetAction"
	strings:
		$1 = { 53 56 57 55 51 8B E8 C6 04 24 00 8B 85 EC 01 00 00 8B 80 2C 03 00 00 8B 80 18 03 00 00 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B F8 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 38 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 85 AC 01 00 00 E8 ?? ?? ?? ?? 5A 3B D0 75 12 8B D3 8B C7 E8 ?? ?? ?? ?? 0F B6 40 30 88 04 24 EB 04 43 4E 75 CB 0F B6 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1223_0 {
	meta:
		name = "TCustomAddRemoveItem.MouseUp"
		size = 45
		refs = "0019 TCustomMenuItem.MouseUp"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 80 00 00 00 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_47687_0 {
	meta:
		name = "TRibbonComboControl.MouseDown"
		size = 45
		refs = "0019 TCustomButtonControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 80 00 00 00 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1225_0 {
	meta:
		name = "TCustomizeActionToolBar.Create"
		size = 82
		refs = "000b @ClassCreate 001c TCustomActionPopupMenu.Create 0024 _Dn_TCustomActionToolBar 0029 @IsClass 003e @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 89 B7 A4 03 00 00 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1226_0 {
	meta:
		name = "TCustomizeActionToolBar.Destroy"
		size = 48
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001e TCustomActionPopupMenu.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 9C 03 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1227_0 {
	meta:
		name = "TCustomizeActionToolBar.CanAutoSize"
		size = 51
		refs = "000f TCustomActionPopupMenu.CanAutoSize 0022 TOrderedList.Count"
	strings:
		$1 = { 53 56 57 51 89 0C 24 8B F8 8B 0C 24 8B C7 E8 ?? ?? ?? ?? 8B D8 8B B7 74 03 00 00 85 F6 74 0D 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 02 33 DB 8B C3 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1229_0 {
	meta:
		name = "TCustomizeActionToolBar.CMItemSelected"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 AC 01 00 00 C3 }
	condition:
		$1
}

rule function_1230_0 {
	meta:
		name = "TCustomizeActionToolBar.GetActionControl"
		size = 53
		refs = "001f TActionClient.GetItems 0026 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 7C 26 8B C3 8B 10 FF 92 20 01 00 00 3B F0 7D 18 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1231_0 {
	meta:
		name = "TCustomizeActionToolBar.ItemCount"
		size = 34
		refs = "0011 TActionClient.GetItems 0016 TCollection.GetCount"
	strings:
		$1 = { 53 56 8B D8 8B B3 68 02 00 00 85 F6 74 0F 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1232_0 {
	meta:
		name = "FindItem"
		size = 126
		refs = "0024 TCustomActionControl.GetActionBar 002f TActionClient.GetItems 0038 TCollection.GetCount 004b TActionClients.GetActionClient 0050 TActionClientItem.GetAction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 33 C0 89 45 F8 8B 45 08 8B 40 FC 8B 80 2C 03 00 00 8B 80 18 03 00 00 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B F8 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 31 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 3B D0 75 0E 8B D3 8B C7 E8 ?? ?? ?? ?? 89 45 F8 EB 04 43 4E 75 D2 8B 45 F8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1233_0 {
	meta:
		name = "TCustomizeActionToolBar.DoItemClicked"
		size = 317
		refs = "002d @IsClass 0041 FindItem 0066 TControl.SetVisible 0073 TCollectionItem.GetIndex 0088 TCustomActionControl.GetActionBar 0093 TActionClient.GetItems 0099 TCollection.Insert 00a6 TActionClientItem.GetAction 00af TActionClientItem.SetAction 00bd TWinControl.Realign 011e TWinControl.GetHandle 0124 PostMessage 0130 TCustomActionMenuBar.DoItemClicked"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 0F 85 CC 00 00 00 8B 45 FC 8B 10 FF 92 CC 01 00 00 8B D0 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 B0 00 00 00 55 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 59 8B F0 85 F6 74 20 0F B6 56 30 80 F2 01 8B C6 8B 08 FF 51 2C 80 7E 30 00 75 53 8B 46 44 33 D2 E8 ?? ?? ?? ?? EB 47 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 2C 03 00 00 8B 80 18 03 00 00 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F0 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 A4 03 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B B0 A4 03 00 00 8B C6 8B 50 48 52 8B 50 4C 52 8B D6 8B 48 44 8B 40 40 92 8B 18 FF 93 88 00 00 00 33 DB EB 4D 8B 45 FC 8B 80 A0 03 00 00 3B 83 AC 01 00 00 75 30 8B 45 FC 8B 10 FF 92 AC 01 00 00 8B 9B AC 01 00 00 6A 00 6A 00 68 09 B4 00 00 8B 45 FC 8B 80 A4 03 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 0C 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1234_0 {
	meta:
		name = "TCustomizeActionToolBar.GetSubMenuControlClass"
		size = 94
		refs = "000d _Dn_TActionClientItem 0012 @IsClass 001d TActionClientItem.GetParentItem 0043 @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 3E 8B C6 E8 ?? ?? ?? ?? 3B 83 98 03 00 00 75 11 8B C3 8B 10 FF 92 CC 01 00 00 8B 55 08 89 02 EB 1E 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 1C 01 00 00 8B 55 08 89 02 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1235_0 {
	meta:
		name = "TCustomizeActionToolBar.NewPopup"
		size = 54
		refs = "0007 TCustomActionPopupMenu.NewPopup 0024 GetShadow 002d TCustomActionPopupMenu.SetShadow"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 89 9E 94 02 00 00 8B 03 8B 80 D0 01 00 00 89 86 90 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1236_0 {
	meta:
		name = "AddSeparator"
		size = 48
		refs = "0002 TActionClients.Add 0009 AddSeparator 0010 TActionClientItem.SetCaption 001a TActionClientItem.SetUsageCount"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 CA FF 8B C3 E8 ?? ?? ?? ?? 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1237_0 {
	meta:
		name = "AddItems"
		size = 179
		refs = "002e TCollection.GetCount 0041 TActionClients.GetActionClient 0046 TActionClientItem.GetAction 0073 TActionClients.Add 0092 TActionClient.SetItems 009c TActionClientItem.SetUsageCount"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 4D F8 89 55 FC 8B F8 8B 45 F8 85 C0 0F 8C 90 00 00 00 40 89 45 EC C7 45 F4 00 00 00 00 C6 45 F3 00 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 31 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 3B D0 75 06 C6 45 F3 01 EB 04 46 4B 75 D2 80 7D F3 00 75 30 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 51 08 33 D2 8B C3 E8 ?? ?? ?? ?? 83 CA FF 8B C3 E8 ?? ?? ?? ?? FF 45 F4 FF 4D EC 0F 85 7B FF FF FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1238_0 {
	meta:
		name = "TCustomizeActionToolBar.DoAddCustomizeItems"
		size = 476
		refs = "0014 TCustomizeActionToolBar.DoAddCustomizeItems 0053 TCollectionItem.GetIndex 0066 TCollection.FindItemID 0077 TActionClient.GetItems 007c TCollection.GetCount 008c AddSeparator 0098 TActionClients.Add 00a6 SAddRemoveButtons 00ab LoadResString 00b9 TActionClientItem.SetCaption 00e1 AddItems 00f2 TCustomActionControl.GetActionBar 0140 _Dn_TCustomAction 0145 TCustomAction.Create 0155 SResetActionToolBar 0164 TCustomAction.SetCaption 01a5 TActionClientItem.SetAction 01af TActionClientItem.SetUsageCount 01c9 @UStrArrayClr 01cf @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 0F 84 8D 01 00 00 83 BB A4 03 00 00 00 0F 84 80 01 00 00 33 F6 8B 83 A4 03 00 00 8B 90 6C 02 00 00 83 BA 90 00 00 00 00 74 22 8B F0 8B 86 68 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 86 6C 02 00 00 8B 80 90 00 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 3F 01 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 0C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 98 03 00 00 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 83 98 03 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 50 8B 83 98 03 00 00 E8 ?? ?? ?? ?? 5A 59 E8 ?? ?? ?? ?? 8B 83 2C 03 00 00 8B 80 18 03 00 00 E8 ?? ?? ?? ?? 8B 80 68 02 00 00 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E8 02 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 83 98 03 00 00 E8 ?? ?? ?? ?? 5A 59 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 78 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 9C 03 00 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8B C6 E8 ?? ?? ?? ?? 8B 83 98 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 0C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 A0 03 00 00 8B 93 9C 03 00 00 8B C6 E8 ?? ?? ?? ?? 83 CA FF 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1239_0 {
	meta:
		name = "TCustomizeActionToolBar.SetActionClient"
		size = 45
		refs = "0017 TCustomActionBar.SetActionClient 0022 TActionClient.GetItems"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 91 C8 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 83 68 02 00 00 E8 ?? ?? ?? ?? C6 40 24 00 5E 5B C3 }
	condition:
		$1
}

rule function_1240_0 {
	meta:
		name = "TCustomizeActionToolBar.GetAddRemoveItemClass"
		size = 59
		refs = "0025 ActionBarStyles 002e TActionBarStyleList.GetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 5C 01 00 00 85 C0 74 13 8B C3 8B 10 FF 92 5C 01 00 00 8B D3 8B 08 FF 51 10 5B C3 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 10 5B C3 }
	condition:
		$1
}

rule function_1241_0 {
	meta:
		name = "TCustomizeActionLink.SetEnabled"
		size = 26
	strings:
		$1 = { 56 57 8B F0 8B 46 18 8B 78 44 85 FF 74 09 8B C7 B2 01 8B 08 FF 51 64 5F 5E C3 }
	condition:
		$1
}

rule function_1243_0 {
	meta:
		name = "TCustomMDIMenuButton.Paint"
		size = 101
		refs = "0011 MouseStyles 0020 ButtonStyles 0035 PushStyles 0056 TCanvas.GetHandle 005c DrawFrameControl"
	strings:
		$1 = { 53 83 C4 F0 8B D8 0F B6 83 C1 01 00 00 0F B7 04 45 ?? ?? ?? ?? 0F B6 93 C8 01 00 00 66 0B 04 55 ?? ?? ?? ?? 80 BB C2 01 00 00 02 0F 94 C2 83 E2 7F 66 0B 04 55 ?? ?? ?? ?? 0F B7 C0 50 6A 01 8D 54 24 08 8B C3 8B 08 FF 51 44 8D 44 24 08 50 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1244_0 {
	meta:
		name = "TCustomActionMainMenuBar.Create"
		size = 244
		refs = "0010 @ClassCreate 001d TCustomActionMenuBar.Create 0026 TCustomActionMainMenuBar.Create 0037 TToolWindow.SetEdgeBorders 0040 TToolWindow.SetEdgeInner 0049 TToolWindow.SetEdgeOuter 005b SystemParametersInfo 0064 TControl.SetAlign 0088 TCustomActionBar.SetHorzMargin 0094 TControl.SetHeight 009d TWinControl.SetTabStop 00ae TCustomActionMainMenuBar.MainWndHook 00be Application 00cc SendMessage 00d7 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 0F B6 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 02 8B C6 E8 ?? ?? ?? ?? 6A 00 8D 45 FC 50 6A 00 68 0A 10 00 00 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 83 7D FC 01 1B D2 42 8B C6 8B 08 FF 91 44 01 00 00 C6 86 70 02 00 00 00 BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 1D 00 00 00 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 8E 03 00 00 01 89 75 F4 C7 45 F0 ?? ?? ?? ?? 8D 45 F0 50 6A 00 68 20 B0 00 00 A1 ?? ?? ?? ?? 8B 00 8B 80 70 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 00 00 00 00 00 01 00 }
	condition:
		$1
}

rule function_1245_0 {
	meta:
		name = "TCustomActionMainMenuBar.Destroy"
		size = 82
		refs = "0006 @BeforeDestruction 0015 TCustomActionMainMenuBar.MainWndHook 0024 Application 0032 SendMessage 003e TCustomActionMenuBar.Destroy 0049 @ClassDestroy"
	strings:
		$1 = { 53 56 83 C4 F8 E8 ?? ?? ?? ?? 8B DA 8B F0 89 74 24 04 C7 04 24 ?? ?? ?? ?? 8B C4 50 6A 01 68 20 B0 00 00 A1 ?? ?? ?? ?? 8B 00 8B 80 70 01 00 00 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1246_0 {
	meta:
		name = "TCustomActionMainMenuBar.Clear"
		size = 90
		refs = "000c TCustomActionMainMenuBar.Clear 0020 @UStrLAsg 0027 TCustomActionBar.Clear 0035 @UStrAsg 004a @UStrClr 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 93 90 03 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8D 83 90 03 00 00 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1247_0 {
	meta:
		name = "TCustomActionMainMenuBar.CloseMenu"
		size = 19
		refs = "0006 TCustomActionMenuBar.ClearSubMenus 000d TCustomActionMenuBar.CloseMenu"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48696_0 {
	meta:
		name = "TAreaSeries.GalleryChanged3D"
		size = 19
		refs = "0006 TCustomChartSeries.GalleryChanged3D 000d TAreaSeries.SetGalleryFormat"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48714_0 {
	meta:
		name = "TAreaSeries.PrepareForGallery"
		size = 19
		refs = "0006 TChartSeries.PrepareForGallery 000d TAreaSeries.SetGalleryFormat"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_55808_0 {
	meta:
		name = "TChartGalleryPanel.Resize"
		size = 19
		refs = "0006 TControl.Resize 000d TChartGalleryPanel.ResizeCharts"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3902_0 {
	meta:
		name = "TCheckListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3899_0 {
	meta:
		name = "TCheckListBox.CreateWnd"
		size = 19
		refs = "0006 TCustomListBox.CreateWnd 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_58318_0 {
	meta:
		name = "TComplexData.DoArcCot"
		size = 19
		refs = "0006 TComplexData.DoInverse 000d TComplexData.DoArcTan"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_58326_0 {
	meta:
		name = "TComplexData.DoSecH"
		size = 19
		refs = "0006 TComplexData.DoCosH 000d TComplexData.DoInverse"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6333_0 {
	meta:
		name = "TCoolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6286_0 {
	meta:
		name = "TCoolBar.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCoolBar.UpdateBands"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_51650_0 {
	meta:
		name = "TCustomCheckBox.Click"
		size = 19
		refs = "0006 TControl.Changed 000d TControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11370_0 {
	meta:
		name = "TCustomDBGrid.TopLeftChanged"
		size = 19
		refs = "0006 TCustomDBGrid.InvalidateTitles 000d TCustomGrid.TopLeftChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11359_0 {
	meta:
		name = "TCustomDBGrid.WMIMEStartComp"
		size = 19
		refs = "0006 TWinControl.WMIMEStartComp 000d TCustomGrid.ShowEditor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9881_0 {
	meta:
		name = "TCustomDataSetAdapter.AddDefaultFields"
		size = 19
		refs = "0006 AddDefaultDataSetFields 000d TCustomDataSetAdapter.CreateDataLink"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21665_0 {
	meta:
		name = "TCustomGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21670_0 {
	meta:
		name = "TCustomGrid.ColWidthsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21671_0 {
	meta:
		name = "TCustomGrid.RowHeightsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21662_0 {
	meta:
		name = "TCustomGrid.WMCancelMode"
		size = 19
		refs = "0006 TControl.WMCancelMode 000d TCustomGrid.CancelMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18982_0 {
	meta:
		name = "TCustomLinkLabel.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomLinkLabel.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18981_0 {
	meta:
		name = "TCustomLinkLabel.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TCustomLinkLabel.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_51732_0 {
	meta:
		name = "TCustomListBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d TCustomListBox.SetColumnWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18704_0 {
	meta:
		name = "TCustomRadioGroup.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18695_0 {
	meta:
		name = "TCustomRadioGroup.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18705_0 {
	meta:
		name = "TCustomRadioGroup.WMSize"
		size = 19
		refs = "0006 TCustomGroupBox.WMSize 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47218_0 {
	meta:
		name = "TCustomRibbonQuickAccessToolbar.CreateControls"
		size = 19
		refs = "0006 TCustomActionToolBar.CreateControls 000d TCustomRibbonQuickAccessToolbar.DoUpdateQATWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48404_0 {
	meta:
		name = "TCustomScreenTipsManager.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TCustomScreenTipsManager.ValidateAllocatedActions"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_49493_0 {
	meta:
		name = "TCustomShellComboBox.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellComboBox.ClearItems 000d TCustomComboBoxEx.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_49515_0 {
	meta:
		name = "TCustomShellComboBox.Loaded"
		size = 19
		refs = "0006 TCustomCombo.Loaded 000d TCustomShellComboBox.CreateRoot"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_49524_0 {
	meta:
		name = "TCustomShellListView.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellListView.ClearItems 000d TCustomListView.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_49453_0 {
	meta:
		name = "TCustomShellTreeView.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellTreeView.ClearItems 000d TCustomTreeView.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_49484_0 {
	meta:
		name = "TCustomShellTreeView.Loaded"
		size = 19
		refs = "0006 TCustomTreeView.Loaded 000d TCustomShellTreeView.CreateRoot"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_51769_0 {
	meta:
		name = "TCustomStaticText.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_51771_0 {
	meta:
		name = "TCustomStaticText.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5229_0 {
	meta:
		name = "TCustomStatusBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5232_0 {
	meta:
		name = "TCustomStatusBar.CMSysColorChange"
		size = 19
		refs = "0006 TWinControl.CMSysColorChange 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5233_0 {
	meta:
		name = "TCustomStatusBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TCustomStatusBar.SyncToSystemFont"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8088_0 {
	meta:
		name = "TCustomTransparentControl.Invalidate"
		size = 19
		refs = "0006 TCustomTransparentControl.InvalidateControlsUnderneath 000d TWinControl.Invalidate"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5527_0 {
	meta:
		name = "TCustomTreeView.DoEnter"
		size = 19
		refs = "0006 TCustomTreeView.InvalidateSelectionsRects 000d TWinControl.DoEnter"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5528_0 {
	meta:
		name = "TCustomTreeView.DoExit"
		size = 19
		refs = "0006 TWinControl.DoExit 000d TCustomTreeView.InvalidateSelectionsRects"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11094_0 {
	meta:
		name = "TDBChartEditor.CBSourcesChange"
		size = 19
		refs = "0006 TBaseSourceEditor.CBSourcesChange 000d TDBChartEditor.SetFields"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10741_0 {
	meta:
		name = "TDBComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TDBComboBox.SetEditReadOnly"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11452_0 {
	meta:
		name = "TDBLookupCombo.CMFontChanged"
		size = 19
		refs = "0006 TCustomEdit.CMFontChanged 000d TDBLookupCombo.GetMinHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10979_0 {
	meta:
		name = "TDBLookupListBox.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TDBLookupListBox.UpdateScrollBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13728_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchDataTypes"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchDataTypes"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13742_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchReservedWords"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchReservedWords"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13741_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchRoles"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchRoles"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_13740_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchUsers"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchUsers"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19064_0 {
	meta:
		name = "TDirectoryListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TDirectoryListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19059_0 {
	meta:
		name = "TDirectoryListBox.DblClick"
		size = 19
		refs = "0006 TControl.DblClick 000d TDirectoryListBox.OpenCurrent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19092_0 {
	meta:
		name = "TFileListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TFileListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19100_0 {
	meta:
		name = "TFilterComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TFilterComboBox.BuildList"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_20945_0 {
	meta:
		name = "TGIFRenderer.HaltAnimation"
		size = 19
		refs = "0006 TCustomGIFRenderer.HaltAnimation 000d TGIFRenderer.StopAnimationTimer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_23070_0 {
	meta:
		name = "TIBDatabase.DBParamsChanging"
		size = 19
		refs = "0006 TIBDatabase.EnsureInactive 000d TIBDatabase.CheckInactive"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_23732_0 {
	meta:
		name = "TIBQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TIBQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_23973_0 {
	meta:
		name = "TIBSecurityService.Loaded"
		size = 19
		refs = "0006 TIBCustomService.Loaded 000d TIBSecurityService.ClearParams"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24286_0 {
	meta:
		name = "TIBStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TIBStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_23155_0 {
	meta:
		name = "TIBTransaction.TRParamsChanging"
		size = 19
		refs = "0006 TIBTransaction.EnsureNotInTransaction 000d TIBTransaction.CheckNotInTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24892_0 {
	meta:
		name = "TIdCompressionIntercept.Disconnect"
		size = 19
		refs = "0006 TIdConnectionIntercept.Disconnect 000d TIdCompressionIntercept.DeinitCompressors"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_28083_0 {
	meta:
		name = "TIdMessage.Clear"
		size = 19
		refs = "0006 TIdMessage.ClearHeader 000d TIdMessage.ClearBody"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_42802_0 {
	meta:
		name = "TMediaPlayer.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d TMediaPlayer.Adjust"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_52699_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 19
		refs = "0006 TObject.CleanupInstance 000d @FreeMem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5145_0 {
	meta:
		name = "TPageControl.Loaded"
		size = 19
		refs = "0006 TCustomTabControl.Loaded 000d TPageControl.UpdateTabHighlights"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48683_0 {
	meta:
		name = "TPointSeries.Assign"
		size = 19
		refs = "0006 TCustomSeries.Assign 000d TPointSeries.SetFixed"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_46546_0 {
	meta:
		name = "TPrinter.Refresh"
		size = 19
		refs = "0006 TPrinter.FreeFonts 000d TPrinter.FreePrinters"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12125_0 {
	meta:
		name = "TQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47840_0 {
	meta:
		name = "TRibbonApplicationPopupMenu.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TRibbonApplicationPopupMenu.CreateWindowRegion"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47778_0 {
	meta:
		name = "TRibbonSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TRibbonSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48480_0 {
	meta:
		name = "TScreenTipsWindow.CMMouseLeave"
		size = 19
		refs = "0006 TControl.CMMouseLeave 000d TScreenTipsWindow.HideHint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_48479_0 {
	meta:
		name = "TScreenTipsWindow.CMMouseenter"
		size = 19
		refs = "0006 TControl.CMMouseEnter 000d TScreenTipsWindow.HideHint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_50670_0 {
	meta:
		name = "TSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12092_0 {
	meta:
		name = "TStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_56695_0 {
	meta:
		name = "TTeeSeriesSource.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TTeeSeriesSource.Refresh"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6179_0 {
	meta:
		name = "TToolBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6182_0 {
	meta:
		name = "TToolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_58252_0 {
	meta:
		name = "TValueListStrings.Clear"
		size = 19
		refs = "0006 TStringList.Clear 000d TValueListStrings.FreeItemProps"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_65994_0 {
	meta:
		name = "TXMLTypedSchemaItem.SetRefItem"
		size = 19
		refs = "0006 TXMLSchemaItem.SetRefItem 000d TXMLTypedSchemaItem.RemoveTypeInfo"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1248_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMKeyDown"
		size = 355
		refs = "004e @CallDynaInst 006f TCustomActionMenuBar.GetSelected 0091 TActionClient.GetHasItems 009a KeyboardStateToShiftState 00ae TActionClient.GetItems 00b3 TActionClients.Add 00ba NotifyDesigner 015a TCustomActionMenuBar.WMKeyDown"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 0F B6 87 7F 02 00 00 8B D0 80 EA 02 72 0E 80 EA 02 0F 82 EA 00 00 00 E9 31 01 00 00 0F B7 55 04 66 83 EA 25 74 29 66 FF CA 74 39 66 FF CA 74 0A 66 FF CA 74 2F E9 13 01 00 00 84 C0 0F 94 C2 8B C7 66 BE AE FF E8 ?? ?? ?? ?? E9 FE 00 00 00 84 C0 0F 95 C2 8B C7 66 BE AE FF E8 ?? ?? ?? ?? E9 E9 00 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 DA 00 00 00 8B C7 8B 10 FF 92 10 01 00 00 84 C0 74 35 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 25 E8 ?? ?? ?? ?? A8 04 0F 84 B8 00 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 83 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 48 44 8B D7 8B C7 8B 18 FF 93 7C 01 00 00 8B F0 8B C6 8B 10 FF 92 54 01 00 00 8B 40 44 B2 01 8B 08 FF 91 E4 00 00 00 66 C7 45 04 00 00 EB 55 0F B7 45 04 66 83 E8 25 74 35 66 83 E8 02 75 3C 8B C7 E8 ?? ?? ?? ?? 85 C0 74 31 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 EC 00 00 00 EB 0D B2 01 8B C7 66 BE AE FF E8 ?? ?? ?? ?? 8B D5 8B C7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1250_0 {
	meta:
		name = "TCustomActionMainMenuBar.CreateControl"
		size = 55
		refs = "000c TCustomActionMenuBar.CreateControl 0023 @AsClass 002d TCustomActionControl.SetSpacing"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 8B D6 8B C3 8B 08 FF 91 1C 01 00 00 8B D0 8B C7 E8 ?? ?? ?? ?? BA 02 00 00 00 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1251_0 {
	meta:
		name = "TCustomActionMainMenuBar.DesignWndProc"
		size = 96
		refs = "000b TCustomActionBar.DesignWndProc 004e ActionBarDesigner"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 84 C0 75 4A 81 3B 00 01 00 00 75 42 8B 53 04 83 EA 1B 74 08 83 C2 F6 83 EA 04 73 32 83 7B 04 1B 75 2A 80 BE 0A 03 00 00 00 74 21 8B C6 8B 10 FF 92 AC 01 00 00 80 BE 7C 02 00 00 00 74 0E A1 ?? ?? ?? ?? 8B 00 8B D6 8B 08 FF 51 20 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_1252_0 {
	meta:
		name = "TCustomActionMainMenuBar.DoneMenuLoop"
		size = 51
		refs = "0007 TCustomActionMenuBar.DoneMenuLoop 001a SystemParametersInfo"
	strings:
		$1 = { 53 51 8B D8 8B C3 E8 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 6A 00 68 0A 10 00 00 E8 ?? ?? ?? ?? 83 3C 24 00 75 0C 33 D2 8B C3 8B 08 FF 91 44 01 00 00 5A 5B C3 }
	condition:
		$1
}

rule function_1253_0 {
	meta:
		name = "TCustomActionMainMenuBar.GetActiveMDIChild"
		size = 197
		refs = "003a TCustomActionMainMenuBar.GetActiveMDIChild 0054 TCustomForm.get_MDIChildCount 0067 TCustomForm.get_MDIChildren 0087 TCustomActionMainMenuBar.MDIChildMaximized 009b TCustomActionMainMenuBar.MDIChildRestored 00b8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 8B 45 FC 80 B8 8C 03 00 00 00 0F 85 A2 00 00 00 8B 45 FC 83 B8 10 03 00 00 00 0F 84 92 00 00 00 8B 45 FC C6 80 8C 03 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B B8 10 03 00 00 C6 45 FB 00 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 32 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 80 B8 83 02 00 00 02 75 19 C6 45 FB 01 8B D3 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 04 43 4E 75 D1 80 7D FB 00 75 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 8C 03 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1254_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMNCHitTest"
		size = 39
		refs = "000b TWinControl.WMNCHitTest"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 10 01 00 00 84 C0 74 07 C7 46 0C 01 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1255_0 {
	meta:
		name = "TCustomActionMainMenuBar.ProcessMouseMsg"
		size = 95
		refs = "000b TCustomActionMenuBar.ProcessMouseMsg 0023 TCustomActionMenuBar.GetMouseHoverItem 003e @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 46 04 2D 01 02 00 00 74 05 83 E8 03 75 3E 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 74 19 3B 58 04 75 2C 80 B8 CC 01 00 00 00 74 23 66 BE EB FF E8 ?? ?? ?? ?? EB 18 8B C3 8B 10 FF 92 10 01 00 00 84 C0 75 0A 8B C3 8B 10 FF 92 AC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1256_0 {
	meta:
		name = "TCustomActionMainMenuBar.CMWininichange"
		size = 40
		refs = "0006 TCustomActionBar.CMWinINIChange 0012 Screen"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 58 A1 ?? ?? ?? ?? 8B 00 8B 90 80 00 00 00 8B 46 64 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1257_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetDesignMode"
		size = 39
		refs = "0017 TCustomActionMenuBar.ClearSubMenus 0020 TCustomActionMenuBar.SetDesignMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 10 01 00 00 3A D8 74 07 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1258_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetInActive"
		size = 29
	strings:
		$1 = { 56 8B F0 3A 96 8D 03 00 00 74 10 88 96 8D 03 00 00 8B C6 8B 10 FF 92 80 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1259_0 {
	meta:
		name = "TCustomActionMainMenuBar.CMEnabledchanged"
		size = 31
		refs = "0006 TCustomActionBar.CMEnabledchanged 0019 TCustomActionMainMenuBar.SetInActive"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 4C 8B D0 80 F2 01 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1260_0 {
	meta:
		name = "TCustomActionMainMenuBar.NewPopup"
		size = 32
		refs = "0007 TCustomActionMenuBar.NewPopup 0017 TCustomActionPopupMenu.SetShadow"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 0F B6 93 8E 03 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1261_0 {
	meta:
		name = "TCustomActionMainMenuBar.Notification"
		size = 156
		refs = "0012 TCustomActionMainMenuBar.Notification 0023 TCustomActionMenuBar.Notification 0030 _Dn_TCustomButtonControl 0035 @IsClass 0050 TActionClientItem.GetCaption 005e @UStrEqual 006d @UStrAsg 008a @UStrClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 4D 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 3C 83 BE AC 01 00 00 00 74 33 8D 55 FC 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 97 90 03 00 00 E8 ?? ?? ?? ?? 75 15 8D 87 90 03 00 00 33 D2 E8 ?? ?? ?? ?? 33 C0 89 87 A4 03 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1262_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetupWindowMenu"
		size = 43
		refs = "0015 TCustomActionBar.FindItemCaption"
	strings:
		$1 = { 53 8B D8 83 BB 68 02 00 00 00 74 1D 8B 93 90 03 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0C 8B 80 AC 01 00 00 89 83 A4 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1263_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetWindowMenu"
		size = 50
		refs = "000f @UStrEqual 001e @UStrAsg 002b TCustomActionMainMenuBar.SetupWindowMenu"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 90 03 00 00 8B D6 E8 ?? ?? ?? ?? 74 1A 8D 83 90 03 00 00 8B D6 E8 ?? ?? ?? ?? F6 43 1C 01 75 07 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1264_0 {
	meta:
		name = "FindChildAction"
		size = 116
		refs = "001b TCustomActionList.GetActionCount 0038 TCustomActionList.GetAction 0059 _DV_TInternalMDIAction 005e @AsClass"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F8 33 C0 89 45 FC 8B 45 08 8B 40 FC 8B 80 88 03 00 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 45 46 33 DB 8B 45 08 8B 40 FC 8B 80 88 03 00 00 8B D3 E8 ?? ?? ?? ?? 3B B8 A0 00 00 00 75 23 8B 45 08 8B 40 FC 8B 80 88 03 00 00 8B D3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC EB 04 43 4E 75 BE 8B 45 FC 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1265_0 {
	meta:
		name = "TCustomActionMainMenuBar.RefreshMDIMenu"
		size = 548
		refs = "0018 TCustomActionMainMenuBar.RefreshMDIMenu 0069 TCustomActionMainMenuBar.GetActiveMDIChild 007f _Dn_TActionList 0084 TCustomActionList.Create 009b TActionClient.GetItems 00a0 TActionClients.Add 00b7 TActionClientItem.SetCaption 00c7 TCustomForm.get_MDIChildCount 00e0 TObject.Free 0100 TCustomForm.get_MDIChildren 0105 FindChildAction 011d TControl.GetText 0127 TCustomAction.SetCaption 013c _DV_TInternalMDIAction 0141 TWindowAction.Create 015a TContainedAction.SetActionList 0163 TCustomAction.SetGroupIndex 0175 TWindowAction.SetForm 01bf TActionClientItem.SetAction 01cd TActionClientItem.SetUsageCount 01da TCustomAction.SetChecked 01fe @UStrArrayClr 0204 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 D2 89 55 F0 89 55 F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 98 10 03 00 00 F6 43 1C 08 0F 85 B3 01 00 00 80 BB 87 02 00 00 02 0F 85 A6 01 00 00 8B 45 FC 8B 10 FF 92 10 01 00 00 84 C0 0F 85 93 01 00 00 8B 45 FC 83 B8 A4 03 00 00 00 0F 84 83 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 B8 88 03 00 00 00 75 42 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 82 88 03 00 00 8B 45 FC 8B 80 A4 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 98 A0 03 00 00 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B B8 10 03 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 15 8B 45 FC 05 A0 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 48 85 C0 0F 8C F4 00 00 00 40 89 45 F8 33 F6 55 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B D8 85 DB 74 20 8B D6 8B C7 E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B C3 E8 ?? ?? ?? ?? E9 A1 00 00 00 8B 45 FC 8B 88 88 03 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 C6 83 B0 00 00 00 00 8B 45 FC 8B 90 88 03 00 00 8B C3 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 8D 55 F0 E8 ?? ?? ?? ?? 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 A4 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 A8 00 00 00 8B 45 FC 89 83 AC 00 00 00 8B D3 8B 83 A8 00 00 00 E8 ?? ?? ?? ?? 83 CA FF 8B 83 A8 00 00 00 E8 ?? ?? ?? ?? 85 F6 75 09 B2 01 8B C3 E8 ?? ?? ?? ?? 46 FF 4D F8 0F 85 12 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1266_0 {
	meta:
		name = "SetupMDIButton"
		size = 492
		refs = "0010 _DV_TCustomMDIMenuButton 0015 TSpeedButton.Create 0020 TControl.SetVisible 0041 TControl.SetTop 0048 GetSystemMetrics 0051 TControl.SetWidth 0061 TControl.SetHeight 0074 _DV_TInternalMDIAction 0079 TWindowAction.Create 0082 TControl.SetAction 00a5 SetupMDIButton 00ac TControl.SetAnchors 00e7 TControl.SetLeft 01a1 @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B D8 8B 45 08 8B 48 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 45 08 8B 50 FC 8B C6 8B 08 FF 51 68 8B 45 08 8B 40 FC 8B 90 AC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? 6A 36 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 6A 37 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 88 9E C8 01 00 00 8B 45 08 8B 48 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 0F B6 80 7F 02 00 00 2C 01 72 0B 0F 84 9B 00 00 00 E9 F1 00 00 00 0F B6 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 86 C8 01 00 00 2C 01 72 0B 74 33 FE C8 74 55 E9 CD 00 00 00 8B 45 08 8B 40 FC 8B 50 48 8B 46 48 8D 04 40 2B D0 8B 45 08 8B 40 FC 2B 90 AC 02 00 00 4A 8B C6 E8 ?? ?? ?? ?? E9 A3 00 00 00 8B 45 08 8B 40 FC 8B 50 48 8B 46 48 03 C0 2B D0 8B 45 08 8B 40 FC 2B 90 AC 02 00 00 4A 8B C6 E8 ?? ?? ?? ?? EB 7D 8B 45 08 8B 40 FC 8B 50 48 2B 56 48 8B 45 08 8B 40 FC 2B 90 AC 02 00 00 4A 8B C6 E8 ?? ?? ?? ?? EB 5B 0F B6 86 C8 01 00 00 2C 01 72 08 74 21 FE C8 74 36 EB 48 8B 56 48 03 D2 8B 45 08 8B 40 FC 03 90 AC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? EB 2D 8B 56 48 8B 45 08 8B 40 FC 03 90 AC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? EB 14 8B 45 08 8B 40 FC 8B 90 AC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 3C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 96 C8 01 00 00 80 EA 01 72 08 74 0F FE CA 74 14 EB 19 C6 80 B0 00 00 00 03 EB 10 C6 80 B0 00 00 00 02 EB 07 C6 80 B0 00 00 00 01 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8B C6 5E 5B 5D C3 00 00 00 06 00 00 00 }
	condition:
		$1
}

rule function_1267_0 {
	meta:
		name = "TCustomActionMainMenuBar.MDIChildMaximized"
		size = 164
		refs = "0024 SetupMDIButton 0067 TWindowAction.SetForm"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC F6 43 1C 08 0F 85 8C 00 00 00 8B 45 FC 83 B8 98 03 00 00 00 75 36 55 33 C0 E8 ?? ?? ?? ?? 59 8B 55 FC 89 82 94 03 00 00 55 B0 01 E8 ?? ?? ?? ?? 59 8B 55 FC 89 82 98 03 00 00 55 B0 02 E8 ?? ?? ?? ?? 59 8B 55 FC 89 82 9C 03 00 00 8B 45 FC 8B 80 94 03 00 00 8B 10 FF 52 3C 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 98 03 00 00 8B 10 FF 52 3C 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 9C 03 00 00 8B 10 FF 52 3C 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 80 00 00 00 5B 59 5D C3 }
	condition:
		$1
}

rule function_1268_0 {
	meta:
		name = "TCustomActionMainMenuBar.MDIChildRestored"
		size = 62
		refs = "0012 TObject.Free"
	strings:
		$1 = { 53 8B D8 8D 83 94 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 98 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 9C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1269_0 {
	meta:
		name = "TCustomActionMainMenuBar.CustomAlignPosition"
		size = 131
		refs = "0050 TControl.GetBoundsRect 0076 TCustomActionDockBar.CustomAlignPosition"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B 75 08 8D 7D E8 A5 A5 A5 A5 89 4D F8 89 55 FC 8B D8 8B 75 0C 8B BB 94 03 00 00 85 FF 74 34 8B 46 08 3B 47 40 7E 2C 0F B6 83 7F 02 00 00 2C 01 72 04 74 0D EB 1D 8B 47 40 83 E8 02 89 46 08 EB 12 8D 55 D8 8B C7 E8 ?? ?? ?? ?? 8B 45 E0 83 C0 02 89 06 8B 45 18 50 8B 45 14 50 8B 45 10 50 56 8D 45 E8 50 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_1270_0 {
	meta:
		name = "TCustomActionMainMenuBar.CreateControls"
		size = 47
		refs = "0006 TCustomActionDockBar.CreateControls 0029 TCustomActionMainMenuBar.SetupWindowMenu"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 83 BB 68 02 00 00 00 74 1A 8B 83 90 03 00 00 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1271_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMSysCommand"
		size = 271
		refs = "000c GetParentForm 0012 Screen 001e Application 0084 GetCapture 009a TCustomActionBar.FindAccelItem 00c4 TCustomActionBar.FindFirstVisibleItem 00f3 TWinControl.GetHandle 00f9 PostMessage"
	strings:
		$1 = { 56 57 55 8B FA 8B F0 B2 01 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 12 3B 42 70 74 14 A1 ?? ?? ?? ?? 8B 00 83 B8 C0 00 00 00 00 0F 85 DA 00 00 00 80 BE 0A 03 00 00 00 0F 85 CD 00 00 00 8B C6 8B 10 FF 52 4C 84 C0 0F 84 BE 00 00 00 80 BE E2 01 00 00 00 0F 84 B1 00 00 00 8B 47 04 25 F0 FF 00 00 3D 00 F1 00 00 0F 85 9E 00 00 00 66 83 7F 08 20 0F 84 93 00 00 00 66 83 7F 08 2D 0F 84 88 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 7F 0F B7 47 08 66 85 C0 74 23 8B D0 8B C6 E8 ?? ?? ?? ?? 8B E8 85 ED 74 59 8B 45 44 8B 10 FF 92 EC 00 00 00 C7 47 0C 01 00 00 00 EB 45 80 BE 60 03 00 00 00 75 3C 8B C6 E8 ?? ?? ?? ?? 8B E8 B2 01 8B C6 8B 08 FF 91 44 01 00 00 85 ED 74 0D 8B 45 44 B2 01 8B 08 FF 91 E4 00 00 00 6A 00 6A 00 68 10 B4 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 86 60 03 00 00 00 C7 47 0C 01 00 00 00 5D 5F 5E C3 }
	condition:
		$1
}

rule function_1272_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMSysKeyDown"
		size = 20
		refs = "000f TCustomActionMenuBar.WMSysKeyDown"
	strings:
		$1 = { 66 83 7A 04 12 0F 94 C1 88 88 60 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1273_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMSysKeyUp"
		size = 20
		refs = "000f TWinControl.WMSysKeyUp"
	strings:
		$1 = { 66 83 7A 04 12 0F 94 C1 88 88 60 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1274_0 {
	meta:
		name = "TCustomActionMainMenuBar.MainWndHook"
		size = 84
		refs = "0036 ActionBarDesigner 004b TCustomActionMainMenuBar.SetInActive"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 06 05 00 50 FF FF 83 E8 02 73 3D C6 83 60 03 00 00 00 80 BB 0A 03 00 00 00 74 0A 8B C3 8B 10 FF 92 AC 01 00 00 80 BB 7C 02 00 00 00 74 0A A1 ?? ?? ?? ?? 83 38 00 75 10 81 3E 01 B0 00 00 0F 94 C2 8B C3 E8 ?? ?? ?? ?? 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1275_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetShadows"
		size = 33
		refs = "001c TObject.Free"
	strings:
		$1 = { 3A 90 8E 03 00 00 74 18 88 90 8E 03 00 00 05 5C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1276_0 {
	meta:
		name = "TCustomActionMainMenuBar.TrackMenu"
		size = 103
		refs = "000b TCustomActionMainMenuBar.RefreshMDIMenu 0013 TCustomActionMainMenuBar.TrackMenu 0021 TCustomActionMenuBar.TrackMenu 0043 TObject.Free 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 05 88 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 45 FC 05 A0 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CE 59 5D C3 }
	condition:
		$1
}

rule function_1277_0 {
	meta:
		name = "TCustomMenuItem.Create"
		size = 168
		refs = "0011 @ClassCreate 0022 TCustomActionControl.Create 0027 TCustomMenuItem.Create 0046 Rect 0050 TCustomActionControl.SetMargins 005c TCustomActionControl.SetSpacing 0064 _DV_TCustomActionMenuBar 0069 @IsClass 007a GetSystemMetrics 008b @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? F7 D0 23 47 50 89 47 50 6A 00 8D 45 F0 50 B9 0A 00 00 00 33 D2 B8 02 00 00 00 E8 ?? ?? ?? ?? 8D 55 F0 8B C7 E8 ?? ?? ?? ?? BA 0A 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 89 B7 EC 01 00 00 6A 0F E8 ?? ?? ?? ?? 89 87 04 02 00 00 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 8B E5 5D C3 00 00 02 00 00 00 }
	condition:
		$1
}

rule function_1278_0 {
	meta:
		name = "TCustomMenuButton.Destroy"
		size = 78
		refs = "0004 @BeforeDestruction 001b _DV_TCustomActionMenuBar 0020 @IsClass 003b TCustomActionControl.Destroy 0046 @ClassDestroy"
		altNames = "TCustomMenuItem.Destroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F8 8B B7 AC 01 00 00 85 F6 74 1D 8B 46 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B 46 18 8B 10 FF 92 AC 01 00 00 8B D3 80 E2 FC 8B C7 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1279_0 {
	meta:
		name = "TCustomMenuItem.DrawSubMenuGlyph"
		size = 230
		refs = "0018 TActionClient.GetHasItems 002b TActionClient.GetItems 0030 TActionClients.VisibleCount 004e TCustomActionControl.GetActionBar 0053 TCustomActionBar.GetColorMap 005e TPen.SetColor 007f TPen.GetColor 0089 TBrush.SetColor 00cc Point 00dd DrawArrow"
	strings:
		$1 = { 53 56 83 C4 F8 8B D8 8B B3 AC 01 00 00 85 F6 0F 84 CC 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 BD 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 A5 00 00 00 8B B3 A0 01 00 00 80 BB CC 01 00 00 00 74 19 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 64 8B 46 10 E8 ?? ?? ?? ?? EB 17 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 50 8B 46 10 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B D0 8B 46 14 E8 ?? ?? ?? ?? 80 BB CC 01 00 00 00 74 1C 8B 83 EC 01 00 00 E8 ?? ?? ?? ?? 8B 50 64 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 6A 03 8D 4C 24 04 8B 53 4C D1 FA 79 03 83 D2 00 83 EA 03 8B 43 48 83 E8 0B E8 ?? ?? ?? ?? 8D 4C 24 04 B2 01 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1280_0 {
	meta:
		name = "TCustomMenuItem.Paint"
		size = 94
		refs = "0006 TCustomActionControl.Paint 0011 TActionClient.GetHasItems 0026 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 0A 8B C3 8B 10 FF 92 F4 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 74 1C 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 74 13 80 BB CC 01 00 00 00 75 0A 8B C3 8B 10 FF 92 F8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1281_0 {
	meta:
		name = "TCustomMenuItem.DrawUnusedEdges"
		size = 199
		refs = "001c TCustomActionControl.GetActionBar 0021 TCustomActionBar.GetColorMap 0032 TPen.SetColor 0046 TCanvas.MoveTo 0057 TCanvas.LineTo 0071 TCustomActionBarColorMap.GetUnusedColor"
	strings:
		$1 = { 53 56 83 C4 F0 8B D8 8B D4 8B C3 8B 08 FF 51 44 F6 83 E8 01 00 00 02 74 42 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 58 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 8B 74 24 04 8B CE 8B 14 24 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B CE 8B 54 24 08 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? F6 83 E8 01 00 00 08 74 47 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 A0 01 00 00 8B 40 10 E8 ?? ?? ?? ?? 8B 74 24 0C 4E 8B CE 8B 14 24 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B CE 8B 54 24 08 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? F6 83 E8 01 00 00 04 74 0D F6 83 E8 01 00 00 02 74 04 FF 44 24 04 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_1282_0 {
	meta:
		name = "TCustomMenuItem.Click"
		size = 54
	strings:
		$1 = { 8B 90 EC 01 00 00 8B 92 2C 03 00 00 8B 92 10 03 00 00 85 D2 74 1F 8B 80 EC 01 00 00 8B 80 2C 03 00 00 80 B8 59 03 00 00 00 74 0A 8B C2 8B 10 FF 92 D8 00 00 00 C3 }
	condition:
		$1
}

rule function_1283_0 {
	meta:
		name = "TCustomMenuItem.Keyed"
		size = 105
		refs = "0020 _Dn_TCustomAction 0025 @IsClass 0046 TCustomAction.SetChecked 005c TWinControl.GetHandle 0062 PostMessage"
	strings:
		$1 = { 53 56 8B D8 B2 01 8B C3 8B 08 FF 91 E4 00 00 00 C6 83 F0 01 00 00 00 8B C3 8B 10 FF 52 3C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C3 8B 10 FF 52 3C 83 78 6C 00 7E 10 80 B8 95 00 00 00 00 75 07 B2 01 E8 ?? ?? ?? ?? 8B 73 30 85 F6 74 15 53 6A 00 68 04 B4 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1284_0 {
	meta:
		name = "TCustomMenuItem.SetEdges"
		size = 146
		refs = "005e TCustomActionControl.GetActionBar 0063 TCustomActionBar.FindLastVisibleItem 0080 TControl.SetHeight"
	strings:
		$1 = { 53 56 51 88 14 24 8B D8 0F B6 04 24 3A 83 E8 01 00 00 74 7A 8B 73 4C F6 04 24 02 74 0C F6 83 E8 01 00 00 02 75 03 46 EB 10 F6 04 24 02 75 0A F6 83 E8 01 00 00 02 74 01 4E F6 04 24 08 74 0C F6 83 E8 01 00 00 08 75 03 46 EB 10 F6 04 24 08 75 0A F6 83 E8 01 00 00 08 74 01 4E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 06 3B 58 44 75 01 46 0F B6 04 24 88 83 E8 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 80 00 00 00 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1285_0 {
	meta:
		name = "TCustomMenuItem.CMMouseEnter"
		size = 96
		refs = "0006 TControl.CMMouseEnter 000d TControl.GetDragMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 3C 01 74 49 C6 83 F0 01 00 00 01 B2 01 8B C3 8B 08 FF 91 E4 00 00 00 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 75 28 8B C3 8B 10 FF 52 4C 84 C0 75 1D 83 BB EC 01 00 00 00 74 14 8B 83 EC 01 00 00 8B 80 2C 03 00 00 33 D2 89 90 00 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1286_0 {
	meta:
		name = "TCustomMenuItem.CMTextchanged"
		size = 108
		refs = "000e TCustomMenuItem.CMTextchanged 001b TCustomActionControl.CMTextChanged 0025 TControl.GetText 0030 StripHotkey 003e @UStrAsg 0053 @UStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8D 83 08 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1287_0 {
	meta:
		name = "TCustomMenuItem.SetSelected"
		size = 125
		refs = "0018 TActionClientItem.GetParentItem 001e _Dn_TActionClientItem 0023 @IsClass 003b _DV_TCustomMenuItem 0065 TCustomActionControl.SetSelected 0076 TCustomActionMenuBar.DoItemSelected"
	strings:
		$1 = { 53 56 8B DA 8B F0 84 DB 75 07 C6 86 F0 01 00 00 00 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B 40 44 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 18 8B 86 AC 01 00 00 E8 ?? ?? ?? ?? 8B 40 44 B2 01 8B 08 FF 91 E4 00 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 86 EC 01 00 00 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1288_0 {
	meta:
		name = "TCustomMenuItem.DragDrop"
		size = 86
		refs = "000d TCustomActionControl.DragDrop 0014 TCustomActionControl.GetActionBar 001a _DV_TCustomActionMenuBar 001f @IsClass 003f Application 004d SetFocus"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2A 8B C3 E8 ?? ?? ?? ?? 8B 90 2C 03 00 00 85 D2 74 19 83 7A 30 00 74 13 A1 ?? ?? ?? ?? 8B 00 8B 80 70 01 00 00 50 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1289_0 {
	meta:
		name = "TCustomMenuItem.DragOver"
		size = 233
		refs = "0017 _Dn_TActionItemDragObject 001c @IsClass 003a _DV_TCustomActionMenuBar 00a5 TCustomActionControl.DragOver 00b1 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D FC 8B DA 8B F0 8B 7D 08 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 6F 8B 43 48 3B 86 AC 01 00 00 75 2F 8B 86 AC 01 00 00 8B 40 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 17 8B 86 AC 01 00 00 8B 40 18 89 45 F8 8B 45 F8 8B 10 FF 92 AC 01 00 00 8B 86 EC 01 00 00 8B 80 2C 03 00 00 8B 80 00 03 00 00 85 C0 74 1F 8B 80 AC 01 00 00 3B 43 48 75 14 8B 86 EC 01 00 00 8B 80 2C 03 00 00 33 D2 89 90 00 03 00 00 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D3 8B C6 E8 ?? ?? ?? ?? 80 3F 00 74 32 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B C6 E8 ?? ?? ?? ?? 80 B8 0A 03 00 00 00 74 0C B2 01 8B C6 8B 08 FF 91 E4 00 00 00 5F 5E 5B 59 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1290_0 {
	meta:
		name = "TCustomMenuItem.CalcBounds"
		size = 440
		refs = "001f TFont.GetStyle 0027 TCustomMenuItem.CalcBounds 002e TFont.SetStyle 0035 TCustomActionControl.CalcBounds 00d7 OffsetRect 00fb Rect 0125 TCanvas.GetHandle 0153 @UStrToPWChar 015a DrawText"
	strings:
		$1 = { 53 56 57 55 83 C4 D0 8B D8 8B 83 AC 01 00 00 85 C0 74 1F 80 78 6C 00 74 19 8B 73 64 8B C6 E8 ?? ?? ?? ?? 8B D0 0A 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 91 C0 00 00 00 8B B3 04 02 00 00 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 74 14 8B 83 04 02 00 00 B9 03 00 00 00 99 F7 F9 8B F0 03 F6 EB 0E 8B 44 24 04 83 F8 10 7E 05 8B F0 83 C6 04 83 BB AC 01 00 00 00 0F 84 22 01 00 00 8B 04 24 83 F8 10 7F 07 BF 18 00 00 00 EB 05 8B F8 83 C7 06 56 57 8D B3 D4 01 00 00 8D 7C 24 18 A5 A5 A5 A5 5F 5E 8B CE D1 F9 79 03 83 D1 00 8B 83 E0 01 00 00 D1 F8 79 03 83 D0 00 2B C8 49 BA 18 00 00 00 2B 93 D4 01 00 00 8D 44 24 10 E8 ?? ?? ?? ?? 56 57 8D 74 24 18 8D BB D4 01 00 00 A5 A5 A5 A5 5F 5E 6A 00 8D 44 24 24 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 56 57 8D 74 24 28 8D BB F4 01 00 00 A5 A5 A5 A5 5F 5E 8B 83 AC 01 00 00 66 83 78 4C 00 74 6E 8B 83 A0 01 00 00 E8 ?? ?? ?? ?? 8B E8 8B 83 AC 01 00 00 8B 40 58 89 44 24 08 8D 83 F4 01 00 00 89 44 24 0C 68 00 04 00 00 8B 44 24 10 50 6A FF 8B 44 24 14 E8 ?? ?? ?? ?? 50 55 E8 ?? ?? ?? ?? 8B 83 D8 01 00 00 89 83 F8 01 00 00 8B 83 E0 01 00 00 89 83 00 02 00 00 8B 83 DC 01 00 00 03 83 FC 01 00 00 03 C7 03 83 D0 01 00 00 EB 0C 8B 83 DC 01 00 00 03 83 D4 01 00 00 50 56 8B 4B 44 8B 53 40 8B C3 8B 18 FF 93 88 00 00 00 83 C4 30 5D 5F 5E 5B C3 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_1291_0 {
	meta:
		name = "TCustomMenuItem.CalcLayout"
		size = 88
		refs = "0009 TCustomActionControl.CalcLayout 003c Point"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 54 24 08 8B C3 8B 08 FF 91 C0 00 00 00 8B 44 24 0C D1 F8 79 03 83 D0 00 8B 53 4C D1 FA 79 03 83 D2 00 2B D0 42 8B CC 8B 83 BC 01 00 00 E8 ?? ?? ?? ?? 8B 04 24 89 83 B4 01 00 00 8B 44 24 04 89 83 B8 01 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1293_0 {
	meta:
		name = "TCustomMenuItem.DrawShadowedText"
		size = 272
		refs = "001d @UStrAddRef 0025 TCustomMenuItem.DrawShadowedText 0034 _Dn_TCustomActionBar 0039 @IsClass 0044 TCustomActionControl.GetActionBar 005b @UStrLAsg 0070 TCustomActionBar.GetColorMap 0088 TCustomActionControl.DrawShadowedText 00a2 TControl.DrawTextBiDiModeFlags 00cb OffsetRect 00fb @UStrClr 0101 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8B 7D 08 8B 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 30 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8B C3 E8 ?? ?? ?? ?? 80 B8 A0 02 00 00 00 75 0E 8D 45 10 8B 93 08 02 00 00 E8 ?? ?? ?? ?? 80 BB CC 01 00 00 00 74 0F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 78 54 8B 45 10 50 8B 45 0C 50 57 8B CE 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 A0 00 00 00 84 C0 74 50 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 56 57 8D B3 F4 01 00 00 8D 7D E0 A5 A5 A5 A5 5F 5E 8B 53 48 83 EA 15 2B 93 FC 01 00 00 8D 45 E0 33 C9 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 8B 40 58 50 8B 45 0C 50 57 8B CE 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1294_0 {
	meta:
		name = "TCustomMenuItem.DrawText"
		size = 225
		refs = "0013 @UStrAddRef 001b TCustomMenuItem.DrawText 002a _Dn_TCustomActionBar 002f @IsClass 003a TCustomActionControl.GetActionBar 0051 @UStrLAsg 0060 TCustomActionControl.DrawText 007a TControl.DrawTextBiDiModeFlags 00a1 OffsetRect 00cc @UStrClr 00d2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F1 8B FA 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 30 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8B C3 E8 ?? ?? ?? ?? 80 B8 A0 02 00 00 00 75 0E 8D 45 08 8B 93 08 02 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 8B CE 8B D7 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 A0 00 00 00 84 C0 74 49 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 89 06 56 8D B3 F4 01 00 00 8D 7D F0 A5 A5 A5 A5 5E 8B 53 48 83 EA 15 2B 93 FC 01 00 00 8D 45 F0 33 C9 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 8B 40 58 50 8B CE 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1295_0 {
	meta:
		name = "TCustomMenuItem.PositionChanged"
		size = 55
		refs = "0007 TCustomActionControl.PositionChanged"
	strings:
		$1 = { 56 57 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 86 AC 01 00 00 85 C0 74 04 C6 40 40 01 8B BE EC 01 00 00 80 BF 09 03 00 00 00 75 0C B2 01 8B C7 8B 08 FF 91 94 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule function_1296_0 {
	meta:
		name = "TCustomMenuItem.DoDragDrop"
		size = 555
		refs = "001e TCollectionItem.GetIndex 002c _Dn_TCategoryDragObject 0031 @IsClass 0041 TCustomActionControl.GetActionBar 0046 TWinControl.DisableAlign 0059 TActionClient.GetItems 006b @AsClass 0087 @CallDynaInst 00ae TCustomMenuItem.DoDragDrop 00cf TActionClientItem.SetUsageCount 00dd TActionClientItem.SetCaption 00f9 TActionClientItem.SetLastSession 0118 TActionDragObject.GetActionCount 015e TActionDragObject.GetAction 0167 TActionClientItem.SetAction 01c5 @HandleFinally 01f9 TWinControl.EnableAlign 0206 NotifyDesigner 021e TCustomActionControl.DoDragDrop"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F1 8B DA 89 45 FC 8B 45 FC 8B 80 AC 01 00 00 85 C0 74 09 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D5 01 00 00 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B 10 FF 52 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 98 6C 02 00 00 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B C8 B2 01 58 FF 50 1C 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BA 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F0 8B 50 50 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 80 6C 02 00 00 8B 40 6C 8B 50 28 8B 45 F8 E8 ?? ?? ?? ?? 8B D7 8B 45 F8 8B 08 FF 51 14 8B 45 F8 E8 ?? ?? ?? ?? 8B 10 FF 52 20 8B 45 F0 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 5B 47 C7 45 F4 00 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 98 6C 02 00 00 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 B2 01 58 FF 50 1C 8B D8 8B 55 F4 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 50 60 8B C3 E8 ?? ?? ?? ?? FF 45 F4 4F 75 AD 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F8 8B 08 FF 91 4C 01 00 00 8B 45 F0 E8 ?? ?? ?? ?? 85 C0 0F 9F C2 8B 45 F8 8B 40 44 8B 08 FF 51 64 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 80 68 02 00 00 E8 ?? ?? ?? ?? 8B 10 FF 52 24 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C6 8B 45 08 50 8B CE 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1297_0 {
	meta:
		name = "TCustomMenuItem.MouseUp"
		size = 138
		refs = "0019 TControl.MouseUp 0036 _Dn_TCustomAction 003b @IsClass 005c TCustomAction.SetChecked 007a TWinControl.GetHandle 0080 PostMessage"
	strings:
		$1 = { 55 8B EC 51 53 88 4D FF 8B D8 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B C3 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 85 C0 74 06 83 78 18 00 75 57 8B C3 8B 10 FF 52 3C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C3 8B 10 FF 52 3C 83 78 6C 00 7E 10 80 B8 95 00 00 00 00 75 07 B2 01 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 D4 00 00 00 84 C0 75 16 53 6A 00 68 03 B4 00 00 8B 43 30 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1298_0 {
	meta:
		name = "TCustomMenuItem.MouseMove"
		size = 25
		refs = "0010 TControl.MouseMove"
	strings:
		$1 = { 55 8B EC 51 88 55 FF 8B 55 08 52 0F B6 55 FF E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1299_0 {
	meta:
		name = "TCustomMenuButton.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCustomButtonControl.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 F0 01 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1301_0 {
	meta:
		name = "TCustomMenuButton.BeginAutoDrag"
		size = 32
		refs = "0012 @CallDynaInst 0019 TCustomActionControl.BeginAutoDrag"
	strings:
		$1 = { 53 56 8B D8 C6 83 F1 01 00 00 01 8B C3 66 BE EB FF E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1302_0 {
	meta:
		name = "TCustomMenuButton.Click"
		size = 221
		refs = "0011 TActionClientItem.GetAction 0028 TCustomActionControl.GetActionBar 003b TCustomActionControl.ResetUsageData 0044 TCustomButtonControl.Click 0061 TCustomMenuButton.GetMenu 00d0 TWinControl.GetHandle 00d6 PostMessage"
	strings:
		$1 = { 53 56 8B F0 8B 9E AC 01 00 00 85 DB 74 33 8B C3 E8 ?? ?? ?? ?? 85 C0 74 28 B2 01 8B C6 8B 08 FF 91 E4 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 10 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 80 BE F1 01 00 00 00 0F 84 85 00 00 00 83 BE AC 01 00 00 00 74 7C 8B C6 E8 ?? ?? ?? ?? 80 B8 0A 03 00 00 00 74 31 80 BE CC 01 00 00 00 74 15 80 BE CC 01 00 00 00 74 1F 8B 86 AC 01 00 00 83 78 18 00 75 13 8B C6 E8 ?? ?? ?? ?? 8B D6 8B 08 FF 91 80 01 00 00 EB 3B 80 BE F0 01 00 00 00 74 18 C6 86 F0 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 EB 1A 56 6A 00 68 03 B4 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1303_0 {
	meta:
		name = "TCustomMenuButton.CMMouseEnter"
		size = 90
		refs = "0006 TCustomButtonControl.CMMouseEnter 000d TCustomMenuButton.GetMenu 001d TCustomActionControl.GetActionBar 0054 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 80 B8 0B 03 00 00 00 75 3E 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 10 01 00 00 84 C0 75 2B 80 BE CC 01 00 00 00 75 22 8B C6 E8 ?? ?? ?? ?? 80 B8 0A 03 00 00 00 74 12 C6 86 F1 01 00 00 01 8B C6 66 BE EB FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1304_0 {
	meta:
		name = "TCustomMenuButton.DoDragDrop"
		size = 118
		refs = "0010 _Dn_TCategoryDragObject 0015 @IsClass 0027 TCustomActionControl.GetActionBar 0047 TCustomActionControl.DoDragDrop 0054 _DV_TCustomActionMenuBar"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1F 8B 43 44 03 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B 4B 40 03 CF 8B D6 8B 30 FF 96 50 01 00 00 EB 0F 8B 45 08 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8B C3 E8 ?? ?? ?? ?? C6 80 0A 03 00 00 00 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1305_0 {
	meta:
		name = "TCustomMenuButton.DragOver"
		size = 174
		refs = "0023 TCustomActionControl.DragOver 002f TCustomActionControl.GetActionBar 0035 _DV_TCustomActionMenuBar 003a @IsClass 0046 _Dn_TActionItemDragObject 0087 TCustomActionMenuBar.ClearSubMenus 00a2 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B FA 8B D8 8B 75 08 8B 45 10 50 0F B6 45 0C 50 56 8B 4D FC 8B D7 8B C3 E8 ?? ?? ?? ?? 80 3E 00 74 7A 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 64 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 38 8B 47 48 3B 83 AC 01 00 00 75 2D 8B C3 E8 ?? ?? ?? ?? 85 C0 74 22 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 BB CC 01 00 00 00 75 12 C6 83 F1 01 00 00 01 8B C3 66 BE EB FF E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1306_0 {
	meta:
		name = "TCustomMenuButton.DrawText"
		size = 258
		refs = "0017 @UStrAddRef 001f TCustomMenuButton.DrawText 0030 @UStrLAsg 003b _DV_TCustomActionMainMenuBar 0040 @IsClass 0058 StripHotkey 007c TCustomActionControl.GetActionBar 0081 TCustomActionBar.GetColorMap 0092 TFont.SetColor 00c8 TCustomActionControl.DrawText 00dd @UStrClr 00f3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 4D F8 8B FA 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 08 E8 ?? ?? ?? ?? 8B 73 30 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 74 80 BE A0 02 00 00 00 75 16 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8D 45 FC E8 ?? ?? ?? ?? 80 BE 8D 03 00 00 00 74 26 80 BB EB 01 00 00 00 75 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 48 8B 83 A0 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 80 BB CC 01 00 00 00 74 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 3C 8B 83 A0 01 00 00 8B 40 0C E8 ?? ?? ?? ?? 8B 45 FC 50 8B 4D F8 8B D7 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1309_0 {
	meta:
		name = "TCustomMenuButton.MouseDown"
		size = 189
		refs = "001e TCustomButtonControl.MouseDown 0025 TCustomMenuButton.GetMenu 0057 ActiveMenu 0086 TWinControl.GetHandle 008c PostMessage"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 80 0A 03 00 00 88 86 F0 01 00 00 8B C3 2C 01 72 04 74 54 EB 76 80 BE F0 01 00 00 00 75 6D B2 01 8B C6 8B 08 FF 91 E4 00 00 00 83 3D ?? ?? ?? ?? 00 74 18 8B 46 04 3B 05 ?? ?? ?? ?? 74 0D A1 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 56 6A 00 68 03 B4 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 24 8B C6 E8 ?? ?? ?? ?? 80 B8 0A 03 00 00 00 74 14 80 FB 01 75 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1310_0 {
	meta:
		name = "TCustomMenuButton.MouseUp"
		size = 76
		refs = "0025 TCustomButtonControl.MouseUp 0039 TCustomMenuButton.GetMenu"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B DA 8B F0 C6 86 F1 01 00 00 00 8B 45 0C 50 8B 45 08 50 0F B6 4D FF 8B D3 8B C6 E8 ?? ?? ?? ?? 84 DB 75 18 80 BE F0 01 00 00 00 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 AC 01 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1311_0 {
	meta:
		name = "TCustomMenuButton.Paint"
		size = 46
		refs = "0021 TCustomButtonControl.Paint"
	strings:
		$1 = { 53 56 8B F0 0F B6 9E EE 01 00 00 8B 86 AC 01 00 00 83 78 18 00 74 07 C6 86 EE 01 00 00 02 8B C6 E8 ?? ?? ?? ?? 88 9E EE 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1312_0 {
	meta:
		name = "TCustomMenuButton.CMDialogChar"
		size = 114
		refs = "000c TCustomButtonControl.CMDialogChar 0016 GetParentForm 002a TCustomActionControl.GetActionBar 0033 TCustomActionBar.FindAccelItem 0058 TCustomMenuButton.GetMenu 005d TWinControl.GetHandle 0063 PostMessage"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B 43 30 E8 ?? ?? ?? ?? 85 C0 74 50 80 B8 87 02 00 00 02 75 47 8B C3 E8 ?? ?? ?? ?? 0F B7 56 04 E8 ?? ?? ?? ?? 8B F8 85 FF 74 31 8B 47 44 B2 01 8B 08 FF 91 E4 00 00 00 8B 47 44 50 6A 00 68 03 B4 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C7 46 0C 01 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1313_0 {
	meta:
		name = "RegisterActnBarStyle"
		size = 148
		refs = "000e RegisterActnBarStyle 0019 ActionBarStyles 0025 _Dn_TActionBarStyleList 002a TStringList.Create 0083 @UStrArrayClr 0089 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 83 38 00 75 14 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 8D 55 FC 8B C3 8B 08 FF 51 08 8B 55 FC A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 40 75 1B 8D 55 F8 8B C3 8B 08 FF 51 08 8B 55 F8 A1 ?? ?? ?? ?? 8B 00 8B CB 8B 18 FF 53 3C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1314_0 {
	meta:
		name = "UnRegisterActnBarStyle"
		size = 76
		refs = "0004 ActionBarStyles 0046 TObject.Free"
	strings:
		$1 = { 56 8B F0 A1 ?? ?? ?? ?? 8B 00 8B D6 8B 08 FF 51 5C 83 F8 FF 74 0E 8B 15 ?? ?? ?? ?? 8B 12 92 8B 08 FF 51 48 A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 14 85 C0 75 16 A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? 33 C9 89 0A E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1316_0 {
	meta:
		name = "ActnMenus"
		size = 31
		refs = "0002 _DV_51 000c UpdateActnMenusProc 0013 MenuCallWndHook 001a MenuList"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 15 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1317_0 {
	meta:
		name = "SetOwner"
		size = 75
		refs = "001a TComponent.InsertComponent 0021 TMenuItem.GetCount 0038 TMenuItem.GetItem 003d SetOwner"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F8 83 7F 04 00 75 10 8B 45 08 8B 40 FC 8B 40 04 8B D7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1A 43 33 F6 8B 45 08 50 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 46 4B 75 E9 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1318_0 {
	meta:
		name = "InitMenuItems"
		size = 51
		refs = "0016 SetOwner 0024 TMenuItem.Add"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B F1 85 F6 7C 1F 46 8B DA 55 8B 03 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 40 34 8B 13 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E4 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1319_0 {
	meta:
		name = "NewPopupMenu"
		size = 67
		refs = "000f _DV_TPopupActionBar 0014 TPopupActionBar.Create 0036 InitMenuItems"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D9 8B F2 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 8B D6 8B C7 8B 08 FF 51 18 0F B6 45 10 88 47 61 88 5F 60 8B 55 0C 8B 4D 08 8B C7 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_41990_0 {
	meta:
		name = "NewPopupMenu"
		size = 67
		refs = "000f _DV_TPopupMenu 0014 TPopupMenu.Create 0036 InitMenuItems"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D9 8B F2 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 8B D6 8B C7 8B 08 FF 51 18 0F B6 45 10 88 47 61 88 5F 60 8B 55 0C 8B 4D 08 8B C7 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_1320_0 {
	meta:
		name = "TPopupActionBar.Create"
		size = 136
		refs = "000a @ClassCreate 0017 TPopupMenu.Create 0020 _Dn_TActionManager 0025 TCustomActionManager.Create 0039 ActionBarStyles 0044 DefaultActnBarStyle 0060 TActionBarStyleList.GetStyle 006a TCustomActionManager.SetStyle 0075 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 78 F6 46 1C 10 75 3C F6 46 1C 01 75 36 A1 ?? ?? ?? ?? 83 38 00 74 2C 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D0 8B 46 78 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1321_0 {
	meta:
		name = "StyleNameStored"
		size = 134
		refs = "0017 TPopupActionBar.GetStyle 0034 ActionBarStyles 003f DefaultActnBarStyle 005b TActionBarStyleList.GetStyle"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 83 78 20 00 74 23 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B 40 20 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 5B 5D C3 A1 ?? ?? ?? ?? 83 38 00 74 36 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 EB 10 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5B 5D C3 }
	condition:
		$1
}

rule function_47030_0 {
	meta:
		name = "StyleNameStored"
		size = 134
		refs = "0017 TCustomRibbon.GetStyle 0034 ActionBarStyles 003f DefaultActnBarStyle 005b TActionBarStyleList.GetStyle"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 83 78 20 00 74 23 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B 40 20 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 5B 5D C3 A1 ?? ?? ?? ?? 83 38 00 74 36 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 EB 10 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5B 5D C3 }
	condition:
		$1
}

rule function_1323_0 {
	meta:
		name = "TPopupActionBar.GetMenuActive"
		size = 8
	strings:
		$1 = { 83 78 7C 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_1324_0 {
	meta:
		name = "TPopupActionBar.GetStyle"
		size = 10
	strings:
		$1 = { 8B 40 78 8B 80 E0 00 00 00 C3 }
	condition:
		$1
}

rule function_1325_0 {
	meta:
		name = "TPopupActionBar.Popup"
		size = 659
		refs = "001a TPopupActionBar.Popup 003b Point 0046 TPopupMenu.SetPopupPoint 0064 TMenuItem.GetCount 007b TMenuItem.GetItem 008f TMenuItem.RethinkHotkeys 009a TMenuItem.RethinkLines 00a3 _DV_TCustomActionPopupMenuEx 00a8 TXPStylePopupMenu.Create 00ca TCollection.Clear 0121 TActionBars.Add 0130 TActionClient.SetActionBar 0146 TActionBarItem.SetAutoSize 017d sActionManagerNotAssigned 0182 LoadResString 018c _Dn_Exception 0191 Exception.CreateFmt 0196 @RaiseExcept 019e TPopupActionBar.GetStyle 01e3 TActionClient.GetItems 0208 TCustomActionPopupMenuEx.LoadMenu 0227 TCustomActionPopupMenu.Popup 023c TObject.Free 0242 @HandleFinally 0281 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 33 DB 89 5D E4 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 78 7C 00 0F 85 3F 02 00 00 8D 4D E8 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 FC 8B 08 FF 51 3C 8B 45 FC 8B 58 34 F6 43 1C 10 75 27 8B C3 E8 ?? ?? ?? ?? 48 85 C0 7C 1B 40 89 C3 33 F6 8B 45 FC 8B 40 34 8B D6 E8 ?? ?? ?? ?? 8B 10 FF 52 40 46 4B 75 EA 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 7C 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 8B 40 78 8B 40 6C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 7C C6 80 7C 02 00 00 00 C6 80 FD 02 00 00 00 8B 55 FC 89 90 A0 03 00 00 8B 55 FC 8B 8A 80 00 00 00 89 88 90 02 00 00 8B 8A 84 00 00 00 89 88 94 02 00 00 8B 45 FC 8B 50 44 8B 45 FC 8B 40 78 8B 08 FF 51 34 8B 45 FC 8B 40 78 8B 40 6C E8 ?? ?? ?? ?? 8B D8 8B 45 FC 8B 50 7C 8B C3 E8 ?? ?? ?? ?? 8B 43 0C B2 02 8B 08 FF 91 40 01 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 7C B2 01 8B 08 FF 51 5C 8B 45 FC 8B 40 7C 83 B8 68 02 00 00 00 75 34 8B 45 FC 8B 40 08 89 45 E8 C6 45 EC 11 8D 45 E8 50 6A 00 8D 55 E4 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D E4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 52 7C 8B 08 FF 51 04 33 C9 B2 01 FF 50 2C 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 7C 8B 55 F0 8B 08 FF 91 38 01 00 00 8B 45 FC 8B 40 7C 8B 80 68 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 58 7C 8B 83 68 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 48 34 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 7C 8B 10 FF 92 58 01 00 00 8B 45 FC 8B 40 7C 8B 4D F4 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 C0 7C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1326_0 {
	meta:
		name = "TPopupActionBar.ReadStyleProp"
		size = 227
		refs = "0017 TPopupActionBar.ReadStyleProp 0027 TReader.ReadString 0044 ActionBarStyles 005c TActionBarStyleList.GetStyle 0066 TPopupActionBar.SetStyle 0075 @HandleAnyException 0083 ApplicationHandleException 008f ExceptObject 00a3 ExceptAddr 00af ShowException 00b6 @RaiseAgain 00bb @DoneExcept 00d0 @UStrClr 00d6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D FC 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 0F 84 8A 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 8B 55 FC 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 4B E9 ?? ?? ?? ?? 8B 45 F8 F6 40 1C 10 74 33 A1 ?? ?? ?? ?? 66 83 78 02 00 74 14 E8 ?? ?? ?? ?? 8B D0 8B 1D ?? ?? ?? ?? 8B 43 04 FF 13 EB 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1327_0 {
	meta:
		name = "TPopupActionBar.SetStyle"
		size = 9
		refs = "0004 TCustomActionManager.SetStyle"
	strings:
		$1 = { 8B 40 78 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1328_0 {
	meta:
		name = "TPopupActionBar.WriteStyleProp"
		size = 117
		refs = "000f TPopupActionBar.WriteStyleProp 001c TPopupActionBar.GetStyle 0030 ActionBarStyles 0039 TActionBarStyleList.GetStyle 004f TWriter.WriteString 0064 @UStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0B 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 10 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D8 8D 55 FC 8B C3 8B 08 FF 51 08 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47122_0 {
	meta:
		name = "TCustomRibbon.WriteStyleProp"
		size = 117
		refs = "000f TCustomRibbon.WriteStyleProp 001c TCustomRibbon.GetStyle 0030 ActionBarStyles 0039 TActionBarStyleList.GetStyle 004f TWriter.WriteString 0064 @UStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0B 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 10 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D8 8D 55 FC 8B C3 8B 08 FF 51 08 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1329_0 {
	meta:
		name = "TCustomActionPopupMenuEx.DoPopup"
		size = 124
		refs = "000c TCustomActionMenuBar.DoPopup 0017 TActionClient.GetItems 001e TActionClients.GetActionClient 0057 TCollection.Clear 0074 TCustomActionPopupMenuEx.LoadMenu"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 83 78 38 00 75 50 8B 83 AC 01 00 00 8B 40 38 66 83 B8 8A 00 00 00 00 74 10 8B F8 8B D0 8B 87 8C 00 00 00 FF 97 88 00 00 00 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 AC 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 AC 01 00 00 8B 48 38 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1330_0 {
	meta:
		name = "TCustomActionPopupMenuEx.ExecAction"
		size = 38
		refs = "0016 PopupList 0021 PostMessage"
	strings:
		$1 = { 6A 00 8B 80 7C 03 00 00 8B 40 38 0F B7 40 4C 50 68 11 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 10 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1332_0 {
	meta:
		name = "TCustomActionPopupMenuEx.LoadMenu"
		size = 776
		refs = "0017 TActionClientsCollection.SetAutoHotKeys 001e TMenuItem.GetCount 0035 TActionClients.Add 0040 TMenuItem.GetItem 004a TActionClientItem.SetCaption 0064 TMenuItem.GetAction 006d TActionClientItem.SetAction 0095 TActionClient.GetItems 00d9 TCustomActionPopupMenuEx.LoadMenu 00de @UStrEqual 00f9 _DV_TMenuAction 00fe TMenuAction.Create 010e TActionClientItem.GetAction 011f TContainedAction.SetActionList 016e TCustomAction.SetAutoCheck 0189 TCustomAction.SetGroupIndex 01c4 TCustomAction.SetImageIndex 01df TCustomAction.SetVisible 01fa TCustomAction.SetChecked 0214 TCustomAction.SetCaption 022f TCustomAction.SetShortCut 024a TCustomAction.SetEnabled 025d TActionClientItem.SetImageIndex 0271 TActionClientItem.SetShortCut 0285 TActionClientItem.SetDefault"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 54 24 04 89 04 24 33 D2 8B 44 24 04 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 0F 8C C1 02 00 00 45 33 DB 8B 44 24 04 E8 ?? ?? ?? ?? 8B F8 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 30 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 89 47 38 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 20 8B D3 8B C6 E8 ?? ?? ?? ?? 80 78 3A 00 74 11 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 E6 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 83 78 30 00 0F 84 D3 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 BD 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 30 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 A1 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 50 8B 4C 24 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 14 24 8B 92 A0 03 00 00 8B 52 78 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? FF 70 0C 8B C7 E8 ?? ?? ?? ?? 5A 89 50 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 50 50 8B C7 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 48 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 80 A8 00 00 00 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 3B 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? FF B0 8C 00 00 00 FF B0 88 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 10 FF 52 34 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 3C 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 3A 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 34 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 30 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B7 40 5C 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 35 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 3C 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B7 50 5C 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 50 36 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 30 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B7 50 5C 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 50 89 47 68 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 3C 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 50 3A 8B C7 8B 08 FF 51 2C 43 4D 0F 85 42 FD FF FF 59 5A 5D 5F 5E 5B C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1333_0 {
	meta:
		name = "TMenuAction.Create"
		size = 68
		refs = "000d @ClassCreate 001a TCustomAction.Create 002e @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 45 08 89 86 A0 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1334_0 {
	meta:
		name = "TMenuAction.Execute"
		size = 43
	strings:
		$1 = { 53 56 B3 01 8B 90 A0 00 00 00 85 D2 74 18 66 83 BA 8A 00 00 00 00 74 0E 8B F2 8B 86 8C 00 00 00 FF 96 88 00 00 00 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1339_0 {
	meta:
		name = "FindDefaultComponentOwnerPageName"
		size = 176
		refs = "0016 FindDefaultComponentOwnerPageName 0026 @UStrAsg 0037 @IntfClear 004c Supports 0055 WebContext 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 33 D2 E8 ?? ?? ?? ?? 8B 5E 04 85 DB 75 02 8B DE 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 85 C0 74 03 83 E8 D4 E8 ?? ?? ?? ?? 84 C0 74 28 E8 ?? ?? ?? ?? 8B F0 8B 03 89 45 F0 8D 4D F4 8B 55 F0 8B C6 8B 18 FF 53 50 84 C0 74 0B 8B 55 F8 8B 45 F4 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 00 61 1F 8D 60 23 F2 74 45 89 F7 F2 9A 73 37 2F FC }
	condition:
		$1
}

rule function_1340_0 {
	meta:
		name = "ExtractStringValue"
		size = 184
		refs = "000f @UStrAddRef 0017 ExtractStringValue 002a AnsiPos 004d @InternalUStrFromLStr 0074 @UStrCopy 007f @UStrSetLength 0094 @UStrClr 009a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 2D 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 3B D8 0F 9C C0 EB 02 33 C0 84 C0 74 13 56 8D 53 01 B9 FF FF FF 7F 8B 45 FC E8 ?? ?? ?? ?? EB 09 8B C6 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1341_0 {
	meta:
		name = "RaiseActionDoesNotProvideResponse"
		size = 84
		refs = "0009 RaiseActionDoesNotProvideResponse 0017 sActionDoesNotProvideResponse 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1343_0 {
	meta:
		name = "RaiseActionCantRedirectToBlankURL"
		size = 84
		refs = "0009 RaiseActionCantRedirectToBlankURL 0017 sActionCantRedirectToBlankURL 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1342_0 {
	meta:
		name = "RaiseCantResponseToUnknownHTTPMethod"
		size = 84
		refs = "0009 RaiseCantResponseToUnknownHTTPMethod 0017 sActionCantRespondToUnkownHTTPMethod 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1344_0 {
	meta:
		name = "TestRedirectOptions"
		size = 46
		refs = "0025 RaiseCantResponseToUnknownHTTPMethod"
	strings:
		$1 = { 53 51 88 04 24 33 DB FE CA 74 07 80 EA 02 74 0B EB 12 F6 04 24 02 0F 95 C3 EB 0E F6 04 24 01 0F 95 C3 EB 05 E8 ?? ?? ?? ?? 8B C3 5A 5B C3 }
	condition:
		$1
}

rule function_1345_0 {
	meta:
		name = "TAdapterRequestParamsImpl.AssignTo"
		size = 15
	strings:
		$1 = { 56 8B F0 8B C2 8B 56 04 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1346_0 {
	meta:
		name = "TAdapterRequestParamsImpl.Create"
		size = 135
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterRequestParamsImpl.Create 0034 TObject.Create 003f @IntfCopy 005f @IntfClear 0065 @HandleFinally 0072 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 08 8B 55 FC E8 ?? ?? ?? ?? 8B 46 08 8B 10 FF 52 14 89 46 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1347_0 {
	meta:
		name = "TAdapterModes.GetAdapterCount"
		size = 9
		altNames = "TAdapterRequestParamsImpl.GetParamCount TAllocatedActions.GetCount TGeneratedFunctions.GetItemCount TIdMIMEBoundary.Count TdomNameValueList.getLength"
	strings:
		$1 = { 8B 40 04 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1348_0 {
	meta:
		name = "TAdapterModes.GetAdapterName"
		size = 25
		refs = "0011 TStrings.GetName"
		altNames = "TAdapterRequestParamsImpl.GetParamName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1351_0 {
	meta:
		name = "TAdapterRequestParamsImpl.ValueOfParam"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1349_0 {
	meta:
		name = "TAdapterRequestParamsImpl.GetParamValue"
		size = 93
		refs = "0018 TAdapterRequestParamsImpl.GetParamValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 04 8B 18 FF 53 0C 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1399_0 {
	meta:
		name = "TAdapterModes.GetAdapterMode"
		size = 93
		refs = "0018 TAdapterModes.GetAdapterMode 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 DB 89 5D F8 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F8 8B D6 8B 43 04 8B 18 FF 53 0C 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1350_0 {
	meta:
		name = "TAdapterRequestParamsImpl.IndexOfParam"
		size = 19
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B 46 04 8B 08 FF 51 54 5F 5E C3 }
	condition:
		$1
}

rule function_1352_0 {
	meta:
		name = "AddValues"
		size = 872
		refs = "0016 AddValues 0045 TStrings.GetName 005b @UStrCopy 0068 SameText 007e @UStrDelete 00c5 ExtractStringValue 00e0 @UStrLAsg 0105 @UStrEqual 0143 _Dn_TStringList 0148 TStringList.Create 0158 TObjectList.Add 022c TObjectList.GetItem 0305 @UStrArrayClr 030d @UStrClr 0313 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 07 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 10 FF 52 14 8B F8 4F 85 FF 0F 8C 4A 01 00 00 47 33 F6 8D 4D FC 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 8D 45 F4 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 17 8D 45 FC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 8E 00 00 00 8D 45 F0 50 B9 06 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 38 8D 4D E8 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 08 8B 40 F8 8B 40 04 8B 08 FF 51 38 8D 45 FC 33 D2 E8 ?? ?? ?? ?? EB 2F 8D 45 E4 50 B9 02 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 0A 8D 45 FC 33 D2 E8 ?? ?? ?? ?? 83 7D FC 00 74 5D 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 40 75 49 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 38 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 F8 8B 40 10 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 08 8B 40 F8 8B 40 14 E8 ?? ?? ?? ?? 46 4F 0F 85 B9 FE FF FF 8B 45 08 8B 40 FC 8B 10 FF 52 14 8B F8 4F 85 FF 0F 8C 59 01 00 00 47 33 F6 8D 4D FC 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 8D 45 E0 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 6B 8D 45 FC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 89 45 F8 83 7D F8 FF 0F 84 E7 00 00 00 8D 4D D8 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 D8 8D 55 DC E8 ?? ?? ?? ?? 8B 45 DC 50 8B 45 08 8B 40 F8 8B 40 14 8B 55 F8 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 38 E9 AC 00 00 00 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 89 45 F8 83 7D F8 FF 0F 84 8E 00 00 00 8B 45 08 8B 40 FC 8B D6 8B 08 FF 51 18 85 C0 74 47 8D 4D D0 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 D0 8D 55 D4 E8 ?? ?? ?? ?? 8B 45 D4 50 8B 45 08 8B 40 FC 8B D6 8B 08 FF 51 18 50 8B 45 08 8B 40 F8 8B 40 10 8B 55 F8 E8 ?? ?? ?? ?? 59 5A 8B 18 FF 53 3C EB 36 8D 4D C8 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 C8 8D 55 CC E8 ?? ?? ?? ?? 8B 45 CC 50 8B 45 08 8B 40 F8 8B 40 10 8B 55 F8 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 38 46 4F 0F 85 AA FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 BA 0C 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 6F 00 76 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 5F 00 5F 00 6B 00 65 00 79 00 2E 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 5F 00 5F 00 00 00 00 00 }
	condition:
		$1
}

rule function_1353_0 {
	meta:
		name = "TActionFieldValuesImpl.Create"
		size = 174
		refs = "000f @ClassCreate 0021 TObject.Create 0028 _Dn_TStringList 002d TStringList.Create 0060 _Dn_TObjectList 0065 TObjectList.Create 008b AddValues 0098 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 89 45 F8 33 D2 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 0C B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 10 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 14 83 7D FC 00 74 07 55 E8 ?? ?? ?? ?? 59 8B 45 F8 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1354_0 {
	meta:
		name = "TActionFieldValueImpl.GetFileCount"
		size = 7
		altNames = "TActionFieldValuesImpl.GetFieldCount TScriptProducer.GetHTMLItemCount TTestResult.FailureCount"
	strings:
		$1 = { 8B 40 10 8B 40 08 C3 }
	condition:
		$1
}

rule function_1355_0 {
	meta:
		name = "TActionFieldValuesImpl.GetFieldName"
		size = 25
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 0C 8B 18 FF 53 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1356_0 {
	meta:
		name = "TActionFieldValuesImpl.AddValue"
		size = 77
		refs = "0021 _Dn_TStringList 0026 TStringList.Create 0030 TObjectList.Add"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C 8B 08 FF 51 54 85 C0 7D 36 8B D6 8B 43 0C 8B 08 FF 51 38 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 10 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1357_0 {
	meta:
		name = "TActionFieldValuesImpl.IndexOfField"
		size = 19
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B 46 0C 8B 08 FF 51 54 5F 5E C3 }
	condition:
		$1
}

rule function_1358_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateValue"
		size = 320
		refs = "001d TActionFieldValuesImpl.CreateValue 0040 _Dn_TInterfaceList 0045 TInterfaceList.Create 0056 @IntfCopy 0085 TObjectList.GetItem 00a3 _DV_TActionFieldValueImpl 00a8 TActionFieldValueImpl.Create 00be @IntfCast 00ed @IntfClear 010a @UStrClr 0120 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 3B F0 0F 8D B2 00 00 00 83 7B 1C 00 75 2F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8D 43 1C E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 52 14 8B D0 8B 43 1C 8B 08 FF 51 20 8D 4D F4 8B D6 8B 43 1C 8B 38 FF 57 0C 83 7D F4 00 75 50 8B D6 8B 43 10 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 50 8D 4D EC 8B D6 8B 43 0C 8B 38 FF 57 0C 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 8B D6 8B 43 1C 8B 38 FF 57 18 8D 4D E8 8B D6 8B 43 1C 8B 18 FF 53 0C 8B 55 E8 8B 45 FC E8 ?? ?? ?? ?? EB 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 00 00 00 56 E5 D4 C5 74 A4 D4 11 A4 FA 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1359_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateValue"
		size = 44
		refs = "000a TActionFieldValuesImpl.IndexOfField 001b TActionFieldValuesImpl.CreateValue 0024 @IntfClear"
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1360_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateOrigValue"
		size = 44
		refs = "000a TActionFieldValuesImpl.IndexOfField 001b TActionFieldValuesImpl.CreateOrigValue 0024 @IntfClear"
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1361_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateOrigValue"
		size = 320
		refs = "001d TActionFieldValuesImpl.CreateOrigValue 0040 _Dn_TInterfaceList 0045 TInterfaceList.Create 0056 @IntfCopy 0085 TObjectList.GetItem 00a3 _DV_TActionFieldValueImpl 00a8 TActionFieldValueImpl.Create 00be @IntfCast 00ed @IntfClear 010a @UStrClr 0120 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 3B F0 0F 8D B2 00 00 00 83 7B 18 00 75 2F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8D 43 18 E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 52 14 8B D0 8B 43 18 8B 08 FF 51 20 8D 4D F4 8B D6 8B 43 18 8B 38 FF 57 0C 83 7D F4 00 75 50 8B D6 8B 43 14 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 50 8D 4D EC 8B D6 8B 43 0C 8B 38 FF 57 0C 8B 4D EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 8B D6 8B 43 18 8B 38 FF 57 18 8D 4D E8 8B D6 8B 43 18 8B 18 FF 53 0C 8B 55 E8 8B 45 FC E8 ?? ?? ?? ?? EB 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 00 00 00 56 E5 D4 C5 74 A4 D4 11 A4 FA 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1362_0 {
	meta:
		name = "TActionFieldValuesImpl.GetValue"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateValue"
		altNames = "TActionFieldValuesImpl.ValueOfField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_57969_0 {
	meta:
		name = "GetStrProp"
		size = 24
		refs = "0010 GetUnicodeStrProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_3984_0 {
	meta:
		name = "Point"
		size = 24
		refs = "0010 Point"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15616_0 {
	meta:
		name = "SubString"
		size = 24
		refs = "0010 TDBXStringBuffer.Substring"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1365_0 {
	meta:
		name = "TActionFieldValuesImpl.GetOrigValue"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateOrigValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1363_0 {
	meta:
		name = "TActionFieldValuesImpl.OrigValueOfField"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateOrigValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_59108_0 {
	meta:
		name = "TBaseAdapterAction.GetInputStyle"
		size = 24
		refs = "0010 TBaseAdapterAction.GetDisplayStyle"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_66533_0 {
	meta:
		name = "TCustomXSLPageProducer.ProduceContentFromString"
		size = 24
		refs = "0010 TCustomXSLPageProducer.ContentFromString"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15635_0 {
	meta:
		name = "TDBXStringStore.GetString"
		size = 24
		refs = "0010 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_60935_0 {
	meta:
		name = "THTMLItemsObj.Item"
		size = 24
		refs = "0010 THTMLItemsObj.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_25403_0 {
	meta:
		name = "TIdRR_SOA.GetName"
		size = 24
		refs = "0010 TIdTextModeResourceRecord.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7298_0 {
	meta:
		name = "TIntegerBucketList.Add"
		size = 24
		refs = "0010 TCustomBucketList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7294_0 {
	meta:
		name = "TObjectBucketList.Add"
		size = 24
		refs = "0010 TCustomBucketList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_44889_0 {
	meta:
		name = "TOleControl.GetVariantProp"
		size = 24
		refs = "0010 TOleControl.GetOleVariantProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_60865_0 {
	meta:
		name = "TSessionObj.Values"
		size = 24
		refs = "0010 TSessionObj.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1366_0 {
	meta:
		name = "TActionFieldValuesImpl.Destroy"
		size = 77
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0046 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B 46 14 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1367_0 {
	meta:
		name = "TBasicActionRequestImpl.Create"
		size = 328
		refs = "0019 @ClassCreate 0028 @IntfAddRef 0030 TBasicActionRequestImpl.Create 003f TAbstractAdapterRequest.Create 004a @IntfCopy 0054 _DV_TAdapterRequestParamsImpl 0059 TAdapterRequestParamsImpl.Create 0064 @IntfClear 0073 Supports 008d @UStrAsg 00b0 TAbstractAdapterRequest.GetRequest 00b8 PageNameOfRequest 00fd @UStrArrayClr 0113 @HandleFinally 0120 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 FC E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 84 C0 74 2C 8D 55 F4 8B 45 F8 8B 08 FF 51 0C 8B 55 F4 8D 46 14 E8 ?? ?? ?? ?? 8D 55 F0 8B 45 F8 8B 08 FF 51 10 8B 55 F0 8D 46 18 E8 ?? ?? ?? ?? 83 7E 14 00 75 1A 8B C6 E8 ?? ?? ?? ?? 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8D 46 14 E8 ?? ?? ?? ?? 83 7E 18 00 75 1A 8B C6 E8 ?? ?? ?? ?? 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8D 46 18 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 00 00 F4 78 D9 14 E9 D1 D4 11 A5 32 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1368_0 {
	meta:
		name = "TActiveScriptSite.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0026 @ClassDestroy"
		altNames = "TBasicActionRequestImpl.Destroy TBasicImageRequestImpl.Destroy TConnectionAdmin.Destroy TMimeAttachHandlerImpl.Destroy TWebRequestFile.Destroy TWebSessionIDsImpl.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48991_0 {
	meta:
		name = "TSessionItem.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TCollectionItem.Destroy 001b TObject.Free 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1369_0 {
	meta:
		name = "TBasicActionRequestImpl.GetActionName"
		size = 19
		altNames = "TBasicImageRequestImpl.GetImageName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 10 8B 08 FF 51 10 5E 5B C3 }
	condition:
		$1
}

rule function_1370_0 {
	meta:
		name = "TAdapterDispatchParams.GetFailurePage"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TBaseWebPageInfo.GetPageTitle TBasicActionRequestImpl.GetFailurePage THeaderInfo.GetEncodingStyle TStreamLoader.GetPassword TXMLDataSet.GetDataSetField"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1371_0 {
	meta:
		name = "TBasicActionRequestImpl.GetHandled"
		size = 5
		altNames = "TDBXMySqlCustomMetaDataReader.IsDefaultCharSetUnicode TDSMethod.IsPublicMethod TIWBaseHTMLControlImplementation.GetVisible TIWBaseWAPControlImplementation.GetVisible"
	strings:
		$1 = { 0F B6 40 1C C3 }
	condition:
		$1
}

rule function_1372_0 {
	meta:
		name = "TActionFieldValueImpl.GetFieldName"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TActionLink.GetFailurePage TAdapterDispatchParams.GetSuccessPage TBaseWebPageInfo.GetPageDescription TBasicActionRequestImpl.GetSuccessPage TComServer.GetHelpFileName THeaderInfo.GetUse TNameContentScriptObject.GetContent TScriptError.GetFileName TStreamLoader.GetUserName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48510_0 {
	meta:
		name = "TScriptManager.GetXMLDocuments"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48547_0 {
	meta:
		name = "TXMLDocument.GetRowSets"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1373_0 {
	meta:
		name = "TBasicActionRequestImpl.SetHandled"
		size = 4
		altNames = "TIWBaseHTMLControlImplementation.SetVisible TIWBaseWAPControlImplementation.SetVisible TWebServExp.SetBindingType"
	strings:
		$1 = { 88 50 1C C3 }
	condition:
		$1
}

rule function_1374_0 {
	meta:
		name = "TSingleRecordActionRequestImpl.Create"
		size = 532
		refs = "001c @ClassCreate 002d @IntfAddRef 0035 TSingleRecordActionRequestImpl.Create 0048 TBasicActionRequestImpl.Create 004f _Dn_TStringList 0054 TStringList.Create 006d TAbstractAdapterRequest.GetRequest 0072 TWebRequest.GetQueryFields 0089 TWebRequest.GetContentFields 00a0 TWebRequest.GetFiles 0128 Format 015d _DV_TActionFieldValuesImpl 0162 TActionFieldValuesImpl.Create 017d TObject.Free 0183 @HandleFinally 0196 _DV_TAdapterModes 019b TAdapterModes.Create 01bb @LStrArrayClr 01c3 @UStrClr 01cb @IntfClear 01e1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 33 DB 89 5D EC 89 5D D8 89 5D D4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 88 55 F7 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC 33 D2 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 AB 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 12 8B F0 4E 85 F6 0F 8C 8F 00 00 00 46 33 DB 8D 45 EC 50 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 D8 8B 08 FF 11 8B 45 D8 89 45 DC C6 45 E0 0B 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 D4 8B 08 FF 51 04 8B 45 D4 89 45 E4 C6 45 E8 0B 8D 55 DC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8B C8 8B 45 F0 5A 8B 38 FF 57 3C 43 4E 0F 85 74 FF FF FF 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B 45 F8 80 7D F7 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F8 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_1375_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 0013 TBasicActionRequestImpl.Destroy 001b TObject.Free 002e @ClassDestroy"
		altNames = "TSingleRecordActionRequestImpl.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 2C E8 ?? ?? ?? ?? 8B 46 30 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1376_0 {
	meta:
		name = "TBasicActionResponseImpl.Create"
		size = 68
		refs = "000b @ClassCreate 001a TAbstractAdapterResponse.Create 0030 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 20 C6 47 0C 02 C6 47 0E 03 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1377_0 {
	meta:
		name = "TBaseWebPageModuleFactory.GetCacheMode"
		size = 5
		altNames = "TBasicActionResponseImpl.GetExecuteStatus TDefaultDBScreenApplication.GetCursor TIWTestFramework.IsRecording TdomCMNode.getCMNodeType TdomNode.getNodeType"
	strings:
		$1 = { 0F B6 40 0C C3 }
	condition:
		$1
}

rule function_1378_0 {
	meta:
		name = "TBaseWebPageModuleFactory.GetCreateMode"
		size = 5
		altNames = "TBasicActionResponseImpl.GetHandled TIWUnitCreator.GetMainForm"
	strings:
		$1 = { 0F B6 40 0D C3 }
	condition:
		$1
}

rule function_1379_0 {
	meta:
		name = "TBasicActionResponseImpl.GetRespondWith"
		size = 5
		altNames = "TIBSQLMonitorHook.GetEnabled"
	strings:
		$1 = { 0F B6 40 0E C3 }
	condition:
		$1
}

rule function_1380_0 {
	meta:
		name = "TBasicActionResponseImpl.SetExecuteStatus"
		size = 133
		refs = "000e TBasicActionResponseImpl.SetExecuteStatus 001e TBasicActionResponseImpl.GetRespondWith 0034 TBasicActionResponseImpl.GetFailurePage 0041 TBasicActionResponseImpl.RespondWithFailurePage 004d TBasicActionResponseImpl.GetSuccessPage 005a TBasicActionResponseImpl.RespondWithSuccessPage 0074 @UStrArrayClr 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 88 53 0C 8B C3 E8 ?? ?? ?? ?? 3C 03 75 38 0F B6 43 0C FE C8 75 19 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 20 8B C3 E8 ?? ?? ?? ?? EB 17 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 83 7D F8 00 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1381_0 {
	meta:
		name = "TBasicActionResponseImpl.SetHandled"
		size = 4
	strings:
		$1 = { 88 50 0D C3 }
	condition:
		$1
}

rule function_1382_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithComponentPage"
		size = 8
	strings:
		$1 = { 89 50 1C C6 40 0E 02 C3 }
	condition:
		$1
}

rule function_1383_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithPage"
		size = 23
		refs = "000c @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 10 8B D6 E8 ?? ?? ?? ?? C6 43 0E 00 5E 5B C3 }
	condition:
		$1
}

rule function_1384_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithURL"
		size = 23
		refs = "000c @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 18 8B D6 E8 ?? ?? ?? ?? C6 43 0E 01 5E 5B C3 }
	condition:
		$1
}

rule function_1385_0 {
	meta:
		name = "RespondWithPage"
		size = 188
		refs = "000b WebContext 002e TBasicActionResponseImpl.GetRedirectOptions 0034 TestRedirectOptions 0041 _Dn_TStringList 0046 TStringList.Create 0051 RespondWithPage 006a TAbstractAdapterResponse.GetResponse 0076 RedirectToPageName 008b TObject.Free 0091 @HandleFinally 00ae DispatchPageName"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F0 33 DB E8 ?? ?? ?? ?? 8B 10 FF 52 04 85 C0 74 22 E8 ?? ?? ?? ?? 8B 10 FF 52 04 0F B6 40 08 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D8 84 DB 74 59 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 05 ?? ?? ?? ?? 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 0F B6 0D ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5E 5B 59 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_1386_0 {
	meta:
		name = "TBasicActionResponseImpl.HandleResponse"
		size = 240
		refs = "0010 TBasicActionResponseImpl.HandleResponse 001e TBasicActionResponseImpl.GetRespondWith 0039 RaiseActionDoesNotProvideResponse 004d FindDefaultComponentOwnerPageName 0055 RespondWithPage 0066 RaiseActionCantRedirectToBlankURL 006e TAbstractAdapterResponse.GetResponse 0076 TCollection.GetCount 008d SafeRedirect 00ab @LStrFromUStr 00d8 @LStrClr 00e0 @UStrClr 00e6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 2C 01 0F 82 90 00 00 00 74 30 FE C8 74 12 FE C8 0F 85 8F 00 00 00 E8 ?? ?? ?? ?? E9 85 00 00 00 55 8D 55 F8 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 59 EB 6B 8B 45 FC 83 78 18 00 75 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 E8 ?? ?? ?? ?? 85 C0 7E 15 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 52 18 E8 ?? ?? ?? ?? EB 34 8B 45 FC E8 ?? ?? ?? ?? 50 8D 45 F4 8B 55 FC 8B 52 18 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 58 8B 08 FF 51 38 EB 0D 55 8B 45 FC 8B 40 10 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1387_0 {
	meta:
		name = "TBasicActionResponseImpl.GetRedirectOptions"
		size = 7
	strings:
		$1 = { 0F B6 50 14 8B C2 C3 }
	condition:
		$1
}

rule function_1388_0 {
	meta:
		name = "TBasicActionResponseImpl.SetRedirectOptions"
		size = 13
	strings:
		$1 = { 51 88 14 24 0F B6 14 24 88 50 14 5A C3 }
	condition:
		$1
}

rule function_1389_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithFailurePage"
		size = 91
		refs = "000c TBasicActionResponseImpl.RespondWithFailurePage 001c TBasicActionResponseImpl.GetFailurePage 0026 TBasicActionResponseImpl.RespondWithPage 002d TBasicActionResponseImpl.FailureRedirect 0036 TBasicActionResponseImpl.SetRedirectOptions 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1390_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithSuccessPage"
		size = 91
		refs = "000c TBasicActionResponseImpl.RespondWithSuccessPage 001c TBasicActionResponseImpl.GetSuccessPage 0026 TBasicActionResponseImpl.RespondWithPage 002d TBasicActionResponseImpl.SuccessRedirect 0036 TBasicActionResponseImpl.SetRedirectOptions 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1391_0 {
	meta:
		name = "TBasicActionResponseImpl.FailureRedirect"
		size = 136
		refs = "000c TBasicActionResponseImpl.FailureRedirect 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 20 8B 40 10 8B 10 FF 52 18 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 10 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 03 7D D2 79 0B D5 D4 11 A5 34 00 C0 4F 6B B8 53 00 00 00 00 }
	condition:
		$1
}

rule function_1392_0 {
	meta:
		name = "TBasicActionResponseImpl.SuccessRedirect"
		size = 136
		refs = "000c TBasicActionResponseImpl.SuccessRedirect 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 20 8B 40 10 8B 10 FF 52 18 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 03 7D D2 79 0B D5 D4 11 A5 34 00 C0 4F 6B B8 53 00 00 00 00 }
	condition:
		$1
}

rule function_1393_0 {
	meta:
		name = "TBasicActionResponseImpl.GetFailurePage"
		size = 19
		refs = "000c TBasicActionRequestImpl.GetFailurePage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1394_0 {
	meta:
		name = "TBasicActionResponseImpl.GetSuccessPage"
		size = 19
		refs = "000c TBasicActionRequestImpl.GetSuccessPage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1395_0 {
	meta:
		name = "GetModes"
		size = 224
		refs = "0014 GetModes 003d TStrings.GetName 004f @UStrCopy 005c SameText 00b2 @UStrArrayClr 00b8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 6F 46 33 DB 8D 45 F8 50 8D 4D F4 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 34 8D 45 F0 50 8D 4D EC 8B D3 8B 45 FC 8B 38 FF 57 0C 8B 45 EC B9 FF FF FF 7F BA 06 00 00 00 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 08 8B 40 FC 8B 40 04 8B 08 FF 51 38 43 4E 75 94 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 04 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 61 00 6D 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1396_0 {
	meta:
		name = "TAdapterModes.Create"
		size = 111
		refs = "000e @ClassCreate 001f TObject.Create 0026 _Dn_TStringList 002b TStringList.Create 0039 TWebRequest.GetQueryFields 003e GetModes 0047 TWebRequest.GetContentFields 0059 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 89 45 FC 33 D2 8B 45 FC E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 04 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 FC 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 FC 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1400_0 {
	meta:
		name = "TAdapterModes.FindAdapterMode"
		size = 260
		refs = "0021 TAdapterModes.FindAdapterMode 0033 @IntfClear 0041 Supports 0075 TStrings.GetName 0080 @UStrEqual 009d ExtractStringValue 00a8 @UStrAsg 00cc @UStrArrayClr 00d4 @UStrClr 00e2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 89 4D F0 8B DA 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 EF 00 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 6D 8D 55 F8 8B 45 FC 8B 08 FF 51 0C 8B 45 F4 8B 40 04 8B 10 FF 52 14 8B F0 4E 85 F6 7C 50 46 33 DB 8D 4D E8 8B 45 F4 8B 40 04 8B D3 E8 ?? ?? ?? ?? 8B 45 E8 8B 55 F8 E8 ?? ?? ?? ?? 75 2C 8D 4D E0 8B 45 F4 8B 40 04 8B D3 8B 30 FF 56 0C 8B 45 E0 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F0 E8 ?? ?? ?? ?? C6 45 EF 01 EB 04 43 4E 75 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 0F B6 45 EF 5E 5B 8B E5 5D C3 00 00 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1401_0 {
	meta:
		name = "TAbstractWebPageModuleFactory.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0026 @ClassDestroy"
		altNames = "TAdapterActionFieldValuesList.Destroy TAdapterModes.Destroy TLocateParamsList.Destroy TNotifyList.Destroy TScriptObjectFactories.Destroy TWebNotifyContainer.Destroy TWebRequestFiles.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2345_0 {
	meta:
		name = "TWebDispatch.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TPersistent.Destroy 001b TObject.Free 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1402_0 {
	meta:
		name = "TBasicImageRequestImpl.Create"
		size = 142
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TBasicImageRequestImpl.Create 0034 TAbstractAdapterRequest.Create 003f @IntfCopy 0049 _DV_TAdapterRequestParamsImpl 004e TAdapterRequestParamsImpl.Create 0066 @IntfClear 006c @HandleFinally 0079 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 FC E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1405_0 {
	meta:
		name = "TBasicImageResponseImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractAdapterResponse.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17662_0 {
	meta:
		name = "DSAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17734_0 {
	meta:
		name = "DSMetadata.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_25692_0 {
	meta:
		name = "EIdException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28822_0 {
	meta:
		name = "EIdReplyIMAP4Error.CreateError"
		size = 53
		refs = "000a @ClassCreate 0017 EIdException.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_60665_0 {
	meta:
		name = "TAbstractActiveScriptLanguages.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9140_0 {
	meta:
		name = "TBinaryField.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TField.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4951_0 {
	meta:
		name = "TCOMAdminCatalog.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4998_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4983_0 {
	meta:
		name = "TCOMAdminCatalogObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4910_0 {
	meta:
		name = "TClassRegistryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20577_0 {
	meta:
		name = "TColorLookup.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_51998_0 {
	meta:
		name = "TConnectionIntercept.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdBaseComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5644_0 {
	meta:
		name = "TConversion.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_51506_0 {
	meta:
		name = "TCustomComboBoxStrings.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10215_0 {
	meta:
		name = "TCustomRemoteServer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10090_0 {
	meta:
		name = "TDBByteBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12908_0 {
	meta:
		name = "TDBXAnsiMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13595_0 {
	meta:
		name = "TDBXAnsiStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12891_0 {
	meta:
		name = "TDBXAnsiStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13590_0 {
	meta:
		name = "TDBXBlobSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13585_0 {
	meta:
		name = "TDBXBooleanSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12316_0 {
	meta:
		name = "TDBXClientDriverLoader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TClassRegistryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13172_0 {
	meta:
		name = "TDBXClosedByteReader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteReader.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13246_0 {
	meta:
		name = "TDBXConnectionBuilder.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14519_0 {
	meta:
		name = "TDBXConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13661_0 {
	meta:
		name = "TDBXDataExpressMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXMetaDataProvider.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14744_0 {
	meta:
		name = "TDBXDataExpressProviderContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13560_0 {
	meta:
		name = "TDBXDataGeneratedRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13599_0 {
	meta:
		name = "TDBXDataGeneratorException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13600_0 {
	meta:
		name = "TDBXDateSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13607_0 {
	meta:
		name = "TDBXDecimalSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13612_0 {
	meta:
		name = "TDBXDoubleSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13617_0 {
	meta:
		name = "TDBXInt16SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13622_0 {
	meta:
		name = "TDBXInt32SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13627_0 {
	meta:
		name = "TDBXInt64SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13632_0 {
	meta:
		name = "TDBXInt8SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13286_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14810_0 {
	meta:
		name = "TDBXMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14192_0 {
	meta:
		name = "TDBXMethodTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13428_0 {
	meta:
		name = "TDBXNoOpRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXStreamerRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_18086_0 {
	meta:
		name = "TDBXServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15762_0 {
	meta:
		name = "TDBXSocketChannel.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15618_0 {
	meta:
		name = "TDBXStringBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12997_0 {
	meta:
		name = "TDBXStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWideStringValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13444_0 {
	meta:
		name = "TDBXTableRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13637_0 {
	meta:
		name = "TDBXTimeSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13644_0 {
	meta:
		name = "TDBXTimestampSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12683_0 {
	meta:
		name = "TDBXTransaction.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12526_0 {
	meta:
		name = "TDBXValueType.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12990_0 {
	meta:
		name = "TDBXWideMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13655_0 {
	meta:
		name = "TDBXWideStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12970_0 {
	meta:
		name = "TDBXWideStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12700_0 {
	meta:
		name = "TDBXWritableValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13388_0 {
	meta:
		name = "TDBXWritableValueList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_41763_0 {
	meta:
		name = "TDCOMConnection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDispatchConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17659_0 {
	meta:
		name = "TDSCustomAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17767_0 {
	meta:
		name = "TDSCustomServerClass.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17742_0 {
	meta:
		name = "TDSSecurity.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17755_0 {
	meta:
		name = "TDSServerCommandHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17764_0 {
	meta:
		name = "TDSServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17821_0 {
	meta:
		name = "TDSServerMethod.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17840_0 {
	meta:
		name = "TDSServerMethodProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17881_0 {
	meta:
		name = "TDSVoidConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_36907_0 {
	meta:
		name = "TDataContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2329_0 {
	meta:
		name = "TEnumDispatcherAS.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomEnumDispatcher.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21196_0 {
	meta:
		name = "TGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83