{"dsyconvf"=>
  {"summary"=>
    ["If parameter WAY = 'C':",
     "DSYCONVF converts the factorization output format used in",
     "DSYTRF provided on entry in parameter A into the factorization",
     "output format used in DSYTRF_RK (or DSYTRF_BK) that is stored",
     "on exit in parameters A and E. It also coverts in place details of",
     "the intechanges stored in IPIV from the format used in DSYTRF into",
     "the format used in DSYTRF_RK (or DSYTRF_BK).",
     "If parameter WAY = 'R':",
     "DSYCONVF performs the conversion in reverse direction, i.e.",
     "converts the factorization output format used in DSYTRF_RK",
     "(or DSYTRF_BK) provided on entry in parametes A and E into",
     "the factorization output format used in DSYTRF that is stored",
     "on exit in parameter A. It also coverts in place details of",
     "the intechanges stored in IPIV from the format used in DSYTRF_RK",
     "(or DSYTRF_BK) into the format used in DSYTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are",
       "         stored as an upper or lower triangular matrix A.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "WAY"=>
      ["[in]",
       "         WAY is CHARACTER*1",
       "         = 'C': Convert",
       "         = 'R': Revert"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         1) If WAY ='C':",
       "         On entry, contains factorization details in format used in",
       "         DSYTRF:",
       "           a) all elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A and on superdiagonal",
       "              (or subdiagonal) of A, and",
       "           b) If UPLO = 'U': multipliers used to obtain factor U",
       "              in the superdiagonal part of A.",
       "              If UPLO = 'L': multipliers used to obtain factor L",
       "              in the superdiagonal part of A.",
       "         On exit, contains factorization details in format used in",
       "         DSYTRF_RK or DSYTRF_BK:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               are stored on exit in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A.",
       "         2) If WAY = 'R':",
       "         On entry, contains factorization details in format used in",
       "         DSYTRF_RK or DSYTRF_BK:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               are stored on exit in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A.",
       "         On exit, contains factorization details in format used in",
       "         DSYTRF:",
       "           a) all elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A and on superdiagonal",
       "              (or subdiagonal) of A, and",
       "           b) If UPLO = 'U': multipliers used to obtain factor U",
       "              in the superdiagonal part of A.",
       "              If UPLO = 'L': multipliers used to obtain factor L",
       "              in the superdiagonal part of A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[in,out]",
       "         E is DOUBLE PRECISION array, dimension (N)",
       "         1) If WAY ='C':",
       "         On entry, just a workspace.",
       "         On exit, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i), i=2:N, E(1) is set to 0;",
       "         If UPLO = 'L': E(i) = D(i+1,i), i=1:N-1, E(N) is set to 0.",
       "         2) If WAY = 'R':",
       "         On entry, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i),i=2:N, E(1) not referenced;",
       "         If UPLO = 'L': E(i) = D(i+1,i),i=1:N-1, E(N) not referenced.",
       "         On exit, is not changed"],
     "IPIV"=>
      ["[in,out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         1) If WAY ='C':",
       "         On entry, details of the interchanges and the block",
       "         structure of D in the format used in DSYTRF.",
       "         On exit, details of the interchanges and the block",
       "         structure of D in the format used in DSYTRF_RK",
       "         ( or DSYTRF_BK).",
       "         1) If WAY ='R':",
       "         On entry, details of the interchanges and the block",
       "         structure of D in the format used in DSYTRF_RK",
       "         ( or DSYTRF_BK).",
       "         On exit, details of the interchanges and the block",
       "         structure of D in the format used in DSYTRF."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cla_hercond_c"=>
  {"summary"=>
    ["   CLA_HERCOND_C computes the infinity norm condition number of",
     "   op(A) * inv(diag(C)) where C is a REAL vector."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX array, dimension (LDAF,N)",
       "    The block diagonal matrix D and the multipliers used to",
       "    obtain the factor U or L as computed by CHETRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    Details of the interchanges and the block structure of D",
       "    as determined by CHETRF."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension (N)",
       "    The vector C in the formula op(A) * inv(diag(C))."],
     "CAPPLY"=>
      ["[in]",
       "         CAPPLY is LOGICAL",
       "    If .TRUE. then access the vector C in the formula above."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "    i > 0:  The ith argument is invalid."],
     "WORK"=>
      ["[in]",
       "         WORK is COMPLEX array, dimension (2*N).",
       "    Workspace."],
     "RWORK"=>
      ["[in]",
       "         RWORK is REAL array, dimension (N).",
       "    Workspace."]}},
 "cgelqt3"=>
  {"summary"=>
    ["CGELQT3 recursively computes a LQ factorization of a complex M-by-N",
     "matrix A, using the compact WY representation of Q.",
     "Based on the algorithm of Elmroth and Gustavson,",
     "IBM J. Res. Develop. Vol 44 No. 4 July 2000."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M =< N."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the real M-by-N matrix A.  On exit, the elements on and",
       "         below the diagonal contain the N-by-N lower triangular matrix L; the",
       "         elements above the diagonal are the rows of V.  See below for",
       "         further details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is COMPLEX array, dimension (LDT,N)",
       "         The N-by-N upper triangular factor of the block reflector.",
       "         The elements on and above the diagonal contain the block",
       "         reflector T; the elements below the diagonal are not used.",
       "         See below for further details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "dlasd4"=>
  {"summary"=>
    ["This subroutine computes the square root of the I-th updated",
     "eigenvalue of a positive symmetric rank-one modification to",
     "a positive diagonal matrix whose entries are given as the squares",
     "of the corresponding entries in the array d, and that",
     "       0 <= D(i) < D(j)  for  i < j",
     "and that RHO > 0. This is arranged by the calling routine, and is",
     "no loss in generality.  The rank-one modified system is thus",
     "       diag( D ) * diag( D ) +  RHO * Z * Z_transpose.",
     "where we assume the Euclidean norm of Z is 1.",
     "The method consists of approximating the rational functions in the",
     "secular equation by simpler interpolating rational functions."],
   "param"=>
    {"N"=>
      ["[in]", "         N is INTEGER", "        The length of all arrays."],
     "I"=>
      ["[in]",
       "         I is INTEGER",
       "        The index of the eigenvalue to be computed.  1 <= I <= N."],
     "D"=>
      ["[in]",
       "         D is DOUBLE PRECISION array, dimension ( N )",
       "        The original eigenvalues.  It is assumed that they are in",
       "        order, 0 <= D(I) < D(J)  for I < J."],
     "Z"=>
      ["[in]",
       "         Z is DOUBLE PRECISION array, dimension ( N )",
       "        The components of the updating vector."],
     "DELTA"=>
      ["[out]",
       "         DELTA is DOUBLE PRECISION array, dimension ( N )",
       "        If N .ne. 1, DELTA contains (D(j) - sigma_I) in its  j-th",
       "        component.  If N = 1, then DELTA(1) = 1.  The vector DELTA",
       "        contains the information necessary to construct the",
       "        (singular) eigenvectors."],
     "RHO"=>
      ["[in]",
       "         RHO is DOUBLE PRECISION",
       "        The scalar in the symmetric updating formula."],
     "SIGMA"=>
      ["[out]",
       "         SIGMA is DOUBLE PRECISION",
       "        The computed sigma_I, the I-th updated eigenvalue."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension ( N )",
       "        If N .ne. 1, WORK contains (D(j) + sigma_I) in its  j-th",
       "        component.  If N = 1, then WORK( 1 ) = 1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "        = 0:  successful exit",
       "        > 0:  if INFO = 1, the updating process failed."]}},
 "cgeqr2p"=>
  {"summary"=>
    ["CGEQR2P computes a QR factorization of a complex m by n matrix A:",
     "A = Q * R. The diagonal entries of R are real and nonnegative."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the m by n matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the min(m,n) by n upper trapezoidal matrix R (R is",
       "         upper triangular if m >= n). The diagonal entries of R are",
       "         real and nonnegative; the elements below the diagonal,",
       "         with the array TAU, represent the unitary matrix Q as a",
       "         product of elementary reflectors (see Further Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is COMPLEX array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "cpptrs"=>
  {"summary"=>
    ["CPPTRS solves a system of linear equations A*X = B with a Hermitian",
     "positive definite matrix A in packed storage using the Cholesky",
     "factorization A = U**H*U or A = L*L**H computed by CPPTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         The triangular factor U or L from the Cholesky factorization",
       "         A = U**H*U or A = L*L**H, packed columnwise in a linear",
       "         array.  The j-th column of U or L is stored in the array AP",
       "         as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dsyevd_2stage"=>
  {"summary"=>
    ["DSYEVD_2STAGE computes all eigenvalues and, optionally, eigenvectors of a",
     "real symmetric matrix A using the 2stage technique for",
     "the reduction to tridiagonal. If eigenvectors are desired, it uses a",
     "divide and conquer algorithm.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors.",
       "                 Not available in this release."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA, N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         orthonormal eigenvectors of the matrix A.",
       "         If JOBZ = 'N', then on exit the lower triangle (if UPLO='L')",
       "         or the upper triangle (if UPLO='U') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array,",
       "                                        dimension (LWORK)",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If N <= 1,               LWORK must be at least 1.",
       "         If JOBZ = 'N' and N > 1, LWORK must be queried.",
       "                                  LWORK = MAX(1, dimension) where",
       "                                  dimension = max(stage1,stage2) + (KD+1)*N + 2*N+1",
       "                                            = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                                              + max(2*KD*KD, KD*NTHREADS) ",
       "                                              + (KD+1)*N + 2*N+1",
       "                                  where KD is the blocking size of the reduction,",
       "                                  FACTOPTNB is the blocking used by the QR or LQ",
       "                                  algorithm, usually FACTOPTNB=128 is a good choice",
       "                                  NTHREADS is the number of threads used when",
       "                                  openMP compilation is enabled, otherwise =1.",
       "         If JOBZ = 'V' and N > 1, LWORK must be at least",
       "                                               1 + 6*N + 2*N**2.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal sizes of the WORK and IWORK",
       "         arrays, returns these values as the first entries of the WORK",
       "         and IWORK arrays, and no error message related to LWORK or",
       "         LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         If N <= 1,                LIWORK must be at least 1.",
       "         If JOBZ  = 'N' and N > 1, LIWORK must be at least 1.",
       "         If JOBZ  = 'V' and N > 1, LIWORK must be at least 3 + 5*N.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK and IWORK arrays, and no error message related to",
       "         LWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i and JOBZ = 'N', then the algorithm failed",
       "               to converge; i off-diagonal elements of an intermediate",
       "               tridiagonal form did not converge to zero;",
       "               if INFO = i and JOBZ = 'V', then the algorithm failed",
       "               to compute an eigenvalue while working on the submatrix",
       "               lying in rows and columns INFO/(N+1) through",
       "               mod(INFO,N+1)."]}},
 "zggbak"=>
  {"summary"=>
    ["ZGGBAK forms the right or left eigenvectors of a complex generalized",
     "eigenvalue problem A*x = lambda*B*x, by backward transformation on",
     "the computed eigenvectors of the balanced pair of matrices output by",
     "ZGGBAL."],
   "param"=>
    {"JOB"=>
      ["[in]",
       "         JOB is CHARACTER*1",
       "         Specifies the type of backward transformation required:",
       "         = 'N':  do nothing, return immediately;",
       "         = 'P':  do backward transformation for permutation only;",
       "         = 'S':  do backward transformation for scaling only;",
       "         = 'B':  do backward transformations for both permutation and",
       "                 scaling.",
       "         JOB must be the same as the argument JOB supplied to ZGGBAL."],
     "SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'R':  V contains right eigenvectors;",
       "         = 'L':  V contains left eigenvectors."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of rows of the matrix V.  N >= 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "         The integers ILO and IHI determined by ZGGBAL.",
       "         1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0."],
     "LSCALE"=>
      ["[in]",
       "         LSCALE is DOUBLE PRECISION array, dimension (N)",
       "         Details of the permutations and/or scaling factors applied",
       "         to the left side of A and B, as returned by ZGGBAL."],
     "RSCALE"=>
      ["[in]",
       "         RSCALE is DOUBLE PRECISION array, dimension (N)",
       "         Details of the permutations and/or scaling factors applied",
       "         to the right side of A and B, as returned by ZGGBAL."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of columns of the matrix V.  M >= 0."],
     "V"=>
      ["[in,out]",
       "         V is COMPLEX*16 array, dimension (LDV,M)",
       "         On entry, the matrix of right or left eigenvectors to be",
       "         transformed, as returned by ZTGEVC.",
       "         On exit, V is overwritten by the transformed eigenvectors."],
     "LDV"=>
      ["[in]",
       "         LDV is INTEGER",
       "         The leading dimension of the matrix V. LDV >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "dlae2"=>
  {"summary"=>
    ["DLAE2  computes the eigenvalues of a 2-by-2 symmetric matrix",
     "   [  A   B  ]",
     "   [  B   C  ].",
     "On return, RT1 is the eigenvalue of larger absolute value, and RT2",
     "is the eigenvalue of smaller absolute value."],
   "param"=>
    {"A"=>
      ["[in]",
       "         A is DOUBLE PRECISION",
       "         The (1,1) element of the 2-by-2 matrix."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION",
       "         The (1,2) and (2,1) elements of the 2-by-2 matrix."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION",
       "         The (2,2) element of the 2-by-2 matrix."],
     "RT1"=>
      ["[out]",
       "         RT1 is DOUBLE PRECISION",
       "         The eigenvalue of larger absolute value."],
     "RT2"=>
      ["[out]",
       "         RT2 is DOUBLE PRECISION",
       "         The eigenvalue of smaller absolute value."]}},
 "zlansp"=>
  {"summary"=>
    ["ZLANSP  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the  element of  largest absolute value  of a",
     "complex symmetric matrix A,  supplied in packed form.",
     "   ZLANSP = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in ZLANSP as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is supplied.",
       "         = 'U':  Upper triangular part of A is supplied",
       "         = 'L':  Lower triangular part of A is supplied"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, ZLANSP is",
       "         set to zero."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX*16 array, dimension (N*(N+1)/2)",
       "         The upper or lower triangle of the symmetric matrix A, packed",
       "         columnwise in a linear array.  The j-th column of A is stored",
       "         in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,",
       "         WORK is not referenced."]}},
 "dspgvd"=>
  {"summary"=>
    ["DSPGVD computes all the eigenvalues, and optionally, the eigenvectors",
     "of a real generalized symmetric-definite eigenproblem, of the form",
     "A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.  Here A and",
     "B are assumed to be symmetric, stored in packed format, and B is also",
     "positive definite.",
     "If eigenvectors are desired, it uses a divide and conquer algorithm.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         Specifies the problem type to be solved:",
       "         = 1:  A*x = (lambda)*B*x",
       "         = 2:  A*B*x = (lambda)*x",
       "         = 3:  B*A*x = (lambda)*x"],
     "JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, the contents of AP are destroyed."],
     "BP"=>
      ["[in,out]",
       "         BP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         B, packed columnwise in a linear array.  The j-th column of B",
       "         is stored in the array BP as follows:",
       "         if UPLO = 'U', BP(i + (j-1)*j/2) = B(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', BP(i + (j-1)*(2*n-j)/2) = B(i,j) for j<=i<=n.",
       "         On exit, the triangular factor U or L from the Cholesky",
       "         factorization B = U**T*U or B = L*L**T, in the same storage",
       "         format as B."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is DOUBLE PRECISION array, dimension (LDZ, N)",
       "         If JOBZ = 'V', then if INFO = 0, Z contains the matrix Z of",
       "         eigenvectors.  The eigenvectors are normalized as follows:",
       "         if ITYPE = 1 or 2, Z**T*B*Z = I;",
       "         if ITYPE = 3, Z**T*inv(B)*Z = I.",
       "         If JOBZ = 'N', then Z is not referenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the required LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If N <= 1,               LWORK >= 1.",
       "         If JOBZ = 'N' and N > 1, LWORK >= 2*N.",
       "         If JOBZ = 'V' and N > 1, LWORK >= 1 + 6*N + 2*N**2.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the required sizes of the WORK and IWORK",
       "         arrays, returns these values as the first entries of the WORK",
       "         and IWORK arrays, and no error message related to LWORK or",
       "         LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the required LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         If JOBZ  = 'N' or N <= 1, LIWORK >= 1.",
       "         If JOBZ  = 'V' and N > 1, LIWORK >= 3 + 5*N.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the required sizes of the WORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK and IWORK arrays, and no error message related to",
       "         LWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  DPPTRF or DSPEVD returned an error code:",
       "            <= N:  if INFO = i, DSPEVD failed to converge;",
       "                   i off-diagonal elements of an intermediate",
       "                   tridiagonal form did not converge to zero;",
       "            > N:   if INFO = N + i, for 1 <= i <= N, then the leading",
       "                   minor of order i of B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "dtzrzf"=>
  {"summary"=>
    ["DTZRZF reduces the M-by-N ( M<=N ) real upper trapezoidal matrix A",
     "to upper triangular form by means of orthogonal transformations.",
     "The upper trapezoidal matrix A is factored as",
     "   A = ( R  0 ) * Z,",
     "where Z is an N-by-N orthogonal matrix and R is an M-by-M upper",
     "triangular matrix."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= M."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the leading M-by-N upper trapezoidal part of the",
       "         array A must contain the matrix to be factorized.",
       "         On exit, the leading M-by-M upper triangular part of A",
       "         contains the upper triangular matrix R, and elements M+1 to",
       "         N of the first M rows of A, with the array TAU, represent the",
       "         orthogonal matrix Z as a product of M elementary reflectors."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is DOUBLE PRECISION array, dimension (M)",
       "         The scalar factors of the elementary reflectors."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,M).",
       "         For optimum performance LWORK >= M*NB, where NB is",
       "         the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "chptrs"=>
  {"summary"=>
    ["CHPTRS solves a system of linear equations A*X = B with a complex",
     "Hermitian matrix A stored in packed format using the factorization",
     "A = U*D*U**H or A = L*D*L**H computed by CHPTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**H;",
       "         = 'L':  Lower triangular, form is A = L*D*L**H."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by CHPTRF, stored as a",
       "         packed triangular matrix."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by CHPTRF."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "zggesx"=>
  {"summary"=>
    ["ZGGESX computes for a pair of N-by-N complex nonsymmetric matrices",
     "(A,B), the generalized eigenvalues, the complex Schur form (S,T),",
     "and, optionally, the left and/or right matrices of Schur vectors (VSL",
     "and VSR).  This gives the generalized Schur factorization",
     "     (A,B) = ( (VSL) S (VSR)**H, (VSL) T (VSR)**H )",
     "where (VSR)**H is the conjugate-transpose of VSR.",
     "Optionally, it also orders the eigenvalues so that a selected cluster",
     "of eigenvalues appears in the leading diagonal blocks of the upper",
     "triangular matrix S and the upper triangular matrix T; computes",
     "a reciprocal condition number for the average of the selected",
     "eigenvalues (RCONDE); and computes a reciprocal condition number for",
     "the right and left deflating subspaces corresponding to the selected",
     "eigenvalues (RCONDV). The leading columns of VSL and VSR then form",
     "an orthonormal basis for the corresponding left and right eigenspaces",
     "(deflating subspaces).",
     "A generalized eigenvalue for a pair of matrices (A,B) is a scalar w",
     "or a ratio alpha/beta = w, such that  A - w*B is singular.  It is",
     "usually represented as the pair (alpha,beta), as there is a",
     "reasonable interpretation for beta=0 or for both being zero.",
     "A pair of matrices (S,T) is in generalized complex Schur form if T is",
     "upper triangular with non-negative diagonal and S is upper",
     "triangular."],
   "param"=>
    {"JOBVSL"=>
      ["[in]",
       "         JOBVSL is CHARACTER*1",
       "         = 'N':  do not compute the left Schur vectors;",
       "         = 'V':  compute the left Schur vectors."],
     "JOBVSR"=>
      ["[in]",
       "         JOBVSR is CHARACTER*1",
       "         = 'N':  do not compute the right Schur vectors;",
       "         = 'V':  compute the right Schur vectors."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the generalized Schur form.",
       "         = 'N':  Eigenvalues are not ordered;",
       "         = 'S':  Eigenvalues are ordered (see SELCTG)."],
     "SELCTG"=>
      ["[in]",
       "         SELCTG is procedure) LOGICAL FUNCTION of two COMPLEX*16 arguments",
       "         SELCTG must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'N', SELCTG is not referenced.",
       "         If SORT = 'S', SELCTG is used to select eigenvalues to sort",
       "         to the top left of the Schur form.",
       "         Note that a selected complex eigenvalue may no longer satisfy",
       "         SELCTG(ALPHA(j),BETA(j)) = .TRUE. after ordering, since",
       "         ordering may change the value of complex eigenvalues",
       "         (especially if the eigenvalue is ill-conditioned), in this",
       "         case INFO is set to N+3 see INFO below)."],
     "SENSE"=>
      ["[in]",
       "         SENSE is CHARACTER*1",
       "         Determines which reciprocal condition numbers are computed.",
       "         = 'N' : None are computed;",
       "         = 'E' : Computed for average of selected eigenvalues only;",
       "         = 'V' : Computed for selected deflating subspaces only;",
       "         = 'B' : Computed for both.",
       "         If SENSE = 'E', 'V', or 'B', SORT must equal 'S'."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A, B, VSL, and VSR.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA, N)",
       "         On entry, the first of the pair of matrices.",
       "         On exit, A has been overwritten by its generalized Schur",
       "         form S."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB, N)",
       "         On entry, the second of the pair of matrices.",
       "         On exit, B has been overwritten by its generalized Schur",
       "         form T."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of B.  LDB >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues (after sorting)",
       "         for which SELCTG is true."],
     "ALPHA"=>["[out]", "         ALPHA is COMPLEX*16 array, dimension (N)"],
     "BETA"=>
      ["[out]",
       "         BETA is COMPLEX*16 array, dimension (N)",
       "         On exit, ALPHA(j)/BETA(j), j=1,...,N, will be the",
       "         generalized eigenvalues.  ALPHA(j) and BETA(j),j=1,...,N  are",
       "         the diagonals of the complex Schur form (S,T).  BETA(j) will",
       "         be non-negative real.",
       "         Note: the quotients ALPHA(j)/BETA(j) may easily over- or",
       "         underflow, and BETA(j) may even be zero.  Thus, the user",
       "         should avoid naively computing the ratio alpha/beta.",
       "         However, ALPHA will be always less than and usually",
       "         comparable with norm(A) in magnitude, and BETA always less",
       "         than and usually comparable with norm(B)."],
     "VSL"=>
      ["[out]",
       "         VSL is COMPLEX*16 array, dimension (LDVSL,N)",
       "         If JOBVSL = 'V', VSL will contain the left Schur vectors.",
       "         Not referenced if JOBVSL = 'N'."],
     "LDVSL"=>
      ["[in]",
       "         LDVSL is INTEGER",
       "         The leading dimension of the matrix VSL. LDVSL >=1, and",
       "         if JOBVSL = 'V', LDVSL >= N."],
     "VSR"=>
      ["[out]",
       "         VSR is COMPLEX*16 array, dimension (LDVSR,N)",
       "         If JOBVSR = 'V', VSR will contain the right Schur vectors.",
       "         Not referenced if JOBVSR = 'N'."],
     "LDVSR"=>
      ["[in]",
       "         LDVSR is INTEGER",
       "         The leading dimension of the matrix VSR. LDVSR >= 1, and",
       "         if JOBVSR = 'V', LDVSR >= N."],
     "RCONDE"=>
      ["[out]",
       "         RCONDE is DOUBLE PRECISION array, dimension ( 2 )",
       "         If SENSE = 'E' or 'B', RCONDE(1) and RCONDE(2) contain the",
       "         reciprocal condition numbers for the average of the selected",
       "         eigenvalues.",
       "         Not referenced if SENSE = 'N' or 'V'."],
     "RCONDV"=>
      ["[out]",
       "         RCONDV is DOUBLE PRECISION array, dimension ( 2 )",
       "         If SENSE = 'V' or 'B', RCONDV(1) and RCONDV(2) contain the",
       "         reciprocal condition number for the selected deflating",
       "         subspaces.",
       "         Not referenced if SENSE = 'N' or 'E'."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If N = 0, LWORK >= 1, else if SENSE = 'E', 'V', or 'B',",
       "         LWORK >= MAX(1,2*N,2*SDIM*(N-SDIM)), else",
       "         LWORK >= MAX(1,2*N).  Note that 2*SDIM*(N-SDIM) <= N*N/2.",
       "         Note also that an error is only returned if",
       "         LWORK < MAX(1,2*N), but if SENSE = 'E' or 'V' or 'B' this may",
       "         not be large enough.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the bound on the optimal size of the WORK",
       "         array and the minimum size of the IWORK array, returns these",
       "         values as the first entries of the WORK and IWORK arrays, and",
       "         no error message related to LWORK or LIWORK is issued by",
       "         XERBLA."],
     "RWORK"=>
      ["[out]",
       "         RWORK is DOUBLE PRECISION array, dimension ( 8*N )",
       "         Real workspace."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the minimum LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         If SENSE = 'N' or N = 0, LIWORK >= 1, otherwise",
       "         LIWORK >= N+2.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the bound on the optimal size of the",
       "         WORK array and the minimum size of the IWORK array, returns",
       "         these values as the first entries of the WORK and IWORK",
       "         arrays, and no error message related to LWORK or LIWORK is",
       "         issued by XERBLA."],
     "BWORK"=>
      ["[out]",
       "         BWORK is LOGICAL array, dimension (N)",
       "         Not referenced if SORT = 'N'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         = 1,...,N:",
       "               The QZ iteration failed.  (A,B) are not in Schur",
       "               form, but ALPHA(j) and BETA(j) should be correct for",
       "               j=INFO+1,...,N.",
       "         > N:  =N+1: other than QZ iteration failed in ZHGEQZ",
       "               =N+2: after reordering, roundoff changed values of",
       "                     some complex eigenvalues so that leading",
       "                     eigenvalues in the Generalized Schur form no",
       "                     longer satisfy SELCTG=.TRUE.  This could also",
       "                     be caused due to scaling.",
       "               =N+3: reordering failed in ZTGSEN."]}},
 "sppcon"=>
  {"summary"=>
    ["SPPCON estimates the reciprocal of the condition number (in the",
     "1-norm) of a real symmetric positive definite packed matrix using",
     "the Cholesky factorization A = U**T*U or A = L*L**T computed by",
     "SPPTRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in]",
       "         AP is REAL array, dimension (N*(N+1)/2)",
       "         The triangular factor U or L from the Cholesky factorization",
       "         A = U**T*U or A = L*L**T, packed columnwise in a linear",
       "         array.  The j-th column of U or L is stored in the array AP",
       "         as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         The 1-norm (or infinity-norm) of the symmetric matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an",
       "         estimate of the 1-norm of inv(A) computed in this routine."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (3*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cheev_2stage"=>
  {"summary"=>
    ["CHEEV_2STAGE computes all eigenvalues and, optionally, eigenvectors of a",
     "complex Hermitian matrix A using the 2stage technique for",
     "the reduction to tridiagonal."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors.",
       "                 Not available in this release."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         orthonormal eigenvectors of the matrix A.",
       "         If JOBZ = 'N', then on exit the lower triangle (if UPLO='L')",
       "         or the upper triangle (if UPLO='U') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK. LWORK >= 1, when N <= 1;",
       "         otherwise  ",
       "         If JOBZ = 'N' and N > 1, LWORK must be queried.",
       "                                  LWORK = MAX(1, dimension) where",
       "                                  dimension = max(stage1,stage2) + (KD+1)*N + N",
       "                                            = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                                              + max(2*KD*KD, KD*NTHREADS) ",
       "                                              + (KD+1)*N + N",
       "                                  where KD is the blocking size of the reduction,",
       "                                  FACTOPTNB is the blocking used by the QR or LQ",
       "                                  algorithm, usually FACTOPTNB=128 is a good choice",
       "                                  NTHREADS is the number of threads used when",
       "                                  openMP compilation is enabled, otherwise =1.",
       "         If JOBZ = 'V' and N > 1, LWORK must be queried. Not yet available",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]", "         RWORK is REAL array, dimension (max(1, 3*N-2))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the algorithm failed to converge; i",
       "               off-diagonal elements of an intermediate tridiagonal",
       "               form did not converge to zero."]}},
 "sorbdb"=>
  {"summary"=>
    ["SORBDB simultaneously bidiagonalizes the blocks of an M-by-M",
     "partitioned orthogonal matrix X:",
     "                                [ B11 | B12 0  0 ]",
     "    [ X11 | X12 ]   [ P1 |    ] [  0  |  0 -I  0 ] [ Q1 |    ]**T",
     "X = [-----------] = [---------] [----------------] [---------]   .",
     "    [ X21 | X22 ]   [    | P2 ] [ B21 | B22 0  0 ] [    | Q2 ]",
     "                                [  0  |  0  0  I ]",
     "X11 is P-by-Q. Q must be no larger than P, M-P, or M-Q. (If this is",
     "not the case, then X must be transposed and/or permuted. This can be",
     "done in constant time using the TRANS and SIGNS options. See SORCSD",
     "for details.)",
     "The orthogonal matrices P1, P2, Q1, and Q2 are P-by-P, (M-P)-by-",
     "(M-P), Q-by-Q, and (M-Q)-by-(M-Q), respectively. They are",
     "represented implicitly by Householder vectors.",
     "B11, B12, B21, and B22 are Q-by-Q bidiagonal matrices represented",
     "implicitly by angles THETA, PHI."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER",
       "         = 'T':      X, U1, U2, V1T, and V2T are stored in row-major",
       "                     order;",
       "         otherwise:  X, U1, U2, V1T, and V2T are stored in column-",
       "                     major order."],
     "SIGNS"=>
      ["[in]",
       "         SIGNS is CHARACTER",
       "         = 'O':      The lower-left block is made nonpositive (the",
       "                     \"other\" convention);",
       "         otherwise:  The upper-right block is made nonpositive (the",
       "                     \"default\" convention)."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows and columns in X."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of rows in X11 and X12. 0 <= P <= M."],
     "Q"=>
      ["[in]",
       "         Q is INTEGER",
       "         The number of columns in X11 and X21. 0 <= Q <=",
       "         MIN(P,M-P,M-Q)."],
     "X11"=>
      ["[in,out]",
       "         X11 is REAL array, dimension (LDX11,Q)",
       "         On entry, the top-left block of the orthogonal matrix to be",
       "         reduced. On exit, the form depends on TRANS:",
       "         If TRANS = 'N', then",
       "            the columns of tril(X11) specify reflectors for P1,",
       "            the rows of triu(X11,1) specify reflectors for Q1;",
       "         else TRANS = 'T', and",
       "            the rows of triu(X11) specify reflectors for P1,",
       "            the columns of tril(X11,-1) specify reflectors for Q1."],
     "LDX11"=>
      ["[in]",
       "         LDX11 is INTEGER",
       "         The leading dimension of X11. If TRANS = 'N', then LDX11 >=",
       "         P; else LDX11 >= Q."],
     "X12"=>
      ["[in,out]",
       "         X12 is REAL array, dimension (LDX12,M-Q)",
       "         On entry, the top-right block of the orthogonal matrix to",
       "         be reduced. On exit, the form depends on TRANS:",
       "         If TRANS = 'N', then",
       "            the rows of triu(X12) specify the first P reflectors for",
       "            Q2;",
       "         else TRANS = 'T', and",
       "            the columns of tril(X12) specify the first P reflectors",
       "            for Q2."],
     "LDX12"=>
      ["[in]",
       "         LDX12 is INTEGER",
       "         The leading dimension of X12. If TRANS = 'N', then LDX12 >=",
       "         P; else LDX11 >= M-Q."],
     "X21"=>
      ["[in,out]",
       "         X21 is REAL array, dimension (LDX21,Q)",
       "         On entry, the bottom-left block of the orthogonal matrix to",
       "         be reduced. On exit, the form depends on TRANS:",
       "         If TRANS = 'N', then",
       "            the columns of tril(X21) specify reflectors for P2;",
       "         else TRANS = 'T', and",
       "            the rows of triu(X21) specify reflectors for P2."],
     "LDX21"=>
      ["[in]",
       "         LDX21 is INTEGER",
       "         The leading dimension of X21. If TRANS = 'N', then LDX21 >=",
       "         M-P; else LDX21 >= Q."],
     "X22"=>
      ["[in,out]",
       "         X22 is REAL array, dimension (LDX22,M-Q)",
       "         On entry, the bottom-right block of the orthogonal matrix to",
       "         be reduced. On exit, the form depends on TRANS:",
       "         If TRANS = 'N', then",
       "            the rows of triu(X22(Q+1:M-P,P+1:M-Q)) specify the last",
       "            M-P-Q reflectors for Q2,",
       "         else TRANS = 'T', and",
       "            the columns of tril(X22(P+1:M-Q,Q+1:M-P)) specify the last",
       "            M-P-Q reflectors for P2."],
     "LDX22"=>
      ["[in]",
       "         LDX22 is INTEGER",
       "         The leading dimension of X22. If TRANS = 'N', then LDX22 >=",
       "         M-P; else LDX22 >= M-Q."],
     "THETA"=>
      ["[out]",
       "         THETA is REAL array, dimension (Q)",
       "         The entries of the bidiagonal blocks B11, B12, B21, B22 can",
       "         be computed from the angles THETA and PHI. See Further",
       "         Details."],
     "PHI"=>
      ["[out]",
       "         PHI is REAL array, dimension (Q-1)",
       "         The entries of the bidiagonal blocks B11, B12, B21, B22 can",
       "         be computed from the angles THETA and PHI. See Further",
       "         Details."],
     "TAUP1"=>
      ["[out]",
       "         TAUP1 is REAL array, dimension (P)",
       "         The scalar factors of the elementary reflectors that define",
       "         P1."],
     "TAUP2"=>
      ["[out]",
       "         TAUP2 is REAL array, dimension (M-P)",
       "         The scalar factors of the elementary reflectors that define",
       "         P2."],
     "TAUQ1"=>
      ["[out]",
       "         TAUQ1 is REAL array, dimension (Q)",
       "         The scalar factors of the elementary reflectors that define",
       "         Q1."],
     "TAUQ2"=>
      ["[out]",
       "         TAUQ2 is REAL array, dimension (M-Q)",
       "         The scalar factors of the elementary reflectors that define",
       "         Q2."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (LWORK)"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= M-Q.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "spftrf"=>
  {"summary"=>
    ["SPFTRF computes the Cholesky factorization of a real symmetric",
     "positive definite matrix A.",
     "The factorization has the form",
     "   A = U**T * U,  if UPLO = 'U', or",
     "   A = L  * L**T,  if UPLO = 'L',",
     "where U is an upper triangular matrix and L is lower triangular.",
     "This is the block version of the algorithm, calling Level 3 BLAS."],
   "param"=>
    {"TRANSR"=>
      ["[in]",
       "         TRANSR is CHARACTER*1",
       "         = 'N':  The Normal TRANSR of RFP A is stored;",
       "         = 'T':  The Transpose TRANSR of RFP A is stored."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of RFP A is stored;",
       "         = 'L':  Lower triangle of RFP A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension ( N*(N+1)/2 );",
       "         On entry, the symmetric matrix A in RFP format. RFP format is",
       "         described by TRANSR, UPLO, and N as follows: If TRANSR = 'N'",
       "         then RFP A is (0:N,0:k-1) when N is even; k=N/2. RFP A is",
       "         (0:N-1,0:k) when N is odd; k=N/2. IF TRANSR = 'T' then RFP is",
       "         the transpose of RFP A as defined when",
       "         TRANSR = 'N'. The contents of RFP A are defined by UPLO as",
       "         follows: If UPLO = 'U' the RFP A contains the NT elements of",
       "         upper packed A. If UPLO = 'L' the RFP A contains the elements",
       "         of lower packed A. The LDA of RFP A is (N+1)/2 when TRANSR =",
       "         'T'. When TRANSR is 'N' the LDA is N+1 when N is even and N",
       "         is odd. See the Note below for more details.",
       "         On exit, if INFO = 0, the factor U or L from the Cholesky",
       "         factorization RFP A = U**T*U or RFP A = L*L**T."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the leading minor of order i is not",
       "               positive definite, and the factorization could not be",
       "               completed."]}},
 "cgtrfs"=>
  {"summary"=>
    ["CGTRFS improves the computed solution to a system of linear",
     "equations when the coefficient matrix is tridiagonal, and provides",
     "error bounds and backward error estimates for the solution."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         Specifies the form of the system of equations:",
       "         = 'N':  A * X = B     (No transpose)",
       "         = 'T':  A**T * X = B  (Transpose)",
       "         = 'C':  A**H * X = B  (Conjugate transpose)"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "DL"=>
      ["[in]",
       "         DL is COMPLEX array, dimension (N-1)",
       "         The (n-1) subdiagonal elements of A."],
     "D"=>
      ["[in]",
       "         D is COMPLEX array, dimension (N)",
       "         The diagonal elements of A."],
     "DU"=>
      ["[in]",
       "         DU is COMPLEX array, dimension (N-1)",
       "         The (n-1) superdiagonal elements of A."],
     "DLF"=>
      ["[in]",
       "         DLF is COMPLEX array, dimension (N-1)",
       "         The (n-1) multipliers that define the matrix L from the",
       "         LU factorization of A as computed by CGTTRF."],
     "DF"=>
      ["[in]",
       "         DF is COMPLEX array, dimension (N)",
       "         The n diagonal elements of the upper triangular matrix U from",
       "         the LU factorization of A."],
     "DUF"=>
      ["[in]",
       "         DUF is COMPLEX array, dimension (N-1)",
       "         The (n-1) elements of the first superdiagonal of U."],
     "DU2"=>
      ["[in]",
       "         DU2 is COMPLEX array, dimension (N-2)",
       "         The (n-2) elements of the second superdiagonal of U."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices; for 1 <= i <= n, row i of the matrix was",
       "         interchanged with row IPIV(i).  IPIV(i) will always be either",
       "         i or i+1; IPIV(i) = i indicates a row interchange was not",
       "         required."],
     "B"=>
      ["[in]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array, dimension (LDX,NRHS)",
       "         On entry, the solution matrix X, as computed by CGTTRS.",
       "         On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.  LDX >= max(1,N)."],
     "FERR"=>
      ["[out]",
       "         FERR is REAL array, dimension (NRHS)",
       "         The estimated forward error bound for each solution vector",
       "         X(j) (the j-th column of the solution matrix X).",
       "         If XTRUE is the true solution corresponding to X(j), FERR(j)",
       "         is an estimated upper bound for the magnitude of the largest",
       "         element in (X(j) - XTRUE) divided by the magnitude of the",
       "         largest element in X(j).  The estimate is as reliable as",
       "         the estimate for RCOND, and is almost always a slight",
       "         overestimate of the true error."],
     "BERR"=>
      ["[out]",
       "         BERR is REAL array, dimension (NRHS)",
       "         The componentwise relative backward error of each solution",
       "         vector X(j) (i.e., the smallest relative change in",
       "         any element of A or B that makes X(j) an exact solution)."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (2*N)"],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dpbrfs"=>
  {"summary"=>
    ["DPBRFS improves the computed solution to a system of linear",
     "equations when the coefficient matrix is symmetric positive definite",
     "and banded, and provides error bounds and backward error estimates",
     "for the solution."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrices B and X.  NRHS >= 0."],
     "AB"=>
      ["[in]",
       "         AB is DOUBLE PRECISION array, dimension (LDAB,N)",
       "         The upper or lower triangle of the symmetric band matrix A,",
       "         stored in the first KD+1 rows of the array.  The j-th column",
       "         of A is stored in the j-th column of the array AB as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd)."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD+1."],
     "AFB"=>
      ["[in]",
       "         AFB is DOUBLE PRECISION array, dimension (LDAFB,N)",
       "         The triangular factor U or L from the Cholesky factorization",
       "         A = U**T*U or A = L*L**T of the band matrix A as computed by",
       "         DPBTRF, in the same storage format as A (see AB)."],
     "LDAFB"=>
      ["[in]",
       "         LDAFB is INTEGER",
       "         The leading dimension of the array AFB.  LDAFB >= KD+1."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array, dimension (LDX,NRHS)",
       "         On entry, the solution matrix X, as computed by DPBTRS.",
       "         On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.  LDX >= max(1,N)."],
     "FERR"=>
      ["[out]",
       "         FERR is DOUBLE PRECISION array, dimension (NRHS)",
       "         The estimated forward error bound for each solution vector",
       "         X(j) (the j-th column of the solution matrix X).",
       "         If XTRUE is the true solution corresponding to X(j), FERR(j)",
       "         is an estimated upper bound for the magnitude of the largest",
       "         element in (X(j) - XTRUE) divided by the magnitude of the",
       "         largest element in X(j).  The estimate is as reliable as",
       "         the estimate for RCOND, and is almost always a slight",
       "         overestimate of the true error."],
     "BERR"=>
      ["[out]",
       "         BERR is DOUBLE PRECISION array, dimension (NRHS)",
       "         The componentwise relative backward error of each solution",
       "         vector X(j) (i.e., the smallest relative change in",
       "         any element of A or B that makes X(j) an exact solution)."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (3*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "csycon_rook"=>
  {"summary"=>
    ["CSYCON_ROOK estimates the reciprocal of the condition number (in the",
     "1-norm) of a complex symmetric matrix A using the factorization",
     "A = U*D*U**T or A = L*D*L**T computed by CSYTRF_ROOK.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by CSYTRF_ROOK."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by CSYTRF_ROOK."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         The 1-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an",
       "         estimate of the 1-norm of inv(A) computed in this routine."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (2*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dlasdq"=>
  {"summary"=>
    ["DLASDQ computes the singular value decomposition (SVD) of a real",
     "(upper or lower) bidiagonal matrix with diagonal D and offdiagonal",
     "E, accumulating the transformations if desired. Letting B denote",
     "the input bidiagonal matrix, the algorithm computes orthogonal",
     "matrices Q and P such that B = Q * S * P**T (P**T denotes the transpose",
     "of P). The singular values S are overwritten on D.",
     "The input matrix U  is changed to U  * Q  if desired.",
     "The input matrix VT is changed to P**T * VT if desired.",
     "The input matrix C  is changed to Q**T * C  if desired.",
     "See \"Computing  Small Singular Values of Bidiagonal Matrices With",
     "Guaranteed High Relative Accuracy,\" by J. Demmel and W. Kahan,",
     "LAPACK Working Note #3, for a detailed description of the algorithm."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "       On entry, UPLO specifies whether the input bidiagonal matrix",
       "       is upper or lower bidiagonal, and whether it is square are",
       "       not.",
       "          UPLO = 'U' or 'u'   B is upper bidiagonal.",
       "          UPLO = 'L' or 'l'   B is lower bidiagonal."],
     "SQRE"=>
      ["[in]",
       "         SQRE is INTEGER",
       "       = 0: then the input matrix is N-by-N.",
       "       = 1: then the input matrix is N-by-(N+1) if UPLU = 'U' and",
       "            (N+1)-by-N if UPLU = 'L'.",
       "       The bidiagonal matrix has",
       "       N = NL + NR + 1 rows and",
       "       M = N + SQRE >= N columns."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "       On entry, N specifies the number of rows and columns",
       "       in the matrix. N must be at least 0."],
     "NCVT"=>
      ["[in]",
       "         NCVT is INTEGER",
       "       On entry, NCVT specifies the number of columns of",
       "       the matrix VT. NCVT must be at least 0."],
     "NRU"=>
      ["[in]",
       "         NRU is INTEGER",
       "       On entry, NRU specifies the number of rows of",
       "       the matrix U. NRU must be at least 0."],
     "NCC"=>
      ["[in]",
       "         NCC is INTEGER",
       "       On entry, NCC specifies the number of columns of",
       "       the matrix C. NCC must be at least 0."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "       On entry, D contains the diagonal entries of the",
       "       bidiagonal matrix whose SVD is desired. On normal exit,",
       "       D contains the singular values in ascending order."],
     "E"=>
      ["[in,out]",
       "         E is DOUBLE PRECISION array.",
       "       dimension is (N-1) if SQRE = 0 and N if SQRE = 1.",
       "       On entry, the entries of E contain the offdiagonal entries",
       "       of the bidiagonal matrix whose SVD is desired. On normal",
       "       exit, E will contain 0. If the algorithm does not converge,",
       "       D and E will contain the diagonal and superdiagonal entries",
       "       of a bidiagonal matrix orthogonally equivalent to the one",
       "       given as input."],
     "VT"=>
      ["[in,out]",
       "         VT is DOUBLE PRECISION array, dimension (LDVT, NCVT)",
       "       On entry, contains a matrix which on exit has been",
       "       premultiplied by P**T, dimension N-by-NCVT if SQRE = 0",
       "       and (N+1)-by-NCVT if SQRE = 1 (not referenced if NCVT=0)."],
     "LDVT"=>
      ["[in]",
       "         LDVT is INTEGER",
       "       On entry, LDVT specifies the leading dimension of VT as",
       "       declared in the calling (sub) program. LDVT must be at",
       "       least 1. If NCVT is nonzero LDVT must also be at least N."],
     "U"=>
      ["[in,out]",
       "         U is DOUBLE PRECISION array, dimension (LDU, N)",
       "       On entry, contains a  matrix which on exit has been",
       "       postmultiplied by Q, dimension NRU-by-N if SQRE = 0",
       "       and NRU-by-(N+1) if SQRE = 1 (not referenced if NRU=0)."],
     "LDU"=>
      ["[in]",
       "         LDU is INTEGER",
       "       On entry, LDU  specifies the leading dimension of U as",
       "       declared in the calling (sub) program. LDU must be at",
       "       least max( 1, NRU ) ."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array, dimension (LDC, NCC)",
       "       On entry, contains an N-by-NCC matrix which on exit",
       "       has been premultiplied by Q**T  dimension N-by-NCC if SQRE = 0",
       "       and (N+1)-by-NCC if SQRE = 1 (not referenced if NCC=0)."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "       On entry, LDC  specifies the leading dimension of C as",
       "       declared in the calling (sub) program. LDC must be at",
       "       least 1. If NCC is nonzero, LDC must also be at least N."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (4*N)",
       "       Workspace. Only referenced if one of NCVT, NRU, or NCC is",
       "       nonzero, and if N is at least 2."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "       On exit, a value of 0 indicates a successful exit.",
       "       If INFO < 0, argument number -INFO is illegal.",
       "       If INFO > 0, the algorithm did not converge, and INFO",
       "       specifies how many superdiagonals did not converge."]}},
 "slansf"=>
  {"summary"=>
    ["SLANSF returns the value of the one norm, or the Frobenius norm, or",
     "the infinity norm, or the element of largest absolute value of a",
     "real symmetric matrix A in RFP format.",
     "   SLANSF = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a  matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in SLANSF as described",
       "         above."],
     "TRANSR"=>
      ["[in]",
       "         TRANSR is CHARACTER*1",
       "         Specifies whether the RFP format of A is normal or",
       "         transposed format.",
       "         = 'N':  RFP format is Normal;",
       "         = 'T':  RFP format is Transpose."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the RFP matrix A came from",
       "          an upper or lower triangular matrix as follows:",
       "          = 'U': RFP A came from an upper triangular matrix;",
       "          = 'L': RFP A came from a lower triangular matrix."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A. N >= 0. When N = 0, SLANSF is",
       "         set to zero."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension ( N*(N+1)/2 );",
       "         On entry, the upper (if UPLO = 'U') or lower (if UPLO = 'L')",
       "         part of the symmetric matrix A stored in RFP format. See the",
       "         \"Notes\" below for more details.",
       "         Unchanged on exit."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,",
       "         WORK is not referenced."]}},
 "slaqgb"=>
  {"summary"=>
    ["SLAQGB equilibrates a general M by N band matrix A with KL",
     "subdiagonals and KU superdiagonals using the row and scaling factors",
     "in the vectors R and C."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "         The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "         The number of superdiagonals within the band of A.  KU >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is REAL array, dimension (LDAB,N)",
       "         On entry, the matrix A in band storage, in rows 1 to KL+KU+1.",
       "         The j-th column of A is stored in the j-th column of the",
       "         array AB as follows:",
       "         AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)",
       "         On exit, the equilibrated matrix, in the same storage format",
       "         as A.  See EQUED for the form of the equilibrated matrix."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDA >= KL+KU+1."],
     "R"=>
      ["[in]",
       "         R is REAL array, dimension (M)",
       "         The row scale factors for A."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension (N)",
       "         The column scale factors for A."],
     "ROWCND"=>
      ["[in]",
       "         ROWCND is REAL",
       "         Ratio of the smallest R(i) to the largest R(i)."],
     "COLCND"=>
      ["[in]",
       "         COLCND is REAL",
       "         Ratio of the smallest C(i) to the largest C(i)."],
     "AMAX"=>
      ["[in]",
       "         AMAX is REAL",
       "         Absolute value of largest matrix entry."],
     "EQUED"=>
      ["[out]",
       "         EQUED is CHARACTER*1",
       "         Specifies the form of equilibration that was done.",
       "         = 'N':  No equilibration",
       "         = 'R':  Row equilibration, i.e., A has been premultiplied by",
       "                 diag(R).",
       "         = 'C':  Column equilibration, i.e., A has been postmultiplied",
       "                 by diag(C).",
       "         = 'B':  Both row and column equilibration, i.e., A has been",
       "                 replaced by diag(R) * A * diag(C)."]}},
 "cladiv"=>
  {"summary"=>
    ["CLADIV := X / Y, where X and Y are complex.  The computation of X / Y",
     "will not overflow on an intermediary step unless the results",
     "overflows."],
   "param"=>
    {"X"=>["[in]", "         X is COMPLEX"],
     "Y"=>
      ["[in]",
       "         Y is COMPLEX",
       "         The complex scalars X and Y."]}},
 "zunbdb1"=>
  {"summary"=>[],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "          The number of rows X11 plus the number of rows in X21."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "          The number of rows in X11. 0 <= P <= M."],
     "Q"=>
      ["[in]",
       "         Q is INTEGER",
       "          The number of columns in X11 and X21. 0 <= Q <=",
       "          MIN(P,M-P,M-Q)."],
     "X11"=>
      ["[in,out]",
       "         X11 is COMPLEX*16 array, dimension (LDX11,Q)",
       "          On entry, the top block of the matrix X to be reduced. On",
       "          exit, the columns of tril(X11) specify reflectors for P1 and",
       "          the rows of triu(X11,1) specify reflectors for Q1."],
     "LDX11"=>
      ["[in]",
       "         LDX11 is INTEGER",
       "          The leading dimension of X11. LDX11 >= P."],
     "X21"=>
      ["[in,out]",
       "         X21 is COMPLEX*16 array, dimension (LDX21,Q)",
       "          On entry, the bottom block of the matrix X to be reduced. On",
       "          exit, the columns of tril(X21) specify reflectors for P2."],
     "LDX21"=>
      ["[in]",
       "         LDX21 is INTEGER",
       "          The leading dimension of X21. LDX21 >= M-P."],
     "THETA"=>
      ["[out]",
       "         THETA is DOUBLE PRECISION array, dimension (Q)",
       "          The entries of the bidiagonal blocks B11, B21 are defined by",
       "          THETA and PHI. See Further Details."],
     "PHI"=>
      ["[out]",
       "         PHI is DOUBLE PRECISION array, dimension (Q-1)",
       "          The entries of the bidiagonal blocks B11, B21 are defined by",
       "          THETA and PHI. See Further Details."],
     "TAUP1"=>
      ["[out]",
       "         TAUP1 is COMPLEX*16 array, dimension (P)",
       "          The scalar factors of the elementary reflectors that define",
       "          P1."],
     "TAUP2"=>
      ["[out]",
       "         TAUP2 is COMPLEX*16 array, dimension (M-P)",
       "          The scalar factors of the elementary reflectors that define",
       "          P2."],
     "TAUQ1"=>
      ["[out]",
       "         TAUQ1 is COMPLEX*16 array, dimension (Q)",
       "          The scalar factors of the elementary reflectors that define",
       "          Q1."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (LWORK)"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "          The dimension of the array WORK. LWORK >= M-Q.",
       "          If LWORK = -1, then a workspace query is assumed; the routine",
       "          only calculates the optimal size of the WORK array, returns",
       "          this value as the first entry of the WORK array, and no error",
       "          message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "          = 0:  successful exit.",
       "          < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "dlargv"=>
  {"summary"=>
    ["DLARGV generates a vector of real plane rotations, determined by",
     "elements of the real vectors x and y. For i = 1,2,...,n",
     "   (  c(i)  s(i) ) ( x(i) ) = ( a(i) )",
     "   ( -s(i)  c(i) ) ( y(i) ) = (   0  )"],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of plane rotations to be generated."],
     "X"=>
      ["[in,out]",
       "         X is DOUBLE PRECISION array,",
       "                        dimension (1+(N-1)*INCX)",
       "         On entry, the vector x.",
       "         On exit, x(i) is overwritten by a(i), for i = 1,...,n."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between elements of X. INCX > 0."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array,",
       "                        dimension (1+(N-1)*INCY)",
       "         On entry, the vector y.",
       "         On exit, the sines of the plane rotations."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "         The increment between elements of Y. INCY > 0."],
     "C"=>
      ["[out]",
       "         C is DOUBLE PRECISION array, dimension (1+(N-1)*INCC)",
       "         The cosines of the plane rotations."],
     "INCC"=>
      ["[in]",
       "         INCC is INTEGER",
       "         The increment between elements of C. INCC > 0."]}},
 "strti2"=>
  {"summary"=>
    ["STRTI2 computes the inverse of a real upper or lower triangular",
     "matrix.",
     "This is the Level 2 BLAS version of the algorithm."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the matrix A is upper or lower triangular.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         Specifies whether or not the matrix A is unit triangular.",
       "         = 'N':  Non-unit triangular",
       "         = 'U':  Unit triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the triangular matrix A.  If UPLO = 'U', the",
       "         leading n by n upper triangular part of the array A contains",
       "         the upper triangular matrix, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n by n lower triangular part of the array A contains",
       "         the lower triangular matrix, and the strictly upper",
       "         triangular part of A is not referenced.  If DIAG = 'U', the",
       "         diagonal elements of A are also not referenced and are",
       "         assumed to be 1.",
       "         On exit, the (triangular) inverse of the original matrix, in",
       "         the same storage format."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value"]}},
 "chbevx"=>
  {"summary"=>
    ["CHBEVX computes selected eigenvalues and, optionally, eigenvectors",
     "of a complex Hermitian band matrix A.  Eigenvalues and eigenvectors",
     "can be selected by specifying either a range of values or a range of",
     "indices for the desired eigenvalues."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found;",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found;",
       "         = 'I': the IL-th through IU-th eigenvalues will be found."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is COMPLEX array, dimension (LDAB, N)",
       "         On entry, the upper or lower triangle of the Hermitian band",
       "         matrix A, stored in the first KD+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         On exit, AB is overwritten by values generated during the",
       "         reduction to tridiagonal form."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD + 1."],
     "Q"=>
      ["[out]",
       "         Q is COMPLEX array, dimension (LDQ, N)",
       "         If JOBZ = 'V', the N-by-N unitary matrix used in the",
       "                         reduction to tridiagonal form.",
       "         If JOBZ = 'N', the array Q is not referenced."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.  If JOBZ = 'V', then",
       "         LDQ >= max(1,N)."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is REAL",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing AB to tridiagonal form.",
       "         Eigenvalues will be computed most accurately when ABSTOL is",
       "         set to twice the underflow threshold 2*SLAMCH('S'), not zero.",
       "         If this routine returns with INFO>0, indicating that some",
       "         eigenvectors did not converge, try setting ABSTOL to",
       "         2*SLAMCH('S').",
       "         See \"Computing Small Singular Values of Bidiagonal Matrices",
       "         with Guaranteed High Relative Accuracy,\" by Demmel and",
       "         Kahan, LAPACK Working Note #3."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         The first M elements contain the selected eigenvalues in",
       "         ascending order."],
     "Z"=>
      ["[out]",
       "         Z is COMPLEX array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If an eigenvector fails to converge, then that column of Z",
       "         contains the latest approximation to the eigenvector, and the",
       "         index of the eigenvector is returned in IFAIL.",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (N)"],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (7*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (5*N)"],
     "IFAIL"=>
      ["[out]",
       "         IFAIL is INTEGER array, dimension (N)",
       "         If JOBZ = 'V', then if INFO = 0, the first M elements of",
       "         IFAIL are zero.  If INFO > 0, then IFAIL contains the",
       "         indices of the eigenvectors that failed to converge.",
       "         If JOBZ = 'N', then IFAIL is not referenced."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, then i eigenvectors failed to converge.",
       "               Their indices are stored in array IFAIL."]}},
 "ssyrfs"=>
  {"summary"=>
    ["SSYRFS improves the computed solution to a system of linear",
     "equations when the coefficient matrix is symmetric indefinite, and",
     "provides error bounds and backward error estimates for the solution."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrices B and X.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         The symmetric matrix A.  If UPLO = 'U', the leading N-by-N",
       "         upper triangular part of A contains the upper triangular part",
       "         of the matrix A, and the strictly lower triangular part of A",
       "         is not referenced.  If UPLO = 'L', the leading N-by-N lower",
       "         triangular part of A contains the lower triangular part of",
       "         the matrix A, and the strictly upper triangular part of A is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is REAL array, dimension (LDAF,N)",
       "         The factored form of the matrix A.  AF contains the block",
       "         diagonal matrix D and the multipliers used to obtain the",
       "         factor U or L from the factorization A = U*D*U**T or",
       "         A = L*D*L**T as computed by SSYTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "         The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by SSYTRF."],
     "B"=>
      ["[in]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "         The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is REAL array, dimension (LDX,NRHS)",
       "         On entry, the solution matrix X, as computed by SSYTRS.",
       "         On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.  LDX >= max(1,N)."],
     "FERR"=>
      ["[out]",
       "         FERR is REAL array, dimension (NRHS)",
       "         The estimated forward error bound for each solution vector",
       "         X(j) (the j-th column of the solution matrix X).",
       "         If XTRUE is the true solution corresponding to X(j), FERR(j)",
       "         is an estimated upper bound for the magnitude of the largest",
       "         element in (X(j) - XTRUE) divided by the magnitude of the",
       "         largest element in X(j).  The estimate is as reliable as",
       "         the estimate for RCOND, and is almost always a slight",
       "         overestimate of the true error."],
     "BERR"=>
      ["[out]",
       "         BERR is REAL array, dimension (NRHS)",
       "         The componentwise relative backward error of each solution",
       "         vector X(j) (i.e., the smallest relative change in",
       "         any element of A or B that makes X(j) an exact solution)."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (3*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zsysvxx"=>
  {"summary"=>
    ["   ZSYSVXX uses the diagonal pivoting factorization to compute the",
     "   solution to a complex*16 system of linear equations A * X = B, where",
     "   A is an N-by-N symmetric matrix and X and B are N-by-NRHS",
     "   matrices.",
     "   If requested, both normwise and maximum componentwise error bounds",
     "   are returned. ZSYSVXX will return a solution with a tiny",
     "   guaranteed error (O(eps) where eps is the working machine",
     "   precision) unless the matrix is very ill-conditioned, in which",
     "   case a warning is returned. Relevant condition numbers also are",
     "   calculated and returned.",
     "   ZSYSVXX accepts user-provided factorizations and equilibration",
     "   factors; see the definitions of the FACT and EQUED options.",
     "   Solving with refinement and using a factorization from a previous",
     "   ZSYSVXX call will also produce a solution with either O(eps)",
     "   errors or warnings, but we cannot make that claim for general",
     "   user-provided factorizations and equilibration factors if they",
     "   differ from what ZSYSVXX would itself produce."],
   "param"=>nil},
 "cpocon"=>
  {"summary"=>
    ["CPOCON estimates the reciprocal of the condition number (in the",
     "1-norm) of a complex Hermitian positive definite matrix using the",
     "Cholesky factorization A = U**H*U or A = L*L**H computed by CPOTRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         The triangular factor U or L from the Cholesky factorization",
       "         A = U**H*U or A = L*L**H, as computed by CPOTRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         The 1-norm (or infinity-norm) of the Hermitian matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an",
       "         estimate of the 1-norm of inv(A) computed in this routine."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (2*N)"],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dptcon"=>
  {"summary"=>
    ["DPTCON computes the reciprocal of the condition number (in the",
     "1-norm) of a real symmetric positive definite tridiagonal matrix",
     "using the factorization A = L*D*L**T or A = U**T*D*U computed by",
     "DPTTRF.",
     "Norm(inv(A)) is computed by a direct method, and the reciprocal of",
     "the condition number is computed as",
     "             RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "D"=>
      ["[in]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         The n diagonal elements of the diagonal matrix D from the",
       "         factorization of A, as computed by DPTTRF."],
     "E"=>
      ["[in]",
       "         E is DOUBLE PRECISION array, dimension (N-1)",
       "         The (n-1) off-diagonal elements of the unit bidiagonal factor",
       "         U or L from the factorization of A,  as computed by DPTTRF."],
     "ANORM"=>
      ["[in]",
       "         ANORM is DOUBLE PRECISION",
       "         The 1-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is DOUBLE PRECISION",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is the",
       "         1-norm of inv(A) computed in this routine."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zsytf2_rook"=>
  {"summary"=>
    ["ZSYTF2_ROOK computes the factorization of a complex symmetric matrix A",
     "using the bounded Bunch-Kaufman (\"rook\") diagonal pivoting method:",
     "   A = U*D*U**T  or  A = L*D*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, U**T is the transpose of U, and D is symmetric and",
     "block diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "This is the unblocked version of the algorithm, calling Level 2 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         n-by-n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n-by-n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L (see below for further details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If UPLO = 'U':",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "            were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) < 0 and IPIV(k-1) < 0, then rows and",
       "            columns k and -IPIV(k) were interchanged and rows and",
       "            columns k-1 and -IPIV(k-1) were inerchaged,",
       "            D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "            were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) < 0 and IPIV(k+1) < 0, then rows and",
       "            columns k and -IPIV(k) were interchanged and rows and",
       "            columns k+1 and -IPIV(k+1) were inerchaged,",
       "            D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value",
       "         > 0: if INFO = k, D(k,k) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if it",
       "              is used to solve a system of equations."]}},
 "sormhr"=>
  {"summary"=>
    ["SORMHR overwrites the general real M-by-N matrix C with",
     "                SIDE = 'L'     SIDE = 'R'",
     "TRANS = 'N':      Q * C          C * Q",
     "TRANS = 'T':      Q**T * C       C * Q**T",
     "where Q is a real orthogonal matrix of order nq, with nq = m if",
     "SIDE = 'L' and nq = n if SIDE = 'R'. Q is defined as the product of",
     "IHI-ILO elementary reflectors, as returned by SGEHRD:",
     "Q = H(ilo) H(ilo+1) . . . H(ihi-1)."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**T from the Left;",
       "         = 'R': apply Q or Q**T from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'T':  Transpose, apply Q**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "         ILO and IHI must have the same values as in the previous call",
       "         of SGEHRD. Q is equal to the unit matrix except in the",
       "         submatrix Q(ilo+1:ihi,ilo+1:ihi).",
       "         If SIDE = 'L', then 1 <= ILO <= IHI <= M, if M > 0, and",
       "         ILO = 1 and IHI = 0, if M = 0;",
       "         if SIDE = 'R', then 1 <= ILO <= IHI <= N, if N > 0, and",
       "         ILO = 1 and IHI = 0, if N = 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension",
       "                              (LDA,M) if SIDE = 'L'",
       "                              (LDA,N) if SIDE = 'R'",
       "         The vectors which define the elementary reflectors, as",
       "         returned by SGEHRD."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.",
       "         LDA >= max(1,M) if SIDE = 'L'; LDA >= max(1,N) if SIDE = 'R'."],
     "TAU"=>
      ["[in]",
       "         TAU is REAL array, dimension",
       "                              (M-1) if SIDE = 'L'",
       "                              (N-1) if SIDE = 'R'",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by SGEHRD."],
     "C"=>
      ["[in,out]",
       "         C is REAL array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If SIDE = 'L', LWORK >= max(1,N);",
       "         if SIDE = 'R', LWORK >= max(1,M).",
       "         For optimum performance LWORK >= N*NB if SIDE = 'L', and",
       "         LWORK >= M*NB if SIDE = 'R', where NB is the optimal",
       "         blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zhetri_rook"=>
  {"summary"=>
    ["ZHETRI_ROOK computes the inverse of a complex Hermitian indefinite matrix",
     "A using the factorization A = U*D*U**H or A = L*D*L**H computed by",
     "ZHETRF_ROOK."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**H;",
       "         = 'L':  Lower triangular, form is A = L*D*L**H."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the block diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by ZHETRF_ROOK.",
       "         On exit, if INFO = 0, the (Hermitian) inverse of the original",
       "         matrix.  If UPLO = 'U', the upper triangular part of the",
       "         inverse is formed and the part of A below the diagonal is not",
       "         referenced; if UPLO = 'L' the lower triangular part of the",
       "         inverse is formed and the part of A above the diagonal is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by ZHETRF_ROOK."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "cptts2"=>
  {"summary"=>
    ["CPTTS2 solves a tridiagonal system of the form",
     "   A * X = B",
     "using the factorization A = U**H*D*U or A = L*D*L**H computed by CPTTRF.",
     "D is a diagonal matrix specified in the vector D, U (or L) is a unit",
     "bidiagonal matrix whose superdiagonal (subdiagonal) is specified in",
     "the vector E, and X and B are N by NRHS matrices."],
   "param"=>
    {"IUPLO"=>
      ["[in]",
       "         IUPLO is INTEGER",
       "         Specifies the form of the factorization and whether the",
       "         vector E is the superdiagonal of the upper bidiagonal factor",
       "         U or the subdiagonal of the lower bidiagonal factor L.",
       "         = 1:  A = U**H *D*U, E is the superdiagonal of U",
       "         = 0:  A = L*D*L**H, E is the subdiagonal of L"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the tridiagonal matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension (N)",
       "         The n diagonal elements of the diagonal matrix D from the",
       "         factorization A = U**H *D*U or A = L*D*L**H."],
     "E"=>
      ["[in]",
       "         E is COMPLEX array, dimension (N-1)",
       "         If IUPLO = 1, the (n-1) superdiagonal elements of the unit",
       "         bidiagonal factor U from the factorization A = U**H*D*U.",
       "         If IUPLO = 0, the (n-1) subdiagonal elements of the unit",
       "         bidiagonal factor L from the factorization A = L*D*L**H."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the right hand side vectors B for the system of",
       "         linear equations.",
       "         On exit, the solution vectors, X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."]}},
 "zhbevd"=>
  {"summary"=>
    ["ZHBEVD computes all the eigenvalues and, optionally, eigenvectors of",
     "a complex Hermitian band matrix A.  If eigenvectors are desired, it",
     "uses a divide and conquer algorithm.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is COMPLEX*16 array, dimension (LDAB, N)",
       "         On entry, the upper or lower triangle of the Hermitian band",
       "         matrix A, stored in the first KD+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         On exit, AB is overwritten by values generated during the",
       "         reduction to tridiagonal form.  If UPLO = 'U', the first",
       "         superdiagonal and the diagonal of the tridiagonal matrix T",
       "         are returned in rows KD and KD+1 of AB, and if UPLO = 'L',",
       "         the diagonal and first subdiagonal of T are returned in the",
       "         first two rows of AB."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD + 1."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is COMPLEX*16 array, dimension (LDZ, N)",
       "         If JOBZ = 'V', then if INFO = 0, Z contains the orthonormal",
       "         eigenvectors of the matrix A, with the i-th column of Z",
       "         holding the eigenvector associated with W(i).",
       "         If JOBZ = 'N', then Z is not referenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If N <= 1,               LWORK must be at least 1.",
       "         If JOBZ = 'N' and N > 1, LWORK must be at least N.",
       "         If JOBZ = 'V' and N > 1, LWORK must be at least 2*N**2.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal sizes of the WORK, RWORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]",
       "         RWORK is DOUBLE PRECISION array,",
       "                                        dimension (LRWORK)",
       "         On exit, if INFO = 0, RWORK(1) returns the optimal LRWORK."],
     "LRWORK"=>
      ["[in]",
       "         LRWORK is INTEGER",
       "         The dimension of array RWORK.",
       "         If N <= 1,               LRWORK must be at least 1.",
       "         If JOBZ = 'N' and N > 1, LRWORK must be at least N.",
       "         If JOBZ = 'V' and N > 1, LRWORK must be at least",
       "                       1 + 5*N + 2*N**2.",
       "         If LRWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK, RWORK",
       "         and IWORK arrays, returns these values as the first entries",
       "         of the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of array IWORK.",
       "         If JOBZ = 'N' or N <= 1, LIWORK must be at least 1.",
       "         If JOBZ = 'V' and N > 1, LIWORK must be at least 3 + 5*N .",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK, RWORK",
       "         and IWORK arrays, returns these values as the first entries",
       "         of the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  if INFO = i, the algorithm failed to converge; i",
       "               off-diagonal elements of an intermediate tridiagonal",
       "               form did not converge to zero."]}},
 "slantr"=>
  {"summary"=>
    ["SLANTR  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the  element of  largest absolute value  of a",
     "trapezoidal or triangular matrix A.",
     "   SLANTR = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in SLANTR as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the matrix A is upper or lower trapezoidal.",
       "         = 'U':  Upper trapezoidal",
       "         = 'L':  Lower trapezoidal",
       "         Note that A is triangular instead of trapezoidal if M = N."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         Specifies whether or not the matrix A has unit diagonal.",
       "         = 'N':  Non-unit diagonal",
       "         = 'U':  Unit diagonal"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0, and if",
       "         UPLO = 'U', M <= N.  When M = 0, SLANTR is set to zero."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0, and if",
       "         UPLO = 'L', N <= M.  When N = 0, SLANTR is set to zero."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         The trapezoidal matrix A (A is triangular if M = N).",
       "         If UPLO = 'U', the leading m by n upper trapezoidal part of",
       "         the array A contains the upper trapezoidal matrix, and the",
       "         strictly lower triangular part of A is not referenced.",
       "         If UPLO = 'L', the leading m by n lower trapezoidal part of",
       "         the array A contains the lower trapezoidal matrix, and the",
       "         strictly upper triangular part of A is not referenced.  Note",
       "         that when DIAG = 'U', the diagonal elements of A are not",
       "         referenced and are assumed to be one."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(M,1)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= M when NORM = 'I'; otherwise, WORK is not",
       "         referenced."]}},
 "slasq3"=>
  {"summary"=>
    ["SLASQ3 checks for deflation, computes a shift (TAU) and calls dqds.",
     "In case of failure it changes shifts, and tries again until output",
     "is positive."],
   "param"=>
    {"I0"=>["[in]", "         I0 is INTEGER", "        First index."],
     "N0"=>["[in,out]", "         N0 is INTEGER", "        Last index."],
     "Z"=>
      ["[in,out]",
       "         Z is REAL array, dimension ( 4*N0 )",
       "        Z holds the qd array."],
     "PP"=>
      ["[in,out]",
       "         PP is INTEGER",
       "        PP=0 for ping, PP=1 for pong.",
       "        PP=2 indicates that flipping was applied to the Z array",
       "        and that the initial tests for deflation should not be",
       "        performed."],
     "DMIN"=>["[out]", "         DMIN is REAL", "        Minimum value of d."],
     "SIGMA"=>
      ["[out]",
       "         SIGMA is REAL",
       "        Sum of shifts used in current segment."],
     "DESIG"=>
      ["[in,out]",
       "         DESIG is REAL",
       "        Lower order part of SIGMA"],
     "QMAX"=>["[in]", "         QMAX is REAL", "        Maximum value of q."],
     "NFAIL"=>
      ["[in,out]",
       "         NFAIL is INTEGER",
       "        Increment NFAIL by 1 each time the shift was too big."],
     "ITER"=>
      ["[in,out]",
       "         ITER is INTEGER",
       "        Increment ITER by 1 for each iteration."],
     "NDIV"=>
      ["[in,out]",
       "         NDIV is INTEGER",
       "        Increment NDIV by 1 for each division."],
     "IEEE"=>
      ["[in]",
       "         IEEE is LOGICAL",
       "        Flag for IEEE or non IEEE arithmetic (passed to SLASQ5)."],
     "TTYPE"=>["[in,out]", "         TTYPE is INTEGER", "        Shift type."],
     "DMIN1"=>["[in,out]", "         DMIN1 is REAL"],
     "DMIN2"=>["[in,out]", "         DMIN2 is REAL"],
     "DN"=>["[in,out]", "         DN is REAL"],
     "DN1"=>["[in,out]", "         DN1 is REAL"],
     "DN2"=>["[in,out]", "         DN2 is REAL"],
     "G"=>["[in,out]", "         G is REAL"],
     "TAU"=>
      ["[in,out]",
       "         TAU is REAL",
       "        These are passed as arguments in order to save their values",
       "        between calls to SLASQ3."]}},
 "zhetri2"=>
  {"summary"=>
    ["ZHETRI2 computes the inverse of a COMPLEX*16 hermitian indefinite matrix",
     "A using the factorization A = U*D*U**T or A = L*D*L**T computed by",
     "ZHETRF. ZHETRI2 set the LEADING DIMENSION of the workspace",
     "before calling ZHETRI2X that actually computes the inverse."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the NB diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by ZHETRF.",
       "         On exit, if INFO = 0, the (symmetric) inverse of the original",
       "         matrix.  If UPLO = 'U', the upper triangular part of the",
       "         inverse is formed and the part of A below the diagonal is not",
       "         referenced; if UPLO = 'L' the lower triangular part of the",
       "         inverse is formed and the part of A above the diagonal is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the NB structure of D",
       "         as determined by ZHETRF."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (N+NB+1)*(NB+3)"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         WORK is size >= (N+NB+1)*(NB+3)",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "          calculates:",
       "             - the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array,",
       "             - and no error message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "zgttrf"=>
  {"summary"=>
    ["ZGTTRF computes an LU factorization of a complex tridiagonal matrix A",
     "using elimination with partial pivoting and row interchanges.",
     "The factorization has the form",
     "   A = L * U",
     "where L is a product of permutation and unit lower bidiagonal",
     "matrices and U is upper triangular with nonzeros in only the main",
     "diagonal and first two superdiagonals."],
   "param"=>
    {"N"=>
      ["[in]", "         N is INTEGER", "         The order of the matrix A."],
     "DL"=>
      ["[in,out]",
       "         DL is COMPLEX*16 array, dimension (N-1)",
       "         On entry, DL must contain the (n-1) sub-diagonal elements of",
       "         A.",
       "         On exit, DL is overwritten by the (n-1) multipliers that",
       "         define the matrix L from the LU factorization of A."],
     "D"=>
      ["[in,out]",
       "         D is COMPLEX*16 array, dimension (N)",
       "         On entry, D must contain the diagonal elements of A.",
       "         On exit, D is overwritten by the n diagonal elements of the",
       "         upper triangular matrix U from the LU factorization of A."],
     "DU"=>
      ["[in,out]",
       "         DU is COMPLEX*16 array, dimension (N-1)",
       "         On entry, DU must contain the (n-1) super-diagonal elements",
       "         of A.",
       "         On exit, DU is overwritten by the (n-1) elements of the first",
       "         super-diagonal of U."],
     "DU2"=>
      ["[out]",
       "         DU2 is COMPLEX*16 array, dimension (N-2)",
       "         On exit, DU2 is overwritten by the (n-2) elements of the",
       "         second super-diagonal of U."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices; for 1 <= i <= n, row i of the matrix was",
       "         interchanged with row IPIV(i).  IPIV(i) will always be either",
       "         i or i+1; IPIV(i) = i indicates a row interchange was not",
       "         required."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -k, the k-th argument had an illegal value",
       "         > 0:  if INFO = k, U(k,k) is exactly zero. The factorization",
       "               has been completed, but the factor U is exactly",
       "               singular, and division by zero will occur if it is used",
       "               to solve a system of equations."]}},
 "sgetri"=>
  {"summary"=>
    ["SGETRI computes the inverse of a matrix using the LU factorization",
     "computed by SGETRF.",
     "This method inverts U and then computes inv(A) by solving the system",
     "inv(A)*L = inv(U) for inv(A)."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the factors L and U from the factorization",
       "         A = P*L*U as computed by SGETRF.",
       "         On exit, if INFO = 0, the inverse of the original matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices from SGETRF; for 1<=i<=N, row i of the",
       "         matrix was interchanged with row IPIV(i)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO=0, then WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,N).",
       "         For optimal performance LWORK >= N*NB, where NB is",
       "         the optimal blocksize returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is",
       "               singular and its inverse could not be computed."]}},
 "claqp2"=>
  {"summary"=>
    ["CLAQP2 computes a QR factorization with column pivoting of",
     "the block A(OFFSET+1:M,1:N).",
     "The block A(1:OFFSET,1:N) is accordingly pivoted, but not factorized."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A. N >= 0."],
     "OFFSET"=>
      ["[in]",
       "         OFFSET is INTEGER",
       "         The number of rows of the matrix A that must be pivoted",
       "         but no factorized. OFFSET >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, the upper triangle of block A(OFFSET+1:M,1:N) is",
       "         the triangular factor obtained; the elements in block",
       "         A(OFFSET+1:M,1:N) below the diagonal, together with the",
       "         array TAU, represent the orthogonal matrix Q as a product of",
       "         elementary reflectors. Block A(1:OFFSET,1:N) has been",
       "         accordingly pivoted, but no factorized."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,M)."],
     "JPVT"=>
      ["[in,out]",
       "         JPVT is INTEGER array, dimension (N)",
       "         On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted",
       "         to the front of A*P (a leading column); if JPVT(i) = 0,",
       "         the i-th column of A is a free column.",
       "         On exit, if JPVT(i) = k, then the i-th column of A*P",
       "         was the k-th column of A."],
     "TAU"=>
      ["[out]",
       "         TAU is COMPLEX array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors."],
     "VN1"=>
      ["[in,out]",
       "         VN1 is REAL array, dimension (N)",
       "         The vector with the partial column norms."],
     "VN2"=>
      ["[in,out]",
       "         VN2 is REAL array, dimension (N)",
       "         The vector with the exact column norms."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (N)"]}},
 "cpptri"=>
  {"summary"=>
    ["CPPTRI computes the inverse of a complex Hermitian positive definite",
     "matrix A using the Cholesky factorization A = U**H*U or A = L*L**H",
     "computed by CPPTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangular factor is stored in AP;",
       "         = 'L':  Lower triangular factor is stored in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         On entry, the triangular factor U or L from the Cholesky",
       "         factorization A = U**H*U or A = L*L**H, packed columnwise as",
       "         a linear array.  The j-th column of U or L is stored in the",
       "         array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.",
       "         On exit, the upper or lower triangle of the (Hermitian)",
       "         inverse of A, overwriting the input factor U or L."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the (i,i) element of the factor U or L is",
       "               zero, and the inverse could not be computed."]}},
 "dgeqrfp"=>
  {"summary"=>
    ["DGEQRFP computes a QR factorization of a real M-by-N matrix A:",
     "A = Q * R. The diagonal entries of R are nonnegative."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the min(M,N)-by-N upper trapezoidal matrix R (R is",
       "         upper triangular if m >= n). The diagonal entries of R",
       "         are nonnegative; the elements below the diagonal,",
       "         with the array TAU, represent the orthogonal matrix Q as a",
       "         product of min(m,n) elementary reflectors (see Further",
       "         Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is DOUBLE PRECISION array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,N).",
       "         For optimum performance LWORK >= N*NB, where NB is",
       "         the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zla_gbrfsx_extended"=>
  {"summary"=>
    ["ZLA_GBRFSX_EXTENDED improves the computed solution to a system of",
     "linear equations by performing extra-precise iterative refinement",
     "and provides error bounds and backward error estimates for the solution.",
     "This subroutine is called by ZGBRFSX to perform iterative refinement.",
     "In addition to normwise error bound, the code provides maximum",
     "componentwise error bound if possible. See comments for ERR_BNDS_NORM",
     "and ERR_BNDS_COMP for details of the error bounds. Note that this",
     "subroutine is only resonsible for setting the second fields of",
     "ERR_BNDS_NORM and ERR_BNDS_COMP."],
   "param"=>
    {"PREC_TYPE"=>
      ["[in]",
       "         PREC_TYPE is INTEGER",
       "    Specifies the intermediate precision to be used in refinement.",
       "    The value is defined by ILAPREC(P) where P is a CHARACTER and",
       "    P    = 'S':  Single",
       "         = 'D':  Double",
       "         = 'I':  Indigenous",
       "         = 'X', 'E':  Extra"],
     "TRANS_TYPE"=>
      ["[in]",
       "         TRANS_TYPE is INTEGER",
       "    Specifies the transposition operation on A.",
       "    The value is defined by ILATRANS(T) where T is a CHARACTER and",
       "    T    = 'N':  No transpose",
       "         = 'T':  Transpose",
       "         = 'C':  Conjugate transpose"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "    The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "    The number of superdiagonals within the band of A.  KU >= 0"],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "    The number of right-hand-sides, i.e., the number of columns of the",
       "    matrix B."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX*16 array, dimension (LDAB,N)",
       "    On entry, the N-by-N matrix A."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "    The leading dimension of the array A.  LDAB >= max(1,N)."],
     "AFB"=>
      ["[in]",
       "         AFB is COMPLEX*16 array, dimension (LDAF,N)",
       "    The factors L and U from the factorization",
       "    A = P*L*U as computed by ZGBTRF."],
     "LDAFB"=>
      ["[in]",
       "         LDAFB is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    The pivot indices from the factorization A = P*L*U",
       "    as computed by ZGBTRF; row i of the matrix was interchanged",
       "    with row IPIV(i)."],
     "COLEQU"=>
      ["[in]",
       "         COLEQU is LOGICAL",
       "    If .TRUE. then column equilibration was done to A before calling",
       "    this routine. This is needed to compute the solution and error",
       "    bounds correctly."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "    The column scale factors for A. If COLEQU = .FALSE., C",
       "    is not accessed. If C is input, each element of C should be a power",
       "    of the radix to ensure a reliable solution and error estimates.",
       "    Scaling by powers of the radix does not cause rounding errors unless",
       "    the result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "    The right-hand-side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "    The leading dimension of the array B.  LDB >= max(1,N)."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array, dimension (LDY,NRHS)",
       "    On entry, the solution matrix X, as computed by ZGBTRS.",
       "    On exit, the improved solution matrix Y."],
     "LDY"=>
      ["[in]",
       "         LDY is INTEGER",
       "    The leading dimension of the array Y.  LDY >= max(1,N)."],
     "BERR_OUT"=>
      ["[out]",
       "         BERR_OUT is DOUBLE PRECISION array, dimension (NRHS)",
       "    On exit, BERR_OUT(j) contains the componentwise relative backward",
       "    error for right-hand-side j from the formula",
       "        max(i) ( abs(RES(i)) / ( abs(op(A_s))*abs(Y) + abs(B_s) )(i) )",
       "    where abs(Z) is the componentwise absolute value of the matrix",
       "    or vector Z. This is computed by ZLA_LIN_BERR."],
     "N_NORMS"=>
      ["[in]",
       "         N_NORMS is INTEGER",
       "    Determines which error bounds to return (see ERR_BNDS_NORM",
       "    and ERR_BNDS_COMP).",
       "    If N_NORMS >= 1 return normwise error bounds.",
       "    If N_NORMS >= 2 return componentwise error bounds."],
     "ERR_BNDS_NORM"=>
      ["[in,out]",
       "         ERR_BNDS_NORM is DOUBLE PRECISION array, dimension",
       "                   (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    normwise relative error, which is defined as follows:",
       "    Normwise relative error in the ith solution vector:",
       "            max_j (abs(XTRUE(j,i) - X(j,i)))",
       "           ------------------------------",
       "                 max_j abs(X(j,i))",
       "    The array is indexed by the type of error information as described",
       "    below. There currently are up to three pieces of information",
       "    returned.",
       "    The first index in ERR_BNDS_NORM(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_NORM(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated normwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*A, where S scales each row by a power of the",
       "             radix so all absolute row sums of Z are approximately 1.",
       "    This subroutine is only responsible for setting the second field",
       "    above.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "ERR_BNDS_COMP"=>
      ["[in,out]",
       "         ERR_BNDS_COMP is DOUBLE PRECISION array, dimension",
       "                   (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    componentwise relative error, which is defined as follows:",
       "    Componentwise relative error in the ith solution vector:",
       "                   abs(XTRUE(j,i) - X(j,i))",
       "            max_j ----------------------",
       "                        abs(X(j,i))",
       "    The array is indexed by the right-hand side i (on which the",
       "    componentwise relative error depends), and the type of error",
       "    information as described below. There currently are up to three",
       "    pieces of information returned for each right-hand side. If",
       "    componentwise accuracy is not requested (PARAMS(3) = 0.0), then",
       "    ERR_BNDS_COMP is not accessed.  If N_ERR_BNDS .LT. 3, then at most",
       "    the first (:,N_ERR_BNDS) entries are returned.",
       "    The first index in ERR_BNDS_COMP(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_COMP(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated componentwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*(A*diag(x)), where x is the solution for the",
       "             current right-hand side and S scales each row of",
       "             A*diag(x) by a power of the radix so all absolute row",
       "             sums of Z are approximately 1.",
       "    This subroutine is only responsible for setting the second field",
       "    above.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "RES"=>
      ["[in]",
       "         RES is COMPLEX*16 array, dimension (N)",
       "    Workspace to hold the intermediate residual."],
     "AYB"=>
      ["[in]",
       "         AYB is DOUBLE PRECISION array, dimension (N)",
       "    Workspace."],
     "DY"=>
      ["[in]",
       "         DY is COMPLEX*16 array, dimension (N)",
       "    Workspace to hold the intermediate solution."],
     "Y_TAIL"=>
      ["[in]",
       "         Y_TAIL is COMPLEX*16 array, dimension (N)",
       "    Workspace to hold the trailing bits of the intermediate solution."],
     "RCOND"=>
      ["[in]",
       "         RCOND is DOUBLE PRECISION",
       "    Reciprocal scaled condition number.  This is an estimate of the",
       "    reciprocal Skeel condition number of the matrix A after",
       "    equilibration (if done).  If this is less than the machine",
       "    precision (in particular, if it is zero), the matrix is singular",
       "    to working precision.  Note that the error may still be small even",
       "    if this number is very small and the matrix appears ill-",
       "    conditioned."],
     "ITHRESH"=>
      ["[in]",
       "         ITHRESH is INTEGER",
       "    The maximum number of residual computations allowed for",
       "    refinement. The default is 10. For 'aggressive' set to 100 to",
       "    permit convergence using approximate factorizations or",
       "    factorizations other than LU. If the factorization uses a",
       "    technique other than Gaussian elimination, the guarantees in",
       "    ERR_BNDS_NORM and ERR_BNDS_COMP may no longer be trustworthy."],
     "RTHRESH"=>
      ["[in]",
       "         RTHRESH is DOUBLE PRECISION",
       "    Determines when to stop refinement if the error estimate stops",
       "    decreasing. Refinement will stop when the next solution no longer",
       "    satisfies norm(dx_{i+1}) < RTHRESH * norm(dx_i) where norm(Z) is",
       "    the infinity norm of Z. RTHRESH satisfies 0 < RTHRESH <= 1. The",
       "    default value is 0.5. For 'aggressive' set to 0.9 to permit",
       "    convergence on extremely ill-conditioned matrices. See LAWN 165",
       "    for more details."],
     "DZ_UB"=>
      ["[in]",
       "         DZ_UB is DOUBLE PRECISION",
       "    Determines when to start considering componentwise convergence.",
       "    Componentwise convergence is only considered after each component",
       "    of the solution Y is stable, which we definte as the relative",
       "    change in each component being less than DZ_UB. The default value",
       "    is 0.25, requiring the first bit to be stable. See LAWN 165 for",
       "    more details."],
     "IGNORE_CWISE"=>
      ["[in]",
       "         IGNORE_CWISE is LOGICAL",
       "    If .TRUE. then ignore componentwise convergence. Default value",
       "    is .FALSE.."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "      < 0:  if INFO = -i, the ith argument to ZGBTRS had an illegal",
       "            value"]}},
 "dtrsyl"=>
  {"summary"=>
    ["DTRSYL solves the real Sylvester matrix equation:",
     "   op(A)*X + X*op(B) = scale*C or",
     "   op(A)*X - X*op(B) = scale*C,",
     "where op(A) = A or A**T, and  A and B are both upper quasi-",
     "triangular. A is M-by-M and B is N-by-N; the right hand side C and",
     "the solution X are M-by-N; and scale is an output scale factor, set",
     "<= 1 to avoid overflow in X.",
     "A and B must be in Schur canonical form (as returned by DHSEQR), that",
     "is, block upper triangular with 1-by-1 and 2-by-2 diagonal blocks;",
     "each 2-by-2 diagonal block has its diagonal elements equal and its",
     "off-diagonal elements of opposite sign."],
   "param"=>
    {"TRANA"=>
      ["[in]",
       "         TRANA is CHARACTER*1",
       "         Specifies the option op(A):",
       "         = 'N': op(A) = A    (No transpose)",
       "         = 'T': op(A) = A**T (Transpose)",
       "         = 'C': op(A) = A**H (Conjugate transpose = Transpose)"],
     "TRANB"=>
      ["[in]",
       "         TRANB is CHARACTER*1",
       "         Specifies the option op(B):",
       "         = 'N': op(B) = B    (No transpose)",
       "         = 'T': op(B) = B**T (Transpose)",
       "         = 'C': op(B) = B**H (Conjugate transpose = Transpose)"],
     "ISGN"=>
      ["[in]",
       "         ISGN is INTEGER",
       "         Specifies the sign in the equation:",
       "         = +1: solve op(A)*X + X*op(B) = scale*C",
       "         = -1: solve op(A)*X - X*op(B) = scale*C"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The order of the matrix A, and the number of rows in the",
       "         matrices X and C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix B, and the number of columns in the",
       "         matrices X and C. N >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,M)",
       "         The upper quasi-triangular matrix A, in Schur canonical form."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,M)."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array, dimension (LDB,N)",
       "         The upper quasi-triangular matrix B, in Schur canonical form."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >= max(1,N)."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array, dimension (LDC,N)",
       "         On entry, the M-by-N right hand side matrix C.",
       "         On exit, C is overwritten by the solution matrix X."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)"],
     "SCALE"=>
      ["[out]",
       "         SCALE is DOUBLE PRECISION",
       "         The scale factor, scale, set <= 1 to avoid overflow in X."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         = 1: A and B have common or very close eigenvalues; perturbed",
       "              values were used to solve the equation (but the matrices",
       "              A and B are unchanged)."]}},
 "stpqrt2"=>
  {"summary"=>
    ["STPQRT2 computes a QR factorization of a real \"triangular-pentagonal\"",
     "matrix C, which is composed of a triangular block A and pentagonal block B,",
     "using the compact WY representation for Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The total number of rows of the matrix B.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B, and the order of",
       "         the triangular matrix A.",
       "         N >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of rows of the upper trapezoidal part of B.",
       "         MIN(M,N) >= L >= 0.  See Further Details."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the upper triangular N-by-N matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the upper triangular matrix R."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,N)",
       "         On entry, the pentagonal M-by-N matrix B.  The first M-L rows",
       "         are rectangular, and the last L rows are upper trapezoidal.",
       "         On exit, B contains the pentagonal matrix V.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is REAL array, dimension (LDT,N)",
       "         The N-by-N upper triangular factor T of the block reflector.",
       "         See Further Details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= max(1,N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "cgges"=>
  {"summary"=>
    ["CGGES computes for a pair of N-by-N complex nonsymmetric matrices",
     "(A,B), the generalized eigenvalues, the generalized complex Schur",
     "form (S, T), and optionally left and/or right Schur vectors (VSL",
     "and VSR). This gives the generalized Schur factorization",
     "        (A,B) = ( (VSL)*S*(VSR)**H, (VSL)*T*(VSR)**H )",
     "where (VSR)**H is the conjugate-transpose of VSR.",
     "Optionally, it also orders the eigenvalues so that a selected cluster",
     "of eigenvalues appears in the leading diagonal blocks of the upper",
     "triangular matrix S and the upper triangular matrix T. The leading",
     "columns of VSL and VSR then form an unitary basis for the",
     "corresponding left and right eigenspaces (deflating subspaces).",
     "(If only the generalized eigenvalues are needed, use the driver",
     "CGGEV instead, which is faster.)",
     "A generalized eigenvalue for a pair of matrices (A,B) is a scalar w",
     "or a ratio alpha/beta = w, such that  A - w*B is singular.  It is",
     "usually represented as the pair (alpha,beta), as there is a",
     "reasonable interpretation for beta=0, and even for both being zero.",
     "A pair of matrices (S,T) is in generalized complex Schur form if S",
     "and T are upper triangular and, in addition, the diagonal elements",
     "of T are non-negative real numbers."],
   "param"=>
    {"JOBVSL"=>
      ["[in]",
       "         JOBVSL is CHARACTER*1",
       "         = 'N':  do not compute the left Schur vectors;",
       "         = 'V':  compute the left Schur vectors."],
     "JOBVSR"=>
      ["[in]",
       "         JOBVSR is CHARACTER*1",
       "         = 'N':  do not compute the right Schur vectors;",
       "         = 'V':  compute the right Schur vectors."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the generalized Schur form.",
       "         = 'N':  Eigenvalues are not ordered;",
       "         = 'S':  Eigenvalues are ordered (see SELCTG)."],
     "SELCTG"=>
      ["[in]",
       "         SELCTG is a LOGICAL FUNCTION of two COMPLEX arguments",
       "         SELCTG must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'N', SELCTG is not referenced.",
       "         If SORT = 'S', SELCTG is used to select eigenvalues to sort",
       "         to the top left of the Schur form.",
       "         An eigenvalue ALPHA(j)/BETA(j) is selected if",
       "         SELCTG(ALPHA(j),BETA(j)) is true.",
       "         Note that a selected complex eigenvalue may no longer satisfy",
       "         SELCTG(ALPHA(j),BETA(j)) = .TRUE. after ordering, since",
       "         ordering may change the value of complex eigenvalues",
       "         (especially if the eigenvalue is ill-conditioned), in this",
       "         case INFO is set to N+2 (See INFO below)."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A, B, VSL, and VSR.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the first of the pair of matrices.",
       "         On exit, A has been overwritten by its generalized Schur",
       "         form S."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB, N)",
       "         On entry, the second of the pair of matrices.",
       "         On exit, B has been overwritten by its generalized Schur",
       "         form T."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of B.  LDB >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues (after sorting)",
       "         for which SELCTG is true."],
     "ALPHA"=>["[out]", "         ALPHA is COMPLEX array, dimension (N)"],
     "BETA"=>
      ["[out]",
       "         BETA is COMPLEX array, dimension (N)",
       "         On exit,  ALPHA(j)/BETA(j), j=1,...,N, will be the",
       "         generalized eigenvalues.  ALPHA(j), j=1,...,N  and  BETA(j),",
       "         j=1,...,N  are the diagonals of the complex Schur form (A,B)",
       "         output by CGGES. The  BETA(j) will be non-negative real.",
       "         Note: the quotients ALPHA(j)/BETA(j) may easily over- or",
       "         underflow, and BETA(j) may even be zero.  Thus, the user",
       "         should avoid naively computing the ratio alpha/beta.",
       "         However, ALPHA will be always less than and usually",
       "         comparable with norm(A) in magnitude, and BETA always less",
       "         than and usually comparable with norm(B)."],
     "VSL"=>
      ["[out]",
       "         VSL is COMPLEX array, dimension (LDVSL,N)",
       "         If JOBVSL = 'V', VSL will contain the left Schur vectors.",
       "         Not referenced if JOBVSL = 'N'."],
     "LDVSL"=>
      ["[in]",
       "         LDVSL is INTEGER",
       "         The leading dimension of the matrix VSL. LDVSL >= 1, and",
       "         if JOBVSL = 'V', LDVSL >= N."],
     "VSR"=>
      ["[out]",
       "         VSR is COMPLEX array, dimension (LDVSR,N)",
       "         If JOBVSR = 'V', VSR will contain the right Schur vectors.",
       "         Not referenced if JOBVSR = 'N'."],
     "LDVSR"=>
      ["[in]",
       "         LDVSR is INTEGER",
       "         The leading dimension of the matrix VSR. LDVSR >= 1, and",
       "         if JOBVSR = 'V', LDVSR >= N."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,2*N).",
       "         For good performance, LWORK must generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (8*N)"],
     "BWORK"=>
      ["[out]",
       "         BWORK is LOGICAL array, dimension (N)",
       "         Not referenced if SORT = 'N'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         =1,...,N:",
       "               The QZ iteration failed.  (A,B) are not in Schur",
       "               form, but ALPHA(j) and BETA(j) should be correct for",
       "               j=INFO+1,...,N.",
       "         > N:  =N+1: other than QZ iteration failed in CHGEQZ",
       "               =N+2: after reordering, roundoff changed values of",
       "                     some complex eigenvalues so that leading",
       "                     eigenvalues in the Generalized Schur form no",
       "                     longer satisfy SELCTG=.TRUE.  This could also",
       "                     be caused due to scaling.",
       "               =N+3: reordering failed in CTGSEN."]}},
 "zpttrf"=>
  {"summary"=>
    ["ZPTTRF computes the L*D*L**H factorization of a complex Hermitian",
     "positive definite tridiagonal matrix A.  The factorization may also",
     "be regarded as having the form A = U**H *D*U."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         On entry, the n diagonal elements of the tridiagonal matrix",
       "         A.  On exit, the n diagonal elements of the diagonal matrix",
       "         D from the L*D*L**H factorization of A."],
     "E"=>
      ["[in,out]",
       "         E is COMPLEX*16 array, dimension (N-1)",
       "         On entry, the (n-1) subdiagonal elements of the tridiagonal",
       "         matrix A.  On exit, the (n-1) subdiagonal elements of the",
       "         unit bidiagonal factor L from the L*D*L**H factorization of A.",
       "         E can also be regarded as the superdiagonal of the unit",
       "         bidiagonal factor U from the U**H *D*U factorization of A."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value",
       "         > 0: if INFO = k, the leading minor of order k is not",
       "              positive definite; if k < N, the factorization could not",
       "              be completed, while if k = N, the factorization was",
       "              completed, but D(N) <= 0."]}},
 "sgeqrt2"=>
  {"summary"=>
    ["SGEQRT2 computes a QR factorization of a real M-by-N matrix A,",
     "using the compact WY representation of Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= N."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the real M-by-N matrix A.  On exit, the elements on and",
       "         above the diagonal contain the N-by-N upper triangular matrix R; the",
       "         elements below the diagonal are the columns of V.  See below for",
       "         further details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is REAL array, dimension (LDT,N)",
       "         The N-by-N upper triangular factor of the block reflector.",
       "         The elements on and above the diagonal contain the block",
       "         reflector T; the elements below the diagonal are not used.",
       "         See below for further details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "sgges3"=>
  {"summary"=>
    ["SGGES3 computes for a pair of N-by-N real nonsymmetric matrices (A,B),",
     "the generalized eigenvalues, the generalized real Schur form (S,T),",
     "optionally, the left and/or right matrices of Schur vectors (VSL and",
     "VSR). This gives the generalized Schur factorization",
     "         (A,B) = ( (VSL)*S*(VSR)**T, (VSL)*T*(VSR)**T )",
     "Optionally, it also orders the eigenvalues so that a selected cluster",
     "of eigenvalues appears in the leading diagonal blocks of the upper",
     "quasi-triangular matrix S and the upper triangular matrix T.The",
     "leading columns of VSL and VSR then form an orthonormal basis for the",
     "corresponding left and right eigenspaces (deflating subspaces).",
     "(If only the generalized eigenvalues are needed, use the driver",
     "SGGEV instead, which is faster.)",
     "A generalized eigenvalue for a pair of matrices (A,B) is a scalar w",
     "or a ratio alpha/beta = w, such that  A - w*B is singular.  It is",
     "usually represented as the pair (alpha,beta), as there is a",
     "reasonable interpretation for beta=0 or both being zero.",
     "A pair of matrices (S,T) is in generalized real Schur form if T is",
     "upper triangular with non-negative diagonal and S is block upper",
     "triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond",
     "to real generalized eigenvalues, while 2-by-2 blocks of S will be",
     "\"standardized\" by making the corresponding elements of T have the",
     "form:",
     "        [  a  0  ]",
     "        [  0  b  ]",
     "and the pair of corresponding 2-by-2 blocks in S and T will have a",
     "complex conjugate pair of generalized eigenvalues."],
   "param"=>
    {"JOBVSL"=>
      ["[in]",
       "         JOBVSL is CHARACTER*1",
       "         = 'N':  do not compute the left Schur vectors;",
       "         = 'V':  compute the left Schur vectors."],
     "JOBVSR"=>
      ["[in]",
       "         JOBVSR is CHARACTER*1",
       "         = 'N':  do not compute the right Schur vectors;",
       "         = 'V':  compute the right Schur vectors."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the generalized Schur form.",
       "         = 'N':  Eigenvalues are not ordered;",
       "         = 'S':  Eigenvalues are ordered (see SELCTG);"],
     "SELCTG"=>
      ["[in]",
       "         SELCTG is a LOGICAL FUNCTION of three REAL arguments",
       "         SELCTG must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'N', SELCTG is not referenced.",
       "         If SORT = 'S', SELCTG is used to select eigenvalues to sort",
       "         to the top left of the Schur form.",
       "         An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if",
       "         SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either",
       "         one of a complex conjugate pair of eigenvalues is selected,",
       "         then both complex eigenvalues are selected.",
       "         Note that in the ill-conditioned case, a selected complex",
       "         eigenvalue may no longer satisfy SELCTG(ALPHAR(j),ALPHAI(j),",
       "         BETA(j)) = .TRUE. after ordering. INFO is to be set to N+2",
       "         in this case."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A, B, VSL, and VSR.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA, N)",
       "         On entry, the first of the pair of matrices.",
       "         On exit, A has been overwritten by its generalized Schur",
       "         form S."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB, N)",
       "         On entry, the second of the pair of matrices.",
       "         On exit, B has been overwritten by its generalized Schur",
       "         form T."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of B.  LDB >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues (after sorting)",
       "         for which SELCTG is true.  (Complex conjugate pairs for which",
       "         SELCTG is true for either eigenvalue count as 2.)"],
     "ALPHAR"=>["[out]", "         ALPHAR is REAL array, dimension (N)"],
     "ALPHAI"=>["[out]", "         ALPHAI is REAL array, dimension (N)"],
     "BETA"=>
      ["[out]",
       "         BETA is REAL array, dimension (N)",
       "         On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will",
       "         be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,",
       "         and  BETA(j),j=1,...,N are the diagonals of the complex Schur",
       "         form (S,T) that would result if the 2-by-2 diagonal blocks of",
       "         the real Schur form of (A,B) were further reduced to",
       "         triangular form using 2-by-2 complex unitary transformations.",
       "         If ALPHAI(j) is zero, then the j-th eigenvalue is real; if",
       "         positive, then the j-th and (j+1)-st eigenvalues are a",
       "         complex conjugate pair, with ALPHAI(j+1) negative.",
       "         Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)",
       "         may easily over- or underflow, and BETA(j) may even be zero.",
       "         Thus, the user should avoid naively computing the ratio.",
       "         However, ALPHAR and ALPHAI will be always less than and",
       "         usually comparable with norm(A) in magnitude, and BETA always",
       "         less than and usually comparable with norm(B)."],
     "VSL"=>
      ["[out]",
       "         VSL is REAL array, dimension (LDVSL,N)",
       "         If JOBVSL = 'V', VSL will contain the left Schur vectors.",
       "         Not referenced if JOBVSL = 'N'."],
     "LDVSL"=>
      ["[in]",
       "         LDVSL is INTEGER",
       "         The leading dimension of the matrix VSL. LDVSL >=1, and",
       "         if JOBVSL = 'V', LDVSL >= N."],
     "VSR"=>
      ["[out]",
       "         VSR is REAL array, dimension (LDVSR,N)",
       "         If JOBVSR = 'V', VSR will contain the right Schur vectors.",
       "         Not referenced if JOBVSR = 'N'."],
     "LDVSR"=>
      ["[in]",
       "         LDVSR is INTEGER",
       "         The leading dimension of the matrix VSR. LDVSR >= 1, and",
       "         if JOBVSR = 'V', LDVSR >= N."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "BWORK"=>
      ["[out]",
       "         BWORK is LOGICAL array, dimension (N)",
       "         Not referenced if SORT = 'N'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         = 1,...,N:",
       "               The QZ iteration failed.  (A,B) are not in Schur",
       "               form, but ALPHAR(j), ALPHAI(j), and BETA(j) should",
       "               be correct for j=INFO+1,...,N.",
       "         > N:  =N+1: other than QZ iteration failed in SHGEQZ.",
       "               =N+2: after reordering, roundoff changed values of",
       "                     some complex eigenvalues so that leading",
       "                     eigenvalues in the Generalized Schur form no",
       "                     longer satisfy SELCTG=.TRUE.  This could also",
       "                     be caused due to scaling.",
       "               =N+3: reordering failed in STGSEN."]}},
 "spotf2"=>
  {"summary"=>
    ["SPOTF2 computes the Cholesky factorization of a real symmetric",
     "positive definite matrix A.",
     "The factorization has the form",
     "   A = U**T * U ,  if UPLO = 'U', or",
     "   A = L  * L**T,  if UPLO = 'L',",
     "where U is an upper triangular matrix and L is lower triangular.",
     "This is the unblocked version of the algorithm, calling Level 2 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         n by n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n by n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if INFO = 0, the factor U or L from the Cholesky",
       "         factorization A = U**T *U  or A = L*L**T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value",
       "         > 0: if INFO = k, the leading minor of order k is not",
       "              positive definite, and the factorization could not be",
       "              completed."]}},
 "dsytri"=>
  {"summary"=>
    ["DSYTRI computes the inverse of a real symmetric indefinite matrix",
     "A using the factorization A = U*D*U**T or A = L*D*L**T computed by",
     "DSYTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the block diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by DSYTRF.",
       "         On exit, if INFO = 0, the (symmetric) inverse of the original",
       "         matrix.  If UPLO = 'U', the upper triangular part of the",
       "         inverse is formed and the part of A below the diagonal is not",
       "         referenced; if UPLO = 'L' the lower triangular part of the",
       "         inverse is formed and the part of A above the diagonal is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by DSYTRF."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "sorml2"=>
  {"summary"=>
    ["SORML2 overwrites the general real m by n matrix C with",
     "      Q * C  if SIDE = 'L' and TRANS = 'N', or",
     "      Q**T* C  if SIDE = 'L' and TRANS = 'T', or",
     "      C * Q  if SIDE = 'R' and TRANS = 'N', or",
     "      C * Q**T if SIDE = 'R' and TRANS = 'T',",
     "where Q is a real orthogonal matrix defined as the product of k",
     "elementary reflectors",
     "      Q = H(k) . . . H(2) H(1)",
     "as returned by SGELQF. Q is of order m if SIDE = 'L' and of order n",
     "if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**T from the Left",
       "         = 'R': apply Q or Q**T from the Right"],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N': apply Q  (No transpose)",
       "         = 'T': apply Q**T (Transpose)"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension",
       "                              (LDA,M) if SIDE = 'L',",
       "                              (LDA,N) if SIDE = 'R'",
       "         The i-th row must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         SGELQF in the first k rows of its array argument A.",
       "         A is modified by the routine but restored on exit."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,K)."],
     "TAU"=>
      ["[in]",
       "         TAU is REAL array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by SGELQF."],
     "C"=>
      ["[in,out]",
       "         C is REAL array, dimension (LDC,N)",
       "         On entry, the m by n matrix C.",
       "         On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension",
       "                                  (N) if SIDE = 'L',",
       "                                  (M) if SIDE = 'R'"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "dposv"=>
  {"summary"=>
    ["DPOSV computes the solution to a real system of linear equations",
     "   A * X = B,",
     "where A is an N-by-N symmetric positive definite matrix and X and B",
     "are N-by-NRHS matrices.",
     "The Cholesky decomposition is used to factor A as",
     "   A = U**T* U,  if UPLO = 'U', or",
     "   A = L * L**T,  if UPLO = 'L',",
     "where U is an upper triangular matrix and L is a lower triangular",
     "matrix.  The factored form of A is then used to solve the system of",
     "equations A * X = B."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of linear equations, i.e., the order of the",
       "         matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if INFO = 0, the factor U or L from the Cholesky",
       "         factorization A = U**T*U or A = L*L**T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the leading minor of order i of A is not",
       "               positive definite, so the factorization could not be",
       "               completed, and the solution has not been computed."]}},
 "sgebrd"=>
  {"summary"=>
    ["SGEBRD reduces a general real M-by-N matrix A to upper or lower",
     "bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.",
     "If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows in the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns in the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the M-by-N general matrix to be reduced.",
       "         On exit,",
       "         if m >= n, the diagonal and the first superdiagonal are",
       "           overwritten with the upper bidiagonal matrix B; the",
       "           elements below the diagonal, with the array TAUQ, represent",
       "           the orthogonal matrix Q as a product of elementary",
       "           reflectors, and the elements above the first superdiagonal,",
       "           with the array TAUP, represent the orthogonal matrix P as",
       "           a product of elementary reflectors;",
       "         if m < n, the diagonal and the first subdiagonal are",
       "           overwritten with the lower bidiagonal matrix B; the",
       "           elements below the first subdiagonal, with the array TAUQ,",
       "           represent the orthogonal matrix Q as a product of",
       "           elementary reflectors, and the elements above the diagonal,",
       "           with the array TAUP, represent the orthogonal matrix P as",
       "           a product of elementary reflectors.",
       "         See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "D"=>
      ["[out]",
       "         D is REAL array, dimension (min(M,N))",
       "         The diagonal elements of the bidiagonal matrix B:",
       "         D(i) = A(i,i)."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (min(M,N)-1)",
       "         The off-diagonal elements of the bidiagonal matrix B:",
       "         if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;",
       "         if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1."],
     "TAUQ"=>
      ["[out]",
       "         TAUQ is REAL array dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors which",
       "         represent the orthogonal matrix Q. See Further Details."],
     "TAUP"=>
      ["[out]",
       "         TAUP is REAL array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors which",
       "         represent the orthogonal matrix P. See Further Details."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.  LWORK >= max(1,M,N).",
       "         For optimum performance LWORK >= (M+N)*NB, where NB",
       "         is the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "dsytrf"=>
  {"summary"=>
    ["DSYTRF computes the factorization of a real symmetric matrix A using",
     "the Bunch-Kaufman diagonal pivoting method.  The form of the",
     "factorization is",
     "   A = U*D*U**T  or  A = L*D*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and D is symmetric and block diagonal with",
     "1-by-1 and 2-by-2 diagonal blocks.",
     "This is the blocked version of the algorithm, calling Level 3 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L (see below for further details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "         interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "         If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0, then rows and",
       "         columns k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "         is a 2-by-2 diagonal block.  If UPLO = 'L' and IPIV(k) =",
       "         IPIV(k+1) < 0, then rows and columns k+1 and -IPIV(k) were",
       "         interchanged and D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >=1.  For best performance",
       "         LWORK >= N*NB, where NB is the block size returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, and division by zero will occur if it",
       "               is used to solve a system of equations."]}},
 "slarrr"=>
  {"summary"=>
    ["Perform tests to decide whether the symmetric tridiagonal matrix T",
     "warrants expensive computations which guarantee high relative accuracy",
     "in the eigenvalues."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix. N > 0."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension (N)",
       "         The N diagonal elements of the tridiagonal matrix T."],
     "E"=>
      ["[in,out]",
       "         E is REAL array, dimension (N)",
       "         On entry, the first (N-1) entries contain the subdiagonal",
       "         elements of the tridiagonal matrix T; E(N) is set to ZERO."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         INFO = 0(default) : the matrix warrants computations preserving",
       "                             relative accuracy.",
       "         INFO = 1          : the matrix warrants computations guaranteeing",
       "                             only absolute accuracy."]}},
 "zgebal"=>
  {"summary"=>
    ["ZGEBAL balances a general complex matrix A.  This involves, first,",
     "permuting A by a similarity transformation to isolate eigenvalues",
     "in the first 1 to ILO-1 and last IHI+1 to N elements on the",
     "diagonal; and second, applying a diagonal similarity transformation",
     "to rows and columns ILO to IHI to make the rows and columns as",
     "close in norm as possible.  Both steps are optional.",
     "Balancing may reduce the 1-norm of the matrix, and improve the",
     "accuracy of the computed eigenvalues and/or eigenvectors."],
   "param"=>
    {"JOB"=>
      ["[in]",
       "         JOB is CHARACTER*1",
       "         Specifies the operations to be performed on A:",
       "         = 'N':  none:  simply set ILO = 1, IHI = N, SCALE(I) = 1.0",
       "                 for i = 1,...,N;",
       "         = 'P':  permute only;",
       "         = 'S':  scale only;",
       "         = 'B':  both permute and scale."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the input matrix A.",
       "         On exit,  A is overwritten by the balanced matrix.",
       "         If JOB = 'N', A is not referenced.",
       "         See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "ILO"=>["[out]"],
     "IHI"=>
      ["[out]",
       "         ILO and IHI are set to INTEGER such that on exit",
       "         A(i,j) = 0 if i > j and j = 1,...,ILO-1 or I = IHI+1,...,N.",
       "         If JOB = 'N' or 'S', ILO = 1 and IHI = N."],
     "SCALE"=>
      ["[out]",
       "         SCALE is DOUBLE PRECISION array, dimension (N)",
       "         Details of the permutations and scaling factors applied to",
       "         A.  If P(j) is the index of the row and column interchanged",
       "         with row and column j and D(j) is the scaling factor",
       "         applied to row and column j, then",
       "         SCALE(j) = P(j)    for j = 1,...,ILO-1",
       "                  = D(j)    for j = ILO,...,IHI",
       "                  = P(j)    for j = IHI+1,...,N.",
       "         The order in which the interchanges are made is N to IHI+1,",
       "         then 1 to ILO-1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "chpgst"=>
  {"summary"=>
    ["CHPGST reduces a complex Hermitian-definite generalized",
     "eigenproblem to standard form, using packed storage.",
     "If ITYPE = 1, the problem is A*x = lambda*B*x,",
     "and A is overwritten by inv(U**H)*A*inv(U) or inv(L)*A*inv(L**H)",
     "If ITYPE = 2 or 3, the problem is A*B*x = lambda*x or",
     "B*A*x = lambda*x, and A is overwritten by U*A*U**H or L**H*A*L.",
     "B must have been previously factorized as U**H*U or L*L**H by CPPTRF."],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         = 1: compute inv(U**H)*A*inv(U) or inv(L)*A*inv(L**H);",
       "         = 2 or 3: compute U*A*U**H or L**H*A*L."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored and B is factored as",
       "                 U**H*U;",
       "         = 'L':  Lower triangle of A is stored and B is factored as",
       "                 L*L**H."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the Hermitian matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, if INFO = 0, the transformed matrix, stored in the",
       "         same format as A."],
     "BP"=>
      ["[in]",
       "         BP is COMPLEX array, dimension (N*(N+1)/2)",
       "         The triangular factor from the Cholesky factorization of B,",
       "         stored in the same format as A, as returned by CPPTRF."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dlahr2"=>
  {"summary"=>
    ["DLAHR2 reduces the first NB columns of A real general n-BY-(n-k+1)",
     "matrix A so that elements below the k-th subdiagonal are zero. The",
     "reduction is performed by an orthogonal similarity transformation",
     "Q**T * A * Q. The routine returns the matrices V and T which determine",
     "Q as a block reflector I - V*T*V**T, and also the matrix Y = A * V * T.",
     "This is an auxiliary routine called by DGEHRD."],
   "param"=>
    {"N"=>
      ["[in]", "         N is INTEGER", "         The order of the matrix A."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The offset for the reduction. Elements below the k-th",
       "         subdiagonal in the first NB columns are reduced to zero.",
       "         K < N."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The number of columns to be reduced."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N-K+1)",
       "         On entry, the n-by-(n-k+1) general matrix A.",
       "         On exit, the elements on and above the k-th subdiagonal in",
       "         the first NB columns are overwritten with the corresponding",
       "         elements of the reduced matrix; the elements below the k-th",
       "         subdiagonal, with the array TAU, represent the matrix Q as a",
       "         product of elementary reflectors. The other columns of A are",
       "         unchanged. See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "TAU"=>
      ["[out]",
       "         TAU is DOUBLE PRECISION array, dimension (NB)",
       "         The scalar factors of the elementary reflectors. See Further",
       "         Details."],
     "T"=>
      ["[out]",
       "         T is DOUBLE PRECISION array, dimension (LDT,NB)",
       "         The upper triangular matrix T."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= NB."],
     "Y"=>
      ["[out]",
       "         Y is DOUBLE PRECISION array, dimension (LDY,NB)",
       "         The n-by-nb matrix Y."],
     "LDY"=>
      ["[in]",
       "         LDY is INTEGER",
       "         The leading dimension of the array Y. LDY >= N."]}},
 "zlasyf_aa"=>
  {"summary"=>
    ["DLATRF_AA factorizes a panel of a complex symmetric matrix A using",
     "the Aasen's algorithm. The panel consists of a set of NB rows of A",
     "when UPLO is U, or a set of NB columns when UPLO is L.",
     "In order to factorize the panel, the Aasen's algorithm requires the",
     "last row, or column, of the previous panel. The first row, or column,",
     "of A is set to be the first row, or column, of an identity matrix,",
     "which is used to factorize the first panel.",
     "The resulting J-th row of U, or J-th column of L, is stored in the",
     "(J-1)-th row, or column, of A (without the unit diagonals), while",
     "the diagonal and subdiagonal of A are overwritten by those of T."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "J1"=>
      ["[in]",
       "         J1 is INTEGER",
       "         The location of the first row, or column, of the panel",
       "         within the submatrix of A, passed to this routine, e.g.,",
       "         when called by ZSYTRF_AA, for the first panel, J1 is 1,",
       "         while for the remaining panels, J1 is 2."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The dimension of the submatrix. M >= 0."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The dimension of the panel to be facotorized."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,M) for",
       "         the first panel, while dimension (LDA,M+1) for the",
       "         remaining panels.",
       "         On entry, A contains the last row, or column, of",
       "         the previous panel, and the trailing submatrix of A",
       "         to be factorized, except for the first panel, only",
       "         the panel is passed.",
       "         On exit, the leading panel is factorized."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the row and column interchanges,",
       "         the row and column k were interchanged with the row and",
       "         column IPIV(k)."],
     "H"=>
      ["[in,out]", "         H is COMPLEX*16 workspace, dimension (LDH,NB)."],
     "LDH"=>
      ["[in]",
       "         LDH is INTEGER",
       "         The leading dimension of the workspace H. LDH >= max(1,M)."],
     "WORK"=>
      ["[out]", "         WORK is COMPLEX*16 workspace, dimension (M)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, and division by zero will occur if it",
       "               is used to solve a system of equations."]}},
 "zlasyf_rk"=>
  {"summary"=>
    ["ZLASYF_RK computes a partial factorization of a complex symmetric",
     "matrix A using the bounded Bunch-Kaufman (rook) diagonal",
     "pivoting method. The partial factorization has the form:",
     "A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:",
     "      ( 0  U22 ) (  0   D  ) ( U12**T U22**T )",
     "A  =  ( L11  0 ) (  D   0  ) ( L11**T L21**T )  if UPLO = 'L',",
     "      ( L21  I ) (  0  A22 ) (  0       I    )",
     "where the order of D is at most NB. The actual order is returned in",
     "the argument KB, and is either NB or NB-1, or N if N <= NB.",
     "ZLASYF_RK is an auxiliary routine called by ZSYTRF_RK. It uses",
     "blocked code (calling Level 3 BLAS) to update the submatrix",
     "A11 (if UPLO = 'U') or A22 (if UPLO = 'L')."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The maximum number of columns of the matrix A that should be",
       "         factored.  NB should be at least 2 to allow for 2-by-2 pivot",
       "         blocks."],
     "KB"=>
      ["[out]",
       "         KB is INTEGER",
       "         The number of columns of A that were actually factored.",
       "         KB is either NB-1 or NB, or N if N <= NB."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.",
       "           If UPLO = 'U': the leading N-by-N upper triangular part",
       "           of A contains the upper triangular part of the matrix A,",
       "           and the strictly lower triangular part of A is not",
       "           referenced.",
       "           If UPLO = 'L': the leading N-by-N lower triangular part",
       "           of A contains the lower triangular part of the matrix A,",
       "           and the strictly upper triangular part of A is not",
       "           referenced.",
       "         On exit, contains:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               are stored on exit in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[out]",
       "         E is COMPLEX*16 array, dimension (N)",
       "         On exit, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i), i=2:N, E(1) is set to 0;",
       "         If UPLO = 'L': E(i) = D(i+1,i), i=1:N-1, E(N) is set to 0.",
       "         NOTE: For 1-by-1 diagonal block D(k), where",
       "         1 <= k <= N, the element E(k) is set to 0 in both",
       "         UPLO = 'U' or UPLO = 'L' cases."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         IPIV describes the permutation matrix P in the factorization",
       "         of matrix A as follows. The absolute value of IPIV(k)",
       "         represents the index of row and column that were",
       "         interchanged with the k-th row and column. The value of UPLO",
       "         describes the order in which the interchanges were applied.",
       "         Also, the sign of IPIV represents the block structure of",
       "         the symmetric block diagonal matrix D with 1-by-1 or 2-by-2",
       "         diagonal blocks which correspond to 1 or 2 interchanges",
       "         at each factorization step.",
       "         If UPLO = 'U',",
       "         ( in factorization order, k decreases from N to 1 ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the submatrix A(1:N,N-KB+1:N);",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k-1) < 0 means:",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the matrix A(1:N,N-KB+1:N).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k-1) != k-1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the submatrix A(1:N,N-KB+1:N).",
       "                 If -IPIV(k-1) = k-1, no interchange occurred.",
       "           c) In both cases a) and b) is always ABS( IPIV(k) ) <= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output.",
       "         If UPLO = 'L',",
       "         ( in factorization order, k increases from 1 to N ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the submatrix A(1:N,1:KB).",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k+1) < 0 means:",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the submatrix A(1:N,1:KB).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k+1) != k+1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the submatrix A(1:N,1:KB).",
       "                 If -IPIV(k+1) = k+1, no interchange occurred.",
       "           c) In both cases a) and b) is always ABS( IPIV(k) ) >= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output."],
     "W"=>["[out]", "         W is COMPLEX*16 array, dimension (LDW,NB)"],
     "LDW"=>
      ["[in]",
       "         LDW is INTEGER",
       "         The leading dimension of the array W.  LDW >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: If INFO = -k, the k-th argument had an illegal value",
       "         > 0: If INFO = k, the matrix A is singular, because:",
       "                If UPLO = 'U': column k in the upper",
       "                triangular part of A contains all zeros.",
       "                If UPLO = 'L': column k in the lower",
       "                triangular part of A contains all zeros.",
       "              Therefore D(k,k) is exactly zero, and superdiagonal",
       "              elements of column k of U (or subdiagonal elements of",
       "              column k of L ) are all zeros. The factorization has",
       "              been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if",
       "              it is used to solve a system of equations.",
       "              NOTE: INFO only stores the first occurrence of",
       "              a singularity, any subsequent occurrence of singularity",
       "              is not stored in INFO even though the factorization",
       "              always completes."]}},
 "ssytrs"=>
  {"summary"=>
    ["SSYTRS solves a system of linear equations A*X = B with a real",
     "symmetric matrix A using the factorization A = U*D*U**T or",
     "A = L*D*L**T computed by SSYTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by SSYTRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by SSYTRF."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "sposvx"=>
  {"summary"=>
    ["SPOSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to",
     "compute the solution to a real system of linear equations",
     "   A * X = B,",
     "where A is an N-by-N symmetric positive definite matrix and X and B",
     "are N-by-NRHS matrices.",
     "Error bounds on the solution and a condition estimate are also",
     "provided."],
   "param"=>nil},
 "cla_gercond_x"=>
  {"summary"=>
    ["   CLA_GERCOND_X computes the infinity norm condition number of",
     "   op(A) * diag(X) where X is a COMPLEX vector."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "    Specifies the form of the system of equations:",
       "      = 'N':  A * X = B     (No transpose)",
       "      = 'T':  A**T * X = B  (Transpose)",
       "      = 'C':  A**H * X = B  (Conjugate Transpose = Transpose)"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX array, dimension (LDAF,N)",
       "    The factors L and U from the factorization",
       "    A = P*L*U as computed by CGETRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    The pivot indices from the factorization A = P*L*U",
       "    as computed by CGETRF; row i of the matrix was interchanged",
       "    with row IPIV(i)."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array, dimension (N)",
       "    The vector X in the formula op(A) * diag(X)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "    i > 0:  The ith argument is invalid."],
     "WORK"=>
      ["[in]",
       "         WORK is COMPLEX array, dimension (2*N).",
       "    Workspace."],
     "RWORK"=>
      ["[in]",
       "         RWORK is REAL array, dimension (N).",
       "    Workspace."]}},
 "dlagts"=>
  {"summary"=>
    ["DLAGTS may be used to solve one of the systems of equations",
     "   (T - lambda*I)*x = y   or   (T - lambda*I)**T*x = y,",
     "where T is an n by n tridiagonal matrix, for x, following the",
     "factorization of (T - lambda*I) as",
     "   (T - lambda*I) = P*L*U ,",
     "by routine DLAGTF. The choice of equation to be solved is",
     "controlled by the argument JOB, and in each case there is an option",
     "to perturb zero or very small diagonal elements of U, this option",
     "being intended for use in applications such as inverse iteration."],
   "param"=>
    {"JOB"=>
      ["[in]",
       "         JOB is INTEGER",
       "         Specifies the job to be performed by DLAGTS as follows:",
       "         =  1: The equations  (T - lambda*I)x = y  are to be solved,",
       "               but diagonal elements of U are not to be perturbed.",
       "         = -1: The equations  (T - lambda*I)x = y  are to be solved",
       "               and, if overflow would otherwise occur, the diagonal",
       "               elements of U are to be perturbed. See argument TOL",
       "               below.",
       "         =  2: The equations  (T - lambda*I)**Tx = y  are to be solved,",
       "               but diagonal elements of U are not to be perturbed.",
       "         = -2: The equations  (T - lambda*I)**Tx = y  are to be solved",
       "               and, if overflow would otherwise occur, the diagonal",
       "               elements of U are to be perturbed. See argument TOL",
       "               below."],
     "N"=>
      ["[in]", "         N is INTEGER", "         The order of the matrix T."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (N)",
       "         On entry, A must contain the diagonal elements of U as",
       "         returned from DLAGTF."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array, dimension (N-1)",
       "         On entry, B must contain the first super-diagonal elements of",
       "         U as returned from DLAGTF."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (N-1)",
       "         On entry, C must contain the sub-diagonal elements of L as",
       "         returned from DLAGTF."],
     "D"=>
      ["[in]",
       "         D is DOUBLE PRECISION array, dimension (N-2)",
       "         On entry, D must contain the second super-diagonal elements",
       "         of U as returned from DLAGTF."],
     "IN"=>
      ["[in]",
       "         IN is INTEGER array, dimension (N)",
       "         On entry, IN must contain details of the matrix P as returned",
       "         from DLAGTF."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array, dimension (N)",
       "         On entry, the right hand side vector y.",
       "         On exit, Y is overwritten by the solution vector x."],
     "TOL"=>
      ["[in,out]",
       "         TOL is DOUBLE PRECISION",
       "         On entry, with  JOB .lt. 0, TOL should be the minimum",
       "         perturbation to be made to very small diagonal elements of U.",
       "         TOL should normally be chosen as about eps*norm(U), where eps",
       "         is the relative machine precision, but if TOL is supplied as",
       "         non-positive, then it is reset to eps*max( abs( u(i,j) ) ).",
       "         If  JOB .gt. 0  then TOL is not referenced.",
       "         On exit, TOL is changed as described above, only if TOL is",
       "         non-positive on entry. Otherwise TOL is unchanged."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0   : successful exit",
       "         .lt. 0: if INFO = -i, the i-th argument had an illegal value",
       "         .gt. 0: overflow would occur when computing the INFO(th)",
       "                 element of the solution vector x. This can only occur",
       "                 when JOB is supplied as positive and either means",
       "                 that a diagonal element of U is very small, or that",
       "                 the elements of the right-hand side vector y are very",
       "                 large."]}},
 "clahef"=>
  {"summary"=>
    ["CLAHEF computes a partial factorization of a complex Hermitian",
     "matrix A using the Bunch-Kaufman diagonal pivoting method. The",
     "partial factorization has the form:",
     "A  =  ( I  U12 ) ( A11  0  ) (  I      0     )  if UPLO = 'U', or:",
     "      ( 0  U22 ) (  0   D  ) ( U12**H U22**H )",
     "A  =  ( L11  0 ) (  D   0  ) ( L11**H L21**H )  if UPLO = 'L'",
     "      ( L21  I ) (  0  A22 ) (  0      I     )",
     "where the order of D is at most NB. The actual order is returned in",
     "the argument KB, and is either NB or NB-1, or N if N <= NB.",
     "Note that U**H denotes the conjugate transpose of U.",
     "CLAHEF is an auxiliary routine called by CHETRF. It uses blocked code",
     "(calling Level 3 BLAS) to update the submatrix A11 (if UPLO = 'U') or",
     "A22 (if UPLO = 'L')."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         Hermitian matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The maximum number of columns of the matrix A that should be",
       "         factored.  NB should be at least 2 to allow for 2-by-2 pivot",
       "         blocks."],
     "KB"=>
      ["[out]",
       "         KB is INTEGER",
       "         The number of columns of A that were actually factored.",
       "         KB is either NB-1 or NB, or N if N <= NB."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the leading",
       "         n-by-n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n-by-n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, A contains details of the partial factorization."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If UPLO = 'U':",
       "            Only the last KB elements of IPIV are set.",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k-1) < 0, then rows and columns",
       "            k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "            is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "            Only the first KB elements of IPIV are set.",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k+1) < 0, then rows and columns",
       "            k+1 and -IPIV(k) were interchanged and D(k:k+1,k:k+1)",
       "            is a 2-by-2 diagonal block."],
     "W"=>["[out]", "         W is COMPLEX array, dimension (LDW,NB)"],
     "LDW"=>
      ["[in]",
       "         LDW is INTEGER",
       "         The leading dimension of the array W.  LDW >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         > 0: if INFO = k, D(k,k) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular."]}},
 "sgeesx"=>
  {"summary"=>
    ["SGEESX computes for an N-by-N real nonsymmetric matrix A, the",
     "eigenvalues, the real Schur form T, and, optionally, the matrix of",
     "Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).",
     "Optionally, it also orders the eigenvalues on the diagonal of the",
     "real Schur form so that selected eigenvalues are at the top left;",
     "computes a reciprocal condition number for the average of the",
     "selected eigenvalues (RCONDE); and computes a reciprocal condition",
     "number for the right invariant subspace corresponding to the",
     "selected eigenvalues (RCONDV).  The leading columns of Z form an",
     "orthonormal basis for this invariant subspace.",
     "For further explanation of the reciprocal condition numbers RCONDE",
     "and RCONDV, see Section 4.10 of the LAPACK Users' Guide (where",
     "these quantities are called s and sep respectively).",
     "A real matrix is in real Schur form if it is upper quasi-triangular",
     "with 1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in",
     "the form",
     "          [  a  b  ]",
     "          [  c  a  ]",
     "where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc)."],
   "param"=>
    {"JOBVS"=>
      ["[in]",
       "         JOBVS is CHARACTER*1",
       "         = 'N': Schur vectors are not computed;",
       "         = 'V': Schur vectors are computed."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the Schur form.",
       "         = 'N': Eigenvalues are not ordered;",
       "         = 'S': Eigenvalues are ordered (see SELECT)."],
     "SELECT"=>
      ["[in]",
       "         SELECT is a LOGICAL FUNCTION of two REAL arguments",
       "         SELECT must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'S', SELECT is used to select eigenvalues to sort",
       "         to the top left of the Schur form.",
       "         If SORT = 'N', SELECT is not referenced.",
       "         An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if",
       "         SELECT(WR(j),WI(j)) is true; i.e., if either one of a",
       "         complex conjugate pair of eigenvalues is selected, then both",
       "         are.  Note that a selected complex eigenvalue may no longer",
       "         satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since",
       "         ordering may change the value of complex eigenvalues",
       "         (especially if the eigenvalue is ill-conditioned); in this",
       "         case INFO may be set to N+3 (see INFO below)."],
     "SENSE"=>
      ["[in]",
       "         SENSE is CHARACTER*1",
       "         Determines which reciprocal condition numbers are computed.",
       "         = 'N': None are computed;",
       "         = 'E': Computed for average of selected eigenvalues only;",
       "         = 'V': Computed for selected right invariant subspace only;",
       "         = 'B': Computed for both.",
       "         If SENSE = 'E', 'V' or 'B', SORT must equal 'S'."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A. N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA, N)",
       "         On entry, the N-by-N matrix A.",
       "         On exit, A is overwritten by its real Schur form T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues (after sorting)",
       "                        for which SELECT is true. (Complex conjugate",
       "                        pairs for which SELECT is true for either",
       "                        eigenvalue count as 2.)"],
     "WR"=>["[out]", "         WR is REAL array, dimension (N)"],
     "WI"=>
      ["[out]",
       "         WI is REAL array, dimension (N)",
       "         WR and WI contain the real and imaginary parts, respectively,",
       "         of the computed eigenvalues, in the same order that they",
       "         appear on the diagonal of the output Schur form T.  Complex",
       "         conjugate pairs of eigenvalues appear consecutively with the",
       "         eigenvalue having the positive imaginary part first."],
     "VS"=>
      ["[out]",
       "         VS is REAL array, dimension (LDVS,N)",
       "         If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur",
       "         vectors.",
       "         If JOBVS = 'N', VS is not referenced."],
     "LDVS"=>
      ["[in]",
       "         LDVS is INTEGER",
       "         The leading dimension of the array VS.  LDVS >= 1, and if",
       "         JOBVS = 'V', LDVS >= N."],
     "RCONDE"=>
      ["[out]",
       "         RCONDE is REAL",
       "         If SENSE = 'E' or 'B', RCONDE contains the reciprocal",
       "         condition number for the average of the selected eigenvalues.",
       "         Not referenced if SENSE = 'N' or 'V'."],
     "RCONDV"=>
      ["[out]",
       "         RCONDV is REAL",
       "         If SENSE = 'V' or 'B', RCONDV contains the reciprocal",
       "         condition number for the selected right invariant subspace.",
       "         Not referenced if SENSE = 'N' or 'E'."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,3*N).",
       "         Also, if SENSE = 'E' or 'V' or 'B',",
       "         LWORK >= N+2*SDIM*(N-SDIM), where SDIM is the number of",
       "         selected eigenvalues computed by this routine.  Note that",
       "         N+2*SDIM*(N-SDIM) <= N+N*N/2. Note also that an error is only",
       "         returned if LWORK < max(1,3*N), but if SENSE = 'E' or 'V' or",
       "         'B' this may not be large enough.",
       "         For good performance, LWORK must generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates upper bounds on the optimal sizes of the",
       "         arrays WORK and IWORK, returns these values as the first",
       "         entries of the WORK and IWORK arrays, and no error messages",
       "         related to LWORK or LIWORK are issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         LIWORK >= 1; if SENSE = 'V' or 'B', LIWORK >= SDIM*(N-SDIM).",
       "         Note that SDIM*(N-SDIM) <= N*N/4. Note also that an error is",
       "         only returned if LIWORK < 1, but if SENSE = 'V' or 'B' this",
       "         may not be large enough.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates upper bounds on the optimal sizes of",
       "         the arrays WORK and IWORK, returns these values as the first",
       "         entries of the WORK and IWORK arrays, and no error messages",
       "         related to LWORK or LIWORK are issued by XERBLA."],
     "BWORK"=>
      ["[out]",
       "         BWORK is LOGICAL array, dimension (N)",
       "         Not referenced if SORT = 'N'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value.",
       "         > 0: if INFO = i, and i is",
       "            <= N: the QR algorithm failed to compute all the",
       "                  eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI",
       "                  contain those eigenvalues which have converged; if",
       "                  JOBVS = 'V', VS contains the transformation which",
       "                  reduces A to its partially converged Schur form.",
       "            = N+1: the eigenvalues could not be reordered because some",
       "                  eigenvalues were too close to separate (the problem",
       "                  is very ill-conditioned);",
       "            = N+2: after reordering, roundoff changed values of some",
       "                  complex eigenvalues so that leading eigenvalues in",
       "                  the Schur form no longer satisfy SELECT=.TRUE.  This",
       "                  could also be caused by underflow due to scaling."]}},
 "ctbcon"=>
  {"summary"=>
    ["CTBCON estimates the reciprocal of the condition number of a",
     "triangular band matrix A, in either the 1-norm or the infinity-norm.",
     "The norm of A is computed and an estimate is obtained for",
     "norm(inv(A)), then the reciprocal of the condition number is",
     "computed as",
     "   RCOND = 1 / ( norm(A) * norm(inv(A)) )."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies whether the 1-norm condition number or the",
       "         infinity-norm condition number is required:",
       "         = '1' or 'O':  1-norm;",
       "         = 'I':         Infinity-norm."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  A is upper triangular;",
       "         = 'L':  A is lower triangular."],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         = 'N':  A is non-unit triangular;",
       "         = 'U':  A is unit triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals or subdiagonals of the",
       "         triangular band matrix A.  KD >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX array, dimension (LDAB,N)",
       "         The upper or lower triangular band matrix A, stored in the",
       "         first kd+1 rows of the array. The j-th column of A is stored",
       "         in the j-th column of the array AB as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         If DIAG = 'U', the diagonal elements of A are not referenced",
       "         and are assumed to be 1."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD+1."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(norm(A) * norm(inv(A)))."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (2*N)"],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dgeequb"=>
  {"summary"=>
    ["DGEEQUB computes row and column scalings intended to equilibrate an",
     "M-by-N matrix A and reduce its condition number.  R returns the row",
     "scale factors and C the column scale factors, chosen to try to make",
     "the largest element in each row and column of the matrix B with",
     "elements B(i,j)=R(i)*A(i,j)*C(j) have an absolute value of at most",
     "the radix.",
     "R(i) and C(j) are restricted to be a power of the radix between",
     "SMLNUM = smallest safe number and BIGNUM = largest safe number.  Use",
     "of these scaling factors is not guaranteed to reduce the condition",
     "number of A but works well in practice.",
     "This routine differs from DGEEQU by restricting the scaling factors",
     "to a power of the radix.  Barring over- and underflow, scaling by",
     "these factors introduces no additional rounding errors.  However, the",
     "scaled entries' magnitudes are no longer approximately 1 but lie",
     "between sqrt(radix) and 1/sqrt(radix)."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         The M-by-N matrix whose equilibration factors are",
       "         to be computed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "R"=>
      ["[out]",
       "         R is DOUBLE PRECISION array, dimension (M)",
       "         If INFO = 0 or INFO > M, R contains the row scale factors",
       "         for A."],
     "C"=>
      ["[out]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0,  C contains the column scale factors for A."],
     "ROWCND"=>
      ["[out]",
       "         ROWCND is DOUBLE PRECISION",
       "         If INFO = 0 or INFO > M, ROWCND contains the ratio of the",
       "         smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and",
       "         AMAX is neither too large nor too small, it is not worth",
       "         scaling by R."],
     "COLCND"=>
      ["[out]",
       "         COLCND is DOUBLE PRECISION",
       "         If INFO = 0, COLCND contains the ratio of the smallest",
       "         C(i) to the largest C(i).  If COLCND >= 0.1, it is not",
       "         worth scaling by C."],
     "AMAX"=>
      ["[out]",
       "         AMAX is DOUBLE PRECISION",
       "         Absolute value of largest matrix element.  If AMAX is very",
       "         close to overflow or very close to underflow, the matrix",
       "         should be scaled."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i,  and i is",
       "               <= M:  the i-th row of A is exactly zero",
       "               >  M:  the (i-M)-th column of A is exactly zero"]}},
 "cgghd3"=>
  {"summary"=>
    ["CGGHD3 reduces a pair of complex matrices (A,B) to generalized upper",
     "Hessenberg form using unitary transformations, where A is a",
     "general matrix and B is upper triangular.  The form of the",
     "generalized eigenvalue problem is",
     "   A*x = lambda*B*x,",
     "and B is typically made upper triangular by computing its QR",
     "factorization and moving the unitary matrix Q to the left side",
     "of the equation.",
     "This subroutine simultaneously reduces A to a Hessenberg matrix H:",
     "   Q**H*A*Z = H",
     "and transforms B to another upper triangular matrix T:",
     "   Q**H*B*Z = T",
     "in order to reduce the problem to its standard form",
     "   H*y = lambda*T*y",
     "where y = Z**H*x.",
     "The unitary matrices Q and Z are determined as products of Givens",
     "rotations.  They may either be formed explicitly, or they may be",
     "postmultiplied into input matrices Q1 and Z1, so that",
     "     Q1 * A * Z1**H = (Q1*Q) * H * (Z1*Z)**H",
     "     Q1 * B * Z1**H = (Q1*Q) * T * (Z1*Z)**H",
     "If Q1 is the unitary matrix from the QR factorization of B in the",
     "original equation A*x = lambda*B*x, then CGGHD3 reduces the original",
     "problem to generalized Hessenberg form.",
     "This is a blocked variant of CGGHRD, using matrix-matrix",
     "multiplications for parts of the computation to enhance performance."],
   "param"=>
    {"COMPQ"=>
      ["[in]",
       "         COMPQ is CHARACTER*1",
       "         = 'N': do not compute Q;",
       "         = 'I': Q is initialized to the unit matrix, and the",
       "                unitary matrix Q is returned;",
       "         = 'V': Q must contain a unitary matrix Q1 on entry,",
       "                and the product Q1*Q is returned."],
     "COMPZ"=>
      ["[in]",
       "         COMPZ is CHARACTER*1",
       "         = 'N': do not compute Z;",
       "         = 'I': Z is initialized to the unit matrix, and the",
       "                unitary matrix Z is returned;",
       "         = 'V': Z must contain a unitary matrix Z1 on entry,",
       "                and the product Z1*Z is returned."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "         ILO and IHI mark the rows and columns of A which are to be",
       "         reduced.  It is assumed that A is already upper triangular",
       "         in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are",
       "         normally set by a previous call to CGGBAL; otherwise they",
       "         should be set to 1 and N respectively.",
       "         1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the N-by-N general matrix to be reduced.",
       "         On exit, the upper triangle and the first subdiagonal of A",
       "         are overwritten with the upper Hessenberg matrix H, and the",
       "         rest is set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB, N)",
       "         On entry, the N-by-N upper triangular matrix B.",
       "         On exit, the upper triangular matrix T = Q**H B Z.  The",
       "         elements below the diagonal are set to zero."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX array, dimension (LDQ, N)",
       "         On entry, if COMPQ = 'V', the unitary matrix Q1, typically",
       "         from the QR factorization of B.",
       "         On exit, if COMPQ='I', the unitary matrix Q, and if",
       "         COMPQ = 'V', the product Q1*Q.",
       "         Not referenced if COMPQ='N'."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.",
       "         LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise."],
     "Z"=>
      ["[in,out]",
       "         Z is COMPLEX array, dimension (LDZ, N)",
       "         On entry, if COMPZ = 'V', the unitary matrix Z1.",
       "         On exit, if COMPZ='I', the unitary matrix Z, and if",
       "         COMPZ = 'V', the product Z1*Z.",
       "         Not referenced if COMPZ='N'."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.",
       "         LDZ >= N if COMPZ='V' or 'I'; LDZ >= 1 otherwise."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (LWORK)",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.  LWORK >= 1.",
       "         For optimum performance LWORK >= 6*N*NB, where NB is the",
       "         optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "dorcsd2by1"=>
  {"summary"=>[],
   "param"=>
    {"JOBU1"=>
      ["[in]",
       "         JOBU1 is CHARACTER",
       "         = 'Y':      U1 is computed;",
       "         otherwise:  U1 is not computed."],
     "JOBU2"=>
      ["[in]",
       "         JOBU2 is CHARACTER",
       "         = 'Y':      U2 is computed;",
       "         otherwise:  U2 is not computed."],
     "JOBV1T"=>
      ["[in]",
       "         JOBV1T is CHARACTER",
       "         = 'Y':      V1T is computed;",
       "         otherwise:  V1T is not computed."],
     "M"=>
      ["[in]", "         M is INTEGER", "         The number of rows in X."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of rows in X11. 0 <= P <= M."],
     "Q"=>
      ["[in]",
       "         Q is INTEGER",
       "         The number of columns in X11 and X21. 0 <= Q <= M."],
     "X11"=>
      ["[in,out]",
       "         X11 is DOUBLE PRECISION array, dimension (LDX11,Q)",
       "         On entry, part of the orthogonal matrix whose CSD is desired."],
     "LDX11"=>
      ["[in]",
       "         LDX11 is INTEGER",
       "         The leading dimension of X11. LDX11 >= MAX(1,P)."],
     "X21"=>
      ["[in,out]",
       "         X21 is DOUBLE PRECISION array, dimension (LDX21,Q)",
       "         On entry, part of the orthogonal matrix whose CSD is desired."],
     "LDX21"=>
      ["[in]",
       "         LDX21 is INTEGER",
       "         The leading dimension of X21. LDX21 >= MAX(1,M-P)."],
     "THETA"=>
      ["[out]",
       "         THETA is DOUBLE PRECISION array, dimension (R), in which R =",
       "         MIN(P,M-P,Q,M-Q).",
       "         C = DIAG( COS(THETA(1)), ... , COS(THETA(R)) ) and",
       "         S = DIAG( SIN(THETA(1)), ... , SIN(THETA(R)) )."],
     "U1"=>
      ["[out]",
       "         U1 is DOUBLE PRECISION array, dimension (P)",
       "         If JOBU1 = 'Y', U1 contains the P-by-P orthogonal matrix U1."],
     "LDU1"=>
      ["[in]",
       "         LDU1 is INTEGER",
       "         The leading dimension of U1. If JOBU1 = 'Y', LDU1 >=",
       "         MAX(1,P)."],
     "U2"=>
      ["[out]",
       "         U2 is DOUBLE PRECISION array, dimension (M-P)",
       "         If JOBU2 = 'Y', U2 contains the (M-P)-by-(M-P) orthogonal",
       "         matrix U2."],
     "LDU2"=>
      ["[in]",
       "         LDU2 is INTEGER",
       "         The leading dimension of U2. If JOBU2 = 'Y', LDU2 >=",
       "         MAX(1,M-P)."],
     "V1T"=>
      ["[out]",
       "         V1T is DOUBLE PRECISION array, dimension (Q)",
       "         If JOBV1T = 'Y', V1T contains the Q-by-Q matrix orthogonal",
       "         matrix V1**T."],
     "LDV1T"=>
      ["[in]",
       "         LDV1T is INTEGER",
       "         The leading dimension of V1T. If JOBV1T = 'Y', LDV1T >=",
       "         MAX(1,Q)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK.",
       "         If INFO > 0 on exit, WORK(2:R) contains the values PHI(1),",
       "         ..., PHI(R-1) that, together with THETA(1), ..., THETA(R),",
       "         define the matrix in intermediate bidiagonal-block form",
       "         remaining after nonconvergence. INFO specifies the number",
       "         of nonzero PHI's."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the work array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (M-MIN(P,M-P,Q,M-Q))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  DBBCSD did not converge. See the description of WORK",
       "               above for details."]}},
 "ctpmqrt"=>
  {"summary"=>
    ["CTPMQRT applies a complex orthogonal matrix Q obtained from a",
     "\"triangular-pentagonal\" complex block reflector H to a general",
     "complex matrix C, which consists of two blocks A and B."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**H from the Left;",
       "         = 'R': apply Q or Q**H from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'C':  Transpose, apply Q**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The order of the trapezoidal part of V.",
       "         K >= L >= 0.  See Further Details."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The block size used for the storage of T.  K >= NB >= 1.",
       "         This must be the same value of NB used to generate T",
       "         in CTPQRT."],
     "V"=>
      ["[in]",
       "         V is COMPLEX array, dimension (LDA,K)",
       "         The i-th column must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         CTPQRT in B.  See Further Details."],
     "LDV"=>
      ["[in]",
       "         LDV is INTEGER",
       "         The leading dimension of the array V.",
       "         If SIDE = 'L', LDV >= max(1,M);",
       "         if SIDE = 'R', LDV >= max(1,N)."],
     "T"=>
      ["[in]",
       "         T is COMPLEX array, dimension (LDT,K)",
       "         The upper triangular factors of the block reflectors",
       "         as returned by CTPQRT, stored as a NB-by-K matrix."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= NB."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension",
       "         (LDA,N) if SIDE = 'L' or",
       "         (LDA,K) if SIDE = 'R'",
       "         On entry, the K-by-N or M-by-K matrix A.",
       "         On exit, A is overwritten by the corresponding block of",
       "         Q*C or Q**H*C or C*Q or C*Q**H.  See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.",
       "         If SIDE = 'L', LDC >= max(1,K);",
       "         If SIDE = 'R', LDC >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,N)",
       "         On entry, the M-by-N matrix B.",
       "         On exit, B is overwritten by the corresponding block of",
       "         Q*C or Q**H*C or C*Q or C*Q**H.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.",
       "         LDB >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array. The dimension of WORK is",
       "          N*NB if SIDE = 'L', or  M*NB if SIDE = 'R'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "sporfs"=>
  {"summary"=>
    ["SPORFS improves the computed solution to a system of linear",
     "equations when the coefficient matrix is symmetric positive definite,",
     "and provides error bounds and backward error estimates for the",
     "solution."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrices B and X.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         The symmetric matrix A.  If UPLO = 'U', the leading N-by-N",
       "         upper triangular part of A contains the upper triangular part",
       "         of the matrix A, and the strictly lower triangular part of A",
       "         is not referenced.  If UPLO = 'L', the leading N-by-N lower",
       "         triangular part of A contains the lower triangular part of",
       "         the matrix A, and the strictly upper triangular part of A is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is REAL array, dimension (LDAF,N)",
       "         The triangular factor U or L from the Cholesky factorization",
       "         A = U**T*U or A = L*L**T, as computed by SPOTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "         The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "B"=>
      ["[in]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "         The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is REAL array, dimension (LDX,NRHS)",
       "         On entry, the solution matrix X, as computed by SPOTRS.",
       "         On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.  LDX >= max(1,N)."],
     "FERR"=>
      ["[out]",
       "         FERR is REAL array, dimension (NRHS)",
       "         The estimated forward error bound for each solution vector",
       "         X(j) (the j-th column of the solution matrix X).",
       "         If XTRUE is the true solution corresponding to X(j), FERR(j)",
       "         is an estimated upper bound for the magnitude of the largest",
       "         element in (X(j) - XTRUE) divided by the magnitude of the",
       "         largest element in X(j).  The estimate is as reliable as",
       "         the estimate for RCOND, and is almost always a slight",
       "         overestimate of the true error."],
     "BERR"=>
      ["[out]",
       "         BERR is REAL array, dimension (NRHS)",
       "         The componentwise relative backward error of each solution",
       "         vector X(j) (i.e., the smallest relative change in",
       "         any element of A or B that makes X(j) an exact solution)."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (3*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cuncsd"=>
  {"summary"=>
    ["CUNCSD computes the CS decomposition of an M-by-M partitioned",
     "unitary matrix X:",
     "                                [  I  0  0 |  0  0  0 ]",
     "                                [  0  C  0 |  0 -S  0 ]",
     "    [ X11 | X12 ]   [ U1 |    ] [  0  0  0 |  0  0 -I ] [ V1 |    ]**H",
     "X = [-----------] = [---------] [---------------------] [---------]   .",
     "    [ X21 | X22 ]   [    | U2 ] [  0  0  0 |  I  0  0 ] [    | V2 ]",
     "                                [  0  S  0 |  0  C  0 ]",
     "                                [  0  0  I |  0  0  0 ]",
     "X11 is P-by-Q. The unitary matrices U1, U2, V1, and V2 are P-by-P,",
     "(M-P)-by-(M-P), Q-by-Q, and (M-Q)-by-(M-Q), respectively. C and S are",
     "R-by-R nonnegative diagonal matrices satisfying C^2 + S^2 = I, in",
     "which R = MIN(P,M-P,Q,M-Q)."],
   "param"=>
    {"JOBU1"=>
      ["[in]",
       "         JOBU1 is CHARACTER",
       "         = 'Y':      U1 is computed;",
       "         otherwise:  U1 is not computed."],
     "JOBU2"=>
      ["[in]",
       "         JOBU2 is CHARACTER",
       "         = 'Y':      U2 is computed;",
       "         otherwise:  U2 is not computed."],
     "JOBV1T"=>
      ["[in]",
       "         JOBV1T is CHARACTER",
       "         = 'Y':      V1T is computed;",
       "         otherwise:  V1T is not computed."],
     "JOBV2T"=>
      ["[in]",
       "         JOBV2T is CHARACTER",
       "         = 'Y':      V2T is computed;",
       "         otherwise:  V2T is not computed."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER",
       "         = 'T':      X, U1, U2, V1T, and V2T are stored in row-major",
       "                     order;",
       "         otherwise:  X, U1, U2, V1T, and V2T are stored in column-",
       "                     major order."],
     "SIGNS"=>
      ["[in]",
       "         SIGNS is CHARACTER",
       "         = 'O':      The lower-left block is made nonpositive (the",
       "                     \"other\" convention);",
       "         otherwise:  The upper-right block is made nonpositive (the",
       "                     \"default\" convention)."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows and columns in X."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of rows in X11 and X12. 0 <= P <= M."],
     "Q"=>
      ["[in]",
       "         Q is INTEGER",
       "         The number of columns in X11 and X21. 0 <= Q <= M."],
     "X11"=>
      ["[in,out]",
       "         X11 is COMPLEX array, dimension (LDX11,Q)",
       "         On entry, part of the unitary matrix whose CSD is desired."],
     "LDX11"=>
      ["[in]",
       "         LDX11 is INTEGER",
       "         The leading dimension of X11. LDX11 >= MAX(1,P)."],
     "X12"=>
      ["[in,out]",
       "         X12 is COMPLEX array, dimension (LDX12,M-Q)",
       "         On entry, part of the unitary matrix whose CSD is desired."],
     "LDX12"=>
      ["[in]",
       "         LDX12 is INTEGER",
       "         The leading dimension of X12. LDX12 >= MAX(1,P)."],
     "X21"=>
      ["[in,out]",
       "         X21 is COMPLEX array, dimension (LDX21,Q)",
       "         On entry, part of the unitary matrix whose CSD is desired."],
     "LDX21"=>
      ["[in]",
       "         LDX21 is INTEGER",
       "         The leading dimension of X11. LDX21 >= MAX(1,M-P)."],
     "X22"=>
      ["[in,out]",
       "         X22 is COMPLEX array, dimension (LDX22,M-Q)",
       "         On entry, part of the unitary matrix whose CSD is desired."],
     "LDX22"=>
      ["[in]",
       "         LDX22 is INTEGER",
       "         The leading dimension of X11. LDX22 >= MAX(1,M-P)."],
     "THETA"=>
      ["[out]",
       "         THETA is REAL array, dimension (R), in which R =",
       "         MIN(P,M-P,Q,M-Q).",
       "         C = DIAG( COS(THETA(1)), ... , COS(THETA(R)) ) and",
       "         S = DIAG( SIN(THETA(1)), ... , SIN(THETA(R)) )."],
     "U1"=>
      ["[out]",
       "         U1 is COMPLEX array, dimension (P)",
       "         If JOBU1 = 'Y', U1 contains the P-by-P unitary matrix U1."],
     "LDU1"=>
      ["[in]",
       "         LDU1 is INTEGER",
       "         The leading dimension of U1. If JOBU1 = 'Y', LDU1 >=",
       "         MAX(1,P)."],
     "U2"=>
      ["[out]",
       "         U2 is COMPLEX array, dimension (M-P)",
       "         If JOBU2 = 'Y', U2 contains the (M-P)-by-(M-P) unitary",
       "         matrix U2."],
     "LDU2"=>
      ["[in]",
       "         LDU2 is INTEGER",
       "         The leading dimension of U2. If JOBU2 = 'Y', LDU2 >=",
       "         MAX(1,M-P)."],
     "V1T"=>
      ["[out]",
       "         V1T is COMPLEX array, dimension (Q)",
       "         If JOBV1T = 'Y', V1T contains the Q-by-Q matrix unitary",
       "         matrix V1**H."],
     "LDV1T"=>
      ["[in]",
       "         LDV1T is INTEGER",
       "         The leading dimension of V1T. If JOBV1T = 'Y', LDV1T >=",
       "         MAX(1,Q)."],
     "V2T"=>
      ["[out]",
       "         V2T is COMPLEX array, dimension (M-Q)",
       "         If JOBV2T = 'Y', V2T contains the (M-Q)-by-(M-Q) unitary",
       "         matrix V2**H."],
     "LDV2T"=>
      ["[in]",
       "         LDV2T is INTEGER",
       "         The leading dimension of V2T. If JOBV2T = 'Y', LDV2T >=",
       "         MAX(1,M-Q)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the work array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]",
       "         RWORK is REAL array, dimension MAX(1,LRWORK)",
       "         On exit, if INFO = 0, RWORK(1) returns the optimal LRWORK.",
       "         If INFO > 0 on exit, RWORK(2:R) contains the values PHI(1),",
       "         ..., PHI(R-1) that, together with THETA(1), ..., THETA(R),",
       "         define the matrix in intermediate bidiagonal-block form",
       "         remaining after nonconvergence. INFO specifies the number",
       "         of nonzero PHI's."],
     "LRWORK"=>
      ["[in]",
       "         LRWORK is INTEGER",
       "         The dimension of the array RWORK.",
       "         If LRWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the RWORK array, returns",
       "         this value as the first entry of the work array, and no error",
       "         message related to LRWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (M-MIN(P,M-P,Q,M-Q))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  CBBCSD did not converge. See the description of RWORK",
       "               above for details."]}},
 "clags2"=>
  {"summary"=>
    ["CLAGS2 computes 2-by-2 unitary matrices U, V and Q, such",
     "that if ( UPPER ) then",
     "          U**H *A*Q = U**H *( A1 A2 )*Q = ( x  0  )",
     "                            ( 0  A3 )     ( x  x  )",
     "and",
     "          V**H*B*Q = V**H *( B1 B2 )*Q = ( x  0  )",
     "                           ( 0  B3 )     ( x  x  )",
     "or if ( .NOT.UPPER ) then",
     "          U**H *A*Q = U**H *( A1 0  )*Q = ( x  x  )",
     "                            ( A2 A3 )     ( 0  x  )",
     "and",
     "          V**H *B*Q = V**H *( B1 0  )*Q = ( x  x  )",
     "                            ( B2 B3 )     ( 0  x  )",
     "where",
     "  U = (   CSU    SNU ), V = (  CSV    SNV ),",
     "      ( -SNU**H  CSU )      ( -SNV**H CSV )",
     "  Q = (   CSQ    SNQ )",
     "      ( -SNQ**H  CSQ )",
     "The rows of the transformed A and B are parallel. Moreover, if the",
     "input 2-by-2 matrix A is not zero, then the transformed (1,1) entry",
     "of A is not zero. If the input matrices A and B are both not zero,",
     "then the transformed (2,2) element of B is not zero, except when the",
     "first rows of input A and B are parallel and the second rows are",
     "zero."],
   "param"=>
    {"UPPER"=>
      ["[in]",
       "         UPPER is LOGICAL",
       "         = .TRUE.: the input matrices A and B are upper triangular.",
       "         = .FALSE.: the input matrices A and B are lower triangular."],
     "A1"=>["[in]", "         A1 is REAL"],
     "A2"=>["[in]", "         A2 is COMPLEX"],
     "A3"=>
      ["[in]",
       "         A3 is REAL",
       "         On entry, A1, A2 and A3 are elements of the input 2-by-2",
       "         upper (lower) triangular matrix A."],
     "B1"=>["[in]", "         B1 is REAL"],
     "B2"=>["[in]", "         B2 is COMPLEX"],
     "B3"=>
      ["[in]",
       "         B3 is REAL",
       "         On entry, B1, B2 and B3 are elements of the input 2-by-2",
       "         upper (lower) triangular matrix B."],
     "CSU"=>["[out]", "         CSU is REAL"],
     "SNU"=>
      ["[out]",
       "         SNU is COMPLEX",
       "         The desired unitary matrix U."],
     "CSV"=>["[out]", "         CSV is REAL"],
     "SNV"=>
      ["[out]",
       "         SNV is COMPLEX",
       "         The desired unitary matrix V."],
     "CSQ"=>["[out]", "         CSQ is REAL"],
     "SNQ"=>
      ["[out]",
       "         SNQ is COMPLEX",
       "         The desired unitary matrix Q."]}},
 "sgecon"=>
  {"summary"=>
    ["SGECON estimates the reciprocal of the condition number of a general",
     "real matrix A, in either the 1-norm or the infinity-norm, using",
     "the LU factorization computed by SGETRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as",
     "   RCOND = 1 / ( norm(A) * norm(inv(A)) )."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies whether the 1-norm condition number or the",
       "         infinity-norm condition number is required:",
       "         = '1' or 'O':  1-norm;",
       "         = 'I':         Infinity-norm."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         The factors L and U from the factorization A = P*L*U",
       "         as computed by SGETRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         If NORM = '1' or 'O', the 1-norm of the original matrix A.",
       "         If NORM = 'I', the infinity-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(norm(A) * norm(inv(A)))."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (4*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dpotrs"=>
  {"summary"=>
    ["DPOTRS solves a system of linear equations A*X = B with a symmetric",
     "positive definite matrix A using the Cholesky factorization",
     "A = U**T*U or A = L*L**T computed by DPOTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         The triangular factor U or L from the Cholesky factorization",
       "         A = U**T*U or A = L*L**T, as computed by DPOTRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "stplqt"=>
  {"summary"=>
    ["DTPLQT computes a blocked LQ factorization of a real",
     "\"triangular-pentagonal\" matrix C, which is composed of a",
     "triangular block A and pentagonal block B, using the compact",
     "WY representation for Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B, and the order of the",
       "         triangular matrix A.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B.",
       "         N >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of rows of the lower trapezoidal part of B.",
       "         MIN(M,N) >= L >= 0.  See Further Details."],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The block size to be used in the blocked QR.  M >= MB >= 1."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the lower triangular N-by-N matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the lower triangular matrix L."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,N)",
       "         On entry, the pentagonal M-by-N matrix B.  The first N-L columns",
       "         are rectangular, and the last L columns are lower trapezoidal.",
       "         On exit, B contains the pentagonal matrix V.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is REAL array, dimension (LDT,N)",
       "         The lower triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See Further Details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (MB*M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zunmlq"=>
  {"summary"=>
    ["ZUNMLQ overwrites the general complex M-by-N matrix C with",
     "                SIDE = 'L'     SIDE = 'R'",
     "TRANS = 'N':      Q * C          C * Q",
     "TRANS = 'C':      Q**H * C       C * Q**H",
     "where Q is a complex unitary matrix defined as the product of k",
     "elementary reflectors",
     "      Q = H(k)**H . . . H(2)**H H(1)**H",
     "as returned by ZGELQF. Q is of order M if SIDE = 'L' and of order N",
     "if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**H from the Left;",
       "         = 'R': apply Q or Q**H from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'C':  Conjugate transpose, apply Q**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension",
       "                              (LDA,M) if SIDE = 'L',",
       "                              (LDA,N) if SIDE = 'R'",
       "         The i-th row must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         ZGELQF in the first k rows of its array argument A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,K)."],
     "TAU"=>
      ["[in]",
       "         TAU is COMPLEX*16 array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by ZGELQF."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**H*C or C*Q**H or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If SIDE = 'L', LWORK >= max(1,N);",
       "         if SIDE = 'R', LWORK >= max(1,M).",
       "         For good performance, LWORK should generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zptsv"=>
  {"summary"=>
    ["ZPTSV computes the solution to a complex system of linear equations",
     "A*X = B, where A is an N-by-N Hermitian positive definite tridiagonal",
     "matrix, and X and B are N-by-NRHS matrices.",
     "A is factored as A = L*D*L**H, and the factored form of A is then",
     "used to solve the system of equations."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         On entry, the n diagonal elements of the tridiagonal matrix",
       "         A.  On exit, the n diagonal elements of the diagonal matrix",
       "         D from the factorization A = L*D*L**H."],
     "E"=>
      ["[in,out]",
       "         E is COMPLEX*16 array, dimension (N-1)",
       "         On entry, the (n-1) subdiagonal elements of the tridiagonal",
       "         matrix A.  On exit, the (n-1) subdiagonal elements of the",
       "         unit bidiagonal factor L from the L*D*L**H factorization of",
       "         A.  E can also be regarded as the superdiagonal of the unit",
       "         bidiagonal factor U from the U**H*D*U factorization of A."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the leading minor of order i is not",
       "               positive definite, and the solution has not been",
       "               computed.  The factorization has not been completed",
       "               unless i = N."]}},
 "dsytri2"=>
  {"summary"=>
    ["DSYTRI2 computes the inverse of a DOUBLE PRECISION symmetric indefinite matrix",
     "A using the factorization A = U*D*U**T or A = L*D*L**T computed by",
     "DSYTRF. DSYTRI2 sets the LEADING DIMENSION of the workspace",
     "before calling DSYTRI2X that actually computes the inverse."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the NB diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by DSYTRF.",
       "         On exit, if INFO = 0, the (symmetric) inverse of the original",
       "         matrix.  If UPLO = 'U', the upper triangular part of the",
       "         inverse is formed and the part of A below the diagonal is not",
       "         referenced; if UPLO = 'L' the lower triangular part of the",
       "         inverse is formed and the part of A above the diagonal is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the NB structure of D",
       "         as determined by DSYTRF."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (N+NB+1)*(NB+3)"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         WORK is size >= (N+NB+1)*(NB+3)",
       "         If LDWORK = -1, then a workspace query is assumed; the routine",
       "          calculates:",
       "             - the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array,",
       "             - and no error message related to LDWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "slaqge"=>
  {"summary"=>
    ["SLAQGE equilibrates a general M by N matrix A using the row and",
     "column scaling factors in the vectors R and C."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the M by N matrix A.",
       "         On exit, the equilibrated matrix.  See EQUED for the form of",
       "         the equilibrated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(M,1)."],
     "R"=>
      ["[in]",
       "         R is REAL array, dimension (M)",
       "         The row scale factors for A."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension (N)",
       "         The column scale factors for A."],
     "ROWCND"=>
      ["[in]",
       "         ROWCND is REAL",
       "         Ratio of the smallest R(i) to the largest R(i)."],
     "COLCND"=>
      ["[in]",
       "         COLCND is REAL",
       "         Ratio of the smallest C(i) to the largest C(i)."],
     "AMAX"=>
      ["[in]",
       "         AMAX is REAL",
       "         Absolute value of largest matrix entry."],
     "EQUED"=>
      ["[out]",
       "         EQUED is CHARACTER*1",
       "         Specifies the form of equilibration that was done.",
       "         = 'N':  No equilibration",
       "         = 'R':  Row equilibration, i.e., A has been premultiplied by",
       "                 diag(R).",
       "         = 'C':  Column equilibration, i.e., A has been postmultiplied",
       "                 by diag(C).",
       "         = 'B':  Both row and column equilibration, i.e., A has been",
       "                 replaced by diag(R) * A * diag(C)."]}},
 "chptrf"=>
  {"summary"=>
    ["CHPTRF computes the factorization of a complex Hermitian packed",
     "matrix A using the Bunch-Kaufman diagonal pivoting method:",
     "   A = U*D*U**H  or  A = L*D*L**H",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and D is Hermitian and block diagonal with",
     "1-by-1 and 2-by-2 diagonal blocks."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the Hermitian matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L, stored as a packed triangular",
       "         matrix overwriting A (see below for further details)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "         interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "         If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0, then rows and",
       "         columns k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "         is a 2-by-2 diagonal block.  If UPLO = 'L' and IPIV(k) =",
       "         IPIV(k+1) < 0, then rows and columns k+1 and -IPIV(k) were",
       "         interchanged and D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if it",
       "              is used to solve a system of equations."]}},
 "slamswlq"=>
  {"summary"=>
    ["   DLAMQRTS overwrites the general real M-by-N matrix C with",
     "                   SIDE = 'L'     SIDE = 'R'",
     "   TRANS = 'N':      Q * C          C * Q",
     "   TRANS = 'T':      Q**T * C       C * Q**T",
     "   where Q is a real orthogonal matrix defined as the product of blocked",
     "   elementary reflectors computed by short wide LQ",
     "   factorization (DLASWLQ)"],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**T from the Left;",
       "         = 'R': apply Q or Q**T from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'T':  Transpose, apply Q**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >=0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= M."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         M >= K >= 0;"],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The row block size to be used in the blocked QR.",
       "         M >= MB >= 1"],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The block size to be used in the blocked QR.",
       "               MB > M."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,K)",
       "         The i-th row must contain the vector which defines the blocked",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         DLASWLQ in the first k rows of its array argument A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.",
       "         If SIDE = 'L', LDA >= max(1,M);",
       "         if SIDE = 'R', LDA >= max(1,N)."],
     "T"=>
      ["[in]",
       "         T is REAL array, dimension",
       "         ( M * Number of blocks(CEIL(N-K/NB-K)),",
       "         The blocked upper triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See below",
       "         for further details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "C"=>
      ["[in,out]",
       "         C is REAL array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]", "        (workspace) REAL array, dimension (MAX(1,LWORK))"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If SIDE = 'L', LWORK >= max(1,NB) * MB;",
       "         if SIDE = 'R', LWORK >= max(1,M) * MB.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "stfttp"=>
  {"summary"=>
    ["STFTTP copies a triangular matrix A from rectangular full packed",
     "format (TF) to standard packed format (TP)."],
   "param"=>
    {"TRANSR"=>
      ["[in]",
       "         TRANSR is CHARACTER*1",
       "         = 'N':  ARF is in Normal format;",
       "         = 'T':  ARF is in Transpose format;"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  A is upper triangular;",
       "         = 'L':  A is lower triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A. N >= 0."],
     "ARF"=>
      ["[in]",
       "         ARF is REAL array, dimension ( N*(N+1)/2 ),",
       "         On entry, the upper or lower triangular matrix A stored in",
       "         RFP format. For a further discussion see Notes below."],
     "AP"=>
      ["[out]",
       "         AP is REAL array, dimension ( N*(N+1)/2 ),",
       "         On exit, the upper or lower triangular matrix A, packed",
       "         columnwise in a linear array. The j-th column of A is stored",
       "         in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "clalsd"=>
  {"summary"=>
    ["CLALSD uses the singular value decomposition of A to solve the least",
     "squares problem of finding X to minimize the Euclidean norm of each",
     "column of A*X-B, where A is N-by-N upper bidiagonal, and X and B",
     "are N-by-NRHS. The solution X overwrites B.",
     "The singular values of A smaller than RCOND times the largest",
     "singular value are treated as zero in solving the least squares",
     "problem; in this case a minimum norm solution is returned.",
     "The actual singular values are returned in D in ascending order.",
     "This code makes very mild assumptions about floating point",
     "arithmetic. It will work on machines with a guard digit in",
     "add/subtract, or on those binary machines without guard digits",
     "which subtract like the Cray XMP, Cray YMP, Cray C 90, or Cray 2.",
     "It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "        = 'U': D and E define an upper bidiagonal matrix.",
       "        = 'L': D and E define a  lower bidiagonal matrix."],
     "SMLSIZ"=>
      ["[in]",
       "         SMLSIZ is INTEGER",
       "        The maximum size of the subproblems at the bottom of the",
       "        computation tree."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The dimension of the  bidiagonal matrix.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "        The number of columns of B. NRHS must be at least 1."],
     "D"=>
      ["[in,out]",
       "         D is REAL array, dimension (N)",
       "        On entry D contains the main diagonal of the bidiagonal",
       "        matrix. On exit, if INFO = 0, D contains its singular values."],
     "E"=>
      ["[in,out]",
       "         E is REAL array, dimension (N-1)",
       "        Contains the super-diagonal entries of the bidiagonal matrix.",
       "        On exit, E has been destroyed."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "        On input, B contains the right hand sides of the least",
       "        squares problem. On output, B contains the solution X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "        The leading dimension of B in the calling subprogram.",
       "        LDB must be at least max(1,N)."],
     "RCOND"=>
      ["[in]",
       "         RCOND is REAL",
       "        The singular values of A less than or equal to RCOND times",
       "        the largest singular value are treated as zero in solving",
       "        the least squares problem. If RCOND is negative,",
       "        machine precision is used instead.",
       "        For example, if diag(S)*X=B were the least squares problem,",
       "        where diag(S) is a diagonal matrix of singular values, the",
       "        solution would be X(i) = B(i) / S(i) if S(i) is greater than",
       "        RCOND*max(S), and X(i) = 0 if S(i) is less than or equal to",
       "        RCOND*max(S)."],
     "RANK"=>
      ["[out]",
       "         RANK is INTEGER",
       "        The number of singular values of A greater than RCOND times",
       "        the largest singular value."],
     "WORK"=>
      ["[out]", "         WORK is COMPLEX array, dimension (N * NRHS)."],
     "RWORK"=>
      ["[out]",
       "         RWORK is REAL array, dimension at least",
       "        (9*N + 2*N*SMLSIZ + 8*N*NLVL + 3*SMLSIZ*NRHS +",
       "        MAX( (SMLSIZ+1)**2, N*(1+NRHS) + 2*NRHS ),",
       "        where",
       "        NLVL = MAX( 0, INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1 )"],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (3*N*NLVL + 11*N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "        = 0:  successful exit.",
       "        < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "        > 0:  The algorithm failed to compute a singular value while",
       "              working on the submatrix lying in rows and columns",
       "              INFO/(N+1) through MOD(INFO,N+1)."]}},
 "slaqr5"=>
  {"summary"=>
    ["   SLAQR5, called by SLAQR0, performs a",
     "   single small-bulge multi-shift QR sweep."],
   "param"=>
    {"WANTT"=>
      ["[in]",
       "         WANTT is logical scalar",
       "            WANTT = .true. if the quasi-triangular Schur factor",
       "            is being computed.  WANTT is set to .false. otherwise."],
     "WANTZ"=>
      ["[in]",
       "         WANTZ is logical scalar",
       "            WANTZ = .true. if the orthogonal Schur factor is being",
       "            computed.  WANTZ is set to .false. otherwise."],
     "KACC22"=>
      ["[in]",
       "         KACC22 is integer with value 0, 1, or 2.",
       "            Specifies the computation mode of far-from-diagonal",
       "            orthogonal updates.",
       "       = 0: SLAQR5 does not accumulate reflections and does not",
       "            use matrix-matrix multiply to update far-from-diagonal",
       "            matrix entries.",
       "       = 1: SLAQR5 accumulates reflections and uses matrix-matrix",
       "            multiply to update the far-from-diagonal matrix entries.",
       "       = 2: SLAQR5 accumulates reflections, uses matrix-matrix",
       "            multiply to update the far-from-diagonal matrix entries,",
       "            and takes advantage of 2-by-2 block structure during",
       "            matrix multiplies."],
     "N"=>
      ["[in]",
       "         N is integer scalar",
       "            N is the order of the Hessenberg matrix H upon which this",
       "            subroutine operates."],
     "KTOP"=>["[in]", "         KTOP is integer scalar"],
     "KBOT"=>
      ["[in]",
       "         KBOT is integer scalar",
       "            These are the first and last rows and columns of an",
       "            isolated diagonal block upon which the QR sweep is to be",
       "            applied. It is assumed without a check that",
       "                      either KTOP = 1  or   H(KTOP,KTOP-1) = 0",
       "            and",
       "                      either KBOT = N  or   H(KBOT+1,KBOT) = 0."],
     "NSHFTS"=>
      ["[in]",
       "         NSHFTS is integer scalar",
       "            NSHFTS gives the number of simultaneous shifts.  NSHFTS",
       "            must be positive and even."],
     "SR"=>["[in,out]", "         SR is REAL array of size (NSHFTS)"],
     "SI"=>
      ["[in,out]",
       "         SI is REAL array of size (NSHFTS)",
       "            SR contains the real parts and SI contains the imaginary",
       "            parts of the NSHFTS shifts of origin that define the",
       "            multi-shift QR sweep.  On output SR and SI may be",
       "            reordered."],
     "H"=>
      ["[in,out]",
       "         H is REAL array of size (LDH,N)",
       "            On input H contains a Hessenberg matrix.  On output a",
       "            multi-shift QR sweep with shifts SR(J)+i*SI(J) is applied",
       "            to the isolated diagonal block in rows and columns KTOP",
       "            through KBOT."],
     "LDH"=>
      ["[in]",
       "         LDH is integer scalar",
       "            LDH is the leading dimension of H just as declared in the",
       "            calling procedure.  LDH.GE.MAX(1,N)."],
     "ILOZ"=>["[in]", "         ILOZ is INTEGER"],
     "IHIZ"=>
      ["[in]",
       "         IHIZ is INTEGER",
       "            Specify the rows of Z to which transformations must be",
       "            applied if WANTZ is .TRUE.. 1 .LE. ILOZ .LE. IHIZ .LE. N"],
     "Z"=>
      ["[in,out]",
       "         Z is REAL array of size (LDZ,IHIZ)",
       "            If WANTZ = .TRUE., then the QR Sweep orthogonal",
       "            similarity transformation is accumulated into",
       "            Z(ILOZ:IHIZ,ILOZ:IHIZ) from the right.",
       "            If WANTZ = .FALSE., then Z is unreferenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is integer scalar",
       "            LDA is the leading dimension of Z just as declared in",
       "            the calling procedure. LDZ.GE.N."],
     "V"=>["[out]", "         V is REAL array of size (LDV,NSHFTS/2)"],
     "LDV"=>
      ["[in]",
       "         LDV is integer scalar",
       "            LDV is the leading dimension of V as declared in the",
       "            calling procedure.  LDV.GE.3."],
     "U"=>
      ["[out]",
       "         U is REAL array of size",
       "            (LDU,3*NSHFTS-3)"],
     "LDU"=>
      ["[in]",
       "         LDU is integer scalar",
       "            LDU is the leading dimension of U just as declared in the",
       "            in the calling subroutine.  LDU.GE.3*NSHFTS-3."],
     "NH"=>
      ["[in]",
       "         NH is integer scalar",
       "            NH is the number of columns in array WH available for",
       "            workspace. NH.GE.1."],
     "WH"=>["[out]", "         WH is REAL array of size (LDWH,NH)"],
     "LDWH"=>
      ["[in]",
       "         LDWH is integer scalar",
       "            Leading dimension of WH just as declared in the",
       "            calling procedure.  LDWH.GE.3*NSHFTS-3."],
     "NV"=>
      ["[in]",
       "         NV is integer scalar",
       "            NV is the number of rows in WV agailable for workspace.",
       "            NV.GE.1."],
     "WV"=>
      ["[out]",
       "         WV is REAL array of size",
       "            (LDWV,3*NSHFTS-3)"],
     "LDWV"=>
      ["[in]",
       "         LDWV is integer scalar",
       "            LDWV is the leading dimension of WV as declared in the",
       "            in the calling subroutine.  LDWV.GE.NV."]}},
 "dlasq6"=>
  {"summary"=>
    ["DLASQ6 computes one dqd (shift equal to zero) transform in",
     "ping-pong form, with protection against underflow and overflow."],
   "param"=>
    {"I0"=>["[in]", "         I0 is INTEGER", "       First index."],
     "N0"=>["[in]", "         N0 is INTEGER", "       Last index."],
     "Z"=>
      ["[in]",
       "         Z is DOUBLE PRECISION array, dimension ( 4*N )",
       "       Z holds the qd array. EMIN is stored in Z(4*N0) to avoid",
       "       an extra argument."],
     "PP"=>
      ["[in]",
       "         PP is INTEGER",
       "       PP=0 for ping, PP=1 for pong."],
     "DMIN"=>
      ["[out]",
       "         DMIN is DOUBLE PRECISION",
       "       Minimum value of d."],
     "DMIN1"=>
      ["[out]",
       "         DMIN1 is DOUBLE PRECISION",
       "       Minimum value of d, excluding D( N0 )."],
     "DMIN2"=>
      ["[out]",
       "         DMIN2 is DOUBLE PRECISION",
       "       Minimum value of d, excluding D( N0 ) and D( N0-1 )."],
     "DN"=>
      ["[out]",
       "         DN is DOUBLE PRECISION",
       "       d(N0), the last value of d."],
     "DNM1"=>["[out]", "         DNM1 is DOUBLE PRECISION", "       d(N0-1)."],
     "DNM2"=>
      ["[out]", "         DNM2 is DOUBLE PRECISION", "       d(N0-2)."]}},
 "claed0"=>
  {"summary"=>
    ["Using the divide and conquer method, CLAED0 computes all eigenvalues",
     "of a symmetric tridiagonal matrix which is one diagonal block of",
     "those from reducing a dense or band Hermitian matrix and",
     "corresponding eigenvectors of the dense or band matrix."],
   "param"=>
    {"QSIZ"=>
      ["[in]",
       "         QSIZ is INTEGER",
       "        The dimension of the unitary matrix used to reduce",
       "        the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The dimension of the symmetric tridiagonal matrix.  N >= 0."],
     "D"=>
      ["[in,out]",
       "         D is REAL array, dimension (N)",
       "        On entry, the diagonal elements of the tridiagonal matrix.",
       "        On exit, the eigenvalues in ascending order."],
     "E"=>
      ["[in,out]",
       "         E is REAL array, dimension (N-1)",
       "        On entry, the off-diagonal elements of the tridiagonal matrix.",
       "        On exit, E has been destroyed."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX array, dimension (LDQ,N)",
       "        On entry, Q must contain an QSIZ x N matrix whose columns",
       "        unitarily orthonormal. It is a part of the unitary matrix",
       "        that reduces the full dense Hermitian matrix to a",
       "        (reducible) symmetric tridiagonal matrix."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "        The leading dimension of the array Q.  LDQ >= max(1,N)."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array,",
       "        the dimension of IWORK must be at least",
       "                     6 + 6*N + 5*N*lg N",
       "                     ( lg( N ) = smallest integer k",
       "                                 such that 2^k >= N )"],
     "RWORK"=>
      ["[out]",
       "         RWORK is REAL array,",
       "                              dimension (1 + 3*N + 2*N*lg N + 3*N**2)",
       "                       ( lg( N ) = smallest integer k",
       "                                   such that 2^k >= N )"],
     "QSTORE"=>
      ["[out]",
       "         QSTORE is COMPLEX array, dimension (LDQS, N)",
       "        Used to store parts of",
       "        the eigenvector matrix when the updating matrix multiplies",
       "        take place."],
     "LDQS"=>
      ["[in]",
       "         LDQS is INTEGER",
       "        The leading dimension of the array QSTORE.",
       "        LDQS >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  The algorithm failed to compute an eigenvalue while",
       "               working on the submatrix lying in rows and columns",
       "               INFO/(N+1) through mod(INFO,N+1)."]}},
 "zhetrs2"=>
  {"summary"=>
    ["ZHETRS2 solves a system of linear equations A*X = B with a complex",
     "Hermitian matrix A using the factorization A = U*D*U**H or",
     "A = L*D*L**H computed by ZHETRF and converted by ZSYCONV."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**H;",
       "         = 'L':  Lower triangular, form is A = L*D*L**H."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by ZHETRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by ZHETRF."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zhbgv"=>
  {"summary"=>
    ["ZHBGV computes all the eigenvalues, and optionally, the eigenvectors",
     "of a complex generalized Hermitian-definite banded eigenproblem, of",
     "the form A*x=(lambda)*B*x. Here A and B are assumed to be Hermitian",
     "and banded, and B is also positive definite."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "KA"=>
      ["[in]",
       "         KA is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'. KA >= 0."],
     "KB"=>
      ["[in]",
       "         KB is INTEGER",
       "         The number of superdiagonals of the matrix B if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'. KB >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is COMPLEX*16 array, dimension (LDAB, N)",
       "         On entry, the upper or lower triangle of the Hermitian band",
       "         matrix A, stored in the first ka+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(ka+1+i-j,j) = A(i,j) for max(1,j-ka)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+ka).",
       "         On exit, the contents of AB are destroyed."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KA+1."],
     "BB"=>
      ["[in,out]",
       "         BB is COMPLEX*16 array, dimension (LDBB, N)",
       "         On entry, the upper or lower triangle of the Hermitian band",
       "         matrix B, stored in the first kb+1 rows of the array.  The",
       "         j-th column of B is stored in the j-th column of the array BB",
       "         as follows:",
       "         if UPLO = 'U', BB(kb+1+i-j,j) = B(i,j) for max(1,j-kb)<=i<=j;",
       "         if UPLO = 'L', BB(1+i-j,j)    = B(i,j) for j<=i<=min(n,j+kb).",
       "         On exit, the factor S from the split Cholesky factorization",
       "         B = S**H*S, as returned by ZPBSTF."],
     "LDBB"=>
      ["[in]",
       "         LDBB is INTEGER",
       "         The leading dimension of the array BB.  LDBB >= KB+1."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is COMPLEX*16 array, dimension (LDZ, N)",
       "         If JOBZ = 'V', then if INFO = 0, Z contains the matrix Z of",
       "         eigenvectors, with the i-th column of Z holding the",
       "         eigenvector associated with W(i). The eigenvectors are",
       "         normalized so that Z**H*B*Z = I.",
       "         If JOBZ = 'N', then Z is not referenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= N."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (N)"],
     "RWORK"=>
      ["[out]", "         RWORK is DOUBLE PRECISION array, dimension (3*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, and i is:",
       "            <= N:  the algorithm failed to converge:",
       "                   i off-diagonal elements of an intermediate",
       "                   tridiagonal form did not converge to zero;",
       "            > N:   if INFO = N + i, for 1 <= i <= N, then ZPBSTF",
       "                   returned INFO = i: B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "sgelsd"=>
  {"summary"=>
    ["SGELSD computes the minimum-norm solution to a real linear least",
     "squares problem:",
     "    minimize 2-norm(| b - A*x |)",
     "using the singular value decomposition (SVD) of A. A is an M-by-N",
     "matrix which may be rank-deficient.",
     "Several right hand side vectors b and solution vectors x can be",
     "handled in a single call; they are stored as the columns of the",
     "M-by-NRHS right hand side matrix B and the N-by-NRHS solution",
     "matrix X.",
     "The problem is solved in three steps:",
     "(1) Reduce the coefficient matrix A to bidiagonal form with",
     "    Householder transformations, reducing the original problem",
     "    into a \"bidiagonal least squares problem\" (BLS)",
     "(2) Solve the BLS using a divide and conquer approach.",
     "(3) Apply back all the Householder transformations to solve",
     "    the original least squares problem.",
     "The effective rank of A is determined by treating as zero those",
     "singular values which are less than RCOND times the largest singular",
     "value.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of A. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of A. N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrices B and X. NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, A has been destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "         On entry, the M-by-NRHS right hand side matrix B.",
       "         On exit, B is overwritten by the N-by-NRHS solution",
       "         matrix X.  If m >= n and RANK = n, the residual",
       "         sum-of-squares for the solution in the i-th column is given",
       "         by the sum of squares of elements n+1:m in that column."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >= max(1,max(M,N))."],
     "S"=>
      ["[out]",
       "         S is REAL array, dimension (min(M,N))",
       "         The singular values of A in decreasing order.",
       "         The condition number of A in the 2-norm = S(1)/S(min(m,n))."],
     "RCOND"=>
      ["[in]",
       "         RCOND is REAL",
       "         RCOND is used to determine the effective rank of A.",
       "         Singular values S(i) <= RCOND*S(1) are treated as zero.",
       "         If RCOND < 0, machine precision is used instead."],
     "RANK"=>
      ["[out]",
       "         RANK is INTEGER",
       "         The effective rank of A, i.e., the number of singular values",
       "         which are greater than RCOND*S(1)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK must be at least 1.",
       "         The exact minimum amount of workspace needed depends on M,",
       "         N and NRHS. As long as LWORK is at least",
       "             12*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS + (SMLSIZ+1)**2,",
       "         if M is greater than or equal to N or",
       "             12*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS + (SMLSIZ+1)**2,",
       "         if M is less than N, the code will execute correctly.",
       "         SMLSIZ is returned by ILAENV and is equal to the maximum",
       "         size of the subproblems at the bottom of the computation",
       "         tree (usually about 25), and",
       "            NLVL = MAX( 0, INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1 )",
       "         For good performance, LWORK should generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the array WORK and the",
       "         minimum size of the array IWORK, and returns these values as",
       "         the first entries of the WORK and IWORK arrays, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         LIWORK >= max(1, 3*MINMN*NLVL + 11*MINMN),",
       "         where MINMN = MIN( M,N ).",
       "         On exit, if INFO = 0, IWORK(1) returns the minimum LIWORK."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  the algorithm for computing the SVD failed to converge;",
       "               if INFO = i, i off-diagonal elements of an intermediate",
       "               bidiagonal form did not converge to zero."]}},
 "sla_gbamv"=>
  {"summary"=>
    ["SLA_GBAMV  performs one of the matrix-vector operations",
     "        y := alpha*abs(A)*abs(x) + beta*abs(y),",
     "   or   y := alpha*abs(A)**T*abs(x) + beta*abs(y),",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "m by n matrix.",
     "This function is primarily used in calculating error bounds.",
     "To protect against underflow during evaluation, components in",
     "the resulting vector are perturbed away from zero by (N+1)",
     "times the underflow threshold.  To prevent unnecessarily large",
     "errors for block-structure embedded in general matrices,",
     "\"symbolically\" zero components are not perturbed.  A zero",
     "entry is considered \"symbolic\" if all multiplications involved",
     "in computing that entry have at least one zero multiplicand."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is INTEGER",
       "          On entry, TRANS specifies the operation to be performed as",
       "          follows:",
       "            BLAS_NO_TRANS      y := alpha*abs(A)*abs(x) + beta*abs(y)",
       "            BLAS_TRANS         y := alpha*abs(A**T)*abs(x) + beta*abs(y)",
       "            BLAS_CONJ_TRANS    y := alpha*abs(A**T)*abs(x) + beta*abs(y)",
       "          Unchanged on exit."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "          On entry, M specifies the number of rows of the matrix A.",
       "          M must be at least zero.",
       "          Unchanged on exit."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero.",
       "          Unchanged on exit."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "          The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "          The number of superdiagonals within the band of A.  KU >= 0."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is REAL",
       "          On entry, ALPHA specifies the scalar alpha.",
       "          Unchanged on exit."],
     "AB"=>
      ["[in]",
       "         AB is REAL array of DIMENSION ( LDAB, n )",
       "          Before entry, the leading m by n part of the array AB must",
       "          contain the matrix of coefficients.",
       "          Unchanged on exit."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "          On entry, LDA specifies the first dimension of AB as declared",
       "          in the calling (sub) program. LDAB must be at least",
       "          max( 1, m ).",
       "          Unchanged on exit."],
     "X"=>
      ["[in]",
       "         X is REAL array, dimension",
       "          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.",
       "          Before entry, the incremented array X must contain the",
       "          vector x.",
       "          Unchanged on exit."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero.",
       "          Unchanged on exit."],
     "BETA"=>
      ["[in]",
       "         BETA is REAL",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input.",
       "          Unchanged on exit."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array, dimension",
       "          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'",
       "          and at least",
       "          ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.",
       "          Before entry with BETA non-zero, the incremented array Y",
       "          must contain the vector y. On exit, Y is overwritten by the",
       "          updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero.",
       "          Unchanged on exit.",
       " Level 2 Blas routine."]}},
 "slasd4"=>
  {"summary"=>
    ["This subroutine computes the square root of the I-th updated",
     "eigenvalue of a positive symmetric rank-one modification to",
     "a positive diagonal matrix whose entries are given as the squares",
     "of the corresponding entries in the array d, and that",
     "       0 <= D(i) < D(j)  for  i < j",
     "and that RHO > 0. This is arranged by the calling routine, and is",
     "no loss in generality.  The rank-one modified system is thus",
     "       diag( D ) * diag( D ) +  RHO * Z * Z_transpose.",
     "where we assume the Euclidean norm of Z is 1.",
     "The method consists of approximating the rational functions in the",
     "secular equation by simpler interpolating rational functions."],
   "param"=>
    {"N"=>
      ["[in]", "         N is INTEGER", "        The length of all arrays."],
     "I"=>
      ["[in]",
       "         I is INTEGER",
       "        The index of the eigenvalue to be computed.  1 <= I <= N."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension ( N )",
       "        The original eigenvalues.  It is assumed that they are in",
       "        order, 0 <= D(I) < D(J)  for I < J."],
     "Z"=>
      ["[in]",
       "         Z is REAL array, dimension ( N )",
       "        The components of the updating vector."],
     "DELTA"=>
      ["[out]",
       "         DELTA is REAL array, dimension ( N )",
       "        If N .ne. 1, DELTA contains (D(j) - sigma_I) in its  j-th",
       "        component.  If N = 1, then DELTA(1) = 1.  The vector DELTA",
       "        contains the information necessary to construct the",
       "        (singular) eigenvectors."],
     "RHO"=>
      ["[in]",
       "         RHO is REAL",
       "        The scalar in the symmetric updating formula."],
     "SIGMA"=>
      ["[out]",
       "         SIGMA is REAL",
       "        The computed sigma_I, the I-th updated eigenvalue."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension ( N )",
       "        If N .ne. 1, WORK contains (D(j) + sigma_I) in its  j-th",
       "        component.  If N = 1, then WORK( 1 ) = 1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "        = 0:  successful exit",
       "        > 0:  if INFO = 1, the updating process failed."]}},
 "dtptrs"=>
  {"summary"=>
    ["DTPTRS solves a triangular system of the form",
     "   A * X = B  or  A**T * X = B,",
     "where A is a triangular matrix of order N stored in packed format,",
     "and B is an N-by-NRHS matrix.  A check is made to verify that A is",
     "nonsingular."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  A is upper triangular;",
       "         = 'L':  A is lower triangular."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         Specifies the form of the system of equations:",
       "         = 'N':  A * X = B  (No transpose)",
       "         = 'T':  A**T * X = B  (Transpose)",
       "         = 'C':  A**H * X = B  (Conjugate transpose = Transpose)"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         = 'N':  A is non-unit triangular;",
       "         = 'U':  A is unit triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AP"=>
      ["[in]",
       "         AP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         The upper or lower triangular matrix A, packed columnwise in",
       "         a linear array.  The j-th column of A is stored in the array",
       "         AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, if INFO = 0, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the i-th diagonal element of A is zero,",
       "               indicating that the matrix is singular and the",
       "               solutions X have not been computed."]}},
 "sgglse"=>
  {"summary"=>
    ["SGGLSE solves the linear equality-constrained least squares (LSE)",
     "problem:",
     "        minimize || c - A*x ||_2   subject to   B*x = d",
     "where A is an M-by-N matrix, B is a P-by-N matrix, c is a given",
     "M-vector, and d is a given P-vector. It is assumed that",
     "P <= N <= M+P, and",
     "         rank(B) = P and  rank( (A) ) = N.",
     "                              ( (B) )",
     "These conditions ensure that the LSE problem has a unique solution,",
     "which is obtained using a generalized RQ factorization of the",
     "matrices (B, A) given by",
     "   B = (0 R)*Q,   A = Z*T*Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrices A and B. N >= 0."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of rows of the matrix B. 0 <= P <= N <= M+P."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the min(M,N)-by-N upper trapezoidal matrix T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,N)",
       "         On entry, the P-by-N matrix B.",
       "         On exit, the upper triangle of the subarray B(1:P,N-P+1:N)",
       "         contains the P-by-P upper triangular matrix R."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >= max(1,P)."],
     "C"=>
      ["[in,out]",
       "         C is REAL array, dimension (M)",
       "         On entry, C contains the right hand side vector for the",
       "         least squares part of the LSE problem.",
       "         On exit, the residual sum of squares for the solution",
       "         is given by the sum of squares of elements N-P+1 to M of",
       "         vector C."],
     "D"=>
      ["[in,out]",
       "         D is REAL array, dimension (P)",
       "         On entry, D contains the right hand side vector for the",
       "         constrained equation.",
       "         On exit, D is destroyed."],
     "X"=>
      ["[out]",
       "         X is REAL array, dimension (N)",
       "         On exit, X is the solution of the LSE problem."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= max(1,M+N+P).",
       "         For optimum performance LWORK >= P+min(M,N)+max(M,N)*NB,",
       "         where NB is an upper bound for the optimal blocksizes for",
       "         SGEQRF, SGERQF, SORMQR and SORMRQ.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         = 1:  the upper triangular factor R associated with B in the",
       "               generalized RQ factorization of the pair (B, A) is",
       "               singular, so that rank(B) < P; the least squares",
       "               solution could not be computed.",
       "         = 2:  the (N-P) by (N-P) part of the upper trapezoidal factor",
       "               T associated with A in the generalized RQ factorization",
       "               of the pair (B, A) is singular, so that",
       "               rank( (A) ) < N; the least squares solution could not",
       "                   ( (B) )",
       "               be computed."]}},
 "dla_gbrcond"=>
  {"summary"=>
    ["   DLA_GBRCOND Estimates the Skeel condition number of  op(A) * op2(C)",
     "   where op2 is determined by CMODE as follows",
     "   CMODE =  1    op2(C) = C",
     "   CMODE =  0    op2(C) = I",
     "   CMODE = -1    op2(C) = inv(C)",
     "   The Skeel condition number  cond(A) = norminf( |inv(A)||A| )",
     "   is computed by computing scaling factors R such that",
     "   diag(R)*A*op2(C) is row equilibrated and computing the standard",
     "   infinity-norm condition number."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "    Specifies the form of the system of equations:",
       "      = 'N':  A * X = B     (No transpose)",
       "      = 'T':  A**T * X = B  (Transpose)",
       "      = 'C':  A**H * X = B  (Conjugate Transpose = Transpose)"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "    The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "    The number of superdiagonals within the band of A.  KU >= 0."],
     "AB"=>
      ["[in]",
       "         AB is DOUBLE PRECISION array, dimension (LDAB,N)",
       "    On entry, the matrix A in band storage, in rows 1 to KL+KU+1.",
       "    The j-th column of A is stored in the j-th column of the",
       "    array AB as follows:",
       "    AB(KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+kl)"],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "    The leading dimension of the array AB.  LDAB >= KL+KU+1."],
     "AFB"=>
      ["[in]",
       "         AFB is DOUBLE PRECISION array, dimension (LDAFB,N)",
       "    Details of the LU factorization of the band matrix A, as",
       "    computed by DGBTRF.  U is stored as an upper triangular",
       "    band matrix with KL+KU superdiagonals in rows 1 to KL+KU+1,",
       "    and the multipliers used during the factorization are stored",
       "    in rows KL+KU+2 to 2*KL+KU+1."],
     "LDAFB"=>
      ["[in]",
       "         LDAFB is INTEGER",
       "    The leading dimension of the array AFB.  LDAFB >= 2*KL+KU+1."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    The pivot indices from the factorization A = P*L*U",
       "    as computed by DGBTRF; row i of the matrix was interchanged",
       "    with row IPIV(i)."],
     "CMODE"=>
      ["[in]",
       "         CMODE is INTEGER",
       "    Determines op2(C) in the formula op(A) * op2(C) as follows:",
       "    CMODE =  1    op2(C) = C",
       "    CMODE =  0    op2(C) = I",
       "    CMODE = -1    op2(C) = inv(C)"],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "    The vector C in the formula op(A) * op2(C)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "    i > 0:  The ith argument is invalid."],
     "WORK"=>
      ["[in]",
       "         WORK is DOUBLE PRECISION array, dimension (5*N).",
       "    Workspace."],
     "IWORK"=>
      ["[in]",
       "         IWORK is INTEGER array, dimension (N).",
       "    Workspace."]}},
 "slasd3"=>
  {"summary"=>
    ["SLASD3 finds all the square roots of the roots of the secular",
     "equation, as defined by the values in D and Z.  It makes the",
     "appropriate calls to SLASD4 and then updates the singular",
     "vectors by matrix multiplication.",
     "This code makes very mild assumptions about floating point",
     "arithmetic. It will work on machines with a guard digit in",
     "add/subtract, or on those binary machines without guard digits",
     "which subtract like the Cray XMP, Cray YMP, Cray C 90, or Cray 2.",
     "It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none.",
     "SLASD3 is called from SLASD1."],
   "param"=>
    {"NL"=>
      ["[in]",
       "         NL is INTEGER",
       "        The row dimension of the upper block.  NL >= 1."],
     "NR"=>
      ["[in]",
       "         NR is INTEGER",
       "        The row dimension of the lower block.  NR >= 1."],
     "SQRE"=>
      ["[in]",
       "         SQRE is INTEGER",
       "        = 0: the lower block is an NR-by-NR square matrix.",
       "        = 1: the lower block is an NR-by-(NR+1) rectangular matrix.",
       "        The bidiagonal matrix has N = NL + NR + 1 rows and",
       "        M = N + SQRE >= N columns."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "        The size of the secular equation, 1 =< K = < N."],
     "D"=>
      ["[out]",
       "         D is REAL array, dimension(K)",
       "        On exit the square roots of the roots of the secular equation,",
       "        in ascending order."],
     "Q"=>
      ["[out]",
       "         Q is REAL array,",
       "                    dimension at least (LDQ,K)."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "        The leading dimension of the array Q.  LDQ >= K."],
     "DSIGMA"=>
      ["[in,out]",
       "         DSIGMA is REAL array, dimension(K)",
       "        The first K elements of this array contain the old roots",
       "        of the deflated updating problem.  These are the poles",
       "        of the secular equation."],
     "U"=>
      ["[out]",
       "         U is REAL array, dimension (LDU, N)",
       "        The last N - K columns of this matrix contain the deflated",
       "        left singular vectors."],
     "LDU"=>
      ["[in]",
       "         LDU is INTEGER",
       "        The leading dimension of the array U.  LDU >= N."],
     "U2"=>
      ["[in]",
       "         U2 is REAL array, dimension (LDU2, N)",
       "        The first K columns of this matrix contain the non-deflated",
       "        left singular vectors for the split problem."],
     "LDU2"=>
      ["[in]",
       "         LDU2 is INTEGER",
       "        The leading dimension of the array U2.  LDU2 >= N."],
     "VT"=>
      ["[out]",
       "         VT is REAL array, dimension (LDVT, M)",
       "        The last M - K columns of VT**T contain the deflated",
       "        right singular vectors."],
     "LDVT"=>
      ["[in]",
       "         LDVT is INTEGER",
       "        The leading dimension of the array VT.  LDVT >= N."],
     "VT2"=>
      ["[in,out]",
       "         VT2 is REAL array, dimension (LDVT2, N)",
       "        The first K columns of VT2**T contain the non-deflated",
       "        right singular vectors for the split problem."],
     "LDVT2"=>
      ["[in]",
       "         LDVT2 is INTEGER",
       "        The leading dimension of the array VT2.  LDVT2 >= N."],
     "IDXC"=>
      ["[in]",
       "         IDXC is INTEGER array, dimension (N)",
       "        The permutation used to arrange the columns of U (and rows of",
       "        VT) into three groups:  the first group contains non-zero",
       "        entries only at and above (or before) NL +1; the second",
       "        contains non-zero entries only at and below (or after) NL+2;",
       "        and the third is dense. The first column of U and the row of",
       "        VT are treated separately, however.",
       "        The rows of the singular vectors found by SLASD4",
       "        must be likewise permuted before the matrix multiplies can",
       "        take place."],
     "CTOT"=>
      ["[in]",
       "         CTOT is INTEGER array, dimension (4)",
       "        A count of the total number of the various types of columns",
       "        in U (or rows in VT), as described in IDXC. The fourth column",
       "        type is any column which has been deflated."],
     "Z"=>
      ["[in,out]",
       "         Z is REAL array, dimension (K)",
       "        The first K elements of this array contain the components",
       "        of the deflation-adjusted updating row vector."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "        = 0:  successful exit.",
       "        < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "        > 0:  if INFO = 1, a singular value did not converge"]}},
 "sorgbr"=>
  {"summary"=>
    ["SORGBR generates one of the real orthogonal matrices Q or P**T",
     "determined by SGEBRD when reducing a real matrix A to bidiagonal",
     "form: A = Q * B * P**T.  Q and P**T are defined as products of",
     "elementary reflectors H(i) or G(i) respectively.",
     "If VECT = 'Q', A is assumed to have been an M-by-K matrix, and Q",
     "is of order M:",
     "if m >= k, Q = H(1) H(2) . . . H(k) and SORGBR returns the first n",
     "columns of Q, where m >= n >= k;",
     "if m < k, Q = H(1) H(2) . . . H(m-1) and SORGBR returns Q as an",
     "M-by-M matrix.",
     "If VECT = 'P', A is assumed to have been a K-by-N matrix, and P**T",
     "is of order N:",
     "if k < n, P**T = G(k) . . . G(2) G(1) and SORGBR returns the first m",
     "rows of P**T, where n >= m >= k;",
     "if k >= n, P**T = G(n-1) . . . G(2) G(1) and SORGBR returns P**T as",
     "an N-by-N matrix."],
   "param"=>
    {"VECT"=>
      ["[in]",
       "         VECT is CHARACTER*1",
       "         Specifies whether the matrix Q or the matrix P**T is",
       "         required, as defined in the transformation applied by SGEBRD:",
       "         = 'Q':  generate Q;",
       "         = 'P':  generate P**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix Q or P**T to be returned.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix Q or P**T to be returned.",
       "         N >= 0.",
       "         If VECT = 'Q', M >= N >= min(M,K);",
       "         if VECT = 'P', N >= M >= min(N,K)."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         If VECT = 'Q', the number of columns in the original M-by-K",
       "         matrix reduced by SGEBRD.",
       "         If VECT = 'P', the number of rows in the original K-by-N",
       "         matrix reduced by SGEBRD.",
       "         K >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the vectors which define the elementary reflectors,",
       "         as returned by SGEBRD.",
       "         On exit, the M-by-N matrix Q or P**T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,M)."],
     "TAU"=>
      ["[in]",
       "         TAU is REAL array, dimension",
       "                               (min(M,K)) if VECT = 'Q'",
       "                               (min(N,K)) if VECT = 'P'",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i) or G(i), which determines Q or P**T, as",
       "         returned by SGEBRD in its array argument TAUQ or TAUP."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= max(1,min(M,N)).",
       "         For optimum performance LWORK >= min(M,N)*NB, where NB",
       "         is the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dlaneg"=>
  {"summary"=>
    ["DLANEG computes the Sturm count, the number of negative pivots",
     "encountered while factoring tridiagonal T - sigma I = L D L^T.",
     "This implementation works directly on the factors without forming",
     "the tridiagonal matrix T.  The Sturm count is also the number of",
     "eigenvalues of T less than sigma.",
     "This routine is called from DLARRB.",
     "The current routine does not use the PIVMIN parameter but rather",
     "requires IEEE-754 propagation of Infinities and NaNs.  This",
     "routine also has no input range restrictions but does require",
     "default exception handling such that x/0 produces Inf when x is",
     "non-zero, and Inf/Inf produces NaN.  For more information, see:",
     "  Marques, Riedy, and Voemel, \"Benefits of IEEE-754 Features in",
     "  Modern Symmetric Tridiagonal Eigensolvers,\" SIAM Journal on",
     "  Scientific Computing, v28, n5, 2006.  DOI 10.1137/050641624",
     "  (Tech report version in LAWN 172 with the same title.)"],
   "param"=>
    {"N"=>
      ["[in]", "         N is INTEGER", "         The order of the matrix."],
     "D"=>
      ["[in]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         The N diagonal elements of the diagonal matrix D."],
     "LLD"=>
      ["[in]",
       "         LLD is DOUBLE PRECISION array, dimension (N-1)",
       "         The (N-1) elements L(i)*L(i)*D(i)."],
     "SIGMA"=>
      ["[in]",
       "         SIGMA is DOUBLE PRECISION",
       "         Shift amount in T - sigma I = L D L^T."],
     "PIVMIN"=>
      ["[in]",
       "         PIVMIN is DOUBLE PRECISION",
       "         The minimum pivot in the Sturm sequence.  May be used",
       "         when zero pivots are encountered on non-IEEE-754",
       "         architectures."],
     "R"=>
      ["[in]",
       "         R is INTEGER",
       "         The twist index for the twisted factorization that is used",
       "         for the negcount."]}},
 "dlantb"=>
  {"summary"=>
    ["DLANTB  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the element of  largest absolute value  of an",
     "n by n triangular band matrix A,  with ( k + 1 ) diagonals.",
     "   DLANTB = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in DLANTB as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the matrix A is upper or lower triangular.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         Specifies whether or not the matrix A is unit triangular.",
       "         = 'N':  Non-unit triangular",
       "         = 'U':  Unit triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, DLANTB is",
       "         set to zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of super-diagonals of the matrix A if UPLO = 'U',",
       "         or the number of sub-diagonals of the matrix A if UPLO = 'L'.",
       "         K >= 0."],
     "AB"=>
      ["[in]",
       "         AB is DOUBLE PRECISION array, dimension (LDAB,N)",
       "         The upper or lower triangular band matrix A, stored in the",
       "         first k+1 rows of AB.  The j-th column of A is stored",
       "         in the j-th column of the array AB as follows:",
       "         if UPLO = 'U', AB(k+1+i-j,j) = A(i,j) for max(1,j-k)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)   = A(i,j) for j<=i<=min(n,j+k).",
       "         Note that when DIAG = 'U', the elements of the array AB",
       "         corresponding to the diagonal elements of the matrix A are",
       "         not referenced, but are assumed to be one."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= K+1."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I'; otherwise, WORK is not",
       "         referenced."]}},
 "zlasyf"=>
  {"summary"=>
    ["ZLASYF computes a partial factorization of a complex symmetric matrix",
     "A using the Bunch-Kaufman diagonal pivoting method. The partial",
     "factorization has the form:",
     "A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:",
     "      ( 0  U22 ) (  0   D  ) ( U12**T U22**T )",
     "A  =  ( L11  0 ) ( D    0  ) ( L11**T L21**T )  if UPLO = 'L'",
     "      ( L21  I ) ( 0   A22 ) (  0       I    )",
     "where the order of D is at most NB. The actual order is returned in",
     "the argument KB, and is either NB or NB-1, or N if N <= NB.",
     "Note that U**T denotes the transpose of U.",
     "ZLASYF is an auxiliary routine called by ZSYTRF. It uses blocked code",
     "(calling Level 3 BLAS) to update the submatrix A11 (if UPLO = 'U') or",
     "A22 (if UPLO = 'L')."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The maximum number of columns of the matrix A that should be",
       "         factored.  NB should be at least 2 to allow for 2-by-2 pivot",
       "         blocks."],
     "KB"=>
      ["[out]",
       "         KB is INTEGER",
       "         The number of columns of A that were actually factored.",
       "         KB is either NB-1 or NB, or N if N <= NB."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         n-by-n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n-by-n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, A contains details of the partial factorization."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If UPLO = 'U':",
       "            Only the last KB elements of IPIV are set.",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k-1) < 0, then rows and columns",
       "            k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "            is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "            Only the first KB elements of IPIV are set.",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k+1) < 0, then rows and columns",
       "            k+1 and -IPIV(k) were interchanged and D(k:k+1,k:k+1)",
       "            is a 2-by-2 diagonal block."],
     "W"=>["[out]", "         W is COMPLEX*16 array, dimension (LDW,NB)"],
     "LDW"=>
      ["[in]",
       "         LDW is INTEGER",
       "         The leading dimension of the array W.  LDW >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         > 0: if INFO = k, D(k,k) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular."]}},
 "dsycon"=>
  {"summary"=>
    ["DSYCON estimates the reciprocal of the condition number (in the",
     "1-norm) of a real symmetric matrix A using the factorization",
     "A = U*D*U**T or A = L*D*L**T computed by DSYTRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by DSYTRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by DSYTRF."],
     "ANORM"=>
      ["[in]",
       "         ANORM is DOUBLE PRECISION",
       "         The 1-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is DOUBLE PRECISION",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an",
       "         estimate of the 1-norm of inv(A) computed in this routine."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (2*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "sgeequ"=>
  {"summary"=>
    ["SGEEQU computes row and column scalings intended to equilibrate an",
     "M-by-N matrix A and reduce its condition number.  R returns the row",
     "scale factors and C the column scale factors, chosen to try to make",
     "the largest element in each row and column of the matrix B with",
     "elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.",
     "R(i) and C(j) are restricted to be between SMLNUM = smallest safe",
     "number and BIGNUM = largest safe number.  Use of these scaling",
     "factors is not guaranteed to reduce the condition number of A but",
     "works well in practice."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "         The M-by-N matrix whose equilibration factors are",
       "         to be computed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "R"=>
      ["[out]",
       "         R is REAL array, dimension (M)",
       "         If INFO = 0 or INFO > M, R contains the row scale factors",
       "         for A."],
     "C"=>
      ["[out]",
       "         C is REAL array, dimension (N)",
       "         If INFO = 0,  C contains the column scale factors for A."],
     "ROWCND"=>
      ["[out]",
       "         ROWCND is REAL",
       "         If INFO = 0 or INFO > M, ROWCND contains the ratio of the",
       "         smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and",
       "         AMAX is neither too large nor too small, it is not worth",
       "         scaling by R."],
     "COLCND"=>
      ["[out]",
       "         COLCND is REAL",
       "         If INFO = 0, COLCND contains the ratio of the smallest",
       "         C(i) to the largest C(i).  If COLCND >= 0.1, it is not",
       "         worth scaling by C."],
     "AMAX"=>
      ["[out]",
       "         AMAX is REAL",
       "         Absolute value of largest matrix element.  If AMAX is very",
       "         close to overflow or very close to underflow, the matrix",
       "         should be scaled."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i,  and i is",
       "               <= M:  the i-th row of A is exactly zero",
       "               >  M:  the (i-M)-th column of A is exactly zero"]}},
 "zunmrq"=>
  {"summary"=>
    ["ZUNMRQ overwrites the general complex M-by-N matrix C with",
     "                SIDE = 'L'     SIDE = 'R'",
     "TRANS = 'N':      Q * C          C * Q",
     "TRANS = 'C':      Q**H * C       C * Q**H",
     "where Q is a complex unitary matrix defined as the product of k",
     "elementary reflectors",
     "      Q = H(1)**H H(2)**H . . . H(k)**H",
     "as returned by ZGERQF. Q is of order M if SIDE = 'L' and of order N",
     "if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**H from the Left;",
       "         = 'R': apply Q or Q**H from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'C':  Transpose, apply Q**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension",
       "                              (LDA,M) if SIDE = 'L',",
       "                              (LDA,N) if SIDE = 'R'",
       "         The i-th row must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         ZGERQF in the last k rows of its array argument A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,K)."],
     "TAU"=>
      ["[in]",
       "         TAU is COMPLEX*16 array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by ZGERQF."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**H*C or C*Q**H or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If SIDE = 'L', LWORK >= max(1,N);",
       "         if SIDE = 'R', LWORK >= max(1,M).",
       "         For good performance, LWORK should generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cspcon"=>
  {"summary"=>
    ["CSPCON estimates the reciprocal of the condition number (in the",
     "1-norm) of a complex symmetric packed matrix A using the",
     "factorization A = U*D*U**T or A = L*D*L**T computed by CSPTRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by CSPTRF, stored as a",
       "         packed triangular matrix."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by CSPTRF."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         The 1-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an",
       "         estimate of the 1-norm of inv(A) computed in this routine."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (2*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "ssytrf_rook"=>
  {"summary"=>
    ["SSYTRF_ROOK computes the factorization of a real symmetric matrix A",
     "using the bounded Bunch-Kaufman (\"rook\") diagonal pivoting method.",
     "The form of the factorization is",
     "   A = U*D*U**T  or  A = L*D*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and D is symmetric and block diagonal with",
     "1-by-1 and 2-by-2 diagonal blocks.",
     "This is the blocked version of the algorithm, calling Level 3 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L (see below for further details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If UPLO = 'U':",
       "              If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "              were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) < 0 and IPIV(k-1) < 0, then rows and",
       "              columns k and -IPIV(k) were interchanged and rows and",
       "              columns k-1 and -IPIV(k-1) were inerchaged,",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "              If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "              were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) < 0 and IPIV(k+1) < 0, then rows and",
       "              columns k and -IPIV(k) were interchanged and rows and",
       "              columns k+1 and -IPIV(k+1) were inerchaged,",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)).",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >=1.  For best performance",
       "         LWORK >= N*NB, where NB is the block size returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, and division by zero will occur if it",
       "               is used to solve a system of equations."]}},
 "clahef_aa"=>
  {"summary"=>
    ["CLAHEF_AA factorizes a panel of a complex hermitian matrix A using",
     "the Aasen's algorithm. The panel consists of a set of NB rows of A",
     "when UPLO is U, or a set of NB columns when UPLO is L.",
     "In order to factorize the panel, the Aasen's algorithm requires the",
     "last row, or column, of the previous panel. The first row, or column,",
     "of A is set to be the first row, or column, of an identity matrix,",
     "which is used to factorize the first panel.",
     "The resulting J-th row of U, or J-th column of L, is stored in the",
     "(J-1)-th row, or column, of A (without the unit diagonals), while",
     "the diagonal and subdiagonal of A are overwritten by those of T."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "J1"=>
      ["[in]",
       "         J1 is INTEGER",
       "         The location of the first row, or column, of the panel",
       "         within the submatrix of A, passed to this routine, e.g.,",
       "         when called by CHETRF_AA, for the first panel, J1 is 1,",
       "         while for the remaining panels, J1 is 2."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The dimension of the submatrix. M >= 0."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The dimension of the panel to be facotorized."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,M) for",
       "         the first panel, while dimension (LDA,M+1) for the",
       "         remaining panels.",
       "         On entry, A contains the last row, or column, of",
       "         the previous panel, and the trailing submatrix of A",
       "         to be factorized, except for the first panel, only",
       "         the panel is passed.",
       "         On exit, the leading panel is factorized."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the row and column interchanges,",
       "         the row and column k were interchanged with the row and",
       "         column IPIV(k)."],
     "H"=>["[in,out]", "         H is COMPLEX workspace, dimension (LDH,NB)."],
     "LDH"=>
      ["[in]",
       "         LDH is INTEGER",
       "         The leading dimension of the workspace H. LDH >= max(1,M)."],
     "WORK"=>["[out]", "         WORK is COMPLEX workspace, dimension (M)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, and division by zero will occur if it",
       "               is used to solve a system of equations."]}},
 "strexc"=>
  {"summary"=>
    ["STREXC reorders the real Schur factorization of a real matrix",
     "A = Q*T*Q**T, so that the diagonal block of T with row index IFST is",
     "moved to row ILST.",
     "The real Schur form T is reordered by an orthogonal similarity",
     "transformation Z**T*T*Z, and optionally the matrix Q of Schur vectors",
     "is updated by postmultiplying it with Z.",
     "T must be in Schur canonical form (as returned by SHSEQR), that is,",
     "block upper triangular with 1-by-1 and 2-by-2 diagonal blocks; each",
     "2-by-2 diagonal block has its diagonal elements equal and its",
     "off-diagonal elements of opposite sign."],
   "param"=>
    {"COMPQ"=>
      ["[in]",
       "         COMPQ is CHARACTER*1",
       "         = 'V':  update the matrix Q of Schur vectors;",
       "         = 'N':  do not update Q."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix T. N >= 0.",
       "         If N == 0 arguments ILST and IFST may be any value."],
     "T"=>
      ["[in,out]",
       "         T is REAL array, dimension (LDT,N)",
       "         On entry, the upper quasi-triangular matrix T, in Schur",
       "         Schur canonical form.",
       "         On exit, the reordered upper quasi-triangular matrix, again",
       "         in Schur canonical form."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T. LDT >= max(1,N)."],
     "Q"=>
      ["[in,out]",
       "         Q is REAL array, dimension (LDQ,N)",
       "         On entry, if COMPQ = 'V', the matrix Q of Schur vectors.",
       "         On exit, if COMPQ = 'V', Q has been postmultiplied by the",
       "         orthogonal transformation matrix Z which reorders T.",
       "         If COMPQ = 'N', Q is not referenced."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.  LDQ >= 1, and if",
       "         COMPQ = 'V', LDQ >= max(1,N)."],
     "IFST"=>["[in,out]", "         IFST is INTEGER"],
     "ILST"=>
      ["[in,out]",
       "         ILST is INTEGER",
       "         Specify the reordering of the diagonal blocks of T.",
       "         The block with row index IFST is moved to row ILST, by a",
       "         sequence of transpositions between adjacent blocks.",
       "         On exit, if IFST pointed on entry to the second row of a",
       "         2-by-2 block, it is changed to point to the first row; ILST",
       "         always points to the first row of the block in its final",
       "         position (which may differ from its input value by +1 or -1).",
       "         1 <= IFST <= N; 1 <= ILST <= N."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         = 1:  two adjacent blocks were too close to swap (the problem",
       "               is very ill-conditioned); T may have been partially",
       "               reordered, and ILST points to the first row of the",
       "               current position of the block being moved."]}},
 "zgetri"=>
  {"summary"=>
    ["ZGETRI computes the inverse of a matrix using the LU factorization",
     "computed by ZGETRF.",
     "This method inverts U and then computes inv(A) by solving the system",
     "inv(A)*L = inv(U) for inv(A)."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the factors L and U from the factorization",
       "         A = P*L*U as computed by ZGETRF.",
       "         On exit, if INFO = 0, the inverse of the original matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices from ZGETRF; for 1<=i<=N, row i of the",
       "         matrix was interchanged with row IPIV(i)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO=0, then WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,N).",
       "         For optimal performance LWORK >= N*NB, where NB is",
       "         the optimal blocksize returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is",
       "               singular and its inverse could not be computed."]}},
 "dsysv_rook"=>
  {"summary"=>
    ["DSYSV_ROOK computes the solution to a real system of linear",
     "equations",
     "   A * X = B,",
     "where A is an N-by-N symmetric matrix and X and B are N-by-NRHS",
     "matrices.",
     "The diagonal pivoting method is used to factor A as",
     "   A = U * D * U**T,  if UPLO = 'U', or",
     "   A = L * D * L**T,  if UPLO = 'L',",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and D is symmetric and block diagonal with",
     "1-by-1 and 2-by-2 diagonal blocks.",
     "DSYTRF_ROOK is called to compute the factorization of a real",
     "symmetric matrix A using the bounded Bunch-Kaufman (\"rook\") diagonal",
     "pivoting method.",
     "The factored form of A is then used to solve the system",
     "of equations A * X = B by calling DSYTRS_ROOK."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of linear equations, i.e., the order of the",
       "         matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if INFO = 0, the block diagonal matrix D and the",
       "         multipliers used to obtain the factor U or L from the",
       "         factorization A = U*D*U**T or A = L*D*L**T as computed by",
       "         DSYTRF_ROOK."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D,",
       "         as determined by DSYTRF_ROOK.",
       "         If UPLO = 'U':",
       "              If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "              were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) < 0 and IPIV(k-1) < 0, then rows and",
       "              columns k and -IPIV(k) were interchanged and rows and",
       "              columns k-1 and -IPIV(k-1) were inerchaged,",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "              If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "              were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) < 0 and IPIV(k+1) < 0, then rows and",
       "              columns k and -IPIV(k) were interchanged and rows and",
       "              columns k+1 and -IPIV(k+1) were inerchaged,",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >= 1, and for best performance",
       "         LWORK >= max(1,N*NB), where NB is the optimal blocksize for",
       "         DSYTRF_ROOK.",
       "         TRS will be done with Level 2 BLAS",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, so the solution could not be computed."]}},
 "claset"=>
  {"summary"=>
    ["CLASET initializes a 2-D array A to BETA on the diagonal and",
     "ALPHA on the offdiagonals."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies the part of the matrix A to be set.",
       "         = 'U':      Upper triangular part is set. The lower triangle",
       "                     is unchanged.",
       "         = 'L':      Lower triangular part is set. The upper triangle",
       "                     is unchanged.",
       "         Otherwise:  All of the matrix A is set."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         On entry, M specifies the number of rows of A."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         On entry, N specifies the number of columns of A."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "         All the offdiagonal array elements are set to ALPHA."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "         All the diagonal array elements are set to BETA."],
     "A"=>
      ["[out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the m by n matrix A.",
       "         On exit, A(i,j) = ALPHA, 1 <= i <= m, 1 <= j <= n, i.ne.j;",
       "                  A(i,i) = BETA , 1 <= i <= min(m,n)"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."]}},
 "ieeeck"=>
  {"summary"=>
    ["IEEECK is called from the ILAENV to verify that Infinity and",
     "possibly NaN arithmetic is safe (i.e. will not trap)."],
   "param"=>
    {"ISPEC"=>
      ["[in]",
       "         ISPEC is INTEGER",
       "         Specifies whether to test just for inifinity arithmetic",
       "         or whether to test for infinity and NaN arithmetic.",
       "         = 0: Verify infinity arithmetic only.",
       "         = 1: Verify infinity and NaN arithmetic."],
     "ZERO"=>
      ["[in]",
       "         ZERO is REAL",
       "         Must contain the value 0.0",
       "         This is passed to prevent the compiler from optimizing",
       "         away this code."],
     "ONE"=>
      ["[in]",
       "         ONE is REAL",
       "         Must contain the value 1.0",
       "         This is passed to prevent the compiler from optimizing",
       "         away this code.",
       " RETURN VALUE:  INTEGER",
       "         = 0:  Arithmetic failed to produce the correct answers",
       "         = 1:  Arithmetic produced the correct answers"]}},
 "sgerfsx"=>
  {"summary"=>
    ["   SGERFSX improves the computed solution to a system of linear",
     "   equations and provides error bounds and backward error estimates",
     "   for the solution.  In addition to normwise error bound, the code",
     "   provides maximum componentwise error bound if possible.  See",
     "   comments for ERR_BNDS_NORM and ERR_BNDS_COMP for details of the",
     "   error bounds.",
     "   The original system of linear equations may have been equilibrated",
     "   before calling this routine, as described by arguments EQUED, R",
     "   and C below. In this case, the solution and error bounds returned",
     "   are for the original unequilibrated system.",
     "    Some optional parameters are bundled in the PARAMS array.  These",
     "    settings determine how refinement is performed, but often the",
     "    defaults are acceptable.  If the defaults are acceptable, users",
     "    can pass NPARAMS = 0 which prevents the source code from accessing",
     "    the PARAMS argument."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "    Specifies the form of the system of equations:",
       "      = 'N':  A * X = B     (No transpose)",
       "      = 'T':  A**T * X = B  (Transpose)",
       "      = 'C':  A**H * X = B  (Conjugate transpose = Transpose)"],
     "EQUED"=>
      ["[in]",
       "         EQUED is CHARACTER*1",
       "    Specifies the form of equilibration that was done to A",
       "    before calling this routine. This is needed to compute",
       "    the solution and error bounds correctly.",
       "      = 'N':  No equilibration",
       "      = 'R':  Row equilibration, i.e., A has been premultiplied by",
       "              diag(R).",
       "      = 'C':  Column equilibration, i.e., A has been postmultiplied",
       "              by diag(C).",
       "      = 'B':  Both row and column equilibration, i.e., A has been",
       "              replaced by diag(R) * A * diag(C).",
       "              The right hand side B has been changed accordingly."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "    The number of right hand sides, i.e., the number of columns",
       "    of the matrices B and X.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "    The original N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is REAL array, dimension (LDAF,N)",
       "    The factors L and U from the factorization A = P*L*U",
       "    as computed by SGETRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    The pivot indices from SGETRF; for 1<=i<=N, row i of the",
       "    matrix was interchanged with row IPIV(i)."],
     "R"=>
      ["[in]",
       "         R is REAL array, dimension (N)",
       "    The row scale factors for A.  If EQUED = 'R' or 'B', A is",
       "    multiplied on the left by diag(R); if EQUED = 'N' or 'C', R",
       "    is not accessed.",
       "    If R is accessed, each element of R should be a power of the radix",
       "    to ensure a reliable solution and error estimates. Scaling by",
       "    powers of the radix does not cause rounding errors unless the",
       "    result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension (N)",
       "    The column scale factors for A.  If EQUED = 'C' or 'B', A is",
       "    multiplied on the right by diag(C); if EQUED = 'N' or 'R', C",
       "    is not accessed.",
       "    If C is accessed, each element of C should be a power of the radix",
       "    to ensure a reliable solution and error estimates. Scaling by",
       "    powers of the radix does not cause rounding errors unless the",
       "    result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "B"=>
      ["[in]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "    The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "    The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is REAL array, dimension (LDX,NRHS)",
       "    On entry, the solution matrix X, as computed by SGETRS.",
       "    On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "    The leading dimension of the array X.  LDX >= max(1,N)."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "    Reciprocal scaled condition number.  This is an estimate of the",
       "    reciprocal Skeel condition number of the matrix A after",
       "    equilibration (if done).  If this is less than the machine",
       "    precision (in particular, if it is zero), the matrix is singular",
       "    to working precision.  Note that the error may still be small even",
       "    if this number is very small and the matrix appears ill-",
       "    conditioned."],
     "BERR"=>
      ["[out]",
       "         BERR is REAL array, dimension (NRHS)",
       "    Componentwise relative backward error.  This is the",
       "    componentwise relative backward error of each solution vector X(j)",
       "    (i.e., the smallest relative change in any element of A or B that",
       "    makes X(j) an exact solution)."],
     "N_ERR_BNDS"=>
      ["[in]",
       "         N_ERR_BNDS is INTEGER",
       "    Number of error bounds to return for each right hand side",
       "    and each type (normwise or componentwise).  See ERR_BNDS_NORM and",
       "    ERR_BNDS_COMP below."],
     "ERR_BNDS_NORM"=>
      ["[out]",
       "         ERR_BNDS_NORM is REAL array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    normwise relative error, which is defined as follows:",
       "    Normwise relative error in the ith solution vector:",
       "            max_j (abs(XTRUE(j,i) - X(j,i)))",
       "           ------------------------------",
       "                 max_j abs(X(j,i))",
       "    The array is indexed by the type of error information as described",
       "    below. There currently are up to three pieces of information",
       "    returned.",
       "    The first index in ERR_BNDS_NORM(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_NORM(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated normwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*A, where S scales each row by a power of the",
       "             radix so all absolute row sums of Z are approximately 1.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "ERR_BNDS_COMP"=>
      ["[out]",
       "         ERR_BNDS_COMP is REAL array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    componentwise relative error, which is defined as follows:",
       "    Componentwise relative error in the ith solution vector:",
       "                   abs(XTRUE(j,i) - X(j,i))",
       "            max_j ----------------------",
       "                        abs(X(j,i))",
       "    The array is indexed by the right-hand side i (on which the",
       "    componentwise relative error depends), and the type of error",
       "    information as described below. There currently are up to three",
       "    pieces of information returned for each right-hand side. If",
       "    componentwise accuracy is not requested (PARAMS(3) = 0.0), then",
       "    ERR_BNDS_COMP is not accessed.  If N_ERR_BNDS .LT. 3, then at most",
       "    the first (:,N_ERR_BNDS) entries are returned.",
       "    The first index in ERR_BNDS_COMP(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_COMP(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated componentwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*(A*diag(x)), where x is the solution for the",
       "             current right-hand side and S scales each row of",
       "             A*diag(x) by a power of the radix so all absolute row",
       "             sums of Z are approximately 1.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "NPARAMS"=>
      ["[in]",
       "         NPARAMS is INTEGER",
       "    Specifies the number of parameters set in PARAMS.  If .LE. 0, the",
       "    PARAMS array is never referenced and default values are used."],
     "PARAMS"=>
      ["[in,out]",
       "         PARAMS is REAL array, dimension NPARAMS",
       "    Specifies algorithm parameters.  If an entry is .LT. 0.0, then",
       "    that entry will be filled with default value used for that",
       "    parameter.  Only positions up to NPARAMS are accessed; defaults",
       "    are used for higher-numbered parameters.",
       "      PARAMS(LA_LINRX_ITREF_I = 1) : Whether to perform iterative",
       "           refinement or not.",
       "        Default: 1.0",
       "           = 0.0 : No refinement is performed, and no error bounds are",
       "                   computed.",
       "           = 1.0 : Use the double-precision refinement algorithm,",
       "                   possibly with doubled-single computations if the",
       "                   compilation environment does not support DOUBLE",
       "                   PRECISION.",
       "             (other values are reserved for future use)",
       "      PARAMS(LA_LINRX_ITHRESH_I = 2) : Maximum number of residual",
       "           computations allowed for refinement.",
       "        Default: 10",
       "        Aggressive: Set to 100 to permit convergence using approximate",
       "                    factorizations or factorizations other than LU. If",
       "                    the factorization uses a technique other than",
       "                    Gaussian elimination, the guarantees in",
       "                    err_bnds_norm and err_bnds_comp may no longer be",
       "                    trustworthy.",
       "      PARAMS(LA_LINRX_CWISE_I = 3) : Flag determining if the code",
       "           will attempt to find a solution with small componentwise",
       "           relative error in the double-precision algorithm.  Positive",
       "           is true, 0.0 is false.",
       "        Default: 1.0 (attempt componentwise convergence)"],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (4*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit. The solution to every right-hand side is",
       "        guaranteed.",
       "      < 0:  If INFO = -i, the i-th argument had an illegal value",
       "      > 0 and <= N:  U(INFO,INFO) is exactly zero.  The factorization",
       "        has been completed, but the factor U is exactly singular, so",
       "        the solution and error bounds could not be computed. RCOND = 0",
       "        is returned.",
       "      = N+J: The solution corresponding to the Jth right-hand side is",
       "        not guaranteed. The solutions corresponding to other right-",
       "        hand sides K with K > J may not be guaranteed as well, but",
       "        only the first such right-hand side is reported. If a small",
       "        componentwise error is not requested (PARAMS(3) = 0.0) then",
       "        the Jth right-hand side is the first with a normwise error",
       "        bound that is not guaranteed (the smallest J such",
       "        that ERR_BNDS_NORM(J,1) = 0.0). By default (PARAMS(3) = 1.0)",
       "        the Jth right-hand side is the first with either a normwise or",
       "        componentwise error bound that is not guaranteed (the smallest",
       "        J such that either ERR_BNDS_NORM(J,1) = 0.0 or",
       "        ERR_BNDS_COMP(J,1) = 0.0). See the definition of",
       "        ERR_BNDS_NORM(:,1) and ERR_BNDS_COMP(:,1). To get information",
       "        about all of the right-hand sides check ERR_BNDS_NORM or",
       "        ERR_BNDS_COMP."]}},
 "sgesdd"=>
  {"summary"=>
    ["SGESDD computes the singular value decomposition (SVD) of a real",
     "M-by-N matrix A, optionally computing the left and right singular",
     "vectors.  If singular vectors are desired, it uses a",
     "divide-and-conquer algorithm.",
     "The SVD is written",
     "     A = U * SIGMA * transpose(V)",
     "where SIGMA is an M-by-N matrix which is zero except for its",
     "min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and",
     "V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA",
     "are the singular values of A; they are real and non-negative, and",
     "are returned in descending order.  The first min(m,n) columns of",
     "U and V are the left and right singular vectors of A.",
     "Note that the routine returns VT = V**T, not V.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         Specifies options for computing all or part of the matrix U:",
       "         = 'A':  all M columns of U and all N rows of V**T are",
       "                 returned in the arrays U and VT;",
       "         = 'S':  the first min(M,N) columns of U and the first",
       "                 min(M,N) rows of V**T are returned in the arrays U",
       "                 and VT;",
       "         = 'O':  If M >= N, the first N columns of U are overwritten",
       "                 on the array A and all rows of V**T are returned in",
       "                 the array VT;",
       "                 otherwise, all columns of U are returned in the",
       "                 array U and the first M rows of V**T are overwritten",
       "                 in the array A;",
       "         = 'N':  no columns of U or rows of V**T are computed."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the input matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the input matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit,",
       "         if JOBZ = 'O',  A is overwritten with the first N columns",
       "                         of U (the left singular vectors, stored",
       "                         columnwise) if M >= N;",
       "                         A is overwritten with the first M rows",
       "                         of V**T (the right singular vectors, stored",
       "                         rowwise) otherwise.",
       "         if JOBZ .ne. 'O', the contents of A are destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "S"=>
      ["[out]",
       "         S is REAL array, dimension (min(M,N))",
       "         The singular values of A, sorted so that S(i) >= S(i+1)."],
     "U"=>
      ["[out]",
       "         U is REAL array, dimension (LDU,UCOL)",
       "         UCOL = M if JOBZ = 'A' or JOBZ = 'O' and M < N;",
       "         UCOL = min(M,N) if JOBZ = 'S'.",
       "         If JOBZ = 'A' or JOBZ = 'O' and M < N, U contains the M-by-M",
       "         orthogonal matrix U;",
       "         if JOBZ = 'S', U contains the first min(M,N) columns of U",
       "         (the left singular vectors, stored columnwise);",
       "         if JOBZ = 'O' and M >= N, or JOBZ = 'N', U is not referenced."],
     "LDU"=>
      ["[in]",
       "         LDU is INTEGER",
       "         The leading dimension of the array U.  LDU >= 1; if",
       "         JOBZ = 'S' or 'A' or JOBZ = 'O' and M < N, LDU >= M."],
     "VT"=>
      ["[out]",
       "         VT is REAL array, dimension (LDVT,N)",
       "         If JOBZ = 'A' or JOBZ = 'O' and M >= N, VT contains the",
       "         N-by-N orthogonal matrix V**T;",
       "         if JOBZ = 'S', VT contains the first min(M,N) rows of",
       "         V**T (the right singular vectors, stored rowwise);",
       "         if JOBZ = 'O' and M < N, or JOBZ = 'N', VT is not referenced."],
     "LDVT"=>
      ["[in]",
       "         LDVT is INTEGER",
       "         The leading dimension of the array VT.  LDVT >= 1;",
       "         if JOBZ = 'A' or JOBZ = 'O' and M >= N, LDVT >= N;",
       "         if JOBZ = 'S', LDVT >= min(M,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK;"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= 1.",
       "         If LWORK = -1, a workspace query is assumed.  The optimal",
       "         size for the WORK array is calculated and stored in WORK(1),",
       "         and no other work except argument checking is performed.",
       "         Let mx = max(M,N) and mn = min(M,N).",
       "         If JOBZ = 'N', LWORK >= 3*mn + max( mx, 7*mn ).",
       "         If JOBZ = 'O', LWORK >= 3*mn + max( mx, 5*mn*mn + 4*mn ).",
       "         If JOBZ = 'S', LWORK >= 4*mn*mn + 7*mn.",
       "         If JOBZ = 'A', LWORK >= 4*mn*mn + 6*mn + mx.",
       "         These are not tight minimums in all cases; see comments inside code.",
       "         For good performance, LWORK should generally be larger;",
       "         a query is recommended."],
     "IWORK"=>
      ["[out]", "         IWORK is INTEGER array, dimension (8*min(M,N))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  SBDSDC did not converge, updating process failed."]}},
 "zlaqr0"=>
  {"summary"=>
    ["   ZLAQR0 computes the eigenvalues of a Hessenberg matrix H",
     "   and, optionally, the matrices T and Z from the Schur decomposition",
     "   H = Z T Z**H, where T is an upper triangular matrix (the",
     "   Schur form), and Z is the unitary matrix of Schur vectors.",
     "   Optionally Z may be postmultiplied into an input unitary",
     "   matrix Q so that this routine can give the Schur factorization",
     "   of a matrix A which has been reduced to the Hessenberg form H",
     "   by the unitary matrix Q:  A = Q*H*Q**H = (QZ)*H*(QZ)**H."],
   "param"=>
    {"WANTT"=>
      ["[in]",
       "         WANTT is LOGICAL",
       "         = .TRUE. : the full Schur form T is required;",
       "         = .FALSE.: only eigenvalues are required."],
     "WANTZ"=>
      ["[in]",
       "         WANTZ is LOGICAL",
       "         = .TRUE. : the matrix of Schur vectors Z is required;",
       "         = .FALSE.: Schur vectors are not required."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          The order of the matrix H.  N .GE. 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "          It is assumed that H is already upper triangular in rows",
       "          and columns 1:ILO-1 and IHI+1:N and, if ILO.GT.1,",
       "          H(ILO,ILO-1) is zero. ILO and IHI are normally set by a",
       "          previous call to ZGEBAL, and then passed to ZGEHRD when the",
       "          matrix output by ZGEBAL is reduced to Hessenberg form.",
       "          Otherwise, ILO and IHI should be set to 1 and N,",
       "          respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.",
       "          If N = 0, then ILO = 1 and IHI = 0."],
     "H"=>
      ["[in,out]",
       "         H is COMPLEX*16 array, dimension (LDH,N)",
       "          On entry, the upper Hessenberg matrix H.",
       "          On exit, if INFO = 0 and WANTT is .TRUE., then H",
       "          contains the upper triangular matrix T from the Schur",
       "          decomposition (the Schur form). If INFO = 0 and WANT is",
       "          .FALSE., then the contents of H are unspecified on exit.",
       "          (The output value of H when INFO.GT.0 is given under the",
       "          description of INFO below.)",
       "          This subroutine may explicitly set H(i,j) = 0 for i.GT.j and",
       "          j = 1, 2, ... ILO-1 or j = IHI+1, IHI+2, ... N."],
     "LDH"=>
      ["[in]",
       "         LDH is INTEGER",
       "          The leading dimension of the array H. LDH .GE. max(1,N)."],
     "W"=>
      ["[out]",
       "         W is COMPLEX*16 array, dimension (N)",
       "          The computed eigenvalues of H(ILO:IHI,ILO:IHI) are stored",
       "          in W(ILO:IHI). If WANTT is .TRUE., then the eigenvalues are",
       "          stored in the same order as on the diagonal of the Schur",
       "          form returned in H, with W(i) = H(i,i)."],
     "ILOZ"=>["[in]", "         ILOZ is INTEGER"],
     "IHIZ"=>
      ["[in]",
       "         IHIZ is INTEGER",
       "          Specify the rows of Z to which transformations must be",
       "          applied if WANTZ is .TRUE..",
       "          1 .LE. ILOZ .LE. ILO; IHI .LE. IHIZ .LE. N."],
     "Z"=>
      ["[in,out]",
       "         Z is COMPLEX*16 array, dimension (LDZ,IHI)",
       "          If WANTZ is .FALSE., then Z is not referenced.",
       "          If WANTZ is .TRUE., then Z(ILO:IHI,ILOZ:IHIZ) is",
       "          replaced by Z(ILO:IHI,ILOZ:IHIZ)*U where U is the",
       "          orthogonal Schur factor of H(ILO:IHI,ILO:IHI).",
       "          (The output value of Z when INFO.GT.0 is given under",
       "          the description of INFO below.)"],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "          The leading dimension of the array Z.  if WANTZ is .TRUE.",
       "          then LDZ.GE.MAX(1,IHIZ).  Otherwize, LDZ.GE.1."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension LWORK",
       "          On exit, if LWORK = -1, WORK(1) returns an estimate of",
       "          the optimal value for LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "          The dimension of the array WORK.  LWORK .GE. max(1,N)",
       "          is sufficient, but LWORK typically as large as 6*N may",
       "          be required for optimal performance.  A workspace query",
       "          to determine the optimal workspace size is recommended.",
       "          If LWORK = -1, then ZLAQR0 does a workspace query.",
       "          In this case, ZLAQR0 checks the input parameters and",
       "          estimates the optimal workspace size for the given",
       "          values of N, ILO and IHI.  The estimate is returned",
       "          in WORK(1).  No error message related to LWORK is",
       "          issued by XERBLA.  Neither H nor Z are accessed."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "            =  0:  successful exit",
       "          .GT. 0:  if INFO = i, ZLAQR0 failed to compute all of",
       "               the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR",
       "               and WI contain those eigenvalues which have been",
       "               successfully computed.  (Failures are rare.)",
       "               If INFO .GT. 0 and WANT is .FALSE., then on exit,",
       "               the remaining unconverged eigenvalues are the eigen-",
       "               values of the upper Hessenberg matrix rows and",
       "               columns ILO through INFO of the final, output",
       "               value of H.",
       "               If INFO .GT. 0 and WANTT is .TRUE., then on exit",
       "          (*)  (initial value of H)*U  = U*(final value of H)",
       "               where U is a unitary matrix.  The final",
       "               value of  H is upper Hessenberg and triangular in",
       "               rows and columns INFO+1 through IHI.",
       "               If INFO .GT. 0 and WANTZ is .TRUE., then on exit",
       "                 (final value of Z(ILO:IHI,ILOZ:IHIZ)",
       "                  =  (initial value of Z(ILO:IHI,ILOZ:IHIZ)*U",
       "               where U is the unitary matrix in (*) (regard-",
       "               less of the value of WANTT.)",
       "               If INFO .GT. 0 and WANTZ is .FALSE., then Z is not",
       "               accessed."]}},
 "ssyev"=>
  {"summary"=>
    ["SSYEV computes all eigenvalues and, optionally, eigenvectors of a",
     "real symmetric matrix A."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA, N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         orthonormal eigenvectors of the matrix A.",
       "         If JOBZ = 'N', then on exit the lower triangle (if UPLO='L')",
       "         or the upper triangle (if UPLO='U') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.  LWORK >= max(1,3*N-1).",
       "         For optimal efficiency, LWORK >= (NB+2)*N,",
       "         where NB is the blocksize for SSYTRD returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the algorithm failed to converge; i",
       "               off-diagonal elements of an intermediate tridiagonal",
       "               form did not converge to zero."]}},
 "cla_gerpvgrw"=>
  {"summary"=>
    ["CLA_GERPVGRW computes the reciprocal pivot growth factor",
     "norm(A)/norm(U). The \"max absolute element\" norm is used. If this is",
     "much less than 1, the stability of the LU factorization of the",
     "(equilibrated) matrix A could be poor. This also means that the",
     "solution X, estimated condition numbers, and error bounds could be",
     "unreliable."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "NCOLS"=>
      ["[in]",
       "         NCOLS is INTEGER",
       "    The number of columns of the matrix A. NCOLS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX array, dimension (LDAF,N)",
       "    The factors L and U from the factorization",
       "    A = P*L*U as computed by CGETRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."]}},
 "dspevx"=>
  {"summary"=>
    ["DSPEVX computes selected eigenvalues and, optionally, eigenvectors",
     "of a real symmetric matrix A in packed storage.  Eigenvalues/vectors",
     "can be selected by specifying either a range of values or a range of",
     "indices for the desired eigenvalues."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found;",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found;",
       "         = 'I': the IL-th through IU-th eigenvalues will be found."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, AP is overwritten by values generated during the",
       "         reduction to tridiagonal form.  If UPLO = 'U', the diagonal",
       "         and first superdiagonal of the tridiagonal matrix T overwrite",
       "         the corresponding elements of A, and if UPLO = 'L', the",
       "         diagonal and first subdiagonal of T overwrite the",
       "         corresponding elements of A."],
     "VL"=>
      ["[in]",
       "         VL is DOUBLE PRECISION",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is DOUBLE PRECISION",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is DOUBLE PRECISION",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing AP to tridiagonal form.",
       "         Eigenvalues will be computed most accurately when ABSTOL is",
       "         set to twice the underflow threshold 2*DLAMCH('S'), not zero.",
       "         If this routine returns with INFO>0, indicating that some",
       "         eigenvectors did not converge, try setting ABSTOL to",
       "         2*DLAMCH('S').",
       "         See \"Computing Small Singular Values of Bidiagonal Matrices",
       "         with Guaranteed High Relative Accuracy,\" by Demmel and",
       "         Kahan, LAPACK Working Note #3."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the selected eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is DOUBLE PRECISION array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If an eigenvector fails to converge, then that column of Z",
       "         contains the latest approximation to the eigenvector, and the",
       "         index of the eigenvector is returned in IFAIL.",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (8*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (5*N)"],
     "IFAIL"=>
      ["[out]",
       "         IFAIL is INTEGER array, dimension (N)",
       "         If JOBZ = 'V', then if INFO = 0, the first M elements of",
       "         IFAIL are zero.  If INFO > 0, then IFAIL contains the",
       "         indices of the eigenvectors that failed to converge.",
       "         If JOBZ = 'N', then IFAIL is not referenced."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, then i eigenvectors failed to converge.",
       "               Their indices are stored in array IFAIL."]}},
 "zla_porcond_c"=>
  {"summary"=>
    ["   ZLA_PORCOND_C Computes the infinity norm condition number of",
     "   op(A) * inv(diag(C)) where C is a DOUBLE PRECISION vector"],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX*16 array, dimension (LDAF,N)",
       "    The triangular factor U or L from the Cholesky factorization",
       "    A = U**H*U or A = L*L**H, as computed by ZPOTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "    The vector C in the formula op(A) * inv(diag(C))."],
     "CAPPLY"=>
      ["[in]",
       "         CAPPLY is LOGICAL",
       "    If .TRUE. then access the vector C in the formula above."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "    i > 0:  The ith argument is invalid."],
     "WORK"=>
      ["[in]",
       "         WORK is COMPLEX*16 array, dimension (2*N).",
       "    Workspace."],
     "RWORK"=>
      ["[in]",
       "         RWORK is DOUBLE PRECISION array, dimension (N).",
       "    Workspace."]}},
 "dsytri2x"=>
  {"summary"=>
    ["DSYTRI2X computes the inverse of a real symmetric indefinite matrix",
     "A using the factorization A = U*D*U**T or A = L*D*L**T computed by",
     "DSYTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the NNB diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by DSYTRF.",
       "         On exit, if INFO = 0, the (symmetric) inverse of the original",
       "         matrix.  If UPLO = 'U', the upper triangular part of the",
       "         inverse is formed and the part of A below the diagonal is not",
       "         referenced; if UPLO = 'L' the lower triangular part of the",
       "         inverse is formed and the part of A above the diagonal is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the NNB structure of D",
       "         as determined by DSYTRF."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (N+NNB+1,NNB+3)"],
     "NB"=>["[in]", "         NB is INTEGER", "         Block size"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "csptri"=>
  {"summary"=>
    ["CSPTRI computes the inverse of a complex symmetric indefinite matrix",
     "A in packed storage using the factorization A = U*D*U**T or",
     "A = L*D*L**T computed by CSPTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         On entry, the block diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by CSPTRF,",
       "         stored as a packed triangular matrix.",
       "         On exit, if INFO = 0, the (symmetric) inverse of the original",
       "         matrix, stored as a packed triangular matrix. The j-th column",
       "         of inv(A) is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = inv(A)(i,j) for 1<=i<=j;",
       "         if UPLO = 'L',",
       "            AP(i + (j-1)*(2n-j)/2) = inv(A)(i,j) for j<=i<=n."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by CSPTRF."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "slarrc"=>
  {"summary"=>
    ["Find the number of eigenvalues of the symmetric tridiagonal matrix T",
     "that are in the interval (VL,VU] if JOBT = 'T', and of L D L^T",
     "if JOBT = 'L'."],
   "param"=>
    {"JOBT"=>
      ["[in]",
       "         JOBT is CHARACTER*1",
       "         = 'T':  Compute Sturm count for matrix T.",
       "         = 'L':  Compute Sturm count for matrix L D L^T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix. N > 0."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         The lower bound for the eigenvalues."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         The upper bound for the eigenvalues."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension (N)",
       "         JOBT = 'T': The N diagonal elements of the tridiagonal matrix T.",
       "         JOBT = 'L': The N diagonal elements of the diagonal matrix D."],
     "E"=>
      ["[in]",
       "         E is REAL array, dimension (N)",
       "         JOBT = 'T': The N-1 offdiagonal elements of the matrix T.",
       "         JOBT = 'L': The N-1 offdiagonal elements of the matrix L."],
     "PIVMIN"=>
      ["[in]",
       "         PIVMIN is REAL",
       "         The minimum pivot in the Sturm sequence for T."],
     "EIGCNT"=>
      ["[out]",
       "         EIGCNT is INTEGER",
       "         The number of eigenvalues of the symmetric tridiagonal matrix T",
       "         that are in the interval (VL,VU]"],
     "LCNT"=>["[out]", "         LCNT is INTEGER"],
     "RCNT"=>
      ["[out]",
       "         RCNT is INTEGER",
       "         The left and right negcounts of the interval."],
     "INFO"=>["[out]", "         INFO is INTEGER"]}},
 "dlarrc"=>
  {"summary"=>
    ["Find the number of eigenvalues of the symmetric tridiagonal matrix T",
     "that are in the interval (VL,VU] if JOBT = 'T', and of L D L^T",
     "if JOBT = 'L'."],
   "param"=>
    {"JOBT"=>
      ["[in]",
       "         JOBT is CHARACTER*1",
       "         = 'T':  Compute Sturm count for matrix T.",
       "         = 'L':  Compute Sturm count for matrix L D L^T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix. N > 0."],
     "VL"=>
      ["[in]",
       "         VL is DOUBLE PRECISION",
       "         The lower bound for the eigenvalues."],
     "VU"=>
      ["[in]",
       "         VU is DOUBLE PRECISION",
       "         The upper bound for the eigenvalues."],
     "D"=>
      ["[in]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         JOBT = 'T': The N diagonal elements of the tridiagonal matrix T.",
       "         JOBT = 'L': The N diagonal elements of the diagonal matrix D."],
     "E"=>
      ["[in]",
       "         E is DOUBLE PRECISION array, dimension (N)",
       "         JOBT = 'T': The N-1 offdiagonal elements of the matrix T.",
       "         JOBT = 'L': The N-1 offdiagonal elements of the matrix L."],
     "PIVMIN"=>
      ["[in]",
       "         PIVMIN is DOUBLE PRECISION",
       "         The minimum pivot in the Sturm sequence for T."],
     "EIGCNT"=>
      ["[out]",
       "         EIGCNT is INTEGER",
       "         The number of eigenvalues of the symmetric tridiagonal matrix T",
       "         that are in the interval (VL,VU]"],
     "LCNT"=>["[out]", "         LCNT is INTEGER"],
     "RCNT"=>
      ["[out]",
       "         RCNT is INTEGER",
       "         The left and right negcounts of the interval."],
     "INFO"=>["[out]", "         INFO is INTEGER"]}},
 "dggev3"=>
  {"summary"=>
    ["DGGEV3 computes for a pair of N-by-N real nonsymmetric matrices (A,B)",
     "the generalized eigenvalues, and optionally, the left and/or right",
     "generalized eigenvectors.",
     "A generalized eigenvalue for a pair of matrices (A,B) is a scalar",
     "lambda or a ratio alpha/beta = lambda, such that A - lambda*B is",
     "singular. It is usually represented as the pair (alpha,beta), as",
     "there is a reasonable interpretation for beta=0, and even for both",
     "being zero.",
     "The right eigenvector v(j) corresponding to the eigenvalue lambda(j)",
     "of (A,B) satisfies",
     "                 A * v(j) = lambda(j) * B * v(j).",
     "The left eigenvector u(j) corresponding to the eigenvalue lambda(j)",
     "of (A,B) satisfies",
     "                 u(j)**H * A  = lambda(j) * u(j)**H * B .",
     "where u(j)**H is the conjugate-transpose of u(j)."],
   "param"=>
    {"JOBVL"=>
      ["[in]",
       "         JOBVL is CHARACTER*1",
       "         = 'N':  do not compute the left generalized eigenvectors;",
       "         = 'V':  compute the left generalized eigenvectors."],
     "JOBVR"=>
      ["[in]",
       "         JOBVR is CHARACTER*1",
       "         = 'N':  do not compute the right generalized eigenvectors;",
       "         = 'V':  compute the right generalized eigenvectors."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A, B, VL, and VR.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA, N)",
       "         On entry, the matrix A in the pair (A,B).",
       "         On exit, A has been overwritten."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB, N)",
       "         On entry, the matrix B in the pair (A,B).",
       "         On exit, B has been overwritten."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of B.  LDB >= max(1,N)."],
     "ALPHAR"=>
      ["[out]", "         ALPHAR is DOUBLE PRECISION array, dimension (N)"],
     "ALPHAI"=>
      ["[out]", "         ALPHAI is DOUBLE PRECISION array, dimension (N)"],
     "BETA"=>
      ["[out]",
       "         BETA is DOUBLE PRECISION array, dimension (N)",
       "         On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will",
       "         be the generalized eigenvalues.  If ALPHAI(j) is zero, then",
       "         the j-th eigenvalue is real; if positive, then the j-th and",
       "         (j+1)-st eigenvalues are a complex conjugate pair, with",
       "         ALPHAI(j+1) negative.",
       "         Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)",
       "         may easily over- or underflow, and BETA(j) may even be zero.",
       "         Thus, the user should avoid naively computing the ratio",
       "         alpha/beta.  However, ALPHAR and ALPHAI will be always less",
       "         than and usually comparable with norm(A) in magnitude, and",
       "         BETA always less than and usually comparable with norm(B)."],
     "VL"=>
      ["[out]",
       "         VL is DOUBLE PRECISION array, dimension (LDVL,N)",
       "         If JOBVL = 'V', the left eigenvectors u(j) are stored one",
       "         after another in the columns of VL, in the same order as",
       "         their eigenvalues. If the j-th eigenvalue is real, then",
       "         u(j) = VL(:,j), the j-th column of VL. If the j-th and",
       "         (j+1)-th eigenvalues form a complex conjugate pair, then",
       "         u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).",
       "         Each eigenvector is scaled so the largest component has",
       "         abs(real part)+abs(imag. part)=1.",
       "         Not referenced if JOBVL = 'N'."],
     "LDVL"=>
      ["[in]",
       "         LDVL is INTEGER",
       "         The leading dimension of the matrix VL. LDVL >= 1, and",
       "         if JOBVL = 'V', LDVL >= N."],
     "VR"=>
      ["[out]",
       "         VR is DOUBLE PRECISION array, dimension (LDVR,N)",
       "         If JOBVR = 'V', the right eigenvectors v(j) are stored one",
       "         after another in the columns of VR, in the same order as",
       "         their eigenvalues. If the j-th eigenvalue is real, then",
       "         v(j) = VR(:,j), the j-th column of VR. If the j-th and",
       "         (j+1)-th eigenvalues form a complex conjugate pair, then",
       "         v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).",
       "         Each eigenvector is scaled so the largest component has",
       "         abs(real part)+abs(imag. part)=1.",
       "         Not referenced if JOBVR = 'N'."],
     "LDVR"=>
      ["[in]",
       "         LDVR is INTEGER",
       "         The leading dimension of the matrix VR. LDVR >= 1, and",
       "         if JOBVR = 'V', LDVR >= N."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         = 1,...,N:",
       "               The QZ iteration failed.  No eigenvectors have been",
       "               calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)",
       "               should be correct for j=INFO+1,...,N.",
       "         > N:  =N+1: other than QZ iteration failed in DHGEQZ.",
       "               =N+2: error return from DTGEVC."]}},
 "zpptrf"=>
  {"summary"=>
    ["ZPPTRF computes the Cholesky factorization of a complex Hermitian",
     "positive definite matrix A stored in packed format.",
     "The factorization has the form",
     "   A = U**H * U,  if UPLO = 'U', or",
     "   A = L  * L**H,  if UPLO = 'L',",
     "where U is an upper triangular matrix and L is lower triangular."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX*16 array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the Hermitian matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         See below for further details.",
       "         On exit, if INFO = 0, the triangular factor U or L from the",
       "         Cholesky factorization A = U**H*U or A = L*L**H, in the same",
       "         storage format as A."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the leading minor of order i is not",
       "               positive definite, and the factorization could not be",
       "               completed."]}},
 "dla_syamv"=>
  {"summary"=>
    ["DLA_SYAMV  performs the matrix-vector operation",
     "        y := alpha*abs(A)*abs(x) + beta*abs(y),",
     "where alpha and beta are scalars, x and y are vectors and A is an",
     "n by n symmetric matrix.",
     "This function is primarily used in calculating error bounds.",
     "To protect against underflow during evaluation, components in",
     "the resulting vector are perturbed away from zero by (N+1)",
     "times the underflow threshold.  To prevent unnecessarily large",
     "errors for block-structure embedded in general matrices,",
     "\"symbolically\" zero components are not perturbed.  A zero",
     "entry is considered \"symbolic\" if all multiplications involved",
     "in computing that entry have at least one zero multiplicand."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is INTEGER",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = BLAS_UPPER   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = BLAS_LOWER   Only the lower triangular part of A",
       "                                 is to be referenced.",
       "          Unchanged on exit."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the number of columns of the matrix A.",
       "          N must be at least zero.",
       "          Unchanged on exit."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is DOUBLE PRECISION .",
       "          On entry, ALPHA specifies the scalar alpha.",
       "          Unchanged on exit."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array of DIMENSION ( LDA, n ).",
       "          Before entry, the leading m by n part of the array A must",
       "          contain the matrix of coefficients.",
       "          Unchanged on exit."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, n ).",
       "          Unchanged on exit."],
     "X"=>
      ["[in]",
       "         X is DOUBLE PRECISION array, dimension",
       "          ( 1 + ( n - 1 )*abs( INCX ) )",
       "          Before entry, the incremented array X must contain the",
       "          vector x.",
       "          Unchanged on exit."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero.",
       "          Unchanged on exit."],
     "BETA"=>
      ["[in]",
       "         BETA is DOUBLE PRECISION .",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input.",
       "          Unchanged on exit."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array, dimension",
       "          ( 1 + ( n - 1 )*abs( INCY ) )",
       "          Before entry with BETA non-zero, the incremented array Y",
       "          must contain the vector y. On exit, Y is overwritten by the",
       "          updated vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero.",
       "          Unchanged on exit."]}},
 "clacpy"=>
  {"summary"=>
    ["CLACPY copies all or part of a two-dimensional matrix A to another",
     "matrix B."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies the part of the matrix A to be copied to B.",
       "         = 'U':      Upper triangular part",
       "         = 'L':      Lower triangular part",
       "         Otherwise:  All of the matrix A"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         The m by n matrix A.  If UPLO = 'U', only the upper trapezium",
       "         is accessed; if UPLO = 'L', only the lower trapezium is",
       "         accessed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "B"=>
      ["[out]",
       "         B is COMPLEX array, dimension (LDB,N)",
       "         On exit, B = A in the locations specified by UPLO."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."]}},
 "chegv_2stage"=>
  {"summary"=>
    ["CHEGV_2STAGE computes all the eigenvalues, and optionally, the eigenvectors",
     "of a complex generalized Hermitian-definite eigenproblem, of the form",
     "A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.",
     "Here A and B are assumed to be Hermitian and B is also",
     "positive definite.",
     "This routine use the 2stage technique for the reduction to tridiagonal",
     "which showed higher performance on recent architecture and for large"],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         Specifies the problem type to be solved:",
       "         = 1:  A*x = (lambda)*B*x",
       "         = 2:  A*B*x = (lambda)*x",
       "         = 3:  B*A*x = (lambda)*x"],
     "JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors.",
       "                 Not available in this release."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         matrix Z of eigenvectors.  The eigenvectors are normalized",
       "         as follows:",
       "         if ITYPE = 1 or 2, Z**H*B*Z = I;",
       "         if ITYPE = 3, Z**H*inv(B)*Z = I.",
       "         If JOBZ = 'N', then on exit the upper triangle (if UPLO='U')",
       "         or the lower triangle (if UPLO='L') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB, N)",
       "         On entry, the Hermitian positive definite matrix B.",
       "         If UPLO = 'U', the leading N-by-N upper triangular part of B",
       "         contains the upper triangular part of the matrix B.",
       "         If UPLO = 'L', the leading N-by-N lower triangular part of B",
       "         contains the lower triangular part of the matrix B.",
       "         On exit, if INFO <= N, the part of B containing the matrix is",
       "         overwritten by the triangular factor U or L from the Cholesky",
       "         factorization B = U**H*U or B = L*L**H."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK. LWORK >= 1, when N <= 1;",
       "         otherwise  ",
       "         If JOBZ = 'N' and N > 1, LWORK must be queried.",
       "                                  LWORK = MAX(1, dimension) where",
       "                                  dimension = max(stage1,stage2) + (KD+1)*N + N",
       "                                            = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                                              + max(2*KD*KD, KD*NTHREADS) ",
       "                                              + (KD+1)*N + N",
       "                                  where KD is the blocking size of the reduction,",
       "                                  FACTOPTNB is the blocking used by the QR or LQ",
       "                                  algorithm, usually FACTOPTNB=128 is a good choice",
       "                                  NTHREADS is the number of threads used when",
       "                                  openMP compilation is enabled, otherwise =1.",
       "         If JOBZ = 'V' and N > 1, LWORK must be queried. Not yet available",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]", "         RWORK is REAL array, dimension (max(1, 3*N-2))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  CPOTRF or CHEEV returned an error code:",
       "            <= N:  if INFO = i, CHEEV failed to converge;",
       "                   i off-diagonal elements of an intermediate",
       "                   tridiagonal form did not converge to zero;",
       "            > N:   if INFO = N + i, for 1 <= i <= N, then the leading",
       "                   minor of order i of B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "dlaed8"=>
  {"summary"=>
    ["DLAED8 merges the two sets of eigenvalues together into a single",
     "sorted set.  Then it tries to deflate the size of the problem.",
     "There are two ways in which deflation can occur:  when two or more",
     "eigenvalues are close together or if there is a tiny element in the",
     "Z vector.  For each such occurrence the order of the related secular",
     "equation problem is reduced by one."],
   "param"=>
    {"ICOMPQ"=>
      ["[in]",
       "         ICOMPQ is INTEGER",
       "         = 0:  Compute eigenvalues only.",
       "         = 1:  Compute eigenvectors of original dense symmetric matrix",
       "               also.  On entry, Q contains the orthogonal matrix used",
       "               to reduce the original matrix to tridiagonal form."],
     "K"=>
      ["[out]",
       "         K is INTEGER",
       "        The number of non-deflated eigenvalues, and the order of the",
       "        related secular equation."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The dimension of the symmetric tridiagonal matrix.  N >= 0."],
     "QSIZ"=>
      ["[in]",
       "         QSIZ is INTEGER",
       "        The dimension of the orthogonal matrix used to reduce",
       "        the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "        On entry, the eigenvalues of the two submatrices to be",
       "        combined.  On exit, the trailing (N-K) updated eigenvalues",
       "        (those which were deflated) sorted into increasing order."],
     "Q"=>
      ["[in,out]",
       "         Q is DOUBLE PRECISION array, dimension (LDQ,N)",
       "        If ICOMPQ = 0, Q is not referenced.  Otherwise,",
       "        on entry, Q contains the eigenvectors of the partially solved",
       "        system which has been previously updated in matrix",
       "        multiplies with other partially solved eigensystems.",
       "        On exit, Q contains the trailing (N-K) updated eigenvectors",
       "        (those which were deflated) in its last N-K columns."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "        The leading dimension of the array Q.  LDQ >= max(1,N)."],
     "INDXQ"=>
      ["[in]",
       "         INDXQ is INTEGER array, dimension (N)",
       "        The permutation which separately sorts the two sub-problems",
       "        in D into ascending order.  Note that elements in the second",
       "        half of this permutation must first have CUTPNT added to",
       "        their values in order to be accurate."],
     "RHO"=>
      ["[in,out]",
       "         RHO is DOUBLE PRECISION",
       "        On entry, the off-diagonal element associated with the rank-1",
       "        cut which originally split the two submatrices which are now",
       "        being recombined.",
       "        On exit, RHO has been modified to the value required by",
       "        DLAED3."],
     "CUTPNT"=>
      ["[in]",
       "         CUTPNT is INTEGER",
       "        The location of the last eigenvalue in the leading",
       "        sub-matrix.  min(1,N) <= CUTPNT <= N."],
     "Z"=>
      ["[in]",
       "         Z is DOUBLE PRECISION array, dimension (N)",
       "        On entry, Z contains the updating vector (the last row of",
       "        the first sub-eigenvector matrix and the first row of the",
       "        second sub-eigenvector matrix).",
       "        On exit, the contents of Z are destroyed by the updating",
       "        process."],
     "DLAMDA"=>
      ["[out]",
       "         DLAMDA is DOUBLE PRECISION array, dimension (N)",
       "        A copy of the first K eigenvalues which will be used by",
       "        DLAED3 to form the secular equation."],
     "Q2"=>
      ["[out]",
       "         Q2 is DOUBLE PRECISION array, dimension (LDQ2,N)",
       "        If ICOMPQ = 0, Q2 is not referenced.  Otherwise,",
       "        a copy of the first K eigenvectors which will be used by",
       "        DLAED7 in a matrix multiply (DGEMM) to update the new",
       "        eigenvectors."],
     "LDQ2"=>
      ["[in]",
       "         LDQ2 is INTEGER",
       "        The leading dimension of the array Q2.  LDQ2 >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "        The first k values of the final deflation-altered z-vector and",
       "        will be passed to DLAED3."],
     "PERM"=>
      ["[out]",
       "         PERM is INTEGER array, dimension (N)",
       "        The permutations (from deflation and sorting) to be applied",
       "        to each eigenblock."],
     "GIVPTR"=>
      ["[out]",
       "         GIVPTR is INTEGER",
       "        The number of Givens rotations which took place in this",
       "        subproblem."],
     "GIVCOL"=>
      ["[out]",
       "         GIVCOL is INTEGER array, dimension (2, N)",
       "        Each pair of numbers indicates a pair of columns to take place",
       "        in a Givens rotation."],
     "GIVNUM"=>
      ["[out]",
       "         GIVNUM is DOUBLE PRECISION array, dimension (2, N)",
       "        Each number indicates the S value to be used in the",
       "        corresponding Givens rotation."],
     "INDXP"=>
      ["[out]",
       "         INDXP is INTEGER array, dimension (N)",
       "        The permutation used to place deflated values of D at the end",
       "        of the array.  INDXP(1:K) points to the nondeflated D-values",
       "        and INDXP(K+1:N) points to the deflated eigenvalues."],
     "INDX"=>
      ["[out]",
       "         INDX is INTEGER array, dimension (N)",
       "        The permutation used to sort the contents of D into ascending",
       "        order."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "slarra"=>
  {"summary"=>
    ["Compute the splitting points with threshold SPLTOL.",
     "SLARRA sets any \"small\" off-diagonal elements to zero."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix. N > 0."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension (N)",
       "         On entry, the N diagonal elements of the tridiagonal",
       "         matrix T."],
     "E"=>
      ["[in,out]",
       "         E is REAL array, dimension (N)",
       "         On entry, the first (N-1) entries contain the subdiagonal",
       "         elements of the tridiagonal matrix T; E(N) need not be set.",
       "         On exit, the entries E( ISPLIT( I ) ), 1 <= I <= NSPLIT,",
       "         are set to zero, the other entries of E are untouched."],
     "E2"=>
      ["[in,out]",
       "         E2 is REAL array, dimension (N)",
       "         On entry, the first (N-1) entries contain the SQUARES of the",
       "         subdiagonal elements of the tridiagonal matrix T;",
       "         E2(N) need not be set.",
       "         On exit, the entries E2( ISPLIT( I ) ),",
       "         1 <= I <= NSPLIT, have been set to zero"],
     "SPLTOL"=>
      ["[in]",
       "         SPLTOL is REAL",
       "         The threshold for splitting. Two criteria can be used:",
       "         SPLTOL<0 : criterion based on absolute off-diagonal value",
       "         SPLTOL>0 : criterion that preserves relative accuracy"],
     "TNRM"=>
      ["[in]", "         TNRM is REAL", "         The norm of the matrix."],
     "NSPLIT"=>
      ["[out]",
       "         NSPLIT is INTEGER",
       "         The number of blocks T splits into. 1 <= NSPLIT <= N."],
     "ISPLIT"=>
      ["[out]",
       "         ISPLIT is INTEGER array, dimension (N)",
       "         The splitting points, at which T breaks up into blocks.",
       "         The first block consists of rows/columns 1 to ISPLIT(1),",
       "         the second of rows/columns ISPLIT(1)+1 through ISPLIT(2),",
       "         etc., and the NSPLIT-th consists of rows/columns",
       "         ISPLIT(NSPLIT-1)+1 through ISPLIT(NSPLIT)=N."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit"]}},
 "dtprfb"=>
  {"summary"=>
    ["DTPRFB applies a real \"triangular-pentagonal\" block reflector H or its",
     "transpose H**T to a real matrix C, which is composed of two",
     "blocks A and B, either from the left or right."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply H or H**T from the Left",
       "         = 'R': apply H or H**T from the Right"],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N': apply H (No transpose)",
       "         = 'T': apply H**T (Transpose)"],
     "DIRECT"=>
      ["[in]",
       "         DIRECT is CHARACTER*1",
       "         Indicates how H is formed from a product of elementary",
       "         reflectors",
       "         = 'F': H = H(1) H(2) . . . H(k) (Forward)",
       "         = 'B': H = H(k) . . . H(2) H(1) (Backward)"],
     "STOREV"=>
      ["[in]",
       "         STOREV is CHARACTER*1",
       "         Indicates how the vectors which define the elementary",
       "         reflectors are stored:",
       "         = 'C': Columns",
       "         = 'R': Rows"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B.",
       "         N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The order of the matrix T, i.e. the number of elementary",
       "         reflectors whose product defines the block reflector.",
       "         K >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The order of the trapezoidal part of V.",
       "         K >= L >= 0.  See Further Details."],
     "V"=>
      ["[in]",
       "         V is DOUBLE PRECISION array, dimension",
       "                               (LDV,K) if STOREV = 'C'",
       "                               (LDV,M) if STOREV = 'R' and SIDE = 'L'",
       "                               (LDV,N) if STOREV = 'R' and SIDE = 'R'",
       "         The pentagonal matrix V, which contains the elementary reflectors",
       "         H(1), H(2), ..., H(K).  See Further Details."],
     "LDV"=>
      ["[in]",
       "         LDV is INTEGER",
       "         The leading dimension of the array V.",
       "         If STOREV = 'C' and SIDE = 'L', LDV >= max(1,M);",
       "         if STOREV = 'C' and SIDE = 'R', LDV >= max(1,N);",
       "         if STOREV = 'R', LDV >= K."],
     "T"=>
      ["[in]",
       "         T is DOUBLE PRECISION array, dimension (LDT,K)",
       "         The triangular K-by-K matrix T in the representation of the",
       "         block reflector."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.",
       "         LDT >= K."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension",
       "         (LDA,N) if SIDE = 'L' or (LDA,K) if SIDE = 'R'",
       "         On entry, the K-by-N or M-by-K matrix A.",
       "         On exit, A is overwritten by the corresponding block of",
       "         H*C or H**T*C or C*H or C*H**T.  See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.",
       "         If SIDE = 'L', LDC >= max(1,K);",
       "         If SIDE = 'R', LDC >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,N)",
       "         On entry, the M-by-N matrix B.",
       "         On exit, B is overwritten by the corresponding block of",
       "         H*C or H**T*C or C*H or C*H**T.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.",
       "         LDB >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension",
       "         (LDWORK,N) if SIDE = 'L',",
       "         (LDWORK,K) if SIDE = 'R'."],
     "LDWORK"=>
      ["[in]",
       "         LDWORK is INTEGER",
       "         The leading dimension of the array WORK.",
       "         If SIDE = 'L', LDWORK >= K;",
       "         if SIDE = 'R', LDWORK >= M."]}},
 "zgbcon"=>
  {"summary"=>
    ["ZGBCON estimates the reciprocal of the condition number of a complex",
     "general band matrix A, in either the 1-norm or the infinity-norm,",
     "using the LU factorization computed by ZGBTRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as",
     "   RCOND = 1 / ( norm(A) * norm(inv(A)) )."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies whether the 1-norm condition number or the",
       "         infinity-norm condition number is required:",
       "         = '1' or 'O':  1-norm;",
       "         = 'I':         Infinity-norm."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "         The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "         The number of superdiagonals within the band of A.  KU >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX*16 array, dimension (LDAB,N)",
       "         Details of the LU factorization of the band matrix A, as",
       "         computed by ZGBTRF.  U is stored as an upper triangular band",
       "         matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and",
       "         the multipliers used during the factorization are stored in",
       "         rows KL+KU+2 to 2*KL+KU+1."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= 2*KL+KU+1."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices; for 1 <= i <= N, row i of the matrix was",
       "         interchanged with row IPIV(i)."],
     "ANORM"=>
      ["[in]",
       "         ANORM is DOUBLE PRECISION",
       "         If NORM = '1' or 'O', the 1-norm of the original matrix A.",
       "         If NORM = 'I', the infinity-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is DOUBLE PRECISION",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(norm(A) * norm(inv(A)))."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (2*N)"],
     "RWORK"=>
      ["[out]", "         RWORK is DOUBLE PRECISION array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "dlaed2"=>
  {"summary"=>
    ["DLAED2 merges the two sets of eigenvalues together into a single",
     "sorted set.  Then it tries to deflate the size of the problem.",
     "There are two ways in which deflation can occur:  when two or more",
     "eigenvalues are close together or if there is a tiny entry in the",
     "Z vector.  For each such occurrence the order of the related secular",
     "equation problem is reduced by one."],
   "param"=>
    {"K"=>
      ["[out]",
       "         K is INTEGER",
       "        The number of non-deflated eigenvalues, and the order of the",
       "        related secular equation. 0 <= K <=N."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The dimension of the symmetric tridiagonal matrix.  N >= 0."],
     "N1"=>
      ["[in]",
       "         N1 is INTEGER",
       "        The location of the last eigenvalue in the leading sub-matrix.",
       "        min(1,N) <= N1 <= N/2."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "        On entry, D contains the eigenvalues of the two submatrices to",
       "        be combined.",
       "        On exit, D contains the trailing (N-K) updated eigenvalues",
       "        (those which were deflated) sorted into increasing order."],
     "Q"=>
      ["[in,out]",
       "         Q is DOUBLE PRECISION array, dimension (LDQ, N)",
       "        On entry, Q contains the eigenvectors of two submatrices in",
       "        the two square blocks with corners at (1,1), (N1,N1)",
       "        and (N1+1, N1+1), (N,N).",
       "        On exit, Q contains the trailing (N-K) updated eigenvectors",
       "        (those which were deflated) in its last N-K columns."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "        The leading dimension of the array Q.  LDQ >= max(1,N)."],
     "INDXQ"=>
      ["[in,out]",
       "         INDXQ is INTEGER array, dimension (N)",
       "        The permutation which separately sorts the two sub-problems",
       "        in D into ascending order.  Note that elements in the second",
       "        half of this permutation must first have N1 added to their",
       "        values. Destroyed on exit."],
     "RHO"=>
      ["[in,out]",
       "         RHO is DOUBLE PRECISION",
       "        On entry, the off-diagonal element associated with the rank-1",
       "        cut which originally split the two submatrices which are now",
       "        being recombined.",
       "        On exit, RHO has been modified to the value required by",
       "        DLAED3."],
     "Z"=>
      ["[in]",
       "         Z is DOUBLE PRECISION array, dimension (N)",
       "        On entry, Z contains the updating vector (the last",
       "        row of the first sub-eigenvector matrix and the first row of",
       "        the second sub-eigenvector matrix).",
       "        On exit, the contents of Z have been destroyed by the updating",
       "        process."],
     "DLAMDA"=>
      ["[out]",
       "         DLAMDA is DOUBLE PRECISION array, dimension (N)",
       "        A copy of the first K eigenvalues which will be used by",
       "        DLAED3 to form the secular equation."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "        The first k values of the final deflation-altered z-vector",
       "        which will be passed to DLAED3."],
     "Q2"=>
      ["[out]",
       "         Q2 is DOUBLE PRECISION array, dimension (N1**2+(N-N1)**2)",
       "        A copy of the first K eigenvectors which will be used by",
       "        DLAED3 in a matrix multiply (DGEMM) to solve for the new",
       "        eigenvectors."],
     "INDX"=>
      ["[out]",
       "         INDX is INTEGER array, dimension (N)",
       "        The permutation used to sort the contents of DLAMDA into",
       "        ascending order."],
     "INDXC"=>
      ["[out]",
       "         INDXC is INTEGER array, dimension (N)",
       "        The permutation used to arrange the columns of the deflated",
       "        Q matrix into three groups:  the first group contains non-zero",
       "        elements only at and above N1, the second contains",
       "        non-zero elements only below N1, and the third is dense."],
     "INDXP"=>
      ["[out]",
       "         INDXP is INTEGER array, dimension (N)",
       "        The permutation used to place deflated values of D at the end",
       "        of the array.  INDXP(1:K) points to the nondeflated D-values",
       "        and INDXP(K+1:N) points to the deflated eigenvalues."],
     "COLTYP"=>
      ["[out]",
       "         COLTYP is INTEGER array, dimension (N)",
       "        During execution, a label which will indicate which of the",
       "        following types a column in the Q2 matrix is:",
       "        1 : non-zero in the upper half only;",
       "        2 : dense;",
       "        3 : non-zero in the lower half only;",
       "        4 : deflated.",
       "        On exit, COLTYP(i) is the number of columns of type i,",
       "        for i=1 to 4 only."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "ssbevx"=>
  {"summary"=>
    ["SSBEVX computes selected eigenvalues and, optionally, eigenvectors",
     "of a real symmetric band matrix A.  Eigenvalues and eigenvectors can",
     "be selected by specifying either a range of values or a range of",
     "indices for the desired eigenvalues."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found;",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found;",
       "         = 'I': the IL-th through IU-th eigenvalues will be found."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is REAL array, dimension (LDAB, N)",
       "         On entry, the upper or lower triangle of the symmetric band",
       "         matrix A, stored in the first KD+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         On exit, AB is overwritten by values generated during the",
       "         reduction to tridiagonal form.  If UPLO = 'U', the first",
       "         superdiagonal and the diagonal of the tridiagonal matrix T",
       "         are returned in rows KD and KD+1 of AB, and if UPLO = 'L',",
       "         the diagonal and first subdiagonal of T are returned in the",
       "         first two rows of AB."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD + 1."],
     "Q"=>
      ["[out]",
       "         Q is REAL array, dimension (LDQ, N)",
       "         If JOBZ = 'V', the N-by-N orthogonal matrix used in the",
       "                        reduction to tridiagonal form.",
       "         If JOBZ = 'N', the array Q is not referenced."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.  If JOBZ = 'V', then",
       "         LDQ >= max(1,N)."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is REAL",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing AB to tridiagonal form.",
       "         Eigenvalues will be computed most accurately when ABSTOL is",
       "         set to twice the underflow threshold 2*SLAMCH('S'), not zero.",
       "         If this routine returns with INFO>0, indicating that some",
       "         eigenvectors did not converge, try setting ABSTOL to",
       "         2*SLAMCH('S').",
       "         See \"Computing Small Singular Values of Bidiagonal Matrices",
       "         with Guaranteed High Relative Accuracy,\" by Demmel and",
       "         Kahan, LAPACK Working Note #3."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         The first M elements contain the selected eigenvalues in",
       "         ascending order."],
     "Z"=>
      ["[out]",
       "         Z is REAL array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If an eigenvector fails to converge, then that column of Z",
       "         contains the latest approximation to the eigenvector, and the",
       "         index of the eigenvector is returned in IFAIL.",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (7*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (5*N)"],
     "IFAIL"=>
      ["[out]",
       "         IFAIL is INTEGER array, dimension (N)",
       "         If JOBZ = 'V', then if INFO = 0, the first M elements of",
       "         IFAIL are zero.  If INFO > 0, then IFAIL contains the",
       "         indices of the eigenvectors that failed to converge.",
       "         If JOBZ = 'N', then IFAIL is not referenced."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  if INFO = i, then i eigenvectors failed to converge.",
       "               Their indices are stored in array IFAIL."]}},
 "dla_syrfsx_extended"=>
  {"summary"=>
    ["DLA_SYRFSX_EXTENDED improves the computed solution to a system of",
     "linear equations by performing extra-precise iterative refinement",
     "and provides error bounds and backward error estimates for the solution.",
     "This subroutine is called by DSYRFSX to perform iterative refinement.",
     "In addition to normwise error bound, the code provides maximum",
     "componentwise error bound if possible. See comments for ERR_BNDS_NORM",
     "and ERR_BNDS_COMP for details of the error bounds. Note that this",
     "subroutine is only resonsible for setting the second fields of",
     "ERR_BNDS_NORM and ERR_BNDS_COMP."],
   "param"=>
    {"PREC_TYPE"=>
      ["[in]",
       "         PREC_TYPE is INTEGER",
       "    Specifies the intermediate precision to be used in refinement.",
       "    The value is defined by ILAPREC(P) where P is a CHARACTER and",
       "    P    = 'S':  Single",
       "         = 'D':  Double",
       "         = 'I':  Indigenous",
       "         = 'X', 'E':  Extra"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "    The number of right-hand-sides, i.e., the number of columns of the",
       "    matrix B."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is DOUBLE PRECISION array, dimension (LDAF,N)",
       "    The block diagonal matrix D and the multipliers used to",
       "    obtain the factor U or L as computed by DSYTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    Details of the interchanges and the block structure of D",
       "    as determined by DSYTRF."],
     "COLEQU"=>
      ["[in]",
       "         COLEQU is LOGICAL",
       "    If .TRUE. then column equilibration was done to A before calling",
       "    this routine. This is needed to compute the solution and error",
       "    bounds correctly."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "    The column scale factors for A. If COLEQU = .FALSE., C",
       "    is not accessed. If C is input, each element of C should be a power",
       "    of the radix to ensure a reliable solution and error estimates.",
       "    Scaling by powers of the radix does not cause rounding errors unless",
       "    the result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "    The right-hand-side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "    The leading dimension of the array B.  LDB >= max(1,N)."],
     "Y"=>
      ["[in,out]",
       "         Y is DOUBLE PRECISION array, dimension",
       "                   (LDY,NRHS)",
       "    On entry, the solution matrix X, as computed by DSYTRS.",
       "    On exit, the improved solution matrix Y."],
     "LDY"=>
      ["[in]",
       "         LDY is INTEGER",
       "    The leading dimension of the array Y.  LDY >= max(1,N)."],
     "BERR_OUT"=>
      ["[out]",
       "         BERR_OUT is DOUBLE PRECISION array, dimension (NRHS)",
       "    On exit, BERR_OUT(j) contains the componentwise relative backward",
       "    error for right-hand-side j from the formula",
       "        max(i) ( abs(RES(i)) / ( abs(op(A_s))*abs(Y) + abs(B_s) )(i) )",
       "    where abs(Z) is the componentwise absolute value of the matrix",
       "    or vector Z. This is computed by DLA_LIN_BERR."],
     "N_NORMS"=>
      ["[in]",
       "         N_NORMS is INTEGER",
       "    Determines which error bounds to return (see ERR_BNDS_NORM",
       "    and ERR_BNDS_COMP).",
       "    If N_NORMS >= 1 return normwise error bounds.",
       "    If N_NORMS >= 2 return componentwise error bounds."],
     "ERR_BNDS_NORM"=>
      ["[in,out]",
       "         ERR_BNDS_NORM is DOUBLE PRECISION array, dimension",
       "                   (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    normwise relative error, which is defined as follows:",
       "    Normwise relative error in the ith solution vector:",
       "            max_j (abs(XTRUE(j,i) - X(j,i)))",
       "           ------------------------------",
       "                 max_j abs(X(j,i))",
       "    The array is indexed by the type of error information as described",
       "    below. There currently are up to three pieces of information",
       "    returned.",
       "    The first index in ERR_BNDS_NORM(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_NORM(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated normwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*A, where S scales each row by a power of the",
       "             radix so all absolute row sums of Z are approximately 1.",
       "    This subroutine is only responsible for setting the second field",
       "    above.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "ERR_BNDS_COMP"=>
      ["[in,out]",
       "         ERR_BNDS_COMP is DOUBLE PRECISION array, dimension",
       "                   (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    componentwise relative error, which is defined as follows:",
       "    Componentwise relative error in the ith solution vector:",
       "                   abs(XTRUE(j,i) - X(j,i))",
       "            max_j ----------------------",
       "                        abs(X(j,i))",
       "    The array is indexed by the right-hand side i (on which the",
       "    componentwise relative error depends), and the type of error",
       "    information as described below. There currently are up to three",
       "    pieces of information returned for each right-hand side. If",
       "    componentwise accuracy is not requested (PARAMS(3) = 0.0), then",
       "    ERR_BNDS_COMP is not accessed.  If N_ERR_BNDS .LT. 3, then at most",
       "    the first (:,N_ERR_BNDS) entries are returned.",
       "    The first index in ERR_BNDS_COMP(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_COMP(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated componentwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*(A*diag(x)), where x is the solution for the",
       "             current right-hand side and S scales each row of",
       "             A*diag(x) by a power of the radix so all absolute row",
       "             sums of Z are approximately 1.",
       "    This subroutine is only responsible for setting the second field",
       "    above.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "RES"=>
      ["[in]",
       "         RES is DOUBLE PRECISION array, dimension (N)",
       "    Workspace to hold the intermediate residual."],
     "AYB"=>
      ["[in]",
       "         AYB is DOUBLE PRECISION array, dimension (N)",
       "    Workspace. This can be the same workspace passed for Y_TAIL."],
     "DY"=>
      ["[in]",
       "         DY is DOUBLE PRECISION array, dimension (N)",
       "    Workspace to hold the intermediate solution."],
     "Y_TAIL"=>
      ["[in]",
       "         Y_TAIL is DOUBLE PRECISION array, dimension (N)",
       "    Workspace to hold the trailing bits of the intermediate solution."],
     "RCOND"=>
      ["[in]",
       "         RCOND is DOUBLE PRECISION",
       "    Reciprocal scaled condition number.  This is an estimate of the",
       "    reciprocal Skeel condition number of the matrix A after",
       "    equilibration (if done).  If this is less than the machine",
       "    precision (in particular, if it is zero), the matrix is singular",
       "    to working precision.  Note that the error may still be small even",
       "    if this number is very small and the matrix appears ill-",
       "    conditioned."],
     "ITHRESH"=>
      ["[in]",
       "         ITHRESH is INTEGER",
       "    The maximum number of residual computations allowed for",
       "    refinement. The default is 10. For 'aggressive' set to 100 to",
       "    permit convergence using approximate factorizations or",
       "    factorizations other than LU. If the factorization uses a",
       "    technique other than Gaussian elimination, the guarantees in",
       "    ERR_BNDS_NORM and ERR_BNDS_COMP may no longer be trustworthy."],
     "RTHRESH"=>
      ["[in]",
       "         RTHRESH is DOUBLE PRECISION",
       "    Determines when to stop refinement if the error estimate stops",
       "    decreasing. Refinement will stop when the next solution no longer",
       "    satisfies norm(dx_{i+1}) < RTHRESH * norm(dx_i) where norm(Z) is",
       "    the infinity norm of Z. RTHRESH satisfies 0 < RTHRESH <= 1. The",
       "    default value is 0.5. For 'aggressive' set to 0.9 to permit",
       "    convergence on extremely ill-conditioned matrices. See LAWN 165",
       "    for more details."],
     "DZ_UB"=>
      ["[in]",
       "         DZ_UB is DOUBLE PRECISION",
       "    Determines when to start considering componentwise convergence.",
       "    Componentwise convergence is only considered after each component",
       "    of the solution Y is stable, which we definte as the relative",
       "    change in each component being less than DZ_UB. The default value",
       "    is 0.25, requiring the first bit to be stable. See LAWN 165 for",
       "    more details."],
     "IGNORE_CWISE"=>
      ["[in]",
       "         IGNORE_CWISE is LOGICAL",
       "    If .TRUE. then ignore componentwise convergence. Default value",
       "    is .FALSE.."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "      < 0:  if INFO = -i, the ith argument to DLA_SYRFSX_EXTENDED had an illegal",
       "            value"]}},
 "ztrtrs"=>
  {"summary"=>
    ["ZTRTRS solves a triangular system of the form",
     "   A * X = B,  A**T * X = B,  or  A**H * X = B,",
     "where A is a triangular matrix of order N, and B is an N-by-NRHS",
     "matrix.  A check is made to verify that A is nonsingular."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  A is upper triangular;",
       "         = 'L':  A is lower triangular."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         Specifies the form of the system of equations:",
       "         = 'N':  A * X = B     (No transpose)",
       "         = 'T':  A**T * X = B  (Transpose)",
       "         = 'C':  A**H * X = B  (Conjugate transpose)"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         = 'N':  A is non-unit triangular;",
       "         = 'U':  A is unit triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         The triangular matrix A.  If UPLO = 'U', the leading N-by-N",
       "         upper triangular part of the array A contains the upper",
       "         triangular matrix, and the strictly lower triangular part of",
       "         A is not referenced.  If UPLO = 'L', the leading N-by-N lower",
       "         triangular part of the array A contains the lower triangular",
       "         matrix, and the strictly upper triangular part of A is not",
       "         referenced.  If DIAG = 'U', the diagonal elements of A are",
       "         also not referenced and are assumed to be 1."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, if INFO = 0, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, the i-th diagonal element of A is zero,",
       "              indicating that the matrix is singular and the solutions",
       "              X have not been computed."]}},
 "dgerq2"=>
  {"summary"=>
    ["DGERQ2 computes an RQ factorization of a real m by n matrix A:",
     "A = R * Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the m by n matrix A.",
       "         On exit, if m <= n, the upper triangle of the subarray",
       "         A(1:m,n-m+1:n) contains the m by m upper triangular matrix R;",
       "         if m >= n, the elements on and above the (m-n)-th subdiagonal",
       "         contain the m by n upper trapezoidal matrix R; the remaining",
       "         elements, with the array TAU, represent the orthogonal matrix",
       "         Q as a product of elementary reflectors (see Further",
       "         Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is DOUBLE PRECISION array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "dgges3"=>
  {"summary"=>
    ["DGGES3 computes for a pair of N-by-N real nonsymmetric matrices (A,B),",
     "the generalized eigenvalues, the generalized real Schur form (S,T),",
     "optionally, the left and/or right matrices of Schur vectors (VSL and",
     "VSR). This gives the generalized Schur factorization",
     "         (A,B) = ( (VSL)*S*(VSR)**T, (VSL)*T*(VSR)**T )",
     "Optionally, it also orders the eigenvalues so that a selected cluster",
     "of eigenvalues appears in the leading diagonal blocks of the upper",
     "quasi-triangular matrix S and the upper triangular matrix T.The",
     "leading columns of VSL and VSR then form an orthonormal basis for the",
     "corresponding left and right eigenspaces (deflating subspaces).",
     "(If only the generalized eigenvalues are needed, use the driver",
     "DGGEV instead, which is faster.)",
     "A generalized eigenvalue for a pair of matrices (A,B) is a scalar w",
     "or a ratio alpha/beta = w, such that  A - w*B is singular.  It is",
     "usually represented as the pair (alpha,beta), as there is a",
     "reasonable interpretation for beta=0 or both being zero.",
     "A pair of matrices (S,T) is in generalized real Schur form if T is",
     "upper triangular with non-negative diagonal and S is block upper",
     "triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond",
     "to real generalized eigenvalues, while 2-by-2 blocks of S will be",
     "\"standardized\" by making the corresponding elements of T have the",
     "form:",
     "        [  a  0  ]",
     "        [  0  b  ]",
     "and the pair of corresponding 2-by-2 blocks in S and T will have a",
     "complex conjugate pair of generalized eigenvalues."],
   "param"=>
    {"JOBVSL"=>
      ["[in]",
       "         JOBVSL is CHARACTER*1",
       "         = 'N':  do not compute the left Schur vectors;",
       "         = 'V':  compute the left Schur vectors."],
     "JOBVSR"=>
      ["[in]",
       "         JOBVSR is CHARACTER*1",
       "         = 'N':  do not compute the right Schur vectors;",
       "         = 'V':  compute the right Schur vectors."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the generalized Schur form.",
       "         = 'N':  Eigenvalues are not ordered;",
       "         = 'S':  Eigenvalues are ordered (see SELCTG);"],
     "SELCTG"=>
      ["[in]",
       "         SELCTG is a LOGICAL FUNCTION of three DOUBLE PRECISION arguments",
       "         SELCTG must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'N', SELCTG is not referenced.",
       "         If SORT = 'S', SELCTG is used to select eigenvalues to sort",
       "         to the top left of the Schur form.",
       "         An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if",
       "         SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either",
       "         one of a complex conjugate pair of eigenvalues is selected,",
       "         then both complex eigenvalues are selected.",
       "         Note that in the ill-conditioned case, a selected complex",
       "         eigenvalue may no longer satisfy SELCTG(ALPHAR(j),ALPHAI(j),",
       "         BETA(j)) = .TRUE. after ordering. INFO is to be set to N+2",
       "         in this case."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A, B, VSL, and VSR.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA, N)",
       "         On entry, the first of the pair of matrices.",
       "         On exit, A has been overwritten by its generalized Schur",
       "         form S."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB, N)",
       "         On entry, the second of the pair of matrices.",
       "         On exit, B has been overwritten by its generalized Schur",
       "         form T."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of B.  LDB >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues (after sorting)",
       "         for which SELCTG is true.  (Complex conjugate pairs for which",
       "         SELCTG is true for either eigenvalue count as 2.)"],
     "ALPHAR"=>
      ["[out]", "         ALPHAR is DOUBLE PRECISION array, dimension (N)"],
     "ALPHAI"=>
      ["[out]", "         ALPHAI is DOUBLE PRECISION array, dimension (N)"],
     "BETA"=>
      ["[out]",
       "         BETA is DOUBLE PRECISION array, dimension (N)",
       "         On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will",
       "         be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,",
       "         and  BETA(j),j=1,...,N are the diagonals of the complex Schur",
       "         form (S,T) that would result if the 2-by-2 diagonal blocks of",
       "         the real Schur form of (A,B) were further reduced to",
       "         triangular form using 2-by-2 complex unitary transformations.",
       "         If ALPHAI(j) is zero, then the j-th eigenvalue is real; if",
       "         positive, then the j-th and (j+1)-st eigenvalues are a",
       "         complex conjugate pair, with ALPHAI(j+1) negative.",
       "         Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)",
       "         may easily over- or underflow, and BETA(j) may even be zero.",
       "         Thus, the user should avoid naively computing the ratio.",
       "         However, ALPHAR and ALPHAI will be always less than and",
       "         usually comparable with norm(A) in magnitude, and BETA always",
       "         less than and usually comparable with norm(B)."],
     "VSL"=>
      ["[out]",
       "         VSL is DOUBLE PRECISION array, dimension (LDVSL,N)",
       "         If JOBVSL = 'V', VSL will contain the left Schur vectors.",
       "         Not referenced if JOBVSL = 'N'."],
     "LDVSL"=>
      ["[in]",
       "         LDVSL is INTEGER",
       "         The leading dimension of the matrix VSL. LDVSL >=1, and",
       "         if JOBVSL = 'V', LDVSL >= N."],
     "VSR"=>
      ["[out]",
       "         VSR is DOUBLE PRECISION array, dimension (LDVSR,N)",
       "         If JOBVSR = 'V', VSR will contain the right Schur vectors.",
       "         Not referenced if JOBVSR = 'N'."],
     "LDVSR"=>
      ["[in]",
       "         LDVSR is INTEGER",
       "         The leading dimension of the matrix VSR. LDVSR >= 1, and",
       "         if JOBVSR = 'V', LDVSR >= N."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "BWORK"=>
      ["[out]",
       "         BWORK is LOGICAL array, dimension (N)",
       "         Not referenced if SORT = 'N'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         = 1,...,N:",
       "               The QZ iteration failed.  (A,B) are not in Schur",
       "               form, but ALPHAR(j), ALPHAI(j), and BETA(j) should",
       "               be correct for j=INFO+1,...,N.",
       "         > N:  =N+1: other than QZ iteration failed in DHGEQZ.",
       "               =N+2: after reordering, roundoff changed values of",
       "                     some complex eigenvalues so that leading",
       "                     eigenvalues in the Generalized Schur form no",
       "                     longer satisfy SELCTG=.TRUE.  This could also",
       "                     be caused due to scaling.",
       "               =N+3: reordering failed in DTGSEN."]}},
 "dpptri"=>
  {"summary"=>
    ["DPPTRI computes the inverse of a real symmetric positive definite",
     "matrix A using the Cholesky factorization A = U**T*U or A = L*L**T",
     "computed by DPPTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangular factor is stored in AP;",
       "         = 'L':  Lower triangular factor is stored in AP."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         On entry, the triangular factor U or L from the Cholesky",
       "         factorization A = U**T*U or A = L*L**T, packed columnwise as",
       "         a linear array.  The j-th column of U or L is stored in the",
       "         array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.",
       "         On exit, the upper or lower triangle of the (symmetric)",
       "         inverse of A, overwriting the input factor U or L."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the (i,i) element of the factor U or L is",
       "               zero, and the inverse could not be computed."]}},
 "chesvxx"=>
  {"summary"=>
    ["   CHESVXX uses the diagonal pivoting factorization to compute the",
     "   solution to a complex system of linear equations A * X = B, where",
     "   A is an N-by-N symmetric matrix and X and B are N-by-NRHS",
     "   matrices.",
     "   If requested, both normwise and maximum componentwise error bounds",
     "   are returned. CHESVXX will return a solution with a tiny",
     "   guaranteed error (O(eps) where eps is the working machine",
     "   precision) unless the matrix is very ill-conditioned, in which",
     "   case a warning is returned. Relevant condition numbers also are",
     "   calculated and returned.",
     "   CHESVXX accepts user-provided factorizations and equilibration",
     "   factors; see the definitions of the FACT and EQUED options.",
     "   Solving with refinement and using a factorization from a previous",
     "   CHESVXX call will also produce a solution with either O(eps)",
     "   errors or warnings, but we cannot make that claim for general",
     "   user-provided factorizations and equilibration factors if they",
     "   differ from what CHESVXX would itself produce."],
   "param"=>nil},
 "slasyf_rk"=>
  {"summary"=>
    ["SLASYF_RK computes a partial factorization of a real symmetric",
     "matrix A using the bounded Bunch-Kaufman (rook) diagonal",
     "pivoting method. The partial factorization has the form:",
     "A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:",
     "      ( 0  U22 ) (  0   D  ) ( U12**T U22**T )",
     "A  =  ( L11  0 ) (  D   0  ) ( L11**T L21**T )  if UPLO = 'L',",
     "      ( L21  I ) (  0  A22 ) (  0       I    )",
     "where the order of D is at most NB. The actual order is returned in",
     "the argument KB, and is either NB or NB-1, or N if N <= NB.",
     "SLASYF_RK is an auxiliary routine called by SSYTRF_RK. It uses",
     "blocked code (calling Level 3 BLAS) to update the submatrix",
     "A11 (if UPLO = 'U') or A22 (if UPLO = 'L')."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The maximum number of columns of the matrix A that should be",
       "         factored.  NB should be at least 2 to allow for 2-by-2 pivot",
       "         blocks."],
     "KB"=>
      ["[out]",
       "         KB is INTEGER",
       "         The number of columns of A that were actually factored.",
       "         KB is either NB-1 or NB, or N if N <= NB."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.",
       "           If UPLO = 'U': the leading N-by-N upper triangular part",
       "           of A contains the upper triangular part of the matrix A,",
       "           and the strictly lower triangular part of A is not",
       "           referenced.",
       "           If UPLO = 'L': the leading N-by-N lower triangular part",
       "           of A contains the lower triangular part of the matrix A,",
       "           and the strictly upper triangular part of A is not",
       "           referenced.",
       "         On exit, contains:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               are stored on exit in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (N)",
       "         On exit, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i), i=2:N, E(1) is set to 0;",
       "         If UPLO = 'L': E(i) = D(i+1,i), i=1:N-1, E(N) is set to 0.",
       "         NOTE: For 1-by-1 diagonal block D(k), where",
       "         1 <= k <= N, the element E(k) is set to 0 in both",
       "         UPLO = 'U' or UPLO = 'L' cases."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         IPIV describes the permutation matrix P in the factorization",
       "         of matrix A as follows. The absolute value of IPIV(k)",
       "         represents the index of row and column that were",
       "         interchanged with the k-th row and column. The value of UPLO",
       "         describes the order in which the interchanges were applied.",
       "         Also, the sign of IPIV represents the block structure of",
       "         the symmetric block diagonal matrix D with 1-by-1 or 2-by-2",
       "         diagonal blocks which correspond to 1 or 2 interchanges",
       "         at each factorization step.",
       "         If UPLO = 'U',",
       "         ( in factorization order, k decreases from N to 1 ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the submatrix A(1:N,N-KB+1:N);",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k-1) < 0 means:",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the matrix A(1:N,N-KB+1:N).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k-1) != k-1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the submatrix A(1:N,N-KB+1:N).",
       "                 If -IPIV(k-1) = k-1, no interchange occurred.",
       "           c) In both cases a) and b) is always ABS( IPIV(k) ) <= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output.",
       "         If UPLO = 'L',",
       "         ( in factorization order, k increases from 1 to N ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the submatrix A(1:N,1:KB).",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k+1) < 0 means:",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the submatrix A(1:N,1:KB).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k+1) != k+1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the submatrix A(1:N,1:KB).",
       "                 If -IPIV(k+1) = k+1, no interchange occurred.",
       "           c) In both cases a) and b) is always ABS( IPIV(k) ) >= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output."],
     "W"=>["[out]", "         W is REAL array, dimension (LDW,NB)"],
     "LDW"=>
      ["[in]",
       "         LDW is INTEGER",
       "         The leading dimension of the array W.  LDW >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: If INFO = -k, the k-th argument had an illegal value",
       "         > 0: If INFO = k, the matrix A is singular, because:",
       "                If UPLO = 'U': column k in the upper",
       "                triangular part of A contains all zeros.",
       "                If UPLO = 'L': column k in the lower",
       "                triangular part of A contains all zeros.",
       "              Therefore D(k,k) is exactly zero, and superdiagonal",
       "              elements of column k of U (or subdiagonal elements of",
       "              column k of L ) are all zeros. The factorization has",
       "              been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if",
       "              it is used to solve a system of equations.",
       "              NOTE: INFO only stores the first occurrence of",
       "              a singularity, any subsequent occurrence of singularity",
       "              is not stored in INFO even though the factorization",
       "              always completes."]}},
 "csytrs"=>
  {"summary"=>
    ["CSYTRS solves a system of linear equations A*X = B with a complex",
     "symmetric matrix A using the factorization A = U*D*U**T or",
     "A = L*D*L**T computed by CSYTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by CSYTRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by CSYTRF."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cunmrz"=>
  {"summary"=>
    ["CUNMRZ overwrites the general complex M-by-N matrix C with",
     "                SIDE = 'L'     SIDE = 'R'",
     "TRANS = 'N':      Q * C          C * Q",
     "TRANS = 'C':      Q**H * C       C * Q**H",
     "where Q is a complex unitary matrix defined as the product of k",
     "elementary reflectors",
     "      Q = H(1) H(2) . . . H(k)",
     "as returned by CTZRZF. Q is of order M if SIDE = 'L' and of order N",
     "if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**H from the Left;",
       "         = 'R': apply Q or Q**H from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'C':  Conjugate transpose, apply Q**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of columns of the matrix A containing",
       "         the meaningful part of the Householder reflectors.",
       "         If SIDE = 'L', M >= L >= 0, if SIDE = 'R', N >= L >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension",
       "                              (LDA,M) if SIDE = 'L',",
       "                              (LDA,N) if SIDE = 'R'",
       "         The i-th row must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         CTZRZF in the last k rows of its array argument A.",
       "         A is modified by the routine but restored on exit."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,K)."],
     "TAU"=>
      ["[in]",
       "         TAU is COMPLEX array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by CTZRZF."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**H*C or C*Q**H or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If SIDE = 'L', LWORK >= max(1,N);",
       "         if SIDE = 'R', LWORK >= max(1,M).",
       "         For good performance, LWORK should generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zpbstf"=>
  {"summary"=>
    ["ZPBSTF computes a split Cholesky factorization of a complex",
     "Hermitian positive definite band matrix A.",
     "This routine is designed to be used in conjunction with ZHBGST.",
     "The factorization has the form  A = S**H*S  where S is a band matrix",
     "of the same bandwidth as A and the following structure:",
     "  S = ( U    )",
     "      ( M  L )",
     "where U is upper triangular of order m = (n+kd)/2, and L is lower",
     "triangular of order n-m."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is COMPLEX*16 array, dimension (LDAB,N)",
       "         On entry, the upper or lower triangle of the Hermitian band",
       "         matrix A, stored in the first kd+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         On exit, if INFO = 0, the factor S from the split Cholesky",
       "         factorization A = S**H*S. See Further Details."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD+1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, the factorization could not be completed,",
       "              because the updated element a(i,i) was negative; the",
       "              matrix A is not positive definite."]}},
 "clansy"=>
  {"summary"=>
    ["CLANSY  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the  element of  largest absolute value  of a",
     "complex symmetric matrix A.",
     "   CLANSY = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in CLANSY as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is to be referenced.",
       "         = 'U':  Upper triangular part of A is referenced",
       "         = 'L':  Lower triangular part of A is referenced"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, CLANSY is",
       "         set to zero."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         The symmetric matrix A.  If UPLO = 'U', the leading n by n",
       "         upper triangular part of A contains the upper triangular part",
       "         of the matrix A, and the strictly lower triangular part of A",
       "         is not referenced.  If UPLO = 'L', the leading n by n lower",
       "         triangular part of A contains the lower triangular part of",
       "         the matrix A, and the strictly upper triangular part of A is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(N,1)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,",
       "         WORK is not referenced."]}},
 "zspsvx"=>
  {"summary"=>
    ["ZSPSVX uses the diagonal pivoting factorization A = U*D*U**T or",
     "A = L*D*L**T to compute the solution to a complex system of linear",
     "equations A * X = B, where A is an N-by-N symmetric matrix stored",
     "in packed format and X and B are N-by-NRHS matrices.",
     "Error bounds on the solution and a condition estimate are also",
     "provided."],
   "param"=>nil},
 "ssyevx"=>
  {"summary"=>
    ["SSYEVX computes selected eigenvalues and, optionally, eigenvectors",
     "of a real symmetric matrix A.  Eigenvalues and eigenvectors can be",
     "selected by specifying either a range of values or a range of indices",
     "for the desired eigenvalues."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found.",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found.",
       "         = 'I': the IL-th through IU-th eigenvalues will be found."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA, N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, the lower triangle (if UPLO='L') or the upper",
       "         triangle (if UPLO='U') of A, including the diagonal, is",
       "         destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is REAL",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing A to tridiagonal form.",
       "         Eigenvalues will be computed most accurately when ABSTOL is",
       "         set to twice the underflow threshold 2*SLAMCH('S'), not zero.",
       "         If this routine returns with INFO>0, indicating that some",
       "         eigenvectors did not converge, try setting ABSTOL to",
       "         2*SLAMCH('S').",
       "         See \"Computing Small Singular Values of Bidiagonal Matrices",
       "         with Guaranteed High Relative Accuracy,\" by Demmel and",
       "         Kahan, LAPACK Working Note #3."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         On normal exit, the first M elements contain the selected",
       "         eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is REAL array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If an eigenvector fails to converge, then that column of Z",
       "         contains the latest approximation to the eigenvector, and the",
       "         index of the eigenvector is returned in IFAIL.",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.  LWORK >= 1, when N <= 1;",
       "         otherwise 8*N.",
       "         For optimal efficiency, LWORK >= (NB+3)*N,",
       "         where NB is the max of the blocksize for SSYTRD and SORMTR",
       "         returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (5*N)"],
     "IFAIL"=>
      ["[out]",
       "         IFAIL is INTEGER array, dimension (N)",
       "         If JOBZ = 'V', then if INFO = 0, the first M elements of",
       "         IFAIL are zero.  If INFO > 0, then IFAIL contains the",
       "         indices of the eigenvectors that failed to converge.",
       "         If JOBZ = 'N', then IFAIL is not referenced."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, then i eigenvectors failed to converge.",
       "               Their indices are stored in array IFAIL."]}},
 "claed8"=>
  {"summary"=>
    ["CLAED8 merges the two sets of eigenvalues together into a single",
     "sorted set.  Then it tries to deflate the size of the problem.",
     "There are two ways in which deflation can occur:  when two or more",
     "eigenvalues are close together or if there is a tiny element in the",
     "Z vector.  For each such occurrence the order of the related secular",
     "equation problem is reduced by one."],
   "param"=>
    {"K"=>
      ["[out]",
       "         K is INTEGER",
       "        Contains the number of non-deflated eigenvalues.",
       "        This is the order of the related secular equation."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The dimension of the symmetric tridiagonal matrix.  N >= 0."],
     "QSIZ"=>
      ["[in]",
       "         QSIZ is INTEGER",
       "        The dimension of the unitary matrix used to reduce",
       "        the dense or band matrix to tridiagonal form.",
       "        QSIZ >= N if ICOMPQ = 1."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX array, dimension (LDQ,N)",
       "        On entry, Q contains the eigenvectors of the partially solved",
       "        system which has been previously updated in matrix",
       "        multiplies with other partially solved eigensystems.",
       "        On exit, Q contains the trailing (N-K) updated eigenvectors",
       "        (those which were deflated) in its last N-K columns."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "        The leading dimension of the array Q.  LDQ >= max( 1, N )."],
     "D"=>
      ["[in,out]",
       "         D is REAL array, dimension (N)",
       "        On entry, D contains the eigenvalues of the two submatrices to",
       "        be combined.  On exit, D contains the trailing (N-K) updated",
       "        eigenvalues (those which were deflated) sorted into increasing",
       "        order."],
     "RHO"=>
      ["[in,out]",
       "         RHO is REAL",
       "        Contains the off diagonal element associated with the rank-1",
       "        cut which originally split the two submatrices which are now",
       "        being recombined. RHO is modified during the computation to",
       "        the value required by SLAED3."],
     "CUTPNT"=>
      ["[in]",
       "         CUTPNT is INTEGER",
       "        Contains the location of the last eigenvalue in the leading",
       "        sub-matrix.  MIN(1,N) <= CUTPNT <= N."],
     "Z"=>
      ["[in]",
       "         Z is REAL array, dimension (N)",
       "        On input this vector contains the updating vector (the last",
       "        row of the first sub-eigenvector matrix and the first row of",
       "        the second sub-eigenvector matrix).  The contents of Z are",
       "        destroyed during the updating process."],
     "DLAMDA"=>
      ["[out]",
       "         DLAMDA is REAL array, dimension (N)",
       "        Contains a copy of the first K eigenvalues which will be used",
       "        by SLAED3 to form the secular equation."],
     "Q2"=>
      ["[out]",
       "         Q2 is COMPLEX array, dimension (LDQ2,N)",
       "        If ICOMPQ = 0, Q2 is not referenced.  Otherwise,",
       "        Contains a copy of the first K eigenvectors which will be used",
       "        by SLAED7 in a matrix multiply (SGEMM) to update the new",
       "        eigenvectors."],
     "LDQ2"=>
      ["[in]",
       "         LDQ2 is INTEGER",
       "        The leading dimension of the array Q2.  LDQ2 >= max( 1, N )."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "        This will hold the first k values of the final",
       "        deflation-altered z-vector and will be passed to SLAED3."],
     "INDXP"=>
      ["[out]",
       "         INDXP is INTEGER array, dimension (N)",
       "        This will contain the permutation used to place deflated",
       "        values of D at the end of the array. On output INDXP(1:K)",
       "        points to the nondeflated D-values and INDXP(K+1:N)",
       "        points to the deflated eigenvalues."],
     "INDX"=>
      ["[out]",
       "         INDX is INTEGER array, dimension (N)",
       "        This will contain the permutation used to sort the contents of",
       "        D into ascending order."],
     "INDXQ"=>
      ["[in]",
       "         INDXQ is INTEGER array, dimension (N)",
       "        This contains the permutation which separately sorts the two",
       "        sub-problems in D into ascending order.  Note that elements in",
       "        the second half of this permutation must first have CUTPNT",
       "        added to their values in order to be accurate."],
     "PERM"=>
      ["[out]",
       "         PERM is INTEGER array, dimension (N)",
       "        Contains the permutations (from deflation and sorting) to be",
       "        applied to each eigenblock."],
     "GIVPTR"=>
      ["[out]",
       "         GIVPTR is INTEGER",
       "        Contains the number of Givens rotations which took place in",
       "        this subproblem."],
     "GIVCOL"=>
      ["[out]",
       "         GIVCOL is INTEGER array, dimension (2, N)",
       "        Each pair of numbers indicates a pair of columns to take place",
       "        in a Givens rotation."],
     "GIVNUM"=>
      ["[out]",
       "         GIVNUM is REAL array, dimension (2, N)",
       "        Each number indicates the S value to be used in the",
       "        corresponding Givens rotation."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "cggqrf"=>
  {"summary"=>
    ["CGGQRF computes a generalized QR factorization of an N-by-M matrix A",
     "and an N-by-P matrix B:",
     "            A = Q*R,        B = Q*T*Z,",
     "where Q is an N-by-N unitary matrix, Z is a P-by-P unitary matrix,",
     "and R and T assume one of the forms:",
     "if N >= M,  R = ( R11 ) M  ,   or if N < M,  R = ( R11  R12 ) N,",
     "                (  0  ) N-M                         N   M-N",
     "                   M",
     "where R11 is upper triangular, and",
     "if N <= P,  T = ( 0  T12 ) N,   or if N > P,  T = ( T11 ) N-P,",
     "                 P-N  N                           ( T21 ) P",
     "                                                     P",
     "where T12 or T21 is upper triangular.",
     "In particular, if B is square and nonsingular, the GQR factorization",
     "of A and B implicitly gives the QR factorization of inv(B)*A:",
     "             inv(B)*A = Z**H * (inv(T)*R)",
     "where inv(B) denotes the inverse of the matrix B, and Z' denotes the",
     "conjugate transpose of matrix Z."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of rows of the matrices A and B. N >= 0."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of columns of the matrix A.  M >= 0."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of columns of the matrix B.  P >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,M)",
       "         On entry, the N-by-M matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the min(N,M)-by-M upper trapezoidal matrix R (R is",
       "         upper triangular if N >= M); the elements below the diagonal,",
       "         with the array TAUA, represent the unitary matrix Q as a",
       "         product of min(N,M) elementary reflectors (see Further",
       "         Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,N)."],
     "TAUA"=>
      ["[out]",
       "         TAUA is COMPLEX array, dimension (min(N,M))",
       "         The scalar factors of the elementary reflectors which",
       "         represent the unitary matrix Q (see Further Details)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,P)",
       "         On entry, the N-by-P matrix B.",
       "         On exit, if N <= P, the upper triangle of the subarray",
       "         B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;",
       "         if N > P, the elements on and above the (N-P)-th subdiagonal",
       "         contain the N-by-P upper trapezoidal matrix T; the remaining",
       "         elements, with the array TAUB, represent the unitary",
       "         matrix Z as a product of elementary reflectors (see Further",
       "         Details)."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >= max(1,N)."],
     "TAUB"=>
      ["[out]",
       "         TAUB is COMPLEX array, dimension (min(N,P))",
       "         The scalar factors of the elementary reflectors which",
       "         represent the unitary matrix Z (see Further Details)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= max(1,N,M,P).",
       "         For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),",
       "         where NB1 is the optimal blocksize for the QR factorization",
       "         of an N-by-M matrix, NB2 is the optimal blocksize for the",
       "         RQ factorization of an N-by-P matrix, and NB3 is the optimal",
       "         blocksize for a call of CUNMQR.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "          = 0:  successful exit",
       "          < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "ssytrd_2stage"=>
  {"summary"=>
    ["SSYTRD_2STAGE reduces a real symmetric matrix A to real symmetric",
     "tridiagonal form T by a orthogonal similarity transformation:",
     "Q1**T Q2**T* A * Q2 * Q1 = T."],
   "param"=>
    {"VECT"=>
      ["[in]",
       "         VECT is CHARACTER*1",
       "         = 'N':  No need for the Housholder representation, ",
       "                 in particular for the second stage (Band to",
       "                 tridiagonal) and thus LHOUS2 is of size max(1, 4*N);",
       "         = 'V':  the Householder representation is needed to ",
       "                 either generate Q1 Q2 or to apply Q1 Q2, ",
       "                 then LHOUS2 is to be queried and computed.",
       "                 (NOT AVAILABLE IN THIS RELEASE)."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if UPLO = 'U', the band superdiagonal",
       "         of A are overwritten by the corresponding elements of the",
       "         internal band-diagonal matrix AB, and the elements above ",
       "         the KD superdiagonal, with the array TAU, represent the orthogonal",
       "         matrix Q1 as a product of elementary reflectors; if UPLO",
       "         = 'L', the diagonal and band subdiagonal of A are over-",
       "         written by the corresponding elements of the internal band-diagonal",
       "         matrix AB, and the elements below the KD subdiagonal, with",
       "         the array TAU, represent the orthogonal matrix Q1 as a product",
       "         of elementary reflectors. See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "D"=>
      ["[out]",
       "         D is REAL array, dimension (N)",
       "         The diagonal elements of the tridiagonal matrix T."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (N-1)",
       "         The off-diagonal elements of the tridiagonal matrix T."],
     "TAU"=>
      ["[out]",
       "         TAU is REAL array, dimension (N-KD)",
       "         The scalar factors of the elementary reflectors of ",
       "         the first stage (see Further Details)."],
     "HOUS2"=>
      ["[out]",
       "         HOUS2 is REAL array, dimension LHOUS2, that",
       "         store the Householder representation of the stage2",
       "         band to tridiagonal."],
     "LHOUS2"=>
      ["[in]",
       "         LHOUS2 is INTEGER",
       "         The dimension of the array HOUS2. LHOUS2 = MAX(1, dimension)",
       "         If LWORK = -1, or LHOUS2=-1,",
       "         then a query is assumed; the routine",
       "         only calculates the optimal size of the HOUS2 array, returns",
       "         this value as the first entry of the HOUS2 array, and no error",
       "         message related to LHOUS2 is issued by XERBLA.",
       "         LHOUS2 = MAX(1, dimension) where",
       "         dimension = 4*N if VECT='N'",
       "         not available now if VECT='H'"],
     "WORK"=>["[out]", "         WORK is REAL array, dimension LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK = MAX(1, dimension)",
       "         If LWORK = -1, or LHOUS2=-1,",
       "         then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA.",
       "         LWORK = MAX(1, dimension) where",
       "         dimension   = max(stage1,stage2) + (KD+1)*N",
       "                     = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                       + max(2*KD*KD, KD*NTHREADS) ",
       "                       + (KD+1)*N ",
       "         where KD is the blocking size of the reduction,",
       "         FACTOPTNB is the blocking used by the QR or LQ",
       "         algorithm, usually FACTOPTNB=128 is a good choice",
       "         NTHREADS is the number of threads used when",
       "         openMP compilation is enabled, otherwise =1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cgeevx"=>
  {"summary"=>
    ["CGEEVX computes for an N-by-N complex nonsymmetric matrix A, the",
     "eigenvalues and, optionally, the left and/or right eigenvectors.",
     "Optionally also, it computes a balancing transformation to improve",
     "the conditioning of the eigenvalues and eigenvectors (ILO, IHI,",
     "SCALE, and ABNRM), reciprocal condition numbers for the eigenvalues",
     "(RCONDE), and reciprocal condition numbers for the right",
     "eigenvectors (RCONDV).",
     "The right eigenvector v(j) of A satisfies",
     "                 A * v(j) = lambda(j) * v(j)",
     "where lambda(j) is its eigenvalue.",
     "The left eigenvector u(j) of A satisfies",
     "              u(j)**H * A = lambda(j) * u(j)**H",
     "where u(j)**H denotes the conjugate transpose of u(j).",
     "The computed eigenvectors are normalized to have Euclidean norm",
     "equal to 1 and largest component real.",
     "Balancing a matrix means permuting the rows and columns to make it",
     "more nearly upper triangular, and applying a diagonal similarity",
     "transformation D * A * D**(-1), where D is a diagonal matrix, to",
     "make its rows and columns closer in norm and the condition numbers",
     "of its eigenvalues and eigenvectors smaller.  The computed",
     "reciprocal condition numbers correspond to the balanced matrix.",
     "Permuting rows and columns will not change the condition numbers",
     "(in exact arithmetic) but diagonal scaling will.  For further",
     "explanation of balancing, see section 4.10.2 of the LAPACK",
     "Users' Guide."],
   "param"=>
    {"BALANC"=>
      ["[in]",
       "         BALANC is CHARACTER*1",
       "         Indicates how the input matrix should be diagonally scaled",
       "         and/or permuted to improve the conditioning of its",
       "         eigenvalues.",
       "         = 'N': Do not diagonally scale or permute;",
       "         = 'P': Perform permutations to make the matrix more nearly",
       "                upper triangular. Do not diagonally scale;",
       "         = 'S': Diagonally scale the matrix, ie. replace A by",
       "                D*A*D**(-1), where D is a diagonal matrix chosen",
       "                to make the rows and columns of A more equal in",
       "                norm. Do not permute;",
       "         = 'B': Both diagonally scale and permute A.",
       "         Computed reciprocal condition numbers will be for the matrix",
       "         after balancing and/or permuting. Permuting does not change",
       "         condition numbers (in exact arithmetic), but balancing does."],
     "JOBVL"=>
      ["[in]",
       "         JOBVL is CHARACTER*1",
       "         = 'N': left eigenvectors of A are not computed;",
       "         = 'V': left eigenvectors of A are computed.",
       "         If SENSE = 'E' or 'B', JOBVL must = 'V'."],
     "JOBVR"=>
      ["[in]",
       "         JOBVR is CHARACTER*1",
       "         = 'N': right eigenvectors of A are not computed;",
       "         = 'V': right eigenvectors of A are computed.",
       "         If SENSE = 'E' or 'B', JOBVR must = 'V'."],
     "SENSE"=>
      ["[in]",
       "         SENSE is CHARACTER*1",
       "         Determines which reciprocal condition numbers are computed.",
       "         = 'N': None are computed;",
       "         = 'E': Computed for eigenvalues only;",
       "         = 'V': Computed for right eigenvectors only;",
       "         = 'B': Computed for eigenvalues and right eigenvectors.",
       "         If SENSE = 'E' or 'B', both left and right eigenvectors",
       "         must also be computed (JOBVL = 'V' and JOBVR = 'V')."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A. N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the N-by-N matrix A.",
       "         On exit, A has been overwritten.  If JOBVL = 'V' or",
       "         JOBVR = 'V', A contains the Schur form of the balanced",
       "         version of the matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is COMPLEX array, dimension (N)",
       "         W contains the computed eigenvalues."],
     "VL"=>
      ["[out]",
       "         VL is COMPLEX array, dimension (LDVL,N)",
       "         If JOBVL = 'V', the left eigenvectors u(j) are stored one",
       "         after another in the columns of VL, in the same order",
       "         as their eigenvalues.",
       "         If JOBVL = 'N', VL is not referenced.",
       "         u(j) = VL(:,j), the j-th column of VL."],
     "LDVL"=>
      ["[in]",
       "         LDVL is INTEGER",
       "         The leading dimension of the array VL.  LDVL >= 1; if",
       "         JOBVL = 'V', LDVL >= N."],
     "VR"=>
      ["[out]",
       "         VR is COMPLEX array, dimension (LDVR,N)",
       "         If JOBVR = 'V', the right eigenvectors v(j) are stored one",
       "         after another in the columns of VR, in the same order",
       "         as their eigenvalues.",
       "         If JOBVR = 'N', VR is not referenced.",
       "         v(j) = VR(:,j), the j-th column of VR."],
     "LDVR"=>
      ["[in]",
       "         LDVR is INTEGER",
       "         The leading dimension of the array VR.  LDVR >= 1; if",
       "         JOBVR = 'V', LDVR >= N."],
     "ILO"=>["[out]", "         ILO is INTEGER"],
     "IHI"=>
      ["[out]",
       "         IHI is INTEGER",
       "         ILO and IHI are integer values determined when A was",
       "         balanced.  The balanced A(i,j) = 0 if I > J and",
       "         J = 1,...,ILO-1 or I = IHI+1,...,N."],
     "SCALE"=>
      ["[out]",
       "         SCALE is REAL array, dimension (N)",
       "         Details of the permutations and scaling factors applied",
       "         when balancing A.  If P(j) is the index of the row and column",
       "         interchanged with row and column j, and D(j) is the scaling",
       "         factor applied to row and column j, then",
       "         SCALE(J) = P(J),    for J = 1,...,ILO-1",
       "                  = D(J),    for J = ILO,...,IHI",
       "                  = P(J)     for J = IHI+1,...,N.",
       "         The order in which the interchanges are made is N to IHI+1,",
       "         then 1 to ILO-1."],
     "ABNRM"=>
      ["[out]",
       "         ABNRM is REAL",
       "         The one-norm of the balanced matrix (the maximum",
       "         of the sum of absolute values of elements of any column)."],
     "RCONDE"=>
      ["[out]",
       "         RCONDE is REAL array, dimension (N)",
       "         RCONDE(j) is the reciprocal condition number of the j-th",
       "         eigenvalue."],
     "RCONDV"=>
      ["[out]",
       "         RCONDV is REAL array, dimension (N)",
       "         RCONDV(j) is the reciprocal condition number of the j-th",
       "         right eigenvector."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  If SENSE = 'N' or 'E',",
       "         LWORK >= max(1,2*N), and if SENSE = 'V' or 'B',",
       "         LWORK >= N*N+2*N.",
       "         For good performance, LWORK must generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (2*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  if INFO = i, the QR algorithm failed to compute all the",
       "               eigenvalues, and no eigenvectors or condition numbers",
       "               have been computed; elements 1:ILO-1 and i+1:N of W",
       "               contain eigenvalues which have converged."]}},
 "zgemlqt"=>
  {"summary"=>
    ["ZGEMQRT overwrites the general real M-by-N matrix C with",
     "                SIDE = 'L'     SIDE = 'R'",
     "TRANS = 'N':      Q C            C Q",
     "TRANS = 'C':   Q**C C            C Q**C",
     "where Q is a complex orthogonal matrix defined as the product of K",
     "elementary reflectors:",
     "      Q = H(1) H(2) . . . H(K) = I - V C V**C",
     "generated using the compact WY representation as returned by ZGELQT.",
     "Q is of order M if SIDE = 'L' and of order N  if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**C from the Left;",
       "         = 'R': apply Q or Q**C from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'C':  Transpose, apply Q**C."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The block size used for the storage of T.  K >= MB >= 1.",
       "         This must be the same value of MB used to generate T",
       "         in DGELQT."],
     "V"=>
      ["[in]",
       "         V is COMPLEX*16 array, dimension (LDV,K)",
       "         The i-th row must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         DGELQT in the first K rows of its array argument A."],
     "LDV"=>
      ["[in]",
       "         LDV is INTEGER",
       "         The leading dimension of the array V.",
       "         If SIDE = 'L', LDA >= max(1,M);",
       "         if SIDE = 'R', LDA >= max(1,N)."],
     "T"=>
      ["[in]",
       "         T is COMPLEX*16 array, dimension (LDT,K)",
       "         The upper triangular factors of the block reflectors",
       "         as returned by DGELQT, stored as a MB-by-M matrix."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q C, Q**C C, C Q**C or C Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array. The dimension of",
       "         WORK is N*MB if SIDE = 'L', or  M*MB if SIDE = 'R'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dstegr"=>
  {"summary"=>
    ["DSTEGR computes selected eigenvalues and, optionally, eigenvectors",
     "of a real symmetric tridiagonal matrix T. Any such unreduced matrix has",
     "a well defined set of pairwise different real eigenvalues, the corresponding",
     "real eigenvectors are pairwise orthogonal.",
     "The spectrum may be computed either completely or partially by specifying",
     "either an interval (VL,VU] or a range of indices IL:IU for the desired",
     "eigenvalues.",
     "DSTEGR is a compatibility wrapper around the improved DSTEMR routine.",
     "See DSTEMR for further details.",
     "One important change is that the ABSTOL parameter no longer provides any",
     "benefit and hence is no longer used.",
     "Note : DSTEGR and DSTEMR work only on machines which follow",
     "IEEE-754 floating-point standard in their handling of infinities and",
     "NaNs.  Normal execution may create these exceptiona values and hence",
     "may abort due to a floating point exception in environments which",
     "do not conform to the IEEE-754 standard."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found.",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found.",
       "         = 'I': the IL-th through IU-th eigenvalues will be found."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix.  N >= 0."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         On entry, the N diagonal elements of the tridiagonal matrix",
       "         T. On exit, D is overwritten."],
     "E"=>
      ["[in,out]",
       "         E is DOUBLE PRECISION array, dimension (N)",
       "         On entry, the (N-1) subdiagonal elements of the tridiagonal",
       "         matrix T in elements 1 to N-1 of E. E(N) need not be set on",
       "         input, but is used internally as workspace.",
       "         On exit, E is overwritten."],
     "VL"=>
      ["[in]",
       "         VL is DOUBLE PRECISION",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is DOUBLE PRECISION",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is DOUBLE PRECISION",
       "         Unused.  Was the absolute error tolerance for the",
       "         eigenvalues/eigenvectors in previous versions."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         The first M elements contain the selected eigenvalues in",
       "         ascending order."],
     "Z"=>
      ["[out]",
       "         Z is DOUBLE PRECISION array, dimension (LDZ, max(1,M) )",
       "         If JOBZ = 'V', and if INFO = 0, then the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix T",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used.",
       "         Supplying N columns is always safe."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', then LDZ >= max(1,N)."],
     "ISUPPZ"=>
      ["[out]",
       "         ISUPPZ is INTEGER ARRAY, dimension ( 2*max(1,M) )",
       "         The support of the eigenvectors in Z, i.e., the indices",
       "         indicating the nonzero elements in Z. The i-th computed eigenvector",
       "         is nonzero only in elements ISUPPZ( 2*i-1 ) through",
       "         ISUPPZ( 2*i ). This is relevant in the case when the matrix",
       "         is split. ISUPPZ is only accessed when JOBZ is 'V' and N > 0."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (LWORK)",
       "         On exit, if INFO = 0, WORK(1) returns the optimal",
       "         (and minimal) LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= max(1,18*N)",
       "         if JOBZ = 'V', and LWORK >= max(1,12*N) if JOBZ = 'N'.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (LIWORK)",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.  LIWORK >= max(1,10*N)",
       "         if the eigenvectors are desired, and LIWORK >= max(1,8*N)",
       "         if only the eigenvalues are to be computed.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal size of the IWORK array,",
       "         returns this value as the first entry of the IWORK array, and",
       "         no error message related to LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         On exit, INFO",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = 1X, internal error in DLARRE,",
       "               if INFO = 2X, internal error in DLARRV.",
       "               Here, the digit X = ABS( IINFO ) < 10, where IINFO is",
       "               the nonzero error code returned by DLARRE or",
       "               DLARRV, respectively."]}},
 "ctrsen"=>
  {"summary"=>
    ["CTRSEN reorders the Schur factorization of a complex matrix",
     "A = Q*T*Q**H, so that a selected cluster of eigenvalues appears in",
     "the leading positions on the diagonal of the upper triangular matrix",
     "T, and the leading columns of Q form an orthonormal basis of the",
     "corresponding right invariant subspace.",
     "Optionally the routine computes the reciprocal condition numbers of",
     "the cluster of eigenvalues and/or the invariant subspace."],
   "param"=>
    {"JOB"=>
      ["[in]",
       "         JOB is CHARACTER*1",
       "         Specifies whether condition numbers are required for the",
       "         cluster of eigenvalues (S) or the invariant subspace (SEP):",
       "         = 'N': none;",
       "         = 'E': for eigenvalues only (S);",
       "         = 'V': for invariant subspace only (SEP);",
       "         = 'B': for both eigenvalues and invariant subspace (S and",
       "                SEP)."],
     "COMPQ"=>
      ["[in]",
       "         COMPQ is CHARACTER*1",
       "         = 'V': update the matrix Q of Schur vectors;",
       "         = 'N': do not update Q."],
     "SELECT"=>
      ["[in]",
       "         SELECT is LOGICAL array, dimension (N)",
       "         SELECT specifies the eigenvalues in the selected cluster. To",
       "         select the j-th eigenvalue, SELECT(j) must be set to .TRUE.."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix T. N >= 0."],
     "T"=>
      ["[in,out]",
       "         T is COMPLEX array, dimension (LDT,N)",
       "         On entry, the upper triangular matrix T.",
       "         On exit, T is overwritten by the reordered matrix T, with the",
       "         selected eigenvalues as the leading diagonal elements."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T. LDT >= max(1,N)."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX array, dimension (LDQ,N)",
       "         On entry, if COMPQ = 'V', the matrix Q of Schur vectors.",
       "         On exit, if COMPQ = 'V', Q has been postmultiplied by the",
       "         unitary transformation matrix which reorders T; the leading M",
       "         columns of Q form an orthonormal basis for the specified",
       "         invariant subspace.",
       "         If COMPQ = 'N', Q is not referenced."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.",
       "         LDQ >= 1; and if COMPQ = 'V', LDQ >= N."],
     "W"=>
      ["[out]",
       "         W is COMPLEX array, dimension (N)",
       "         The reordered eigenvalues of T, in the same order as they",
       "         appear on the diagonal of T."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The dimension of the specified invariant subspace.",
       "         0 <= M <= N."],
     "S"=>
      ["[out]",
       "         S is REAL",
       "         If JOB = 'E' or 'B', S is a lower bound on the reciprocal",
       "         condition number for the selected cluster of eigenvalues.",
       "         S cannot underestimate the true reciprocal condition number",
       "         by more than a factor of sqrt(N). If M = 0 or N, S = 1.",
       "         If JOB = 'N' or 'V', S is not referenced."],
     "SEP"=>
      ["[out]",
       "         SEP is REAL",
       "         If JOB = 'V' or 'B', SEP is the estimated reciprocal",
       "         condition number of the specified invariant subspace. If",
       "         M = 0 or N, SEP = norm(T).",
       "         If JOB = 'N' or 'E', SEP is not referenced."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If JOB = 'N', LWORK >= 1;",
       "         if JOB = 'E', LWORK = max(1,M*(N-M));",
       "         if JOB = 'V' or 'B', LWORK >= max(1,2*M*(N-M)).",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dspsv"=>
  {"summary"=>
    ["DSPSV computes the solution to a real system of linear equations",
     "   A * X = B,",
     "where A is an N-by-N symmetric matrix stored in packed format and X",
     "and B are N-by-NRHS matrices.",
     "The diagonal pivoting method is used to factor A as",
     "   A = U * D * U**T,  if UPLO = 'U', or",
     "   A = L * D * L**T,  if UPLO = 'L',",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, D is symmetric and block diagonal with 1-by-1",
     "and 2-by-2 diagonal blocks.  The factored form of A is then used to",
     "solve the system of equations A * X = B."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of linear equations, i.e., the order of the",
       "         matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         See below for further details.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L from the factorization",
       "         A = U*D*U**T or A = L*D*L**T as computed by DSPTRF, stored as",
       "         a packed triangular matrix in the same storage format as A."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D, as",
       "         determined by DSPTRF.  If IPIV(k) > 0, then rows and columns",
       "         k and IPIV(k) were interchanged, and D(k,k) is a 1-by-1",
       "         diagonal block.  If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0,",
       "         then rows and columns k-1 and -IPIV(k) were interchanged and",
       "         D(k-1:k,k-1:k) is a 2-by-2 diagonal block.  If UPLO = 'L' and",
       "         IPIV(k) = IPIV(k+1) < 0, then rows and columns k+1 and",
       "         -IPIV(k) were interchanged and D(k:k+1,k:k+1) is a 2-by-2",
       "         diagonal block."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, so the solution could not be",
       "               computed."]}},
 "dbbcsd"=>
  {"summary"=>
    ["DBBCSD computes the CS decomposition of an orthogonal matrix in",
     "bidiagonal-block form,",
     "    [ B11 | B12 0  0 ]",
     "    [  0  |  0 -I  0 ]",
     "X = [----------------]",
     "    [ B21 | B22 0  0 ]",
     "    [  0  |  0  0  I ]",
     "                              [  C | -S  0  0 ]",
     "                  [ U1 |    ] [  0 |  0 -I  0 ] [ V1 |    ]**T",
     "                = [---------] [---------------] [---------]   .",
     "                  [    | U2 ] [  S |  C  0  0 ] [    | V2 ]",
     "                              [  0 |  0  0  I ]",
     "X is M-by-M, its top-left block is P-by-Q, and Q must be no larger",
     "than P, M-P, or M-Q. (If Q is not the smallest index, then X must be",
     "transposed and/or permuted. This can be done in constant time using",
     "the TRANS and SIGNS options. See DORCSD for details.)",
     "The bidiagonal matrices B11, B12, B21, and B22 are represented",
     "implicitly by angles THETA(1:Q) and PHI(1:Q-1).",
     "The orthogonal matrices U1, U2, V1T, and V2T are input/output.",
     "The input matrices are pre- or post-multiplied by the appropriate",
     "singular vector matrices."],
   "param"=>
    {"JOBU1"=>
      ["[in]",
       "         JOBU1 is CHARACTER",
       "         = 'Y':      U1 is updated;",
       "         otherwise:  U1 is not updated."],
     "JOBU2"=>
      ["[in]",
       "         JOBU2 is CHARACTER",
       "         = 'Y':      U2 is updated;",
       "         otherwise:  U2 is not updated."],
     "JOBV1T"=>
      ["[in]",
       "         JOBV1T is CHARACTER",
       "         = 'Y':      V1T is updated;",
       "         otherwise:  V1T is not updated."],
     "JOBV2T"=>
      ["[in]",
       "         JOBV2T is CHARACTER",
       "         = 'Y':      V2T is updated;",
       "         otherwise:  V2T is not updated."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER",
       "         = 'T':      X, U1, U2, V1T, and V2T are stored in row-major",
       "                     order;",
       "         otherwise:  X, U1, U2, V1T, and V2T are stored in column-",
       "                     major order."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows and columns in X, the orthogonal matrix in",
       "         bidiagonal-block form."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of rows in the top-left block of X. 0 <= P <= M."],
     "Q"=>
      ["[in]",
       "         Q is INTEGER",
       "         The number of columns in the top-left block of X.",
       "         0 <= Q <= MIN(P,M-P,M-Q)."],
     "THETA"=>
      ["[in,out]",
       "         THETA is DOUBLE PRECISION array, dimension (Q)",
       "         On entry, the angles THETA(1),...,THETA(Q) that, along with",
       "         PHI(1), ...,PHI(Q-1), define the matrix in bidiagonal-block",
       "         form. On exit, the angles whose cosines and sines define the",
       "         diagonal blocks in the CS decomposition."],
     "PHI"=>
      ["[in,out]",
       "         PHI is DOUBLE PRECISION array, dimension (Q-1)",
       "         The angles PHI(1),...,PHI(Q-1) that, along with THETA(1),...,",
       "         THETA(Q), define the matrix in bidiagonal-block form."],
     "U1"=>
      ["[in,out]",
       "         U1 is DOUBLE PRECISION array, dimension (LDU1,P)",
       "         On entry, a P-by-P matrix. On exit, U1 is postmultiplied",
       "         by the left singular vector matrix common to [ B11 ; 0 ] and",
       "         [ B12 0 0 ; 0 -I 0 0 ]."],
     "LDU1"=>
      ["[in]",
       "         LDU1 is INTEGER",
       "         The leading dimension of the array U1, LDU1 >= MAX(1,P)."],
     "U2"=>
      ["[in,out]",
       "         U2 is DOUBLE PRECISION array, dimension (LDU2,M-P)",
       "         On entry, an (M-P)-by-(M-P) matrix. On exit, U2 is",
       "         postmultiplied by the left singular vector matrix common to",
       "         [ B21 ; 0 ] and [ B22 0 0 ; 0 0 I ]."],
     "LDU2"=>
      ["[in]",
       "         LDU2 is INTEGER",
       "         The leading dimension of the array U2, LDU2 >= MAX(1,M-P)."],
     "V1T"=>
      ["[in,out]",
       "         V1T is DOUBLE PRECISION array, dimension (LDV1T,Q)",
       "         On entry, a Q-by-Q matrix. On exit, V1T is premultiplied",
       "         by the transpose of the right singular vector",
       "         matrix common to [ B11 ; 0 ] and [ B21 ; 0 ]."],
     "LDV1T"=>
      ["[in]",
       "         LDV1T is INTEGER",
       "         The leading dimension of the array V1T, LDV1T >= MAX(1,Q)."],
     "V2T"=>
      ["[in,out]",
       "         V2T is DOUBLE PRECISION array, dimenison (LDV2T,M-Q)",
       "         On entry, an (M-Q)-by-(M-Q) matrix. On exit, V2T is",
       "         premultiplied by the transpose of the right",
       "         singular vector matrix common to [ B12 0 0 ; 0 -I 0 ] and",
       "         [ B22 0 0 ; 0 0 I ]."],
     "LDV2T"=>
      ["[in]",
       "         LDV2T is INTEGER",
       "         The leading dimension of the array V2T, LDV2T >= MAX(1,M-Q)."],
     "B11D"=>
      ["[out]",
       "         B11D is DOUBLE PRECISION array, dimension (Q)",
       "         When DBBCSD converges, B11D contains the cosines of THETA(1),",
       "         ..., THETA(Q). If DBBCSD fails to converge, then B11D",
       "         contains the diagonal of the partially reduced top-left",
       "         block."],
     "B11E"=>
      ["[out]",
       "         B11E is DOUBLE PRECISION array, dimension (Q-1)",
       "         When DBBCSD converges, B11E contains zeros. If DBBCSD fails",
       "         to converge, then B11E contains the superdiagonal of the",
       "         partially reduced top-left block."],
     "B12D"=>
      ["[out]",
       "         B12D is DOUBLE PRECISION array, dimension (Q)",
       "         When DBBCSD converges, B12D contains the negative sines of",
       "         THETA(1), ..., THETA(Q). If DBBCSD fails to converge, then",
       "         B12D contains the diagonal of the partially reduced top-right",
       "         block."],
     "B12E"=>
      ["[out]",
       "         B12E is DOUBLE PRECISION array, dimension (Q-1)",
       "         When DBBCSD converges, B12E contains zeros. If DBBCSD fails",
       "         to converge, then B12E contains the subdiagonal of the",
       "         partially reduced top-right block."],
     "B21D"=>
      ["[out]",
       "         B21D is DOUBLE PRECISION  array, dimension (Q)",
       "         When DBBCSD converges, B21D contains the negative sines of",
       "         THETA(1), ..., THETA(Q). If DBBCSD fails to converge, then",
       "         B21D contains the diagonal of the partially reduced bottom-left",
       "         block."],
     "B21E"=>
      ["[out]",
       "         B21E is DOUBLE PRECISION  array, dimension (Q-1)",
       "         When DBBCSD converges, B21E contains zeros. If DBBCSD fails",
       "         to converge, then B21E contains the subdiagonal of the",
       "         partially reduced bottom-left block."],
     "B22D"=>
      ["[out]",
       "         B22D is DOUBLE PRECISION  array, dimension (Q)",
       "         When DBBCSD converges, B22D contains the negative sines of",
       "         THETA(1), ..., THETA(Q). If DBBCSD fails to converge, then",
       "         B22D contains the diagonal of the partially reduced bottom-right",
       "         block."],
     "B22E"=>
      ["[out]",
       "         B22E is DOUBLE PRECISION  array, dimension (Q-1)",
       "         When DBBCSD converges, B22E contains zeros. If DBBCSD fails",
       "         to converge, then B22E contains the subdiagonal of the",
       "         partially reduced bottom-right block."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= MAX(1,8*Q).",
       "         If LWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal size of the WORK array,",
       "         returns this value as the first entry of the work array, and",
       "         no error message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  if DBBCSD did not converge, INFO specifies the number",
       "               of nonzero entries in PHI, and B11D, B11E, etc.,",
       "               contain the partially reduced matrix."]}},
 "zla_gerpvgrw"=>
  {"summary"=>
    ["ZLA_GERPVGRW computes the reciprocal pivot growth factor",
     "norm(A)/norm(U). The \"max absolute element\" norm is used. If this is",
     "much less than 1, the stability of the LU factorization of the",
     "(equilibrated) matrix A could be poor. This also means that the",
     "solution X, estimated condition numbers, and error bounds could be",
     "unreliable."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "NCOLS"=>
      ["[in]",
       "         NCOLS is INTEGER",
       "    The number of columns of the matrix A. NCOLS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX*16 array, dimension (LDAF,N)",
       "    The factors L and U from the factorization",
       "    A = P*L*U as computed by ZGETRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."]}},
 "clantb"=>
  {"summary"=>
    ["CLANTB  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the element of  largest absolute value  of an",
     "n by n triangular band matrix A,  with ( k + 1 ) diagonals.",
     "   CLANTB = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in CLANTB as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the matrix A is upper or lower triangular.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         Specifies whether or not the matrix A is unit triangular.",
       "         = 'N':  Non-unit triangular",
       "         = 'U':  Unit triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, CLANTB is",
       "         set to zero."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of super-diagonals of the matrix A if UPLO = 'U',",
       "         or the number of sub-diagonals of the matrix A if UPLO = 'L'.",
       "         K >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX array, dimension (LDAB,N)",
       "         The upper or lower triangular band matrix A, stored in the",
       "         first k+1 rows of AB.  The j-th column of A is stored",
       "         in the j-th column of the array AB as follows:",
       "         if UPLO = 'U', AB(k+1+i-j,j) = A(i,j) for max(1,j-k)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)   = A(i,j) for j<=i<=min(n,j+k).",
       "         Note that when DIAG = 'U', the elements of the array AB",
       "         corresponding to the diagonal elements of the matrix A are",
       "         not referenced, but are assumed to be one."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= K+1."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I'; otherwise, WORK is not",
       "         referenced."]}},
 "cgglse"=>
  {"summary"=>
    ["CGGLSE solves the linear equality-constrained least squares (LSE)",
     "problem:",
     "        minimize || c - A*x ||_2   subject to   B*x = d",
     "where A is an M-by-N matrix, B is a P-by-N matrix, c is a given",
     "M-vector, and d is a given P-vector. It is assumed that",
     "P <= N <= M+P, and",
     "         rank(B) = P and  rank( (A) ) = N.",
     "                              ( (B) )",
     "These conditions ensure that the LSE problem has a unique solution,",
     "which is obtained using a generalized RQ factorization of the",
     "matrices (B, A) given by",
     "   B = (0 R)*Q,   A = Z*T*Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrices A and B. N >= 0."],
     "P"=>
      ["[in]",
       "         P is INTEGER",
       "         The number of rows of the matrix B. 0 <= P <= N <= M+P."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the min(M,N)-by-N upper trapezoidal matrix T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,N)",
       "         On entry, the P-by-N matrix B.",
       "         On exit, the upper triangle of the subarray B(1:P,N-P+1:N)",
       "         contains the P-by-P upper triangular matrix R."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >= max(1,P)."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX array, dimension (M)",
       "         On entry, C contains the right hand side vector for the",
       "         least squares part of the LSE problem.",
       "         On exit, the residual sum of squares for the solution",
       "         is given by the sum of squares of elements N-P+1 to M of",
       "         vector C."],
     "D"=>
      ["[in,out]",
       "         D is COMPLEX array, dimension (P)",
       "         On entry, D contains the right hand side vector for the",
       "         constrained equation.",
       "         On exit, D is destroyed."],
     "X"=>
      ["[out]",
       "         X is COMPLEX array, dimension (N)",
       "         On exit, X is the solution of the LSE problem."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= max(1,M+N+P).",
       "         For optimum performance LWORK >= P+min(M,N)+max(M,N)*NB,",
       "         where NB is an upper bound for the optimal blocksizes for",
       "         CGEQRF, CGERQF, CUNMQR and CUNMRQ.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         = 1:  the upper triangular factor R associated with B in the",
       "               generalized RQ factorization of the pair (B, A) is",
       "               singular, so that rank(B) < P; the least squares",
       "               solution could not be computed.",
       "         = 2:  the (N-P) by (N-P) part of the upper trapezoidal factor",
       "               T associated with A in the generalized RQ factorization",
       "               of the pair (B, A) is singular, so that",
       "               rank( (A) ) < N; the least squares solution could not",
       "                   ( (B) )",
       "               be computed."]}},
 "zlacrm"=>
  {"summary"=>
    ["ZLACRM performs a very simple matrix-matrix multiplication:",
     "         C := A * B,",
     "where A is M by N and complex; B is N by N and real;",
     "C is M by N and complex."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A and of the matrix C.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns and rows of the matrix B and",
       "         the number of columns of the matrix C.",
       "         N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA, N)",
       "         On entry, A contains the M by N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >=max(1,M)."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array, dimension (LDB, N)",
       "         On entry, B contains the N by N matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >=max(1,N)."],
     "C"=>
      ["[out]",
       "         C is COMPLEX*16 array, dimension (LDC, N)",
       "         On exit, C contains the M by N matrix C."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >=max(1,N)."],
     "RWORK"=>
      ["[out]",
       "         RWORK is DOUBLE PRECISION array, dimension (2*M*N)"]}},
 "slaqsy"=>
  {"summary"=>
    ["SLAQSY equilibrates a symmetric matrix A using the scaling factors",
     "in the vector S."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         n by n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n by n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if EQUED = 'Y', the equilibrated matrix:",
       "         diag(S) * A * diag(S)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(N,1)."],
     "S"=>
      ["[in]",
       "         S is REAL array, dimension (N)",
       "         The scale factors for A."],
     "SCOND"=>
      ["[in]",
       "         SCOND is REAL",
       "         Ratio of the smallest S(i) to the largest S(i)."],
     "AMAX"=>
      ["[in]",
       "         AMAX is REAL",
       "         Absolute value of largest matrix entry."],
     "EQUED"=>
      ["[out]",
       "         EQUED is CHARACTER*1",
       "         Specifies whether or not equilibration was done.",
       "         = 'N':  No equilibration.",
       "         = 'Y':  Equilibration was done, i.e., A has been replaced by",
       "                 diag(S) * A * diag(S)."]}},
 "dtplqt"=>
  {"summary"=>
    ["DTPLQT computes a blocked LQ factorization of a real",
     "\"triangular-pentagonal\" matrix C, which is composed of a",
     "triangular block A and pentagonal block B, using the compact",
     "WY representation for Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B, and the order of the",
       "         triangular matrix A.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B.",
       "         N >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of rows of the lower trapezoidal part of B.",
       "         MIN(M,N) >= L >= 0.  See Further Details."],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The block size to be used in the blocked QR.  M >= MB >= 1."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the lower triangular N-by-N matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the lower triangular matrix L."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB,N)",
       "         On entry, the pentagonal M-by-N matrix B.  The first N-L columns",
       "         are rectangular, and the last L columns are lower trapezoidal.",
       "         On exit, B contains the pentagonal matrix V.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is DOUBLE PRECISION array, dimension (LDT,N)",
       "         The lower triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See Further Details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (MB*M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "spttrf"=>
  {"summary"=>
    ["SPTTRF computes the L*D*L**T factorization of a real symmetric",
     "positive definite tridiagonal matrix A.  The factorization may also",
     "be regarded as having the form A = U**T*D*U."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "D"=>
      ["[in,out]",
       "         D is REAL array, dimension (N)",
       "         On entry, the n diagonal elements of the tridiagonal matrix",
       "         A.  On exit, the n diagonal elements of the diagonal matrix",
       "         D from the L*D*L**T factorization of A."],
     "E"=>
      ["[in,out]",
       "         E is REAL array, dimension (N-1)",
       "         On entry, the (n-1) subdiagonal elements of the tridiagonal",
       "         matrix A.  On exit, the (n-1) subdiagonal elements of the",
       "         unit bidiagonal factor L from the L*D*L**T factorization of A.",
       "         E can also be regarded as the superdiagonal of the unit",
       "         bidiagonal factor U from the U**T*D*U factorization of A."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value",
       "         > 0: if INFO = k, the leading minor of order k is not",
       "              positive definite; if k < N, the factorization could not",
       "              be completed, while if k = N, the factorization was",
       "              completed, but D(N) <= 0."]}},
 "slalsa"=>
  {"summary"=>
    ["SLALSA is an itermediate step in solving the least squares problem",
     "by computing the SVD of the coefficient matrix in compact form (The",
     "singular vectors are computed as products of simple orthorgonal",
     "matrices.).",
     "If ICOMPQ = 0, SLALSA applies the inverse of the left singular vector",
     "matrix of an upper bidiagonal matrix to the right hand side; and if",
     "ICOMPQ = 1, SLALSA applies the right singular vector matrix to the",
     "right hand side. The singular vector matrices were generated in",
     "compact form by SLALSA."],
   "param"=>
    {"ICOMPQ"=>
      ["[in]",
       "         ICOMPQ is INTEGER",
       "        Specifies whether the left or the right singular vector",
       "        matrix is involved.",
       "        = 0: Left singular vector matrix",
       "        = 1: Right singular vector matrix"],
     "SMLSIZ"=>
      ["[in]",
       "         SMLSIZ is INTEGER",
       "        The maximum size of the subproblems at the bottom of the",
       "        computation tree."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The row and column dimensions of the upper bidiagonal matrix."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "        The number of columns of B and BX. NRHS must be at least 1."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension ( LDB, NRHS )",
       "        On input, B contains the right hand sides of the least",
       "        squares problem in rows 1 through M.",
       "        On output, B contains the solution X in rows 1 through N."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "        The leading dimension of B in the calling subprogram.",
       "        LDB must be at least max(1,MAX( M, N ) )."],
     "BX"=>
      ["[out]",
       "         BX is REAL array, dimension ( LDBX, NRHS )",
       "        On exit, the result of applying the left or right singular",
       "        vector matrix to B."],
     "LDBX"=>
      ["[in]",
       "         LDBX is INTEGER",
       "        The leading dimension of BX."],
     "U"=>
      ["[in]",
       "         U is REAL array, dimension ( LDU, SMLSIZ ).",
       "        On entry, U contains the left singular vector matrices of all",
       "        subproblems at the bottom level."],
     "LDU"=>
      ["[in]",
       "         LDU is INTEGER, LDU = > N.",
       "        The leading dimension of arrays U, VT, DIFL, DIFR,",
       "        POLES, GIVNUM, and Z."],
     "VT"=>
      ["[in]",
       "         VT is REAL array, dimension ( LDU, SMLSIZ+1 ).",
       "        On entry, VT**T contains the right singular vector matrices of",
       "        all subproblems at the bottom level."],
     "K"=>["[in]", "         K is INTEGER array, dimension ( N )."],
     "DIFL"=>
      ["[in]",
       "         DIFL is REAL array, dimension ( LDU, NLVL ).",
       "        where NLVL = INT(log_2 (N/(SMLSIZ+1))) + 1."],
     "DIFR"=>
      ["[in]",
       "         DIFR is REAL array, dimension ( LDU, 2 * NLVL ).",
       "        On entry, DIFL(*, I) and DIFR(*, 2 * I -1) record",
       "        distances between singular values on the I-th level and",
       "        singular values on the (I -1)-th level, and DIFR(*, 2 * I)",
       "        record the normalizing factors of the right singular vectors",
       "        matrices of subproblems on I-th level."],
     "Z"=>
      ["[in]",
       "         Z is REAL array, dimension ( LDU, NLVL ).",
       "        On entry, Z(1, I) contains the components of the deflation-",
       "        adjusted updating row vector for subproblems on the I-th",
       "        level."],
     "POLES"=>
      ["[in]",
       "         POLES is REAL array, dimension ( LDU, 2 * NLVL ).",
       "        On entry, POLES(*, 2 * I -1: 2 * I) contains the new and old",
       "        singular values involved in the secular equations on the I-th",
       "        level."],
     "GIVPTR"=>
      ["[in]",
       "         GIVPTR is INTEGER array, dimension ( N ).",
       "        On entry, GIVPTR( I ) records the number of Givens",
       "        rotations performed on the I-th problem on the computation",
       "        tree."],
     "GIVCOL"=>
      ["[in]",
       "         GIVCOL is INTEGER array, dimension ( LDGCOL, 2 * NLVL ).",
       "        On entry, for each I, GIVCOL(*, 2 * I - 1: 2 * I) records the",
       "        locations of Givens rotations performed on the I-th level on",
       "        the computation tree."],
     "LDGCOL"=>
      ["[in]",
       "         LDGCOL is INTEGER, LDGCOL = > N.",
       "        The leading dimension of arrays GIVCOL and PERM."],
     "PERM"=>
      ["[in]",
       "         PERM is INTEGER array, dimension ( LDGCOL, NLVL ).",
       "        On entry, PERM(*, I) records permutations done on the I-th",
       "        level of the computation tree."],
     "GIVNUM"=>
      ["[in]",
       "         GIVNUM is REAL array, dimension ( LDU, 2 * NLVL ).",
       "        On entry, GIVNUM(*, 2 *I -1 : 2 * I) records the C- and S-",
       "        values of Givens rotations performed on the I-th level on the",
       "        computation tree."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension ( N ).",
       "        On entry, if the I-th subproblem is not square,",
       "        C( I ) contains the C-value of a Givens rotation related to",
       "        the right null space of the I-th subproblem."],
     "S"=>
      ["[in]",
       "         S is REAL array, dimension ( N ).",
       "        On entry, if the I-th subproblem is not square,",
       "        S( I ) contains the S-value of a Givens rotation related to",
       "        the right null space of the I-th subproblem."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array.",
       "        The dimension must be at least N."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array.",
       "        The dimension must be at least 3 * N"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "dgelqf"=>
  {"summary"=>
    ["DGELQF computes an LQ factorization of a real M-by-N matrix A:",
     "A = L * Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the m-by-min(m,n) lower trapezoidal matrix L (L is",
       "         lower triangular if m <= n); the elements above the diagonal,",
       "         with the array TAU, represent the orthogonal matrix Q as a",
       "         product of elementary reflectors (see Further Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is DOUBLE PRECISION array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,M).",
       "         For optimum performance LWORK >= M*NB, where NB is the",
       "         optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "csysv_rook"=>
  {"summary"=>
    ["CSYSV_ROOK computes the solution to a complex system of linear",
     "equations",
     "   A * X = B,",
     "where A is an N-by-N symmetric matrix and X and B are N-by-NRHS",
     "matrices.",
     "The diagonal pivoting method is used to factor A as",
     "   A = U * D * U**T,  if UPLO = 'U', or",
     "   A = L * D * L**T,  if UPLO = 'L',",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and D is symmetric and block diagonal with",
     "1-by-1 and 2-by-2 diagonal blocks.",
     "CSYTRF_ROOK is called to compute the factorization of a complex",
     "symmetric matrix A using the bounded Bunch-Kaufman (\"rook\") diagonal",
     "pivoting method.",
     "The factored form of A is then used to solve the system",
     "of equations A * X = B by calling CSYTRS_ROOK."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of linear equations, i.e., the order of the",
       "         matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if INFO = 0, the block diagonal matrix D and the",
       "         multipliers used to obtain the factor U or L from the",
       "         factorization A = U*D*U**T or A = L*D*L**T as computed by",
       "         CSYTRF_ROOK."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D,",
       "         as determined by CSYTRF_ROOK.",
       "         If UPLO = 'U':",
       "              If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "              were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) < 0 and IPIV(k-1) < 0, then rows and",
       "              columns k and -IPIV(k) were interchanged and rows and",
       "              columns k-1 and -IPIV(k-1) were inerchaged,",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "              If IPIV(k) > 0, then rows and columns k and IPIV(k)",
       "              were interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) < 0 and IPIV(k+1) < 0, then rows and",
       "              columns k and -IPIV(k) were interchanged and rows and",
       "              columns k+1 and -IPIV(k+1) were inerchaged,",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >= 1, and for best performance",
       "         LWORK >= max(1,N*NB), where NB is the optimal blocksize for",
       "         CSYTRF_ROOK.",
       "         TRS will be done with Level 2 BLAS",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, so the solution could not be computed."]}},
 "zsytri2"=>
  {"summary"=>
    ["ZSYTRI2 computes the inverse of a COMPLEX*16 symmetric indefinite matrix",
     "A using the factorization A = U*D*U**T or A = L*D*L**T computed by",
     "ZSYTRF. ZSYTRI2 sets the LEADING DIMENSION of the workspace",
     "before calling ZSYTRI2X that actually computes the inverse."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the NB diagonal matrix D and the multipliers",
       "         used to obtain the factor U or L as computed by ZSYTRF.",
       "         On exit, if INFO = 0, the (symmetric) inverse of the original",
       "         matrix.  If UPLO = 'U', the upper triangular part of the",
       "         inverse is formed and the part of A below the diagonal is not",
       "         referenced; if UPLO = 'L' the lower triangular part of the",
       "         inverse is formed and the part of A above the diagonal is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the NB structure of D",
       "         as determined by ZSYTRF."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (N+NB+1)*(NB+3)"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         WORK is size >= (N+NB+1)*(NB+3)",
       "         If LDWORK = -1, then a workspace query is assumed; the routine",
       "          calculates:",
       "             - the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array,",
       "             - and no error message related to LDWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "dhseqr"=>
  {"summary"=>
    ["   DHSEQR computes the eigenvalues of a Hessenberg matrix H",
     "   and, optionally, the matrices T and Z from the Schur decomposition",
     "   H = Z T Z**T, where T is an upper quasi-triangular matrix (the",
     "   Schur form), and Z is the orthogonal matrix of Schur vectors.",
     "   Optionally Z may be postmultiplied into an input orthogonal",
     "   matrix Q so that this routine can give the Schur factorization",
     "   of a matrix A which has been reduced to the Hessenberg form H",
     "   by the orthogonal matrix Q:  A = Q*H*Q**T = (QZ)*T*(QZ)**T."],
   "param"=>
    {"JOB"=>
      ["[in]",
       "         JOB is CHARACTER*1",
       "          = 'E':  compute eigenvalues only;",
       "          = 'S':  compute eigenvalues and the Schur form T."],
     "COMPZ"=>
      ["[in]",
       "         COMPZ is CHARACTER*1",
       "          = 'N':  no Schur vectors are computed;",
       "          = 'I':  Z is initialized to the unit matrix and the matrix Z",
       "                  of Schur vectors of H is returned;",
       "          = 'V':  Z must contain an orthogonal matrix Q on entry, and",
       "                  the product Q*Z is returned."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          The order of the matrix H.  N .GE. 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "          It is assumed that H is already upper triangular in rows",
       "          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally",
       "          set by a previous call to DGEBAL, and then passed to ZGEHRD",
       "          when the matrix output by DGEBAL is reduced to Hessenberg",
       "          form. Otherwise ILO and IHI should be set to 1 and N",
       "          respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.",
       "          If N = 0, then ILO = 1 and IHI = 0."],
     "H"=>
      ["[in,out]",
       "         H is DOUBLE PRECISION array, dimension (LDH,N)",
       "          On entry, the upper Hessenberg matrix H.",
       "          On exit, if INFO = 0 and JOB = 'S', then H contains the",
       "          upper quasi-triangular matrix T from the Schur decomposition",
       "          (the Schur form); 2-by-2 diagonal blocks (corresponding to",
       "          complex conjugate pairs of eigenvalues) are returned in",
       "          standard form, with H(i,i) = H(i+1,i+1) and",
       "          H(i+1,i)*H(i,i+1).LT.0. If INFO = 0 and JOB = 'E', the",
       "          contents of H are unspecified on exit.  (The output value of",
       "          H when INFO.GT.0 is given under the description of INFO",
       "          below.)",
       "          Unlike earlier versions of DHSEQR, this subroutine may",
       "          explicitly H(i,j) = 0 for i.GT.j and j = 1, 2, ... ILO-1",
       "          or j = IHI+1, IHI+2, ... N."],
     "LDH"=>
      ["[in]",
       "         LDH is INTEGER",
       "          The leading dimension of the array H. LDH .GE. max(1,N)."],
     "WR"=>["[out]", "         WR is DOUBLE PRECISION array, dimension (N)"],
     "WI"=>
      ["[out]",
       "         WI is DOUBLE PRECISION array, dimension (N)",
       "          The real and imaginary parts, respectively, of the computed",
       "          eigenvalues. If two eigenvalues are computed as a complex",
       "          conjugate pair, they are stored in consecutive elements of",
       "          WR and WI, say the i-th and (i+1)th, with WI(i) .GT. 0 and",
       "          WI(i+1) .LT. 0. If JOB = 'S', the eigenvalues are stored in",
       "          the same order as on the diagonal of the Schur form returned",
       "          in H, with WR(i) = H(i,i) and, if H(i:i+1,i:i+1) is a 2-by-2",
       "          diagonal block, WI(i) = sqrt(-H(i+1,i)*H(i,i+1)) and",
       "          WI(i+1) = -WI(i)."],
     "Z"=>
      ["[in,out]",
       "         Z is DOUBLE PRECISION array, dimension (LDZ,N)",
       "          If COMPZ = 'N', Z is not referenced.",
       "          If COMPZ = 'I', on entry Z need not be set and on exit,",
       "          if INFO = 0, Z contains the orthogonal matrix Z of the Schur",
       "          vectors of H.  If COMPZ = 'V', on entry Z must contain an",
       "          N-by-N matrix Q, which is assumed to be equal to the unit",
       "          matrix except for the submatrix Z(ILO:IHI,ILO:IHI). On exit,",
       "          if INFO = 0, Z contains Q*Z.",
       "          Normally Q is the orthogonal matrix generated by DORGHR",
       "          after the call to DGEHRD which formed the Hessenberg matrix",
       "          H. (The output value of Z when INFO.GT.0 is given under",
       "          the description of INFO below.)"],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "          The leading dimension of the array Z.  if COMPZ = 'I' or",
       "          COMPZ = 'V', then LDZ.GE.MAX(1,N).  Otherwize, LDZ.GE.1."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (LWORK)",
       "          On exit, if INFO = 0, WORK(1) returns an estimate of",
       "          the optimal value for LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "          The dimension of the array WORK.  LWORK .GE. max(1,N)",
       "          is sufficient and delivers very good and sometimes",
       "          optimal performance.  However, LWORK as large as 11*N",
       "          may be required for optimal performance.  A workspace",
       "          query is recommended to determine the optimal workspace",
       "          size.",
       "          If LWORK = -1, then DHSEQR does a workspace query.",
       "          In this case, DHSEQR checks the input parameters and",
       "          estimates the optimal workspace size for the given",
       "          values of N, ILO and IHI.  The estimate is returned",
       "          in WORK(1).  No error message related to LWORK is",
       "          issued by XERBLA.  Neither H nor Z are accessed."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "            =  0:  successful exit",
       "          .LT. 0:  if INFO = -i, the i-th argument had an illegal",
       "                   value",
       "          .GT. 0:  if INFO = i, DHSEQR failed to compute all of",
       "               the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR",
       "               and WI contain those eigenvalues which have been",
       "               successfully computed.  (Failures are rare.)",
       "               If INFO .GT. 0 and JOB = 'E', then on exit, the",
       "               remaining unconverged eigenvalues are the eigen-",
       "               values of the upper Hessenberg matrix rows and",
       "               columns ILO through INFO of the final, output",
       "               value of H.",
       "               If INFO .GT. 0 and JOB   = 'S', then on exit",
       "          (*)  (initial value of H)*U  = U*(final value of H)",
       "               where U is an orthogonal matrix.  The final",
       "               value of H is upper Hessenberg and quasi-triangular",
       "               in rows and columns INFO+1 through IHI.",
       "               If INFO .GT. 0 and COMPZ = 'V', then on exit",
       "                 (final value of Z)  =  (initial value of Z)*U",
       "               where U is the orthogonal matrix in (*) (regard-",
       "               less of the value of JOB.)",
       "               If INFO .GT. 0 and COMPZ = 'I', then on exit",
       "                     (final value of Z)  = U",
       "               where U is the orthogonal matrix in (*) (regard-",
       "               less of the value of JOB.)",
       "               If INFO .GT. 0 and COMPZ = 'N', then Z is not",
       "               accessed."]}},
 "slaswp"=>
  {"summary"=>
    ["SLASWP performs a series of row interchanges on the matrix A.",
     "One row interchange is initiated for each of rows K1 through K2 of A."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the matrix of column dimension N to which the row",
       "         interchanges will be applied.",
       "         On exit, the permuted matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A."],
     "K1"=>
      ["[in]",
       "         K1 is INTEGER",
       "         The first element of IPIV for which a row interchange will",
       "         be done."],
     "K2"=>
      ["[in]",
       "         K2 is INTEGER",
       "         (K2-K1+1) is the number of elements of IPIV for which a row",
       "         interchange will be done."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (K1+(K2-K1)*abs(INCX))",
       "         The vector of pivot indices. Only the elements in positions",
       "         K1 through K1+(K2-K1)*INCX of IPIV are accessed.",
       "         IPIV(K) = L implies rows K and L are to be interchanged."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between successive values of IPIV.  If IPIV",
       "         is negative, the pivots are applied in reverse order."]}},
 "sla_porpvgrw"=>
  {"summary"=>
    ["SLA_PORPVGRW computes the reciprocal pivot growth factor",
     "norm(A)/norm(U). The \"max absolute element\" norm is used. If this is",
     "much less than 1, the stability of the LU factorization of the",
     "(equilibrated) matrix A could be poor. This also means that the",
     "solution X, estimated condition numbers, and error bounds could be",
     "unreliable."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "NCOLS"=>
      ["[in]",
       "         NCOLS is INTEGER",
       "    The number of columns of the matrix A. NCOLS >= 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is REAL array, dimension (LDAF,N)",
       "    The triangular factor U or L from the Cholesky factorization",
       "    A = U**T*U or A = L*L**T, as computed by SPOTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "WORK"=>["[in]", "         WORK is REAL array, dimension (2*N)"]}},
 "ssyevr"=>
  {"summary"=>
    ["SSYEVR computes selected eigenvalues and, optionally, eigenvectors",
     "of a real symmetric matrix A.  Eigenvalues and eigenvectors can be",
     "selected by specifying either a range of values or a range of",
     "indices for the desired eigenvalues.",
     "SSYEVR first reduces the matrix A to tridiagonal form T with a call",
     "to SSYTRD.  Then, whenever possible, SSYEVR calls SSTEMR to compute",
     "the eigenspectrum using Relatively Robust Representations.  SSTEMR",
     "computes eigenvalues by the dqds algorithm, while orthogonal",
     "eigenvectors are computed from various \"good\" L D L^T representations",
     "(also known as Relatively Robust Representations). Gram-Schmidt",
     "orthogonalization is avoided as far as possible. More specifically,",
     "the various steps of the algorithm are as follows.",
     "For each unreduced block (submatrix) of T,",
     "   (a) Compute T - sigma I  = L D L^T, so that L and D",
     "       define all the wanted eigenvalues to high relative accuracy.",
     "       This means that small relative changes in the entries of D and L",
     "       cause only small relative changes in the eigenvalues and",
     "       eigenvectors. The standard (unfactored) representation of the",
     "       tridiagonal matrix T does not have this property in general.",
     "   (b) Compute the eigenvalues to suitable accuracy.",
     "       If the eigenvectors are desired, the algorithm attains full",
     "       accuracy of the computed eigenvalues only right before",
     "       the corresponding vectors have to be computed, see steps c) and d).",
     "   (c) For each cluster of close eigenvalues, select a new",
     "       shift close to the cluster, find a new factorization, and refine",
     "       the shifted eigenvalues to suitable accuracy.",
     "   (d) For each eigenvalue with a large enough relative separation compute",
     "       the corresponding eigenvector by forming a rank revealing twisted",
     "       factorization. Go back to (c) for any clusters that remain.",
     "The desired accuracy of the output can be specified by the input",
     "parameter ABSTOL.",
     "For more details, see SSTEMR's documentation and:",
     "- Inderjit S. Dhillon and Beresford N. Parlett: \"Multiple representations",
     "  to compute orthogonal eigenvectors of symmetric tridiagonal matrices,\"",
     "  Linear Algebra and its Applications, 387(1), pp. 1-28, August 2004.",
     "- Inderjit Dhillon and Beresford Parlett: \"Orthogonal Eigenvectors and",
     "  Relative Gaps,\" SIAM Journal on Matrix Analysis and Applications, Vol. 25,",
     "  2004.  Also LAPACK Working Note 154.",
     "- Inderjit Dhillon: \"A new O(n^2) algorithm for the symmetric",
     "  tridiagonal eigenvalue/eigenvector problem\",",
     "  Computer Science Division Technical Report No. UCB/CSD-97-971,",
     "  UC Berkeley, May 1997.",
     "Note 1 : SSYEVR calls SSTEMR when the full spectrum is requested",
     "on machines which conform to the ieee-754 floating point standard.",
     "SSYEVR calls SSTEBZ and SSTEIN on non-ieee machines and",
     "when partial spectrum requests are made.",
     "Normal execution of SSTEMR may create NaNs and infinities and",
     "hence may abort due to a floating point exception in environments",
     "which do not handle NaNs and infinities in the ieee standard default",
     "manner."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found.",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found.",
       "         = 'I': the IL-th through IU-th eigenvalues will be found.",
       "         For RANGE = 'V' or 'I' and IU - IL < N - 1, SSTEBZ and",
       "         SSTEIN are called"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA, N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, the lower triangle (if UPLO='L') or the upper",
       "         triangle (if UPLO='U') of A, including the diagonal, is",
       "         destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is REAL",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing A to tridiagonal form.",
       "         See \"Computing Small Singular Values of Bidiagonal Matrices",
       "         with Guaranteed High Relative Accuracy,\" by Demmel and",
       "         Kahan, LAPACK Working Note #3.",
       "         If high relative accuracy is important, set ABSTOL to",
       "         SLAMCH( 'Safe minimum' ).  Doing so will guarantee that",
       "         eigenvalues are computed to high relative accuracy when",
       "         possible in future releases.  The current code does not",
       "         make any guarantees about high relative accuracy, but",
       "         future releases will. See J. Barlow and J. Demmel,",
       "         \"Computing Accurate Eigensystems of Scaled Diagonally",
       "         Dominant Matrices\", LAPACK Working Note #7, for a discussion",
       "         of which matrices define their eigenvalues to high relative",
       "         accuracy."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         The first M elements contain the selected eigenvalues in",
       "         ascending order."],
     "Z"=>
      ["[out]",
       "         Z is REAL array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used.",
       "         Supplying N columns is always safe."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "ISUPPZ"=>
      ["[out]",
       "         ISUPPZ is INTEGER array, dimension ( 2*max(1,M) )",
       "         The support of the eigenvectors in Z, i.e., the indices",
       "         indicating the nonzero elements in Z. The i-th eigenvector",
       "         is nonzero only in elements ISUPPZ( 2*i-1 ) through",
       "         ISUPPZ( 2*i ). This is an output of SSTEMR (tridiagonal",
       "         matrix). The support of the eigenvectors of A is typically",
       "         1:N because of the orthogonal transformations applied by SORMTR.",
       "         Implemented only for RANGE = 'A' or 'I' and IU - IL = N - 1"],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,26*N).",
       "         For optimal efficiency, LWORK >= (NB+6)*N,",
       "         where NB is the max of the blocksize for SSYTRD and SORMTR",
       "         returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal sizes of the WORK and IWORK",
       "         arrays, returns these values as the first entries of the WORK",
       "         and IWORK arrays, and no error message related to LWORK or",
       "         LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.  LIWORK >= max(1,10*N).",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK and IWORK arrays, and no error message related to",
       "         LWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  Internal error"]}},
 "sptsv"=>
  {"summary"=>
    ["SPTSV computes the solution to a real system of linear equations",
     "A*X = B, where A is an N-by-N symmetric positive definite tridiagonal",
     "matrix, and X and B are N-by-NRHS matrices.",
     "A is factored as A = L*D*L**T, and the factored form of A is then",
     "used to solve the system of equations."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "D"=>
      ["[in,out]",
       "         D is REAL array, dimension (N)",
       "         On entry, the n diagonal elements of the tridiagonal matrix",
       "         A.  On exit, the n diagonal elements of the diagonal matrix",
       "         D from the factorization A = L*D*L**T."],
     "E"=>
      ["[in,out]",
       "         E is REAL array, dimension (N-1)",
       "         On entry, the (n-1) subdiagonal elements of the tridiagonal",
       "         matrix A.  On exit, the (n-1) subdiagonal elements of the",
       "         unit bidiagonal factor L from the L*D*L**T factorization of",
       "         A.  (E can also be regarded as the superdiagonal of the unit",
       "         bidiagonal factor U from the U**T*D*U factorization of A.)"],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the leading minor of order i is not",
       "               positive definite, and the solution has not been",
       "               computed.  The factorization has not been completed",
       "               unless i = N."]}},
 "cgeesx"=>
  {"summary"=>
    ["CGEESX computes for an N-by-N complex nonsymmetric matrix A, the",
     "eigenvalues, the Schur form T, and, optionally, the matrix of Schur",
     "vectors Z.  This gives the Schur factorization A = Z*T*(Z**H).",
     "Optionally, it also orders the eigenvalues on the diagonal of the",
     "Schur form so that selected eigenvalues are at the top left;",
     "computes a reciprocal condition number for the average of the",
     "selected eigenvalues (RCONDE); and computes a reciprocal condition",
     "number for the right invariant subspace corresponding to the",
     "selected eigenvalues (RCONDV).  The leading columns of Z form an",
     "orthonormal basis for this invariant subspace.",
     "For further explanation of the reciprocal condition numbers RCONDE",
     "and RCONDV, see Section 4.10 of the LAPACK Users' Guide (where",
     "these quantities are called s and sep respectively).",
     "A complex matrix is in Schur form if it is upper triangular."],
   "param"=>
    {"JOBVS"=>
      ["[in]",
       "         JOBVS is CHARACTER*1",
       "         = 'N': Schur vectors are not computed;",
       "         = 'V': Schur vectors are computed."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the Schur form.",
       "         = 'N': Eigenvalues are not ordered;",
       "         = 'S': Eigenvalues are ordered (see SELECT)."],
     "SELECT"=>
      ["[in]",
       "         SELECT is a LOGICAL FUNCTION of one COMPLEX argument",
       "         SELECT must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'S', SELECT is used to select eigenvalues to order",
       "         to the top left of the Schur form.",
       "         If SORT = 'N', SELECT is not referenced.",
       "         An eigenvalue W(j) is selected if SELECT(W(j)) is true."],
     "SENSE"=>
      ["[in]",
       "         SENSE is CHARACTER*1",
       "         Determines which reciprocal condition numbers are computed.",
       "         = 'N': None are computed;",
       "         = 'E': Computed for average of selected eigenvalues only;",
       "         = 'V': Computed for selected right invariant subspace only;",
       "         = 'B': Computed for both.",
       "         If SENSE = 'E', 'V' or 'B', SORT must equal 'S'."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A. N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the N-by-N matrix A.",
       "         On exit, A is overwritten by its Schur form T."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues for which",
       "                        SELECT is true."],
     "W"=>
      ["[out]",
       "         W is COMPLEX array, dimension (N)",
       "         W contains the computed eigenvalues, in the same order",
       "         that they appear on the diagonal of the output Schur form T."],
     "VS"=>
      ["[out]",
       "         VS is COMPLEX array, dimension (LDVS,N)",
       "         If JOBVS = 'V', VS contains the unitary matrix Z of Schur",
       "         vectors.",
       "         If JOBVS = 'N', VS is not referenced."],
     "LDVS"=>
      ["[in]",
       "         LDVS is INTEGER",
       "         The leading dimension of the array VS.  LDVS >= 1, and if",
       "         JOBVS = 'V', LDVS >= N."],
     "RCONDE"=>
      ["[out]",
       "         RCONDE is REAL",
       "         If SENSE = 'E' or 'B', RCONDE contains the reciprocal",
       "         condition number for the average of the selected eigenvalues.",
       "         Not referenced if SENSE = 'N' or 'V'."],
     "RCONDV"=>
      ["[out]",
       "         RCONDV is REAL",
       "         If SENSE = 'V' or 'B', RCONDV contains the reciprocal",
       "         condition number for the selected right invariant subspace.",
       "         Not referenced if SENSE = 'N' or 'E'."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,2*N).",
       "         Also, if SENSE = 'E' or 'V' or 'B', LWORK >= 2*SDIM*(N-SDIM),",
       "         where SDIM is the number of selected eigenvalues computed by",
       "         this routine.  Note that 2*SDIM*(N-SDIM) <= N*N/2. Note also",
       "         that an error is only returned if LWORK < max(1,2*N), but if",
       "         SENSE = 'E' or 'V' or 'B' this may not be large enough.",
       "         For good performance, LWORK must generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates upper bound on the optimal size of the",
       "         array WORK, returns this value as the first entry of the WORK",
       "         array, and no error message related to LWORK is issued by",
       "         XERBLA."],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (N)"],
     "BWORK"=>
      ["[out]",
       "         BWORK is LOGICAL array, dimension (N)",
       "         Not referenced if SORT = 'N'."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value.",
       "         > 0: if INFO = i, and i is",
       "            <= N: the QR algorithm failed to compute all the",
       "                  eigenvalues; elements 1:ILO-1 and i+1:N of W",
       "                  contain those eigenvalues which have converged; if",
       "                  JOBVS = 'V', VS contains the transformation which",
       "                  reduces A to its partially converged Schur form.",
       "            = N+1: the eigenvalues could not be reordered because some",
       "                  eigenvalues were too close to separate (the problem",
       "                  is very ill-conditioned);",
       "            = N+2: after reordering, roundoff changed values of some",
       "                  complex eigenvalues so that leading eigenvalues in",
       "                  the Schur form no longer satisfy SELECT=.TRUE.  This",
       "                  could also be caused by underflow due to scaling."]}},
 "clargv"=>
  {"summary"=>
    ["CLARGV generates a vector of complex plane rotations with real",
     "cosines, determined by elements of the complex vectors x and y.",
     "For i = 1,2,...,n",
     "   (        c(i)   s(i) ) ( x(i) ) = ( r(i) )",
     "   ( -conjg(s(i))  c(i) ) ( y(i) ) = (   0  )",
     "   where c(i)**2 + ABS(s(i))**2 = 1",
     "The following conventions are used (these are the same as in CLARTG,",
     "but differ from the BLAS1 routine CROTG):",
     "   If y(i)=0, then c(i)=1 and s(i)=0.",
     "   If x(i)=0, then c(i)=0 and s(i) is chosen so that r(i) is real."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of plane rotations to be generated."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array, dimension (1+(N-1)*INCX)",
       "         On entry, the vector x.",
       "         On exit, x(i) is overwritten by r(i), for i = 1,...,n."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between elements of X. INCX > 0."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array, dimension (1+(N-1)*INCY)",
       "         On entry, the vector y.",
       "         On exit, the sines of the plane rotations."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "         The increment between elements of Y. INCY > 0."],
     "C"=>
      ["[out]",
       "         C is REAL array, dimension (1+(N-1)*INCC)",
       "         The cosines of the plane rotations."],
     "INCC"=>
      ["[in]",
       "         INCC is INTEGER",
       "         The increment between elements of C. INCC > 0."]}},
 "zlaqhe"=>
  {"summary"=>
    ["ZLAQHE equilibrates a Hermitian matrix A using the scaling factors",
     "in the vector S."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         Hermitian matrix A is stored.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the leading",
       "         n by n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n by n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if EQUED = 'Y', the equilibrated matrix:",
       "         diag(S) * A * diag(S)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(N,1)."],
     "S"=>
      ["[in]",
       "         S is DOUBLE PRECISION array, dimension (N)",
       "         The scale factors for A."],
     "SCOND"=>
      ["[in]",
       "         SCOND is DOUBLE PRECISION",
       "         Ratio of the smallest S(i) to the largest S(i)."],
     "AMAX"=>
      ["[in]",
       "         AMAX is DOUBLE PRECISION",
       "         Absolute value of largest matrix entry."],
     "EQUED"=>
      ["[out]",
       "         EQUED is CHARACTER*1",
       "         Specifies whether or not equilibration was done.",
       "         = 'N':  No equilibration.",
       "         = 'Y':  Equilibration was done, i.e., A has been replaced by",
       "                 diag(S) * A * diag(S)."]}},
 "dgehd2"=>
  {"summary"=>
    ["DGEHD2 reduces a real general matrix A to upper Hessenberg form H by",
     "an orthogonal similarity transformation:  Q**T * A * Q = H ."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "         It is assumed that A is already upper triangular in rows",
       "         and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally",
       "         set by a previous call to DGEBAL; otherwise they should be",
       "         set to 1 and N respectively. See Further Details.",
       "         1 <= ILO <= IHI <= max(1,N)."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the n by n general matrix to be reduced.",
       "         On exit, the upper triangle and the first subdiagonal of A",
       "         are overwritten with the upper Hessenberg matrix H, and the",
       "         elements below the first subdiagonal, with the array TAU,",
       "         represent the orthogonal matrix Q as a product of elementary",
       "         reflectors. See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "TAU"=>
      ["[out]",
       "         TAU is DOUBLE PRECISION array, dimension (N-1)",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "cla_gercond_c"=>
  {"summary"=>
    ["   CLA_GERCOND_C computes the infinity norm condition number of",
     "   op(A) * inv(diag(C)) where C is a REAL vector."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "    Specifies the form of the system of equations:",
       "      = 'N':  A * X = B     (No transpose)",
       "      = 'T':  A**T * X = B  (Transpose)",
       "      = 'C':  A**H * X = B  (Conjugate Transpose = Transpose)"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A"],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX array, dimension (LDAF,N)",
       "    The factors L and U from the factorization",
       "    A = P*L*U as computed by CGETRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    The pivot indices from the factorization A = P*L*U",
       "    as computed by CGETRF; row i of the matrix was interchanged",
       "    with row IPIV(i)."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension (N)",
       "    The vector C in the formula op(A) * inv(diag(C))."],
     "CAPPLY"=>
      ["[in]",
       "         CAPPLY is LOGICAL",
       "    If .TRUE. then access the vector C in the formula above."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "    i > 0:  The ith argument is invalid."],
     "WORK"=>
      ["[in]",
       "         WORK is COMPLEX array, dimension (2*N).",
       "    Workspace."],
     "RWORK"=>
      ["[in]",
       "         RWORK is REAL array, dimension (N).",
       "    Workspace."]}},
 "zlarfx"=>
  {"summary"=>
    ["ZLARFX applies a complex elementary reflector H to a complex m by n",
     "matrix C, from either the left or the right. H is represented in the",
     "form",
     "      H = I - tau * v * v**H",
     "where tau is a complex scalar and v is a complex vector.",
     "If tau = 0, then H is taken to be the unit matrix",
     "This version uses inline code if H has order < 11."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': form  H * C",
       "         = 'R': form  C * H"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C."],
     "V"=>
      ["[in]",
       "         V is COMPLEX*16 array, dimension (M) if SIDE = 'L'",
       "                                       or (N) if SIDE = 'R'",
       "         The vector v in the representation of H."],
     "TAU"=>
      ["[in]",
       "         TAU is COMPLEX*16",
       "         The value tau in the representation of H."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array, dimension (LDC,N)",
       "         On entry, the m by n matrix C.",
       "         On exit, C is overwritten by the matrix H * C if SIDE = 'L',",
       "         or C * H if SIDE = 'R'."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDA >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (N) if SIDE = 'L'",
       "                                           or (M) if SIDE = 'R'",
       "         WORK is not referenced if H has order < 11."]}},
 "csyequb"=>
  {"summary"=>
    ["CSYEQUB computes row and column scalings intended to equilibrate a",
     "symmetric matrix A (with respect to the Euclidean norm) and reduce",
     "its condition number. The scale factors S are computed by the BIN",
     "algorithm (see references) so that the scaled matrix B with elements",
     "B(i,j) = S(i)*A(i,j)*S(j) has a condition number within a factor N of",
     "the smallest possible condition number over all possible diagonal",
     "scalings."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A. N >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         The N-by-N symmetric matrix whose scaling factors are to be",
       "         computed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,N)."],
     "S"=>
      ["[out]",
       "         S is REAL array, dimension (N)",
       "         If INFO = 0, S contains the scale factors for A."],
     "SCOND"=>
      ["[out]",
       "         SCOND is REAL",
       "         If INFO = 0, S contains the ratio of the smallest S(i) to",
       "         the largest S(i). If SCOND >= 0.1 and AMAX is neither too",
       "         large nor too small, it is not worth scaling by S."],
     "AMAX"=>
      ["[out]",
       "         AMAX is REAL",
       "         Largest absolute value of any matrix element. If AMAX is",
       "         very close to overflow or very close to underflow, the",
       "         matrix should be scaled."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (2*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the i-th diagonal element is nonpositive."]}},
 "clapll"=>
  {"summary"=>
    ["Given two column vectors X and Y, let",
     "                     A = ( X Y ).",
     "The subroutine first computes the QR factorization of A = Q*R,",
     "and then computes the SVD of the 2-by-2 upper triangular matrix R.",
     "The smaller singular value of R is returned in SSMIN, which is used",
     "as the measurement of the linear dependency of the vectors X and Y."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The length of the vectors X and Y."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX array, dimension (1+(N-1)*INCX)",
       "         On entry, X contains the N-vector X.",
       "         On exit, X is overwritten."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between successive elements of X. INCX > 0."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array, dimension (1+(N-1)*INCY)",
       "         On entry, Y contains the N-vector Y.",
       "         On exit, Y is overwritten."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "         The increment between successive elements of Y. INCY > 0."],
     "SSMIN"=>
      ["[out]",
       "         SSMIN is REAL",
       "         The smallest singular value of the N-by-2 matrix A = ( X Y )."]}},
 "cgetri"=>
  {"summary"=>
    ["CGETRI computes the inverse of a matrix using the LU factorization",
     "computed by CGETRF.",
     "This method inverts U and then computes inv(A) by solving the system",
     "inv(A)*L = inv(U) for inv(A)."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the factors L and U from the factorization",
       "         A = P*L*U as computed by CGETRF.",
       "         On exit, if INFO = 0, the inverse of the original matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices from CGETRF; for 1<=i<=N, row i of the",
       "         matrix was interchanged with row IPIV(i)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO=0, then WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  LWORK >= max(1,N).",
       "         For optimal performance LWORK >= N*NB, where NB is",
       "         the optimal blocksize returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is",
       "               singular and its inverse could not be computed."]}},
 "sla_porfsx_extended"=>
  {"summary"=>
    ["SLA_PORFSX_EXTENDED improves the computed solution to a system of",
     "linear equations by performing extra-precise iterative refinement",
     "and provides error bounds and backward error estimates for the solution.",
     "This subroutine is called by SPORFSX to perform iterative refinement.",
     "In addition to normwise error bound, the code provides maximum",
     "componentwise error bound if possible. See comments for ERR_BNDS_NORM",
     "and ERR_BNDS_COMP for details of the error bounds. Note that this",
     "subroutine is only resonsible for setting the second fields of",
     "ERR_BNDS_NORM and ERR_BNDS_COMP."],
   "param"=>
    {"PREC_TYPE"=>
      ["[in]",
       "         PREC_TYPE is INTEGER",
       "    Specifies the intermediate precision to be used in refinement.",
       "    The value is defined by ILAPREC(P) where P is a CHARACTER and",
       "    P    = 'S':  Single",
       "         = 'D':  Double",
       "         = 'I':  Indigenous",
       "         = 'X', 'E':  Extra"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "    The number of right-hand-sides, i.e., the number of columns of the",
       "    matrix B."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is REAL array, dimension (LDAF,N)",
       "    The triangular factor U or L from the Cholesky factorization",
       "    A = U**T*U or A = L*L**T, as computed by SPOTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "COLEQU"=>
      ["[in]",
       "         COLEQU is LOGICAL",
       "    If .TRUE. then column equilibration was done to A before calling",
       "    this routine. This is needed to compute the solution and error",
       "    bounds correctly."],
     "C"=>
      ["[in]",
       "         C is REAL array, dimension (N)",
       "    The column scale factors for A. If COLEQU = .FALSE., C",
       "    is not accessed. If C is input, each element of C should be a power",
       "    of the radix to ensure a reliable solution and error estimates.",
       "    Scaling by powers of the radix does not cause rounding errors unless",
       "    the result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "B"=>
      ["[in]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "    The right-hand-side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "    The leading dimension of the array B.  LDB >= max(1,N)."],
     "Y"=>
      ["[in,out]",
       "         Y is REAL array, dimension (LDY,NRHS)",
       "    On entry, the solution matrix X, as computed by SPOTRS.",
       "    On exit, the improved solution matrix Y."],
     "LDY"=>
      ["[in]",
       "         LDY is INTEGER",
       "    The leading dimension of the array Y.  LDY >= max(1,N)."],
     "BERR_OUT"=>
      ["[out]",
       "         BERR_OUT is REAL array, dimension (NRHS)",
       "    On exit, BERR_OUT(j) contains the componentwise relative backward",
       "    error for right-hand-side j from the formula",
       "        max(i) ( abs(RES(i)) / ( abs(op(A_s))*abs(Y) + abs(B_s) )(i) )",
       "    where abs(Z) is the componentwise absolute value of the matrix",
       "    or vector Z. This is computed by SLA_LIN_BERR."],
     "N_NORMS"=>
      ["[in]",
       "         N_NORMS is INTEGER",
       "    Determines which error bounds to return (see ERR_BNDS_NORM",
       "    and ERR_BNDS_COMP).",
       "    If N_NORMS >= 1 return normwise error bounds.",
       "    If N_NORMS >= 2 return componentwise error bounds."],
     "ERR_BNDS_NORM"=>
      ["[in,out]",
       "         ERR_BNDS_NORM is REAL array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    normwise relative error, which is defined as follows:",
       "    Normwise relative error in the ith solution vector:",
       "            max_j (abs(XTRUE(j,i) - X(j,i)))",
       "           ------------------------------",
       "                 max_j abs(X(j,i))",
       "    The array is indexed by the type of error information as described",
       "    below. There currently are up to three pieces of information",
       "    returned.",
       "    The first index in ERR_BNDS_NORM(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_NORM(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated normwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*A, where S scales each row by a power of the",
       "             radix so all absolute row sums of Z are approximately 1.",
       "    This subroutine is only responsible for setting the second field",
       "    above.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "ERR_BNDS_COMP"=>
      ["[in,out]",
       "         ERR_BNDS_COMP is REAL array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    componentwise relative error, which is defined as follows:",
       "    Componentwise relative error in the ith solution vector:",
       "                   abs(XTRUE(j,i) - X(j,i))",
       "            max_j ----------------------",
       "                        abs(X(j,i))",
       "    The array is indexed by the right-hand side i (on which the",
       "    componentwise relative error depends), and the type of error",
       "    information as described below. There currently are up to three",
       "    pieces of information returned for each right-hand side. If",
       "    componentwise accuracy is not requested (PARAMS(3) = 0.0), then",
       "    ERR_BNDS_COMP is not accessed.  If N_ERR_BNDS .LT. 3, then at most",
       "    the first (:,N_ERR_BNDS) entries are returned.",
       "    The first index in ERR_BNDS_COMP(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_COMP(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * slamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * slamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated componentwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * slamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*(A*diag(x)), where x is the solution for the",
       "             current right-hand side and S scales each row of",
       "             A*diag(x) by a power of the radix so all absolute row",
       "             sums of Z are approximately 1.",
       "    This subroutine is only responsible for setting the second field",
       "    above.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "RES"=>
      ["[in]",
       "         RES is REAL array, dimension (N)",
       "    Workspace to hold the intermediate residual."],
     "AYB"=>
      ["[in]",
       "         AYB is REAL array, dimension (N)",
       "    Workspace. This can be the same workspace passed for Y_TAIL."],
     "DY"=>
      ["[in]",
       "         DY is REAL array, dimension (N)",
       "    Workspace to hold the intermediate solution."],
     "Y_TAIL"=>
      ["[in]",
       "         Y_TAIL is REAL array, dimension (N)",
       "    Workspace to hold the trailing bits of the intermediate solution."],
     "RCOND"=>
      ["[in]",
       "         RCOND is REAL",
       "    Reciprocal scaled condition number.  This is an estimate of the",
       "    reciprocal Skeel condition number of the matrix A after",
       "    equilibration (if done).  If this is less than the machine",
       "    precision (in particular, if it is zero), the matrix is singular",
       "    to working precision.  Note that the error may still be small even",
       "    if this number is very small and the matrix appears ill-",
       "    conditioned."],
     "ITHRESH"=>
      ["[in]",
       "         ITHRESH is INTEGER",
       "    The maximum number of residual computations allowed for",
       "    refinement. The default is 10. For 'aggressive' set to 100 to",
       "    permit convergence using approximate factorizations or",
       "    factorizations other than LU. If the factorization uses a",
       "    technique other than Gaussian elimination, the guarantees in",
       "    ERR_BNDS_NORM and ERR_BNDS_COMP may no longer be trustworthy."],
     "RTHRESH"=>
      ["[in]",
       "         RTHRESH is REAL",
       "    Determines when to stop refinement if the error estimate stops",
       "    decreasing. Refinement will stop when the next solution no longer",
       "    satisfies norm(dx_{i+1}) < RTHRESH * norm(dx_i) where norm(Z) is",
       "    the infinity norm of Z. RTHRESH satisfies 0 < RTHRESH <= 1. The",
       "    default value is 0.5. For 'aggressive' set to 0.9 to permit",
       "    convergence on extremely ill-conditioned matrices. See LAWN 165",
       "    for more details."],
     "DZ_UB"=>
      ["[in]",
       "         DZ_UB is REAL",
       "    Determines when to start considering componentwise convergence.",
       "    Componentwise convergence is only considered after each component",
       "    of the solution Y is stable, which we definte as the relative",
       "    change in each component being less than DZ_UB. The default value",
       "    is 0.25, requiring the first bit to be stable. See LAWN 165 for",
       "    more details."],
     "IGNORE_CWISE"=>
      ["[in]",
       "         IGNORE_CWISE is LOGICAL",
       "    If .TRUE. then ignore componentwise convergence. Default value",
       "    is .FALSE.."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit.",
       "      < 0:  if INFO = -i, the ith argument to SPOTRS had an illegal",
       "            value"]}},
 "chetrd_2stage"=>
  {"summary"=>
    ["CHETRD_2STAGE reduces a complex Hermitian matrix A to real symmetric",
     "tridiagonal form T by a unitary similarity transformation:",
     "Q1**H Q2**H* A * Q2 * Q1 = T."],
   "param"=>
    {"VECT"=>
      ["[in]",
       "         VECT is CHARACTER*1",
       "         = 'N':  No need for the Housholder representation, ",
       "                 in particular for the second stage (Band to",
       "                 tridiagonal) and thus LHOUS2 is of size max(1, 4*N);",
       "         = 'V':  the Householder representation is needed to ",
       "                 either generate Q1 Q2 or to apply Q1 Q2, ",
       "                 then LHOUS2 is to be queried and computed.",
       "                 (NOT AVAILABLE IN THIS RELEASE)."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if UPLO = 'U', the band superdiagonal",
       "         of A are overwritten by the corresponding elements of the",
       "         internal band-diagonal matrix AB, and the elements above ",
       "         the KD superdiagonal, with the array TAU, represent the unitary",
       "         matrix Q1 as a product of elementary reflectors; if UPLO",
       "         = 'L', the diagonal and band subdiagonal of A are over-",
       "         written by the corresponding elements of the internal band-diagonal",
       "         matrix AB, and the elements below the KD subdiagonal, with",
       "         the array TAU, represent the unitary matrix Q1 as a product",
       "         of elementary reflectors. See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "D"=>
      ["[out]",
       "         D is REAL array, dimension (N)",
       "         The diagonal elements of the tridiagonal matrix T."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (N-1)",
       "         The off-diagonal elements of the tridiagonal matrix T."],
     "TAU"=>
      ["[out]",
       "         TAU is COMPLEX array, dimension (N-KD)",
       "         The scalar factors of the elementary reflectors of ",
       "         the first stage (see Further Details)."],
     "HOUS2"=>
      ["[out]",
       "         HOUS2 is COMPLEX array, dimension LHOUS2, that",
       "         store the Householder representation of the stage2",
       "         band to tridiagonal."],
     "LHOUS2"=>
      ["[in]",
       "         LHOUS2 is INTEGER",
       "         The dimension of the array HOUS2. LHOUS2 = MAX(1, dimension)",
       "         If LWORK = -1, or LHOUS2=-1,",
       "         then a query is assumed; the routine",
       "         only calculates the optimal size of the HOUS2 array, returns",
       "         this value as the first entry of the HOUS2 array, and no error",
       "         message related to LHOUS2 is issued by XERBLA.",
       "         LHOUS2 = MAX(1, dimension) where",
       "         dimension = 4*N if VECT='N'",
       "         not available now if VECT='H'"],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK = MAX(1, dimension)",
       "         If LWORK = -1, or LHOUS2=-1,",
       "         then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA.",
       "         LWORK = MAX(1, dimension) where",
       "         dimension   = max(stage1,stage2) + (KD+1)*N",
       "                     = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                       + max(2*KD*KD, KD*NTHREADS) ",
       "                       + (KD+1)*N ",
       "         where KD is the blocking size of the reduction,",
       "         FACTOPTNB is the blocking used by the QR or LQ",
       "         algorithm, usually FACTOPTNB=128 is a good choice",
       "         NTHREADS is the number of threads used when",
       "         openMP compilation is enabled, otherwise =1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dlaed7"=>
  {"summary"=>
    ["DLAED7 computes the updated eigensystem of a diagonal",
     "matrix after modification by a rank-one symmetric matrix. This",
     "routine is used only for the eigenproblem which requires all",
     "eigenvalues and optionally eigenvectors of a dense symmetric matrix",
     "that has been reduced to tridiagonal form.  DLAED1 handles",
     "the case in which all eigenvalues and eigenvectors of a symmetric",
     "tridiagonal matrix are desired.",
     "  T = Q(in) ( D(in) + RHO * Z*Z**T ) Q**T(in) = Q(out) * D(out) * Q**T(out)",
     "   where Z = Q**Tu, u is a vector of length N with ones in the",
     "   CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.",
     "   The eigenvectors of the original matrix are stored in Q, and the",
     "   eigenvalues are in D.  The algorithm consists of three stages:",
     "      The first stage consists of deflating the size of the problem",
     "      when there are multiple eigenvalues or if there is a zero in",
     "      the Z vector.  For each such occurrence the dimension of the",
     "      secular equation problem is reduced by one.  This stage is",
     "      performed by the routine DLAED8.",
     "      The second stage consists of calculating the updated",
     "      eigenvalues. This is done by finding the roots of the secular",
     "      equation via the routine DLAED4 (as called by DLAED9).",
     "      This routine also calculates the eigenvectors of the current",
     "      problem.",
     "      The final stage consists of computing the updated eigenvectors",
     "      directly using the updated eigenvalues.  The eigenvectors for",
     "      the current problem are multiplied with the eigenvectors from",
     "      the overall problem."],
   "param"=>
    {"ICOMPQ"=>
      ["[in]",
       "         ICOMPQ is INTEGER",
       "         = 0:  Compute eigenvalues only.",
       "         = 1:  Compute eigenvectors of original dense symmetric matrix",
       "               also.  On entry, Q contains the orthogonal matrix used",
       "               to reduce the original matrix to tridiagonal form."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "        The dimension of the symmetric tridiagonal matrix.  N >= 0."],
     "QSIZ"=>
      ["[in]",
       "         QSIZ is INTEGER",
       "        The dimension of the orthogonal matrix used to reduce",
       "        the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1."],
     "TLVLS"=>
      ["[in]",
       "         TLVLS is INTEGER",
       "        The total number of merging levels in the overall divide and",
       "        conquer tree."],
     "CURLVL"=>
      ["[in]",
       "         CURLVL is INTEGER",
       "        The current level in the overall merge routine,",
       "        0 <= CURLVL <= TLVLS."],
     "CURPBM"=>
      ["[in]",
       "         CURPBM is INTEGER",
       "        The current problem in the current level in the overall",
       "        merge routine (counting from upper left to lower right)."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "        On entry, the eigenvalues of the rank-1-perturbed matrix.",
       "        On exit, the eigenvalues of the repaired matrix."],
     "Q"=>
      ["[in,out]",
       "         Q is DOUBLE PRECISION array, dimension (LDQ, N)",
       "        On entry, the eigenvectors of the rank-1-perturbed matrix.",
       "        On exit, the eigenvectors of the repaired tridiagonal matrix."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "        The leading dimension of the array Q.  LDQ >= max(1,N)."],
     "INDXQ"=>
      ["[out]",
       "         INDXQ is INTEGER array, dimension (N)",
       "        The permutation which will reintegrate the subproblem just",
       "        solved back into sorted order, i.e., D( INDXQ( I = 1, N ) )",
       "        will be in ascending order."],
     "RHO"=>
      ["[in]",
       "         RHO is DOUBLE PRECISION",
       "        The subdiagonal element used to create the rank-1",
       "        modification."],
     "CUTPNT"=>
      ["[in]",
       "         CUTPNT is INTEGER",
       "        Contains the location of the last eigenvalue in the leading",
       "        sub-matrix.  min(1,N) <= CUTPNT <= N."],
     "QSTORE"=>
      ["[in,out]",
       "         QSTORE is DOUBLE PRECISION array, dimension (N**2+1)",
       "        Stores eigenvectors of submatrices encountered during",
       "        divide and conquer, packed together. QPTR points to",
       "        beginning of the submatrices."],
     "QPTR"=>
      ["[in,out]",
       "         QPTR is INTEGER array, dimension (N+2)",
       "        List of indices pointing to beginning of submatrices stored",
       "        in QSTORE. The submatrices are numbered starting at the",
       "        bottom left of the divide and conquer tree, from left to",
       "        right and bottom to top."],
     "PRMPTR"=>
      ["[in]",
       "         PRMPTR is INTEGER array, dimension (N lg N)",
       "        Contains a list of pointers which indicate where in PERM a",
       "        level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)",
       "        indicates the size of the permutation and also the size of",
       "        the full, non-deflated problem."],
     "PERM"=>
      ["[in]",
       "         PERM is INTEGER array, dimension (N lg N)",
       "        Contains the permutations (from deflation and sorting) to be",
       "        applied to each eigenblock."],
     "GIVPTR"=>
      ["[in]",
       "         GIVPTR is INTEGER array, dimension (N lg N)",
       "        Contains a list of pointers which indicate where in GIVCOL a",
       "        level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)",
       "        indicates the number of Givens rotations."],
     "GIVCOL"=>
      ["[in]",
       "         GIVCOL is INTEGER array, dimension (2, N lg N)",
       "        Each pair of numbers indicates a pair of columns to take place",
       "        in a Givens rotation."],
     "GIVNUM"=>
      ["[in]",
       "         GIVNUM is DOUBLE PRECISION array, dimension (2, N lg N)",
       "        Each number indicates the S value to be used in the",
       "        corresponding Givens rotation."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (3*N+2*QSIZ*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (4*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  if INFO = 1, an eigenvalue did not converge"]}},
 "zsytf2"=>
  {"summary"=>
    ["ZSYTF2 computes the factorization of a complex symmetric matrix A",
     "using the Bunch-Kaufman diagonal pivoting method:",
     "   A = U*D*U**T  or  A = L*D*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, U**T is the transpose of U, and D is symmetric and",
     "block diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "This is the unblocked version of the algorithm, calling Level 2 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         n-by-n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n-by-n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L (see below for further details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If UPLO = 'U':",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k-1) < 0, then rows and columns",
       "            k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "            is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k+1) < 0, then rows and columns",
       "            k+1 and -IPIV(k) were interchanged and D(k:k+1,k:k+1)",
       "            is a 2-by-2 diagonal block."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value",
       "         > 0: if INFO = k, D(k,k) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if it",
       "              is used to solve a system of equations."]}},
 "sgesvxx"=>
  {"summary"=>
    ["   SGESVXX uses the LU factorization to compute the solution to a",
     "   real system of linear equations  A * X = B,  where A is an",
     "   N-by-N matrix and X and B are N-by-NRHS matrices.",
     "   If requested, both normwise and maximum componentwise error bounds",
     "   are returned. SGESVXX will return a solution with a tiny",
     "   guaranteed error (O(eps) where eps is the working machine",
     "   precision) unless the matrix is very ill-conditioned, in which",
     "   case a warning is returned. Relevant condition numbers also are",
     "   calculated and returned.",
     "   SGESVXX accepts user-provided factorizations and equilibration",
     "   factors; see the definitions of the FACT and EQUED options.",
     "   Solving with refinement and using a factorization from a previous",
     "   SGESVXX call will also produce a solution with either O(eps)",
     "   errors or warnings, but we cannot make that claim for general",
     "   user-provided factorizations and equilibration factors if they",
     "   differ from what SGESVXX would itself produce."],
   "param"=>nil},
 "cppsvx"=>
  {"summary"=>
    ["CPPSVX uses the Cholesky factorization A = U**H*U or A = L*L**H to",
     "compute the solution to a complex system of linear equations",
     "   A * X = B,",
     "where A is an N-by-N Hermitian positive definite matrix stored in",
     "packed format and X and B are N-by-NRHS matrices.",
     "Error bounds on the solution and a condition estimate are also",
     "provided."],
   "param"=>nil},
 "stpqrt"=>
  {"summary"=>
    ["STPQRT computes a blocked QR factorization of a real",
     "\"triangular-pentagonal\" matrix C, which is composed of a",
     "triangular block A and pentagonal block B, using the compact",
     "WY representation for Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B, and the order of the",
       "         triangular matrix A.",
       "         N >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of rows of the upper trapezoidal part of B.",
       "         MIN(M,N) >= L >= 0.  See Further Details."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The block size to be used in the blocked QR.  N >= NB >= 1."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the upper triangular N-by-N matrix A.",
       "         On exit, the elements on and above the diagonal of the array",
       "         contain the upper triangular matrix R."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,N)",
       "         On entry, the pentagonal M-by-N matrix B.  The first M-L rows",
       "         are rectangular, and the last L rows are upper trapezoidal.",
       "         On exit, B contains the pentagonal matrix V.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is REAL array, dimension (LDT,N)",
       "         The upper triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See Further Details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= NB."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (NB*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "stprfb"=>
  {"summary"=>
    ["STPRFB applies a real \"triangular-pentagonal\" block reflector H or its",
     "conjugate transpose H^H to a real matrix C, which is composed of two",
     "blocks A and B, either from the left or right."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply H or H^H from the Left",
       "         = 'R': apply H or H^H from the Right"],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N': apply H (No transpose)",
       "         = 'C': apply H^H (Conjugate transpose)"],
     "DIRECT"=>
      ["[in]",
       "         DIRECT is CHARACTER*1",
       "         Indicates how H is formed from a product of elementary",
       "         reflectors",
       "         = 'F': H = H(1) H(2) . . . H(k) (Forward)",
       "         = 'B': H = H(k) . . . H(2) H(1) (Backward)"],
     "STOREV"=>
      ["[in]",
       "         STOREV is CHARACTER*1",
       "         Indicates how the vectors which define the elementary",
       "         reflectors are stored:",
       "         = 'C': Columns",
       "         = 'R': Rows"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B.",
       "         N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The order of the matrix T, i.e. the number of elementary",
       "         reflectors whose product defines the block reflector.",
       "         K >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The order of the trapezoidal part of V.",
       "         K >= L >= 0.  See Further Details."],
     "V"=>
      ["[in]",
       "         V is REAL array, dimension",
       "                               (LDV,K) if STOREV = 'C'",
       "                               (LDV,M) if STOREV = 'R' and SIDE = 'L'",
       "                               (LDV,N) if STOREV = 'R' and SIDE = 'R'",
       "         The pentagonal matrix V, which contains the elementary reflectors",
       "         H(1), H(2), ..., H(K).  See Further Details."],
     "LDV"=>
      ["[in]",
       "         LDV is INTEGER",
       "         The leading dimension of the array V.",
       "         If STOREV = 'C' and SIDE = 'L', LDV >= max(1,M);",
       "         if STOREV = 'C' and SIDE = 'R', LDV >= max(1,N);",
       "         if STOREV = 'R', LDV >= K."],
     "T"=>
      ["[in]",
       "         T is REAL array, dimension (LDT,K)",
       "         The triangular K-by-K matrix T in the representation of the",
       "         block reflector."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.",
       "         LDT >= K."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension",
       "         (LDA,N) if SIDE = 'L' or (LDA,K) if SIDE = 'R'",
       "         On entry, the K-by-N or M-by-K matrix A.",
       "         On exit, A is overwritten by the corresponding block of",
       "         H*C or H^H*C or C*H or C*H^H.  See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.",
       "         If SIDE = 'L', LDC >= max(1,K);",
       "         If SIDE = 'R', LDC >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,N)",
       "         On entry, the M-by-N matrix B.",
       "         On exit, B is overwritten by the corresponding block of",
       "         H*C or H^H*C or C*H or C*H^H.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.",
       "         LDB >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension",
       "         (LDWORK,N) if SIDE = 'L',",
       "         (LDWORK,K) if SIDE = 'R'."],
     "LDWORK"=>
      ["[in]",
       "         LDWORK is INTEGER",
       "         The leading dimension of the array WORK.",
       "         If SIDE = 'L', LDWORK >= K;",
       "         if SIDE = 'R', LDWORK >= M."]}},
 "ssytrd_sy2sb"=>
  {"summary"=>
    ["SSYTRD_SY2SB reduces a real symmetric matrix A to real symmetric",
     "band-diagonal form AB by a orthogonal similarity transformation:",
     "Q**T * A * Q = AB."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the reduced matrix if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0.",
       "         The reduced matrix is stored in the array AB."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if UPLO = 'U', the diagonal and first superdiagonal",
       "         of A are overwritten by the corresponding elements of the",
       "         tridiagonal matrix T, and the elements above the first",
       "         superdiagonal, with the array TAU, represent the orthogonal",
       "         matrix Q as a product of elementary reflectors; if UPLO",
       "         = 'L', the diagonal and first subdiagonal of A are over-",
       "         written by the corresponding elements of the tridiagonal",
       "         matrix T, and the elements below the first subdiagonal, with",
       "         the array TAU, represent the orthogonal matrix Q as a product",
       "         of elementary reflectors. See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "AB"=>
      ["[out]",
       "         AB is REAL array, dimension (LDAB,N)",
       "         On exit, the upper or lower triangle of the symmetric band",
       "         matrix A, stored in the first KD+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd)."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD+1."],
     "TAU"=>
      ["[out]",
       "         TAU is REAL array, dimension (N-KD)",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension LWORK.",
       "         On exit, if INFO = 0, or if LWORK=-1, ",
       "         WORK(1) returns the size of LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK which should be calculated",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA.",
       "         LWORK_QUERY = N*KD + N*max(KD,FACTOPTNB) + 2*KD*KD",
       "         where FACTOPTNB is the blocking used by the QR or LQ",
       "         algorithm, usually FACTOPTNB=128 is a good choice otherwise",
       "         putting LWORK=-1 will provide the size of WORK."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zhpsv"=>
  {"summary"=>
    ["ZHPSV computes the solution to a complex system of linear equations",
     "   A * X = B,",
     "where A is an N-by-N Hermitian matrix stored in packed format and X",
     "and B are N-by-NRHS matrices.",
     "The diagonal pivoting method is used to factor A as",
     "   A = U * D * U**H,  if UPLO = 'U', or",
     "   A = L * D * L**H,  if UPLO = 'L',",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, D is Hermitian and block diagonal with 1-by-1",
     "and 2-by-2 diagonal blocks.  The factored form of A is then used to",
     "solve the system of equations A * X = B."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of linear equations, i.e., the order of the",
       "         matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX*16 array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the Hermitian matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         See below for further details.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L from the factorization",
       "         A = U*D*U**H or A = L*D*L**H as computed by ZHPTRF, stored as",
       "         a packed triangular matrix in the same storage format as A."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D, as",
       "         determined by ZHPTRF.  If IPIV(k) > 0, then rows and columns",
       "         k and IPIV(k) were interchanged, and D(k,k) is a 1-by-1",
       "         diagonal block.  If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0,",
       "         then rows and columns k-1 and -IPIV(k) were interchanged and",
       "         D(k-1:k,k-1:k) is a 2-by-2 diagonal block.  If UPLO = 'L' and",
       "         IPIV(k) = IPIV(k+1) < 0, then rows and columns k+1 and",
       "         -IPIV(k) were interchanged and D(k:k+1,k:k+1) is a 2-by-2",
       "         diagonal block."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "         On entry, the N-by-NRHS right hand side matrix B.",
       "         On exit, if INFO = 0, the N-by-NRHS solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, so the solution could not be",
       "               computed."]}},
 "zhegvd"=>
  {"summary"=>
    ["ZHEGVD computes all the eigenvalues, and optionally, the eigenvectors",
     "of a complex generalized Hermitian-definite eigenproblem, of the form",
     "A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.  Here A and",
     "B are assumed to be Hermitian and B is also positive definite.",
     "If eigenvectors are desired, it uses a divide and conquer algorithm.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         Specifies the problem type to be solved:",
       "         = 1:  A*x = (lambda)*B*x",
       "         = 2:  A*B*x = (lambda)*x",
       "         = 3:  B*A*x = (lambda)*x"],
     "JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA, N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         matrix Z of eigenvectors.  The eigenvectors are normalized",
       "         as follows:",
       "         if ITYPE = 1 or 2, Z**H*B*Z = I;",
       "         if ITYPE = 3, Z**H*inv(B)*Z = I.",
       "         If JOBZ = 'N', then on exit the upper triangle (if UPLO='U')",
       "         or the lower triangle (if UPLO='L') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB, N)",
       "         On entry, the Hermitian matrix B.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of B contains the",
       "         upper triangular part of the matrix B.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of B contains",
       "         the lower triangular part of the matrix B.",
       "         On exit, if INFO <= N, the part of B containing the matrix is",
       "         overwritten by the triangular factor U or L from the Cholesky",
       "         factorization B = U**H*U or B = L*L**H."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.",
       "         If N <= 1,                LWORK >= 1.",
       "         If JOBZ  = 'N' and N > 1, LWORK >= N + 1.",
       "         If JOBZ  = 'V' and N > 1, LWORK >= 2*N + N**2.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal sizes of the WORK, RWORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]",
       "         RWORK is DOUBLE PRECISION array, dimension (MAX(1,LRWORK))",
       "         On exit, if INFO = 0, RWORK(1) returns the optimal LRWORK."],
     "LRWORK"=>
      ["[in]",
       "         LRWORK is INTEGER",
       "         The dimension of the array RWORK.",
       "         If N <= 1,                LRWORK >= 1.",
       "         If JOBZ  = 'N' and N > 1, LRWORK >= N.",
       "         If JOBZ  = 'V' and N > 1, LRWORK >= 1 + 5*N + 2*N**2.",
       "         If LRWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK, RWORK",
       "         and IWORK arrays, returns these values as the first entries",
       "         of the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         If N <= 1,                LIWORK >= 1.",
       "         If JOBZ  = 'N' and N > 1, LIWORK >= 1.",
       "         If JOBZ  = 'V' and N > 1, LIWORK >= 3 + 5*N.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK, RWORK",
       "         and IWORK arrays, returns these values as the first entries",
       "         of the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  ZPOTRF or ZHEEVD returned an error code:",
       "            <= N:  if INFO = i and JOBZ = 'N', then the algorithm",
       "                   failed to converge; i off-diagonal elements of an",
       "                   intermediate tridiagonal form did not converge to",
       "                   zero;",
       "                   if INFO = i and JOBZ = 'V', then the algorithm",
       "                   failed to compute an eigenvalue while working on",
       "                   the submatrix lying in rows and columns INFO/(N+1)",
       "                   through mod(INFO,N+1);",
       "            > N:   if INFO = N + i, for 1 <= i <= N, then the leading",
       "                   minor of order i of B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "zla_syrpvgrw"=>
  {"summary"=>
    ["ZLA_SYRPVGRW computes the reciprocal pivot growth factor",
     "norm(A)/norm(U). The \"max absolute element\" norm is used. If this is",
     "much less than 1, the stability of the LU factorization of the",
     "(equilibrated) matrix A could be poor. This also means that the",
     "solution X, estimated condition numbers, and error bounds could be",
     "unreliable."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "INFO"=>
      ["[in]",
       "         INFO is INTEGER",
       "    The value of INFO returned from ZSYTRF, .i.e., the pivot in",
       "    column INFO is exactly 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX*16 array, dimension (LDAF,N)",
       "    The block diagonal matrix D and the multipliers used to",
       "    obtain the factor U or L as computed by ZSYTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    Details of the interchanges and the block structure of D",
       "    as determined by ZSYTRF."],
     "WORK"=>
      ["[in]", "         WORK is DOUBLE PRECISION array, dimension (2*N)"]}},
 "sspcon"=>
  {"summary"=>
    ["SSPCON estimates the reciprocal of the condition number (in the",
     "1-norm) of a real symmetric packed matrix A using the factorization",
     "A = U*D*U**T or A = L*D*L**T computed by SSPTRF.",
     "An estimate is obtained for norm(inv(A)), and the reciprocal of the",
     "condition number is computed as RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in]",
       "         AP is REAL array, dimension (N*(N+1)/2)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by SSPTRF, stored as a",
       "         packed triangular matrix."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by SSPTRF."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         The 1-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an",
       "         estimate of the 1-norm of inv(A) computed in this routine."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (2*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zlartv"=>
  {"summary"=>
    ["ZLARTV applies a vector of complex plane rotations with real cosines",
     "to elements of the complex vectors x and y. For i = 1,2,...,n",
     "   ( x(i) ) := (        c(i)   s(i) ) ( x(i) )",
     "   ( y(i) )    ( -conjg(s(i))  c(i) ) ( y(i) )"],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of plane rotations to be applied."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array, dimension (1+(N-1)*INCX)",
       "         The vector x."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between elements of X. INCX > 0."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX*16 array, dimension (1+(N-1)*INCY)",
       "         The vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "         The increment between elements of Y. INCY > 0."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (1+(N-1)*INCC)",
       "         The cosines of the plane rotations."],
     "S"=>
      ["[in]",
       "         S is COMPLEX*16 array, dimension (1+(N-1)*INCC)",
       "         The sines of the plane rotations."],
     "INCC"=>
      ["[in]",
       "         INCC is INTEGER",
       "         The increment between elements of C and S. INCC > 0."]}},
 "dlaqge"=>
  {"summary"=>
    ["DLAQGE equilibrates a general M by N matrix A using the row and",
     "column scaling factors in the vectors R and C."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the M by N matrix A.",
       "         On exit, the equilibrated matrix.  See EQUED for the form of",
       "         the equilibrated matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(M,1)."],
     "R"=>
      ["[in]",
       "         R is DOUBLE PRECISION array, dimension (M)",
       "         The row scale factors for A."],
     "C"=>
      ["[in]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "         The column scale factors for A."],
     "ROWCND"=>
      ["[in]",
       "         ROWCND is DOUBLE PRECISION",
       "         Ratio of the smallest R(i) to the largest R(i)."],
     "COLCND"=>
      ["[in]",
       "         COLCND is DOUBLE PRECISION",
       "         Ratio of the smallest C(i) to the largest C(i)."],
     "AMAX"=>
      ["[in]",
       "         AMAX is DOUBLE PRECISION",
       "         Absolute value of largest matrix entry."],
     "EQUED"=>
      ["[out]",
       "         EQUED is CHARACTER*1",
       "         Specifies the form of equilibration that was done.",
       "         = 'N':  No equilibration",
       "         = 'R':  Row equilibration, i.e., A has been premultiplied by",
       "                 diag(R).",
       "         = 'C':  Column equilibration, i.e., A has been postmultiplied",
       "                 by diag(C).",
       "         = 'B':  Both row and column equilibration, i.e., A has been",
       "                 replaced by diag(R) * A * diag(C)."]}},
 "cgelq2"=>
  {"summary"=>
    ["CGELQ2 computes an LQ factorization of a complex m by n matrix A:",
     "A = L * Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the m by n matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the m by min(m,n) lower trapezoidal matrix L (L is",
       "         lower triangular if m <= n); the elements above the diagonal,",
       "         with the array TAU, represent the unitary matrix Q as a",
       "         product of elementary reflectors (see Further Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is COMPLEX array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "ssytrf_aa"=>
  {"summary"=>
    ["SSYTRF_AA computes the factorization of a real symmetric matrix A",
     "using the Aasen's algorithm.  The form of the factorization is",
     "   A = U*T*U**T  or  A = L*T*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and T is a symmetric tridiagonal matrix.",
     "This is the blocked version of the algorithm, calling Level 3 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, the tridiagonal matrix is stored in the diagonals",
       "         and the subdiagonals of A just below (or above) the diagonals,",
       "         and L is stored below (or above) the subdiaonals, when UPLO",
       "         is 'L' (or 'U')."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         On exit, it contains the details of the interchanges, i.e.,",
       "         the row and column k of A were interchanged with the",
       "         row and column IPIV(k)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >= MAX(1,2*N). For optimum performance",
       "         LWORK >= N*(1+NB), where NB is the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, D(i,i) is exactly zero.  The factorization",
       "               has been completed, but the block diagonal matrix D is",
       "               exactly singular, and division by zero will occur if it",
       "               is used to solve a system of equations."]}},
 "csymv"=>
  {"summary"=>
    ["CSYMV  performs the matrix-vector  operation",
     "   y := alpha*A*x + beta*y,",
     "where alpha and beta are scalars, x and y are n element vectors and",
     "A is an n by n symmetric matrix."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "          On entry, UPLO specifies whether the upper or lower",
       "          triangular part of the array A is to be referenced as",
       "          follows:",
       "             UPLO = 'U' or 'u'   Only the upper triangular part of A",
       "                                 is to be referenced.",
       "             UPLO = 'L' or 'l'   Only the lower triangular part of A",
       "                                 is to be referenced.",
       "          Unchanged on exit."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          On entry, N specifies the order of the matrix A.",
       "          N must be at least zero.",
       "          Unchanged on exit."],
     "ALPHA"=>
      ["[in]",
       "         ALPHA is COMPLEX",
       "          On entry, ALPHA specifies the scalar alpha.",
       "          Unchanged on exit."],
     "A"=>
      ["[in]",
       "         A is COMPLEX array, dimension ( LDA, N )",
       "          Before entry, with  UPLO = 'U' or 'u', the leading n by n",
       "          upper triangular part of the array A must contain the upper",
       "          triangular part of the symmetric matrix and the strictly",
       "          lower triangular part of A is not referenced.",
       "          Before entry, with UPLO = 'L' or 'l', the leading n by n",
       "          lower triangular part of the array A must contain the lower",
       "          triangular part of the symmetric matrix and the strictly",
       "          upper triangular part of A is not referenced.",
       "          Unchanged on exit."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "          On entry, LDA specifies the first dimension of A as declared",
       "          in the calling (sub) program. LDA must be at least",
       "          max( 1, N ).",
       "          Unchanged on exit."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array, dimension at least",
       "          ( 1 + ( N - 1 )*abs( INCX ) ).",
       "          Before entry, the incremented array X must contain the N-",
       "          element vector x.",
       "          Unchanged on exit."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "          On entry, INCX specifies the increment for the elements of",
       "          X. INCX must not be zero.",
       "          Unchanged on exit."],
     "BETA"=>
      ["[in]",
       "         BETA is COMPLEX",
       "          On entry, BETA specifies the scalar beta. When BETA is",
       "          supplied as zero then Y need not be set on input.",
       "          Unchanged on exit."],
     "Y"=>
      ["[in,out]",
       "         Y is COMPLEX array, dimension at least",
       "          ( 1 + ( N - 1 )*abs( INCY ) ).",
       "          Before entry, the incremented array Y must contain the n",
       "          element vector y. On exit, Y is overwritten by the updated",
       "          vector y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "          On entry, INCY specifies the increment for the elements of",
       "          Y. INCY must not be zero.",
       "          Unchanged on exit."]}},
 "dormlq"=>
  {"summary"=>
    ["DORMLQ overwrites the general real M-by-N matrix C with",
     "                SIDE = 'L'     SIDE = 'R'",
     "TRANS = 'N':      Q * C          C * Q",
     "TRANS = 'T':      Q**T * C       C * Q**T",
     "where Q is a real orthogonal matrix defined as the product of k",
     "elementary reflectors",
     "      Q = H(k) . . . H(2) H(1)",
     "as returned by DGELQF. Q is of order M if SIDE = 'L' and of order N",
     "if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**T from the Left;",
       "         = 'R': apply Q or Q**T from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'T':  Transpose, apply Q**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension",
       "                              (LDA,M) if SIDE = 'L',",
       "                              (LDA,N) if SIDE = 'R'",
       "         The i-th row must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         DGELQF in the first k rows of its array argument A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,K)."],
     "TAU"=>
      ["[in]",
       "         TAU is DOUBLE PRECISION array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by DGELQF."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If SIDE = 'L', LWORK >= max(1,N);",
       "         if SIDE = 'R', LWORK >= max(1,M).",
       "         For good performance, LWORK should generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dgbbrd"=>
  {"summary"=>
    ["DGBBRD reduces a real general m-by-n band matrix A to upper",
     "bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.",
     "The routine computes B, and optionally forms Q or P**T, or computes",
     "Q**T*C for a given matrix C."],
   "param"=>
    {"VECT"=>
      ["[in]",
       "         VECT is CHARACTER*1",
       "         Specifies whether or not the matrices Q and P**T are to be",
       "         formed.",
       "         = 'N': do not form Q or P**T;",
       "         = 'Q': form Q only;",
       "         = 'P': form P**T only;",
       "         = 'B': form both."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "NCC"=>
      ["[in]",
       "         NCC is INTEGER",
       "         The number of columns of the matrix C.  NCC >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "         The number of subdiagonals of the matrix A. KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "         The number of superdiagonals of the matrix A. KU >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is DOUBLE PRECISION array, dimension (LDAB,N)",
       "         On entry, the m-by-n band matrix A, stored in rows 1 to",
       "         KL+KU+1. The j-th column of A is stored in the j-th column of",
       "         the array AB as follows:",
       "         AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).",
       "         On exit, A is overwritten by values generated during the",
       "         reduction."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array A. LDAB >= KL+KU+1."],
     "D"=>
      ["[out]",
       "         D is DOUBLE PRECISION array, dimension (min(M,N))",
       "         The diagonal elements of the bidiagonal matrix B."],
     "E"=>
      ["[out]",
       "         E is DOUBLE PRECISION array, dimension (min(M,N)-1)",
       "         The superdiagonal elements of the bidiagonal matrix B."],
     "Q"=>
      ["[out]",
       "         Q is DOUBLE PRECISION array, dimension (LDQ,M)",
       "         If VECT = 'Q' or 'B', the m-by-m orthogonal matrix Q.",
       "         If VECT = 'N' or 'P', the array Q is not referenced."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.",
       "         LDQ >= max(1,M) if VECT = 'Q' or 'B'; LDQ >= 1 otherwise."],
     "PT"=>
      ["[out]",
       "         PT is DOUBLE PRECISION array, dimension (LDPT,N)",
       "         If VECT = 'P' or 'B', the n-by-n orthogonal matrix P'.",
       "         If VECT = 'N' or 'Q', the array PT is not referenced."],
     "LDPT"=>
      ["[in]",
       "         LDPT is INTEGER",
       "         The leading dimension of the array PT.",
       "         LDPT >= max(1,N) if VECT = 'P' or 'B'; LDPT >= 1 otherwise."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array, dimension (LDC,NCC)",
       "         On entry, an m-by-ncc matrix C.",
       "         On exit, C is overwritten by Q**T*C.",
       "         C is not referenced if NCC = 0."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C.",
       "         LDC >= max(1,M) if NCC > 0; LDC >= 1 if NCC = 0."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (2*max(M,N))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "clansp"=>
  {"summary"=>
    ["CLANSP  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the  element of  largest absolute value  of a",
     "complex symmetric matrix A,  supplied in packed form.",
     "   CLANSP = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in CLANSP as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is supplied.",
       "         = 'U':  Upper triangular part of A is supplied",
       "         = 'L':  Lower triangular part of A is supplied"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, CLANSP is",
       "         set to zero."],
     "AP"=>
      ["[in]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         The upper or lower triangle of the symmetric matrix A, packed",
       "         columnwise in a linear array.  The j-th column of A is stored",
       "         in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,",
       "         WORK is not referenced."]}},
 "zlabrd"=>
  {"summary"=>
    ["ZLABRD reduces the first NB rows and columns of a complex general",
     "m by n matrix A to upper or lower real bidiagonal form by a unitary",
     "transformation Q**H * A * P, and returns the matrices X and Y which",
     "are needed to apply the transformation to the unreduced part of A.",
     "If m >= n, A is reduced to upper bidiagonal form; if m < n, to lower",
     "bidiagonal form.",
     "This is an auxiliary routine called by ZGEBRD"],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows in the matrix A."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns in the matrix A."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The number of leading rows and columns of A to be reduced."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the m by n general matrix to be reduced.",
       "         On exit, the first NB rows and columns of the matrix are",
       "         overwritten; the rest of the array is unchanged.",
       "         If m >= n, elements on and below the diagonal in the first NB",
       "           columns, with the array TAUQ, represent the unitary",
       "           matrix Q as a product of elementary reflectors; and",
       "           elements above the diagonal in the first NB rows, with the",
       "           array TAUP, represent the unitary matrix P as a product",
       "           of elementary reflectors.",
       "         If m < n, elements below the diagonal in the first NB",
       "           columns, with the array TAUQ, represent the unitary",
       "           matrix Q as a product of elementary reflectors, and",
       "           elements on and above the diagonal in the first NB rows,",
       "           with the array TAUP, represent the unitary matrix P as",
       "           a product of elementary reflectors.",
       "         See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "D"=>
      ["[out]",
       "         D is DOUBLE PRECISION array, dimension (NB)",
       "         The diagonal elements of the first NB rows and columns of",
       "         the reduced matrix.  D(i) = A(i,i)."],
     "E"=>
      ["[out]",
       "         E is DOUBLE PRECISION array, dimension (NB)",
       "         The off-diagonal elements of the first NB rows and columns of",
       "         the reduced matrix."],
     "TAUQ"=>
      ["[out]",
       "         TAUQ is COMPLEX*16 array dimension (NB)",
       "         The scalar factors of the elementary reflectors which",
       "         represent the unitary matrix Q. See Further Details."],
     "TAUP"=>
      ["[out]",
       "         TAUP is COMPLEX*16 array, dimension (NB)",
       "         The scalar factors of the elementary reflectors which",
       "         represent the unitary matrix P. See Further Details."],
     "X"=>
      ["[out]",
       "         X is COMPLEX*16 array, dimension (LDX,NB)",
       "         The m-by-nb matrix X required to update the unreduced part",
       "         of A."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X. LDX >= max(1,M)."],
     "Y"=>
      ["[out]",
       "         Y is COMPLEX*16 array, dimension (LDY,NB)",
       "         The n-by-nb matrix Y required to update the unreduced part",
       "         of A."],
     "LDY"=>
      ["[in]",
       "         LDY is INTEGER",
       "         The leading dimension of the array Y. LDY >= max(1,N)."]}},
 "zhetrd_2stage"=>
  {"summary"=>
    ["ZHETRD_2STAGE reduces a complex Hermitian matrix A to real symmetric",
     "tridiagonal form T by a unitary similarity transformation:",
     "Q1**H Q2**H* A * Q2 * Q1 = T."],
   "param"=>
    {"VECT"=>
      ["[in]",
       "         VECT is CHARACTER*1",
       "         = 'N':  No need for the Housholder representation, ",
       "                 in particular for the second stage (Band to",
       "                 tridiagonal) and thus LHOUS2 is of size max(1, 4*N);",
       "         = 'V':  the Householder representation is needed to ",
       "                 either generate Q1 Q2 or to apply Q1 Q2, ",
       "                 then LHOUS2 is to be queried and computed.",
       "                 (NOT AVAILABLE IN THIS RELEASE)."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the leading",
       "         N-by-N upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading N-by-N lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, if UPLO = 'U', the band superdiagonal",
       "         of A are overwritten by the corresponding elements of the",
       "         internal band-diagonal matrix AB, and the elements above ",
       "         the KD superdiagonal, with the array TAU, represent the unitary",
       "         matrix Q1 as a product of elementary reflectors; if UPLO",
       "         = 'L', the diagonal and band subdiagonal of A are over-",
       "         written by the corresponding elements of the internal band-diagonal",
       "         matrix AB, and the elements below the KD subdiagonal, with",
       "         the array TAU, represent the unitary matrix Q1 as a product",
       "         of elementary reflectors. See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "D"=>
      ["[out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         The diagonal elements of the tridiagonal matrix T."],
     "E"=>
      ["[out]",
       "         E is DOUBLE PRECISION array, dimension (N-1)",
       "         The off-diagonal elements of the tridiagonal matrix T."],
     "TAU"=>
      ["[out]",
       "         TAU is COMPLEX*16 array, dimension (N-KD)",
       "         The scalar factors of the elementary reflectors of ",
       "         the first stage (see Further Details)."],
     "HOUS2"=>
      ["[out]",
       "         HOUS2 is COMPLEX*16 array, dimension LHOUS2, that",
       "         store the Householder representation of the stage2",
       "         band to tridiagonal."],
     "LHOUS2"=>
      ["[in]",
       "         LHOUS2 is INTEGER",
       "         The dimension of the array HOUS2. LHOUS2 = MAX(1, dimension)",
       "         If LWORK = -1, or LHOUS2=-1,",
       "         then a query is assumed; the routine",
       "         only calculates the optimal size of the HOUS2 array, returns",
       "         this value as the first entry of the HOUS2 array, and no error",
       "         message related to LHOUS2 is issued by XERBLA.",
       "         LHOUS2 = MAX(1, dimension) where",
       "         dimension = 4*N if VECT='N'",
       "         not available now if VECT='H'"],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK = MAX(1, dimension)",
       "         If LWORK = -1, or LHOUS2=-1,",
       "         then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA.",
       "         LWORK = MAX(1, dimension) where",
       "         dimension   = max(stage1,stage2) + (KD+1)*N",
       "                     = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                       + max(2*KD*KD, KD*NTHREADS) ",
       "                       + (KD+1)*N ",
       "         where KD is the blocking size of the reduction,",
       "         FACTOPTNB is the blocking used by the QR or LQ",
       "         algorithm, usually FACTOPTNB=128 is a good choice",
       "         NTHREADS is the number of threads used when",
       "         openMP compilation is enabled, otherwise =1."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zstedc"=>
  {"summary"=>
    ["ZSTEDC computes all eigenvalues and, optionally, eigenvectors of a",
     "symmetric tridiagonal matrix using the divide and conquer method.",
     "The eigenvectors of a full or band complex Hermitian matrix can also",
     "be found if ZHETRD or ZHPTRD or ZHBTRD has been used to reduce this",
     "matrix to tridiagonal form.",
     "This code makes very mild assumptions about floating point",
     "arithmetic. It will work on machines with a guard digit in",
     "add/subtract, or on those binary machines without guard digits",
     "which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.",
     "It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none.  See DLAED3 for details."],
   "param"=>
    {"COMPZ"=>
      ["[in]",
       "         COMPZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only.",
       "         = 'I':  Compute eigenvectors of tridiagonal matrix also.",
       "         = 'V':  Compute eigenvectors of original Hermitian matrix",
       "                 also.  On entry, Z contains the unitary matrix used",
       "                 to reduce the original matrix to tridiagonal form."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The dimension of the symmetric tridiagonal matrix.  N >= 0."],
     "D"=>
      ["[in,out]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         On entry, the diagonal elements of the tridiagonal matrix.",
       "         On exit, if INFO = 0, the eigenvalues in ascending order."],
     "E"=>
      ["[in,out]",
       "         E is DOUBLE PRECISION array, dimension (N-1)",
       "         On entry, the subdiagonal elements of the tridiagonal matrix.",
       "         On exit, E has been destroyed."],
     "Z"=>
      ["[in,out]",
       "         Z is COMPLEX*16 array, dimension (LDZ,N)",
       "         On entry, if COMPZ = 'V', then Z contains the unitary",
       "         matrix used in the reduction to tridiagonal form.",
       "         On exit, if INFO = 0, then if COMPZ = 'V', Z contains the",
       "         orthonormal eigenvectors of the original Hermitian matrix,",
       "         and if COMPZ = 'I', Z contains the orthonormal eigenvectors",
       "         of the symmetric tridiagonal matrix.",
       "         If  COMPZ = 'N', then Z is not referenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1.",
       "         If eigenvectors are desired, then LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If COMPZ = 'N' or 'I', or N <= 1, LWORK must be at least 1.",
       "         If COMPZ = 'V' and N > 1, LWORK must be at least N*N.",
       "         Note that for COMPZ = 'V', then if N is less than or",
       "         equal to the minimum divide size, usually 25, then LWORK need",
       "         only be 1.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal sizes of the WORK, RWORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]",
       "         RWORK is DOUBLE PRECISION array,",
       "                                        dimension (LRWORK)",
       "         On exit, if INFO = 0, RWORK(1) returns the optimal LRWORK."],
     "LRWORK"=>
      ["[in]",
       "         LRWORK is INTEGER",
       "         The dimension of the array RWORK.",
       "         If COMPZ = 'N' or N <= 1, LRWORK must be at least 1.",
       "         If COMPZ = 'V' and N > 1, LRWORK must be at least",
       "                        1 + 3*N + 2*N*lg N + 4*N**2 ,",
       "                        where lg( N ) = smallest integer k such",
       "                        that 2**k >= N.",
       "         If COMPZ = 'I' and N > 1, LRWORK must be at least",
       "                        1 + 4*N + 2*N**2 .",
       "         Note that for COMPZ = 'I' or 'V', then if N is less than or",
       "         equal to the minimum divide size, usually 25, then LRWORK",
       "         need only be max(1,2*(N-1)).",
       "         If LRWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK, RWORK",
       "         and IWORK arrays, returns these values as the first entries",
       "         of the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         If COMPZ = 'N' or N <= 1, LIWORK must be at least 1.",
       "         If COMPZ = 'V' or N > 1,  LIWORK must be at least",
       "                                   6 + 6*N + 5*N*lg N.",
       "         If COMPZ = 'I' or N > 1,  LIWORK must be at least",
       "                                   3 + 5*N .",
       "         Note that for COMPZ = 'I' or 'V', then if N is less than or",
       "         equal to the minimum divide size, usually 25, then LIWORK",
       "         need only be 1.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK, RWORK",
       "         and IWORK arrays, returns these values as the first entries",
       "         of the WORK, RWORK and IWORK arrays, and no error message",
       "         related to LWORK or LRWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  The algorithm failed to compute an eigenvalue while",
       "               working on the submatrix lying in rows and columns",
       "               INFO/(N+1) through mod(INFO,N+1)."]}},
 "cgbtrs"=>
  {"summary"=>
    ["CGBTRS solves a system of linear equations",
     "   A * X = B,  A**T * X = B,  or  A**H * X = B",
     "with a general band matrix A using the LU factorization computed",
     "by CGBTRF."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         Specifies the form of the system of equations.",
       "         = 'N':  A * X = B     (No transpose)",
       "         = 'T':  A**T * X = B  (Transpose)",
       "         = 'C':  A**H * X = B  (Conjugate transpose)"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "         The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "         The number of superdiagonals within the band of A.  KU >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX array, dimension (LDAB,N)",
       "         Details of the LU factorization of the band matrix A, as",
       "         computed by CGBTRF.  U is stored as an upper triangular band",
       "         matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and",
       "         the multipliers used during the factorization are stored in",
       "         rows KL+KU+2 to 2*KL+KU+1."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= 2*KL+KU+1."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices; for 1 <= i <= N, row i of the matrix was",
       "         interchanged with row IPIV(i)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zrot"=>
  {"summary"=>
    ["ZROT   applies a plane rotation, where the cos (C) is real and the",
     "sin (S) is complex, and the vectors CX and CY are complex."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of elements in the vectors CX and CY."],
     "CX"=>
      ["[in,out]",
       "         CX is COMPLEX*16 array, dimension (N)",
       "         On input, the vector X.",
       "         On output, CX is overwritten with C*X + S*Y."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between successive values of CY.  INCX <> 0."],
     "CY"=>
      ["[in,out]",
       "         CY is COMPLEX*16 array, dimension (N)",
       "         On input, the vector Y.",
       "         On output, CY is overwritten with -CONJG(S)*X + C*Y."],
     "INCY"=>
      ["[in]",
       "         INCY is INTEGER",
       "         The increment between successive values of CY.  INCX <> 0."],
     "C"=>["[in]", "         C is DOUBLE PRECISION"],
     "S"=>
      ["[in]",
       "         S is COMPLEX*16",
       "         C and S define a rotation",
       "            [  C          S  ]",
       "            [ -conjg(S)   C  ]",
       "         where C*C + S*CONJG(S) = 1.0."]}},
 "dspgv"=>
  {"summary"=>
    ["DSPGV computes all the eigenvalues and, optionally, the eigenvectors",
     "of a real generalized symmetric-definite eigenproblem, of the form",
     "A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.",
     "Here A and B are assumed to be symmetric, stored in packed format,",
     "and B is also positive definite."],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         Specifies the problem type to be solved:",
       "         = 1:  A*x = (lambda)*B*x",
       "         = 2:  A*B*x = (lambda)*x",
       "         = 3:  B*A*x = (lambda)*x"],
     "JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is DOUBLE PRECISION array, dimension",
       "                           (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, the contents of AP are destroyed."],
     "BP"=>
      ["[in,out]",
       "         BP is DOUBLE PRECISION array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         B, packed columnwise in a linear array.  The j-th column of B",
       "         is stored in the array BP as follows:",
       "         if UPLO = 'U', BP(i + (j-1)*j/2) = B(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', BP(i + (j-1)*(2*n-j)/2) = B(i,j) for j<=i<=n.",
       "         On exit, the triangular factor U or L from the Cholesky",
       "         factorization B = U**T*U or B = L*L**T, in the same storage",
       "         format as B."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is DOUBLE PRECISION array, dimension (LDZ, N)",
       "         If JOBZ = 'V', then if INFO = 0, Z contains the matrix Z of",
       "         eigenvectors.  The eigenvectors are normalized as follows:",
       "         if ITYPE = 1 or 2, Z**T*B*Z = I;",
       "         if ITYPE = 3, Z**T*inv(B)*Z = I.",
       "         If JOBZ = 'N', then Z is not referenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (3*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  DPPTRF or DSPEV returned an error code:",
       "            <= N:  if INFO = i, DSPEV failed to converge;",
       "                   i off-diagonal elements of an intermediate",
       "                   tridiagonal form did not converge to zero.",
       "            > N:   if INFO = n + i, for 1 <= i <= n, then the leading",
       "                   minor of order i of B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "ssytri_3x"=>
  {"summary"=>
    ["SSYTRI_3X computes the inverse of a real symmetric indefinite",
     "matrix A using the factorization computed by SSYTRF_RK or SSYTRF_BK:",
     "    A = P*U*D*(U**T)*(P**T) or A = P*L*D*(L**T)*(P**T),",
     "where U (or L) is unit upper (or lower) triangular matrix,",
     "U**T (or L**T) is the transpose of U (or L), P is a permutation",
     "matrix, P**T is the transpose of P, and D is symmetric and block",
     "diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "This is the blocked version of the algorithm, calling Level 3 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are",
       "         stored as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, diagonal of the block diagonal matrix D and",
       "         factors U or L as computed by SYTRF_RK and SSYTRF_BK:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               should be provided on entry in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A.",
       "         On exit, if INFO = 0, the symmetric inverse of the original",
       "         matrix.",
       "            If UPLO = 'U': the upper triangular part of the inverse",
       "            is formed and the part of A below the diagonal is not",
       "            referenced;",
       "            If UPLO = 'L': the lower triangular part of the inverse",
       "            is formed and the part of A above the diagonal is not",
       "            referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[in]",
       "         E is REAL array, dimension (N)",
       "         On entry, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i), i=2:N, E(1) not refernced;",
       "         If UPLO = 'L': E(i) = D(i+1,i), i=1:N-1, E(N) not referenced.",
       "         NOTE: For 1-by-1 diagonal block D(k), where",
       "         1 <= k <= N, the element E(k) is not referenced in both",
       "         UPLO = 'U' or UPLO = 'L' cases."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by SSYTRF_RK or SSYTRF_BK."],
     "WORK"=>
      ["[out]", "         WORK is REAL array, dimension (N+NB+1,NB+3)."],
     "NB"=>["[in]", "         NB is INTEGER", "         Block size."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "ztgsy2"=>
  {"summary"=>
    ["ZTGSY2 solves the generalized Sylvester equation",
     "            A * R - L * B = scale * C               (1)",
     "            D * R - L * E = scale * F",
     "using Level 1 and 2 BLAS, where R and L are unknown M-by-N matrices,",
     "(A, D), (B, E) and (C, F) are given matrix pairs of size M-by-M,",
     "N-by-N and M-by-N, respectively. A, B, D and E are upper triangular",
     "(i.e., (A,D) and (B,E) in generalized Schur form).",
     "The solution (R, L) overwrites (C, F). 0 <= SCALE <= 1 is an output",
     "scaling factor chosen to avoid overflow.",
     "In matrix notation solving equation (1) corresponds to solve",
     "Zx = scale * b, where Z is defined as",
     "       Z = [ kron(In, A)  -kron(B**H, Im) ]             (2)",
     "           [ kron(In, D)  -kron(E**H, Im) ],",
     "Ik is the identity matrix of size k and X**H is the conjuguate transpose of X.",
     "kron(X, Y) is the Kronecker product between the matrices X and Y.",
     "If TRANS = 'C', y in the conjugate transposed system Z**H*y = scale*b",
     "is solved for, which is equivalent to solve for R and L in",
     "            A**H * R  + D**H * L   = scale * C           (3)",
     "            R  * B**H + L  * E**H  = scale * -F",
     "This case is used to compute an estimate of Dif[(A, D), (B, E)] =",
     "= sigma_min(Z) using reverse communicaton with ZLACON.",
     "ZTGSY2 also (IJOB >= 1) contributes to the computation in ZTGSYL",
     "of an upper bound on the separation between to matrix pairs. Then",
     "the input (A, D), (B, E) are sub-pencils of two matrix pairs in",
     "ZTGSYL."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N', solve the generalized Sylvester equation (1).",
       "         = 'T': solve the 'transposed' system (3)."],
     "IJOB"=>
      ["[in]",
       "         IJOB is INTEGER",
       "         Specifies what kind of functionality to be performed.",
       "         =0: solve (1) only.",
       "         =1: A contribution from this subsystem to a Frobenius",
       "             norm-based estimate of the separation between two matrix",
       "             pairs is computed. (look ahead strategy is used).",
       "         =2: A contribution from this subsystem to a Frobenius",
       "             norm-based estimate of the separation between two matrix",
       "             pairs is computed. (DGECON on sub-systems is used.)",
       "         Not referenced if TRANS = 'T'."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         On entry, M specifies the order of A and D, and the row",
       "         dimension of C, F, R and L."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         On entry, N specifies the order of B and E, and the column",
       "         dimension of C, F, R and L."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA, M)",
       "         On entry, A contains an upper triangular matrix."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the matrix A. LDA >= max(1, M)."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array, dimension (LDB, N)",
       "         On entry, B contains an upper triangular matrix."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the matrix B. LDB >= max(1, N)."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array, dimension (LDC, N)",
       "         On entry, C contains the right-hand-side of the first matrix",
       "         equation in (1).",
       "         On exit, if IJOB = 0, C has been overwritten by the solution",
       "         R."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the matrix C. LDC >= max(1, M)."],
     "D"=>
      ["[in]",
       "         D is COMPLEX*16 array, dimension (LDD, M)",
       "         On entry, D contains an upper triangular matrix."],
     "LDD"=>
      ["[in]",
       "         LDD is INTEGER",
       "         The leading dimension of the matrix D. LDD >= max(1, M)."],
     "E"=>
      ["[in]",
       "         E is COMPLEX*16 array, dimension (LDE, N)",
       "         On entry, E contains an upper triangular matrix."],
     "LDE"=>
      ["[in]",
       "         LDE is INTEGER",
       "         The leading dimension of the matrix E. LDE >= max(1, N)."],
     "F"=>
      ["[in,out]",
       "         F is COMPLEX*16 array, dimension (LDF, N)",
       "         On entry, F contains the right-hand-side of the second matrix",
       "         equation in (1).",
       "         On exit, if IJOB = 0, F has been overwritten by the solution",
       "         L."],
     "LDF"=>
      ["[in]",
       "         LDF is INTEGER",
       "         The leading dimension of the matrix F. LDF >= max(1, M)."],
     "SCALE"=>
      ["[out]",
       "         SCALE is DOUBLE PRECISION",
       "         On exit, 0 <= SCALE <= 1. If 0 < SCALE < 1, the solutions",
       "         R and L (C and F on entry) will hold the solutions to a",
       "         slightly perturbed system but the input matrices A, B, D and",
       "         E have not been changed. If SCALE = 0, R and L will hold the",
       "         solutions to the homogeneous system with C = F = 0.",
       "         Normally, SCALE = 1."],
     "RDSUM"=>
      ["[in,out]",
       "         RDSUM is DOUBLE PRECISION",
       "         On entry, the sum of squares of computed contributions to",
       "         the Dif-estimate under computation by ZTGSYL, where the",
       "         scaling factor RDSCAL (see below) has been factored out.",
       "         On exit, the corresponding sum of squares updated with the",
       "         contributions from the current sub-system.",
       "         If TRANS = 'T' RDSUM is not touched.",
       "         NOTE: RDSUM only makes sense when ZTGSY2 is called by",
       "         ZTGSYL."],
     "RDSCAL"=>
      ["[in,out]",
       "         RDSCAL is DOUBLE PRECISION",
       "         On entry, scaling factor used to prevent overflow in RDSUM.",
       "         On exit, RDSCAL is updated w.r.t. the current contributions",
       "         in RDSUM.",
       "         If TRANS = 'T', RDSCAL is not touched.",
       "         NOTE: RDSCAL only makes sense when ZTGSY2 is called by",
       "         ZTGSYL."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         On exit, if INFO is set to",
       "           =0: Successful exit",
       "           <0: If INFO = -i, input argument number i is illegal.",
       "           >0: The matrix pairs (A, D) and (B, E) have common or very",
       "               close eigenvalues."]}},
 "zlaqr4"=>
  {"summary"=>
    ["   ZLAQR4 implements one level of recursion for ZLAQR0.",
     "   It is a complete implementation of the small bulge multi-shift",
     "   QR algorithm.  It may be called by ZLAQR0 and, for large enough",
     "   deflation window size, it may be called by ZLAQR3.  This",
     "   subroutine is identical to ZLAQR0 except that it calls ZLAQR2",
     "   instead of ZLAQR3.",
     "   ZLAQR4 computes the eigenvalues of a Hessenberg matrix H",
     "   and, optionally, the matrices T and Z from the Schur decomposition",
     "   H = Z T Z**H, where T is an upper triangular matrix (the",
     "   Schur form), and Z is the unitary matrix of Schur vectors.",
     "   Optionally Z may be postmultiplied into an input unitary",
     "   matrix Q so that this routine can give the Schur factorization",
     "   of a matrix A which has been reduced to the Hessenberg form H",
     "   by the unitary matrix Q:  A = Q*H*Q**H = (QZ)*H*(QZ)**H."],
   "param"=>
    {"WANTT"=>
      ["[in]",
       "         WANTT is LOGICAL",
       "         = .TRUE. : the full Schur form T is required;",
       "         = .FALSE.: only eigenvalues are required."],
     "WANTZ"=>
      ["[in]",
       "         WANTZ is LOGICAL",
       "         = .TRUE. : the matrix of Schur vectors Z is required;",
       "         = .FALSE.: Schur vectors are not required."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          The order of the matrix H.  N .GE. 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "          It is assumed that H is already upper triangular in rows",
       "          and columns 1:ILO-1 and IHI+1:N and, if ILO.GT.1,",
       "          H(ILO,ILO-1) is zero. ILO and IHI are normally set by a",
       "          previous call to ZGEBAL, and then passed to ZGEHRD when the",
       "          matrix output by ZGEBAL is reduced to Hessenberg form.",
       "          Otherwise, ILO and IHI should be set to 1 and N,",
       "          respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.",
       "          If N = 0, then ILO = 1 and IHI = 0."],
     "H"=>
      ["[in,out]",
       "         H is COMPLEX*16 array, dimension (LDH,N)",
       "          On entry, the upper Hessenberg matrix H.",
       "          On exit, if INFO = 0 and WANTT is .TRUE., then H",
       "          contains the upper triangular matrix T from the Schur",
       "          decomposition (the Schur form). If INFO = 0 and WANT is",
       "          .FALSE., then the contents of H are unspecified on exit.",
       "          (The output value of H when INFO.GT.0 is given under the",
       "          description of INFO below.)",
       "          This subroutine may explicitly set H(i,j) = 0 for i.GT.j and",
       "          j = 1, 2, ... ILO-1 or j = IHI+1, IHI+2, ... N."],
     "LDH"=>
      ["[in]",
       "         LDH is INTEGER",
       "          The leading dimension of the array H. LDH .GE. max(1,N)."],
     "W"=>
      ["[out]",
       "         W is COMPLEX*16 array, dimension (N)",
       "          The computed eigenvalues of H(ILO:IHI,ILO:IHI) are stored",
       "          in W(ILO:IHI). If WANTT is .TRUE., then the eigenvalues are",
       "          stored in the same order as on the diagonal of the Schur",
       "          form returned in H, with W(i) = H(i,i)."],
     "ILOZ"=>["[in]", "         ILOZ is INTEGER"],
     "IHIZ"=>
      ["[in]",
       "         IHIZ is INTEGER",
       "          Specify the rows of Z to which transformations must be",
       "          applied if WANTZ is .TRUE..",
       "          1 .LE. ILOZ .LE. ILO; IHI .LE. IHIZ .LE. N."],
     "Z"=>
      ["[in,out]",
       "         Z is COMPLEX*16 array, dimension (LDZ,IHI)",
       "          If WANTZ is .FALSE., then Z is not referenced.",
       "          If WANTZ is .TRUE., then Z(ILO:IHI,ILOZ:IHIZ) is",
       "          replaced by Z(ILO:IHI,ILOZ:IHIZ)*U where U is the",
       "          orthogonal Schur factor of H(ILO:IHI,ILO:IHI).",
       "          (The output value of Z when INFO.GT.0 is given under",
       "          the description of INFO below.)"],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "          The leading dimension of the array Z.  if WANTZ is .TRUE.",
       "          then LDZ.GE.MAX(1,IHIZ).  Otherwize, LDZ.GE.1."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension LWORK",
       "          On exit, if LWORK = -1, WORK(1) returns an estimate of",
       "          the optimal value for LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "          The dimension of the array WORK.  LWORK .GE. max(1,N)",
       "          is sufficient, but LWORK typically as large as 6*N may",
       "          be required for optimal performance.  A workspace query",
       "          to determine the optimal workspace size is recommended.",
       "          If LWORK = -1, then ZLAQR4 does a workspace query.",
       "          In this case, ZLAQR4 checks the input parameters and",
       "          estimates the optimal workspace size for the given",
       "          values of N, ILO and IHI.  The estimate is returned",
       "          in WORK(1).  No error message related to LWORK is",
       "          issued by XERBLA.  Neither H nor Z are accessed."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "            =  0:  successful exit",
       "          .GT. 0:  if INFO = i, ZLAQR4 failed to compute all of",
       "               the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR",
       "               and WI contain those eigenvalues which have been",
       "               successfully computed.  (Failures are rare.)",
       "               If INFO .GT. 0 and WANT is .FALSE., then on exit,",
       "               the remaining unconverged eigenvalues are the eigen-",
       "               values of the upper Hessenberg matrix rows and",
       "               columns ILO through INFO of the final, output",
       "               value of H.",
       "               If INFO .GT. 0 and WANTT is .TRUE., then on exit",
       "          (*)  (initial value of H)*U  = U*(final value of H)",
       "               where U is a unitary matrix.  The final",
       "               value of  H is upper Hessenberg and triangular in",
       "               rows and columns INFO+1 through IHI.",
       "               If INFO .GT. 0 and WANTZ is .TRUE., then on exit",
       "                 (final value of Z(ILO:IHI,ILOZ:IHIZ)",
       "                  =  (initial value of Z(ILO:IHI,ILOZ:IHIZ)*U",
       "               where U is the unitary matrix in (*) (regard-",
       "               less of the value of WANTT.)",
       "               If INFO .GT. 0 and WANTZ is .FALSE., then Z is not",
       "               accessed."]}},
 "classq"=>
  {"summary"=>
    ["CLASSQ returns the values scl and ssq such that",
     "   ( scl**2 )*ssq = x( 1 )**2 +...+ x( n )**2 + ( scale**2 )*sumsq,",
     "where x( i ) = abs( X( 1 + ( i - 1 )*INCX ) ). The value of sumsq is",
     "assumed to be at least unity and the value of ssq will then satisfy",
     "   1.0 .le. ssq .le. ( sumsq + 2*n ).",
     "scale is assumed to be non-negative and scl returns the value",
     "   scl = max( scale, abs( real( x( i ) ) ), abs( aimag( x( i ) ) ) ),",
     "          i",
     "scale and sumsq must be supplied in SCALE and SUMSQ respectively.",
     "SCALE and SUMSQ are overwritten by scl and ssq respectively.",
     "The routine makes only one pass through the vector X."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of elements to be used from the vector X."],
     "X"=>
      ["[in]",
       "         X is COMPLEX array, dimension (N)",
       "         The vector x as described above.",
       "            x( i )  = X( 1 + ( i - 1 )*INCX ), 1 <= i <= n."],
     "INCX"=>
      ["[in]",
       "         INCX is INTEGER",
       "         The increment between successive values of the vector X.",
       "         INCX > 0."],
     "SCALE"=>
      ["[in,out]",
       "         SCALE is REAL",
       "         On entry, the value  scale  in the equation above.",
       "         On exit, SCALE is overwritten with the value  scl ."],
     "SUMSQ"=>
      ["[in,out]",
       "         SUMSQ is REAL",
       "         On entry, the value  sumsq  in the equation above.",
       "         On exit, SUMSQ is overwritten with the value  ssq ."]}},
 "ssptrs"=>
  {"summary"=>
    ["SSPTRS solves a system of linear equations A*X = B with a real",
     "symmetric matrix A stored in packed format using the factorization",
     "A = U*D*U**T or A = L*D*L**T computed by SSPTRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AP"=>
      ["[in]",
       "         AP is REAL array, dimension (N*(N+1)/2)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by SSPTRF, stored as a",
       "         packed triangular matrix."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by SSPTRF."],
     "B"=>
      ["[in,out]",
       "         B is REAL array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "sgerq2"=>
  {"summary"=>
    ["SGERQ2 computes an RQ factorization of a real m by n matrix A:",
     "A = R * Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the m by n matrix A.",
       "         On exit, if m <= n, the upper triangle of the subarray",
       "         A(1:m,n-m+1:n) contains the m by m upper triangular matrix R;",
       "         if m >= n, the elements on and above the (m-n)-th subdiagonal",
       "         contain the m by n upper trapezoidal matrix R; the remaining",
       "         elements, with the array TAU, represent the orthogonal matrix",
       "         Q as a product of elementary reflectors (see Further",
       "         Details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "TAU"=>
      ["[out]",
       "         TAU is REAL array, dimension (min(M,N))",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "dgelqt"=>
  {"summary"=>
    ["DGELQT computes a blocked LQ factorization of a real M-by-N matrix A",
     "using the compact WY representation of Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The block size to be used in the blocked QR.  MIN(M,N) >= MB >= 1."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the M-by-MIN(M,N) lower trapezoidal matrix L (L is",
       "         lower triangular if M <= N); the elements above the diagonal",
       "         are the rows of V."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is DOUBLE PRECISION array, dimension (LDT,MIN(M,N))",
       "         The upper triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See below",
       "         for further details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (MB*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "chegvx"=>
  {"summary"=>
    ["CHEGVX computes selected eigenvalues, and optionally, eigenvectors",
     "of a complex generalized Hermitian-definite eigenproblem, of the form",
     "A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.  Here A and",
     "B are assumed to be Hermitian and B is also positive definite.",
     "Eigenvalues and eigenvectors can be selected by specifying either a",
     "range of values or a range of indices for the desired eigenvalues."],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         Specifies the problem type to be solved:",
       "         = 1:  A*x = (lambda)*B*x",
       "         = 2:  A*B*x = (lambda)*x",
       "         = 3:  B*A*x = (lambda)*x"],
     "JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found.",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found.",
       "         = 'I': the IL-th through IU-th eigenvalues will be found."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit,  the lower triangle (if UPLO='L') or the upper",
       "         triangle (if UPLO='U') of A, including the diagonal, is",
       "         destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB, N)",
       "         On entry, the Hermitian matrix B.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of B contains the",
       "         upper triangular part of the matrix B.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of B contains",
       "         the lower triangular part of the matrix B.",
       "         On exit, if INFO <= N, the part of B containing the matrix is",
       "         overwritten by the triangular factor U or L from the Cholesky",
       "         factorization B = U**H*U or B = L*L**H."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is REAL",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing C to tridiagonal form, where C is the symmetric",
       "         matrix of the standard symmetric problem to which the",
       "         generalized problem is transformed.",
       "         Eigenvalues will be computed most accurately when ABSTOL is",
       "         set to twice the underflow threshold 2*SLAMCH('S'), not zero.",
       "         If this routine returns with INFO>0, indicating that some",
       "         eigenvectors did not converge, try setting ABSTOL to",
       "         2*SLAMCH('S')."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         The first M elements contain the selected",
       "         eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is COMPLEX array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         The eigenvectors are normalized as follows:",
       "         if ITYPE = 1 or 2, Z**T*B*Z = I;",
       "         if ITYPE = 3, Z**T*inv(B)*Z = I.",
       "         If an eigenvector fails to converge, then that column of Z",
       "         contains the latest approximation to the eigenvector, and the",
       "         index of the eigenvector is returned in IFAIL.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.  LWORK >= max(1,2*N).",
       "         For optimal efficiency, LWORK >= (NB+1)*N,",
       "         where NB is the blocksize for CHETRD returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (7*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (5*N)"],
     "IFAIL"=>
      ["[out]",
       "         IFAIL is INTEGER array, dimension (N)",
       "         If JOBZ = 'V', then if INFO = 0, the first M elements of",
       "         IFAIL are zero.  If INFO > 0, then IFAIL contains the",
       "         indices of the eigenvectors that failed to converge.",
       "         If JOBZ = 'N', then IFAIL is not referenced."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  CPOTRF or CHEEVX returned an error code:",
       "            <= N:  if INFO = i, CHEEVX failed to converge;",
       "                   i eigenvectors failed to converge.  Their indices",
       "                   are stored in array IFAIL.",
       "            > N:   if INFO = N + i, for 1 <= i <= N, then the leading",
       "                   minor of order i of B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "sla_syrpvgrw"=>
  {"summary"=>
    ["SLA_SYRPVGRW computes the reciprocal pivot growth factor",
     "norm(A)/norm(U). The \"max absolute element\" norm is used. If this is",
     "much less than 1, the stability of the LU factorization of the",
     "(equilibrated) matrix A could be poor. This also means that the",
     "solution X, estimated condition numbers, and error bounds could be",
     "unreliable."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "INFO"=>
      ["[in]",
       "         INFO is INTEGER",
       "    The value of INFO returned from SSYTRF, .i.e., the pivot in",
       "    column INFO is exactly 0."],
     "A"=>
      ["[in]",
       "         A is REAL array, dimension (LDA,N)",
       "    On entry, the N-by-N matrix A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is REAL array, dimension (LDAF,N)",
       "    The block diagonal matrix D and the multipliers used to",
       "    obtain the factor U or L as computed by SSYTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    Details of the interchanges and the block structure of D",
       "    as determined by SSYTRF."],
     "WORK"=>["[in]", "         WORK is REAL array, dimension (2*N)"]}},
 "cunbdb6"=>
  {"summary"=>[],
   "param"=>
    {"M1"=>
      ["[in]",
       "         M1 is INTEGER",
       "          The dimension of X1 and the number of rows in Q1. 0 <= M1."],
     "M2"=>
      ["[in]",
       "         M2 is INTEGER",
       "          The dimension of X2 and the number of rows in Q2. 0 <= M2."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "          The number of columns in Q1 and Q2. 0 <= N."],
     "X1"=>
      ["[in,out]",
       "         X1 is COMPLEX array, dimension (M1)",
       "          On entry, the top part of the vector to be orthogonalized.",
       "          On exit, the top part of the projected vector."],
     "INCX1"=>
      ["[in]",
       "         INCX1 is INTEGER",
       "          Increment for entries of X1."],
     "X2"=>
      ["[in,out]",
       "         X2 is COMPLEX array, dimension (M2)",
       "          On entry, the bottom part of the vector to be",
       "          orthogonalized. On exit, the bottom part of the projected",
       "          vector."],
     "INCX2"=>
      ["[in]",
       "         INCX2 is INTEGER",
       "          Increment for entries of X2."],
     "Q1"=>
      ["[in]",
       "         Q1 is COMPLEX array, dimension (LDQ1, N)",
       "          The top part of the orthonormal basis matrix."],
     "LDQ1"=>
      ["[in]",
       "         LDQ1 is INTEGER",
       "          The leading dimension of Q1. LDQ1 >= M1."],
     "Q2"=>
      ["[in]",
       "         Q2 is COMPLEX array, dimension (LDQ2, N)",
       "          The bottom part of the orthonormal basis matrix."],
     "LDQ2"=>
      ["[in]",
       "         LDQ2 is INTEGER",
       "          The leading dimension of Q2. LDQ2 >= M2."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (LWORK)"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "          The dimension of the array WORK. LWORK >= N."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "          = 0:  successful exit.",
       "          < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "ssyevr_2stage"=>
  {"summary"=>
    ["SSYEVR_2STAGE computes selected eigenvalues and, optionally, eigenvectors",
     "of a real symmetric matrix A using the 2stage technique for",
     "the reduction to tridiagonal.  Eigenvalues and eigenvectors can be",
     "selected by specifying either a range of values or a range of",
     "indices for the desired eigenvalues.",
     "SSYEVR_2STAGE first reduces the matrix A to tridiagonal form T with a call",
     "to SSYTRD.  Then, whenever possible, SSYEVR_2STAGE calls SSTEMR to compute",
     "the eigenspectrum using Relatively Robust Representations.  SSTEMR",
     "computes eigenvalues by the dqds algorithm, while orthogonal",
     "eigenvectors are computed from various \"good\" L D L^T representations",
     "(also known as Relatively Robust Representations). Gram-Schmidt",
     "orthogonalization is avoided as far as possible. More specifically,",
     "the various steps of the algorithm are as follows.",
     "For each unreduced block (submatrix) of T,",
     "   (a) Compute T - sigma I  = L D L^T, so that L and D",
     "       define all the wanted eigenvalues to high relative accuracy.",
     "       This means that small relative changes in the entries of D and L",
     "       cause only small relative changes in the eigenvalues and",
     "       eigenvectors. The standard (unfactored) representation of the",
     "       tridiagonal matrix T does not have this property in general.",
     "   (b) Compute the eigenvalues to suitable accuracy.",
     "       If the eigenvectors are desired, the algorithm attains full",
     "       accuracy of the computed eigenvalues only right before",
     "       the corresponding vectors have to be computed, see steps c) and d).",
     "   (c) For each cluster of close eigenvalues, select a new",
     "       shift close to the cluster, find a new factorization, and refine",
     "       the shifted eigenvalues to suitable accuracy.",
     "   (d) For each eigenvalue with a large enough relative separation compute",
     "       the corresponding eigenvector by forming a rank revealing twisted",
     "       factorization. Go back to (c) for any clusters that remain.",
     "The desired accuracy of the output can be specified by the input",
     "parameter ABSTOL.",
     "For more details, see SSTEMR's documentation and:",
     "- Inderjit S. Dhillon and Beresford N. Parlett: \"Multiple representations",
     "  to compute orthogonal eigenvectors of symmetric tridiagonal matrices,\"",
     "  Linear Algebra and its Applications, 387(1), pp. 1-28, August 2004.",
     "- Inderjit Dhillon and Beresford Parlett: \"Orthogonal Eigenvectors and",
     "  Relative Gaps,\" SIAM Journal on Matrix Analysis and Applications, Vol. 25,",
     "  2004.  Also LAPACK Working Note 154.",
     "- Inderjit Dhillon: \"A new O(n^2) algorithm for the symmetric",
     "  tridiagonal eigenvalue/eigenvector problem\",",
     "  Computer Science Division Technical Report No. UCB/CSD-97-971,",
     "  UC Berkeley, May 1997.",
     "Note 1 : SSYEVR_2STAGE calls SSTEMR when the full spectrum is requested",
     "on machines which conform to the ieee-754 floating point standard.",
     "SSYEVR_2STAGE calls SSTEBZ and SSTEIN on non-ieee machines and",
     "when partial spectrum requests are made.",
     "Normal execution of SSTEMR may create NaNs and infinities and",
     "hence may abort due to a floating point exception in environments",
     "which do not handle NaNs and infinities in the ieee standard default",
     "manner."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors.",
       "                 Not available in this release."],
     "RANGE"=>
      ["[in]",
       "         RANGE is CHARACTER*1",
       "         = 'A': all eigenvalues will be found.",
       "         = 'V': all eigenvalues in the half-open interval (VL,VU]",
       "                will be found.",
       "         = 'I': the IL-th through IU-th eigenvalues will be found.",
       "         For RANGE = 'V' or 'I' and IU - IL < N - 1, SSTEBZ and",
       "         SSTEIN are called"],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA, N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, the lower triangle (if UPLO='L') or the upper",
       "         triangle (if UPLO='U') of A, including the diagonal, is",
       "         destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "VL"=>
      ["[in]",
       "         VL is REAL",
       "         If RANGE='V', the lower bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "VU"=>
      ["[in]",
       "         VU is REAL",
       "         If RANGE='V', the upper bound of the interval to",
       "         be searched for eigenvalues. VL < VU.",
       "         Not referenced if RANGE = 'A' or 'I'."],
     "IL"=>
      ["[in]",
       "         IL is INTEGER",
       "         If RANGE='I', the index of the",
       "         smallest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "IU"=>
      ["[in]",
       "         IU is INTEGER",
       "         If RANGE='I', the index of the",
       "         largest eigenvalue to be returned.",
       "         1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.",
       "         Not referenced if RANGE = 'A' or 'V'."],
     "ABSTOL"=>
      ["[in]",
       "         ABSTOL is REAL",
       "         The absolute error tolerance for the eigenvalues.",
       "         An approximate eigenvalue is accepted as converged",
       "         when it is determined to lie in an interval [a,b]",
       "         of width less than or equal to",
       "                 ABSTOL + EPS *   max( |a|,|b| ) ,",
       "         where EPS is the machine precision.  If ABSTOL is less than",
       "         or equal to zero, then  EPS*|T|  will be used in its place,",
       "         where |T| is the 1-norm of the tridiagonal matrix obtained",
       "         by reducing A to tridiagonal form.",
       "         See \"Computing Small Singular Values of Bidiagonal Matrices",
       "         with Guaranteed High Relative Accuracy,\" by Demmel and",
       "         Kahan, LAPACK Working Note #3.",
       "         If high relative accuracy is important, set ABSTOL to",
       "         SLAMCH( 'Safe minimum' ).  Doing so will guarantee that",
       "         eigenvalues are computed to high relative accuracy when",
       "         possible in future releases.  The current code does not",
       "         make any guarantees about high relative accuracy, but",
       "         future releases will. See J. Barlow and J. Demmel,",
       "         \"Computing Accurate Eigensystems of Scaled Diagonally",
       "         Dominant Matrices\", LAPACK Working Note #7, for a discussion",
       "         of which matrices define their eigenvalues to high relative",
       "         accuracy."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The total number of eigenvalues found.  0 <= M <= N.",
       "         If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         The first M elements contain the selected eigenvalues in",
       "         ascending order."],
     "Z"=>
      ["[out]",
       "         Z is REAL array, dimension (LDZ, max(1,M))",
       "         If JOBZ = 'V', then if INFO = 0, the first M columns of Z",
       "         contain the orthonormal eigenvectors of the matrix A",
       "         corresponding to the selected eigenvalues, with the i-th",
       "         column of Z holding the eigenvector associated with W(i).",
       "         If JOBZ = 'N', then Z is not referenced.",
       "         Note: the user must ensure that at least max(1,M) columns are",
       "         supplied in the array Z; if RANGE = 'V', the exact value of M",
       "         is not known in advance and an upper bound must be used.",
       "         Supplying N columns is always safe."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "ISUPPZ"=>
      ["[out]",
       "         ISUPPZ is INTEGER array, dimension ( 2*max(1,M) )",
       "         The support of the eigenvectors in Z, i.e., the indices",
       "         indicating the nonzero elements in Z. The i-th eigenvector",
       "         is nonzero only in elements ISUPPZ( 2*i-1 ) through",
       "         ISUPPZ( 2*i ). This is an output of SSTEMR (tridiagonal",
       "         matrix). The support of the eigenvectors of A is typically ",
       "         1:N because of the orthogonal transformations applied by SORMTR.",
       "         Implemented only for RANGE = 'A' or 'I' and IU - IL = N - 1"],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.  ",
       "         If JOBZ = 'N' and N > 1, LWORK must be queried.",
       "                                  LWORK = MAX(1, 26*N, dimension) where",
       "                                  dimension = max(stage1,stage2) + (KD+1)*N + 5*N",
       "                                            = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                                              + max(2*KD*KD, KD*NTHREADS) ",
       "                                              + (KD+1)*N + 5*N",
       "                                  where KD is the blocking size of the reduction,",
       "                                  FACTOPTNB is the blocking used by the QR or LQ",
       "                                  algorithm, usually FACTOPTNB=128 is a good choice",
       "                                  NTHREADS is the number of threads used when",
       "                                  openMP compilation is enabled, otherwise =1.",
       "         If JOBZ = 'V' and N > 1, LWORK must be queried. Not yet available",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.  LIWORK >= max(1,10*N).",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal size of the IWORK array,",
       "         returns this value as the first entry of the IWORK array, and",
       "         no error message related to LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  Internal error"]}},
 "ctbtrs"=>
  {"summary"=>
    ["CTBTRS solves a triangular system of the form",
     "   A * X = B,  A**T * X = B,  or  A**H * X = B,",
     "where A is a triangular band matrix of order N, and B is an",
     "N-by-NRHS matrix.  A check is made to verify that A is nonsingular."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  A is upper triangular;",
       "         = 'L':  A is lower triangular."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         Specifies the form of the system of equations:",
       "         = 'N':  A * X = B     (No transpose)",
       "         = 'T':  A**T * X = B  (Transpose)",
       "         = 'C':  A**H * X = B  (Conjugate transpose)"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         = 'N':  A is non-unit triangular;",
       "         = 'U':  A is unit triangular."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals or subdiagonals of the",
       "         triangular band matrix A.  KD >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX array, dimension (LDAB,N)",
       "         The upper or lower triangular band matrix A, stored in the",
       "         first kd+1 rows of AB.  The j-th column of A is stored",
       "         in the j-th column of the array AB as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         If DIAG = 'U', the diagonal elements of A are not referenced",
       "         and are assumed to be 1."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD+1."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,NRHS)",
       "         On entry, the right hand side matrix B.",
       "         On exit, if INFO = 0, the solution matrix X."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the i-th diagonal element of A is zero,",
       "               indicating that the matrix is singular and the",
       "               solutions X have not been computed."]}},
 "zgbrfsx"=>
  {"summary"=>
    ["   ZGBRFSX improves the computed solution to a system of linear",
     "   equations and provides error bounds and backward error estimates",
     "   for the solution.  In addition to normwise error bound, the code",
     "   provides maximum componentwise error bound if possible.  See",
     "   comments for ERR_BNDS_NORM and ERR_BNDS_COMP for details of the",
     "   error bounds.",
     "   The original system of linear equations may have been equilibrated",
     "   before calling this routine, as described by arguments EQUED, R",
     "   and C below. In this case, the solution and error bounds returned",
     "   are for the original unequilibrated system.",
     "    Some optional parameters are bundled in the PARAMS array.  These",
     "    settings determine how refinement is performed, but often the",
     "    defaults are acceptable.  If the defaults are acceptable, users",
     "    can pass NPARAMS = 0 which prevents the source code from accessing",
     "    the PARAMS argument."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "    Specifies the form of the system of equations:",
       "      = 'N':  A * X = B     (No transpose)",
       "      = 'T':  A**T * X = B  (Transpose)",
       "      = 'C':  A**H * X = B  (Conjugate transpose = Transpose)"],
     "EQUED"=>
      ["[in]",
       "         EQUED is CHARACTER*1",
       "    Specifies the form of equilibration that was done to A",
       "    before calling this routine. This is needed to compute",
       "    the solution and error bounds correctly.",
       "      = 'N':  No equilibration",
       "      = 'R':  Row equilibration, i.e., A has been premultiplied by",
       "              diag(R).",
       "      = 'C':  Column equilibration, i.e., A has been postmultiplied",
       "              by diag(C).",
       "      = 'B':  Both row and column equilibration, i.e., A has been",
       "              replaced by diag(R) * A * diag(C).",
       "              The right hand side B has been changed accordingly."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The order of the matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "    The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "    The number of superdiagonals within the band of A.  KU >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "    The number of right hand sides, i.e., the number of columns",
       "    of the matrices B and X.  NRHS >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX*16 array, dimension (LDAB,N)",
       "    The original band matrix A, stored in rows 1 to KL+KU+1.",
       "    The j-th column of A is stored in the j-th column of the",
       "    array AB as follows:",
       "    AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(n,j+kl)."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "    The leading dimension of the array AB.  LDAB >= KL+KU+1."],
     "AFB"=>
      ["[in]",
       "         AFB is COMPLEX*16 array, dimension (LDAFB,N)",
       "    Details of the LU factorization of the band matrix A, as",
       "    computed by DGBTRF.  U is stored as an upper triangular band",
       "    matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and",
       "    the multipliers used during the factorization are stored in",
       "    rows KL+KU+2 to 2*KL+KU+1."],
     "LDAFB"=>
      ["[in]",
       "         LDAFB is INTEGER",
       "    The leading dimension of the array AFB.  LDAFB >= 2*KL*KU+1."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "    The pivot indices from DGETRF; for 1<=i<=N, row i of the",
       "    matrix was interchanged with row IPIV(i)."],
     "R"=>
      ["[in,out]",
       "         R is DOUBLE PRECISION array, dimension (N)",
       "    The row scale factors for A.  If EQUED = 'R' or 'B', A is",
       "    multiplied on the left by diag(R); if EQUED = 'N' or 'C', R",
       "    is not accessed.  R is an input argument if FACT = 'F';",
       "    otherwise, R is an output argument.  If FACT = 'F' and",
       "    EQUED = 'R' or 'B', each element of R must be positive.",
       "    If R is output, each element of R is a power of the radix.",
       "    If R is input, each element of R should be a power of the radix",
       "    to ensure a reliable solution and error estimates. Scaling by",
       "    powers of the radix does not cause rounding errors unless the",
       "    result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array, dimension (N)",
       "    The column scale factors for A.  If EQUED = 'C' or 'B', A is",
       "    multiplied on the right by diag(C); if EQUED = 'N' or 'R', C",
       "    is not accessed.  C is an input argument if FACT = 'F';",
       "    otherwise, C is an output argument.  If FACT = 'F' and",
       "    EQUED = 'C' or 'B', each element of C must be positive.",
       "    If C is output, each element of C is a power of the radix.",
       "    If C is input, each element of C should be a power of the radix",
       "    to ensure a reliable solution and error estimates. Scaling by",
       "    powers of the radix does not cause rounding errors unless the",
       "    result underflows or overflows. Rounding errors during scaling",
       "    lead to refining with a matrix that is not equivalent to the",
       "    input matrix, producing error estimates that may not be",
       "    reliable."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "    The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "    The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array, dimension (LDX,NRHS)",
       "    On entry, the solution matrix X, as computed by DGETRS.",
       "    On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "    The leading dimension of the array X.  LDX >= max(1,N)."],
     "RCOND"=>
      ["[out]",
       "         RCOND is DOUBLE PRECISION",
       "    Reciprocal scaled condition number.  This is an estimate of the",
       "    reciprocal Skeel condition number of the matrix A after",
       "    equilibration (if done).  If this is less than the machine",
       "    precision (in particular, if it is zero), the matrix is singular",
       "    to working precision.  Note that the error may still be small even",
       "    if this number is very small and the matrix appears ill-",
       "    conditioned."],
     "BERR"=>
      ["[out]",
       "         BERR is DOUBLE PRECISION array, dimension (NRHS)",
       "    Componentwise relative backward error.  This is the",
       "    componentwise relative backward error of each solution vector X(j)",
       "    (i.e., the smallest relative change in any element of A or B that",
       "    makes X(j) an exact solution)."],
     "N_ERR_BNDS"=>
      ["[in]",
       "         N_ERR_BNDS is INTEGER",
       "    Number of error bounds to return for each right hand side",
       "    and each type (normwise or componentwise).  See ERR_BNDS_NORM and",
       "    ERR_BNDS_COMP below."],
     "ERR_BNDS_NORM"=>
      ["[out]",
       "         ERR_BNDS_NORM is DOUBLE PRECISION array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    normwise relative error, which is defined as follows:",
       "    Normwise relative error in the ith solution vector:",
       "            max_j (abs(XTRUE(j,i) - X(j,i)))",
       "           ------------------------------",
       "                 max_j abs(X(j,i))",
       "    The array is indexed by the type of error information as described",
       "    below. There currently are up to three pieces of information",
       "    returned.",
       "    The first index in ERR_BNDS_NORM(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_NORM(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * dlamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * dlamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated normwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * dlamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*A, where S scales each row by a power of the",
       "             radix so all absolute row sums of Z are approximately 1.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "ERR_BNDS_COMP"=>
      ["[out]",
       "         ERR_BNDS_COMP is DOUBLE PRECISION array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    componentwise relative error, which is defined as follows:",
       "    Componentwise relative error in the ith solution vector:",
       "                   abs(XTRUE(j,i) - X(j,i))",
       "            max_j ----------------------",
       "                        abs(X(j,i))",
       "    The array is indexed by the right-hand side i (on which the",
       "    componentwise relative error depends), and the type of error",
       "    information as described below. There currently are up to three",
       "    pieces of information returned for each right-hand side. If",
       "    componentwise accuracy is not requested (PARAMS(3) = 0.0), then",
       "    ERR_BNDS_COMP is not accessed.  If N_ERR_BNDS .LT. 3, then at most",
       "    the first (:,N_ERR_BNDS) entries are returned.",
       "    The first index in ERR_BNDS_COMP(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_COMP(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * dlamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * dlamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated componentwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * dlamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*(A*diag(x)), where x is the solution for the",
       "             current right-hand side and S scales each row of",
       "             A*diag(x) by a power of the radix so all absolute row",
       "             sums of Z are approximately 1.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "NPARAMS"=>
      ["[in]",
       "         NPARAMS is INTEGER",
       "    Specifies the number of parameters set in PARAMS.  If .LE. 0, the",
       "    PARAMS array is never referenced and default values are used."],
     "PARAMS"=>
      ["[in,out]",
       "         PARAMS is DOUBLE PRECISION array, dimension NPARAMS",
       "    Specifies algorithm parameters.  If an entry is .LT. 0.0, then",
       "    that entry will be filled with default value used for that",
       "    parameter.  Only positions up to NPARAMS are accessed; defaults",
       "    are used for higher-numbered parameters.",
       "      PARAMS(LA_LINRX_ITREF_I = 1) : Whether to perform iterative",
       "           refinement or not.",
       "        Default: 1.0D+0",
       "           = 0.0 : No refinement is performed, and no error bounds are",
       "                   computed.",
       "           = 1.0 : Use the double-precision refinement algorithm,",
       "                   possibly with doubled-single computations if the",
       "                   compilation environment does not support DOUBLE",
       "                   PRECISION.",
       "             (other values are reserved for future use)",
       "      PARAMS(LA_LINRX_ITHRESH_I = 2) : Maximum number of residual",
       "           computations allowed for refinement.",
       "        Default: 10",
       "        Aggressive: Set to 100 to permit convergence using approximate",
       "                    factorizations or factorizations other than LU. If",
       "                    the factorization uses a technique other than",
       "                    Gaussian elimination, the guarantees in",
       "                    err_bnds_norm and err_bnds_comp may no longer be",
       "                    trustworthy.",
       "      PARAMS(LA_LINRX_CWISE_I = 3) : Flag determining if the code",
       "           will attempt to find a solution with small componentwise",
       "           relative error in the double-precision algorithm.  Positive",
       "           is true, 0.0 is false.",
       "        Default: 1.0 (attempt componentwise convergence)"],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (2*N)"],
     "RWORK"=>
      ["[out]", "         RWORK is DOUBLE PRECISION array, dimension (2*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit. The solution to every right-hand side is",
       "        guaranteed.",
       "      < 0:  If INFO = -i, the i-th argument had an illegal value",
       "      > 0 and <= N:  U(INFO,INFO) is exactly zero.  The factorization",
       "        has been completed, but the factor U is exactly singular, so",
       "        the solution and error bounds could not be computed. RCOND = 0",
       "        is returned.",
       "      = N+J: The solution corresponding to the Jth right-hand side is",
       "        not guaranteed. The solutions corresponding to other right-",
       "        hand sides K with K > J may not be guaranteed as well, but",
       "        only the first such right-hand side is reported. If a small",
       "        componentwise error is not requested (PARAMS(3) = 0.0) then",
       "        the Jth right-hand side is the first with a normwise error",
       "        bound that is not guaranteed (the smallest J such",
       "        that ERR_BNDS_NORM(J,1) = 0.0). By default (PARAMS(3) = 1.0)",
       "        the Jth right-hand side is the first with either a normwise or",
       "        componentwise error bound that is not guaranteed (the smallest",
       "        J such that either ERR_BNDS_NORM(J,1) = 0.0 or",
       "        ERR_BNDS_COMP(J,1) = 0.0). See the definition of",
       "        ERR_BNDS_NORM(:,1) and ERR_BNDS_COMP(:,1). To get information",
       "        about all of the right-hand sides check ERR_BNDS_NORM or",
       "        ERR_BNDS_COMP."]}},
 "dlagv2"=>
  {"summary"=>
    ["DLAGV2 computes the Generalized Schur factorization of a real 2-by-2",
     "matrix pencil (A,B) where B is upper triangular. This routine",
     "computes orthogonal (rotation) matrices given by CSL, SNL and CSR,",
     "SNR such that",
     "1) if the pencil (A,B) has two real eigenvalues (include 0/0 or 1/0",
     "   types), then",
     "   [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]",
     "   [  0  a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]",
     "   [ b11 b12 ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]",
     "   [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ],",
     "2) if the pencil (A,B) has a pair of complex conjugate eigenvalues,",
     "   then",
     "   [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]",
     "   [ a21 a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]",
     "   [ b11  0  ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]",
     "   [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ]",
     "   where b11 >= b22 > 0."],
   "param"=>
    {"A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA, 2)",
       "         On entry, the 2 x 2 matrix A.",
       "         On exit, A is overwritten by the ``A-part'' of the",
       "         generalized Schur form."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         THe leading dimension of the array A.  LDA >= 2."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB, 2)",
       "         On entry, the upper triangular 2 x 2 matrix B.",
       "         On exit, B is overwritten by the ``B-part'' of the",
       "         generalized Schur form."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         THe leading dimension of the array B.  LDB >= 2."],
     "ALPHAR"=>
      ["[out]", "         ALPHAR is DOUBLE PRECISION array, dimension (2)"],
     "ALPHAI"=>
      ["[out]", "         ALPHAI is DOUBLE PRECISION array, dimension (2)"],
     "BETA"=>
      ["[out]",
       "         BETA is DOUBLE PRECISION array, dimension (2)",
       "         (ALPHAR(k)+i*ALPHAI(k))/BETA(k) are the eigenvalues of the",
       "         pencil (A,B), k=1,2, i = sqrt(-1).  Note that BETA(k) may",
       "         be zero."],
     "CSL"=>
      ["[out]",
       "         CSL is DOUBLE PRECISION",
       "         The cosine of the left rotation matrix."],
     "SNL"=>
      ["[out]",
       "         SNL is DOUBLE PRECISION",
       "         The sine of the left rotation matrix."],
     "CSR"=>
      ["[out]",
       "         CSR is DOUBLE PRECISION",
       "         The cosine of the right rotation matrix."],
     "SNR"=>
      ["[out]",
       "         SNR is DOUBLE PRECISION",
       "         The sine of the right rotation matrix."]}},
 "csptrf"=>
  {"summary"=>
    ["CSPTRF computes the factorization of a complex symmetric matrix A",
     "stored in packed format using the Bunch-Kaufman diagonal pivoting",
     "method:",
     "   A = U*D*U**T  or  A = L*D*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, and D is symmetric and block diagonal with",
     "1-by-1 and 2-by-2 diagonal blocks."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is COMPLEX array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L, stored as a packed triangular",
       "         matrix overwriting A (see below for further details)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "         interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "         If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0, then rows and",
       "         columns k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "         is a 2-by-2 diagonal block.  If UPLO = 'L' and IPIV(k) =",
       "         IPIV(k+1) < 0, then rows and columns k+1 and -IPIV(k) were",
       "         interchanged and D(k:k+1,k:k+1) is a 2-by-2 diagonal block."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if it",
       "              is used to solve a system of equations."]}},
 "dgetrf2"=>
  {"summary"=>
    ["DGETRF2 computes an LU factorization of a general M-by-N matrix A",
     "using partial pivoting with row interchanges.",
     "The factorization has the form",
     "   A = P * L * U",
     "where P is a permutation matrix, L is lower triangular with unit",
     "diagonal elements (lower trapezoidal if m > n), and U is upper",
     "triangular (upper trapezoidal if m < n).",
     "This is the recursive version of the algorithm. It divides",
     "the matrix into four submatrices:",
     "       [  A11 | A12  ]  where A11 is n1 by n1 and A22 is n2 by n2",
     "   A = [ -----|----- ]  with n1 = min(m,n)/2",
     "       [  A21 | A22  ]       n2 = n-n1",
     "                                      [ A11 ]",
     "The subroutine calls itself to factor [ --- ],",
     "                                      [ A12 ]",
     "                [ A12 ]",
     "do the swaps on [ --- ], solve A12, update A22,",
     "                [ A22 ]",
     "then calls itself to factor A22 and do the swaps on A21."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix to be factored.",
       "         On exit, the factors L and U from the factorization",
       "         A = P*L*U; the unit diagonal elements of L are not stored."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (min(M,N))",
       "         The pivot indices; for 1 <= i <= min(M,N), row i of the",
       "         matrix was interchanged with row IPIV(i)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, U(i,i) is exactly zero. The factorization",
       "               has been completed, but the factor U is exactly",
       "               singular, and division by zero will occur if it is used",
       "               to solve a system of equations."]}},
 "sptcon"=>
  {"summary"=>
    ["SPTCON computes the reciprocal of the condition number (in the",
     "1-norm) of a real symmetric positive definite tridiagonal matrix",
     "using the factorization A = L*D*L**T or A = U**T*D*U computed by",
     "SPTTRF.",
     "Norm(inv(A)) is computed by a direct method, and the reciprocal of",
     "the condition number is computed as",
     "             RCOND = 1 / (ANORM * norm(inv(A)))."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension (N)",
       "         The n diagonal elements of the diagonal matrix D from the",
       "         factorization of A, as computed by SPTTRF."],
     "E"=>
      ["[in]",
       "         E is REAL array, dimension (N-1)",
       "         The (n-1) off-diagonal elements of the unit bidiagonal factor",
       "         U or L from the factorization of A,  as computed by SPTTRF."],
     "ANORM"=>
      ["[in]",
       "         ANORM is REAL",
       "         The 1-norm of the original matrix A."],
     "RCOND"=>
      ["[out]",
       "         RCOND is REAL",
       "         The reciprocal of the condition number of the matrix A,",
       "         computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is the",
       "         1-norm of inv(A) computed in this routine."],
     "WORK"=>["[out]", "         WORK is REAL array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "sgbsvx"=>
  {"summary"=>
    ["SGBSVX uses the LU factorization to compute the solution to a real",
     "system of linear equations A * X = B, A**T * X = B, or A**H * X = B,",
     "where A is a band matrix of order N with KL subdiagonals and KU",
     "superdiagonals, and X and B are N-by-NRHS matrices.",
     "Error bounds on the solution and a condition estimate are also",
     "provided."],
   "param"=>nil},
 "dsygv_2stage"=>
  {"summary"=>
    ["DSYGV_2STAGE computes all the eigenvalues, and optionally, the eigenvectors",
     "of a real generalized symmetric-definite eigenproblem, of the form",
     "A*x=(lambda)*B*x,  A*Bx=(lambda)*x,  or B*A*x=(lambda)*x.",
     "Here A and B are assumed to be symmetric and B is also",
     "positive definite.",
     "This routine use the 2stage technique for the reduction to tridiagonal",
     "which showed higher performance on recent architecture and for large"],
   "param"=>
    {"ITYPE"=>
      ["[in]",
       "         ITYPE is INTEGER",
       "         Specifies the problem type to be solved:",
       "         = 1:  A*x = (lambda)*B*x",
       "         = 2:  A*B*x = (lambda)*x",
       "         = 3:  B*A*x = (lambda)*x"],
     "JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors.",
       "                 Not available in this release."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangles of A and B are stored;",
       "         = 'L':  Lower triangles of A and B are stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA, N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         matrix Z of eigenvectors.  The eigenvectors are normalized",
       "         as follows:",
       "         if ITYPE = 1 or 2, Z**T*B*Z = I;",
       "         if ITYPE = 3, Z**T*inv(B)*Z = I.",
       "         If JOBZ = 'N', then on exit the upper triangle (if UPLO='U')",
       "         or the lower triangle (if UPLO='L') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB, N)",
       "         On entry, the symmetric positive definite matrix B.",
       "         If UPLO = 'U', the leading N-by-N upper triangular part of B",
       "         contains the upper triangular part of the matrix B.",
       "         If UPLO = 'L', the leading N-by-N lower triangular part of B",
       "         contains the lower triangular part of the matrix B.",
       "         On exit, if INFO <= N, the part of B containing the matrix is",
       "         overwritten by the triangular factor U or L from the Cholesky",
       "         factorization B = U**T*U or B = L*L**T."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK. LWORK >= 1, when N <= 1;",
       "         otherwise  ",
       "         If JOBZ = 'N' and N > 1, LWORK must be queried.",
       "                                  LWORK = MAX(1, dimension) where",
       "                                  dimension = max(stage1,stage2) + (KD+1)*N + 2*N",
       "                                            = N*KD + N*max(KD+1,FACTOPTNB) ",
       "                                              + max(2*KD*KD, KD*NTHREADS) ",
       "                                              + (KD+1)*N + 2*N",
       "                                  where KD is the blocking size of the reduction,",
       "                                  FACTOPTNB is the blocking used by the QR or LQ",
       "                                  algorithm, usually FACTOPTNB=128 is a good choice",
       "                                  NTHREADS is the number of threads used when",
       "                                  openMP compilation is enabled, otherwise =1.",
       "         If JOBZ = 'V' and N > 1, LWORK must be queried. Not yet available",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  DPOTRF or DSYEV returned an error code:",
       "            <= N:  if INFO = i, DSYEV failed to converge;",
       "                   i off-diagonal elements of an intermediate",
       "                   tridiagonal form did not converge to zero;",
       "            > N:   if INFO = N + i, for 1 <= i <= N, then the leading",
       "                   minor of order i of B is not positive definite.",
       "                   The factorization of B could not be completed and",
       "                   no eigenvalues or eigenvectors were computed."]}},
 "ssptrd"=>
  {"summary"=>
    ["SSPTRD reduces a real symmetric matrix A stored in packed form to",
     "symmetric tridiagonal form T by an orthogonal similarity",
     "transformation: Q**T * A * Q = T."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "AP"=>
      ["[in,out]",
       "         AP is REAL array, dimension (N*(N+1)/2)",
       "         On entry, the upper or lower triangle of the symmetric matrix",
       "         A, packed columnwise in a linear array.  The j-th column of A",
       "         is stored in the array AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.",
       "         On exit, if UPLO = 'U', the diagonal and first superdiagonal",
       "         of A are overwritten by the corresponding elements of the",
       "         tridiagonal matrix T, and the elements above the first",
       "         superdiagonal, with the array TAU, represent the orthogonal",
       "         matrix Q as a product of elementary reflectors; if UPLO",
       "         = 'L', the diagonal and first subdiagonal of A are over-",
       "         written by the corresponding elements of the tridiagonal",
       "         matrix T, and the elements below the first subdiagonal, with",
       "         the array TAU, represent the orthogonal matrix Q as a product",
       "         of elementary reflectors. See Further Details."],
     "D"=>
      ["[out]",
       "         D is REAL array, dimension (N)",
       "         The diagonal elements of the tridiagonal matrix T:",
       "         D(i) = A(i,i)."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (N-1)",
       "         The off-diagonal elements of the tridiagonal matrix T:",
       "         E(i) = A(i,i+1) if UPLO = 'U', E(i) = A(i+1,i) if UPLO = 'L'."],
     "TAU"=>
      ["[out]",
       "         TAU is REAL array, dimension (N-1)",
       "         The scalar factors of the elementary reflectors (see Further",
       "         Details)."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "dorm2r"=>
  {"summary"=>
    ["DORM2R overwrites the general real m by n matrix C with",
     "      Q * C  if SIDE = 'L' and TRANS = 'N', or",
     "      Q**T* C  if SIDE = 'L' and TRANS = 'T', or",
     "      C * Q  if SIDE = 'R' and TRANS = 'N', or",
     "      C * Q**T if SIDE = 'R' and TRANS = 'T',",
     "where Q is a real orthogonal matrix defined as the product of k",
     "elementary reflectors",
     "      Q = H(1) H(2) . . . H(k)",
     "as returned by DGEQRF. Q is of order m if SIDE = 'L' and of order n",
     "if SIDE = 'R'."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**T from the Left",
       "         = 'R': apply Q or Q**T from the Right"],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N': apply Q  (No transpose)",
       "         = 'T': apply Q**T (Transpose)"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix C. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,K)",
       "         The i-th column must contain the vector which defines the",
       "         elementary reflector H(i), for i = 1,2,...,k, as returned by",
       "         DGEQRF in the first k columns of its array argument A.",
       "         A is modified by the routine but restored on exit."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.",
       "         If SIDE = 'L', LDA >= max(1,M);",
       "         if SIDE = 'R', LDA >= max(1,N)."],
     "TAU"=>
      ["[in]",
       "         TAU is DOUBLE PRECISION array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by DGEQRF."],
     "C"=>
      ["[in,out]",
       "         C is DOUBLE PRECISION array, dimension (LDC,N)",
       "         On entry, the m by n matrix C.",
       "         On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension",
       "                                  (N) if SIDE = 'L',",
       "                                  (M) if SIDE = 'R'"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value"]}},
 "dsyconv"=>
  {"summary"=>
    ["DSYCONV convert A given by TRF into L and D and vice-versa.",
     "Get Non-diag elements of D (returned in workspace) and",
     "apply or reverse permutation done in TRF."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are stored",
       "         as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangular, form is A = U*D*U**T;",
       "         = 'L':  Lower triangular, form is A = L*D*L**T."],
     "WAY"=>
      ["[in]",
       "         WAY is CHARACTER*1",
       "         = 'C': Convert",
       "         = 'R': Revert"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         The block diagonal matrix D and the multipliers used to",
       "         obtain the factor U or L as computed by DSYTRF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by DSYTRF."],
     "E"=>
      ["[out]",
       "         E is DOUBLE PRECISION array, dimension (N)",
       "         E stores the supdiagonal/subdiagonal of the symmetric 1-by-1",
       "         or 2-by-2 block diagonal matrix D in LDLT."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zhetri_3"=>
  {"summary"=>
    ["ZHETRI_3 computes the inverse of a complex Hermitian indefinite",
     "matrix A using the factorization computed by ZHETRF_RK or ZHETRF_BK:",
     "    A = P*U*D*(U**H)*(P**T) or A = P*L*D*(L**H)*(P**T),",
     "where U (or L) is unit upper (or lower) triangular matrix,",
     "U**H (or L**H) is the conjugate of U (or L), P is a permutation",
     "matrix, P**T is the transpose of P, and D is Hermitian and block",
     "diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "ZHETRI_3 sets the leading dimension of the workspace  before calling",
     "ZHETRI_3X that actually computes the inverse.  This is the blocked",
     "version of the algorithm, calling Level 3 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the details of the factorization are",
       "         stored as an upper or lower triangular matrix.",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, diagonal of the block diagonal matrix D and",
       "         factors U or L as computed by ZHETRF_RK and ZHETRF_BK:",
       "           a) ONLY diagonal elements of the Hermitian block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               should be provided on entry in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A.",
       "         On exit, if INFO = 0, the Hermitian inverse of the original",
       "         matrix.",
       "            If UPLO = 'U': the upper triangular part of the inverse",
       "            is formed and the part of A below the diagonal is not",
       "            referenced;",
       "            If UPLO = 'L': the lower triangular part of the inverse",
       "            is formed and the part of A above the diagonal is not",
       "            referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[in]",
       "         E is COMPLEX*16 array, dimension (N)",
       "         On entry, contains the superdiagonal (or subdiagonal)",
       "         elements of the Hermitian block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i),i=2:N, E(1) not refernced;",
       "         If UPLO = 'L': E(i) = D(i+1,i),i=1:N-1, E(N) not referenced.",
       "         NOTE: For 1-by-1 diagonal block D(k), where",
       "         1 <= k <= N, the element E(k) is not referenced in both",
       "         UPLO = 'U' or UPLO = 'L' cases."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by ZHETRF_RK or ZHETRF_BK."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (N+NB+1)*(NB+3).",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK. LWORK >= (N+NB+1)*(NB+3).",
       "         If LDWORK = -1, then a workspace query is assumed;",
       "         the routine only calculates the optimal size of the optimal",
       "         size of the WORK array, returns this value as the first",
       "         entry of the WORK array, and no error message related to",
       "         LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, D(i,i) = 0; the matrix is singular and its",
       "              inverse could not be computed."]}},
 "ztrsen"=>
  {"summary"=>
    ["ZTRSEN reorders the Schur factorization of a complex matrix",
     "A = Q*T*Q**H, so that a selected cluster of eigenvalues appears in",
     "the leading positions on the diagonal of the upper triangular matrix",
     "T, and the leading columns of Q form an orthonormal basis of the",
     "corresponding right invariant subspace.",
     "Optionally the routine computes the reciprocal condition numbers of",
     "the cluster of eigenvalues and/or the invariant subspace."],
   "param"=>
    {"JOB"=>
      ["[in]",
       "         JOB is CHARACTER*1",
       "         Specifies whether condition numbers are required for the",
       "         cluster of eigenvalues (S) or the invariant subspace (SEP):",
       "         = 'N': none;",
       "         = 'E': for eigenvalues only (S);",
       "         = 'V': for invariant subspace only (SEP);",
       "         = 'B': for both eigenvalues and invariant subspace (S and",
       "                SEP)."],
     "COMPQ"=>
      ["[in]",
       "         COMPQ is CHARACTER*1",
       "         = 'V': update the matrix Q of Schur vectors;",
       "         = 'N': do not update Q."],
     "SELECT"=>
      ["[in]",
       "         SELECT is LOGICAL array, dimension (N)",
       "         SELECT specifies the eigenvalues in the selected cluster. To",
       "         select the j-th eigenvalue, SELECT(j) must be set to .TRUE.."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix T. N >= 0."],
     "T"=>
      ["[in,out]",
       "         T is COMPLEX*16 array, dimension (LDT,N)",
       "         On entry, the upper triangular matrix T.",
       "         On exit, T is overwritten by the reordered matrix T, with the",
       "         selected eigenvalues as the leading diagonal elements."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T. LDT >= max(1,N)."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX*16 array, dimension (LDQ,N)",
       "         On entry, if COMPQ = 'V', the matrix Q of Schur vectors.",
       "         On exit, if COMPQ = 'V', Q has been postmultiplied by the",
       "         unitary transformation matrix which reorders T; the leading M",
       "         columns of Q form an orthonormal basis for the specified",
       "         invariant subspace.",
       "         If COMPQ = 'N', Q is not referenced."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.",
       "         LDQ >= 1; and if COMPQ = 'V', LDQ >= N."],
     "W"=>
      ["[out]",
       "         W is COMPLEX*16 array, dimension (N)",
       "         The reordered eigenvalues of T, in the same order as they",
       "         appear on the diagonal of T."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The dimension of the specified invariant subspace.",
       "         0 <= M <= N."],
     "S"=>
      ["[out]",
       "         S is DOUBLE PRECISION",
       "         If JOB = 'E' or 'B', S is a lower bound on the reciprocal",
       "         condition number for the selected cluster of eigenvalues.",
       "         S cannot underestimate the true reciprocal condition number",
       "         by more than a factor of sqrt(N). If M = 0 or N, S = 1.",
       "         If JOB = 'N' or 'V', S is not referenced."],
     "SEP"=>
      ["[out]",
       "         SEP is DOUBLE PRECISION",
       "         If JOB = 'V' or 'B', SEP is the estimated reciprocal",
       "         condition number of the specified invariant subspace. If",
       "         M = 0 or N, SEP = norm(T).",
       "         If JOB = 'N' or 'E', SEP is not referenced."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If JOB = 'N', LWORK >= 1;",
       "         if JOB = 'E', LWORK = max(1,M*(N-M));",
       "         if JOB = 'V' or 'B', LWORK >= max(1,2*M*(N-M)).",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zgels"=>
  {"summary"=>
    ["ZGELS solves overdetermined or underdetermined complex linear systems",
     "involving an M-by-N matrix A, or its conjugate-transpose, using a QR",
     "or LQ factorization of A.  It is assumed that A has full rank.",
     "The following options are provided:",
     "1. If TRANS = 'N' and m >= n:  find the least squares solution of",
     "   an overdetermined system, i.e., solve the least squares problem",
     "                minimize || B - A*X ||.",
     "2. If TRANS = 'N' and m < n:  find the minimum norm solution of",
     "   an underdetermined system A * X = B.",
     "3. If TRANS = 'C' and m >= n:  find the minimum norm solution of",
     "   an underdetermined system A**H * X = B.",
     "4. If TRANS = 'C' and m < n:  find the least squares solution of",
     "   an overdetermined system, i.e., solve the least squares problem",
     "                minimize || B - A**H * X ||.",
     "Several right hand side vectors b and solution vectors x can be",
     "handled in a single call; they are stored as the columns of the",
     "M-by-NRHS right hand side matrix B and the N-by-NRHS solution",
     "matrix X."],
   "param"=>
    {"TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N': the linear system involves A;",
       "         = 'C': the linear system involves A**H."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of",
       "         columns of the matrices B and X. NRHS >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "           if M >= N, A is overwritten by details of its QR",
       "                      factorization as returned by ZGEQRF;",
       "           if M <  N, A is overwritten by details of its LQ",
       "                      factorization as returned by ZGELQF."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "         On entry, the matrix B of right hand side vectors, stored",
       "         columnwise; B is M-by-NRHS if TRANS = 'N', or N-by-NRHS",
       "         if TRANS = 'C'.",
       "         On exit, if INFO = 0, B is overwritten by the solution",
       "         vectors, stored columnwise:",
       "         if TRANS = 'N' and m >= n, rows 1 to n of B contain the least",
       "         squares solution vectors; the residual sum of squares for the",
       "         solution in each column is given by the sum of squares of the",
       "         modulus of elements N+1 to M in that column;",
       "         if TRANS = 'N' and m < n, rows 1 to N of B contain the",
       "         minimum norm solution vectors;",
       "         if TRANS = 'C' and m >= n, rows 1 to M of B contain the",
       "         minimum norm solution vectors;",
       "         if TRANS = 'C' and m < n, rows 1 to M of B contain the",
       "         least squares solution vectors; the residual sum of squares",
       "         for the solution in each column is given by the sum of",
       "         squares of the modulus of elements M+1 to N in that column."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B. LDB >= MAX(1,M,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         LWORK >= max( 1, MN + max( MN, NRHS ) ).",
       "         For optimal performance,",
       "         LWORK >= max( 1, MN + max( MN, NRHS )*NB ).",
       "         where MN = min(M,N) and NB is the optimum block size.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO =  i, the i-th diagonal element of the",
       "               triangular factor of A is zero, so that A does not have",
       "               full rank; the least squares solution could not be",
       "               computed."]}},
 "slarrj"=>
  {"summary"=>
    ["Given the initial eigenvalue approximations of T, SLARRJ",
     "does  bisection to refine the eigenvalues of T,",
     "W( IFIRST-OFFSET ) through W( ILAST-OFFSET ), to more accuracy. Initial",
     "guesses for these eigenvalues are input in W, the corresponding estimate",
     "of the error in these guesses in WERR. During bisection, intervals",
     "[left, right] are maintained by storing their mid-points and",
     "semi-widths in the arrays W and WERR respectively."],
   "param"=>
    {"N"=>
      ["[in]", "         N is INTEGER", "         The order of the matrix."],
     "D"=>
      ["[in]",
       "         D is REAL array, dimension (N)",
       "         The N diagonal elements of T."],
     "E2"=>
      ["[in]",
       "         E2 is REAL array, dimension (N-1)",
       "         The Squares of the (N-1) subdiagonal elements of T."],
     "IFIRST"=>
      ["[in]",
       "         IFIRST is INTEGER",
       "         The index of the first eigenvalue to be computed."],
     "ILAST"=>
      ["[in]",
       "         ILAST is INTEGER",
       "         The index of the last eigenvalue to be computed."],
     "RTOL"=>
      ["[in]",
       "         RTOL is REAL",
       "         Tolerance for the convergence of the bisection intervals.",
       "         An interval [LEFT,RIGHT] has converged if",
       "         RIGHT-LEFT.LT.RTOL*MAX(|LEFT|,|RIGHT|)."],
     "OFFSET"=>
      ["[in]",
       "         OFFSET is INTEGER",
       "         Offset for the arrays W and WERR, i.e., the IFIRST-OFFSET",
       "         through ILAST-OFFSET elements of these arrays are to be used."],
     "W"=>
      ["[in,out]",
       "         W is REAL array, dimension (N)",
       "         On input, W( IFIRST-OFFSET ) through W( ILAST-OFFSET ) are",
       "         estimates of the eigenvalues of L D L^T indexed IFIRST through",
       "         ILAST.",
       "         On output, these estimates are refined."],
     "WERR"=>
      ["[in,out]",
       "         WERR is REAL array, dimension (N)",
       "         On input, WERR( IFIRST-OFFSET ) through WERR( ILAST-OFFSET ) are",
       "         the errors in the estimates of the corresponding elements in W.",
       "         On output, these errors are refined."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (2*N)",
       "         Workspace."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (2*N)",
       "         Workspace."],
     "PIVMIN"=>
      ["[in]",
       "         PIVMIN is REAL",
       "         The minimum pivot in the Sturm sequence for T."],
     "SPDIAM"=>
      ["[in]",
       "         SPDIAM is REAL",
       "         The spectral diameter of T."],
     "INFO"=>["[out]", "         INFO is INTEGER", "         Error flag."]}},
 "cgghrd"=>
  {"summary"=>
    ["CGGHRD reduces a pair of complex matrices (A,B) to generalized upper",
     "Hessenberg form using unitary transformations, where A is a",
     "general matrix and B is upper triangular.  The form of the generalized",
     "eigenvalue problem is",
     "   A*x = lambda*B*x,",
     "and B is typically made upper triangular by computing its QR",
     "factorization and moving the unitary matrix Q to the left side",
     "of the equation.",
     "This subroutine simultaneously reduces A to a Hessenberg matrix H:",
     "   Q**H*A*Z = H",
     "and transforms B to another upper triangular matrix T:",
     "   Q**H*B*Z = T",
     "in order to reduce the problem to its standard form",
     "   H*y = lambda*T*y",
     "where y = Z**H*x.",
     "The unitary matrices Q and Z are determined as products of Givens",
     "rotations.  They may either be formed explicitly, or they may be",
     "postmultiplied into input matrices Q1 and Z1, so that",
     "     Q1 * A * Z1**H = (Q1*Q) * H * (Z1*Z)**H",
     "     Q1 * B * Z1**H = (Q1*Q) * T * (Z1*Z)**H",
     "If Q1 is the unitary matrix from the QR factorization of B in the",
     "original equation A*x = lambda*B*x, then CGGHRD reduces the original",
     "problem to generalized Hessenberg form."],
   "param"=>
    {"COMPQ"=>
      ["[in]",
       "         COMPQ is CHARACTER*1",
       "         = 'N': do not compute Q;",
       "         = 'I': Q is initialized to the unit matrix, and the",
       "                unitary matrix Q is returned;",
       "         = 'V': Q must contain a unitary matrix Q1 on entry,",
       "                and the product Q1*Q is returned."],
     "COMPZ"=>
      ["[in]",
       "         COMPZ is CHARACTER*1",
       "         = 'N': do not compute Z;",
       "         = 'I': Z is initialized to the unit matrix, and the",
       "                unitary matrix Z is returned;",
       "         = 'V': Z must contain a unitary matrix Z1 on entry,",
       "                and the product Z1*Z is returned."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "         ILO and IHI mark the rows and columns of A which are to be",
       "         reduced.  It is assumed that A is already upper triangular",
       "         in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are",
       "         normally set by a previous call to CGGBAL; otherwise they",
       "         should be set to 1 and N respectively.",
       "         1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA, N)",
       "         On entry, the N-by-N general matrix to be reduced.",
       "         On exit, the upper triangle and the first subdiagonal of A",
       "         are overwritten with the upper Hessenberg matrix H, and the",
       "         rest is set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB, N)",
       "         On entry, the N-by-N upper triangular matrix B.",
       "         On exit, the upper triangular matrix T = Q**H B Z.  The",
       "         elements below the diagonal are set to zero."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX array, dimension (LDQ, N)",
       "         On entry, if COMPQ = 'V', the unitary matrix Q1, typically",
       "         from the QR factorization of B.",
       "         On exit, if COMPQ='I', the unitary matrix Q, and if",
       "         COMPQ = 'V', the product Q1*Q.",
       "         Not referenced if COMPQ='N'."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.",
       "         LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise."],
     "Z"=>
      ["[in,out]",
       "         Z is COMPLEX array, dimension (LDZ, N)",
       "         On entry, if COMPZ = 'V', the unitary matrix Z1.",
       "         On exit, if COMPZ='I', the unitary matrix Z, and if",
       "         COMPZ = 'V', the product Z1*Z.",
       "         Not referenced if COMPZ='N'."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.",
       "         LDZ >= N if COMPZ='V' or 'I'; LDZ >= 1 otherwise."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "ztplqt"=>
  {"summary"=>
    ["DTPLQT computes a blocked LQ factorization of a complex",
     "\"triangular-pentagonal\" matrix C, which is composed of a",
     "triangular block A and pentagonal block B, using the compact",
     "WY representation for Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B, and the order of the",
       "         triangular matrix A.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B.",
       "         N >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of rows of the lower trapezoidal part of B.",
       "         MIN(M,N) >= L >= 0.  See Further Details."],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The block size to be used in the blocked QR.  M >= MB >= 1."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the lower triangular N-by-N matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the lower triangular matrix L."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB,N)",
       "         On entry, the pentagonal M-by-N matrix B.  The first N-L columns",
       "         are rectangular, and the last L columns are lower trapezoidal.",
       "         On exit, B contains the pentagonal matrix V.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is COMPLEX*16 array, dimension (LDT,N)",
       "         The lower triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See Further Details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (MB*M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "ssytrf_rk"=>
  {"summary"=>
    ["SSYTRF_RK computes the factorization of a real symmetric matrix A",
     "using the bounded Bunch-Kaufman (rook) diagonal pivoting method:",
     "   A = P*U*D*(U**T)*(P**T) or A = P*L*D*(L**T)*(P**T),",
     "where U (or L) is unit upper (or lower) triangular matrix,",
     "U**T (or L**T) is the transpose of U (or L), P is a permutation",
     "matrix, P**T is the transpose of P, and D is symmetric and block",
     "diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "This is the blocked version of the algorithm, calling Level 3 BLAS.",
     "For more information see Further Details section."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.",
       "           If UPLO = 'U': the leading N-by-N upper triangular part",
       "           of A contains the upper triangular part of the matrix A,",
       "           and the strictly lower triangular part of A is not",
       "           referenced.",
       "           If UPLO = 'L': the leading N-by-N lower triangular part",
       "           of A contains the lower triangular part of the matrix A,",
       "           and the strictly upper triangular part of A is not",
       "           referenced.",
       "         On exit, contains:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               are stored on exit in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (N)",
       "         On exit, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i), i=2:N, E(1) is set to 0;",
       "         If UPLO = 'L': E(i) = D(i+1,i), i=1:N-1, E(N) is set to 0.",
       "         NOTE: For 1-by-1 diagonal block D(k), where",
       "         1 <= k <= N, the element E(k) is set to 0 in both",
       "         UPLO = 'U' or UPLO = 'L' cases."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         IPIV describes the permutation matrix P in the factorization",
       "         of matrix A as follows. The absolute value of IPIV(k)",
       "         represents the index of row and column that were",
       "         interchanged with the k-th row and column. The value of UPLO",
       "         describes the order in which the interchanges were applied.",
       "         Also, the sign of IPIV represents the block structure of",
       "         the symmetric block diagonal matrix D with 1-by-1 or 2-by-2",
       "         diagonal blocks which correspond to 1 or 2 interchanges",
       "         at each factorization step. For more info see Further",
       "         Details section.",
       "         If UPLO = 'U',",
       "         ( in factorization order, k decreases from N to 1 ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the matrix A(1:N,1:N);",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k-1) < 0 means:",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k-1) != k-1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k-1) = k-1, no interchange occurred.",
       "           c) In both cases a) and b), always ABS( IPIV(k) ) <= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output.",
       "         If UPLO = 'L',",
       "         ( in factorization order, k increases from 1 to N ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the matrix A(1:N,1:N).",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k+1) < 0 means:",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k+1) != k+1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k+1) = k+1, no interchange occurred.",
       "           c) In both cases a) and b), always ABS( IPIV(k) ) >= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension ( MAX(1,LWORK) ).",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >=1.  For best performance",
       "         LWORK >= N*NB, where NB is the block size returned",
       "         by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed;",
       "         the routine only calculates the optimal size of the WORK",
       "         array, returns this value as the first entry of the WORK",
       "         array, and no error message related to LWORK is issued",
       "         by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: If INFO = -k, the k-th argument had an illegal value",
       "         > 0: If INFO = k, the matrix A is singular, because:",
       "                If UPLO = 'U': column k in the upper",
       "                triangular part of A contains all zeros.",
       "                If UPLO = 'L': column k in the lower",
       "                triangular part of A contains all zeros.",
       "              Therefore D(k,k) is exactly zero, and superdiagonal",
       "              elements of column k of U (or subdiagonal elements of",
       "              column k of L ) are all zeros. The factorization has",
       "              been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if",
       "              it is used to solve a system of equations.",
       "              NOTE: INFO only stores the first occurrence of",
       "              a singularity, any subsequent occurrence of singularity",
       "              is not stored in INFO even though the factorization",
       "              always completes."]}},
 "ssytf2"=>
  {"summary"=>
    ["SSYTF2 computes the factorization of a real symmetric matrix A using",
     "the Bunch-Kaufman diagonal pivoting method:",
     "   A = U*D*U**T  or  A = L*D*L**T",
     "where U (or L) is a product of permutation and unit upper (lower)",
     "triangular matrices, U**T is the transpose of U, and D is symmetric and",
     "block diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "This is the unblocked version of the algorithm, calling Level 2 BLAS."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.  If UPLO = 'U', the leading",
       "         n-by-n upper triangular part of A contains the upper",
       "         triangular part of the matrix A, and the strictly lower",
       "         triangular part of A is not referenced.  If UPLO = 'L', the",
       "         leading n-by-n lower triangular part of A contains the lower",
       "         triangular part of the matrix A, and the strictly upper",
       "         triangular part of A is not referenced.",
       "         On exit, the block diagonal matrix D and the multipliers used",
       "         to obtain the factor U or L (see below for further details)."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D.",
       "         If UPLO = 'U':",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k-1) < 0, then rows and columns",
       "            k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)",
       "            is a 2-by-2 diagonal block.",
       "         If UPLO = 'L':",
       "            If IPIV(k) > 0, then rows and columns k and IPIV(k) were",
       "            interchanged and D(k,k) is a 1-by-1 diagonal block.",
       "            If IPIV(k) = IPIV(k+1) < 0, then rows and columns",
       "            k+1 and -IPIV(k) were interchanged and D(k:k+1,k:k+1)",
       "            is a 2-by-2 diagonal block."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: if INFO = -k, the k-th argument had an illegal value",
       "         > 0: if INFO = k, D(k,k) is exactly zero.  The factorization",
       "              has been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if it",
       "              is used to solve a system of equations."]}},
 "ctrevc3"=>
  {"summary"=>
    ["CTREVC3 computes some or all of the right and/or left eigenvectors of",
     "a complex upper triangular matrix T.",
     "Matrices of this type are produced by the Schur factorization of",
     "a complex general matrix:  A = Q*T*Q**H, as computed by CHSEQR.",
     "The right eigenvector x and the left eigenvector y of T corresponding",
     "to an eigenvalue w are defined by:",
     "             T*x = w*x,     (y**H)*T = w*(y**H)",
     "where y**H denotes the conjugate transpose of the vector y.",
     "The eigenvalues are not input to this routine, but are read directly",
     "from the diagonal of T.",
     "This routine returns the matrices X and/or Y of right and left",
     "eigenvectors of T, or the products Q*X and/or Q*Y, where Q is an",
     "input matrix. If Q is the unitary factor that reduces a matrix A to",
     "Schur form T, then Q*X and Q*Y are the matrices of right and left",
     "eigenvectors of A.",
     "This uses a Level 3 BLAS version of the back transformation."],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'R':  compute right eigenvectors only;",
       "         = 'L':  compute left eigenvectors only;",
       "         = 'B':  compute both right and left eigenvectors."],
     "HOWMNY"=>
      ["[in]",
       "         HOWMNY is CHARACTER*1",
       "         = 'A':  compute all right and/or left eigenvectors;",
       "         = 'B':  compute all right and/or left eigenvectors,",
       "                 backtransformed using the matrices supplied in",
       "                 VR and/or VL;",
       "         = 'S':  compute selected right and/or left eigenvectors,",
       "                 as indicated by the logical array SELECT."],
     "SELECT"=>
      ["[in]",
       "         SELECT is LOGICAL array, dimension (N)",
       "         If HOWMNY = 'S', SELECT specifies the eigenvectors to be",
       "         computed.",
       "         The eigenvector corresponding to the j-th eigenvalue is",
       "         computed if SELECT(j) = .TRUE..",
       "         Not referenced if HOWMNY = 'A' or 'B'."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix T. N >= 0."],
     "T"=>
      ["[in,out]",
       "         T is COMPLEX array, dimension (LDT,N)",
       "         The upper triangular matrix T.  T is modified, but restored",
       "         on exit."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T. LDT >= max(1,N)."],
     "VL"=>
      ["[in,out]",
       "         VL is COMPLEX array, dimension (LDVL,MM)",
       "         On entry, if SIDE = 'L' or 'B' and HOWMNY = 'B', VL must",
       "         contain an N-by-N matrix Q (usually the unitary matrix Q of",
       "         Schur vectors returned by CHSEQR).",
       "         On exit, if SIDE = 'L' or 'B', VL contains:",
       "         if HOWMNY = 'A', the matrix Y of left eigenvectors of T;",
       "         if HOWMNY = 'B', the matrix Q*Y;",
       "         if HOWMNY = 'S', the left eigenvectors of T specified by",
       "                          SELECT, stored consecutively in the columns",
       "                          of VL, in the same order as their",
       "                          eigenvalues.",
       "         Not referenced if SIDE = 'R'."],
     "LDVL"=>
      ["[in]",
       "         LDVL is INTEGER",
       "         The leading dimension of the array VL.",
       "         LDVL >= 1, and if SIDE = 'L' or 'B', LDVL >= N."],
     "VR"=>
      ["[in,out]",
       "         VR is COMPLEX array, dimension (LDVR,MM)",
       "         On entry, if SIDE = 'R' or 'B' and HOWMNY = 'B', VR must",
       "         contain an N-by-N matrix Q (usually the unitary matrix Q of",
       "         Schur vectors returned by CHSEQR).",
       "         On exit, if SIDE = 'R' or 'B', VR contains:",
       "         if HOWMNY = 'A', the matrix X of right eigenvectors of T;",
       "         if HOWMNY = 'B', the matrix Q*X;",
       "         if HOWMNY = 'S', the right eigenvectors of T specified by",
       "                          SELECT, stored consecutively in the columns",
       "                          of VR, in the same order as their",
       "                          eigenvalues.",
       "         Not referenced if SIDE = 'L'."],
     "LDVR"=>
      ["[in]",
       "         LDVR is INTEGER",
       "         The leading dimension of the array VR.",
       "         LDVR >= 1, and if SIDE = 'R' or 'B', LDVR >= N."],
     "MM"=>
      ["[in]",
       "         MM is INTEGER",
       "         The number of columns in the arrays VL and/or VR. MM >= M."],
     "M"=>
      ["[out]",
       "         M is INTEGER",
       "         The number of columns in the arrays VL and/or VR actually",
       "         used to store the eigenvectors.",
       "         If HOWMNY = 'A' or 'B', M is set to N.",
       "         Each selected eigenvector occupies one column."],
     "WORK"=>
      ["[out]", "         WORK is COMPLEX array, dimension (MAX(1,LWORK))"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of array WORK. LWORK >= max(1,2*N).",
       "         For optimum performance, LWORK >= N + 2*N*NB, where NB is",
       "         the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (LRWORK)"],
     "LRWORK"=>
      ["[in]",
       "         LRWORK is INTEGER",
       "         The dimension of array RWORK. LRWORK >= max(1,N).",
       "         If LRWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the RWORK array, returns",
       "         this value as the first entry of the RWORK array, and no error",
       "         message related to LRWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zgghrd"=>
  {"summary"=>
    ["ZGGHRD reduces a pair of complex matrices (A,B) to generalized upper",
     "Hessenberg form using unitary transformations, where A is a",
     "general matrix and B is upper triangular.  The form of the",
     "generalized eigenvalue problem is",
     "   A*x = lambda*B*x,",
     "and B is typically made upper triangular by computing its QR",
     "factorization and moving the unitary matrix Q to the left side",
     "of the equation.",
     "This subroutine simultaneously reduces A to a Hessenberg matrix H:",
     "   Q**H*A*Z = H",
     "and transforms B to another upper triangular matrix T:",
     "   Q**H*B*Z = T",
     "in order to reduce the problem to its standard form",
     "   H*y = lambda*T*y",
     "where y = Z**H*x.",
     "The unitary matrices Q and Z are determined as products of Givens",
     "rotations.  They may either be formed explicitly, or they may be",
     "postmultiplied into input matrices Q1 and Z1, so that",
     "     Q1 * A * Z1**H = (Q1*Q) * H * (Z1*Z)**H",
     "     Q1 * B * Z1**H = (Q1*Q) * T * (Z1*Z)**H",
     "If Q1 is the unitary matrix from the QR factorization of B in the",
     "original equation A*x = lambda*B*x, then ZGGHRD reduces the original",
     "problem to generalized Hessenberg form."],
   "param"=>
    {"COMPQ"=>
      ["[in]",
       "         COMPQ is CHARACTER*1",
       "         = 'N': do not compute Q;",
       "         = 'I': Q is initialized to the unit matrix, and the",
       "                unitary matrix Q is returned;",
       "         = 'V': Q must contain a unitary matrix Q1 on entry,",
       "                and the product Q1*Q is returned."],
     "COMPZ"=>
      ["[in]",
       "         COMPZ is CHARACTER*1",
       "         = 'N': do not compute Z;",
       "         = 'I': Z is initialized to the unit matrix, and the",
       "                unitary matrix Z is returned;",
       "         = 'V': Z must contain a unitary matrix Z1 on entry,",
       "                and the product Z1*Z is returned."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "ILO"=>["[in]", "         ILO is INTEGER"],
     "IHI"=>
      ["[in]",
       "         IHI is INTEGER",
       "         ILO and IHI mark the rows and columns of A which are to be",
       "         reduced.  It is assumed that A is already upper triangular",
       "         in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are",
       "         normally set by a previous call to ZGGBAL; otherwise they",
       "         should be set to 1 and N respectively.",
       "         1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA, N)",
       "         On entry, the N-by-N general matrix to be reduced.",
       "         On exit, the upper triangle and the first subdiagonal of A",
       "         are overwritten with the upper Hessenberg matrix H, and the",
       "         rest is set to zero."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX*16 array, dimension (LDB, N)",
       "         On entry, the N-by-N upper triangular matrix B.",
       "         On exit, the upper triangular matrix T = Q**H B Z.  The",
       "         elements below the diagonal are set to zero."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "Q"=>
      ["[in,out]",
       "         Q is COMPLEX*16 array, dimension (LDQ, N)",
       "         On entry, if COMPQ = 'V', the unitary matrix Q1, typically",
       "         from the QR factorization of B.",
       "         On exit, if COMPQ='I', the unitary matrix Q, and if",
       "         COMPQ = 'V', the product Q1*Q.",
       "         Not referenced if COMPQ='N'."],
     "LDQ"=>
      ["[in]",
       "         LDQ is INTEGER",
       "         The leading dimension of the array Q.",
       "         LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise."],
     "Z"=>
      ["[in,out]",
       "         Z is COMPLEX*16 array, dimension (LDZ, N)",
       "         On entry, if COMPZ = 'V', the unitary matrix Z1.",
       "         On exit, if COMPZ='I', the unitary matrix Z, and if",
       "         COMPZ = 'V', the product Z1*Z.",
       "         Not referenced if COMPZ='N'."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.",
       "         LDZ >= N if COMPZ='V' or 'I'; LDZ >= 1 otherwise."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "zporfsx"=>
  {"summary"=>
    ["   ZPORFSX improves the computed solution to a system of linear",
     "   equations when the coefficient matrix is symmetric positive",
     "   definite, and provides error bounds and backward error estimates",
     "   for the solution.  In addition to normwise error bound, the code",
     "   provides maximum componentwise error bound if possible.  See",
     "   comments for ERR_BNDS_NORM and ERR_BNDS_COMP for details of the",
     "   error bounds.",
     "   The original system of linear equations may have been equilibrated",
     "   before calling this routine, as described by arguments EQUED and S",
     "   below. In this case, the solution and error bounds returned are",
     "   for the original unequilibrated system.",
     "    Some optional parameters are bundled in the PARAMS array.  These",
     "    settings determine how refinement is performed, but often the",
     "    defaults are acceptable.  If the defaults are acceptable, users",
     "    can pass NPARAMS = 0 which prevents the source code from accessing",
     "    the PARAMS argument."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "      = 'U':  Upper triangle of A is stored;",
       "      = 'L':  Lower triangle of A is stored."],
     "EQUED"=>
      ["[in]",
       "         EQUED is CHARACTER*1",
       "    Specifies the form of equilibration that was done to A",
       "    before calling this routine. This is needed to compute",
       "    the solution and error bounds correctly.",
       "      = 'N':  No equilibration",
       "      = 'Y':  Both row and column equilibration, i.e., A has been",
       "              replaced by diag(S) * A * diag(S).",
       "              The right hand side B has been changed accordingly."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "    The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "    The number of right hand sides, i.e., the number of columns",
       "    of the matrices B and X.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "    The symmetric matrix A.  If UPLO = 'U', the leading N-by-N",
       "    upper triangular part of A contains the upper triangular part",
       "    of the matrix A, and the strictly lower triangular part of A",
       "    is not referenced.  If UPLO = 'L', the leading N-by-N lower",
       "    triangular part of A contains the lower triangular part of",
       "    the matrix A, and the strictly upper triangular part of A is",
       "    not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "    The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX*16 array, dimension (LDAF,N)",
       "    The triangular factor U or L from the Cholesky factorization",
       "    A = U**T*U or A = L*L**T, as computed by DPOTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "    The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "S"=>
      ["[in,out]",
       "         S is DOUBLE PRECISION array, dimension (N)",
       "    The row scale factors for A.  If EQUED = 'Y', A is multiplied on",
       "    the left and right by diag(S).  S is an input argument if FACT =",
       "    'F'; otherwise, S is an output argument.  If FACT = 'F' and EQUED",
       "    = 'Y', each element of S must be positive.  If S is output, each",
       "    element of S is a power of the radix. If S is input, each element",
       "    of S should be a power of the radix to ensure a reliable solution",
       "    and error estimates. Scaling by powers of the radix does not cause",
       "    rounding errors unless the result underflows or overflows.",
       "    Rounding errors during scaling lead to refining with a matrix that",
       "    is not equivalent to the input matrix, producing error estimates",
       "    that may not be reliable."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "    The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "    The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array, dimension (LDX,NRHS)",
       "    On entry, the solution matrix X, as computed by DGETRS.",
       "    On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "    The leading dimension of the array X.  LDX >= max(1,N)."],
     "RCOND"=>
      ["[out]",
       "         RCOND is DOUBLE PRECISION",
       "    Reciprocal scaled condition number.  This is an estimate of the",
       "    reciprocal Skeel condition number of the matrix A after",
       "    equilibration (if done).  If this is less than the machine",
       "    precision (in particular, if it is zero), the matrix is singular",
       "    to working precision.  Note that the error may still be small even",
       "    if this number is very small and the matrix appears ill-",
       "    conditioned."],
     "BERR"=>
      ["[out]",
       "         BERR is DOUBLE PRECISION array, dimension (NRHS)",
       "    Componentwise relative backward error.  This is the",
       "    componentwise relative backward error of each solution vector X(j)",
       "    (i.e., the smallest relative change in any element of A or B that",
       "    makes X(j) an exact solution)."],
     "N_ERR_BNDS"=>
      ["[in]",
       "         N_ERR_BNDS is INTEGER",
       "    Number of error bounds to return for each right hand side",
       "    and each type (normwise or componentwise).  See ERR_BNDS_NORM and",
       "    ERR_BNDS_COMP below."],
     "ERR_BNDS_NORM"=>
      ["[out]",
       "         ERR_BNDS_NORM is DOUBLE PRECISION array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    normwise relative error, which is defined as follows:",
       "    Normwise relative error in the ith solution vector:",
       "            max_j (abs(XTRUE(j,i) - X(j,i)))",
       "           ------------------------------",
       "                 max_j abs(X(j,i))",
       "    The array is indexed by the type of error information as described",
       "    below. There currently are up to three pieces of information",
       "    returned.",
       "    The first index in ERR_BNDS_NORM(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_NORM(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * dlamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * dlamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated normwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * dlamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*A, where S scales each row by a power of the",
       "             radix so all absolute row sums of Z are approximately 1.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "ERR_BNDS_COMP"=>
      ["[out]",
       "         ERR_BNDS_COMP is DOUBLE PRECISION array, dimension (NRHS, N_ERR_BNDS)",
       "    For each right-hand side, this array contains information about",
       "    various error bounds and condition numbers corresponding to the",
       "    componentwise relative error, which is defined as follows:",
       "    Componentwise relative error in the ith solution vector:",
       "                   abs(XTRUE(j,i) - X(j,i))",
       "            max_j ----------------------",
       "                        abs(X(j,i))",
       "    The array is indexed by the right-hand side i (on which the",
       "    componentwise relative error depends), and the type of error",
       "    information as described below. There currently are up to three",
       "    pieces of information returned for each right-hand side. If",
       "    componentwise accuracy is not requested (PARAMS(3) = 0.0), then",
       "    ERR_BNDS_COMP is not accessed.  If N_ERR_BNDS .LT. 3, then at most",
       "    the first (:,N_ERR_BNDS) entries are returned.",
       "    The first index in ERR_BNDS_COMP(i,:) corresponds to the ith",
       "    right-hand side.",
       "    The second index in ERR_BNDS_COMP(:,err) contains the following",
       "    three fields:",
       "    err = 1 \"Trust/don't trust\" boolean. Trust the answer if the",
       "             reciprocal condition number is less than the threshold",
       "             sqrt(n) * dlamch('Epsilon').",
       "    err = 2 \"Guaranteed\" error bound: The estimated forward error,",
       "             almost certainly within a factor of 10 of the true error",
       "             so long as the next entry is greater than the threshold",
       "             sqrt(n) * dlamch('Epsilon'). This error bound should only",
       "             be trusted if the previous boolean is true.",
       "    err = 3  Reciprocal condition number: Estimated componentwise",
       "             reciprocal condition number.  Compared with the threshold",
       "             sqrt(n) * dlamch('Epsilon') to determine if the error",
       "             estimate is \"guaranteed\". These reciprocal condition",
       "             numbers are 1 / (norm(Z^{-1},inf) * norm(Z,inf)) for some",
       "             appropriately scaled matrix Z.",
       "             Let Z = S*(A*diag(x)), where x is the solution for the",
       "             current right-hand side and S scales each row of",
       "             A*diag(x) by a power of the radix so all absolute row",
       "             sums of Z are approximately 1.",
       "    See Lapack Working Note 165 for further details and extra",
       "    cautions."],
     "NPARAMS"=>
      ["[in]",
       "         NPARAMS is INTEGER",
       "    Specifies the number of parameters set in PARAMS.  If .LE. 0, the",
       "    PARAMS array is never referenced and default values are used."],
     "PARAMS"=>
      ["[in,out]",
       "         PARAMS is DOUBLE PRECISION array, dimension NPARAMS",
       "    Specifies algorithm parameters.  If an entry is .LT. 0.0, then",
       "    that entry will be filled with default value used for that",
       "    parameter.  Only positions up to NPARAMS are accessed; defaults",
       "    are used for higher-numbered parameters.",
       "      PARAMS(LA_LINRX_ITREF_I = 1) : Whether to perform iterative",
       "           refinement or not.",
       "        Default: 1.0D+0",
       "           = 0.0 : No refinement is performed, and no error bounds are",
       "                   computed.",
       "           = 1.0 : Use the double-precision refinement algorithm,",
       "                   possibly with doubled-single computations if the",
       "                   compilation environment does not support DOUBLE",
       "                   PRECISION.",
       "             (other values are reserved for future use)",
       "      PARAMS(LA_LINRX_ITHRESH_I = 2) : Maximum number of residual",
       "           computations allowed for refinement.",
       "        Default: 10",
       "        Aggressive: Set to 100 to permit convergence using approximate",
       "                    factorizations or factorizations other than LU. If",
       "                    the factorization uses a technique other than",
       "                    Gaussian elimination, the guarantees in",
       "                    err_bnds_norm and err_bnds_comp may no longer be",
       "                    trustworthy.",
       "      PARAMS(LA_LINRX_CWISE_I = 3) : Flag determining if the code",
       "           will attempt to find a solution with small componentwise",
       "           relative error in the double-precision algorithm.  Positive",
       "           is true, 0.0 is false.",
       "        Default: 1.0 (attempt componentwise convergence)"],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (2*N)"],
     "RWORK"=>
      ["[out]", "         RWORK is DOUBLE PRECISION array, dimension (2*N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "      = 0:  Successful exit. The solution to every right-hand side is",
       "        guaranteed.",
       "      < 0:  If INFO = -i, the i-th argument had an illegal value",
       "      > 0 and <= N:  U(INFO,INFO) is exactly zero.  The factorization",
       "        has been completed, but the factor U is exactly singular, so",
       "        the solution and error bounds could not be computed. RCOND = 0",
       "        is returned.",
       "      = N+J: The solution corresponding to the Jth right-hand side is",
       "        not guaranteed. The solutions corresponding to other right-",
       "        hand sides K with K > J may not be guaranteed as well, but",
       "        only the first such right-hand side is reported. If a small",
       "        componentwise error is not requested (PARAMS(3) = 0.0) then",
       "        the Jth right-hand side is the first with a normwise error",
       "        bound that is not guaranteed (the smallest J such",
       "        that ERR_BNDS_NORM(J,1) = 0.0). By default (PARAMS(3) = 1.0)",
       "        the Jth right-hand side is the first with either a normwise or",
       "        componentwise error bound that is not guaranteed (the smallest",
       "        J such that either ERR_BNDS_NORM(J,1) = 0.0 or",
       "        ERR_BNDS_COMP(J,1) = 0.0). See the definition of",
       "        ERR_BNDS_NORM(:,1) and ERR_BNDS_COMP(:,1). To get information",
       "        about all of the right-hand sides check ERR_BNDS_NORM or",
       "        ERR_BNDS_COMP."]}},
 "dsgesv"=>
  {"summary"=>
    ["DSGESV computes the solution to a real system of linear equations",
     "   A * X = B,",
     "where A is an N-by-N matrix and X and B are N-by-NRHS matrices.",
     "DSGESV first attempts to factorize the matrix in SINGLE PRECISION",
     "and use this factorization within an iterative refinement procedure",
     "to produce a solution with DOUBLE PRECISION normwise backward error",
     "quality (see below). If the approach fails the method switches to a",
     "DOUBLE PRECISION factorization and solve.",
     "The iterative refinement is not going to be a winning strategy if",
     "the ratio SINGLE PRECISION performance over DOUBLE PRECISION",
     "performance is too small. A reasonable strategy should take the",
     "number of right-hand sides and the size of the matrix into account.",
     "This might be done with a call to ILAENV in the future. Up to now, we",
     "always try iterative refinement.",
     "The iterative refinement process is stopped if",
     "    ITER > ITERMAX",
     "or for all the RHS we have:",
     "    RNRM < SQRT(N)*XNRM*ANRM*EPS*BWDMAX",
     "where",
     "    o ITER is the number of the current iteration in the iterative",
     "      refinement process",
     "    o RNRM is the infinity-norm of the residual",
     "    o XNRM is the infinity-norm of the solution",
     "    o ANRM is the infinity-operator-norm of the matrix A",
     "    o EPS is the machine epsilon returned by DLAMCH('Epsilon')",
     "The value ITERMAX and BWDMAX are fixed to 30 and 1.0D+00",
     "respectively."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of linear equations, i.e., the order of the",
       "         matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrix B.  NRHS >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array,",
       "         dimension (LDA,N)",
       "         On entry, the N-by-N coefficient matrix A.",
       "         On exit, if iterative refinement has been successfully used",
       "         (INFO.EQ.0 and ITER.GE.0, see description below), then A is",
       "         unchanged, if double precision factorization has been used",
       "         (INFO.EQ.0 and ITER.LT.0, see description below), then the",
       "         array A contains the factors L and U from the factorization",
       "         A = P*L*U; the unit diagonal elements of L are not stored."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         The pivot indices that define the permutation matrix P;",
       "         row i of the matrix was interchanged with row IPIV(i).",
       "         Corresponds either to the single precision factorization",
       "         (if INFO.EQ.0 and ITER.GE.0) or the double precision",
       "         factorization (if INFO.EQ.0 and ITER.LT.0)."],
     "B"=>
      ["[in]",
       "         B is DOUBLE PRECISION array, dimension (LDB,NRHS)",
       "         The N-by-NRHS right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[out]",
       "         X is DOUBLE PRECISION array, dimension (LDX,NRHS)",
       "         If INFO = 0, the N-by-NRHS solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.  LDX >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (N,NRHS)",
       "         This array is used to hold the residual vectors."],
     "SWORK"=>
      ["[out]",
       "         SWORK is REAL array, dimension (N*(N+NRHS))",
       "         This array is used to use the single precision matrix and the",
       "         right-hand sides or solutions in single precision."],
     "ITER"=>
      ["[out]",
       "         ITER is INTEGER",
       "         < 0: iterative refinement has failed, double precision",
       "              factorization has been performed",
       "              -1 : the routine fell back to full precision for",
       "                   implementation- or machine-specific reasons",
       "              -2 : narrowing the precision induced an overflow,",
       "                   the routine fell back to full precision",
       "              -3 : failure of SGETRF",
       "              -31: stop the iterative refinement after the 30th",
       "                   iterations",
       "         > 0: iterative refinement has been successfully used.",
       "              Returns the number of iterations"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, U(i,i) computed in DOUBLE PRECISION is",
       "               exactly zero.  The factorization has been completed,",
       "               but the factor U is exactly singular, so the solution",
       "               could not be computed."]}},
 "dstein"=>
  {"summary"=>
    ["DSTEIN computes the eigenvectors of a real symmetric tridiagonal",
     "matrix T corresponding to specified eigenvalues, using inverse",
     "iteration.",
     "The maximum number of iterations allowed for each eigenvector is",
     "specified by an internal parameter MAXITS (currently set to 5)."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix.  N >= 0."],
     "D"=>
      ["[in]",
       "         D is DOUBLE PRECISION array, dimension (N)",
       "         The n diagonal elements of the tridiagonal matrix T."],
     "E"=>
      ["[in]",
       "         E is DOUBLE PRECISION array, dimension (N-1)",
       "         The (n-1) subdiagonal elements of the tridiagonal matrix",
       "         T, in elements 1 to N-1."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of eigenvectors to be found.  0 <= M <= N."],
     "W"=>
      ["[in]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         The first M elements of W contain the eigenvalues for",
       "         which eigenvectors are to be computed.  The eigenvalues",
       "         should be grouped by split-off block and ordered from",
       "         smallest to largest within the block.  ( The output array",
       "         W from DSTEBZ with ORDER = 'B' is expected here. )"],
     "IBLOCK"=>
      ["[in]",
       "         IBLOCK is INTEGER array, dimension (N)",
       "         The submatrix indices associated with the corresponding",
       "         eigenvalues in W; IBLOCK(i)=1 if eigenvalue W(i) belongs to",
       "         the first submatrix from the top, =2 if W(i) belongs to",
       "         the second submatrix, etc.  ( The output array IBLOCK",
       "         from DSTEBZ is expected here. )"],
     "ISPLIT"=>
      ["[in]",
       "         ISPLIT is INTEGER array, dimension (N)",
       "         The splitting points, at which T breaks up into submatrices.",
       "         The first submatrix consists of rows/columns 1 to",
       "         ISPLIT( 1 ), the second of rows/columns ISPLIT( 1 )+1",
       "         through ISPLIT( 2 ), etc.",
       "         ( The output array ISPLIT from DSTEBZ is expected here. )"],
     "Z"=>
      ["[out]",
       "         Z is DOUBLE PRECISION array, dimension (LDZ, M)",
       "         The computed eigenvectors.  The eigenvector associated",
       "         with the eigenvalue W(i) is stored in the i-th column of",
       "         Z.  Any vector which fails to converge is set to its current",
       "         iterate after MAXITS iterations."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]", "         WORK is DOUBLE PRECISION array, dimension (5*N)"],
     "IWORK"=>["[out]", "         IWORK is INTEGER array, dimension (N)"],
     "IFAIL"=>
      ["[out]",
       "         IFAIL is INTEGER array, dimension (M)",
       "         On normal exit, all elements of IFAIL are zero.",
       "         If one or more eigenvectors fail to converge after",
       "         MAXITS iterations, then their indices are stored in",
       "         array IFAIL."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit.",
       "         < 0: if INFO = -i, the i-th argument had an illegal value",
       "         > 0: if INFO = i, then i eigenvectors failed to converge",
       "              in MAXITS iterations.  Their indices are stored in",
       "              array IFAIL."]}},
 "chbgst"=>
  {"summary"=>
    ["CHBGST reduces a complex Hermitian-definite banded generalized",
     "eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,",
     "such that C has the same bandwidth as A.",
     "B must have been previously factorized as S**H*S by CPBSTF, using a",
     "split Cholesky factorization. A is overwritten by C = X**H*A*X, where",
     "X = S**(-1)*Q and Q is a unitary matrix chosen to preserve the",
     "bandwidth of A."],
   "param"=>
    {"VECT"=>
      ["[in]",
       "         VECT is CHARACTER*1",
       "         = 'N':  do not form the transformation matrix X;",
       "         = 'V':  form X."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A and B.  N >= 0."],
     "KA"=>
      ["[in]",
       "         KA is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KA >= 0."],
     "KB"=>
      ["[in]",
       "         KB is INTEGER",
       "         The number of superdiagonals of the matrix B if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KA >= KB >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is COMPLEX array, dimension (LDAB,N)",
       "         On entry, the upper or lower triangle of the Hermitian band",
       "         matrix A, stored in the first ka+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(ka+1+i-j,j) = A(i,j) for max(1,j-ka)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+ka).",
       "         On exit, the transformed matrix X**H*A*X, stored in the same",
       "         format as A."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KA+1."],
     "BB"=>
      ["[in]",
       "         BB is COMPLEX array, dimension (LDBB,N)",
       "         The banded factor S from the split Cholesky factorization of",
       "         B, as returned by CPBSTF, stored in the first kb+1 rows of",
       "         the array."],
     "LDBB"=>
      ["[in]",
       "         LDBB is INTEGER",
       "         The leading dimension of the array BB.  LDBB >= KB+1."],
     "X"=>
      ["[out]",
       "         X is COMPLEX array, dimension (LDX,N)",
       "         If VECT = 'V', the n-by-n matrix X.",
       "         If VECT = 'N', the array X is not referenced."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.",
       "         LDX >= max(1,N) if VECT = 'V'; LDX >= 1 otherwise."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (N)"],
     "RWORK"=>["[out]", "         RWORK is REAL array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value."]}},
 "zlacp2"=>
  {"summary"=>
    ["ZLACP2 copies all or part of a real two-dimensional matrix A to a",
     "complex matrix B."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies the part of the matrix A to be copied to B.",
       "         = 'U':      Upper triangular part",
       "         = 'L':      Lower triangular part",
       "         Otherwise:  All of the matrix A"],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix A.  N >= 0."],
     "A"=>
      ["[in]",
       "         A is DOUBLE PRECISION array, dimension (LDA,N)",
       "         The m by n matrix A.  If UPLO = 'U', only the upper trapezium",
       "         is accessed; if UPLO = 'L', only the lower trapezium is",
       "         accessed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "B"=>
      ["[out]",
       "         B is COMPLEX*16 array, dimension (LDB,N)",
       "         On exit, B = A in the locations specified by UPLO."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."]}},
 "zheev"=>
  {"summary"=>
    ["ZHEEV computes all eigenvalues and, optionally, eigenvectors of a",
     "complex Hermitian matrix A."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA, N)",
       "         On entry, the Hermitian matrix A.  If UPLO = 'U', the",
       "         leading N-by-N upper triangular part of A contains the",
       "         upper triangular part of the matrix A.  If UPLO = 'L',",
       "         the leading N-by-N lower triangular part of A contains",
       "         the lower triangular part of the matrix A.",
       "         On exit, if JOBZ = 'V', then if INFO = 0, A contains the",
       "         orthonormal eigenvectors of the matrix A.",
       "         If JOBZ = 'N', then on exit the lower triangle (if UPLO='L')",
       "         or the upper triangle (if UPLO='U') of A, including the",
       "         diagonal, is destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "W"=>
      ["[out]",
       "         W is DOUBLE PRECISION array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK.  LWORK >= max(1,2*N-1).",
       "         For optimal efficiency, LWORK >= (NB+1)*N,",
       "         where NB is the blocksize for ZHETRD returned by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "RWORK"=>
      ["[out]",
       "         RWORK is DOUBLE PRECISION array, dimension (max(1, 3*N-2))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the algorithm failed to converge; i",
       "               off-diagonal elements of an intermediate tridiagonal",
       "               form did not converge to zero."]}},
 "slabrd"=>
  {"summary"=>
    ["SLABRD reduces the first NB rows and columns of a real general",
     "m by n matrix A to upper or lower bidiagonal form by an orthogonal",
     "transformation Q**T * A * P, and returns the matrices X and Y which",
     "are needed to apply the transformation to the unreduced part of A.",
     "If m >= n, A is reduced to upper bidiagonal form; if m < n, to lower",
     "bidiagonal form.",
     "This is an auxiliary routine called by SGEBRD"],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows in the matrix A."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns in the matrix A."],
     "NB"=>
      ["[in]",
       "         NB is INTEGER",
       "         The number of leading rows and columns of A to be reduced."],
     "A"=>
      ["[in,out]",
       "         A is REAL array, dimension (LDA,N)",
       "         On entry, the m by n general matrix to be reduced.",
       "         On exit, the first NB rows and columns of the matrix are",
       "         overwritten; the rest of the array is unchanged.",
       "         If m >= n, elements on and below the diagonal in the first NB",
       "           columns, with the array TAUQ, represent the orthogonal",
       "           matrix Q as a product of elementary reflectors; and",
       "           elements above the diagonal in the first NB rows, with the",
       "           array TAUP, represent the orthogonal matrix P as a product",
       "           of elementary reflectors.",
       "         If m < n, elements below the diagonal in the first NB",
       "           columns, with the array TAUQ, represent the orthogonal",
       "           matrix Q as a product of elementary reflectors, and",
       "           elements on and above the diagonal in the first NB rows,",
       "           with the array TAUP, represent the orthogonal matrix P as",
       "           a product of elementary reflectors.",
       "         See Further Details."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "D"=>
      ["[out]",
       "         D is REAL array, dimension (NB)",
       "         The diagonal elements of the first NB rows and columns of",
       "         the reduced matrix.  D(i) = A(i,i)."],
     "E"=>
      ["[out]",
       "         E is REAL array, dimension (NB)",
       "         The off-diagonal elements of the first NB rows and columns of",
       "         the reduced matrix."],
     "TAUQ"=>
      ["[out]",
       "         TAUQ is REAL array dimension (NB)",
       "         The scalar factors of the elementary reflectors which",
       "         represent the orthogonal matrix Q. See Further Details."],
     "TAUP"=>
      ["[out]",
       "         TAUP is REAL array, dimension (NB)",
       "         The scalar factors of the elementary reflectors which",
       "         represent the orthogonal matrix P. See Further Details."],
     "X"=>
      ["[out]",
       "         X is REAL array, dimension (LDX,NB)",
       "         The m-by-nb matrix X required to update the unreduced part",
       "         of A."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X. LDX >= max(1,M)."],
     "Y"=>
      ["[out]",
       "         Y is REAL array, dimension (LDY,NB)",
       "         The n-by-nb matrix Y required to update the unreduced part",
       "         of A."],
     "LDY"=>
      ["[in]",
       "         LDY is INTEGER",
       "         The leading dimension of the array Y. LDY >= max(1,N)."]}},
 "ssbevd_2stage"=>
  {"summary"=>
    ["SSBEVD_2STAGE computes all the eigenvalues and, optionally, eigenvectors of",
     "a real symmetric band matrix A using the 2stage technique for",
     "the reduction to tridiagonal. If eigenvectors are desired, it uses",
     "a divide and conquer algorithm.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         = 'N':  Compute eigenvalues only;",
       "         = 'V':  Compute eigenvalues and eigenvectors.",
       "                 Not available in this release."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "KD"=>
      ["[in]",
       "         KD is INTEGER",
       "         The number of superdiagonals of the matrix A if UPLO = 'U',",
       "         or the number of subdiagonals if UPLO = 'L'.  KD >= 0."],
     "AB"=>
      ["[in,out]",
       "         AB is REAL array, dimension (LDAB, N)",
       "         On entry, the upper or lower triangle of the symmetric band",
       "         matrix A, stored in the first KD+1 rows of the array.  The",
       "         j-th column of A is stored in the j-th column of the array AB",
       "         as follows:",
       "         if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;",
       "         if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).",
       "         On exit, AB is overwritten by values generated during the",
       "         reduction to tridiagonal form.  If UPLO = 'U', the first",
       "         superdiagonal and the diagonal of the tridiagonal matrix T",
       "         are returned in rows KD and KD+1 of AB, and if UPLO = 'L',",
       "         the diagonal and first subdiagonal of T are returned in the",
       "         first two rows of AB."],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "         The leading dimension of the array AB.  LDAB >= KD + 1."],
     "W"=>
      ["[out]",
       "         W is REAL array, dimension (N)",
       "         If INFO = 0, the eigenvalues in ascending order."],
     "Z"=>
      ["[out]",
       "         Z is REAL array, dimension (LDZ, N)",
       "         If JOBZ = 'V', then if INFO = 0, Z contains the orthonormal",
       "         eigenvectors of the matrix A, with the i-th column of Z",
       "         holding the eigenvector associated with W(i).",
       "         If JOBZ = 'N', then Z is not referenced."],
     "LDZ"=>
      ["[in]",
       "         LDZ is INTEGER",
       "         The leading dimension of the array Z.  LDZ >= 1, and if",
       "         JOBZ = 'V', LDZ >= max(1,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension LWORK",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of the array WORK. LWORK >= 1, when N <= 1;",
       "         otherwise  ",
       "         If JOBZ = 'N' and N > 1, LWORK must be queried.",
       "                                  LWORK = MAX(1, dimension) where",
       "                                  dimension = (2KD+1)*N + KD*NTHREADS + N",
       "                                  where KD is the size of the band.",
       "                                  NTHREADS is the number of threads used when",
       "                                  openMP compilation is enabled, otherwise =1.",
       "         If JOBZ = 'V' and N > 1, LWORK must be queried. Not yet available.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal sizes of the WORK and IWORK",
       "         arrays, returns these values as the first entries of the WORK",
       "         and IWORK arrays, and no error message related to LWORK or",
       "         LIWORK is issued by XERBLA."],
     "IWORK"=>
      ["[out]",
       "         IWORK is INTEGER array, dimension (MAX(1,LIWORK))",
       "         On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK."],
     "LIWORK"=>
      ["[in]",
       "         LIWORK is INTEGER",
       "         The dimension of the array IWORK.",
       "         If JOBZ  = 'N' or N <= 1, LIWORK must be at least 1.",
       "         If JOBZ  = 'V' and N > 2, LIWORK must be at least 3 + 5*N.",
       "         If LIWORK = -1, then a workspace query is assumed; the",
       "         routine only calculates the optimal sizes of the WORK and",
       "         IWORK arrays, returns these values as the first entries of",
       "         the WORK and IWORK arrays, and no error message related to",
       "         LWORK or LIWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value",
       "         > 0:  if INFO = i, the algorithm failed to converge; i",
       "               off-diagonal elements of an intermediate tridiagonal",
       "               form did not converge to zero."]}},
 "cla_gbrpvgrw"=>
  {"summary"=>
    ["CLA_GBRPVGRW computes the reciprocal pivot growth factor",
     "norm(A)/norm(U). The \"max absolute element\" norm is used. If this is",
     "much less than 1, the stability of the LU factorization of the",
     "(equilibrated) matrix A could be poor. This also means that the",
     "solution X, estimated condition numbers, and error bounds could be",
     "unreliable."],
   "param"=>
    {"N"=>
      ["[in]",
       "         N is INTEGER",
       "    The number of linear equations, i.e., the order of the",
       "    matrix A.  N >= 0."],
     "KL"=>
      ["[in]",
       "         KL is INTEGER",
       "    The number of subdiagonals within the band of A.  KL >= 0."],
     "KU"=>
      ["[in]",
       "         KU is INTEGER",
       "    The number of superdiagonals within the band of A.  KU >= 0."],
     "NCOLS"=>
      ["[in]",
       "         NCOLS is INTEGER",
       "    The number of columns of the matrix A.  NCOLS >= 0."],
     "AB"=>
      ["[in]",
       "         AB is COMPLEX array, dimension (LDAB,N)",
       "    On entry, the matrix A in band storage, in rows 1 to KL+KU+1.",
       "    The j-th column of A is stored in the j-th column of the",
       "    array AB as follows:",
       "    AB(KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+kl)"],
     "LDAB"=>
      ["[in]",
       "         LDAB is INTEGER",
       "    The leading dimension of the array AB.  LDAB >= KL+KU+1."],
     "AFB"=>
      ["[in]",
       "         AFB is COMPLEX array, dimension (LDAFB,N)",
       "    Details of the LU factorization of the band matrix A, as",
       "    computed by CGBTRF.  U is stored as an upper triangular",
       "    band matrix with KL+KU superdiagonals in rows 1 to KL+KU+1,",
       "    and the multipliers used during the factorization are stored",
       "    in rows KL+KU+2 to 2*KL+KU+1."],
     "LDAFB"=>
      ["[in]",
       "         LDAFB is INTEGER",
       "    The leading dimension of the array AFB.  LDAFB >= 2*KL+KU+1."]}},
 "zsytrf_rk"=>
  {"summary"=>
    ["ZSYTRF_RK computes the factorization of a complex symmetric matrix A",
     "using the bounded Bunch-Kaufman (rook) diagonal pivoting method:",
     "   A = P*U*D*(U**T)*(P**T) or A = P*L*D*(L**T)*(P**T),",
     "where U (or L) is unit upper (or lower) triangular matrix,",
     "U**T (or L**T) is the transpose of U (or L), P is a permutation",
     "matrix, P**T is the transpose of P, and D is symmetric and block",
     "diagonal with 1-by-1 and 2-by-2 diagonal blocks.",
     "This is the blocked version of the algorithm, calling Level 3 BLAS.",
     "For more information see Further Details section."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the upper or lower triangular part of the",
       "         symmetric matrix A is stored:",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         On entry, the symmetric matrix A.",
       "           If UPLO = 'U': the leading N-by-N upper triangular part",
       "           of A contains the upper triangular part of the matrix A,",
       "           and the strictly lower triangular part of A is not",
       "           referenced.",
       "           If UPLO = 'L': the leading N-by-N lower triangular part",
       "           of A contains the lower triangular part of the matrix A,",
       "           and the strictly upper triangular part of A is not",
       "           referenced.",
       "         On exit, contains:",
       "           a) ONLY diagonal elements of the symmetric block diagonal",
       "              matrix D on the diagonal of A, i.e. D(k,k) = A(k,k);",
       "              (superdiagonal (or subdiagonal) elements of D",
       "               are stored on exit in array E), and",
       "           b) If UPLO = 'U': factor U in the superdiagonal part of A.",
       "              If UPLO = 'L': factor L in the subdiagonal part of A."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "E"=>
      ["[out]",
       "         E is COMPLEX*16 array, dimension (N)",
       "         On exit, contains the superdiagonal (or subdiagonal)",
       "         elements of the symmetric block diagonal matrix D",
       "         with 1-by-1 or 2-by-2 diagonal blocks, where",
       "         If UPLO = 'U': E(i) = D(i-1,i), i=2:N, E(1) is set to 0;",
       "         If UPLO = 'L': E(i) = D(i+1,i), i=1:N-1, E(N) is set to 0.",
       "         NOTE: For 1-by-1 diagonal block D(k), where",
       "         1 <= k <= N, the element E(k) is set to 0 in both",
       "         UPLO = 'U' or UPLO = 'L' cases."],
     "IPIV"=>
      ["[out]",
       "         IPIV is INTEGER array, dimension (N)",
       "         IPIV describes the permutation matrix P in the factorization",
       "         of matrix A as follows. The absolute value of IPIV(k)",
       "         represents the index of row and column that were",
       "         interchanged with the k-th row and column. The value of UPLO",
       "         describes the order in which the interchanges were applied.",
       "         Also, the sign of IPIV represents the block structure of",
       "         the symmetric block diagonal matrix D with 1-by-1 or 2-by-2",
       "         diagonal blocks which correspond to 1 or 2 interchanges",
       "         at each factorization step. For more info see Further",
       "         Details section.",
       "         If UPLO = 'U',",
       "         ( in factorization order, k decreases from N to 1 ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the matrix A(1:N,1:N);",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k-1) < 0 means:",
       "              D(k-1:k,k-1:k) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k-1) != k-1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k-1) = k-1, no interchange occurred.",
       "           c) In both cases a) and b), always ABS( IPIV(k) ) <= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output.",
       "         If UPLO = 'L',",
       "         ( in factorization order, k increases from 1 to N ):",
       "           a) A single positive entry IPIV(k) > 0 means:",
       "              D(k,k) is a 1-by-1 diagonal block.",
       "              If IPIV(k) != k, rows and columns k and IPIV(k) were",
       "              interchanged in the matrix A(1:N,1:N).",
       "              If IPIV(k) = k, no interchange occurred.",
       "           b) A pair of consecutive negative entries",
       "              IPIV(k) < 0 and IPIV(k+1) < 0 means:",
       "              D(k:k+1,k:k+1) is a 2-by-2 diagonal block.",
       "              (NOTE: negative entries in IPIV appear ONLY in pairs).",
       "              1) If -IPIV(k) != k, rows and columns",
       "                 k and -IPIV(k) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k) = k, no interchange occurred.",
       "              2) If -IPIV(k+1) != k+1, rows and columns",
       "                 k-1 and -IPIV(k-1) were interchanged",
       "                 in the matrix A(1:N,1:N).",
       "                 If -IPIV(k+1) = k+1, no interchange occurred.",
       "           c) In both cases a) and b), always ABS( IPIV(k) ) >= k.",
       "           d) NOTE: Any entry IPIV(k) is always NONZERO on output."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX*16 array, dimension ( MAX(1,LWORK) ).",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The length of WORK.  LWORK >=1.  For best performance",
       "         LWORK >= N*NB, where NB is the block size returned",
       "         by ILAENV.",
       "         If LWORK = -1, then a workspace query is assumed;",
       "         the routine only calculates the optimal size of the WORK",
       "         array, returns this value as the first entry of the WORK",
       "         array, and no error message related to LWORK is issued",
       "         by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0: successful exit",
       "         < 0: If INFO = -k, the k-th argument had an illegal value",
       "         > 0: If INFO = k, the matrix A is singular, because:",
       "                If UPLO = 'U': column k in the upper",
       "                triangular part of A contains all zeros.",
       "                If UPLO = 'L': column k in the lower",
       "                triangular part of A contains all zeros.",
       "              Therefore D(k,k) is exactly zero, and superdiagonal",
       "              elements of column k of U (or subdiagonal elements of",
       "              column k of L ) are all zeros. The factorization has",
       "              been completed, but the block diagonal matrix D is",
       "              exactly singular, and division by zero will occur if",
       "              it is used to solve a system of equations.",
       "              NOTE: INFO only stores the first occurrence of",
       "              a singularity, any subsequent occurrence of singularity",
       "              is not stored in INFO even though the factorization",
       "              always completes."]}},
 "zlanhs"=>
  {"summary"=>
    ["ZLANHS  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the  element of  largest absolute value  of a",
     "Hessenberg matrix A.",
     "   ZLANHS = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in ZLANHS as described",
       "         above."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, ZLANHS is",
       "         set to zero."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         The n by n upper Hessenberg matrix A; the part of A below the",
       "         first sub-diagonal is not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(N,1)."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I'; otherwise, WORK is not",
       "         referenced."]}},
 "cgesdd"=>
  {"summary"=>
    ["CGESDD computes the singular value decomposition (SVD) of a complex",
     "M-by-N matrix A, optionally computing the left and/or right singular",
     "vectors, by using divide-and-conquer method. The SVD is written",
     "     A = U * SIGMA * conjugate-transpose(V)",
     "where SIGMA is an M-by-N matrix which is zero except for its",
     "min(m,n) diagonal elements, U is an M-by-M unitary matrix, and",
     "V is an N-by-N unitary matrix.  The diagonal elements of SIGMA",
     "are the singular values of A; they are real and non-negative, and",
     "are returned in descending order.  The first min(m,n) columns of",
     "U and V are the left and right singular vectors of A.",
     "Note that the routine returns VT = V**H, not V.",
     "The divide and conquer algorithm makes very mild assumptions about",
     "floating point arithmetic. It will work on machines with a guard",
     "digit in add/subtract, or on those binary machines without guard",
     "digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or",
     "Cray-2. It could conceivably fail on hexadecimal or decimal machines",
     "without guard digits, but we know of none."],
   "param"=>
    {"JOBZ"=>
      ["[in]",
       "         JOBZ is CHARACTER*1",
       "         Specifies options for computing all or part of the matrix U:",
       "         = 'A':  all M columns of U and all N rows of V**H are",
       "                 returned in the arrays U and VT;",
       "         = 'S':  the first min(M,N) columns of U and the first",
       "                 min(M,N) rows of V**H are returned in the arrays U",
       "                 and VT;",
       "         = 'O':  If M >= N, the first N columns of U are overwritten",
       "                 in the array A and all rows of V**H are returned in",
       "                 the array VT;",
       "                 otherwise, all columns of U are returned in the",
       "                 array U and the first M rows of V**H are overwritten",
       "                 in the array A;",
       "         = 'N':  no columns of U or rows of V**H are computed."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the input matrix A.  M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the input matrix A.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the M-by-N matrix A.",
       "         On exit,",
       "         if JOBZ = 'O',  A is overwritten with the first N columns",
       "                         of U (the left singular vectors, stored",
       "                         columnwise) if M >= N;",
       "                         A is overwritten with the first M rows",
       "                         of V**H (the right singular vectors, stored",
       "                         rowwise) otherwise.",
       "         if JOBZ .ne. 'O', the contents of A are destroyed."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,M)."],
     "S"=>
      ["[out]",
       "         S is REAL array, dimension (min(M,N))",
       "         The singular values of A, sorted so that S(i) >= S(i+1)."],
     "U"=>
      ["[out]",
       "         U is COMPLEX array, dimension (LDU,UCOL)",
       "         UCOL = M if JOBZ = 'A' or JOBZ = 'O' and M < N;",
       "         UCOL = min(M,N) if JOBZ = 'S'.",
       "         If JOBZ = 'A' or JOBZ = 'O' and M < N, U contains the M-by-M",
       "         unitary matrix U;",
       "         if JOBZ = 'S', U contains the first min(M,N) columns of U",
       "         (the left singular vectors, stored columnwise);",
       "         if JOBZ = 'O' and M >= N, or JOBZ = 'N', U is not referenced."],
     "LDU"=>
      ["[in]",
       "         LDU is INTEGER",
       "         The leading dimension of the array U.  LDU >= 1;",
       "         if JOBZ = 'S' or 'A' or JOBZ = 'O' and M < N, LDU >= M."],
     "VT"=>
      ["[out]",
       "         VT is COMPLEX array, dimension (LDVT,N)",
       "         If JOBZ = 'A' or JOBZ = 'O' and M >= N, VT contains the",
       "         N-by-N unitary matrix V**H;",
       "         if JOBZ = 'S', VT contains the first min(M,N) rows of",
       "         V**H (the right singular vectors, stored rowwise);",
       "         if JOBZ = 'O' and M < N, or JOBZ = 'N', VT is not referenced."],
     "LDVT"=>
      ["[in]",
       "         LDVT is INTEGER",
       "         The leading dimension of the array VT.  LDVT >= 1;",
       "         if JOBZ = 'A' or JOBZ = 'O' and M >= N, LDVT >= N;",
       "         if JOBZ = 'S', LDVT >= min(M,N)."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= 1.",
       "         If LWORK = -1, a workspace query is assumed.  The optimal",
       "         size for the WORK array is calculated and stored in WORK(1),",
       "         and no other work except argument checking is performed.",
       "         Let mx = max(M,N) and mn = min(M,N).",
       "         If JOBZ = 'N', LWORK >= 2*mn + mx.",
       "         If JOBZ = 'O', LWORK >= 2*mn*mn + 2*mn + mx.",
       "         If JOBZ = 'S', LWORK >=   mn*mn + 3*mn.",
       "         If JOBZ = 'A', LWORK >=   mn*mn + 2*mn + mx.",
       "         These are not tight minimums in all cases; see comments inside code.",
       "         For good performance, LWORK should generally be larger;",
       "         a query is recommended."],
     "RWORK"=>
      ["[out]",
       "         RWORK is REAL array, dimension (MAX(1,LRWORK))",
       "         Let mx = max(M,N) and mn = min(M,N).",
       "         If JOBZ = 'N',    LRWORK >= 5*mn (LAPACK <= 3.6 needs 7*mn);",
       "         else if mx >> mn, LRWORK >= 5*mn*mn + 5*mn;",
       "         else              LRWORK >= max( 5*mn*mn + 5*mn,",
       "                                          2*mx*mn + 2*mn*mn + mn )."],
     "IWORK"=>
      ["[out]", "         IWORK is INTEGER array, dimension (8*min(M,N))"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit.",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value.",
       "         > 0:  The updating process of SBDSDC did not converge."]}},
 "ctplqt"=>
  {"summary"=>
    ["CTPLQT computes a blocked LQ factorization of a complex",
     "\"triangular-pentagonal\" matrix C, which is composed of a",
     "triangular block A and pentagonal block B, using the compact",
     "WY representation for Q."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix B, and the order of the",
       "         triangular matrix A.",
       "         M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix B.",
       "         N >= 0."],
     "L"=>
      ["[in]",
       "         L is INTEGER",
       "         The number of rows of the lower trapezoidal part of B.",
       "         MIN(M,N) >= L >= 0.  See Further Details."],
     "MB"=>
      ["[in]",
       "         MB is INTEGER",
       "         The block size to be used in the blocked QR.  M >= MB >= 1."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the lower triangular N-by-N matrix A.",
       "         On exit, the elements on and below the diagonal of the array",
       "         contain the lower triangular matrix L."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is COMPLEX array, dimension (LDB,N)",
       "         On entry, the pentagonal M-by-N matrix B.  The first N-L columns",
       "         are rectangular, and the last L columns are lower trapezoidal.",
       "         On exit, B contains the pentagonal matrix V.  See Further Details."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,M)."],
     "T"=>
      ["[out]",
       "         T is COMPLEX array, dimension (LDT,N)",
       "         The lower triangular block reflectors stored in compact form",
       "         as a sequence of upper triangular blocks.  See Further Details."],
     "LDT"=>
      ["[in]",
       "         LDT is INTEGER",
       "         The leading dimension of the array T.  LDT >= MB."],
     "WORK"=>["[out]", "         WORK is COMPLEX array, dimension (MB*M)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "cunglq"=>
  {"summary"=>
    ["CUNGLQ generates an M-by-N complex matrix Q with orthonormal rows,",
     "which is defined as the first M rows of a product of K elementary",
     "reflectors of order N",
     "      Q  =  H(k)**H . . . H(2)**H H(1)**H",
     "as returned by CGELQF."],
   "param"=>
    {"M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix Q. M >= 0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix Q. N >= M."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines the",
       "         matrix Q. M >= K >= 0."],
     "A"=>
      ["[in,out]",
       "         A is COMPLEX array, dimension (LDA,N)",
       "         On entry, the i-th row must contain the vector which defines",
       "         the elementary reflector H(i), for i = 1,2,...,k, as returned",
       "         by CGELQF in the first k rows of its array argument A.",
       "         On exit, the M-by-N matrix Q."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The first dimension of the array A. LDA >= max(1,M)."],
     "TAU"=>
      ["[in]",
       "         TAU is COMPLEX array, dimension (K)",
       "         TAU(i) must contain the scalar factor of the elementary",
       "         reflector H(i), as returned by CGELQF."],
     "WORK"=>
      ["[out]",
       "         WORK is COMPLEX array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK. LWORK >= max(1,M).",
       "         For optimum performance LWORK >= M*NB, where NB is",
       "         the optimal blocksize.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "         this value as the first entry of the WORK array, and no error",
       "         message related to LWORK is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit;",
       "         < 0:  if INFO = -i, the i-th argument has an illegal value"]}},
 "zgemlq"=>
  {"summary"=>
    ["    ZGEMLQ overwrites the general real M-by-N matrix C with",
     "                     SIDE = 'L'     SIDE = 'R'",
     "     TRANS = 'N':      Q * C          C * Q",
     "     TRANS = 'C':      Q**H * C       C * Q**H",
     "     where Q is a complex unitary matrix defined as the product",
     "     of blocked elementary reflectors computed by short wide",
     "     LQ factorization (ZGELQ)"],
   "param"=>
    {"SIDE"=>
      ["[in]",
       "         SIDE is CHARACTER*1",
       "         = 'L': apply Q or Q**T from the Left;",
       "         = 'R': apply Q or Q**T from the Right."],
     "TRANS"=>
      ["[in]",
       "         TRANS is CHARACTER*1",
       "         = 'N':  No transpose, apply Q;",
       "         = 'T':  Transpose, apply Q**T."],
     "M"=>
      ["[in]",
       "         M is INTEGER",
       "         The number of rows of the matrix A.  M >=0."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The number of columns of the matrix C. N >= 0."],
     "K"=>
      ["[in]",
       "         K is INTEGER",
       "         The number of elementary reflectors whose product defines",
       "         the matrix Q.",
       "         If SIDE = 'L', M >= K >= 0;",
       "         if SIDE = 'R', N >= K >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension",
       "                              (LDA,M) if SIDE = 'L',",
       "                              (LDA,N) if SIDE = 'R'",
       "         Part of the data structure to represent Q as returned by ZGELQ."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A. LDA >= max(1,K)."],
     "T"=>
      ["[in]",
       "         T is COMPLEX*16 array, dimension (MAX(5,TSIZE)).",
       "         Part of the data structure to represent Q as returned by ZGELQ."],
     "TSIZE"=>
      ["[in]",
       "         TSIZE is INTEGER",
       "         The dimension of the array T. TSIZE >= 5."],
     "C"=>
      ["[in,out]",
       "         C is COMPLEX*16 array, dimension (LDC,N)",
       "         On entry, the M-by-N matrix C.",
       "         On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q."],
     "LDC"=>
      ["[in]",
       "         LDC is INTEGER",
       "         The leading dimension of the array C. LDC >= max(1,M)."],
     "WORK"=>
      ["[out]",
       "        (workspace) COMPLEX*16 array, dimension (MAX(1,LWORK))"],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If LWORK = -1, then a workspace query is assumed. The routine",
       "         only calculates the size of the WORK array, returns this",
       "         value as WORK(1), and no error message related to WORK ",
       "         is issued by XERBLA."],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "zsyrfs"=>
  {"summary"=>
    ["ZSYRFS improves the computed solution to a system of linear",
     "equations when the coefficient matrix is symmetric indefinite, and",
     "provides error bounds and backward error estimates for the solution."],
   "param"=>
    {"UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         = 'U':  Upper triangle of A is stored;",
       "         = 'L':  Lower triangle of A is stored."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0."],
     "NRHS"=>
      ["[in]",
       "         NRHS is INTEGER",
       "         The number of right hand sides, i.e., the number of columns",
       "         of the matrices B and X.  NRHS >= 0."],
     "A"=>
      ["[in]",
       "         A is COMPLEX*16 array, dimension (LDA,N)",
       "         The symmetric matrix A.  If UPLO = 'U', the leading N-by-N",
       "         upper triangular part of A contains the upper triangular part",
       "         of the matrix A, and the strictly lower triangular part of A",
       "         is not referenced.  If UPLO = 'L', the leading N-by-N lower",
       "         triangular part of A contains the lower triangular part of",
       "         the matrix A, and the strictly upper triangular part of A is",
       "         not referenced."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of the array A.  LDA >= max(1,N)."],
     "AF"=>
      ["[in]",
       "         AF is COMPLEX*16 array, dimension (LDAF,N)",
       "         The factored form of the matrix A.  AF contains the block",
       "         diagonal matrix D and the multipliers used to obtain the",
       "         factor U or L from the factorization A = U*D*U**T or",
       "         A = L*D*L**T as computed by ZSYTRF."],
     "LDAF"=>
      ["[in]",
       "         LDAF is INTEGER",
       "         The leading dimension of the array AF.  LDAF >= max(1,N)."],
     "IPIV"=>
      ["[in]",
       "         IPIV is INTEGER array, dimension (N)",
       "         Details of the interchanges and the block structure of D",
       "         as determined by ZSYTRF."],
     "B"=>
      ["[in]",
       "         B is COMPLEX*16 array, dimension (LDB,NRHS)",
       "         The right hand side matrix B."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of the array B.  LDB >= max(1,N)."],
     "X"=>
      ["[in,out]",
       "         X is COMPLEX*16 array, dimension (LDX,NRHS)",
       "         On entry, the solution matrix X, as computed by ZSYTRS.",
       "         On exit, the improved solution matrix X."],
     "LDX"=>
      ["[in]",
       "         LDX is INTEGER",
       "         The leading dimension of the array X.  LDX >= max(1,N)."],
     "FERR"=>
      ["[out]",
       "         FERR is DOUBLE PRECISION array, dimension (NRHS)",
       "         The estimated forward error bound for each solution vector",
       "         X(j) (the j-th column of the solution matrix X).",
       "         If XTRUE is the true solution corresponding to X(j), FERR(j)",
       "         is an estimated upper bound for the magnitude of the largest",
       "         element in (X(j) - XTRUE) divided by the magnitude of the",
       "         largest element in X(j).  The estimate is as reliable as",
       "         the estimate for RCOND, and is almost always a slight",
       "         overestimate of the true error."],
     "BERR"=>
      ["[out]",
       "         BERR is DOUBLE PRECISION array, dimension (NRHS)",
       "         The componentwise relative backward error of each solution",
       "         vector X(j) (i.e., the smallest relative change in",
       "         any element of A or B that makes X(j) an exact solution)."],
     "WORK"=>["[out]", "         WORK is COMPLEX*16 array, dimension (2*N)"],
     "RWORK"=>
      ["[out]", "         RWORK is DOUBLE PRECISION array, dimension (N)"],
     "INFO"=>
      ["[out]",
       "         INFO is INTEGER",
       "         = 0:  successful exit",
       "         < 0:  if INFO = -i, the i-th argument had an illegal value"]}},
 "slantp"=>
  {"summary"=>
    ["SLANTP  returns the value of the one norm,  or the Frobenius norm, or",
     "the  infinity norm,  or the  element of  largest absolute value  of a",
     "triangular matrix A, supplied in packed form.",
     "   SLANTP = ( max(abs(A(i,j))), NORM = 'M' or 'm'",
     "            (",
     "            ( norm1(A),         NORM = '1', 'O' or 'o'",
     "            (",
     "            ( normI(A),         NORM = 'I' or 'i'",
     "            (",
     "            ( normF(A),         NORM = 'F', 'f', 'E' or 'e'",
     "where  norm1  denotes the  one norm of a matrix (maximum column sum),",
     "normI  denotes the  infinity norm  of a matrix  (maximum row sum) and",
     "normF  denotes the  Frobenius norm of a matrix (square root of sum of",
     "squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix norm."],
   "param"=>
    {"NORM"=>
      ["[in]",
       "         NORM is CHARACTER*1",
       "         Specifies the value to be returned in SLANTP as described",
       "         above."],
     "UPLO"=>
      ["[in]",
       "         UPLO is CHARACTER*1",
       "         Specifies whether the matrix A is upper or lower triangular.",
       "         = 'U':  Upper triangular",
       "         = 'L':  Lower triangular"],
     "DIAG"=>
      ["[in]",
       "         DIAG is CHARACTER*1",
       "         Specifies whether or not the matrix A is unit triangular.",
       "         = 'N':  Non-unit triangular",
       "         = 'U':  Unit triangular"],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrix A.  N >= 0.  When N = 0, SLANTP is",
       "         set to zero."],
     "AP"=>
      ["[in]",
       "         AP is REAL array, dimension (N*(N+1)/2)",
       "         The upper or lower triangular matrix A, packed columnwise in",
       "         a linear array.  The j-th column of A is stored in the array",
       "         AP as follows:",
       "         if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;",
       "         if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.",
       "         Note that when DIAG = 'U', the elements of the array AP",
       "         corresponding to the diagonal elements of the matrix A are",
       "         not referenced, but are assumed to be one."],
     "WORK"=>
      ["[out]",
       "         WORK is REAL array, dimension (MAX(1,LWORK)),",
       "         where LWORK >= N when NORM = 'I'; otherwise, WORK is not",
       "         referenced."]}},
 "dgges"=>
  {"summary"=>
    ["DGGES computes for a pair of N-by-N real nonsymmetric matrices (A,B),",
     "the generalized eigenvalues, the generalized real Schur form (S,T),",
     "optionally, the left and/or right matrices of Schur vectors (VSL and",
     "VSR). This gives the generalized Schur factorization",
     "         (A,B) = ( (VSL)*S*(VSR)**T, (VSL)*T*(VSR)**T )",
     "Optionally, it also orders the eigenvalues so that a selected cluster",
     "of eigenvalues appears in the leading diagonal blocks of the upper",
     "quasi-triangular matrix S and the upper triangular matrix T.The",
     "leading columns of VSL and VSR then form an orthonormal basis for the",
     "corresponding left and right eigenspaces (deflating subspaces).",
     "(If only the generalized eigenvalues are needed, use the driver",
     "DGGEV instead, which is faster.)",
     "A generalized eigenvalue for a pair of matrices (A,B) is a scalar w",
     "or a ratio alpha/beta = w, such that  A - w*B is singular.  It is",
     "usually represented as the pair (alpha,beta), as there is a",
     "reasonable interpretation for beta=0 or both being zero.",
     "A pair of matrices (S,T) is in generalized real Schur form if T is",
     "upper triangular with non-negative diagonal and S is block upper",
     "triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond",
     "to real generalized eigenvalues, while 2-by-2 blocks of S will be",
     "\"standardized\" by making the corresponding elements of T have the",
     "form:",
     "        [  a  0  ]",
     "        [  0  b  ]",
     "and the pair of corresponding 2-by-2 blocks in S and T will have a",
     "complex conjugate pair of generalized eigenvalues."],
   "param"=>
    {"JOBVSL"=>
      ["[in]",
       "         JOBVSL is CHARACTER*1",
       "         = 'N':  do not compute the left Schur vectors;",
       "         = 'V':  compute the left Schur vectors."],
     "JOBVSR"=>
      ["[in]",
       "         JOBVSR is CHARACTER*1",
       "         = 'N':  do not compute the right Schur vectors;",
       "         = 'V':  compute the right Schur vectors."],
     "SORT"=>
      ["[in]",
       "         SORT is CHARACTER*1",
       "         Specifies whether or not to order the eigenvalues on the",
       "         diagonal of the generalized Schur form.",
       "         = 'N':  Eigenvalues are not ordered;",
       "         = 'S':  Eigenvalues are ordered (see SELCTG);"],
     "SELCTG"=>
      ["[in]",
       "         SELCTG is a LOGICAL FUNCTION of three DOUBLE PRECISION arguments",
       "         SELCTG must be declared EXTERNAL in the calling subroutine.",
       "         If SORT = 'N', SELCTG is not referenced.",
       "         If SORT = 'S', SELCTG is used to select eigenvalues to sort",
       "         to the top left of the Schur form.",
       "         An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if",
       "         SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either",
       "         one of a complex conjugate pair of eigenvalues is selected,",
       "         then both complex eigenvalues are selected.",
       "         Note that in the ill-conditioned case, a selected complex",
       "         eigenvalue may no longer satisfy SELCTG(ALPHAR(j),ALPHAI(j),",
       "         BETA(j)) = .TRUE. after ordering. INFO is to be set to N+2",
       "         in this case."],
     "N"=>
      ["[in]",
       "         N is INTEGER",
       "         The order of the matrices A, B, VSL, and VSR.  N >= 0."],
     "A"=>
      ["[in,out]",
       "         A is DOUBLE PRECISION array, dimension (LDA, N)",
       "         On entry, the first of the pair of matrices.",
       "         On exit, A has been overwritten by its generalized Schur",
       "         form S."],
     "LDA"=>
      ["[in]",
       "         LDA is INTEGER",
       "         The leading dimension of A.  LDA >= max(1,N)."],
     "B"=>
      ["[in,out]",
       "         B is DOUBLE PRECISION array, dimension (LDB, N)",
       "         On entry, the second of the pair of matrices.",
       "         On exit, B has been overwritten by its generalized Schur",
       "         form T."],
     "LDB"=>
      ["[in]",
       "         LDB is INTEGER",
       "         The leading dimension of B.  LDB >= max(1,N)."],
     "SDIM"=>
      ["[out]",
       "         SDIM is INTEGER",
       "         If SORT = 'N', SDIM = 0.",
       "         If SORT = 'S', SDIM = number of eigenvalues (after sorting)",
       "         for which SELCTG is true.  (Complex conjugate pairs for which",
       "         SELCTG is true for either eigenvalue count as 2.)"],
     "ALPHAR"=>
      ["[out]", "         ALPHAR is DOUBLE PRECISION array, dimension (N)"],
     "ALPHAI"=>
      ["[out]", "         ALPHAI is DOUBLE PRECISION array, dimension (N)"],
     "BETA"=>
      ["[out]",
       "         BETA is DOUBLE PRECISION array, dimension (N)",
       "         On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will",
       "         be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,",
       "         and  BETA(j),j=1,...,N are the diagonals of the complex Schur",
       "         form (S,T) that would result if the 2-by-2 diagonal blocks of",
       "         the real Schur form of (A,B) were further reduced to",
       "         triangular form using 2-by-2 complex unitary transformations.",
       "         If ALPHAI(j) is zero, then the j-th eigenvalue is real; if",
       "         positive, then the j-th and (j+1)-st eigenvalues are a",
       "         complex conjugate pair, with ALPHAI(j+1) negative.",
       "         Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)",
       "         may easily over- or underflow, and BETA(j) may even be zero.",
       "         Thus, the user should avoid naively computing the ratio.",
       "         However, ALPHAR and ALPHAI will be always less than and",
       "         usually comparable with norm(A) in magnitude, and BETA always",
       "         less than and usually comparable with norm(B)."],
     "VSL"=>
      ["[out]",
       "         VSL is DOUBLE PRECISION array, dimension (LDVSL,N)",
       "         If JOBVSL = 'V', VSL will contain the left Schur vectors.",
       "         Not referenced if JOBVSL = 'N'."],
     "LDVSL"=>
      ["[in]",
       "         LDVSL is INTEGER",
       "         The leading dimension of the matrix VSL. LDVSL >=1, and",
       "         if JOBVSL = 'V', LDVSL >= N."],
     "VSR"=>
      ["[out]",
       "         VSR is DOUBLE PRECISION array, dimension (LDVSR,N)",
       "         If JOBVSR = 'V', VSR will contain the right Schur vectors.",
       "         Not referenced if JOBVSR = 'N'."],
     "LDVSR"=>
      ["[in]",
       "         LDVSR is INTEGER",
       "         The leading dimension of the matrix VSR. LDVSR >= 1, and",
       "         if JOBVSR = 'V', LDVSR >= N."],
     "WORK"=>
      ["[out]",
       "         WORK is DOUBLE PRECISION array, dimension (MAX(1,LWORK))",
       "         On exit, if INFO = 0, WORK(1) returns the optimal LWORK."],
     "LWORK"=>
      ["[in]",
       "         LWORK is INTEGER",
       "         The dimension of the array WORK.",
       "         If N = 0, LWORK >= 1, else LWORK >= 8*N+16.",
       "         For good performance , LWORK must generally be larger.",
       "         If LWORK = -1, then a workspace query is assumed; the routine",
       "         only calculates the optimal size of the WORK array, returns",
       "        