[{:func_name=>"gsl_cdf_gaussian_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_gaussian_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_gaussian_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_gaussian_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_ugaussian_P",
  :func_type=>"double",
  :args=>[["double", "x"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_ugaussian_Q",
  :func_type=>"double",
  :args=>[["double", "x"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_ugaussian_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_ugaussian_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_exponential_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_exponential_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_exponential_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_exponential_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_laplace_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_laplace_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_laplace_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_laplace_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_exppow_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) for the exponential power distribution with\n" +
   "parameters a and b."},
 {:func_name=>"gsl_cdf_exppow_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) for the exponential power distribution with\n" +
   "parameters a and b."},
 {:func_name=>"gsl_cdf_cauchy_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_cauchy_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_cauchy_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_cauchy_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_rayleigh_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_rayleigh_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_rayleigh_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_rayleigh_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_gamma_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gamma_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gamma_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gamma_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_flat_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_flat_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_flat_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_flat_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_lognormal_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_lognormal_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_lognormal_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_lognormal_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_chisq_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_chisq_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_chisq_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_chisq_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_beta_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_beta_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_beta_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_beta_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_logistic_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_logistic_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_logistic_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_logistic_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_pareto_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_pareto_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_pareto_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_pareto_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_weibull_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_weibull_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_weibull_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_weibull_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_gumbel1_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel1_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel1_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel1_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_poisson_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Poisson distribution with parameter\n" +
   "mu."},
 {:func_name=>"gsl_cdf_poisson_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Poisson distribution with parameter\n" +
   "mu."},
 {:func_name=>"gsl_cdf_binomial_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k)  for the binomial\n" +
   "distribution with parameters p and n."},
 {:func_name=>"gsl_cdf_binomial_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k)  for the binomial\n" +
   "distribution with parameters p and n."},
 {:func_name=>"gsl_cdf_negative_binomial_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["double", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the negative binomial distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_cdf_negative_binomial_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["double", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the negative binomial distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_cdf_pascal_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Pascal distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_cdf_pascal_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Pascal distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_cdf_geometric_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the geometric distribution with parameter\n" +
   "p."},
 {:func_name=>"gsl_cdf_geometric_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the geometric distribution with parameter\n" +
   "p."},
 {:func_name=>"gsl_cdf_hypergeometric_P",
  :func_type=>"double",
  :args=>
   [["unsigned int", "k"],
    ["unsigned int", "n1"],
    ["unsigned int", "n2"],
    ["unsigned int", "t"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the hypergeometric distribution with\n" +
   "parameters n1, n2 and t."},
 {:func_name=>"gsl_cdf_hypergeometric_Q",
  :func_type=>"double",
  :args=>
   [["unsigned int", "k"],
    ["unsigned int", "n1"],
    ["unsigned int", "n2"],
    ["unsigned int", "t"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the hypergeometric distribution with\n" +
   "parameters n1, n2 and t."}]
