import sys

if sys.platform == "darwin":
    from collections.abc import Callable
    from typing import Final, TypeVar
    from typing_extensions import ParamSpec

    from psutil._common import (
        AccessDenied as AccessDenied,
        NoSuchProcess as NoSuchProcess,
        ZombieProcess as ZombieProcess,
        conn_tmap as conn_tmap,
        conn_to_ntuple as conn_to_ntuple,
        debug as debug,
        isfile_strict as isfile_strict,
        memoize_when_activated as memoize_when_activated,
        parse_environ_block as parse_environ_block,
        usage_percent as usage_percent,
    )

    from . import _ntuples as ntp, _psposix, _psutil_osx

    _P = ParamSpec("_P")
    _R = TypeVar("_R")

    __extra__all__: Final[list[str]]
    PAGESIZE: Final[int]
    AF_LINK: Final[int]
    TCP_STATUSES: Final[dict[int, str]]
    PROC_STATUSES: Final[dict[int, str]]
    kinfo_proc_map: Final[dict[str, int]]
    pidtaskinfo_map: Final[dict[str, int]]

    def virtual_memory() -> ntp.svmem: ...
    def swap_memory() -> ntp.sswap: ...
    heap_info = _psutil_osx.heap_info
    heap_trim = _psutil_osx.heap_trim
    def cpu_times() -> ntp.scputimes: ...
    def per_cpu_times() -> list[ntp.scputimes]: ...
    def cpu_count_logical() -> int | None: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_stats() -> ntp.scpustats: ...
    def cpu_freq() -> list[ntp.scpufreq]: ...

    disk_usage = _psposix.disk_usage
    disk_io_counters = _psutil_osx.disk_io_counters
    def disk_partitions(all: bool = False) -> list[ntp.sdiskpart]: ...
    def sensors_battery() -> ntp.sbattery | None: ...

    net_io_counters = _psutil_osx.net_io_counters
    net_if_addrs = _psutil_osx.net_if_addrs
    def net_connections(kind: str = "inet") -> list[ntp.sconn]: ...
    def net_if_stats() -> dict[str, ntp.snicstats]: ...
    def boot_time() -> float: ...
    INIT_BOOT_TIME: float
    def adjust_proc_create_time(ctime: float) -> float: ...
    def users() -> list[ntp.suser]: ...
    def pids() -> list[int]: ...
    pid_exists = _psposix.pid_exists
    def wrap_exceptions(fun: Callable[_P, _R]) -> Callable[_P, _R]: ...

    class Process:
        __slots__ = ["_cache", "_name", "_ppid", "pid"]
        pid: int
        def __init__(self, pid: int) -> None: ...
        def oneshot_enter(self) -> None: ...
        def oneshot_exit(self) -> None: ...
        def name(self) -> str: ...
        def exe(self) -> str: ...
        def cmdline(self) -> list[str]: ...
        def environ(self) -> dict[str, str]: ...
        def ppid(self) -> int: ...
        def cwd(self) -> str: ...
        def uids(self) -> ntp.puids: ...
        def gids(self) -> ntp.puids: ...
        def terminal(self) -> str | None: ...
        def memory_info(self) -> ntp.pmem: ...
        def memory_full_info(self) -> ntp.pfullmem: ...
        def cpu_times(self) -> ntp.pcputimes: ...
        def create_time(self, monotonic: bool = False) -> float: ...
        def num_ctx_switches(self) -> ntp.pctxsw: ...
        def num_threads(self) -> int: ...
        def open_files(self) -> list[ntp.popenfile]: ...
        def net_connections(self, kind: str = "inet") -> list[ntp.pconn]: ...
        def num_fds(self) -> int: ...
        def wait(self, timeout: float | None = None) -> int | None: ...
        def nice_get(self) -> int: ...
        def nice_set(self, value: int) -> None: ...
        def status(self) -> str: ...
        def threads(self) -> list[ntp.pthread]: ...
