-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
-- pgRouting extension upgrade from 3.0.0 to 4.0.0
-- generated by tools/build-extension-update-file
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

\echo Use "ALTER extension pgrouting update to '4.0.0'" to load this file. \quit

-------------------------------------
-- remove functions no longer in the 4.0.0 extension
-------------------------------------
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_alphashape(text,double precision);
DROP FUNCTION IF EXISTS _pgr_alphashape(text,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_checkverttab(text,text[],integer,text);
DROP FUNCTION IF EXISTS _pgr_checkverttab(text,text[],integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_createindex(text,text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_createindex(text,text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_createindex(text,text,text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_createindex(text,text,text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_dagshortestpath(text,anyarray,anyarray,boolean,boolean);
DROP FUNCTION IF EXISTS _pgr_dagshortestpath(text,anyarray,anyarray,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_dijkstra(text,anyarray,anyarray,boolean,boolean,boolean,bigint);
DROP FUNCTION IF EXISTS _pgr_dijkstra(text,anyarray,anyarray,boolean,boolean,boolean,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_dijkstranear(text,anyarray,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS _pgr_dijkstranear(text,anyarray,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_dijkstranear(text,anyarray,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS _pgr_dijkstranear(text,anyarray,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_dijkstranear(text,bigint,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS _pgr_dijkstranear(text,bigint,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_drivingdistance(text,anyarray,double precision,boolean,boolean);
DROP FUNCTION IF EXISTS _pgr_drivingdistance(text,anyarray,double precision,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_endpoint(geometry);
DROP FUNCTION IF EXISTS _pgr_endpoint(geometry);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_getcolumnname(text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_getcolumnname(text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_getcolumnname(text,text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_getcolumnname(text,text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_getcolumntype(text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_getcolumntype(text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_getcolumntype(text,text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_getcolumntype(text,text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_gettablename(text,integer,text);
DROP FUNCTION IF EXISTS _pgr_gettablename(text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_iscolumnindexed(text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_iscolumnindexed(text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_iscolumnindexed(text,text,text,integer,text);
DROP FUNCTION IF EXISTS _pgr_iscolumnindexed(text,text,text,integer,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_iscolumnintable(text,text);
DROP FUNCTION IF EXISTS _pgr_iscolumnintable(text,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_kruskal(text,anyarray,text,bigint,double precision);
DROP FUNCTION IF EXISTS _pgr_kruskal(text,anyarray,text,bigint,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_ksp(text,bigint,bigint,integer,boolean,boolean);
DROP FUNCTION IF EXISTS _pgr_ksp(text,bigint,bigint,integer,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_maxcardinalitymatch(text,boolean);
DROP FUNCTION IF EXISTS _pgr_maxcardinalitymatch(text,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_msg(integer,text,text);
DROP FUNCTION IF EXISTS _pgr_msg(integer,text,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_onerror(boolean,integer,text,text,text,text);
DROP FUNCTION IF EXISTS _pgr_onerror(boolean,integer,text,text,text,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_pointtoid(geometry,double precision,text,integer);
DROP FUNCTION IF EXISTS _pgr_pointtoid(geometry,double precision,text,integer);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_prim(text,anyarray,text,bigint,double precision);
DROP FUNCTION IF EXISTS _pgr_prim(text,anyarray,text,bigint,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_quote_ident(text);
DROP FUNCTION IF EXISTS _pgr_quote_ident(text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_startpoint(geometry);
DROP FUNCTION IF EXISTS _pgr_startpoint(geometry);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_trsp(text,integer,double precision,integer,double precision,boolean,boolean,text);
DROP FUNCTION IF EXISTS _pgr_trsp(text,integer,double precision,integer,double precision,boolean,boolean,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_trsp(text,text,anyarray,anyarray,boolean);
DROP FUNCTION IF EXISTS _pgr_trsp(text,text,anyarray,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_trsp(text,text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS _pgr_trsp(text,text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_trsp(text,text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS _pgr_trsp(text,text,bigint,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_trsp(text,text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS _pgr_trsp(text,text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_trspviavertices(text,integer[],boolean,boolean,text);
DROP FUNCTION IF EXISTS _pgr_trspviavertices(text,integer[],boolean,boolean,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_tsp(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
DROP FUNCTION IF EXISTS _pgr_tsp(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_tspeuclidean(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
DROP FUNCTION IF EXISTS _pgr_tspeuclidean(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_turnrestrictedpath(text,text,bigint,bigint,integer,boolean,boolean,boolean,boolean);
DROP FUNCTION IF EXISTS _pgr_turnrestrictedpath(text,text,bigint,bigint,integer,boolean,boolean,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_versionless(text,text);
DROP FUNCTION IF EXISTS _pgr_versionless(text,text);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_withpointsdd(text,text,anyarray,double precision,boolean,character,boolean,boolean);
DROP FUNCTION IF EXISTS _pgr_withpointsdd(text,text,anyarray,double precision,boolean,character,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_withpointsksp(text,text,bigint,bigint,integer,boolean,boolean,character,boolean);
DROP FUNCTION IF EXISTS _pgr_withpointsksp(text,text,bigint,bigint,integer,boolean,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_withpointsvia(text,bigint[],double precision[],boolean);
DROP FUNCTION IF EXISTS _pgr_withpointsvia(text,bigint[],double precision[],boolean);
ALTER EXTENSION pgrouting DROP FUNCTION _trsp(text,text,anyarray,anyarray,boolean);
DROP FUNCTION IF EXISTS _trsp(text,text,anyarray,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_alphashape(geometry,double precision);
DROP FUNCTION IF EXISTS pgr_alphashape(geometry,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_analyzegraph(text,double precision,text,text,text,text,text);
DROP FUNCTION IF EXISTS pgr_analyzegraph(text,double precision,text,text,text,text,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_analyzeoneway(text,text[],text[],text[],text[],boolean,text,text,text);
DROP FUNCTION IF EXISTS pgr_analyzeoneway(text,text[],text[],text[],text[],boolean,text,text,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_breadthfirstsearch(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_breadthfirstsearch(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_breadthfirstsearch(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_breadthfirstsearch(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_contraction(text,bigint[],integer,bigint[],boolean);
DROP FUNCTION IF EXISTS pgr_contraction(text,bigint[],integer,bigint[],boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_createtopology(text,double precision,text,text,text,text,text,boolean);
DROP FUNCTION IF EXISTS pgr_createtopology(text,double precision,text,text,text,text,text,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_createverticestable(text,text,text,text,text);
DROP FUNCTION IF EXISTS pgr_createverticestable(text,text,text,text,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_maxcardinalitymatch(text,boolean);
DROP FUNCTION IF EXISTS pgr_maxcardinalitymatch(text,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_nodenetwork(text,double precision,text,text,text,text,boolean);
DROP FUNCTION IF EXISTS pgr_nodenetwork(text,double precision,text,text,text,text,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_trsp(text,integer,double precision,integer,double precision,boolean,boolean,text);
DROP FUNCTION IF EXISTS pgr_trsp(text,integer,double precision,integer,double precision,boolean,boolean,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_trsp(text,integer,integer,boolean,boolean,text);
DROP FUNCTION IF EXISTS pgr_trsp(text,integer,integer,boolean,boolean,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_trspviaedges(text,integer[],double precision[],boolean,boolean,text);
DROP FUNCTION IF EXISTS pgr_trspviaedges(text,integer[],double precision[],boolean,boolean,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_trspviavertices(text,anyarray,boolean,boolean,text);
DROP FUNCTION IF EXISTS pgr_trspviavertices(text,anyarray,boolean,boolean,text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_tsp(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
DROP FUNCTION IF EXISTS pgr_tsp(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_tspeuclidean(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
DROP FUNCTION IF EXISTS pgr_tspeuclidean(text,bigint,bigint,double precision,integer,integer,integer,double precision,double precision,double precision,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpoints(text,text,anyarray,anyarray,boolean,character,boolean);
DROP FUNCTION IF EXISTS pgr_withpoints(text,text,anyarray,anyarray,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpoints(text,text,anyarray,bigint,boolean,character,boolean);
DROP FUNCTION IF EXISTS pgr_withpoints(text,text,anyarray,bigint,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpoints(text,text,bigint,anyarray,boolean,character,boolean);
DROP FUNCTION IF EXISTS pgr_withpoints(text,text,bigint,anyarray,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpoints(text,text,bigint,bigint,boolean,character,boolean);
DROP FUNCTION IF EXISTS pgr_withpoints(text,text,bigint,bigint,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointscost(text,text,anyarray,anyarray,boolean,character);
DROP FUNCTION IF EXISTS pgr_withpointscost(text,text,anyarray,anyarray,boolean,character);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointscost(text,text,anyarray,bigint,boolean,character);
DROP FUNCTION IF EXISTS pgr_withpointscost(text,text,anyarray,bigint,boolean,character);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointscost(text,text,bigint,anyarray,boolean,character);
DROP FUNCTION IF EXISTS pgr_withpointscost(text,text,bigint,anyarray,boolean,character);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointscost(text,text,bigint,bigint,boolean,character);
DROP FUNCTION IF EXISTS pgr_withpointscost(text,text,bigint,bigint,boolean,character);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointscostmatrix(text,text,anyarray,boolean,character);
DROP FUNCTION IF EXISTS pgr_withpointscostmatrix(text,text,anyarray,boolean,character);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointsdd(text,text,anyarray,double precision,boolean,character,boolean,boolean);
DROP FUNCTION IF EXISTS pgr_withpointsdd(text,text,anyarray,double precision,boolean,character,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointsdd(text,text,bigint,double precision,boolean,character,boolean);
DROP FUNCTION IF EXISTS pgr_withpointsdd(text,text,bigint,double precision,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_withpointsksp(text,text,bigint,bigint,integer,boolean,boolean,character,boolean);
DROP FUNCTION IF EXISTS pgr_withpointsksp(text,text,bigint,bigint,integer,boolean,boolean,character,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dijkstra(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_dijkstra(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dijkstra(text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS pgr_dijkstra(text,bigint,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dijkstra(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_dijkstra(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_astar(text,anyarray,bigint,boolean,integer,double precision,double precision);
DROP FUNCTION IF EXISTS pgr_astar(text,anyarray,bigint,boolean,integer,double precision,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_astar(text,bigint,anyarray,boolean,integer,double precision,double precision);
DROP FUNCTION IF EXISTS pgr_astar(text,bigint,anyarray,boolean,integer,double precision,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_astar(text,bigint,bigint,boolean,integer,double precision,double precision);
DROP FUNCTION IF EXISTS pgr_astar(text,bigint,bigint,boolean,integer,double precision,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_ksp(text,bigint,bigint,integer,boolean,boolean);
DROP FUNCTION IF EXISTS pgr_ksp(text,bigint,bigint,integer,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bdastar(text,bigint,bigint,boolean,integer,numeric,numeric);
DROP FUNCTION IF EXISTS pgr_bdastar(text,bigint,bigint,boolean,integer,numeric,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bdastar(text,bigint,anyarray,boolean,integer,numeric,numeric);
DROP FUNCTION IF EXISTS pgr_bdastar(text,bigint,anyarray,boolean,integer,numeric,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bdastar(text,anyarray,bigint,boolean,integer,numeric,numeric);
DROP FUNCTION IF EXISTS pgr_bdastar(text,anyarray,bigint,boolean,integer,numeric,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_drivingdistance(text,anyarray,double precision,boolean,boolean);
DROP FUNCTION IF EXISTS pgr_drivingdistance(text,anyarray,double precision,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_drivingdistance(text,bigint,double precision,boolean);
DROP FUNCTION IF EXISTS pgr_drivingdistance(text,bigint,double precision,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primbfs(text,anyarray,bigint);
DROP FUNCTION IF EXISTS pgr_primbfs(text,anyarray,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primbfs(text,bigint,bigint);
DROP FUNCTION IF EXISTS pgr_primbfs(text,bigint,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primdfs(text,anyarray,bigint);
DROP FUNCTION IF EXISTS pgr_primdfs(text,anyarray,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primdfs(text,bigint,bigint);
DROP FUNCTION IF EXISTS pgr_primdfs(text,bigint,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primdd(text,bigint,numeric);
DROP FUNCTION IF EXISTS pgr_primdd(text,bigint,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primdd(text,bigint,double precision);
DROP FUNCTION IF EXISTS pgr_primdd(text,bigint,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primdd(text,anyarray,numeric);
DROP FUNCTION IF EXISTS pgr_primdd(text,anyarray,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_primdd(text,anyarray,double precision);
DROP FUNCTION IF EXISTS pgr_primdd(text,anyarray,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskalbfs(text,anyarray,bigint);
DROP FUNCTION IF EXISTS pgr_kruskalbfs(text,anyarray,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskalbfs(text,bigint,bigint);
DROP FUNCTION IF EXISTS pgr_kruskalbfs(text,bigint,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskaldfs(text,anyarray,bigint);
DROP FUNCTION IF EXISTS pgr_kruskaldfs(text,anyarray,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskaldfs(text,bigint,bigint);
DROP FUNCTION IF EXISTS pgr_kruskaldfs(text,bigint,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskaldd(text,bigint,numeric);
DROP FUNCTION IF EXISTS pgr_kruskaldd(text,bigint,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskaldd(text,bigint,double precision);
DROP FUNCTION IF EXISTS pgr_kruskaldd(text,bigint,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskaldd(text,anyarray,numeric);
DROP FUNCTION IF EXISTS pgr_kruskaldd(text,anyarray,numeric);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_kruskaldd(text,anyarray,double precision);
DROP FUNCTION IF EXISTS pgr_kruskaldd(text,anyarray,double precision);
ALTER EXTENSION pgrouting DROP FUNCTION _pgr_breadthfirstsearch(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS _pgr_breadthfirstsearch(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_turnrestrictedpath(text,text,bigint,bigint,integer,boolean,boolean,boolean,boolean);
DROP FUNCTION IF EXISTS pgr_turnrestrictedpath(text,text,bigint,bigint,integer,boolean,boolean,boolean,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bellmanford(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_bellmanford(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bellmanford(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_bellmanford(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bellmanford(text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS pgr_bellmanford(text,bigint,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_binarybreadthfirstsearch(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_binarybreadthfirstsearch(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_binarybreadthfirstsearch(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_binarybreadthfirstsearch(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_binarybreadthfirstsearch(text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS pgr_binarybreadthfirstsearch(text,bigint,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_topologicalsort(text);
DROP FUNCTION IF EXISTS pgr_topologicalsort(text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_transitiveclosure(text);
DROP FUNCTION IF EXISTS pgr_transitiveclosure(text);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dagshortestpath(text,bigint,bigint);
DROP FUNCTION IF EXISTS pgr_dagshortestpath(text,bigint,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dagshortestpath(text,bigint,anyarray);
DROP FUNCTION IF EXISTS pgr_dagshortestpath(text,bigint,anyarray);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dagshortestpath(text,anyarray,bigint);
DROP FUNCTION IF EXISTS pgr_dagshortestpath(text,anyarray,bigint);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_dagshortestpath(text,anyarray,anyarray);
DROP FUNCTION IF EXISTS pgr_dagshortestpath(text,anyarray,anyarray);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_edgedisjointpaths(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_edgedisjointpaths(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_edgedisjointpaths(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_edgedisjointpaths(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_edgedisjointpaths(text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS pgr_edgedisjointpaths(text,bigint,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_edwardmoore(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_edwardmoore(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_edwardmoore(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_edwardmoore(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_edwardmoore(text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS pgr_edwardmoore(text,bigint,anyarray,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bddijkstra(text,bigint,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_bddijkstra(text,bigint,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bddijkstra(text,anyarray,bigint,boolean);
DROP FUNCTION IF EXISTS pgr_bddijkstra(text,anyarray,bigint,boolean);
ALTER EXTENSION pgrouting DROP FUNCTION pgr_bddijkstra(text,bigint,anyarray,boolean);
DROP FUNCTION IF EXISTS pgr_bddijkstra(text,bigint,anyarray,boolean);





---
--- pgRouting provides geospatial routing functionality.
--- http://pgrouting.org
--- copyright
--- -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--- Functions are under GNU General Public Licence.

---
--- This program is free software; you can redistribute it and/or modify
--- it under the terms of the GNU General Public License as published by
--- the Free Software Foundation; either version 2 of the License, or
--- (at your option) any later version.

--- This program is distributed in the hope that it will be useful,
--- but WITHOUT ANY WARRANTY; without even the implied warranty of
--- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--- GNU General Public License for more details.

--- You should have received a copy of the GNU General Public License
--- along with this program; if not, write to the Free Software
--- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

--- -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

--- -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
--
-- WARNING: Any change in this file must be evaluated for compatibility.
--          Changes cleanly handled by pgrouting upgrades.sql are fine,
--          other changes will require a bump in Major version.
--          Currently only function replaceble by CREATE OR REPLACE
--          are cleanly handled.
--
-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -





CREATE OR REPLACE FUNCTION _pgr_parameter_check(fn text, sql text, big boolean default false)
  RETURNS BOOLEAN AS
  $BODY$

  DECLARE
  rec record;
  rec1 record;
  has_rcost boolean;
  safesql text;
  BEGIN
    IF (big) THEN
       RAISE EXCEPTION 'This function is for old style functions';
    END IF;

    -- checking query is executable
    BEGIN
      safesql =  'select * from ('||sql||' ) AS __a__ limit 1';
      execute safesql into rec;
      EXCEPTION
        WHEN OTHERS THEN
            RAISE EXCEPTION 'Could not execute query please verify syntax of: '
              USING HINT = sql;
    END;

    -- checking the fixed columns and data types of the integers
    IF fn IN ('dijkstra','astar') THEN
        BEGIN
          execute 'select id,source,target,cost  from ('||safesql||') as __b__' into rec;
          EXCEPTION
            WHEN OTHERS THEN
                RAISE EXCEPTION 'An expected column was not found in the query'
                  USING ERRCODE = 'XX000',
                   HINT = 'Please verify the column names: id, source, target, cost';
        END;
        execute 'select pg_typeof(id)::text as id_type, pg_typeof(source)::text as source_type, pg_typeof(target)::text as target_type, pg_typeof(cost)::text as cost_type'
            || ' from ('||safesql||') AS __b__ ' into rec;
        -- Version 2.0.0 is more restrictive
        IF NOT(   (rec.id_type in ('integer'::text))
              AND (rec.source_type in ('integer'::text))
              AND (rec.target_type in ('integer'::text))
              AND (rec.cost_type = 'double precision'::text)) THEN
            RAISE EXCEPTION 'Error, columns ''source'', ''target'' must be of type int4, ''cost'' must be of type float8'
            USING ERRCODE = 'XX000';
        END IF;
    END IF;


    IF fn IN ('astar') THEN
        BEGIN
          execute 'select x1,y1,x2,y2  from ('||safesql||') as __b__' into rec;
          EXCEPTION
            WHEN OTHERS THEN
                RAISE EXCEPTION 'An expected column was not found in the query'
                  USING ERRCODE = 'XX000',
                   HINT = 'Please verify the column names: x1,y1, x2,y2';
        END;
        execute 'select pg_typeof(x1)::text as x1_type, pg_typeof(y1)::text as y1_type, pg_typeof(x2)::text as x2_type, pg_typeof(y2)::text as y2_type'
            || ' from ('||safesql||') AS __b__ ' into rec;
        -- Version 2.0.0 is more restrictive
        IF NOT(   (rec.x1_type = 'double precision'::text)
              AND (rec.y1_type = 'double precision'::text)
              AND (rec.x2_type = 'double precision'::text)
              AND (rec.y2_type = 'double precision'::text)) THEN
            RAISE EXCEPTION 'Columns: x1, y1, x2, y2 must be of type float8'
            USING ERRCODE = 'XX000';
        END IF;
    END IF;

    -- checking the fixed columns and data types of the integers
    IF fn IN ('johnson') THEN
        BEGIN
          execute 'select source,target,cost  from ('||safesql||') as __b__' into rec;
          EXCEPTION
            WHEN OTHERS THEN
                RAISE EXCEPTION 'An expected column was not found in the query'
                  USING HINT = 'Please verify the column names: id, source, target, cost',
                         ERRCODE = 'XX000';
        END;

        execute 'select pg_typeof(source)::text as source_type, pg_typeof(target)::text as target_type, pg_typeof(cost)::text as cost_type'
            || ' from ('||safesql||') AS __b__ ' into rec;
        -- Version 2.0.0 is more restrictive
        IF NOT(   (rec.source_type in ('integer'::text))
              AND (rec.target_type in ('integer'::text))
              AND (rec.cost_type = 'double precision'::text)) THEN
            RAISE EXCEPTION 'Support for source,target columns only of type: integer. Support for Cost: double precision'
            USING ERRCODE = 'XX000';
        END IF;
    END IF;


    -- Checking the data types of the optional reverse_cost";
    has_rcost := false;
    IF fn IN ('johnson','dijkstra','astar') THEN
      BEGIN
        execute 'select reverse_cost, pg_typeof(reverse_cost)::text as rev_type  from ('||safesql||' ) AS __b__ limit 1 ' into rec1;
        has_rcost := true;
        EXCEPTION
          WHEN OTHERS THEN
            has_rcost = false;
            return has_rcost;
      END;
      if (has_rcost) then
        IF (big) then
           IF  not (rec1.rev_type in ('bigint'::text, 'integer'::text, 'smallint'::text, 'double precision'::text, 'real'::text)) then
             RAISE EXCEPTION 'Illegar type in optional parameter reverse_cost.'
             USING ERRCODE = 'XX000';
           END IF;
        ELSE -- Version 2.0.0 is more restrictive
           IF (rec1.rev_type != 'double precision') then
             RAISE EXCEPTION 'Illegal type in optional parameter reverse_cost, must be of type float8'
             USING ERRCODE = 'XX000';
           END IF;
        END IF;
      end if;
      return true;
    END IF;
    -- just for keeps
    return true;
  END
  $BODY$
  LANGUAGE plpgsql VOLATILE
  COST 1;

COMMENT ON FUNCTION _pgr_parameter_check(TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';



--v3.4
CREATE FUNCTION _pgr_checkquery(
  TEXT  -- SQL
)
RETURNS TEXT AS
$BODY$
DECLARE
  main_sql TEXT;

BEGIN

  IF $1 !~ '[[:space:]]' THEN
    -- prepared statements no arguments
    EXECUTE format($$
      SELECT regexp_replace(regexp_replace(statement, %1$L,'','i'),';$','')
      FROM pg_prepared_statements WHERE name = %2$L$$,
      '.*' || $1 || '\s*as', $1)
    INTO main_sql;

    IF main_sql IS NULL THEN
      RAISE EXCEPTION 'prepared statement "%" does not exist', $1;
    END IF;
  ELSE
    -- normal query
    main_sql := $1;
  END IF;

  BEGIN
    EXECUTE format('SELECT * FROM ( %1$s ) AS __a__ limit 1', main_sql);

    EXCEPTION WHEN OTHERS THEN
      RAISE EXCEPTION '%', SQLERRM USING HINT = $1, ERRCODE = SQLSTATE;
  END;

  RETURN main_sql;

END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;

COMMENT ON FUNCTION _pgr_checkquery(TEXT)
IS 'pgrouting internal function';



--v3.4
CREATE FUNCTION _pgr_checkColumn(
  TEXT, -- SQL
  TEXT, -- Column
  TEXT, -- Types
  is_optional BOOLEAN DEFAULT false,
  dryrun BOOLEAN DEFAULT false
)
RETURNS BOOLEAN AS
$BODY$
DECLARE
  has_column BOOLEAN := TRUE;
  rec RECORD;
  sqlhint TEXT;

BEGIN

  BEGIN
    EXECUTE format('SELECT %1$s FROM ( %2$s ) AS __a__ limit 1', $2, $1);
    EXCEPTION WHEN OTHERS THEN
      BEGIN
      IF NOT is_optional THEN
        RAISE EXCEPTION '%', SQLERRM USING HINT = $1, ERRCODE = SQLSTATE;
      ELSE
        has_column := FALSE;
      END IF;
      END;
  END;

  BEGIN
    EXECUTE format('SELECT pg_typeof(%1$s) FROM ( %2$s ) AS __a__ limit 1', $2, $1)
    INTO rec;

    EXCEPTION WHEN OTHERS THEN
      has_column := FALSE;
  END;

  IF dryrun THEN
    RETURN has_column;
  END IF;

  IF NOT is_optional AND NOT has_column THEN
    RAISE EXCEPTION 'Missing column'
    USING HINT = format('Column "%1$s" missing in: %2$s', $2, $1);
  END IF;

  IF has_column THEN
    CASE $3
    WHEN 'ANY-INTEGER' THEN
      IF  rec.pg_typeof NOT IN ('smallint','integer','bigint') THEN
        RAISE EXCEPTION 'Expected type of column "%" is ANY-INTEGER', $2
        USING HINT = 'Query: ' || $1;
      END IF;
    WHEN 'ANY-INTEGER[]' THEN
      IF  rec.pg_typeof NOT IN ('smallint[]','integer[]','bigint[]') THEN
        RAISE EXCEPTION 'Expected type of column "%" is ANY-INTEGER-ARRAY', $2
        USING HINT = 'Query: ' || $1;
      END IF;
    WHEN 'ANY-NUMERICAL' THEN
      IF  rec.pg_typeof NOT IN ('smallint','integer','bigint','real','float','numeric') THEN
        RAISE EXCEPTION 'Expected type of column "%s" is ANY-NUMERICAL', $2
        USING HINT = 'Query: ' || $1;
      END IF;
    ELSE
      IF rec.pg_typeof::TEXT != $3 THEN
        RAISE EXCEPTION 'Expected type of column "%" is %', $2, $3
        USING HINT = 'Query: ' || $1;
      END IF;
    END CASE;
  END IF;

  RETURN has_column;

END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;

COMMENT ON FUNCTION _pgr_checkColumn(TEXT, TEXT, TEXT, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION _pgr_get_statement(o_sql text)
RETURNS TEXT AS
$BODY$
DECLARE
sql TEXT;
BEGIN
    EXECUTE 'SELECT statement FROM pg_prepared_statements WHERE name ='  || quote_literal(o_sql) || ' limit 1 ' INTO sql;
    IF (sql IS NULL) THEN
      RETURN   o_sql;
    ELSE
      RETURN  regexp_replace(regexp_replace(regexp_replace(sql, '\s(as)\s', '___foo___', 'i'), '^.*___foo___', '','i'), ';$', '');
    END IF;
END
$BODY$
LANGUAGE plpgsql STABLE STRICT;

COMMENT ON FUNCTION _pgr_get_statement(TEXT)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION _pgr_dijkstra_v4(
    TEXT, -- edges

    ANYARRAY, -- departures
    ANYARRAY, -- arrivals

    BOOLEAN, --directed

    BOOLEAN, -- only_cost
    BOOLEAN, -- normal

    BIGINT,  -- n_goals
    BOOLEAN, -- global

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION _pgr_dijkstra_v4(
    TEXT, -- edges
    TEXT, -- combinations

    BOOLEAN, --directed
    BOOLEAN, -- only_cost

    BIGINT,  -- n_goals
    BOOLEAN, -- global

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_dijkstra_v4(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_dijkstra_v4(TEXT, TEXT, BOOLEAN, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgRouting internal function';


-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_dijkstra(
    TEXT,   -- edges_sql (required)
    BIGINT, -- start_vid (required)
    BIGINT, -- end_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[],
        $4, false, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- ONE TO MANY
CREATE OR REPLACE FUNCTION pgr_dijkstra(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- start_vid (required)
    ANYARRAY, -- end_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[],
       $4, false, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY TO ONE
CREATE OR REPLACE FUNCTION pgr_dijkstra(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- start_vid (required)
    BIGINT,   -- end_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[],
$4, false, false, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY TO MANY
CREATE OR REPLACE FUNCTION pgr_dijkstra(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- start_vid (required)
    ANYARRAY, -- end_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[],
      $4, false, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- Combinations SQL signature
--v3.1
CREATE FUNCTION pgr_dijkstra(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), _pgr_get_statement($2),
      $3, false, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_dijkstra(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_dijkstra(One to One)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstra.html
';

COMMENT ON FUNCTION pgr_dijkstra(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_dijkstra(One to Many)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstra.html
';

COMMENT ON FUNCTION pgr_dijkstra(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_dijkstra(Many to One)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstra.html
';

COMMENT ON FUNCTION pgr_dijkstra(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_dijkstra(Many to Many)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstra.html
';

COMMENT ON FUNCTION pgr_dijkstra(TEXT, TEXT, BOOLEAN)
IS 'pgr_dijkstra(Combinations)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - Combinations SQL with columns: source, target
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstra.html
';


-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_dijkstraCost(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vids (required)
    BIGINT, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4, true, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_dijkstraCost(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4, true, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;




-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_dijkstraCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4, true, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;




-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_dijkstraCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4, true, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

-- Combinations SQL signature
--v3.1
CREATE FUNCTION pgr_dijkstraCost(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3, true, 0, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



COMMENT ON FUNCTION pgr_dijkstraCost(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_dijkstraCost(One to One)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraCost.html
';

COMMENT ON FUNCTION pgr_dijkstraCost(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_dijkstraCost(One to Many)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraCost.html
';

COMMENT ON FUNCTION pgr_dijkstraCost(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_dijkstraCost(Many to One)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraCost.html
';

COMMENT ON FUNCTION pgr_dijkstraCost(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_dijkstraCost(Many to Many)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraCost.html
';

COMMENT ON FUNCTION pgr_dijkstraCost(TEXT, TEXT, BOOLEAN)
IS 'pgr_dijkstraCost(Combinations SQL)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - Combinations SQL with columns: source, target
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraCost.html
';


CREATE OR REPLACE FUNCTION pgr_dijkstraCostMatrix(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], '{}'::BIGINT[], $3, true, true, 0, false) a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_dijkstraCostMatrix(TEXT, ANYARRAY, BOOLEAN)
IS 'pgr_dijkstraCostMatrix
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - ARRAY [vertices identifiers]
- Optional Parameters
    - directed := true
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_dijkstraCostMatrix.html
';


------------------
-- pgr_dijkstraVia
------------------

CREATE OR REPLACE FUNCTION _pgr_dijkstraVia(
    edges_sql TEXT,
    via_vids ANYARRAY,
    directed BOOLEAN,
    strict BOOLEAN,
    U_turn_on_edge BOOLEAN,


    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT,
    OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_dijkstraVia(TEXT, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_dijkstraVia(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- via_vids (required)

    directed BOOLEAN DEFAULT true,
    strict BOOLEAN DEFAULT false,
    U_turn_on_edge BOOLEAN DEFAULT true,


    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT,
    OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost, route_agg_cost
    FROM _pgr_dijkstraVia(_pgr_get_statement($1), $2, $3 , $4, $5);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_dijkstraVia(TEXT, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_dijkstraVia
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - ARRAY[via vertices identifiers]
- Optional Parameters
   - directed := true
   - strict := false
   - U_turn_on_edge := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraVia.html
';


--------------------
-- pgr_dijkstraNear
--------------------

-- ONE to MANY
--v3.2
CREATE FUNCTION pgr_dijkstraNear(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], directed, false, true, cap, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to ONE
--v3.2
CREATE FUNCTION pgr_dijkstraNear(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], directed, false, false, cap, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to MANY
--v3.2
CREATE FUNCTION pgr_dijkstraNear(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,
    global   BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], directed, false, true, cap, global);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- Combinations SQL signature
--v3.2
CREATE FUNCTION pgr_dijkstraNear(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,
    global   BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), _pgr_get_statement($2), directed, false, cap, global);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_dijkstraNear(TEXT, BIGINT, ANYARRAY, BOOLEAN, BIGINT)
IS 'pgr_dijkstraNear(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dijkstraNear.html
';

COMMENT ON FUNCTION  pgr_dijkstraNear(TEXT, ANYARRAY, BIGINT, BOOLEAN, BIGINT)
IS 'pgr_dijkstraNear(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dijkstraNear.html
';

COMMENT ON FUNCTION  pgr_dijkstraNear(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgr_dijkstraNear(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraNear.html
';

COMMENT ON FUNCTION  pgr_dijkstraNear(TEXT, TEXT, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgr_dijkstraNear(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dijkstraNear.html
';


-- ONE to MANY
--v3.2
CREATE FUNCTION pgr_dijkstraNearCost(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], directed, true, true, cap, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

-- MANY to ONE
--v3.2
CREATE FUNCTION pgr_dijkstraNearCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], directed, true, false, cap, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

-- MANY to MANY
--v3.2
CREATE FUNCTION pgr_dijkstraNearCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,
    global   BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], directed, true, true, cap, global);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

-- Combinations
--v3.2
CREATE FUNCTION pgr_dijkstraNearCost(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,
    cap      BIGINT DEFAULT 1,
    global   BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_dijkstra_v4(_pgr_get_statement($1), _pgr_get_statement($2), directed, true, cap, global);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_dijkstraNearCost(TEXT, BIGINT, ANYARRAY, BOOLEAN, BIGINT)
IS 'pgr_dijkstraNearCost(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dijkstraNearCost.html
';

COMMENT ON FUNCTION  pgr_dijkstraNearCost(TEXT, ANYARRAY, BIGINT, BOOLEAN, BIGINT)
IS 'pgr_dijkstraNearCost(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dijkstraNearCost.html
';

COMMENT ON FUNCTION  pgr_dijkstraNearCost(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgr_dijkstraNearCost(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_dijkstraNearCost.html
';

COMMENT ON FUNCTION  pgr_dijkstraNearCost(TEXT, TEXT, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgr_dijkstraNearCost(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed => true
  - cap => 1 (nth found)
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dijkstraNearCost.html
';


------------------
-- pgr_johnson
------------------

CREATE OR REPLACE FUNCTION _pgr_johnson(
    edges_sql TEXT,
    directed BOOLEAN,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_johnson(TEXT, BOOLEAN)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_johnson(
    TEXT,    -- edges_sql (required)
    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$

    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_johnson(_pgr_get_statement($1), $2);

$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_johnson(TEXT, BOOLEAN)
IS 'pgr_johnson
- Parameters:
    - edges SQL with columns: source, target, cost [,reverse_cost])
- Optional Parameters:
    - directed := true
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_johnson.html
';


---------------------
-- pgr_floydWarshall
---------------------

CREATE OR REPLACE FUNCTION _pgr_floydWarshall(
    edges_sql TEXT,
    directed BOOLEAN,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_floydWarshall(TEXT, BOOLEAN)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_floydWarshall(
    TEXT,    -- edges_sql (required)
    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$

    SELECT start_vid, end_vid, agg_cost
    FROM _pgr_floydWarshall(_pgr_get_statement($1), $2);

$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_floydWarshall(TEXT, BOOLEAN)
IS 'pgr_floydWarshall
- Parameters:
    - edges SQL with columns: source, target, cost [,reverse_cost])
- Optional Parameters:
    - directed := true
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_floydWarshall.html
';


-----------------
-----------------
-- _astar
-----------------
-----------------


-----------------
-- pgr_astar
-----------------


CREATE OR REPLACE FUNCTION _pgr_astar(
    edges_sql TEXT, -- XY edges sql
    start_vids ANYARRAY,
    end_vids ANYARRAY,

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,
    only_cost BOOLEAN DEFAULT false,
    normal BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.2
CREATE FUNCTION _pgr_astar(
    edges_sql TEXT, -- XY edges sql
    combinations_sql TEXT,

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,
    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_astar(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_astar(TEXT, TEXT, BOOLEAN, INTEGER, FLOAT, FLOAT, BOOLEAN)
IS 'pgRouting internal function';


-----------------
-- pgr_aStar
-----------------


--v3.6
CREATE FUNCTION pgr_aStar(
    TEXT,     -- edges sql (required)
    BIGINT,   -- from_vid (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[],  ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.6
CREATE FUNCTION pgr_aStar(
    TEXT,       -- edges sql (required)
    BIGINT,     -- from_vid (required)
    ANYARRAY,   -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[],  $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.6
CREATE FUNCTION pgr_aStar(
    TEXT,       -- edges sql (required)
    ANYARRAY,   -- from_vids (required)
    BIGINT,     -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), $2::BIGINT[],  ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, normal:=false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


CREATE OR REPLACE FUNCTION pgr_aStar(
    TEXT,       -- edges sql (required)
    ANYARRAY,   -- from_vids (required)
    ANYARRAY,   -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), $2::BIGINT[],  $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.2
CREATE FUNCTION pgr_aStar(
    TEXT,       -- edges sql (required)
    TEXT,       -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5::FLOAT, $6::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_aStar(TEXT, BIGINT, BIGINT, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStar(One to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_aStar.html
';


COMMENT ON FUNCTION pgr_aStar(TEXT, BIGINT, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStar(One to Many)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_aStar.html
';


COMMENT ON FUNCTION pgr_aStar(TEXT, ANYARRAY, BIGINT, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStar(Many to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_aStar.html
';


  COMMENT ON FUNCTION pgr_aStar(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStar(Many to Many)
 - Parameters:
   - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
   - From ARRAY[vertices identifiers]
   - To ARRAY[vertices identifiers]
 - Optional Parameters:
   - directed := true
   - heuristic := 5
   - factor := 1
   - epsilon := 1
 - Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_aStar.html
';


COMMENT ON FUNCTION pgr_aStar(TEXT, TEXT, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStar(Combinations)
 - Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
   - Combinations SQL with columns: source, target
 - Optional Parameters:
   - directed := true
   - heuristic := 5
   - factor := 1
   - epsilon := 1
 - Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_aStar.html
';



-----------------
-- pgr_aStarCost
-----------------


CREATE OR REPLACE FUNCTION pgr_aStarCost(
    TEXT,     -- edges sql (required)
    BIGINT,   -- from_vid (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[],  ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a
    ORDER BY  a.start_vid, a.end_vid;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



CREATE OR REPLACE FUNCTION pgr_aStarCost(
    TEXT,       -- edges sql (required)
    BIGINT,     -- from_vid (required)
    ANYARRAY,   -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[],  $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a
    ORDER BY  a.start_vid, a.end_vid;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



CREATE OR REPLACE FUNCTION pgr_aStarCost(
    TEXT,       -- edges sql (required)
    ANYARRAY,   -- from_vids (required)
    BIGINT,     -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), $2::BIGINT[],  ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true, normal:=false) AS a
    ORDER BY  a.start_vid, a.end_vid;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


CREATE OR REPLACE FUNCTION pgr_aStarCost(
    TEXT,       -- edges sql (required)
    ANYARRAY,   -- from_vids (required)
    ANYARRAY,   -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), $2::BIGINT[],  $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a
    ORDER BY  a.start_vid, a.end_vid;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


--v3.2
CREATE FUNCTION pgr_aStarCost(
    TEXT,       -- edges sql (required)
    TEXT,       -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_aStar(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5::FLOAT, $6::FLOAT, true) AS a
    ORDER BY  a.start_vid, a.end_vid;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



COMMENT ON FUNCTION pgr_aStarCost(TEXT, BIGINT, BIGINT, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStarCost(One to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_aStarCost.html
';


COMMENT ON FUNCTION pgr_aStarCost(TEXT, BIGINT, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStarCost(One to Many)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_aStarCost.html
';


COMMENT ON FUNCTION pgr_aStarCost(TEXT, ANYARRAY, BIGINT, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStarCost(Many to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_aStarCost.html
';


COMMENT ON FUNCTION pgr_aStarCost(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStarCost(Many to Many)
 - Parameters:
   - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
   - From ARRAY[vertices identifiers]
   - To ARRAY[vertices identifiers]
 - Optional Parameters:
   - directed := true
   - heuristic := 5
   - factor := 1
   - epsilon := 1
 - Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_aStarCost.html
';


COMMENT ON FUNCTION pgr_aStarCost(TEXT, TEXT, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStarCost(Combinations)
 - Parameters:
   - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
   - Combinations SQL with columns: source, target
 - Optional Parameters:
   - directed := true
   - heuristic := 5
   - factor := 1
   - epsilon := 1
 - Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_aStarCost.html
';


-----------------------------
-- pgr_aStarCostMatrix
-----------------------------


CREATE OR REPLACE FUNCTION pgr_aStarCostMatrix(
    TEXT,     -- edges sql (required)
    ANYARRAY, -- vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_astar(_pgr_get_statement($1), $2, $2, $3, $4, $5::FLOAT, $6::FLOAT, true) a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- COMMENT

COMMENT ON FUNCTION pgr_aStarCostMatrix(TEXT, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT)
IS 'pgr_aStarCostMatrix
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
    - ARRAY [vertices identifiers]
- Optional Parameters:
    - directed := true
    - heuristic := 5
    - factor := 1
    - epsilon := 1
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_aStarCostMatrix.html
';


-------------------
-- pgr_withPointsDD
-------------------

--v3.6
CREATE FUNCTION _pgr_withPointsDDv4(
    TEXT,     -- edges SQL
    TEXT,     -- points SQL
    ANYARRAY, -- roots
    FLOAT,    -- distance
    CHAR,     -- driving_side,

    BOOLEAN,  -- directed
    BOOLEAN,  -- details
    BOOLEAN,  -- equicost

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_withPointsDDv4(TEXT, TEXT, ANYARRAY, FLOAT, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


-- SINGLE
--v3.6
CREATE FUNCTION pgr_withPointsDD(
    TEXT,   --edges_sql (required)
    TEXT,   -- points_sql (required)
    BIGINT, -- from_vid (required)
    FLOAT,  -- distance (required)
    CHAR,   -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    details BOOLEAN DEFAULT false,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_withPointsDDv4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], $4,
      $5, directed, details, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MULTIPLE
--v3.6
CREATE FUNCTION pgr_withPointsDD(
    TEXT,     --edges_sql (required)
    TEXT,     -- points_sql (required)
    ANYARRAY, -- from_vid (required)
    FLOAT,    -- distance (required)
    CHAR,     -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    details BOOLEAN DEFAULT false,
    equicost BOOLEAN DEFAULT false,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_withPointsDDv4(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4,
      $5, directed, details, equicost);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_withPointsDD(TEXT, TEXT, BIGINT, FLOAT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsDD(Single Vertex)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From vertex identifier
    - Distance
    - Driving side
- Optional Parameters
    - directed := true
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsDD.html
';


COMMENT ON FUNCTION pgr_withPointsDD(TEXT, TEXT, ANYARRAY, FLOAT, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsDD(Multiple Vertices)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From ARRAY[vertices identifiers]
    - Distance
    - Driving side
- Optional Parameters
    - directed := true
    - details := false
    - equicost := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsDD.html
';


-- SINGLE
--v4.0
CREATE FUNCTION pgr_withPointsDD(
    TEXT,   --edges_sql (required)
    TEXT,   -- points_sql (required)
    BIGINT, -- from_vid (required)
    FLOAT,  -- distance (required)

    directed BOOLEAN DEFAULT true,
    details BOOLEAN DEFAULT false,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_withPointsDDv4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], $4,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, details, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MULTIPLE
--v4.0
CREATE FUNCTION pgr_withPointsDD(
    TEXT,     --edges_sql (required)
    TEXT,     -- points_sql (required)
    ANYARRAY, -- from_vid (required)
    FLOAT,    -- distance (required)

    directed BOOLEAN DEFAULT true,
    details BOOLEAN DEFAULT false,
    equicost BOOLEAN DEFAULT false,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_withPointsDDv4(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, details, equicost);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_withPointsDD(TEXT, TEXT, BIGINT, FLOAT, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsDD(Single Vertex)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From vertex identifier
    - Distance
- Optional Parameters
    - directed := true
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsDD.html
';


COMMENT ON FUNCTION pgr_withPointsDD(TEXT, TEXT, ANYARRAY, FLOAT, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsDD(Multiple Vertices)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From ARRAY[vertices identifiers]
    - Distance
- Optional Parameters
    - directed := true
    - details := false
    - equicost := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsDD.html
';


--v3.6
CREATE FUNCTION _pgr_drivingDistancev4(
    TEXT,     -- edges_sql
    ANYARRAY, -- start_vids
    FLOAT,    -- distance
    BOOLEAN,  -- directed
    BOOLEAN,  -- equicost
    OUT seq BIGINT,
    OUT depth  BIGINT,
    OUT start_vid  BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_drivingDistancev4(TEXT, ANYARRAY, FLOAT, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


-- MULTIPLE
--v3.6
CREATE FUNCTION pgr_drivingDistance(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    FLOAT,    -- distance (required)

    directed BOOLEAN DEFAULT TRUE,
    equicost BOOLEAN DEFAULT FALSE,

    OUT seq BIGINT,
    OUT depth  BIGINT,
    OUT start_vid  BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_drivingDistancev4(_pgr_get_statement($1), $2, $3, $4, $5);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- SINGLE
--v3.6
CREATE FUNCTION pgr_drivingDistance(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    FLOAT,  -- distance (required)

    directed BOOLEAN DEFAULT TRUE,

    OUT seq BIGINT,
    OUT depth  BIGINT,
    OUT start_vid  BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_drivingDistancev4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3, $4, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_drivingDistance(TEXT, BIGINT, FLOAT, BOOLEAN)
IS 'pgr_drivingDistance(Single_vertex)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - Distance from vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_drivingDistance.html
';

COMMENT ON FUNCTION pgr_drivingDistance(TEXT, ANYARRAY, FLOAT, BOOLEAN, BOOLEAN)
IS 'pgr_drivingDistance(Multiple vertices)
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - Distance from vertices identifiers
- Optional Parameters
   - directed := true
   - equicost := false
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_drivingDistance.html
';



---------------
---------------
-- pgr_ksp
---------------
---------------

--v4.0
CREATE FUNCTION _pgr_ksp_v4(
  TEXT,     -- edges
  ANYARRAY, -- start_vids
  ANYARRAY, -- end_vids
  INTEGER,  -- k

  BOOLEAN,  -- directed
  BOOLEAN,  -- heap_paths

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION _pgr_ksp_v4(
    TEXT,     -- edges
    TEXT,     -- combinations

    INTEGER,  -- k

    BOOLEAN,  -- directed
    BOOLEAN,  -- heap_paths

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_ksp_v4(TEXT, ANYARRAY, ANYARRAY, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_ksp_v4(TEXT, TEXT, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';



-- one-to-one
--v3.6
CREATE FUNCTION pgr_ksp(
    TEXT,
    BIGINT,
    BIGINT,
    INTEGER,
    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_ksp_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4, $5, $6);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- one-to-many
--v3.6
CREATE FUNCTION pgr_ksp(
    TEXT,
    BIGINT,
    ANYARRAY,
    INTEGER,
    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM  _pgr_ksp_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4, $5, $6);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- many-to-one
--v3.6
CREATE FUNCTION pgr_ksp(
    TEXT,
    ANYARRAY,
    BIGINT,
    INTEGER,
    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM  _pgr_ksp_v4(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4, $5, $6);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- many-to-many
--v3.6
CREATE FUNCTION pgr_ksp(
    TEXT,
    ANYARRAY,
    ANYARRAY,
    INTEGER,
    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM  _pgr_ksp_v4(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4, $5, $6);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- combinations
--v3.6
CREATE FUNCTION pgr_ksp(
    TEXT,
    TEXT,
    INTEGER,
    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM  _pgr_ksp_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_ksp(TEXT, BIGINT, BIGINT, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgr_KSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From vertex identifier
    - To vertex identifier
    - K
- Optional Parameters
    - directed := true
    - heap_paths := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_KSP.html
';

COMMENT ON FUNCTION pgr_ksp(TEXT, BIGINT, ANYARRAY, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgr_KSP(One to Many)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From vertex identifier
    - To ARRAY[vertex identifier]
    - K
- Optional Parameters
    - directed := true
    - heap_paths := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_KSP.html
';

COMMENT ON FUNCTION pgr_ksp(TEXT, ANYARRAY, BIGINT, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgr_KSP(Many to One)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[vertex identifier]
    - To vertex identifier
    - K
- Optional Parameters
    - directed := true
    - heap_paths := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_KSP.html
';

COMMENT ON FUNCTION pgr_ksp(TEXT, ANYARRAY, ANYARRAY, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgr_KSP(Many to Many)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[vertex identifier]
    - To ARRAY[vertex identifier]
    - K
- Optional Parameters
    - directed := true
    - heap_paths := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_KSP.html
';

COMMENT ON FUNCTION pgr_ksp(TEXT, TEXT, INTEGER, BOOLEAN, BOOLEAN)
IS 'pgr_KSP(Combinations)
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Combinations SQL with columns: source, target
    - K
- Optional Parameters
    - directed := true
    - heap_paths := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_KSP.html
';


--v4.0
CREATE FUNCTION _pgr_withPointsKSP_v4(
  TEXT, -- edges
  TEXT, -- points
  ANYARRAY, -- departures
  ANYARRAY, -- destinations
  INTEGER, -- k
  CHAR, -- driving side

  BOOLEAN, -- directed
  BOOLEAN, -- heaps
  BOOLEAN, -- details

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION _pgr_withPointsKSP_v4(
  TEXT, -- edges
  TEXT, -- points
  TEXT, -- combinations
  INTEGER, -- k
  CHAR, -- driving side

  BOOLEAN, -- directed
  BOOLEAN, -- heaps
  BOOLEAN, -- details

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_withPointsKSP_v4(TEXT, TEXT, ANYARRAY, ANYARRAY, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_withPointsKSP_v4(TEXT, TEXT, TEXT, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


-- ONE to ONE
--v3.6
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    BIGINT,  -- from_vid (required)
    BIGINT,  -- to_vid (required)
    INTEGER, -- K (required)
    CHAR,    -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[], $5, $6,
      directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- ONE to MANY
--v3.6
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    BIGINT,  -- from_vid (required)
    ANYARRAY,-- to_vids (required)
    INTEGER, -- K (required)
    CHAR,    -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], $4::BIGINT[], $5, $6,
      directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to ONE
--v3.6
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    ANYARRAY,-- from_vid (required)
    BIGINT,  -- to_vids (required)
    INTEGER, -- K (required)
    CHAR,    -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], ARRAY[$4]::BIGINT[], $5, $6,
      directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to MANY
--v3.6
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    ANYARRAY,-- from_vid (required)
    ANYARRAY,-- to_vids (required)
    INTEGER, -- K (required)
    CHAR,    -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], $4::BIGINT[], $5, $6,
      directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- Combinations SQL signature
--v3.6
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    TEXT,    -- combinations_sql(required)
    INTEGER, -- K (required)
    CHAR,    -- driving_side (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3), $4, $5,
      directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, BIGINT, BIGINT, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From vertex identifier
    - To vertex identifier
    - K
    - driving side
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, BIGINT, ANYARRAY, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From vertex identifier
    - To ARRAY[vertices identifiers]
    - K
    - driving side
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, ANYARRAY, BIGINT, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From ARRAY[vertices identifier]
    - To vertex identifier
    - K
    - driving side
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, ANYARRAY, ANYARRAY, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From ARRAY[vertices identifier]
    - To ARRAY[vertices identifiers]
    - K
    - driving side
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, TEXT, INTEGER, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - Combinations SQL with columns: source, target
    - K
    - driving side
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

-- ONE to ONE
--v4.0
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    BIGINT,  -- from_vid (required)
    BIGINT,  -- to_vid (required)
    INTEGER, -- K (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[], $5,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- ONE to MANY
--v4.0
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    BIGINT,  -- from_vid (required)
    ANYARRAY,-- to_vids (required)
    INTEGER, -- K (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], $4::BIGINT[], $5,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to ONE
--v4.0
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    ANYARRAY,-- from_vid (required)
    BIGINT,  -- to_vids (required)
    INTEGER, -- K (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], ARRAY[$4]::BIGINT[], $5,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to MANY
--v4.0
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    ANYARRAY,-- from_vid (required)
    ANYARRAY,-- to_vids (required)
    INTEGER, -- K (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], $4::BIGINT[], $5,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- Combinations SQL signature
--v4.0
CREATE FUNCTION pgr_withPointsKSP(
    TEXT,    -- edges_sql (required)
    TEXT,    -- points_sql (required)
    TEXT,    -- combinations_sql(required)
    INTEGER, -- K (required)

    directed BOOLEAN DEFAULT true,
    heap_paths BOOLEAN DEFAULT false,
    details BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_withPointsKSP_v4(_pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3), $4,
      (CASE WHEN directed THEN 'r' ELSE 'b' END), directed, heap_paths, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, BIGINT, BIGINT, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From vertex identifier
    - To vertex identifier
    - K
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, BIGINT, ANYARRAY, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From vertex identifier
    - To ARRAY[vertices identifiers]
    - K
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, ANYARRAY, BIGINT, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From ARRAY[vertices identifier]
    - To vertex identifier
    - K
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, ANYARRAY, ANYARRAY, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - From ARRAY[vertices identifier]
    - To ARRAY[vertices identifiers]
    - K
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';

COMMENT ON FUNCTION pgr_withPointsKSP(TEXT, TEXT, TEXT, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsKSP
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - Points SQL with columns: [pid], edge_id, fraction[,side]
    - Combinations SQL with columns: source, target
    - K
- Optional Parameters
    - directed := true
    - heap paths := false
    - details := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_withPointsKSP.html';


--v4.0
CREATE FUNCTION _pgr_turnRestrictedPath_v4(
  TEXT,   -- edges_sql
  TEXT,   -- restrictions_sql
  ANYARRAY, -- start_vertex
  ANYARRAY, -- end_vertex
  INTEGER,  -- K cycles

  BOOLEAN,  -- directed
  BOOLEAN,  -- heap_paths
  BOOLEAN,
  BOOLEAN,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_turnRestrictedPath_v4(TEXT, TEXT, ANYARRAY, ANYARRAY, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


-- ONE to ONE
--v4.0
CREATE FUNCTION pgr_turnRestrictedPath(
  TEXT,   -- edges_sql (required)
  TEXT,   -- restrictions_sql (required)
  BIGINT, -- start_vertex (required)
  BIGINT, -- end_vertex (required)
  INTEGER,-- K cycles (required)

  directed BOOLEAN DEFAULT true,
  heap_paths BOOLEAN DEFAULT false,
  stop_on_first BOOLEAN DEFAULT true,
  strict BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_turnRestrictedPath_v4(
    _pgr_get_statement($1),
    _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[],
    $5, directed, heap_paths, stop_on_first, strict);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_turnRestrictedPath(TEXT, TEXT, BIGINT, BIGINT, INTEGER, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_turnRestrictedPath
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - From vertex identifier
  - To vertex identifier
  - K
- Optional Parameters
  - directed := true
  - heap_paths := false
  - stop_on_first := true
  - strict := false
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_turnRestrictedPath.html
';


--v4.0
CREATE FUNCTION _pgr_TSP_v4(
  TEXT,
  BIGINT,
  BIGINT,

  OUT seq INTEGER,
  OUT node BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF record
AS 'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_TSP_v4(TEXT, BIGINT, BIGINT)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION _pgr_TSPeuclidean_v4(
  TEXT,
  BIGINT,
  BIGINT,

  OUT seq integer,
  OUT node BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF record
AS 'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_TSPeuclidean_v4(TEXT, BIGINT, BIGINT)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION pgr_TSP(
    TEXT, -- matrix_row_sql (required)

    start_id BIGINT DEFAULT 0,
    end_id BIGINT DEFAULT 0,

    OUT seq INTEGER,
    OUT node BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, node, cost, agg_cost
    FROM _pgr_TSP_v4(_pgr_get_statement($1), $2, $3);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_TSP(TEXT, BIGINT, BIGINT)
IS 'pgr_TSP
- Parameters
  - matrix SQL with columns: start_vid, end_vid, agg_cost
- Optional parameters
    - start_id := 0
    - end_id := 0
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_TSP.html
';


--v4.0
CREATE FUNCTION pgr_TSPeuclidean(
    TEXT,

    start_id BIGINT DEFAULT 0,
    end_id BIGINT DEFAULT 0,

    OUT seq integer,
    OUT node BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, node, cost, agg_cost
FROM _pgr_TSPeuclidean_v4(_pgr_get_statement($1), $2, $3);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_TSPeuclidean(TEXT, BIGINT, BIGINT)
IS 'pgr_TSPeuclidean
- Parameters
   - coordinates SQL with columns: id, x, y
- Optional parameters
    - start_id := 0
    - end_id := 0
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_TSPeuclidean.html
';



----------------
----------------
-- bdAstar
----------------
----------------



CREATE OR REPLACE FUNCTION _pgr_bdAstar(
    TEXT,
    ANYARRAY,
    ANYARRAY,
    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,
    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
    'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.2
CREATE FUNCTION _pgr_bdAstar(
    TEXT,
    TEXT,
    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor FLOAT DEFAULT 1.0,
    epsilon FLOAT DEFAULT 1.0,
    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
    'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION _pgr_bdAstar(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, INTEGER, FLOAT, FLOAT, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_bdAstar(TEXT, TEXT, BOOLEAN, INTEGER, FLOAT, FLOAT, BOOLEAN)
IS 'pgRouting internal function';

--------------------
-- pgr_bdAstar
--------------------


-- one to one
CREATE OR REPLACE FUNCTION pgr_bdAstar(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- one to many
CREATE OR REPLACE FUNCTION pgr_bdAstar(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- many to one
CREATE OR REPLACE FUNCTION pgr_bdAstar(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- many to many
CREATE OR REPLACE FUNCTION pgr_bdAstar(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- combinations
--v3.2
CREATE FUNCTION pgr_bdAstar(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5::FLOAT, $6::FLOAT, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_bdAstar(TEXT, BIGINT, BIGINT, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstar(One to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstar.html
';

COMMENT ON FUNCTION pgr_bdAstar(TEXT, BIGINT, ANYARRAY, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstar(One to Many)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstar.html
';


COMMENT ON FUNCTION pgr_bdAstar(TEXT, ANYARRAY, BIGINT, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstar(Many to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstar.html
';

COMMENT ON FUNCTION pgr_bdAstar(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstar(Many to Many)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstar.html
';

COMMENT ON FUNCTION pgr_bdAstar(TEXT, TEXT, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstar(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [, reverse_cost], x1, y1, x2, y2
  - Combinations SQL with columns: source, target
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstar.html
';


--------------------
-- pgr_bdAstarCost
--------------------

-- one to one
CREATE OR REPLACE FUNCTION pgr_bdAstarCost(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- one to many
CREATE OR REPLACE FUNCTION pgr_bdAstarCost(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vidd (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- many to one
CREATE OR REPLACE FUNCTION pgr_bdAstarCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



-- many to many
CREATE OR REPLACE FUNCTION pgr_bdAstarCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4, $5, $6::FLOAT, $7::FLOAT, true) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- combinations
--v3.2
CREATE FUNCTION pgr_bdAstarCost(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5::FLOAT, $6::FLOAT, true) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



COMMENT ON FUNCTION pgr_bdAstarCost(TEXT, BIGINT, BIGINT, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstarCost(One to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstarCost.html
';


COMMENT ON FUNCTION pgr_bdAstarCost(TEXT, BIGINT, ANYARRAY, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstarCost(One to Many)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstarCost.html
';


COMMENT ON FUNCTION pgr_bdAstarCost(TEXT, ANYARRAY, BIGINT, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstarCost(Many to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstarCost.html
';


COMMENT ON FUNCTION pgr_bdAstarCost(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstarCost(Many to Many)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstarCost.html
';


COMMENT ON FUNCTION pgr_bdAstarCost(TEXT, TEXT, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstarCost(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [, reverse_cost], x1, y1, x2, y2
  - Combinations SQL with columns: source, target
- Optional Parameters:
  - directed := true
  - heuristic := 5
  - factor := 1
  - epsilon := 1
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdAstarCost.html
';



-----------------------------
-- pgr_bdAstarCostMatrix
-----------------------------


CREATE OR REPLACE FUNCTION pgr_bdAstarCostMatrix(
    TEXT,     -- edges sql (required)
    ANYARRAY, -- vids (required)

    directed BOOLEAN DEFAULT true,
    heuristic INTEGER DEFAULT 5,
    factor NUMERIC DEFAULT 1.0,
    epsilon NUMERIC DEFAULT 1.0,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost float)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdAstar(_pgr_get_statement($1), $2::BIGINT[], $2::BIGINT[], $3, $4, $5::FLOAT, $6::FLOAT, true) a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMMENT

COMMENT ON FUNCTION pgr_bdAstarCostMatrix(TEXT, ANYARRAY, BOOLEAN, INTEGER, NUMERIC, NUMERIC)
IS 'pgr_bdAstarCostMatrix
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost], x1, y1, x2, y2
    - ARRAY [vertices identifiers]
- Optional Parameters:
    - directed := true
    - heuristic := 5
    - factor := 1
    - epsilon := 1
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_bdAstarCostMatrix.html
';


-------------
-------------
-- bdDijkstra
-------------
-------------


CREATE OR REPLACE FUNCTION _pgr_bdDijkstra(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- start_vids (required)
    ANYARRAY, -- end_vids (required)

    directed BOOLEAN,
    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.2
CREATE FUNCTION _pgr_bdDijkstra(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN,
    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION _pgr_bdDijkstra(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_bdDijkstra(TEXT, TEXT, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


-- ONE TO ONE
CREATE OR REPLACE FUNCTION pgr_bdDijkstra(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid
    BIGINT, -- to_vid

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE TO MANY
CREATE OR REPLACE FUNCTION pgr_bdDijkstra(
    TEXT,    -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT TRUE,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY TO ONE
CREATE OR REPLACE FUNCTION pgr_bdDijkstra(
    TEXT,    -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT TRUE,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



-- MANY TO MANY
CREATE OR REPLACE FUNCTION pgr_bdDijkstra(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT TRUE,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], directed, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_bdDijkstra(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT TRUE,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), _pgr_get_statement($2), directed, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_bdDijkstra(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_bdDijkstra(One to One)
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Optional Parameters:
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstra.html
';

COMMENT ON FUNCTION pgr_bdDijkstra(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_bdDijkstra(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstra.html
';

COMMENT ON FUNCTION pgr_bdDijkstra(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_bdDijkstra(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstra.html
';

COMMENT ON FUNCTION pgr_bdDijkstra(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_bdDijkstra(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstra.html
';

COMMENT ON FUNCTION pgr_bdDijkstra(TEXT, TEXT, BOOLEAN)
IS 'pgr_bdDijkstra(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstra.html
';



----------------------
-- pgr_bdDijkstraCost
----------------------


-- ONE TO ONE
CREATE OR REPLACE FUNCTION pgr_bdDijkstraCost(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4, true) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- ONE TO MANY
CREATE OR REPLACE FUNCTION pgr_bdDijkstraCost(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4, true) as a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- MANY TO ONE
CREATE OR REPLACE FUNCTION pgr_bdDijkstraCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4, true) as a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- MANY TO MANY
CREATE OR REPLACE FUNCTION pgr_bdDijkstraCost(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], directed, true) as a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_bdDijkstraCost(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), _pgr_get_statement($2), directed, true) as a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



COMMENT ON FUNCTION pgr_bdDijkstraCost(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_bdDijkstraCost(One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstraCost.html
';


COMMENT ON FUNCTION pgr_bdDijkstraCost(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_bdDijkstraCost(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstraCost.html
';


COMMENT ON FUNCTION pgr_bdDijkstraCost(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_bdDijkstraCost(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstraCost.html
';


COMMENT ON FUNCTION pgr_bdDijkstraCost(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_bdDijkstraCost(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstraCost.html
';

COMMENT ON FUNCTION pgr_bdDijkstraCost(TEXT, TEXT, BOOLEAN)
IS 'pgr_bdDijkstraCost(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bdDijkstraCost.html
';


-----------------------------
-- pgr_bdDijkstraCostMatrix
-----------------------------

CREATE OR REPLACE FUNCTION pgr_bdDijkstraCostMatrix(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- vids (required)

    directed BOOLEAN DEFAULT true,

    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT a.start_vid, a.end_vid, a.agg_cost
    FROM _pgr_bdDijkstra(_pgr_get_statement($1), $2::BIGINT[], $2::BIGINT[], $3, true) a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- COMMENT

COMMENT ON FUNCTION pgr_bdDijkstraCostMatrix(TEXT, ANYARRAY, BOOLEAN)
IS 'pgr_bdDijkstraCostMatrix
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - ARRAY [vertices identifiers]
- Optional Parameters
    - directed := true
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_bdDijkstraCostMatrix.html
';


CREATE OR REPLACE FUNCTION _pgr_array_reverse(anyarray) RETURNS anyarray AS $$
SELECT ARRAY(
    SELECT $1[i]
    FROM generate_subscripts($1,1) AS s(i)
    ORDER BY i DESC
);
$$ LANGUAGE 'sql' STRICT IMMUTABLE;



COMMENT ON FUNCTION _pgr_array_reverse(ANYARRAY)
IS 'pgRouting internal function';


--v3.6
CREATE FUNCTION _pgr_trspv4(
    TEXT,     -- edges SQL
    TEXT,     -- restrictions SQL
    ANYARRAY, -- departures
    ANYARRAY, -- destinations
    BOOLEAN,  -- directed

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE 'c' VOLATILE;

--v3.6
CREATE FUNCTION _pgr_trspv4(
    TEXT, -- edges SQL
    TEXT, -- restrictions SQL
    TEXT, -- combinations SQL
    BOOLEAN,  -- directed

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE 'c' VOLATILE;

COMMENT ON FUNCTION _pgr_trspv4(TEXT, TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_trspv4(TEXT, TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';



-- ONE to ONE
--v3.4
CREATE FUNCTION pgr_trsp(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  BIGINT, -- departure
  BIGINT, -- destination
  directed BOOLEAN DEFAULT true,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT
)
RETURNS SETOF record AS
$BODY$

  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_trspv4(
    _pgr_get_statement($1),
    _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[],
    ARRAY[$4]::BIGINT[],
    directed) AS a;

$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- ONE to MANY
--v3.4
CREATE FUNCTION pgr_trsp(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  BIGINT, -- departure
  ANYARRAY, -- destinations
  directed BOOLEAN DEFAULT true,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_trspv4(
    _pgr_get_statement($1),
    _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[],
    $4::BIGINT[],
    directed) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to ONE
--v3.4
CREATE FUNCTION pgr_trsp(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  ANYARRAY, -- departures
  BIGINT, -- destination
  directed BOOLEAN DEFAULT true,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_trspv4(
    _pgr_get_statement($1),
    _pgr_get_statement($2),
    $3::BIGINT[],
    ARRAY[$4]::BIGINT[],
    $5) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MANY to MANY
--v3.4
CREATE FUNCTION pgr_trsp(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  ANYARRAY, -- departures
  ANYARRAY, -- destinations
  directed BOOLEAN DEFAULT true,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_trspv4(
    _pgr_get_statement($1),
    _pgr_get_statement($2),
    $3::BIGINT[],
    $4::BIGINT[],
    $5) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- COMBINATIONS
--v3.4
CREATE FUNCTION pgr_trsp(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Combinations SQL
  directed BOOLEAN DEFAULT true,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_trspv4(
    _pgr_get_statement($1),
    _pgr_get_statement($2),
    _pgr_get_statement($3),
    $4) AS a;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_trsp(TEXT, TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_trsp(one to one)
- Parameters
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Departure vertex identifier
  - Destination vertex identifier
- Optional parameters
  - directed
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp.html
';

COMMENT ON FUNCTION pgr_trsp(TEXT, TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_trsp(one to many)
- Parameters
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Departure vertex identifier
  - Destinations ARRAY[vertices identifier]
- Optional parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp.html
';

COMMENT ON FUNCTION pgr_trsp(TEXT, TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_trsp(many to one)
- Parameters
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Departures ARRAY[vertices identifier]
  - Destination vertex identifier
- Optional parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp.html
';

COMMENT ON FUNCTION pgr_trsp(TEXT, TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_trsp(many to many)
- Parameters
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Departures ARRAY[vertices identifier]
  - Destinations ARRAY[vertices identifier]
- Optional parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp.html
';

COMMENT ON FUNCTION pgr_trsp(TEXT, TEXT, TEXT, BOOLEAN)
IS 'pgr_trsp(combinations)
- Parameters
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Combinations SQL with columns: source, target
- Optional parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp.html
';


--v4.0
CREATE FUNCTION _pgr_trsp_withPoints_v4(
    TEXT,  -- edges_sql
    TEXT,  -- restrictions_sql
    TEXT,  -- points_sql
    ANYARRAY,  -- start_vid
    ANYARRAY,  -- end_vids

    BOOLEAN, -- directed
    CHAR,    -- driving side
    BOOLEAN, -- details

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION _pgr_trsp_withPoints_v4(
    TEXT,  -- edges_sql
    TEXT,  -- restrictions_sql
    TEXT,  -- points_sql
    TEXT,  -- combinations_sql

    BOOLEAN, -- directed
    CHAR,    -- driving side
    BOOLEAN, -- details

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_trsp_withPoints_v4(TEXT, TEXT, TEXT, ANYARRAY, ANYARRAY, BOOLEAN, CHAR, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_trsp_withPoints_v4(TEXT, TEXT, TEXT, TEXT, BOOLEAN, CHAR, BOOLEAN)
IS 'pgRouting internal function';



--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  BIGINT, -- start_vid
  BIGINT, -- end_vid
  CHAR,   -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  ARRAY[$4]::BIGINT[], ARRAY[$5]::BIGINT[],  directed, $6, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  BIGINT, -- start_vid
  ANYARRAY, -- end_vids
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  ARRAY[$4]::BIGINT[], $5::BIGINT[], directed, $6, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  ANYARRAY, -- start_vids
  BIGINT, -- end_vid
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  $4::BIGINT[], ARRAY[$5]::BIGINT[], directed, $6, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  ANYARRAY, -- start_vids
  ANYARRAY, -- end_vids
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  $4::BIGINT[], $5::BIGINT[], directed, $6, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  TEXT, -- combinations SQL
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  _pgr_get_statement($4),
  directed, $5, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, BIGINT, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints (One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departure vertex/point identifier
  - Destination vertex/point identifier
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';


COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, BIGINT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departure vertex/point identifier
  - Destinations ARRAY[vertices/Points identifier]
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, ANYARRAY, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departures ARRAY[vertices/Points identifier]
  - Destination vertex/point identifier
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, ANYARRAY, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departures ARRAY[vertices/Points identifier]
  - Destinations ARRAY[vertices/Points identifier]
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, TEXT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, path, cost
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Combinations SQL with columns: source, target
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  BIGINT, -- start_vid
  BIGINT, -- end_vid

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  ARRAY[$4]::BIGINT[], ARRAY[$5]::BIGINT[],  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  BIGINT, -- start_vid
  ANYARRAY, -- end_vids

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  ARRAY[$4]::BIGINT[], $5::BIGINT[], directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  ANYARRAY, -- start_vids
  BIGINT, -- end_vid

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  $4::BIGINT[], ARRAY[$5]::BIGINT[], directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  ANYARRAY, -- start_vids
  ANYARRAY, -- end_vids

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  $4::BIGINT[], $5::BIGINT[], directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION pgr_trsp_withPoints(
  TEXT, -- Edges SQL
  TEXT, -- Restrictions SQL
  TEXT, -- Points SQL
  TEXT, -- combinations SQL

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
FROM _pgr_trsp_withPoints_v4(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  _pgr_get_statement($3),
  _pgr_get_statement($4),
  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, BIGINT, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints (One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departure vertex/point identifier
  - Destination vertex/point identifier
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';


COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, BIGINT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departure vertex/point identifier
  - Destinations ARRAY[vertices/Points identifier]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, ANYARRAY, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departures ARRAY[vertices/Points identifier]
  - Destination vertex/point identifier
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, ANYARRAY, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Departures ARRAY[vertices/Points identifier]
  - Destinations ARRAY[vertices/Points identifier]
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';

COMMENT ON FUNCTION pgr_trsp_withPoints(TEXT, TEXT, TEXT, TEXT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_trsp_withPoints(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: id, path, cost
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Combinations SQL with columns: source, target
- Optional Parameters:
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trsp_withPoints.html
';


------------------
-- pgr_trspVia
------------------

CREATE OR REPLACE FUNCTION _pgr_trspVia(
  TEXT, -- edges
  TEXT, -- restrictions
  ANYARRAY, -- via
  BOOLEAN,  -- directed
  BOOLEAN,  -- strict
  BOOLEAN,  -- U_turn_on_edge

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_trspVia(TEXT, TEXT, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


--v3.4
CREATE FUNCTION pgr_trspVia(
  TEXT,     -- edges sql
  TEXT,     -- restrictions sql
  ANYARRAY, -- via vids

  directed BOOLEAN DEFAULT true,
  strict BOOLEAN DEFAULT false,
  U_turn_on_edge BOOLEAN DEFAULT true,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost, route_agg_cost
FROM _pgr_trspVia(
  _pgr_get_statement($1),
  _pgr_get_statement($2),
  $3 , $4, $5, $6);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_trspVia(TEXT, TEXT, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_trspVia
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - ARRAY[via vertices identifiers]
- Optional Parameters
  - directed := true
  - strict := false
  - U_turn_on_edge := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trspVia.html
';


--v4.0
CREATE FUNCTION _pgr_trspVia_withPoints_v4(
  TEXT,     -- edges
  TEXT,     -- restrictions
  TEXT,     -- points
  ANYARRAY, -- via

  BOOLEAN,  -- directed

  BOOLEAN,  -- strict
  BOOLEAN,  -- U_turn_on_edge

  CHAR,     -- driving side
  BOOLEAN,  -- details

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_trspVia_withPoints_v4(TEXT, TEXT, TEXT, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN, CHAR, BOOLEAN)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION pgr_trspVia_withPoints(
  TEXT,     -- edges
  TEXT,     -- restrictions
  TEXT,     -- points
  ANYARRAY, -- via vids
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,

  -- via parameters
  strict BOOLEAN DEFAULT false,
  U_turn_on_edge BOOLEAN DEFAULT true,

  -- withPoints parameters
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost, route_agg_cost
  FROM _pgr_trspVia_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3), $4,
    directed, strict, u_turn_on_edge, $5, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_trspVia_withPoints(TEXT, TEXT, TEXT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_trspVia_withPoints
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - ARRAY[via vertices identifiers]
  - driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - strict => false
  - U_turn_on_edge => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trspVia_withPoints.html
';

--v4.0
CREATE FUNCTION pgr_trspVia_withPoints(
  TEXT,     -- edges
  TEXT,     -- restrictions
  TEXT,     -- points
  ANYARRAY, -- via vids

  directed BOOLEAN DEFAULT true,

  -- via parameters
  strict BOOLEAN DEFAULT false,
  U_turn_on_edge BOOLEAN DEFAULT true,

  -- withPoints parameters
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost, route_agg_cost
  FROM _pgr_trspVia_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3), $4,
    directed, strict, u_turn_on_edge, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_trspVia_withPoints(TEXT, TEXT, TEXT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_trspVia_withPoints
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Restrictions SQL with columns: cost, path
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - ARRAY[via vertices identifiers]
- Optional Parameters
  - directed => true
  - strict => false
  - U_turn_on_edge => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_trspVia_withPoints.html
';


--------------
--------------
-- maxflow
--------------
--------------


CREATE OR REPLACE FUNCTION _pgr_maxflow(
    edges_sql TEXT,
    sources ANYARRAY,
    targets ANYARRAY,

    algorithm INTEGER DEFAULT 1,
    only_flow BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT edge_id BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT
    )
  RETURNS SETOF RECORD AS
 'MODULE_PATHNAME'
    LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.2
CREATE FUNCTION _pgr_maxflow(
    edges_sql TEXT,
    combinations_sql TEXT,

    algorithm INTEGER DEFAULT 1,
    only_flow BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT edge_id BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT
    )
  RETURNS SETOF RECORD AS
 'MODULE_PATHNAME'
    LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_maxflow(TEXT, ANYARRAY, ANYARRAY, INTEGER, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_maxflow(TEXT, TEXT, INTEGER, BOOLEAN)
IS 'pgRouting internal function';


------------------------
------------------------
-- costFlow
------------------------
------------------------


------------------------
-- _pgr_maxFlowMinCost
------------------------


CREATE OR REPLACE FUNCTION _pgr_maxFlowMinCost(
    edges_sql TEXT,
    sources ANYARRAY,
    targets ANYARRAY,

    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;

--v3.2
CREATE FUNCTION _pgr_maxFlowMinCost(
    edges_sql TEXT,
    combinations_sql TEXT,
    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_maxFlowMinCost(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_maxFlowMinCost(TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';


-------------------
-- pgr_edmondsKarp
-------------------

-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_edmondsKarp(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SEtoF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], 3);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_edmondsKarp(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SEtoF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], 3);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_edmondsKarp(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT, -- to_vid (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SEtoF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], 3);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_edmondsKarp(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SEtoF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], 3);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_edmondsKarp(
    TEXT, -- edges_sql (required)
    TEXT, -- combinations_sql (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SEtoF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), _pgr_get_statement($2), 3);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_edmondsKarp(TEXT, BIGINT, BIGINT)
IS 'pgr_edmondsKarp(One to One)
- Directed graph
- Parameters:
   - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
   - From vertex
   - to vertex
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_edmondsKarp.html
';


COMMENT ON FUNCTION pgr_edmondsKarp(TEXT, BIGINT, ANYARRAY)
IS 'pgr_edmondsKarp(One to Many)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From vertex
  - to ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edmondsKarp.html
';


COMMENT ON FUNCTION pgr_edmondsKarp(TEXT, ANYARRAY, BIGINT)
IS 'pgr_edmondsKarp(Many to One)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From ARRAY[vertices identifiers]
  - to vertex
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edmondsKarp.html
';


COMMENT ON FUNCTION pgr_edmondsKarp(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_edmondsKarp(Many to Many)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From ARRAY[vertices identifiers]
  - to ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edmondsKarp.html
';

COMMENT ON FUNCTION pgr_edmondsKarp(TEXT, TEXT)
IS 'pgr_edmondsKarp(Combinations)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edmondsKarp.html
';


------------------------------------
-- pgr_boykovKolmogorov
------------------------------------


-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_boykovKolmogorov(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], 2);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_boykovKolmogorov(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], 2);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_boykovKolmogorov(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT, -- to_vid (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], 2);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_boykovKolmogorov(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], 2);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_boykovKolmogorov(
    TEXT, -- edges_sql (required)
    TEXT, -- combinations_sql (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), _pgr_get_statement($2), 2);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_boykovKolmogorov(TEXT, BIGINT, BIGINT)
IS 'pgr_boykovKolmogorov(One to One)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from vertex
  - to vertex
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_boykovKolmogorov.html
';


COMMENT ON FUNCTION pgr_boykovKolmogorov(TEXT, BIGINT, ANYARRAY)
IS 'pgr_boykovKolmogorov(One to Many)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from vertex
  - to ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_boykovKolmogorov.html
';


COMMENT ON FUNCTION pgr_boykovKolmogorov(TEXT, ANYARRAY, BIGINT)
IS 'pgr_boykovKolmogorov(Many to One)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from ARRAY[vertices identifiers]
  - to vertex
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_boykovKolmogorov.html
';


COMMENT ON FUNCTION pgr_boykovKolmogorov(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_boykovKolmogorov(Many to Many)
 - Directed graph
 - Parameters:
   - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
   - from ARRAY[vertices identifiers]
   - to ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_boykovKolmogorov.html
';

COMMENT ON FUNCTION pgr_boykovKolmogorov(TEXT, TEXT)
IS 'pgr_boykovKolmogorov(Combinations)
 - Directed graph
 - Parameters:
   - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
   - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_boykovKolmogorov.html
';


------------------------------------
-- pgr_pushRelabel
------------------------------------


-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_pushRelabel(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], 1);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_pushRelabel(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], 1);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_pushRelabel(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT, -- to_vid (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], 1);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_pushRelabel(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], 1);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_pushRelabel(
    TEXT, -- edges_sql (required)
    TEXT, -- combinations_sql (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT)
  RETURNS SETOF RECORD AS
  $BODY$
        SELECT seq, edge_id, source, target, flow, residual_capacity
        FROM _pgr_maxflow(_pgr_get_statement($1), _pgr_get_statement($2), 1);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_pushRelabel(TEXT, BIGINT, BIGINT)
IS 'pgr_pushRelabel(One to One)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From vertex identifier
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_pushRelabel.html
';


COMMENT ON FUNCTION pgr_pushRelabel(TEXT, BIGINT, ANYARRAY)
IS 'pgr_pushRelabel(One to Many)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From vertex identifie
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_pushRelabel.html
';


COMMENT ON FUNCTION pgr_pushRelabel(TEXT, ANYARRAY, BIGINT)
IS 'pgr_pushRelabel(Many to One)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From ARRAY[vertices identifiers]
  - To vertex identifie
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_pushRelabel.html
';


COMMENT ON FUNCTION pgr_pushRelabel(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_pushRelabel(Many to Many)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_pushRelabel.html
';

COMMENT ON FUNCTION pgr_pushRelabel(TEXT, TEXT)
IS 'pgr_pushRelabel(Combinations)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_pushRelabel.html
';


--v4.0
CREATE FUNCTION _pgr_maxCardinalityMatch_v4(
    edges_sql TEXT,
    OUT edge BIGINT)
RETURNS SETOF BIGINT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_maxCardinalityMatch_v4(TEXT)
IS 'pgRouting internal function';


--v3.4
CREATE FUNCTION pgr_maxCardinalityMatch(
  TEXT, -- edges_sql (required)

  OUT edge BIGINT)
RETURNS SETOF BIGINT AS
$BODY$
SELECT edge
FROM _pgr_maxCardinalityMatch_v4(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_maxCardinalityMatch(TEXT)
IS 'pgr_maxCardinalityMatch
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxCardinalityMatch.html
';


------------------------
-- pgr_edgeDisjointPaths
------------------------

CREATE OR REPLACE FUNCTION _pgr_edgeDisjointPaths(
    TEXT,
    ANYARRAY,
    ANYARRAY,

    directed BOOLEAN,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SEtoF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

--v3.2
CREATE FUNCTION _pgr_edgeDisjointPaths(
    TEXT,
    TEXT,

    directed BOOLEAN,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SEtoF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_edgeDisjointPaths(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_edgeDisjointPaths(TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';


-- ONE to ONE
--v4.0
CREATE FUNCTION pgr_edgeDisjointPaths(
    TEXT,   --edges_sql (required)
    BIGINT, -- From_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edgeDisjointPaths(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
--v4.0
CREATE FUNCTION pgr_edgeDisjointPaths(
    TEXT,     --edges_sql (required)
    BIGINT,   -- From_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edgeDisjointPaths(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
--v4.0
CREATE FUNCTION pgr_edgeDisjointPaths(
    TEXT,     --edges_sql (required)
    ANYARRAY, -- From_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, end_vid, start_vid, node, edge, cost, agg_cost
    FROM _pgr_edgeDisjointPaths(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_edgeDisjointPaths(
    TEXT,     --edges_sql (required)
    ANYARRAY, -- From_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edgeDisjointPaths(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_edgeDisjointPaths(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edgeDisjointPaths(_pgr_get_statement($1), _pgr_get_statement($2), $3)
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_edgeDisjointPaths(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_edgeDisjointPaths(One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edgeDisjointPaths.html
';


COMMENT ON FUNCTION pgr_edgeDisjointPaths(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_edgeDisjointPaths(One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edgeDisjointPaths.html
';


COMMENT ON FUNCTION pgr_edgeDisjointPaths(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_edgeDisjointPaths(Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edgeDisjointPaths.html
';


COMMENT ON FUNCTION pgr_edgeDisjointPaths(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_edgeDisjointPaths(Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edgeDisjointPaths.html
';

COMMENT ON FUNCTION pgr_edgeDisjointPaths(TEXT, TEXT, BOOLEAN)
IS 'pgr_edgeDisjointPaths(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_edgeDisjointPaths.html
';


------------------------
-- pgr_maxFlowMinCost
------------------------

--    ONE TO ONE
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost(
    TEXT,   -- edges_sql (required)
    BIGINT,   -- source (required)
    BIGINT,   -- target (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, edge, source, target, flow, residual_capacity, cost, agg_cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], only_cost := false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


--    ONE TO MANY
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost(
    TEXT,   -- edges_sql (required)
    BIGINT, -- sources (required)
    ANYARRAY,   -- target (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, edge, source, target, flow, residual_capacity, cost, agg_cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], only_cost := false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


--    MANY TO ONE
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost(
    TEXT,   -- edges_sql (required)
    ANYARRAY,   -- source (required)
    BIGINT, -- targets (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, edge, source, target, flow, residual_capacity, cost, agg_cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], only_cost := false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--    MANY TO MANY
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost(
    TEXT,   -- edges_sql (required)
    ANYARRAY, -- sources (required)
    ANYARRAY, -- targets (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, edge, source, target, flow, residual_capacity, cost, agg_cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], only_cost := false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


-- COMBINATIONS
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost(
    TEXT,   -- edges_sql (required)
    TEXT,   -- combinations_sql (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT flow BIGINT,
    OUT residual_capacity BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, edge, source, target, flow, residual_capacity, cost, agg_cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), _pgr_get_statement($2), only_cost := false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;



COMMENT ON FUNCTION pgr_maxFlowMinCost(TEXT, BIGINT, BIGINT)
IS 'pgr_maxFlowMinCost(One to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost(TEXT, BIGINT, ANYARRAY)
IS 'pgr_maxFlowMinCost(One to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost(TEXT, ANYARRAY, BIGINT)
IS 'pgr_maxFlowMinCost(Many to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]vertex identifier
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_maxFlowMinCost(Many to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost(TEXT, TEXT)
IS 'pgr_maxFlowMinCost(Combinations)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost.html
';


CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost_Cost(
    TEXT,   -- edges_sql (required)
    BIGINT,   -- source (required)
    BIGINT)   -- target (required)

RETURNS FLOAT AS
$BODY$
    SELECT cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], only_cost := true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;


--    ONE TO MANY
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost_Cost(
    TEXT,   -- edges_sql (required)
    BIGINT,   -- source (required)
    ANYARRAY) -- targets (required)

RETURNS FLOAT AS
$BODY$
    SELECT cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], only_cost := true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;


--    MANY TO ONE
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost_Cost(
    TEXT,   -- edges_sql (required)
    ANYARRAY, -- sources (required)
    BIGINT)   -- target (required)

RETURNS FLOAT AS
$BODY$
    SELECT cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], only_cost := true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;


--    MANY TO MANY
CREATE OR REPLACE FUNCTION pgr_maxFlowMinCost_Cost(
    TEXT,   -- edges_sql (required)
    ANYARRAY, -- sources (required)
    ANYARRAY) -- targets (required)

RETURNS FLOAT AS
$BODY$
    SELECT cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], only_cost := true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_maxFlowMinCost_Cost(
    TEXT,   -- edges_sql (required)
    TEXT)   -- combinations_sql (required)

RETURNS FLOAT AS
$BODY$
    SELECT cost
    FROM _pgr_maxFlowMinCost(_pgr_get_statement($1), _pgr_get_statement($2), only_cost := true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;



COMMENT ON FUNCTION pgr_maxFlowMinCost_Cost(TEXT, BIGINT, BIGINT)
IS 'pgr_maxFlowMinCost_Cost (One to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost_Cost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost_Cost(TEXT, BIGINT, ANYARRAY)
IS 'pgr_maxFlowMinCost_Cost(One to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost_Cost.html
  ';

COMMENT ON FUNCTION pgr_maxFlowMinCost_Cost(TEXT, ANYARRAY, BIGINT)
IS 'pgr_maxFlowMinCost_Cost (Many to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost_Cost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost_Cost(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_maxFlowMinCost_Cost (Many to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost_Cost.html
';

COMMENT ON FUNCTION pgr_maxFlowMinCost_Cost(TEXT, TEXT)
IS 'pgr_maxFlowMinCost_Cost (Combinations)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlowMinCost_Cost.html
';


---------------
-- pgr_maxFlow
---------------


-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_maxFlow(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT) -- to_vid (required)
  RETURNS BIGINT AS
  $BODY$
        SELECT flow
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], algorithm := 1, only_flow := true);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000;


-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_maxFlow(
    TEXT, -- edges_sql (required)
    BIGINT, -- from_vid (required)
    ANYARRAY) -- to_vids (required)
  RETURNS BIGINT AS
  $BODY$
        SELECT flow
        FROM _pgr_maxflow(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], algorithm := 1, only_flow := true);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000;


-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_maxFlow(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT) -- to_vid (required)
  RETURNS BIGINT AS
  $BODY$
        SELECT flow
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], algorithm := 1, only_flow := true);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_maxFlow(
    TEXT, -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY) -- to_vids (required)
  RETURNS BIGINT AS
  $BODY$
        SELECT flow
        FROM _pgr_maxflow(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], algorithm := 1, only_flow := true);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_maxFlow(
    TEXT, -- edges_sql (required)
    TEXT) -- combinations_sql (required)
  RETURNS BIGINT AS
  $BODY$
        SELECT flow
        FROM _pgr_maxflow(_pgr_get_statement($1), _pgr_get_statement($2), algorithm := 1, only_flow := true);
  $BODY$
  LANGUAGE SQL VOLATILE STRICT
COST 10000;




COMMENT ON FUNCTION pgr_maxFlow(TEXT, BIGINT, BIGINT)
IS 'pgr_maxFlow(One to One)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from vertex
  - to vertex
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlow.html
';

COMMENT ON FUNCTION pgr_maxFlow(TEXT, BIGINT, ANYARRAY)
IS 'pgr_maxFlow(One to Many)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from vertex
  - to ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlow.html
';

COMMENT ON FUNCTION pgr_maxFlow(TEXT, ANYARRAY, BIGINT)
IS 'pgr_maxFlow(Many to One)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from ARRAY[vertices identifiers]
  - to vertex
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlow.html
';

COMMENT ON FUNCTION pgr_maxFlow(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_maxFlow(Many to Many)
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - from ARRAY[vertices identifiers]
  - to ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlow.html
';

COMMENT ON FUNCTION pgr_maxFlow(TEXT, TEXT)
IS 'pgr_maxFlow(Combinations)
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, capacity [,reverse_capacity]
  - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_maxFlow.html
';


--------------------
--------------------
-- contraction
--------------------
--------------------

CREATE OR REPLACE FUNCTION _pgr_contraction(
    edges_sql TEXT,
    contraction_order BIGINT[],
    max_cycles INTEGER DEFAULT 1,
    forbidden_vertices BIGINT[] DEFAULT ARRAY[]::BIGINT[],
    directed BOOLEAN DEFAULT true,

    OUT type TEXT,
    OUT id BIGINT,
    OUT contracted_vertices BIGINT[],
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_contraction(TEXT, BIGINT[], INTEGER, BIGINT[], BOOLEAN)
IS 'pgRouting internal function';


--v3.8
CREATE FUNCTION pgr_contraction(
    TEXT,     -- edges_sql (required)
    directed BOOLEAN DEFAULT true,
    methods INTEGER[] DEFAULT ARRAY[1,2]::INTEGER[],
    cycles INTEGER DEFAULT 1,
    forbidden BIGINT[] DEFAULT ARRAY[]::BIGINT[],

    OUT type TEXT,
    OUT id BIGINT,
    OUT contracted_vertices BIGINT[],
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT type, id, contracted_vertices, source, target, cost
  FROM _pgr_contraction(_pgr_get_statement($1), methods::BIGINT[], cycles, forbidden, directed);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_contraction(TEXT, BOOLEAN, INTEGER[], INTEGER, BIGINT[])
IS 'pgr_contraction
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Optional Parameters
    - directed := true
    - methods := ARRAY[1,2]
    - cycles := 1
    - forbidden := ARRAY[]::BIGINT[]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_contraction.html
';



----------------------------
----------------------------
-- contractionHierarchies
----------------------------
----------------------------

CREATE OR REPLACE FUNCTION _pgr_contractionhierarchies(
    edges_sql TEXT,
    forbidden_vertices BIGINT[],
    directed BOOLEAN,

    OUT type TEXT,
    OUT id BIGINT,
    OUT contracted_vertices BIGINT[],
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT,
    OUT metric BIGINT,
    OUT vertex_order BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_contractionhierarchies(TEXT, BIGINT[], BOOLEAN)
IS 'pgRouting internal function';


---------------------------
---------------------------
-- contractionHierarchies
---------------------------
---------------------------

--------------------------------
-- pgr_contractionHierarchies
--------------------------------


--v3.8
CREATE FUNCTION pgr_contractionHierarchies(
    TEXT,     -- edges_sql (required)
    directed BOOLEAN DEFAULT true,
    forbidden BIGINT[] DEFAULT ARRAY[]::BIGINT[],

    OUT type TEXT,
    OUT id BIGINT,
    OUT contracted_vertices BIGINT[],
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT,
    OUT metric BIGINT,
    OUT vertex_order BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT type, id, contracted_vertices, source, target, cost, metric, vertex_order
    FROM _pgr_contractionhierarchies(_pgr_get_statement($1), $3::BIGINT[], $2);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_contractionHierarchies(TEXT, BOOLEAN, BIGINT[])
IS 'pgr_contractionHierarchies
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Optional Parameters
    - forbidden := ARRAY[]::BIGINT[]
    - directed := true
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_contractionHierarchies.html
';


--v3.8
CREATE FUNCTION pgr_contractionDeadEnd(
    TEXT,     -- edges_sql (required)

    directed BOOLEAN DEFAULT true,
    forbidden BIGINT[] DEFAULT ARRAY[]::BIGINT[],

    OUT type TEXT,
    OUT id BIGINT,
    OUT contracted_vertices BIGINT[],
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT type, id, contracted_vertices, source, target, cost
    FROM _pgr_contraction(_pgr_get_statement($1), ARRAY[1]::BIGINT[], 1, $3, $2);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_contractionDeadEnd(TEXT, BOOLEAN, BIGINT[])
IS 'pgr_contractionDeadEnd
- PROPOSED
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Optional Parameters
    - directed := true
    - forbidden := ARRAY[]::BIGINT[]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_contractionDeadEnd.html
';


--v3.8
CREATE FUNCTION pgr_contractionLinear(
    TEXT,     -- edges_sql (required)

    directed BOOLEAN DEFAULT true,
    forbidden BIGINT[] DEFAULT ARRAY[]::BIGINT[],

    OUT type TEXT,
    OUT id BIGINT,
    OUT contracted_vertices BIGINT[],
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT type, id, contracted_vertices, source, target, cost
    FROM _pgr_contraction(_pgr_get_statement($1), ARRAY[2]::BIGINT[], 1, $3, $2);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_contractionLinear(TEXT, BOOLEAN, BIGINT[])
IS 'pgr_contractionLinear
- PROPOSED
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Optional Parameters
    - directed := true
    - forbidden := ARRAY[]::BIGINT[]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_contractionLinear.html
';


CREATE OR REPLACE FUNCTION _pgr_pickDeliver(
    TEXT, -- orders_sql
    TEXT, -- vehicles_sql
    TEXT, -- matrix_cell_sql

    factor FLOAT DEFAULT 1,
    max_cycles INTEGER DEFAULT 10,
    initial_sol INTEGER DEFAULT 4,

    OUT seq INTEGER,
    OUT vehicle_seq INTEGER,
    OUT vehicle_id BIGINT,
    OUT stop_seq INTEGER,
    OUT stop_type INTEGER,
    OUT stop_id BIGINT,
    OUT order_id BIGINT,
    OUT cargo FLOAT,
    OUT travel_time FLOAT,
    OUT arrival_time FLOAT,
    OUT wait_time FLOAT,
    OUT service_time FLOAT,
    OUT departure_time FLOAT)
RETURNS SETOF RECORD AS
 'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_pickDeliver(TEXT, TEXT, TEXT, FLOAT, INTEGER, INTEGER)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_pickDeliver(
    TEXT, -- orders_sql (required)
    TEXT, -- vehicles_sql (required)
    TEXT, -- matrix_cell_sql

    factor FLOAT DEFAULT 1,
    max_cycles INTEGER DEFAULT 10,
    initial_sol INTEGER DEFAULT 4,

    OUT seq INTEGER,
    OUT vehicle_seq INTEGER,
    OUT vehicle_id BIGINT,
    OUT stop_seq INTEGER,
    OUT stop_type INTEGER,
    OUT stop_id BIGINT,
    OUT order_id BIGINT,
    OUT cargo FLOAT,
    OUT travel_time FLOAT,
    OUT arrival_time FLOAT,
    OUT wait_time FLOAT,
    OUT service_time FLOAT,
    OUT departure_time FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, vehicle_seq, vehicle_id, stop_seq, stop_type, stop_id, order_id, cargo, travel_time, arrival_time,
           wait_time, service_time, departure_time
    FROM _pgr_pickDeliver(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_pickDeliver(TEXT, TEXT, TEXT, FLOAT, INTEGER, INTEGER)
IS 'pgr_pickDeliver
 - EXPERIMENTAL
 - Parameters:
   - orders SQL with columns:
     - id, demand, p_node_id, p_open, p_close, d_node_id, d_open, d_close
     - optional columns:
        - p_service := 0
        - d_service := 0
   - vehicles SQL with columns:
     - id, capacity, start_open, start_close
     - optional columns:
        - speed := 1
        - start_service := 0
        - end_open := start_open
        - end_close := start_close
        - end_service := 0
   - Matrix
     - start_vid
     - end_vid
     - agg_cost
 - Optional Parameters:
   - factor: default := 1
   - max_cycles: default := 10
   - initial_sol: default := 4
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_pickDeliver.html
';


CREATE OR REPLACE FUNCTION _pgr_pickDeliverEuclidean (
    TEXT, -- orders_sql
    TEXT, -- vehicles_sql

    factor FLOAT DEFAULT 1,
    max_cycles INTEGER DEFAULT 10,
    initial_sol INTEGER DEFAULT 4,

    OUT seq INTEGER,
    OUT vehicle_seq INTEGER,
    OUT vehicle_id BIGINT,
    OUT stop_seq INTEGER,
    OUT stop_type INTEGER,
    OUT order_id BIGINT,
    OUT cargo FLOAT,
    OUT travel_time FLOAT,
    OUT arrival_time FLOAT,
    OUT wait_time FLOAT,
    OUT service_time FLOAT,
    OUT departure_time FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_pickDeliverEuclidean(TEXT, TEXT, FLOAT, INTEGER, INTEGER)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_pickDeliverEuclidean(
    TEXT, -- orders_sql (required)
    TEXT, -- vehicles_sql (required)

    factor FLOAT DEFAULT 1,
    max_cycles INTEGER DEFAULT 10,
    initial_sol INTEGER DEFAULT 4,

    OUT seq INTEGER,
    OUT vehicle_seq INTEGER,
    OUT vehicle_id BIGINT,
    OUT stop_seq INTEGER,
    OUT stop_type INTEGER,
    OUT order_id BIGINT,
    OUT cargo FLOAT,
    OUT travel_time FLOAT,
    OUT arrival_time FLOAT,
    OUT wait_time FLOAT,
    OUT service_time FLOAT,
    OUT departure_time FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, vehicle_seq, vehicle_id, stop_seq, stop_type, order_id, cargo, travel_time, arrival_time,
           wait_time, service_time, departure_time
    FROM _pgr_pickDeliverEuclidean(_pgr_get_statement($1), _pgr_get_statement($2), $3, $4, $5);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_pickDeliverEuclidean(TEXT, TEXT, FLOAT, INTEGER, INTEGER)
IS 'pgr_pickDeliverEuclidean
 - EXPERIMENTAL
 - Parameters:
   - orders SQL with columns:
     - id, demand, p_x, p_t, d_x, d_y, p_open, p_close, d_open, d_close
     - optional columns:
       - p_service := 0
       - d_service := 0
   - vehicles SQL with columns:
     - id, start_x, start_y, capacity, start_open, start_close
     - optional columns:
       - speed := 1
       - start_service := 0
       - end_x := start_x
       - end_y := start_y
       - end_open := start_open
       - end_close := start_close
       - end_service := 0
 - Optional Parameters:
   - factor: default := 1
   - max_cycles: default := 10
   - initial_sol: default := 4
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_pickDeliver.html
';


--------------------
-- _pgr_vrpOneDepot
--------------------


CREATE OR REPLACE FUNCTION _pgr_vrpOneDepot(
    TEXT, -- customers_sql
    TEXT, -- vehicles_sql
    TEXT, -- matrix_sql
    INTEGER, -- depot_id

    OUT seq INTEGER,
    OUT vehicle_seq INTEGER,
    OUT vehicle_id BIGINT,
    OUT stop_seq INTEGER,
    OUT stop_type INTEGER,
    OUT stop_id BIGINT,
    OUT order_id BIGINT,
    OUT cargo FLOAT,
    OUT travel_time FLOAT,
    OUT arrival_time FLOAT,
    OUT wait_time FLOAT,
    OUT service_time FLOAT,
    OUT departure_time FLOAT
)
RETURNS SETOF RECORD AS
$BODY$
DECLARE
orders_sql TEXT;
trucks_sql TEXT;
matrix_sql TEXT;
final_sql TEXT;
BEGIN

    orders_sql = $$WITH
    vrp_orders AS ($$ || $1 || $$ ),
    pickups AS (
        SELECT id, x AS p_x, y AS p_y, open_time AS p_open, close_time AS p_close, service_time AS p_service
        FROM vrp_orders
        WHERE id = $$ || $4 || $$
    )
    SELECT vrp_orders.id AS id, order_unit AS demand, pickups.id AS p_node_id, p_x, p_y, p_open, p_close, p_service,
    vrp_orders.id AS d_node_id, x AS d_x, y AS d_y, open_time AS d_open, close_time AS d_close, service_time AS d_service
    FROM vrp_orders, pickups
    WHERE vrp_orders.id != $$ || $4;


    trucks_sql = $$ WITH
    vrp_orders AS ($$ || $1 || $$ ),
    vrp_vehicles AS ($$ || $2 || $$ ),
    starts AS (
        SELECT id AS start_node_id, x AS start_x, y AS start_y, open_time AS start_open, close_time AS start_close, service_time AS start_service
        FROM vrp_orders
        WHERE id = $$ || $4 || $$
    )
    SELECT vehicle_id AS id, capacity, starts.* FROM vrp_vehicles, starts;
    $$;

    final_sql = '
    SELECT seq, vehicle_seq, vehicle_id, stop_seq, stop_type, stop_id, order_id, cargo, travel_time, arrival_time,
           wait_time, service_time, departure_time
    FROM _pgr_pickDeliver(
            $$' || orders_sql || '$$,
            $$' || trucks_sql || '$$,
            $$' || $3 || '$$,
            max_cycles := 3,
            initial_sol := 7 ); ';

    RAISE DEBUG '%', orders_sql;
    RAISE DEBUG '%', trucks_sql;
    RAISE DEBUG '%', $3;
    RAISE DEBUG '%', final_sql;

    RETURN QUERY EXECUTE final_sql;
END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;




COMMENT ON FUNCTION _pgr_vrpOneDepot(TEXT, TEXT, TEXT, INTEGER)
IS 'pgRouting internal function';

-----------------------------------------------------------------------
-- Core function for vrp with single depot computation
-- See README for description
-----------------------------------------------------------------------


--------------------
-- pgr_vrpOneDepot
--------------------


CREATE OR REPLACE FUNCTION pgr_vrpOneDepot(
	text,  -- order_sql
	text, -- vehicle_sql
	text, -- cost_sql
	integer, -- depot_id

	OUT oid integer,
	OUT opos integer,
	OUT vid integer,
	OUT tarrival integer,
	OUT tdepart integer)
RETURNS SETOF RECORD AS
$BODY$
    SELECT order_id::INTEGER, stop_seq::INTEGER, vehicle_id::INTEGER, arrival_time::INTEGER, departure_time::INTEGER
    FROM _pgr_vrpOneDepot($1, $2,
       '
            SELECT src_id AS start_vid, dest_id AS end_vid, traveltime AS agg_cost FROM ('||$3||') AS a
       ',
       $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_vrpOneDepot(TEXT, TEXT, TEXT, INTEGER)
IS 'pgr_vrpOneDepot
- EXPERIMENTAL
- Parameters
  - orders SQL with columns: id, x, y, order_unit, open_time, close_time, service_time
  - vehicle SQL with columns: vehicle_id, capacity, case_no
  - cost SQL with columns: src_id, dest_id, cost, distance, traveltime
  - depot id
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_vrpOneDepot.html
';


--v4.0
CREATE FUNCTION _pgr_withPoints_v4(
    TEXT, -- edges
    TEXT, -- points

    ANYARRAY, -- departures
    ANYARRAY, -- arrivals

    BOOLEAN, --directed
    CHAR,    -- driving_side
    BOOLEAN, -- details

    BOOLEAN, -- only_cost
    BOOLEAN, -- normal

    BIGINT,  -- n_goals
    BOOLEAN, -- global

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_withPoints_v4(TEXT, TEXT, ANYARRAY, ANYARRAY, BOOLEAN, CHAR, BOOLEAN, BOOLEAN, BOOLEAN,
  BIGINT, BOOLEAN)
IS 'pgRouting internal function';

--v4.0
CREATE FUNCTION _pgr_withPoints_v4(
    TEXT, -- edges
    TEXT, -- points
    TEXT, -- combinations

    BOOLEAN, --directed
    CHAR,    -- driving_side
    BOOLEAN, -- details
    BOOLEAN, -- only_cost

    BIGINT,  -- n_goals
    BOOLEAN, -- global

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_withPoints_v4(TEXT, TEXT, TEXT, BOOLEAN, CHAR, BOOLEAN, BOOLEAN, BIGINT, BOOLEAN)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION _pgr_withPoints(
    edges_sql TEXT,
    points_sql TEXT,
    start_pids ANYARRAY,
    end_pids ANYARRAY,
    directed BOOLEAN,
    driving_side CHAR,
    details BOOLEAN,

    only_cost BOOLEAN DEFAULT false, -- gets path
    normal BOOLEAN DEFAULT true, -- false for many to onu


    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_pid BIGINT,
    OUT end_pid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c VOLATILE;


--v3.2
CREATE FUNCTION _pgr_withPoints(
    edges_sql TEXT,
    points_sql TEXT,
    combinations_sql TEXT,

    directed BOOLEAN,
    driving_side CHAR,
    details BOOLEAN,

    only_cost BOOLEAN DEFAULT false,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_pid BIGINT,
    OUT end_pid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_withPoints(TEXT, TEXT, ANYARRAY, ANYARRAY, BOOLEAN, CHAR, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgRouting deprecated internal function';

COMMENT ON FUNCTION _pgr_withPoints(TEXT, TEXT, TEXT, BOOLEAN, CHAR, BOOLEAN, BOOLEAN)
IS 'pgRouting deprecated internal function';


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,   -- edges
  TEXT,   -- points
  BIGINT, -- start
  BIGINT, -- end
  CHAR,   -- driving side
  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[],
    directed, $5, details, false, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  BIGINT,   -- start
  ANYARRAY, -- ends
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[], $4::BIGINT[],
    directed, $5, details, false, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- start
  BIGINT,   -- ends
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    $3::BIGINT[], ARRAY[$4]::BIGINT[],
    directed, $5, details, false, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- start
  ANYARRAY, -- ends
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    $3::BIGINT[], $4::BIGINT[],
    directed, $5, details, false, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  TEXT,     -- combinations
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3),
    directed, $4, details, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, BIGINT, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertex/point identifier
  - To vertex/point identifier
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, BIGINT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertex/point identifier
  - To ARRAY[vertices/points identifiers]
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, ANYARRAY, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To vertex/point identifier
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, ANYARRAY, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To ARRAY[vertices/points identifiers]
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, TEXT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Combinations SQL with columns: source, target
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,   -- edges
  TEXT,   -- points
  BIGINT, -- start
  BIGINT, -- end
  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[],
    directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details, false, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  BIGINT,   -- start
  ANYARRAY, -- ends

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    ARRAY[$3]::BIGINT[], $4::BIGINT[],
    directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details, false, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- start
  BIGINT,   -- ends

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    $3::BIGINT[], ARRAY[$4]::BIGINT[],
    directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details, false, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- start
  ANYARRAY, -- ends

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2),
    $3::BIGINT[], $4::BIGINT[],
    directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details, false, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v4.0
CREATE FUNCTION pgr_withPoints(
  TEXT,     -- edges
  TEXT,     -- points
  TEXT,     -- combinations

  directed BOOLEAN DEFAULT true,
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
  FROM _pgr_withPoints_v4(
    _pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3),
    directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), details, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, BIGINT, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertex/point identifier
  - To vertex/point identifier
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, BIGINT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertex/point identifier
  - To ARRAY[vertices/points identifiers]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, ANYARRAY, BIGINT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To vertex/point identifier
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, ANYARRAY, ANYARRAY, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints (Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To ARRAY[vertices/points identifiers]
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';

COMMENT ON FUNCTION pgr_withPoints(TEXT, TEXT, TEXT, CHAR, BOOLEAN, BOOLEAN)
IS 'pgr_withPoints(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed => true
  - details => false
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPoints.html
';


--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,   -- edges
  TEXT,   -- points
  BIGINT, -- starts
  BIGINT, -- ends
  CHAR,   -- driving side

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[],
  directed, $5, true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,     -- edges
  TEXT,     -- points
  BIGINT,   -- starts
  ANYARRAY, -- ends
  CHAR,    -- driving side

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], $4::BIGINT[],
  directed, $5, true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- starts
  BIGINT,   -- ends
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], ARRAY[$4]::BIGINT[],
  directed, $5, true, true, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- starts
  ANYARRAY, -- ends
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost float)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], $4::BIGINT[],
  directed, $5, true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT, -- edges
  TEXT, -- points
  TEXT, -- combinations
  CHAR, -- driving side

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3),
  directed, $4, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, BIGINT, BIGINT, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertices/point identifier
  - To vertex/point identifier
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, BIGINT, ANYARRAY, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertices/point identifier
  - To ARRAY[vertices/points identifiers]
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, ANYARRAY, BIGINT, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To vertex/point identifier
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, ANYARRAY, ANYARRAY, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To ARRAY[vertices/points identifiers]
  - driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, TEXT, CHAR, BOOLEAN)
IS 'pgr_withPointsCost(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Combinations SQL with columns: source, target
  - driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,   -- edges
  TEXT,   -- points
  BIGINT, -- starts
  BIGINT, -- ends

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], ARRAY[$4]::BIGINT[],
  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;


--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,     -- edges
  TEXT,     -- points
  BIGINT,   -- starts
  ANYARRAY, -- ends

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), ARRAY[$3]::BIGINT[], $4::BIGINT[],
  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- starts
  BIGINT,   -- ends

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], ARRAY[$4]::BIGINT[],
  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), true, true, false, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- starts
  ANYARRAY, -- ends

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost float)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], $4::BIGINT[],
  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

--v4.0
CREATE FUNCTION pgr_withPointsCost(
  TEXT, -- edges
  TEXT, -- points
  TEXT, -- combinations

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
SELECT start_vid, end_vid, agg_cost
FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), _pgr_get_statement($3),
  directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, BIGINT, BIGINT, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (One to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertices/point identifier
  - To vertex/point identifier
- Optional Parameters
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, BIGINT, ANYARRAY, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (One to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From vertices/point identifier
  - To ARRAY[vertices/points identifiers]
- Optional Parameters
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, ANYARRAY, BIGINT, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (Many to One)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To vertex/point identifier
- Optional Parameters
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, ANYARRAY, ANYARRAY, CHAR, BOOLEAN)
IS 'pgr_withPointsCost (Many to Many)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - From ARRAY[vertices/points identifiers]
  - To ARRAY[vertices/points identifiers]
- Optional Parameters:
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';

COMMENT ON FUNCTION pgr_withPointsCost(TEXT, TEXT, TEXT, CHAR, BOOLEAN)
IS 'pgr_withPointsCost(Combinations)
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - Combinations SQL with columns: source, target
- Optional Parameters:
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCost.html
';


--v4.0
CREATE FUNCTION pgr_withPointsCostMatrix(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- vids
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost float)
RETURNS SETOF RECORD AS
$BODY$
  SELECT start_vid, end_vid, agg_cost
  FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], '{}'::BIGINT[],
    directed, $4, true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_withPointsCostMatrix(TEXT, TEXT, ANYARRAY, CHAR, BOOLEAN)
IS'pgr_withPointsCostMatrix
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - ARRAY [vertex/points identifiers],
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters:
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCostMatrix.html
';

--v4.0
CREATE FUNCTION pgr_withPointsCostMatrix(
  TEXT,     -- edges
  TEXT,     -- points
  ANYARRAY, -- vids

  directed BOOLEAN DEFAULT true,

  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT agg_cost float)
RETURNS SETOF RECORD AS
$BODY$
  SELECT start_vid, end_vid, agg_cost
  FROM _pgr_withPoints_v4(_pgr_get_statement($1), _pgr_get_statement($2), $3::BIGINT[], '{}'::BIGINT[],
    directed, (CASE WHEN directed THEN 'r' ELSE 'b' END), true, true, true, 0, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_withPointsCostMatrix(TEXT, TEXT, ANYARRAY, CHAR, BOOLEAN)
IS'pgr_withPointsCostMatrix
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - ARRAY [vertex/points identifiers],
- Optional Parameters:
  - directed => true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_withPointsCostMatrix.html
';


--v4.0
CREATE FUNCTION _pgr_withPointsVia_v4(
  TEXT,     -- edges_sql
  TEXT,     -- points_sql
  ANYARRAY, -- via vids
  BOOLEAN,  -- directed
  BOOLEAN,  -- strict
  BOOLEAN,  -- U_turn_on_edge
  CHAR,     -- driving_side
  BOOLEAN,  -- details

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_withPointsVia_v4(TEXT, TEXT, ANYARRAY, BOOLEAN, BOOLEAN, BOOLEAN, CHAR, BOOLEAN)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION pgr_withPointsVia(
  TEXT,     -- edges SQL
  TEXT,     -- points SQL
  ANYARRAY, -- via vids
  CHAR,     -- driving side

  directed BOOLEAN DEFAULT true,

  -- via parameters
  strict BOOLEAN DEFAULT false,
  U_turn_on_edge BOOLEAN DEFAULT true,

  -- withPoints parameters
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost, route_agg_cost
  FROM _pgr_withPointsVia_v4(
    _pgr_get_statement($1), _pgr_get_statement($2), $3,
    directed, strict, u_turn_on_edge, $4, details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_withPointsVia(TEXT, TEXT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsVia
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - ARRAY[via vertices identifiers]
  - Driving side: directed graph [r,l], undirected graph [b]
- Optional Parameters
  - directed => true
  - strict => false
  - U_turn_on_edge => true
  - details => false
- Documentation:
  -{PROJECT_DOC_LINK}/pgr_withPointsVia.html
';

--v4.0
CREATE FUNCTION pgr_withPointsVia(
  TEXT,     -- edges SQL
  TEXT,     -- points SQL
  ANYARRAY, -- via vids

  directed BOOLEAN DEFAULT true,

  -- via parameters
  strict BOOLEAN DEFAULT false,
  U_turn_on_edge BOOLEAN DEFAULT true,

  -- withPoints parameters
  details BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT path_id INTEGER,
  OUT path_seq INTEGER,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT,
  OUT route_agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
  SELECT seq, path_id, path_seq, start_vid, end_vid, node, edge, cost, agg_cost, route_agg_cost
  FROM _pgr_withPointsVia_v4(
    _pgr_get_statement($1), _pgr_get_statement($2), $3,
    directed, strict, u_turn_on_edge, (CASE WHEN directed THEN 'r' ELSE 'b' END), details);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_withPointsVia(TEXT, TEXT, ANYARRAY, CHAR, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN)
IS 'pgr_withPointsVia
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Points SQL with columns: [pid], edge_id, fraction [,side]
  - ARRAY[via vertices identifiers]
- Optional Parameters
  - directed => true
  - strict => false
  - U_turn_on_edge => true
  - details => false
- Documentation:
  -{PROJECT_DOC_LINK}/pgr_withPointsVia.html
';


----------------------
-- pgr_lineGraphFull
----------------------

CREATE OR REPLACE FUNCTION _pgr_lineGraphFull(
    TEXT, -- edges_sql

    OUT seq INTEGER,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT,
    OUT edge BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_lineGraphFull(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_lineGraphFull(
    TEXT, -- edges_sql (required)

    OUT seq INTEGER,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT,
    OUT edge BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, source, target, cost, edge
    FROM _pgr_lineGraphFull(_pgr_get_statement($1))
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_lineGraphFull(TEXT)
IS 'pgr_lineGraphFull
- EXPERIMENTAL
- For Directed Graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_lineGraphFull.html
';


----------------------
-- pgr_lineGraph
----------------------


CREATE OR REPLACE FUNCTION _pgr_lineGraph(
    TEXT, -- edges_sql

    directed BOOLEAN,

    OUT seq INTEGER,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT,
    OUT reverse_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_lineGraph(TEXT, BOOLEAN)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_lineGraph(
    TEXT, -- edges_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT source BIGINT,
    OUT target BIGINT,
    OUT cost FLOAT,
    OUT reverse_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, source, target, cost, reverse_cost
    FROM _pgr_lineGraph(_pgr_get_statement($1), $2)
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_lineGraph(TEXT, BOOLEAN)
IS 'pgr_lineGraph
- PROPOSED
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Optional Parameters:
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_lineGraph.html
';


---------------
---------------
--  COMPONENTS
---------------
---------------

--------------------------
-- pgr_connectedComponents
--------------------------

CREATE OR REPLACE FUNCTION _pgr_connectedComponents(
    edges_sql TEXT,

    OUT seq BIGINT,
    OUT component BIGINT,
    OUT node BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_connectedComponents(TEXT)
IS 'pgRouting internal function';


---------------
---------------
--  COMPONENTS
---------------
---------------

--------------------------
-- pgr_connectedComponents
--------------------------

CREATE OR REPLACE FUNCTION pgr_connectedComponents(
    TEXT, -- edges_sql (required)

    OUT seq BIGINT,
    OUT component BIGINT,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, component, node
    FROM _pgr_connectedComponents(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_connectedComponents(TEXT)
IS'pgr_connectedComponents
- Undirected graph
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_connectedComponents.html
';


-----------------------
-- pgr_strongComponents
-----------------------


CREATE OR REPLACE FUNCTION _pgr_strongComponents(
    edges_sql TEXT,

    OUT seq BIGINT,
    OUT component BIGINT,
    OUT node BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_strongComponents(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_strongComponents(
    TEXT, -- edges_sql (required)

    OUT seq BIGINT,
    OUT component BIGINT,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, component, node
    FROM _pgr_strongComponents(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_strongComponents(TEXT)
IS'pgr_strongComponents
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_strongComponents.html
';



----------------------------
-- pgr_biconnectedComponents
----------------------------


CREATE OR REPLACE FUNCTION _pgr_biconnectedComponents(
    edges_sql TEXT,

    OUT seq BIGINT,
    OUT component BIGINT,
    OUT edge BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_biconnectedComponents(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_biconnectedComponents(
    TEXT, -- edges_sql (required)

    OUT seq BIGINT,
    OUT component BIGINT,
    OUT edge BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, component, edge
    FROM _pgr_biconnectedComponents(_pgr_get_statement($1)) ;
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION pgr_biconnectedComponents(TEXT)
IS'pgr_biconnectedComponents
- Undirected graph
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_biconnectedComponents.html
';


-------------------------
-- pgr_articulationPoints
-------------------------

CREATE OR REPLACE FUNCTION _pgr_articulationPoints(
    edges_sql TEXT,

    OUT seq INTEGER,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;



COMMENT ON FUNCTION _pgr_articulationPoints(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_articulationPoints(
    TEXT,   -- edges_sql (required)

    OUT node BIGINT)
RETURNS SETOF BIGINT AS
$BODY$
    SELECT node
    FROM _pgr_articulationPoints(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_articulationPoints(TEXT)
IS'pgr_articulationPoints
- Undirected graph
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_articulationPoints.html
';


--------------
-- pgr_bridges
--------------

CREATE OR REPLACE FUNCTION _pgr_bridges(
    edges_sql TEXT,

    OUT seq INTEGER,
    OUT edge BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_bridges(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_bridges(
    TEXT,  -- edges_sql (required)

    OUT edge BIGINT)
RETURNS SETOF BIGINT AS
$BODY$
    SELECT edge
    FROM _pgr_bridges(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_bridges(TEXT)
IS'pgr_bridges
- Undirected graph
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bridges.html
';

-------------------------
-------------------------
-- _makeConnected
-------------------------
-------------------------

--v3.2
CREATE FUNCTION _pgr_makeConnected(
  TEXT,   -- edges_sql (required)

  OUT seq BIGINT,
  OUT start_vid BIGINT,
  OUT end_vid BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;



COMMENT ON FUNCTION _pgr_makeConnected(TEXT)
IS 'pgRouting internal function';


------------------
-- pgr_makeConnected
------------------

--v3.2
CREATE FUNCTION pgr_makeConnected(
    TEXT,   -- edges_sql (required)
    OUT seq BIGINT,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, start_vid, end_vid
    FROM _pgr_makeConnected(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_makeConnected(TEXT)
IS 'pgr_makeConnected
- EXPERIMENTAL
- Undirected graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_makeConnected.html
';

-------------------------
-------------------------
-- bellman_ford
-------------------------
-------------------------

CREATE OR REPLACE FUNCTION _pgr_bellmanFord(
    edges_sql TEXT,
    from_vids ANYARRAY,
    to_vids   ANYARRAY,
    directed  BOOLEAN,
    only_cost BOOLEAN,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


--v3.2
CREATE FUNCTION _pgr_bellmanFord(
    edges_sql TEXT,
    combinations_sql TEXT,
    directed  BOOLEAN,
    only_cost BOOLEAN,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;



COMMENT ON FUNCTION _pgr_bellmanFord(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_bellmanFord(TEXT, TEXT, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';


-- ONE TO ONE
CREATE OR REPLACE FUNCTION pgr_bellmanFord(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bellmanFord(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], directed, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--ONE TO MANY
CREATE OR REPLACE FUNCTION pgr_bellmanFord(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,


    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bellmanFord(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], directed, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--MANY TO ONE
CREATE OR REPLACE FUNCTION pgr_bellmanFord(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bellmanFord(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], directed, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--MANY TO MANY
CREATE OR REPLACE FUNCTION pgr_bellmanFord(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bellmanFord(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], directed, false );
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--COMBINATIONS
--v3.2
CREATE FUNCTION pgr_bellmanFord(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_bellmanFord(_pgr_get_statement($1), _pgr_get_statement($2), directed, false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_bellmanFord(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_bellmanFord(One to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Optional Parameters:
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bellmanFord.html
';


COMMENT ON FUNCTION pgr_bellmanFord(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_bellmanFord(One to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bellmanFord.html
';


COMMENT ON FUNCTION pgr_bellmanFord(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_bellmanFord(Many to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bellmanFord.html
';


COMMENT ON FUNCTION pgr_bellmanFord(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_bellmanFord(Many to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bellmanFord.html
';


COMMENT ON FUNCTION pgr_bellmanFord(TEXT, TEXT, BOOLEAN)
IS 'pgr_bellmanFord(Combinations)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Optional Parameters
  - directed := true
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_bellmanFord.html
';

-------------------------
-------------------------
-- _pgr_edwardMoore
-------------------------
-------------------------

CREATE OR REPLACE FUNCTION _pgr_edwardMoore(
    edges_sql TEXT,
    from_vids ANYARRAY,
    to_vids   ANYARRAY,
    directed  BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


--v3.2
CREATE FUNCTION _pgr_edwardMoore(
    edges_sql TEXT,
    combinations_sql TEXT,
    directed  BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_edwardMoore(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_edwardMoore(TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';



-- ONE TO ONE
CREATE OR REPLACE FUNCTION pgr_edwardMoore(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edwardMoore(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_edwardMoore(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edwardMoore(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_edwardMoore(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edwardMoore(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_edwardMoore(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edwardMoore(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_edwardMoore(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_edwardMoore(_pgr_get_statement($1), _pgr_get_statement($2), $3);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_edwardMoore(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_edwardMoore(One to One)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_edwardMoore.html
';

COMMENT ON FUNCTION pgr_edwardMoore(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_edwardMoore(One to Many)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_edwardMoore.html
';

COMMENT ON FUNCTION pgr_edwardMoore(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_edwardMoore(Many to One)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_edwardMoore.html
';

COMMENT ON FUNCTION pgr_edwardMoore(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_edwardMoore(Many to Many)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_edwardMoore.html
';

COMMENT ON FUNCTION pgr_edwardMoore(TEXT, TEXT, BOOLEAN)
IS 'pgr_edwardMoore(Combinations)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - Combinations SQL with columns: source, target
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_edwardMoore.html
';


--v4.0
CREATE FUNCTION _pgr_dagShortestPath_v4(
    TEXT, -- edges

    ANYARRAY, -- departures
    ANYARRAY, -- arrivals

    BOOLEAN, -- only_cost
    BOOLEAN, -- normal

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

--v4.0
CREATE FUNCTION _pgr_dagShortestPath_v4(
    TEXT, -- edges
    TEXT, -- combinations

    BOOLEAN, -- only_cost

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_dagShortestPath_v4(TEXT, ANYARRAY, ANYARRAY, BOOLEAN, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_dagShortestPath_v4(TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';


-- ONE to ONE
--v4.0
CREATE FUNCTION pgr_dagShortestPath(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    BIGINT,   -- from_vid (required)

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dagShortestPath_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], false, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
--v4.0
CREATE FUNCTION pgr_dagShortestPath(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dagShortestPath_v4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], false, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
--v4.0
CREATE FUNCTION pgr_dagShortestPath(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dagShortestPath_v4(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], false, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
--v4.0
CREATE FUNCTION pgr_dagShortestPath(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dagShortestPath_v4(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], false, true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_dagShortestPath(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_dagShortestPath_v4(_pgr_get_statement($1), _pgr_get_statement($2), false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_dagShortestPath(TEXT, BIGINT, BIGINT)
IS 'pgr_dagShortestPath(One to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dagShortestPath.html
';

COMMENT ON FUNCTION pgr_dagShortestPath(TEXT, BIGINT, ANYARRAY)
IS 'pgr_dagShortestPath(One to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From vertex identifier
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dagShortestPath.html
';

COMMENT ON FUNCTION pgr_dagShortestPath(TEXT, ANYARRAY, BIGINT)
IS 'pgr_dagShortestPath(Many to One)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To vertex identifier
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dagShortestPath.html
';

COMMENT ON FUNCTION pgr_dagShortestPath(TEXT, ANYARRAY, ANYARRAY)
IS 'pgr_dagShortestPath(Many to Many)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[vertices identifiers]
  - To ARRAY[vertices identifiers]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dagShortestPath.html
';

COMMENT ON FUNCTION pgr_dagShortestPath(TEXT, TEXT)
IS 'pgr_dagShortestPath(Combinations)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - Combinations SQL with columns: source, target
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_dagShortestPath.html
';

----------
----------
-- ChPP
----------
----------

CREATE OR REPLACE FUNCTION _pgr_chinesePostman(
    edges_sql TEXT,

    only_cost BOOLEAN,

    OUT seq INTEGER,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_chinesePostman(TEXT, BOOLEAN)
IS 'pgRouting internal function';



--------------------
-- pgr_directedChPP
--------------------



CREATE OR REPLACE FUNCTION pgr_chinesePostman(
    TEXT, -- edges_sql (required)

    OUT seq INTEGER,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, node, edge, cost, agg_cost
    FROM _pgr_chinesePostman(_pgr_get_statement($1), only_cost := false);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_chinesePostman(TEXT)
IS 'pgr_chinesePostman
- EXPERIMENTAL
- Directed graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_chinesePostman.html
';



CREATE OR REPLACE FUNCTION pgr_chinesePostmanCost(
    TEXT -- edges_sql (required)
)
RETURNS FLOAT AS
$BODY$
    SELECT cost
    FROM _pgr_chinesePostman(_pgr_get_statement($1), only_cost := true);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;


COMMENT ON FUNCTION pgr_chinesePostmanCost(TEXT)
IS 'pgr_chinesePostmanCost
- EXPERIMENTAL
- Directed graph
- Parameters:
	- Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
	- https://docs.pgrouting.org/latest/en/pgr_chinesePostmanCost.html
';


--v3.7
CREATE FUNCTION _pgr_primv4(
  TEXT,     -- Edge sql
  ANYARRAY, -- tree root for traversal
  TEXT,     -- order by
  BIGINT,   -- max depth
  FLOAT,    -- distance

  OUT seq BIGINT,
  OUT depth BIGINT,
  OUT start_vid BIGINT,
  OUT pred BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_primv4(TEXT, ANYARRAY, TEXT, BIGINT, FLOAT)
IS 'pgRouting internal function';


----------------
-- _pgr_kruskal
----------------

--v3.7
CREATE FUNCTION _pgr_kruskalv4(
  TEXT,     -- Edge sql
  ANYARRAY, -- tree root for traversal
  TEXT,     -- gn suffix
  BIGINT,   -- max depth
  FLOAT,    -- distance

  OUT seq BIGINT,
  OUT depth BIGINT,
  OUT start_vid BIGINT,
  OUT pred BIGINT,
  OUT node BIGINT,
  OUT edge BIGINT,
  OUT cost FLOAT,
  OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_kruskalv4(TEXT, ANYARRAY, TEXT, BIGINT, FLOAT)
IS 'pgRouting internal function';



------------
-- pgr_prim
------------


CREATE OR REPLACE FUNCTION pgr_prim(
    TEXT,  -- edges_sql (required)

    OUT edge BIGINT,
    OUT cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT edge, cost
    FROM _pgr_primv4(_pgr_get_statement($1), ARRAY[0]::BIGINT[], '', -1, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMMENT


COMMENT ON FUNCTION pgr_prim(TEXT)
IS 'pgr_prim
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_prim.html
';


-----------------
-- pgr_primDFS
-----------------


-- SINGLE VERTEX
--v3.7
CREATE FUNCTION pgr_primDFS(
    TEXT,   -- Edge sql
    BIGINT, -- root vertex

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'DFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.7
CREATE FUNCTION pgr_primDFS(
    TEXT,     -- Edge sql
    ANYARRAY, -- root vertices

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), $2, 'DFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_primDFS(TEXT, BIGINT, BIGINT)
IS 'pgr_primDFS(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
- Optional parameters
    - max_depth := 9223372036854775807
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primDFS.html
';

COMMENT ON FUNCTION pgr_primDFS(TEXT, ANYARRAY, BIGINT)
IS 'pgr_primDFS(Multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
- Optional parameters
    - max_depth := 9223372036854775807
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primDFS.html
';



-----------------
-- pgr_primBFS
-----------------


-- SINGLE VERTEX
--v3.7
CREATE FUNCTION pgr_primBFS(
    TEXT,   -- Edge sql
    BIGINT, -- root vertex

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'BFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.7
CREATE FUNCTION pgr_primBFS(
    TEXT,     -- Edge sql
    ANYARRAY, -- root vertices

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), $2, 'BFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_primBFS(TEXT, BIGINT, BIGINT)
IS 'pgr_primBFS(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
- Optional parameters
    - max_depth := 9223372036854775807
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primBFS.html
';


COMMENT ON FUNCTION pgr_primBFS(TEXT, ANYARRAY, BIGINT)
IS 'pgr_primBFS(multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
- Optional parameters
    - max_depth := 9223372036854775807
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primBFS.html
';


--------------
-- pgr_primDD
--------------


-- SINGLE VERTEX
--v3.7
CREATE FUNCTION pgr_primDD (
    TEXT,   -- Edge sql
    BIGINT, -- root vertex
    NUMERIC,  -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'DD', -1, $3::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v3.7
CREATE FUNCTION pgr_primDD (
    TEXT,   -- Edge sql
    BIGINT, -- root vertex
    FLOAT,  -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'DD', -1, $3::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.7
CREATE FUNCTION pgr_primDD (
    TEXT,   -- Edge sql
    ANYARRAY, -- root vertex

    NUMERIC, -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), $2, 'DD', -1, $3);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.7
CREATE FUNCTION pgr_primDD (
    TEXT,   -- Edge sql
    ANYARRAY, -- root vertex

    FLOAT, -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_primv4(_pgr_get_statement($1), $2, 'DD', -1, $3::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_primDD(TEXT, BIGINT, NUMERIC)
IS 'pgr_primDD(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primDD.html
';


COMMENT ON FUNCTION pgr_primDD(TEXT, ANYARRAY, NUMERIC)
IS 'pgr_primDD(Multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primDD.html
';


COMMENT ON FUNCTION pgr_primDD(TEXT, BIGINT, FLOAT)
IS 'pgr_primDD(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
    - Distance
- DocumentatiEdgeson:
    - https://docs.pgrouting.org/latest/en/pgr_primDD.html
';


COMMENT ON FUNCTION pgr_primDD(TEXT, ANYARRAY, FLOAT)
IS 'pgr_primDD(Multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_primDD.html
';



---------------
-- pgr_kruskal
---------------


CREATE OR REPLACE FUNCTION pgr_kruskal(
    TEXT, -- edges-sql (required)

    OUT edge BIGINT,
    OUT cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT edge, cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), ARRAY[0]::BIGINT[], '', -1, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_kruskal(TEXT)
IS 'pgr_kruskal
- Undirected graph
- Parameters:
	- Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
	- https://docs.pgrouting.org/latest/en/pgr_kruskal.html
';



-----------------
-- pgr_kruskalDFS
-----------------


-- SINGLE VERTEX
--v3.7
CREATE FUNCTION pgr_kruskalDFS(
    TEXT,   -- Edge sql
    BIGINT, -- root vertex

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'DFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MULTIPLE VERTICES
--v3.7
CREATE FUNCTION pgr_kruskalDFS(
    TEXT,     -- Edge sql
    ANYARRAY, -- root vertices

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), $2, 'DFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_kruskalDFS(TEXT, BIGINT, BIGINT)
IS 'pgr_kruskalDFS(Single Vertex)
- Undirected graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
  - from root vertex identifier
- Optional parameters
  - max_depth: default 9223372036854775807
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_kruskalDFS.html
';


COMMENT ON FUNCTION pgr_kruskalDFS(TEXT, ANYARRAY, BIGINT)
IS 'pgr_kruskalDFS(Multiple Vertices)
- Undirected graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
  - from ARRAY[root vertices identifiers]
- Optional parameters
  - max_depth: default 9223372036854775807
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_kruskalDFS.html
';



-----------------
-- pgr_kruskalBFS
-----------------


--v3.7
CREATE FUNCTION pgr_kruskalBFS(
    TEXT,   -- Edge sql (required)
    BIGINT, -- root vertex (required)

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'BFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.7
CREATE FUNCTION pgr_kruskalBFS(
    TEXT,     -- Edge sql (required)
    ANYARRAY, -- root vertices (required)

    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), $2, 'BFS', $3, -1);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_kruskalBFS(TEXT, BIGINT, BIGINT)
IS 'pgr_kruskalBFS(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
- Optional parameters
    - max_depth: default := 9223372036854775807
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kruskalBFS.html
';


COMMENT ON FUNCTION pgr_kruskalBFS(TEXT, ANYARRAY, BIGINT)
IS 'pgr_kruskalBFS(multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
- Optional parameters
    - max_depth: default := 9223372036854775807
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kruskalBFS.html
';



-----------------
-- pgr_kruskalDD
-----------------


-- SINGLE VERTEX
--v3.7
CREATE FUNCTION pgr_kruskalDD (
    TEXT,   -- Edge sql
    BIGINT, -- root vertex
    NUMERIC,  -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'DD', -1, $3::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

--v3.7
CREATE FUNCTION pgr_kruskalDD (
    TEXT,   -- Edge sql
    BIGINT, -- root vertex
    FLOAT,  -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], 'DD', -1, $3::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

-- MULTIPLE VERTICES
--v3.7
CREATE FUNCTION pgr_kruskalDD (
    TEXT,   -- Edge sql
    ANYARRAY, -- root vertex

    NUMERIC, -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), $2, 'DD', -1, $3);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--v3.7
CREATE FUNCTION pgr_kruskalDD (
    TEXT,   -- Edge sql
    ANYARRAY, -- root vertex

    FLOAT, -- distance

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_kruskalv4(_pgr_get_statement($1), $2, 'DD', -1, $3::FLOAT);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_kruskalDD(TEXT, BIGINT, NUMERIC)
IS 'pgr_kruskalDD(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kruskalDD.html
';


COMMENT ON FUNCTION pgr_kruskalDD(TEXT, ANYARRAY, NUMERIC)
IS 'pgr_kruskalDD(Multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kruskalDD.html
';


COMMENT ON FUNCTION pgr_kruskalDD(TEXT, BIGINT, FLOAT)
IS 'pgr_kruskalDD(Single Vertex)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From root vertex identifier
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kruskalDD.html
';


COMMENT ON FUNCTION pgr_kruskalDD(TEXT, ANYARRAY, FLOAT)
IS 'pgr_kruskalDD(Multiple Vertices)
- Undirected graph
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
    - From ARRAY[root vertices identifiers]
    - Distance
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kruskalDD.html
';


---------------
---------------
-- mincut
---------------
---------------

-------------------
-- pgr_stoerWagner
-------------------

CREATE OR REPLACE FUNCTION _pgr_stoerWagner(
    edges_sql TEXT,

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT mincut FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_stoerWagner(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_stoerWagner(
    TEXT, -- edges_sql (required)

    OUT seq INTEGER,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT mincut FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, edge, cost, mincut
    FROM _pgr_stoerWagner(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_stoerWagner(TEXT)
IS 'pgr_stoerWagner
- EXPERIMENTAL
- Undirected graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_stoerWagner.html
';


CREATE OR REPLACE FUNCTION _pgr_boost_version()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_boost_version() IS
'pgRouting internal function';

---

CREATE OR REPLACE FUNCTION _pgr_build_type()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_build_type() IS
'pgRouting internal function';

---

CREATE OR REPLACE FUNCTION _pgr_compilation_date()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_compilation_date() IS
'pgRouting internal function';

---

CREATE OR REPLACE FUNCTION _pgr_compiler_version()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_compiler_version() IS
'pgRouting internal function';

---

CREATE OR REPLACE FUNCTION _pgr_git_hash()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_git_hash() IS
'pgRouting internal function';

---

CREATE OR REPLACE FUNCTION _pgr_lib_version()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_lib_version() IS
'pgRouting internal function';


---

CREATE OR REPLACE FUNCTION _pgr_operating_system()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_operating_system() IS
'pgRouting internal function';
---

CREATE OR REPLACE FUNCTION _pgr_pgsql_version()
RETURNS TEXT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 1;

COMMENT ON FUNCTION _pgr_pgsql_version() IS
'pgRouting internal function';



CREATE OR REPLACE FUNCTION pgr_version()
RETURNS TEXT AS
$BODY$
    SELECT '4.0.0'::varchar AS pgr_version;
$BODY$
LANGUAGE sql IMMUTABLE
COST 1;

COMMENT ON FUNCTION pgr_version() IS
'pgr_version
- Documentation
  - https://docs.pgrouting.org/latest/en/pgr_version.html
';




CREATE OR REPLACE FUNCTION pgr_full_version(
    OUT version TEXT,
    OUT build_type TEXT,
    OUT compile_date TEXT,
    OUT library TEXT,
    OUT system TEXT,
    OUT PostgreSQL TEXT,
    OUT compiler TEXT,
    OUT boost TEXT,
    OUT hash TEXT
)
RETURNS Record AS
$BODY$
    SELECT pgr_version(),
        _pgr_build_type(),
        _pgr_compilation_date(),
        _pgr_lib_version(),
        _pgr_operating_system(),
        _pgr_pgsql_version(),
        _pgr_compiler_version(),
        _pgr_boost_version(),
        _pgr_git_hash()
$BODY$
LANGUAGE sql IMMUTABLE;

COMMENT ON FUNCTION pgr_full_version() IS
'pgr_full_version
- Documentation
  - https://docs.pgrouting.org/latest/en/pgr_full_version.html
';


---------------
-- pgr_topologicalSort
---------------


CREATE OR REPLACE FUNCTION _pgr_topologicalSort(
    edges_sql TEXT,

    OUT seq INTEGER,
    OUT sorted_v BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION _pgr_topologicalSort(TEXT)
IS 'pgRouting internal function';



---------------
-- pgr_topologicalSort
---------------


CREATE OR REPLACE FUNCTION pgr_topologicalSort(
    TEXT, -- edges_sql (required)

    OUT seq INTEGER,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, sorted_v
    FROM _pgr_topologicalSort(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;




COMMENT ON FUNCTION pgr_topologicalSort(TEXT)
IS 'pgr_topologicalSort
- EXPERIMENTAL
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_topologicalSort.html
';


---------------
-- pgr_transitiveClosure
---------------


CREATE OR REPLACE FUNCTION _pgr_transitiveClosure(
    edges_sql TEXT,

    OUT seq INTEGER,
    OUT vid BIGINT,
    OUT target_array BIGINT[])
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION _pgr_transitiveClosure(TEXT)
IS 'pgRouting internal function';


CREATE OR REPLACE FUNCTION pgr_transitiveClosure(
    TEXT, -- edges_sql (required)

    OUT node BIGINT,
    OUT targets BIGINT[])
RETURNS SETOF RECORD AS
$BODY$
    SELECT vid, target_array
    FROM _pgr_transitiveClosure(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_transitiveClosure(TEXT)
IS 'pgr_transitiveClosure
- EXPERIMENTAL
- Directed graph
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_transitiveClosure.html
';


CREATE OR REPLACE FUNCTION _pgr_breadthFirstSearch(
    TEXT,     --edges
    ANYARRAY, -- roots
    BIGINT,   -- max depth
    BOOLEAN,  --directed

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT,
    OUT pred BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_breadthFirstSearch(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgRouting internal function';

-------------------------
-------------------------
-- _pgr_binaryBreadthFirstSearch
-------------------------
-------------------------

CREATE OR REPLACE FUNCTION _pgr_binaryBreadthFirstSearch(
    edges_sql TEXT,
    from_vids ANYARRAY,
    to_vids   ANYARRAY,
    directed  BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE c IMMUTABLE STRICT;


--v3.2
CREATE FUNCTION _pgr_binaryBreadthFirstSearch(
    edges_sql TEXT,
    combinations_sql TEXT,
    directed  BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_binaryBreadthFirstSearch(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgRouting internal function';

COMMENT ON FUNCTION _pgr_binaryBreadthFirstSearch(TEXT, TEXT, BOOLEAN)
IS 'pgRouting internal function';


--ONE TO DEPTH
CREATE OR REPLACE FUNCTION pgr_breadthFirstSearch(
    TEXT,   -- edges_sql (required)
    BIGINT, -- root_vid (required)

    directed BOOLEAN DEFAULT true,
    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_breadthFirstSearch(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], max_depth, directed);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


--MANY TO DEPTH
CREATE OR REPLACE FUNCTION pgr_breadthFirstSearch(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- root_vids (required)

    directed BOOLEAN DEFAULT true,
    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_breadthFirstSearch(_pgr_get_statement($1), $2::BIGINT[], max_depth, directed);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_breadthFirstSearch(TEXT, BIGINT, BOOLEAN, BIGINT)
IS 'pgr_breadthFirstSearch(One to Depth)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From root vertex identifier
- Optional parameters
  - directed := true
  - max_depth := 9223372036854775807
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_breadthFirstSearch.html
';

COMMENT ON FUNCTION pgr_breadthFirstSearch(TEXT, ANYARRAY, BOOLEAN, BIGINT)
IS 'pgr_breadthFirstSearch(Many to Depth)
- EXPERIMENTAL
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[root vertices identifiers]
- Optional parameters
   - directed := true
   - max_depth := 9223372036854775807
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_breadthFirstSearch.html
';


-- ONE to ONE
CREATE OR REPLACE FUNCTION pgr_binaryBreadthFirstSearch(
    TEXT,   -- edges_sql (required)
    BIGINT, -- from_vid (required)
    BIGINT, -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_binaryBreadthFirstSearch(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], ARRAY[$3]::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- ONE to MANY
CREATE OR REPLACE FUNCTION pgr_binaryBreadthFirstSearch(
    TEXT,     -- edges_sql (required)
    BIGINT,   -- from_vid (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_binaryBreadthFirstSearch(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], $3::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to ONE
CREATE OR REPLACE FUNCTION pgr_binaryBreadthFirstSearch(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    BIGINT,   -- to_vid (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_binaryBreadthFirstSearch(_pgr_get_statement($1), $2::BIGINT[], ARRAY[$3]::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MANY to MANY
CREATE OR REPLACE FUNCTION pgr_binaryBreadthFirstSearch(
    TEXT,     -- edges_sql (required)
    ANYARRAY, -- from_vids (required)
    ANYARRAY, -- to_vids (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_binaryBreadthFirstSearch(_pgr_get_statement($1), $2::BIGINT[], $3::BIGINT[], $4);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- COMBINATIONS
--v3.2
CREATE FUNCTION pgr_binaryBreadthFirstSearch(
    TEXT,     -- edges_sql (required)
    TEXT,     -- combinations_sql (required)

    directed BOOLEAN DEFAULT true,

    OUT seq INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, path_seq, start_vid, end_vid, node, edge, cost, agg_cost
    FROM _pgr_binaryBreadthFirstSearch(_pgr_get_statement($1), _pgr_get_statement($2), directed);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_binaryBreadthFirstSearch(TEXT, BIGINT, BIGINT, BOOLEAN)
IS 'pgr_binaryBreadthFirstSearch(One to One)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_binaryBreadthFirstSearch.html
';

COMMENT ON FUNCTION pgr_binaryBreadthFirstSearch(TEXT, BIGINT, ANYARRAY, BOOLEAN)
IS 'pgr_binaryBreadthFirstSearch(One to Many)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From vertex identifier
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_binaryBreadthFirstSearch.html
';

COMMENT ON FUNCTION pgr_binaryBreadthFirstSearch(TEXT, ANYARRAY, BIGINT, BOOLEAN)
IS 'pgr_binaryBreadthFirstSearch(Many to One)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To vertex identifier
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_binaryBreadthFirstSearch.html
';

COMMENT ON FUNCTION pgr_binaryBreadthFirstSearch(TEXT, ANYARRAY, ANYARRAY, BOOLEAN)
IS 'pgr_binaryBreadthFirstSearch(Many to Many)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - From ARRAY[vertices identifiers]
   - To ARRAY[vertices identifiers]
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_binaryBreadthFirstSearch.html
';

COMMENT ON FUNCTION pgr_binaryBreadthFirstSearch(TEXT, TEXT, BOOLEAN)
IS 'pgr_binaryBreadthFirstSearch(Combinations)
- EXPERIMENTAL
- Parameters:
   - Edges SQL with columns: id, source, target, cost [,reverse_cost]
   - Combinations SQL with columns: source, target
- Optional Parameters
   - directed := true
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_binaryBreadthFirstSearch.html
';


--v3.2
CREATE FUNCTION _pgr_depthFirstSearch(
    TEXT,     --edges
    ANYARRAY, -- roots
    BOOLEAN,  --directed
    BIGINT,   -- max depth

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT,
    OUT pred BIGINT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION _pgr_depthFirstSearch(TEXT, ANYARRAY, BOOLEAN, BIGINT)
IS 'pgRouting internal function';


-- SINGLE VERTEX
--v3.2
CREATE FUNCTION pgr_depthFirstSearch(
    TEXT,   -- edges sql (required)
    BIGINT, -- root vid (required)

    directed BOOLEAN DEFAULT true,
    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_depthFirstSearch(_pgr_get_statement($1), ARRAY[$2]::BIGINT[], directed, max_depth);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


-- MULTIPLE VERTICES
--v3.2
CREATE FUNCTION pgr_depthFirstSearch(
    TEXT,     -- edges sql (required)
    ANYARRAY, -- root vids (required)

    directed BOOLEAN DEFAULT true,
    max_depth BIGINT DEFAULT 9223372036854775807,

    OUT seq BIGINT,
    OUT depth BIGINT,
    OUT start_vid BIGINT,
    OUT pred BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, depth, start_vid, pred, node, edge, cost, agg_cost
    FROM _pgr_depthFirstSearch(_pgr_get_statement($1), $2, directed, max_depth);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_depthFirstSearch(TEXT, BIGINT, BOOLEAN, BIGINT)
IS 'pgr_depthFirstSearch(Single Vertex)
- PROPOSED
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From root vertex identifier
- Optional parameters
  - directed := true
  - max_depth := 9223372036854775807
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_depthFirstSearch.html
';

COMMENT ON FUNCTION pgr_depthFirstSearch(TEXT, ANYARRAY, BOOLEAN, BIGINT)
IS 'pgr_depthFirstSearch(Multiple Vertices)
- PROPOSED
- Parameters:
  - Edges SQL with columns: id, source, target, cost [,reverse_cost]
  - From ARRAY[root vertices identifiers]
- Optional parameters
   - directed := true
   - max_depth := 9223372036854775807
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_depthFirstSearch.html
';


----------------------------------
-- _pgr_sequentialVertexColoring
----------------------------------


--v3.2
CREATE FUNCTION _pgr_sequentialVertexColoring(
    edges_sql TEXT,

    OUT vertex_id BIGINT,
    OUT color_id BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_sequentialVertexColoring(TEXT)
IS 'pgRouting internal function';


--3.2
CREATE FUNCTION pgr_sequentialVertexColoring(
    TEXT,    -- edges_sql (required)

    OUT node BIGINT,
    OUT color BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT vertex_id, color_id
    FROM _pgr_sequentialVertexColoring(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_sequentialVertexColoring(TEXT)
IS 'pgr_sequentialVertexColoring
- PROPOSED
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_sequentialVertexColoring.html
';

---------------
-- _pgr_bipartite
---------------

--v3.2
CREATE FUNCTION _pgr_bipartite(
    edges_sql TEXT,

    OUT node BIGINT,
    OUT color BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_bipartite(TEXT)
IS 'pgRouting internal function';


--v3.2
CREATE FUNCTION pgr_bipartite(
    TEXT, -- edges_sql (required)

    OUT node BIGINT,
    OUT color BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT node, color
    FROM _pgr_bipartite(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_bipartite(TEXT)
IS 'pgr_bipartite
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_bipartite.html
';

---------------
-- _pgr_edgeColoring
---------------

--v3.3
CREATE FUNCTION _pgr_edgeColoring(
    edges_sql TEXT,

    OUT edge_id BIGINT,
    OUT color_id BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_edgeColoring(TEXT)
IS 'pgRouting internal function';

---------------
-- pgr_edgeColoring
---------------

--v3.3
CREATE FUNCTION pgr_edgeColoring(
    TEXT, -- edges_sql (required)

    OUT edge BIGINT,
    OUT color BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT edge_id, color_id
    FROM _pgr_edgeColoring(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_edgeColoring(TEXT)
IS 'pgr_edgeColoring
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_edgeColoring.html
';


--v3.2
CREATE FUNCTION _pgr_isPlanar(
  TEXT   -- edges_sql (required)
)
RETURNS BOOLEAN AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT;

COMMENT ON FUNCTION _pgr_isPlanar(TEXT)
IS 'pgRouting internal function';


--v3.2
CREATE FUNCTION pgr_isPlanar(
  TEXT   -- edges_sql (required)
)

RETURNS BOOLEAN AS
$BODY$
  SELECT _pgr_isPlanar(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT;


COMMENT ON FUNCTION pgr_isPlanar(TEXT)
IS 'pgr_isPlanar
- EXPERIMENTAL
- Undirected graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_isPlanar.html
';

---------------
-- _pgr_lengauerTarjanDominatorTree
---------------
--v3.2
CREATE FUNCTION _pgr_lengauerTarjanDominatorTree (
    edges_sql TEXT, -- edges_sql (required)
    root_vid BIGINT , -- vertex (required)
    OUT seq integer,
    OUT vid BIGINT,
    OUT idom BIGINT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;



COMMENT ON FUNCTION _pgr_lengauerTarjanDominatorTree (TEXT,BIGINT)
IS 'pgRouting internal function';


---------------
-- pgr_lengauerTarjanDominatorTree
---------------
--v3.2
CREATE FUNCTION pgr_lengauerTarjanDominatorTree(
    TEXT,   -- edges_sql (required)
    BIGINT, -- start_vid (required)
    OUT seq integer,
    OUT vertex_id BIGINT,
    OUT idom BIGINT
    )
RETURNS SETOF RECORD AS
$BODY$
BEGIN

    RETURN QUERY
    SELECT a.seq, vid, a.idom
    FROM _pgr_lengauerTarjanDominatorTree(_pgr_get_statement($1),$2) AS a;
END;
$BODY$
LANGUAGE  plpgsql VOLATILE STRICT;




COMMENT ON FUNCTION pgr_lengauerTarjanDominatorTree(TEXT,BIGINT)
IS 'pgr_lengauerTarjanDominatorTree
- EXPERIMENTAL
- Directed graph
- Parameters:
  - edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
  - https://docs.pgrouting.org/latest/en/pgr_lengauerTarjanDominatorTree.html
';



----------------------------
-- _pgr_cuthillMckeeOrdering
----------------------------

--v3.4.0
CREATE FUNCTION _pgr_cuthillMckeeOrdering(
    TEXT,
    OUT seq BIGINT,
    OUT node BIGINT
    )

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;


COMMENT ON FUNCTION _pgr_cuthillMckeeOrdering(TEXT)
IS 'pgRouting internal function';



----------------------------
-- pgr_cuthillMckeeOrdering
----------------------------

--v3.4.0
CREATE FUNCTION pgr_cuthillMckeeOrdering(
    TEXT, -- edges_sql (required)
    OUT seq BIGINT,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, node
    FROM _pgr_cuthillMckeeOrdering(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_cuthillMckeeOrdering(TEXT)
IS 'pgr_cuthillMckeeOrdering
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_cuthillMckeeOrdering.html
';


----------------------------
-- _pgr_sloanOrdering
----------------------------

--v4.0.0
CREATE FUNCTION _pgr_sloanOrdering(
    TEXT,
    OUT seq BIGINT,
    OUT node BIGINT
    )

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;

COMMENT ON FUNCTION _pgr_sloanOrdering(TEXT)
IS 'pgRouting internal function';


--v4.0.0
CREATE FUNCTION pgr_sloanOrdering(
    TEXT, -- edges_sql (required)
    OUT seq BIGINT,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, node
    FROM _pgr_sloanOrdering(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT;

-- COMMENTS

COMMENT ON FUNCTION pgr_sloanOrdering(TEXT)
IS 'pgr_sloanOrdering
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]

- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_sloanOrdering.html
';


--v4.0
CREATE FUNCTION _pgr_kingOrdering(
    TEXT,
    OUT seq BIGINT,
    OUT node BIGINT
    )

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_kingOrdering(TEXT)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION pgr_kingOrdering(
    TEXT, -- edges_sql (required)
    OUT seq BIGINT,
    OUT node BIGINT)
RETURNS SETOF RECORD AS
$BODY$
    SELECT seq, node
    FROM _pgr_kingOrdering(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;

COMMENT ON FUNCTION pgr_kingOrdering(TEXT)
IS 'pgr_kingOrdering
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_kingOrdering.html
';

---------------
-- _pgr_hawickCircuits
---------------

--v3.4.0
CREATE FUNCTION _pgr_hawickCircuits(
    TEXT,

    OUT seq INTEGER,
    OUT path_id  INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C IMMUTABLE STRICT;

COMMENT ON FUNCTION _pgr_hawickCircuits(TEXT)
IS 'pgRouting internal function';

---------------
-- pgr_hawickCircuits
---------------

--v3.4.0
CREATE FUNCTION pgr_hawickCircuits(
    TEXT, -- edges_sql (required)

    OUT seq INTEGER,
    OUT path_id INTEGER,
    OUT path_seq INTEGER,
    OUT start_vid BIGINT,
    OUT end_vid BIGINT,
    OUT node BIGINT,
    OUT edge BIGINT,
    OUT cost FLOAT,
    OUT agg_cost FLOAT)

RETURNS SETOF RECORD AS
$BODY$
BEGIN
    RETURN QUERY
    SELECT a.seq, a.path_id, a.path_seq, a.start_vid, a.end_vid, a.node, a.edge, a.cost, a.agg_cost
    FROM _pgr_hawickCircuits(_pgr_get_statement($1)) AS a;
END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;

COMMENT ON FUNCTION pgr_hawickCircuits(TEXT)
IS 'pgr_hawickCircuits
- EXPERIMENTAL
- Parameters:
    - Edges SQL with columns: id, source, target, cost [,reverse_cost]
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_hawickCircuits.html
';


--------------------------------
-- pgr_betweennessCentrality
--------------------------------

--v3.7
CREATE FUNCTION _pgr_betweennessCentrality(
    edges_sql TEXT,
    directed BOOLEAN,

    OUT vid BIGINT,
    OUT centrality FLOAT)
RETURNS SETOF RECORD AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION _pgr_betweennessCentrality(TEXT, BOOLEAN)
IS 'pgRouting internal function';


--v3.7
CREATE FUNCTION pgr_betweennessCentrality(
    TEXT,    -- edges_sql (required)
    directed BOOLEAN DEFAULT true,

    OUT vid BIGINT,
    OUT centrality FLOAT)
RETURNS SETOF RECORD AS
$BODY$

    SELECT vid, centrality
    FROM _pgr_betweennesscentrality(_pgr_get_statement($1), $2);

$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 10000;


COMMENT ON FUNCTION pgr_betweennessCentrality(TEXT, BOOLEAN)
IS 'pgr_betweennessCentrality
- EXPERIMENTAL
- Parameters:
    - edges SQL with columns: source, target, cost [,reverse_cost])
- Optional Parameters:
    - directed := true
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_centrality.html
';



--v3.4
CREATE FUNCTION pgr_degree(
  TEXT,  -- Edges SQL
  TEXT,  -- Vertices SQL

  dryrun BOOLEAN DEFAULT false,

  OUT node BIGINT,
  OUT degree BIGINT
)
RETURNS SETOF RECORD AS
$BODY$
DECLARE
  edges_sql TEXT;
  vertices_sql TEXT;
  has_in_edges BOOLEAN := TRUE;
  has_out_edges BOOLEAN := TRUE;
  eids TEXT;
  query TEXT;

  sqlhint TEXT;

BEGIN

  BEGIN
    edges_sql := _pgr_checkQuery($1);
    PERFORM _pgr_checkColumn(edges_sql, 'id', 'ANY-INTEGER', dryrun => $3);

    vertices_sql := _pgr_checkQuery($2);
    PERFORM _pgr_checkColumn(vertices_sql, 'id', 'ANY-INTEGER', dryrun => $3);

    EXCEPTION WHEN OTHERS THEN
      GET STACKED DIAGNOSTICS sqlhint = PG_EXCEPTION_HINT;
      RAISE EXCEPTION '%', SQLERRM USING HINT = sqlhint, ERRCODE = SQLSTATE;
  END;

  has_in_edges := _pgr_checkColumn(vertices_sql, 'in_edges', 'ANY-INTEGER[]', true, dryrun => $3);
  has_out_edges := _pgr_checkColumn(vertices_sql, 'out_edges', 'ANY-INTEGER[]', true, dryrun => $3);

  IF NOT has_in_edges AND NOT has_out_edges THEN
      RAISE EXCEPTION 'column "in_edges" does not exist' USING HINT = vertices_sql, ERRCODE = 42703;
  END IF;


  IF has_in_edges THEN
    eids = $$coalesce(in_edges::BIGINT[], '{}'::BIGINT[])$$;
  END IF;

  IF has_out_edges THEN
    IF has_in_edges THEN
      eids = E'\n          ' || eids
            || E'\n          ||\n          '
            || $$coalesce(out_edges::BIGINT[], '{}'::BIGINT[])$$;
    ELSE
      eids = $$coalesce(out_edges::BIGINT[], '{}'::BIGINT[])$$;
    END IF;
  ELSE
    IF NOT has_in_edges THEN
      RAISE EXCEPTION 'Missing column'
      USING HINT = 'Column "in_edges" and/or "out_edges" is missing in'||E'\n'||vertices_sql;
    END IF;
  END IF;

  query := format($q$
    WITH

    -- a sub set of edges of the graph goes here
    g_edges AS (
      $q$ || edges_sql || $q$
    ),

    -- sub set of vertices of the graph goes here
    all_vertices AS (
      $q$ || vertices_sql || $q$
    ),

    g_vertices AS (
      SELECT id,
        unnest(%s) AS eid
      FROM all_vertices
    ),

    totals AS (
      SELECT v.id, count(*)
      FROM g_vertices v
      JOIN g_edges e ON (v.eid = e.id) GROUP BY v.id
    )

    SELECT id::BIGINT, count::BIGINT FROM all_vertices JOIN totals USING (id)
    $q$, eids);

  IF dryrun THEN
    RAISE NOTICE '%', query || ';';
  ELSE
    RETURN QUERY EXECUTE query;
  END IF;

END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;

COMMENT ON FUNCTION pgr_degree(TEXT, TEXT, BOOLEAN)
IS 'pgr_degree
- Parameters
- Edges SQL with columns: id
- Vertices SQL with columns: id, in_edges, out_edges
- Documentation:
- https://docs.pgrouting.org/latest/en/pgr_degree.html
';

--v3.8
CREATE FUNCTION pgr_degree(
  TEXT,  -- Edges SQL

  dryrun BOOLEAN DEFAULT false,

  OUT node BIGINT,
  OUT degree BIGINT
)
RETURNS SETOF RECORD AS
$BODY$
DECLARE
  edges_sql TEXT;
  has_id BOOLEAN;
  has_source BOOLEAN;
  has_target BOOLEAN;
  eids TEXT;
  query TEXT;

  sqlhint TEXT;

BEGIN

  -- Verify the data is complete
  BEGIN
    edges_sql := _pgr_checkQuery($1);
    has_id :=  _pgr_checkColumn(edges_sql, 'id', 'ANY-INTEGER', dryrun => $2);
    has_source :=  _pgr_checkColumn(edges_sql, 'source', 'ANY-INTEGER', dryrun => $2);
    has_target :=  _pgr_checkColumn(edges_sql, 'target', 'ANY-INTEGER', dryrun => $2);
    EXCEPTION WHEN OTHERS THEN
      GET STACKED DIAGNOSTICS sqlhint = PG_EXCEPTION_HINT;
      RAISE EXCEPTION '%', SQLERRM USING HINT = sqlhint, ERRCODE = SQLSTATE;
  END;

  query := format($q$

    WITH

    -- a sub set of edges of the graph goes here
    g_edges AS (
      %1$s
    ),

    -- sub set of vertices of the graph goes here
    g_vertices AS (
      SELECT source, id FROM g_edges
      UNION ALL
      SELECT target, id FROM g_edges
    ),

    totals AS (
      SELECT source AS node, count(*) AS degree
      FROM g_vertices
      GROUP BY node
    )

    SELECT node::BIGINT, degree::BIGINT
    FROM totals
    $q$, edges_sql);

  IF dryrun THEN
    RAISE NOTICE '%', query || ';';
  ELSE
    RETURN QUERY EXECUTE query;
  END IF;

END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;

COMMENT ON FUNCTION pgr_degree(TEXT, BOOLEAN)
IS 'pgr_degree
- Parameters
- Edges SQL with columns: id
- Documentation:
- https://docs.pgrouting.org/latest/en/pgr_degree.html
';


--------------------------------
-- _pgr_bandwidth
--------------------------------
--v4.0
CREATE FUNCTION _pgr_bandwidth(
    TEXT,

    OUT bandwidth BIGINT
)
RETURNS BIGINT AS
'MODULE_PATHNAME'
LANGUAGE C VOLATILE STRICT
COST 10000;

-- COMMENTS
COMMENT ON FUNCTION _pgr_bandwidth(TEXT)
IS 'pgRouting internal function';


--v4.0
CREATE FUNCTION pgr_bandwidth(
    TEXT,    -- edges_sql (required)

    OUT bandwidth BIGINT
)
RETURNS BIGINT
AS
$BODY$
    SELECT bandwidth FROM _pgr_bandwidth(_pgr_get_statement($1));
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000;

-- COMMENTS

COMMENT ON FUNCTION pgr_bandwidth(TEXT)
IS 'pgr_bandwidth
- EXPERIMENTAL
- Calculates the bandwidth of graph components based on current vertex ordering.
- Parameters:
    - edges SQL with columns: id, source, target, cost [, reverse_cost]
- Returns:
    - bandwidth BIGINT
- Documentation:
    - https://docs.pgrouting.org/latest/en/pgr_bandwidth.html
';


CREATE OR REPLACE FUNCTION pgr_extractVertices(
    TEXT,  -- SQL inner query (required)

    dryrun BOOLEAN DEFAULT false,

    OUT id BIGINT,
    OUT in_edges BIGINT[],
    OUT out_edges BIGINT[],
    OUT x FLOAT,
    OUT y FLOAT,
    OUT geom geometry
)
RETURNS SETOF RECORD AS
$BODY$
DECLARE
    edges_SQL TEXT;
    quoted TEXT;
    query TEXT;
    has_geom BOOLEAN := TRUE;
    has_st BOOLEAN := TRUE;
    has_source BOOLEAN := TRUE;
    has_target BOOLEAN := TRUE;
    has_points BOOLEAN := TRUE;
    has_start BOOLEAN := TRUE;
    has_end BOOLEAN := TRUE;
    has_id BOOLEAN := TRUE;
    rec RECORD;

    sqlhint TEXT;

BEGIN
  BEGIN
    edges_sql := _pgr_checkQuery($1);
    EXCEPTION WHEN OTHERS THEN
      GET STACKED DIAGNOSTICS sqlhint = PG_EXCEPTION_HINT;
      RAISE EXCEPTION '%', SQLERRM USING HINT = sqlhint, ERRCODE = SQLSTATE;
  END;

  has_id := _pgr_checkColumn(edges_sql, 'id', 'ANY-INTEGER', true, dryrun => $2);
  has_source := _pgr_checkColumn(edges_sql, 'source', 'ANY-INTEGER', true, dryrun => $2);
  has_target := _pgr_checkColumn(edges_sql, 'target', 'ANY-INTEGER', true, dryrun => $2);

  has_geom := _pgr_checkColumn(edges_sql, 'geom', 'geometry', true, dryrun => $2);
  has_start := _pgr_checkColumn(edges_sql, 'startpoint', 'geometry', true, dryrun => $2);
  has_end   := _pgr_checkColumn(edges_sql, 'endpoint', 'geometry', true, dryrun => $2);
  has_points := has_start AND has_end;
  has_st := has_source AND has_target;

  IF (NOT has_geom) THEN
    IF (has_target AND NOT has_source) THEN
        RAISE EXCEPTION 'column "source" does not exist' USING HINT = $1, ERRCODE = 42703;
    ELSIF (NOT has_target AND has_source) THEN
        RAISE EXCEPTION 'column "target" does not exist' USING HINT = $1, ERRCODE = 42703;
    ELSIF (has_start AND NOT has_end) THEN
      RAISE EXCEPTION 'column "endpoint" does not exist' USING HINT = $1, ERRCODE = 42703;
    ELSIF (NOT has_start AND has_end) THEN
      RAISE EXCEPTION 'column "startpoint" does not exist' USING HINT = $1, ERRCODE = 42703;
    ELSIF (NOT has_st AND NOT has_points AND NOT has_geom) THEN
      RAISE EXCEPTION 'column "geom" does not exist' USING HINT = $1, ERRCODE = 42703;
    END IF;
  END IF;


    IF has_geom AND has_id THEN
      -- SELECT id, geom
      query := $q$
        WITH

        main_sql AS (
          $q$ || edges_sql || $q$
        ),

        the_out AS (
          SELECT id::BIGINT AS out_edge, ST_StartPoint(geom) AS geom
          FROM main_sql
        ),

        agg_out AS (
          SELECT array_agg(out_edge ORDER BY out_edge) AS out_edges, ST_x(geom) AS x, ST_Y(geom) AS y, geom
          FROM the_out
          GROUP BY geom
        ),

        the_in AS (
          SELECT id::BIGINT AS in_edge, ST_EndPoint(geom) AS geom
          FROM main_sql
        ),

        agg_in AS (
          SELECT array_agg(in_edge ORDER BY in_edge) AS in_edges, ST_x(geom) AS x, ST_Y(geom) AS y, geom
          FROM the_in
          GROUP BY geom
        ),

        the_points AS (
          SELECT in_edges, out_edges, coalesce(agg_out.geom, agg_in.geom) AS geom
          FROM agg_out
          FULL OUTER JOIN agg_in USING (x, y)
        )

        SELECT row_number() over(ORDER BY ST_X(geom), ST_Y(geom)) AS id, in_edges, out_edges, ST_X(geom), ST_Y(geom), geom
        FROM the_points$q$;

    ELSIF has_geom AND NOT has_id THEN
      -- SELECT startpoint, endpoint
      -- can not get the ins and outs
      query := $q$
        WITH

        main_sql AS (
          $q$ || edges_sql || $q$
        ),

        sub_main AS (
          SELECT ST_StartPoint(geom) AS startpoint, ST_EndPoint(geom) AS endpoint
          FROM main_sql
        ),

        the_out AS (
          SELECT  DISTINCT ST_X(startpoint) AS x, ST_Y(startpoint) AS y, startpoint AS geom
          FROM sub_main
        ),

        the_in AS (
            SELECT DISTINCT ST_X(endpoint) AS x, ST_Y(endpoint) AS y, endpoint AS geom
          FROM sub_main
        ),

        the_points AS (
          SELECT x, y, coalesce(the_out.geom, the_in.geom) AS geom
          FROM the_out
          FULL OUTER JOIN the_in USING (x, y)
        )

        SELECT row_number() over(ORDER BY  ST_X(geom), ST_Y(geom)) AS id, NULL::BIGINT[], NULL::BIGINT[], x, y, geom
        FROM the_points$q$;

    ELSIF has_points AND has_id THEN
      -- SELECT id, startpoint, endpoint
      query := $q$
        WITH

        main_sql AS (
          $q$ || edges_sql || $q$
        ),

        the_out AS (
          SELECT id::BIGINT AS out_edge, startpoint AS geom
          FROM main_sql
        ),

        agg_out AS (
          SELECT array_agg(out_edge ORDER BY out_edge) AS out_edges, ST_x(geom) AS x, ST_Y(geom) AS y, geom
          FROM the_out
          GROUP BY geom
        ),

        the_in AS (
          SELECT id::BIGINT AS in_edge, endpoint AS geom
          FROM main_sql
        ),

        agg_in AS (
          SELECT array_agg(in_edge ORDER BY in_edge) AS in_edges, ST_x(geom) AS x, ST_Y(geom) AS y, geom
          FROM the_in
          GROUP BY geom
        ),

        the_points AS (
          SELECT in_edges, out_edges, coalesce(agg_out.geom, agg_in.geom) AS geom
          FROM agg_out
          FULL OUTER JOIN agg_in USING (x, y)
        )

        SELECT row_number() over(ORDER BY  ST_X(geom), ST_Y(geom)) AS id, in_edges, out_edges, ST_X(geom), ST_Y(geom), geom
        FROM the_points$q$;

    ELSIF has_points AND NOT has_id THEN
      -- SELECT startpoint, endpoint
      -- can not get the ins and outs
      query := $q$
        WITH

        main_sql AS (
          $q$ || edges_sql || $q$
        ),

        the_out AS (
          SELECT DISTINCT ST_X(startpoint) AS x, ST_Y(startpoint) AS y, startpoint AS geom
          FROM main_sql
        ),

        the_in AS (
            SELECT DISTINCT ST_X(endpoint) AS x, ST_Y(endpoint) AS y, endpoint AS geom
          FROM main_sql
        ),

        the_points AS (
          SELECT x, y, coalesce(the_out.geom, the_in.geom) AS geom
          FROM the_out
          FULL OUTER JOIN the_in USING (x, y)
        )

        SELECT row_number() over(ORDER BY  ST_X(geom), ST_Y(geom)) AS id, NULL::BIGINT[], NULL::BIGINT[], x, y, geom
        FROM the_points$q$;

    ELSIF has_st AND has_id THEN
      -- SELECT id, source, target
      query := $q$ WITH

        main_sql AS (
          $q$ || edges_sql || $q$
        ),

        agg_out AS (
          SELECT source AS vid, array_agg(id::BIGINT) AS out_edges
          FROM main_sql
          GROUP BY source
        ),

        agg_in AS (
          SELECT target AS vid, array_agg(id::BIGINT) AS in_edges
          FROM main_sql
          GROUP BY target
        ),

        the_points AS (
          SELECT vid, in_edges, out_edges
          FROM agg_out
          FULL OUTER JOIN agg_in USING (vid)
        )

        SELECT vid::BIGINT AS id, in_edges, out_edges, NULL::FLOAT, NULL::FLOAT, NULL::geometry
        FROM the_points$q$;


    ELSIF has_st AND NOT has_id THEN
      -- SELECT source, target
      query := $q$
        WITH

        main_sql AS (
          $q$ || edges_sql || $q$
        ),


        the_points AS (
          SELECT source AS vid FROM main_sql
          UNION
          SELECT target FROM main_sql
        )

        SELECT DISTINCT vid::BIGINT AS id, NULL::BIGINT[], NULL::BIGINT[], NULL::FLOAT, NULL::FLOAT, NULL::geometry
        FROM the_points$q$;

    END IF;

    IF dryrun THEN
      RAISE NOTICE '%', query || ';';
    ELSE
      RETURN QUERY EXECUTE query;
    END IF;

END;
$BODY$
LANGUAGE plpgsql VOLATILE STRICT;




COMMENT ON FUNCTION pgr_extractVertices(TEXT, BOOLEAN)
IS 'pgr_extractVertices
- Parameters
  - Edges SQL with columns: [id,] startpoint, endpoint
        OR
  - Edges SQL with columns: [id,] source, target
        OR
  - Edges SQL with columns: [id,] geom
- Documentation:
- https://docs.pgrouting.org/latest/en/pgr_extractVertices.html
';


--v3.8
CREATE FUNCTION pgr_findCloseEdges(
  TEXT,
  geometry[],
  FLOAT,
  cap INTEGER DEFAULT 1,
  dryrun BOOLEAN default false,

  OUT edge_id BIGINT,
  OUT fraction FLOAT,
  OUT side CHAR,
  OUT distance FLOAT,
  OUT geom geometry,
  OUT edge geometry)
returns SETOF RECORD AS
$BODY$
DECLARE
  geom_arr geometry[] := $2;
  tolerance FLOAT := $3;
  cap INTEGER := $4;
  dryrun BOOLEAN := $5;
  edges_SQL TEXT;
  has_id BOOLEAN;
  has_geom BOOLEAN;
  ret_query TEXT;
  ret_query_end TEXT;

  sqlhint TEXT;

BEGIN

  IF (tolerance < 0) THEN
    RAISE EXCEPTION 'Invalid value for "tolerance"';
  END IF;

  IF (cap < 0) THEN
    RAISE EXCEPTION 'Invalid value for "cap"';
  END IF;

  BEGIN
    edges_sql := _pgr_checkQuery($1);
    has_id := _pgr_checkColumn(edges_sql, 'id', 'ANY-INTEGER', false, dryrun => dryrun);
    has_geom := _pgr_checkColumn(edges_sql, 'geom', 'geometry', false, dryrun => dryrun);
    EXCEPTION WHEN OTHERS THEN
      GET STACKED DIAGNOSTICS sqlhint = PG_EXCEPTION_HINT;
      RAISE EXCEPTION '%', SQLERRM USING HINT = sqlhint, ERRCODE = SQLSTATE;
  END;

  ret_query = format(
    $q$
WITH
edges_sql AS (%1$s),
point_sql AS (SELECT unnest(%2$L::geometry[]) AS point),
results AS (
  SELECT
    id::BIGINT AS edge_id,
    ST_LineLocatePoint(geom, point) AS fraction,
    CASE WHEN ST_Intersects(ST_Buffer(geom, %3$s, 'side=right endcap=flat'), point)
         THEN 'r'
         ELSE 'l' END::CHAR AS side,
    geom <-> point AS distance,
    point,
    $q$, edges_sql, geom_arr, tolerance);

  ret_query_end = format(
    $q$
  FROM  edges_sql, point_sql
  WHERE ST_DWithin(geom, point, %1$s)
  ORDER BY geom <-> point),
prepare_cap AS (
  SELECT row_number() OVER (PARTITION BY point ORDER BY point, distance) AS rn, *
  FROM results)
SELECT edge_id, fraction, side, distance, point, new_line
FROM prepare_cap
WHERE rn <= %2$s
    $q$, tolerance, cap);

    ret_query = ret_query
      || $q$ST_MakeLine(point, ST_ClosestPoint(geom, point)) AS new_line $q$
      || ret_query_end;

  IF dryrun THEN
    RAISE NOTICE '%', ret_query;
    RETURN;
  END IF;

  RETURN query EXECUTE ret_query;

END;
$BODY$
LANGUAGE PLPGSQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_findCloseEdges(TEXT, GEOMETRY[], FLOAT, INTEGER, BOOLEAN)
IS 'pgr_findCloseEdges(Many Points)
- Parameters:
  - Edges SQL with columns: id, geom
  - Array of POINT geometries
  - Maximum separation between geometries
- Optional Parameters
  - cap => 1: at most one answer
  - dryrun => false: do not output code
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_findCloseEdges.html
';

--v3.8
CREATE FUNCTION pgr_findCloseEdges(
  TEXT,
  geometry,
  FLOAT,
  cap INTEGER DEFAULT 1,
  dryrun BOOLEAN default false,
  OUT edge_id BIGINT,
  OUT fraction FLOAT,
  OUT side CHAR,
  OUT distance FLOAT,
  OUT geom geometry,
  OUT edge geometry)
returns SETOF RECORD AS
$BODY$
  SELECT edge_id, fraction, side, distance, geom, edge
  FROM pgr_findCloseEdges($1, ARRAY[$2]::GEOMETRY[], $3, cap, dryrun);
$BODY$
LANGUAGE SQL VOLATILE STRICT
COST 10000 ROWS 100;

COMMENT ON FUNCTION pgr_findCloseEdges(TEXT, GEOMETRY, FLOAT, INTEGER, BOOLEAN)
IS 'pgr_findCloseEdges(One Point)
- Parameters:
  - Edges SQL with columns: id, geom
  - POINT geometry
  - Maximum separation between geometries
- Optional Parameters
  - cap => 1: at most one answer
  - dryrun => false: do not output code
- Documentation:
   - https://docs.pgrouting.org/latest/en/pgr_findCloseEdges.html
';


--v3.8
CREATE FUNCTION pgr_separateCrossing(
  TEXT, -- edges SQL
  tolerance FLOAT DEFAULT 0.01, -- tolerance
  dryrun BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT id BIGINT,
  OUT sub_id INTEGER,
  OUT geom geometry)
RETURNS SETOF RECORD AS
$BODY$
DECLARE
  edges_sql TEXT := $1;

  the_query TEXT;
  sqlhint TEXT;
  has_geom BOOLEAN;
  has_id BOOLEAN;
BEGIN

  IF tolerance <= 0 THEN
    RAISE EXCEPTION $$'tolerance' must be a positive number (given %)$$, tolerance
      USING ERRCODE = '22023'; -- invalid_parameter_value
  END IF;

  BEGIN
    edges_sql := _pgr_checkQuery($1);
    EXCEPTION WHEN OTHERS THEN
      GET STACKED DIAGNOSTICS sqlhint = PG_EXCEPTION_HINT;
      RAISE EXCEPTION '%', SQLERRM USING HINT = sqlhint, ERRCODE = SQLSTATE;
  END;

  has_id := _pgr_checkColumn(edges_sql, 'id', 'ANY-INTEGER', false, dryrun);
  has_geom := _pgr_checkColumn(edges_sql, 'geom', 'geometry', false, dryrun);

  IF NOT has_id OR NOT has_geom THEN
    RAISE EXCEPTION $$'id' or 'geom' are missing$$ USING HINT = edges_sql;
  END IF;

  the_query := format(
    $$
    WITH
        edges_table AS (
          %s
        ),

    get_crossings AS (
      SELECT e1.id id1, e2.id id2, e1.geom AS g1, e2.geom AS g2, ST_Intersection(e1.geom, e2.geom) AS point
      FROM edges_table e1, edges_table e2
      WHERE e1.id < e2.id AND ST_Crosses(e1.geom, e2.geom)
    ),

    crossings AS (
      SELECT id1, g1, point FROM get_crossings
      UNION
      SELECT id2, g2, point FROM get_crossings
    ),

    blades AS (
      SELECT id1, g1, ST_UnaryUnion(ST_Collect(point)) AS blade
      FROM crossings
      GROUP BY id1, g1
    ),

    collection AS (
      SELECT id1, (st_dump(st_split(st_snap(g1, blade, %2$s), blade))).*
      FROM blades
    )

    SELECT row_number() over()::INTEGER AS seq, id1::BIGINT, path[1], geom
    FROM collection;
    $$,

    edges_sql, tolerance);

    IF dryrun THEN
      RAISE NOTICE '%', the_query || ';';
    ELSE
      RETURN QUERY EXECUTE the_query;
    END IF;

END;
$BODY$ LANGUAGE 'plpgsql' VOLATILE STRICT;

COMMENT ON FUNCTION pgr_separateCrossing(TEXT, FLOAT, BOOLEAN)
IS 'pgr_separateCrossing
- Parameters
  - Edges SQL with columns: id, geom
- Optional parameters
  - tolerance => 0.01
  - dryrun => true
- DOCUMENTATION:
  - https://docs.pgrouting.org/latest/en/pgr_separateCrossing.html
';


--v3.8
CREATE FUNCTION pgr_separateTouching(
  TEXT, -- edges SQL
  tolerance FLOAT DEFAULT 0.01, -- tolerance
  dryrun BOOLEAN DEFAULT false,

  OUT seq INTEGER,
  OUT id BIGINT,
  OUT sub_id INTEGER,
  OUT geom geometry)
RETURNS SETOF RECORD AS
$BODY$
DECLARE
  edges_sql TEXT := $1;

  the_query TEXT;
  sqlhint TEXT;
  has_geom BOOLEAN;
  has_id BOOLEAN;
BEGIN

  BEGIN
    edges_sql := _pgr_checkQuery($1);
    EXCEPTION WHEN OTHERS THEN
      GET STACKED DIAGNOSTICS sqlhint = PG_EXCEPTION_HINT;
      RAISE EXCEPTION '%', SQLERRM USING HINT = sqlhint, ERRCODE = SQLSTATE;
  END;

  has_id := _pgr_checkColumn(edges_sql, 'id', 'ANY-INTEGER', true, dryrun => $3);
  has_geom := _pgr_checkColumn(edges_sql, 'geom', 'geometry', true, dryrun => $3);

  the_query := format($$
    WITH
    edges_table AS (
      %s
    ),

    get_touching AS (
      SELECT e1.id id1, e2.id id2, ST_Snap(e1.geom, e2.geom, %2$s) AS geom, e1.geom AS g1, e2.geom AS g2
      FROM edges_table e1, edges_table e2
      WHERE e1.id != e2.id AND ST_DWithin(e1.geom, e2.geom, %2$s) AND NOT(
        ST_StartPoint(e1.geom) = ST_StartPoint(e2.geom) OR ST_StartPoint(e1.geom) = ST_EndPoint(e2.geom)
        OR ST_EndPoint(e1.geom) = ST_StartPoint(e2.geom) OR ST_EndPoint(e1.geom) = ST_EndPoint(e2.geom))
    ),

    touchings AS (
      SELECT  id1, g1, g2, st_intersection(geom, g2) AS point
      FROM get_touching
      WHERE  NOT (geom = g1) OR
         (ST_touches(g1, g2) AND NOT
            (ST_Intersection(geom, g2) = ST_StartPoint(g1)
             OR ST_Intersection(geom, g2) = ST_EndPoint(g1)))
    ),

    blades AS (
      SELECT id1, g1, ST_UnaryUnion(ST_Collect(point)) AS blade
      FROM touchings
      GROUP BY id1, g1
    ),

    collection AS (
      SELECT id1, (st_dump(st_split(st_snap(g1, blade, %2$s), blade))).*
      FROM blades
    )

    SELECT row_number() over()::INTEGER AS seq, id1::BIGINT, path[1], geom
    FROM collection;
    $$,

    edges_sql, tolerance);

    IF dryrun THEN
      RAISE NOTICE '%', the_query || ';';
    ELSE
      RETURN QUERY EXECUTE the_query;
    END IF;

END;
$BODY$ LANGUAGE 'plpgsql' VOLATILE STRICT;

COMMENT ON FUNCTION pgr_separateTouching(TEXT, FLOAT, BOOLEAN)
IS 'pgr_separateTouching
- Parameters
  - Edges SQL with columns: id, geom
- Optional parameters
  - tolerance => 0.01
  - dryrun => true
- DOCUMENTATION:
  - https://docs.pgrouting.org/latest/en/pgr_separateTouching.html
';


