/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nqo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "\u07dc\u07ed\u07d9\u07cb\u07e3\u07cd\u07d5 \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d8\u07ca",
               "GMT",
               "",
               "BST",
               "",
               "GMT",
            };
        final String[] Reunion = new String[] {
               "\u07d9\u07cb\u07e3\u07cc\u07e6\u07d0\u07f2\u07eb \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "\u07e1\u07cf\u07d9\u07cc\u07db \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2 \u07e2\u07ca\u07d3\u07d8\u07cd",
               "",
               "\u07e1\u07cf\u07d9\u07cc\u07db \u07d5\u07df\u07cb\u07ec\u07e1\u07ca\u07ec \u07d5\u07ce\u07e1\u07ca\u07d9\u07cb\u07f2",
               "",
               "\u07e1\u07cf\u07d9\u07cc\u07db \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "\u07dc\u07d9\u07cb\u07de\u07ce\u07f2\u07eb-\u07dd\u07d9\u07cc\u07db\u07cc\u07eb \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2 \u07e2\u07ca\u07d3\u07d8\u07cd",
               "",
               "\u07dc\u07d9\u07cb\u07de\u07ce\u07f2\u07eb-\u07dd\u07d9\u07cc\u07db\u07cc\u07eb \u07d5\u07df\u07cb\u07ec\u07e1\u07ca\u07ec \u07d5\u07ce\u07e1\u07ca\u07d9\u07cb\u07f2",
               "",
               "\u07dc\u07d9\u07cb\u07de\u07ce\u07f2\u07eb-\u07dd\u07d9\u07cc\u07db\u07cc\u07eb \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u07db\u07cb\u07e6\u07cc\u07db\u07cc\u07df \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u07cd\u07f2\u07d8\u07ce\u07eb \u07df\u07cc\u07f2\u07d3\u07ca\u07f2\u07d8\u07ce\u07ef \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Central = new String[] {
               "\u07dd\u07d8\u07ca\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07d5\u07ca\u07f2\u07d3\u07ca\u07f2 \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2 \u07e2\u07ca\u07d3\u07d8\u07cd",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u07dd\u07d8\u07ca\u07ec\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07d3\u07df\u07cb\u07ec\u07d3\u07d0 \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2 \u07e2\u07ca\u07d3\u07d8\u07cd",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "\u07dd\u07d8\u07ca\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07d5\u07df\u07cb\u07ec\u07d3\u07cb \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2 \u07e2\u07ca\u07d3\u07d8\u07cd",
               "WAT",
               "\u07dd\u07d8\u07ca\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07d5\u07df\u07cb\u07ec\u07d3\u07cb \u07d5\u07df\u07cb\u07ec\u07e1\u07ca\u07ec \u07d5\u07ce\u07e1\u07ca\u07d9\u07cb\u07f2",
               "WAT",
               "\u07dd\u07d8\u07ca\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07d5\u07df\u07cb\u07ec\u07d3\u07cb \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2",
               "WAT",
            };
        final String[] Africa_Southern = new String[] {
               "\u07dd\u07d8\u07cc\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07e5\u07d9\u07cf\u07ec\u07d8\u07ce\u07ee \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb\u07f2 \u07e2\u07ca\u07d3\u07d8\u07cd",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] French_Southern = new String[] {
               "\u07d0\u07db\u07d1\u07d5\u07d9\u07ca\u07df\u07cc\u07eb \u07d8\u07ce\u07f0\u07de\u07df\u07cf \u07e3\u07cc\u07eb \u07dd\u07ca\u07ec\u07d9\u07ca\u07f2\u07ec\u07db\u07cc\u07eb \u07ca\u07f2\u07d5\u07ca\u07d9\u07d1\u07d5\u07cc\u07de \u07d5\u07ce\u07ec\u07e1\u07ca\u07ec\u07d9\u07cb",
               "",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "GMT", GMT },
            { "UTC", EMPTY_ZONE },
            { "CAT", Africa_Central },
            { "EAT", Africa_Eastern },
            { "Etc/GMT", GMT },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Indian/Mahe", Seychelles },
            { "Africa/Accra", GMT },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/London", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Africa/Abidjan", GMT },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Europe/Belfast", GMT },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "Europe/Guernsey", GMT },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Antarctica/Troll", GMT },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Isle_of_Man", GMT },
            { "Africa/Johannesburg", Africa_Southern },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Juba", "\u07d6\u07ce\u07d3\u07ca\u07eb" },
            { "timezone.excity.Africa/Lome", "\u07df\u07cf\u07e1\u07cb\u07eb" },
            { "timezone.excity.Indian/Mahe", "\u07e1\u07ca\u07e4\u07cb\u07eb" },
            { "timezone.excity.Africa/Accra", "\u07ca\u07de\u07d9\u07ca\u07eb" },
            { "timezone.excity.Africa/Cairo", "\u07de\u07cd\u07ef\u07d9" },
            { "timezone.excity.Africa/Dakar", "\u07d8\u07ca\u07ec\u07de\u07ca\u07ef\u07d9\u07ce\u07eb" },
            { "timezone.excity.Africa/Lagos", "\u07df\u07cb\u07dc\u07ed\u07d0\u07db" },
            { "timezone.excity.Africa/Tunis", "\u07d5\u07ce\u07e3\u07cc\u07db" },
            { "timezone.excity.Africa/Asmera", "\u07ca\u07db\u07d1\u07e1\u07d9\u07ca\u07eb" },
            { "timezone.excity.Africa/Bamako", "\u07d3\u07e1\u07ca\u07ec\u07de\u07d0\u07eb" },
            { "timezone.excity.Africa/Bangui", "\u07d3\u07ca\u07f2\u07dc\u07ed\u07cc\u07eb" },
            { "timezone.excity.Africa/Banjul", "\u07d3\u07ca\u07f2\u07d6\u07ce\u07df" },
            { "timezone.excity.Africa/Bissau", "\u07d3\u07cc\u07db\u07ca\u07e5\u07cf\u07eb" },
            { "timezone.excity.Africa/Douala", "\u07d8\u07ce\u07e5\u07df\u07ca\u07eb" },
            { "timezone.excity.Africa/Harare", "\u07e4\u07d9\u07ca\u07d9\u07cb\u07eb" },
            { "timezone.excity.Africa/Kigali", "\u07de\u07cc\u07dc\u07ed\u07ca\u07df\u07cc\u07eb" },
            { "timezone.excity.Africa/Luanda", "\u07df\u07ce\u07e5\u07ca\u07f2\u07d8\u07ca\u07eb" },
            { "timezone.excity.Africa/Lusaka", "\u07df\u07ce\u07db\u07de\u07ca\u07eb" },
            { "timezone.excity.Africa/Malabo", "\u07e1\u07df\u07ca\u07d3\u07cf\u07eb" },
            { "timezone.excity.Africa/Maputo", "\u07e1\u07ca\u07d4\u07ce\u07d5\u07cf\u07eb" },
            { "timezone.excity.Africa/Maseru", "\u07e1\u07ca\u07db\u07cb\u07d9\u07ce\u07eb" },
            { "timezone.excity.Africa/Niamey", "\u07e2\u07ca\u07e1\u07cb\u07eb" },
            { "timezone.excity.Indian/Chagos", "\u07db\u07ca\u07dc\u07ed\u07d0\u07db" },
            { "timezone.excity.Indian/Comoro", "\u07de\u07d0\u07e1\u07d0\u07ef\u07d9" },
            { "timezone.excity.Africa/Abidjan", "\u07ca\u07d3\u07cc\u07d6\u07ca\u07f2\u07ec" },
            { "timezone.excity.Africa/Algiers", "\u07ca\u07df\u07d1\u07d6\u07ed\u07cb" },
            { "timezone.excity.Africa/Conakry", "\u07de\u07d0\u07e3\u07ca\u07de\u07d9\u07cc\u07eb" },
            { "timezone.excity.Africa/Kampala", "\u07de\u07ca\u07f2\u07d4\u07df\u07ca\u07eb" },
            { "timezone.excity.Africa/Mbabane", "\u07d2\u07d3\u07ca\u07d3\u07ca\u07e3" },
            { "timezone.excity.Africa/Nairobi", "\u07e3\u07ca\u07e6\u07d9\u07cf\u07d3\u07cc\u07eb" },
            { "timezone.excity.Africa/Tripoli", "\u07d5\u07d9\u07cc\u07d4\u07df\u07cc\u07eb ( \u07df\u07d3\u07cc\u07eb )" },
            { "timezone.excity.Indian/Mayotte", "\u07e1\u07ca\u07e6\u07d0\u07d5" },
            { "timezone.excity.Indian/Reunion", "\u07d9\u07cb\u07e3\u07cc\u07e6\u07d0\u07f2\u07eb" },
            { "timezone.excity.Africa/Blantyre", "\u07d3\u07d1\u07df\u07ca\u07f2\u07d5\u07cc\u07ef\u07d9" },
            { "timezone.excity.Africa/Djibouti", "\u07d6\u07cc\u07d3\u07ce\u07d5\u07cc\u07eb" },
            { "timezone.excity.Africa/El_Aaiun", "\u07df\u07ca\u07ef\u07e6\u07ce\u07e3" },
            { "timezone.excity.Africa/Freetown", "\u07dd\u07d9\u07cc\u07d5\u07d0\u07f2\u07ec" },
            { "timezone.excity.Africa/Gaborone", "\u07dc\u07ed\u07ca\u07d3\u07cf\u07d9\u07d0\u07e3" },
            { "timezone.excity.Africa/Khartoum", "\u07de\u07ca\u07d9\u07d1\u07d5\u07ce\u07e1" },
            { "timezone.excity.Africa/Kinshasa", "\u07de\u07cc\u07f2\u07db\u07ca\u07db\u07ca\u07eb" },
            { "timezone.excity.Africa/Monrovia", "\u07e1\u07cf\u07ec\u07d9\u07cf\u07dd\u07ed\u07cc\u07e6\u07ca\u07eb" },
            { "timezone.excity.Africa/Ndjamena", "\u07d2\u07d6\u07ca\u07e1\u07cb\u07e3\u07ca\u07eb" },
            { "timezone.excity.Africa/Sao_Tome", "\u07db\u07ca\u07cf-\u07d5\u07cf\u07e1\u07cb\u07eb" },
            { "timezone.excity.Africa/Windhoek", "\u07e5\u07cc\u07f2\u07d8\u07d0\u07de" },
            { "timezone.excity.Africa/Bujumbura", "\u07d3\u07ce\u07d6\u07ed\u07ce\u07f2\u07d3\u07ce\u07d9\u07ca\u07eb" },
            { "timezone.excity.Africa/Mogadishu", "\u07e1\u07cf\u07dc\u07ed\u07ca\u07d8\u07cc\u07db\u07cf\u07eb" },
            { "timezone.excity.Indian/Kerguelen", "\u07de\u07cd\u07d9\u07d1\u07dc\u07ed\u07cb\u07df\u07cd\u07f2\u07eb" },
            { "timezone.excity.Indian/Mauritius", "\u07e1\u07cf\u07d9\u07cc\u07db" },
            { "timezone.excity.Africa/Casablanca", "\u07de\u07db\u07ca\u07d3\u07ce\u07df\u07ca\u07f2\u07de\u07ca\u07eb" },
            { "timezone.excity.Africa/Libreville", "\u07df\u07cc\u07d3\u07d9\u07cb\u07dd\u07ed\u07cc\u07df" },
            { "timezone.excity.Africa/Lubumbashi", "\u07df\u07ce\u07d3\u07ce\u07f2\u07d3\u07ca\u07db\u07cc\u07eb" },
            { "timezone.excity.Africa/Nouakchott", "\u07e3\u07ce\u07e5\u07ca\u07de\u07d1\u07db\u07d0\u07d5" },
            { "timezone.excity.Africa/Porto-Novo", "\u07d4\u07d0\u07d9\u07d1\u07d5\u07cf\u07eb-\u07e3\u07dd\u07ed\u07cf\u07eb" },
            { "timezone.excity.Africa/Addis_Ababa", "\u07ca\u07ec\u07d8\u07cc\u07eb \u07db\u07ca\u07ec\u07d3\u07cb\u07d3\u07ca\u07eb" },
            { "timezone.excity.Africa/Brazzaville", "\u07d3\u07d9\u07d6\u07ed\u07ca\u07dd\u07ed\u07cc\u07df" },
            { "timezone.excity.Africa/Ouagadougou", "\u07e5\u07dc\u07ed\u07ca\u07ec\u07d8\u07dc\u07ed\u07ce\u07eb" },
            { "timezone.excity.Atlantic/St_Helena", "\u07db\u07cd\u07f2\u07d5 \u07e4\u07cb\u07df\u07cd\u07e3" },
            { "timezone.excity.Africa/Johannesburg", "\u07d6\u07ed\u07ce\u07e5\u07ca\u07e3\u07cd\u07db\u07d1\u07d3\u07ce\u07ef\u07d9" },
            { "timezone.excity.Atlantic/Cape_Verde", "\u07dc\u07e6\u07cb\u07de\u07ce\u07f2\u07eb-\u07dd\u07d9\u07cc\u07db\u07cc\u07eb" },
            { "timezone.excity.Indian/Antananarivo", "\u07ca\u07f2\u07d5\u07e3\u07ca\u07e3\u07ca\u07d9\u07cc\u07dd\u07ed\u07cf\u07eb" },
            { "timezone.excity.Africa/Dar_es_Salaam", "\u07d8\u07ca\u07ef\u07d9-\u07db\u07ca\u07ec\u07df\u07ca\u07ef\u07e1" },
        };
        return data;
    }
}
