# v7.1

This release focuses mainly on bugfixes and quality-of-life with the exception of three **experimental** new major additions:
* `foreach` now supports running processes in parallel
* `fanout` is a new builtin that allows sending stdout to the stdin of many processes
* `md` is a new datatype added. Currently only supports rendering markdown tables but more features will follow in future releases

## Breaking Changes

None

## v7.1.xxxx

### Features

* `fanout`: new builtin (EXPERIMENTAL)
* REPL: default prompt modernized
* ANSI titlebar: Windows support added ([PR](https://github.com/lmorg/murex/pull/931))
* autocomplete: add support for substring matches ([discussion](https://github.com/lmorg/murex/discussions/934))
* autocomplete: remove `stat` syscall from recursive directory lookups to improve performance
* `foreach`: parallel support added (EXPERIMENTAL) ([discussion](https://github.com/lmorg/murex/discussions/933))
* macro vars: history support added (history stored in cache.db)
* integrations: `basti` autocomplete
* integrations: Charm Bracelet's `freeze`
* tooling: Makefile added for simplified development on POSIX systems
* `runtime --about`: `GOMAXPROCS` field added
* xml: improved interop between CSV and XML
* core: data types can now register what their layout type is. Allowing for `format` to better deduce how to reformat the data. eg next few refinements below
* csv: support for JSON and YAML maps
* yaml: convert tables to maps
* json: convert tables to maps
* `select`: support for maps
* `config`: new option: **syntax-completion-enabled**
* `config`: new option: **history-write-enabled**
* md: new datatype, markdown (EXPERIMENTAL)
* murex: new flag added: `-ignore-whatsnew`
* core: hint text added for `cd -` ([PR](https://github.com/lmorg/murex/pull/951))
* core: errors reformatted to make them slightly easier to read
* `test`: default test report now uses the full width of the terminal, plus other minor readability improvements
* docgen: new functions added
* docgen: support for metadata
* Update dependencies

### Bug Fixes

* `datetime`: stdout datatype set to `str`
* `fid-kill`: autocomplete fix ([issue](https://github.com/lmorg/murex/issues/949))
* exec: don't error on wait if PID is already closed ([issue](https://github.com/lmorg/murex/issues/946))
* spellcheck: fixed bug causing users to be re-prompted when `aspell` isn't installed
* REPL: fixed regression bug causing hint text not to display application hints
* `murex-package`: working directory preserved when installing packages
* readline: panic fixed in command line preview
* cache.db: fixed potential race condition when checking if cache.db is enabled
* REPL: fixed potential race condition when instantiating `readline`
* tests: `env` test skips on Windows, uses full path on POSIX
* tests: skip tilde parser test if username contains non-var chars (eg `@`)
* readline: null check when using tab grid
* readline: improved SGR detection
* readline: fixed wider character rendering bug when using tab grid
* readline: fixed potential race condition with read/write access to unicode slices
* readline: fixed potential race condition with terminal width caching
* readline: fixed potential race condition with asynchronous updates to tab completion
* readline: fixed potential race condition with hint text height reporting
* readline: fixed potential race condition with tab completion height reporting
* readline: fixed potential race condition with previews
* readline: fixed potential race condition with hint text cache

## Special Thanks

Thank yous for this release goes to [TheBearodactyl](https://github.com/TheBearodactyl), [JeffMelton](https://github.com/JeffMelton), [Th0rgal](https://github.com/Th0rgal), [lokalius](https://github.com/lokalius), [tiymat](https://github.com/tiymat) for your code, testing and feedback.

Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!

<hr>

Published: 23.10.2025 at 22:35

## See Also

* [Date And Time Conversion: `datetime`](../commands/datetime.md):
  A date and/or time conversion tool (like `printf` but for date and time values)
* [For Each In array: `foreach`](../commands/foreach.md):
  Iterate through an array
* [How To Contribute](../Murex/CONTRIBUTING.md):
  Murex is community project. We gratefully accept contributions
* [Inline SQL: `select`](../optional/select.md):
  Inlining SQL into shell pipelines
* [Integrations](../user-guide/integrations.md):
  Default integrations shipped with Murex
* [Interactive Shell](../user-guide/interactive-shell.md):
  What's different about Murex's interactive shell?
* [Kill Function: `fid-kill`](../commands/fid-kill.md):
  Terminate a running Murex function
* [Send pipes to multiple processes: `fanout` (EXPERIMENTAL)](../commands/fanout.md):
  Copies stdin and sends it to multiple pipelines, collating their output
* [Shell Configuration And Settings: `config`](../commands/config.md):
  Query or define Murex runtime settings
* [Shell Runtime: `runtime`](../commands/runtime.md):
  Returns runtime information on the internal state of Murex
* [Shell Script Tests: `test`](../commands/test.md):
  Murex's test framework - define tests, run tests and debug shell scripts
* [Spellcheck](../integrations/spellcheck.md):
  How to enable inline spellchecking
* [Tab Autocompletion: `autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line

<hr/>

This document was generated from [gen/changelog/v7.1_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v7.1_doc.yaml).