# v7.0

Introducing experimental support for XML, new integrations, and several other quality-of-life improvements. Four deprecated builtins have been removed too, which is this release sees an increment of its major version number

## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`

* backtick strings (````) has been an undocumented hack for several years. This release officially sees that hack as deprecated and will be removed in the next release

## Breaking Changes

The following builtins have been removed in this release, having been marked as deprecated for 2 years or longer.

* `die` has been removed because it adds a feature for no purpose. It was original borrowed from Perl but realistically you can do the same with `exit 1` so this removal is to bring the language complexity down.

* the `=` and `let` builtins are now removed. These builtins were created back before expressions were a first class citizen in Murex. Now these serve no purpose and just add clutter to the language specification.

* `tread` is now longer needed due to `read` supporting all `tread`'s use cases.

You can still compile Murex to include these builtins via by including the following compile-time tag: `deprecated_builtins`. However we recommend you use the more modern syntax instead.

## v7.0.0xxx

### Features

* `xml`: new data type support added (**EXPERIMENTAL**) ([read more](/docs/types/xml.md))
* `pretty`: new flag added `--type` ([read more](/docs/commands/pretty.md))
* core: support added for running Murex scripts against specific versions of Murex
* index: new behavior introduced for v8.0.x
* `runtime`: new flag added `--module-murex-version` ([read more](/docs/commands/runtime.md))
* `get` & `post`: `Body` can now be marshalled into JSON. Even if `Body` was originally a different Content-Type, like XML ([read more](/docs/commands/get.md))
* `onPrompt`: new event interrupt: `command-completion` ([read more](/docs/events/onprompt.md))
* readline: VIM command mode ([read more](/docs/user-guide/terminal-keys.md))
* `$MUREX_HISTORY`: new environmental variable for changing the write location of Murex's history file ([read more](/docs/variables/murex_history.md))
* `$MUREX_CONFIG_DIR`: new environmental variable for changing the write location of all of Murex's config and profiles ([read more](/docs/variables/murex_config_dir.md))
* core: RISC-V 64 CPU support added (**EXPERIMENTAL**)
* `cd`: support added for OSC 7 ANSI escape sequence ([read more](/docs/commands/cd.md))
* `getfile` & `open`: additional type inference logic for `text/plain` Content-Types ([issue #915](https://github.com/lmorg/murex/issues/915), [read more](/docs/commands/getfile.md))
* core: system profile now loaded after `.murex_preload`
* core: add support for preloading code in modules
* integration: support added for OpenTofu
* integration: support added for Orbstack
* integration: support added for Ollama
* integration: updates for Ttyphoon
* readline: add support for line defaults
* readline: `ctrl`+`n` for next line ([issue #924](https://github.com/lmorg/murex/discussions/924), [read more](/docs/user-guide/terminal-keys.md))
* readline: `ctrl`+`p` for previous line ([issue #924](https://github.com/lmorg/murex/discussions/924), [read more](/docs/user-guide/terminal-keys.md))
* source: support for loading modules

### Bug Fixes

* readline: fix end of line cursor position bug when using `B` with VIM keys
* readline: don't show preview if no preview is set
* core: file extension checks from HTTP was happening before content-type normalisation
* core: `<fid:var>` was failing to set `$var` with FID

## Special Thanks

Thank yous for this release goes to [tiymat](https://github.com/tiymat), [atagen](https://github.com/atagen) for your testing and feedback.

Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!

<hr>

Published: 14.04.2025 at 23:50

## See Also

* [Change Directory: `cd`](../commands/cd.md):
  Change (working) directory
* [Download File: `getfile`](../commands/getfile.md):
  Makes a standard HTTP request and return the contents as Murex-aware data type for passing along Murex pipelines.
* [HTTP(S) Get Request: `get`](../commands/get.md):
  Makes a standard HTTP request and returns the result as a JSON object
* [HTTP(S) Post Request: `post`](../commands/post.md):
  HTTP POST request with a JSON-parsable return
* [How To Contribute](../Murex/CONTRIBUTING.md):
  Murex is community project. We gratefully accept contributions
* [MUREX_CONFIG_DIR](../variables/murex_config_dir.md):
  Defines the path to Murex's config
* [MUREX_HISTORY](../variables/murex_history.md):
  Defines the path to the `.murex_history` log
* [Murex Event Subsystem: `event`](../commands/event.md):
  Event driven programming for shell scripts
* [Open File: `open`](../commands/open.md):
  Open a file with a preferred handler
* [Prettify Objects: `pretty`](../commands/pretty.md):
  Prettifies data documents to make it human readable
* [Shell Runtime: `runtime`](../commands/runtime.md):
  Returns runtime information on the internal state of Murex
* [`MUREX_PRELOAD` (str)](../variables/murex_preload.md):
  Defines the path to the `.murex_preload` script
* [`xml`](../types/xml.md):
  Extensible Markup Language (XML) (experimental)
* [index](../parser/item-index.md):
  Outputs an element from an array, map or table
* [onPrompt](../events/onprompt.md):
  Events triggered by changes in state of the interactive shell

<hr/>

This document was generated from [gen/changelog/v7.0_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v7.0_doc.yaml).