/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.ChecksumProcessor;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named(value="basic")
public final class BasicRepositoryConnectorFactory
implements RepositoryConnectorFactory {
    public static final String NAME = "basic";
    private final TransporterProvider transporterProvider;
    private final RepositoryLayoutProvider layoutProvider;
    private final ChecksumPolicyProvider checksumPolicyProvider;
    private final PathProcessor pathProcessor;
    private final ChecksumProcessor checksumProcessor;
    private final Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private float priority;

    @Inject
    public BasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, PathProcessor pathProcessor, ChecksumProcessor checksumProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        this.transporterProvider = Objects.requireNonNull(transporterProvider, "transporter provider cannot be null");
        this.layoutProvider = Objects.requireNonNull(layoutProvider, "repository layout provider cannot be null");
        this.checksumPolicyProvider = Objects.requireNonNull(checksumPolicyProvider, "checksum policy provider cannot be null");
        this.pathProcessor = Objects.requireNonNull(pathProcessor, "path processor cannot be null");
        this.checksumProcessor = Objects.requireNonNull(checksumProcessor, "checksum processor cannot be null");
        this.providedChecksumsSources = Objects.requireNonNull(providedChecksumsSources, "provided checksum sources cannot be null");
    }

    public float getPriority() {
        return this.priority;
    }

    public BasicRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new BasicRepositoryConnector(session, repository, this.transporterProvider, this.layoutProvider, this.checksumPolicyProvider, this.pathProcessor, this.checksumProcessor, this.providedChecksumsSources);
    }
}

