#!/bin/sh

# macOS-Fortress: Firewall, Blackhole, and Privatizing Proxy
# for Trackers, Attackers, Malware, Adware, and Spammers

# macos_fortress_setup_check.sh

# commands

SUDO=/usr/bin/sudo
PORT=/opt/local/bin/port
LAUNCHCTL=/bin/launchctl
PFCTL=/sbin/pfctl
KILLALL=/usr/bin/killall
CAT=/bin/cat
SED=/usr/bin/sed
GREP=/usr/bin/grep
EGREP=/usr/bin/egrep
ECHO=/bin/echo
PFCTL=/sbin/pfctl
HEAD=/usr/bin/head
TAIL=/usr/bin/tail
LSOF=/usr/sbin/lsof
KILLALL=/usr/bin/killall
PS=/bin/ps
WC=/usr/bin/wc
CURL=/usr/bin/curl
AWK=/usr/bin/awk
HOSTNAME=/bin/hostname

JSC=/System/Library/Frameworks/JavaScriptCore.framework/Versions/A/Helpers/jsc

PROXY_HOSTNAME="${PROXY_HOSTNAME:-localhost}"
LAUNCHDAEMONS=/Library/LaunchDaemons
# apache for proxy.pac
if ! [ -d /Applications/Server.app ]
then
    # macOS native apache server for proxy.pac
    PROXY_PAC_DIRECTORY="${PROXY_PAC_DIRECTORY:-/Library/WebServer/Documents}"
else
    # macOS Server for proxy.pac
    PROXY_PAC_DIRECTORY="${PROXY_PAC_DIRECTORY:-/Library/WebServer/Sites/${PROXY_HOSTNAME}}"
fi

fname_exists () { [ -f "${FNAME}" ] && echo "[✅] ${FNAME} exists" || echo "[❌] ${FNAME} DOESN'T EXIST!"; }

# print launchd status, or echo "# comment line"
launchctl_check () { "${EGREP}" -q -e '^(\d+|-)+\s[0]' <<< "${LINE}" && echo "[✅]\t${LINE}" || echo "[❌]\t${LINE}"; }

# launchctl_check () { [ "${PLIST##\#*}" == "" ] && echo "${PLIST}" || ( [ -f "${LAUNCHDAEMONS}/${PLIST}" ] && ( LINE=`"${SUDO}" "${LAUNCHCTL}" list | "${EGREP}" -e $(echo "${PLIST}" | "${SED}" -e 's/.plist$//')'$'`; "${EGREP}" -q -e '^(\d+|-)+\s[0]' <<< "${LINE}" && echo "[✅] ${LINE}" || "[❌] ${LINE}" ) || echo "[❌] ${LAUNCHDAEMONS}/${PLIST}: NOT INSTALLED!"; ) }

"${CAT}" <<HELPSTRING
Checking macOS-Fortress installed items (run as sudo)…
HELPSTRING

# launchcd.plist
"${CAT}" <<EOF

Checking launchd.plist files…
EOF

LAUNCHD_PLISTS=( \
        org.macports.macos-fortress \
        org.macports.macos-fortress-pf \
        org.macports.macos-fortress-pf.brutexpire \
        org.macports.macos-fortress-pf.subports \
        org.macports.macos-fortress-dshield \
        org.macports.macos-fortress-emergingthreats \
        org.macports.macos-fortress-proxy \
        org.macports.macos-fortress-hosts \
        org.macports.adblock2privoxy \
        org.macports.adblock2privoxy-nginx \
        org.macports.Privoxy \
    )

for PLIST in "${LAUNCHD_PLISTS[@]}" \
	; do \
	FNAME="${LAUNCHDAEMONS}/${PLIST}.plist"; \
	fname_exists; \
done

"${CAT}" <<'EOF'

Checking launchd.plist's. These should all be installed with return
code 0 (2d column of `sudo launchctl list`)…
EOF

IFS="|"
LAUNCHD_PLISTS_REGEX="(${LAUNCHD_PLISTS[*]%%.plist})"
IFS=$'\n'
LAUNCHD_LIST=(`"${SUDO}" "${LAUNCHCTL}" list | "${EGREP}" "${LAUNCHD_PLISTS_REGEX}"`)

# loaded launchcd.plist's
for LINE in "${LAUNCHD_LIST[@]}" \
	; do \
	launchctl_check; \
done
# unloaded launchcd.plist's
LAUNCHD_SERVICES=(`for L in "${LAUNCHD_LIST[@]}"; do "${AWK}" '{ print $3 }' <<< "${L}"; done`)
IFS="|"
LAUNCHD_SERVICES_REGEX="(${LAUNCHD_SERVICES[*]})"
IFS=$'\n'
for SERVICE in "${LAUNCHD_PLISTS[@]}" \
	; do \
	"${EGREP}" -q -e "${LAUNCHD_SERVICES_REGEX}" <<< "${SERVICE%%.plist}" \
	|| echo "[❌] ${SERVICE%%.plist} isn't loaded!"; \
done

# PF
"${CAT}" <<EOF

Checking PF files…
EOF

unset IFS
PF_FILES=( \
	/opt/local/etc/macos-fortress/pf.conf \
	/opt/local/etc/macos-fortress/blockips.conf \
        /opt/local/etc/macos-fortress/emerging-Block-IPs.txt \
        /opt/local/etc/macos-fortress/compromised-ips.txt \
        /opt/local/etc/macos-fortress/dshield_block_ip.txt \
	/opt/local/etc/macos-fortress/block.txt \
	/opt/local/etc/macos-fortress/block.txt.asc \
) 
for FNAME in "${PF_FILES[@]}" \
	; do \
	fname_exists; \
done

"${CAT}" <<EOF

Checking PF…
EOF

# pfctl
if [[ `"${SUDO}" "${PFCTL}" -s info | "${HEAD}" -1 | "${TAIL}" -1` =~ "Status: Enabled" ]]; then
    echo "[✅] PF is enabled and running"
else
    "${CAT}" <<EOF
[❌] PF isn't enabled! Troubleshooting:

sudo pfctl -si
less /opt/local/var/log/macos-fortress.log
sudo /opt/local/bin/gpg --homedir /var/root/.gnupg --list-keys | grep -A2 -B1 -i dshield.org
sudo pfctl -Fall && sudo pfctl -ef /opt/local/etc/macos-fortress/pf.conf
EOF
fi

# hosts
"${CAT}" <<EOF

Checking hosts files…
EOF

HOSTS_FILES=( \
	/opt/local/etc/macos-fortress/macos-fortress-hosts \
	/opt/local/etc/macos-fortress/whitelist.txt \
	/opt/local/etc/macos-fortress/blacklist.txt \
)

for FNAME in "${HOSTS_FILES[@]}" \
	; do \
	fname_exists; \
done

"${CAT}" <<EOF

Checking /opt/local/etc/macos-fortress/macos-fortress-hosts creation…
EOF

# pfctl
if [ -f /opt/local/etc/macos-fortress/macos-fortress-hosts ]; then
    echo "[✅] /opt/local/etc/macos-fortress/macos-fortress-hosts exists"
else
    "${CAT}" <<EOF
[❌] /opt/local/etc/macos-fortress/macos-fortress-hosts doesn't exist! Troubleshooting:

sudo port reload org.macports.macos-fortress-hosts
sudo launchctl kickstart -k system/org.macports.macos-fortress-hosts
EOF
fi

# Proxy PAC and proxy chain
"${CAT}" <<EOF

Checking proxy PAC and proxy chain files…
EOF

PROXY_FILES=( \
	"${PROXY_PAC_DIRECTORY}/proxy.pac.orig" \
	"${PROXY_PAC_DIRECTORY}/proxy.pac" \
	/opt/local/bin/adblock2privoxy \
        /opt/local/etc/macos-fortress/proxy.pac \
	/opt/local/etc/adblock2privoxy/nginx.conf \
        /opt/local/etc/adblock2privoxy/css/default.html \
        /opt/local/etc/macos-fortress/macos-fortress-hosts.action \
        /opt/local/etc/adblock2privoxy/privoxy/ab2p.action \
        /opt/local/etc/adblock2privoxy/privoxy/ab2p.filter \
        /opt/local/etc/adblock2privoxy/privoxy/ab2p.system.action \
        /opt/local/etc/adblock2privoxy/privoxy/ab2p.system.filter \
        /opt/local/etc/privoxy/config \
        /opt/local/var/log/privoxy/logfile \
)

for FNAME in "${PROXY_FILES[@]}" \
	; do \
	fname_exists; \
done

"${CAT}" <<EOF

Checking proxy status…
EOF

# privoxy
if [[ `"${SUDO}" "${LSOF}" -i ':8118' | "${TAIL}" -1` ]]; then
    echo "[✅] Privoxy is running properly"
else
    "${CAT}" <<EOF
[❌] Privoxy isn't running properly! Troubleshooting:

sudo less /opt/local/var/log/privoxy/logfile
sudo port reload privoxy
EOF
fi

# Privoxy configuration http://p.p/ via proxy server
if [[ `( http_proxy=http://${PROXY_HOSTNAME}:8118; "${CURL}" -s --head http://p.p/ | "${HEAD}" -n 1 | "${GREP}" "HTTP/1.\d [23]\d\d" )` ]]; then
    echo "[✅] Privoxy config http://p.p/ via http://${PROXY_HOSTNAME}:8118 is running properly"
else
    "${CAT}" <<EOF
[❌] Privoxy config http://p.p/ via http://${PROXY_HOSTNAME}:8118 isn't running properly! Troubleshooting:

sudo less /opt/local/var/log/privoxy/logfile
sudo port reload privoxy
EOF
fi

# nginx
if [[ `"${SUDO}" "${LSOF}" -i ':8119' | "${TAIL}" -1` ]]; then
    echo "[✅] nginx is running properly"
else
    "${CAT}" <<'EOF'
[❌] nginx isn't running properly! Troubleshooting:

sudo ps -f `cat /opt/local/var/run/nginx/nginx-adblock2privoxy.pid`
sudo port reload org.macports.adblock2privoxy-nginx
EOF
fi

# Javascript parsing of proxy.pac.orig and proxy.pac
if [ -x "${JSC}" -a -f "${PROXY_PAC_DIRECTORY/proxy.pac.orig}" ]; then \
    "${JSC}" "${PROXY_PAC_DIRECTORY}/proxy.pac.orig" >/dev/null 2>&1 \
	&& echo "[✅] PAC ${PROXY_PAC_DIRECTORY}/proxy.pac.orig passes Javascript parsing" \
	|| echo "[❌] PAC ${PROXY_PAC_DIRECTORY}/proxy.pac.orig fails Javascript parsing" ; \
fi
if [ -x "${JSC}" -a -f "${PROXY_PAC_DIRECTORY}/proxy.pac" ]; then \
    "${JSC}" "${PROXY_PAC_DIRECTORY}/proxy.pac" >/dev/null 2>&1 \
	&& echo "[✅] PAC ${PROXY_PAC_DIRECTORY}/proxy.pac passes Javascript parsing" \
	|| echo "[❌] PAC ${PROXY_PAC_DIRECTORY}/proxy.pac fails Javascript parsing" ; \
fi

# proxy.pac on proxy server
if [[ `"${CURL}" -s --head "http://${PROXY_HOSTNAME}/proxy.pac" | "${HEAD}" -n 1 | "${GREP}" "HTTP/1.\d [23]\d\d"` ]]; then
    echo "[✅] Web server for http://${PROXY_HOSTNAME}/proxy.pac is running properly"
else
    "${CAT}" <<EOF
[❌] Web server for http://${PROXY_HOSTNAME}/proxy.pac isn't running properly! Troubleshooting:

sudo apachectl start
EOF
fi

# blackhole on proxy server
if [[ `"${CURL}" -s --head "https://${PROXY_HOSTNAME}:8119/" | "${HEAD}" -n 1 | "${GREP}" "HTTP/1.[01] [23]\d\d"` ]]; then
    echo "[✅] Blackhole server for https://${PROXY_HOSTNAME}:8119/ is running properly"
else
    "${CAT}" <<EOF
[❌] Blackhole server for https://${PROXY_HOSTNAME}:8119/ isn't running properly! Troubleshooting:

sudo ps -f \`cat /opt/local/var/run/nginx/nginx-adblock2privoxy.pid\`
sudo port reload org.macports.adblock2privoxy-nginx
EOF
fi
