/* lhtml.h: definitions for libhtmlparse
   Mooneer Salem <mooneer@translator.cx> */

#ifndef LHTML_H
#define LHTML_H

#define LHTML_EOF -128

/* lhtml_param_list */
struct _lhtml_param_list {
        char *name, *val;
        struct _lhtml_param_list *next;
};

typedef struct _lhtml_param_list lhtml_param_list;

/* enum lhtml_tag */
enum lhtml_tag { TAG_A, TAG_BASE, TAG_H1, TAG_H2, TAG_H3, TAG_H4,
        TAG_H5, TAG_H6, TAG_HR, TAG_P, TAG_STYLE, TAG_DIV, TAG_BR,
        TAG_FONT, TAG_IMG, TAG_CLASS, TAG_APPLET, TAG_EMBED, TAG_HTML,
        TAG_HEAD, TAG_BODY, TAG_META, TAG_OTHER};

/* enum lhtml_type */
enum lhtml_type { TYPE_HTMLTAG, TYPE_TEXT, TYPE_COMMENT, TYPE_DECL, TYPE_ENTITY };

/* lhtml_tree */
struct _lhtml_tree {
        enum lhtml_type type;
        enum lhtml_tag tag;
        char *other_tag; /* if type = TYPE_TEXT, will contain text */
        int end; /* 0 = start tag, 1 = end tag */

        lhtml_param_list *params;
        struct _lhtml_tree *parent, *children, *next;
};

typedef struct _lhtml_tree lhtml_tree;

/* lhtml_tagnameval */
struct _lhtml_tagnameval {
        char *name;
        enum lhtml_tag tag;
};

typedef struct _lhtml_tagnameval lhtml_tagnameval;

/* internal functions. DO NOT USE. */
int lhtml_text (char *text);
int lhtml_comment (char *text);
enum lhtml_tag lhtml_tagis (char *tag);
char *lhtml_tagtext (enum lhtml_tag tag);
int lhtml_endtag (char *tag);
int lhtml_add_start_tag (lhtml_tree *tree);
int lhtml_add_decl_tag (lhtml_tree *tree);
int lhtml_add_param (lhtml_tree *tree, char *param, char *val);
void lhtml_free_param_list (lhtml_param_list *params);
int lhtml_entity (char *text);
int lhtmlwrap (void);
int lhtmllex (void);

/* ANSI compliance functions */
char *lhtml_strdup (char *string);
int lhtml_strcasecmp(char *haystack, char *needle);

/* these are safe to use outside of lhtml.y */

/* use this when you're done parsing so you can get the struct */
lhtml_tree *lhtml_end_parse (void);

/* begin (or continue) parsing from a given file handle */
void lhtml_parse_filehandle (FILE *fp);

/* begin (or continue) parsing from a string */
void lhtml_parse_string (char *string);

/* dump the contents of the tree to standard output (for debugging).
   tab_count should be 0 in most cases, since this function is recursive
   and will add 1 to that number before calling itself again. */
int lhtml_dump (lhtml_tree *temp, int tab_count);

/* frees the contents of the tree, use when done with it */
void lhtml_free (lhtml_tree *temp);

/* Callback functions/data structures. these are public too */

/* lhtml_callback_list */

struct _lhtml_callback_list {
	int (*func)(lhtml_tree *entry, void *data);
	enum lhtml_tag tag;
	char *other_tag; /* misc tags */
	int end;
	enum lhtml_type type;
	void *data;
	struct _lhtml_callback_list *next;
};

typedef struct _lhtml_callback_list lhtml_callback_list;

/* callback defines */

#define LHTML_CB_REJECTED -1	/* rejected parsing, goto next handler */
#define LHTML_CB_DONE 0		/* stop parsing */
#define LHTML_CB_CONTINUE 1	/* everything is ok */

/* functions */

lhtml_callback_list *lhtml_add_callback(lhtml_callback_list *list, enum lhtml_tag tag,
	char *other_tag, int end, enum lhtml_type type, 
	int (*func)(lhtml_tree *entry, void *data), void *data);

void lhtml_parse_tree (lhtml_tree *tree, lhtml_callback_list *list);
void lhtml_callback_free (lhtml_callback_list *list);

#endif
