/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.api.extensions.Extension;
import org.jreleaser.model.api.tools.Jbang;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;

public final class Extension
extends AbstractModelObject<Extension>
implements Domain,
EnabledAware {
    private static final long serialVersionUID = -4404376822137828992L;
    private final List<Provider> providers = new ArrayList<Provider>();
    private final org.jreleaser.model.internal.tools.Jbang jbang = new org.jreleaser.model.internal.tools.Jbang();
    private Boolean enabled;
    private String name;
    private String gav;
    private String directory;
    @JsonIgnore
    private final org.jreleaser.model.api.extensions.Extension immutable = new org.jreleaser.model.api.extensions.Extension(){
        private static final long serialVersionUID = -2686799718269690059L;
        private List<? extends Extension.Provider> providers;

        public String getName() {
            return Extension.this.name;
        }

        public String getGav() {
            return Extension.this.gav;
        }

        public String getDirectory() {
            return Extension.this.directory;
        }

        public Jbang getJbang() {
            return Extension.this.jbang.asImmutable();
        }

        public List<? extends Extension.Provider> getProviders() {
            if (null == this.providers) {
                this.providers = Extension.this.providers.stream().map(Provider::asImmutable).collect(Collectors.toList());
            }
            return this.providers;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Extension.this.asMap(full));
        }

        public boolean isEnabled() {
            return Extension.this.isEnabled();
        }
    };

    public org.jreleaser.model.api.extensions.Extension asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Extension source) {
        this.enabled = this.merge(this.enabled, source.enabled);
        this.name = this.merge(this.name, source.name);
        this.gav = this.merge(this.gav, source.gav);
        this.directory = this.merge(this.directory, source.directory);
        this.setJbang(source.jbang);
        this.setProviders(this.merge(this.providers, source.providers));
    }

    @Override
    public boolean isEnabled() {
        return null != this.enabled && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return null != this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGav() {
        return this.gav;
    }

    public void setGav(String gav) {
        this.gav = gav;
    }

    public org.jreleaser.model.internal.tools.Jbang getJbang() {
        return this.jbang;
    }

    public void setJbang(org.jreleaser.model.internal.tools.Jbang jbang) {
        this.jbang.merge(jbang);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Provider> providers) {
        this.providers.clear();
        this.providers.addAll(providers);
    }

    public void addProvider(Provider provider) {
        if (null != provider) {
            this.providers.add(provider);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("gav", this.gav);
        props.put("directory", this.directory);
        props.put("jbang", this.jbang.asMap(full));
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.providers.size(); ++i) {
            m.put("provider " + i, this.providers.get(i).asMap(full));
        }
        props.put("providers", m);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, props);
        return map;
    }

    public static final class Provider
    extends AbstractModelObject<Provider>
    implements Domain {
        private static final long serialVersionUID = -6536770909683740039L;
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
        private String type;
        @JsonIgnore
        private final Extension.Provider immutable = new Extension.Provider(){
            private static final long serialVersionUID = 6167354406466230040L;

            public String getType() {
                return type;
            }

            public Map<String, Object> getProperties() {
                return Collections.unmodifiableMap(properties);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Extension.Provider asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Provider source) {
            this.type = this.merge(this.type, source.type);
            this.setProperties(this.merge(this.properties, source.properties));
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", this.type);
            map.put("properties", this.getProperties());
            return map;
        }
    }
}

