/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.cli.internal;

import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kordamp.jarviz.cli.IO;
import org.kordamp.jarviz.cli.internal.AbstractCommand;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command
public abstract class AbstractJarvizSubcommand<C extends IO>
extends AbstractCommand<C> {
    @CommandLine.Option(names={"--fail-on-error"}, negatable=true, defaultValue="true", fallbackValue="true")
    public boolean failOnError;
    @CommandLine.Option(names={"--directory"})
    public Path[] directory;
    @CommandLine.Option(names={"--file"})
    public Path[] file;
    @CommandLine.Option(names={"--gav"})
    public String[] gav;
    @CommandLine.Option(names={"--url"})
    public URL[] url;
    @CommandLine.Option(names={"--classpath"})
    public String[] classpath;
    @CommandLine.Option(names={"--cache-directory"}, paramLabel="<directory>")
    public Path cache;
    @CommandLine.ParentCommand
    public C parent;
    @CommandLine.Option(names={"--report-path"}, paramLabel="<path>")
    protected Path reportPath;
    @CommandLine.Option(names={"--report-format"}, paramLabel="<format>")
    Format[] reportFormats;
    @CommandLine.Option(names={"--output-format"}, paramLabel="<format>")
    protected Format outputFormat;

    @Override
    protected C parent() {
        return this.parent;
    }

    @Override
    protected int execute() {
        return 0;
    }

    protected Set<Format> resolveReportFormats() {
        if (null != this.reportPath && (null == this.reportFormats || this.reportFormats.length == 0)) {
            return Collections.singleton(Format.TXT);
        }
        return null == this.reportFormats ? Collections.emptySet() : Arrays.stream(this.reportFormats).collect(Collectors.toSet());
    }

    protected Set<Path> collectEntries(Path[] input) {
        TreeSet<Path> set = new TreeSet<Path>();
        if (null != input) {
            Collections.addAll(set, input);
        }
        return set;
    }

    protected Set<URL> collectEntries(URL[] input) {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (null != input) {
            Collections.addAll(set, input);
        }
        return set;
    }

    protected Set<String> collectEntries(String[] input) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (null != input) {
            for (String s : input) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                set.add(s.trim());
            }
        }
        return set;
    }
}

