/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.kordamp.jarviz.core.model.BytecodeVersion;

public class BytecodeVersions {
    private final Set<BytecodeVersion> manifestBytecode = new TreeSet<BytecodeVersion>();
    private final Map<BytecodeVersion, List<String>> unversionedClasses = new LinkedHashMap<BytecodeVersion, List<String>>();
    private final Map<Integer, Map<BytecodeVersion, List<String>>> versionedClasses = new LinkedHashMap<Integer, Map<BytecodeVersion, List<String>>>();

    public Set<BytecodeVersion> getManifestBytecode() {
        return Collections.unmodifiableSet(this.manifestBytecode);
    }

    public void setManifestBytecode(Set<BytecodeVersion> manifestBytecode) {
        this.manifestBytecode.clear();
        this.manifestBytecode.addAll(manifestBytecode);
    }

    public void addUnversionedClass(BytecodeVersion bytecodeVersion, String className) {
        this.unversionedClasses.computeIfAbsent(bytecodeVersion, k -> new ArrayList()).add(className);
    }

    public void addVersionedClass(Integer javaVersion, BytecodeVersion bytecodeVersion, String className) {
        this.versionedClasses.computeIfAbsent(javaVersion, k -> new LinkedHashMap()).computeIfAbsent(bytecodeVersion, k -> new ArrayList()).add(className);
    }

    public Set<BytecodeVersion> getBytecodeOfUnversionedClasses() {
        return Collections.unmodifiableSet(new TreeSet<BytecodeVersion>(this.unversionedClasses.keySet()));
    }

    public Map<BytecodeVersion, List<String>> getUnversionedClasses() {
        LinkedHashMap<BytecodeVersion, List<String>> tmp = new LinkedHashMap<BytecodeVersion, List<String>>();
        for (Map.Entry<BytecodeVersion, List<String>> entry : this.unversionedClasses.entrySet()) {
            tmp.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(tmp);
    }

    public Set<Integer> getJavaVersionOfVersionedClasses() {
        return Collections.unmodifiableSet(new TreeSet<Integer>(this.versionedClasses.keySet()));
    }

    public Map<BytecodeVersion, List<String>> getVersionedClasses(Integer javaVersion) {
        if (!this.versionedClasses.containsKey(javaVersion)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<BytecodeVersion, List<String>> tmp = new LinkedHashMap<BytecodeVersion, List<String>>();
        for (Map.Entry<BytecodeVersion, List<String>> entry : this.versionedClasses.get(javaVersion).entrySet()) {
            tmp.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(tmp);
    }
}

