/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaDeprecatedAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaRetentionAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaTargetAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/load/java/components/JavaAnnotationMapper;", "", "<init>", "()V", "DEPRECATED_ANNOTATION_MESSAGE", "Lorg/jetbrains/kotlin/name/Name;", "getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm", "()Lorg/jetbrains/kotlin/name/Name;", "TARGET_ANNOTATION_ALLOWED_TARGETS", "getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm", "RETENTION_ANNOTATION_VALUE", "getRETENTION_ANNOTATION_VALUE$descriptors_jvm", "mapOrResolveJavaAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "annotation", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "isFreshlySupportedAnnotation", "", "findMappedJavaAnnotation", "kotlinName", "Lorg/jetbrains/kotlin/name/FqName;", "annotationOwner", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationOwner;", "kotlinToJavaNameMap", "", "descriptors.jvm"})
public final class JavaAnnotationMapper {
    @NotNull
    public static final JavaAnnotationMapper INSTANCE = new JavaAnnotationMapper();
    @NotNull
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    @NotNull
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    @NotNull
    private static final Name RETENTION_ANNOTATION_VALUE;
    @NotNull
    private static final Map<FqName, FqName> kotlinToJavaNameMap;

    private JavaAnnotationMapper() {
    }

    @NotNull
    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    @NotNull
    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    @NotNull
    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation, @NotNull LazyJavaResolverContext c2, boolean isFreshlySupportedAnnotation) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        ClassId classId = annotation.getClassId();
        FqName fqName = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"TARGET_ANNOTATION");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName))) {
            annotationDescriptor = new JavaTargetAnnotationDescriptor(annotation, c2);
        } else {
            FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"RETENTION_ANNOTATION");
            if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName2))) {
                annotationDescriptor = new JavaRetentionAnnotationDescriptor(annotation, c2);
            } else {
                FqName fqName3 = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"DOCUMENTED_ANNOTATION");
                if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName3))) {
                    annotationDescriptor = new JavaAnnotationDescriptor(c2, annotation, StandardNames.FqNames.mustBeDocumented);
                } else {
                    FqName fqName4 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"DEPRECATED_ANNOTATION");
                    annotationDescriptor = Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName4)) ? null : (AnnotationDescriptor)new LazyJavaAnnotationDescriptor(c2, annotation, isFreshlySupportedAnnotation);
                }
            }
        }
        return annotationDescriptor;
    }

    public static /* synthetic */ AnnotationDescriptor mapOrResolveJavaAnnotation$default(JavaAnnotationMapper javaAnnotationMapper, JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return javaAnnotationMapper.mapOrResolveJavaAnnotation(javaAnnotation, lazyJavaResolverContext, bl);
    }

    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c2) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter((Object)kotlinName, (String)"kotlinName");
        Intrinsics.checkNotNullParameter((Object)annotationOwner, (String)"annotationOwner");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        if (Intrinsics.areEqual((Object)kotlinName, (Object)StandardNames.FqNames.deprecated)) {
            FqName fqName = JvmAnnotationNames.DEPRECATED_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"DEPRECATED_ANNOTATION");
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(fqName);
            if (javaAnnotation != null || annotationOwner.isDeprecatedInJavaDoc()) {
                return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c2);
            }
        }
        FqName fqName = kotlinToJavaNameMap.get(kotlinName);
        if (fqName != null) {
            FqName javaName = fqName;
            boolean bl = false;
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(javaName);
            if (javaAnnotation != null) {
                JavaAnnotation annotation = javaAnnotation;
                boolean bl2 = false;
                annotationDescriptor = JavaAnnotationMapper.mapOrResolveJavaAnnotation$default(INSTANCE, annotation, c2, false, 4, null);
            } else {
                annotationDescriptor = null;
            }
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    static {
        Name name2 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DEPRECATED_ANNOTATION_MESSAGE = name2;
        Name name3 = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        TARGET_ANNOTATION_ALLOWED_TARGETS = name3;
        Name name4 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        RETENTION_ANNOTATION_VALUE = name4;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames.target, (Object)JvmAnnotationNames.TARGET_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.retention, (Object)JvmAnnotationNames.RETENTION_ANNOTATION), TuplesKt.to((Object)StandardNames.FqNames.mustBeDocumented, (Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION)};
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

