"""Generated message classes for oracledatabase version v1alpha.

The Oracle Database@Google Cloud API provides a set of APIs to manage Oracle
database services, such as Exadata and Autonomous Databases.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'oracledatabase'


class AllConnectionStrings(_messages.Message):
  r"""A list of all connection strings that can be used to connect to the
  Autonomous Database.

  Fields:
    high: Output only. The database service provides the highest level of
      resources to each SQL statement.
    low: Output only. The database service provides the least level of
      resources to each SQL statement.
    medium: Output only. The database service provides a lower level of
      resources to each SQL statement.
  """

  high = _messages.StringField(1)
  low = _messages.StringField(2)
  medium = _messages.StringField(3)


class AutonomousDatabase(_messages.Message):
  r"""Details of the Autonomous Database resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDatabase/

  Messages:
    LabelsValue: Optional. The labels or tags associated with the Autonomous
      Database.

  Fields:
    adminPassword: Optional. Immutable. The password for the default ADMIN
      user.
    cidr: Optional. Immutable. The subnet CIDR range for the Autonomous
      Database.
    createTime: Output only. The date and time that the Autonomous Database
      was created.
    database: Optional. Immutable. The name of the Autonomous Database. The
      database name must be unique in the project. The name must begin with a
      letter and can contain a maximum of 30 alphanumeric characters.
    disasterRecoverySupportedLocations: Output only. List of supported GCP
      region to clone the Autonomous Database for disaster recovery. Format:
      `project/{project}/locations/{location}`.
    displayName: Optional. Immutable. The display name for the Autonomous
      Database. The name does not have to be unique within your project.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the Autonomous Database.
    labels: Optional. The labels or tags associated with the Autonomous
      Database.
    name: Identifier. The name of the Autonomous Database resource in the
      following format: projects/{project}/locations/{region}/autonomousDataba
      ses/{autonomous_database}
    network: Optional. Immutable. The name of the VPC network used by the
      Autonomous Database in the following format:
      projects/{project}/global/networks/{network}
    odbNetwork: Optional. Immutable. The name of the OdbNetwork associated
      with the Autonomous Database. Format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
      optional but if specified, this should match the parent ODBNetwork of
      the OdbSubnet.
    odbSubnet: Optional. Immutable. The name of the OdbSubnet associated with
      the Autonomous Database. Format: projects/{project}/locations/{location}
      /odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
    peerAutonomousDatabases: Output only. The peer Autonomous Database names
      of the given Autonomous Database.
    properties: Optional. The properties of the Autonomous Database.
    sourceConfig: Optional. Immutable. The source Autonomous Database
      configuration for the standby Autonomous Database. The source Autonomous
      Database is configured while creating the Peer Autonomous Database and
      can't be updated after creation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the Autonomous Database.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  adminPassword = _messages.StringField(1)
  cidr = _messages.StringField(2)
  createTime = _messages.StringField(3)
  database = _messages.StringField(4)
  disasterRecoverySupportedLocations = _messages.StringField(5, repeated=True)
  displayName = _messages.StringField(6)
  entitlementId = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  network = _messages.StringField(10)
  odbNetwork = _messages.StringField(11)
  odbSubnet = _messages.StringField(12)
  peerAutonomousDatabases = _messages.StringField(13, repeated=True)
  properties = _messages.MessageField('AutonomousDatabaseProperties', 14)
  sourceConfig = _messages.MessageField('SourceConfig', 15)


class AutonomousDatabaseApex(_messages.Message):
  r"""Oracle APEX Application Development. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseApex

  Fields:
    apexVersion: Output only. The Oracle APEX Application Development version.
    ordsVersion: Output only. The Oracle REST Data Services (ORDS) version.
  """

  apexVersion = _messages.StringField(1)
  ordsVersion = _messages.StringField(2)


class AutonomousDatabaseBackup(_messages.Message):
  r"""Details of the Autonomous Database Backup resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDatabaseBackup/

  Messages:
    LabelsValue: Optional. labels or tags associated with the resource.

  Fields:
    autonomousDatabase: Required. The name of the Autonomous Database resource
      for which the backup is being created. Format: projects/{project}/locati
      ons/{region}/autonomousDatabases/{autonomous_database}
    displayName: Optional. User friendly name for the Backup. The name does
      not have to be unique.
    labels: Optional. labels or tags associated with the resource.
    name: Identifier. The name of the Autonomous Database Backup resource with
      the format: projects/{project}/locations/{region}/autonomousDatabaseBack
      ups/{autonomous_database_backup}
    properties: Optional. Various properties of the backup.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  autonomousDatabase = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  properties = _messages.MessageField('AutonomousDatabaseBackupProperties', 5)


class AutonomousDatabaseBackupProperties(_messages.Message):
  r"""Properties of the Autonomous Database Backup resource.

  Enums:
    LifecycleStateValueValuesEnum: Output only. The lifecycle state of the
      backup.
    TypeValueValuesEnum: Output only. The type of the backup.

  Fields:
    availableTillTime: Output only. Timestamp until when the backup will be
      available.
    compartmentId: Output only. The OCID of the compartment.
    databaseSizeTb: Output only. The quantity of data in the database, in
      terabytes.
    dbVersion: Output only. A valid Oracle Database version for Autonomous
      Database.
    endTime: Output only. The date and time the backup completed.
    isAutomaticBackup: Output only. Indicates if the backup is automatic or
      user initiated.
    isLongTermBackup: Output only. Indicates if the backup is long term
      backup.
    isRestorable: Output only. Indicates if the backup can be used to restore
      the Autonomous Database.
    keyStoreId: Optional. The OCID of the key store of Oracle Vault.
    keyStoreWallet: Optional. The wallet name for Oracle Key Vault.
    kmsKeyId: Optional. The OCID of the key container that is used as the
      master encryption key in database transparent data encryption (TDE)
      operations.
    kmsKeyVersionId: Optional. The OCID of the key container version that is
      used in database transparent data encryption (TDE) operations KMS Key
      can have multiple key versions. If none is specified, the current key
      version (latest) of the Key Id is used for the operation. Autonomous
      Database Serverless does not use key versions, hence is not applicable
      for Autonomous Database Serverless instances.
    lifecycleDetails: Output only. Additional information about the current
      lifecycle state.
    lifecycleState: Output only. The lifecycle state of the backup.
    ocid: Output only. OCID of the Autonomous Database backup.
      https://docs.oracle.com/en-
      us/iaas/Content/General/Concepts/identifiers.htm#Oracle
    retentionPeriodDays: Optional. Retention period in days for the backup.
    sizeTb: Output only. The backup size in terabytes.
    startTime: Output only. The date and time the backup started.
    type: Output only. The type of the backup.
    vaultId: Optional. The OCID of the vault.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. The lifecycle state of the backup.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      CREATING: Indicates that the resource is in creating state.
      ACTIVE: Indicates that the resource is in active state.
      DELETING: Indicates that the resource is in deleting state.
      DELETED: Indicates that the resource is in deleted state.
      FAILED: Indicates that the resource is in failed state.
      UPDATING: Indicates that the resource is in updating state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    DELETED = 4
    FAILED = 5
    UPDATING = 6

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the backup.

    Values:
      TYPE_UNSPECIFIED: Default unspecified value.
      INCREMENTAL: Incremental backups.
      FULL: Full backups.
      LONG_TERM: Long term backups.
    """
    TYPE_UNSPECIFIED = 0
    INCREMENTAL = 1
    FULL = 2
    LONG_TERM = 3

  availableTillTime = _messages.StringField(1)
  compartmentId = _messages.StringField(2)
  databaseSizeTb = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  dbVersion = _messages.StringField(4)
  endTime = _messages.StringField(5)
  isAutomaticBackup = _messages.BooleanField(6)
  isLongTermBackup = _messages.BooleanField(7)
  isRestorable = _messages.BooleanField(8)
  keyStoreId = _messages.StringField(9)
  keyStoreWallet = _messages.StringField(10)
  kmsKeyId = _messages.StringField(11)
  kmsKeyVersionId = _messages.StringField(12)
  lifecycleDetails = _messages.StringField(13)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 14)
  ocid = _messages.StringField(15)
  retentionPeriodDays = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  sizeTb = _messages.FloatField(17, variant=_messages.Variant.FLOAT)
  startTime = _messages.StringField(18)
  type = _messages.EnumField('TypeValueValuesEnum', 19)
  vaultId = _messages.StringField(20)


class AutonomousDatabaseCharacterSet(_messages.Message):
  r"""Details of the Autonomous Database character set resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/

  Enums:
    CharacterSetTypeValueValuesEnum: Output only. The character set type for
      the Autonomous Database.

  Fields:
    characterSet: Output only. The character set name for the Autonomous
      Database which is the ID in the resource name.
    characterSetType: Output only. The character set type for the Autonomous
      Database.
    name: Identifier. The name of the Autonomous Database Character Set
      resource in the following format: projects/{project}/locations/{region}/
      autonomousDatabaseCharacterSets/{autonomous_database_character_set}
  """

  class CharacterSetTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The character set type for the Autonomous Database.

    Values:
      CHARACTER_SET_TYPE_UNSPECIFIED: Character set type is not specified.
      DATABASE: Character set type is set to database.
      NATIONAL: Character set type is set to national.
    """
    CHARACTER_SET_TYPE_UNSPECIFIED = 0
    DATABASE = 1
    NATIONAL = 2

  characterSet = _messages.StringField(1)
  characterSetType = _messages.EnumField('CharacterSetTypeValueValuesEnum', 2)
  name = _messages.StringField(3)


class AutonomousDatabaseConnectionStrings(_messages.Message):
  r"""The connection string used to connect to the Autonomous Database.
  https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/Auto
  nomousDatabaseConnectionStrings

  Fields:
    allConnectionStrings: Output only. Returns all connection strings that can
      be used to connect to the Autonomous Database.
    dedicated: Output only. The database service provides the least level of
      resources to each SQL statement, but supports the most number of
      concurrent SQL statements.
    high: Output only. The database service provides the highest level of
      resources to each SQL statement.
    low: Output only. The database service provides the least level of
      resources to each SQL statement.
    medium: Output only. The database service provides a lower level of
      resources to each SQL statement.
    profiles: Output only. A list of connection string profiles to allow
      clients to group, filter, and select values based on the structured
      metadata.
  """

  allConnectionStrings = _messages.MessageField('AllConnectionStrings', 1)
  dedicated = _messages.StringField(2)
  high = _messages.StringField(3)
  low = _messages.StringField(4)
  medium = _messages.StringField(5)
  profiles = _messages.MessageField('DatabaseConnectionStringProfile', 6, repeated=True)


class AutonomousDatabaseConnectionUrls(_messages.Message):
  r"""The URLs for accessing Oracle Application Express (APEX) and SQL
  Developer Web with a browser from a Compute instance.
  https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/Auto
  nomousDatabaseConnectionUrls

  Fields:
    apexUri: Output only. Oracle Application Express (APEX) URL.
    databaseTransformsUri: Output only. The URL of the Database Transforms for
      the Autonomous Database.
    graphStudioUri: Output only. The URL of the Graph Studio for the
      Autonomous Database.
    machineLearningNotebookUri: Output only. The URL of the Oracle Machine
      Learning (OML) Notebook for the Autonomous Database.
    machineLearningUserManagementUri: Output only. The URL of Machine Learning
      user management the Autonomous Database.
    mongoDbUri: Output only. The URL of the MongoDB API for the Autonomous
      Database.
    ordsUri: Output only. The Oracle REST Data Services (ORDS) URL of the Web
      Access for the Autonomous Database.
    sqlDevWebUri: Output only. The URL of the Oracle SQL Developer Web for the
      Autonomous Database.
  """

  apexUri = _messages.StringField(1)
  databaseTransformsUri = _messages.StringField(2)
  graphStudioUri = _messages.StringField(3)
  machineLearningNotebookUri = _messages.StringField(4)
  machineLearningUserManagementUri = _messages.StringField(5)
  mongoDbUri = _messages.StringField(6)
  ordsUri = _messages.StringField(7)
  sqlDevWebUri = _messages.StringField(8)


class AutonomousDatabaseProperties(_messages.Message):
  r"""The properties of an Autonomous Database.

  Enums:
    DataSafeStateValueValuesEnum: Output only. The current state of the Data
      Safe registration for the Autonomous Database.
    DatabaseManagementStateValueValuesEnum: Output only. The current state of
      database management for the Autonomous Database.
    DbEditionValueValuesEnum: Optional. Immutable. The edition of the
      Autonomous Databases.
    DbWorkloadValueValuesEnum: Required. Immutable. The workload type of the
      Autonomous Database.
    LicenseTypeValueValuesEnum: Required. Immutable. The license type used for
      the Autonomous Database.
    LocalDisasterRecoveryTypeValueValuesEnum: Output only. This field
      indicates the local disaster recovery (DR) type of an Autonomous
      Database.
    MaintenanceScheduleTypeValueValuesEnum: Optional. Immutable. The
      maintenance schedule of the Autonomous Database.
    OpenModeValueValuesEnum: Output only. This field indicates the current
      mode of the Autonomous Database.
    OperationsInsightsStateValueValuesEnum: Output only. This field indicates
      the state of Operations Insights for the Autonomous Database.
    PermissionLevelValueValuesEnum: Output only. The permission level of the
      Autonomous Database.
    RefreshableModeValueValuesEnum: Output only. The refresh mode of the
      cloned Autonomous Database.
    RefreshableStateValueValuesEnum: Output only. The refresh State of the
      clone.
    RoleValueValuesEnum: Output only. The Data Guard role of the Autonomous
      Database.
    StateValueValuesEnum: Output only. The current lifecycle state of the
      Autonomous Database.

  Fields:
    actualUsedDataStorageSizeTb: Output only. The amount of storage currently
      being used for user and system data, in terabytes.
    allocatedStorageSizeTb: Output only. The amount of storage currently
      allocated for the database tables and billed for, rounded up in
      terabytes.
    allowlistedIps: Optional. Immutable. The list of allowlisted IP addresses
      for the Autonomous Database.
    apexDetails: Output only. The details for the Oracle APEX Application
      Development.
    arePrimaryAllowlistedIpsUsed: Output only. This field indicates the status
      of Data Guard and Access control for the Autonomous Database. The
      field's value is null if Data Guard is disabled or Access Control is
      disabled. The field's value is TRUE if both Data Guard and Access
      Control are enabled, and the Autonomous Database is using primary IP
      access control list (ACL) for standby. The field's value is FALSE if
      both Data Guard and Access Control are enabled, and the Autonomous
      Database is using a different IP access control list (ACL) for standby
      compared to primary.
    autonomousContainerDatabaseId: Output only. The Autonomous Container
      Database OCID.
    availableUpgradeVersions: Output only. The list of available Oracle
      Database upgrade versions for an Autonomous Database.
    backupRetentionPeriodDays: Optional. Immutable. The retention period for
      the Autonomous Database. This field is specified in days, can range from
      1 day to 60 days, and has a default value of 60 days.
    characterSet: Optional. Immutable. The character set for the Autonomous
      Database. The default is AL32UTF8.
    computeCount: Optional. Immutable. The number of compute servers for the
      Autonomous Database.
    connectionStrings: Output only. The connection strings used to connect to
      an Autonomous Database.
    connectionUrls: Output only. The Oracle Connection URLs for an Autonomous
      Database.
    cpuCoreCount: Optional. Immutable. The number of CPU cores to be made
      available to the database.
    customerContacts: Optional. Immutable. The list of customer contacts.
    dataGuardRoleChangedTime: Output only. The date and time the Autonomous
      Data Guard role was changed for the standby Autonomous Database.
    dataSafeState: Output only. The current state of the Data Safe
      registration for the Autonomous Database.
    dataStorageSizeGb: Optional. Immutable. The size of the data stored in the
      database, in gigabytes.
    dataStorageSizeTb: Optional. Immutable. The size of the data stored in the
      database, in terabytes.
    databaseManagementState: Output only. The current state of database
      management for the Autonomous Database.
    dbEdition: Optional. Immutable. The edition of the Autonomous Databases.
    dbVersion: Optional. Immutable. The Oracle Database version for the
      Autonomous Database.
    dbWorkload: Required. Immutable. The workload type of the Autonomous
      Database.
    disasterRecoveryRoleChangedTime: Output only. The date and time the
      Disaster Recovery role was changed for the standby Autonomous Database.
    encryptionKey: Optional. The encryption key used to encrypt the Autonomous
      Database. Updating this field will add a new entry in the
      `encryption_key_history_entries` field with the former version.
    encryptionKeyHistoryEntries: Output only. The history of the encryption
      keys used to encrypt the Autonomous Database.
    failedDataRecoveryDuration: Output only. This field indicates the number
      of seconds of data loss during a Data Guard failover.
    isAutoScalingEnabled: Optional. Immutable. This field indicates if auto
      scaling is enabled for the Autonomous Database CPU core count.
    isLocalDataGuardEnabled: Output only. This field indicates whether the
      Autonomous Database has local (in-region) Data Guard enabled.
    isStorageAutoScalingEnabled: Optional. Immutable. This field indicates if
      auto scaling is enabled for the Autonomous Database storage.
    licenseType: Required. Immutable. The license type used for the Autonomous
      Database.
    lifecycleDetails: Output only. The details of the current lifestyle state
      of the Autonomous Database.
    localAdgAutoFailoverMaxDataLossLimit: Output only. This field indicates
      the maximum data loss limit for an Autonomous Database, in seconds.
    localAdgAutoFailoverMaxDataLossLimitDuration: Optional. This field
      indicates the maximum data loss limit for an Autonomous Database, in
      seconds.
    localDataGuardEnabled: Optional. Indicates whether the Autonomous Database
      has a local (in-region) standby database. Not applicable to cross-region
      Data Guard or dedicated Exadata infrastructure.
    localDisasterRecoveryType: Output only. This field indicates the local
      disaster recovery (DR) type of an Autonomous Database.
    localStandbyDb: Output only. The details of the Autonomous Data Guard
      standby database.
    maintenanceBeginTime: Output only. The date and time when maintenance will
      begin.
    maintenanceEndTime: Output only. The date and time when maintenance will
      end.
    maintenanceScheduleType: Optional. Immutable. The maintenance schedule of
      the Autonomous Database.
    memoryPerOracleComputeUnitGbs: Output only. The amount of memory enabled
      per ECPU, in gigabytes.
    memoryTableGbs: Output only. The memory assigned to in-memory tables in an
      Autonomous Database.
    mtlsConnectionRequired: Optional. Immutable. This field specifies if the
      Autonomous Database requires mTLS connections.
    nCharacterSet: Optional. Immutable. The national character set for the
      Autonomous Database. The default is AL16UTF16.
    nextLongTermBackupTime: Output only. The long term backup schedule of the
      Autonomous Database.
    ociUrl: Output only. The Oracle Cloud Infrastructure link for the
      Autonomous Database.
    ocid: Output only. OCID of the Autonomous Database.
      https://docs.oracle.com/en-
      us/iaas/Content/General/Concepts/identifiers.htm#Oracle
    openMode: Output only. This field indicates the current mode of the
      Autonomous Database.
    operationsInsightsState: Output only. This field indicates the state of
      Operations Insights for the Autonomous Database.
    peerDbIds: Output only. The list of OCIDs of standby databases located in
      Autonomous Data Guard remote regions that are associated with the source
      database.
    permissionLevel: Output only. The permission level of the Autonomous
      Database.
    privateEndpoint: Output only. The private endpoint for the Autonomous
      Database.
    privateEndpointIp: Optional. Immutable. The private endpoint IP address
      for the Autonomous Database.
    privateEndpointLabel: Optional. Immutable. The private endpoint label for
      the Autonomous Database.
    refreshableClone: Optional. Indicates if the Autonomous Database is a
      refreshable clone. This field is used in update flow to connect /
      disconnect a refreshable clone from its source database.
    refreshableMode: Output only. The refresh mode of the cloned Autonomous
      Database.
    refreshableState: Output only. The refresh State of the clone.
    role: Output only. The Data Guard role of the Autonomous Database.
    scheduledOperationDetails: Output only. The list and details of the
      scheduled operations of the Autonomous Database.
    secretId: Optional. Immutable. The ID of the Oracle Cloud Infrastructure
      vault secret.
    serviceAgentEmail: Output only. An Oracle-managed Google Cloud service
      account on which customers can grant roles to access resources in the
      customer project.
    sqlWebDeveloperUrl: Output only. The SQL Web Developer URL for the
      Autonomous Database.
    state: Output only. The current lifecycle state of the Autonomous
      Database.
    supportedCloneRegions: Output only. The list of available regions that can
      be used to create a clone for the Autonomous Database.
    totalAutoBackupStorageSizeGbs: Output only. The storage space used by
      automatic backups of Autonomous Database, in gigabytes.
    usedDataStorageSizeTbs: Output only. The storage space used by Autonomous
      Database, in gigabytes.
    vaultId: Optional. Immutable. The ID of the Oracle Cloud Infrastructure
      vault.
  """

  class DataSafeStateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the Data Safe registration for the
    Autonomous Database.

    Values:
      DATA_SAFE_STATE_UNSPECIFIED: Default unspecified value.
      REGISTERING: Registering data safe state.
      REGISTERED: Registered data safe state.
      DEREGISTERING: Deregistering data safe state.
      NOT_REGISTERED: Not registered data safe state.
      FAILED: Failed data safe state.
    """
    DATA_SAFE_STATE_UNSPECIFIED = 0
    REGISTERING = 1
    REGISTERED = 2
    DEREGISTERING = 3
    NOT_REGISTERED = 4
    FAILED = 5

  class DatabaseManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of database management for the
    Autonomous Database.

    Values:
      DATABASE_MANAGEMENT_STATE_UNSPECIFIED: Default unspecified value.
      ENABLING: Enabling Database Management state
      ENABLED: Enabled Database Management state
      DISABLING: Disabling Database Management state
      NOT_ENABLED: Not Enabled Database Management state
      FAILED_ENABLING: Failed enabling Database Management state
      FAILED_DISABLING: Failed disabling Database Management state
    """
    DATABASE_MANAGEMENT_STATE_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    NOT_ENABLED = 4
    FAILED_ENABLING = 5
    FAILED_DISABLING = 6

  class DbEditionValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. The edition of the Autonomous Databases.

    Values:
      DATABASE_EDITION_UNSPECIFIED: Default unspecified value.
      STANDARD_EDITION: Standard Database Edition
      ENTERPRISE_EDITION: Enterprise Database Edition
    """
    DATABASE_EDITION_UNSPECIFIED = 0
    STANDARD_EDITION = 1
    ENTERPRISE_EDITION = 2

  class DbWorkloadValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The workload type of the Autonomous Database.

    Values:
      DB_WORKLOAD_UNSPECIFIED: Default unspecified value.
      OLTP: Autonomous Transaction Processing database.
      DW: Autonomous Data Warehouse database.
      AJD: Autonomous JSON Database.
      APEX: Autonomous Database with the Oracle APEX Application Development
        workload type.
    """
    DB_WORKLOAD_UNSPECIFIED = 0
    OLTP = 1
    DW = 2
    AJD = 3
    APEX = 4

  class LicenseTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The license type used for the Autonomous
    Database.

    Values:
      LICENSE_TYPE_UNSPECIFIED: Unspecified
      LICENSE_INCLUDED: License included part of offer
      BRING_YOUR_OWN_LICENSE: Bring your own license
    """
    LICENSE_TYPE_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class LocalDisasterRecoveryTypeValueValuesEnum(_messages.Enum):
    r"""Output only. This field indicates the local disaster recovery (DR)
    type of an Autonomous Database.

    Values:
      LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED: Default unspecified value.
      ADG: Autonomous Data Guard recovery.
      BACKUP_BASED: Backup based recovery.
    """
    LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED = 0
    ADG = 1
    BACKUP_BASED = 2

  class MaintenanceScheduleTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. The maintenance schedule of the Autonomous
    Database.

    Values:
      MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED: Default unspecified value.
      EARLY: An EARLY maintenance schedule patches the database before the
        regular scheduled maintenance.
      REGULAR: A REGULAR maintenance schedule follows the normal maintenance
        cycle.
    """
    MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED = 0
    EARLY = 1
    REGULAR = 2

  class OpenModeValueValuesEnum(_messages.Enum):
    r"""Output only. This field indicates the current mode of the Autonomous
    Database.

    Values:
      OPEN_MODE_UNSPECIFIED: Default unspecified value.
      READ_ONLY: Read Only Mode
      READ_WRITE: Read Write Mode
    """
    OPEN_MODE_UNSPECIFIED = 0
    READ_ONLY = 1
    READ_WRITE = 2

  class OperationsInsightsStateValueValuesEnum(_messages.Enum):
    r"""Output only. This field indicates the state of Operations Insights for
    the Autonomous Database.

    Values:
      OPERATIONS_INSIGHTS_STATE_UNSPECIFIED: Default unspecified value.
      ENABLING: Enabling status for operation insights.
      ENABLED: Enabled status for operation insights.
      DISABLING: Disabling status for operation insights.
      NOT_ENABLED: Not Enabled status for operation insights.
      FAILED_ENABLING: Failed enabling status for operation insights.
      FAILED_DISABLING: Failed disabling status for operation insights.
    """
    OPERATIONS_INSIGHTS_STATE_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    NOT_ENABLED = 4
    FAILED_ENABLING = 5
    FAILED_DISABLING = 6

  class PermissionLevelValueValuesEnum(_messages.Enum):
    r"""Output only. The permission level of the Autonomous Database.

    Values:
      PERMISSION_LEVEL_UNSPECIFIED: Default unspecified value.
      RESTRICTED: Restricted mode allows access only by admin users.
      UNRESTRICTED: Normal access.
    """
    PERMISSION_LEVEL_UNSPECIFIED = 0
    RESTRICTED = 1
    UNRESTRICTED = 2

  class RefreshableModeValueValuesEnum(_messages.Enum):
    r"""Output only. The refresh mode of the cloned Autonomous Database.

    Values:
      REFRESHABLE_MODE_UNSPECIFIED: The default unspecified value.
      AUTOMATIC: AUTOMATIC indicates that the cloned database is automatically
        refreshed with data from the source Autonomous Database.
      MANUAL: MANUAL indicates that the cloned database is manually refreshed
        with data from the source Autonomous Database.
    """
    REFRESHABLE_MODE_UNSPECIFIED = 0
    AUTOMATIC = 1
    MANUAL = 2

  class RefreshableStateValueValuesEnum(_messages.Enum):
    r"""Output only. The refresh State of the clone.

    Values:
      REFRESHABLE_STATE_UNSPECIFIED: Default unspecified value.
      REFRESHING: Refreshing
      NOT_REFRESHING: Not refreshed
    """
    REFRESHABLE_STATE_UNSPECIFIED = 0
    REFRESHING = 1
    NOT_REFRESHING = 2

  class RoleValueValuesEnum(_messages.Enum):
    r"""Output only. The Data Guard role of the Autonomous Database.

    Values:
      ROLE_UNSPECIFIED: Default unspecified value.
      PRIMARY: Primary role
      STANDBY: Standby role
      DISABLED_STANDBY: Disabled standby role
      BACKUP_COPY: Backup copy role
      SNAPSHOT_STANDBY: Snapshot standby role
    """
    ROLE_UNSPECIFIED = 0
    PRIMARY = 1
    STANDBY = 2
    DISABLED_STANDBY = 3
    BACKUP_COPY = 4
    SNAPSHOT_STANDBY = 5

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the Autonomous Database.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the Autonomous Database is in provisioning
        state.
      AVAILABLE: Indicates that the Autonomous Database is in available state.
      STOPPING: Indicates that the Autonomous Database is in stopping state.
      STOPPED: Indicates that the Autonomous Database is in stopped state.
      STARTING: Indicates that the Autonomous Database is in starting state.
      TERMINATING: Indicates that the Autonomous Database is in terminating
        state.
      TERMINATED: Indicates that the Autonomous Database is in terminated
        state.
      UNAVAILABLE: Indicates that the Autonomous Database is in unavailable
        state.
      RESTORE_IN_PROGRESS: Indicates that the Autonomous Database restore is
        in progress.
      RESTORE_FAILED: Indicates that the Autonomous Database failed to
        restore.
      BACKUP_IN_PROGRESS: Indicates that the Autonomous Database backup is in
        progress.
      SCALE_IN_PROGRESS: Indicates that the Autonomous Database scale is in
        progress.
      AVAILABLE_NEEDS_ATTENTION: Indicates that the Autonomous Database is
        available but needs attention state.
      UPDATING: Indicates that the Autonomous Database is in updating state.
      MAINTENANCE_IN_PROGRESS: Indicates that the Autonomous Database's
        maintenance is in progress state.
      RESTARTING: Indicates that the Autonomous Database is in restarting
        state.
      RECREATING: Indicates that the Autonomous Database is in recreating
        state.
      ROLE_CHANGE_IN_PROGRESS: Indicates that the Autonomous Database's role
        change is in progress state.
      UPGRADING: Indicates that the Autonomous Database is in upgrading state.
      INACCESSIBLE: Indicates that the Autonomous Database is in inaccessible
        state.
      STANDBY: Indicates that the Autonomous Database is in standby state.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    STOPPING = 3
    STOPPED = 4
    STARTING = 5
    TERMINATING = 6
    TERMINATED = 7
    UNAVAILABLE = 8
    RESTORE_IN_PROGRESS = 9
    RESTORE_FAILED = 10
    BACKUP_IN_PROGRESS = 11
    SCALE_IN_PROGRESS = 12
    AVAILABLE_NEEDS_ATTENTION = 13
    UPDATING = 14
    MAINTENANCE_IN_PROGRESS = 15
    RESTARTING = 16
    RECREATING = 17
    ROLE_CHANGE_IN_PROGRESS = 18
    UPGRADING = 19
    INACCESSIBLE = 20
    STANDBY = 21

  actualUsedDataStorageSizeTb = _messages.FloatField(1)
  allocatedStorageSizeTb = _messages.FloatField(2)
  allowlistedIps = _messages.StringField(3, repeated=True)
  apexDetails = _messages.MessageField('AutonomousDatabaseApex', 4)
  arePrimaryAllowlistedIpsUsed = _messages.BooleanField(5)
  autonomousContainerDatabaseId = _messages.StringField(6)
  availableUpgradeVersions = _messages.StringField(7, repeated=True)
  backupRetentionPeriodDays = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  characterSet = _messages.StringField(9)
  computeCount = _messages.FloatField(10, variant=_messages.Variant.FLOAT)
  connectionStrings = _messages.MessageField('AutonomousDatabaseConnectionStrings', 11)
  connectionUrls = _messages.MessageField('AutonomousDatabaseConnectionUrls', 12)
  cpuCoreCount = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  customerContacts = _messages.MessageField('CustomerContact', 14, repeated=True)
  dataGuardRoleChangedTime = _messages.StringField(15)
  dataSafeState = _messages.EnumField('DataSafeStateValueValuesEnum', 16)
  dataStorageSizeGb = _messages.IntegerField(17, variant=_messages.Variant.INT32)
  dataStorageSizeTb = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  databaseManagementState = _messages.EnumField('DatabaseManagementStateValueValuesEnum', 19)
  dbEdition = _messages.EnumField('DbEditionValueValuesEnum', 20)
  dbVersion = _messages.StringField(21)
  dbWorkload = _messages.EnumField('DbWorkloadValueValuesEnum', 22)
  disasterRecoveryRoleChangedTime = _messages.StringField(23)
  encryptionKey = _messages.MessageField('EncryptionKey', 24)
  encryptionKeyHistoryEntries = _messages.MessageField('EncryptionKeyHistoryEntry', 25, repeated=True)
  failedDataRecoveryDuration = _messages.StringField(26)
  isAutoScalingEnabled = _messages.BooleanField(27)
  isLocalDataGuardEnabled = _messages.BooleanField(28)
  isStorageAutoScalingEnabled = _messages.BooleanField(29)
  licenseType = _messages.EnumField('LicenseTypeValueValuesEnum', 30)
  lifecycleDetails = _messages.StringField(31)
  localAdgAutoFailoverMaxDataLossLimit = _messages.IntegerField(32, variant=_messages.Variant.INT32)
  localAdgAutoFailoverMaxDataLossLimitDuration = _messages.IntegerField(33, variant=_messages.Variant.INT32)
  localDataGuardEnabled = _messages.BooleanField(34)
  localDisasterRecoveryType = _messages.EnumField('LocalDisasterRecoveryTypeValueValuesEnum', 35)
  localStandbyDb = _messages.MessageField('AutonomousDatabaseStandbySummary', 36)
  maintenanceBeginTime = _messages.StringField(37)
  maintenanceEndTime = _messages.StringField(38)
  maintenanceScheduleType = _messages.EnumField('MaintenanceScheduleTypeValueValuesEnum', 39)
  memoryPerOracleComputeUnitGbs = _messages.IntegerField(40, variant=_messages.Variant.INT32)
  memoryTableGbs = _messages.IntegerField(41, variant=_messages.Variant.INT32)
  mtlsConnectionRequired = _messages.BooleanField(42)
  nCharacterSet = _messages.StringField(43)
  nextLongTermBackupTime = _messages.StringField(44)
  ociUrl = _messages.StringField(45)
  ocid = _messages.StringField(46)
  openMode = _messages.EnumField('OpenModeValueValuesEnum', 47)
  operationsInsightsState = _messages.EnumField('OperationsInsightsStateValueValuesEnum', 48)
  peerDbIds = _messages.StringField(49, repeated=True)
  permissionLevel = _messages.EnumField('PermissionLevelValueValuesEnum', 50)
  privateEndpoint = _messages.StringField(51)
  privateEndpointIp = _messages.StringField(52)
  privateEndpointLabel = _messages.StringField(53)
  refreshableClone = _messages.BooleanField(54)
  refreshableMode = _messages.EnumField('RefreshableModeValueValuesEnum', 55)
  refreshableState = _messages.EnumField('RefreshableStateValueValuesEnum', 56)
  role = _messages.EnumField('RoleValueValuesEnum', 57)
  scheduledOperationDetails = _messages.MessageField('ScheduledOperationDetails', 58, repeated=True)
  secretId = _messages.StringField(59)
  serviceAgentEmail = _messages.StringField(60)
  sqlWebDeveloperUrl = _messages.StringField(61)
  state = _messages.EnumField('StateValueValuesEnum', 62)
  supportedCloneRegions = _messages.StringField(63, repeated=True)
  totalAutoBackupStorageSizeGbs = _messages.FloatField(64, variant=_messages.Variant.FLOAT)
  usedDataStorageSizeTbs = _messages.IntegerField(65, variant=_messages.Variant.INT32)
  vaultId = _messages.StringField(66)


class AutonomousDatabaseRefreshableClone(_messages.Message):
  r"""An Autonomous Database refreshable clone

  Fields:
    name: Output only. The GCP resource name of the Autonomous Database.
    region: Output only. The Google Cloud region where the refreshable clone
      exists.
  """

  name = _messages.StringField(1)
  region = _messages.StringField(2)


class AutonomousDatabaseStandbySummary(_messages.Message):
  r"""Autonomous Data Guard standby database details.
  https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/Auto
  nomousDatabaseStandbySummary

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of the
      Autonomous Database.

  Fields:
    dataGuardRoleChangedTime: Output only. The date and time the Autonomous
      Data Guard role was switched for the standby Autonomous Database.
    disasterRecoveryRoleChangedTime: Output only. The date and time the
      Disaster Recovery role was switched for the standby Autonomous Database.
    lagTimeDuration: Output only. The amount of time, in seconds, that the
      data of the standby database lags in comparison to the data of the
      primary database.
    lifecycleDetails: Output only. The additional details about the current
      lifecycle state of the Autonomous Database.
    state: Output only. The current lifecycle state of the Autonomous
      Database.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the Autonomous Database.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the Autonomous Database is in provisioning
        state.
      AVAILABLE: Indicates that the Autonomous Database is in available state.
      STOPPING: Indicates that the Autonomous Database is in stopping state.
      STOPPED: Indicates that the Autonomous Database is in stopped state.
      STARTING: Indicates that the Autonomous Database is in starting state.
      TERMINATING: Indicates that the Autonomous Database is in terminating
        state.
      TERMINATED: Indicates that the Autonomous Database is in terminated
        state.
      UNAVAILABLE: Indicates that the Autonomous Database is in unavailable
        state.
      RESTORE_IN_PROGRESS: Indicates that the Autonomous Database restore is
        in progress.
      RESTORE_FAILED: Indicates that the Autonomous Database failed to
        restore.
      BACKUP_IN_PROGRESS: Indicates that the Autonomous Database backup is in
        progress.
      SCALE_IN_PROGRESS: Indicates that the Autonomous Database scale is in
        progress.
      AVAILABLE_NEEDS_ATTENTION: Indicates that the Autonomous Database is
        available but needs attention state.
      UPDATING: Indicates that the Autonomous Database is in updating state.
      MAINTENANCE_IN_PROGRESS: Indicates that the Autonomous Database's
        maintenance is in progress state.
      RESTARTING: Indicates that the Autonomous Database is in restarting
        state.
      RECREATING: Indicates that the Autonomous Database is in recreating
        state.
      ROLE_CHANGE_IN_PROGRESS: Indicates that the Autonomous Database's role
        change is in progress state.
      UPGRADING: Indicates that the Autonomous Database is in upgrading state.
      INACCESSIBLE: Indicates that the Autonomous Database is in inaccessible
        state.
      STANDBY: Indicates that the Autonomous Database is in standby state.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    STOPPING = 3
    STOPPED = 4
    STARTING = 5
    TERMINATING = 6
    TERMINATED = 7
    UNAVAILABLE = 8
    RESTORE_IN_PROGRESS = 9
    RESTORE_FAILED = 10
    BACKUP_IN_PROGRESS = 11
    SCALE_IN_PROGRESS = 12
    AVAILABLE_NEEDS_ATTENTION = 13
    UPDATING = 14
    MAINTENANCE_IN_PROGRESS = 15
    RESTARTING = 16
    RECREATING = 17
    ROLE_CHANGE_IN_PROGRESS = 18
    UPGRADING = 19
    INACCESSIBLE = 20
    STANDBY = 21

  dataGuardRoleChangedTime = _messages.StringField(1)
  disasterRecoveryRoleChangedTime = _messages.StringField(2)
  lagTimeDuration = _messages.StringField(3)
  lifecycleDetails = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class AutonomousDbVersion(_messages.Message):
  r"""Details of the Autonomous Database version. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDbVersionSummary/

  Enums:
    DbWorkloadValueValuesEnum: Output only. The Autonomous Database workload
      type.

  Fields:
    dbWorkload: Output only. The Autonomous Database workload type.
    name: Identifier. The name of the Autonomous Database Version resource
      with the format: projects/{project}/locations/{region}/autonomousDbVersi
      ons/{autonomous_db_version}
    version: Output only. An Oracle Database version for Autonomous Database.
    workloadUri: Output only. A URL that points to a detailed description of
      the Autonomous Database version.
  """

  class DbWorkloadValueValuesEnum(_messages.Enum):
    r"""Output only. The Autonomous Database workload type.

    Values:
      DB_WORKLOAD_UNSPECIFIED: Default unspecified value.
      OLTP: Autonomous Transaction Processing database.
      DW: Autonomous Data Warehouse database.
      AJD: Autonomous JSON Database.
      APEX: Autonomous Database with the Oracle APEX Application Development
        workload type.
    """
    DB_WORKLOAD_UNSPECIFIED = 0
    OLTP = 1
    DW = 2
    AJD = 3
    APEX = 4

  dbWorkload = _messages.EnumField('DbWorkloadValueValuesEnum', 1)
  name = _messages.StringField(2)
  version = _messages.StringField(3)
  workloadUri = _messages.StringField(4)


class BackupDestinationDetails(_messages.Message):
  r"""The details of the database backup destination.

  Enums:
    TypeValueValuesEnum: Optional. The type of the database backup
      destination.

  Fields:
    type: Optional. The type of the database backup destination.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of the database backup destination.

    Values:
      BACKUP_DESTINATION_TYPE_UNSPECIFIED: Default unspecified value.
      NFS: Backup destination type is NFS.
      RECOVERY_APPLIANCE: Backup destination type is Recovery Appliance.
      OBJECT_STORE: Backup destination type is Object Store.
      LOCAL: Backup destination type is Local.
      DBRS: Backup destination type is DBRS.
    """
    BACKUP_DESTINATION_TYPE_UNSPECIFIED = 0
    NFS = 1
    RECOVERY_APPLIANCE = 2
    OBJECT_STORE = 3
    LOCAL = 4
    DBRS = 5

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudAccountDetails(_messages.Message):
  r"""Details of the OCI Cloud Account.

  Fields:
    accountCreationUri: Output only. URL to create a new account and link.
    cloudAccount: Output only. OCI account name.
    cloudAccountHomeRegion: Output only. OCI account home region.
    linkExistingAccountUri: Output only. URL to link an existing account.
  """

  accountCreationUri = _messages.StringField(1)
  cloudAccount = _messages.StringField(2)
  cloudAccountHomeRegion = _messages.StringField(3)
  linkExistingAccountUri = _messages.StringField(4)


class CloudExadataInfrastructure(_messages.Message):
  r"""Represents CloudExadataInfrastructure resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/CloudExadataInfrastructure/

  Messages:
    LabelsValue: Optional. Labels or tags associated with the resource.

  Fields:
    createTime: Output only. The date and time that the Exadata Infrastructure
      was created.
    displayName: Optional. User friendly name for this resource.
    entitlementId: Output only. Entitlement ID of the private offer against
      which this infrastructure resource is provisioned.
    gcpOracleZone: Optional. The GCP Oracle zone where Oracle Exadata
      Infrastructure is hosted. Example: us-east4-b-r2. If not specified, the
      system will pick a zone based on availability.
    labels: Optional. Labels or tags associated with the resource.
    name: Identifier. The name of the Exadata Infrastructure resource with the
      format: projects/{project}/locations/{region}/cloudExadataInfrastructure
      s/{cloud_exadata_infrastructure}
    properties: Optional. Various properties of the infra.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entitlementId = _messages.StringField(3)
  gcpOracleZone = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  properties = _messages.MessageField('CloudExadataInfrastructureProperties', 7)


class CloudExadataInfrastructureProperties(_messages.Message):
  r"""Various properties of Exadata Infrastructure.

  Enums:
    ComputeModelValueValuesEnum: Output only. The compute model of the Exadata
      Infrastructure.
    StateValueValuesEnum: Output only. The current lifecycle state of the
      Exadata Infrastructure.

  Fields:
    activatedStorageCount: Output only. The requested number of additional
      storage servers activated for the Exadata Infrastructure.
    additionalStorageCount: Output only. The requested number of additional
      storage servers for the Exadata Infrastructure.
    availableStorageSizeGb: Output only. The available storage can be
      allocated to the Exadata Infrastructure resource, in gigabytes (GB).
    computeCount: Optional. The number of compute servers for the Exadata
      Infrastructure.
    computeModel: Output only. The compute model of the Exadata
      Infrastructure.
    cpuCount: Output only. The number of enabled CPU cores.
    customerContacts: Optional. The list of customer contacts.
    dataStorageSizeTb: Output only. Size, in terabytes, of the DATA disk
      group.
    databaseServerType: Output only. The database server type of the Exadata
      Infrastructure.
    dbNodeStorageSizeGb: Output only. The local node storage allocated in GBs.
    dbServerVersion: Output only. The software version of the database servers
      (dom0) in the Exadata Infrastructure.
    maintenanceWindow: Optional. Maintenance window for repair.
    maxCpuCount: Output only. The total number of CPU cores available.
    maxDataStorageTb: Output only. The total available DATA disk group size.
    maxDbNodeStorageSizeGb: Output only. The total local node storage
      available in GBs.
    maxMemoryGb: Output only. The total memory available in GBs.
    memorySizeGb: Output only. The memory allocated in GBs.
    monthlyDbServerVersion: Output only. The monthly software version of the
      database servers (dom0) in the Exadata Infrastructure. Example: 20.1.15
    monthlyStorageServerVersion: Output only. The monthly software version of
      the storage servers (cells) in the Exadata Infrastructure. Example:
      20.1.15
    nextMaintenanceRunId: Output only. The OCID of the next maintenance run.
    nextMaintenanceRunTime: Output only. The time when the next maintenance
      run will occur.
    nextSecurityMaintenanceRunTime: Output only. The time when the next
      security maintenance run will occur.
    ociUrl: Output only. Deep link to the OCI console to view this resource.
    ocid: Output only. OCID of created infra. https://docs.oracle.com/en-
      us/iaas/Content/General/Concepts/identifiers.htm#Oracle
    shape: Required. The shape of the Exadata Infrastructure. The shape
      determines the amount of CPU, storage, and memory resources allocated to
      the instance.
    state: Output only. The current lifecycle state of the Exadata
      Infrastructure.
    storageCount: Optional. The number of Cloud Exadata storage servers for
      the Exadata Infrastructure.
    storageServerType: Output only. The storage server type of the Exadata
      Infrastructure.
    storageServerVersion: Output only. The software version of the storage
      servers (cells) in the Exadata Infrastructure.
    totalStorageSizeGb: Optional. The total storage allocated to the Exadata
      Infrastructure resource, in gigabytes (GB).
  """

  class ComputeModelValueValuesEnum(_messages.Enum):
    r"""Output only. The compute model of the Exadata Infrastructure.

    Values:
      COMPUTE_MODEL_UNSPECIFIED: Unspecified compute model.
      COMPUTE_MODEL_ECPU: Abstract measure of compute resources. ECPUs are
        based on the number of cores elastically allocated from a pool of
        compute and storage servers.
      COMPUTE_MODEL_OCPU: Physical measure of compute resources. OCPUs are
        based on the physical core of a processor.
    """
    COMPUTE_MODEL_UNSPECIFIED = 0
    COMPUTE_MODEL_ECPU = 1
    COMPUTE_MODEL_OCPU = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the Exadata
    Infrastructure.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: The Exadata Infrastructure is being provisioned.
      AVAILABLE: The Exadata Infrastructure is available for use.
      UPDATING: The Exadata Infrastructure is being updated.
      TERMINATING: The Exadata Infrastructure is being terminated.
      TERMINATED: The Exadata Infrastructure is terminated.
      FAILED: The Exadata Infrastructure is in failed state.
      MAINTENANCE_IN_PROGRESS: The Exadata Infrastructure is in maintenance.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6
    MAINTENANCE_IN_PROGRESS = 7

  activatedStorageCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  additionalStorageCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  availableStorageSizeGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  computeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  computeModel = _messages.EnumField('ComputeModelValueValuesEnum', 5)
  cpuCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  customerContacts = _messages.MessageField('CustomerContact', 7, repeated=True)
  dataStorageSizeTb = _messages.FloatField(8)
  databaseServerType = _messages.StringField(9)
  dbNodeStorageSizeGb = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  dbServerVersion = _messages.StringField(11)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 12)
  maxCpuCount = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  maxDataStorageTb = _messages.FloatField(14)
  maxDbNodeStorageSizeGb = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  maxMemoryGb = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  memorySizeGb = _messages.IntegerField(17, variant=_messages.Variant.INT32)
  monthlyDbServerVersion = _messages.StringField(18)
  monthlyStorageServerVersion = _messages.StringField(19)
  nextMaintenanceRunId = _messages.StringField(20)
  nextMaintenanceRunTime = _messages.StringField(21)
  nextSecurityMaintenanceRunTime = _messages.StringField(22)
  ociUrl = _messages.StringField(23)
  ocid = _messages.StringField(24)
  shape = _messages.StringField(25)
  state = _messages.EnumField('StateValueValuesEnum', 26)
  storageCount = _messages.IntegerField(27, variant=_messages.Variant.INT32)
  storageServerType = _messages.StringField(28)
  storageServerVersion = _messages.StringField(29)
  totalStorageSizeGb = _messages.IntegerField(30, variant=_messages.Variant.INT32)


class CloudVmCluster(_messages.Message):
  r"""Details of the Cloud VM Cluster resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/CloudVmCluster/

  Messages:
    LabelsValue: Optional. Labels or tags associated with the VM Cluster.

  Fields:
    backupOdbSubnet: Optional. The name of the backup OdbSubnet associated
      with the VM Cluster. Format: projects/{project}/locations/{location}/odb
      Networks/{odb_network}/odbSubnets/{odb_subnet}
    backupSubnetCidr: Optional. CIDR range of the backup subnet.
    cidr: Optional. Network settings. CIDR to use for cluster IP allocation.
    createTime: Output only. The date and time that the VM cluster was
      created.
    displayName: Optional. User friendly name for this resource.
    exadataInfrastructure: Required. The name of the Exadata Infrastructure
      resource on which VM cluster resource is created, in the following
      format: projects/{project}/locations/{region}/cloudExadataInfrastuctures
      /{cloud_extradata_infrastructure}
    exascaleDbStorageVault: Optional. The name of ExascaleDbStorageVault
      associated with the VM Cluster. Format: projects/{project}/locations/{lo
      cation}/exascaleDbStorageVaults/{exascale_db_storage_vault}
    gcpOracleZone: Output only. The GCP Oracle zone where Oracle
      CloudVmCluster is hosted. This will be the same as the gcp_oracle_zone
      of the CloudExadataInfrastructure. Example: us-east4-b-r2.
    identityConnector: Output only. The identity connector details which will
      allow OCI to securely access the resources in the customer project.
    labels: Optional. Labels or tags associated with the VM Cluster.
    name: Identifier. The name of the VM Cluster resource with the format:
      projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
    network: Optional. The name of the VPC network. Format:
      projects/{project}/global/networks/{network}
    odbNetwork: Optional. The name of the OdbNetwork associated with the VM
      Cluster. Format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
      optional but if specified, this should match the parent ODBNetwork of
      the odb_subnet and backup_odb_subnet.
    odbSubnet: Optional. The name of the OdbSubnet associated with the VM
      Cluster for IP allocation. Format: projects/{project}/locations/{locatio
      n}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
    properties: Optional. Various properties of the VM Cluster.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels or tags associated with the VM Cluster.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupOdbSubnet = _messages.StringField(1)
  backupSubnetCidr = _messages.StringField(2)
  cidr = _messages.StringField(3)
  createTime = _messages.StringField(4)
  displayName = _messages.StringField(5)
  exadataInfrastructure = _messages.StringField(6)
  exascaleDbStorageVault = _messages.StringField(7)
  gcpOracleZone = _messages.StringField(8)
  identityConnector = _messages.MessageField('IdentityConnector', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  name = _messages.StringField(11)
  network = _messages.StringField(12)
  odbNetwork = _messages.StringField(13)
  odbSubnet = _messages.StringField(14)
  properties = _messages.MessageField('CloudVmClusterProperties', 15)


class CloudVmClusterProperties(_messages.Message):
  r"""Various properties and settings associated with Exadata VM cluster.

  Enums:
    ComputeModelValueValuesEnum: Output only. The compute model of the VM
      Cluster.
    DiskRedundancyValueValuesEnum: Optional. The type of redundancy.
    LicenseTypeValueValuesEnum: Required. License type of VM Cluster.
    StateValueValuesEnum: Output only. State of the cluster.

  Fields:
    clusterName: Optional. OCI Cluster name.
    compartmentId: Output only. Compartment ID of cluster.
    computeModel: Output only. The compute model of the VM Cluster.
    cpuCoreCount: Required. Number of enabled CPU cores.
    dataStorageSizeTb: Optional. The data disk group size to be allocated in
      TBs.
    dbNodeStorageSizeGb: Optional. Local storage per VM.
    dbServerOcids: Optional. OCID of database servers.
    diagnosticsDataCollectionOptions: Optional. Data collection options for
      diagnostics.
    diskRedundancy: Optional. The type of redundancy.
    dnsListenerIp: Output only. DNS listener IP.
    domain: Output only. Parent DNS domain where SCAN DNS and hosts names are
      qualified. ex: ocispdelegated.ocisp10jvnet.oraclevcn.com
    giVersion: Optional. Grid Infrastructure Version.
    hostname: Output only. host name without domain. format: "-" with some
      suffix. ex: sp2-yi0xq where "sp2" is the hostname_prefix.
    hostnamePrefix: Optional. Prefix for VM cluster host names.
    licenseType: Required. License type of VM Cluster.
    localBackupEnabled: Optional. Use local backup.
    memorySizeGb: Optional. Memory allocated in GBs.
    nodeCount: Optional. Number of database servers.
    ociUrl: Output only. Deep link to the OCI console to view this resource.
    ocid: Output only. Oracle Cloud Infrastructure ID of VM Cluster.
    ocpuCount: Optional. OCPU count per VM. Minimum is 0.1.
    scanDns: Output only. SCAN DNS name. ex: sp2-yi0xq-
      scan.ocispdelegated.ocisp10jvnet.oraclevcn.com
    scanDnsRecordId: Output only. OCID of scan DNS record.
    scanIpIds: Output only. OCIDs of scan IPs.
    scanListenerPortTcp: Output only. SCAN listener port - TCP
    scanListenerPortTcpSsl: Output only. SCAN listener port - TLS
    shape: Output only. Shape of VM Cluster.
    sparseDiskgroupEnabled: Optional. Use exadata sparse snapshots.
    sshPublicKeys: Optional. SSH public keys to be stored with cluster.
    state: Output only. State of the cluster.
    storageSizeGb: Output only. The storage allocation for the disk group, in
      gigabytes (GB).
    systemVersion: Optional. Operating system version of the image.
    timeZone: Optional. Time zone of VM Cluster to set. Defaults to UTC if not
      specified.
  """

  class ComputeModelValueValuesEnum(_messages.Enum):
    r"""Output only. The compute model of the VM Cluster.

    Values:
      COMPUTE_MODEL_UNSPECIFIED: Unspecified compute model.
      COMPUTE_MODEL_ECPU: Abstract measure of compute resources. ECPUs are
        based on the number of cores elastically allocated from a pool of
        compute and storage servers.
      COMPUTE_MODEL_OCPU: Physical measure of compute resources. OCPUs are
        based on the physical core of a processor.
    """
    COMPUTE_MODEL_UNSPECIFIED = 0
    COMPUTE_MODEL_ECPU = 1
    COMPUTE_MODEL_OCPU = 2

  class DiskRedundancyValueValuesEnum(_messages.Enum):
    r"""Optional. The type of redundancy.

    Values:
      DISK_REDUNDANCY_UNSPECIFIED: Unspecified.
      HIGH: High - 3 way mirror.
      NORMAL: Normal - 2 way mirror.
    """
    DISK_REDUNDANCY_UNSPECIFIED = 0
    HIGH = 1
    NORMAL = 2

  class LicenseTypeValueValuesEnum(_messages.Enum):
    r"""Required. License type of VM Cluster.

    Values:
      LICENSE_TYPE_UNSPECIFIED: Unspecified
      LICENSE_INCLUDED: License included part of offer
      BRING_YOUR_OWN_LICENSE: Bring your own license
    """
    LICENSE_TYPE_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the cluster.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      UPDATING: Indicates that the resource is in updating state.
      TERMINATING: Indicates that the resource is in terminating state.
      TERMINATED: Indicates that the resource is in terminated state.
      FAILED: Indicates that the resource is in failed state.
      MAINTENANCE_IN_PROGRESS: Indicates that the resource is in maintenance
        in progress state.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6
    MAINTENANCE_IN_PROGRESS = 7

  clusterName = _messages.StringField(1)
  compartmentId = _messages.StringField(2)
  computeModel = _messages.EnumField('ComputeModelValueValuesEnum', 3)
  cpuCoreCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  dataStorageSizeTb = _messages.FloatField(5)
  dbNodeStorageSizeGb = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  dbServerOcids = _messages.StringField(7, repeated=True)
  diagnosticsDataCollectionOptions = _messages.MessageField('DataCollectionOptions', 8)
  diskRedundancy = _messages.EnumField('DiskRedundancyValueValuesEnum', 9)
  dnsListenerIp = _messages.StringField(10)
  domain = _messages.StringField(11)
  giVersion = _messages.StringField(12)
  hostname = _messages.StringField(13)
  hostnamePrefix = _messages.StringField(14)
  licenseType = _messages.EnumField('LicenseTypeValueValuesEnum', 15)
  localBackupEnabled = _messages.BooleanField(16)
  memorySizeGb = _messages.IntegerField(17, variant=_messages.Variant.INT32)
  nodeCount = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  ociUrl = _messages.StringField(19)
  ocid = _messages.StringField(20)
  ocpuCount = _messages.FloatField(21, variant=_messages.Variant.FLOAT)
  scanDns = _messages.StringField(22)
  scanDnsRecordId = _messages.StringField(23)
  scanIpIds = _messages.StringField(24, repeated=True)
  scanListenerPortTcp = _messages.IntegerField(25, variant=_messages.Variant.INT32)
  scanListenerPortTcpSsl = _messages.IntegerField(26, variant=_messages.Variant.INT32)
  shape = _messages.StringField(27)
  sparseDiskgroupEnabled = _messages.BooleanField(28)
  sshPublicKeys = _messages.StringField(29, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 30)
  storageSizeGb = _messages.IntegerField(31, variant=_messages.Variant.INT32)
  systemVersion = _messages.StringField(32)
  timeZone = _messages.MessageField('TimeZone', 33)


class CustomerContact(_messages.Message):
  r"""The CustomerContact reference as defined by Oracle.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/CustomerContact

  Fields:
    email: Required. The email address used by Oracle to send notifications
      regarding databases and infrastructure.
  """

  email = _messages.StringField(1)


class DataCollectionOptions(_messages.Message):
  r"""Data collection options for diagnostics.

  Fields:
    diagnosticsEventsEnabled: Optional. Indicates whether diagnostic
      collection is enabled for the VM cluster
    healthMonitoringEnabled: Optional. Indicates whether health monitoring is
      enabled for the VM cluster
    incidentLogsEnabled: Optional. Indicates whether incident logs and trace
      collection are enabled for the VM cluster
  """

  diagnosticsEventsEnabled = _messages.BooleanField(1)
  healthMonitoringEnabled = _messages.BooleanField(2)
  incidentLogsEnabled = _messages.BooleanField(3)


class DataCollectionOptionsCommon(_messages.Message):
  r"""Data collection options for diagnostics. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/DataCollectionOptions

  Fields:
    isDiagnosticsEventsEnabled: Optional. Indicates whether to enable data
      collection for diagnostics.
    isHealthMonitoringEnabled: Optional. Indicates whether to enable health
      monitoring.
    isIncidentLogsEnabled: Optional. Indicates whether to enable incident logs
      and trace collection.
  """

  isDiagnosticsEventsEnabled = _messages.BooleanField(1)
  isHealthMonitoringEnabled = _messages.BooleanField(2)
  isIncidentLogsEnabled = _messages.BooleanField(3)


class DataCollectionOptionsDbSystem(_messages.Message):
  r"""Data collection options for DbSystem.

  Fields:
    isDiagnosticsEventsEnabled: Optional. Indicates whether to enable data
      collection for diagnostics.
    isIncidentLogsEnabled: Optional. Indicates whether to enable incident logs
      and trace collection.
  """

  isDiagnosticsEventsEnabled = _messages.BooleanField(1)
  isIncidentLogsEnabled = _messages.BooleanField(2)


class Database(_messages.Message):
  r"""Details of the Database resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/Database/

  Enums:
    OpsInsightsStatusValueValuesEnum: Output only. The Status of Operations
      Insights for this Database.

  Fields:
    adminPassword: Required. The password for the default ADMIN user.
    characterSet: Optional. The character set for the database. The default is
      AL32UTF8.
    createTime: Output only. The date and time that the Database was created.
    databaseId: Optional. The database ID of the Database.
    dbHomeName: Optional. The name of the DbHome resource associated with the
      Database.
    dbName: Optional. The database name. The name must begin with an
      alphabetic character and can contain a maximum of eight alphanumeric
      characters. Special characters are not permitted.
    dbUniqueName: Optional. The DB_UNIQUE_NAME of the Oracle Database being
      backed up.
    gcpOracleZone: Output only. The GCP Oracle zone where the Database is
      created.
    name: Identifier. The name of the Database resource in the following
      format: projects/{project}/locations/{region}/databases/{database}
    ncharacterSet: Optional. The national character set for the database. The
      default is AL16UTF16.
    ociUrl: Output only. HTTPS link to OCI resources exposed to Customer via
      UI Interface.
    opsInsightsStatus: Output only. The Status of Operations Insights for this
      Database.
    pluggableDatabaseId: Optional. The ID of the pluggable database associated
      with the Database. The ID must be unique within the project and
      location.
    pluggableDatabaseName: Optional. The pluggable database associated with
      the Database. The name must begin with an alphabetic character and can
      contain a maximum of thirty alphanumeric characters.
    properties: Optional. The properties of the Database.
    tdeWalletPassword: Optional. The TDE wallet password for the database.
  """

  class OpsInsightsStatusValueValuesEnum(_messages.Enum):
    r"""Output only. The Status of Operations Insights for this Database.

    Values:
      OPERATIONS_INSIGHTS_STATUS_UNSPECIFIED: Default unspecified value.
      ENABLING: Indicates that the operations insights are being enabled.
      ENABLED: Indicates that the operations insights are enabled.
      DISABLING: Indicates that the operations insights are being disabled.
      NOT_ENABLED: Indicates that the operations insights are not enabled.
      FAILED_ENABLING: Indicates that the operations insights failed to
        enable.
      FAILED_DISABLING: Indicates that the operations insights failed to
        disable.
    """
    OPERATIONS_INSIGHTS_STATUS_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    NOT_ENABLED = 4
    FAILED_ENABLING = 5
    FAILED_DISABLING = 6

  adminPassword = _messages.StringField(1)
  characterSet = _messages.StringField(2)
  createTime = _messages.StringField(3)
  databaseId = _messages.StringField(4)
  dbHomeName = _messages.StringField(5)
  dbName = _messages.StringField(6)
  dbUniqueName = _messages.StringField(7)
  gcpOracleZone = _messages.StringField(8)
  name = _messages.StringField(9)
  ncharacterSet = _messages.StringField(10)
  ociUrl = _messages.StringField(11)
  opsInsightsStatus = _messages.EnumField('OpsInsightsStatusValueValuesEnum', 12)
  pluggableDatabaseId = _messages.StringField(13)
  pluggableDatabaseName = _messages.StringField(14)
  properties = _messages.MessageField('DatabaseProperties', 15)
  tdeWalletPassword = _messages.StringField(16)


class DatabaseCharacterSet(_messages.Message):
  r"""Details of the Database character set resource.

  Enums:
    CharacterSetTypeValueValuesEnum: Output only. The character set type for
      the Database.

  Fields:
    characterSet: Output only. The character set name for the Database which
      is the ID in the resource name.
    characterSetType: Output only. The character set type for the Database.
    name: Identifier. The name of the Database Character Set resource in the
      following format: projects/{project}/locations/{region}/databaseCharacte
      rSets/{database_character_set}
  """

  class CharacterSetTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The character set type for the Database.

    Values:
      CHARACTER_SET_TYPE_UNSPECIFIED: Character set type is not specified.
      DATABASE: Character set type is set to database.
      NATIONAL: Character set type is set to national.
    """
    CHARACTER_SET_TYPE_UNSPECIFIED = 0
    DATABASE = 1
    NATIONAL = 2

  characterSet = _messages.StringField(1)
  characterSetType = _messages.EnumField('CharacterSetTypeValueValuesEnum', 2)
  name = _messages.StringField(3)


class DatabaseConnectionStringProfile(_messages.Message):
  r"""The connection string profile to allow clients to group.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/DatabaseConnectionStringProfile

  Enums:
    ConsumerGroupValueValuesEnum: Output only. The current consumer group
      being used by the connection.
    HostFormatValueValuesEnum: Output only. The host name format being
      currently used in connection string.
    ProtocolValueValuesEnum: Output only. The protocol being used by the
      connection.
    SessionModeValueValuesEnum: Output only. The current session mode of the
      connection.
    SyntaxFormatValueValuesEnum: Output only. The syntax of the connection
      string.
    TlsAuthenticationValueValuesEnum: Output only. This field indicates the
      TLS authentication type of the connection.

  Fields:
    consumerGroup: Output only. The current consumer group being used by the
      connection.
    displayName: Output only. The display name for the database connection.
    hostFormat: Output only. The host name format being currently used in
      connection string.
    isRegional: Output only. This field indicates if the connection string is
      regional and is only applicable for cross-region Data Guard.
    protocol: Output only. The protocol being used by the connection.
    sessionMode: Output only. The current session mode of the connection.
    syntaxFormat: Output only. The syntax of the connection string.
    tlsAuthentication: Output only. This field indicates the TLS
      authentication type of the connection.
    value: Output only. The value of the connection string.
  """

  class ConsumerGroupValueValuesEnum(_messages.Enum):
    r"""Output only. The current consumer group being used by the connection.

    Values:
      CONSUMER_GROUP_UNSPECIFIED: Default unspecified value.
      HIGH: High consumer group.
      MEDIUM: Medium consumer group.
      LOW: Low consumer group.
      TP: TP consumer group.
      TPURGENT: TPURGENT consumer group.
    """
    CONSUMER_GROUP_UNSPECIFIED = 0
    HIGH = 1
    MEDIUM = 2
    LOW = 3
    TP = 4
    TPURGENT = 5

  class HostFormatValueValuesEnum(_messages.Enum):
    r"""Output only. The host name format being currently used in connection
    string.

    Values:
      HOST_FORMAT_UNSPECIFIED: Default unspecified value.
      FQDN: FQDN
      IP: IP
    """
    HOST_FORMAT_UNSPECIFIED = 0
    FQDN = 1
    IP = 2

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Output only. The protocol being used by the connection.

    Values:
      PROTOCOL_UNSPECIFIED: Default unspecified value.
      TCP: Tcp
      TCPS: Tcps
    """
    PROTOCOL_UNSPECIFIED = 0
    TCP = 1
    TCPS = 2

  class SessionModeValueValuesEnum(_messages.Enum):
    r"""Output only. The current session mode of the connection.

    Values:
      SESSION_MODE_UNSPECIFIED: Default unspecified value.
      DIRECT: Direct
      INDIRECT: Indirect
    """
    SESSION_MODE_UNSPECIFIED = 0
    DIRECT = 1
    INDIRECT = 2

  class SyntaxFormatValueValuesEnum(_messages.Enum):
    r"""Output only. The syntax of the connection string.

    Values:
      SYNTAX_FORMAT_UNSPECIFIED: Default unspecified value.
      LONG: Long
      EZCONNECT: Ezconnect
      EZCONNECTPLUS: Ezconnectplus
    """
    SYNTAX_FORMAT_UNSPECIFIED = 0
    LONG = 1
    EZCONNECT = 2
    EZCONNECTPLUS = 3

  class TlsAuthenticationValueValuesEnum(_messages.Enum):
    r"""Output only. This field indicates the TLS authentication type of the
    connection.

    Values:
      TLS_AUTHENTICATION_UNSPECIFIED: Default unspecified value.
      SERVER: Server
      MUTUAL: Mutual
    """
    TLS_AUTHENTICATION_UNSPECIFIED = 0
    SERVER = 1
    MUTUAL = 2

  consumerGroup = _messages.EnumField('ConsumerGroupValueValuesEnum', 1)
  displayName = _messages.StringField(2)
  hostFormat = _messages.EnumField('HostFormatValueValuesEnum', 3)
  isRegional = _messages.BooleanField(4)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 5)
  sessionMode = _messages.EnumField('SessionModeValueValuesEnum', 6)
  syntaxFormat = _messages.EnumField('SyntaxFormatValueValuesEnum', 7)
  tlsAuthentication = _messages.EnumField('TlsAuthenticationValueValuesEnum', 8)
  value = _messages.StringField(9)


class DatabaseManagementConfig(_messages.Message):
  r"""The configuration of the Database Management service.

  Enums:
    ManagementStateValueValuesEnum: Output only. The status of the Database
      Management service.
    ManagementTypeValueValuesEnum: Output only. The Database Management type.

  Fields:
    managementState: Output only. The status of the Database Management
      service.
    managementType: Output only. The Database Management type.
  """

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. The status of the Database Management service.

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: The status is not specified.
      ENABLING: The Database Management service is enabling.
      ENABLED: The Database Management service is enabled.
      DISABLING: The Database Management service is disabling.
      DISABLED: The Database Management service is disabled.
      UPDATING: The Database Management service is updating.
      FAILED_ENABLING: The Database Management service failed to enable.
      FAILED_DISABLING: The Database Management service failed to disable.
      FAILED_UPDATING: The Database Management service failed to update.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    DISABLED = 4
    UPDATING = 5
    FAILED_ENABLING = 6
    FAILED_DISABLING = 7
    FAILED_UPDATING = 8

  class ManagementTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The Database Management type.

    Values:
      MANAGEMENT_TYPE_UNSPECIFIED: The type is not specified.
      BASIC: Basic Database Management.
      ADVANCED: Advanced Database Management.
    """
    MANAGEMENT_TYPE_UNSPECIFIED = 0
    BASIC = 1
    ADVANCED = 2

  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 1)
  managementType = _messages.EnumField('ManagementTypeValueValuesEnum', 2)


class DatabaseProperties(_messages.Message):
  r"""The properties of a Database.

  Enums:
    StateValueValuesEnum: Output only. State of the Database.

  Fields:
    databaseManagementConfig: Output only. The Database Management config.
    dbBackupConfig: Optional. Backup options for the Database.
    dbVersion: Required. The Oracle Database version.
    state: Output only. State of the Database.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the Database.

    Values:
      DATABASE_LIFECYCLE_STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      UPDATING: Indicates that the resource is in updating state.
      BACKUP_IN_PROGRESS: Indicates that the resource is in backup in progress
        state.
      UPGRADING: Indicates that the resource is in upgrading state.
      CONVERTING: Indicates that the resource is in converting state.
      TERMINATING: Indicates that the resource is in terminating state.
      TERMINATED: Indicates that the resource is in terminated state.
      RESTORE_FAILED: Indicates that the resource is in restore failed state.
      FAILED: Indicates that the resource is in failed state.
    """
    DATABASE_LIFECYCLE_STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    BACKUP_IN_PROGRESS = 4
    UPGRADING = 5
    CONVERTING = 6
    TERMINATING = 7
    TERMINATED = 8
    RESTORE_FAILED = 9
    FAILED = 10

  databaseManagementConfig = _messages.MessageField('DatabaseManagementConfig', 1)
  dbBackupConfig = _messages.MessageField('DbBackupConfig', 2)
  dbVersion = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class DbBackupConfig(_messages.Message):
  r"""Backup Options for the Database.

  Enums:
    AutoFullBackupDayValueValuesEnum: Optional. The day of the week on which
      the full backup should be performed on the database. If no value is
      provided, it will default to Sunday.
    AutoFullBackupWindowValueValuesEnum: Optional. The window in which the
      full backup should be performed on the database. If no value is
      provided, the default is anytime.
    AutoIncrementalBackupWindowValueValuesEnum: Optional. The window in which
      the incremental backup should be performed on the database. If no value
      is provided, the default is anytime except the auto full backup day.
    BackupDeletionPolicyValueValuesEnum: Optional. This defines when the
      backups will be deleted after Database termination.

  Fields:
    autoBackupEnabled: Optional. If set to true, enables automatic backups on
      the database.
    autoFullBackupDay: Optional. The day of the week on which the full backup
      should be performed on the database. If no value is provided, it will
      default to Sunday.
    autoFullBackupWindow: Optional. The window in which the full backup should
      be performed on the database. If no value is provided, the default is
      anytime.
    autoIncrementalBackupWindow: Optional. The window in which the incremental
      backup should be performed on the database. If no value is provided, the
      default is anytime except the auto full backup day.
    backupDeletionPolicy: Optional. This defines when the backups will be
      deleted after Database termination.
    backupDestinationDetails: Optional. Details of the database backup
      destinations.
    retentionPeriodDays: Optional. The number of days an automatic backup is
      retained before being automatically deleted. This value determines the
      earliest point in time to which a database can be restored. Min: 1, Max:
      60.
  """

  class AutoFullBackupDayValueValuesEnum(_messages.Enum):
    r"""Optional. The day of the week on which the full backup should be
    performed on the database. If no value is provided, it will default to
    Sunday.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class AutoFullBackupWindowValueValuesEnum(_messages.Enum):
    r"""Optional. The window in which the full backup should be performed on
    the database. If no value is provided, the default is anytime.

    Values:
      BACKUP_WINDOW_UNSPECIFIED: Default unspecified value.
      SLOT_ONE: 12:00 AM - 2:00 AM
      SLOT_TWO: 2:00 AM - 4:00 AM
      SLOT_THREE: 4:00 AM - 6:00 AM
      SLOT_FOUR: 6:00 AM - 8:00 AM
      SLOT_FIVE: 8:00 AM - 10:00 AM
      SLOT_SIX: 10:00 AM - 12:00 PM
      SLOT_SEVEN: 12:00 PM - 2:00 PM
      SLOT_EIGHT: 2:00 PM - 4:00 PM
      SLOT_NINE: 4:00 PM - 6:00 PM
      SLOT_TEN: 6:00 PM - 8:00 PM
      SLOT_ELEVEN: 8:00 PM - 10:00 PM
      SLOT_TWELVE: 10:00 PM - 12:00 AM
    """
    BACKUP_WINDOW_UNSPECIFIED = 0
    SLOT_ONE = 1
    SLOT_TWO = 2
    SLOT_THREE = 3
    SLOT_FOUR = 4
    SLOT_FIVE = 5
    SLOT_SIX = 6
    SLOT_SEVEN = 7
    SLOT_EIGHT = 8
    SLOT_NINE = 9
    SLOT_TEN = 10
    SLOT_ELEVEN = 11
    SLOT_TWELVE = 12

  class AutoIncrementalBackupWindowValueValuesEnum(_messages.Enum):
    r"""Optional. The window in which the incremental backup should be
    performed on the database. If no value is provided, the default is anytime
    except the auto full backup day.

    Values:
      BACKUP_WINDOW_UNSPECIFIED: Default unspecified value.
      SLOT_ONE: 12:00 AM - 2:00 AM
      SLOT_TWO: 2:00 AM - 4:00 AM
      SLOT_THREE: 4:00 AM - 6:00 AM
      SLOT_FOUR: 6:00 AM - 8:00 AM
      SLOT_FIVE: 8:00 AM - 10:00 AM
      SLOT_SIX: 10:00 AM - 12:00 PM
      SLOT_SEVEN: 12:00 PM - 2:00 PM
      SLOT_EIGHT: 2:00 PM - 4:00 PM
      SLOT_NINE: 4:00 PM - 6:00 PM
      SLOT_TEN: 6:00 PM - 8:00 PM
      SLOT_ELEVEN: 8:00 PM - 10:00 PM
      SLOT_TWELVE: 10:00 PM - 12:00 AM
    """
    BACKUP_WINDOW_UNSPECIFIED = 0
    SLOT_ONE = 1
    SLOT_TWO = 2
    SLOT_THREE = 3
    SLOT_FOUR = 4
    SLOT_FIVE = 5
    SLOT_SIX = 6
    SLOT_SEVEN = 7
    SLOT_EIGHT = 8
    SLOT_NINE = 9
    SLOT_TEN = 10
    SLOT_ELEVEN = 11
    SLOT_TWELVE = 12

  class BackupDeletionPolicyValueValuesEnum(_messages.Enum):
    r"""Optional. This defines when the backups will be deleted after Database
    termination.

    Values:
      BACKUP_DELETION_POLICY_UNSPECIFIED: Default unspecified value.
      DELETE_IMMEDIATELY: Keeps the backup for predefined time i.e. 72 hours
        and then delete permanently.
      DELETE_AFTER_RETENTION_PERIOD: Keeps the backups as per the policy
        defined for database backups.
    """
    BACKUP_DELETION_POLICY_UNSPECIFIED = 0
    DELETE_IMMEDIATELY = 1
    DELETE_AFTER_RETENTION_PERIOD = 2

  autoBackupEnabled = _messages.BooleanField(1)
  autoFullBackupDay = _messages.EnumField('AutoFullBackupDayValueValuesEnum', 2)
  autoFullBackupWindow = _messages.EnumField('AutoFullBackupWindowValueValuesEnum', 3)
  autoIncrementalBackupWindow = _messages.EnumField('AutoIncrementalBackupWindowValueValuesEnum', 4)
  backupDeletionPolicy = _messages.EnumField('BackupDeletionPolicyValueValuesEnum', 5)
  backupDestinationDetails = _messages.MessageField('BackupDestinationDetails', 6, repeated=True)
  retentionPeriodDays = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class DbHome(_messages.Message):
  r"""Details of the Database Home resource.

  Fields:
    database: Required. The Database resource.
    dbVersion: Required. A valid Oracle Database version. For a list of
      supported versions, use the ListDbVersions operation.
    displayName: Optional. The display name for the Database Home. The name
      does not have to be unique within your project.
    isUnifiedAuditingEnabled: Optional. Whether unified auditing is enabled
      for the Database Home.
  """

  database = _messages.MessageField('Database', 1)
  dbVersion = _messages.StringField(2)
  displayName = _messages.StringField(3)
  isUnifiedAuditingEnabled = _messages.BooleanField(4)


class DbNode(_messages.Message):
  r"""Details of the database node resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbNode/

  Fields:
    name: Identifier. The name of the database node resource in the following
      format: projects/{project}/locations/{location}/cloudVmClusters/{cloud_v
      m_cluster}/dbNodes/{db_node}
    properties: Optional. Various properties of the database node.
  """

  name = _messages.StringField(1)
  properties = _messages.MessageField('DbNodeProperties', 2)


class DbNodeProperties(_messages.Message):
  r"""Various properties and settings associated with Db node.

  Enums:
    StateValueValuesEnum: Output only. State of the database node.

  Fields:
    createTime: Output only. The date and time that the database node was
      created.
    dbNodeStorageSizeGb: Optional. Local storage per database node.
    dbServerOcid: Optional. Database server OCID.
    hostname: Optional. DNS
    memorySizeGb: Memory allocated in GBs.
    ocid: Output only. OCID of database node.
    ocpuCount: Optional. OCPU count per database node.
    state: Output only. State of the database node.
    totalCpuCoreCount: Total CPU core count of the database node.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the database node.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      UPDATING: Indicates that the resource is in updating state.
      STOPPING: Indicates that the resource is in stopping state.
      STOPPED: Indicates that the resource is in stopped state.
      STARTING: Indicates that the resource is in starting state.
      TERMINATING: Indicates that the resource is in terminating state.
      TERMINATED: Indicates that the resource is in terminated state.
      FAILED: Indicates that the resource is in failed state.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    STOPPING = 4
    STOPPED = 5
    STARTING = 6
    TERMINATING = 7
    TERMINATED = 8
    FAILED = 9

  createTime = _messages.StringField(1)
  dbNodeStorageSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  dbServerOcid = _messages.StringField(3)
  hostname = _messages.StringField(4)
  memorySizeGb = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  ocid = _messages.StringField(6)
  ocpuCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  totalCpuCoreCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class DbServer(_messages.Message):
  r"""Details of the database server resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbServer/

  Fields:
    displayName: Optional. User friendly name for this resource.
    name: Identifier. The name of the database server resource with the
      format: projects/{project}/locations/{location}/cloudExadataInfrastructu
      res/{cloud_exadata_infrastructure}/dbServers/{db_server}
    properties: Optional. Various properties of the database server.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  properties = _messages.MessageField('DbServerProperties', 3)


class DbServerProperties(_messages.Message):
  r"""Various properties and settings associated with Exadata database server.

  Enums:
    StateValueValuesEnum: Output only. State of the database server.

  Fields:
    dbNodeIds: Output only. OCID of database nodes associated with the
      database server.
    dbNodeStorageSizeGb: Optional. Local storage per VM.
    maxDbNodeStorageSizeGb: Optional. Maximum local storage per VM.
    maxMemorySizeGb: Optional. Maximum memory allocated in GBs.
    maxOcpuCount: Optional. Maximum OCPU count per database.
    memorySizeGb: Optional. Memory allocated in GBs.
    ocid: Output only. OCID of database server.
    ocpuCount: Optional. OCPU count per database.
    state: Output only. State of the database server.
    vmCount: Optional. Vm count per database.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the database server.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      CREATING: Indicates that the resource is in creating state.
      AVAILABLE: Indicates that the resource is in available state.
      UNAVAILABLE: Indicates that the resource is in unavailable state.
      DELETING: Indicates that the resource is in deleting state.
      DELETED: Indicates that the resource is in deleted state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    AVAILABLE = 2
    UNAVAILABLE = 3
    DELETING = 4
    DELETED = 5

  dbNodeIds = _messages.StringField(1, repeated=True)
  dbNodeStorageSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  maxDbNodeStorageSizeGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  maxMemorySizeGb = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxOcpuCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  memorySizeGb = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  ocid = _messages.StringField(7)
  ocpuCount = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  vmCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class DbSystem(_messages.Message):
  r"""Details of the DbSystem (BaseDB) resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbSystem/

  Messages:
    LabelsValue: Optional. The labels or tags associated with the DbSystem.

  Fields:
    createTime: Output only. The date and time that the DbSystem was created.
    displayName: Required. The display name for the System db. The name does
      not have to be unique within your project.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the DbSystem
    gcpOracleZone: Optional. The GCP Oracle zone where Oracle DbSystem is
      hosted. Example: us-east4-b-r2. If not specified, the system will pick a
      zone based on availability.
    labels: Optional. The labels or tags associated with the DbSystem.
    name: Identifier. The name of the DbSystem resource in the following
      format: projects/{project}/locations/{region}/dbSystems/{db_system}
    ociUrl: Output only. HTTPS link to OCI resources exposed to Customer via
      UI Interface.
    odbNetwork: Optional. The name of the OdbNetwork associated with the
      DbSystem. Format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
      optional but if specified, this should match the parent ODBNetwork of
      the OdbSubnet.
    odbSubnet: Required. The name of the OdbSubnet associated with the
      DbSystem for IP allocation. Format: projects/{project}/locations/{locati
      on}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
    properties: Optional. The properties of the DbSystem.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the DbSystem.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entitlementId = _messages.StringField(3)
  gcpOracleZone = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  ociUrl = _messages.StringField(7)
  odbNetwork = _messages.StringField(8)
  odbSubnet = _messages.StringField(9)
  properties = _messages.MessageField('DbSystemProperties', 10)


class DbSystemInitialStorageSize(_messages.Message):
  r"""Summary of the DbSystem initial storage size.

  Fields:
    name: Output only. The name of the resource.
    properties: Output only. The properties of the DbSystem initial storage
      size summary.
  """

  name = _messages.StringField(1)
  properties = _messages.MessageField('DbSystemInitialStorageSizeProperties', 2)


class DbSystemInitialStorageSizeProperties(_messages.Message):
  r"""The properties of a DbSystem initial storage size summary.

  Enums:
    ShapeTypeValueValuesEnum: Output only. VM shape platform type
    StorageManagementValueValuesEnum: Output only. The storage option used in
      DB system.

  Fields:
    launchFromBackupStorageSizeDetails: Output only. List of storage disk
      details available for launches from backup.
    shapeType: Output only. VM shape platform type
    storageManagement: Output only. The storage option used in DB system.
    storageSizeDetails: Output only. List of storage disk details.
  """

  class ShapeTypeValueValuesEnum(_messages.Enum):
    r"""Output only. VM shape platform type

    Values:
      SHAPE_TYPE_UNSPECIFIED: Unspecified shape type.
      STANDARD_X86: Standard X86.
    """
    SHAPE_TYPE_UNSPECIFIED = 0
    STANDARD_X86 = 1

  class StorageManagementValueValuesEnum(_messages.Enum):
    r"""Output only. The storage option used in DB system.

    Values:
      STORAGE_MANAGEMENT_UNSPECIFIED: Unspecified storage management.
      ASM: Automatic Storage Management.
      LVM: Logical Volume Management.
    """
    STORAGE_MANAGEMENT_UNSPECIFIED = 0
    ASM = 1
    LVM = 2

  launchFromBackupStorageSizeDetails = _messages.MessageField('StorageSizeDetails', 1, repeated=True)
  shapeType = _messages.EnumField('ShapeTypeValueValuesEnum', 2)
  storageManagement = _messages.EnumField('StorageManagementValueValuesEnum', 3)
  storageSizeDetails = _messages.MessageField('StorageSizeDetails', 4, repeated=True)


class DbSystemOptions(_messages.Message):
  r"""Details of the DbSystem Options.

  Enums:
    StorageManagementValueValuesEnum: Optional. The storage option used in DB
      system.

  Fields:
    storageManagement: Optional. The storage option used in DB system.
  """

  class StorageManagementValueValuesEnum(_messages.Enum):
    r"""Optional. The storage option used in DB system.

    Values:
      STORAGE_MANAGEMENT_UNSPECIFIED: The storage management is unspecified.
      ASM: Automatic storage management.
      LVM: Logical Volume management.
    """
    STORAGE_MANAGEMENT_UNSPECIFIED = 0
    ASM = 1
    LVM = 2

  storageManagement = _messages.EnumField('StorageManagementValueValuesEnum', 1)


class DbSystemProperties(_messages.Message):
  r"""The properties of a DbSystem.

  Enums:
    ComputeModelValueValuesEnum: Optional. The compute model of the DbSystem.
    DatabaseEditionValueValuesEnum: Required. The database edition of the
      DbSystem.
    LicenseModelValueValuesEnum: Required. The license model of the DbSystem.
    LifecycleStateValueValuesEnum: Output only. State of the DbSystem.

  Fields:
    computeCount: Required. The number of CPU cores to enable for the
      DbSystem.
    computeModel: Optional. The compute model of the DbSystem.
    dataCollectionOptions: Optional. Data collection options for diagnostics.
    dataStorageSizeGb: Optional. The data storage size in GB that is currently
      available to DbSystems.
    databaseEdition: Required. The database edition of the DbSystem.
    dbHome: Optional. Details for creating a Database Home.
    dbSystemOptions: Optional. The options for the DbSystem.
    domain: Optional. The host domain name of the DbSystem.
    hostname: Output only. The hostname of the DbSystem.
    hostnamePrefix: Optional. Prefix for DB System host names.
    initialDataStorageSizeGb: Required. The initial data storage size in GB.
    licenseModel: Required. The license model of the DbSystem.
    lifecycleState: Output only. State of the DbSystem.
    memorySizeGb: Optional. The memory size in GB.
    nodeCount: Optional. The number of nodes in the DbSystem.
    ocid: Output only. OCID of the DbSystem.
    privateIp: Optional. The private IP address of the DbSystem.
    recoStorageSizeGb: Optional. The reco/redo storage size in GB.
    shape: Required. Shape of DB System.
    sshPublicKeys: Required. SSH public keys to be stored with the DbSystem.
    timeZone: Optional. Time zone of the DbSystem.
  """

  class ComputeModelValueValuesEnum(_messages.Enum):
    r"""Optional. The compute model of the DbSystem.

    Values:
      COMPUTE_MODEL_UNSPECIFIED: The compute model is unspecified.
      ECPU: The compute model is virtual.
      OCPU: The compute model is physical.
    """
    COMPUTE_MODEL_UNSPECIFIED = 0
    ECPU = 1
    OCPU = 2

  class DatabaseEditionValueValuesEnum(_messages.Enum):
    r"""Required. The database edition of the DbSystem.

    Values:
      DB_SYSTEM_DATABASE_EDITION_UNSPECIFIED: The database edition is
        unspecified.
      STANDARD_EDITION: The database edition is Standard.
      ENTERPRISE_EDITION: The database edition is Enterprise.
      ENTERPRISE_EDITION_HIGH_PERFORMANCE: The database edition is Enterprise
        Edition.
    """
    DB_SYSTEM_DATABASE_EDITION_UNSPECIFIED = 0
    STANDARD_EDITION = 1
    ENTERPRISE_EDITION = 2
    ENTERPRISE_EDITION_HIGH_PERFORMANCE = 3

  class LicenseModelValueValuesEnum(_messages.Enum):
    r"""Required. The license model of the DbSystem.

    Values:
      LICENSE_MODEL_UNSPECIFIED: The license model is unspecified.
      LICENSE_INCLUDED: The license model is included.
      BRING_YOUR_OWN_LICENSE: The license model is bring your own license.
    """
    LICENSE_MODEL_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the DbSystem.

    Values:
      DB_SYSTEM_LIFECYCLE_STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      UPDATING: Indicates that the resource is in updating state.
      TERMINATING: Indicates that the resource is in terminating state.
      TERMINATED: Indicates that the resource is in terminated state.
      FAILED: Indicates that the resource is in failed state.
      MIGRATED: Indicates that the resource has been migrated.
      MAINTENANCE_IN_PROGRESS: Indicates that the resource is in maintenance
        in progress state.
      NEEDS_ATTENTION: Indicates that the resource needs attention.
      UPGRADING: Indicates that the resource is upgrading.
    """
    DB_SYSTEM_LIFECYCLE_STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6
    MIGRATED = 7
    MAINTENANCE_IN_PROGRESS = 8
    NEEDS_ATTENTION = 9
    UPGRADING = 10

  computeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  computeModel = _messages.EnumField('ComputeModelValueValuesEnum', 2)
  dataCollectionOptions = _messages.MessageField('DataCollectionOptionsDbSystem', 3)
  dataStorageSizeGb = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  databaseEdition = _messages.EnumField('DatabaseEditionValueValuesEnum', 5)
  dbHome = _messages.MessageField('DbHome', 6)
  dbSystemOptions = _messages.MessageField('DbSystemOptions', 7)
  domain = _messages.StringField(8)
  hostname = _messages.StringField(9)
  hostnamePrefix = _messages.StringField(10)
  initialDataStorageSizeGb = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  licenseModel = _messages.EnumField('LicenseModelValueValuesEnum', 12)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 13)
  memorySizeGb = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  nodeCount = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  ocid = _messages.StringField(16)
  privateIp = _messages.StringField(17)
  recoStorageSizeGb = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  shape = _messages.StringField(19)
  sshPublicKeys = _messages.StringField(20, repeated=True)
  timeZone = _messages.MessageField('TimeZone', 21)


class DbSystemShape(_messages.Message):
  r"""Details of the Database System Shapes resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbSystemShapeSummary/

  Fields:
    availableCoreCountPerNode: Optional. Number of cores per node.
    availableDataStorageTb: Optional. Storage per storage server in terabytes.
    availableMemoryPerNodeGb: Optional. Memory per database server node in
      gigabytes.
    maxNodeCount: Optional. Maximum number of database servers.
    maxStorageCount: Optional. Maximum number of storage servers.
    minCoreCountPerNode: Optional. Minimum core count per node.
    minDbNodeStoragePerNodeGb: Optional. Minimum node storage per database
      server in gigabytes.
    minMemoryPerNodeGb: Optional. Minimum memory per node in gigabytes.
    minNodeCount: Optional. Minimum number of database servers.
    minStorageCount: Optional. Minimum number of storage servers.
    name: Identifier. The name of the Database System Shape resource with the
      format:
      projects/{project}/locations/{region}/dbSystemShapes/{db_system_shape}
    shape: Optional. shape
  """

  availableCoreCountPerNode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  availableDataStorageTb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  availableMemoryPerNodeGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  maxNodeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxStorageCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  minCoreCountPerNode = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  minDbNodeStoragePerNodeGb = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  minMemoryPerNodeGb = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  minStorageCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  name = _messages.StringField(11)
  shape = _messages.StringField(12)


class DbVersion(_messages.Message):
  r"""A valid Oracle Database version.

  Fields:
    name: Output only. The name of the DbVersion resource in the following
      format: projects/{project}/locations/{region}/dbVersions/{db_version}
    properties: Output only. The properties of the DbVersion.
  """

  name = _messages.StringField(1)
  properties = _messages.MessageField('DbVersionProperties', 2)


class DbVersionProperties(_messages.Message):
  r"""The properties of a DbVersion.

  Fields:
    isLatestForMajorVersion: Output only. True if this version of the Oracle
      Database software is the latest version for a release.
    isPreviewDbVersion: Output only. True if this version of the Oracle
      Database software is the preview version.
    isUpgradeSupported: Output only. True if this version of the Oracle
      Database software is supported for Upgrade.
    supportsPdb: Output only. True if this version of the Oracle Database
      software supports pluggable databases.
    version: Output only. A valid Oracle Database version.
  """

  isLatestForMajorVersion = _messages.BooleanField(1)
  isPreviewDbVersion = _messages.BooleanField(2)
  isUpgradeSupported = _messages.BooleanField(3)
  supportsPdb = _messages.BooleanField(4)
  version = _messages.StringField(5)


class DefinedTagValue(_messages.Message):
  r"""Wrapper message for the value of a defined tag.

  Messages:
    TagsValue: The tags within the namespace.

  Fields:
    tags: The tags within the namespace.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TagsValue(_messages.Message):
    r"""The tags within the namespace.

    Messages:
      AdditionalProperty: An additional property for a TagsValue object.

    Fields:
      additionalProperties: Additional properties of type TagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  tags = _messages.MessageField('TagsValue', 1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EncryptionKey(_messages.Message):
  r"""The encryption key used to encrypt the Autonomous Database.

  Enums:
    ProviderValueValuesEnum: Optional. The provider of the encryption key.

  Fields:
    kmsKey: Optional. The KMS key used to encrypt the Autonomous Database.
      This field is required if the provider is GOOGLE_MANAGED. The name of
      the KMS key resource in the following format: `projects/{project}/locati
      ons/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
    provider: Optional. The provider of the encryption key.
  """

  class ProviderValueValuesEnum(_messages.Enum):
    r"""Optional. The provider of the encryption key.

    Values:
      PROVIDER_UNSPECIFIED: Default unspecified value.
      GOOGLE_MANAGED: Google Managed KMS key, if selected, please provide the
        KMS key name.
      ORACLE_MANAGED: Oracle Managed.
    """
    PROVIDER_UNSPECIFIED = 0
    GOOGLE_MANAGED = 1
    ORACLE_MANAGED = 2

  kmsKey = _messages.StringField(1)
  provider = _messages.EnumField('ProviderValueValuesEnum', 2)


class EncryptionKeyHistoryEntry(_messages.Message):
  r"""The history of the encryption keys used to encrypt the Autonomous
  Database.

  Fields:
    activationTime: Output only. The date and time when the encryption key was
      activated on the Autonomous Database..
    encryptionKey: Output only. The encryption key used to encrypt the
      Autonomous Database.
  """

  activationTime = _messages.StringField(1)
  encryptionKey = _messages.MessageField('EncryptionKey', 2)


class Entitlement(_messages.Message):
  r"""Details of the Entitlement resource.

  Enums:
    StateValueValuesEnum: Output only. Entitlement State.

  Fields:
    cloudAccountDetails: Details of the OCI Cloud Account.
    entitlementId: Output only. Google Cloud Marketplace order ID (aka
      entitlement ID)
    name: Identifier. The name of the Entitlement resource with the format:
      projects/{project}/locations/{region}/entitlements/{entitlement}
    state: Output only. Entitlement State.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Entitlement State.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      ACCOUNT_NOT_LINKED: Account not linked.
      ACCOUNT_NOT_ACTIVE: Account is linked but not active.
      ACTIVE: Entitlement and Account are active.
      ACCOUNT_SUSPENDED: Account is suspended.
      NOT_APPROVED_IN_PRIVATE_MARKETPLACE: Entitlement is not approved in
        private marketplace.
    """
    STATE_UNSPECIFIED = 0
    ACCOUNT_NOT_LINKED = 1
    ACCOUNT_NOT_ACTIVE = 2
    ACTIVE = 3
    ACCOUNT_SUSPENDED = 4
    NOT_APPROVED_IN_PRIVATE_MARKETPLACE = 5

  cloudAccountDetails = _messages.MessageField('CloudAccountDetails', 1)
  entitlementId = _messages.StringField(2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class ExadbVmCluster(_messages.Message):
  r"""ExadbVmCluster represents a cluster of VMs that are used to run Exadata
  workloads. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/ExadbVmCluster/

  Messages:
    LabelsValue: Optional. The labels or tags associated with the
      ExadbVmCluster.

  Fields:
    backupOdbSubnet: Required. Immutable. The name of the backup OdbSubnet
      associated with the ExadbVmCluster. Format: projects/{project}/locations
      /{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
    createTime: Output only. The date and time that the ExadbVmCluster was
      created.
    displayName: Required. Immutable. The display name for the ExadbVmCluster.
      The name does not have to be unique within your project. The name must
      be 1-255 characters long and can only contain alphanumeric characters.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the ExadbVmCluster.
    gcpOracleZone: Output only. Immutable. The GCP Oracle zone where Oracle
      ExadbVmCluster is hosted. Example: us-east4-b-r2. During creation, the
      system will pick the zone assigned to the ExascaleDbStorageVault.
    labels: Optional. The labels or tags associated with the ExadbVmCluster.
    name: Identifier. The name of the ExadbVmCluster resource in the following
      format:
      projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
    odbNetwork: Optional. Immutable. The name of the OdbNetwork associated
      with the ExadbVmCluster. Format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
      optional but if specified, this should match the parent ODBNetwork of
      the OdbSubnet.
    odbSubnet: Required. Immutable. The name of the OdbSubnet associated with
      the ExadbVmCluster for IP allocation. Format: projects/{project}/locatio
      ns/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
    properties: Required. The properties of the ExadbVmCluster.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the ExadbVmCluster.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupOdbSubnet = _messages.StringField(1)
  createTime = _messages.StringField(2)
  displayName = _messages.StringField(3)
  entitlementId = _messages.StringField(4)
  gcpOracleZone = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  odbNetwork = _messages.StringField(8)
  odbSubnet = _messages.StringField(9)
  properties = _messages.MessageField('ExadbVmClusterProperties', 10)


class ExadbVmClusterProperties(_messages.Message):
  r"""The properties of an ExadbVmCluster.

  Enums:
    LicenseModelValueValuesEnum: Optional. Immutable. The license type of the
      ExadbVmCluster.
    LifecycleStateValueValuesEnum: Output only. State of the cluster.
    ShapeAttributeValueValuesEnum: Required. Immutable. The shape attribute of
      the VM cluster. The type of Exascale storage used for Exadata VM
      cluster. The default is SMART_STORAGE which supports Oracle Database
      23ai and later

  Fields:
    additionalEcpuCountPerNode: Optional. Immutable. The number of additional
      ECPUs per node for an Exadata VM cluster on exascale infrastructure.
    clusterName: Optional. Immutable. The cluster name for Exascale vm
      cluster. The cluster name must begin with an alphabetic character and
      may contain hyphens(-) but can not contain underscores(_). It should be
      not more than 11 characters and is not case sensitive. OCI Cluster name.
    dataCollectionOptions: Optional. Immutable. Indicates user preference for
      data collection options.
    enabledEcpuCountPerNode: Required. Immutable. The number of ECPUs enabled
      per node for an exadata vm cluster on exascale infrastructure.
    exascaleDbStorageVault: Required. Immutable. The name of
      ExascaleDbStorageVault associated with the ExadbVmCluster. It can refer
      to an existing ExascaleDbStorageVault. Or a new one can be created
      during the ExadbVmCluster creation (requires storage_vault_properties to
      be set). Format: projects/{project}/locations/{location}/exascaleDbStora
      geVaults/{exascale_db_storage_vault}
    giVersion: Output only. The Oracle Grid Infrastructure (GI) software
      version.
    gridImageId: Required. Immutable. Grid Infrastructure Version.
    hostname: Output only. The hostname of the ExadbVmCluster.
    hostnamePrefix: Required. Immutable. Prefix for VM cluster host names.
    licenseModel: Optional. Immutable. The license type of the ExadbVmCluster.
    lifecycleState: Output only. State of the cluster.
    memorySizeGb: Output only. Memory per VM (GB) (Read-only): Shows the
      amount of memory allocated to each VM. Memory is calculated based on
      2.75 GB per Total ECPUs.
    nodeCount: Required. The number of nodes/VMs in the ExadbVmCluster.
    ociUri: Output only. Deep link to the OCI console to view this resource.
    scanListenerPortTcp: Optional. Immutable. SCAN listener port - TCP
    shapeAttribute: Required. Immutable. The shape attribute of the VM
      cluster. The type of Exascale storage used for Exadata VM cluster. The
      default is SMART_STORAGE which supports Oracle Database 23ai and later
    sshPublicKeys: Required. Immutable. The SSH public keys for the
      ExadbVmCluster.
    timeZone: Optional. Immutable. The time zone of the ExadbVmCluster.
    vmFileSystemStorage: Required. Immutable. Total storage details for the
      ExadbVmCluster.
  """

  class LicenseModelValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. The license type of the ExadbVmCluster.

    Values:
      LICENSE_MODEL_UNSPECIFIED: Unspecified.
      LICENSE_INCLUDED: Default is license included.
      BRING_YOUR_OWN_LICENSE: Bring your own license.
    """
    LICENSE_MODEL_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the cluster.

    Values:
      EXADB_VM_CLUSTER_LIFECYCLE_STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      UPDATING: Indicates that the resource is in updating state.
      TERMINATING: Indicates that the resource is in terminating state.
      TERMINATED: Indicates that the resource is in terminated state.
      FAILED: Indicates that the resource is in failed state.
      MAINTENANCE_IN_PROGRESS: Indicates that the resource is in maintenance
        in progress state.
    """
    EXADB_VM_CLUSTER_LIFECYCLE_STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6
    MAINTENANCE_IN_PROGRESS = 7

  class ShapeAttributeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The shape attribute of the VM cluster. The type
    of Exascale storage used for Exadata VM cluster. The default is
    SMART_STORAGE which supports Oracle Database 23ai and later

    Values:
      SHAPE_ATTRIBUTE_UNSPECIFIED: Default unspecified value.
      SMART_STORAGE: Indicates that the resource is in smart storage.
      BLOCK_STORAGE: Indicates that the resource is in block storage.
    """
    SHAPE_ATTRIBUTE_UNSPECIFIED = 0
    SMART_STORAGE = 1
    BLOCK_STORAGE = 2

  additionalEcpuCountPerNode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  clusterName = _messages.StringField(2)
  dataCollectionOptions = _messages.MessageField('DataCollectionOptionsCommon', 3)
  enabledEcpuCountPerNode = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  exascaleDbStorageVault = _messages.StringField(5)
  giVersion = _messages.StringField(6)
  gridImageId = _messages.StringField(7)
  hostname = _messages.StringField(8)
  hostnamePrefix = _messages.StringField(9)
  licenseModel = _messages.EnumField('LicenseModelValueValuesEnum', 10)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 11)
  memorySizeGb = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  nodeCount = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  ociUri = _messages.StringField(14)
  scanListenerPortTcp = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  shapeAttribute = _messages.EnumField('ShapeAttributeValueValuesEnum', 16)
  sshPublicKeys = _messages.StringField(17, repeated=True)
  timeZone = _messages.MessageField('TimeZone', 18)
  vmFileSystemStorage = _messages.MessageField('ExadbVmClusterStorageDetails', 19)


class ExadbVmClusterStorageDetails(_messages.Message):
  r"""The storage allocation for the exadbvmcluster, in gigabytes (GB).

  Fields:
    sizeInGbsPerNode: Required. The storage allocation for the exadbvmcluster
      per node, in gigabytes (GB). This field is used to calculate the total
      storage allocation for the exadbvmcluster.
  """

  sizeInGbsPerNode = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ExascaleDbStorageDetails(_messages.Message):
  r"""The storage details of the ExascaleDbStorageVault.

  Fields:
    availableSizeGbs: Output only. The available storage capacity for the
      ExascaleDbStorageVault, in gigabytes (GB).
    totalSizeGbs: Required. The total storage allocation for the
      ExascaleDbStorageVault, in gigabytes (GB).
  """

  availableSizeGbs = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  totalSizeGbs = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ExascaleDbStorageVault(_messages.Message):
  r"""ExascaleDbStorageVault represents a storage vault exadb vm cluster
  resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/ExascaleDbStorageVault/

  Messages:
    LabelsValue: Optional. The labels or tags associated with the
      ExascaleDbStorageVault.

  Fields:
    createTime: Output only. The date and time when the ExascaleDbStorageVault
      was created.
    displayName: Required. The display name for the ExascaleDbStorageVault.
      The name does not have to be unique within your project. The name must
      be 1-255 characters long and can only contain alphanumeric characters.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the ExascaleDbStorageVault.
    exadataInfrastructure: Optional. The Exadata Infrastructure resource on
      which ExascaleDbStorageVault resource is created, in the following
      format: projects/{project}/locations/{region}/cloudExadataInfrastuctures
      /{cloud_extradata_infrastructure}
    gcpOracleZone: Optional. The GCP Oracle zone where Oracle
      ExascaleDbStorageVault is hosted. Example: us-east4-b-r2. If not
      specified, the system will pick a zone based on availability.
    labels: Optional. The labels or tags associated with the
      ExascaleDbStorageVault.
    name: Identifier. The resource name of the ExascaleDbStorageVault. Format:
      projects/{project}/locations/{location}/exascaleDbStorageVaults/{exascal
      e_db_storage_vault}
    properties: Required. The properties of the ExascaleDbStorageVault.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the
    ExascaleDbStorageVault.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entitlementId = _messages.StringField(3)
  exadataInfrastructure = _messages.StringField(4)
  gcpOracleZone = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  properties = _messages.MessageField('ExascaleDbStorageVaultProperties', 8)


class ExascaleDbStorageVaultProperties(_messages.Message):
  r"""The properties of the ExascaleDbStorageVault. next ID: 12

  Enums:
    AttachedShapeAttributesValueListEntryValuesEnum:
    AvailableShapeAttributesValueListEntryValuesEnum:
    StateValueValuesEnum: Output only. The state of the
      ExascaleDbStorageVault.

  Fields:
    additionalFlashCachePercent: Optional. The size of additional flash cache
      in percentage of high capacity database storage.
    attachedShapeAttributes: Output only. The shape attributes of the VM
      clusters attached to the ExascaleDbStorageVault.
    availableShapeAttributes: Output only. The shape attributes available for
      the VM clusters to be attached to the ExascaleDbStorageVault.
    description: Optional. The description of the ExascaleDbStorageVault.
    exascaleDbStorageDetails: Required. The storage details of the
      ExascaleDbStorageVault.
    ociUri: Output only. Deep link to the OCI console to view this resource.
    ocid: Output only. The OCID for the ExascaleDbStorageVault.
    state: Output only. The state of the ExascaleDbStorageVault.
    timeZone: Output only. The time zone of the ExascaleDbStorageVault.
    vmClusterCount: Output only. The number of VM clusters associated with the
      ExascaleDbStorageVault.
    vmClusterIds: Output only. The list of VM cluster OCIDs associated with
      the ExascaleDbStorageVault.
  """

  class AttachedShapeAttributesValueListEntryValuesEnum(_messages.Enum):
    r"""AttachedShapeAttributesValueListEntryValuesEnum enum type.

    Values:
      SHAPE_ATTRIBUTE_UNSPECIFIED: Default unspecified value.
      SMART_STORAGE: Indicates that the resource is in smart storage.
      BLOCK_STORAGE: Indicates that the resource is in block storage.
    """
    SHAPE_ATTRIBUTE_UNSPECIFIED = 0
    SMART_STORAGE = 1
    BLOCK_STORAGE = 2

  class AvailableShapeAttributesValueListEntryValuesEnum(_messages.Enum):
    r"""AvailableShapeAttributesValueListEntryValuesEnum enum type.

    Values:
      SHAPE_ATTRIBUTE_UNSPECIFIED: Default unspecified value.
      SMART_STORAGE: Indicates that the resource is in smart storage.
      BLOCK_STORAGE: Indicates that the resource is in block storage.
    """
    SHAPE_ATTRIBUTE_UNSPECIFIED = 0
    SMART_STORAGE = 1
    BLOCK_STORAGE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the ExascaleDbStorageVault.

    Values:
      STATE_UNSPECIFIED: The state of the ExascaleDbStorageVault is
        unspecified.
      PROVISIONING: The ExascaleDbStorageVault is being provisioned.
      AVAILABLE: The ExascaleDbStorageVault is available.
      UPDATING: The ExascaleDbStorageVault is being updated.
      TERMINATING: The ExascaleDbStorageVault is being deleted.
      TERMINATED: The ExascaleDbStorageVault has been deleted.
      FAILED: The ExascaleDbStorageVault has failed.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6

  additionalFlashCachePercent = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  attachedShapeAttributes = _messages.EnumField('AttachedShapeAttributesValueListEntryValuesEnum', 2, repeated=True)
  availableShapeAttributes = _messages.EnumField('AvailableShapeAttributesValueListEntryValuesEnum', 3, repeated=True)
  description = _messages.StringField(4)
  exascaleDbStorageDetails = _messages.MessageField('ExascaleDbStorageDetails', 5)
  ociUri = _messages.StringField(6)
  ocid = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  timeZone = _messages.MessageField('TimeZone', 9)
  vmClusterCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  vmClusterIds = _messages.StringField(11, repeated=True)


class FailoverAutonomousDatabaseRequest(_messages.Message):
  r"""The request for `OracleDatabase.FailoverAutonomousDatabase`.

  Fields:
    peerAutonomousDatabase: Optional. The peer database name to fail over to.
      Required for cross-region standby, and must be omitted for in-region
      Data Guard.
  """

  peerAutonomousDatabase = _messages.StringField(1)


class GenerateAutonomousDatabaseWalletRequest(_messages.Message):
  r"""The request for `AutonomousDatabase.GenerateWallet`.

  Enums:
    TypeValueValuesEnum: Optional. The type of wallet generation for the
      Autonomous Database. The default value is SINGLE.

  Fields:
    isRegional: Optional. True when requesting regional connection strings in
      PDB connect info, applicable to cross-region Data Guard only.
    password: Required. The password used to encrypt the keys inside the
      wallet. The password must be a minimum of 8 characters.
    type: Optional. The type of wallet generation for the Autonomous Database.
      The default value is SINGLE.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of wallet generation for the Autonomous Database.
    The default value is SINGLE.

    Values:
      GENERATE_TYPE_UNSPECIFIED: Default unspecified value.
      ALL: Used to generate wallet for all databases in the region.
      SINGLE: Used to generate wallet for a single database.
    """
    GENERATE_TYPE_UNSPECIFIED = 0
    ALL = 1
    SINGLE = 2

  isRegional = _messages.BooleanField(1)
  password = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class GenerateAutonomousDatabaseWalletResponse(_messages.Message):
  r"""The response for `AutonomousDatabase.GenerateWallet`.

  Fields:
    archiveContent: Output only. The base64 encoded wallet files.
  """

  archiveContent = _messages.BytesField(1)


class GiVersion(_messages.Message):
  r"""Details of the Oracle Grid Infrastructure (GI) version resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/GiVersionSummary/

  Fields:
    name: Identifier. The name of the Oracle Grid Infrastructure (GI) version
      resource with the format:
      projects/{project}/locations/{region}/giVersions/{gi_versions}
    version: Optional. version
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class GoldenGateAmazonKinesisConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateAmazonKinesisConnection.

  Fields:
    accessKeyId: Optional. Access key ID to access the Amazon Kinesis.
    awsRegion: Optional. The name of the AWS region. If not provided,
      GoldenGate will default to 'us-west-1'.
    endpoint: Optional. The endpoint URL of the Amazon Kinesis service. e.g.:
      'https://kinesis.us-east-1.amazonaws.com' If not provided, GoldenGate
      will default to 'https://kinesis..amazonaws.com'.
    secretAccessKeySecret: Optional. Secret access key to access the Amazon
      Kinesis.
    technologyType: Optional. The technology type of AmazonKinesisConnection.
  """

  accessKeyId = _messages.StringField(1)
  awsRegion = _messages.StringField(2)
  endpoint = _messages.StringField(3)
  secretAccessKeySecret = _messages.StringField(4)
  technologyType = _messages.StringField(5)


class GoldenGateAmazonRedshiftConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateAmazonRedshiftConnection.

  Fields:
    connectionUrl: Optional. Connection URL. e.g.: 'jdbc:redshift://aws-
      redshift-instance.aaaaaaaaaaaa.us-
      east-2.redshift.amazonaws.com:5439/mydb'
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology.
    technologyType: Optional. The technology type of AmazonRedshiftConnection.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  connectionUrl = _messages.StringField(1)
  passwordSecret = _messages.StringField(2)
  technologyType = _messages.StringField(3)
  username = _messages.StringField(4)


class GoldenGateAmazonS3ConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateAmazonS3Connection.

  Fields:
    accessKeyId: Optional. Access key ID to access the Amazon S3 bucket.
    endpoint: Optional. The Amazon Endpoint for S3.
    region: Optional. The name of the AWS region where the bucket is created.
    secretAccessKeySecret: Optional. Secret access key to access the Amazon S3
      bucket.
    technologyType: Optional. The technology type of AmazonS3Connection.
  """

  accessKeyId = _messages.StringField(1)
  endpoint = _messages.StringField(2)
  region = _messages.StringField(3)
  secretAccessKeySecret = _messages.StringField(4)
  technologyType = _messages.StringField(5)


class GoldenGateAzureDataLakeStorageConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateAzureDataLakeStorageConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Authentication mechanism to
      access Azure Data Lake Storage.

  Fields:
    account: Optional. Sets the Azure storage account name.
    accountKeySecret: Optional. Azure storage account key. This property is
      required when 'authentication_type' is set to 'SHARED_KEY'.
    authenticationType: Optional. Authentication mechanism to access Azure
      Data Lake Storage.
    azureAuthorityHost: Optional. The endpoint used for authentication with
      Microsoft Entra ID (formerly Azure Active Directory). Default value:
      https://login.microsoftonline.com
    azureTenantId: Optional. Azure tenant ID of the application. This property
      is required when 'authentication_type' is set to
      'AZURE_ACTIVE_DIRECTORY'.
    clientId: Optional. Azure client ID of the application. This property is
      required when 'authentication_type' is set to 'AZURE_ACTIVE_DIRECTORY'.
    clientSecret: Optional. Azure client secret (aka application password) for
      authentication.
    endpoint: Optional. Azure Storage service endpoint. e.g:
      https://test.blob.core.windows.net
    sasTokenSecret: Optional. Credential that uses a shared access signature
      (SAS) to authenticate to an Azure Service.
    technologyType: Optional. The technology type of
      AzureDataLakeStorageConnection.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Authentication mechanism to access Azure Data Lake Storage.

    Values:
      AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not specified.
      SHARED_KEY: Shared key authentication.
      SHARED_ACCESS_SIGNATURE: Shared access signature authentication.
      AZURE_ACTIVE_DIRECTORY: Azure active directory authentication.
    """
    AUTHENTICATION_TYPE_UNSPECIFIED = 0
    SHARED_KEY = 1
    SHARED_ACCESS_SIGNATURE = 2
    AZURE_ACTIVE_DIRECTORY = 3

  account = _messages.StringField(1)
  accountKeySecret = _messages.StringField(2)
  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 3)
  azureAuthorityHost = _messages.StringField(4)
  azureTenantId = _messages.StringField(5)
  clientId = _messages.StringField(6)
  clientSecret = _messages.StringField(7)
  endpoint = _messages.StringField(8)
  sasTokenSecret = _messages.StringField(9)
  technologyType = _messages.StringField(10)


class GoldenGateAzureSynapseAnalyticsConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateAzureSynapseAnalyticsConnection.

  Fields:
    connectionString: Optional. JDBC connection string. e.g.: 'jdbc:sqlserver:
      //.sql.azuresynapse.net:1433;database=;encrypt=true;trustServerCertifica
      te=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;'
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology.
    technologyType: Optional. The technology type of
      AzureSynapseAnalyticsConnection.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  connectionString = _messages.StringField(1)
  passwordSecret = _messages.StringField(2)
  technologyType = _messages.StringField(3)
  username = _messages.StringField(4)


class GoldenGateConnection(_messages.Message):
  r"""Details of the GoldenGateConnection resource.

  Messages:
    LabelsValue: Optional. The labels or tags associated with the
      GoldenGateConnection.

  Fields:
    createTime: Output only. The date and time that the GoldenGateConnection
      was created.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the GoldenGateConnection.
    gcpOracleZone: Optional. The GCP Oracle zone where Oracle
      GoldenGateConnection is hosted. Example: us-east4-b-r2. If not
      specified, the system will pick a zone based on availability.
    labels: Optional. The labels or tags associated with the
      GoldenGateConnection.
    name: Identifier. The name of the GoldenGateConnection resource in the
      following format: projects/{project}/locations/{region}/goldenGateConnec
      tions/{golden_gate_connection}
    ociUrl: Output only. HTTPS link to OCI resources exposed to Customer via
      UI Interface.
    odbNetwork: Optional. The name of the OdbNetwork associated with the
      GoldenGateConnection. The format is
      projects/{project}/locations/{location}/odbNetworks/{odb_network}. It is
      optional but if specified, this should match the parent ODBNetwork of
      the OdbSubnet.
    odbSubnet: Optional. The name of the OdbSubnet associated with the
      GoldenGateConnection for IP allocation. Format: projects/{project}/locat
      ions/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
    properties: Required. The properties of the GoldenGateConnection.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the GoldenGateConnection.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  entitlementId = _messages.StringField(2)
  gcpOracleZone = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  ociUrl = _messages.StringField(6)
  odbNetwork = _messages.StringField(7)
  odbSubnet = _messages.StringField(8)
  properties = _messages.MessageField('GoldenGateConnectionProperties', 9)


class GoldenGateConnectionAssignment(_messages.Message):
  r"""Represents the metadata of a GoldenGate Connection Assignment.

  Messages:
    LabelsValue: Optional. The labels or tags associated with the
      GoldenGateConnectionAssignment.

  Fields:
    createTime: Output only. The time when the connection assignment was
      created.
    displayName: Optional. The display name for the
      GoldenGateConnectionAssignment.
    entitlementId: Output only. The OCID of the entitlement linked to this
      resource.
    labels: Optional. The labels or tags associated with the
      GoldenGateConnectionAssignment.
    name: Identifier. The name of the GoldenGateConnectionAssignment resource
      in the following format: projects/{project}/locations/{region}/goldenGat
      eConnectionAssignments/{golden_gate_connection_assignment}
    properties: Required. The properties of the
      GoldenGateConnectionAssignment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the
    GoldenGateConnectionAssignment.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entitlementId = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  properties = _messages.MessageField('GoldenGateConnectionAssignmentProperties', 6)


class GoldenGateConnectionAssignmentProperties(_messages.Message):
  r"""The properties of a GoldenGateConnectionAssignment.

  Enums:
    StateValueValuesEnum: Output only. The lifecycle state of the connection
      assignment.

  Fields:
    alias: Output only. Credential store alias.
    goldenGateConnection: Required. The GoldenGateConnection resource to be
      assigned. Format: projects/{project}/locations/{location}/goldenGateConn
      ections/{golden_gate_connection}
    goldenGateDeployment: Required. The GoldenGateDeployment to assign the
      connection to. Format: projects/{project}/locations/{location}/goldenGat
      eDeployments/{golden_gate_deployment}
    ocid: Output only. The [OCID](https://docs.cloud.oracle.com/Content/Genera
      l/Concepts/identifiers.htm) of the connection assignment being
      referenced.
    state: Output only. The lifecycle state of the connection assignment.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The lifecycle state of the connection assignment.

    Values:
      STATE_UNSPECIFIED: Lifecycle state is unspecified.
      CREATING: Connection assignment is being created.
      ACTIVE: Connection assignment is active.
      FAILED: Connection assignment failed.
      UPDATING: Connection assignment is being updated.
      DELETING: Connection assignment is being deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    FAILED = 3
    UPDATING = 4
    DELETING = 5

  alias = _messages.StringField(1)
  goldenGateConnection = _messages.StringField(2)
  goldenGateDeployment = _messages.StringField(3)
  ocid = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoldenGateConnectionProperties(_messages.Message):
  r"""The properties of a GoldenGateConnection.

  Enums:
    LifecycleStateValueValuesEnum: Output only. The lifecycle state of the
      connection.
    RoutingMethodValueValuesEnum: Optional. The routing method for the
      GoldenGateConnection.

  Fields:
    amazonKinesisConnectionProperties: Properties for an Amazon Kinesis
      connection.
    amazonRedshiftConnectionProperties: Properties for an Amazon Redshift
      connection.
    amazonS3ConnectionProperties: Properties for an Amazon S3 connection.
    azureDataLakeStorageConnectionProperties: Properties for an Azure Data
      Lake Storage Connection.
    azureSynapseAnalyticsConnectionProperties: Properties for an Azure Synapse
      Analytics connection.
    connectionType: Required. The connection type.
    databricksConnectionProperties: Properties for a Databricks connection.
    db2ConnectionProperties: Properties for a DB2 connection.
    description: Optional. Metadata about this specific object.
    displayName: Required. An object's Display Name.
    elasticsearchConnectionProperties: Properties for an Elasticsearch
      connection.
    genericConnectionProperties: Properties for a Generic Connection.
    goldenGateConnectionProperties: Properties for a GoldenGate Connection.
    googleBigQueryConnectionProperties: Properties for a Google BigQuery
      Connection.
    googleCloudStorageConnectionProperties: Properties for a Google Cloud
      Storage Connection.
    googlePubsubConnectionProperties: Properties for a Google Pub/Sub
      connection.
    hdfsConnectionProperties: Properties for an HDFS connection.
    javaMessageServiceConnectionProperties: Properties for a Java Message
      Service connection.
    kafkaConnectionProperties: Properties for a Kafka Connection.
    kafkaSchemaRegistryConnectionProperties: Properties for a Kafka Schema
      Registry Connection.
    lifecycleDetails: Output only. Describes the object's current state in
      detail. For example, it can be used to provide actionable information
      for a resource in a Failed state.
    lifecycleState: Output only. The lifecycle state of the connection.
    microsoftFabricConnectionProperties: Properties for a Microsoft Fabric
      connection.
    microsoftSqlserverConnectionProperties: Properties for a Microsoft SQL
      Server connection.
    mongodbConnectionProperties: Properties for a MongoDB connection.
    mysqlConnectionProperties: Properties for a Mysql Connection.
    ociObjectStorageConnectionProperties: Properties for an OCI Object Storage
      Connection.
    ocid: Output only. The [OCID] of the connection being referenced.
    oracleAiDataPlatformConnectionProperties: Properties for an Oracle AI Data
      Platform connection.
    oracleConnectionProperties: Properties for an Oracle Database Connection.
    oracleNosqlConnectionProperties: Properties for an Oracle NoSQL
      connection.
    postgresqlConnectionProperties: Properties for a PostgreSQL connection.
    redisConnectionProperties: Properties for a Redis connection.
    routingMethod: Optional. The routing method for the GoldenGateConnection.
    snowflakeConnectionProperties: Properties for a Snowflake connection.
    updateTime: Output only. The time the resource was last updated.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. The lifecycle state of the connection.

    Values:
      GOLDEN_GATE_CONNECTION_LIFECYCLE_STATE_UNSPECIFIED: Default unspecified
        value.
      CREATING: Indicates that the resource is in provisioning state.
      ACTIVE: Indicates that the resource is in active state.
      UPDATING: Indicates that the resource is in updating state.
      DELETING: Indicates that the resource is in deleting state.
      DELETED: Indicates that the resource is in deleted state.
      FAILED: Indicates that the resource is in failed state.
    """
    GOLDEN_GATE_CONNECTION_LIFECYCLE_STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    UPDATING = 3
    DELETING = 4
    DELETED = 5
    FAILED = 6

  class RoutingMethodValueValuesEnum(_messages.Enum):
    r"""Optional. The routing method for the GoldenGateConnection.

    Values:
      GOLDEN_GATE_CONNECTION_ROUTING_METHOD_UNSPECIFIED: Default unspecified
        value.
      SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned
        deployment's private endpoint through the deployment's subnet.
      DEDICATED_ENDPOINT: A dedicated private endpoint is created in the
        target VCN subnet for the connection.
    """
    GOLDEN_GATE_CONNECTION_ROUTING_METHOD_UNSPECIFIED = 0
    SHARED_DEPLOYMENT_ENDPOINT = 1
    DEDICATED_ENDPOINT = 2

  amazonKinesisConnectionProperties = _messages.MessageField('GoldenGateAmazonKinesisConnectionProperties', 1)
  amazonRedshiftConnectionProperties = _messages.MessageField('GoldenGateAmazonRedshiftConnectionProperties', 2)
  amazonS3ConnectionProperties = _messages.MessageField('GoldenGateAmazonS3ConnectionProperties', 3)
  azureDataLakeStorageConnectionProperties = _messages.MessageField('GoldenGateAzureDataLakeStorageConnectionProperties', 4)
  azureSynapseAnalyticsConnectionProperties = _messages.MessageField('GoldenGateAzureSynapseAnalyticsConnectionProperties', 5)
  connectionType = _messages.StringField(6)
  databricksConnectionProperties = _messages.MessageField('GoldenGateDatabricksConnectionProperties', 7)
  db2ConnectionProperties = _messages.MessageField('GoldenGateDb2ConnectionProperties', 8)
  description = _messages.StringField(9)
  displayName = _messages.StringField(10)
  elasticsearchConnectionProperties = _messages.MessageField('GoldenGateElasticsearchConnectionProperties', 11)
  genericConnectionProperties = _messages.MessageField('GoldenGateGenericConnectionProperties', 12)
  goldenGateConnectionProperties = _messages.MessageField('GoldenGateGoldenGateConnectionProperties', 13)
  googleBigQueryConnectionProperties = _messages.MessageField('GoldenGateGoogleBigQueryConnectionProperties', 14)
  googleCloudStorageConnectionProperties = _messages.MessageField('GoldenGateGoogleCloudStorageConnectionProperties', 15)
  googlePubsubConnectionProperties = _messages.MessageField('GoldenGateGooglePubsubConnectionProperties', 16)
  hdfsConnectionProperties = _messages.MessageField('GoldenGateHdfsConnectionProperties', 17)
  javaMessageServiceConnectionProperties = _messages.MessageField('GoldenGateJavaMessageServiceConnectionProperties', 18)
  kafkaConnectionProperties = _messages.MessageField('GoldenGateKafkaConnectionProperties', 19)
  kafkaSchemaRegistryConnectionProperties = _messages.MessageField('GoldenGateKafkaSchemaRegistryConnectionProperties', 20)
  lifecycleDetails = _messages.StringField(21)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 22)
  microsoftFabricConnectionProperties = _messages.MessageField('GoldenGateMicrosoftFabricConnectionProperties', 23)
  microsoftSqlserverConnectionProperties = _messages.MessageField('GoldenGateMicrosoftSqlserverConnectionProperties', 24)
  mongodbConnectionProperties = _messages.MessageField('GoldenGateMongodbConnectionProperties', 25)
  mysqlConnectionProperties = _messages.MessageField('GoldenGateMysqlConnectionProperties', 26)
  ociObjectStorageConnectionProperties = _messages.MessageField('GoldenGateOciObjectStorageConnectionProperties', 27)
  ocid = _messages.StringField(28)
  oracleAiDataPlatformConnectionProperties = _messages.MessageField('GoldenGateOracleAIDataPlatformConnectionProperties', 29)
  oracleConnectionProperties = _messages.MessageField('GoldenGateOracleConnectionProperties', 30)
  oracleNosqlConnectionProperties = _messages.MessageField('GoldenGateOracleNosqlConnectionProperties', 31)
  postgresqlConnectionProperties = _messages.MessageField('GoldenGatePostgresqlConnectionProperties', 32)
  redisConnectionProperties = _messages.MessageField('GoldenGateRedisConnectionProperties', 33)
  routingMethod = _messages.EnumField('RoutingMethodValueValuesEnum', 34)
  snowflakeConnectionProperties = _messages.MessageField('GoldenGateSnowflakeConnectionProperties', 35)
  updateTime = _messages.StringField(36)


class GoldenGateDatabricksConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateDatabricksConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Authentication type for
      Databricks.

  Fields:
    authenticationType: Optional. Authentication type for Databricks.
    clientId: Optional. OAuth client id, only applicable for
      authentication_type == OAUTH_M2M
    clientSecret: Optional. OAuth client secret, only applicable for
      authentication_type == OAUTH_M2M
    connectionUrl: Optional. Connection URL. e.g.: 'jdbc:databricks://adb-
      33934.4.azuredatabricks.net:443/default;transportMode=http;ssl=1;httpPat
      h=sql/protocolv1/o/3393########44/0##3-7-hlrb'
    passwordSecret: Optional. The password used to connect to Databricks. Only
      applicable for authentication_type == PERSONAL_ACCESS_TOKEN.
    storageCredential: Optional. External storage credential name to access
      files on object storage such as ADLS Gen2, S3 or Cloud Storage.
    technologyType: Optional. The technology type of DatabricksConnection.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Authentication type for Databricks.

    Values:
      DATABRICKS_AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not
        specified.
      PERSONAL_ACCESS_TOKEN: Personal access token authentication.
      OAUTH_M2M: OAuth M2M authentication.
    """
    DATABRICKS_AUTHENTICATION_TYPE_UNSPECIFIED = 0
    PERSONAL_ACCESS_TOKEN = 1
    OAUTH_M2M = 2

  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 1)
  clientId = _messages.StringField(2)
  clientSecret = _messages.StringField(3)
  connectionUrl = _messages.StringField(4)
  passwordSecret = _messages.StringField(5)
  storageCredential = _messages.StringField(6)
  technologyType = _messages.StringField(7)


class GoldenGateDb2ConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateDb2Connection.

  Enums:
    SecurityProtocolValueValuesEnum: Optional. Security protocol for the DB2
      database.

  Fields:
    additionalAttributes: Optional. An array of name-value pair attribute
      entries. Used as additional parameters in connection string.
    database: Optional. The name of the database.
    host: Optional. The name or address of a host.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      to the associated DB2 database.
    port: Optional. The port of an endpoint usually specified for a
      connection.
    securityProtocol: Optional. Security protocol for the DB2 database.
    sslClientKeystashFile: Optional. The keystash file which contains the
      encrypted password to the key database file. Not supported for IBM Db2
      for i.
    sslClientKeystoredbFile: Optional. The keystore file created at the client
      containing the server certificate / CA root certificate. Not supported
      for IBM Db2 for i.
    sslServerCertificateFile: Optional. The file which contains the self-
      signed server certificate / Certificate Authority (CA) certificate.
    technologyType: Optional. The technology type of Db2Connection.
    username: Optional. The username Oracle GoldenGate uses to connect to the
      DB2 database.
  """

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security protocol for the DB2 database.

    Values:
      DB2_SECURITY_PROTOCOL_UNSPECIFIED: Security protocol not specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
    """
    DB2_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2

  additionalAttributes = _messages.MessageField('NameValuePair', 1, repeated=True)
  database = _messages.StringField(2)
  host = _messages.StringField(3)
  passwordSecret = _messages.StringField(4)
  port = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 6)
  sslClientKeystashFile = _messages.BytesField(7)
  sslClientKeystoredbFile = _messages.BytesField(8)
  sslServerCertificateFile = _messages.BytesField(9)
  technologyType = _messages.StringField(10)
  username = _messages.StringField(11)


class GoldenGateDeployment(_messages.Message):
  r"""GoldenGateDeployment GoldenGate Deployment resource model.

  Messages:
    LabelsValue: Optional. The labels or tags associated with the
      GoldenGateDeployment.

  Fields:
    createTime: Output only. The date and time that the GoldenGateDeployment
      was created.
    displayName: Required. The display name for the GoldenGateDeployment.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the GoldenGateDeployment
    gcpOracleZone: Optional. The GCP Oracle zone where Oracle
      GoldenGateDeployment is hosted. Example: us-east4-b-r2. If not
      specified, the system will pick a zone based on availability.
    labels: Optional. The labels or tags associated with the
      GoldenGateDeployment.
    name: Identifier. The name of the GoldenGateDeployment resource in the
      following format: projects/{project}/locations/{region}/goldenGateDeploy
      ments/{golden_gate_deployment}
    ociUrl: Output only. HTTPS link to OCI resources exposed to Customer via
      UI Interface.
    odbNetwork: Optional. The name of the OdbNetwork associated with the
      GoldenGateDeployment.
    odbSubnet: Required. The name of the OdbSubnet associated with the
      GoldenGateDeployment for IP allocation.
    properties: Required. The properties of the GoldenGateDeployment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels or tags associated with the GoldenGateDeployment.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  entitlementId = _messages.StringField(3)
  gcpOracleZone = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  ociUrl = _messages.StringField(7)
  odbNetwork = _messages.StringField(8)
  odbSubnet = _messages.StringField(9)
  properties = _messages.MessageField('GoldenGateDeploymentProperties', 10)


class GoldenGateDeploymentProperties(_messages.Message):
  r"""Properties of GoldenGateDeployment.

  Enums:
    LicenseModelValueValuesEnum: Optional. The Oracle license model that
      applies to a Deployment.
    LifecycleStateValueValuesEnum: Output only. State of the
      GoldenGateDeployment.

  Fields:
    cpuCoreCount: Required. The Minimum number of OCPUs to be made available
      for this Deployment.
    deploymentType: Required. A valid Oracle GoldenGate version. For a list of
      supported versions, use the ListGoldenGateDeployments operation.
    description: Optional. The description of the GoldenGateDeployment.
    environmentType: Optional. The environment type of the
      GoldenGateDeployment.
    fqdn: Output only. The Fully Qualified Domain Name of the
      GoldenGateDeployment.
    isAutoScalingEnabled: Optional. Indicates if auto scaling is enabled for
      the Deployment's CPU core count.
    licenseModel: Optional. The Oracle license model that applies to a
      Deployment.
    lifecycleState: Output only. State of the GoldenGateDeployment.
    maintenanceConfig: Optional. The maintenance configuration of the
      GoldenGateDeployment.
    maintenanceWindow: Optional. The maintenance window of the
      GoldenGateDeployment.
    ocid: Output only. OCID of the GoldenGateDeployment.
    oggData: Required. The ogg data of the GoldenGateDeployment.
  """

  class LicenseModelValueValuesEnum(_messages.Enum):
    r"""Optional. The Oracle license model that applies to a Deployment.

    Values:
      LICENSE_MODEL_UNSPECIFIED: The license model is unspecified.
      LICENSE_INCLUDED: The license model is included.
      BRING_YOUR_OWN_LICENSE: The license model is bring your own license.
    """
    LICENSE_MODEL_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the GoldenGateDeployment.

    Values:
      GOLDEN_GATE_DEPLOYMENT_LIFECYCLE_STATE_UNSPECIFIED: Default unspecified
        value.
      CREATING: The deployment is being created.
      UPDATING: The deployment is being updated.
      ACTIVE: The deployment is active.
      INACTIVE: The deployment is inactive.
      DELETING: The deployment is being deleted.
      DELETED: The deployment is deleted.
      FAILED: The deployment failed.
      NEEDS_ATTENTION: The deployment needs attention.
      IN_PROGRESS: The deployment is in progress.
      CANCELLING: The deployment is canceling.
      CANCELLED: The deployment is canceled.
      SUCCEEDED: The deployment succeeded.
      WAITING: The deployment is waiting.
    """
    GOLDEN_GATE_DEPLOYMENT_LIFECYCLE_STATE_UNSPECIFIED = 0
    CREATING = 1
    UPDATING = 2
    ACTIVE = 3
    INACTIVE = 4
    DELETING = 5
    DELETED = 6
    FAILED = 7
    NEEDS_ATTENTION = 8
    IN_PROGRESS = 9
    CANCELLING = 10
    CANCELLED = 11
    SUCCEEDED = 12
    WAITING = 13

  cpuCoreCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  deploymentType = _messages.StringField(2)
  description = _messages.StringField(3)
  environmentType = _messages.StringField(4)
  fqdn = _messages.StringField(5)
  isAutoScalingEnabled = _messages.BooleanField(6)
  licenseModel = _messages.EnumField('LicenseModelValueValuesEnum', 7)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 8)
  maintenanceConfig = _messages.MessageField('GoldenGateMaintenanceConfig', 9)
  maintenanceWindow = _messages.MessageField('GoldenGateMaintenanceWindow', 10)
  ocid = _messages.StringField(11)
  oggData = _messages.MessageField('GoldenGateOggDeployment', 12)


class GoldenGateElasticsearchConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateElasticsearchConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Authentication type for
      Elasticsearch.
    SecurityProtocolValueValuesEnum: Optional. Security protocol for
      Elasticsearch.

  Fields:
    authenticationType: Optional. Authentication type for Elasticsearch.
    fingerprint: Optional. Fingerprint required by TLS security protocol. Eg.:
      '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology.
    securityProtocol: Optional. Security protocol for Elasticsearch.
    servers: Optional. Comma separated list of Elasticsearch server addresses,
      specified as host:port entries, where :port is optional. If port is not
      specified, it defaults to 9200. Example:
      "server1.example.com:4000,server2.example.com:4000"
    technologyType: Optional. The technology type of ElasticsearchConnection.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Authentication type for Elasticsearch.

    Values:
      ELASTICSEARCH_AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not
        specified.
      NONE: No authentication.
      BASIC: Basic authentication.
    """
    ELASTICSEARCH_AUTHENTICATION_TYPE_UNSPECIFIED = 0
    NONE = 1
    BASIC = 2

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security protocol for Elasticsearch.

    Values:
      ELASTICSEARCH_SECURITY_PROTOCOL_UNSPECIFIED: Security protocol not
        specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
    """
    ELASTICSEARCH_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2

  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 1)
  fingerprint = _messages.StringField(2)
  passwordSecret = _messages.StringField(3)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 4)
  servers = _messages.StringField(5)
  technologyType = _messages.StringField(6)
  username = _messages.StringField(7)


class GoldenGateGenericConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateGenericConnectionProperties.

  Fields:
    host: Optional. The host of the GenericConnection.
    technologyType: Optional. The technology type.
  """

  host = _messages.StringField(1)
  technologyType = _messages.StringField(2)


class GoldenGateGoldenGateConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateGoldenGateConnectionProperties.

  Fields:
    goldenGateDeploymentId: Optional. The name of the GoldenGateDeployment
      associated with the GoldenGateConnection. Format: projects/{project}/loc
      ations/{location}/goldenGateDeployments/{golden_gate_deployment}
    host: Optional. The host of the GoldenGateConnection.
    passwordSecret: Optional. The password used to connect to the Oracle
      GoldenGate accessed through this connection.
    port: Optional. The port of the GoldenGateConnection.
    technologyType: Optional. The technology type.
    username: Optional. The username credential.
  """

  goldenGateDeploymentId = _messages.StringField(1)
  host = _messages.StringField(2)
  passwordSecret = _messages.StringField(3)
  port = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  technologyType = _messages.StringField(5)
  username = _messages.StringField(6)


class GoldenGateGoogleBigQueryConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateGoogleBigQueryConnectionProperties.

  Fields:
    serviceAccountKeyFile: Optional. The service account key file Cloud
      Storage containing the credentials required to use Google BigQuery.
    technologyType: Optional. The technology type.
  """

  serviceAccountKeyFile = _messages.BytesField(1)
  technologyType = _messages.StringField(2)


class GoldenGateGoogleCloudStorageConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateGoogleCloudStorageConnectionProperties.

  Fields:
    serviceAccountKeyFile: Optional. The service account key Cloud Storage
      file containing the credentials required to use Google Cloud Storage.
    technologyType: Optional. The technology type.
  """

  serviceAccountKeyFile = _messages.BytesField(1)
  technologyType = _messages.StringField(2)


class GoldenGateGooglePubsubConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateGooglePubsubConnection.

  Fields:
    serviceAccountKeyFile: Optional. The content of the service account key
      file containing the credentials required to use Google Pub/Sub.
    technologyType: Optional. The technology type of GooglePubsubConnection.
  """

  serviceAccountKeyFile = _messages.BytesField(1)
  technologyType = _messages.StringField(2)


class GoldenGateHdfsConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateHdfsConnection.

  Fields:
    coreSiteXml: Optional. The content of the Hadoop Distributed File System
      configuration file (core-site.xml).
    technologyType: Optional. The technology type of HdfsConnection.
  """

  coreSiteXml = _messages.BytesField(1)
  technologyType = _messages.StringField(2)


class GoldenGateJavaMessageServiceConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateJavaMessageServiceConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Authentication type for Java
      Message Service.
    SecurityProtocolValueValuesEnum: Optional. Security protocol for Java
      Message Service.

  Fields:
    authenticationType: Optional. Authentication type for Java Message
      Service.
    connectionFactory: Optional. The Java class implementing
      javax.jms.ConnectionFactory interface supplied by the JMS provider.
    connectionUrl: Optional. Connection URL of the Java Message Service,
      specifying the protocol, host, and port. e.g.:
      'mq://myjms.host.domain:7676'
    jndiConnectionFactory: Optional. The Connection Factory can be looked up
      using this name. e.g.: 'ConnectionFactory'
    jndiInitialContextFactory: Optional. The implementation of
      javax.naming.spi.InitialContextFactory interface used to obtain initial
      naming context.
    jndiProviderUrl: Optional. The URL that Java Message Service will use to
      contact the JNDI provider. e.g.:
      'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
    jndiSecurityCredentialsSecret: Optional. The password associated to the
      principal.
    jndiSecurityPrincipal: Optional. Specifies the identity of the principal
      (user) to be authenticated.
    keyStoreFile: Optional. The content of the KeyStore file.
    keyStorePasswordSecret: Optional. The KeyStore password.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated Java Message Service.
    securityProtocol: Optional. Security protocol for Java Message Service.
    sslKeyPasswordSecret: Optional. The password for the cert inside of the
      KeyStore. In case it differs from the KeyStore password, it should be
      provided.
    technologyType: Optional. The technology type of
      JavaMessageServiceConnection.
    trustStoreFile: Optional. The content of the TrustStore file.
    trustStorePasswordSecret: Optional. The TrustStore password.
    useJndi: Optional. If set to true, Java Naming and Directory Interface
      (JNDI) properties should be provided.
    username: Optional. The username Oracle GoldenGate uses to connect to the
      Java Message Service.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Authentication type for Java Message Service.

    Values:
      JMS_AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not specified.
      NONE: No authentication.
      BASIC: Basic authentication.
    """
    JMS_AUTHENTICATION_TYPE_UNSPECIFIED = 0
    NONE = 1
    BASIC = 2

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security protocol for Java Message Service.

    Values:
      JMS_SECURITY_PROTOCOL_UNSPECIFIED: Security protocol not specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
      MTLS: Mutual Transport Layer Security.
    """
    JMS_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2
    MTLS = 3

  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 1)
  connectionFactory = _messages.StringField(2)
  connectionUrl = _messages.StringField(3)
  jndiConnectionFactory = _messages.StringField(4)
  jndiInitialContextFactory = _messages.StringField(5)
  jndiProviderUrl = _messages.StringField(6)
  jndiSecurityCredentialsSecret = _messages.StringField(7)
  jndiSecurityPrincipal = _messages.StringField(8)
  keyStoreFile = _messages.BytesField(9)
  keyStorePasswordSecret = _messages.StringField(10)
  passwordSecret = _messages.StringField(11)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 12)
  sslKeyPasswordSecret = _messages.StringField(13)
  technologyType = _messages.StringField(14)
  trustStoreFile = _messages.BytesField(15)
  trustStorePasswordSecret = _messages.StringField(16)
  useJndi = _messages.BooleanField(17)
  username = _messages.StringField(18)


class GoldenGateKafkaConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateKafkaConnection.

  Enums:
    SecurityProtocolValueValuesEnum: Optional. Security Type for Kafka.

  Fields:
    bootstrapServers: Optional. Kafka bootstrap. Equivalent of
      bootstrap.servers configuration property in Kafka: list of
      KafkaBootstrapServer objects specified by host/port. Used for
      establishing the initial connection to the Kafka cluster. Example:
      "server1.example.com:9092,server2.example.com:9092"
    clusterId: Optional. The OCID of the Kafka cluster being referenced from
      OCI Streaming with Apache Kafka.
    consumerPropertiesFile: Optional. The content of the consumer.properties
      file.
    keyStoreFile: Optional. The content of the KeyStore file.
    keyStorePasswordSecret: Optional. The KeyStore password.
    passwordSecret: Optional. The password for Kafka basic/SASL auth.
    producerPropertiesFile: Optional. The content of the producer.properties
      file.
    securityProtocol: Optional. Security Type for Kafka.
    sslKeyPasswordSecret: Optional. The password for the cert inside of the
      KeyStore. In case it differs from the KeyStore password, it should be
      provided.
    streamPoolId: Optional. The OCID of the stream pool being referenced.
    technologyType: Optional. The technology type of KafkaConnection.
    trustStoreFile: Optional. The content of the TrustStore file.
    trustStorePasswordSecret: Optional. The TrustStore password.
    useResourcePrincipal: Optional. Specifies that the user intends to
      authenticate to the instance using a resource principal. Applicable only
      for OCI Streaming connections.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security Type for Kafka.

    Values:
      KAFKA_SECURITY_PROTOCOL_UNSPECIFIED: Security type not specified.
      SSL: SSL security protocol.
      SASL_SSL: SASL SSL security protocol.
      PLAINTEXT: Plaintext security protocol.
      SASL_PLAINTEXT: SASL Plaintext security protocol.
    """
    KAFKA_SECURITY_PROTOCOL_UNSPECIFIED = 0
    SSL = 1
    SASL_SSL = 2
    PLAINTEXT = 3
    SASL_PLAINTEXT = 4

  bootstrapServers = _messages.MessageField('KafkaBootstrapServer', 1, repeated=True)
  clusterId = _messages.StringField(2)
  consumerPropertiesFile = _messages.BytesField(3)
  keyStoreFile = _messages.BytesField(4)
  keyStorePasswordSecret = _messages.StringField(5)
  passwordSecret = _messages.StringField(6)
  producerPropertiesFile = _messages.BytesField(7)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 8)
  sslKeyPasswordSecret = _messages.StringField(9)
  streamPoolId = _messages.StringField(10)
  technologyType = _messages.StringField(11)
  trustStoreFile = _messages.BytesField(12)
  trustStorePasswordSecret = _messages.StringField(13)
  useResourcePrincipal = _messages.BooleanField(14)
  username = _messages.StringField(15)


class GoldenGateKafkaSchemaRegistryConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateKafkaSchemaRegistryConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Used authentication mechanism
      to access Schema Registry.

  Fields:
    authenticationType: Optional. Used authentication mechanism to access
      Schema Registry.
    keyStoreFile: Optional. The content of the KeyStore file.
    keyStorePasswordSecret: Optional. The KeyStore password.
    passwordSecret: Optional. The password to access Schema Registry using
      basic authentication.
    sslKeyPasswordSecret: Optional. The password for the cert inside the
      KeyStore.
    technologyType: Optional. The technology type of
      KafkaSchemaRegistryConnection.
    trustStoreFile: Optional. The content of the TrustStore file.
    trustStorePasswordSecret: Optional. The TrustStore password.
    url: Optional. Kafka Schema Registry URL. e.g.:
      'https://server1.us.oracle.com:8081'
    username: Optional. The username to access Schema Registry using basic
      authentication. This value is injected into
      'schema.registry.basic.auth.user.info=user:password' configuration
      property.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Used authentication mechanism to access Schema Registry.

    Values:
      AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not specified.
      NONE: No authentication.
      BASIC: Basic authentication.
      MUTUAL: Mutual authentication.
    """
    AUTHENTICATION_TYPE_UNSPECIFIED = 0
    NONE = 1
    BASIC = 2
    MUTUAL = 3

  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 1)
  keyStoreFile = _messages.BytesField(2)
  keyStorePasswordSecret = _messages.StringField(3)
  passwordSecret = _messages.StringField(4)
  sslKeyPasswordSecret = _messages.StringField(5)
  technologyType = _messages.StringField(6)
  trustStoreFile = _messages.BytesField(7)
  trustStorePasswordSecret = _messages.StringField(8)
  url = _messages.StringField(9)
  username = _messages.StringField(10)


class GoldenGateMaintenanceConfig(_messages.Message):
  r"""The maintenance configuration of the GoldenGateDeployment.

  Fields:
    bundleReleaseUpgradePeriodDays: Optional. Defines auto upgrade period for
      bundle releases. Manually configured period cannot be longer than
      service defined period for bundle releases. This period must be shorter
      or equal to major release upgrade period. Not passing this field during
      create will equate to using the service default.
    interimReleaseUpgradePeriodDays: Optional. Defines auto upgrade period for
      interim releases. This period must be shorter or equal to bundle release
      upgrade period.
    isInterimReleaseAutoUpgradeEnabled: Optional. By default auto upgrade for
      interim releases are not enabled. If auto-upgrade is enabled for interim
      release, you have to specify interim_release_upgrade_period_days too.
    majorReleaseUpgradePeriodDays: Optional. Defines auto upgrade period for
      major releases. Manually configured period cannot be longer than service
      defined period for major releases. Not passing this field during create
      will equate to using the service default.
    securityPatchUpgradePeriodDays: Optional. Defines auto upgrade period for
      releases with security fix. Manually configured period cannot be longer
      than service defined period for security releases. Not passing this
      field during create will equate to using the service default.
  """

  bundleReleaseUpgradePeriodDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  interimReleaseUpgradePeriodDays = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  isInterimReleaseAutoUpgradeEnabled = _messages.BooleanField(3)
  majorReleaseUpgradePeriodDays = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  securityPatchUpgradePeriodDays = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoldenGateMaintenanceWindow(_messages.Message):
  r"""The maintenance window of the GoldenGateDeployment.

  Fields:
    day: Required. Days of the week.
    startHour: Required. Start hour for maintenance period. Hour is in UTC.
  """

  day = _messages.StringField(1)
  startHour = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoldenGateMicrosoftFabricConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateMicrosoftFabricConnection.

  Fields:
    clientId: Optional. Azure client ID of the application.
    clientSecret: Optional. Client secret associated with the client id.
    endpoint: Optional. Optional Microsoft Fabric service endpoint. Default
      value: https://onelake.dfs.fabric.microsoft.com
    technologyType: Optional. The technology type of
      MicrosoftFabricConnection.
    tenantId: Optional. Azure tenant ID of the application.
  """

  clientId = _messages.StringField(1)
  clientSecret = _messages.StringField(2)
  endpoint = _messages.StringField(3)
  technologyType = _messages.StringField(4)
  tenantId = _messages.StringField(5)


class GoldenGateMicrosoftSqlserverConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateMicrosoftSqlserverConnection.

  Enums:
    SecurityProtocolValueValuesEnum: Optional. Security Type for Microsoft SQL
      Server.

  Fields:
    additionalAttributes: Optional. An array of name-value pair attribute
      entries. Used as additional parameters in connection string.
    database: Optional. The name of the database.
    host: Optional. The name or address of a host.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated Microsoft SQL Server.
    port: Optional. The port of an endpoint usually specified for a
      connection.
    securityProtocol: Optional. Security Type for Microsoft SQL Server.
    serverCertificateValidationRequired: Optional. If set to true, the driver
      validates the certificate that is sent by the database server.
    sslCaFile: Optional. Database Certificate - The content of a .pem or .crt
      file containing the server public key (for 1-way SSL).
    technologyType: Optional. The technology type of
      MicrosoftSqlserverConnection.
    username: Optional. The username Oracle GoldenGate uses to connect to the
      Microsoft SQL Server.
  """

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security Type for Microsoft SQL Server.

    Values:
      MICROSOFT_SQLSERVER_SECURITY_PROTOCOL_UNSPECIFIED: Security type not
        specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
    """
    MICROSOFT_SQLSERVER_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2

  additionalAttributes = _messages.MessageField('NameValuePair', 1, repeated=True)
  database = _messages.StringField(2)
  host = _messages.StringField(3)
  passwordSecret = _messages.StringField(4)
  port = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 6)
  serverCertificateValidationRequired = _messages.BooleanField(7)
  sslCaFile = _messages.BytesField(8)
  technologyType = _messages.StringField(9)
  username = _messages.StringField(10)


class GoldenGateMongodbConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateMongodbConnection.

  Enums:
    SecurityProtocolValueValuesEnum: Optional. Security Type for MongoDB.

  Fields:
    connectionString: Optional. MongoDB connection string. e.g.:
      'mongodb://mongodb0.example.com:27017/recordsrecords'
    databaseId: Optional. The OCID of the Oracle Autonomous Json Database.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated database.
    securityProtocol: Optional. Security Type for MongoDB.
    technologyType: Optional. The technology type of MongodbConnection.
    tlsCaFile: Optional. Database Certificate - The content of a .pem file,
      containing the server public key (for 1 and 2-way SSL).
    tlsCertificateKeyFile: Optional. Client Certificate - The content of a
      .pem file, containing the client public key (for 2-way SSL).
    tlsCertificateKeyFilePasswordSecret: Optional. Client Certificate key file
      password.
    username: Optional. The username Oracle GoldenGate uses to connect to the
      database.
  """

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security Type for MongoDB.

    Values:
      MONGODB_SECURITY_PROTOCOL_UNSPECIFIED: Security type not specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
      MTLS: Mutual Transport Layer Security.
    """
    MONGODB_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2
    MTLS = 3

  connectionString = _messages.StringField(1)
  databaseId = _messages.StringField(2)
  passwordSecret = _messages.StringField(3)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 4)
  technologyType = _messages.StringField(5)
  tlsCaFile = _messages.BytesField(6)
  tlsCertificateKeyFile = _messages.BytesField(7)
  tlsCertificateKeyFilePasswordSecret = _messages.StringField(8)
  username = _messages.StringField(9)


class GoldenGateMysqlConnectionProperties(_messages.Message):
  r"""Properties of GoldenGateMysqlConnection.

  Enums:
    SecurityProtocolValueValuesEnum: Optional. Security Type for MySQL.
    SslModeValueValuesEnum: Optional. SSL modes for MySQL.

  Fields:
    additionalAttributes: Optional. An array of name-value pair attribute
      entries. Used as additional parameters in connection string.
    database: Optional. The name of the database.
    dbSystemId: Optional. The OCID of the database system being referenced.
    host: Optional. The name or address of a host.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology. It must conform to the
      specific security requirements including length, case sensitivity, and
      so on.
    port: Optional. The port of an endpoint usually specified for a
      connection.
    securityProtocol: Optional. Security Type for MySQL.
    sslCaFile: Optional. Database Certificate - The content of a .pem or .crt
      file containing the server public key (for 1 and 2-way SSL).
    sslCertFile: Optional. Client Certificate - The content of a .pem or .crt
      file containing the client public key (for 2-way SSL).
    sslCrlFile: Optional. The list of certificates revoked by the trusted
      certificate authorities (Trusted CA).
    sslKeyFile: Optional. Client Key - The content of a .pem or .crt file
      containing the client private key (for 2-way SSL).
    sslMode: Optional. SSL modes for MySQL.
    technologyType: Optional. The technology type of MysqlConnection.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security Type for MySQL.

    Values:
      MYSQL_SECURITY_PROTOCOL_UNSPECIFIED: Security type not specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
      MTLS: Mutual Transport Layer Security.
    """
    MYSQL_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2
    MTLS = 3

  class SslModeValueValuesEnum(_messages.Enum):
    r"""Optional. SSL modes for MySQL.

    Values:
      SSL_MODE_UNSPECIFIED: SSL mode not specified.
      DISABLED: SSL is disabled.
      PREFERRED: SSL is preferred.
      REQUIRED: SSL is required.
      VERIFY_CA: SSL is required and certificate is verified.
      VERIFY_IDENTITY: SSL is required and certificate and hostname are
        verified.
    """
    SSL_MODE_UNSPECIFIED = 0
    DISABLED = 1
    PREFERRED = 2
    REQUIRED = 3
    VERIFY_CA = 4
    VERIFY_IDENTITY = 5

  additionalAttributes = _messages.MessageField('NameValuePair', 1, repeated=True)
  database = _messages.StringField(2)
  dbSystemId = _messages.StringField(3)
  host = _messages.StringField(4)
  passwordSecret = _messages.StringField(5)
  port = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 7)
  sslCaFile = _messages.BytesField(8)
  sslCertFile = _messages.BytesField(9)
  sslCrlFile = _messages.BytesField(10)
  sslKeyFile = _messages.BytesField(11)
  sslMode = _messages.EnumField('SslModeValueValuesEnum', 12)
  technologyType = _messages.StringField(13)
  username = _messages.StringField(14)


class GoldenGateOciObjectStorageConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateOciObjectStorageConnection.

  Fields:
    privateKeyFile: Optional. The content of the private key file (PEM file)
      corresponding to the API key of the fingerprint.
    privateKeyPassphraseSecret: Optional. The passphrase of the private key.
    publicKeyFingerprint: Optional. The fingerprint of the API Key of the user
      specified by the userId.
    region: Optional. The name of the region of OCI Object Storage. e.g.: us-
      ashburn-1 If the region is not provided, backend will default to the
      default region.
    technologyType: Optional. The technology type of
      OciObjectStorageConnection.
    tenancyId: Optional. The OCID of the related OCI tenancy.
    useResourcePrincipal: Optional. Specifies that the user intends to
      authenticate to the instance using a resource principal.
    userId: Optional. The OCID of the OCI user who will access the Object
      Storage. The user must have write access to the bucket they want to
      connect to.
  """

  privateKeyFile = _messages.BytesField(1)
  privateKeyPassphraseSecret = _messages.StringField(2)
  publicKeyFingerprint = _messages.StringField(3)
  region = _messages.StringField(4)
  technologyType = _messages.StringField(5)
  tenancyId = _messages.StringField(6)
  useResourcePrincipal = _messages.BooleanField(7)
  userId = _messages.StringField(8)


class GoldenGateOggDeployment(_messages.Message):
  r"""The Ogg data of the GoldenGateDeployment.

  Fields:
    adminPassword: Optional. The GoldenGate deployment console password.
    adminUsername: Optional. The GoldenGate deployment console username.
    deployment: Required. The name given to the GoldenGate service deployment.
      The name must be 1 to 32 characters long, must contain only alphanumeric
      characters and must start with a letter.
    oggVersion: Optional. Version of OGG
  """

  adminPassword = _messages.StringField(1)
  adminUsername = _messages.StringField(2)
  deployment = _messages.StringField(3)
  oggVersion = _messages.StringField(4)


class GoldenGateOracleAIDataPlatformConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateOracleAIDataPlatformConnection.

  Fields:
    connectionUrl: Optional. Connection URL. It must start with
      'jdbc:spark://'
    privateKeyFile: Optional. The content of the private key file (PEM file)
      corresponding to the API key of the fingerprint.
    privateKeyPassphraseSecret: Optional. The passphrase of the private key.
    publicKeyFingerprint: Optional. The fingerprint of the API Key of the user
      specified by the user_id.
    region: Optional. The name of the region. e.g.: us-ashburn-1
    technologyType: Optional. The technology type of
      OracleAiDataPlatformConnection.
    tenancyId: Optional. The OCID of the related OCI tenancy.
    useResourcePrincipal: Optional. Specifies that the user intends to
      authenticate to the instance using a resource principal.
    userId: Optional. The OCID of the OCI user who will access.
  """

  connectionUrl = _messages.StringField(1)
  privateKeyFile = _messages.BytesField(2)
  privateKeyPassphraseSecret = _messages.StringField(3)
  publicKeyFingerprint = _messages.StringField(4)
  region = _messages.StringField(5)
  technologyType = _messages.StringField(6)
  tenancyId = _messages.StringField(7)
  useResourcePrincipal = _messages.BooleanField(8)
  userId = _messages.StringField(9)


class GoldenGateOracleConnectionProperties(_messages.Message):
  r"""The properties of GoldenGate Oracle Database Connection.

  Enums:
    SessionModeValueValuesEnum: Optional. The mode of the database connection
      session to be established by the data client.

  Fields:
    authenticationMode: Optional. Authentication mode.
    connectionString: Optional. Connect descriptor or Easy Connect Naming
      method used to connect to a database.
    gcpOracleDatabaseId: Optional. database instance id of database in Oracle
      Database @ Google Cloud. If gcp_oracle_database_id is provided,
      connection_string must be empty.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology. It must conform to the
      specific security requirements including length, case sensitivity, and
      so on.
    sessionMode: Optional. The mode of the database connection session to be
      established by the data client.
    technologyType: Optional. The technology type.
    username: Optional. The username Oracle GoldenGate uses to connect.
    walletFile: Optional. The wallet contents Oracle GoldenGate uses to make
      connections to a database.
  """

  class SessionModeValueValuesEnum(_messages.Enum):
    r"""Optional. The mode of the database connection session to be
    established by the data client.

    Values:
      SESSION_MODE_UNSPECIFIED: Default unspecified value.
      DIRECT: Indicates that the resource is using direct session mode.
      REDIRECT: Indicates that the resource is using redirect session mode.
    """
    SESSION_MODE_UNSPECIFIED = 0
    DIRECT = 1
    REDIRECT = 2

  authenticationMode = _messages.StringField(1)
  connectionString = _messages.StringField(2)
  gcpOracleDatabaseId = _messages.StringField(3)
  passwordSecret = _messages.StringField(4)
  sessionMode = _messages.EnumField('SessionModeValueValuesEnum', 5)
  technologyType = _messages.StringField(6)
  username = _messages.StringField(7)
  walletFile = _messages.BytesField(8)


class GoldenGateOracleNosqlConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateOracleNosqlConnection.

  Fields:
    privateKeyFile: Optional. The content of the private key file (PEM file)
      corresponding to the API key of the fingerprint.
    privateKeyPassphraseSecret: Optional. The passphrase of the private key.
    publicKeyFingerprint: Optional. The fingerprint of the API Key of the user
      specified by the userId.
    region: Optional. The name of the region. e.g.: us-ashburn-1
    technologyType: Optional. The technology type of OracleNosqlConnection.
    tenancyId: Optional. The OCID of the OCI tenancy.
    useResourcePrincipal: Optional. Specifies that the user intends to
      authenticate to the instance using a resource principal.
    userId: Optional. The OCID of the OCI user who will access the Oracle
      NoSQL database.
  """

  privateKeyFile = _messages.BytesField(1)
  privateKeyPassphraseSecret = _messages.StringField(2)
  publicKeyFingerprint = _messages.StringField(3)
  region = _messages.StringField(4)
  technologyType = _messages.StringField(5)
  tenancyId = _messages.StringField(6)
  useResourcePrincipal = _messages.BooleanField(7)
  userId = _messages.StringField(8)


class GoldenGatePostgresqlConnectionProperties(_messages.Message):
  r"""The properties of GoldenGatePostgresqlConnection.

  Enums:
    SecurityProtocolValueValuesEnum: Optional. Security protocol for
      PostgreSQL.
    SslModeValueValuesEnum: Optional. SSL modes for PostgreSQL.

  Fields:
    additionalAttributes: Optional. An array of name-value pair attribute
      entries. Used as additional parameters in connection string.
    database: Optional. The name of the database.
    dbSystemId: Optional. The OCID of the database system being referenced.
    host: Optional. The name or address of a host.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology.
    port: Optional. The port of an endpoint usually specified for a
      connection.
    securityProtocol: Optional. Security protocol for PostgreSQL.
    sslCaFile: Optional. The certificate of the trusted certificate
      authorities (Trusted CA) for PostgreSQL.
    sslCertFile: Optional. The certificate of the PostgreSQL server.
    sslCrlFile: Optional. The list of certificates revoked by the trusted
      certificate authorities (Trusted CA).
    sslKeyFile: Optional. The private key of the PostgreSQL server.
    sslMode: Optional. SSL modes for PostgreSQL.
    technologyType: Optional. The technology type of PostgresqlConnection.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security protocol for PostgreSQL.

    Values:
      POSTGRESQL_SECURITY_PROTOCOL_UNSPECIFIED: Security protocol not
        specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
      MTLS: Mutual Transport Layer Security.
    """
    POSTGRESQL_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2
    MTLS = 3

  class SslModeValueValuesEnum(_messages.Enum):
    r"""Optional. SSL modes for PostgreSQL.

    Values:
      POSTGRESQL_SSL_MODE_UNSPECIFIED: SSL mode not specified.
      PREFER: Prefer SSL.
      REQUIRE: Require SSL.
      VERIFY_CA: Verify Certificate Authority.
      VERIFY_FULL: Verify Full.
    """
    POSTGRESQL_SSL_MODE_UNSPECIFIED = 0
    PREFER = 1
    REQUIRE = 2
    VERIFY_CA = 3
    VERIFY_FULL = 4

  additionalAttributes = _messages.MessageField('NameValuePair', 1, repeated=True)
  database = _messages.StringField(2)
  dbSystemId = _messages.StringField(3)
  host = _messages.StringField(4)
  passwordSecret = _messages.StringField(5)
  port = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 7)
  sslCaFile = _messages.BytesField(8)
  sslCertFile = _messages.BytesField(9)
  sslCrlFile = _messages.BytesField(10)
  sslKeyFile = _messages.BytesField(11)
  sslMode = _messages.EnumField('SslModeValueValuesEnum', 12)
  technologyType = _messages.StringField(13)
  username = _messages.StringField(14)


class GoldenGateRedisConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateRedisConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Authentication type for
      Redis.
    SecurityProtocolValueValuesEnum: Optional. Security protocol for Redis.

  Fields:
    authenticationType: Optional. Authentication type for Redis.
    keyStoreFile: Optional. The content of the KeyStore file.
    keyStorePasswordSecret: Optional. The KeyStore password.
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      the associated system of the given technology.
    redisClusterId: Optional. The OCID of the Redis cluster.
    securityProtocol: Optional. Security protocol for Redis.
    servers: Optional. Comma separated list of Redis server addresses,
      specified as host:port entries, where :port is optional. If port is not
      specified, it defaults to 6379. Example:
      "server1.example.com:6379,server2.example.com:6379"
    technologyType: Optional. The technology type of RedisConnection.
    trustStoreFile: Optional. The content of the TrustStore file.
    trustStorePasswordSecret: Optional. The TrustStore password.
    username: Optional. The username Oracle GoldenGate uses to connect the
      associated system of the given technology.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Authentication type for Redis.

    Values:
      REDIS_AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not
        specified.
      NONE: No authentication.
      BASIC: Basic authentication.
    """
    REDIS_AUTHENTICATION_TYPE_UNSPECIFIED = 0
    NONE = 1
    BASIC = 2

  class SecurityProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Security protocol for Redis.

    Values:
      REDIS_SECURITY_PROTOCOL_UNSPECIFIED: Security protocol not specified.
      PLAIN: Plain text communication.
      TLS: Transport Layer Security.
      MTLS: Mutual Transport Layer Security.
    """
    REDIS_SECURITY_PROTOCOL_UNSPECIFIED = 0
    PLAIN = 1
    TLS = 2
    MTLS = 3

  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 1)
  keyStoreFile = _messages.BytesField(2)
  keyStorePasswordSecret = _messages.StringField(3)
  passwordSecret = _messages.StringField(4)
  redisClusterId = _messages.StringField(5)
  securityProtocol = _messages.EnumField('SecurityProtocolValueValuesEnum', 6)
  servers = _messages.StringField(7)
  technologyType = _messages.StringField(8)
  trustStoreFile = _messages.BytesField(9)
  trustStorePasswordSecret = _messages.StringField(10)
  username = _messages.StringField(11)


class GoldenGateSnowflakeConnectionProperties(_messages.Message):
  r"""The properties of GoldenGateSnowflakeConnection.

  Enums:
    AuthenticationTypeValueValuesEnum: Optional. Used authentication mechanism
      to access Snowflake.

  Fields:
    authenticationType: Optional. Used authentication mechanism to access
      Snowflake.
    connectionUrl: Optional. JDBC connection URL. e.g.:
      'jdbc:snowflake://.snowflakecomputing.com/?warehouse=&db='
    passwordSecret: Optional. The password Oracle GoldenGate uses to connect
      to Snowflake platform.
    privateKeyFile: Optional. The content of private key file in PEM format.
    privateKeyPassphraseSecret: Optional. Password if the private key file is
      encrypted.
    technologyType: Optional. The technology type of SnowflakeConnection.
    username: Optional. The username Oracle GoldenGate uses to connect to
      Snowflake.
  """

  class AuthenticationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Used authentication mechanism to access Snowflake.

    Values:
      AUTHENTICATION_TYPE_UNSPECIFIED: Authentication type not specified.
      BASIC: Basic authentication.
      KEY_PAIR: Key pair authentication.
    """
    AUTHENTICATION_TYPE_UNSPECIFIED = 0
    BASIC = 1
    KEY_PAIR = 2

  authenticationType = _messages.EnumField('AuthenticationTypeValueValuesEnum', 1)
  connectionUrl = _messages.StringField(2)
  passwordSecret = _messages.StringField(3)
  privateKeyFile = _messages.BytesField(4)
  privateKeyPassphraseSecret = _messages.StringField(5)
  technologyType = _messages.StringField(6)
  username = _messages.StringField(7)


class IdentityConnector(_messages.Message):
  r"""The identity connector details which will allow OCI to securely access
  the resources in the customer project.

  Enums:
    ConnectionStateValueValuesEnum: Output only. The connection state of the
      identity connector.

  Fields:
    connectionState: Output only. The connection state of the identity
      connector.
    serviceAgentEmail: Output only. A google managed service account on which
      customers can grant roles to access resources in the customer project.
      Example: `p176944527254-55-75119d87fd8f@gcp-sa-
      oci.iam.gserviceaccount.com`
  """

  class ConnectionStateValueValuesEnum(_messages.Enum):
    r"""Output only. The connection state of the identity connector.

    Values:
      CONNECTION_STATE_UNSPECIFIED: Default unspecified value.
      CONNECTED: The identity pool connection is connected.
      PARTIALLY_CONNECTED: The identity pool connection is partially
        connected.
      DISCONNECTED: The identity pool connection is disconnected.
      UNKNOWN: The identity pool connection is in an unknown state.
    """
    CONNECTION_STATE_UNSPECIFIED = 0
    CONNECTED = 1
    PARTIALLY_CONNECTED = 2
    DISCONNECTED = 3
    UNKNOWN = 4

  connectionState = _messages.EnumField('ConnectionStateValueValuesEnum', 1)
  serviceAgentEmail = _messages.StringField(2)


class KafkaBootstrapServer(_messages.Message):
  r"""Represents a Kafka bootstrap server with host name, optional port
  defaults to 9092, and an optional private ip.

  Fields:
    host: Required. The name or address of a host.
    port: Optional. The port of an endpoint usually specified for a
      connection.
    privateIpAddress: Optional. The private IP address of the connection's
      endpoint in the customer's VCN, typically a database endpoint or a big
      data endpoint (e.g. Kafka bootstrap server). In case the privateIp is
      provided, the subnetId must also be provided. In case the privateIp (and
      the subnetId) is not provided it is assumed the datasource is publicly
      accessible. In case the connection is accessible only privately, the
      lack of privateIp will result in not being able to access the
      connection.
  """

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  privateIpAddress = _messages.StringField(3)


class ListAutonomousDatabaseBackupsResponse(_messages.Message):
  r"""The response for `AutonomousDatabaseBackup.List`.

  Fields:
    autonomousDatabaseBackups: The list of Autonomous Database Backups.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDatabaseBackups = _messages.MessageField('AutonomousDatabaseBackup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAutonomousDatabaseCharacterSetsResponse(_messages.Message):
  r"""The response for `AutonomousDatabaseCharacterSet.List`.

  Fields:
    autonomousDatabaseCharacterSets: The list of Autonomous Database Character
      Sets.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDatabaseCharacterSets = _messages.MessageField('AutonomousDatabaseCharacterSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAutonomousDatabaseRefreshableClonesResponse(_messages.Message):
  r"""Response message for listing the Autonomous Database refreshable clones.

  Fields:
    autonomousDatabaseRefreshableClones: The list of Autonomous Database
      refreshable clones.
    nextPageToken: Optional. A token identifying a page of results the server
      should return.
  """

  autonomousDatabaseRefreshableClones = _messages.MessageField('AutonomousDatabaseRefreshableClone', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAutonomousDatabasesResponse(_messages.Message):
  r"""The response for `AutonomousDatabase.List`.

  Fields:
    autonomousDatabases: The list of Autonomous Databases.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDatabases = _messages.MessageField('AutonomousDatabase', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAutonomousDbVersionsResponse(_messages.Message):
  r"""The response for `AutonomousDbVersion.List`.

  Fields:
    autonomousDbVersions: The list of Autonomous Database versions.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDbVersions = _messages.MessageField('AutonomousDbVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCloudExadataInfrastructuresResponse(_messages.Message):
  r"""The response for `CloudExadataInfrastructures.list`.

  Fields:
    cloudExadataInfrastructures: The list of Exadata Infrastructures.
    nextPageToken: A token for fetching next page of response.
  """

  cloudExadataInfrastructures = _messages.MessageField('CloudExadataInfrastructure', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCloudVmClustersResponse(_messages.Message):
  r"""The response for `CloudVmCluster.List`.

  Fields:
    cloudVmClusters: The list of VM Clusters.
    nextPageToken: A token to fetch the next page of results.
  """

  cloudVmClusters = _messages.MessageField('CloudVmCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDatabaseCharacterSetsResponse(_messages.Message):
  r"""The response for `DatabaseCharacterSet.List`.

  Fields:
    databaseCharacterSets: The list of DatabaseCharacterSets.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  databaseCharacterSets = _messages.MessageField('DatabaseCharacterSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDatabasesResponse(_messages.Message):
  r"""The response for `Database.List`.

  Fields:
    databases: The list of Databases.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  databases = _messages.MessageField('Database', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbNodesResponse(_messages.Message):
  r"""The response for `DbNode.List`.

  Fields:
    dbNodes: The list of DB Nodes
    nextPageToken: A token identifying a page of results the node should
      return.
  """

  dbNodes = _messages.MessageField('DbNode', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbServersResponse(_messages.Message):
  r"""The response for `DbServer.List`.

  Fields:
    dbServers: The list of database servers.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbServers = _messages.MessageField('DbServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbSystemInitialStorageSizesResponse(_messages.Message):
  r"""The response for `DbSystemInitialStorageSizes.List`.

  Fields:
    dbSystemInitialStorageSizes: The list of DbSystemInitialStorageSizes.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbSystemInitialStorageSizes = _messages.MessageField('DbSystemInitialStorageSize', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbSystemShapesResponse(_messages.Message):
  r"""The response for `DbSystemShape.List`.

  Fields:
    dbSystemShapes: The list of Database System shapes.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbSystemShapes = _messages.MessageField('DbSystemShape', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbSystemsResponse(_messages.Message):
  r"""The response for `DbSystem.List`.

  Fields:
    dbSystems: The list of DbSystems.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbSystems = _messages.MessageField('DbSystem', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbVersionsResponse(_messages.Message):
  r"""The response for `DbVersions.List`.

  Fields:
    dbVersions: The list of DbVersions.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbVersions = _messages.MessageField('DbVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEntitlementsResponse(_messages.Message):
  r"""The response for `Entitlement.List`.

  Fields:
    entitlements: The list of Entitlements
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  entitlements = _messages.MessageField('Entitlement', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListExadbVmClustersResponse(_messages.Message):
  r"""The response for `ExadbVmCluster.List`.

  Fields:
    exadbVmClusters: The list of ExadbVmClusters.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  exadbVmClusters = _messages.MessageField('ExadbVmCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListExascaleDbStorageVaultsResponse(_messages.Message):
  r"""The response for `ExascaleDbStorageVault.List`.

  Fields:
    exascaleDbStorageVaults: The ExascaleDbStorageVaults.
    nextPageToken: A token identifying a page of results the server should
      return. If present, the next page token can be provided to a subsequent
      ListExascaleDbStorageVaults call to list the next page. If empty, there
      are no more pages.
  """

  exascaleDbStorageVaults = _messages.MessageField('ExascaleDbStorageVault', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGiVersionsResponse(_messages.Message):
  r"""The response for `GiVersion.List`.

  Fields:
    giVersions: The list of Oracle Grid Infrastructure (GI) versions.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  giVersions = _messages.MessageField('GiVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGoldenGateConnectionAssignmentsResponse(_messages.Message):
  r"""Response message for listing GoldenGateConnectionAssignments.

  Fields:
    goldenGateConnectionAssignments: The list of
      GoldenGateConnectionAssignments.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  goldenGateConnectionAssignments = _messages.MessageField('GoldenGateConnectionAssignment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGoldenGateConnectionsResponse(_messages.Message):
  r"""The response for `GoldenGateConnection.List`.

  Fields:
    goldenGateConnections: The list of GoldenGateConnections.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Optional. Locations that could not be reached.
  """

  goldenGateConnections = _messages.MessageField('GoldenGateConnection', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListGoldenGateDeploymentsResponse(_messages.Message):
  r"""The response for `GoldenGateDeployment.List`.

  Fields:
    goldenGateDeployments: The list of GoldenGateDeployments.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Optional. Locations that could not be reached.
  """

  goldenGateDeployments = _messages.MessageField('GoldenGateDeployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMinorVersionsResponse(_messages.Message):
  r"""The response for `MinorVersion.List`.

  Fields:
    minorVersions: The list of MinorVersions.
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  minorVersions = _messages.MessageField('MinorVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOdbNetworksResponse(_messages.Message):
  r"""The response for `OdbNetwork.List`.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    odbNetworks: The list of ODB Networks.
    unreachable: Unreachable locations when listing resources across all
      locations using wildcard location '-'.
  """

  nextPageToken = _messages.StringField(1)
  odbNetworks = _messages.MessageField('OdbNetwork', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListOdbSubnetsResponse(_messages.Message):
  r"""The response for `OdbSubnet.List`.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    odbSubnets: The list of ODB Subnets.
    unreachable: Unreachable locations when listing resources across all
      locations using wildcard location '-'.
  """

  nextPageToken = _messages.StringField(1)
  odbSubnets = _messages.MessageField('OdbSubnet', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListPluggableDatabasesResponse(_messages.Message):
  r"""The response for `PluggableDatabase.List`.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    pluggableDatabases: The list of PluggableDatabases.
  """

  nextPageToken = _messages.StringField(1)
  pluggableDatabases = _messages.MessageField('PluggableDatabase', 2, repeated=True)


class ListSystemVersionsResponse(_messages.Message):
  r"""The response for `SystemVersion.List`.

  Fields:
    nextPageToken: A token identifying the next page of results to retrieve.
      If empty/omitted, there are no more pages to retrieve.
    systemVersions: The list of System Versions.
  """

  nextPageToken = _messages.StringField(1)
  systemVersions = _messages.MessageField('SystemVersion', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Metadata for a given Location.

  Fields:
    gcpOracleZones: Output only. Google Cloud Platform Oracle zones in a
      location.
    resourceAvailability: Output only. Resource availability for a given
      location.
  """

  gcpOracleZones = _messages.StringField(1, repeated=True)
  resourceAvailability = _messages.MessageField('ResourceAvailability', 2, repeated=True)


class MaintenanceWindow(_messages.Message):
  r"""Maintenance window as defined by Oracle. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/MaintenanceWindow

  Enums:
    DaysOfWeekValueListEntryValuesEnum:
    MonthsValueListEntryValuesEnum:
    PatchingModeValueValuesEnum: Optional. Cloud CloudExadataInfrastructure
      node patching method, either "ROLLING" or "NONROLLING". Default value is
      ROLLING.
    PreferenceValueValuesEnum: Optional. The maintenance window scheduling
      preference.

  Fields:
    customActionTimeoutMins: Optional. Determines the amount of time the
      system will wait before the start of each database server patching
      operation. Custom action timeout is in minutes and valid value is
      between 15 to 120 (inclusive).
    daysOfWeek: Optional. Days during the week when maintenance should be
      performed.
    hoursOfDay: Optional. The window of hours during the day when maintenance
      should be performed. The window is a 4 hour slot. Valid values are: 0 -
      represents time slot 0:00 - 3:59 UTC 4 - represents time slot 4:00 -
      7:59 UTC 8 - represents time slot 8:00 - 11:59 UTC 12 - represents time
      slot 12:00 - 15:59 UTC 16 - represents time slot 16:00 - 19:59 UTC 20 -
      represents time slot 20:00 - 23:59 UTC
    isCustomActionTimeoutEnabled: Optional. If true, enables the configuration
      of a custom action timeout (waiting period) between database server
      patching operations.
    leadTimeWeek: Optional. Lead time window allows user to set a lead time to
      prepare for a down time. The lead time is in weeks and valid value is
      between 1 to 4.
    months: Optional. Months during the year when maintenance should be
      performed.
    patchingMode: Optional. Cloud CloudExadataInfrastructure node patching
      method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
    preference: Optional. The maintenance window scheduling preference.
    weeksOfMonth: Optional. Weeks during the month when maintenance should be
      performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the
      month, and have a duration of 7 days. Weeks start and end based on
      calendar dates, not days of the week.
  """

  class DaysOfWeekValueListEntryValuesEnum(_messages.Enum):
    r"""DaysOfWeekValueListEntryValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class MonthsValueListEntryValuesEnum(_messages.Enum):
    r"""MonthsValueListEntryValuesEnum enum type.

    Values:
      MONTH_UNSPECIFIED: The unspecified month.
      JANUARY: The month of January.
      FEBRUARY: The month of February.
      MARCH: The month of March.
      APRIL: The month of April.
      MAY: The month of May.
      JUNE: The month of June.
      JULY: The month of July.
      AUGUST: The month of August.
      SEPTEMBER: The month of September.
      OCTOBER: The month of October.
      NOVEMBER: The month of November.
      DECEMBER: The month of December.
    """
    MONTH_UNSPECIFIED = 0
    JANUARY = 1
    FEBRUARY = 2
    MARCH = 3
    APRIL = 4
    MAY = 5
    JUNE = 6
    JULY = 7
    AUGUST = 8
    SEPTEMBER = 9
    OCTOBER = 10
    NOVEMBER = 11
    DECEMBER = 12

  class PatchingModeValueValuesEnum(_messages.Enum):
    r"""Optional. Cloud CloudExadataInfrastructure node patching method,
    either "ROLLING" or "NONROLLING". Default value is ROLLING.

    Values:
      PATCHING_MODE_UNSPECIFIED: Default unspecified value.
      ROLLING: Updates the Cloud Exadata database server hosts in a rolling
        fashion.
      NON_ROLLING: The non-rolling maintenance method first updates your
        storage servers at the same time, then your database servers at the
        same time.
    """
    PATCHING_MODE_UNSPECIFIED = 0
    ROLLING = 1
    NON_ROLLING = 2

  class PreferenceValueValuesEnum(_messages.Enum):
    r"""Optional. The maintenance window scheduling preference.

    Values:
      MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED: Default unspecified value.
      CUSTOM_PREFERENCE: Custom preference.
      NO_PREFERENCE: No preference.
    """
    MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED = 0
    CUSTOM_PREFERENCE = 1
    NO_PREFERENCE = 2

  customActionTimeoutMins = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  daysOfWeek = _messages.EnumField('DaysOfWeekValueListEntryValuesEnum', 2, repeated=True)
  hoursOfDay = _messages.IntegerField(3, repeated=True, variant=_messages.Variant.INT32)
  isCustomActionTimeoutEnabled = _messages.BooleanField(4)
  leadTimeWeek = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  months = _messages.EnumField('MonthsValueListEntryValuesEnum', 6, repeated=True)
  patchingMode = _messages.EnumField('PatchingModeValueValuesEnum', 7)
  preference = _messages.EnumField('PreferenceValueValuesEnum', 8)
  weeksOfMonth = _messages.IntegerField(9, repeated=True, variant=_messages.Variant.INT32)


class MinorVersion(_messages.Message):
  r"""MinorVersion represents a minor version of a GI.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/GiMinorVersionSummary/

  Fields:
    gridImageId: Optional. The ID of the Grid Image.
    name: Identifier. The name of the MinorVersion resource with the format: p
      rojects/{project}/locations/{region}/giVersions/{gi_version}/minorVersio
      ns/{minor_version}
    version: Optional. The valid Oracle grid infrastructure software version.
  """

  gridImageId = _messages.StringField(1)
  name = _messages.StringField(2)
  version = _messages.StringField(3)


class NameValuePair(_messages.Message):
  r"""A name-value pair representing an attribute entry usable in a list of
  attributes.

  Fields:
    key: Required. The name of the property entry.
    value: Required. The value of the property entry.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class OdbNetwork(_messages.Message):
  r"""Represents OdbNetwork resource.

  Enums:
    StateValueValuesEnum: Output only. State of the ODB Network.

  Messages:
    LabelsValue: Optional. Labels or tags associated with the resource.

  Fields:
    createTime: Output only. The date and time that the OdbNetwork was
      created.
    entitlementId: Output only. The ID of the subscription entitlement
      associated with the OdbNetwork.
    gcpOracleZone: Optional. The GCP Oracle zone where OdbNetwork is hosted.
      Example: us-east4-b-r2. If not specified, the system will pick a zone
      based on availability.
    labels: Optional. Labels or tags associated with the resource.
    name: Identifier. The name of the OdbNetwork resource in the following
      format: projects/{project}/locations/{region}/odbNetworks/{odb_network}
    network: Required. The name of the VPC network in the following format:
      projects/{project}/global/networks/{network}
    state: Output only. State of the ODB Network.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the ODB Network.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      TERMINATING: Indicates that the resource is in terminating state.
      FAILED: Indicates that the resource is in failed state.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    TERMINATING = 3
    FAILED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  entitlementId = _messages.StringField(2)
  gcpOracleZone = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  network = _messages.StringField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)


class OdbSubnet(_messages.Message):
  r"""Represents OdbSubnet resource.

  Enums:
    PurposeValueValuesEnum: Required. Purpose of the subnet.
    StateValueValuesEnum: Output only. State of the ODB Subnet.

  Messages:
    LabelsValue: Optional. Labels or tags associated with the resource.

  Fields:
    cidrRange: Required. The CIDR range of the subnet.
    createTime: Output only. The date and time that the OdbNetwork was
      created.
    labels: Optional. Labels or tags associated with the resource.
    name: Identifier. The name of the OdbSubnet resource in the following
      format: projects/{project}/locations/{location}/odbNetworks/{odb_network
      }/odbSubnets/{odb_subnet}
    purpose: Required. Purpose of the subnet.
    state: Output only. State of the ODB Subnet.
  """

  class PurposeValueValuesEnum(_messages.Enum):
    r"""Required. Purpose of the subnet.

    Values:
      PURPOSE_UNSPECIFIED: Default unspecified value.
      CLIENT_SUBNET: Subnet to be used for client connections.
      BACKUP_SUBNET: Subnet to be used for backup.
    """
    PURPOSE_UNSPECIFIED = 0
    CLIENT_SUBNET = 1
    BACKUP_SUBNET = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the ODB Subnet.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that the resource is in provisioning state.
      AVAILABLE: Indicates that the resource is in available state.
      TERMINATING: Indicates that the resource is in terminating state.
      FAILED: Indicates that the resource is in failed state.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    TERMINATING = 3
    FAILED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cidrRange = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  purpose = _messages.EnumField('PurposeValueValuesEnum', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    percentComplete: Output only. An estimated percentage of the operation
      that has been completed at a given moment of time, between 0 and 100.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. The status of the operation.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  percentComplete = _messages.FloatField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class OracledatabaseProjectsLocationsAutonomousDatabaseBackupsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabaseBackupsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only the **autonomous_database_id** field is supported in the following
      format: `autonomous_database_id="{autonomous_database_id}"`. The
      accepted values must be a valid Autonomous Database ID, limited to the
      naming restrictions of the ID: ^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$). The
      ID must start with a letter, end with a letter or a number, and be a
      maximum of 63 characters.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous DB Backups will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for ListAutonomousDatabaseBackups in
      the following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsGetRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsGetRequest
  object.

  Fields:
    name: Required. The name of the Autonomous Database Character Set in the
      following format: projects/{project}/locations/{location}/autonomousData
      baseCharacterSets/{autonomous_database_character_set}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsListRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only the **character_set_type** field is supported in the following
      format: `character_set_type="{characterSetType}"`. Accepted values
      include `DATABASE` and `NATIONAL`.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous DB Character Sets will be returned. The maximum
      value is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for the Autonomous Database in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesCreateRequest
  object.

  Fields:
    autonomousDatabase: A AutonomousDatabase resource to be passed as the
      request body.
    autonomousDatabaseId: Required. The ID of the Autonomous Database to
      create. This value is restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$)
      and must be a maximum of 63 characters in length. The value must start
      with a letter and end with a letter or a number.
    parent: Required. The name of the parent in the following format:
      projects/{project}/locations/{location}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  autonomousDatabase = _messages.MessageField('AutonomousDatabase', 1)
  autonomousDatabaseId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsAutonomousDatabasesDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesDeleteRequest
  object.

  Fields:
    name: Required. The name of the resource in the following format: projects
      /{project}/locations/{location}/autonomousDatabases/{autonomous_database
      }.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsAutonomousDatabasesFailoverRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesFailoverRequest
  object.

  Fields:
    failoverAutonomousDatabaseRequest: A FailoverAutonomousDatabaseRequest
      resource to be passed as the request body.
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
  """

  failoverAutonomousDatabaseRequest = _messages.MessageField('FailoverAutonomousDatabaseRequest', 1)
  name = _messages.StringField(2, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesGenerateWalletRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsAutonomousDatabasesGenerateWalletRequest
  object.

  Fields:
    generateAutonomousDatabaseWalletRequest: A
      GenerateAutonomousDatabaseWalletRequest resource to be passed as the
      request body.
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
  """

  generateAutonomousDatabaseWalletRequest = _messages.MessageField('GenerateAutonomousDatabaseWalletRequest', 1)
  name = _messages.StringField(2, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesGetRequest object.

  Fields:
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesListRefreshableClonesRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesListRefreshableClone
  sRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The Autonomous Database parent resource whose
      refreshable clones are to be listed. Format: projects/{project}/location
      s/{location}/autonomousDatabases/{autonomous_database}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous Database will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for the Autonomous Database in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesPatchRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesPatchRequest object.

  Fields:
    autonomousDatabase: A AutonomousDatabase resource to be passed as the
      request body.
    name: Identifier. The name of the Autonomous Database resource in the
      following format: projects/{project}/locations/{region}/autonomousDataba
      ses/{autonomous_database}
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Exadata resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  autonomousDatabase = _messages.MessageField('AutonomousDatabase', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class OracledatabaseProjectsLocationsAutonomousDatabasesRefreshRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesRefreshRequest
  object.

  Fields:
    name: Required. The name of the AutonomousDatabase resource. Format: proje
      cts/{project}/location/{location}/autonomousDatabases/{autonomous_databa
      se}
    refreshAutonomousDatabaseRequest: A RefreshAutonomousDatabaseRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  refreshAutonomousDatabaseRequest = _messages.MessageField('RefreshAutonomousDatabaseRequest', 2)


class OracledatabaseProjectsLocationsAutonomousDatabasesRestartRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesRestartRequest
  object.

  Fields:
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
    restartAutonomousDatabaseRequest: A RestartAutonomousDatabaseRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  restartAutonomousDatabaseRequest = _messages.MessageField('RestartAutonomousDatabaseRequest', 2)


class OracledatabaseProjectsLocationsAutonomousDatabasesRestoreRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesRestoreRequest
  object.

  Fields:
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
    restoreAutonomousDatabaseRequest: A RestoreAutonomousDatabaseRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  restoreAutonomousDatabaseRequest = _messages.MessageField('RestoreAutonomousDatabaseRequest', 2)


class OracledatabaseProjectsLocationsAutonomousDatabasesStartRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesStartRequest object.

  Fields:
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
    startAutonomousDatabaseRequest: A StartAutonomousDatabaseRequest resource
      to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  startAutonomousDatabaseRequest = _messages.MessageField('StartAutonomousDatabaseRequest', 2)


class OracledatabaseProjectsLocationsAutonomousDatabasesStopRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesStopRequest object.

  Fields:
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
    stopAutonomousDatabaseRequest: A StopAutonomousDatabaseRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  stopAutonomousDatabaseRequest = _messages.MessageField('StopAutonomousDatabaseRequest', 2)


class OracledatabaseProjectsLocationsAutonomousDatabasesSwitchoverRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesSwitchoverRequest
  object.

  Fields:
    name: Required. The name of the Autonomous Database in the following
      format: projects/{project}/locations/{location}/autonomousDatabases/{aut
      onomous_database}.
    switchoverAutonomousDatabaseRequest: A SwitchoverAutonomousDatabaseRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  switchoverAutonomousDatabaseRequest = _messages.MessageField('SwitchoverAutonomousDatabaseRequest', 2)


class OracledatabaseProjectsLocationsAutonomousDbVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDbVersionsGetRequest object.

  Fields:
    name: Required. The name of the Autonomous Database Version in the
      following format: projects/{project}/locations/{location}/autonomousDbVe
      rsions/{autonomous_db_version}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsAutonomousDbVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDbVersionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous DB Versions will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for the Autonomous Database in the
      following format: projects/{project}/locations/{location}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresCreateRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsCloudExadataInfrastructuresCreateRequest
  object.

  Fields:
    cloudExadataInfrastructure: A CloudExadataInfrastructure resource to be
      passed as the request body.
    cloudExadataInfrastructureId: Required. The ID of the Exadata
      Infrastructure to create. This value is restricted to
      (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63
      characters in length. The value must start with a letter and end with a
      letter or a number.
    parent: Required. The parent value for CloudExadataInfrastructure in the
      following format: projects/{project}/locations/{location}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  cloudExadataInfrastructure = _messages.MessageField('CloudExadataInfrastructure', 1)
  cloudExadataInfrastructureId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersGet
  Request object.

  Fields:
    name: Required. The name of the database server in the following format: p
      rojects/{project}/locations/{location}/cloudExadataInfrastructures/{clou
      dExadataInfrastructure}/dbServers/{db_server}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersLis
  tRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 db servers will be returned. The maximum value is 1000;
      values above 1000 will be reset to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for database server in the following
      format: projects/{project}/locations/{location}/cloudExadataInfrastructu
      res/{cloudExadataInfrastructure}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresDeleteRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsCloudExadataInfrastructuresDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, all VM clusters for this Exadata
      Infrastructure will be deleted. An Exadata Infrastructure can only be
      deleted once all its VM clusters have been deleted.
    name: Required. The name of the Cloud Exadata Infrastructure in the
      following format: projects/{project}/locations/{location}/cloudExadataIn
      frastructures/{cloud_exadata_infrastructure}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresGetRequest
  object.

  Fields:
    name: Required. The name of the Cloud Exadata Infrastructure in the
      following format: projects/{project}/locations/{location}/cloudExadataIn
      frastructures/{cloud_exadata_infrastructure}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Exadata infrastructures will be returned. The maximum value
      is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for CloudExadataInfrastructure in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresPatchRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresPatchRequest
  object.

  Fields:
    cloudExadataInfrastructure: A CloudExadataInfrastructure resource to be
      passed as the request body.
    name: Identifier. The name of the Exadata Infrastructure resource with the
      format: projects/{project}/locations/{region}/cloudExadataInfrastructure
      s/{cloud_exadata_infrastructure}
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Exadata resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  cloudExadataInfrastructure = _messages.MessageField('CloudExadataInfrastructure', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class OracledatabaseProjectsLocationsCloudVmClustersCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersCreateRequest object.

  Fields:
    cloudVmCluster: A CloudVmCluster resource to be passed as the request
      body.
    cloudVmClusterId: Required. The ID of the VM Cluster to create. This value
      is restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a
      maximum of 63 characters in length. The value must start with a letter
      and end with a letter or a number.
    parent: Required. The name of the parent in the following format:
      projects/{project}/locations/{location}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  cloudVmCluster = _messages.MessageField('CloudVmCluster', 1)
  cloudVmClusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsCloudVmClustersDbNodesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersDbNodesGetRequest
  object.

  Fields:
    name: Required. The name of the database node in the following format: pro
      jects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}/
      dbNodes/{db_node}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersDbNodesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersDbNodesListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 db nodes will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the node should
      return.
    parent: Required. The parent value for database node in the following
      format: projects/{project}/locations/{location}/cloudVmClusters/{cloudVm
      Cluster}. .
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersDeleteRequest object.

  Fields:
    force: Optional. If set to true, all child resources for the VM Cluster
      will be deleted. A VM Cluster can only be deleted once all its child
      resources have been deleted.
    name: Required. The name of the Cloud VM Cluster in the following format:
      projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluste
      r}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class OracledatabaseProjectsLocationsCloudVmClustersGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersGetRequest object.

  Fields:
    name: Required. The name of the Cloud VM Cluster in the following format:
      projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluste
      r}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    pageSize: Optional. The number of VM clusters to return. If unspecified,
      at most 50 VM clusters will be returned. The maximum value is 1,000.
    pageToken: Optional. A token identifying the page of results the server
      returns.
    parent: Required. The name of the parent in the following format:
      projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersPatchRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersPatchRequest object.

  Fields:
    cloudVmCluster: A CloudVmCluster resource to be passed as the request
      body.
    name: Identifier. The name of the VM Cluster resource with the format:
      projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. A mask specifying which fields in th VM Cluster
      should be updated. A field specified in the mask is overwritten. If a
      mask isn't provided then all the fields in the VM Cluster are
      overwritten.
  """

  cloudVmCluster = _messages.MessageField('CloudVmCluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class OracledatabaseProjectsLocationsDatabaseCharacterSetsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDatabaseCharacterSetsGetRequest object.

  Fields:
    name: Required. The name of the Database Character Set resource in the
      following format: projects/{project}/locations/{region}/databaseCharacte
      rSets/{database_character_set}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDatabaseCharacterSetsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDatabaseCharacterSetsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only the **character_set_type** field is supported in the following
      format: `character_set_type="{characterSetType}"`. Accepted values
      include `DATABASE` and `NATIONAL`.
    pageSize: Optional. The maximum number of DatabaseCharacterSets to return.
      The service may return fewer than this value. If unspecified, at most 50
      DatabaseCharacterSets will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListDatabaseCharacterSets` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `ListDatabaseCharacterSets` must match the call that provided the page
      token.
    parent: Required. The parent value for DatabaseCharacterSets in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsDatabasesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDatabasesGetRequest object.

  Fields:
    name: Required. The name of the Database resource in the following format:
      projects/{project}/locations/{region}/databases/{database}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDatabasesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDatabasesListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      list for container databases is supported only with a valid dbSystem
      (full resource name) filter in this format: `dbSystem="projects/{project
      }/locations/{location}/dbSystems/{dbSystemId}"`
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 Databases will be returned. The maximum value is 1000;
      values above 1000 will be reset to 1000.
    pageToken: Optional. A token identifying the requested page of results to
      return. All fields except the filter should remain the same as in the
      request that provided this page token.
    parent: Required. The parent resource name in the following format:
      projects/{project}/locations/{region}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsDbSystemInitialStorageSizesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemInitialStorageSizesGetRequest
  object.

  Fields:
    name: Required. The name of the DbSystemInitialStorageSize resource with
      the format: projects/{project}/locations/{location}/dbSystemInitialStora
      geSizes/{db_system_initial_storage_size}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDbSystemInitialStorageSizesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemInitialStorageSizesListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 DbSystemInitialStorageSizes will be returned. The
      maximum value is 1000; values above 1000 will be reset to 1000.
    pageToken: Optional. A token identifying the requested page of results to
      return. All fields except the filter should remain the same as in the
      request that provided this page token.
    parent: Required. The parent value for the DbSystemInitialStorageSize
      resource with the format: projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsDbSystemShapesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemShapesGetRequest object.

  Fields:
    name: Required. The name of the Database System Shape in the following
      format: projects/{project}/locations/{location}/dbSystemShapes/{db_syste
      m_shape}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDbSystemShapesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemShapesListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only the gcp_oracle_zone_id field is supported in this format:
      `gcp_oracle_zone_id="{gcp_oracle_zone_id}"`.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 database system shapes will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for Database System Shapes in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsDbSystemsCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemsCreateRequest object.

  Fields:
    dbSystem: A DbSystem resource to be passed as the request body.
    dbSystemId: Required. The ID of the DbSystem to create. This value is
      restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum
      of 63 characters in length. The value must start with a letter and end
      with a letter or a number.
    parent: Required. The value for parent of the DbSystem in the following
      format: projects/{project}/locations/{location}.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  dbSystem = _messages.MessageField('DbSystem', 1)
  dbSystemId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsDbSystemsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemsDeleteRequest object.

  Fields:
    name: Required. The name of the DbSystem in the following format:
      projects/{project}/locations/{location}/dbSystems/{db_system}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsDbSystemsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemsGetRequest object.

  Fields:
    name: Required. The name of the DbSystem in the following format:
      projects/{project}/locations/{location}/dbSystems/{db_system}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDbSystemsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 DbSystems will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for DbSystems in the following format:
      projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsDbVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbVersionsGetRequest object.

  Fields:
    name: Required. The name of the DbVersion resource with the format:
      projects/{project}/locations/{location}/dbVersions/{db_version}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDbVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbVersionsListRequest object.

  Fields:
    filter: Optional. Filter expression that matches a subset of the
      DbVersions to show. The supported filter for dbSystem creation is
      `db_system_shape = {db_system_shape} AND storage_management =
      {storage_management}`. If no filter is provided, all DbVersions will be
      returned.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 DbVersions will be returned. The maximum value is 1000;
      values above 1000 will be reset to 1000.
    pageToken: Optional. A token identifying the requested page of results to
      return. All fields except the filter should remain the same as in the
      request that provided this page token.
    parent: Required. The parent value for the DbVersion resource with the
      format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsEntitlementsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsEntitlementsGetRequest object.

  Fields:
    name: Required. The name of the entitlement in the following format:
      projects/{project}/locations/{location}/entitlements/{entitlement}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsEntitlementsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsEntitlementsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 entitlements will be returned. The maximum value is
      1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for the entitlement in the following
      format: projects/{project}/locations/{location}.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsExadbVmClustersCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersCreateRequest object.

  Fields:
    exadbVmCluster: A ExadbVmCluster resource to be passed as the request
      body.
    exadbVmClusterId: Required. The ID of the ExadbVmCluster to create. This
      value is restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a
      maximum of 63 characters in length. The value must start with a letter
      and end with a letter or a number.
    parent: Required. The value for parent of the ExadbVmCluster in the
      following format: projects/{project}/locations/{location}.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  exadbVmCluster = _messages.MessageField('ExadbVmCluster', 1)
  exadbVmClusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsExadbVmClustersDbNodesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersDbNodesGetRequest
  object.

  Fields:
    name: Required. The name of the database node in the following format: pro
      jects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}/
      dbNodes/{db_node}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsExadbVmClustersDbNodesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersDbNodesListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 db nodes will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the node should
      return.
    parent: Required. The parent value for database node in the following
      format: projects/{project}/locations/{location}/cloudVmClusters/{cloudVm
      Cluster}. .
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsExadbVmClustersDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersDeleteRequest object.

  Fields:
    name: Required. The name of the ExadbVmCluster in the following format: pr
      ojects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}
      .
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsExadbVmClustersGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersGetRequest object.

  Fields:
    name: Required. The name of the ExadbVmCluster in the following format: pr
      ojects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}
      .
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsExadbVmClustersListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 ExadbVmClusters will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for ExadbVmClusters in the following
      format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsExadbVmClustersPatchRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExadbVmClustersPatchRequest object.

  Fields:
    exadbVmCluster: A ExadbVmCluster resource to be passed as the request
      body.
    name: Identifier. The name of the ExadbVmCluster resource in the following
      format:
      projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. A mask specifying which fields in th VM Cluster
      should be updated. A field specified in the mask is overwritten. If a
      mask isn't provided then all the fields in the VM Cluster are
      overwritten.
  """

  exadbVmCluster = _messages.MessageField('ExadbVmCluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class OracledatabaseProjectsLocationsExadbVmClustersRemoveVirtualMachineRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsExadbVmClustersRemoveVirtualMachineRequest
  object.

  Fields:
    name: Required. The name of the ExadbVmCluster in the following format: pr
      ojects/{project}/locations/{location}/exadbVmClusters/{exadb_vm_cluster}
      .
    removeVirtualMachineExadbVmClusterRequest: A
      RemoveVirtualMachineExadbVmClusterRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  removeVirtualMachineExadbVmClusterRequest = _messages.MessageField('RemoveVirtualMachineExadbVmClusterRequest', 2)


class OracledatabaseProjectsLocationsExascaleDbStorageVaultsCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExascaleDbStorageVaultsCreateRequest
  object.

  Fields:
    exascaleDbStorageVault: A ExascaleDbStorageVault resource to be passed as
      the request body.
    exascaleDbStorageVaultId: Required. The ID of the ExascaleDbStorageVault
      to create. This value is restricted to
      (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63
      characters in length. The value must start with a letter and end with a
      letter or a number.
    parent: Required. The value for parent of the ExascaleDbStorageVault in
      the following format: projects/{project}/locations/{location}.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  exascaleDbStorageVault = _messages.MessageField('ExascaleDbStorageVault', 1)
  exascaleDbStorageVaultId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsExascaleDbStorageVaultsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExascaleDbStorageVaultsDeleteRequest
  object.

  Fields:
    name: Required. The name of the ExascaleDbStorageVault in the following
      format: projects/{project}/locations/{location}/exascaleDbStorageVaults/
      {exascale_db_storage_vault}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsExascaleDbStorageVaultsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExascaleDbStorageVaultsGetRequest
  object.

  Fields:
    name: Required. The name of the ExascaleDbStorageVault in the following
      format: projects/{project}/locations/{location}/exascaleDbStorageVaults/
      {exascale_db_storage_vault}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsExascaleDbStorageVaultsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsExascaleDbStorageVaultsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Filter the list as specified in https://google.aip.dev/160.
    orderBy: Optional. An expression for ordering the results of the request.
      Order results as specified in https://google.aip.dev/132.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 ExascaleDbStorageVaults will be returned. The maximum value
      is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for ExascaleDbStorageVault in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGiVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGiVersionsGetRequest object.

  Fields:
    name: Required. The name of the Grid Infrastructure (GI) version in the
      following format:
      projects/{project}/locations/{location}/giVersions/{gi_version}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGiVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGiVersionsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only the shape, gcp_oracle_zone and gi_version fields are supported in
      this format: `shape="{shape}"`.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 Oracle Grid Infrastructure (GI) versions will be
      returned. The maximum value is 1000; values above 1000 will be reset to
      1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for Grid Infrastructure Version in the
      following format: Format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsGiVersionsMinorVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGiVersionsMinorVersionsGetRequest
  object.

  Fields:
    name: Required. The name of the MinorVersion resource with the format: pro
      jects/{project}/locations/{location}/giVersions/{gi_version}/minorVersio
      ns/{minor_version}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGiVersionsMinorVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGiVersionsMinorVersionsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only shapeFamily and gcp_oracle_zone_id are supported in this format:
      `shape_family="{shapeFamily}" AND
      gcp_oracle_zone_id="{gcp_oracle_zone_id}"`.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 System Versions will be returned. The maximum value is
      1000; values above 1000 will be reset to 1000.
    pageToken: Optional. A token identifying the requested page of results to
      return. All fields except the filter should remain the same as in the
      request that provided this page token.
    parent: Required. The parent value for the MinorVersion resource with the
      format: projects/{project}/locations/{location}/giVersions/{gi_version}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsCreateRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsCreateRequest
  object.

  Fields:
    goldenGateConnectionAssignment: A GoldenGateConnectionAssignment resource
      to be passed as the request body.
    goldenGateConnectionAssignmentId: Required. The ID of the
      GoldenGateConnectionAssignment to create.
    parent: Required. The parent resource where this
      GoldenGateConnectionAssignment will be created. Format:
      projects/{project}/locations/{location}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  goldenGateConnectionAssignment = _messages.MessageField('GoldenGateConnectionAssignment', 1)
  goldenGateConnectionAssignmentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsDeleteRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsDeleteRequest
  object.

  Fields:
    name: Required. The name of the GoldenGateConnectionAssignment to delete.
      Format: projects/{project}/locations/{location}/goldenGateConnectionAssi
      gnments/{golden_gate_connection_assignment}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsGetRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsGetRequest
  object.

  Fields:
    name: Required. The name of the GoldenGateConnectionAssignment to
      retrieve. Format: projects/{project}/locations/{location}/goldenGateConn
      ectionAssignments/{golden_gate_connection_assignment}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsListRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsListRequest
  object.

  Fields:
    filter: Optional. A filter expression that filters
      GoldenGateConnectionAssignments listed in the response.
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "DESC" after a field name for descending.
    pageSize: Optional. The maximum number of GoldenGateConnectionAssignments
      to return. The service may return fewer than this value. If unspecified,
      at most 50 GoldenGateConnectionAssignments will be returned. The maximum
      value is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListGoldenGateConnectionAssignments` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `ListGoldenGateConnectionAssignments` must match the call that provided
      the page token.
    parent: Required. The parent resource where this
      GoldenGateConnectionAssignment will be created. Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsTestRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsGoldenGateConnectionAssignmentsTestRequest
  object.

  Fields:
    name: Required. Name of the connection assignment for which to test
      connection. projects/{project}/locations/{region}/goldenGateConnectionAs
      signments/{golden_gate_connection_assignment}
    testGoldenGateConnectionAssignmentRequest: A
      TestGoldenGateConnectionAssignmentRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  testGoldenGateConnectionAssignmentRequest = _messages.MessageField('TestGoldenGateConnectionAssignmentRequest', 2)


class OracledatabaseProjectsLocationsGoldenGateConnectionsCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateConnectionsCreateRequest
  object.

  Fields:
    goldenGateConnection: A GoldenGateConnection resource to be passed as the
      request body.
    goldenGateConnectionId: Required. The ID of the GoldenGateConnection to
      create. This value is restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$)
      and must be a maximum of 63 characters in length. The value must start
      with a letter and end with a letter or a number.
    parent: Required. The value for parent of the GoldenGateConnection in the
      following format: projects/{project}/locations/{location}.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  goldenGateConnection = _messages.MessageField('GoldenGateConnection', 1)
  goldenGateConnectionId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsGoldenGateConnectionsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateConnectionsDeleteRequest
  object.

  Fields:
    name: Required. The name of the GoldenGateConnection in the following
      format: projects/{project}/locations/{location}/goldenGateConnections/{g
      olden_gate_connection}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsGoldenGateConnectionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateConnectionsGetRequest object.

  Fields:
    name: Required. The name of the GoldenGateConnection in the following
      format: projects/{project}/locations/{location}/goldenGateConnections/{g
      olden_gate_connection}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGoldenGateConnectionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateConnectionsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 GoldenGateConnections will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      ListGoldenGateConnections call. Provide this to retrieve the subsequent
      page.
    parent: Required. The parent value for GoldenGateConnections in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsGoldenGateDeploymentsCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateDeploymentsCreateRequest
  object.

  Fields:
    goldenGateDeployment: A GoldenGateDeployment resource to be passed as the
      request body.
    goldenGateDeploymentId: Required. The ID of the GoldenGateDeployment to
      create. This value is restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$)
      and must be a maximum of 63 characters in length. The value must start
      with a letter and end with a letter or a number.
    parent: Required. The value for parent of the GoldenGateDeployment in the
      following format: projects/{project}/locations/{location}.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  goldenGateDeployment = _messages.MessageField('GoldenGateDeployment', 1)
  goldenGateDeploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsGoldenGateDeploymentsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateDeploymentsDeleteRequest
  object.

  Fields:
    name: Required. The name of the GoldenGateDeployment in the following
      format: projects/{project}/locations/{location}/goldenGateDeployments/{g
      olden_gate_deployment}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsGoldenGateDeploymentsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateDeploymentsGetRequest object.

  Fields:
    name: Required. The name of the GoldenGateDeployment in the following
      format: projects/{project}/locations/{location}/goldenGateDeployments/{g
      olden_gate_deployment}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGoldenGateDeploymentsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateDeploymentsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 GoldenGateDeployments will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      ListGoldenGateDeployments call. Provide this to retrieve the subsequent
      page.
    parent: Required. The parent value for GoldenGateDeployments in the
      following format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsGoldenGateDeploymentsStartRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateDeploymentsStartRequest
  object.

  Fields:
    name: Required. The name of the GoldenGate Deployment in the following
      format: projects/{project}/locations/{location}/goldenGateDeployments/{g
      olden_gate_deployment}.
    startGoldenGateDeploymentRequest: A StartGoldenGateDeploymentRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  startGoldenGateDeploymentRequest = _messages.MessageField('StartGoldenGateDeploymentRequest', 2)


class OracledatabaseProjectsLocationsGoldenGateDeploymentsStopRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGoldenGateDeploymentsStopRequest
  object.

  Fields:
    name: Required. The name of the GoldenGate Deployment in the following
      format: projects/{project}/locations/{location}/goldenGateDeployments/{g
      olden_gate_deployment}.
    stopGoldenGateDeploymentRequest: A StopGoldenGateDeploymentRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  stopGoldenGateDeploymentRequest = _messages.MessageField('StopGoldenGateDeploymentRequest', 2)


class OracledatabaseProjectsLocationsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class OracledatabaseProjectsLocationsOdbNetworksCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksCreateRequest object.

  Fields:
    odbNetwork: A OdbNetwork resource to be passed as the request body.
    odbNetworkId: Required. The ID of the OdbNetwork to create. This value is
      restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum
      of 63 characters in length. The value must start with a letter and end
      with a letter or a number.
    parent: Required. The parent value for the OdbNetwork in the following
      format: projects/{project}/locations/{location}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  odbNetwork = _messages.MessageField('OdbNetwork', 1)
  odbNetworkId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsOdbNetworksDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksDeleteRequest object.

  Fields:
    name: Required. The name of the resource in the following format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsOdbNetworksGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksGetRequest object.

  Fields:
    name: Required. The name of the OdbNetwork in the following format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsOdbNetworksListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 ODB Networks will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for the ODB Network in the following
      format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsCreateRequest
  object.

  Fields:
    odbSubnet: A OdbSubnet resource to be passed as the request body.
    odbSubnetId: Required. The ID of the OdbSubnet to create. This value is
      restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum
      of 63 characters in length. The value must start with a letter and end
      with a letter or a number.
    parent: Required. The parent value for the OdbSubnet in the following
      format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  odbSubnet = _messages.MessageField('OdbSubnet', 1)
  odbSubnetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsDeleteRequest
  object.

  Fields:
    name: Required. The name of the resource in the following format: projects
      /{project}/locations/{region}/odbNetworks/{odb_network}/odbSubnets/{odb_
      subnet}.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsGetRequest object.

  Fields:
    name: Required. The name of the OdbSubnet in the following format: project
      s/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{o
      db_subnet}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOdbNetworksOdbSubnetsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
    orderBy: Optional. An expression for ordering the results of the request.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 ODB Networks will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent value for the OdbSubnet in the following
      format:
      projects/{project}/locations/{location}/odbNetworks/{odb_network}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class OracledatabaseProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class OracledatabaseProjectsLocationsPluggableDatabasesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsPluggableDatabasesGetRequest object.

  Fields:
    name: Required. The name of the PluggableDatabase resource in the
      following format: projects/{project}/locations/{region}/pluggableDatabas
      es/{pluggable_database}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsPluggableDatabasesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsPluggableDatabasesListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      List for pluggable databases is supported only with a valid container
      database (full resource name) filter in this format: `database="projects
      /{project}/locations/{location}/databases/{database}"`
    pageSize: Optional. The maximum number of PluggableDatabases to return.
      The service may return fewer than this value.
    pageToken: Optional. A page token, received from a previous
      `ListPluggableDatabases` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListPluggableDatabases` must match the call that provided the page
      token.
    parent: Required. The parent, which owns this collection of
      PluggableDatabases. Format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsSystemVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsSystemVersionsGetRequest object.

  Fields:
    name: Required. The name of the System Version in the following format:
      projects/{project}/locations/{location}/systemVersions/{system_version}.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsSystemVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsSystemVersionsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Only the shape and gi_version fields are supported in this format:
      `shape="{shape}" AND gi_version="{gi_version}"`.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      a maximum of 50 System Versions will be returned. The maximum value is
      1000; values above 1000 will be reset to 1000.
    pageToken: Optional. A token identifying the requested page of results to
      return. All fields except the filter should remain the same as in the
      request that provided this page token.
    parent: Required. The parent value for System Version in the following
      format: Format: projects/{project}/locations/{location}.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class PluggableDatabase(_messages.Message):
  r"""The PluggableDatabase resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/PluggableDatabase/

  Fields:
    createTime: Output only. The date and time that the PluggableDatabase was
      created.
    name: Identifier. The name of the PluggableDatabase resource in the
      following format: projects/{project}/locations/{region}/pluggableDatabas
      es/{pluggable_database}
    ociUrl: Output only. HTTPS link to OCI resources exposed to Customer via
      UI Interface.
    properties: Optional. The properties of the PluggableDatabase.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  ociUrl = _messages.StringField(3)
  properties = _messages.MessageField('PluggableDatabaseProperties', 4)


class PluggableDatabaseConnectionStrings(_messages.Message):
  r"""The connection strings used to connect to the Oracle Database.

  Messages:
    AllConnectionStringsValue: Optional. All connection strings to use to
      connect to the pluggable database.

  Fields:
    allConnectionStrings: Optional. All connection strings to use to connect
      to the pluggable database.
    pdbDefault: Optional. The default connection string to use to connect to
      the pluggable database.
    pdbIpDefault: Optional. The default connection string to use to connect to
      the pluggable database using IP.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AllConnectionStringsValue(_messages.Message):
    r"""Optional. All connection strings to use to connect to the pluggable
    database.

    Messages:
      AdditionalProperty: An additional property for a
        AllConnectionStringsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AllConnectionStringsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AllConnectionStringsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allConnectionStrings = _messages.MessageField('AllConnectionStringsValue', 1)
  pdbDefault = _messages.StringField(2)
  pdbIpDefault = _messages.StringField(3)


class PluggableDatabaseNodeLevelDetails(_messages.Message):
  r"""The Pluggable Database Node Level Details.

  Enums:
    OpenModeValueValuesEnum: Required. The mode that the pluggable database is
      in to open it.

  Fields:
    nodeName: Required. The Node name of the Database home.
    openMode: Required. The mode that the pluggable database is in to open it.
    pluggableDatabaseId: Required. The OCID of the Pluggable Database.
  """

  class OpenModeValueValuesEnum(_messages.Enum):
    r"""Required. The mode that the pluggable database is in to open it.

    Values:
      PLUGGABLE_DATABASE_OPEN_MODE_UNSPECIFIED: The open mode is unspecified.
      READ_ONLY: The pluggable database is opened in read-only mode.
      READ_WRITE: The pluggable database is opened in read-write mode.
      MOUNTED: The pluggable database is mounted.
      MIGRATE: The pluggable database is migrated.
    """
    PLUGGABLE_DATABASE_OPEN_MODE_UNSPECIFIED = 0
    READ_ONLY = 1
    READ_WRITE = 2
    MOUNTED = 3
    MIGRATE = 4

  nodeName = _messages.StringField(1)
  openMode = _messages.EnumField('OpenModeValueValuesEnum', 2)
  pluggableDatabaseId = _messages.StringField(3)


class PluggableDatabaseProperties(_messages.Message):
  r"""The properties of a PluggableDatabase.

  Enums:
    LifecycleStateValueValuesEnum: Output only. The current state of the
      pluggable database.
    OperationsInsightsStateValueValuesEnum: Output only. The status of
      Operations Insights for this Database.

  Messages:
    DefinedTagsValue: Optional. Defined tags for this resource. Each key is
      predefined and scoped to a namespace.
    FreeformTagsValue: Optional. Free-form tags for this resource. Each tag is
      a simple key-value pair with no predefined name, type, or namespace.

  Fields:
    compartmentId: Required. The OCID of the compartment.
    connectionStrings: Optional. The Connection strings used to connect to the
      Oracle Database.
    containerDatabaseOcid: Required. The OCID of the CDB.
    databaseManagementConfig: Output only. The configuration of the Database
      Management service.
    definedTags: Optional. Defined tags for this resource. Each key is
      predefined and scoped to a namespace.
    freeformTags: Optional. Free-form tags for this resource. Each tag is a
      simple key-value pair with no predefined name, type, or namespace.
    isRestricted: Optional. The restricted mode of the pluggable database. If
      a pluggable database is opened in restricted mode, the user needs both
      create a session and have restricted session privileges to connect to
      it.
    lifecycleDetails: Output only. Additional information about the current
      lifecycle state.
    lifecycleState: Output only. The current state of the pluggable database.
    ocid: Output only. The OCID of the pluggable database.
    operationsInsightsState: Output only. The status of Operations Insights
      for this Database.
    pdbName: Required. The database name.
    pdbNodeLevelDetails: Optional. Pluggable Database Node Level Details
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the pluggable database.

    Values:
      PLUGGABLE_DATABASE_LIFECYCLE_STATE_UNSPECIFIED: The lifecycle state is
        unspecified.
      PROVISIONING: The pluggable database is provisioning.
      AVAILABLE: The pluggable database is available.
      TERMINATING: The pluggable database is terminating.
      TERMINATED: The pluggable database is terminated.
      UPDATING: The pluggable database is updating.
      FAILED: The pluggable database is in a failed state.
      RELOCATING: The pluggable database is relocating.
      RELOCATED: The pluggable database is relocated.
      REFRESHING: The pluggable database is refreshing.
      RESTORE_IN_PROGRESS: The pluggable database is restoring.
      RESTORE_FAILED: The pluggable database restore failed.
      BACKUP_IN_PROGRESS: The pluggable database is backing up.
      DISABLED: The pluggable database is disabled.
    """
    PLUGGABLE_DATABASE_LIFECYCLE_STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    TERMINATING = 3
    TERMINATED = 4
    UPDATING = 5
    FAILED = 6
    RELOCATING = 7
    RELOCATED = 8
    REFRESHING = 9
    RESTORE_IN_PROGRESS = 10
    RESTORE_FAILED = 11
    BACKUP_IN_PROGRESS = 12
    DISABLED = 13

  class OperationsInsightsStateValueValuesEnum(_messages.Enum):
    r"""Output only. The status of Operations Insights for this Database.

    Values:
      OPERATIONS_INSIGHTS_STATE_UNSPECIFIED: The status is not specified.
      ENABLING: Operations Insights is enabling.
      ENABLED: Operations Insights is enabled.
      DISABLING: Operations Insights is disabling.
      NOT_ENABLED: Operations Insights is not enabled.
      FAILED_ENABLING: Operations Insights failed to enable.
      FAILED_DISABLING: Operations Insights failed to disable.
    """
    OPERATIONS_INSIGHTS_STATE_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    NOT_ENABLED = 4
    FAILED_ENABLING = 5
    FAILED_DISABLING = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DefinedTagsValue(_messages.Message):
    r"""Optional. Defined tags for this resource. Each key is predefined and
    scoped to a namespace.

    Messages:
      AdditionalProperty: An additional property for a DefinedTagsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DefinedTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DefinedTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A DefinedTagValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('DefinedTagValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FreeformTagsValue(_messages.Message):
    r"""Optional. Free-form tags for this resource. Each tag is a simple key-
    value pair with no predefined name, type, or namespace.

    Messages:
      AdditionalProperty: An additional property for a FreeformTagsValue
        object.

    Fields:
      additionalProperties: Additional properties of type FreeformTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FreeformTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  compartmentId = _messages.StringField(1)
  connectionStrings = _messages.MessageField('PluggableDatabaseConnectionStrings', 2)
  containerDatabaseOcid = _messages.StringField(3)
  databaseManagementConfig = _messages.MessageField('DatabaseManagementConfig', 4)
  definedTags = _messages.MessageField('DefinedTagsValue', 5)
  freeformTags = _messages.MessageField('FreeformTagsValue', 6)
  isRestricted = _messages.BooleanField(7)
  lifecycleDetails = _messages.StringField(8)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 9)
  ocid = _messages.StringField(10)
  operationsInsightsState = _messages.EnumField('OperationsInsightsStateValueValuesEnum', 11)
  pdbName = _messages.StringField(12)
  pdbNodeLevelDetails = _messages.MessageField('PluggableDatabaseNodeLevelDetails', 13, repeated=True)


class RefreshAutonomousDatabaseRequest(_messages.Message):
  r"""Request message for RefreshAutonomousDatabase method.

  Fields:
    refreshCutoffTime: Required. The timestamp to which the Autonomous
      Database refreshable clone will be refreshed. Changes made in the
      primary database after this timestamp are not part of the data refresh.
  """

  refreshCutoffTime = _messages.StringField(1)


class RemoveVirtualMachineExadbVmClusterRequest(_messages.Message):
  r"""The request for `ExadbVmCluster.RemoveVirtualMachine`.

  Fields:
    hostnames: Required. The list of host names of db nodes to be removed from
      the ExadbVmCluster.
    requestId: Optional. An optional ID to identify the request. This value is
      used to identify duplicate requests. If you make a request with the same
      request ID and the original request is still in progress or completed,
      the server ignores the second request. This prevents clients from
      accidentally creating duplicate commitments. The request ID must be a
      valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  hostnames = _messages.StringField(1, repeated=True)
  requestId = _messages.StringField(2)


class ResourceAvailability(_messages.Message):
  r"""Resource availability for a given location.

  Enums:
    ResourceTypeValueValuesEnum: Resource type.

  Fields:
    resourceType: Resource type.
    supportedZones: Supported zones for the resource in the location.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""Resource type.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: The resource type is not specified.
      RESOURCE_TYPE_BASE_DB: Base Database resource.
      RESOURCE_TYPE_AUTONOMOUS_DATABASE: Autonomous Database resource.
      RESOURCE_TYPE_EXADATA: Exadata resource.
      RESOURCE_TYPE_EXASCALE: Exascale resource.
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    RESOURCE_TYPE_BASE_DB = 1
    RESOURCE_TYPE_AUTONOMOUS_DATABASE = 2
    RESOURCE_TYPE_EXADATA = 3
    RESOURCE_TYPE_EXASCALE = 4

  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 1)
  supportedZones = _messages.StringField(2, repeated=True)


class RestartAutonomousDatabaseRequest(_messages.Message):
  r"""The request for `AutonomousDatabase.Restart`."""


class RestoreAutonomousDatabaseRequest(_messages.Message):
  r"""The request for `AutonomousDatabase.Restore`.

  Fields:
    restoreTime: Required. The time and date to restore the database to.
  """

  restoreTime = _messages.StringField(1)


class ScheduledOperationDetails(_messages.Message):
  r"""Details of scheduled operation. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/ScheduledOperationDetails

  Enums:
    DayOfWeekValueValuesEnum: Output only. Day of week.

  Fields:
    dayOfWeek: Output only. Day of week.
    startTime: Output only. Auto start time.
    stopTime: Output only. Auto stop time.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Output only. Day of week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  startTime = _messages.MessageField('TimeOfDay', 2)
  stopTime = _messages.MessageField('TimeOfDay', 3)


class SourceConfig(_messages.Message):
  r"""The source configuration for the standby Autonomous Database.

  Enums:
    CloneTypeValueValuesEnum: Optional. The clone type of the Autonomous
      Database. This field is only applicable in case of cloning
    RefreshableModeValueValuesEnum: Optional. The refresh mode of the clone.
    SourceTypeValueValuesEnum: Optional. The source type of the Autonomous
      Database.

  Fields:
    autoRefreshFrequencySeconds: Optional. The frequency in seconds a
      refreshable clone is refreshed after auto-refresh is enabled.
    autoRefreshPointLagSeconds: Optional. The time, in seconds, the data of
      the automatic refreshable clone lags the primary database at the point
      of refresh.
    autoRefreshStartTime: Optional. The date and time that auto-refreshing
      will begin for an Autonomous Database refreshable clone. This value
      controls only the start time for the first refresh operation.
    automaticBackupsReplicationEnabled: Optional. This field specifies if the
      replication of automatic backups is enabled when creating a Data Guard.
    autonomousDatabase: Optional. The name of the primary Autonomous Database
      that is used to create a Peer Autonomous Database from a source.
    autonomousDatabaseBackup: Optional. The name of the Autonomous Database
      Backup resource with the format: projects/{project}/locations/{region}/a
      utonomousDatabaseBackups/{autonomous_database_backup} Required when
      source_type is BACKUP_FROM_ID.
    backupTime: Optional. The timestamp specified for the point-in-time clone
      of the source Autonomous Database. This field is only applicable in case
      of BACKUP_FROM_TIMESTAMP source type and when
      use_latest_available_backup is false.
    cloneType: Optional. The clone type of the Autonomous Database. This field
      is only applicable in case of cloning
    refreshableMode: Optional. The refresh mode of the clone.
    sourceType: Optional. The source type of the Autonomous Database.
    useLatestAvailableBackup: Optional. Clone from latest available backup
      timestamp. This field is only applicable in case of
      BACKUP_FROM_TIMESTAMP source type.
  """

  class CloneTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The clone type of the Autonomous Database. This field is
    only applicable in case of cloning

    Values:
      CLONE_TYPE_UNSPECIFIED: Default unspecified value.
      FULL: Creates a new database with the source database's data and
        metadata.
      METADATA: Creates a new database that includes all the source database
        schema metadata, but none of the source database data.
    """
    CLONE_TYPE_UNSPECIFIED = 0
    FULL = 1
    METADATA = 2

  class RefreshableModeValueValuesEnum(_messages.Enum):
    r"""Optional. The refresh mode of the clone.

    Values:
      REFRESHABLE_MODE_UNSPECIFIED: Default unspecified value.
      AUTOMATIC: Automatic refresh.
      MANUAL: Manual refresh.
    """
    REFRESHABLE_MODE_UNSPECIFIED = 0
    AUTOMATIC = 1
    MANUAL = 2

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The source type of the Autonomous Database.

    Values:
      SOURCE_TYPE_UNSPECIFIED: Default unspecified value.
      CLONE_DATABASE: Clone database from an existing database specified in
        autonomous_database field.
      CROSS_REGION_DISASTER_RECOVERY: Create a cross-region disaster recovery
        peer adb from an existing adb.
      CLONE_TO_REFRESHABLE: Create a refreshable clone from an existing
        database specified in autonomous_database field.
      BACKUP_FROM_ID: Create clone from the backup resource.
      BACKUP_FROM_TIMESTAMP: Create clone from backup specified by backup_time
        field, or use latest available backup if use_latest_available_backup
        is true. The autonomous_database field must specify the source
        database to clone from.
    """
    SOURCE_TYPE_UNSPECIFIED = 0
    CLONE_DATABASE = 1
    CROSS_REGION_DISASTER_RECOVERY = 2
    CLONE_TO_REFRESHABLE = 3
    BACKUP_FROM_ID = 4
    BACKUP_FROM_TIMESTAMP = 5

  autoRefreshFrequencySeconds = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  autoRefreshPointLagSeconds = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  autoRefreshStartTime = _messages.StringField(3)
  automaticBackupsReplicationEnabled = _messages.BooleanField(4)
  autonomousDatabase = _messages.StringField(5)
  autonomousDatabaseBackup = _messages.StringField(6)
  backupTime = _messages.StringField(7)
  cloneType = _messages.EnumField('CloneTypeValueValuesEnum', 8)
  refreshableMode = _messages.EnumField('RefreshableModeValueValuesEnum', 9)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 10)
  useLatestAvailableBackup = _messages.BooleanField(11)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StartAutonomousDatabaseRequest(_messages.Message):
  r"""The request for `AutonomousDatabase.Start`."""


class StartGoldenGateDeploymentRequest(_messages.Message):
  r"""The request for `GoldenGateDeployment.Start`."""


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StopAutonomousDatabaseRequest(_messages.Message):
  r"""The request for `AutonomousDatabase.Stop`."""


class StopGoldenGateDeploymentRequest(_messages.Message):
  r"""The request for `GoldenGateDeployment.Stop`."""


class StorageSizeDetails(_messages.Message):
  r"""The initial storage size, in gigabytes, that is applicable for virtual
  machine DBSystem.

  Fields:
    dataStorageSizeInGbs: Output only. The data storage size, in gigabytes,
      that is applicable for virtual machine DBSystem.
    recoStorageSizeInGbs: Output only. The RECO/REDO storage size, in
      gigabytes, that is applicable for virtual machine DBSystem.
  """

  dataStorageSizeInGbs = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  recoStorageSizeInGbs = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class SwitchoverAutonomousDatabaseRequest(_messages.Message):
  r"""The request for `OracleDatabase.SwitchoverAutonomousDatabase`.

  Fields:
    peerAutonomousDatabase: Optional. The peer database name to switch over
      to. Required for cross-region standby, and must be omitted for in-region
      Data Guard.
  """

  peerAutonomousDatabase = _messages.StringField(1)


class SystemVersion(_messages.Message):
  r"""Details of the System version. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/SystemVersionSummary

  Fields:
    giVersion: Output only. Oracle Grid Infrastructure (GI) version.
    name: Identifier. The name of the System Version resource with the format:
      projects/{project}/locations/{location}/systemVersions/{system_version}
    shape: Output only. The Exadata shape.
    systemVersions: Output only. Compatible Exadata system versions for a
      given shape and GI version.
  """

  giVersion = _messages.StringField(1)
  name = _messages.StringField(2)
  shape = _messages.StringField(3)
  systemVersions = _messages.StringField(4, repeated=True)


class TestConnectionAssignmentError(_messages.Message):
  r"""Error details for TestGoldenGateConnectionAssignment.

  Fields:
    action: The text describing the action required to fix the issue.
    code: A short error code that defines the error, meant for programmatic
      parsing.
    issue: The text describing the root cause of the reported issue.
    message: A human-readable error message.
  """

  action = _messages.StringField(1)
  code = _messages.StringField(2)
  issue = _messages.StringField(3)
  message = _messages.StringField(4)


class TestGoldenGateConnectionAssignmentRequest(_messages.Message):
  r"""Request message for TestGoldenGateConnectionAssignment.

  Enums:
    TypeValueValuesEnum: Optional. The type of the test of the assigned
      connection. The only type actually supported is DEFAULT.

  Fields:
    type: Optional. The type of the test of the assigned connection. The only
      type actually supported is DEFAULT.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of the test of the assigned connection. The only
    type actually supported is DEFAULT.

    Values:
      TEST_TYPE_UNSPECIFIED: The default value. This value is unused.
      DEFAULT: The default connection test.
    """
    TEST_TYPE_UNSPECIFIED = 0
    DEFAULT = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class TestGoldenGateConnectionAssignmentResponse(_messages.Message):
  r"""The result of the connectivity test performed between the GoldenGate
  deployment and the associated database / service.

  Enums:
    ResultTypeValueValuesEnum: Type of the result i.e. Success, Failure or
      Timeout.

  Fields:
    error: Error details if test connection failed.
    errors: List of test connection assignment error objects.
    resultType: Type of the result i.e. Success, Failure or Timeout.
  """

  class ResultTypeValueValuesEnum(_messages.Enum):
    r"""Type of the result i.e. Success, Failure or Timeout.

    Values:
      RESULT_TYPE_UNSPECIFIED: Result type is unspecified.
      SUCCEEDED: Test connection succeeded.
      FAILED: Test connection failed.
      TIMED_OUT: Test connection timed out.
    """
    RESULT_TYPE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2
    TIMED_OUT = 3

  error = _messages.MessageField('TestConnectionAssignmentError', 1)
  errors = _messages.MessageField('TestConnectionAssignmentError', 2, repeated=True)
  resultType = _messages.EnumField('ResultTypeValueValuesEnum', 3)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of a day in 24 hour format. Must be greater than or equal to
      0 and typically must be less than or equal to 23. An API may choose to
      allow the value "24:00:00" for scenarios like business closing time.
    minutes: Minutes of an hour. Must be greater than or equal to 0 and less
      than or equal to 59.
    nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
      to 0 and less than or equal to 999,999,999.
    seconds: Seconds of a minute. Must be greater than or equal to 0 and
      typically must be less than or equal to 59. An API may allow the value
      60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class TimeZone(_messages.Message):
  r"""Represents a time zone from the [IANA Time Zone
  Database](https://www.iana.org/time-zones).

  Fields:
    id: IANA Time Zone Database time zone. For example "America/New_York".
    version: Optional. IANA Time Zone Database version number. For example
      "2019a".
  """

  id = _messages.StringField(1)
  version = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
