// src/grpc/pb/a2a_services.ts
import { BinaryReader as BinaryReader4, BinaryWriter as BinaryWriter4 } from "@bufbuild/protobuf/wire";
import {
  makeGenericClientConstructor
} from "@grpc/grpc-js";

// src/grpc/pb/google/protobuf/empty.ts
import { BinaryReader, BinaryWriter } from "@bufbuild/protobuf/wire";
function createBaseEmpty() {
  return {};
}
var Empty = {
  encode(_, writer = new BinaryWriter()) {
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseEmpty();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};

// src/grpc/pb/google/protobuf/struct.ts
import { BinaryReader as BinaryReader2, BinaryWriter as BinaryWriter2 } from "@bufbuild/protobuf/wire";
function createBaseStruct() {
  return { fields: {} };
}
var Struct = {
  encode(message, writer = new BinaryWriter2()) {
    Object.entries(message.fields).forEach(([key, value]) => {
      if (value !== void 0) {
        Struct_FieldsEntry.encode({ key, value }, writer.uint32(10).fork()).join();
      }
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader2 ? input : new BinaryReader2(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStruct();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          const entry1 = Struct_FieldsEntry.decode(reader, reader.uint32());
          if (entry1.value !== void 0) {
            message.fields[entry1.key] = entry1.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  },
  wrap(object) {
    const struct = createBaseStruct();
    if (object !== void 0) {
      for (const key of Object.keys(object)) {
        struct.fields[key] = object[key];
      }
    }
    return struct;
  },
  unwrap(message) {
    const object = {};
    if (message.fields) {
      for (const key of Object.keys(message.fields)) {
        object[key] = message.fields[key];
      }
    }
    return object;
  }
};
function createBaseStruct_FieldsEntry() {
  return { key: "", value: void 0 };
}
var Struct_FieldsEntry = {
  encode(message, writer = new BinaryWriter2()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      Value.encode(Value.wrap(message.value), writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader2 ? input : new BinaryReader2(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStruct_FieldsEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = Value.unwrap(Value.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseValue() {
  return { kind: void 0 };
}
var Value = {
  encode(message, writer = new BinaryWriter2()) {
    switch (message.kind?.$case) {
      case "nullValue":
        writer.uint32(8).int32(message.kind.value);
        break;
      case "numberValue":
        writer.uint32(17).double(message.kind.value);
        break;
      case "stringValue":
        writer.uint32(26).string(message.kind.value);
        break;
      case "boolValue":
        writer.uint32(32).bool(message.kind.value);
        break;
      case "structValue":
        Struct.encode(Struct.wrap(message.kind.value), writer.uint32(42).fork()).join();
        break;
      case "listValue":
        ListValue.encode(ListValue.wrap(message.kind.value), writer.uint32(50).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader2 ? input : new BinaryReader2(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseValue();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.kind = { $case: "nullValue", value: reader.int32() };
          continue;
        }
        case 2: {
          if (tag !== 17) {
            break;
          }
          message.kind = { $case: "numberValue", value: reader.double() };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.kind = { $case: "stringValue", value: reader.string() };
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.kind = { $case: "boolValue", value: reader.bool() };
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.kind = { $case: "structValue", value: Struct.unwrap(Struct.decode(reader, reader.uint32())) };
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.kind = { $case: "listValue", value: ListValue.unwrap(ListValue.decode(reader, reader.uint32())) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  },
  wrap(value) {
    const result = createBaseValue();
    if (value === null) {
      result.kind = { $case: "nullValue", value };
    } else if (typeof value === "boolean") {
      result.kind = { $case: "boolValue", value };
    } else if (typeof value === "number") {
      result.kind = { $case: "numberValue", value };
    } else if (typeof value === "string") {
      result.kind = { $case: "stringValue", value };
    } else if (globalThis.Array.isArray(value)) {
      result.kind = { $case: "listValue", value };
    } else if (typeof value === "object") {
      result.kind = { $case: "structValue", value };
    } else if (typeof value !== "undefined") {
      throw new globalThis.Error("Unsupported any value type: " + typeof value);
    }
    return result;
  },
  unwrap(message) {
    return message.kind?.value;
  }
};
function createBaseListValue() {
  return { values: [] };
}
var ListValue = {
  encode(message, writer = new BinaryWriter2()) {
    for (const v of message.values) {
      Value.encode(Value.wrap(v), writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader2 ? input : new BinaryReader2(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseListValue();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.values.push(Value.unwrap(Value.decode(reader, reader.uint32())));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  },
  wrap(array) {
    const result = createBaseListValue();
    result.values = array ?? [];
    return result;
  },
  unwrap(message) {
    if (message?.hasOwnProperty("values") && globalThis.Array.isArray(message.values)) {
      return message.values;
    } else {
      return message;
    }
  }
};

// src/grpc/pb/google/protobuf/timestamp.ts
import { BinaryReader as BinaryReader3, BinaryWriter as BinaryWriter3 } from "@bufbuild/protobuf/wire";
function createBaseTimestamp() {
  return { seconds: 0, nanos: 0 };
}
var Timestamp = {
  encode(message, writer = new BinaryWriter3()) {
    if (message.seconds !== 0) {
      writer.uint32(8).int64(message.seconds);
    }
    if (message.nanos !== 0) {
      writer.uint32(16).int32(message.nanos);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader3 ? input : new BinaryReader3(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTimestamp();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.seconds = longToNumber(reader.int64());
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.nanos = reader.int32();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function longToNumber(int64) {
  const num = globalThis.Number(int64.toString());
  if (num > globalThis.Number.MAX_SAFE_INTEGER) {
    throw new globalThis.Error("Value is larger than Number.MAX_SAFE_INTEGER");
  }
  if (num < globalThis.Number.MIN_SAFE_INTEGER) {
    throw new globalThis.Error("Value is smaller than Number.MIN_SAFE_INTEGER");
  }
  return num;
}

// src/grpc/pb/a2a_services.ts
function createBaseSendMessageConfiguration() {
  return { acceptedOutputModes: [], pushNotification: void 0, historyLength: 0, blocking: false };
}
var SendMessageConfiguration = {
  encode(message, writer = new BinaryWriter4()) {
    for (const v of message.acceptedOutputModes) {
      writer.uint32(10).string(v);
    }
    if (message.pushNotification !== void 0) {
      PushNotificationConfig.encode(message.pushNotification, writer.uint32(18).fork()).join();
    }
    if (message.historyLength !== 0) {
      writer.uint32(24).int32(message.historyLength);
    }
    if (message.blocking !== false) {
      writer.uint32(32).bool(message.blocking);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSendMessageConfiguration();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.acceptedOutputModes.push(reader.string());
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.pushNotification = PushNotificationConfig.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 24) {
            break;
          }
          message.historyLength = reader.int32();
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.blocking = reader.bool();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTask() {
  return { id: "", contextId: "", status: void 0, artifacts: [], history: [], metadata: void 0 };
}
var Task = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.status !== void 0) {
      TaskStatus.encode(message.status, writer.uint32(26).fork()).join();
    }
    for (const v of message.artifacts) {
      Artifact.encode(v, writer.uint32(34).fork()).join();
    }
    for (const v of message.history) {
      Message.encode(v, writer.uint32(42).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTask();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.status = TaskStatus.decode(reader, reader.uint32());
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.artifacts.push(Artifact.decode(reader, reader.uint32()));
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.history.push(Message.decode(reader, reader.uint32()));
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskStatus() {
  return { state: 0, update: void 0, timestamp: void 0 };
}
var TaskStatus = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.state !== 0) {
      writer.uint32(8).int32(message.state);
    }
    if (message.update !== void 0) {
      Message.encode(message.update, writer.uint32(18).fork()).join();
    }
    if (message.timestamp !== void 0) {
      Timestamp.encode(toTimestamp(message.timestamp), writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskStatus();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.state = reader.int32();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.update = Message.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.timestamp = fromTimestamp(Timestamp.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePart() {
  return { part: void 0 };
}
var Part = {
  encode(message, writer = new BinaryWriter4()) {
    switch (message.part?.$case) {
      case "text":
        writer.uint32(10).string(message.part.value);
        break;
      case "file":
        FilePart.encode(message.part.value, writer.uint32(18).fork()).join();
        break;
      case "data":
        DataPart.encode(message.part.value, writer.uint32(26).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePart();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.part = { $case: "text", value: reader.string() };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.part = { $case: "file", value: FilePart.decode(reader, reader.uint32()) };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.part = { $case: "data", value: DataPart.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseFilePart() {
  return { file: void 0, mimeType: "" };
}
var FilePart = {
  encode(message, writer = new BinaryWriter4()) {
    switch (message.file?.$case) {
      case "fileWithUri":
        writer.uint32(10).string(message.file.value);
        break;
      case "fileWithBytes":
        writer.uint32(18).bytes(message.file.value);
        break;
    }
    if (message.mimeType !== "") {
      writer.uint32(26).string(message.mimeType);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseFilePart();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.file = { $case: "fileWithUri", value: reader.string() };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.file = { $case: "fileWithBytes", value: Buffer.from(reader.bytes()) };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.mimeType = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseDataPart() {
  return { data: void 0 };
}
var DataPart = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.data !== void 0) {
      Struct.encode(Struct.wrap(message.data), writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseDataPart();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.data = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseMessage() {
  return { messageId: "", contextId: "", taskId: "", role: 0, content: [], metadata: void 0, extensions: [] };
}
var Message = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.messageId !== "") {
      writer.uint32(10).string(message.messageId);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.taskId !== "") {
      writer.uint32(26).string(message.taskId);
    }
    if (message.role !== 0) {
      writer.uint32(32).int32(message.role);
    }
    for (const v of message.content) {
      Part.encode(v, writer.uint32(42).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    for (const v of message.extensions) {
      writer.uint32(58).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseMessage();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.messageId = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.taskId = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.role = reader.int32();
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.content.push(Part.decode(reader, reader.uint32()));
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.extensions.push(reader.string());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseArtifact() {
  return { artifactId: "", name: "", description: "", parts: [], metadata: void 0, extensions: [] };
}
var Artifact = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.artifactId !== "") {
      writer.uint32(10).string(message.artifactId);
    }
    if (message.name !== "") {
      writer.uint32(26).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(34).string(message.description);
    }
    for (const v of message.parts) {
      Part.encode(v, writer.uint32(42).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    for (const v of message.extensions) {
      writer.uint32(58).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseArtifact();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.artifactId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.parts.push(Part.decode(reader, reader.uint32()));
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.extensions.push(reader.string());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskStatusUpdateEvent() {
  return { taskId: "", contextId: "", status: void 0, final: false, metadata: void 0 };
}
var TaskStatusUpdateEvent = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.taskId !== "") {
      writer.uint32(10).string(message.taskId);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.status !== void 0) {
      TaskStatus.encode(message.status, writer.uint32(26).fork()).join();
    }
    if (message.final !== false) {
      writer.uint32(32).bool(message.final);
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(42).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskStatusUpdateEvent();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.taskId = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.status = TaskStatus.decode(reader, reader.uint32());
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.final = reader.bool();
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskArtifactUpdateEvent() {
  return { taskId: "", contextId: "", artifact: void 0, append: false, lastChunk: false, metadata: void 0 };
}
var TaskArtifactUpdateEvent = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.taskId !== "") {
      writer.uint32(10).string(message.taskId);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.artifact !== void 0) {
      Artifact.encode(message.artifact, writer.uint32(26).fork()).join();
    }
    if (message.append !== false) {
      writer.uint32(32).bool(message.append);
    }
    if (message.lastChunk !== false) {
      writer.uint32(40).bool(message.lastChunk);
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskArtifactUpdateEvent();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.taskId = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.artifact = Artifact.decode(reader, reader.uint32());
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.append = reader.bool();
          continue;
        }
        case 5: {
          if (tag !== 40) {
            break;
          }
          message.lastChunk = reader.bool();
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePushNotificationConfig() {
  return { id: "", url: "", token: "", authentication: void 0 };
}
var PushNotificationConfig = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.url !== "") {
      writer.uint32(18).string(message.url);
    }
    if (message.token !== "") {
      writer.uint32(26).string(message.token);
    }
    if (message.authentication !== void 0) {
      AuthenticationInfo.encode(message.authentication, writer.uint32(34).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePushNotificationConfig();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.token = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.authentication = AuthenticationInfo.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAuthenticationInfo() {
  return { schemes: [], credentials: "" };
}
var AuthenticationInfo = {
  encode(message, writer = new BinaryWriter4()) {
    for (const v of message.schemes) {
      writer.uint32(10).string(v);
    }
    if (message.credentials !== "") {
      writer.uint32(18).string(message.credentials);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAuthenticationInfo();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.schemes.push(reader.string());
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.credentials = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentInterface() {
  return { url: "", transport: "" };
}
var AgentInterface = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.url !== "") {
      writer.uint32(10).string(message.url);
    }
    if (message.transport !== "") {
      writer.uint32(18).string(message.transport);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentInterface();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.transport = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCard() {
  return {
    protocolVersion: "",
    name: "",
    description: "",
    url: "",
    preferredTransport: "",
    additionalInterfaces: [],
    provider: void 0,
    version: "",
    documentationUrl: "",
    capabilities: void 0,
    securitySchemes: {},
    security: [],
    defaultInputModes: [],
    defaultOutputModes: [],
    skills: [],
    supportsAuthenticatedExtendedCard: false,
    signatures: []
  };
}
var AgentCard = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.protocolVersion !== "") {
      writer.uint32(130).string(message.protocolVersion);
    }
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.url !== "") {
      writer.uint32(26).string(message.url);
    }
    if (message.preferredTransport !== "") {
      writer.uint32(114).string(message.preferredTransport);
    }
    for (const v of message.additionalInterfaces) {
      AgentInterface.encode(v, writer.uint32(122).fork()).join();
    }
    if (message.provider !== void 0) {
      AgentProvider.encode(message.provider, writer.uint32(34).fork()).join();
    }
    if (message.version !== "") {
      writer.uint32(42).string(message.version);
    }
    if (message.documentationUrl !== "") {
      writer.uint32(50).string(message.documentationUrl);
    }
    if (message.capabilities !== void 0) {
      AgentCapabilities.encode(message.capabilities, writer.uint32(58).fork()).join();
    }
    Object.entries(message.securitySchemes).forEach(([key, value]) => {
      AgentCard_SecuritySchemesEntry.encode({ key, value }, writer.uint32(66).fork()).join();
    });
    for (const v of message.security) {
      Security.encode(v, writer.uint32(74).fork()).join();
    }
    for (const v of message.defaultInputModes) {
      writer.uint32(82).string(v);
    }
    for (const v of message.defaultOutputModes) {
      writer.uint32(90).string(v);
    }
    for (const v of message.skills) {
      AgentSkill.encode(v, writer.uint32(98).fork()).join();
    }
    if (message.supportsAuthenticatedExtendedCard !== false) {
      writer.uint32(104).bool(message.supportsAuthenticatedExtendedCard);
    }
    for (const v of message.signatures) {
      AgentCardSignature.encode(v, writer.uint32(138).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCard();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 16: {
          if (tag !== 130) {
            break;
          }
          message.protocolVersion = reader.string();
          continue;
        }
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 14: {
          if (tag !== 114) {
            break;
          }
          message.preferredTransport = reader.string();
          continue;
        }
        case 15: {
          if (tag !== 122) {
            break;
          }
          message.additionalInterfaces.push(AgentInterface.decode(reader, reader.uint32()));
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.provider = AgentProvider.decode(reader, reader.uint32());
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.version = reader.string();
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.documentationUrl = reader.string();
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.capabilities = AgentCapabilities.decode(reader, reader.uint32());
          continue;
        }
        case 8: {
          if (tag !== 66) {
            break;
          }
          const entry8 = AgentCard_SecuritySchemesEntry.decode(reader, reader.uint32());
          if (entry8.value !== void 0) {
            message.securitySchemes[entry8.key] = entry8.value;
          }
          continue;
        }
        case 9: {
          if (tag !== 74) {
            break;
          }
          message.security.push(Security.decode(reader, reader.uint32()));
          continue;
        }
        case 10: {
          if (tag !== 82) {
            break;
          }
          message.defaultInputModes.push(reader.string());
          continue;
        }
        case 11: {
          if (tag !== 90) {
            break;
          }
          message.defaultOutputModes.push(reader.string());
          continue;
        }
        case 12: {
          if (tag !== 98) {
            break;
          }
          message.skills.push(AgentSkill.decode(reader, reader.uint32()));
          continue;
        }
        case 13: {
          if (tag !== 104) {
            break;
          }
          message.supportsAuthenticatedExtendedCard = reader.bool();
          continue;
        }
        case 17: {
          if (tag !== 138) {
            break;
          }
          message.signatures.push(AgentCardSignature.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCard_SecuritySchemesEntry() {
  return { key: "", value: void 0 };
}
var AgentCard_SecuritySchemesEntry = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      SecurityScheme.encode(message.value, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCard_SecuritySchemesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = SecurityScheme.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentProvider() {
  return { url: "", organization: "" };
}
var AgentProvider = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.url !== "") {
      writer.uint32(10).string(message.url);
    }
    if (message.organization !== "") {
      writer.uint32(18).string(message.organization);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentProvider();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.organization = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCapabilities() {
  return { streaming: false, pushNotifications: false, extensions: [] };
}
var AgentCapabilities = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.streaming !== false) {
      writer.uint32(8).bool(message.streaming);
    }
    if (message.pushNotifications !== false) {
      writer.uint32(16).bool(message.pushNotifications);
    }
    for (const v of message.extensions) {
      AgentExtension.encode(v, writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCapabilities();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.streaming = reader.bool();
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.pushNotifications = reader.bool();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.extensions.push(AgentExtension.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentExtension() {
  return { uri: "", description: "", required: false, params: void 0 };
}
var AgentExtension = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.uri !== "") {
      writer.uint32(10).string(message.uri);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.required !== false) {
      writer.uint32(24).bool(message.required);
    }
    if (message.params !== void 0) {
      Struct.encode(Struct.wrap(message.params), writer.uint32(34).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentExtension();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.uri = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 24) {
            break;
          }
          message.required = reader.bool();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.params = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentSkill() {
  return { id: "", name: "", description: "", tags: [], examples: [], inputModes: [], outputModes: [], security: [] };
}
var AgentSkill = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.name !== "") {
      writer.uint32(18).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(26).string(message.description);
    }
    for (const v of message.tags) {
      writer.uint32(34).string(v);
    }
    for (const v of message.examples) {
      writer.uint32(42).string(v);
    }
    for (const v of message.inputModes) {
      writer.uint32(50).string(v);
    }
    for (const v of message.outputModes) {
      writer.uint32(58).string(v);
    }
    for (const v of message.security) {
      Security.encode(v, writer.uint32(66).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentSkill();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.tags.push(reader.string());
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.examples.push(reader.string());
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.inputModes.push(reader.string());
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.outputModes.push(reader.string());
          continue;
        }
        case 8: {
          if (tag !== 66) {
            break;
          }
          message.security.push(Security.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCardSignature() {
  return { protected: "", signature: "", header: void 0 };
}
var AgentCardSignature = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.protected !== "") {
      writer.uint32(10).string(message.protected);
    }
    if (message.signature !== "") {
      writer.uint32(18).string(message.signature);
    }
    if (message.header !== void 0) {
      Struct.encode(Struct.wrap(message.header), writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCardSignature();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.protected = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.signature = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.header = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskPushNotificationConfig() {
  return { name: "", pushNotificationConfig: void 0 };
}
var TaskPushNotificationConfig = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.pushNotificationConfig !== void 0) {
      PushNotificationConfig.encode(message.pushNotificationConfig, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskPushNotificationConfig();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.pushNotificationConfig = PushNotificationConfig.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseStringList() {
  return { list: [] };
}
var StringList = {
  encode(message, writer = new BinaryWriter4()) {
    for (const v of message.list) {
      writer.uint32(10).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStringList();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.list.push(reader.string());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSecurity() {
  return { schemes: {} };
}
var Security = {
  encode(message, writer = new BinaryWriter4()) {
    Object.entries(message.schemes).forEach(([key, value]) => {
      Security_SchemesEntry.encode({ key, value }, writer.uint32(10).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSecurity();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          const entry1 = Security_SchemesEntry.decode(reader, reader.uint32());
          if (entry1.value !== void 0) {
            message.schemes[entry1.key] = entry1.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSecurity_SchemesEntry() {
  return { key: "", value: void 0 };
}
var Security_SchemesEntry = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      StringList.encode(message.value, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSecurity_SchemesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = StringList.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSecurityScheme() {
  return { scheme: void 0 };
}
var SecurityScheme = {
  encode(message, writer = new BinaryWriter4()) {
    switch (message.scheme?.$case) {
      case "apiKeySecurityScheme":
        APIKeySecurityScheme.encode(message.scheme.value, writer.uint32(10).fork()).join();
        break;
      case "httpAuthSecurityScheme":
        HTTPAuthSecurityScheme.encode(message.scheme.value, writer.uint32(18).fork()).join();
        break;
      case "oauth2SecurityScheme":
        OAuth2SecurityScheme.encode(message.scheme.value, writer.uint32(26).fork()).join();
        break;
      case "openIdConnectSecurityScheme":
        OpenIdConnectSecurityScheme.encode(message.scheme.value, writer.uint32(34).fork()).join();
        break;
      case "mtlsSecurityScheme":
        MutualTlsSecurityScheme.encode(message.scheme.value, writer.uint32(42).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.scheme = {
            $case: "apiKeySecurityScheme",
            value: APIKeySecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.scheme = {
            $case: "httpAuthSecurityScheme",
            value: HTTPAuthSecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.scheme = {
            $case: "oauth2SecurityScheme",
            value: OAuth2SecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.scheme = {
            $case: "openIdConnectSecurityScheme",
            value: OpenIdConnectSecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.scheme = {
            $case: "mtlsSecurityScheme",
            value: MutualTlsSecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAPIKeySecurityScheme() {
  return { description: "", location: "", name: "" };
}
var APIKeySecurityScheme = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.location !== "") {
      writer.uint32(18).string(message.location);
    }
    if (message.name !== "") {
      writer.uint32(26).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAPIKeySecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.location = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseHTTPAuthSecurityScheme() {
  return { description: "", scheme: "", bearerFormat: "" };
}
var HTTPAuthSecurityScheme = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.scheme !== "") {
      writer.uint32(18).string(message.scheme);
    }
    if (message.bearerFormat !== "") {
      writer.uint32(26).string(message.bearerFormat);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseHTTPAuthSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.scheme = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.bearerFormat = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseOAuth2SecurityScheme() {
  return { description: "", flows: void 0, oauth2MetadataUrl: "" };
}
var OAuth2SecurityScheme = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.flows !== void 0) {
      OAuthFlows.encode(message.flows, writer.uint32(18).fork()).join();
    }
    if (message.oauth2MetadataUrl !== "") {
      writer.uint32(26).string(message.oauth2MetadataUrl);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseOAuth2SecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.flows = OAuthFlows.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.oauth2MetadataUrl = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseOpenIdConnectSecurityScheme() {
  return { description: "", openIdConnectUrl: "" };
}
var OpenIdConnectSecurityScheme = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.openIdConnectUrl !== "") {
      writer.uint32(18).string(message.openIdConnectUrl);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseOpenIdConnectSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.openIdConnectUrl = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseMutualTlsSecurityScheme() {
  return { description: "" };
}
var MutualTlsSecurityScheme = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseMutualTlsSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseOAuthFlows() {
  return { flow: void 0 };
}
var OAuthFlows = {
  encode(message, writer = new BinaryWriter4()) {
    switch (message.flow?.$case) {
      case "authorizationCode":
        AuthorizationCodeOAuthFlow.encode(message.flow.value, writer.uint32(10).fork()).join();
        break;
      case "clientCredentials":
        ClientCredentialsOAuthFlow.encode(message.flow.value, writer.uint32(18).fork()).join();
        break;
      case "implicit":
        ImplicitOAuthFlow.encode(message.flow.value, writer.uint32(26).fork()).join();
        break;
      case "password":
        PasswordOAuthFlow.encode(message.flow.value, writer.uint32(34).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseOAuthFlows();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.flow = {
            $case: "authorizationCode",
            value: AuthorizationCodeOAuthFlow.decode(reader, reader.uint32())
          };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.flow = {
            $case: "clientCredentials",
            value: ClientCredentialsOAuthFlow.decode(reader, reader.uint32())
          };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.flow = { $case: "implicit", value: ImplicitOAuthFlow.decode(reader, reader.uint32()) };
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.flow = { $case: "password", value: PasswordOAuthFlow.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAuthorizationCodeOAuthFlow() {
  return { authorizationUrl: "", tokenUrl: "", refreshUrl: "", scopes: {} };
}
var AuthorizationCodeOAuthFlow = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.authorizationUrl !== "") {
      writer.uint32(10).string(message.authorizationUrl);
    }
    if (message.tokenUrl !== "") {
      writer.uint32(18).string(message.tokenUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(26).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      AuthorizationCodeOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(34).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAuthorizationCodeOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.authorizationUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.tokenUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          const entry4 = AuthorizationCodeOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry4.value !== void 0) {
            message.scopes[entry4.key] = entry4.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAuthorizationCodeOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var AuthorizationCodeOAuthFlow_ScopesEntry = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAuthorizationCodeOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseClientCredentialsOAuthFlow() {
  return { tokenUrl: "", refreshUrl: "", scopes: {} };
}
var ClientCredentialsOAuthFlow = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.tokenUrl !== "") {
      writer.uint32(10).string(message.tokenUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(18).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      ClientCredentialsOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(26).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseClientCredentialsOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.tokenUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          const entry3 = ClientCredentialsOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry3.value !== void 0) {
            message.scopes[entry3.key] = entry3.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseClientCredentialsOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var ClientCredentialsOAuthFlow_ScopesEntry = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseClientCredentialsOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseImplicitOAuthFlow() {
  return { authorizationUrl: "", refreshUrl: "", scopes: {} };
}
var ImplicitOAuthFlow = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.authorizationUrl !== "") {
      writer.uint32(10).string(message.authorizationUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(18).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      ImplicitOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(26).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseImplicitOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.authorizationUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          const entry3 = ImplicitOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry3.value !== void 0) {
            message.scopes[entry3.key] = entry3.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseImplicitOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var ImplicitOAuthFlow_ScopesEntry = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseImplicitOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePasswordOAuthFlow() {
  return { tokenUrl: "", refreshUrl: "", scopes: {} };
}
var PasswordOAuthFlow = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.tokenUrl !== "") {
      writer.uint32(10).string(message.tokenUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(18).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      PasswordOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(26).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePasswordOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.tokenUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          const entry3 = PasswordOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry3.value !== void 0) {
            message.scopes[entry3.key] = entry3.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePasswordOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var PasswordOAuthFlow_ScopesEntry = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePasswordOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSendMessageRequest() {
  return { request: void 0, configuration: void 0, metadata: void 0 };
}
var SendMessageRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.request !== void 0) {
      Message.encode(message.request, writer.uint32(10).fork()).join();
    }
    if (message.configuration !== void 0) {
      SendMessageConfiguration.encode(message.configuration, writer.uint32(18).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSendMessageRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.request = Message.decode(reader, reader.uint32());
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.configuration = SendMessageConfiguration.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetTaskRequest() {
  return { name: "", historyLength: 0 };
}
var GetTaskRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.historyLength !== 0) {
      writer.uint32(16).int32(message.historyLength);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetTaskRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.historyLength = reader.int32();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCancelTaskRequest() {
  return { name: "" };
}
var CancelTaskRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCancelTaskRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetTaskPushNotificationConfigRequest() {
  return { name: "" };
}
var GetTaskPushNotificationConfigRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseDeleteTaskPushNotificationConfigRequest() {
  return { name: "" };
}
var DeleteTaskPushNotificationConfigRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseDeleteTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCreateTaskPushNotificationConfigRequest() {
  return { parent: "", configId: "", config: void 0 };
}
var CreateTaskPushNotificationConfigRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.parent !== "") {
      writer.uint32(10).string(message.parent);
    }
    if (message.configId !== "") {
      writer.uint32(18).string(message.configId);
    }
    if (message.config !== void 0) {
      TaskPushNotificationConfig.encode(message.config, writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCreateTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.parent = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.configId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.config = TaskPushNotificationConfig.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskSubscriptionRequest() {
  return { name: "" };
}
var TaskSubscriptionRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskSubscriptionRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseListTaskPushNotificationConfigRequest() {
  return { parent: "", pageSize: 0, pageToken: "" };
}
var ListTaskPushNotificationConfigRequest = {
  encode(message, writer = new BinaryWriter4()) {
    if (message.parent !== "") {
      writer.uint32(10).string(message.parent);
    }
    if (message.pageSize !== 0) {
      writer.uint32(16).int32(message.pageSize);
    }
    if (message.pageToken !== "") {
      writer.uint32(26).string(message.pageToken);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseListTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.parent = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.pageSize = reader.int32();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.pageToken = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetAgentCardRequest() {
  return {};
}
var GetAgentCardRequest = {
  encode(_, writer = new BinaryWriter4()) {
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetAgentCardRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSendMessageResponse() {
  return { payload: void 0 };
}
var SendMessageResponse = {
  encode(message, writer = new BinaryWriter4()) {
    switch (message.payload?.$case) {
      case "task":
        Task.encode(message.payload.value, writer.uint32(10).fork()).join();
        break;
      case "msg":
        Message.encode(message.payload.value, writer.uint32(18).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSendMessageResponse();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.payload = { $case: "task", value: Task.decode(reader, reader.uint32()) };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.payload = { $case: "msg", value: Message.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseStreamResponse() {
  return { payload: void 0 };
}
var StreamResponse = {
  encode(message, writer = new BinaryWriter4()) {
    switch (message.payload?.$case) {
      case "task":
        Task.encode(message.payload.value, writer.uint32(10).fork()).join();
        break;
      case "msg":
        Message.encode(message.payload.value, writer.uint32(18).fork()).join();
        break;
      case "statusUpdate":
        TaskStatusUpdateEvent.encode(message.payload.value, writer.uint32(26).fork()).join();
        break;
      case "artifactUpdate":
        TaskArtifactUpdateEvent.encode(message.payload.value, writer.uint32(34).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStreamResponse();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.payload = { $case: "task", value: Task.decode(reader, reader.uint32()) };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.payload = { $case: "msg", value: Message.decode(reader, reader.uint32()) };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.payload = { $case: "statusUpdate", value: TaskStatusUpdateEvent.decode(reader, reader.uint32()) };
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.payload = { $case: "artifactUpdate", value: TaskArtifactUpdateEvent.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseListTaskPushNotificationConfigResponse() {
  return { configs: [], nextPageToken: "" };
}
var ListTaskPushNotificationConfigResponse = {
  encode(message, writer = new BinaryWriter4()) {
    for (const v of message.configs) {
      TaskPushNotificationConfig.encode(v, writer.uint32(10).fork()).join();
    }
    if (message.nextPageToken !== "") {
      writer.uint32(18).string(message.nextPageToken);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader4 ? input : new BinaryReader4(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseListTaskPushNotificationConfigResponse();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.configs.push(TaskPushNotificationConfig.decode(reader, reader.uint32()));
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.nextPageToken = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
var A2AServiceService = {
  /**
   * Send a message to the agent. This is a blocking call that will return the
   * task once it is completed, or a LRO if requested.
   */
  sendMessage: {
    path: "/a2a.v1.A2AService/SendMessage",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(SendMessageRequest.encode(value).finish()),
    requestDeserialize: (value) => SendMessageRequest.decode(value),
    responseSerialize: (value) => Buffer.from(SendMessageResponse.encode(value).finish()),
    responseDeserialize: (value) => SendMessageResponse.decode(value)
  },
  /**
   * SendStreamingMessage is a streaming call that will return a stream of
   * task update events until the Task is in an interrupted or terminal state.
   */
  sendStreamingMessage: {
    path: "/a2a.v1.A2AService/SendStreamingMessage",
    requestStream: false,
    responseStream: true,
    requestSerialize: (value) => Buffer.from(SendMessageRequest.encode(value).finish()),
    requestDeserialize: (value) => SendMessageRequest.decode(value),
    responseSerialize: (value) => Buffer.from(StreamResponse.encode(value).finish()),
    responseDeserialize: (value) => StreamResponse.decode(value)
  },
  /** Get the current state of a task from the agent. */
  getTask: {
    path: "/a2a.v1.A2AService/GetTask",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(GetTaskRequest.encode(value).finish()),
    requestDeserialize: (value) => GetTaskRequest.decode(value),
    responseSerialize: (value) => Buffer.from(Task.encode(value).finish()),
    responseDeserialize: (value) => Task.decode(value)
  },
  /**
   * Cancel a task from the agent. If supported one should expect no
   * more task updates for the task.
   */
  cancelTask: {
    path: "/a2a.v1.A2AService/CancelTask",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(CancelTaskRequest.encode(value).finish()),
    requestDeserialize: (value) => CancelTaskRequest.decode(value),
    responseSerialize: (value) => Buffer.from(Task.encode(value).finish()),
    responseDeserialize: (value) => Task.decode(value)
  },
  /**
   * TaskSubscription is a streaming call that will return a stream of task
   * update events. This attaches the stream to an existing in process task.
   * If the task is complete the stream will return the completed task (like
   * GetTask) and close the stream.
   */
  taskSubscription: {
    path: "/a2a.v1.A2AService/TaskSubscription",
    requestStream: false,
    responseStream: true,
    requestSerialize: (value) => Buffer.from(TaskSubscriptionRequest.encode(value).finish()),
    requestDeserialize: (value) => TaskSubscriptionRequest.decode(value),
    responseSerialize: (value) => Buffer.from(StreamResponse.encode(value).finish()),
    responseDeserialize: (value) => StreamResponse.decode(value)
  },
  /** Set a push notification config for a task. */
  createTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/CreateTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(CreateTaskPushNotificationConfigRequest.encode(value).finish()),
    requestDeserialize: (value) => CreateTaskPushNotificationConfigRequest.decode(value),
    responseSerialize: (value) => Buffer.from(TaskPushNotificationConfig.encode(value).finish()),
    responseDeserialize: (value) => TaskPushNotificationConfig.decode(value)
  },
  /** Get a push notification config for a task. */
  getTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/GetTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(GetTaskPushNotificationConfigRequest.encode(value).finish()),
    requestDeserialize: (value) => GetTaskPushNotificationConfigRequest.decode(value),
    responseSerialize: (value) => Buffer.from(TaskPushNotificationConfig.encode(value).finish()),
    responseDeserialize: (value) => TaskPushNotificationConfig.decode(value)
  },
  /** Get a list of push notifications configured for a task. */
  listTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/ListTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(ListTaskPushNotificationConfigRequest.encode(value).finish()),
    requestDeserialize: (value) => ListTaskPushNotificationConfigRequest.decode(value),
    responseSerialize: (value) => Buffer.from(ListTaskPushNotificationConfigResponse.encode(value).finish()),
    responseDeserialize: (value) => ListTaskPushNotificationConfigResponse.decode(value)
  },
  /** GetAgentCard returns the agent card for the agent. */
  getAgentCard: {
    path: "/a2a.v1.A2AService/GetAgentCard",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(GetAgentCardRequest.encode(value).finish()),
    requestDeserialize: (value) => GetAgentCardRequest.decode(value),
    responseSerialize: (value) => Buffer.from(AgentCard.encode(value).finish()),
    responseDeserialize: (value) => AgentCard.decode(value)
  },
  /** Delete a push notification config for a task. */
  deleteTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/DeleteTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(DeleteTaskPushNotificationConfigRequest.encode(value).finish()),
    requestDeserialize: (value) => DeleteTaskPushNotificationConfigRequest.decode(value),
    responseSerialize: (value) => Buffer.from(Empty.encode(value).finish()),
    responseDeserialize: (value) => Empty.decode(value)
  }
};
var A2AServiceClient = makeGenericClientConstructor(A2AServiceService, "a2a.v1.A2AService");
function toTimestamp(dateStr) {
  const date = new globalThis.Date(dateStr);
  const seconds = Math.trunc(date.getTime() / 1e3);
  const nanos = date.getTime() % 1e3 * 1e6;
  return { seconds, nanos };
}
function fromTimestamp(t) {
  let millis = (t.seconds || 0) * 1e3;
  millis += (t.nanos || 0) / 1e6;
  return new globalThis.Date(millis).toISOString();
}

export {
  A2AServiceService,
  A2AServiceClient
};
