import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import {} from '@google/gemini-cli-core';
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { useKeypress } from '../hooks/useKeypress.js';
import { runExitCleanup } from '../../utils/cleanup.js';
import { RELAUNCH_EXIT_CODE } from '../../utils/processUtils.js';
export const LoginWithGoogleRestartDialog = ({ onDismiss, config, }) => {
    useKeypress((key) => {
        if (key.name === 'escape') {
            onDismiss();
            return true;
        }
        else if (key.name === 'r' || key.name === 'R') {
            setTimeout(async () => {
                if (process.send) {
                    const remoteSettings = config.getRemoteAdminSettings();
                    if (remoteSettings) {
                        process.send({
                            type: 'admin-settings-update',
                            settings: remoteSettings,
                        });
                    }
                }
                await runExitCleanup();
                process.exit(RELAUNCH_EXIT_CODE);
            }, 100);
            return true;
        }
        return false;
    }, { isActive: true });
    const message = 'You have successfully logged in with Google. Gemini CLI needs to be restarted.';
    return (_jsx(Box, { borderStyle: "round", borderColor: theme.status.warning, paddingX: 1, children: _jsxs(Text, { color: theme.status.warning, children: [message, " Press 'r' to restart, or 'escape' to choose a different auth method."] }) }));
};
//# sourceMappingURL=LoginWithGoogleRestartDialog.js.map