import { debugLogger, ExitCodes } from '@google/gemini-cli-core';
import { runExitCleanup } from './utils/cleanup.js';
import process from 'node:process';
let deferredCommand;
export function setDeferredCommand(command) {
    deferredCommand = command;
}
export async function runDeferredCommand(settings) {
    if (!deferredCommand) {
        return;
    }
    const adminSettings = settings.admin;
    const commandName = deferredCommand.commandName;
    if (commandName === 'mcp' && adminSettings?.mcp?.enabled === false) {
        debugLogger.error('Error: MCP is disabled by your admin.');
        await runExitCleanup();
        process.exit(ExitCodes.FATAL_CONFIG_ERROR);
    }
    if (commandName === 'extensions' &&
        adminSettings?.extensions?.enabled === false) {
        debugLogger.error('Error: Extensions are disabled by your admin.');
        await runExitCleanup();
        process.exit(ExitCodes.FATAL_CONFIG_ERROR);
    }
    if (commandName === 'skills' && adminSettings?.skills?.enabled === false) {
        debugLogger.error('Error: Agent skills are disabled by your admin.');
        await runExitCleanup();
        process.exit(ExitCodes.FATAL_CONFIG_ERROR);
    }
    await deferredCommand.handler(deferredCommand.argv);
    await runExitCleanup();
    process.exit(ExitCodes.SUCCESS);
}
/**
 * Wraps a command's handler to defer its execution.
 * It stores the handler and arguments in a singleton `deferredCommand` variable.
 */
export function defer(commandModule, parentCommandName) {
    return {
        ...commandModule,
        handler: (argv) => {
            setDeferredCommand({
                handler: commandModule.handler,
                argv: argv,
                commandName: parentCommandName || 'unknown',
            });
        },
    };
}
//# sourceMappingURL=deferred.js.map