import {
  HTTP_EXTENSION_HEADER
} from "../../chunk-3QDLXHKS.js";
import {
  ServerCallContext,
  UnauthenticatedUser
} from "../../chunk-F6ACNKFR.js";
import {
  Extensions
} from "../../chunk-ZX6KNMCP.js";
import {
  A2AServiceService
} from "../../chunk-QQCCX2KH.js";
import {
  FromProto,
  ToProto
} from "../../chunk-U3QAVT4H.js";
import {
  A2AError
} from "../../chunk-UHZEIZLS.js";

// src/server/grpc/grpc_service.ts
import * as grpc from "@grpc/grpc-js";
function grpcService(options) {
  const requestHandler = options.requestHandler;
  const wrapUnary = async (call, callback, parser, handler, converter) => {
    try {
      const context = await buildContext(call, options.userBuilder);
      const params = parser(call.request);
      const result = await handler(params, context);
      call.sendMetadata(buildMetadata(context));
      callback(null, converter(result));
    } catch (error) {
      callback(mapToError(error), null);
    }
  };
  const wrapStreaming = async (call, parser, handler, converter) => {
    try {
      const context = await buildContext(call, options.userBuilder);
      const params = parser(call.request);
      const stream = await handler(params, context);
      const metadata = buildMetadata(context);
      call.sendMetadata(metadata);
      for await (const responsePart of stream) {
        const response = converter(responsePart);
        call.write(response);
      }
    } catch (error) {
      call.emit("error", mapToError(error));
    } finally {
      call.end();
    }
  };
  return {
    sendMessage(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.messageSendParams,
        requestHandler.sendMessage.bind(requestHandler),
        ToProto.messageSendResult
      );
    },
    sendStreamingMessage(call) {
      return wrapStreaming(
        call,
        FromProto.messageSendParams,
        requestHandler.sendMessageStream.bind(requestHandler),
        ToProto.messageStreamResult
      );
    },
    taskSubscription(call) {
      return wrapStreaming(
        call,
        FromProto.taskIdParams,
        requestHandler.resubscribe.bind(requestHandler),
        ToProto.messageStreamResult
      );
    },
    deleteTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.deleteTaskPushNotificationConfigParams,
        requestHandler.deleteTaskPushNotificationConfig.bind(requestHandler),
        () => ({})
      );
    },
    listTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.listTaskPushNotificationConfigParams,
        requestHandler.listTaskPushNotificationConfigs.bind(requestHandler),
        ToProto.listTaskPushNotificationConfig
      );
    },
    createTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.createTaskPushNotificationConfig,
        requestHandler.setTaskPushNotificationConfig.bind(requestHandler),
        ToProto.taskPushNotificationConfig
      );
    },
    getTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.getTaskPushNotificationConfigParams,
        requestHandler.getTaskPushNotificationConfig.bind(requestHandler),
        ToProto.taskPushNotificationConfig
      );
    },
    getTask(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.taskQueryParams,
        requestHandler.getTask.bind(requestHandler),
        ToProto.task
      );
    },
    cancelTask(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.taskIdParams,
        requestHandler.cancelTask.bind(requestHandler),
        ToProto.task
      );
    },
    getAgentCard(call, callback) {
      return wrapUnary(
        call,
        callback,
        () => ({}),
        (_params, context) => requestHandler.getAuthenticatedExtendedAgentCard(context),
        ToProto.agentCard
      );
    }
  };
}
var mapping = {
  [-32001]: grpc.status.NOT_FOUND,
  [-32002]: grpc.status.FAILED_PRECONDITION,
  [-32003]: grpc.status.UNIMPLEMENTED,
  [-32004]: grpc.status.UNIMPLEMENTED,
  [-32005]: grpc.status.INVALID_ARGUMENT,
  [-32006]: grpc.status.INTERNAL,
  [-32007]: grpc.status.FAILED_PRECONDITION,
  [-32600]: grpc.status.INVALID_ARGUMENT,
  [-32602]: grpc.status.INVALID_ARGUMENT,
  [-32603]: grpc.status.INTERNAL
};
var mapToError = (error) => {
  const a2aError = error instanceof A2AError ? error : A2AError.internalError(error instanceof Error ? error.message : "Internal server error");
  return {
    code: mapping[a2aError.code] ?? grpc.status.UNKNOWN,
    details: a2aError.message
  };
};
var buildContext = async (call, userBuilder) => {
  const user = await userBuilder(call);
  const extensionHeaders = call.metadata.get(HTTP_EXTENSION_HEADER);
  const extensionString = extensionHeaders.map((v) => v.toString()).join(",");
  return new ServerCallContext(Extensions.parseServiceParameter(extensionString), user);
};
var buildMetadata = (context) => {
  const metadata = new grpc.Metadata();
  if (context.activatedExtensions?.length) {
    metadata.set(HTTP_EXTENSION_HEADER, context.activatedExtensions.join(","));
  }
  return metadata;
};

// src/server/grpc/common.ts
var UserBuilder = {
  noAuthentication: () => Promise.resolve(new UnauthenticatedUser())
};
export {
  A2AServiceService as A2AService,
  UserBuilder,
  grpcService
};
