<a href="https://agentclientprotocol.com/" >
  <img alt="Agent Client Protocol" src="https://zed.dev/img/acp/banner-dark.webp">
</a>

# ACP TypeScript Library

The official TypeScript implementation of the Agent Client Protocol (ACP) — a standardized communication protocol between code editors and AI-powered coding agents.

Learn more at https://agentclientprotocol.com

## Installation

```bash
npm install @agentclientprotocol/sdk
```

## Get Started

### Understand the Protocol

Start by reading the [official ACP documentation](https://agentclientprotocol.com) to understand the core concepts and protocol specification.

### Try the Examples

The [examples directory](https://github.com/agentclientprotocol/typescript-sdk/tree/main/src/examples) contains simple implementations of both Agents and Clients in TypeScript. These examples can be run from your terminal or from an ACP Client like [Zed](https://zed.dev), making them great starting points for your own integration!

### Explore the API

Browse the [TypeScript library reference](https://agentclientprotocol.github.io/typescript-sdk) for detailed API documentation.

If you're building an [Agent](https://agentclientprotocol.com/protocol/overview#agent), start with [AgentSideConnection](https://agentclientprotocol.github.io/typescript-sdk/classes/AgentSideConnection.html).

If you're building a [Client](https://agentclientprotocol.com/protocol/overview#client), start with [ClientSideConnection](https://agentclientprotocol.github.io/typescript-sdk/classes/ClientSideConnection.html).

### Study a Production Implementation

For a complete, production-ready implementation, check out the [Gemini CLI Agent](https://github.com/google-gemini/gemini-cli/blob/main/packages/cli/src/zed-integration/zedIntegration.ts).

## Resources

- [Library docs](https://agentclientprotocol.github.io/typescript-sdk)
- [Examples](https://github.com/agentclientprotocol/typescript-sdk/tree/main/src/examples)
- [Protocol Documentation](https://agentclientprotocol.com)
- [GitHub Repository](https://github.com/agentclientprotocol/typescript-sdk)
- [NPM Package](https://www.npmjs.com/package/@agentclientprotocol/sdk)

## Contributing

See the main [repository](https://github.com/agentclientprotocol/typescript-sdk) for contribution guidelines.

### License

By contributing, you agree that your contributions will be licensed under the Apache 2.0 License.
