# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was edencommon-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# We will generate this one cmake file that has all our targets in it. This is
# how dependent projects find our targets.
set_and_check(EDENCOMMON_CMAKE_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/edencommon")
include("${EDENCOMMON_CMAKE_DIR}/edencommon-targets.cmake")


# Here we are just printing that edencommon was found to make debugging issues
# for dependent projects easier.
if (NOT edencommon_FIND_QUIETLY)
    message(STATUS "Found edencommon: ${PACKAGE_PREFIX_DIR}")
endif()
