/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.filter.UploadRegexFilter;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.DelegateStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.normalizer.UploadRootPathsNormalizer;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.symlink.UploadSymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.CompareFilter;
import ch.cyberduck.core.transfer.upload.OverwriteFilter;
import ch.cyberduck.core.transfer.upload.RenameExistingFilter;
import ch.cyberduck.core.transfer.upload.RenameFilter;
import ch.cyberduck.core.transfer.upload.ResumeFilter;
import ch.cyberduck.core.transfer.upload.SkipFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.core.transfer.upload.UploadRegexPriorityComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UploadTransfer
extends Transfer {
    private static final Logger log = Logger.getLogger(UploadTransfer.class);
    private final Filter<Local> filter;
    private final Comparator<Local> comparator;
    private Cache<Path> cache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    private UploadFilterOptions options = new UploadFilterOptions();

    public UploadTransfer(Host host, Path root, Local local) {
        this(host, Collections.singletonList(new TransferItem(root, local)), PreferencesFactory.get().getBoolean("queue.upload.skip.enable") ? new UploadRegexFilter() : new NullFilter());
    }

    public UploadTransfer(Host host, Path root, Local local, Filter<Local> f) {
        this(host, Collections.singletonList(new TransferItem(root, local)), f);
    }

    public UploadTransfer(Host host, List<TransferItem> roots) {
        this(host, roots, PreferencesFactory.get().getBoolean("queue.upload.skip.enable") ? new UploadRegexFilter() : new NullFilter());
    }

    public UploadTransfer(Host host, List<TransferItem> roots, Filter<Local> f) {
        this(host, roots, f, new UploadRegexPriorityComparator());
    }

    public UploadTransfer(Host host, List<TransferItem> roots, Filter<Local> f, Comparator<Local> comparator) {
        super(host, roots, new BandwidthThrottle(PreferencesFactory.get().getFloat("queue.upload.bandwidth.bytes")));
        this.filter = f;
        this.comparator = comparator;
    }

    @Override
    public Transfer withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public Transfer withOptions(UploadFilterOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public Transfer.Type getType() {
        return Transfer.Type.upload;
    }

    @Override
    public List<TransferItem> list(Session<?> session, Path remote, Local directory, ListProgressListener listener) throws BackgroundException {
        Symlink symlink;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("List children for %s", directory));
        }
        if (directory.isSymbolicLink() && new UploadSymlinkResolver(symlink = session.getFeature(Symlink.class), this.roots).resolve(directory)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Do not list children for symbolic link %s", directory));
            }
            return Collections.emptyList();
        }
        ArrayList<TransferItem> children = new ArrayList<TransferItem>();
        for (Local local : directory.list().filter(this.comparator, this.filter)) {
            children.add(new TransferItem(new Path(remote, local.getName(), local.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), local));
        }
        return children;
    }

    @Override
    public AbstractUploadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Filter transfer with action %s and options %s", action, this.options));
        }
        Symlink symlink = source.getFeature(Symlink.class);
        UploadSymlinkResolver resolver = new UploadSymlinkResolver(symlink, this.roots);
        if (this.options.temporary) {
            this.options.withTemporary(source.getFeature(Write.class).temporary());
        }
        if (action.equals(TransferAction.resume)) {
            return new ResumeFilter(resolver, source, this.options).withCache((Cache)this.cache);
        }
        if (action.equals(TransferAction.rename)) {
            return new RenameFilter(resolver, source, this.options).withCache((Cache)this.cache);
        }
        if (action.equals(TransferAction.renameexisting)) {
            return new RenameExistingFilter(resolver, source, this.options).withCache((Cache)this.cache);
        }
        if (action.equals(TransferAction.skip)) {
            return new SkipFilter(resolver, source, this.options).withCache((Cache)this.cache);
        }
        if (action.equals(TransferAction.comparison)) {
            return new CompareFilter((SymlinkResolver<Local>)resolver, source, this.options, listener).withCache((Cache)this.cache);
        }
        return new OverwriteFilter(resolver, source, this.options).withCache((Cache)this.cache);
    }

    @Override
    public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find transfer action for Resume=%s,Reload=%s", resumeRequested, reloadRequested));
        }
        if (resumeRequested) {
            return TransferAction.resume;
        }
        TransferAction action = reloadRequested ? TransferAction.forName(PreferencesFactory.get().getProperty("queue.upload.reload.action")) : TransferAction.forName(PreferencesFactory.get().getProperty("queue.upload.action"));
        if (action.equals(TransferAction.callback)) {
            for (TransferItem upload : this.roots) {
                Upload write = source.getFeature(Upload.class);
                Write.Append append = write.append(upload.remote, upload.local.attributes().getSize(), this.cache);
                if (!append.override && !append.append || upload.remote.isDirectory() && this.list(source, upload.remote, upload.local, listener).isEmpty()) continue;
                return prompt.prompt(upload);
            }
            return TransferAction.overwrite;
        }
        return action;
    }

    @Override
    public void pre(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Bulk feature = source.getFeature(Bulk.class);
        Object id = feature.withCache(this.cache).pre(Transfer.Type.upload, files, callback);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Obtained bulk id %s for transfer %s", id, this));
        }
        super.pre(source, destination, files, callback);
    }

    @Override
    public void post(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Bulk feature = source.getFeature(Bulk.class);
        feature.post(Transfer.Type.upload, files, callback);
        super.post(source, destination, files, callback);
    }

    @Override
    public void transfer(Session<?> source, Session<?> destination, Path file, Local local, TransferOptions options, TransferStatus overall, TransferStatus segment, ConnectionCallback connectionCallback, ProgressListener listener, StreamListener streamListener) throws BackgroundException {
        Object feature;
        UploadSymlinkResolver symlinkResolver;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Transfer file %s with options %s", file, options));
        }
        if (local.isSymbolicLink() && (symlinkResolver = new UploadSymlinkResolver((Symlink)(feature = source.getFeature(Symlink.class)), this.roots)).resolve(local)) {
            String target = symlinkResolver.relativize(local.getAbsolute(), local.getSymlinkTarget().getAbsolute());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create symbolic link from %s to %s", file, target));
            }
            feature.symlink(file, target);
            return;
        }
        if (file.isFile()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), file.getName()));
            Upload upload = source.getFeature(Upload.class);
            Object Reply = upload.upload(file, local, this.bandwidth, new UploadStreamListener(this, streamListener), segment, connectionCallback);
        } else if (file.isDirectory() && !segment.isExists()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Making directory {0}", "Status"), file.getName()));
            feature = source.getFeature(Directory.class);
            feature.mkdir(file, null, segment);
            segment.setComplete();
        }
    }

    @Override
    public void normalize() {
        List<TransferItem> normalized = new UploadRootPathsNormalizer().normalize(this.roots);
        this.roots.clear();
        this.roots.addAll(normalized);
    }

    @Override
    public void stop() {
        this.cache.clear();
        super.stop();
    }

    private static final class UploadStreamListener
    extends DelegateStreamListener {
        private final UploadTransfer transfer;

        public UploadStreamListener(UploadTransfer transfer, StreamListener delegate) {
            super(delegate);
            this.transfer = transfer;
        }

        @Override
        public void sent(long bytes) {
            this.transfer.addTransferred(bytes);
            super.sent(bytes);
        }
    }
}

