/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.threading.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ScheduledThreadPool {
    private static final Logger log = Logger.getLogger(ScheduledThreadPool.class);
    private final ScheduledExecutorService pool = Executors.newScheduledThreadPool(1, new NamedThreadFactory("timer"));

    public ScheduledFuture repeat(Runnable runnable, Long period, TimeUnit unit) {
        return this.pool.scheduleAtFixedRate(runnable, 0L, period, unit);
    }

    public ScheduledFuture schedule(Runnable runnable, Long delay, TimeUnit unit) {
        return this.pool.schedule(runnable, (long)delay, unit);
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Shutdown pool %s", this.pool));
        }
        this.pool.shutdownNow();
    }
}

