/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.editor.AbstractEditor;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.core.worker.SingleTransferWorker;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.log4j.Logger;

public class EditSaveWorker
extends Worker<Transfer> {
    private static final Logger log = Logger.getLogger(EditSaveWorker.class);
    private final AbstractEditor editor;
    private final Transfer upload;
    private final TransferErrorCallback callback;
    private final NotificationService notification;
    private final ProgressListener listener;

    public EditSaveWorker(Host bookmark, AbstractEditor editor, TransferErrorCallback callback, ProgressListener listener, NotificationService notification) {
        this.editor = editor;
        this.callback = callback;
        this.notification = notification;
        this.upload = new UploadTransfer(bookmark, editor.getRemote(), editor.getLocal(), new NullFilter()){

            @Override
            public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) {
                return TransferAction.overwrite;
            }

            @Override
            public AbstractUploadFilter filter(Session<?> session, Session<?> destination, TransferAction action, ProgressListener listener) {
                return ((AbstractUploadFilter)super.filter((Session)session, (Session)destination, action, listener)).withOptions(new UploadFilterOptions().withTemporary(PreferencesFactory.get().getBoolean("queue.upload.file.temporary")).withPermission(PreferencesFactory.get().getBoolean("editor.upload.permissions.change")));
            }
        };
        this.listener = listener;
    }

    @Override
    public Transfer run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run upload action for editor %s", this.editor));
        }
        SingleTransferWorker worker = new SingleTransferWorker(session, session, this.upload, new TransferOptions(), new TransferSpeedometer(this.upload), new DisabledTransferPrompt(), this.callback, this.listener, new DisabledStreamListener(), new DisabledLoginCallback(), this.notification);
        worker.run((Session)session);
        if (!this.upload.isComplete()) {
            log.warn((Object)String.format("File size changed for %s", this.editor.getRemote()));
        } else {
            this.editor.getRemote().attributes().setSize(this.upload.getTransferred());
        }
        return this.upload;
    }

    @Override
    public void cleanup(Transfer upload) {
        this.editor.setModified(false);
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), this.editor.getRemote().getName());
    }

    @Override
    public Transfer initialize() {
        return this.upload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditSaveWorker that = (EditSaveWorker)o;
        return Objects.equals(this.editor, that.editor);
    }

    public int hashCode() {
        return this.editor != null ? this.editor.hashCode() : 0;
    }
}

