/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;

public class LimitedListProgressListener
implements ListProgressListener {
    private final Preferences preferences = PreferencesFactory.get();
    private Integer container = this.preferences.getInteger("browser.list.limit.container");
    private Integer directory = this.preferences.getInteger("browser.list.limit.directory");
    private final ProgressListener delegate;

    public LimitedListProgressListener(ProgressListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void message(String message) {
        this.delegate.message(message);
    }

    @Override
    public void chunk(Path folder, AttributedList<Path> list) throws ListCanceledException {
        if (folder.isRoot() && list.size() >= this.container) {
            this.container = this.container + this.preferences.getInteger("browser.list.limit.container");
            throw new ListCanceledException(list);
        }
        if (list.size() >= this.directory) {
            this.directory = this.directory + this.preferences.getInteger("browser.list.limit.directory");
            throw new ListCanceledException(list);
        }
    }

    @Override
    public ListProgressListener reset() {
        return this;
    }

    protected void disable() {
        this.preferences.setProperty("browser.list.limit.directory", Integer.MAX_VALUE);
        this.preferences.setProperty("browser.list.limit.container", Integer.MAX_VALUE);
    }
}

