/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.cocoa;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGFloat
extends Number
implements NativeMapped {
    public static final int SIZE = Native.LONG_SIZE;
    private final double value;

    public CGFloat() {
        this.value = 0.0;
    }

    public CGFloat(double d) {
        this.value = d;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object other) {
        return other instanceof CGFloat && Double.doubleToLongBits(((CGFloat)other).value) == Double.doubleToLongBits(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Object fromNative(Object o, FromNativeContext fromNativeContext) {
        switch (SIZE) {
            case 4: {
                return new CGFloat(((Float)o).floatValue());
            }
            case 8: {
                return new CGFloat((Double)o);
            }
        }
        throw new Error("Unknown Native.LONG_SIZE: " + SIZE);
    }

    public Object toNative() {
        switch (SIZE) {
            case 4: {
                return Float.valueOf(this.floatValue());
            }
            case 8: {
                return this.doubleValue();
            }
        }
        throw new Error("Unknown Native.LONG_SIZE: " + SIZE);
    }

    public Class<?> nativeType() {
        switch (SIZE) {
            case 4: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
        }
        throw new Error("Unknown Native.LONG_SIZE: " + SIZE);
    }
}

