/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.blobstrategy;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.GetJobChunksReadyForClientProcessingSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetJobChunksReadyForClientProcessingSpectraS3Response;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.AbstractBlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import java.io.IOException;
import javax.annotation.Nullable;

public class GetSequentialBlobStrategy
extends AbstractBlobStrategy {
    public GetSequentialBlobStrategy(Ds3Client client, MasterObjectList masterObjectList, EventDispatcher eventDispatcher, ChunkAttemptRetryBehavior retryBehavior, ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior) {
        super(client, masterObjectList, eventDispatcher, retryBehavior, chunkAttemptRetryDelayBehavior);
    }

    @Override
    public synchronized Iterable<JobPart> getWork() throws IOException, InterruptedException {
        MasterObjectList masterObjectListWithAvailableChunks = this.masterObjectListWithAvailableChunks();
        FluentIterable chunks = FluentIterable.from(masterObjectListWithAvailableChunks.getObjects());
        return chunks.transformAndConcat((Function)new Function<Objects, Iterable<? extends JobPart>>(){

            @Nullable
            public Iterable<? extends JobPart> apply(@Nullable Objects chunk) {
                return FluentIterable.from(chunk.getObjects()).transform((Function)new Function<BulkObject, JobPart>(){

                    @Nullable
                    public JobPart apply(@Nullable BulkObject blob) {
                        return new JobPart(GetSequentialBlobStrategy.this.client(), blob);
                    }
                });
            }
        });
    }

    private MasterObjectList masterObjectListWithAvailableChunks() throws IOException, InterruptedException {
        block4: while (true) {
            GetJobChunksReadyForClientProcessingSpectraS3Response availableJobChunks = this.client().getJobChunksReadyForClientProcessingSpectraS3(new GetJobChunksReadyForClientProcessingSpectraS3Request(this.masterObjectList().getJobId().toString()));
            switch (availableJobChunks.getStatus()) {
                case AVAILABLE: {
                    this.retryBehavior().reset();
                    return availableJobChunks.getMasterObjectListResult();
                }
                case RETRYLATER: {
                    this.retryBehavior().invoke();
                    this.chunkAttemptRetryDelayBehavior().delay(availableJobChunks.getRetryAfterSeconds());
                    continue block4;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)"This line of code should be impossible to hit.");
    }

    @Override
    public void blobCompleted(BulkObject bulkObject) {
    }
}

