/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyNodeSpectraS3Request
extends AbstractRequest {
    private final String node;
    private String dnsName;
    private String name;

    public ModifyNodeSpectraS3Request(String node) {
        this.node = node;
    }

    public ModifyNodeSpectraS3Request withDnsName(String dnsName) {
        this.dnsName = dnsName;
        this.updateQueryParam("dns_name", dnsName);
        return this;
    }

    public ModifyNodeSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/node/" + this.node;
    }

    public String getNode() {
        return this.node;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getName() {
        return this.name;
    }
}

