/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ModifyBucketSpectraS3Request
extends AbstractRequest {
    private final String bucketName;
    private String dataPolicyId;
    private String userId;

    public ModifyBucketSpectraS3Request(String bucketName) {
        this.bucketName = bucketName;
    }

    public ModifyBucketSpectraS3Request withDataPolicyId(UUID dataPolicyId) {
        this.dataPolicyId = dataPolicyId.toString();
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ModifyBucketSpectraS3Request withDataPolicyId(String dataPolicyId) {
        this.dataPolicyId = dataPolicyId;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ModifyBucketSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ModifyBucketSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket/" + this.bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public String getUserId() {
        return this.userId;
    }
}

