/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetBulkJobSpectraS3Response;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetBulkJobSpectraS3ResponseParser
extends AbstractResponseParser<GetBulkJobSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetBulkJobSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    if (ResponseParserUtils.getSizeFromHeaders(response.getHeaders()) == 0L) {
                        return new GetBulkJobSpectraS3Response(null, this.getChecksum(), this.getChecksumType());
                    }
                    try (InputStream inputStream = response.getResponseStream();){
                        MasterObjectList result = XmlOutput.fromXml(inputStream, MasterObjectList.class);
                        GetBulkJobSpectraS3Response getBulkJobSpectraS3Response = new GetBulkJobSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getBulkJobSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

