/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class CompleteBlobRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final String blob;
    private final String job;
    private long size;

    public CompleteBlobRequest(String bucketName, String objectName, UUID blob, UUID job) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.blob = blob.toString();
        this.job = job.toString();
        this.updateQueryParam("blob", blob);
        this.updateQueryParam("job", job);
    }

    public CompleteBlobRequest(String bucketName, String objectName, String blob, String job) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.blob = blob;
        this.job = job;
        this.updateQueryParam("blob", blob);
        this.updateQueryParam("job", job);
    }

    public CompleteBlobRequest withSize(long size) {
        this.size = size;
        this.updateQueryParam("size", size);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getBlob() {
        return this.blob;
    }

    public String getJob() {
        return this.job;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

