/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphPromptUrlProvider
implements PromptUrlProvider {
    private final GraphSession session;

    public GraphPromptUrlProvider(GraphSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        if (PromptUrlProvider.Type.download == type) {
            return this.session.isAccessible(file, true);
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        DriveItem item = this.session.toItem(file);
        try {
            return new DescriptiveUrl(URI.create(Files.createSharedLink((DriveItem)item, (OneDriveSharingLink.Type)OneDriveSharingLink.Type.VIEW).getLink().getWebUrl()), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
        catch (IllegalArgumentException e) {
            throw new DefaultExceptionMappingService().map("Failed creating download url", (Throwable)e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        return DescriptiveUrl.EMPTY;
    }
}

