/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import java.lang.ref.WeakReference;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;

public class PoolStatsMBean
implements DynamicMBean {
    private static final MBeanAttributeInfo[] M_BEAN_ATTRIBUTES_INFO = new MBeanAttributeInfo[]{new MBeanAttributeInfo("leased", Integer.class.getName(), "The number of persistent connections", true, false, false), new MBeanAttributeInfo("pending", Integer.class.getName(), "The number of connection requests being blocked awaiting a free connection", true, false, false), new MBeanAttributeInfo("available", Integer.class.getName(), "The number of idle persistent connections", true, false, false), new MBeanAttributeInfo("max", Integer.class.getName(), "The maximum number of allowed persistent connections", true, false, false)};
    private static final MBeanConstructorInfo[] M_BEAN_CONSTRUCTOR_INFO = new MBeanConstructorInfo[]{new MBeanConstructorInfo("PoolingHttpClientConnectionManagerConstructor", "Constructs a new instance based on a connection factory", new MBeanParameterInfo[]{new MBeanParameterInfo("PoolingHttpClientConnectionManager", PoolingHttpClientConnectionManager.class.getName(), "PoolingHttpClientConnectionManager instance")})};
    private static final MBeanInfo M_BEAN_INFO = new MBeanInfo(PoolStats.class.getName(), "Java Manta SDK HTTP Connection Pool Statistics", M_BEAN_ATTRIBUTES_INFO, M_BEAN_CONSTRUCTOR_INFO, new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    public static final int NO_OF_PROPERTIES = 4;
    private PoolStats stats;
    private final WeakReference<PoolingHttpClientConnectionManager> connectionManagerRef;

    PoolStatsMBean(PoolingHttpClientConnectionManager connectionManager) {
        this.connectionManagerRef = new WeakReference<PoolingHttpClientConnectionManager>(connectionManager);
        this.updatePoolStats();
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.updatePoolStats();
        Integer result = PoolStatsMBean.getAttributeFromPoolStats(attribute, this.stats);
        if (result == null) {
            String msg = String.format("Can't find MBean attribute: %s", attribute);
            throw new AttributeNotFoundException(msg);
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException("Not supported");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        this.updatePoolStats();
        AttributeList list = new AttributeList(4);
        for (String a : attributes) {
            Integer result = PoolStatsMBean.getAttributeFromPoolStats(a, this.stats);
            if (result == null) continue;
            list.add(result);
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return M_BEAN_INFO;
    }

    private void updatePoolStats() {
        if (this.connectionManagerRef.isEnqueued()) {
            return;
        }
        PoolingHttpClientConnectionManager manager = (PoolingHttpClientConnectionManager)this.connectionManagerRef.get();
        if (manager != null) {
            this.stats = manager.getTotalStats();
        }
    }

    private static Integer getAttributeFromPoolStats(String attribute, PoolStats stats) {
        switch (attribute) {
            case "leased": {
                return stats.getLeased();
            }
            case "pending": {
                return stats.getPending();
            }
            case "available": {
                return stats.getAvailable();
            }
            case "max": {
                return stats.getMax();
            }
        }
        return null;
    }
}

