/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.codahale.metrics.Meter;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.MantaClientMetricConfiguration;
import com.joyent.manta.http.HttpContextRetryCancellation;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.Validate;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler
implements HttpContextRetryCancellation {
    private final Logger logger = LoggerFactory.getLogger(MantaHttpRequestRetryHandler.class);
    protected static final List<Class<? extends IOException>> NON_RETRIABLE = Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class);
    @Deprecated
    public static final String CONTEXT_ATTRIBUTE_MANTA_RETRY_DISABLE = "manta.retry.disable";
    public static final String METRIC_NAME_RETRIES = "retries";
    private final Meter retries;

    @Deprecated
    public MantaHttpRequestRetryHandler(ConfigContext config) {
        this(((ConfigContext)Validate.notNull((Object)config)).getRetries(), null);
    }

    public MantaHttpRequestRetryHandler(int retryCount) {
        this(retryCount, null);
    }

    public MantaHttpRequestRetryHandler(int retryCount, MantaClientMetricConfiguration metricConfig) {
        super(retryCount, true, NON_RETRIABLE);
        this.retries = metricConfig != null && metricConfig.getRegistry() != null ? metricConfig.getRegistry().meter(METRIC_NAME_RETRIES) : null;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Validate.notNull((Object)context, (String)"HTTP context cannot be null", (Object[])new Object[0]);
        if (this.neverRetry(context)) {
            return false;
        }
        boolean toBeRetried = super.retryRequest(exception, executionCount, context);
        if (this.logger.isDebugEnabled()) {
            if (toBeRetried) {
                String msg = String.format("Request failed, %d/%d retry.", executionCount, this.getRetryCount());
                this.logger.debug(msg, (Throwable)exception);
            } else {
                this.logger.debug("Request failed, unable to retry.", (Throwable)exception);
            }
        }
        if (toBeRetried && this.retries != null) {
            this.retries.mark();
        }
        return toBeRetried;
    }
}

