/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.exception.MantaClientException;
import com.joyent.manta.exception.MantaResourceCloseException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaConnectionFactory;
import com.joyent.manta.http.MantaHttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class MantaSeekableByteChannel
extends InputStream
implements SeekableByteChannel {
    private static final int EOF = -1;
    private static final long UNKNOWN_CONTENT_LENGTH = -1L;
    private volatile boolean open = true;
    private final String path;
    private AtomicLong position;
    private final HttpHelper httpHelper;
    private final AtomicReference<HttpUriRequest> requestRef;
    private final AtomicReference<MantaObjectInputStream> responseStream;

    @Deprecated
    public MantaSeekableByteChannel(String path, long position, MantaConnectionFactory connectionFactory, HttpHelper httpHelper) {
        this.path = path;
        this.position = new AtomicLong(position);
        this.httpHelper = httpHelper;
        this.requestRef = new AtomicReference();
        this.responseStream = new AtomicReference();
    }

    @Deprecated
    public MantaSeekableByteChannel(String path, MantaConnectionFactory connectionFactory, HttpHelper httpHelper) {
        this(path, 0L, connectionFactory, httpHelper);
    }

    @Deprecated
    protected MantaSeekableByteChannel(AtomicReference<HttpUriRequest> requestRef, AtomicReference<MantaObjectInputStream> responseStream, String path, AtomicLong position, MantaConnectionFactory connectionFactory, HttpHelper httpHelper) {
        this.requestRef = requestRef;
        this.responseStream = responseStream;
        this.path = path;
        this.position = position;
        this.httpHelper = httpHelper;
    }

    public MantaSeekableByteChannel(String path, long position, HttpHelper httpHelper) {
        this.path = path;
        this.position = new AtomicLong(position);
        this.httpHelper = httpHelper;
        this.requestRef = new AtomicReference();
        this.responseStream = new AtomicReference();
    }

    public MantaSeekableByteChannel(String path, HttpHelper httpHelper) {
        this(path, 0L, httpHelper);
    }

    protected MantaSeekableByteChannel(AtomicReference<HttpUriRequest> requestRef, AtomicReference<MantaObjectInputStream> responseStream, String path, AtomicLong position, HttpHelper httpHelper) {
        this.requestRef = requestRef;
        this.responseStream = responseStream;
        this.path = path;
        this.position = position;
        this.httpHelper = httpHelper;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        long size = this.size();
        if (this.position.get() >= size) {
            return -1;
        }
        byte[] buff = dst.array();
        int bytesRead = stream.read(buff);
        this.position.addAndGet(bytesRead);
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        int read = stream.read();
        if (read > -1) {
            this.position.incrementAndGet();
        }
        return read;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        int totalRead = stream.read(buffer);
        if (totalRead > -1) {
            this.position.addAndGet(totalRead);
        }
        return totalRead;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        int totalRead = stream.read(buffer, offset, length);
        if (totalRead > -1) {
            this.position.addAndGet(totalRead);
        }
        return totalRead;
    }

    @Override
    public long skip(long noOfBytesToSkip) throws IOException {
        if (!this.open) {
            return 0L;
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        long totalSkipped = stream.skip(noOfBytesToSkip);
        this.position.addAndGet(totalSkipped);
        return totalSkipped;
    }

    @Override
    public int available() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        return stream.available();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public long position() throws IOException {
        return this.position.get();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return new MantaSeekableByteChannel(new AtomicReference<HttpUriRequest>(), new AtomicReference<MantaObjectInputStream>(), this.path, new AtomicLong(newPosition), this.httpHelper);
    }

    @Override
    public long size() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        MantaObjectInputStream stream = this.connectOrGetResponse();
        long contentLength = stream.getContentLength();
        if (contentLength == -1L) {
            MantaClientException e = new MantaClientException("Can't get SeekableByteChannel for objects of unknown size");
            HttpUriRequest request = this.requestRef.get();
            if (request != null) {
                HttpResponse response = (HttpResponse)stream.getHttpResponse();
                HttpHelper.annotateContextedException((ExceptionContext)e, (HttpRequest)request, response);
            }
            throw e;
        }
        return contentLength;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public SeekableByteChannel truncate(long newSize) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.open) {
            return;
        }
        MantaObjectInputStream stream = this.responseStream.getAndSet(null);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            String msg = "Problem closing response stream";
            throw new MantaResourceCloseException(msg, e);
        }
        this.open = false;
    }

    protected synchronized MantaObjectInputStream connectOrGetResponse() throws IOException {
        if (this.responseStream.get() != null) {
            return this.responseStream.get();
        }
        HttpGet request = this.httpHelper.getRequestFactory().get(this.path);
        MantaHttpHeaders headers = new MantaHttpHeaders();
        headers.setRange(String.format("bytes=%d-", this.position.get()));
        this.requestRef.set((HttpUriRequest)request);
        MantaObjectInputStream stream = this.httpHelper.httpRequestAsInputStream((HttpUriRequest)request, headers);
        this.responseStream.compareAndSet(null, stream);
        String contentType = stream.getContentType();
        if ("application/x-json-stream; type=directory".equals(contentType)) {
            MantaClientException e = new MantaClientException("Can't get SeekableByteChannel for directory objects");
            HttpResponse response = (HttpResponse)stream.getHttpResponse();
            HttpHelper.annotateContextedException((ExceptionContext)e, (HttpRequest)request, response);
            throw e;
        }
        return stream;
    }
}

