/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.joyent.manta.client.FindForkJoinPoolFactory;
import com.joyent.manta.client.MantaClientAgent;
import com.joyent.manta.client.MantaDirectoryListingIterator;
import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.client.MantaObjectConversionFunction;
import com.joyent.manta.client.MantaObjectDepthComparator;
import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.MantaObjectMapper;
import com.joyent.manta.client.MantaObjectOutputStream;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.client.MantaSeekableByteChannel;
import com.joyent.manta.client.PruneEmptyParentDirectoryStrategy;
import com.joyent.manta.client.RecursiveDirectoryCreationStrategy;
import com.joyent.manta.client.StringIteratorHttpContent;
import com.joyent.manta.client.UriSigner;
import com.joyent.manta.client.crypto.ExternalSecurityProviderLoader;
import com.joyent.manta.client.jobs.MantaJob;
import com.joyent.manta.client.jobs.MantaJobBuilder;
import com.joyent.manta.client.jobs.MantaJobError;
import com.joyent.manta.config.AuthAwareConfigContext;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.MantaClientMetricConfiguration;
import com.joyent.manta.config.MetricReporterMode;
import com.joyent.manta.exception.MantaClientException;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaErrorCode;
import com.joyent.manta.exception.MantaException;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.exception.MantaJobException;
import com.joyent.manta.exception.MantaNoHttpResponseException;
import com.joyent.manta.exception.OnCloseAggregateException;
import com.joyent.manta.http.ContentTypeLookup;
import com.joyent.manta.http.EncryptionHttpHelper;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaApacheHttpClientContext;
import com.joyent.manta.http.MantaConnectionContext;
import com.joyent.manta.http.MantaConnectionFactory;
import com.joyent.manta.http.MantaConnectionFactoryConfigurator;
import com.joyent.manta.http.MantaContentTypes;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.http.MantaHttpRequestFactory;
import com.joyent.manta.http.StandardHttpHelper;
import com.joyent.manta.http.entity.ExposedByteArrayEntity;
import com.joyent.manta.http.entity.ExposedStringEntity;
import com.joyent.manta.util.ConcurrentWeakIdentityHashMap;
import com.joyent.manta.util.MantaUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaClient
implements AutoCloseable {
    public static final String SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(MantaClient.class);
    private static final String[] ILLEGAL_METADATA_HEADERS = new String[]{"Content-Length", "Content-MD5", "Durability-Level"};
    private static final int MAX_RESULTS = 1024;
    private final UUID clientId;
    private volatile boolean closed = false;
    private final HttpHelper httpHelper;
    private final AuthAwareConfigContext config;
    private final Set<AutoCloseable> danglingStreams = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());
    private final ForkJoinPool findForkJoinPool;
    private final MantaClientAgent agent;

    public MantaClient(ConfigContext config) {
        this(config, null);
    }

    public MantaClient(ConfigContext config, MantaConnectionFactoryConfigurator connectionFactoryConfigurator) {
        this(config, connectionFactoryConfigurator, null, null);
    }

    public MantaClient(ConfigContext config, MantaConnectionFactoryConfigurator connectionFactoryConfigurator, MantaClientMetricConfiguration metricConfiguration) {
        this(config, connectionFactoryConfigurator, null, metricConfiguration);
    }

    MantaClient(ConfigContext config, MantaConnectionFactoryConfigurator connectionFactoryConfigurator, HttpHelper httpHelper, MantaClientMetricConfiguration metricConfiguration) {
        boolean metricsEnabled;
        MantaClient.dumpConfig(config);
        ConfigContext.validate(config);
        this.clientId = UUID.randomUUID();
        this.config = config instanceof AuthAwareConfigContext ? (AuthAwareConfigContext)config : new AuthAwareConfigContext(config);
        boolean bl = metricsEnabled = this.config.getMetricReporterMode() != null && !this.config.getMetricReporterMode().equals((Object)MetricReporterMode.DISABLED);
        MantaClientMetricConfiguration metricConfig = metricConfiguration != null ? metricConfiguration : (metricsEnabled ? new MantaClientMetricConfiguration(this.clientId, new MetricRegistry(), config.getMetricReporterMode(), config.getMetricReporterOutputInterval()) : null);
        MantaConnectionFactory connectionFactory = new MantaConnectionFactory(config, connectionFactoryConfigurator, metricConfig);
        MantaApacheHttpClientContext connectionContext = new MantaApacheHttpClientContext(connectionFactory, metricConfig);
        MantaHttpRequestFactory requestFactory = new MantaHttpRequestFactory(this.config);
        this.httpHelper = httpHelper != null ? httpHelper : (BooleanUtils.isTrue((Boolean)this.config.isClientEncryptionEnabled()) ? new EncryptionHttpHelper((MantaConnectionContext)connectionContext, requestFactory, config) : new StandardHttpHelper(connectionContext, requestFactory, (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{config.verifyUploads(), true}), config.downloadContinuations()));
        if (metricConfig != null) {
            this.agent = new MantaClientAgent(metricConfig);
            this.agent.register(this.config);
        } else {
            this.agent = null;
        }
        this.findForkJoinPool = FindForkJoinPoolFactory.getInstance(config);
    }

    private static void dumpConfig(ConfigContext context) {
        if (context == null) {
            System.out.println("========================================");
            System.out.println("Configuration Context was null");
            System.out.println("========================================");
            return;
        }
        String dumpConfigVal = System.getProperty("manta.dumpConfig");
        if (dumpConfigVal != null && MantaUtils.parseBooleanOrNull(dumpConfigVal).booleanValue()) {
            System.out.println("========================================");
            System.out.println(ConfigContext.toString(context));
            System.out.println("========================================");
        }
    }

    private ContentType assignContentType(MantaHttpHeaders headers, String path, File file) throws IOException {
        if (BooleanUtils.isTrue((Boolean)this.config.isContentTypeDetectionEnabled())) {
            return ContentTypeLookup.findOrDefaultContentType(headers, path, file, ContentType.APPLICATION_OCTET_STREAM);
        }
        return ContentType.APPLICATION_OCTET_STREAM;
    }

    private ContentType assignContentType(MantaHttpHeaders headers, String path) {
        Validate.notBlank((CharSequence)path, (String)"path must not be blank", (Object[])new Object[0]);
        if (BooleanUtils.isTrue((Boolean)this.config.isContentTypeDetectionEnabled())) {
            return ContentTypeLookup.findOrDefaultContentType(headers, path, ContentType.APPLICATION_OCTET_STREAM);
        }
        return ContentType.APPLICATION_OCTET_STREAM;
    }

    public ConfigContext getContext() {
        return this.config;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void delete(String rawPath) throws IOException {
        this.delete(rawPath, null);
    }

    public void delete(String rawPath, MantaHttpHeaders requestHeaders) throws IOException {
        this.delete(rawPath, requestHeaders, this.config.getPruneEmptyParentDepth());
    }

    public void delete(String rawPath, MantaHttpHeaders requestHeaders, Integer pruneDepth) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        if (pruneDepth == null || pruneDepth == 0) {
            LOG.debug("DELETE {}", (Object)path);
            this.httpHelper.httpDelete(path, requestHeaders);
        } else {
            PruneEmptyParentDirectoryStrategy.pruneParentDirectories(this, requestHeaders, path, pruneDepth);
        }
    }

    public void deleteRecursive(String path) throws IOException {
        LOG.debug("DELETE {} [recursive]", (Object)path);
        int loops = 0;
        AtomicInteger responseTimeouts = new AtomicInteger(0);
        while (true) {
            ++loops;
            Stream<MantaObject> toDelete = this.find(path).map(obj -> {
                if (obj.isDirectory()) {
                    return obj;
                }
                try {
                    this.delete(obj.getPath());
                }
                catch (MantaClientHttpResponseException e) {
                    if (!e.getServerCode().equals((Object)MantaErrorCode.RESOURCE_NOT_FOUND_ERROR)) {
                        throw new UncheckedIOException(e);
                    }
                }
                catch (ConnectionPoolTimeoutException e) {
                    responseTimeouts.incrementAndGet();
                    LOG.debug("{} for deleting object {}", (Object)e.getMessage(), (Object)obj.getPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                obj.getHttpHeaders().put("deleted", (Object)true);
                return obj;
            }).sorted(MantaObjectDepthComparator.INSTANCE);
            toDelete.forEachOrdered(obj -> {
                for (int i = 0; i < this.config.getRetries(); ++i) {
                    try {
                        if (obj.getHttpHeaders().containsKey("deleted")) break;
                        this.delete(obj.getPath());
                        LOG.trace("Finished deleting path {}", (Object)obj.getPath());
                        break;
                    }
                    catch (MantaClientHttpResponseException e) {
                        if (e.getServerCode().equals((Object)MantaErrorCode.RESOURCE_NOT_FOUND_ERROR)) break;
                        if (e.getServerCode().equals((Object)MantaErrorCode.DIRECTORY_NOT_EMPTY_ERROR)) continue;
                        throw new UncheckedIOException(e);
                    }
                    catch (ConnectionPoolTimeoutException e) {
                        responseTimeouts.incrementAndGet();
                        LOG.debug("{} for deleting object {}", (Object)e.getMessage(), (Object)obj.getPath());
                        continue;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
            try {
                this.delete(path);
            }
            catch (MantaClientHttpResponseException e) {
                if (e.getServerCode().equals((Object)MantaErrorCode.RESOURCE_NOT_FOUND_ERROR)) break;
                if (e.getServerCode().equals((Object)MantaErrorCode.DIRECTORY_NOT_EMPTY_ERROR)) continue;
                MantaIOException mioe = new MantaIOException("Unable to delete path", e);
                mioe.setContextValue("path", path);
                throw mioe;
            }
            catch (ConnectionPoolTimeoutException e) {
                responseTimeouts.incrementAndGet();
                LOG.debug("{} for deleting root object {}", (Object)e.getMessage(), (Object)path);
                continue;
            }
            break;
        }
        LOG.debug("Finished deleting path {}. It took {} loops to delete recursively", (Object)path, (Object)loops);
        if (responseTimeouts.get() > 0) {
            LOG.info("Request timeouts were hit [%d] times when attempting to delete recursively. You may want to adjust the Manta SDK request timeout config setting, the Manta SDK maximum connections setting, or the Java system property [java.util.concurrent.ForkJoinPool.common.parallelism].");
        }
    }

    public MantaObjectResponse get(String rawPath) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        HttpResponse response = this.httpHelper.httpGet(path);
        MantaHttpHeaders headers = new MantaHttpHeaders(response.getAllHeaders());
        return new MantaObjectResponse(path, headers);
    }

    public MantaObjectInputStream getAsInputStream(String rawPath, MantaHttpHeaders requestHeaders) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        HttpGet get = this.httpHelper.getRequestFactory().get(path);
        MantaObjectInputStream stream = this.httpHelper.httpRequestAsInputStream((HttpUriRequest)get, requestHeaders);
        this.danglingStreams.add(stream);
        return stream;
    }

    public MantaObjectInputStream getAsInputStream(String rawPath, MantaHttpHeaders requestHeaders, Long startPosition, Long endPosition) throws IOException {
        if (requestHeaders.getRange() != null) {
            throw new IllegalArgumentException("Ambiguous request, requestHeaders already has a Range");
        }
        requestHeaders.setByteRange(startPosition, endPosition);
        return this.getAsInputStream(rawPath, requestHeaders);
    }

    public MantaObjectInputStream getAsInputStream(String path) throws IOException {
        return this.getAsInputStream(path, null);
    }

    public String getAsString(String path) throws IOException {
        try (MantaObjectInputStream is = this.getAsInputStream(path);){
            String string = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            return string;
        }
    }

    public String getAsString(String path, String charsetName) throws IOException {
        try (MantaObjectInputStream is = this.getAsInputStream(path);){
            String string = IOUtils.toString((InputStream)is, (String)charsetName);
            return string;
        }
    }

    public String getAsString(String path, Charset charset) throws IOException {
        try (MantaObjectInputStream is = this.getAsInputStream(path);){
            String string = IOUtils.toString((InputStream)is, (Charset)charset);
            return string;
        }
    }

    public Path getToTempPath(String path) throws IOException {
        try (MantaObjectInputStream is = this.getAsInputStream(path);){
            Path temp = Files.createTempFile("manta-object", "tmp", new FileAttribute[0]);
            Files.copy(is, temp, StandardCopyOption.REPLACE_EXISTING);
            Path path2 = temp;
            return path2;
        }
    }

    public File getToTempFile(String path) throws IOException {
        return this.getToTempPath(path).toFile();
    }

    public MantaSeekableByteChannel getSeekableByteChannel(String rawPath, long position) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"Path must not be blank", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        return new MantaSeekableByteChannel(path, position, this.httpHelper);
    }

    public MantaSeekableByteChannel getSeekableByteChannel(String rawPath) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"Path must not be blank", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        return new MantaSeekableByteChannel(path, this.httpHelper);
    }

    public URI getAsSignedURI(String path, String method, TemporalAmount expiresIn) throws IOException {
        Validate.notNull((Object)expiresIn, (String)"expires in duration must not be null", (Object[])new Object[0]);
        Instant expires = Instant.now().plus(expiresIn);
        return this.getAsSignedURI(path, method, expires);
    }

    public URI getAsSignedURI(String path, String method, Instant expires) throws IOException {
        Validate.notNull((Object)expires, (String)"Expires setting must not be null", (Object[])new Object[0]);
        return this.getAsSignedURI(path, method, expires.getEpochSecond());
    }

    public URI getAsSignedURI(String path, String method, long expiresEpochSeconds) throws IOException {
        Validate.notBlank((CharSequence)path, (String)"Path must be not be blank", (Object[])new Object[0]);
        String fullPath = String.format("%s%s", this.config.getMantaURL(), MantaUtils.formatPath(path));
        URI request = URI.create(fullPath);
        UriSigner uriSigner = new UriSigner(this.config);
        return uriSigner.signURI(request, method, expiresEpochSeconds);
    }

    public MantaObjectResponse head(String rawPath) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"Path must not be empty nor null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        HttpResponse response = this.httpHelper.httpHead(path);
        MantaHttpHeaders headers = new MantaHttpHeaders(response.getAllHeaders());
        return new MantaObjectResponse(path, headers);
    }

    public MantaDirectoryListingIterator streamingIterator(String path) {
        return this.streamingIterator(path, 1024);
    }

    public MantaDirectoryListingIterator streamingIterator(String path, int pagingSize) {
        MantaDirectoryListingIterator itr = new MantaDirectoryListingIterator(path, this.httpHelper, pagingSize);
        this.danglingStreams.add(itr);
        return itr;
    }

    public Stream<MantaObject> listObjects(String path) throws IOException {
        MantaDirectoryListingIterator itr = this.streamingIterator(path);
        try {
            if (!itr.hasNext()) {
                itr.close();
                return Stream.empty();
            }
        }
        catch (UncheckedIOException e) {
            if (e.getCause() instanceof MantaClientHttpResponseException) {
                throw e.getCause();
            }
            throw e;
        }
        int additionalCharacteristics = 4369;
        Stream<Map<String, Object>> backingStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 4369), false);
        Stream stream = (Stream)backingStream.map(MantaObjectConversionFunction.INSTANCE).onClose(itr::close);
        this.danglingStreams.add(stream);
        return stream;
    }

    public Stream<MantaObject> find(String path) {
        return this.find(path, null);
    }

    public Stream<MantaObject> find(String path, Predicate<? super MantaObject> filter) {
        Stream.Builder<MantaObject> objectBuilder = Stream.builder();
        Stream.Builder<MantaObject> dirBuilder = Stream.builder();
        try (MantaDirectoryListingIterator itr = this.streamingIterator(path);){
            while (itr.hasNext()) {
                Object item = itr.next();
                MantaObject obj = MantaObjectConversionFunction.INSTANCE.apply((Map<String, Object>)item);
                if (filter != null && !filter.test(obj)) continue;
                objectBuilder.accept(obj);
                if (!obj.isDirectory()) continue;
                dirBuilder.accept(obj);
            }
        }
        Stream objectStream = objectBuilder.build();
        try {
            Stream dirStream = (Stream)((ForkJoinTask)this.findForkJoinPool.submit(() -> ((Stream)dirBuilder.build().parallel()).flatMap(obj -> this.find(obj.getPath(), filter)))).get();
            Stream<MantaObject> stream = Stream.concat(objectStream, dirStream);
            this.danglingStreams.add(stream);
            return stream;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Stream.empty();
        }
        catch (ExecutionException e) {
            throw new MantaException(e.getCause());
        }
    }

    public boolean isDirectoryEmpty(String path) throws IOException {
        MantaObjectResponse object = this.head(path);
        if (!object.isDirectory()) {
            MantaClientException e = new MantaClientException("The requested object was not a directory");
            e.setContextValue("path", path);
            throw e;
        }
        Long size = object.getHttpHeaders().getResultSetSize();
        if (size == null) {
            MantaClientException e = new MantaClientException("Expected result-set-size header to be non-null but it was not part of the response");
            e.setContextValue("path", path);
            throw e;
        }
        return size == 0L;
    }

    public boolean existsAndIsAccessible(String path) {
        try {
            this.head(path);
        }
        catch (MantaClientHttpResponseException e) {
            switch (e.getServerCode()) {
                case DIRECTORY_DOES_NOT_EXIST_ERROR: {
                    LOG.error("{} Directory invalid for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case ACCOUNT_DOES_NOT_EXIST_ERROR: {
                    LOG.error("{} Non-existent account for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case AUTHORIZATION_FAILED_ERROR: 
                case INVALID_CREDENTIALS_ERROR: {
                    LOG.error("{} Invalid authorization credentials for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case RESOURCE_NOT_FOUND_ERROR: 
                case MULTIPART_UPLOAD_STATE_ERROR: {
                    LOG.error("{} Unavailable Resource for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case INVALID_KEY_ID_ERROR: {
                    LOG.error("{} Invalid key-id for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case JOB_NOT_FOUND_ERROR: {
                    LOG.error("{} Non-existent Job Id for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case REQUEST_TIMEOUT_ERROR: {
                    LOG.error("{} Request time-out for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case INTERNAL_ERROR: {
                    LOG.error("{} Internal Server error for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                case SNAPLINKS_DISABLED_ERROR: {
                    LOG.error("{} Snaplinks disabled for given path: {}", (Object)e.getMessage(), (Object)path);
                    break;
                }
                default: {
                    LOG.error("{} doesn't exist for given path: {}", (Object)e.getMessage(), (Object)path);
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public MantaObjectResponse put(String path, InputStream source, MantaHttpHeaders headers) throws IOException {
        return this.put(path, source, headers, null);
    }

    public MantaObjectResponse put(String path, InputStream source, MantaMetadata metadata) throws IOException {
        return this.put(path, source, null, metadata);
    }

    public MantaObjectResponse put(String path, InputStream source, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        return this.put(path, source, -1L, headers, metadata);
    }

    public MantaObjectResponse put(String rawPath, InputStream source, long contentLength, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        Object entity;
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)source, (String)"Input stream must not be null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        ContentType contentType = ContentTypeLookup.findOrDefaultContentType(headers, ContentType.APPLICATION_OCTET_STREAM);
        int preLoadSize = this.config.getUploadBufferSize();
        if (contentLength < 0L) {
            if (source.getClass().equals(FileInputStream.class)) {
                FileInputStream fsin = (FileInputStream)source;
                entity = new InputStreamEntity((InputStream)fsin, fsin.getChannel().size(), contentType);
            } else {
                byte[] preLoad = new byte[preLoadSize];
                int read = IOUtils.read((InputStream)source, (byte[])preLoad);
                if (read < preLoadSize) {
                    entity = new ExposedByteArrayEntity(preLoad, 0, read, contentType);
                } else {
                    ByteArrayInputStream bin = new ByteArrayInputStream(preLoad);
                    SequenceInputStream sin = new SequenceInputStream(bin, source);
                    entity = new InputStreamEntity((InputStream)sin, contentType);
                }
            }
        } else if (contentLength <= (long)preLoadSize && contentLength <= Integer.MAX_VALUE) {
            byte[] preLoad = new byte[(int)contentLength];
            IOUtils.read((InputStream)source, (byte[])preLoad);
            entity = new ExposedByteArrayEntity(preLoad, contentType);
        } else {
            entity = new InputStreamEntity(source, contentLength, contentType);
        }
        return this.httpHelper.httpPut(path, headers, (HttpEntity)entity, metadata);
    }

    public MantaObjectResponse put(String path, InputStream source) throws IOException {
        return this.put(path, source, null, null);
    }

    public MantaObjectResponse put(String path, String string, MantaHttpHeaders headers) throws IOException {
        return this.put(path, string, headers, null);
    }

    public MantaObjectResponse put(String path, String string, MantaMetadata metadata) throws IOException {
        return this.put(path, string, null, metadata);
    }

    public MantaObjectOutputStream putAsOutputStream(String path) {
        return this.putAsOutputStream(path, null, null);
    }

    public MantaObjectOutputStream putAsOutputStream(String path, MantaHttpHeaders headers) {
        return this.putAsOutputStream(path, headers, null);
    }

    public MantaObjectOutputStream putAsOutputStream(String path, MantaMetadata metadata) {
        return this.putAsOutputStream(path, null, metadata);
    }

    public MantaObjectOutputStream putAsOutputStream(String rawPath, MantaHttpHeaders headers, MantaMetadata metadata) {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        ContentType contentType = this.assignContentType(headers, path);
        MantaObjectOutputStream stream = new MantaObjectOutputStream(path, this.httpHelper, headers, metadata, contentType);
        this.danglingStreams.add(stream);
        return stream;
    }

    public MantaObjectResponse put(String rawPath, String string, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"Path must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)string, (String)"String content must not be null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        ContentType contentType = ContentTypeLookup.findOrDefaultContentType(headers, ContentType.APPLICATION_OCTET_STREAM);
        if (headers != null) {
            headers.remove("Content-Type");
        }
        ExposedStringEntity entity = string == null ? null : new ExposedStringEntity(string, contentType);
        return this.httpHelper.httpPut(path, headers, (HttpEntity)entity, metadata);
    }

    public MantaObjectResponse put(String path, String string) throws IOException {
        return this.put(path, string, Charset.defaultCharset());
    }

    public MantaObjectResponse put(String path, String string, String charsetName) throws IOException {
        return this.put(path, string, Charset.forName(charsetName));
    }

    public MantaObjectResponse put(String path, String string, Charset charset) throws IOException {
        ContentType contentType = ContentType.TEXT_PLAIN.withCharset(charset);
        MantaHttpHeaders headers = new MantaHttpHeaders();
        headers.setContentType(contentType.toString());
        return this.put(path, string, headers, null);
    }

    public MantaObjectResponse put(String path, File file) throws IOException {
        return this.put(path, file, null, null);
    }

    public MantaObjectResponse put(String path, File file, MantaHttpHeaders headers) throws IOException {
        return this.put(path, file, headers, null);
    }

    public MantaObjectResponse put(String path, File file, MantaMetadata metadata) throws IOException {
        return this.put(path, file, null, metadata);
    }

    public MantaObjectResponse put(String rawPath, File file, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)file, (String)"File must not be null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        if (!file.exists()) {
            String msg = String.format("File doesn't exist: %s", file.getPath());
            throw new FileNotFoundException(msg);
        }
        if (!file.canRead()) {
            String msg = String.format("Can't access file for read: %s", file.getPath());
            throw new IOException(msg);
        }
        ContentType contentType = this.assignContentType(headers, path, file);
        FileEntity entity = new FileEntity(file, contentType);
        return this.httpHelper.httpPut(path, headers, (HttpEntity)entity, metadata);
    }

    public MantaObjectResponse put(String path, byte[] bytes) throws IOException {
        return this.put(path, bytes, null, null);
    }

    public MantaObjectResponse put(String path, byte[] bytes, MantaMetadata metadata) throws IOException {
        return this.put(path, bytes, null, metadata);
    }

    public MantaObjectResponse put(String path, byte[] bytes, MantaHttpHeaders headers) throws IOException {
        return this.put(path, bytes, headers, null);
    }

    public MantaObjectResponse put(String rawPath, byte[] bytes, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)bytes, (String)"Byte array must not be null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        ContentType contentType = this.assignContentType(headers, path);
        ExposedByteArrayEntity entity = new ExposedByteArrayEntity(bytes, contentType);
        return this.httpHelper.httpPut(path, headers, (HttpEntity)entity, metadata);
    }

    public MantaObjectResponse putMetadata(String path, MantaMetadata metadata) throws IOException {
        MantaHttpHeaders headers = new MantaHttpHeaders(metadata);
        return this.putMetadata(path, headers, metadata);
    }

    public MantaObjectResponse putMetadata(String path, MantaHttpHeaders headers) throws IOException {
        Validate.notNull((Object)headers, (String)"Headers must not be null", (Object[])new Object[0]);
        MantaMetadata metadata = new MantaMetadata(headers.metadataAsStrings());
        return this.putMetadata(path, headers, metadata);
    }

    public MantaObjectResponse putMetadata(String rawPath, MantaHttpHeaders headers, MantaMetadata metadata) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)headers, (String)"Headers must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)metadata, (String)"Metadata must not be null", (Object[])new Object[0]);
        for (String header : ILLEGAL_METADATA_HEADERS) {
            if (!headers.containsKey(header)) continue;
            String msg = String.format("Critical header [%s] can't be changed", header);
            throw new IllegalArgumentException(msg);
        }
        String path = MantaUtils.formatPath(rawPath);
        return this.httpHelper.httpPutMetadata(path, headers, metadata);
    }

    public boolean putDirectory(String path) throws IOException {
        return this.putDirectory(path, null);
    }

    public boolean putDirectory(String rawPath, MantaHttpHeaders rawHeaders) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"PUT directory path must not be empty nor null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(rawPath);
        LOG.debug("PUT    {} [directory]", (Object)path);
        HttpPut put = this.httpHelper.getRequestFactory().put(path);
        MantaHttpHeaders headers = rawHeaders == null ? new MantaHttpHeaders() : rawHeaders;
        MantaHttpRequestFactory.addHeaders((HttpMessage)put, headers.asApacheHttpHeaders());
        put.setHeader("Content-Type", MantaContentTypes.DIRECTORY_LIST.getContentType());
        CloseableHttpResponse response = this.httpHelper.executeAndCloseRequest((HttpUriRequest)put, (Integer)204, "PUT    {} response [{}] {} ", new Object[0]);
        return response.getFirstHeader("Last-Modified") == null;
    }

    public void putDirectory(String path, boolean recursive) throws IOException {
        this.putDirectory(path, recursive, null);
    }

    public void putDirectory(String rawPath, boolean recursive, MantaHttpHeaders headers) throws IOException {
        Validate.notBlank((CharSequence)rawPath, (String)"rawPath must not be blank", (Object[])new Object[0]);
        if (!recursive) {
            this.putDirectory(rawPath, headers);
            return;
        }
        Integer skipDepth = this.config.getSkipDirectoryDepth();
        if (skipDepth != null && 0 < skipDepth) {
            RecursiveDirectoryCreationStrategy.createWithSkipDepth(this, rawPath, headers, skipDepth);
        } else {
            RecursiveDirectoryCreationStrategy.createCompletely(this, rawPath, headers);
        }
    }

    public void putSnapLink(String rawLinkPath, String rawObjectPath, MantaHttpHeaders headers) throws IOException {
        Validate.notBlank((CharSequence)rawLinkPath, (String)"rawLinkPath must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rawObjectPath, (String)"rawObjectPath must not be blank", (Object[])new Object[0]);
        String linkPath = MantaUtils.formatPath(rawLinkPath);
        String objectPath = MantaUtils.formatPath(rawObjectPath);
        LOG.debug("PUT    {} -> {} [snaplink]", (Object)objectPath, (Object)linkPath);
        HttpPut put = this.httpHelper.getRequestFactory().put(linkPath);
        if (headers != null) {
            MantaHttpRequestFactory.addHeaders((HttpMessage)put, headers.asApacheHttpHeaders());
        }
        put.setHeader("Content-Type", MantaContentTypes.SNAPLINK.getContentType());
        put.setHeader("Location", objectPath);
        this.httpHelper.executeAndCloseRequest((HttpUriRequest)put, (Integer)204, "PUT    {} -> {} response [{}] {} ", objectPath, linkPath);
    }

    public void move(String source, String destination) throws IOException {
        this.move(source, destination, false);
    }

    public void move(String source, String destination, boolean recursivelyCreateDestinationDirectories) throws IOException {
        Validate.notBlank((CharSequence)source, (String)"Source path must not be empty nor null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)destination, (String)"Destination path must not be empty nor null", (Object[])new Object[0]);
        LOG.debug("Moving [{}] to [{}]", (Object)source, (Object)destination);
        MantaObjectResponse entry = this.head(source);
        if (entry.isDirectory()) {
            this.moveDirectory(source, destination, entry);
        } else {
            this.moveFile(source, destination, recursivelyCreateDestinationDirectories);
        }
    }

    private void moveFile(String source, String destination, boolean recursivelyCreateDestinationDirectories) throws IOException {
        String formattedDestination = MantaUtils.formatPath(destination);
        String destinationDir = FilenameUtils.getFullPath((String)formattedDestination);
        if (recursivelyCreateDestinationDirectories && !this.existsAndIsAccessible(destinationDir)) {
            this.putDirectory(destinationDir, true);
        }
        this.putSnapLink(destination, source, null);
        this.delete(source);
    }

    private void moveDirectory(String source, String destination, MantaObjectResponse entry) throws IOException {
        this.putDirectory(destination, true);
        MantaHttpHeaders sourceHeaders = entry.getHttpHeaders();
        Long contentsCount = sourceHeaders.getResultSetSize();
        if (contentsCount != null && contentsCount == 0L) {
            this.delete(source);
            return;
        }
        MantaObjectResponse destDir = this.head(destination);
        String destDirPath = destDir.getPath();
        String sourceDirPath = entry.getPath();
        this.listObjects(source).forEach(mantaObject -> {
            try {
                String sourcePath = mantaObject.getPath();
                String relPath = sourcePath.substring(sourceDirPath.length());
                String destFullPath = destDirPath + SEPARATOR + relPath;
                if (mantaObject.isDirectory()) {
                    this.move(mantaObject.getPath(), destFullPath);
                } else {
                    this.putSnapLink(destFullPath, sourcePath, null);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.deleteRecursive(source);
    }

    public UUID createJob(MantaJob job) throws IOException {
        Validate.notNull((Object)job, (String)"Manta job must not be null", (Object[])new Object[0]);
        String path = MantaUtils.formatPath(this.config.getMantaJobsDirectory());
        ObjectMapper mapper = MantaObjectMapper.INSTANCE;
        byte[] json = mapper.writeValueAsBytes((Object)job);
        ExposedByteArrayEntity entity = new ExposedByteArrayEntity(json, ContentType.APPLICATION_JSON);
        HttpPost post = this.httpHelper.getRequestFactory().post(path);
        post.setEntity((HttpEntity)entity);
        Function<CloseableHttpResponse, UUID> jobIdFunction = response -> {
            String location = response.getFirstHeader("Location").getValue();
            String id = MantaUtils.lastItemInPath(location);
            return UUID.fromString(id);
        };
        int retries = this.config.getRetries() == null ? 3 : this.config.getRetries();
        Throwable lastException = new IOException("Never thrown. Report me as a bug.");
        for (int count = 0; count < retries || count == 0; ++count) {
            try {
                return this.httpHelper.executeAndCloseRequest((HttpUriRequest)post, jobIdFunction, "POST   {} response [{}] {} ", path);
            }
            catch (MantaNoHttpResponseException | NoHttpResponseException e) {
                lastException = e;
                LOG.warn("Error posting createJob. Retrying.", e);
                continue;
            }
        }
        throw lastException;
    }

    public void addJobInputs(UUID jobId, Iterator<String> inputs) throws IOException {
        Validate.notNull(inputs, (String)"Inputs must not be null", (Object[])new Object[0]);
        ContentType contentType = ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8);
        StringIteratorHttpContent entity = new StringIteratorHttpContent(inputs, contentType);
        this.addJobInputs(jobId, entity);
    }

    public void addJobInputs(UUID jobId, Stream<String> inputs) throws IOException {
        Validate.notNull(inputs, (String)"Inputs must not be null", (Object[])new Object[0]);
        ContentType contentType = ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8);
        StringIteratorHttpContent entity = new StringIteratorHttpContent(inputs, contentType);
        this.addJobInputs(jobId, entity);
    }

    private void addJobInputs(UUID jobId, HttpEntity entity) throws IOException {
        Validate.notNull((Object)jobId, (String)"Manta job id must not be null", (Object[])new Object[0]);
        this.processJobInputs(jobId, entity);
    }

    protected void processJobInputs(UUID jobId, HttpEntity entity) throws IOException {
        String path = String.format("%s/%s/live/in", this.config.getMantaJobsDirectory(), jobId);
        HttpPost post = this.httpHelper.getRequestFactory().post(path);
        post.setHeader("Content-Encoding", "chunked");
        post.setEntity(entity);
        this.httpHelper.executeAndCloseRequest((HttpUriRequest)post, "POST   {} response [{}] {} ", new Object[0]);
    }

    public Stream<String> getJobInputs(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Manta job id must not be null", (Object[])new Object[0]);
        String path = String.format("%s/%s/live/in", this.config.getMantaJobsDirectory(), jobId);
        HttpGet get = this.httpHelper.getRequestFactory().get(path);
        CloseableHttpResponse response = this.httpHelper.executeRequest((HttpUriRequest)get, "GET    {} response [{}] {} ", new Object[0]);
        return this.responseAsStream((HttpResponse)response);
    }

    public boolean endJobInput(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Manta job id must not be null", (Object[])new Object[0]);
        String path = String.format("%s/%s/live/in/end", this.config.getMantaJobsDirectory(), jobId);
        HttpResponse response = this.httpHelper.httpPost(path);
        StatusLine statusLine = response.getStatusLine();
        return statusLine.getStatusCode() == 202;
    }

    public boolean cancelJob(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Manta job id must not be null", (Object[])new Object[0]);
        String path = String.format("%s/%s/live/cancel", this.config.getMantaJobsDirectory(), jobId);
        HttpResponse response = this.httpHelper.httpPost(path);
        StatusLine statusLine = response.getStatusLine();
        return statusLine.getStatusCode() == 202;
    }

    public MantaJob getJob(UUID jobId) throws IOException {
        MantaJob job;
        Validate.notNull((Object)jobId, (String)"Manta job id must not be null", (Object[])new Object[0]);
        String livePath = String.format("%s/%s/live/status", this.config.getMantaJobsDirectory(), jobId);
        CloseableHttpClient client = this.httpHelper.getConnectionContext().getHttpClient();
        HttpGet initialRequest = this.httpHelper.getRequestFactory().get(livePath);
        CloseableHttpResponse lastResponse = null;
        try (CloseableHttpResponse initialResponse = client.execute((HttpUriRequest)initialRequest);){
            HttpEntity entity;
            lastResponse = initialResponse;
            StatusLine statusLine = initialResponse.getStatusLine();
            if (statusLine.getStatusCode() == 404) {
                CloseableHttpResponse archiveResponse;
                String archivePath = String.format("%s/%s/job.json", this.config.getMantaJobsDirectory(), jobId);
                HttpGet archiveRequest = this.httpHelper.getRequestFactory().get(archivePath);
                lastResponse = archiveResponse = client.execute((HttpUriRequest)archiveRequest);
                StatusLine archiveStatusLine = archiveResponse.getStatusLine();
                if (archiveStatusLine.getStatusCode() == 404) {
                    String msg = "No record for job in Manta";
                    MantaJobException e = new MantaJobException(jobId, msg);
                    HttpHelper.annotateContextedException((ExceptionContext)e, (HttpRequest)archiveRequest, (HttpResponse)archiveResponse);
                    throw e;
                }
                if (archiveStatusLine.getStatusCode() != 200) {
                    String msg = "Unable to get job data from archive";
                    MantaIOException ioe = new MantaIOException(msg);
                    HttpHelper.annotateContextedException(ioe, (HttpRequest)archiveRequest, (HttpResponse)archiveResponse);
                    ioe.setContextValue("jobId", Objects.toString(jobId));
                    throw ioe;
                }
                entity = archiveResponse.getEntity();
            } else {
                if (statusLine.getStatusCode() != 200) {
                    String msg = "Unable to get job data from live status";
                    MantaIOException ioe = new MantaIOException(msg);
                    HttpHelper.annotateContextedException(ioe, (HttpRequest)initialRequest, (HttpResponse)initialResponse);
                    ioe.setContextValue("jobId", Objects.toString(jobId));
                    throw ioe;
                }
                entity = initialResponse.getEntity();
            }
            try (InputStream in = entity.getContent();){
                job = (MantaJob)MantaObjectMapper.INSTANCE.readValue(in, MantaJob.class);
            }
            catch (IOException e) {
                String msg = "Unable to deserialize job data";
                MantaIOException ioe = new MantaIOException(msg, e);
                HttpHelper.annotateContextedException(ioe, (HttpRequest)initialRequest, (HttpResponse)initialResponse);
                ioe.setContextValue("jobId", Objects.toString(jobId));
                throw ioe;
            }
        }
        catch (IOException e) {
            if (e instanceof MantaIOException) {
                throw e;
            }
            String msg = "Unable to get job data";
            MantaIOException ioe = new MantaIOException(msg, e);
            HttpHelper.annotateContextedException(ioe, (HttpRequest)initialRequest, (HttpResponse)lastResponse);
            ioe.setContextValue("jobId", Objects.toString(jobId));
            throw ioe;
        }
        catch (RuntimeException e) {
            if (e instanceof MantaException) {
                throw e;
            }
            String msg = "Unexpected error when getting job data";
            MantaJobException je = new MantaJobException(jobId, msg, e);
            HttpHelper.annotateContextedException((ExceptionContext)je, (HttpRequest)initialRequest, (HttpResponse)lastResponse);
            throw je;
        }
        finally {
            if (lastResponse != null) {
                try {
                    lastResponse.close();
                }
                catch (IOException e) {
                    MantaIOException mio = new MantaIOException(e);
                    HttpHelper.annotateContextedException(mio, (HttpRequest)initialRequest, (HttpResponse)lastResponse);
                    LOG.error("Unable to close HTTP response resource", (Throwable)mio);
                }
            }
        }
        Validate.notNull((Object)job, (String)"Job returned must not be null", (Object[])new Object[0]);
        return job;
    }

    public Stream<MantaJob> getAllJobs() {
        return this.getAllJobIds().map(id -> {
            Validate.notNull((Object)id, (String)"Job ids must not be null", (Object[])new Object[0]);
            try {
                return this.getJob((UUID)id);
            }
            catch (IOException e) {
                String msg = "Error processing job object stream";
                MantaJobException jobException = new MantaJobException((UUID)id, msg, e);
                jobException.setContextValue("failedJobId", Objects.toString(id));
                throw jobException;
            }
        });
    }

    public Stream<MantaJob> getAllJobs(int limit) throws IOException {
        if (limit < 0 || limit > 1024) {
            String msg = String.format("%d is invalid: must be between [1, %d]", limit, 1024);
            throw new IllegalArgumentException(msg);
        }
        return this.getAllJobs("limit", String.valueOf(limit));
    }

    public Stream<MantaJob> getJobsByState(String state) throws IOException {
        return this.getAllJobs("state", state);
    }

    public Stream<MantaJob> getJobsByName(String name) throws IOException {
        return this.getAllJobs("name", name);
    }

    public Stream<MantaJob> getAllJobs(String filterName, String filter) throws IOException {
        return this.getAllJobIds(filterName, filter).map(id -> {
            if (id == null) {
                return null;
            }
            try {
                return this.getJob((UUID)id);
            }
            catch (IOException e) {
                String msg = "Error filtering job object stream";
                MantaJobException jobException = new MantaJobException((UUID)id, msg, e);
                jobException.setContextValue("filterName", filterName);
                jobException.setContextValue("filter", filter);
                throw jobException;
            }
        });
    }

    public Stream<UUID> getAllJobIds() {
        String path = MantaUtils.formatPath(this.config.getMantaJobsDirectory());
        MantaDirectoryListingIterator itr = new MantaDirectoryListingIterator(path, this.httpHelper, 1024);
        this.danglingStreams.add(itr);
        Stream<Map<String, Object>> backingStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 272), false);
        return backingStream.map(item -> {
            String id = Objects.toString(item.get("name"));
            return UUID.fromString(id);
        });
    }

    public Stream<UUID> getAllJobIds(int limit) throws IOException {
        if (limit < 0 || limit > 1024) {
            String msg = String.format("%d is invalid: must be between [1, %d]", limit, 1024);
            throw new IllegalArgumentException(msg);
        }
        return this.getAllJobIds("limit", String.valueOf(limit));
    }

    public Stream<UUID> getJobIdsByState(String state) throws IOException {
        return this.getAllJobIds("state", state);
    }

    public Stream<UUID> getJobIdsByName(String name) throws IOException {
        return this.getAllJobIds("name", name);
    }

    private Stream<UUID> getAllJobIds(String filterName, String filter) throws IOException {
        List<NameValuePair> params;
        if (filterName != null && filter != null) {
            BasicNameValuePair pair = new BasicNameValuePair(filterName, filter);
            params = Collections.singletonList(pair);
        } else {
            params = Collections.emptyList();
        }
        String path = MantaUtils.formatPath(this.config.getMantaJobsDirectory());
        HttpGet get = this.httpHelper.getRequestFactory().get(path, params);
        CloseableHttpResponse response = this.httpHelper.executeRequest((HttpUriRequest)get, "GET    {} response [{}] {} ", new Object[0]);
        ObjectMapper mapper = MantaObjectMapper.INSTANCE;
        Stream<String> responseStream = this.responseAsStream((HttpResponse)response);
        return responseStream.map(arg_0 -> MantaClient.lambda$getAllJobIds$9(mapper, get, (HttpResponse)response, filterName, filter, arg_0));
    }

    public Stream<String> getJobOutputs(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        String path = String.format("%s/%s/live/out", this.config.getMantaJobsDirectory(), jobId);
        HttpGet get = this.httpHelper.getRequestFactory().get(path);
        CloseableHttpResponse response = this.httpHelper.executeRequest((HttpUriRequest)get, "GET    {} response [{}] {} ", new Object[0]);
        return this.responseAsStream((HttpResponse)response);
    }

    public Stream<MantaObjectInputStream> getJobOutputsAsStreams(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        return this.getJobOutputs(jobId).map(obj -> {
            try {
                return this.getAsInputStream((String)obj);
            }
            catch (IOException e) {
                String msg = "Error deserializing JSON output as InputStream";
                MantaJobException jobException = new MantaJobException(jobId, msg, e);
                jobException.setContextValue("output", obj);
                throw jobException;
            }
        });
    }

    public Stream<String> getJobOutputsAsStrings(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        return this.getJobOutputs(jobId).map(obj -> {
            try {
                return this.getAsString((String)obj);
            }
            catch (IOException e) {
                String msg = "Error deserializing JSON output as string";
                MantaJobException jobException = new MantaJobException(jobId, msg, e);
                jobException.setContextValue("output", obj);
                throw jobException;
            }
        });
    }

    public Stream<String> getJobFailures(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        String path = String.format("%s/%s/live/fail", this.config.getMantaJobsDirectory(), jobId);
        HttpGet get = this.httpHelper.getRequestFactory().get(path);
        CloseableHttpResponse response = this.httpHelper.executeRequest((HttpUriRequest)get, "GET    {} response [{}] {} ", new Object[0]);
        return this.responseAsStream((HttpResponse)response);
    }

    public Stream<MantaJobError> getJobErrors(UUID jobId) throws IOException {
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        String path = String.format("%s/%s/live/err", this.config.getMantaJobsDirectory(), jobId);
        HttpGet get = this.httpHelper.getRequestFactory().get(path);
        CloseableHttpResponse response = this.httpHelper.executeRequest((HttpUriRequest)get, "GET    {} response [{}] {} ", new Object[0]);
        ObjectMapper mapper = MantaObjectMapper.INSTANCE;
        return this.responseAsStream((HttpResponse)response).map(arg_0 -> MantaClient.lambda$getJobErrors$12(mapper, jobId, get, (HttpResponse)response, arg_0));
    }

    public MantaJobBuilder jobBuilder() {
        return new MantaJobBuilder(this);
    }

    protected Stream<String> responseAsStream(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        InputStreamReader reader = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(reader);
        Stream stream = (Stream)br.lines().onClose(() -> {
            MantaIOException mio;
            try {
                br.close();
            }
            catch (IOException e) {
                mio = new MantaIOException(e);
                HttpHelper.annotateContextedException(mio, null, response);
                LOG.error("Unable to close buffered reader", (Throwable)mio);
            }
            if (response instanceof Closeable) {
                try {
                    ((Closeable)response).close();
                }
                catch (IOException e) {
                    mio = new MantaIOException(e);
                    HttpHelper.annotateContextedException(mio, null, response);
                    LOG.error("Unable to close HTTP response resource", (Throwable)mio);
                }
            }
        });
        this.danglingStreams.add(stream);
        return stream;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (AutoCloseable closeable : this.danglingStreams) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        try {
            this.httpHelper.close();
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            if (this.agent != null) {
                this.agent.close();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            this.config.close();
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            this.findForkJoinPool.shutdownNow();
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = "At least one exception was thrown when performing close()";
            OnCloseAggregateException exception = new OnCloseAggregateException(msg);
            exceptions.forEach(exception::aggregateException);
            throw exception;
        }
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.debug("Error closing connection", (Throwable)e);
        }
    }

    public void closeWithWarning() {
        block2: {
            try {
                this.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Error closing client", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ MantaJobError lambda$getJobErrors$12(ObjectMapper mapper, UUID jobId, HttpGet get, HttpResponse response, String err) {
        try {
            return (MantaJobError)mapper.readValue(err, MantaJobError.class);
        }
        catch (IOException e) {
            String msg = "Error deserializing JSON job error output";
            MantaJobException jobException = new MantaJobException(jobId, msg, e);
            HttpHelper.annotateContextedException((ExceptionContext)jobException, (HttpRequest)get, response);
            jobException.setContextValue("errText", err);
            throw jobException;
        }
    }

    private static /* synthetic */ UUID lambda$getAllJobIds$9(ObjectMapper mapper, HttpGet get, HttpResponse response, String filterName, String filter, String s) {
        try {
            Map jobDetails = (Map)mapper.readValue(s, Map.class);
            Object value = jobDetails.get("name");
            if (value == null) {
                return null;
            }
            return UUID.fromString(value.toString());
        }
        catch (IOException | IllegalArgumentException e) {
            String msg = "Error deserializing for job id stream";
            MantaJobException jobException = new MantaJobException(msg, e);
            HttpHelper.annotateContextedException((ExceptionContext)jobException, (HttpRequest)get, response);
            jobException.setContextValue("filterName", filterName);
            jobException.setContextValue("filter", filter);
            jobException.setContextValue("failedContent", s);
            throw jobException;
        }
    }

    static {
        LOG.debug("Preferred Security Provider: {}", (Object)ExternalSecurityProviderLoader.getPreferredProvider());
    }
}

