/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;

public class LocalQuotaFeature
implements Quota {
    private final LocalSession session;

    public LocalQuotaFeature(LocalSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        Path home = new DefaultHomeFinderService(this.session.getHost()).find();
        try {
            FileStore store = Files.getFileStore(this.session.toPath(home));
            return new Quota.Space(Long.valueOf(store.getTotalSpace() - store.getUnallocatedSpace()), Long.valueOf(store.getUnallocatedSpace()));
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Failure to read attributes of {0}", e, home);
        }
    }
}

