/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;

public class DropboxFindFeature
implements Find {
    private final DropboxSession session;

    public DropboxFindFeature(DropboxSession session) {
        this.session = session;
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            return new DropboxAttributesFinderFeature(this.session).find(file) != PathAttributes.EMPTY;
        }
        catch (NotfoundException e) {
            return false;
        }
    }
}

