/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoFilename;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CryptoDeleteV7Feature
implements Delete {
    private static final Logger log = Logger.getLogger(CryptoDeleteV7Feature.class);
    private final Session<?> session;
    private final Delete proxy;
    private final CryptoVault vault;
    private final CryptoFilename filenameProvider;

    public CryptoDeleteV7Feature(Session<?> session, Delete proxy, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy;
        this.vault = vault;
        this.filenameProvider = vault.getFilenameProvider();
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<Path> encrypted = new ArrayList<Path>();
        for (Path f : files.keySet()) {
            Path metadataFile;
            if (f.equals((Object)this.vault.getHome())) continue;
            Path encrypt = this.vault.encrypt(this.session, f);
            encrypted.add(encrypt);
            Path metadata = this.vault.encrypt(this.session, f, true);
            if (f.isDirectory()) {
                metadataFile = new Path(metadata, CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add metadata file %s", metadataFile));
                }
                encrypted.add(metadataFile);
                encrypted.add(metadata);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add metadata folder %s", metadata));
                }
                this.vault.getDirectoryProvider().delete(f);
            }
            if (!this.filenameProvider.isDeflated(metadata.getName())) continue;
            this.filenameProvider.invalidate(this.filenameProvider.inflate(this.session, metadata.getName()));
            metadataFile = this.filenameProvider.resolve(metadata.getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Add metadata file %s", metadata));
            }
            encrypted.add(metadataFile);
        }
        if (!encrypted.isEmpty()) {
            this.proxy.delete(encrypted, prompt, callback);
        }
        for (Path f : files.keySet()) {
            if (!f.equals((Object)this.vault.getHome())) continue;
            log.warn((Object)String.format("Recursively delete vault %s", f));
            ArrayList<Path> metadata = new ArrayList<Path>();
            if (!this.proxy.isRecursive()) {
                Path dataRoot;
                Find find = (Find)this.session._getFeature(Find.class);
                if (find.find(dataRoot = new Path(f, "d", f.getType()))) {
                    for (Path d : ((ListService)this.session._getFeature(ListService.class)).list(dataRoot, (ListProgressListener)new DisabledListProgressListener()).toList()) {
                        metadata.addAll(((ListService)this.session._getFeature(ListService.class)).list(d, (ListProgressListener)new DisabledListProgressListener()).toList());
                        metadata.add(d);
                    }
                    metadata.add(dataRoot);
                }
                metadata.add(this.vault.getMasterkey());
            }
            metadata.add(f);
            this.proxy.delete(metadata, prompt, callback);
        }
    }

    public boolean isSupported(Path file) {
        return this.proxy.isSupported(file);
    }

    public boolean isRecursive() {
        return this.proxy.isRecursive();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoDeleteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

