/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.io.UnrecoverableIOException;
import org.jets3t.service.utils.ServiceUtils;

public class RestUtils {
    private static final Log log = LogFactory.getLog(RestUtils.class);
    public static final List<String> HTTP_HEADER_METADATA_NAMES = Arrays.asList("content-type", "content-md5", "content-length", "content-language", "expires", "cache-control", "content-disposition", "content-encoding");

    public static String encodeUrlString(String path) {
        StringBuilder result = new StringBuilder();
        try {
            block7: for (int i = 0; i < path.length(); ++i) {
                char ch = path.charAt(i);
                switch (ch) {
                    case ' ': {
                        result.append("%20");
                        continue block7;
                    }
                    case '*': {
                        result.append("%2A");
                        continue block7;
                    }
                    case '~': {
                        result.append("~");
                        continue block7;
                    }
                    default: {
                        result.append(URLEncoder.encode(Character.toString(ch), Constants.DEFAULT_ENCODING));
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result.toString();
    }

    public static String encodeUrlPath(String path, String delimiter) {
        StringBuilder result = new StringBuilder();
        StringTokenizer t = new StringTokenizer(path, delimiter);
        if (!t.hasMoreTokens()) {
            return path;
        }
        if (path.startsWith(delimiter)) {
            result.append(delimiter);
        }
        while (t.hasMoreTokens()) {
            result.append(RestUtils.encodeUrlString(t.nextToken()));
            if (!t.hasMoreTokens()) continue;
            result.append(delimiter);
        }
        if (path.endsWith(delimiter)) {
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String makeServiceCanonicalString(String method, String resource, Map<String, Object> headersMap, String expires, String headerPrefix, List<String> serviceResourceParameterNames) {
        String[] value;
        String key;
        StringBuilder canonicalStringBuf = new StringBuilder();
        canonicalStringBuf.append(method).append("\n");
        TreeMap<String, Object> interestingHeaders = new TreeMap<String, Object>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
                String lk;
                key = entry.getKey();
                value = entry.getValue();
                if (key == null || !(lk = key.toString().toLowerCase(Locale.ENGLISH)).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(headerPrefix)) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date") || interestingHeaders.containsKey("x-goog-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (Map.Entry<String, Object> entry : interestingHeaders.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith(headerPrefix)) {
                canonicalStringBuf.append(key).append(':').append(value);
            } else {
                canonicalStringBuf.append(value);
            }
            canonicalStringBuf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            canonicalStringBuf.append(resource);
        } else {
            canonicalStringBuf.append(resource.substring(0, queryIndex));
        }
        if (queryIndex >= 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            String query = resource.substring(queryIndex + 1);
            for (String paramPair : query.split("&")) {
                String[] paramNameValue = paramPair.split("=");
                try {
                    String name = URLDecoder.decode(paramNameValue[0], "UTF-8");
                    String value2 = null;
                    if (paramNameValue.length > 1) {
                        value2 = URLDecoder.decode(paramNameValue[1], "UTF-8");
                    }
                    if (!serviceResourceParameterNames.contains(name)) continue;
                    treeMap.put(name, value2);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            if (treeMap.size() > 0) {
                canonicalStringBuf.append("?");
            }
            boolean addedParam = false;
            for (Map.Entry entry : treeMap.entrySet()) {
                if (addedParam) {
                    canonicalStringBuf.append("&");
                }
                canonicalStringBuf.append((String)entry.getKey());
                if (entry.getValue() != null) {
                    canonicalStringBuf.append("=").append((String)entry.getValue());
                }
                addedParam = true;
            }
        }
        return canonicalStringBuf.toString();
    }

    public static HttpClientBuilder initHttpClientBuilder(JetS3tRequestAuthorizer requestAuthorizer, Jets3tProperties jets3tProperties, String userAgentDescription, CredentialsProvider credentialsProvider) {
        PoolingHttpClientConnectionManager connectionManager = null;
        BrowserCompatHostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
        try {
            SSLContext sslContext = SSLContextBuilder.create().build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslsf).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to initialise SSL connection context, falling back to default connection without SSL customisations", (Throwable)ex);
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        int maxConnections = jets3tProperties.getIntProperty("httpclient.max-connections", 20);
        int maxConnectionsPerHost = jets3tProperties.getIntProperty("httpclient.max-connections-per-host", maxConnections);
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnectionsPerHost);
        if (jets3tProperties.getBoolProperty("httpclient.stale-checking-enabled", true)) {
            connectionManager.setValidateAfterInactivity(jets3tProperties.getIntProperty("httpclient.connection-validate-after-inactivity", 60000));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(jets3tProperties.getIntProperty("httpclient.request-timeout-ms", 60000)).setConnectTimeout(jets3tProperties.getIntProperty("httpclient.connection-timeout-ms", 60000)).setSocketTimeout(jets3tProperties.getIntProperty("httpclient.socket-timeout-ms", 60000)).setExpectContinueEnabled(jets3tProperties.getBoolProperty("http.protocol.expect-continue", true)).build();
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setRcvBufSize(jets3tProperties.getIntProperty("httpclient.socket-receive-buffer", 0)).build();
        String userAgent = jets3tProperties.getStringProperty("httpclient.useragent", null);
        if (userAgent == null) {
            userAgent = ServiceUtils.getUserAgentDescription(userAgentDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting user agent string: " + userAgent));
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).setUserAgent(userAgent);
        if (credentialsProvider != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using credentials provider class: " + credentialsProvider.getClass().getName()));
            }
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        JetS3tRetryHandler retryHandler = null;
        if (requestAuthorizer != null) {
            int retryMax = jets3tProperties.getIntProperty("httpclient.retry-max", 5);
            retryHandler = new JetS3tRetryHandler(retryMax, requestAuthorizer);
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)retryHandler);
        }
        return httpClientBuilder;
    }

    public static void initHttpProxy(HttpClientBuilder httpClientBuilder, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClientBuilder, jets3tProperties, true, null, -1, null, null, null);
    }

    public static void initHttpProxy(HttpClientBuilder httpClientBuilder, Jets3tProperties jets3tProperties, String endpoint) {
        RestUtils.initHttpProxy(httpClientBuilder, jets3tProperties, true, null, -1, null, null, null, endpoint);
    }

    public static void initHttpProxy(HttpClientBuilder httpClientBuilder, String proxyHostAddress, int proxyPort, Jets3tProperties jets3tProperties) {
        RestUtils.initHttpProxy(httpClientBuilder, jets3tProperties, false, proxyHostAddress, proxyPort, null, null, null);
    }

    public static void initHttpProxy(HttpClientBuilder httpClientBuilder, Jets3tProperties jets3tProperties, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        RestUtils.initHttpProxy(httpClientBuilder, jets3tProperties, false, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
    }

    public static void initHttpProxy(HttpClientBuilder httpClientBuilder, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain) {
        String s3Endpoint = jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        RestUtils.initHttpProxy(httpClientBuilder, jets3tProperties, proxyAutodetect, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, s3Endpoint);
    }

    public static void initHttpProxy(HttpClientBuilder httpClientBuilder, Jets3tProperties jets3tProperties, boolean proxyAutodetect, String proxyHostAddress, int proxyPort, String proxyUser, String proxyPassword, String proxyDomain, String endpoint) {
        block9: {
            if (proxyHostAddress != null && proxyPort != -1) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using Proxy: " + proxyHostAddress + ":" + proxyPort));
                }
                HttpHost proxy = new HttpHost(proxyHostAddress, proxyPort);
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                if (proxyUser != null && !proxyUser.trim().equals("")) {
                    AuthScope authScope = new AuthScope(proxyHostAddress, proxyPort);
                    Object credentials = null;
                    credentials = proxyDomain != null ? new NTCredentials(proxyUser, proxyPassword, proxyHostAddress, proxyDomain) : new UsernamePasswordCredentials(proxyUser, proxyPassword);
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
            } else if (proxyAutodetect) {
                HttpHost proxyHost = null;
                try {
                    proxyHost = PluginProxyUtil.detectProxy(new URL("http://" + endpoint));
                    if (proxyHost != null) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Using Proxy: " + proxyHost.getHostName() + ":" + proxyHost.getPort()));
                        }
                        HttpHost proxy = new HttpHost(proxyHost.getHostName(), proxyHost.getPort());
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Unable to detect proxy configuration", t);
                }
            }
        }
    }

    public static long calculateTimeAdjustmentOffset(HttpResponse response) throws ParseException {
        Header[] dateHeaders = response.getHeaders("Date");
        if (dateHeaders.length > 0) {
            String dateHeader = dateHeaders[0].getValue();
            Date awsTime = ServiceUtils.parseRfc822Date(dateHeader);
            Date localTime = new Date();
            long timeOffset = awsTime.getTime() - localTime.getTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculated time offset value of " + timeOffset + " milliseconds between the local machine and the response: " + response));
            }
            return timeOffset;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("Unable to calculate value of time offset between the local machine and the response: " + response));
        }
        return 0L;
    }

    public static Map<String, String> convertHeadersToMap(Header[] headers) {
        HashMap<String, String> s3Headers = new HashMap<String, String>();
        for (Header header : headers) {
            s3Headers.put(header.getName(), header.getValue());
        }
        return s3Headers;
    }

    public static String httpGetUrlAsString(String uri) throws ClientProtocolException, IOException {
        HttpGet getMethod = new HttpGet(uri);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpEntity entity = client.execute((HttpUriRequest)getMethod).getEntity();
        String contentEncoding = "UTF-8";
        if (entity.getContentEncoding() != null && entity.getContentEncoding().getValue() != null) {
            contentEncoding = entity.getContentEncoding().getValue();
        }
        String dataString = ServiceUtils.readInputStreamToString(entity.getContent(), contentEncoding);
        EntityUtils.consume((HttpEntity)entity);
        return dataString;
    }

    public static void closeHttpResponse(HttpResponse response) throws IOException {
        try {
            CloseableHttpResponse closeableResponse = (CloseableHttpResponse)response;
            closeableResponse.close();
            return;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to close HttpResponse, will consume instead", (Throwable)ex);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (IOException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    log.warn((Object)"Unable to consume and close HttpResponse's entity", (Throwable)ex3);
                }
            }
            return;
        }
    }

    public static class JetS3tRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private final JetS3tRequestAuthorizer requestAuthorizer;

        public JetS3tRetryHandler(int pRetryMaxCount, JetS3tRequestAuthorizer requestAuthorizer) {
            super(pRetryMaxCount, false);
            this.requestAuthorizer = requestAuthorizer;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            block10: {
                if (super.retryRequest(exception, executionCount, context)) {
                    if (exception instanceof UnrecoverableIOException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Deliberate interruption, will not retry");
                        }
                        return false;
                    }
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    HttpRequest request = clientContext.getRequest();
                    if (!(request instanceof HttpRequestBase)) {
                        return false;
                    }
                    HttpRequestBase method = (HttpRequestBase)request;
                    try {
                        clientContext.getConnection().close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrying " + method.getMethod() + " request with path '" + method.getURI() + "' - attempt " + executionCount + " of " + this.getRetryCount()));
                    }
                    try {
                        if (this.requestAuthorizer != null) {
                            this.requestAuthorizer.authorizeHttpRequest((HttpUriRequest)method, context, null);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn((Object)"Unable to generate updated authorization string for retried request", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }
}

